
#include "nir.h"
#include "nir_builder.h"
#include "nir_search.h"
#include "nir_search_helpers.h"

/* What follows is NIR algebraic transform code for the following 2320
 * transforms:
 *    ('imul', 'a', '#b(is_pos_power_of_two)') => ('ishl', 'a', ('find_lsb', 'b'))
 *    ('imul', 'a@8', 128) => ('ishl', 'a', 7)
 *    ('imul', 'a@16', 32768) => ('ishl', 'a', 15)
 *    ('imul', 'a@32', 2147483648) => ('ishl', 'a', 31)
 *    ('imul', 'a@64', 9223372036854775808) => ('ishl', 'a', 63)
 *    ('imul', 'a', '#b(is_neg_power_of_two)') => ('ineg', ('ishl', 'a', ('find_lsb', ('iabs', 'b'))))
 *    ('ishl', 'a', '#b') => ('imul', 'a', ('ishl', 1, 'b'))
 *    ('imul@64', 'a', '#b(is_bitcount2)') => ('iadd', ('ishl', 'a', ('ufind_msb', 'b')), ('ishl', 'a', ('find_lsb', 'b')))
 *    ('unpack_64_2x32_split_x', ('imul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b')
 *    ('unpack_64_2x32_split_x', ('umul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b')
 *    ('imul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('imul_high', 'a', 'b'))
 *    ('umul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('umul_high', 'a', 'b'))
 *    ('udiv', 'a', 1) => a
 *    ('idiv', 'a', 1) => a
 *    ('umod', 'a', 1) => 0
 *    ('imod', 'a', 1) => 0
 *    ('imod', 'a', -1) => 0
 *    ('irem', 'a', 1) => 0
 *    ('irem', 'a', -1) => 0
 *    ('udiv', 'a', '#b(is_pos_power_of_two)') => ('ushr', 'a', ('find_lsb', 'b'))
 *    ('idiv', 'a', '#b(is_pos_power_of_two)') => ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', 'b')))
 *    ('idiv', 'a', '#b(is_neg_power_of_two)') => ('ineg', ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', ('iabs', 'b')))))
 *    ('umod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1))
 *    ('imod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1))
 *    ('imod', 'a', '#b(is_neg_power_of_two)') => ('bcsel', ('ieq', ('ior', 'a', 'b'), 'b'), 0, ('ior', 'a', 'b'))
 *    ('irem', 'a', '#b(is_pos_power_of_two)') => ('isub', 'a', ('iand', ('bcsel', ('ilt', 'a', 0), ('iadd', 'a', ('isub', 'b', 1)), 'a'), ('ineg', 'b')))
 *    ('irem', 'a', '#b(is_neg_power_of_two)') => ('irem', 'a', ('iabs', 'b'))
 *    ('~fmul', ('fsign', 'a'), ('ffloor', ('fadd', ('fabs', 'a'), 0.5))) => ('ftrunc', ('fadd', 'a', ('fmul', ('fsign', 'a'), 0.5)))
 *    ('~fneg', ('fneg', 'a')) => a
 *    ('ineg', ('ineg', 'a')) => a
 *    ('fabs', ('fneg', 'a')) => ('fabs', 'a')
 *    ('fabs', ('u2f', 'a')) => ('u2f', 'a')
 *    ('iabs', ('iabs', 'a')) => ('iabs', 'a')
 *    ('iabs', ('ineg', 'a')) => ('iabs', 'a')
 *    ('~fadd', 'a', 0.0) => a
 *    ('fadd(is_only_used_as_float)', 'a@16', 0.0) => a
 *    ('fadd(is_only_used_as_float)', 'a@32', 0.0) => a
 *    ('iadd', 'a', 0) => a
 *    ('iadd_sat', 'a', 0) => a
 *    ('isub_sat', 'a', 0) => a
 *    ('uadd_sat', 'a', 0) => a
 *    ('usub_sat', 'a', 0) => a
 *    ('usadd_4x8_vc4', 'a', 0) => a
 *    ('usadd_4x8_vc4', 'a', -1) => -1
 *    ('~fadd', ('fmul', 'a', 'b'), ('fmul', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c'))
 *    ('~fadd', ('fmulz', 'a', 'b'), ('fmulz', 'a', 'c')) => ('fmulz', 'a', ('fadd', 'b', 'c'))
 *    ('~ffma', 'a', 'b', ('ffma(is_used_once)', 'a', 'c', 'd')) => ('ffma', 'a', ('fadd', 'b', 'c'), 'd')
 *    ('~ffma', 'a', 'b', ('fmul(is_used_once)', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c'))
 *    ('~fadd', ('fmul(is_used_once)', 'a', 'b'), ('ffma(is_used_once)', 'a', 'c', 'd')) => ('ffma', 'a', ('fadd', 'b', 'c'), 'd')
 *    ('~ffma', 'a', ('fmul(is_used_once)', 'b', 'c'), ('fmul(is_used_once)', 'b', 'd')) => ('fmul', 'b', ('ffma', 'a', 'c', 'd'))
 *    ('~ffmaz', 'a', 'b', ('ffmaz(is_used_once)', 'a', 'c', 'd')) => ('ffmaz', 'a', ('fadd', 'b', 'c'), 'd')
 *    ('~ffmaz', 'a', 'b', ('fmulz(is_used_once)', 'a', 'c')) => ('fmulz', 'a', ('fadd', 'b', 'c'))
 *    ('~fadd', ('fmulz(is_used_once)', 'a', 'b'), ('ffmaz(is_used_once)', 'a', 'c', 'd')) => ('ffmaz', 'a', ('fadd', 'b', 'c'), 'd')
 *    ('~ffmaz', 'a', ('fmulz(is_used_once)', 'b', 'c'), ('fmulz(is_used_once)', 'b', 'd')) => ('fmulz', 'b', ('ffmaz', 'a', 'c', 'd'))
 *    ('iadd', ('imul', 'a', 'b'), ('imul', 'a', 'c')) => ('imul', 'a', ('iadd', 'b', 'c'))
 *    ('iadd', ('ishl', 'b', 'a'), ('ishl', 'c', 'a')) => ('ishl', ('iadd', 'b', 'c'), 'a')
 *    ('iand', ('ior', 'a', 'b'), ('ior', 'a', 'c')) => ('ior', 'a', ('iand', 'b', 'c'))
 *    ('ior', ('iand', 'a', 'b'), ('iand', 'a', 'c')) => ('iand', 'a', ('ior', 'b', 'c'))
 *    ('ieq', ('iand', 'a', '#b(is_pos_power_of_two)'), 'b') => ('ine', ('iand', 'a', 'b'), 0)
 *    ('ine', ('iand', 'a', '#b(is_pos_power_of_two)'), 'b') => ('ieq', ('iand', 'a', 'b'), 0)
 *    ('ieq', ('ushr(is_used_once)', 'a', '#b'), 0) => ('ult', 'a', ('ishl', 1, 'b'))
 *    ('ine', ('ushr(is_used_once)', 'a', '#b'), 0) => ('uge', 'a', ('ishl', 1, 'b'))
 *    ('~fadd', ('fneg', 'a'), 'a') => 0.0
 *    ('iadd', ('ineg', 'a'), 'a') => 0
 *    ('iadd', ('ineg', 'a'), ('iadd', 'a', 'b')) => b
 *    ('iadd', 'a', ('iadd', ('ineg', 'a'), 'b')) => b
 *    ('~fadd', ('fneg', 'a'), ('fadd', 'a', 'b')) => b
 *    ('~fadd', 'a', ('fadd', ('fneg', 'a'), 'b')) => b
 *    ('fadd', ('fsat', 'a'), ('fsat', ('fneg', 'a'))) => ('fsat', ('fabs', 'a'))
 *    ('~fmul', 'a', 0.0) => 0.0
 *    ('fmul', 'a@16', 0.0) => 0.0
 *    ('fmul', 'a@32', 0.0) => 0.0
 *    ('fmulz', 'a', 0.0) => 0.0
 *    ('fmulz', 'a', 'b(is_finite_not_zero)') => ('fmul', 'a', 'b')
 *    ('fmulz', 'a(is_finite)', 'b(is_finite)') => ('fmul', 'a', 'b')
 *    ('fmulz', 'a', 'a') => ('fmul', 'a', 'a')
 *    ('ffmaz', 'a', 'b(is_finite_not_zero)', 'c') => ('ffma', 'a', 'b', 'c')
 *    ('ffmaz', 'a(is_finite)', 'b(is_finite)', 'c') => ('ffma', 'a', 'b', 'c')
 *    ('ffmaz', 'a', 'a', 'b') => ('ffma', 'a', 'a', 'b')
 *    ('imul', 'a', 0) => 0
 *    ('umul_unorm_4x8_vc4', 'a', 0) => 0
 *    ('umul_unorm_4x8_vc4', 'a', -1) => a
 *    ('~fmul', 'a', 1.0) => a
 *    ('~fmulz', 'a', 1.0) => a
 *    ('fmul(is_only_used_as_float)', 'a', 1.0) => a
 *    ('imul', 'a', 1) => a
 *    ('fmul', 'a', -1.0) => ('fneg', 'a')
 *    ('imul', 'a', -1) => ('ineg', 'a')
 *    ('fmul', ('fsign', 'a'), ('fmul', 'a', 'a')) => ('fmul', ('fabs', 'a'), 'a')
 *    ('fmul', ('fmul', ('fsign', 'a'), 'a'), 'a') => ('fmul', ('fabs', 'a'), 'a')
 *    ('~ffma', 0.0, 'a', 'b') => b
 *    ('ffma@16(is_only_used_as_float)', 0.0, 'a', 'b') => b
 *    ('ffma@32(is_only_used_as_float)', 0.0, 'a', 'b') => b
 *    ('ffmaz', 0.0, 'a', 'b') => ('fadd', 0.0, 'b')
 *    ('~ffma', 'a', 'b', 0.0) => ('fmul', 'a', 'b')
 *    ('ffma@16', 'a', 'b', 0.0) => ('fmul', 'a', 'b')
 *    ('ffma@32', 'a', 'b', 0.0) => ('fmul', 'a', 'b')
 *    ('ffmaz', 'a', 'b', 0.0) => ('fmulz', 'a', 'b')
 *    ('ffma', 1.0, 'a', 'b') => ('fadd', 'a', 'b')
 *    ('ffmaz', 1.0, 'a', 'b') => ('fadd', 'a', 'b')
 *    ('ffma', -1.0, 'a', 'b') => ('fadd', ('fneg', 'a'), 'b')
 *    ('ffmaz', -1.0, 'a', 'b') => ('fadd', ('fneg', 'a'), 'b')
 *    ('~ffma', '#a', '#b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~ffmaz', '#a', '#b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c')
 *    ('~flrp', 'a', 'b', 0.0) => a
 *    ('~flrp', 'a', 'b', 1.0) => b
 *    ('~flrp', 'a', 'a', 'b') => a
 *    ('~flrp', 0.0, 'a', 'b') => ('fmul', 'a', 'b')
 *    ('~flrp', 'a', ('fadd(is_used_once)', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('sdot_4x8_iadd', 'a', 0, 'b') => b
 *    ('udot_4x8_uadd', 'a', 0, 'b') => b
 *    ('sdot_4x8_iadd_sat', 'a', 0, 'b') => b
 *    ('udot_4x8_uadd_sat', 'a', 0, 'b') => b
 *    ('sdot_2x16_iadd', 'a', 0, 'b') => b
 *    ('udot_2x16_uadd', 'a', 0, 'b') => b
 *    ('sdot_2x16_iadd_sat', 'a', 0, 'b') => b
 *    ('udot_2x16_uadd_sat', 'a', 0, 'b') => b
 *    ('sudot_4x8_iadd', 'a', 0, 'b') => b
 *    ('sudot_4x8_iadd', 0, 'a', 'b') => b
 *    ('sudot_4x8_iadd_sat', 'a', 0, 'b') => b
 *    ('sudot_4x8_iadd_sat', 0, 'a', 'b') => b
 *    ('iadd', ('sdot_4x8_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sdot_4x8_iadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('udot_4x8_uadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('udot_4x8_uadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('sudot_4x8_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sudot_4x8_iadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('sdot_2x16_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sdot_2x16_iadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('udot_2x16_uadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('udot_2x16_uadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('sdot_4x8_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sdot_4x8_iadd', 'a', 'b', 'c')
 *    ('iadd', ('udot_4x8_uadd', 'a(is_not_const)', 'b', 0), 'c') => ('udot_4x8_uadd', 'a', 'b', 'c')
 *    ('iadd', ('sudot_4x8_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sudot_4x8_iadd', 'a', 'b', 'c')
 *    ('iadd', ('sudot_4x8_iadd', 'a', 'b(is_not_const)', 0), 'c') => ('sudot_4x8_iadd', 'a', 'b', 'c')
 *    ('iadd', ('sdot_2x16_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sdot_2x16_iadd', 'a', 'b', 'c')
 *    ('iadd', ('udot_2x16_uadd', 'a(is_not_const)', 'b', 0), 'c') => ('udot_2x16_uadd', 'a', 'b', 'c')
 *    ('sdot_4x8_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sdot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('udot_4x8_uadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('udot_4x8_uadd', 'a', 'b', 0), 'c')
 *    ('sudot_4x8_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sudot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('sdot_2x16_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sdot_2x16_iadd', 'a', 'b', 0), 'c')
 *    ('udot_2x16_uadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('udot_2x16_uadd', 'a', 'b', 0), 'c')
 *    ('sdot_4x8_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sdot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('udot_4x8_uadd_sat', '#a', '#b', 'c(is_not_const)') => ('uadd_sat', ('udot_4x8_uadd', 'a', 'b', 0), 'c')
 *    ('sudot_4x8_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sudot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('sdot_2x16_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sdot_2x16_iadd', 'a', 'b', 0), 'c')
 *    ('udot_2x16_uadd_sat', '#a', '#b', 'c(is_not_const)') => ('uadd_sat', ('udot_2x16_uadd', 'a', 'b', 0), 'c')
 *    ('fmul@32', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', 'a', 'b')
 *    ('fmul@32', 'a', ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', 'a', 'b')
 *    ('ffma@32', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', 'a', 'b', 'c')
 *    ('ffma@32', 'a', ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', 'a', 'b', 'c')
 *    ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmul@32', 'a', 'b'))) => ('fexp2', ('fmulz', 'a', 'b'))
 *    ('sdot_4x8_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_i8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_i8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_i8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_i8', 'b', 3)))), 'c')
 *    ('udot_4x8_uadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_u8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_u8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_u8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_u8', 'a', 3), ('extract_u8', 'b', 3)))), 'c')
 *    ('sudot_4x8_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_u8', 'b', 3)))), 'c')
 *    ('sdot_2x16_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('imul', ('extract_i16', 'a', 0), ('extract_i16', 'b', 0)), ('imul', ('extract_i16', 'a', 1), ('extract_i16', 'b', 1))), 'c')
 *    ('udot_2x16_uadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('imul', ('extract_u16', 'a', 0), ('extract_u16', 'b', 0)), ('imul', ('extract_u16', 'a', 1), ('extract_u16', 'b', 1))), 'c')
 *    ('udot_4x8_uadd_sat', 'a', 'b', '#c(is_ult_0xfffc07fc)') => ('udot_4x8_uadd', 'a', 'b', 'c')
 *    ('udot_4x8_uadd_sat', 'a', 'b', 'c') => ('uadd_sat', ('udot_4x8_uadd', 'a', 'b', 0), 'c')
 *    ('sdot_4x8_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('sdot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('sudot_4x8_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('sudot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('udot_2x16_uadd_sat', 'a', 'b', 'c') => ('uadd_sat', ('iadd', ('imul', ('extract_u16', 'a', 0), ('extract_u16', 'b', 0)), ('imul', ('extract_u16', 'a', 1), ('extract_u16', 'b', 1))), 'c')
 *    ('sdot_2x16_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('iadd', ('imul', ('extract_i16', 'a', 0), ('extract_i16', 'b', 0)), ('imul', ('extract_i16', 'a', 1), ('extract_i16', 'b', 1))), 'c')
 *    ('~flrp@16', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a')
 *    ('~flrp@16', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('~flrp@16', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp@16', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a')
 *    ('~fadd@16', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@16', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c'))
 *    ('~fadd@16', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@16', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~fadd@16', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@16', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@16', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@16', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@16', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b'))
 *    ('~fadd@16', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a')
 *    ('~flrp@32', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a')
 *    ('~flrp@32', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('~flrp@32', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp@32', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a')
 *    ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@32', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c'))
 *    ('~fadd@32', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~fadd@32', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@32', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@32', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@32', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@32', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b'))
 *    ('~fadd@32', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a')
 *    ('~flrp@64', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a')
 *    ('~flrp@64', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('~flrp@64', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp@64', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a')
 *    ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@64', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c'))
 *    ('~fadd@64', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~fadd@64', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@64', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@64', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@64', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@64', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b'))
 *    ('~fadd@64', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a')
 *    ('~flrp', ('fmul(is_used_once)', 'a', 'b'), ('fmul(is_used_once)', 'a', 'c'), 'd') => ('fmul', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp', 'a', 0.0, 'c') => ('fadd', ('fmul', ('fneg', 'a'), 'c'), 'a')
 *    ('ftrunc@16', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a')))
 *    ('ftrunc@32', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a')))
 *    ('ftrunc@64', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a')))
 *    ('ffloor@16', 'a') => ('fsub', 'a', ('ffract', 'a'))
 *    ('ffloor@32', 'a') => ('fsub', 'a', ('ffract', 'a'))
 *    ('ffloor@64', 'a') => ('fsub', 'a', ('ffract', 'a'))
 *    ('fadd@16', 'a', ('fadd@16', 'b', ('fneg', ('ffract', 'a')))) => ('fadd@16', 'b', ('ffloor', 'a'))
 *    ('fadd@32', 'a', ('fadd@32', 'b', ('fneg', ('ffract', 'a')))) => ('fadd@32', 'b', ('ffloor', 'a'))
 *    ('fadd@64', 'a', ('fadd@64', 'b', ('fneg', ('ffract', 'a')))) => ('fadd@64', 'b', ('ffloor', 'a'))
 *    ('fadd@16', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a')
 *    ('fadd@32', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a')
 *    ('fadd@64', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a')
 *    ('ffract@16', 'a') => ('fsub', 'a', ('ffloor', 'a'))
 *    ('ffract@32', 'a') => ('fsub', 'a', ('ffloor', 'a'))
 *    ('ffract@64', 'a') => ('fsub', 'a', ('ffloor', 'a'))
 *    ('fceil', 'a') => ('fneg', ('ffloor', ('fneg', 'a')))
 *    ('ffma@16', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('ffma@32', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('ffma@64', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('ffmaz', 'a', 'b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c')
 *    ('~ffma@16', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~ffma@32', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~ffma@64', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~ffmaz', 'a', 'b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c')
 *    ('~fmul', ('fadd', ('iand', ('ineg', ('b2i', 'a@bool')), ('fmul', 'b', 'c')), '#d'), '#e') => ('bcsel', 'a', ('fmul', ('fadd', ('fmul', 'b', 'c'), 'd'), 'e'), ('fmul', 'd', 'e'))
 *    ('fdph', 'a', 'b') => ('fdot4', ('vec4', 'a.x', 'a.y', 'a.z', 1.0), 'b')
 *    ('fdot4', 'a', 0.0) => 0.0
 *    ('fdot3', 'a', 0.0) => 0.0
 *    ('fdot2', 'a', 0.0) => 0.0
 *    ('fdot4', ('vec4', 'a', 'b', 'c', 1.0), 'd') => ('fdph', ('vec3', 'a', 'b', 'c'), 'd')
 *    ('fdot4', ('vec4', 'a', 0.0, 0.0, 0.0), 'b') => ('fmul', 'a', 'b')
 *    ('fdot4', ('vec4', 'a', 'b', 0.0, 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c')
 *    ('fdot4', ('vec4', 'a', 'b', 'c', 0.0), 'd') => ('fdot3', ('vec3', 'a', 'b', 'c'), 'd')
 *    ('fdot3', ('vec3', 'a', 0.0, 0.0), 'b') => ('fmul', 'a', 'b')
 *    ('fdot3', ('vec3', 'a', 'b', 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c')
 *    ('fdot2', ('vec2', 'a', 0.0), 'b') => ('fmul', 'a', 'b')
 *    ('fdot2', 'a', 1.0) => ('fadd', 'a.x', 'a.y')
 *    ('fdot2', 'a', 'b') => ('fsum2', ('fmul', 'a', 'b'))
 *    ('fdot3', 'a', 'b') => ('fsum3', ('fmul', 'a', 'b'))
 *    ('fdot4', 'a', 'b') => ('fsum4', ('fmul', 'a', 'b'))
 *    ('fsum2', 'a') => ('fadd', 'a.x', 'a.y')
 *    ('~fadd', ('fneg(is_used_once)', ('fsat(is_used_once)', 'a(is_not_fmul)')), 1.0) => ('fsat', ('fadd', 1.0, ('fneg', 'a')))
 *    ('ishl', ('iadd', ('imul', 'a', '#b'), '#c'), '#d') => ('iadd', ('imul', 'a', ('ishl', 'b', 'd')), ('ishl', 'c', 'd'))
 *    ('ishl', ('imul', 'a', '#b'), '#c') => ('imul', 'a', ('ishl', 'b', 'c'))
 *    ('ishl@8', ('ishl@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 8), ('ishl@8', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@8', ('ushr@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 8), ('ushr@8', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@8', ('ishr@8', 'a', '#b'), '#c') => ('ishr@8', 'a', ('imin', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 7))
 *    ('ishl@16', ('ishl@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 16), ('ishl@16', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@16', ('ushr@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 16), ('ushr@16', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@16', ('ishr@16', 'a', '#b'), '#c') => ('ishr@16', 'a', ('imin', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 15))
 *    ('ishl@32', ('ishl@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 32), ('ishl@32', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@32', ('ushr@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 32), ('ushr@32', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@32', ('ishr@32', 'a', '#b'), '#c') => ('ishr@32', 'a', ('imin', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 31))
 *    ('ishl@64', ('ishl@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 64), ('ishl@64', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@64', ('ushr@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 64), ('ushr@64', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@64', ('ishr@64', 'a', '#b'), '#c') => ('ishr@64', 'a', ('imin', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 63))
 *    ('ishl', ('ushr', 'a@8', '#b'), 'b') => ('iand', 'a', ('ishl', 255, 'b'))
 *    ('ishl', ('ishr', 'a@8', '#b'), 'b') => ('iand', 'a', ('ishl', 255, 'b'))
 *    ('ushr', ('ishl', 'a@8', '#b'), 'b') => ('iand', 'a', ('ushr', 255, 'b'))
 *    ('ishl', ('ushr', 'a@16', '#b'), 'b') => ('iand', 'a', ('ishl', 65535, 'b'))
 *    ('ishl', ('ishr', 'a@16', '#b'), 'b') => ('iand', 'a', ('ishl', 65535, 'b'))
 *    ('ushr', ('ishl', 'a@16', '#b'), 'b') => ('iand', 'a', ('ushr', 65535, 'b'))
 *    ('ishl', ('ushr', 'a@32', '#b'), 'b') => ('iand', 'a', ('ishl', 4294967295, 'b'))
 *    ('ishl', ('ishr', 'a@32', '#b'), 'b') => ('iand', 'a', ('ishl', 4294967295, 'b'))
 *    ('ushr', ('ishl', 'a@32', '#b'), 'b') => ('iand', 'a', ('ushr', 4294967295, 'b'))
 *    ('ishl', ('ushr', 'a@64', '#b'), 'b') => ('iand', 'a', ('ishl', 18446744073709551615, 'b'))
 *    ('ishl', ('ishr', 'a@64', '#b'), 'b') => ('iand', 'a', ('ishl', 18446744073709551615, 'b'))
 *    ('ushr', ('ishl', 'a@64', '#b'), 'b') => ('iand', 'a', ('ushr', 18446744073709551615, 'b'))
 *    ('iand', ('ishl', 'a@32', '#b(is_first_5_bits_uge_2)'), -4) => ('ishl', 'a', 'b')
 *    ('iand', ('imul', 'a', '#b(is_unsigned_multiple_of_4)'), -4) => ('imul', 'a', 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_2)'), 4294967294) => ('iadd', ('iand', 'a', 4294967294), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_4)'), 4294967292) => ('iadd', ('iand', 'a', 4294967292), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_8)'), 4294967288) => ('iadd', ('iand', 'a', 4294967288), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_16)'), 4294967280) => ('iadd', ('iand', 'a', 4294967280), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_32)'), 4294967264) => ('iadd', ('iand', 'a', 4294967264), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_64)'), 4294967232) => ('iadd', ('iand', 'a', 4294967232), 'b')
 *    ('ishl@32', ('iand', 'a@32', 2147483647), 1) => ('ishl', 'a', 1)
 *    ('iand', ('ishl', 'a@32', 1), 4294967294) => ('ishl', 'a', 1)
 *    ('iand', ('ushr', 'a@32', 1), 2147483647) => ('ushr', 'a', 1)
 *    ('ishl@32', ('iand', 'a@32', 1073741823), 2) => ('ishl', 'a', 2)
 *    ('iand', ('ishl', 'a@32', 2), 4294967292) => ('ishl', 'a', 2)
 *    ('iand', ('ushr', 'a@32', 2), 1073741823) => ('ushr', 'a', 2)
 *    ('ishl@32', ('iand', 'a@32', 65535), 16) => ('ishl', 'a', 16)
 *    ('iand', ('ishl', 'a@32', 16), 4294901760) => ('ishl', 'a', 16)
 *    ('iand', ('ushr', 'a@32', 16), 65535) => ('ushr', 'a', 16)
 *    ('ishl@32', ('iand', 'a@32', 255), 24) => ('ishl', 'a', 24)
 *    ('iand', ('ishl', 'a@32', 24), 4278190080) => ('ishl', 'a', 24)
 *    ('iand', ('ushr', 'a@32', 24), 255) => ('ushr', 'a', 24)
 *    ('ishl', ('iadd', 'a', '#b'), '#c') => ('iadd', ('ishl', 'a', 'c'), ('ishl', 'b', 'c'))
 *    ('imul', ('iadd(is_used_once)', 'a', '#b'), '#c') => ('iadd', ('imul', 'a', 'c'), ('imul', 'b', 'c'))
 *    ('imul', ('iadd(is_used_once)', ('iadd(is_used_once)', 'a', '#b'), 'c'), '#d') => ('iadd', ('imul', ('iadd', 'a', 'c'), 'd'), ('imul', 'b', 'd'))
 *    ('ishl', ('iadd(is_used_once)', ('iadd(is_used_once)', 'a', '#b'), 'c'), '#d') => ('iadd', ('ishl', ('iadd', 'a', 'c'), 'd'), ('ishl', 'b', 'd'))
 *    ('inot', ('flt(is_used_once)', 'a(is_a_number)', 'b(is_a_number)')) => ('fge', 'a', 'b')
 *    ('inot', ('fge(is_used_once)', 'a(is_a_number)', 'b(is_a_number)')) => ('flt', 'a', 'b')
 *    ('inot', ('feq(is_used_once)', 'a', 'b')) => ('fneu', 'a', 'b')
 *    ('inot', ('fneu(is_used_once)', 'a', 'b')) => ('feq', 'a', 'b')
 *    ('inot', ('ilt(is_used_once)', 'a', 'b')) => ('ige', 'a', 'b')
 *    ('inot', ('ult(is_used_once)', 'a', 'b')) => ('uge', 'a', 'b')
 *    ('inot', ('ige(is_used_once)', 'a', 'b')) => ('ilt', 'a', 'b')
 *    ('inot', ('uge(is_used_once)', 'a', 'b')) => ('ult', 'a', 'b')
 *    ('inot', ('ieq(is_used_once)', 'a', 'b')) => ('ine', 'a', 'b')
 *    ('inot', ('ine(is_used_once)', 'a', 'b')) => ('ieq', 'a', 'b')
 *    ('iand', ('feq', 'a', 'b'), ('fneu', 'a', 'b')) => False
 *    ('iand', ('flt', 'a', 'b'), ('flt', 'b', 'a')) => False
 *    ('iand', ('ieq', 'a', 'b'), ('ine', 'a', 'b')) => False
 *    ('iand', ('ilt', 'a', 'b'), ('ilt', 'b', 'a')) => False
 *    ('iand', ('ult', 'a', 'b'), ('ult', 'b', 'a')) => False
 *    ('flt', ('fneg', 'a'), ('fneg', 'b')) => ('flt', 'b', 'a')
 *    ('fge', ('fneg', 'a'), ('fneg', 'b')) => ('fge', 'b', 'a')
 *    ('feq', ('fneg', 'a'), ('fneg', 'b')) => ('feq', 'b', 'a')
 *    ('fneu', ('fneg', 'a'), ('fneg', 'b')) => ('fneu', 'b', 'a')
 *    ('flt', ('fneg', 'a'), -1.0) => ('flt', 1.0, 'a')
 *    ('flt', -1.0, ('fneg', 'a')) => ('flt', 'a', 1.0)
 *    ('fge', ('fneg', 'a'), -1.0) => ('fge', 1.0, 'a')
 *    ('fge', -1.0, ('fneg', 'a')) => ('fge', 'a', 1.0)
 *    ('fneu', ('fneg', 'a'), -1.0) => ('fneu', 1.0, 'a')
 *    ('feq', -1.0, ('fneg', 'a')) => ('feq', 'a', 1.0)
 *    ('ieq', ('ineg', 'a'), 0) => ('ieq', 'a', 0)
 *    ('ine', ('ineg', 'a'), 0) => ('ine', 'a', 0)
 *    ('ieq', ('iabs', 'a'), 0) => ('ieq', 'a', 0)
 *    ('ine', ('iabs', 'a'), 0) => ('ine', 'a', 0)
 *    ('flt', '#b(is_gt_0_and_lt_1)', ('fsat(is_used_once)', 'a')) => ('flt', 'b', 'a')
 *    ('fge', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fge', 'a', 'b')
 *    ('feq', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('feq', 'a', 'b')
 *    ('fneu', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fneu', 'a', 'b')
 *    ('fge', ('fsat(is_used_once)', 'a'), 1.0) => ('fge', 'a', 1.0)
 *    ('flt', 0.0, ('fsat(is_used_once)', 'a')) => ('flt', 0.0, 'a')
 *    ('fge', 0.0, ('b2f', 'a@1')) => ('inot', 'a')
 *    ('fge', ('fneg', ('b2f', 'a@1')), 0.0) => ('inot', 'a')
 *    ('fneu', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b')
 *    ('fneu', ('bcsel', 'a', 1.0, ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b')
 *    ('fneu', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('ior', 'a', 'b')
 *    ('fneu', ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('iand', 'a', 'b')
 *    ('fneu', ('bcsel', 'a', ('b2f', 'b@1'), 0.0), 0.0) => ('iand', 'a', 'b')
 *    ('fneu', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ixor', 'a', 'b')
 *    ('fneu', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ixor', 'a', 'b')
 *    ('fneu', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ixor', 'a', 'b')
 *    ('feq', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b'))
 *    ('feq', ('bcsel', 'a', 1.0, ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b'))
 *    ('feq', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b'))
 *    ('feq', ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('iand', 'a', 'b'))
 *    ('feq', ('bcsel', 'a', ('b2f', 'b@1'), 0.0), 0.0) => ('inot', ('iand', 'a', 'b'))
 *    ('feq', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ieq', 'a', 'b')
 *    ('feq', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ieq', 'a', 'b')
 *    ('feq', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ieq', 'a', 'b')
 *    ('flt', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('ior', 'a', 'b')
 *    ('flt', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('ior', 'a', 'b')
 *    ('fge', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('inot', ('ior', 'a', 'b'))
 *    ('fge', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b'))
 *    ('flt', 'a', ('fneg', 'a')) => ('flt', 'a', 0.0)
 *    ('fge', 'a', ('fneg', 'a')) => ('fge', 'a', 0.0)
 *    ('flt', ('fmin', 'c', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')))), 0.0) => ('ior', ('flt', 'c', 0.0), ('ior', 'a', 'b'))
 *    ('~flt', ('fadd', 'a', 'b'), 'a') => ('flt', 'b', 0.0)
 *    ('~fge', ('fadd', 'a', 'b'), 'a') => ('fge', 'b', 0.0)
 *    ('~feq', ('fadd', 'a', 'b'), 'a') => ('feq', 'b', 0.0)
 *    ('~fneu', ('fadd', 'a', 'b'), 'a') => ('fneu', 'b', 0.0)
 *    ('~flt', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('flt', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~flt', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('flt', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('~fge', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fge', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~fge', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fge', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('~feq', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('feq', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~feq', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('feq', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('~fneu', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fneu', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~fneu', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fneu', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('ieq', ('iadd', 'a', 'b'), 'a') => ('ieq', 'b', 0)
 *    ('ine', ('iadd', 'a', 'b'), 'a') => ('ine', 'b', 0)
 *    ('feq', ('b2f', 'a@1'), 0.0) => ('inot', 'a')
 *    ('fneu', ('b2f', 'a@1'), 0.0) => a
 *    ('ieq', ('b2i', 'a@1'), 0) => ('inot', 'a')
 *    ('ine', ('b2i', 'a@1'), 0) => a
 *    ('ieq', 'a@1', False) => ('inot', 'a')
 *    ('ieq', 'a@1', True) => a
 *    ('ine', 'a@1', False) => a
 *    ('ine', 'a@1', True) => ('inot', 'a')
 *    ('fneu', ('u2f', 'a'), 0.0) => ('ine', 'a', 0)
 *    ('feq', ('u2f', 'a'), 0.0) => ('ieq', 'a', 0)
 *    ('fge', ('u2f', 'a'), 0.0) => True
 *    ('fge', 0.0, ('u2f', 'a')) => ('uge', 0, 'a')
 *    ('flt', ('u2f', 'a'), 0.0) => False
 *    ('flt', 0.0, ('u2f', 'a')) => ('ult', 0, 'a')
 *    ('fneu', ('i2f', 'a'), 0.0) => ('ine', 'a', 0)
 *    ('feq', ('i2f', 'a'), 0.0) => ('ieq', 'a', 0)
 *    ('fge', ('i2f', 'a'), 0.0) => ('ige', 'a', 0)
 *    ('fge', 0.0, ('i2f', 'a')) => ('ige', 0, 'a')
 *    ('flt', ('i2f', 'a'), 0.0) => ('ilt', 'a', 0)
 *    ('flt', 0.0, ('i2f', 'a')) => ('ilt', 0, 'a')
 *    ('~flt', 0.0, ('fabs', 'a')) => ('fneu', 'a', 0.0)
 *    ('~flt', ('fneg', ('fabs', 'a')), 0.0) => ('fneu', 'a', 0.0)
 *    ('fge', 0.0, ('fabs', 'a')) => ('feq', 'a', 0.0)
 *    ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0)
 *    ('iand', ('fge', 'a', 0.0), ('fge', 1.0, 'a')) => ('feq', 'a', ('fsat', 'a'))
 *    ('fmax', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('ior', 'a', 'b'))
 *    ('fmax', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('iand', 'a', 'b')))
 *    ('fmin', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('iand', 'a', 'b'))
 *    ('fmin', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('ior', 'a', 'b')))
 *    ('fmin', ('b2f', 'a@1'), '#b') => ('bcsel', 'a', ('fmin', 'b', 1.0), ('fmin', 'b', 0.0))
 *    ('flt', ('fadd(is_used_once)', 'a', ('fneg', 'b')), 0.0) => ('flt', 'a', 'b')
 *    ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0)
 *    ('~bcsel', ('flt', 'b', 'a'), 'b', 'a') => ('fmin', 'a', 'b')
 *    ('~bcsel', ('flt', 'a', 'b'), 'b', 'a') => ('fmax', 'a', 'b')
 *    ('~bcsel', ('fge', 'a', 'b'), 'b', 'a') => ('fmin', 'a', 'b')
 *    ('~bcsel', ('fge', 'b', 'a'), 'b', 'a') => ('fmax', 'a', 'b')
 *    ('bcsel', ('inot', 'a'), 'b', 'c') => ('bcsel', 'a', 'c', 'b')
 *    ('bcsel', 'a', ('bcsel', 'a', 'b', 'c'), 'd') => ('bcsel', 'a', 'b', 'd')
 *    ('bcsel', 'a', 'b', ('bcsel', 'a', 'c', 'd')) => ('bcsel', 'a', 'b', 'd')
 *    ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', True, 'b') => ('ior', 'a', 'b')
 *    ('bcsel', 'a', 'a', 'b') => ('ior', 'a', 'b')
 *    ('bcsel', 'a', 'b', False) => ('iand', 'a', 'b')
 *    ('bcsel', 'a', 'b', 'a') => ('iand', 'a', 'b')
 *    ('~fmin', 'a', 'a') => a
 *    ('~fmax', 'a', 'a') => a
 *    ('imin', 'a', 'a') => a
 *    ('imax', 'a', 'a') => a
 *    ('umin', 'a', 'a') => a
 *    ('umin', 'a', 0) => 0
 *    ('umin', 'a', -1) => a
 *    ('umax', 'a', 'a') => a
 *    ('umax', 'a', 0) => a
 *    ('umax', 'a', -1) => -1
 *    ('fmax', ('fmax', 'a', 'b'), 'b') => ('fmax', 'a', 'b')
 *    ('umax', ('umax', 'a', 'b'), 'b') => ('umax', 'a', 'b')
 *    ('imax', ('imax', 'a', 'b'), 'b') => ('imax', 'a', 'b')
 *    ('fmin', ('fmin', 'a', 'b'), 'b') => ('fmin', 'a', 'b')
 *    ('umin', ('umin', 'a', 'b'), 'b') => ('umin', 'a', 'b')
 *    ('imin', ('imin', 'a', 'b'), 'b') => ('imin', 'a', 'b')
 *    ('fmax', ('fmax', ('fmax', 'a', 'b'), 'c'), 'a') => ('fmax', ('fmax', 'a', 'b'), 'c')
 *    ('umax', ('umax', ('umax', 'a', 'b'), 'c'), 'a') => ('umax', ('umax', 'a', 'b'), 'c')
 *    ('imax', ('imax', ('imax', 'a', 'b'), 'c'), 'a') => ('imax', ('imax', 'a', 'b'), 'c')
 *    ('fmin', ('fmin', ('fmin', 'a', 'b'), 'c'), 'a') => ('fmin', ('fmin', 'a', 'b'), 'c')
 *    ('umin', ('umin', ('umin', 'a', 'b'), 'c'), 'a') => ('umin', ('umin', 'a', 'b'), 'c')
 *    ('imin', ('imin', ('imin', 'a', 'b'), 'c'), 'a') => ('imin', ('imin', 'a', 'b'), 'c')
 *    ('ieq', ('b2i8', 'a@1'), ('b2i8', 'b@1')) => ('ieq', 'a', 'b')
 *    ('ine', ('b2i8', 'a@1'), ('b2i8', 'b@1')) => ('ine', 'a', 'b')
 *    ('ieq', ('b2i16', 'a@1'), ('b2i16', 'b@1')) => ('ieq', 'a', 'b')
 *    ('ine', ('b2i16', 'a@1'), ('b2i16', 'b@1')) => ('ine', 'a', 'b')
 *    ('ieq', ('b2i32', 'a@1'), ('b2i32', 'b@1')) => ('ieq', 'a', 'b')
 *    ('ine', ('b2i32', 'a@1'), ('b2i32', 'b@1')) => ('ine', 'a', 'b')
 *    ('ieq', ('b2i64', 'a@1'), ('b2i64', 'b@1')) => ('ieq', 'a', 'b')
 *    ('ine', ('b2i64', 'a@1'), ('b2i64', 'b@1')) => ('ine', 'a', 'b')
 *    ('feq', ('b2f16', 'a@1'), ('b2f16', 'b@1')) => ('ieq', 'a', 'b')
 *    ('fneu', ('b2f16', 'a@1'), ('b2f16', 'b@1')) => ('ine', 'a', 'b')
 *    ('feq', ('b2f32', 'a@1'), ('b2f32', 'b@1')) => ('ieq', 'a', 'b')
 *    ('fneu', ('b2f32', 'a@1'), ('b2f32', 'b@1')) => ('ine', 'a', 'b')
 *    ('feq', ('b2f64', 'a@1'), ('b2f64', 'b@1')) => ('ieq', 'a', 'b')
 *    ('fneu', ('b2f64', 'a@1'), ('b2f64', 'b@1')) => ('ine', 'a', 'b')
 *    ('iand@8', 'a', ('inot', ('ishr', 'a', 7))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@8', 128), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@8', 128), 128) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@8', 128), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@8', 128), 128) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@8', 7), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@8', 7), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@8', 7), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@8', 7), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@8', 7), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@8', 7), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@8', 7), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@8', 7), -1) => ('ige', 'a', 0)
 *    ('iand@16', 'a', ('inot', ('ishr', 'a', 15))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@16', 32768), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@16', 32768), 32768) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@16', 32768), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@16', 32768), 32768) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@16', 15), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@16', 15), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@16', 15), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@16', 15), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@16', 15), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@16', 15), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@16', 15), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@16', 15), -1) => ('ige', 'a', 0)
 *    ('iand@32', 'a', ('inot', ('ishr', 'a', 31))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@32', 2147483648), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@32', 2147483648), 2147483648) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@32', 2147483648), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@32', 2147483648), 2147483648) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@32', 31), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@32', 31), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@32', 31), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@32', 31), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@32', 31), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@32', 31), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@32', 31), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@32', 31), -1) => ('ige', 'a', 0)
 *    ('iand@64', 'a', ('inot', ('ishr', 'a', 63))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@64', 9223372036854775808), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@64', 9223372036854775808), 9223372036854775808) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@64', 9223372036854775808), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@64', 9223372036854775808), 9223372036854775808) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@64', 63), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@64', 63), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@64', 63), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@64', 63), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@64', 63), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@64', 63), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@64', 63), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@64', 63), -1) => ('ige', 'a', 0)
 *    ('fmin', 'a', ('fneg', 'a')) => ('fneg', ('fabs', 'a'))
 *    ('imin', 'a', ('ineg', 'a')) => ('ineg', ('iabs', 'a'))
 *    ('fmin', 'a', ('fneg', ('fabs', 'a'))) => ('fneg', ('fabs', 'a'))
 *    ('imin', 'a', ('ineg', ('iabs', 'a'))) => ('ineg', ('iabs', 'a'))
 *    ('~fmin', 'a', ('fabs', 'a')) => a
 *    ('imin', 'a', ('iabs', 'a')) => a
 *    ('~fmax', 'a', ('fneg', ('fabs', 'a'))) => a
 *    ('imax', 'a', ('ineg', ('iabs', 'a'))) => a
 *    ('fmax', 'a', ('fabs', 'a')) => ('fabs', 'a')
 *    ('imax', 'a', ('iabs', 'a')) => ('iabs', 'a')
 *    ('fmax', 'a', ('fneg', 'a')) => ('fabs', 'a')
 *    ('imax', 'a', ('ineg', 'a')) => ('iabs', 'a')
 *    ('~fmax', ('fabs', 'a'), 0.0) => ('fabs', 'a')
 *    ('fmin', ('fmax', 'a', 0.0), 1.0) => ('fsat', 'a')
 *    ('~fmax', ('fmin', 'a', 1.0), 0.0) => ('fsat', 'a')
 *    ('~fmin', ('fmax', 'a', -1.0), 0.0) => ('fneg', ('fsat', ('fneg', 'a')))
 *    ('~fmax', ('fmin', 'a', 0.0), -1.0) => ('fneg', ('fsat', ('fneg', 'a')))
 *    ('fsat', ('fsign', 'a')) => ('b2f', ('!flt', 0.0, 'a'))
 *    ('fsat', ('b2f', 'a')) => ('b2f', 'a')
 *    ('fsat', 'a') => ('fmin', ('fmax', 'a', 0.0), 1.0)
 *    ('fsat', ('fsat', 'a')) => ('fsat', 'a')
 *    ('fsat', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', 'b'))) => ('fsat', ('fadd', ('fneg', 'a'), ('fneg', 'b')))
 *    ('fsat', ('fneg(is_used_once)', ('fmul(is_used_once)', 'a', 'b'))) => ('fsat', ('fmul', ('fneg', 'a'), 'b'))
 *    ('fsat', ('fneg(is_used_once)', ('fmulz(is_used_once)', 'a', 'b'))) => ('fsat', ('fmulz', ('fneg', 'a'), 'b'))
 *    ('fsat', ('fabs(is_used_once)', ('fmul(is_used_once)', 'a', 'b'))) => ('fsat', ('fmul', ('fabs', 'a'), ('fabs', 'b')))
 *    ('fmin', ('fmax', ('fmin', ('fmax', 'a', 'b'), 'c'), 'b'), 'c') => ('fmin', ('fmax', 'a', 'b'), 'c')
 *    ('imin', ('imax', ('imin', ('imax', 'a', 'b'), 'c'), 'b'), 'c') => ('imin', ('imax', 'a', 'b'), 'c')
 *    ('umin', ('umax', ('umin', ('umax', 'a', 'b'), 'c'), 'b'), 'c') => ('umin', ('umax', 'a', 'b'), 'c')
 *    ('fmax', ('fsat', 'a'), '#b(is_zero_to_one)') => ('fsat', ('fmax', 'a', 'b'))
 *    ('fmax', ('fsat(is_used_once)', 'a'), ('fsat(is_used_once)', 'b')) => ('fsat', ('fmax', 'a', 'b'))
 *    ('~fmin', ('fsat', 'a'), '#b(is_zero_to_one)') => ('fsat', ('fmin', 'a', 'b'))
 *    ('fmax', ('fneg', ('fmin', 'b', 'a')), 'b') => ('fmax', ('fabs', 'b'), ('fneg', 'a'))
 *    ('fmin', ('fneg', ('fmax', 'b', 'a')), 'b') => ('fmin', ('fneg', ('fabs', 'b')), ('fneg', 'a'))
 *    ('fmax', ('fadd(is_used_once)', ('fneg', 'a(is_not_negative)'), '#b(is_zero_to_one)'), 0.0) => ('fsat', ('fadd', ('fneg', 'a'), 'b'))
 *    ('extract_u8', ('imin', ('imax', 'a', 0), 255), 0) => ('imin', ('imax', 'a', 0), 255)
 *    ('ior', ('flt(is_used_once)', 'a', 'b'), ('flt', 'a', 'c')) => ('flt', 'a', ('!fmax', 'b', 'c'))
 *    ('ior', ('flt(is_used_once)', 'a', 'c'), ('flt', 'b', 'c')) => ('flt', ('!fmin', 'a', 'b'), 'c')
 *    ('ior', ('fge(is_used_once)', 'a', 'b'), ('fge', 'a', 'c')) => ('fge', 'a', ('!fmin', 'b', 'c'))
 *    ('ior', ('fge(is_used_once)', 'a', 'c'), ('fge', 'b', 'c')) => ('fge', ('!fmax', 'a', 'b'), 'c')
 *    ('ior', ('flt', 'a', '#b'), ('flt', 'a', '#c')) => ('flt', 'a', ('!fmax', 'b', 'c'))
 *    ('ior', ('flt', '#a', 'c'), ('flt', '#b', 'c')) => ('flt', ('!fmin', 'a', 'b'), 'c')
 *    ('ior', ('fge', 'a', '#b'), ('fge', 'a', '#c')) => ('fge', 'a', ('!fmin', 'b', 'c'))
 *    ('ior', ('fge', '#a', 'c'), ('fge', '#b', 'c')) => ('fge', ('!fmax', 'a', 'b'), 'c')
 *    ('~iand', ('flt(is_used_once)', 'a', 'b'), ('flt', 'a', 'c')) => ('flt', 'a', ('fmin', 'b', 'c'))
 *    ('~iand', ('flt(is_used_once)', 'a', 'c'), ('flt', 'b', 'c')) => ('flt', ('fmax', 'a', 'b'), 'c')
 *    ('~iand', ('fge(is_used_once)', 'a', 'b'), ('fge', 'a', 'c')) => ('fge', 'a', ('fmax', 'b', 'c'))
 *    ('~iand', ('fge(is_used_once)', 'a', 'c'), ('fge', 'b', 'c')) => ('fge', ('fmin', 'a', 'b'), 'c')
 *    ('iand', ('flt', 'a', '#b(is_a_number)'), ('flt', 'a', '#c(is_a_number)')) => ('flt', 'a', ('fmin', 'b', 'c'))
 *    ('iand', ('flt', '#a(is_a_number)', 'c'), ('flt', '#b(is_a_number)', 'c')) => ('flt', ('fmax', 'a', 'b'), 'c')
 *    ('iand', ('fge', 'a', '#b(is_a_number)'), ('fge', 'a', '#c(is_a_number)')) => ('fge', 'a', ('fmax', 'b', 'c'))
 *    ('iand', ('fge', '#a(is_a_number)', 'c'), ('fge', '#b(is_a_number)', 'c')) => ('fge', ('fmin', 'a', 'b'), 'c')
 *    ('ior', ('ilt(is_used_once)', 'a', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imax', 'b', 'c'))
 *    ('ior', ('ilt(is_used_once)', 'a', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imin', 'a', 'b'), 'c')
 *    ('ior', ('ige(is_used_once)', 'a', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imin', 'b', 'c'))
 *    ('ior', ('ige(is_used_once)', 'a', 'c'), ('ige', 'b', 'c')) => ('ige', ('imax', 'a', 'b'), 'c')
 *    ('ior', ('ult(is_used_once)', 'a', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umax', 'b', 'c'))
 *    ('ior', ('ult(is_used_once)', 'a', 'c'), ('ult', 'b', 'c')) => ('ult', ('umin', 'a', 'b'), 'c')
 *    ('ior', ('uge(is_used_once)', 'a', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umin', 'b', 'c'))
 *    ('ior', ('uge(is_used_once)', 'a', 'c'), ('uge', 'b', 'c')) => ('uge', ('umax', 'a', 'b'), 'c')
 *    ('iand', ('ilt(is_used_once)', 'a', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imin', 'b', 'c'))
 *    ('iand', ('ilt(is_used_once)', 'a', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imax', 'a', 'b'), 'c')
 *    ('iand', ('ige(is_used_once)', 'a', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imax', 'b', 'c'))
 *    ('iand', ('ige(is_used_once)', 'a', 'c'), ('ige', 'b', 'c')) => ('ige', ('imin', 'a', 'b'), 'c')
 *    ('iand', ('ult(is_used_once)', 'a', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umin', 'b', 'c'))
 *    ('iand', ('ult(is_used_once)', 'a', 'c'), ('ult', 'b', 'c')) => ('ult', ('umax', 'a', 'b'), 'c')
 *    ('iand', ('uge(is_used_once)', 'a', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umax', 'b', 'c'))
 *    ('iand', ('uge(is_used_once)', 'a', 'c'), ('uge', 'b', 'c')) => ('uge', ('umin', 'a', 'b'), 'c')
 *    ('ior', ('ior(is_used_once)', ('flt(is_used_once)', 'a', 'c'), 'd'), ('flt', 'b', 'c')) => ('ior', ('flt', ('!fmin', 'a', 'b'), 'c'), 'd')
 *    ('ior', ('ior(is_used_once)', ('flt', 'a', 'c'), 'd'), ('flt(is_used_once)', 'b', 'c')) => ('ior', ('flt', ('!fmin', 'a', 'b'), 'c'), 'd')
 *    ('ior', ('ior(is_used_once)', ('flt(is_used_once)', 'a', 'b'), 'd'), ('flt', 'a', 'c')) => ('ior', ('flt', 'a', ('!fmax', 'b', 'c')), 'd')
 *    ('ior', ('ior(is_used_once)', ('flt', 'a', 'b'), 'd'), ('flt(is_used_once)', 'a', 'c')) => ('ior', ('flt', 'a', ('!fmax', 'b', 'c')), 'd')
 *    ('ior', ('flt', 'a(is_a_number)', 'b(is_a_number)'), ('flt', 'b', 'a')) => ('fneu', 'a', 'b')
 *    ('umin', ('iand', 'a', '#b(is_pos_power_of_two)'), ('iand', 'c', 'b')) => ('iand', ('iand', 'a', 'b'), ('iand', 'c', 'b'))
 *    ('ior', ('flt(is_used_once)', 0.0, 'a@16'), ('flt', 'b@16', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('flt', 0.0, 'a@16'), ('flt(is_used_once)', 'b@16', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('fge(is_used_once)', 0.0, 'a@16'), ('fge', 'b@16', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('ior', ('fge', 0.0, 'a@16'), ('fge(is_used_once)', 'b@16', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt(is_used_once)', 0.0, 'a@16'), ('flt', 'b@16', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt', 0.0, 'a@16'), ('flt(is_used_once)', 'b@16', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge(is_used_once)', 0.0, 'a@16'), ('fge', 'b@16', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge', 0.0, 'a@16'), ('fge(is_used_once)', 'b@16', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('feq(is_used_once)', 'a@16', 0.0), ('feq', 'b@16', 0.0)) => ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('ior', ('fneu(is_used_once)', 'a@16', 0.0), ('fneu', 'b@16', 0.0)) => ('fneu', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('iand', ('feq(is_used_once)', 'a@16', 0.0), ('feq', 'b@16', 0.0)) => ('feq', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('iand', ('fneu(is_used_once)', 'a@16', 0.0), ('fneu', 'b@16', 0.0)) => ('fneu', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('bcsel@16', ('feq', 'a', 0.0), 1.0, ('i2f16', ('iadd', ('b2i16', ('flt', 0.0, 'a@16')), ('ineg', ('b2i16', ('flt', 'a@16', 0.0)))))) => ('i2f16', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0)))))
 *    ('bcsel', 'a', ('b2f(is_used_once)', 'b@16'), ('b2f', 'c@16')) => ('b2f', ('bcsel', 'a', 'b', 'c'))
 *    ('~i2f16', ('f2i', 'a@16')) => ('ftrunc', 'a')
 *    ('~f2i16', ('i2f', 'a@16')) => a
 *    ('~f2i16', ('u2f', 'a@16')) => a
 *    ('~f2u16', ('i2f', 'a@16')) => a
 *    ('~f2u16', ('u2f', 'a@16')) => a
 *    ('fadd', ('b2f16', ('flt', 0.0, 'a@16')), ('fneg', ('b2f16', ('flt', 'a@16', 0.0)))) => ('fsign', 'a')
 *    ('iadd', ('b2i16', ('flt', 0, 'a@16')), ('ineg', ('b2i16', ('flt', 'a@16', 0)))) => ('f2i16', ('fsign', 'a'))
 *    ('~f2f16', ('f2f', 'a')) => ('f2f16', 'a')
 *    ('~f2f16', ('u2f', 'a')) => ('u2f16', 'a')
 *    ('~f2f16', ('i2f', 'a')) => ('i2f16', 'a')
 *    ('~f2u16', ('f2f', 'a')) => ('f2u16', 'a')
 *    ('~f2i16', ('f2f', 'a')) => ('f2i16', 'a')
 *    ('i2f16', ('f2i', ('fsign', 'a@16'))) => ('fsign', 'a')
 *    ('~f2f16', ('f2f32', 'a@16')) => a
 *    ('f2u32', ('f2f32', 'a@16')) => ('f2u32', 'a')
 *    ('f2i32', ('f2f32', 'a@16')) => ('f2i32', 'a')
 *    ('f2f16', ('u2f32', 'a')) => ('u2f16', 'a')
 *    ('f2f16', ('i2f32', 'a')) => ('i2f16', 'a')
 *    ('~f2f16', ('f2f64', 'a@16')) => a
 *    ('f2u64', ('f2f64', 'a@16')) => ('f2u64', 'a')
 *    ('f2i64', ('f2f64', 'a@16')) => ('f2i64', 'a')
 *    ('f2f16', ('u2f64', 'a')) => ('u2f16', 'a')
 *    ('f2f16', ('i2f64', 'a')) => ('i2f16', 'a')
 *    ('ior', ('flt(is_used_once)', 0.0, 'a@32'), ('flt', 'b@32', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('flt', 0.0, 'a@32'), ('flt(is_used_once)', 'b@32', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('fge(is_used_once)', 0.0, 'a@32'), ('fge', 'b@32', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('ior', ('fge', 0.0, 'a@32'), ('fge(is_used_once)', 'b@32', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt(is_used_once)', 0.0, 'a@32'), ('flt', 'b@32', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt', 0.0, 'a@32'), ('flt(is_used_once)', 'b@32', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge(is_used_once)', 0.0, 'a@32'), ('fge', 'b@32', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge', 0.0, 'a@32'), ('fge(is_used_once)', 'b@32', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('feq(is_used_once)', 'a@32', 0.0), ('feq', 'b@32', 0.0)) => ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('ior', ('fneu(is_used_once)', 'a@32', 0.0), ('fneu', 'b@32', 0.0)) => ('fneu', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('iand', ('feq(is_used_once)', 'a@32', 0.0), ('feq', 'b@32', 0.0)) => ('feq', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('iand', ('fneu(is_used_once)', 'a@32', 0.0), ('fneu', 'b@32', 0.0)) => ('fneu', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('bcsel@32', ('feq', 'a', 0.0), 1.0, ('i2f32', ('iadd', ('b2i32', ('flt', 0.0, 'a@32')), ('ineg', ('b2i32', ('flt', 'a@32', 0.0)))))) => ('i2f32', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0)))))
 *    ('bcsel', 'a', ('b2f(is_used_once)', 'b@32'), ('b2f', 'c@32')) => ('b2f', ('bcsel', 'a', 'b', 'c'))
 *    ('~i2f32', ('f2i', 'a@32')) => ('ftrunc', 'a')
 *    ('~f2i32', ('i2f', 'a@32')) => a
 *    ('~f2i32', ('u2f', 'a@32')) => a
 *    ('~f2u32', ('i2f', 'a@32')) => a
 *    ('~f2u32', ('u2f', 'a@32')) => a
 *    ('fadd', ('b2f32', ('flt', 0.0, 'a@32')), ('fneg', ('b2f32', ('flt', 'a@32', 0.0)))) => ('fsign', 'a')
 *    ('iadd', ('b2i32', ('flt', 0, 'a@32')), ('ineg', ('b2i32', ('flt', 'a@32', 0)))) => ('f2i32', ('fsign', 'a'))
 *    ('~f2f32', ('f2f', 'a')) => ('f2f32', 'a')
 *    ('~f2f32', ('u2f', 'a')) => ('u2f32', 'a')
 *    ('~f2f32', ('i2f', 'a')) => ('i2f32', 'a')
 *    ('~f2u32', ('f2f', 'a')) => ('f2u32', 'a')
 *    ('~f2i32', ('f2f', 'a')) => ('f2i32', 'a')
 *    ('i2f32', ('f2i', ('fsign', 'a@32'))) => ('fsign', 'a')
 *    ('~f2f32', ('f2f64', 'a@32')) => a
 *    ('f2u64', ('f2f64', 'a@32')) => ('f2u64', 'a')
 *    ('f2i64', ('f2f64', 'a@32')) => ('f2i64', 'a')
 *    ('f2f32', ('u2f64', 'a')) => ('u2f32', 'a')
 *    ('f2f32', ('i2f64', 'a')) => ('i2f32', 'a')
 *    ('ior', ('flt(is_used_once)', 0.0, 'a@64'), ('flt', 'b@64', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('flt', 0.0, 'a@64'), ('flt(is_used_once)', 'b@64', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('fge(is_used_once)', 0.0, 'a@64'), ('fge', 'b@64', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('ior', ('fge', 0.0, 'a@64'), ('fge(is_used_once)', 'b@64', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt(is_used_once)', 0.0, 'a@64'), ('flt', 'b@64', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt', 0.0, 'a@64'), ('flt(is_used_once)', 'b@64', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge(is_used_once)', 0.0, 'a@64'), ('fge', 'b@64', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge', 0.0, 'a@64'), ('fge(is_used_once)', 'b@64', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('feq(is_used_once)', 'a@64', 0.0), ('feq', 'b@64', 0.0)) => ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('ior', ('fneu(is_used_once)', 'a@64', 0.0), ('fneu', 'b@64', 0.0)) => ('fneu', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('iand', ('feq(is_used_once)', 'a@64', 0.0), ('feq', 'b@64', 0.0)) => ('feq', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('iand', ('fneu(is_used_once)', 'a@64', 0.0), ('fneu', 'b@64', 0.0)) => ('fneu', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('bcsel@64', ('feq', 'a', 0.0), 1.0, ('i2f64', ('iadd', ('b2i64', ('flt', 0.0, 'a@64')), ('ineg', ('b2i64', ('flt', 'a@64', 0.0)))))) => ('i2f64', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0)))))
 *    ('bcsel', 'a', ('b2f(is_used_once)', 'b@64'), ('b2f', 'c@64')) => ('b2f', ('bcsel', 'a', 'b', 'c'))
 *    ('~i2f64', ('f2i', 'a@64')) => ('ftrunc', 'a')
 *    ('~f2i64', ('i2f', 'a@64')) => a
 *    ('~f2i64', ('u2f', 'a@64')) => a
 *    ('~f2u64', ('i2f', 'a@64')) => a
 *    ('~f2u64', ('u2f', 'a@64')) => a
 *    ('fadd', ('b2f64', ('flt', 0.0, 'a@64')), ('fneg', ('b2f64', ('flt', 'a@64', 0.0)))) => ('fsign', 'a')
 *    ('iadd', ('b2i64', ('flt', 0, 'a@64')), ('ineg', ('b2i64', ('flt', 'a@64', 0)))) => ('f2i64', ('fsign', 'a'))
 *    ('~f2f64', ('f2f', 'a')) => ('f2f64', 'a')
 *    ('~f2f64', ('u2f', 'a')) => ('u2f64', 'a')
 *    ('~f2f64', ('i2f', 'a')) => ('i2f64', 'a')
 *    ('~f2u64', ('f2f', 'a')) => ('f2u64', 'a')
 *    ('~f2i64', ('f2f', 'a')) => ('f2i64', 'a')
 *    ('i2f64', ('f2i', ('fsign', 'a@64'))) => ('fsign', 'a')
 *    ('i2i1', ('i2i8', 'a@1')) => a
 *    ('u2u1', ('u2u8', 'a@1')) => a
 *    ('i2i1', ('i2i16', 'a@1')) => a
 *    ('u2u1', ('u2u16', 'a@1')) => a
 *    ('u2f16', ('u2u8', 'a@1')) => ('u2f16', 'a')
 *    ('i2f16', ('i2i8', 'a@1')) => ('i2f16', 'a')
 *    ('u2f16', ('u2u16', 'a@1')) => ('u2f16', 'a')
 *    ('i2f16', ('i2i16', 'a@1')) => ('i2f16', 'a')
 *    ('u2f16', ('u2u32', 'a@1')) => ('u2f16', 'a')
 *    ('i2f16', ('i2i32', 'a@1')) => ('i2f16', 'a')
 *    ('u2f16', ('u2u64', 'a@1')) => ('u2f16', 'a')
 *    ('i2f16', ('i2i64', 'a@1')) => ('i2f16', 'a')
 *    ('i2i1', ('i2i32', 'a@1')) => a
 *    ('u2u1', ('u2u32', 'a@1')) => a
 *    ('u2f32', ('u2u8', 'a@1')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i8', 'a@1')) => ('i2f32', 'a')
 *    ('u2f32', ('u2u16', 'a@1')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i16', 'a@1')) => ('i2f32', 'a')
 *    ('u2f32', ('u2u32', 'a@1')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i32', 'a@1')) => ('i2f32', 'a')
 *    ('u2f32', ('u2u64', 'a@1')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i64', 'a@1')) => ('i2f32', 'a')
 *    ('i2i1', ('i2i64', 'a@1')) => a
 *    ('u2u1', ('u2u64', 'a@1')) => a
 *    ('u2f64', ('u2u8', 'a@1')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i8', 'a@1')) => ('i2f64', 'a')
 *    ('u2f64', ('u2u16', 'a@1')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i16', 'a@1')) => ('i2f64', 'a')
 *    ('u2f64', ('u2u32', 'a@1')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i32', 'a@1')) => ('i2f64', 'a')
 *    ('u2f64', ('u2u64', 'a@1')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i64', 'a@1')) => ('i2f64', 'a')
 *    ('i2i8', ('i2i16', 'a@8')) => a
 *    ('u2u8', ('u2u16', 'a@8')) => a
 *    ('u2f16', ('u2u16', 'a@8')) => ('u2f16', 'a')
 *    ('i2f16', ('i2i16', 'a@8')) => ('i2f16', 'a')
 *    ('u2f16', ('u2u32', 'a@8')) => ('u2f16', 'a')
 *    ('i2f16', ('i2i32', 'a@8')) => ('i2f16', 'a')
 *    ('u2f16', ('u2u64', 'a@8')) => ('u2f16', 'a')
 *    ('i2f16', ('i2i64', 'a@8')) => ('i2f16', 'a')
 *    ('i2i8', ('i2i32', 'a@8')) => a
 *    ('u2u8', ('u2u32', 'a@8')) => a
 *    ('u2f32', ('u2u16', 'a@8')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i16', 'a@8')) => ('i2f32', 'a')
 *    ('u2f32', ('u2u32', 'a@8')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i32', 'a@8')) => ('i2f32', 'a')
 *    ('u2f32', ('u2u64', 'a@8')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i64', 'a@8')) => ('i2f32', 'a')
 *    ('i2i8', ('i2i64', 'a@8')) => a
 *    ('u2u8', ('u2u64', 'a@8')) => a
 *    ('u2f64', ('u2u16', 'a@8')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i16', 'a@8')) => ('i2f64', 'a')
 *    ('u2f64', ('u2u32', 'a@8')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i32', 'a@8')) => ('i2f64', 'a')
 *    ('u2f64', ('u2u64', 'a@8')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i64', 'a@8')) => ('i2f64', 'a')
 *    ('i2i16', ('i2i32', 'a@16')) => a
 *    ('u2u16', ('u2u32', 'a@16')) => a
 *    ('u2f32', ('u2u32', 'a@16')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i32', 'a@16')) => ('i2f32', 'a')
 *    ('u2f32', ('u2u64', 'a@16')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i64', 'a@16')) => ('i2f32', 'a')
 *    ('i2i16', ('i2i64', 'a@16')) => a
 *    ('u2u16', ('u2u64', 'a@16')) => a
 *    ('u2f64', ('u2u32', 'a@16')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i32', 'a@16')) => ('i2f64', 'a')
 *    ('u2f64', ('u2u64', 'a@16')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i64', 'a@16')) => ('i2f64', 'a')
 *    ('i2i32', ('i2i64', 'a@32')) => a
 *    ('u2u32', ('u2u64', 'a@32')) => a
 *    ('u2f64', ('u2u64', 'a@32')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i64', 'a@32')) => ('i2f64', 'a')
 *    ('f2fmp', ('u2f32', 'a@32')) => ('u2fmp', 'a')
 *    ('f2fmp', ('i2f32', 'a@32')) => ('i2fmp', 'a')
 *    ('f2u16', ('f2fmp', 'a@32')) => ('f2u16', 'a')
 *    ('f2i16', ('f2fmp', 'a@32')) => ('f2i16', 'a')
 *    ('i2imp', ('f2u32', 'a@32')) => ('f2ump', 'a')
 *    ('i2imp', ('f2i32', 'a@32')) => ('f2imp', 'a')
 *    ('u2f16', ('i2imp', 'a@32')) => ('u2f16', 'a')
 *    ('i2f16', ('i2imp', 'a@32')) => ('i2f16', 'a')
 *    ('iand', ('u2u16', ('u2u8', 'a@16')), '#b') => ('iand', 'a', ('iand', 'b', 255))
 *    ('u2u16', ('u2u8(is_used_once)', ('iand', 'a@16', '#b'))) => ('iand', 'a', ('iand', 'b', 255))
 *    ('u2u8', ('iand', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('iand', 'a', 'b'))
 *    ('u2u8', ('iand', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('iand', 'a', 'b'))
 *    ('iand', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('iand', 'a', 'c'), 'b')
 *    ('u2u8', ('ior', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('ior', 'a', 'b'))
 *    ('u2u8', ('ior', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('ior', 'a', 'b'))
 *    ('ior', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('ior', 'a', 'c'), 'b')
 *    ('u2u8', ('ixor', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('ixor', 'a', 'b'))
 *    ('u2u8', ('ixor', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('ixor', 'a', 'b'))
 *    ('ixor', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('ixor', 'a', 'c'), 'b')
 *    ('iand', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('bcsel', ('ult', 'b@8', 'a'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('ult', 'a@8', 'b'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('uge', 'a@8', 'b'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('uge', 'b@8', 'a'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('ilt', 'b@8', 'a'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ilt', 'a@8', 'b'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('bcsel', ('ige', 'a@8', 'b'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ige', 'b@8', 'a'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('ineg', ('b2i8', 'a@8')) => a
 *    ('ishl', 'a@8', ('iand', 7, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@8', ('iand', 7, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@8', ('iand', 7, 'b')) => ('ushr', 'a', 'b')
 *    ('ushr', 'a@8', ('ishl(is_used_once)', ('iand', 'b', 1), 2)) => ('ushr', 'a', ('ishl', 'b', 2))
 *    ('iand', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('bcsel', ('ult', 'b@16', 'a'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('ult', 'a@16', 'b'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('uge', 'a@16', 'b'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('uge', 'b@16', 'a'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('ilt', 'b@16', 'a'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ilt', 'a@16', 'b'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('bcsel', ('ige', 'a@16', 'b'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ige', 'b@16', 'a'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('ineg', ('b2i16', 'a@16')) => a
 *    ('ishl', 'a@16', ('iand', 15, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@16', ('iand', 15, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@16', ('iand', 15, 'b')) => ('ushr', 'a', 'b')
 *    ('ushr', 'a@16', ('ishl(is_used_once)', ('iand', 'b', 1), 3)) => ('ushr', 'a', ('ishl', 'b', 3))
 *    ('iand', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('bcsel', ('ult', 'b@32', 'a'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('ult', 'a@32', 'b'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('uge', 'a@32', 'b'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('uge', 'b@32', 'a'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('ilt', 'b@32', 'a'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ilt', 'a@32', 'b'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('bcsel', ('ige', 'a@32', 'b'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ige', 'b@32', 'a'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('ineg', ('b2i32', 'a@32')) => a
 *    ('ishl', 'a@32', ('iand', 31, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@32', ('iand', 31, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@32', ('iand', 31, 'b')) => ('ushr', 'a', 'b')
 *    ('ushr', 'a@32', ('ishl(is_used_once)', ('iand', 'b', 1), 4)) => ('ushr', 'a', ('ishl', 'b', 4))
 *    ('iand', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('bcsel', ('ult', 'b@64', 'a'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('ult', 'a@64', 'b'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('uge', 'a@64', 'b'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('uge', 'b@64', 'a'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('ilt', 'b@64', 'a'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ilt', 'a@64', 'b'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('bcsel', ('ige', 'a@64', 'b'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ige', 'b@64', 'a'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('ineg', ('b2i64', 'a@64')) => a
 *    ('ishl', 'a@64', ('iand', 63, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@64', ('iand', 63, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@64', ('iand', 63, 'b')) => ('ushr', 'a', 'b')
 *    ('ushr', 'a@64', ('ishl(is_used_once)', ('iand', 'b', 1), 5)) => ('ushr', 'a', ('ishl', 'b', 5))
 *    ('ior', ('ieq', 'a', 0), ('ieq', 'a', 1)) => ('uge', 1, 'a')
 *    ('ior', ('uge', 1, 'a'), ('ieq', 'a', 2)) => ('uge', 2, 'a')
 *    ('ior', ('uge', 2, 'a'), ('ieq', 'a', 3)) => ('uge', 3, 'a')
 *    ('ior', 'a', ('ieq', 'a', False)) => True
 *    ('ine', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ine', 'a', 'b')
 *    ('b2i', ('ine', 'a@1', 'b@1')) => ('b2i', ('ixor', 'a', 'b'))
 *    ('ishl', ('b2i32', ('ine', ('iand', 'a@32', '#b(is_pos_power_of_two)'), 0)), '#c') => ('bcsel', ('ige', ('iand', 'c', 31), ('find_lsb', 'b')), ('ishl', ('iand', 'a', 'b'), ('iadd', ('iand', 'c', 31), ('ineg', ('find_lsb', 'b')))), ('ushr', ('iand', 'a', 'b'), ('iadd', ('ineg', ('iand', 'c', 31)), ('find_lsb', 'b'))))
 *    ('b2i32', ('ine', ('iand', 'a@32', '#b(is_pos_power_of_two)'), 0)) => ('ushr', ('iand', 'a', 'b'), ('find_lsb', 'b'))
 *    ('ior', ('b2i', 'a'), ('iand', 'b', 1)) => ('iand', ('ior', ('b2i', 'a'), 'b'), 1)
 *    ('iand', ('b2i', 'a'), ('iand', 'b', 1)) => ('iand', ('b2i', 'a'), 'b')
 *    ('iand', ('inot', ('iand', ('ior', ('ieq', 'a', 0), 'b'), 'c')), ('ilt', 'a', 0)) => ('iand', ('inot', ('iand', 'b', 'c')), ('ilt', 'a', 0))
 *    ('iand', ('inot', ('iand', ('ieq', ('umin', 'a', 'b'), 0), 'c')), ('ilt', 'a', 0)) => ('iand', ('inot', ('iand', ('ieq', 'b', 0), 'c')), ('ilt', 'a', 0))
 *    ('flt', 'a', ('fmax', 'b', 'a')) => ('flt', 'a', 'b')
 *    ('flt', ('fmin', 'a', 'b'), 'a') => ('flt', 'b', 'a')
 *    ('~fge', 'a', ('fmin', 'b', 'a')) => True
 *    ('~fge', ('fmax', 'a', 'b'), 'a') => True
 *    ('flt', 'a', ('fmin', 'b', 'a')) => False
 *    ('flt', ('fmax', 'a', 'b'), 'a') => False
 *    ('~fge', 'a', ('fmax', 'b', 'a')) => ('fge', 'a', 'b')
 *    ('~fge', ('fmin', 'a', 'b'), 'a') => ('fge', 'b', 'a')
 *    ('ilt', 'a', ('imax', 'b', 'a')) => ('ilt', 'a', 'b')
 *    ('ilt', ('imin', 'a', 'b'), 'a') => ('ilt', 'b', 'a')
 *    ('ige', 'a', ('imin', 'b', 'a')) => True
 *    ('ige', ('imax', 'a', 'b'), 'a') => True
 *    ('ult', 'a', ('umax', 'b', 'a')) => ('ult', 'a', 'b')
 *    ('ult', ('umin', 'a', 'b'), 'a') => ('ult', 'b', 'a')
 *    ('uge', 'a', ('umin', 'b', 'a')) => True
 *    ('uge', ('umax', 'a', 'b'), 'a') => True
 *    ('ilt', 'a', ('imin', 'b', 'a')) => False
 *    ('ilt', ('imax', 'a', 'b'), 'a') => False
 *    ('ige', 'a', ('imax', 'b', 'a')) => ('ige', 'a', 'b')
 *    ('ige', ('imin', 'a', 'b'), 'a') => ('ige', 'b', 'a')
 *    ('ult', 'a', ('umin', 'b', 'a')) => False
 *    ('ult', ('umax', 'a', 'b'), 'a') => False
 *    ('uge', 'a', ('umax', 'b', 'a')) => ('uge', 'a', 'b')
 *    ('uge', ('umin', 'a', 'b'), 'a') => ('uge', 'b', 'a')
 *    ('ult', 'a', ('iand', 'b', 'a')) => False
 *    ('ult', ('ior', 'a', 'b'), 'a') => False
 *    ('uge', 'a', ('iand', 'b', 'a')) => True
 *    ('uge', ('ior', 'a', 'b'), 'a') => True
 *    ('ilt', '#a', ('imax', '#b', 'c')) => ('ior', ('ilt', 'a', 'b'), ('ilt', 'a', 'c'))
 *    ('ilt', ('imin', '#a', 'b'), '#c') => ('ior', ('ilt', 'a', 'c'), ('ilt', 'b', 'c'))
 *    ('ige', '#a', ('imin', '#b', 'c')) => ('ior', ('ige', 'a', 'b'), ('ige', 'a', 'c'))
 *    ('ige', ('imax', '#a', 'b'), '#c') => ('ior', ('ige', 'a', 'c'), ('ige', 'b', 'c'))
 *    ('ult', '#a', ('umax', '#b', 'c')) => ('ior', ('ult', 'a', 'b'), ('ult', 'a', 'c'))
 *    ('ult', ('umin', '#a', 'b'), '#c') => ('ior', ('ult', 'a', 'c'), ('ult', 'b', 'c'))
 *    ('uge', '#a', ('umin', '#b', 'c')) => ('ior', ('uge', 'a', 'b'), ('uge', 'a', 'c'))
 *    ('uge', ('umax', '#a', 'b'), '#c') => ('ior', ('uge', 'a', 'c'), ('uge', 'b', 'c'))
 *    ('ilt', '#a', ('imin', '#b', 'c')) => ('iand', ('ilt', 'a', 'b'), ('ilt', 'a', 'c'))
 *    ('ilt', ('imax', '#a', 'b'), '#c') => ('iand', ('ilt', 'a', 'c'), ('ilt', 'b', 'c'))
 *    ('ige', '#a', ('imax', '#b', 'c')) => ('iand', ('ige', 'a', 'b'), ('ige', 'a', 'c'))
 *    ('ige', ('imin', '#a', 'b'), '#c') => ('iand', ('ige', 'a', 'c'), ('ige', 'b', 'c'))
 *    ('ult', '#a', ('umin', '#b', 'c')) => ('iand', ('ult', 'a', 'b'), ('ult', 'a', 'c'))
 *    ('ult', ('umax', '#a', 'b'), '#c') => ('iand', ('ult', 'a', 'c'), ('ult', 'b', 'c'))
 *    ('uge', '#a', ('umax', '#b', 'c')) => ('iand', ('uge', 'a', 'b'), ('uge', 'a', 'c'))
 *    ('uge', ('umin', '#a', 'b'), '#c') => ('iand', ('uge', 'a', 'c'), ('uge', 'b', 'c'))
 *    ('bcsel', ('ilt', 'a', 0), ('ineg', ('ishr', 'a', 'b')), ('ishr', 'a', 'b')) => ('iabs', ('ishr', 'a', 'b'))
 *    ('iabs', ('ishr', ('iabs', 'a'), 'b')) => ('ishr', ('iabs', 'a'), 'b')
 *    ('fabs', ('slt', 'a', 'b')) => ('slt', 'a', 'b')
 *    ('fabs', ('sge', 'a', 'b')) => ('sge', 'a', 'b')
 *    ('fabs', ('seq', 'a', 'b')) => ('seq', 'a', 'b')
 *    ('fabs', ('sne', 'a', 'b')) => ('sne', 'a', 'b')
 *    ('slt', 'a', 'b') => ('b2f', ('flt', 'a', 'b'))
 *    ('sge', 'a', 'b') => ('b2f', ('fge', 'a', 'b'))
 *    ('seq', 'a', 'b') => ('b2f', ('feq', 'a', 'b'))
 *    ('sne', 'a', 'b') => ('b2f', ('fneu', 'a', 'b'))
 *    ('seq', ('seq', 'a', 'b'), 1.0) => ('seq', 'a', 'b')
 *    ('seq', ('sne', 'a', 'b'), 1.0) => ('sne', 'a', 'b')
 *    ('seq', ('slt', 'a', 'b'), 1.0) => ('slt', 'a', 'b')
 *    ('seq', ('sge', 'a', 'b'), 1.0) => ('sge', 'a', 'b')
 *    ('sne', ('seq', 'a', 'b'), 0.0) => ('seq', 'a', 'b')
 *    ('sne', ('sne', 'a', 'b'), 0.0) => ('sne', 'a', 'b')
 *    ('sne', ('slt', 'a', 'b'), 0.0) => ('slt', 'a', 'b')
 *    ('sne', ('sge', 'a', 'b'), 0.0) => ('sge', 'a', 'b')
 *    ('seq', ('seq', 'a', 'b'), 0.0) => ('sne', 'a', 'b')
 *    ('seq', ('sne', 'a', 'b'), 0.0) => ('seq', 'a', 'b')
 *    ('seq', ('slt', 'a', 'b'), 0.0) => ('sge', 'a', 'b')
 *    ('seq', ('sge', 'a', 'b'), 0.0) => ('slt', 'a', 'b')
 *    ('sne', ('seq', 'a', 'b'), 1.0) => ('sne', 'a', 'b')
 *    ('sne', ('sne', 'a', 'b'), 1.0) => ('seq', 'a', 'b')
 *    ('sne', ('slt', 'a', 'b'), 1.0) => ('sge', 'a', 'b')
 *    ('sne', ('sge', 'a', 'b'), 1.0) => ('slt', 'a', 'b')
 *    ('fall_equal2', 'a', 'b') => ('fmin', ('seq', 'a.x', 'b.x'), ('seq', 'a.y', 'b.y'))
 *    ('fall_equal3', 'a', 'b') => ('seq', ('fany_nequal3', 'a', 'b'), 0.0)
 *    ('fall_equal4', 'a', 'b') => ('seq', ('fany_nequal4', 'a', 'b'), 0.0)
 *    ('fall_equal8', 'a', 'b') => ('seq', ('fany_nequal8', 'a', 'b'), 0.0)
 *    ('fall_equal16', 'a', 'b') => ('seq', ('fany_nequal16', 'a', 'b'), 0.0)
 *    ('fany_nequal2', 'a', 'b') => ('fmax', ('sne', 'a.x', 'b.x'), ('sne', 'a.y', 'b.y'))
 *    ('fany_nequal3', 'a', 'b') => ('fsat', ('fdot3', ('sne', 'a', 'b'), ('sne', 'a', 'b')))
 *    ('fany_nequal4', 'a', 'b') => ('fsat', ('fdot4', ('sne', 'a', 'b'), ('sne', 'a', 'b')))
 *    ('fany_nequal8', 'a', 'b') => ('fsat', ('fdot8', ('sne', 'a', 'b'), ('sne', 'a', 'b')))
 *    ('fany_nequal16', 'a', 'b') => ('fsat', ('fdot16', ('sne', 'a', 'b'), ('sne', 'a', 'b')))
 *    ('ball_iequal2', 'a', 'b') => ('iand', ('ieq', 'a.x', 'b.x'), ('ieq', 'a.y', 'b.y'))
 *    ('ball_iequal3', 'a', 'b') => ('iand', ('ieq', 'a.x', 'b.x'), ('iand', ('ieq', 'a.y', 'b.y'), ('ieq', 'a.z', 'b.z')))
 *    ('ball_iequal4', 'a', 'b') => ('iand', ('iand', ('ieq', 'a.x', 'b.x'), ('ieq', 'a.y', 'b.y')), ('iand', ('ieq', 'a.z', 'b.z'), ('ieq', 'a.w', 'b.w')))
 *    ('ball_iequal8', 'a', 'b') => ('iand', ('iand', ('iand', ('ieq', 'a.a', 'b.a'), ('ieq', 'a.b', 'b.b')), ('iand', ('ieq', 'a.c', 'b.c'), ('ieq', 'a.d', 'b.d'))), ('iand', ('iand', ('ieq', 'a.e', 'b.e'), ('ieq', 'a.f', 'b.f')), ('iand', ('ieq', 'a.g', 'b.g'), ('ieq', 'a.h', 'b.h'))))
 *    ('ball_iequal16', 'a', 'b') => ('iand', ('iand', ('iand', ('iand', ('ieq', 'a.a', 'b.a'), ('ieq', 'a.b', 'b.b')), ('iand', ('ieq', 'a.c', 'b.c'), ('ieq', 'a.d', 'b.d'))), ('iand', ('iand', ('ieq', 'a.e', 'b.e'), ('ieq', 'a.f', 'b.f')), ('iand', ('ieq', 'a.g', 'b.g'), ('ieq', 'a.h', 'b.h')))), ('iand', ('iand', ('iand', ('ieq', 'a.i', 'b.i'), ('ieq', 'a.j', 'b.j')), ('iand', ('ieq', 'a.k', 'b.k'), ('ieq', 'a.l', 'b.l'))), ('iand', ('iand', ('ieq', 'a.m', 'b.m'), ('ieq', 'a.n', 'b.n')), ('iand', ('ieq', 'a.o', 'b.o'), ('ieq', 'a.p', 'b.p')))))
 *    ('ball_fequal2', 'a', 'b') => ('iand', ('feq', 'a.x', 'b.x'), ('feq', 'a.y', 'b.y'))
 *    ('ball_fequal3', 'a', 'b') => ('iand', ('feq', 'a.x', 'b.x'), ('iand', ('feq', 'a.y', 'b.y'), ('feq', 'a.z', 'b.z')))
 *    ('ball_fequal4', 'a', 'b') => ('iand', ('iand', ('feq', 'a.x', 'b.x'), ('feq', 'a.y', 'b.y')), ('iand', ('feq', 'a.z', 'b.z'), ('feq', 'a.w', 'b.w')))
 *    ('ball_fequal8', 'a', 'b') => ('iand', ('iand', ('iand', ('feq', 'a.a', 'b.a'), ('feq', 'a.b', 'b.b')), ('iand', ('feq', 'a.c', 'b.c'), ('feq', 'a.d', 'b.d'))), ('iand', ('iand', ('feq', 'a.e', 'b.e'), ('feq', 'a.f', 'b.f')), ('iand', ('feq', 'a.g', 'b.g'), ('feq', 'a.h', 'b.h'))))
 *    ('ball_fequal16', 'a', 'b') => ('iand', ('iand', ('iand', ('iand', ('feq', 'a.a', 'b.a'), ('feq', 'a.b', 'b.b')), ('iand', ('feq', 'a.c', 'b.c'), ('feq', 'a.d', 'b.d'))), ('iand', ('iand', ('feq', 'a.e', 'b.e'), ('feq', 'a.f', 'b.f')), ('iand', ('feq', 'a.g', 'b.g'), ('feq', 'a.h', 'b.h')))), ('iand', ('iand', ('iand', ('feq', 'a.i', 'b.i'), ('feq', 'a.j', 'b.j')), ('iand', ('feq', 'a.k', 'b.k'), ('feq', 'a.l', 'b.l'))), ('iand', ('iand', ('feq', 'a.m', 'b.m'), ('feq', 'a.n', 'b.n')), ('iand', ('feq', 'a.o', 'b.o'), ('feq', 'a.p', 'b.p')))))
 *    ('bany_inequal2', 'a', 'b') => ('ior', ('ine', 'a.x', 'b.x'), ('ine', 'a.y', 'b.y'))
 *    ('bany_inequal3', 'a', 'b') => ('ior', ('ine', 'a.x', 'b.x'), ('ior', ('ine', 'a.y', 'b.y'), ('ine', 'a.z', 'b.z')))
 *    ('bany_inequal4', 'a', 'b') => ('ior', ('ior', ('ine', 'a.x', 'b.x'), ('ine', 'a.y', 'b.y')), ('ior', ('ine', 'a.z', 'b.z'), ('ine', 'a.w', 'b.w')))
 *    ('bany_inequal8', 'a', 'b') => ('ior', ('ior', ('ior', ('ine', 'a.a', 'b.a'), ('ine', 'a.b', 'b.b')), ('ior', ('ine', 'a.c', 'b.c'), ('ine', 'a.d', 'b.d'))), ('ior', ('ior', ('ine', 'a.e', 'b.e'), ('ine', 'a.f', 'b.f')), ('ior', ('ine', 'a.g', 'b.g'), ('ine', 'a.h', 'b.h'))))
 *    ('bany_inequal16', 'a', 'b') => ('ior', ('ior', ('ior', ('ior', ('ine', 'a.a', 'b.a'), ('ine', 'a.b', 'b.b')), ('ior', ('ine', 'a.c', 'b.c'), ('ine', 'a.d', 'b.d'))), ('ior', ('ior', ('ine', 'a.e', 'b.e'), ('ine', 'a.f', 'b.f')), ('ior', ('ine', 'a.g', 'b.g'), ('ine', 'a.h', 'b.h')))), ('ior', ('ior', ('ior', ('ine', 'a.i', 'b.i'), ('ine', 'a.j', 'b.j')), ('ior', ('ine', 'a.k', 'b.k'), ('ine', 'a.l', 'b.l'))), ('ior', ('ior', ('ine', 'a.m', 'b.m'), ('ine', 'a.n', 'b.n')), ('ior', ('ine', 'a.o', 'b.o'), ('ine', 'a.p', 'b.p')))))
 *    ('bany_fnequal2', 'a', 'b') => ('ior', ('fneu', 'a.x', 'b.x'), ('fneu', 'a.y', 'b.y'))
 *    ('bany_fnequal3', 'a', 'b') => ('ior', ('fneu', 'a.x', 'b.x'), ('ior', ('fneu', 'a.y', 'b.y'), ('fneu', 'a.z', 'b.z')))
 *    ('bany_fnequal4', 'a', 'b') => ('ior', ('ior', ('fneu', 'a.x', 'b.x'), ('fneu', 'a.y', 'b.y')), ('ior', ('fneu', 'a.z', 'b.z'), ('fneu', 'a.w', 'b.w')))
 *    ('bany_fnequal8', 'a', 'b') => ('ior', ('ior', ('ior', ('fneu', 'a.a', 'b.a'), ('fneu', 'a.b', 'b.b')), ('ior', ('fneu', 'a.c', 'b.c'), ('fneu', 'a.d', 'b.d'))), ('ior', ('ior', ('fneu', 'a.e', 'b.e'), ('fneu', 'a.f', 'b.f')), ('ior', ('fneu', 'a.g', 'b.g'), ('fneu', 'a.h', 'b.h'))))
 *    ('bany_fnequal16', 'a', 'b') => ('ior', ('ior', ('ior', ('ior', ('fneu', 'a.a', 'b.a'), ('fneu', 'a.b', 'b.b')), ('ior', ('fneu', 'a.c', 'b.c'), ('fneu', 'a.d', 'b.d'))), ('ior', ('ior', ('fneu', 'a.e', 'b.e'), ('fneu', 'a.f', 'b.f')), ('ior', ('fneu', 'a.g', 'b.g'), ('fneu', 'a.h', 'b.h')))), ('ior', ('ior', ('ior', ('fneu', 'a.i', 'b.i'), ('fneu', 'a.j', 'b.j')), ('ior', ('fneu', 'a.k', 'b.k'), ('fneu', 'a.l', 'b.l'))), ('ior', ('ior', ('fneu', 'a.m', 'b.m'), ('fneu', 'a.n', 'b.n')), ('ior', ('fneu', 'a.o', 'b.o'), ('fneu', 'a.p', 'b.p')))))
 *    ('feq', ('seq', 'a', 'b'), 1.0) => ('feq', 'a', 'b')
 *    ('feq', ('sne', 'a', 'b'), 1.0) => ('fneu', 'a', 'b')
 *    ('feq', ('slt', 'a', 'b'), 1.0) => ('flt', 'a', 'b')
 *    ('feq', ('sge', 'a', 'b'), 1.0) => ('fge', 'a', 'b')
 *    ('fneu', ('seq', 'a', 'b'), 0.0) => ('feq', 'a', 'b')
 *    ('fneu', ('sne', 'a', 'b'), 0.0) => ('fneu', 'a', 'b')
 *    ('fneu', ('slt', 'a', 'b'), 0.0) => ('flt', 'a', 'b')
 *    ('fneu', ('sge', 'a', 'b'), 0.0) => ('fge', 'a', 'b')
 *    ('feq', ('seq', 'a', 'b'), 0.0) => ('fneu', 'a', 'b')
 *    ('feq', ('sne', 'a', 'b'), 0.0) => ('feq', 'a', 'b')
 *    ('feq', ('slt', 'a', 'b'), 0.0) => ('fge', 'a', 'b')
 *    ('feq', ('sge', 'a', 'b'), 0.0) => ('flt', 'a', 'b')
 *    ('fneu', ('seq', 'a', 'b'), 1.0) => ('fneu', 'a', 'b')
 *    ('fneu', ('sne', 'a', 'b'), 1.0) => ('feq', 'a', 'b')
 *    ('fneu', ('slt', 'a', 'b'), 1.0) => ('fge', 'a', 'b')
 *    ('fneu', ('sge', 'a', 'b'), 1.0) => ('flt', 'a', 'b')
 *    ('fneu', ('fneg', 'a'), 'a') => ('fneu', 'a', 0.0)
 *    ('feq', ('fneg', 'a'), 'a') => ('feq', 'a', 0.0)
 *    ('imul', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('iand', 'a', 'b'))
 *    ('iand', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('iand', 'a', 'b'))
 *    ('ior', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('ior', 'a', 'b'))
 *    ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('iand', 'a', 'b'))
 *    ('fsat', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('b2f', ('ior', 'a', 'b'))
 *    ('iand', 'a@bool16', 1.0) => ('b2f', 'a')
 *    ('iand', 'a@bool32', 1.0) => ('b2f', 'a')
 *    ('flt', ('fneg', ('b2f', 'a@1')), 0) => a
 *    ('ilt', 'a', 'a') => False
 *    ('ige', 'a', 'a') => True
 *    ('ieq', 'a', 'a') => True
 *    ('ine', 'a', 'a') => False
 *    ('ult', 'a', 'a') => False
 *    ('uge', 'a', 'a') => True
 *    ('flt', 'a', 'a') => False
 *    ('fge', 'a(is_a_number)', 'a') => True
 *    ('feq', 'a(is_a_number)', 'a') => True
 *    ('fneu', 'a(is_a_number)', 'a') => False
 *    ('iand', 'a', 'a') => a
 *    ('iand', 'a', 0) => 0
 *    ('iand', 'a', -1) => a
 *    ('iand', 'a', ('inot', 'a')) => 0
 *    ('ior', 'a', 'a') => a
 *    ('ior', 'a', 0) => a
 *    ('ior', 'a', -1) => -1
 *    ('ior', 'a', ('inot', 'a')) => -1
 *    ('ixor', 'a', 'a') => 0
 *    ('ixor', 'a', 0) => a
 *    ('ixor', 'a', ('ixor', 'a', 'b')) => b
 *    ('ixor', 'a', -1) => ('inot', 'a')
 *    ('inot', ('inot', 'a')) => a
 *    ('ior', ('iand', 'a', 'b'), 'b') => b
 *    ('ior', ('ior', 'a', 'b'), 'b') => ('ior', 'a', 'b')
 *    ('iand', ('ior', 'a', 'b'), 'b') => b
 *    ('iand', ('iand', 'a', 'b'), 'b') => ('iand', 'a', 'b')
 *    ('iand', ('iand(is_used_once)', 'a', 'b'), ('iand(is_used_once)', 'a', 'c')) => ('iand', 'a', ('iand', 'b', 'c'))
 *    ('iand@64', 'a', '#b(is_lower_half_zero)') => ('pack_64_2x32_split', 0, ('iand', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')))
 *    ('iand@64', 'a', '#b(is_upper_half_zero)') => ('pack_64_2x32_split', ('iand', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_x', 'b')), 0)
 *    ('iand@64', 'a', '#b(is_lower_half_negative_one)') => ('pack_64_2x32_split', ('unpack_64_2x32_split_x', 'a'), ('iand', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')))
 *    ('iand@64', 'a', '#b(is_upper_half_negative_one)') => ('pack_64_2x32_split', ('iand', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_x', 'b')), ('unpack_64_2x32_split_y', 'a'))
 *    ('ior@64', 'a', '#b(is_lower_half_zero)') => ('pack_64_2x32_split', ('unpack_64_2x32_split_x', 'a'), ('ior', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')))
 *    ('ior@64', 'a', '#b(is_upper_half_zero)') => ('pack_64_2x32_split', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_x', 'b')), ('unpack_64_2x32_split_y', 'a'))
 *    ('ior@64', 'a', '#b(is_lower_half_negative_one)') => ('pack_64_2x32_split', -1, ('ior', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')))
 *    ('ior@64', 'a', '#b(is_upper_half_negative_one)') => ('pack_64_2x32_split', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_x', 'b')), -1)
 *    ('ixor@64', 'a', '#b(is_lower_half_zero)') => ('pack_64_2x32_split', ('unpack_64_2x32_split_x', 'a'), ('ixor', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')))
 *    ('ixor@64', 'a', '#b(is_upper_half_zero)') => ('pack_64_2x32_split', ('ixor', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_x', 'b')), ('unpack_64_2x32_split_y', 'a'))
 *    ('iand', ('inot', 'a'), ('inot', 'b')) => ('inot', ('ior', 'a', 'b'))
 *    ('ior', ('inot', 'a'), ('inot', 'b')) => ('inot', ('iand', 'a', 'b'))
 *    ('ishl', 0, 'a') => 0
 *    ('ishl', 'a', 0) => a
 *    ('ishr', 0, 'a') => 0
 *    ('ishr', -1, 'a') => -1
 *    ('ishr', 'a', 0) => a
 *    ('ushr', 0, 'a') => 0
 *    ('ushr', 'a', 0) => a
 *    ('ior', ('ishl@16', 'a', 'b'), ('ushr@16', 'a', ('iadd', 16, ('ineg', 'b')))) => ('urol', 'a', 'b')
 *    ('ior', ('ishl@16', 'a', 'b'), ('ushr@16', 'a', ('isub', 16, 'b'))) => ('urol', 'a', 'b')
 *    ('ior', ('ishl@32', 'a', 'b'), ('ushr@32', 'a', ('iadd', 32, ('ineg', 'b')))) => ('urol', 'a', 'b')
 *    ('ior', ('ishl@32', 'a', 'b'), ('ushr@32', 'a', ('isub', 32, 'b'))) => ('urol', 'a', 'b')
 *    ('ior', ('ushr@16', 'a', 'b'), ('ishl@16', 'a', ('iadd', 16, ('ineg', 'b')))) => ('uror', 'a', 'b')
 *    ('ior', ('ushr@16', 'a', 'b'), ('ishl@16', 'a', ('isub', 16, 'b'))) => ('uror', 'a', 'b')
 *    ('ior', ('ushr@32', 'a', 'b'), ('ishl@32', 'a', ('iadd', 32, ('ineg', 'b')))) => ('uror', 'a', 'b')
 *    ('ior', ('ushr@32', 'a', 'b'), ('ishl@32', 'a', ('isub', 32, 'b'))) => ('uror', 'a', 'b')
 *    ('urol@8', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 8, 'b')))
 *    ('urol@16', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 16, 'b')))
 *    ('urol@32', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 32, 'b')))
 *    ('urol@64', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 64, 'b')))
 *    ('uror@8', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 8, 'b')))
 *    ('uror@16', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 16, 'b')))
 *    ('uror@32', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 32, 'b')))
 *    ('uror@64', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 64, 'b')))
 *    ('bfi', 4294967295, 'a', 'b') => a
 *    ('bfi', 0, 'a', 'b') => b
 *    ('bfi', ('ineg', ('b2i', 'a@1')), 'b', 'c') => ('bcsel', 'a', 'b', 'c')
 *    ('bfi', '#a(is_odd)', 'a', 'b') => ('ior', 'a', 'b')
 *    ('bfi', '#a(is_odd)', 'b', 0) => ('iand', 'a', 'b')
 *    ('u2f32', ('bfi', '#a(is_pos_power_of_two)', 'b', 0)) => ('bcsel', ('ieq', ('iand', 'b', 1), 0), ('iand', 'b', 1), ('u2f', 'a'))
 *    ('u2f', ('bfi', '#a(is_pos_power_of_two)', 'b', 0)) => ('bcsel', ('ieq', ('iand', 'b', 1), 0), 0, ('u2f', 'a'))
 *    ('~fexp2', ('flog2', 'a')) => a
 *    ('~flog2', ('fexp2', 'a')) => a
 *    ('fpow', 'a', 'b') => ('fexp2', ('fmul', ('flog2', 'a'), 'b'))
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 'b')) => ('fpow', 'a', 'b')
 *    ('~fexp2', ('fadd', ('fmul', ('flog2', 'a'), 'b'), ('fmul', ('flog2', 'c'), 'd'))) => ('~fmul', ('fpow', 'a', 'b'), ('fpow', 'c', 'd'))
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 0.5)) => ('fsqrt', 'a')
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 2.0)) => ('fmul', 'a', 'a')
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 3.0)) => ('fmul', ('fmul', 'a', 'a'), 'a')
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 4.0)) => ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a'))
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 5.0)) => ('fmul', ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a')), 'a')
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 6.0)) => ('fmul', ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a')), ('fmul', 'a', 'a'))
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 8.0)) => ('fmul', ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a')), ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a')))
 *    ('~fpow', 'a', 1.0) => a
 *    ('~fpow', 'a', 2.0) => ('fmul', 'a', 'a')
 *    ('~fpow', 'a', 3.0) => ('fmul', ('fmul', 'a', 'a'), 'a')
 *    ('~fpow', 'a', 4.0) => ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a'))
 *    ('~fpow', 2.0, 'a') => ('fexp2', 'a')
 *    ('~fpow', ('fpow', 'a', 2.2), 0.454545) => a
 *    ('~fpow', ('fabs', ('fpow', 'a', 2.2)), 0.454545) => ('fabs', 'a')
 *    ('~fsqrt', ('fexp2', 'a')) => ('fexp2', ('fmul', 0.5, 'a'))
 *    ('~frcp', ('fexp2', 'a')) => ('fexp2', ('fneg', 'a'))
 *    ('~frsq', ('fexp2', 'a')) => ('fexp2', ('fmul', -0.5, 'a'))
 *    ('~flog2', ('fsqrt', 'a')) => ('fmul', 0.5, ('flog2', 'a'))
 *    ('~flog2', ('frcp', 'a')) => ('fneg', ('flog2', 'a'))
 *    ('~flog2', ('frsq', 'a')) => ('fmul', -0.5, ('flog2', 'a'))
 *    ('~flog2', ('fpow', 'a', 'b')) => ('fmul', 'b', ('flog2', 'a'))
 *    ('~fmul', ('fexp2(is_used_once)', 'a'), ('fexp2(is_used_once)', 'b')) => ('fexp2', ('fadd', 'a', 'b'))
 *    ('bcsel', ('flt', 'a', 0.0), 0.0, ('fsqrt', 'a')) => ('fsqrt', ('fmax', 'a', 0.0))
 *    ('~fmul', ('fsqrt', 'a'), ('fsqrt', 'a')) => ('fabs', 'a')
 *    ('~fmulz', ('fsqrt', 'a'), ('fsqrt', 'a')) => ('fabs', 'a')
 *    ('~fdiv', 1.0, 'a') => ('frcp', 'a')
 *    ('fdiv', 'a', 'b') => ('fmul', 'a', ('frcp', 'b'))
 *    ('~frcp', ('frcp', 'a')) => a
 *    ('~frcp', ('fsqrt', 'a')) => ('frsq', 'a')
 *    ('fsqrt', 'a') => ('frcp', ('frsq', 'a'))
 *    ('~frcp', ('frsq', 'a')) => ('fsqrt', 'a')
 *    ('fsin', 'a') => ('ffma', ('ffma', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0), ('fabs', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0)), ('fneg', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0))), 0.225, ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0))
 *    ('fcos', 'a') => ('ffma', ('ffma', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0), ('fabs', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0)), ('fneg', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0))), 0.225, ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0))
 *    ('ieq', 'a', True) => a
 *    ('ine(is_not_used_by_if)', 'a', True) => ('inot', 'a')
 *    ('ine', 'a', False) => a
 *    ('ieq(is_not_used_by_if)', 'a', False) => ('inot', 'a')
 *    ('bcsel', 'a', True, False) => a
 *    ('bcsel', 'a', False, True) => ('inot', 'a')
 *    ('bcsel', True, 'b', 'c') => b
 *    ('bcsel', False, 'b', 'c') => c
 *    ('bcsel@16', 'a', 1.0, 0.0) => ('b2f', 'a')
 *    ('bcsel@16', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a'))
 *    ('bcsel@16', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a'))
 *    ('bcsel@16', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a')))
 *    ('bcsel@32', 'a', 1.0, 0.0) => ('b2f', 'a')
 *    ('bcsel@32', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a'))
 *    ('bcsel@32', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a'))
 *    ('bcsel@32', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a')))
 *    ('bcsel@64', 'a', 1.0, 0.0) => ('b2f', 'a')
 *    ('bcsel@64', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a'))
 *    ('bcsel@64', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a'))
 *    ('bcsel@64', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a')))
 *    ('bcsel', 'a', 'b', 'b') => b
 *    ('~fcsel', 'a', 'b', 'b') => b
 *    ('bcsel', 'a', -1, 0) => ('ineg', ('b2i', 'a@1'))
 *    ('bcsel', 'a', 0, -1) => ('ineg', ('b2i', ('inot', 'a')))
 *    ('bcsel', 'a', 1, 0) => ('b2i', 'a@1')
 *    ('bcsel', 'a', 0, 1) => ('b2i', ('inot', 'a'))
 *    ('iand', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('iand', 'a', 'b')))
 *    ('ior', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ior', 'a', 'b')))
 *    ('ieq', ('ineg', ('b2i', 'a@1')), -1) => a
 *    ('ine', ('ineg', ('b2i', 'a@1')), -1) => ('inot', 'a')
 *    ('ige', ('ineg', ('b2i', 'a@1')), 0) => ('inot', 'a')
 *    ('ilt', ('ineg', ('b2i', 'a@1')), 0) => a
 *    ('ult', 0, ('ineg', ('b2i', 'a@1'))) => a
 *    ('iand', ('ineg', ('b2i', 'a')), 1.0) => ('b2f', 'a')
 *    ('iand', ('ineg', ('b2i', 'a')), 1) => ('b2i', 'a')
 *    ('imax', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('iand', 'a', 'b')))
 *    ('imin', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ior', 'a', 'b')))
 *    ('umax', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ior', 'a', 'b')))
 *    ('umin', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('iand', 'a', 'b')))
 *    ('umax', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('ior', 'a', 'b'))
 *    ('umin', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('iand', 'a', 'b'))
 *    ('iand', ('b2i', 'a'), 1) => ('b2i', 'a')
 *    ('ine', ('umin', ('ineg', ('b2i', 'a@1')), 'b'), 0) => ('iand', 'a', ('ine', 'b', 0))
 *    ('ine', ('umax', ('ineg', ('b2i', 'a@1')), 'b'), 0) => ('ior', 'a', ('ine', 'b', 0))
 *    ('f2i', ('ftrunc', 'a')) => ('f2i', 'a')
 *    ('f2u', ('ftrunc', 'a')) => ('f2u', 'a')
 *    ('f2fmp', ('f2f32', 'a@16')) => a
 *    ('i2imp', ('i2i32', 'a@16')) => a
 *    ('i2imp', ('u2u32', 'a@16')) => a
 *    ('f2imp', ('f2f32', 'a@16')) => ('f2i16', 'a')
 *    ('f2ump', ('f2f32', 'a@16')) => ('f2u16', 'a')
 *    ('i2fmp', ('i2i32', 'a@16')) => ('i2f16', 'a')
 *    ('u2fmp', ('u2u32', 'a@16')) => ('u2f16', 'a')
 *    ('f2fmp', ('b2f32', 'a@1')) => ('b2f16', 'a')
 *    ('i2imp', ('b2i32', 'a@1')) => ('b2i16', 'a')
 *    ('i2imp', ('b2i32', 'a@1')) => ('b2i16', 'a')
 *    ('f2imp', ('b2f32', 'a@1')) => ('b2i16', 'a')
 *    ('f2ump', ('b2f32', 'a@1')) => ('b2i16', 'a')
 *    ('i2fmp', ('b2i32', 'a@1')) => ('b2f16', 'a')
 *    ('u2fmp', ('b2i32', 'a@1')) => ('b2f16', 'a')
 *    ('f2f32', ('f2fmp', 'a@32')) => a
 *    ('i2i32', ('i2imp', 'a@32')) => a
 *    ('u2u32', ('i2imp', 'a@32')) => a
 *    ('i2i32', ('f2imp', 'a@32')) => ('f2i32', 'a')
 *    ('u2u32', ('f2ump', 'a@32')) => ('f2u32', 'a')
 *    ('f2f32', ('i2fmp', 'a@32')) => ('i2f32', 'a')
 *    ('f2f32', ('u2fmp', 'a@32')) => ('u2f32', 'a')
 *    ('f2i32', ('f2fmp', 'a@32')) => ('f2i32', 'a')
 *    ('f2u32', ('f2fmp', 'a@32')) => ('f2u32', 'a')
 *    ('i2f32', ('i2imp', 'a@32')) => ('i2f32', 'a')
 *    ('ffloor', 'a(is_integral)') => a
 *    ('fceil', 'a(is_integral)') => a
 *    ('ftrunc', 'a(is_integral)') => a
 *    ('fround_even', 'a(is_integral)') => a
 *    ('~ffract', 'a(is_integral)') => 0.0
 *    ('fabs', 'a(is_not_negative)') => a
 *    ('iabs', 'a(is_not_negative)') => a
 *    ('fsat', 'a(is_not_positive)') => 0.0
 *    ('~fmin', 'a(is_not_negative)', 1.0) => ('fsat', 'a')
 *    ('flt', ('fadd', ('fmul', ('fsat', 'a'), ('fneg', ('fsat', 'a'))), 1.0), 0.0) => False
 *    ('flt', ('fadd', ('fneg', ('fmul', ('fsat', 'a'), ('fsat', 'a'))), 1.0), 0.0) => False
 *    ('fmax', ('fadd', ('fmul', ('fsat', 'a'), ('fneg', ('fsat', 'a'))), 1.0), 0.0) => ('fadd', ('fmul', ('fsat', 'a'), ('fneg', ('fsat', 'a'))), 1.0)
 *    ('fmax', ('fadd', ('fneg', ('fmul', ('fsat', 'a'), ('fsat', 'a'))), 1.0), 0.0) => ('fadd', ('fneg', ('fmul', ('fsat', 'a'), ('fsat', 'a'))), 1.0)
 *    ('fneu', 'a(is_not_zero)', 0.0) => True
 *    ('feq', 'a(is_not_zero)', 0.0) => False
 *    ('fge', 'a(is_a_number_not_negative)', 'b(is_a_number_not_positive)') => True
 *    ('fge', 'a(is_not_positive)', 'b(is_gt_zero)') => False
 *    ('fge', 'a(is_lt_zero)', 'b(is_not_negative)') => False
 *    ('flt', 'a(is_not_negative)', 'b(is_not_positive)') => False
 *    ('flt', 'a(is_a_number_not_positive)', 'b(is_a_number_gt_zero)') => True
 *    ('flt', 'a(is_a_number_lt_zero)', 'b(is_a_number_not_negative)') => True
 *    ('ine', 'a(is_not_zero)', 0) => True
 *    ('ieq', 'a(is_not_zero)', 0) => False
 *    ('ige', 'a(is_not_negative)', 'b(is_not_positive)') => True
 *    ('ige', 'a(is_not_positive)', 'b(is_gt_zero)') => False
 *    ('ige', 'a(is_lt_zero)', 'b(is_not_negative)') => False
 *    ('ilt', 'a(is_not_negative)', 'b(is_not_positive)') => False
 *    ('ilt', 'a(is_not_positive)', 'b(is_gt_zero)') => True
 *    ('ilt', 'a(is_lt_zero)', 'b(is_not_negative)') => True
 *    ('ult', 0, 'a(is_gt_zero)') => True
 *    ('ult', 'a', 0) => False
 *    ('unpack_64_2x32_split_x', ('pack_64_2x32_split', 'a', 'b')) => a
 *    ('unpack_64_2x32_split_y', ('pack_64_2x32_split', 'a', 'b')) => b
 *    ('unpack_64_2x32_split_x', ('pack_64_2x32', 'a')) => a.x
 *    ('unpack_64_2x32_split_y', ('pack_64_2x32', 'a')) => a.y
 *    ('unpack_64_2x32_split_x', ('u2u64', 'a@32')) => a
 *    ('unpack_64_2x32_split_y', ('u2u64', 'a')) => 0
 *    ('unpack_64_2x32_split_x', ('i2i64', 'a@32')) => a
 *    ('unpack_64_2x32_split_y', ('i2i64(is_used_once)', 'a@32')) => ('ishr', 'a', 31)
 *    ('unpack_64_2x32', ('pack_64_2x32_split', 'a', 'b')) => ('vec2', 'a', 'b')
 *    ('unpack_64_2x32', ('pack_64_2x32', 'a')) => a
 *    ('unpack_double_2x32_dxil', ('pack_double_2x32_dxil', 'a')) => a
 *    ('pack_64_2x32_split', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')) => a
 *    ('pack_64_2x32', ('vec2', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a'))) => a
 *    ('pack_64_2x32', ('unpack_64_2x32', 'a')) => a
 *    ('pack_double_2x32_dxil', ('unpack_double_2x32_dxil', 'a')) => a
 *    ('unpack_64_4x16', ('pack_64_4x16', 'a')) => a
 *    ('unpack_64_4x16', ('pack_64_2x32', ('vec2', ('pack_32_2x16_split', 'a', 'b'), ('pack_32_2x16_split', 'c', 'd')))) => ('vec4', 'a', 'b', 'c', 'd')
 *    ('unpack_64_4x16', ('pack_64_2x32_split', ('pack_32_2x16_split', 'a', 'b'), ('pack_32_2x16_split', 'c', 'd'))) => ('vec4', 'a', 'b', 'c', 'd')
 *    ('iand', ('ieq', ('unpack_32_2x16_split_x', 'a'), '#b'), ('ieq', ('unpack_32_2x16_split_y', 'a'), '#c')) => ('ieq', 'a', ('pack_32_2x16_split', 'b', 'c'))
 *    ('ushr', 'a@16', 8) => ('extract_u8', 'a', 1)
 *    ('ushr', 'a@32', 24) => ('extract_u8', 'a', 3)
 *    ('ushr', 'a@64', 56) => ('extract_u8', 'a', 7)
 *    ('ishr', 'a@16', 8) => ('extract_i8', 'a', 1)
 *    ('ishr', 'a@32', 24) => ('extract_i8', 'a', 3)
 *    ('ishr', 'a@64', 56) => ('extract_i8', 'a', 7)
 *    ('iand', 255, 'a') => ('extract_u8', 'a', 0)
 *    ('u2u8', ('extract_u16', 'a', 1)) => ('u2u8', ('extract_u8', 'a', 2))
 *    ('u2u8', ('ushr', 'a', 8)) => ('u2u8', ('extract_u8', 'a', 1))
 *    ('i2i16', ('u2u8', ('extract_u8', 'a', 'b'))) => ('i2i16', ('extract_i8', 'a', 'b'))
 *    ('u2u16', ('u2u8', ('extract_u8', 'a', 'b'))) => ('u2u16', ('extract_u8', 'a', 'b'))
 *    ('ubfe', 'a', 0, 8) => ('extract_u8', 'a', 0)
 *    ('ubfe', 'a', 8, 8) => ('extract_u8', 'a', 1)
 *    ('ubfe', 'a', 16, 8) => ('extract_u8', 'a', 2)
 *    ('ubfe', 'a', 24, 8) => ('extract_u8', 'a', 3)
 *    ('ibfe', 'a', 0, 8) => ('extract_i8', 'a', 0)
 *    ('ibfe', 'a', 8, 8) => ('extract_i8', 'a', 1)
 *    ('ibfe', 'a', 16, 8) => ('extract_i8', 'a', 2)
 *    ('ibfe', 'a', 24, 8) => ('extract_i8', 'a', 3)
 *    ('extract_u8', ('extract_i8', 'a', 'b'), 0) => ('extract_u8', 'a', 'b')
 *    ('extract_u8', ('extract_u8', 'a', 'b'), 0) => ('extract_u8', 'a', 'b')
 *    ('ushr', ('ishl', 'a@32', 16), 16) => ('extract_u16', 'a', 0)
 *    ('ushr', 'a@32', 16) => ('extract_u16', 'a', 1)
 *    ('ishr', ('ishl', 'a@32', 16), 16) => ('extract_i16', 'a', 0)
 *    ('ishr', 'a@32', 16) => ('extract_i16', 'a', 1)
 *    ('iand', 65535, 'a') => ('extract_u16', 'a', 0)
 *    ('ubfe', 'a', 0, 16) => ('extract_u16', 'a', 0)
 *    ('ubfe', 'a', 16, 16) => ('extract_u16', 'a', 1)
 *    ('ibfe', 'a', 0, 16) => ('extract_i16', 'a', 0)
 *    ('ibfe', 'a', 16, 16) => ('extract_i16', 'a', 1)
 *    ('ior', ('ishl', ('u2u32', 'a@8'), 24), ('ior', ('ishl', ('u2u32', 'b@8'), 16), ('ior', ('ishl', ('u2u32', 'c@8'), 8), ('u2u32', 'd@8')))) => ('pack_32_4x8', ('vec4', 'd', 'c', 'b', 'a'))
 *    ('extract_u16', ('extract_i16', 'a', 'b'), 0) => ('extract_u16', 'a', 'b')
 *    ('extract_u16', ('extract_u16', 'a', 'b'), 0) => ('extract_u16', 'a', 'b')
 *    ('pack_64_2x32_split', 'a', 'b') => ('ior', ('u2u64', 'a'), ('ishl', ('u2u64', 'b'), 32))
 *    ('pack_32_2x16_split', 'a', 'b') => ('ior', ('u2u32', 'a'), ('ishl', ('u2u32', 'b'), 16))
 *    ('pack_half_2x16_split', 'a', 'b') => ('pack_half_2x16_rtz_split', 'a', 'b')
 *    ('unpack_64_2x32_split_x', 'a') => ('u2u32', 'a')
 *    ('unpack_64_2x32_split_y', 'a') => ('u2u32', ('ushr', 'a', 32))
 *    ('unpack_32_2x16_split_x', 'a') => ('u2u16', 'a')
 *    ('unpack_32_2x16_split_y', 'a') => ('u2u16', ('ushr', 'a', 16))
 *    ('unpack_64_2x32_split_x', ('ushr', 'a', 32)) => ('unpack_64_2x32_split_y', 'a')
 *    ('u2u32', ('ushr', 'a@64', 32)) => ('unpack_64_2x32_split_y', 'a')
 *    ('unpack_half_2x16_split_x', ('iand', 'a', 65535)) => ('unpack_half_2x16_split_x', 'a')
 *    ('unpack_32_2x16_split_x', ('iand', 'a', 65535)) => ('unpack_32_2x16_split_x', 'a')
 *    ('unpack_64_2x32_split_x', ('iand', 'a', 4294967295)) => ('unpack_64_2x32_split_x', 'a')
 *    ('unpack_half_2x16_split_y', ('iand', 'a', 4294901760)) => ('unpack_half_2x16_split_y', 'a')
 *    ('unpack_32_2x16_split_y', ('iand', 'a', 4294901760)) => ('unpack_32_2x16_split_y', 'a')
 *    ('unpack_64_2x32_split_y', ('iand', 'a', 18446744069414584320)) => ('unpack_64_2x32_split_y', 'a')
 *    ('unpack_half_2x16_split_x', ('extract_u16', 'a', 0)) => ('unpack_half_2x16_split_x', 'a')
 *    ('unpack_half_2x16_split_x', ('extract_u16', 'a', 1)) => ('unpack_half_2x16_split_y', 'a')
 *    ('unpack_half_2x16_split_x', ('ushr', 'a', 16)) => ('unpack_half_2x16_split_y', 'a')
 *    ('unpack_32_2x16_split_x', ('extract_u16', 'a', 0)) => ('unpack_32_2x16_split_x', 'a')
 *    ('unpack_32_2x16_split_x', ('extract_u16', 'a', 1)) => ('unpack_32_2x16_split_y', 'a')
 *    ('ishl', ('pack_half_2x16', ('vec2', 'a', 0)), 16) => ('pack_half_2x16', ('vec2', 0, 'a'))
 *    ('ushr', ('pack_half_2x16', ('vec2', 0, 'a')), 16) => ('pack_half_2x16', ('vec2', 'a', 0))
 *    ('iadd', ('pack_half_2x16', ('vec2', 'a', 0)), ('pack_half_2x16', ('vec2', 0, 'b'))) => ('pack_half_2x16', ('vec2', 'a', 'b'))
 *    ('ior', ('pack_half_2x16', ('vec2', 'a', 0)), ('pack_half_2x16', ('vec2', 0, 'b'))) => ('pack_half_2x16', ('vec2', 'a', 'b'))
 *    ('ishl', ('pack_half_2x16_split', 'a', 0), 16) => ('pack_half_2x16_split', 0, 'a')
 *    ('ushr', ('pack_half_2x16_split', 0, 'a'), 16) => ('pack_half_2x16_split', 'a', 0)
 *    ('extract_u16', ('pack_half_2x16_split', 0, 'a'), 1) => ('pack_half_2x16_split', 'a', 0)
 *    ('ishl', ('pack_half_2x16_rtz_split', 'a', 0), 16) => ('pack_half_2x16_rtz_split', 0, 'a')
 *    ('ushr', ('pack_half_2x16_rtz_split', 0, 'a'), 16) => ('pack_half_2x16_rtz_split', 'a', 0)
 *    ('extract_u16', ('pack_half_2x16_rtz_split', 0, 'a'), 1) => ('pack_half_2x16_rtz_split', 'a', 0)
 *    ('iadd', ('pack_half_2x16_split', 'a', 0), ('pack_half_2x16_split', 0, 'b')) => ('pack_half_2x16_split', 'a', 'b')
 *    ('ior', ('pack_half_2x16_split', 'a', 0), ('pack_half_2x16_split', 0, 'b')) => ('pack_half_2x16_split', 'a', 'b')
 *    ('iadd', ('pack_half_2x16_rtz_split', 'a', 0), ('pack_half_2x16_rtz_split', 0, 'b')) => ('pack_half_2x16_rtz_split', 'a', 'b')
 *    ('ior', ('pack_half_2x16_rtz_split', 'a', 0), ('pack_half_2x16_rtz_split', 0, 'b')) => ('pack_half_2x16_rtz_split', 'a', 'b')
 *    ('extract_i8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 0) => ('i2i', 'a')
 *    ('extract_i8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 1) => ('i2i', 'b')
 *    ('extract_i8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 2) => ('i2i', 'c')
 *    ('extract_i8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 3) => ('i2i', 'd')
 *    ('extract_u8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 0) => ('u2u', 'a')
 *    ('extract_u8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 1) => ('u2u', 'b')
 *    ('extract_u8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 2) => ('u2u', 'c')
 *    ('extract_u8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 3) => ('u2u', 'd')
 *    ('u2u32', ('iadd(is_used_once)', 'a@64', 'b')) => ('iadd', ('u2u32', 'a'), ('u2u32', 'b'))
 *    ('extract_u8', ('ushr', 'a@16', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ushr', 'a@32', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ushr', 'a@32', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ushr', 'a@32', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ushr', 'a@64', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ushr', 'a@64', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ushr', 'a@64', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ushr', 'a@64', 32), 0) => ('extract_u8', 'a', 4)
 *    ('extract_u8', ('ushr', 'a@64', 40), 0) => ('extract_u8', 'a', 5)
 *    ('extract_u8', ('ushr', 'a@64', 48), 0) => ('extract_u8', 'a', 6)
 *    ('extract_u8', ('ushr', 'a@64', 56), 0) => ('extract_u8', 'a', 7)
 *    ('extract_u8', ('ishr', 'a@16', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishr', 'a@32', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishr', 'a@32', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishr', 'a@32', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ishr', 'a@64', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishr', 'a@64', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishr', 'a@64', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ishr', 'a@64', 32), 0) => ('extract_u8', 'a', 4)
 *    ('extract_u8', ('ishr', 'a@64', 40), 0) => ('extract_u8', 'a', 5)
 *    ('extract_u8', ('ishr', 'a@64', 48), 0) => ('extract_u8', 'a', 6)
 *    ('extract_u8', ('ishr', 'a@64', 56), 0) => ('extract_u8', 'a', 7)
 *    ('extract_u8', ('extract_u16', 'a', 1), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishl', 'a@16', 8), 1) => ('extract_u8', 'a', 0)
 *    ('extract_u8', ('ishl', 'a@32', 8), 3) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishl', 'a@32', 16), 3) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishl', 'a@32', 24), 3) => ('extract_u8', 'a', 0)
 *    ('extract_u8', ('ishl', 'a@64', 8), 7) => ('extract_u8', 'a', 6)
 *    ('extract_u8', ('ishl', 'a@64', 16), 7) => ('extract_u8', 'a', 5)
 *    ('extract_u8', ('ishl', 'a@64', 24), 7) => ('extract_u8', 'a', 4)
 *    ('extract_u8', ('ishl', 'a@64', 32), 7) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ishl', 'a@64', 40), 7) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishl', 'a@64', 48), 7) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishl', 'a@64', 56), 7) => ('extract_u8', 'a', 0)
 *    ('extract_i8', ('ishl', 'a@16', 8), 1) => ('extract_i8', 'a', 0)
 *    ('extract_i8', ('ishl', 'a@32', 8), 3) => ('extract_i8', 'a', 2)
 *    ('extract_i8', ('ishl', 'a@32', 16), 3) => ('extract_i8', 'a', 1)
 *    ('extract_i8', ('ishl', 'a@32', 24), 3) => ('extract_i8', 'a', 0)
 *    ('extract_i8', ('ishl', 'a@64', 8), 7) => ('extract_i8', 'a', 6)
 *    ('extract_i8', ('ishl', 'a@64', 16), 7) => ('extract_i8', 'a', 5)
 *    ('extract_i8', ('ishl', 'a@64', 24), 7) => ('extract_i8', 'a', 4)
 *    ('extract_i8', ('ishl', 'a@64', 32), 7) => ('extract_i8', 'a', 3)
 *    ('extract_i8', ('ishl', 'a@64', 40), 7) => ('extract_i8', 'a', 2)
 *    ('extract_i8', ('ishl', 'a@64', 48), 7) => ('extract_i8', 'a', 1)
 *    ('extract_i8', ('ishl', 'a@64', 56), 7) => ('extract_i8', 'a', 0)
 *    ('ieq', ('pack_64_2x32_split', 'a', 0), ('pack_64_2x32_split', 'b', 0)) => ('ieq', 'a', 'b')
 *    ('ieq', ('pack_64_2x32_split', 'a', 0), '#b(is_upper_half_zero)') => ('ieq', 'a', ('unpack_64_2x32_split_x', 'b'))
 *    ('ieq', '#a(is_upper_half_zero)', ('pack_64_2x32_split', 'b', 0)) => ('ieq', ('unpack_64_2x32_split_x', 'a'), 'b')
 *    ('ieq', ('pack_64_2x32_split', 0, 'a'), ('pack_64_2x32_split', 0, 'b')) => ('ieq', 'a', 'b')
 *    ('ieq', ('pack_64_2x32_split', 0, 'a'), '#b(is_lower_half_zero)') => ('ieq', 'a', ('unpack_64_2x32_split_y', 'b'))
 *    ('ieq', '#a(is_lower_half_zero)', ('pack_64_2x32_split', 0, 'b')) => ('ieq', ('unpack_64_2x32_split_y', 'a'), 'b')
 *    ('ine', ('pack_64_2x32_split', 'a', 0), ('pack_64_2x32_split', 'b', 0)) => ('ine', 'a', 'b')
 *    ('ine', ('pack_64_2x32_split', 'a', 0), '#b(is_upper_half_zero)') => ('ine', 'a', ('unpack_64_2x32_split_x', 'b'))
 *    ('ine', '#a(is_upper_half_zero)', ('pack_64_2x32_split', 'b', 0)) => ('ine', ('unpack_64_2x32_split_x', 'a'), 'b')
 *    ('ine', ('pack_64_2x32_split', 0, 'a'), ('pack_64_2x32_split', 0, 'b')) => ('ine', 'a', 'b')
 *    ('ine', ('pack_64_2x32_split', 0, 'a'), '#b(is_lower_half_zero)') => ('ine', 'a', ('unpack_64_2x32_split_y', 'b'))
 *    ('ine', '#a(is_lower_half_zero)', ('pack_64_2x32_split', 0, 'b')) => ('ine', ('unpack_64_2x32_split_y', 'a'), 'b')
 *    ('ult', ('pack_64_2x32_split', 'a', 0), ('pack_64_2x32_split', 'b', 0)) => ('ult', 'a', 'b')
 *    ('ult', ('pack_64_2x32_split', 'a', 0), '#b(is_upper_half_zero)') => ('ult', 'a', ('unpack_64_2x32_split_x', 'b'))
 *    ('ult', '#a(is_upper_half_zero)', ('pack_64_2x32_split', 'b', 0)) => ('ult', ('unpack_64_2x32_split_x', 'a'), 'b')
 *    ('ult', ('pack_64_2x32_split', 0, 'a'), ('pack_64_2x32_split', 0, 'b')) => ('ult', 'a', 'b')
 *    ('ult', ('pack_64_2x32_split', 0, 'a'), '#b(is_lower_half_zero)') => ('ult', 'a', ('unpack_64_2x32_split_y', 'b'))
 *    ('ult', '#a(is_lower_half_zero)', ('pack_64_2x32_split', 0, 'b')) => ('ult', ('unpack_64_2x32_split_y', 'a'), 'b')
 *    ('ilt', ('pack_64_2x32_split', 'a', 0), ('pack_64_2x32_split', 'b', 0)) => ('ult', 'a', 'b')
 *    ('ilt', ('pack_64_2x32_split', 'a', 0), '#b(is_upper_half_zero)') => ('ult', 'a', ('unpack_64_2x32_split_x', 'b'))
 *    ('ilt', '#a(is_upper_half_zero)', ('pack_64_2x32_split', 'b', 0)) => ('ult', ('unpack_64_2x32_split_x', 'a'), 'b')
 *    ('ilt', ('pack_64_2x32_split', 0, 'a'), ('pack_64_2x32_split', 0, 'b')) => ('ilt', 'a', 'b')
 *    ('ilt', ('pack_64_2x32_split', 0, 'a'), '#b(is_lower_half_zero)') => ('ilt', 'a', ('unpack_64_2x32_split_y', 'b'))
 *    ('ilt', '#a(is_lower_half_zero)', ('pack_64_2x32_split', 0, 'b')) => ('ilt', ('unpack_64_2x32_split_y', 'a'), 'b')
 *    ('uge', ('pack_64_2x32_split', 'a', 0), ('pack_64_2x32_split', 'b', 0)) => ('uge', 'a', 'b')
 *    ('uge', ('pack_64_2x32_split', 'a', 0), '#b(is_upper_half_zero)') => ('uge', 'a', ('unpack_64_2x32_split_x', 'b'))
 *    ('uge', '#a(is_upper_half_zero)', ('pack_64_2x32_split', 'b', 0)) => ('uge', ('unpack_64_2x32_split_x', 'a'), 'b')
 *    ('uge', ('pack_64_2x32_split', 0, 'a'), ('pack_64_2x32_split', 0, 'b')) => ('uge', 'a', 'b')
 *    ('uge', ('pack_64_2x32_split', 0, 'a'), '#b(is_lower_half_zero)') => ('uge', 'a', ('unpack_64_2x32_split_y', 'b'))
 *    ('uge', '#a(is_lower_half_zero)', ('pack_64_2x32_split', 0, 'b')) => ('uge', ('unpack_64_2x32_split_y', 'a'), 'b')
 *    ('ige', ('pack_64_2x32_split', 'a', 0), ('pack_64_2x32_split', 'b', 0)) => ('uge', 'a', 'b')
 *    ('ige', ('pack_64_2x32_split', 'a', 0), '#b(is_upper_half_zero)') => ('uge', 'a', ('unpack_64_2x32_split_x', 'b'))
 *    ('ige', '#a(is_upper_half_zero)', ('pack_64_2x32_split', 'b', 0)) => ('uge', ('unpack_64_2x32_split_x', 'a'), 'b')
 *    ('ige', ('pack_64_2x32_split', 0, 'a'), ('pack_64_2x32_split', 0, 'b')) => ('ige', 'a', 'b')
 *    ('ige', ('pack_64_2x32_split', 0, 'a'), '#b(is_lower_half_zero)') => ('ige', 'a', ('unpack_64_2x32_split_y', 'b'))
 *    ('ige', '#a(is_lower_half_zero)', ('pack_64_2x32_split', 0, 'b')) => ('ige', ('unpack_64_2x32_split_y', 'a'), 'b')
 *    ('ussub_4x8_vc4', 'a', 0) => a
 *    ('ussub_4x8_vc4', 'a', -1) => 0
 *    ('fsub', 'a', 'b') => ('fadd', 'a', ('fneg', 'b'))
 *    ('isub', 'a', 'b') => ('iadd', 'a', ('ineg', 'b'))
 *    ('uabs_usub', 'a', 'b') => ('bcsel', ('ult', 'a', 'b'), ('ineg', ('isub', 'a', 'b')), ('isub', 'a', 'b'))
 *    ('uabs_isub', 'a', 'b') => ('bcsel', ('ilt', 'a', 'b'), ('ineg', ('isub', 'a', 'b')), ('isub', 'a', 'b'))
 *    ('bitz', 'a', 'b') => ('inot', ('bitnz', 'a', 'b'))
 *    ('fmul(is_used_by_non_fsat)', ('fneg', 'a'), 'b') => ('fneg', ('fmul', 'a', 'b'))
 *    ('fmulz(is_used_by_non_fsat)', ('fneg', 'a'), 'b') => ('fneg', ('fmulz', 'a', 'b'))
 *    ('ffma', ('fneg', 'a'), ('fneg', 'b'), 'c') => ('ffma', 'a', 'b', 'c')
 *    ('ffmaz', ('fneg', 'a'), ('fneg', 'b'), 'c') => ('ffmaz', 'a', 'b', 'c')
 *    ('imul', ('ineg', 'a'), 'b') => ('ineg', ('imul', 'a', 'b'))
 *    ('~fmul(is_used_once)', ('fmul(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('fmul', ('fmul', 'a', 'c'), 'b')
 *    ('~fmulz(is_used_once)', ('fmulz(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('fmulz', ('fmulz', 'a', 'c'), 'b')
 *    ('~fmul(is_used_once)', ('fmulz(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c(is_finite_not_zero)') => ('fmulz', ('fmul', 'a', 'c'), 'b')
 *    ('imul(is_used_once)', ('imul(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('imul', ('imul', 'a', 'c'), 'b')
 *    ('~ffma', ('fmul(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c', 'd') => ('ffma', ('fmul', 'a', 'c'), 'b', 'd')
 *    ('~ffmaz', ('fmulz(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c', 'd') => ('ffmaz', ('fmulz', 'a', 'c'), 'b', 'd')
 *    ('~ffma', ('fmulz(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c(is_finite_not_zero)', 'd') => ('ffmaz', ('fmul', 'a', 'c'), 'b', 'd')
 *    ('~fadd(is_used_once)', ('fadd(is_used_once)', 'a(is_not_const)', 'b(is_fmul)'), '#c') => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('~fadd(is_used_once)', ('fadd(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('~fadd(is_used_once)', ('ffma(is_used_once)', 'a(is_not_const)', 'b', 'c(is_not_const)'), '#d') => ('fadd', ('ffma', 'a', 'b', 'd'), 'c')
 *    ('~fadd(is_used_once)', ('ffmaz(is_used_once)', 'a(is_not_const)', 'b', 'c(is_not_const)'), '#d') => ('fadd', ('ffmaz', 'a', 'b', 'd'), 'c')
 *    ('iadd(is_used_once)', ('iadd(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('iadd', ('iadd', 'a', 'c'), 'b')
 *    ('~fmul', '#a', ('fmul', 'b(is_not_const)', '#c')) => ('fmul', ('fmul', 'a', 'c'), 'b')
 *    ('~fmulz', '#a', ('fmulz', 'b(is_not_const)', '#c')) => ('fmulz', ('fmulz', 'a', 'c'), 'b')
 *    ('~fmul', '#a(is_finite_not_zero)', ('fmulz', 'b(is_not_const)', '#c')) => ('fmulz', ('fmul', 'a', 'c'), 'b')
 *    ('~ffma', '#a', ('fmul', 'b(is_not_const)', '#c'), 'd') => ('ffma', ('fmul', 'a', 'c'), 'b', 'd')
 *    ('~ffmaz', '#a', ('fmulz', 'b(is_not_const)', '#c'), 'd') => ('ffmaz', ('fmulz', 'a', 'c'), 'b', 'd')
 *    ('~ffmaz', '#a(is_finite_not_zero)', ('fmulz', 'b(is_not_const)', '#c'), 'd') => ('ffmaz', ('fmul', 'a', 'c'), 'b', 'd')
 *    ('imul', '#a', ('imul', 'b(is_not_const)', '#c')) => ('imul', ('imul', 'a', 'c'), 'b')
 *    ('~fadd', '#a', ('fadd', 'b(is_not_const)', '#c')) => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('~fadd', '#a', ('fneg', ('fadd', 'b(is_not_const)', '#c'))) => ('fadd', ('fadd', 'a', ('fneg', 'c')), ('fneg', 'b'))
 *    ('~fadd', '#a', ('ffma', 'b(is_not_const)', 'c(is_not_const)', '#d')) => ('ffma', 'b', 'c', ('fadd', 'a', 'd'))
 *    ('~fadd', '#a', ('fneg', ('ffma', 'b(is_not_const)', 'c(is_not_const)', '#d'))) => ('ffma', ('fneg', 'b'), 'c', ('fadd', 'a', ('fneg', 'd')))
 *    ('~fadd', '#a', ('ffmaz', 'b(is_not_const)', 'c(is_not_const)', '#d')) => ('ffmaz', 'b', 'c', ('fadd', 'a', 'd'))
 *    ('~fadd', '#a', ('fneg', ('ffmaz', 'b(is_not_const)', 'c(is_not_const)', '#d'))) => ('ffmaz', ('fneg', 'b'), 'c', ('fadd', 'a', ('fneg', 'd')))
 *    ('iadd', '#a', ('iadd', 'b(is_not_const)', '#c')) => ('iadd', ('iadd', 'a', 'c'), 'b')
 *    ('iand', '#a', ('iand', 'b(is_not_const)', '#c')) => ('iand', ('iand', 'a', 'c'), 'b')
 *    ('ior', '#a', ('ior', 'b(is_not_const)', '#c')) => ('ior', ('ior', 'a', 'c'), 'b')
 *    ('ixor', '#a', ('ixor', 'b(is_not_const)', '#c')) => ('ixor', ('ixor', 'a', 'c'), 'b')
 *    ('~fadd', ('fadd(is_used_once)', 'a(is_fmul)', 'b(is_fmul)'), 'c(is_not_fmul)') => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('idiv', ('imul(no_signed_wrap)', 'a', 'b'), 'b') => a
 *    ('bcsel', ('ige', ('find_lsb', 'a'), 0), ('find_lsb', 'a'), -1) => ('find_lsb', 'a')
 *    ('bcsel', ('ige', ('ifind_msb', 'a'), 0), ('ifind_msb', 'a'), -1) => ('ifind_msb', 'a')
 *    ('bcsel', ('ige', ('ufind_msb', 'a'), 0), ('ufind_msb', 'a'), -1) => ('ufind_msb', 'a')
 *    ('bcsel', ('ige', ('ifind_msb_rev', 'a'), 0), ('ifind_msb_rev', 'a'), -1) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ige', ('ufind_msb_rev', 'a'), 0), ('ufind_msb_rev', 'a'), -1) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('find_lsb', 'a'), -1) => ('find_lsb', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('ifind_msb', 'a'), -1) => ('ifind_msb', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('ufind_msb', 'a'), -1) => ('ufind_msb', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('ifind_msb_rev', 'a'), -1) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('ufind_msb_rev', 'a'), -1) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ine', 'a', -1), ('ifind_msb', 'a'), -1) => ('ifind_msb', 'a')
 *    ('bcsel', ('ine', 'a', -1), ('ifind_msb_rev', 'a'), -1) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ine', ('ifind_msb', 'a@32'), -1), ('iadd', 31, ('ineg', ('ifind_msb', 'a'))), -1) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ine', ('ufind_msb', 'a@32'), -1), ('iadd', 31, ('ineg', ('ufind_msb', 'a'))), -1) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ieq', ('ifind_msb', 'a@32'), -1), -1, ('iadd', 31, ('ineg', ('ifind_msb', 'a')))) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ieq', ('ufind_msb', 'a@32'), -1), -1, ('iadd', 31, ('ineg', ('ufind_msb', 'a')))) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ine', ('ifind_msb', 'a@32'), -1), ('iadd', 31, ('ineg', ('ifind_msb', 'a'))), ('ifind_msb', 'a')) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ine', ('ufind_msb', 'a@32'), -1), ('iadd', 31, ('ineg', ('ufind_msb', 'a'))), ('ufind_msb', 'a')) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ieq', ('ifind_msb', 'a@32'), -1), ('ifind_msb', 'a'), ('iadd', 31, ('ineg', ('ifind_msb', 'a')))) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ieq', ('ufind_msb', 'a@32'), -1), ('ufind_msb', 'a'), ('iadd', 31, ('ineg', ('ufind_msb', 'a')))) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ine', 'a@32', 0), ('iadd', 31, ('ineg', ('ufind_msb', 'a'))), -1) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ieq', 'a@32', 0), -1, ('iadd', 31, ('ineg', ('ufind_msb', 'a')))) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ine', 'a@32', 0), ('iadd', 31, ('ineg', ('ufind_msb', 'a'))), ('ufind_msb', 'a')) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ieq', 'a@32', 0), ('ufind_msb', 'a'), ('iadd', 31, ('ineg', ('ufind_msb', 'a')))) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ine', ('ifind_msb_rev', 'a@32'), -1), ('iadd', 31, ('ineg', ('ifind_msb_rev', 'a'))), -1) => ('ifind_msb', 'a')
 *    ('bcsel', ('ine', ('ufind_msb_rev', 'a@32'), -1), ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a'))), -1) => ('ufind_msb', 'a')
 *    ('bcsel', ('ieq', ('ifind_msb_rev', 'a@32'), -1), -1, ('iadd', 31, ('ineg', ('ifind_msb_rev', 'a')))) => ('ifind_msb', 'a')
 *    ('bcsel', ('ieq', ('ufind_msb_rev', 'a@32'), -1), -1, ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a')))) => ('ufind_msb', 'a')
 *    ('bcsel', ('ine', ('ifind_msb_rev', 'a@32'), -1), ('iadd', 31, ('ineg', ('ifind_msb_rev', 'a'))), ('ifind_msb_rev', 'a')) => ('ifind_msb', 'a')
 *    ('bcsel', ('ine', ('ufind_msb_rev', 'a@32'), -1), ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a'))), ('ufind_msb_rev', 'a')) => ('ufind_msb', 'a')
 *    ('bcsel', ('ieq', ('ifind_msb_rev', 'a@32'), -1), ('ifind_msb_rev', 'a'), ('iadd', 31, ('ineg', ('ifind_msb_rev', 'a')))) => ('ifind_msb', 'a')
 *    ('bcsel', ('ieq', ('ufind_msb_rev', 'a@32'), -1), ('ufind_msb_rev', 'a'), ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a')))) => ('ufind_msb', 'a')
 *    ('bcsel', ('ine', 'a@32', 0), ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a'))), -1) => ('ufind_msb', 'a')
 *    ('bcsel', ('ieq', 'a@32', 0), -1, ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a')))) => ('ufind_msb', 'a')
 *    ('bcsel', ('ine', 'a@32', 0), ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a'))), ('ufind_msb_rev', 'a')) => ('ufind_msb', 'a')
 *    ('bcsel', ('ieq', 'a@32', 0), ('ufind_msb_rev', 'a'), ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a')))) => ('ufind_msb', 'a')
 *    ('find_lsb', ('bitfield_reverse', 'a')) => ('ufind_msb_rev', 'a')
 *    ('ufind_msb_rev', ('bitfield_reverse', 'a')) => ('find_lsb', 'a')
 *    ('ifind_msb', ('f2i32(is_used_once)', 'a')) => ('ufind_msb', ('f2i32', ('fabs', 'a')))
 *    ('~fmul', ('bcsel(is_used_once)', 'c', -1.0, 1.0), 'b') => ('bcsel', 'c', ('fneg', 'b'), 'b')
 *    ('~fmul', ('bcsel(is_used_once)', 'c', 1.0, -1.0), 'b') => ('bcsel', 'c', 'b', ('fneg', 'b'))
 *    ('~fmulz', ('bcsel(is_used_once)', 'c', -1.0, 1.0), 'b') => ('bcsel', 'c', ('fneg', 'b'), 'b')
 *    ('~fmulz', ('bcsel(is_used_once)', 'c', 1.0, -1.0), 'b') => ('bcsel', 'c', 'b', ('fneg', 'b'))
 *    ('fabs', ('bcsel(is_used_once)', 'b', ('fneg', 'a'), 'a')) => ('fabs', 'a')
 *    ('fabs', ('bcsel(is_used_once)', 'b', 'a', ('fneg', 'a'))) => ('fabs', 'a')
 *    ('~bcsel', ('flt', 'a', 0.0), ('fneg', 'a'), 'a') => ('fabs', 'a')
 *    ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), 'd') => ('bcsel', ('iand', 'a', 'b'), 'c', 'd')
 *    ('bcsel', 'a', 'b', ('bcsel', 'c', 'b', 'd')) => ('bcsel', ('ior', 'a', 'c'), 'b', 'd')
 *    ('fmod', 'a', 'b') => ('fsub', 'a', ('fmul', 'b', ('ffloor', ('fdiv', 'a', 'b'))))
 *    ('frem', 'a', 'b') => ('fsub', 'a', ('fmul', 'b', ('ftrunc', ('fdiv', 'a', 'b'))))
 *    ('uadd_carry', 'a', 'b') => ('b2i', ('ult', ('iadd', 'a', 'b'), 'a'))
 *    ('usub_borrow', 'a', 'b') => ('b2i', ('ult', 'a', 'b'))
 *    ('bitfield_insert', 'base', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'insert', ('bfi', ('bfm', 'bits', 'offset'), 'insert', 'base'))
 *    ('ihadd', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('uhadd', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('irhadd', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('urhadd', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('ihadd@64', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('uhadd@64', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('irhadd@64', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('urhadd@64', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('imul_32x16', 'a', 'b') => ('imul', 'a', ('extract_i16', 'b', 0))
 *    ('umul_32x16', 'a', 'b') => ('imul', 'a', ('extract_u16', 'b', 0))
 *    ('uadd_sat@64', 'a', 'b') => ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd', 'a', 'b'))
 *    ('uadd_sat', 'a', 'b') => ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd', 'a', 'b'))
 *    ('usub_sat', 'a', 'b') => ('bcsel', ('ult', 'a', 'b'), 0, ('isub', 'a', 'b'))
 *    ('usub_sat@64', 'a', 'b') => ('bcsel', ('ult', 'a', 'b'), 0, ('isub', 'a', 'b'))
 *    ('iadd_sat@64', 'a', 'b') => ('bcsel', ('iand', ('iand', ('ilt', 'a', 0), ('ilt', 'b', 0)), ('ige', ('iadd', 'a', 'b'), 0)), 9223372036854775808, ('bcsel', ('ior', ('ior', ('ilt', 'a', 0), ('ilt', 'b', 0)), ('ige', ('iadd', 'a', 'b'), 0)), ('iadd', 'a', 'b'), 9223372036854775807))
 *    ('isub_sat@64', 'a', 'b') => ('bcsel', ('iand', ('iand', ('ilt', 'a', 0), ('ige', 'b', 0)), ('ige', ('isub', 'a', 'b'), 0)), 9223372036854775808, ('bcsel', ('ior', ('ior', ('ilt', 'a', 0), ('ige', 'b', 0)), ('ige', ('isub', 'a', 'b'), 0)), ('isub', 'a', 'b'), 9223372036854775807))
 *    ('ilt', ('imax(is_used_once)', 'a@64', 'b@64'), 0) => ('ilt', ('imax', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ilt', ('imin(is_used_once)', 'a@64', 'b@64'), 0) => ('ilt', ('imin', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ige', ('imax(is_used_once)', 'a@64', 'b@64'), 0) => ('ige', ('imax', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ige', ('imin(is_used_once)', 'a@64', 'b@64'), 0) => ('ige', ('imin', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ilt', 'a@64', 0) => ('ilt', ('unpack_64_2x32_split_y', 'a'), 0)
 *    ('ige', 'a@64', 0) => ('ige', ('unpack_64_2x32_split_y', 'a'), 0)
 *    ('ine', 'a@64', 0) => ('ine', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')), 0)
 *    ('ieq', 'a@64', 0) => ('ieq', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')), 0)
 *    ('ult', 0, 'a@64') => ('ine', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')), 0)
 *    ('bitfield_insert', 'base', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'insert', ('ior', ('iand', 'base', ('inot', ('ishl', ('isub', ('ishl', 1, 'bits'), 1), 'offset'))), ('iand', ('ishl', 'insert', 'offset'), ('ishl', ('isub', ('ishl', 1, 'bits'), 1), 'offset'))))
 *    ('bitfield_insert', 'base', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'insert', ('bitfield_select', ('bfm', 'bits', 'offset'), ('ishl', 'insert', 'offset'), 'base'))
 *    ('ibitfield_extract', 'value', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'value', ('ibfe', 'value', 'offset', 'bits'))
 *    ('ubitfield_extract', 'value', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'value', ('ubfe', 'value', 'offset', 'bits'))
 *    ('bitfield_select', 'a', 'b', 0) => ('iand', 'a', 'b')
 *    ('bitfield_select', 'a', ('iand', 'a', 'b'), 'c') => ('bitfield_select', 'a', 'b', 'c')
 *    ('ubfe', 'value', 'offset', ('iand', 31, 'bits')) => ('ubfe', 'value', 'offset', 'bits')
 *    ('ubfe', 'value', ('iand', 31, 'offset'), 'bits') => ('ubfe', 'value', 'offset', 'bits')
 *    ('ibfe', 'value', 'offset', ('iand', 31, 'bits')) => ('ibfe', 'value', 'offset', 'bits')
 *    ('ibfe', 'value', ('iand', 31, 'offset'), 'bits') => ('ibfe', 'value', 'offset', 'bits')
 *    ('bfm', 'bits', ('iand', 31, 'offset')) => ('bfm', 'bits', 'offset')
 *    ('bfm', ('iand', 31, 'bits'), 'offset') => ('bfm', 'bits', 'offset')
 *    ('ult', 'a', ('umin', ('iand', 'a', 'b'), 'c')) => False
 *    ('ult', 31, ('umin', '#bits(is_ult_32)', 'a')) => False
 *    ('ubfe', 'value', 'offset', ('umin', 'width', ('iadd', 32, ('ineg', ('iand', 31, 'offset'))))) => ('ubfe', 'value', 'offset', 'width')
 *    ('ibfe', 'value', 'offset', ('umin', 'width', ('iadd', 32, ('ineg', ('iand', 31, 'offset'))))) => ('ibfe', 'value', 'offset', 'width')
 *    ('bfm', ('umin', 'width', ('iadd', 32, ('ineg', ('iand', 31, 'offset')))), 'offset') => ('bfm', 'width', 'offset')
 *    ('iadd@32', ('ishl', 1, 'a'), -1) => ('bfm', 'a', 0)
 *    ('ishl', ('bfm', 'a', 0), 'b') => ('bfm', 'a', 'b')
 *    ('ubfe', 'a', 'b', 0) => 0
 *    ('ibfe', 'a', 'b', 0) => 0
 *    ('ubfe', 'a', 0, '#b') => ('iand', 'a', ('ushr', 4294967295, ('ineg', 'b')))
 *    ('b2i32', ('ine', ('ubfe', 'a', 'b', 1), 0)) => ('ubfe', 'a', 'b', 1)
 *    ('b2i32', ('ine', ('ibfe', 'a', 'b', 1), 0)) => ('ubfe', 'a', 'b', 1)
 *    ('ine', ('ibfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ine', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ieq', ('ibfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ieq', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ine', ('ubfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ine', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ieq', ('ubfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ieq', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ibitfield_extract', 'value', 'offset', 'bits') => ('bcsel', ('ieq', 0, 'bits'), 0, ('ishr', ('ishl', 'value', ('isub', ('isub', 32, 'bits'), 'offset')), ('isub', 32, 'bits')))
 *    ('ubitfield_extract', 'value', 'offset', 'bits') => ('iand', ('ushr', 'value', 'offset'), ('bcsel', ('ieq', 'bits', 32), 4294967295, ('isub', ('ishl', 1, 'bits'), 1)))
 *    ('ifind_msb', 'value') => ('ufind_msb', ('bcsel', ('ilt', 'value', 0), ('inot', 'value'), 'value'))
 *    ('ifind_msb', 'value') => ('bcsel', ('ige', ('ifind_msb_rev', 'value'), 0), ('isub', 31, ('ifind_msb_rev', 'value')), ('ifind_msb_rev', 'value'))
 *    ('ifind_msb', 'value') => ('isub', 31, ('uclz', ('ixor', 'value', ('ishr', 'value', 31))))
 *    ('ufind_msb', 'value@32') => ('bcsel', ('ige', ('ufind_msb_rev', 'value'), 0), ('isub', 31, ('ufind_msb_rev', 'value')), ('ufind_msb_rev', 'value'))
 *    ('ufind_msb', 'value@32') => ('isub', 31, ('uclz', 'value'))
 *    ('uclz', 'a') => ('umin', 32, ('ufind_msb_rev', 'a'))
 *    ('find_lsb', 'value@64') => ('ufind_msb', ('iand', 'value', ('ineg', 'value')))
 *    ('find_lsb', 'value') => ('ufind_msb', ('u2u32', ('iand', 'value', ('ineg', 'value'))))
 *    ('extract_i8', 'a', 'b@32') => ('ishr', ('ishl', 'a', ('imul', ('isub', 3, 'b'), 8)), 24)
 *    ('extract_u8', 'a', 'b@32') => ('iand', ('ushr', 'a', ('imul', 'b', 8)), 255)
 *    ('extract_i16', 'a', 'b@32') => ('ishr', ('ishl', 'a', ('imul', ('isub', 1, 'b'), 16)), 16)
 *    ('extract_u16', 'a', 'b@32') => ('iand', ('ushr', 'a', ('imul', 'b', 16)), 65535)
 *    ('pack_unorm_2x16', 'v') => ('pack_uvec2_to_uint', ('f2u32', ('fround_even', ('fmul', ('fsat', 'v'), 65535.0))))
 *    ('pack_unorm_4x8', 'v') => ('pack_uvec4_to_uint', ('f2u32', ('fround_even', ('fmul', ('fsat', 'v'), 255.0))))
 *    ('pack_snorm_2x16', 'v') => ('pack_uvec2_to_uint', ('f2i32', ('fround_even', ('fmul', ('fmin', 1.0, ('fmax', -1.0, 'v')), 32767.0))))
 *    ('pack_snorm_4x8', 'v') => ('pack_uvec4_to_uint', ('f2i32', ('fround_even', ('fmul', ('fmin', 1.0, ('fmax', -1.0, 'v')), 127.0))))
 *    ('unpack_unorm_2x16', 'v') => ('fdiv', ('u2f32', ('vec2', ('extract_u16', 'v', 0), ('extract_u16', 'v', 1))), 65535.0)
 *    ('unpack_unorm_4x8', 'v') => ('fdiv', ('u2f32', ('vec4', ('extract_u8', 'v', 0), ('extract_u8', 'v', 1), ('extract_u8', 'v', 2), ('extract_u8', 'v', 3))), 255.0)
 *    ('unpack_snorm_2x16', 'v') => ('fmin', 1.0, ('fmax', -1.0, ('fdiv', ('i2f', ('vec2', ('extract_i16', 'v', 0), ('extract_i16', 'v', 1))), 32767.0)))
 *    ('unpack_snorm_4x8', 'v') => ('fmin', 1.0, ('fmax', -1.0, ('fdiv', ('i2f', ('vec4', ('extract_i8', 'v', 0), ('extract_i8', 'v', 1), ('extract_i8', 'v', 2), ('extract_i8', 'v', 3))), 127.0)))
 *    ('pack_half_2x16_split', 'a@32', 'b@32') => ('ior', ('ishl', ('u2u32', ('f2f16', 'b')), 16), ('u2u32', ('f2f16', 'a')))
 *    ('unpack_half_2x16_split_x', 'a@32') => ('f2f32', ('u2u16', 'a'))
 *    ('unpack_half_2x16_split_y', 'a@32') => ('f2f32', ('u2u16', ('ushr', 'a', 16)))
 *    ('isign', 'a') => ('imin', ('imax', 'a', -1), 1)
 *    ('imin', ('imax', 'a', -1), 1) => ('isign', 'a')
 *    ('imax', ('imin', 'a', 1), -1) => ('isign', 'a')
 *    ('fsign', 'a') => ('fsub', ('b2f', ('!flt', 0.0, 'a')), ('b2f', ('!flt', 'a', 0.0)))
 *    ('fsign', 'a@64') => ('fsub', ('b2f', ('!flt', 0.0, 'a')), ('b2f', ('!flt', 'a', 0.0)))
 *    ('amul', 'a', 'b') => ('imul', 'a', 'b')
 *    ('umul24', 'a', 'b') => ('imul', ('iand', 'a', 16777215), ('iand', 'b', 16777215))
 *    ('umad24', 'a', 'b', 'c') => ('iadd', ('imul', ('iand', 'a', 16777215), ('iand', 'b', 16777215)), 'c')
 *    ('imul24_relaxed', 'a', 'b') => ('imul24', 'a', 'b')
 *    ('imul24_relaxed', 'a', 'b') => ('imul', 'a', 'b')
 *    ('umad24_relaxed', 'a', 'b', 'c') => ('umad24', 'a', 'b', 'c')
 *    ('umad24_relaxed', 'a', 'b', 'c') => ('iadd', ('umul24_relaxed', 'a', 'b'), 'c')
 *    ('umul24_relaxed', 'a', 'b') => ('umul24', 'a', 'b')
 *    ('umul24_relaxed', 'a', 'b') => ('imul', 'a', 'b')
 *    ('imad24_ir3', 'a', 'b', 0) => ('imul24', 'a', 'b')
 *    ('imad24_ir3', 'a', 0, 'c') => c
 *    ('imad24_ir3', 'a', 1, 'c') => ('iadd', 'a', 'c')
 *    ('imad24_ir3', '#a', '#b', 'c') => ('iadd', ('imul', 'a', 'b'), 'c')
 *    ('imul24', 'a', '#b@32(is_pos_power_of_two)') => ('ishl', 'a', ('find_lsb', 'b'))
 *    ('imul24', 'a', '#b@32(is_neg_power_of_two)') => ('ineg', ('ishl', 'a', ('find_lsb', ('iabs', 'b'))))
 *    ('imul24', 'a', 0) => 0
 *    ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd@8', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('uge', ('iadd', 'a', 'b'), 'a'), ('iadd@8', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('uadd_carry', 'a', 'b'), 0), ('iadd@8', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('uadd_carry', 'a', 'b'), 0), -1, ('iadd@8', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd@16', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('uge', ('iadd', 'a', 'b'), 'a'), ('iadd@16', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('uadd_carry', 'a', 'b'), 0), ('iadd@16', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('uadd_carry', 'a', 'b'), 0), -1, ('iadd@16', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd@32', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('uge', ('iadd', 'a', 'b'), 'a'), ('iadd@32', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('uadd_carry', 'a', 'b'), 0), ('iadd@32', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('uadd_carry', 'a', 'b'), 0), -1, ('iadd@32', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd@64', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('uge', ('iadd', 'a', 'b'), 'a'), ('iadd@64', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('uadd_carry', 'a', 'b'), 0), ('iadd@64', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('uadd_carry', 'a', 'b'), 0), -1, ('iadd@64', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ult', 'a', 'b'), 0, ('iadd@8', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('uge', 'a', 'b'), ('iadd@8', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('usub_borrow', 'a', 'b'), 0), ('iadd@8', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('usub_borrow', 'a', 'b'), 0), 0, ('iadd@8', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ult', 'a', 'b'), 0, ('iadd@16', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('uge', 'a', 'b'), ('iadd@16', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('usub_borrow', 'a', 'b'), 0), ('iadd@16', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('usub_borrow', 'a', 'b'), 0), 0, ('iadd@16', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ult', 'a', 'b'), 0, ('iadd@32', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('uge', 'a', 'b'), ('iadd@32', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('usub_borrow', 'a', 'b'), 0), ('iadd@32', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('usub_borrow', 'a', 'b'), 0), 0, ('iadd@32', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ult', 'a', 'b'), 0, ('iadd@64', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('uge', 'a', 'b'), ('iadd@64', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('usub_borrow', 'a', 'b'), 0), ('iadd@64', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('usub_borrow', 'a', 'b'), 0), 0, ('iadd@64', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('iadd_sat@8', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 127, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 128, ('iadd', 'a', 'b')))
 *    ('isub_sat@8', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 127, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 128, ('isub', 'a', 'b')))
 *    ('iadd_sat@16', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 32767, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 32768, ('iadd', 'a', 'b')))
 *    ('isub_sat@16', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 32767, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 32768, ('isub', 'a', 'b')))
 *    ('iadd_sat@32', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 2147483647, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 2147483648, ('iadd', 'a', 'b')))
 *    ('isub_sat@32', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 2147483647, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 2147483648, ('isub', 'a', 'b')))
 *    ('iadd_sat@64', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 9223372036854775807, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 9223372036854775808, ('iadd', 'a', 'b')))
 *    ('isub_sat@64', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 9223372036854775807, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 9223372036854775808, ('isub', 'a', 'b')))
 *    ('inot', ('ior(is_used_once)', ('feq', 'a', 'b'), ('feq', 'c', 'd'))) => ('iand', ('fneu', 'a', 'b'), ('fneu', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('feq', 'a', 'b'), ('feq', 'c', 'd'))) => ('ior', ('fneu', 'a', 'b'), ('fneu', 'c', 'd'))
 *    ('inot', ('ior(is_used_once)', ('feq', 'a', 'b'), ('fneu', 'c', 'd'))) => ('iand', ('fneu', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('feq', 'a', 'b'), ('fneu', 'c', 'd'))) => ('ior', ('fneu', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('inot', ('ior(is_used_once)', ('fneu', 'a', 'b'), ('fneu', 'c', 'd'))) => ('iand', ('feq', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('fneu', 'a', 'b'), ('fneu', 'c', 'd'))) => ('ior', ('feq', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('f2f', ('b2f', 'a')) => ('b2f', 'a')
 *    ('f2u', ('b2f', 'a')) => ('b2i', 'a')
 *    ('f2i', ('b2f', 'a')) => ('b2i', 'a')
 *    ('u2f', ('b2i', 'a')) => ('b2f', 'a')
 *    ('u2u', ('b2i', 'a')) => ('b2i', 'a')
 *    ('i2f', ('b2i', 'a')) => ('b2f', 'a')
 *    ('i2i', ('b2i', 'a')) => ('b2i', 'a')
 *    ('i2i1', 'a@1') => a
 *    ('i2i8', 'a@8') => a
 *    ('i2i16', 'a@16') => a
 *    ('i2i32', 'a@32') => a
 *    ('i2i64', 'a@64') => a
 *    ('u2u1', 'a@1') => a
 *    ('u2u8', 'a@8') => a
 *    ('u2u16', 'a@16') => a
 *    ('u2u32', 'a@32') => a
 *    ('u2u64', 'a@64') => a
 *    ('f2f16', 'a@16') => a
 *    ('f2f32', 'a@32') => a
 *    ('f2f64', 'a@64') => a
 *    ('b2b1', 'a@1') => a
 *    ('b2b8', 'a@8') => a
 *    ('b2b16', 'a@16') => a
 *    ('b2b32', 'a@32') => a
 *    ('i2i1', ('i2i8', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u8', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i8', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u8', 'a')) => ('u2u1', 'a')
 *    ('i2i1', ('i2i16', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u16', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i16', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u16', 'a')) => ('u2u1', 'a')
 *    ('i2i1', ('i2i32', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u32', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i32', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u32', 'a')) => ('u2u1', 'a')
 *    ('i2i1', ('i2i64', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u64', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i64', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u64', 'a')) => ('u2u1', 'a')
 *    ('i2i8', ('i2i1', 'a@1')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u1', 'a@1')) => ('u2u8', 'a')
 *    ('i2i8', ('i2i16', 'a')) => ('i2i8', 'a')
 *    ('i2i8', ('u2u16', 'a')) => ('u2u8', 'a')
 *    ('u2u8', ('i2i16', 'a')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u16', 'a')) => ('u2u8', 'a')
 *    ('i2i8', ('i2i32', 'a')) => ('i2i8', 'a')
 *    ('i2i8', ('u2u32', 'a')) => ('u2u8', 'a')
 *    ('u2u8', ('i2i32', 'a')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u32', 'a')) => ('u2u8', 'a')
 *    ('i2i8', ('i2i64', 'a')) => ('i2i8', 'a')
 *    ('i2i8', ('u2u64', 'a')) => ('u2u8', 'a')
 *    ('u2u8', ('i2i64', 'a')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u64', 'a')) => ('u2u8', 'a')
 *    ('i2i16', ('i2i1', 'a@1')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u1', 'a@1')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i8', 'a@1')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u8', 'a@1')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i8', 'a@8')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u8', 'a@8')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i32', 'a')) => ('i2i16', 'a')
 *    ('i2i16', ('u2u32', 'a')) => ('u2u16', 'a')
 *    ('u2u16', ('i2i32', 'a')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u32', 'a')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i64', 'a')) => ('i2i16', 'a')
 *    ('i2i16', ('u2u64', 'a')) => ('u2u16', 'a')
 *    ('u2u16', ('i2i64', 'a')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u64', 'a')) => ('u2u16', 'a')
 *    ('i2i32', ('i2i1', 'a@1')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u1', 'a@1')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i8', 'a@1')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u8', 'a@1')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i8', 'a@8')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u8', 'a@8')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i16', 'a@1')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u16', 'a@1')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i16', 'a@8')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u16', 'a@8')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i16', 'a@16')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u16', 'a@16')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i64', 'a')) => ('i2i32', 'a')
 *    ('i2i32', ('u2u64', 'a')) => ('u2u32', 'a')
 *    ('u2u32', ('i2i64', 'a')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u64', 'a')) => ('u2u32', 'a')
 *    ('i2i64', ('i2i1', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u1', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i8', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u8', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i8', 'a@8')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u8', 'a@8')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i16', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u16', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i16', 'a@8')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u16', 'a@8')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i16', 'a@16')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u16', 'a@16')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@8')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@8')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@16')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@16')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@32')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@32')) => ('u2u64', 'a')
 *    ('i2i8', ('pack_64_2x32_split', 'a', 'b')) => ('i2i8', 'a')
 *    ('i2i8', ('pack_64_2x32_split', 'a', 'b')) => ('i2i8', 'a')
 *    ('i2i16', ('pack_64_2x32_split', 'a', 'b')) => ('i2i16', 'a')
 *    ('i2i16', ('pack_64_2x32_split', 'a', 'b')) => ('i2i16', 'a')
 *    ('i2i32', ('pack_64_2x32_split', 'a', 'b')) => ('i2i32', 'a')
 *    ('i2i32', ('pack_64_2x32_split', 'a', 'b')) => ('i2i32', 'a')
 *    ('u2u8', ('pack_64_2x32_split', 'a', 'b')) => ('u2u8', 'a')
 *    ('u2u8', ('pack_64_2x32_split', 'a', 'b')) => ('u2u8', 'a')
 *    ('u2u16', ('pack_64_2x32_split', 'a', 'b')) => ('u2u16', 'a')
 *    ('u2u16', ('pack_64_2x32_split', 'a', 'b')) => ('u2u16', 'a')
 *    ('u2u32', ('pack_64_2x32_split', 'a', 'b')) => ('u2u32', 'a')
 *    ('u2u32', ('pack_64_2x32_split', 'a', 'b')) => ('u2u32', 'a')
 *    ('ieq', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ieq', 'a', ('i2i8', 'b'))
 *    ('ine', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ine', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ige', 'a', ('i2i8', 'b'))
 *    ('ilt', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ilt', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i16', 'b@8'), ('i2i16', 'a@8')) => ('ige', ('i2i8', 'b'), 'a')
 *    ('ilt', ('i2i16', 'b@8'), ('i2i16', 'a@8')) => ('ilt', ('i2i8', 'b'), 'a')
 *    ('ieq', ('i2i16', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('i2i8', 'b')), ('ieq', ('i2i16', ('i2i8', 'b')), 'b'))
 *    ('ine', ('i2i16', 'a@8'), '#b') => ('ior', ('ine', 'a', ('i2i8', 'b')), ('ine', ('i2i16', ('i2i8', 'b')), 'b'))
 *    ('ilt', ('i2i16', 'a@8'), '#b') => ('iand', ('ilt', -128, 'b'), ('ior', ('ilt', 127, 'b'), ('ilt', 'a', ('i2i8', 'b'))))
 *    ('ilt', '#a', ('i2i16', 'b@8')) => ('iand', ('ilt', 'a', 127), ('ior', ('ilt', 'a', -128), ('ilt', ('i2i8', 'a'), 'b')))
 *    ('ige', ('i2i16', 'a@8'), '#b') => ('iand', ('ige', 127, 'b'), ('ior', ('ige', -128, 'b'), ('ige', 'a', ('i2i8', 'b'))))
 *    ('ige', '#a', ('i2i16', 'b@8')) => ('iand', ('ige', 'a', -128), ('ior', ('ige', 'a', 127), ('ige', ('i2i8', 'a'), 'b')))
 *    ('ieq', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ieq', 'a', ('i2i8', 'b'))
 *    ('ine', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ine', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ige', 'a', ('i2i8', 'b'))
 *    ('ilt', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ilt', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i32', 'b@8'), ('i2i32', 'a@8')) => ('ige', ('i2i8', 'b'), 'a')
 *    ('ilt', ('i2i32', 'b@8'), ('i2i32', 'a@8')) => ('ilt', ('i2i8', 'b'), 'a')
 *    ('ieq', ('i2i32', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('i2i8', 'b')), ('ieq', ('i2i32', ('i2i8', 'b')), 'b'))
 *    ('ine', ('i2i32', 'a@8'), '#b') => ('ior', ('ine', 'a', ('i2i8', 'b')), ('ine', ('i2i32', ('i2i8', 'b')), 'b'))
 *    ('ilt', ('i2i32', 'a@8'), '#b') => ('iand', ('ilt', -128, 'b'), ('ior', ('ilt', 127, 'b'), ('ilt', 'a', ('i2i8', 'b'))))
 *    ('ilt', '#a', ('i2i32', 'b@8')) => ('iand', ('ilt', 'a', 127), ('ior', ('ilt', 'a', -128), ('ilt', ('i2i8', 'a'), 'b')))
 *    ('ige', ('i2i32', 'a@8'), '#b') => ('iand', ('ige', 127, 'b'), ('ior', ('ige', -128, 'b'), ('ige', 'a', ('i2i8', 'b'))))
 *    ('ige', '#a', ('i2i32', 'b@8')) => ('iand', ('ige', 'a', -128), ('ior', ('ige', 'a', 127), ('ige', ('i2i8', 'a'), 'b')))
 *    ('ieq', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ieq', 'a', ('i2i8', 'b'))
 *    ('ine', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ine', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ige', 'a', ('i2i8', 'b'))
 *    ('ilt', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ilt', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i64', 'b@8'), ('i2i64', 'a@8')) => ('ige', ('i2i8', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@8'), ('i2i64', 'a@8')) => ('ilt', ('i2i8', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('i2i8', 'b')), ('ieq', ('i2i64', ('i2i8', 'b')), 'b'))
 *    ('ine', ('i2i64', 'a@8'), '#b') => ('ior', ('ine', 'a', ('i2i8', 'b')), ('ine', ('i2i64', ('i2i8', 'b')), 'b'))
 *    ('ilt', ('i2i64', 'a@8'), '#b') => ('iand', ('ilt', -128, 'b'), ('ior', ('ilt', 127, 'b'), ('ilt', 'a', ('i2i8', 'b'))))
 *    ('ilt', '#a', ('i2i64', 'b@8')) => ('iand', ('ilt', 'a', 127), ('ior', ('ilt', 'a', -128), ('ilt', ('i2i8', 'a'), 'b')))
 *    ('ige', ('i2i64', 'a@8'), '#b') => ('iand', ('ige', 127, 'b'), ('ior', ('ige', -128, 'b'), ('ige', 'a', ('i2i8', 'b'))))
 *    ('ige', '#a', ('i2i64', 'b@8')) => ('iand', ('ige', 'a', -128), ('ior', ('ige', 'a', 127), ('ige', ('i2i8', 'a'), 'b')))
 *    ('ieq', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'b@8'), ('i2i32', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i32', 'b@8'), ('i2i32', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'b@16'), ('i2i32', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i32', 'b@16'), ('i2i32', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i32', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('i2i16', 'b')), ('ieq', ('i2i32', ('i2i16', 'b')), 'b'))
 *    ('ine', ('i2i32', 'a@16'), '#b') => ('ior', ('ine', 'a', ('i2i16', 'b')), ('ine', ('i2i32', ('i2i16', 'b')), 'b'))
 *    ('ilt', ('i2i32', 'a@16'), '#b') => ('iand', ('ilt', -32768, 'b'), ('ior', ('ilt', 32767, 'b'), ('ilt', 'a', ('i2i16', 'b'))))
 *    ('ilt', '#a', ('i2i32', 'b@16')) => ('iand', ('ilt', 'a', 32767), ('ior', ('ilt', 'a', -32768), ('ilt', ('i2i16', 'a'), 'b')))
 *    ('ige', ('i2i32', 'a@16'), '#b') => ('iand', ('ige', 32767, 'b'), ('ior', ('ige', -32768, 'b'), ('ige', 'a', ('i2i16', 'b'))))
 *    ('ige', '#a', ('i2i32', 'b@16')) => ('iand', ('ige', 'a', -32768), ('ior', ('ige', 'a', 32767), ('ige', ('i2i16', 'a'), 'b')))
 *    ('ieq', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'b@8'), ('i2i64', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@8'), ('i2i64', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'b@16'), ('i2i64', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@16'), ('i2i64', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('i2i16', 'b')), ('ieq', ('i2i64', ('i2i16', 'b')), 'b'))
 *    ('ine', ('i2i64', 'a@16'), '#b') => ('ior', ('ine', 'a', ('i2i16', 'b')), ('ine', ('i2i64', ('i2i16', 'b')), 'b'))
 *    ('ilt', ('i2i64', 'a@16'), '#b') => ('iand', ('ilt', -32768, 'b'), ('ior', ('ilt', 32767, 'b'), ('ilt', 'a', ('i2i16', 'b'))))
 *    ('ilt', '#a', ('i2i64', 'b@16')) => ('iand', ('ilt', 'a', 32767), ('ior', ('ilt', 'a', -32768), ('ilt', ('i2i16', 'a'), 'b')))
 *    ('ige', ('i2i64', 'a@16'), '#b') => ('iand', ('ige', 32767, 'b'), ('ior', ('ige', -32768, 'b'), ('ige', 'a', ('i2i16', 'b'))))
 *    ('ige', '#a', ('i2i64', 'b@16')) => ('iand', ('ige', 'a', -32768), ('ior', ('ige', 'a', 32767), ('ige', ('i2i16', 'a'), 'b')))
 *    ('ieq', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ieq', 'a', ('i2i32', 'b'))
 *    ('ine', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ine', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ige', 'a', ('i2i32', 'b'))
 *    ('ilt', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ilt', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'b@8'), ('i2i64', 'a@32')) => ('ige', ('i2i32', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@8'), ('i2i64', 'a@32')) => ('ilt', ('i2i32', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ieq', 'a', ('i2i32', 'b'))
 *    ('ine', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ine', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ige', 'a', ('i2i32', 'b'))
 *    ('ilt', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ilt', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'b@16'), ('i2i64', 'a@32')) => ('ige', ('i2i32', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@16'), ('i2i64', 'a@32')) => ('ilt', ('i2i32', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ieq', 'a', ('i2i32', 'b'))
 *    ('ine', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ine', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ige', 'a', ('i2i32', 'b'))
 *    ('ilt', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ilt', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'b@32'), ('i2i64', 'a@32')) => ('ige', ('i2i32', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@32'), ('i2i64', 'a@32')) => ('ilt', ('i2i32', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@32'), '#b') => ('iand', ('ieq', 'a', ('i2i32', 'b')), ('ieq', ('i2i64', ('i2i32', 'b')), 'b'))
 *    ('ine', ('i2i64', 'a@32'), '#b') => ('ior', ('ine', 'a', ('i2i32', 'b')), ('ine', ('i2i64', ('i2i32', 'b')), 'b'))
 *    ('ilt', ('i2i64', 'a@32'), '#b') => ('iand', ('ilt', -2147483648, 'b'), ('ior', ('ilt', 2147483647, 'b'), ('ilt', 'a', ('i2i32', 'b'))))
 *    ('ilt', '#a', ('i2i64', 'b@32')) => ('iand', ('ilt', 'a', 2147483647), ('ior', ('ilt', 'a', -2147483648), ('ilt', ('i2i32', 'a'), 'b')))
 *    ('ige', ('i2i64', 'a@32'), '#b') => ('iand', ('ige', 2147483647, 'b'), ('ior', ('ige', -2147483648, 'b'), ('ige', 'a', ('i2i32', 'b'))))
 *    ('ige', '#a', ('i2i64', 'b@32')) => ('iand', ('ige', 'a', -2147483648), ('ior', ('ige', 'a', 2147483647), ('ige', ('i2i32', 'a'), 'b')))
 *    ('ieq', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('ieq', 'a', ('u2u8', 'b'))
 *    ('ine', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('ine', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('uge', 'a', ('u2u8', 'b'))
 *    ('ult', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('ult', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u16', 'b@8'), ('u2u16', 'a@8')) => ('uge', ('u2u8', 'b'), 'a')
 *    ('ult', ('u2u16', 'b@8'), ('u2u16', 'a@8')) => ('ult', ('u2u8', 'b'), 'a')
 *    ('ieq', ('u2u16', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('u2u8', 'b')), ('ieq', ('u2u16', ('u2u8', 'b')), 'b'))
 *    ('ine', ('u2u16', 'a@8'), '#b') => ('ior', ('ine', 'a', ('u2u8', 'b')), ('ine', ('u2u16', ('u2u8', 'b')), 'b'))
 *    ('ult', ('u2u16', 'a@8'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 255, 'b'), ('ult', 'a', ('u2u8', 'b'))))
 *    ('ult', '#a', ('u2u16', 'b@8')) => ('iand', ('ult', 'a', 255), ('ior', ('ult', 'a', 0), ('ult', ('u2u8', 'a'), 'b')))
 *    ('uge', ('u2u16', 'a@8'), '#b') => ('iand', ('uge', 255, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u8', 'b'))))
 *    ('uge', '#a', ('u2u16', 'b@8')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 255), ('uge', ('u2u8', 'a'), 'b')))
 *    ('ieq', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('ieq', 'a', ('u2u8', 'b'))
 *    ('ine', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('ine', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('uge', 'a', ('u2u8', 'b'))
 *    ('ult', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('ult', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u32', 'b@8'), ('u2u32', 'a@8')) => ('uge', ('u2u8', 'b'), 'a')
 *    ('ult', ('u2u32', 'b@8'), ('u2u32', 'a@8')) => ('ult', ('u2u8', 'b'), 'a')
 *    ('ieq', ('u2u32', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('u2u8', 'b')), ('ieq', ('u2u32', ('u2u8', 'b')), 'b'))
 *    ('ine', ('u2u32', 'a@8'), '#b') => ('ior', ('ine', 'a', ('u2u8', 'b')), ('ine', ('u2u32', ('u2u8', 'b')), 'b'))
 *    ('ult', ('u2u32', 'a@8'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 255, 'b'), ('ult', 'a', ('u2u8', 'b'))))
 *    ('ult', '#a', ('u2u32', 'b@8')) => ('iand', ('ult', 'a', 255), ('ior', ('ult', 'a', 0), ('ult', ('u2u8', 'a'), 'b')))
 *    ('uge', ('u2u32', 'a@8'), '#b') => ('iand', ('uge', 255, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u8', 'b'))))
 *    ('uge', '#a', ('u2u32', 'b@8')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 255), ('uge', ('u2u8', 'a'), 'b')))
 *    ('ieq', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('ieq', 'a', ('u2u8', 'b'))
 *    ('ine', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('ine', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('uge', 'a', ('u2u8', 'b'))
 *    ('ult', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('ult', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u64', 'b@8'), ('u2u64', 'a@8')) => ('uge', ('u2u8', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@8'), ('u2u64', 'a@8')) => ('ult', ('u2u8', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('u2u8', 'b')), ('ieq', ('u2u64', ('u2u8', 'b')), 'b'))
 *    ('ine', ('u2u64', 'a@8'), '#b') => ('ior', ('ine', 'a', ('u2u8', 'b')), ('ine', ('u2u64', ('u2u8', 'b')), 'b'))
 *    ('ult', ('u2u64', 'a@8'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 255, 'b'), ('ult', 'a', ('u2u8', 'b'))))
 *    ('ult', '#a', ('u2u64', 'b@8')) => ('iand', ('ult', 'a', 255), ('ior', ('ult', 'a', 0), ('ult', ('u2u8', 'a'), 'b')))
 *    ('uge', ('u2u64', 'a@8'), '#b') => ('iand', ('uge', 255, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u8', 'b'))))
 *    ('uge', '#a', ('u2u64', 'b@8')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 255), ('uge', ('u2u8', 'a'), 'b')))
 *    ('ieq', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'b@8'), ('u2u32', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u32', 'b@8'), ('u2u32', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'b@16'), ('u2u32', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u32', 'b@16'), ('u2u32', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u32', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('u2u16', 'b')), ('ieq', ('u2u32', ('u2u16', 'b')), 'b'))
 *    ('ine', ('u2u32', 'a@16'), '#b') => ('ior', ('ine', 'a', ('u2u16', 'b')), ('ine', ('u2u32', ('u2u16', 'b')), 'b'))
 *    ('ult', ('u2u32', 'a@16'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 65535, 'b'), ('ult', 'a', ('u2u16', 'b'))))
 *    ('ult', '#a', ('u2u32', 'b@16')) => ('iand', ('ult', 'a', 65535), ('ior', ('ult', 'a', 0), ('ult', ('u2u16', 'a'), 'b')))
 *    ('uge', ('u2u32', 'a@16'), '#b') => ('iand', ('uge', 65535, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u16', 'b'))))
 *    ('uge', '#a', ('u2u32', 'b@16')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 65535), ('uge', ('u2u16', 'a'), 'b')))
 *    ('ieq', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'b@8'), ('u2u64', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@8'), ('u2u64', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'b@16'), ('u2u64', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@16'), ('u2u64', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('u2u16', 'b')), ('ieq', ('u2u64', ('u2u16', 'b')), 'b'))
 *    ('ine', ('u2u64', 'a@16'), '#b') => ('ior', ('ine', 'a', ('u2u16', 'b')), ('ine', ('u2u64', ('u2u16', 'b')), 'b'))
 *    ('ult', ('u2u64', 'a@16'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 65535, 'b'), ('ult', 'a', ('u2u16', 'b'))))
 *    ('ult', '#a', ('u2u64', 'b@16')) => ('iand', ('ult', 'a', 65535), ('ior', ('ult', 'a', 0), ('ult', ('u2u16', 'a'), 'b')))
 *    ('uge', ('u2u64', 'a@16'), '#b') => ('iand', ('uge', 65535, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u16', 'b'))))
 *    ('uge', '#a', ('u2u64', 'b@16')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 65535), ('uge', ('u2u16', 'a'), 'b')))
 *    ('ieq', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('ieq', 'a', ('u2u32', 'b'))
 *    ('ine', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('ine', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('uge', 'a', ('u2u32', 'b'))
 *    ('ult', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('ult', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'b@8'), ('u2u64', 'a@32')) => ('uge', ('u2u32', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@8'), ('u2u64', 'a@32')) => ('ult', ('u2u32', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('ieq', 'a', ('u2u32', 'b'))
 *    ('ine', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('ine', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('uge', 'a', ('u2u32', 'b'))
 *    ('ult', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('ult', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'b@16'), ('u2u64', 'a@32')) => ('uge', ('u2u32', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@16'), ('u2u64', 'a@32')) => ('ult', ('u2u32', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('ieq', 'a', ('u2u32', 'b'))
 *    ('ine', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('ine', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('uge', 'a', ('u2u32', 'b'))
 *    ('ult', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('ult', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'b@32'), ('u2u64', 'a@32')) => ('uge', ('u2u32', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@32'), ('u2u64', 'a@32')) => ('ult', ('u2u32', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@32'), '#b') => ('iand', ('ieq', 'a', ('u2u32', 'b')), ('ieq', ('u2u64', ('u2u32', 'b')), 'b'))
 *    ('ine', ('u2u64', 'a@32'), '#b') => ('ior', ('ine', 'a', ('u2u32', 'b')), ('ine', ('u2u64', ('u2u32', 'b')), 'b'))
 *    ('ult', ('u2u64', 'a@32'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 4294967295, 'b'), ('ult', 'a', ('u2u32', 'b'))))
 *    ('ult', '#a', ('u2u64', 'b@32')) => ('iand', ('ult', 'a', 4294967295), ('ior', ('ult', 'a', 0), ('ult', ('u2u32', 'a'), 'b')))
 *    ('uge', ('u2u64', 'a@32'), '#b') => ('iand', ('uge', 4294967295, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u32', 'b'))))
 *    ('uge', '#a', ('u2u64', 'b@32')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 4294967295), ('uge', ('u2u32', 'a'), 'b')))
 *    ('feq', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('feq', 'a', ('f2f16', 'b'))
 *    ('fneu', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('fneu', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('fge', 'a', ('f2f16', 'b'))
 *    ('flt', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('flt', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f32', 'b@16'), ('f2f32', 'a@16')) => ('fge', ('f2f16', 'b'), 'a')
 *    ('flt', ('f2f32', 'b@16'), ('f2f32', 'a@16')) => ('flt', ('f2f16', 'b'), 'a')
 *    ('feq', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('feq', 'a', ('f2f16', 'b'))
 *    ('fneu', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('fneu', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('fge', 'a', ('f2f16', 'b'))
 *    ('flt', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('flt', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f64', 'b@16'), ('f2f64', 'a@16')) => ('fge', ('f2f16', 'b'), 'a')
 *    ('flt', ('f2f64', 'b@16'), ('f2f64', 'a@16')) => ('flt', ('f2f16', 'b'), 'a')
 *    ('feq', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('feq', 'a', ('f2f32', 'b'))
 *    ('fneu', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('fneu', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('fge', 'a', ('f2f32', 'b'))
 *    ('flt', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('flt', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'b@16'), ('f2f64', 'a@32')) => ('fge', ('f2f32', 'b'), 'a')
 *    ('flt', ('f2f64', 'b@16'), ('f2f64', 'a@32')) => ('flt', ('f2f32', 'b'), 'a')
 *    ('feq', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('feq', 'a', ('f2f32', 'b'))
 *    ('fneu', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('fneu', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('fge', 'a', ('f2f32', 'b'))
 *    ('flt', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('flt', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'b@32'), ('f2f64', 'a@32')) => ('fge', ('f2f32', 'b'), 'a')
 *    ('flt', ('f2f64', 'b@32'), ('f2f64', 'a@32')) => ('flt', ('f2f32', 'b'), 'a')
 *    ('i2i32', ('iand', 'a@64', 4294967295)) => ('u2u32', 'a')
 *    ('i2i16', ('iand', 'a@32', 65535)) => ('u2u16', 'a')
 *    ('i2i16', ('iand', 'a@64', 65535)) => ('u2u16', 'a')
 *    ('i2i8', ('iand', 'a@16', 255)) => ('u2u8', 'a')
 *    ('i2i8', ('iand', 'a@32', 255)) => ('u2u8', 'a')
 *    ('i2i8', ('iand', 'a@64', 255)) => ('u2u8', 'a')
 *    ('u2u16(only_lower_8_bits_used)', ('u2u8', 'a@16')) => a
 *    ('extract_u8(only_lower_8_bits_used)', 'a@16', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u16', ('u2u8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u16', ('i2i8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_u8', 'a@16', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('ixor', 'a', 'b')
 *    ('i2i16(only_lower_8_bits_used)', ('u2u8', 'a@16')) => a
 *    ('extract_i8(only_lower_8_bits_used)', 'a@16', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i16', ('u2u8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i16', ('i2i8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_i8', 'a@16', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('ixor', 'a', 'b')
 *    ('u2u32(only_lower_8_bits_used)', ('u2u8', 'a@32')) => a
 *    ('extract_u8(only_lower_8_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u32', ('u2u8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u32', ('i2i8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_u8', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('i2i32(only_lower_8_bits_used)', ('u2u8', 'a@32')) => a
 *    ('extract_i8(only_lower_8_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i32', ('u2u8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i32', ('i2i8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_i8', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('u2u32(only_lower_16_bits_used)', ('u2u16', 'a@32')) => a
 *    ('extract_u16(only_lower_16_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('u2u32', ('u2u16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('u2u32', ('i2i16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('extract_u16', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('i2i32(only_lower_16_bits_used)', ('u2u16', 'a@32')) => a
 *    ('extract_i16(only_lower_16_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('i2i32', ('u2u16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('i2i32', ('i2i16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('extract_i16', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('ldexp@16', 'x', 'exp') => ('fmul', ('fmul', 'x', ('i2i16', ('ishl', ('iadd', ('ishr', ('imin', ('imax', 'exp', -30), 30), 1), 15), 10))), ('i2i16', ('ishl', ('iadd', ('isub', ('imin', ('imax', 'exp', -30), 30), ('ishr', ('imin', ('imax', 'exp', -30), 30), 1)), 15), 10)))
 *    ('ldexp@32', 'x', 'exp') => ('fmul', ('fmul', 'x', ('ishl', ('iadd', ('ishr', ('imin', ('imax', 'exp', -254), 254), 1), 127), 23)), ('ishl', ('iadd', ('isub', ('imin', ('imax', 'exp', -254), 254), ('ishr', ('imin', ('imax', 'exp', -254), 254), 1)), 127), 23))
 *    ('ldexp@64', 'x', 'exp') => ('fmul', ('fmul', 'x', ('pack_64_2x32_split', 0, ('ishl', ('iadd', ('ishr', ('imin', ('imax', 'exp', -2046), 2046), 1), 1023), 20))), ('pack_64_2x32_split', 0, ('ishl', ('iadd', ('isub', ('imin', ('imax', 'exp', -2046), 2046), ('ishr', ('imin', ('imax', 'exp', -2046), 2046), 1)), 1023), 20)))
 *    ('ior(many-comm-expr)', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 858993459), 2), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 3435973836), 2)), 1431655765), 1), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 858993459), 2), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 3435973836), 2)), 2863311530), 1)) => ('bitfield_reverse', 'x')
 *    ('ior(many-comm-expr)', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 4042322160), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 252645135)), 8), 4278255360), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 4042322160), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 252645135)), 8), 16711935)) => ('bitfield_reverse', 'x')
 *    ('bcsel', ('iand', ('ine', ('fabs', 'x'), 2139095040), ('ieq', ('iand', ('pack_half_2x16_rtz_split', 'x', 0), 32767), 31744)), ('iadd', ('pack_half_2x16_rtz_split', 'x', 0), 4294967295), ('pack_half_2x16_rtz_split', 'x', 0)) => ('pack_half_2x16_rtz_split', 'x', 0)
 *    ('bcsel', ('iand', ('ine', 'x', 2139095040), ('ieq', ('iand', ('pack_half_2x16_rtz_split', 'x(is_not_negative)', 0), 32767), 31744)), ('iadd', ('pack_half_2x16_rtz_split', 'x(is_not_negative)', 0), 4294967295), ('pack_half_2x16_rtz_split', 'x(is_not_negative)', 0)) => ('pack_half_2x16_rtz_split', 'x', 0)
 *    ('bcsel', ('iand', ('ine', ('fabs', 'x'), 2139095040), ('ieq', ('iand', ('pack_half_2x16_rtz_split', ('fneg', 'x'), 0), 32767), 31744)), ('iadd', ('pack_half_2x16_rtz_split', ('fneg', 'x'), 0), 4294967295), ('pack_half_2x16_rtz_split', ('fneg', 'x'), 0)) => ('pack_half_2x16_rtz_split', ('fneg', 'x'), 0)
 *    ('iadd(many-comm-expr)', ('iadd', ('iadd', ('bcsel', ('ieq', ('extract_u8', 'a@32', 0), 0), 0, ('iabs', ('iadd', ('extract_u8', 'a@32', 0), ('ineg', ('extract_u8', 'b@32', 0))))), ('bcsel', ('ieq', ('extract_u8', 'a@32', 1), 0), 0, ('iabs', ('iadd', ('extract_u8', 'a@32', 1), ('ineg', ('extract_u8', 'b@32', 1)))))), ('bcsel', ('ieq', ('extract_u8', 'a@32', 2), 0), 0, ('iabs', ('iadd', ('extract_u8', 'a@32', 2), ('ineg', ('extract_u8', 'b@32', 2)))))), ('bcsel', ('ieq', ('extract_u8', 'a@32', 3), 0), 0, ('iabs', ('iadd', ('extract_u8', 'a@32', 3), ('ineg', ('extract_u8', 'b@32', 3)))))) => ('msad_4x8', 'a', 'b', 0)
 *    ('iadd', ('msad_4x8', 'a', 'b', 0), 'c') => ('msad_4x8', 'a', 'b', 'c')
 *    ('ball_iequal2', ('ieq', 'a', 'b'), -1) => ('ball_iequal2', 'a', 'b')
 *    ('ball_iequal2', ('feq', 'a', 'b'), -1) => ('ball_fequal2', 'a', 'b')
 *    ('bany_inequal2', ('ine', 'a', 'b'), 0) => ('bany_inequal2', 'a', 'b')
 *    ('bany_inequal2', ('fneu', 'a', 'b'), 0) => ('bany_fnequal2', 'a', 'b')
 *    ('ball_iequal3', ('ieq', 'a', 'b'), -1) => ('ball_iequal3', 'a', 'b')
 *    ('ball_iequal3', ('feq', 'a', 'b'), -1) => ('ball_fequal3', 'a', 'b')
 *    ('bany_inequal3', ('ine', 'a', 'b'), 0) => ('bany_inequal3', 'a', 'b')
 *    ('bany_inequal3', ('fneu', 'a', 'b'), 0) => ('bany_fnequal3', 'a', 'b')
 *    ('ball_iequal4', ('ieq', 'a', 'b'), -1) => ('ball_iequal4', 'a', 'b')
 *    ('ball_iequal4', ('feq', 'a', 'b'), -1) => ('ball_fequal4', 'a', 'b')
 *    ('bany_inequal4', ('ine', 'a', 'b'), 0) => ('bany_inequal4', 'a', 'b')
 *    ('bany_inequal4', ('fneu', 'a', 'b'), 0) => ('bany_fnequal4', 'a', 'b')
 *    ('ball_iequal8', ('ieq', 'a', 'b'), -1) => ('ball_iequal8', 'a', 'b')
 *    ('ball_iequal8', ('feq', 'a', 'b'), -1) => ('ball_fequal8', 'a', 'b')
 *    ('bany_inequal8', ('ine', 'a', 'b'), 0) => ('bany_inequal8', 'a', 'b')
 *    ('bany_inequal8', ('fneu', 'a', 'b'), 0) => ('bany_fnequal8', 'a', 'b')
 *    ('ball_iequal16', ('ieq', 'a', 'b'), -1) => ('ball_iequal16', 'a', 'b')
 *    ('ball_iequal16', ('feq', 'a', 'b'), -1) => ('ball_fequal16', 'a', 'b')
 *    ('bany_inequal16', ('ine', 'a', 'b'), 0) => ('bany_inequal16', 'a', 'b')
 *    ('bany_inequal16', ('fneu', 'a', 'b'), 0) => ('bany_fnequal16', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('flt', 'a', 'b')) => ('!flt', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('flt', 'b', 'a')) => ('!flt', 'b', 'a')
 *    ('iand', ('feq', 'a', 'a'), ('fge', 'a', 'b')) => ('!fge', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('fge', 'b', 'a')) => ('!fge', 'b', 'a')
 *    ('iand', ('feq', 'a', 'a'), ('feq', 'a', 'b')) => ('!feq', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('feq', 'b', 'a')) => ('!feq', 'b', 'a')
 *    ('feq', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('feq', 'b', 'd'), ('feq', 'c', 'd'))
 *    ('fneu', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('fneu', 'b', 'd'), ('fneu', 'c', 'd'))
 *    ('ieq', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ieq', 'b', 'd'), ('ieq', 'c', 'd'))
 *    ('ine', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ine', 'b', 'd'), ('ine', 'c', 'd'))
 *    ('flt', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('flt', 'b', 'd'), ('flt', 'c', 'd'))
 *    ('flt', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('flt', 'd', 'b'), ('flt', 'd', 'c'))
 *    ('fge', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('fge', 'b', 'd'), ('fge', 'c', 'd'))
 *    ('fge', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('fge', 'd', 'b'), ('fge', 'd', 'c'))
 *    ('ilt', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ilt', 'b', 'd'), ('ilt', 'c', 'd'))
 *    ('ilt', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ilt', 'd', 'b'), ('ilt', 'd', 'c'))
 *    ('ige', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ige', 'b', 'd'), ('ige', 'c', 'd'))
 *    ('ige', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ige', 'd', 'b'), ('ige', 'd', 'c'))
 *    ('ult', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ult', 'b', 'd'), ('ult', 'c', 'd'))
 *    ('ult', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ult', 'd', 'b'), ('ult', 'd', 'c'))
 *    ('uge', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('uge', 'b', 'd'), ('uge', 'c', 'd'))
 *    ('uge', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('uge', 'd', 'b'), ('uge', 'd', 'c'))
 *    ('fadd', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fadd', 'b', 'd'), ('fadd', 'c', 'd'))
 *    ('fmul', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fmul', 'b', 'd'), ('fmul', 'c', 'd'))
 *    ('fmulz', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fmulz', 'b', 'd'), ('fmulz', 'c', 'd'))
 *    ('iadd', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('iadd', 'b', 'd'), ('iadd', 'c', 'd'))
 *    ('imul', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('imul', 'b', 'd'), ('imul', 'c', 'd'))
 *    ('fddx', 'a') => 0.0
 *    ('fddx_fine', 'a') => 0.0
 *    ('fddx_coarse', 'a') => 0.0
 *    ('fddy', 'a') => 0.0
 *    ('fddy_fine', 'a') => 0.0
 *    ('fddy_coarse', 'a') => 0.0
 *    ('umul_low', '#a(is_lower_half_zero)', 'b') => 0
 *    ('imadsh_mix16', '#a@32(is_lower_half_zero)', 'b@32', 'c@32') => c
 *    ('imadsh_mix16', 'a@32', '#b@32(is_upper_half_zero)', 'c@32') => c
 *    ('bcsel', 'a', ('flrp(is_used_once)', 'b', 'c', 'd'), ('flrp', 'b', 'c', 'e')) => ('flrp', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('flrp', 'b', 'c', 'd'), ('flrp(is_used_once)', 'b', 'c', 'e')) => ('flrp', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('flrp(is_used_once)', 'b', 'c', 'd'), ('flrp', 'b', 'e', 'd')) => ('flrp', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', ('flrp', 'b', 'c', 'd'), ('flrp(is_used_once)', 'b', 'e', 'd')) => ('flrp', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', ('flrp(is_used_once)', 'b', 'c', 'd'), ('flrp', 'e', 'c', 'd')) => ('flrp', ('bcsel', 'a', 'b', 'e'), 'c', 'd')
 *    ('bcsel', 'a', ('flrp', 'b', 'c', 'd'), ('flrp(is_used_once)', 'e', 'c', 'd')) => ('flrp', ('bcsel', 'a', 'b', 'e'), 'c', 'd')
 *    ('bcsel', 'a', ('fmulz(is_used_once)', 'b', 'c'), ('fmulz', 'b', 'd(is_not_const)')) => ('fmulz', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmulz(is_used_once)', 'b', 'c(is_not_const)'), ('fmulz', 'b', 'd')) => ('fmulz', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmulz', 'b', 'c(is_not_const)'), ('fmulz(is_used_once)', 'b', 'd')) => ('fmulz', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmulz', 'b', 'c'), ('fmulz(is_used_once)', 'b', 'd(is_not_const)')) => ('fmulz', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul(is_used_once)', 'b', 'c'), ('fmul', 'b', 'd(is_not_const)')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul(is_used_once)', 'b', 'c(is_not_const)'), ('fmul', 'b', 'd')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul', 'b', 'c(is_not_const)'), ('fmul(is_used_once)', 'b', 'd')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul', 'b', 'c'), ('fmul(is_used_once)', 'b', 'd(is_not_const)')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd(is_used_once)', 'b', 'c'), ('iadd', 'b', 'd(is_not_const)')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd(is_used_once)', 'b', 'c(is_not_const)'), ('iadd', 'b', 'd')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd', 'b', 'c(is_not_const)'), ('iadd(is_used_once)', 'b', 'd')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd', 'b', 'c'), ('iadd(is_used_once)', 'b', 'd(is_not_const)')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul(is_used_once)', 'b', 'c'), ('imul', 'b', 'd(is_not_const)')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul(is_used_once)', 'b', 'c(is_not_const)'), ('imul', 'b', 'd')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul', 'b', 'c(is_not_const)'), ('imul(is_used_once)', 'b', 'd')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul', 'b', 'c'), ('imul(is_used_once)', 'b', 'd(is_not_const)')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand(is_used_once)', 'b', 'c'), ('iand', 'b', 'd(is_not_const)')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand(is_used_once)', 'b', 'c(is_not_const)'), ('iand', 'b', 'd')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand', 'b', 'c(is_not_const)'), ('iand(is_used_once)', 'b', 'd')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand', 'b', 'c'), ('iand(is_used_once)', 'b', 'd(is_not_const)')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior(is_used_once)', 'b', 'c'), ('ior', 'b', 'd(is_not_const)')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior(is_used_once)', 'b', 'c(is_not_const)'), ('ior', 'b', 'd')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior', 'b', 'c(is_not_const)'), ('ior(is_used_once)', 'b', 'd')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior', 'b', 'c'), ('ior(is_used_once)', 'b', 'd(is_not_const)')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor(is_used_once)', 'b', 'c'), ('ixor', 'b', 'd(is_not_const)')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor(is_used_once)', 'b', 'c(is_not_const)'), ('ixor', 'b', 'd')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor', 'b', 'c(is_not_const)'), ('ixor(is_used_once)', 'b', 'd')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor', 'b', 'c'), ('ixor(is_used_once)', 'b', 'd(is_not_const)')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin(is_used_once)', 'b', 'c'), ('fmin', 'b', 'd(is_not_const)')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin(is_used_once)', 'b', 'c(is_not_const)'), ('fmin', 'b', 'd')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin', 'b', 'c(is_not_const)'), ('fmin(is_used_once)', 'b', 'd')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin', 'b', 'c'), ('fmin(is_used_once)', 'b', 'd(is_not_const)')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax(is_used_once)', 'b', 'c'), ('fmax', 'b', 'd(is_not_const)')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax(is_used_once)', 'b', 'c(is_not_const)'), ('fmax', 'b', 'd')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax', 'b', 'c(is_not_const)'), ('fmax(is_used_once)', 'b', 'd')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax', 'b', 'c'), ('fmax(is_used_once)', 'b', 'd(is_not_const)')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin(is_used_once)', 'b', 'c'), ('imin', 'b', 'd(is_not_const)')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin(is_used_once)', 'b', 'c(is_not_const)'), ('imin', 'b', 'd')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin', 'b', 'c(is_not_const)'), ('imin(is_used_once)', 'b', 'd')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin', 'b', 'c'), ('imin(is_used_once)', 'b', 'd(is_not_const)')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax(is_used_once)', 'b', 'c'), ('imax', 'b', 'd(is_not_const)')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax(is_used_once)', 'b', 'c(is_not_const)'), ('imax', 'b', 'd')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax', 'b', 'c(is_not_const)'), ('imax(is_used_once)', 'b', 'd')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax', 'b', 'c'), ('imax(is_used_once)', 'b', 'd(is_not_const)')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin(is_used_once)', 'b', 'c'), ('umin', 'b', 'd(is_not_const)')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin(is_used_once)', 'b', 'c(is_not_const)'), ('umin', 'b', 'd')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin', 'b', 'c(is_not_const)'), ('umin(is_used_once)', 'b', 'd')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin', 'b', 'c'), ('umin(is_used_once)', 'b', 'd(is_not_const)')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax(is_used_once)', 'b', 'c'), ('umax', 'b', 'd(is_not_const)')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax(is_used_once)', 'b', 'c(is_not_const)'), ('umax', 'b', 'd')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax', 'b', 'c(is_not_const)'), ('umax(is_used_once)', 'b', 'd')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax', 'b', 'c'), ('umax(is_used_once)', 'b', 'd(is_not_const)')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fpow(is_used_once)', 'b', 'c'), ('fpow', 'b', 'd')) => ('fpow', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fpow', 'b', 'c'), ('fpow(is_used_once)', 'b', 'd')) => ('fpow', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fpow(is_used_once)', 'b', 'c'), ('fpow', 'd', 'c')) => ('fpow', ('bcsel', 'a', 'b', 'd'), 'c')
 *    ('bcsel', 'a', ('fpow', 'b', 'c'), ('fpow(is_used_once)', 'd', 'c')) => ('fpow', ('bcsel', 'a', 'b', 'd'), 'c')
 *    ('bcsel', 'c', ('frcp(is_used_once)', 'a'), ('frcp(is_used_once)', 'b')) => ('frcp', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('frsq(is_used_once)', 'a'), ('frsq(is_used_once)', 'b')) => ('frsq', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsqrt(is_used_once)', 'a'), ('fsqrt(is_used_once)', 'b')) => ('fsqrt', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fexp2(is_used_once)', 'a'), ('fexp2(is_used_once)', 'b')) => ('fexp2', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('flog2(is_used_once)', 'a'), ('flog2(is_used_once)', 'b')) => ('flog2', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsign(is_used_once)', 'a'), ('fsign(is_used_once)', 'b')) => ('fsign', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsin(is_used_once)', 'a'), ('fsin(is_used_once)', 'b')) => ('fsin', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fcos(is_used_once)', 'a'), ('fcos(is_used_once)', 'b')) => ('fcos', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsin_amd(is_used_once)', 'a'), ('fsin_amd(is_used_once)', 'b')) => ('fsin_amd', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fcos_amd(is_used_once)', 'a'), ('fcos_amd(is_used_once)', 'b')) => ('fcos_amd', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsin_mdg(is_used_once)', 'a'), ('fsin_mdg(is_used_once)', 'b')) => ('fsin_mdg', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fcos_mdg(is_used_once)', 'a'), ('fcos_mdg(is_used_once)', 'b')) => ('fcos_mdg', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsin_agx(is_used_once)', 'a'), ('fsin_agx(is_used_once)', 'b')) => ('fsin_agx', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fneg(is_used_once)', 'a'), ('fneg(is_used_once)', 'b')) => ('fneg', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fabs(is_used_once)', 'a'), ('fabs(is_used_once)', 'b')) => ('fabs', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsign(is_used_once)', 'a'), ('fsign(is_used_once)', 'b')) => ('fsign', ('bcsel', 'c', 'a', 'b'))
 *    ('ineg', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('ineg', 'a'), ('ineg', 'b'))
 *    ('iabs', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('iabs', 'a'), ('iabs', 'b'))
 *    ('inot', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('inot', 'a'), ('inot', 'b'))
 *    ('isign', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('isign', 'a'), ('isign', 'b'))
 *    ('fisnormal', 'a@16') => ('ult', 4095, ('iadd', ('ishl', 'a', 1), 2048))
 *    ('fisnormal', 'a@32') => ('ult', 33554431, ('iadd', ('ishl', 'a', 1), 16777216))
 *    ('fisnormal', 'a@64') => ('ult', 18014398509481983, ('iadd', ('ishl', 'a', 1), 9007199254740992))
 *    ('fquantize2f16', 'a@32') => ('bcsel', ('!flt', ('!fabs', 'a'), 6.103515625e-05), ('iand', 'a', 2147483648), ('!f2f32', ('!f2f16_rtne', 'a')))
 *    ('bfi', 4294967295, 'a', '#b') => ('iadd', ('ishl', 'a', 0), ('iand', 'b', -4294967296))
 *    ('bfi', 8589934590, 'a', '#b') => ('iadd', ('ishl', 'a', 1), ('iand', 'b', -8589934591))
 *    ('bfi', 17179869180, 'a', '#b') => ('iadd', ('ishl', 'a', 2), ('iand', 'b', -17179869181))
 *    ('bfi', 34359738360, 'a', '#b') => ('iadd', ('ishl', 'a', 3), ('iand', 'b', -34359738361))
 *    ('bfi', 68719476720, 'a', '#b') => ('iadd', ('ishl', 'a', 4), ('iand', 'b', -68719476721))
 *    ('bfi', 137438953440, 'a', '#b') => ('iadd', ('ishl', 'a', 5), ('iand', 'b', -137438953441))
 *    ('bfi', 274877906880, 'a', '#b') => ('iadd', ('ishl', 'a', 6), ('iand', 'b', -274877906881))
 *    ('bfi', 549755813760, 'a', '#b') => ('iadd', ('ishl', 'a', 7), ('iand', 'b', -549755813761))
 *    ('bfi', 1099511627520, 'a', '#b') => ('iadd', ('ishl', 'a', 8), ('iand', 'b', -1099511627521))
 *    ('bfi', 2199023255040, 'a', '#b') => ('iadd', ('ishl', 'a', 9), ('iand', 'b', -2199023255041))
 *    ('bfi', 4398046510080, 'a', '#b') => ('iadd', ('ishl', 'a', 10), ('iand', 'b', -4398046510081))
 *    ('bfi', 8796093020160, 'a', '#b') => ('iadd', ('ishl', 'a', 11), ('iand', 'b', -8796093020161))
 *    ('bfi', 17592186040320, 'a', '#b') => ('iadd', ('ishl', 'a', 12), ('iand', 'b', -17592186040321))
 *    ('bfi', 35184372080640, 'a', '#b') => ('iadd', ('ishl', 'a', 13), ('iand', 'b', -35184372080641))
 *    ('bfi', 70368744161280, 'a', '#b') => ('iadd', ('ishl', 'a', 14), ('iand', 'b', -70368744161281))
 *    ('bfi', 140737488322560, 'a', '#b') => ('iadd', ('ishl', 'a', 15), ('iand', 'b', -140737488322561))
 *    ('bfi', 281474976645120, 'a', '#b') => ('iadd', ('ishl', 'a', 16), ('iand', 'b', -281474976645121))
 *    ('bfi', 562949953290240, 'a', '#b') => ('iadd', ('ishl', 'a', 17), ('iand', 'b', -562949953290241))
 *    ('bfi', 1125899906580480, 'a', '#b') => ('iadd', ('ishl', 'a', 18), ('iand', 'b', -1125899906580481))
 *    ('bfi', 2251799813160960, 'a', '#b') => ('iadd', ('ishl', 'a', 19), ('iand', 'b', -2251799813160961))
 *    ('bfi', 4503599626321920, 'a', '#b') => ('iadd', ('ishl', 'a', 20), ('iand', 'b', -4503599626321921))
 *    ('bfi', 9007199252643840, 'a', '#b') => ('iadd', ('ishl', 'a', 21), ('iand', 'b', -9007199252643841))
 *    ('bfi', 18014398505287680, 'a', '#b') => ('iadd', ('ishl', 'a', 22), ('iand', 'b', -18014398505287681))
 *    ('bfi', 36028797010575360, 'a', '#b') => ('iadd', ('ishl', 'a', 23), ('iand', 'b', -36028797010575361))
 *    ('bfi', 72057594021150720, 'a', '#b') => ('iadd', ('ishl', 'a', 24), ('iand', 'b', -72057594021150721))
 *    ('bfi', 144115188042301440, 'a', '#b') => ('iadd', ('ishl', 'a', 25), ('iand', 'b', -144115188042301441))
 *    ('bfi', 288230376084602880, 'a', '#b') => ('iadd', ('ishl', 'a', 26), ('iand', 'b', -288230376084602881))
 *    ('bfi', 576460752169205760, 'a', '#b') => ('iadd', ('ishl', 'a', 27), ('iand', 'b', -576460752169205761))
 *    ('bfi', 1152921504338411520, 'a', '#b') => ('iadd', ('ishl', 'a', 28), ('iand', 'b', -1152921504338411521))
 *    ('bfi', 2305843008676823040, 'a', '#b') => ('iadd', ('ishl', 'a', 29), ('iand', 'b', -2305843008676823041))
 *    ('bfi', 4611686017353646080, 'a', '#b') => ('iadd', ('ishl', 'a', 30), ('iand', 'b', -4611686017353646081))
 *    ('fadd', '#a(is_nan)', 'b') => nan
 *    ('fadd', 'a', '#b(is_nan)') => nan
 *    ('fdiv', '#a(is_nan)', 'b') => nan
 *    ('fdiv', 'a', '#b(is_nan)') => nan
 *    ('fmod', '#a(is_nan)', 'b') => nan
 *    ('fmod', 'a', '#b(is_nan)') => nan
 *    ('fmul', '#a(is_nan)', 'b') => nan
 *    ('fmul', 'a', '#b(is_nan)') => nan
 *    ('fpow', '#a(is_nan)', 'b') => nan
 *    ('fpow', 'a', '#b(is_nan)') => nan
 *    ('frem', '#a(is_nan)', 'b') => nan
 *    ('frem', 'a', '#b(is_nan)') => nan
 *    ('fsub', '#a(is_nan)', 'b') => nan
 *    ('fsub', 'a', '#b(is_nan)') => nan
 *    ('ffma', '#a(is_nan)', 'b', 'c') => nan
 *    ('ffma', 'a', '#b(is_nan)', 'c') => nan
 *    ('ffma', 'a', 'b', '#c(is_nan)') => nan
 *    ('flrp', '#a(is_nan)', 'b', 'c') => nan
 *    ('flrp', 'a', '#b(is_nan)', 'c') => nan
 *    ('flrp', 'a', 'b', '#c(is_nan)') => nan
 *    ('fmin', '#a(is_nan)', 'b') => b
 *    ('fmax', '#a(is_nan)', 'b') => b
 *    ('ldexp', '#a(is_nan)', 'b') => nan
 *    ('fdot2', '#a(is_any_comp_nan)', 'b') => nan
 *    ('fdot3', '#a(is_any_comp_nan)', 'b') => nan
 *    ('fdot4', '#a(is_any_comp_nan)', 'b') => nan
 *    ('fdot5', '#a(is_any_comp_nan)', 'b') => nan
 *    ('fdot8', '#a(is_any_comp_nan)', 'b') => nan
 *    ('fdot16', '#a(is_any_comp_nan)', 'b') => nan
 *    ('feq', '#a(is_nan)', 'b') => False
 *    ('feq', 'a', '#b(is_nan)') => False
 *    ('fge', '#a(is_nan)', 'b') => False
 *    ('fge', 'a', '#b(is_nan)') => False
 *    ('flt', '#a(is_nan)', 'b') => False
 *    ('flt', 'a', '#b(is_nan)') => False
 *    ('fneu', '#a(is_nan)', 'b') => True
 *    ('seq', '#a(is_nan)', 'b') => 0.0
 *    ('seq', 'a', '#b(is_nan)') => 0.0
 *    ('sge', '#a(is_nan)', 'b') => 0.0
 *    ('sge', 'a', '#b(is_nan)') => 0.0
 *    ('slt', '#a(is_nan)', 'b') => 0.0
 *    ('slt', 'a', '#b(is_nan)') => 0.0
 *    ('sne', '#a(is_nan)', 'b') => 1.0
 *    ('f2f16', ('vec2', 'a@32', 'b@32')) => ('vec2', ('f2f16', 'a'), ('f2f16', 'b'))
 *    ('f2fmp', ('vec2', 'a@32', 'b@32')) => ('vec2', ('f2fmp', 'a'), ('f2fmp', 'b'))
 *    ('u2u16', ('vec2', 'a@32', 'b@32')) => ('vec2', ('u2u16', 'a'), ('u2u16', 'b'))
 *    ('i2i16', ('vec2', 'a@32', 'b@32')) => ('vec2', ('i2i16', 'a'), ('i2i16', 'b'))
 *    ('i2imp', ('vec2', 'a@32', 'b@32')) => ('vec2', ('i2imp', 'a'), ('i2imp', 'b'))
 *    ('f2f16', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('f2f16', 'a'), ('f2f16', 'b'), ('f2f16', 'c'))
 *    ('f2fmp', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('f2fmp', 'a'), ('f2fmp', 'b'), ('f2fmp', 'c'))
 *    ('u2u16', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('u2u16', 'a'), ('u2u16', 'b'), ('u2u16', 'c'))
 *    ('i2i16', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('i2i16', 'a'), ('i2i16', 'b'), ('i2i16', 'c'))
 *    ('i2imp', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('i2imp', 'a'), ('i2imp', 'b'), ('i2imp', 'c'))
 *    ('f2f16', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('f2f16', 'a'), ('f2f16', 'b'), ('f2f16', 'c'), ('f2f16', 'd'))
 *    ('f2fmp', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('f2fmp', 'a'), ('f2fmp', 'b'), ('f2fmp', 'c'), ('f2fmp', 'd'))
 *    ('u2u16', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('u2u16', 'a'), ('u2u16', 'b'), ('u2u16', 'c'), ('u2u16', 'd'))
 *    ('i2i16', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('i2i16', 'a'), ('i2i16', 'b'), ('i2i16', 'c'), ('i2i16', 'd'))
 *    ('i2imp', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('i2imp', 'a'), ('i2imp', 'b'), ('i2imp', 'c'), ('i2imp', 'd'))
 */


static const nir_search_value_union nir_opt_algebraic_values[] = {
   /* ('imul', 'a', '#b(is_pos_power_of_two)') => ('ishl', 'a', ('find_lsb', 'b')) */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      0,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* replace0_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_find_lsb,
      -1, 0,
      { 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 0, 4 },
      -1,
   } },

   /* ('imul', 'a@8', 128) => ('ishl', 'a', 7) */
   { .variable = {
      { nir_search_value_variable, 8 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { 0x80 /* 128 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 6, 7 },
      -1,
   } },

   /* replace1_0 -> 6 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x7 /* 7 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 6, 9 },
      -1,
   } },

   /* ('imul', 'a@16', 32768) => ('ishl', 'a', 15) */
   { .variable = {
      { nir_search_value_variable, 16 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0x8000 /* 32768 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 11, 12 },
      -1,
   } },

   /* replace2_0 -> 11 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xf /* 15 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 11, 14 },
      -1,
   } },

   /* ('imul', 'a@32', 2147483648) => ('ishl', 'a', 31) */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x80000000 /* 2147483648 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 16, 17 },
      -1,
   } },

   /* replace3_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x1f /* 31 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 16, 19 },
      -1,
   } },

   /* ('imul', 'a@64', 9223372036854775808) => ('ishl', 'a', 63) */
   { .variable = {
      { nir_search_value_variable, 64 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0x8000000000000000 /* 9223372036854775808 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 21, 22 },
      -1,
   } },

   /* replace4_0 -> 21 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x3f /* 63 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 21, 24 },
      -1,
   } },

   /* ('imul', 'a', '#b(is_neg_power_of_two)') => ('ineg', ('ishl', 'a', ('find_lsb', ('iabs', 'b')))) */
   /* search5_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 0, 26 },
      -1,
   } },

   /* replace5_0_0 -> 0 in the cache */
   /* replace5_0_1_0_0 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_find_lsb,
      -1, 0,
      { 28 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 0, 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 30 },
      -1,
   } },

   /* ('ishl', 'a', '#b') => ('imul', 'a', ('ishl', 1, 'b')) */
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 32, 33 },
      -1,
   } },

   /* replace6_0 -> 32 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0x1 /* 1 */ },
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 35, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 32, 37 },
      -1,
   } },

   /* ('imul@64', 'a', '#b(is_bitcount2)') => ('iadd', ('ishl', 'a', ('ufind_msb', 'b')), ('ishl', 'a', ('find_lsb', 'b'))) */
   /* search7_0 -> 21 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      1, /* b */
      true,
      nir_type_invalid,
      2,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 21, 39 },
      -1,
   } },

   /* replace7_0_0 -> 21 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ufind_msb,
      -1, 0,
      { 41 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 21, 42 },
      -1,
   } },
   /* replace7_1_0 -> 21 in the cache */
   /* replace7_1_1_0 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_find_lsb,
      -1, 0,
      { 41 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 21, 44 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 43, 45 },
      -1,
   } },

   /* ('unpack_64_2x32_split_x', ('imul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b') */
   /* search8_0_0 -> 16 in the cache */
   /* search8_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_imul_2x32_64,
      0, 1,
      { 16, 36 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_unpack_64_2x32_split_x,
      -1, 1,
      { 47 },
      -1,
   } },

   /* replace8_0 -> 16 in the cache */
   /* replace8_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* ('unpack_64_2x32_split_x', ('umul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b') */
   /* search9_0_0 -> 16 in the cache */
   /* search9_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_umul_2x32_64,
      0, 1,
      { 16, 36 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_unpack_64_2x32_split_x,
      -1, 1,
      { 50 },
      -1,
   } },

   /* replace9_0 -> 16 in the cache */
   /* replace9_1 -> 36 in the cache */
   /* replace9 -> 49 in the cache */

   /* ('imul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('imul_high', 'a', 'b')) */
   /* search10_0 -> 16 in the cache */
   /* search10_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_imul_2x32_64,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* replace10_0_0 -> 16 in the cache */
   /* replace10_0_1 -> 36 in the cache */
   /* replace10_0 -> 49 in the cache */
   /* replace10_1_0 -> 16 in the cache */
   /* replace10_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul_high,
      1, 1,
      { 16, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_pack_64_2x32_split,
      -1, 2,
      { 49, 53 },
      -1,
   } },

   /* ('umul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('umul_high', 'a', 'b')) */
   /* search11_0 -> 16 in the cache */
   /* search11_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_umul_2x32_64,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* replace11_0_0 -> 16 in the cache */
   /* replace11_0_1 -> 36 in the cache */
   /* replace11_0 -> 49 in the cache */
   /* replace11_1_0 -> 16 in the cache */
   /* replace11_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_umul_high,
      1, 1,
      { 16, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_pack_64_2x32_split,
      -1, 2,
      { 49, 56 },
      -1,
   } },

   /* ('udiv', 'a', 1) => a */
   /* search12_0 -> 32 in the cache */
   /* search12_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_udiv,
      -1, 0,
      { 32, 35 },
      -1,
   } },

   /* replace12 -> 32 in the cache */

   /* ('idiv', 'a', 1) => a */
   /* search13_0 -> 32 in the cache */
   /* search13_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_idiv,
      -1, 0,
      { 32, 35 },
      -1,
   } },

   /* replace13 -> 32 in the cache */

   /* ('umod', 'a', 1) => 0 */
   /* search14_0 -> 32 in the cache */
   /* search14_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umod,
      -1, 0,
      { 32, 35 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0x0 /* 0 */ },
   } },

   /* ('imod', 'a', 1) => 0 */
   /* search15_0 -> 32 in the cache */
   /* search15_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imod,
      -1, 0,
      { 32, 35 },
      -1,
   } },

   /* replace15 -> 61 in the cache */

   /* ('imod', 'a', -1) => 0 */
   /* search16_0 -> 32 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { -0x1 /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imod,
      -1, 0,
      { 32, 63 },
      -1,
   } },

   /* replace16 -> 61 in the cache */

   /* ('irem', 'a', 1) => 0 */
   /* search17_0 -> 32 in the cache */
   /* search17_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_irem,
      -1, 0,
      { 32, 35 },
      -1,
   } },

   /* replace17 -> 61 in the cache */

   /* ('irem', 'a', -1) => 0 */
   /* search18_0 -> 32 in the cache */
   /* search18_1 -> 63 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_irem,
      -1, 0,
      { 32, 63 },
      -1,
   } },

   /* replace18 -> 61 in the cache */

   /* ('udiv', 'a', '#b(is_pos_power_of_two)') => ('ushr', 'a', ('find_lsb', 'b')) */
   /* search19_0 -> 0 in the cache */
   /* search19_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_udiv,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* replace19_0 -> 0 in the cache */
   /* replace19_1_0 -> 3 in the cache */
   /* replace19_1 -> 4 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 0, 4 },
      -1,
   } },

   /* ('idiv', 'a', '#b(is_pos_power_of_two)') => ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', 'b'))) */
   /* search20_0 -> 0 in the cache */
   /* search20_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_idiv,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* replace20_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_isign,
      -1, 0,
      { 0 },
      -1,
   } },
   /* replace20_1_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 0 },
      -1,
   } },
   /* replace20_1_1_0 -> 3 in the cache */
   /* replace20_1_1 -> 4 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 71, 4 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 70, 72 },
      -1,
   } },

   /* ('idiv', 'a', '#b(is_neg_power_of_two)') => ('ineg', ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', ('iabs', 'b'))))) */
   /* search21_0 -> 0 in the cache */
   /* search21_1 -> 26 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_idiv,
      -1, 0,
      { 0, 26 },
      -1,
   } },

   /* replace21_0_0_0 -> 0 in the cache */
   /* replace21_0_0 -> 70 in the cache */
   /* replace21_0_1_0_0 -> 0 in the cache */
   /* replace21_0_1_0 -> 71 in the cache */
   /* replace21_0_1_1_0_0 -> 3 in the cache */
   /* replace21_0_1_1_0 -> 28 in the cache */
   /* replace21_0_1_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 71, 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 70, 75 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 1,
      { 76 },
      -1,
   } },

   /* ('umod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1)) */
   /* search22_0 -> 0 in the cache */
   /* search22_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umod,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* replace22_0 -> 0 in the cache */
   /* replace22_1_0 -> 3 in the cache */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_int, { 0x1 /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_isub,
      -1, 0,
      { 3, 79 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 0, 80 },
      -1,
   } },

   /* ('imod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1)) */
   /* search23_0 -> 0 in the cache */
   /* search23_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imod,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* replace23_0 -> 0 in the cache */
   /* replace23_1_0 -> 3 in the cache */
   /* replace23_1_1 -> 79 in the cache */
   /* replace23_1 -> 80 in the cache */
   /* replace23 -> 81 in the cache */

   /* ('imod', 'a', '#b(is_neg_power_of_two)') => ('bcsel', ('ieq', ('ior', 'a', 'b'), 'b'), 0, ('ior', 'a', 'b')) */
   /* search24_0 -> 0 in the cache */
   /* search24_1 -> 26 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imod,
      -1, 0,
      { 0, 26 },
      -1,
   } },

   /* replace24_0_0_0 -> 0 in the cache */
   /* replace24_0_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* replace24_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 84, 3 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_int, { 0x0 /* 0 */ },
   } },
   /* replace24_2_0 -> 0 in the cache */
   /* replace24_2_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      2, 1,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 3,
      { 85, 86, 87 },
      -1,
   } },

   /* ('irem', 'a', '#b(is_pos_power_of_two)') => ('isub', 'a', ('iand', ('bcsel', ('ilt', 'a', 0), ('iadd', 'a', ('isub', 'b', 1)), 'a'), ('ineg', 'b'))) */
   /* search25_0 -> 0 in the cache */
   /* search25_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_irem,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* replace25_0 -> 0 in the cache */
   /* replace25_1_0_0_0 -> 0 in the cache */
   /* replace25_1_0_0_1 -> 86 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 0, 86 },
      -1,
   } },
   /* replace25_1_0_1_0 -> 0 in the cache */
   /* replace25_1_0_1_1_0 -> 3 in the cache */
   /* replace25_1_0_1_1_1 -> 79 in the cache */
   /* replace25_1_0_1_1 -> 80 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 0, 80 },
      -1,
   } },
   /* replace25_1_0_2 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 90, 91, 0 },
      -1,
   } },
   /* replace25_1_1_0 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 92, 93 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_isub,
      -1, 2,
      { 0, 94 },
      -1,
   } },

   /* ('irem', 'a', '#b(is_neg_power_of_two)') => ('irem', 'a', ('iabs', 'b')) */
   /* search26_0 -> 0 in the cache */
   /* search26_1 -> 26 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_irem,
      -1, 0,
      { 0, 26 },
      -1,
   } },

   /* replace26_0 -> 0 in the cache */
   /* replace26_1_0 -> 3 in the cache */
   /* replace26_1 -> 28 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_irem,
      -1, 0,
      { 0, 28 },
      -1,
   } },

   /* ('~fmul', ('fsign', 'a'), ('ffloor', ('fadd', ('fabs', 'a'), 0.5))) => ('ftrunc', ('fadd', 'a', ('fmul', ('fsign', 'a'), 0.5))) */
   /* search27_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsign,
      -1, 0,
      { 32 },
      -1,
   } },
   /* search27_1_0_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 32 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x3fe0000000000000 /* 0.5 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 99, 100 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 1,
      { 101 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 98, 102 },
      -1,
   } },

   /* replace27_0_0 -> 32 in the cache */
   /* replace27_0_1_0_0 -> 32 in the cache */
   /* replace27_0_1_0 -> 98 in the cache */
   /* replace27_0_1_1 -> 100 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 98, 100 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 32, 104 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ftrunc,
      -1, 2,
      { 105 },
      -1,
   } },

   /* ('~fneg', ('fneg', 'a')) => a */
   /* search28_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 107 },
      -1,
   } },

   /* replace28 -> 32 in the cache */

   /* ('ineg', ('ineg', 'a')) => a */
   /* search29_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 109 },
      -1,
   } },

   /* replace29 -> 32 in the cache */

   /* ('fabs', ('fneg', 'a')) => ('fabs', 'a') */
   /* search30_0_0 -> 32 in the cache */
   /* search30_0 -> 107 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 107 },
      -1,
   } },

   /* replace30_0 -> 32 in the cache */
   /* replace30 -> 99 in the cache */

   /* ('fabs', ('u2f', 'a')) => ('u2f', 'a') */
   /* search31_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_u2f,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 112 },
      -1,
   } },

   /* replace31_0 -> 32 in the cache */
   /* replace31 -> 112 in the cache */

   /* ('iabs', ('iabs', 'a')) => ('iabs', 'a') */
   /* search32_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 114 },
      -1,
   } },

   /* replace32_0 -> 32 in the cache */
   /* replace32 -> 114 in the cache */

   /* ('iabs', ('ineg', 'a')) => ('iabs', 'a') */
   /* search33_0_0 -> 32 in the cache */
   /* search33_0 -> 109 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 109 },
      -1,
   } },

   /* replace33_0 -> 32 in the cache */
   /* replace33 -> 114 in the cache */

   /* ('~fadd', 'a', 0.0) => a */
   /* search34_0 -> 32 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x0 /* 0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 32, 117 },
      -1,
   } },

   /* replace34 -> 32 in the cache */

   /* ('fadd(is_only_used_as_float)', 'a@16', 0.0) => a */
   /* search35_0 -> 11 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_float, { 0x0 /* 0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 11, 119 },
      1,
   } },

   /* replace35 -> 11 in the cache */

   /* ('fadd(is_only_used_as_float)', 'a@32', 0.0) => a */
   /* search36_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_float, { 0x0 /* 0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 16, 121 },
      1,
   } },

   /* replace36 -> 16 in the cache */

   /* ('iadd', 'a', 0) => a */
   /* search37_0 -> 32 in the cache */
   /* search37_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* replace37 -> 32 in the cache */

   /* ('iadd_sat', 'a', 0) => a */
   /* search38_0 -> 32 in the cache */
   /* search38_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* replace38 -> 32 in the cache */

   /* ('isub_sat', 'a', 0) => a */
   /* search39_0 -> 32 in the cache */
   /* search39_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_isub_sat,
      -1, 0,
      { 32, 61 },
      -1,
   } },

   /* replace39 -> 32 in the cache */

   /* ('uadd_sat', 'a', 0) => a */
   /* search40_0 -> 32 in the cache */
   /* search40_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_uadd_sat,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* replace40 -> 32 in the cache */

   /* ('usub_sat', 'a', 0) => a */
   /* search41_0 -> 32 in the cache */
   /* search41_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_usub_sat,
      -1, 0,
      { 32, 61 },
      -1,
   } },

   /* replace41 -> 32 in the cache */

   /* ('usadd_4x8_vc4', 'a', 0) => a */
   /* search42_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x0 /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_usadd_4x8_vc4,
      0, 1,
      { 16, 128 },
      -1,
   } },

   /* replace42 -> 16 in the cache */

   /* ('usadd_4x8_vc4', 'a', -1) => -1 */
   /* search43_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { -0x1 /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_usadd_4x8_vc4,
      0, 1,
      { 16, 130 },
      -1,
   } },

   /* replace43 -> 130 in the cache */

   /* ('~fadd', ('fmul', 'a', 'b'), ('fmul', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c')) */
   { .variable = {
      { nir_search_value_variable, -3 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -3 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 132, 133 },
      -1,
   } },
   /* search44_1_0 -> 132 in the cache */
   { .variable = {
      { nir_search_value_variable, -3 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 132, 135 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 134, 136 },
      -1,
   } },

   /* replace44_0 -> 132 in the cache */
   /* replace44_1_0 -> 133 in the cache */
   /* replace44_1_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 133, 135 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 132, 138 },
      -1,
   } },

   /* ('~fadd', ('fmulz', 'a', 'b'), ('fmulz', 'a', 'c')) => ('fmulz', 'a', ('fadd', 'b', 'c')) */
   /* search45_0_0 -> 16 in the cache */
   /* search45_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      1, 1,
      { 16, 36 },
      -1,
   } },
   /* search45_1_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      2, 1,
      { 16, 141 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 140, 142 },
      -1,
   } },

   /* replace45_0 -> 16 in the cache */
   /* replace45_1_0 -> 36 in the cache */
   /* replace45_1_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 36, 141 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 2,
      { 16, 144 },
      -1,
   } },

   /* ('~ffma', 'a', 'b', ('ffma(is_used_once)', 'a', 'c', 'd')) => ('ffma', 'a', ('fadd', 'b', 'c'), 'd') */
   /* search46_0 -> 0 in the cache */
   /* search46_1 -> 3 in the cache */
   /* search46_2_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 0, 146, 147 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 0, 3, 148 },
      -1,
   } },

   /* replace46_0 -> 0 in the cache */
   /* replace46_1_0 -> 3 in the cache */
   /* replace46_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 3, 146 },
      -1,
   } },
   /* replace46_2 -> 147 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 0, 150, 147 },
      -1,
   } },

   /* ('~ffma', 'a', 'b', ('fmul(is_used_once)', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c')) */
   /* search47_0 -> 0 in the cache */
   /* search47_1 -> 3 in the cache */
   /* search47_2_0 -> 0 in the cache */
   /* search47_2_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 0, 146 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 0, 3, 152 },
      -1,
   } },

   /* replace47_0 -> 0 in the cache */
   /* replace47_1_0 -> 3 in the cache */
   /* replace47_1_1 -> 146 in the cache */
   /* replace47_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 0, 150 },
      -1,
   } },

   /* ('~fadd', ('fmul(is_used_once)', 'a', 'b'), ('ffma(is_used_once)', 'a', 'c', 'd')) => ('ffma', 'a', ('fadd', 'b', 'c'), 'd') */
   { .variable = {
      { nir_search_value_variable, -4 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -4 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 155, 156 },
      0,
   } },
   /* search48_1_0 -> 155 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -4 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_ffma,
      2, 1,
      { 155, 158, 159 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 157, 160 },
      -1,
   } },

   /* replace48_0 -> 155 in the cache */
   /* replace48_1_0 -> 156 in the cache */
   /* replace48_1_1 -> 158 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 156, 158 },
      -1,
   } },
   /* replace48_2 -> 159 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 155, 162, 159 },
      -1,
   } },

   /* ('~ffma', 'a', ('fmul(is_used_once)', 'b', 'c'), ('fmul(is_used_once)', 'b', 'd')) => ('fmul', 'b', ('ffma', 'a', 'c', 'd')) */
   /* search49_0 -> 155 in the cache */
   /* search49_1_0 -> 156 in the cache */
   /* search49_1_1 -> 158 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 156, 158 },
      0,
   } },
   /* search49_2_0 -> 156 in the cache */
   /* search49_2_1 -> 159 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 156, 159 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 155, 164, 165 },
      -1,
   } },

   /* replace49_0 -> 156 in the cache */
   /* replace49_1_0 -> 155 in the cache */
   /* replace49_1_1 -> 158 in the cache */
   /* replace49_1_2 -> 159 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 155, 158, 159 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 156, 167 },
      -1,
   } },

   /* ('~ffmaz', 'a', 'b', ('ffmaz(is_used_once)', 'a', 'c', 'd')) => ('ffmaz', 'a', ('fadd', 'b', 'c'), 'd') */
   /* search50_0 -> 16 in the cache */
   /* search50_1 -> 36 in the cache */
   /* search50_2_0 -> 16 in the cache */
   /* search50_2_1 -> 141 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      1, 1,
      { 16, 141, 169 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffmaz,
      0, 2,
      { 16, 36, 170 },
      -1,
   } },

   /* replace50_0 -> 16 in the cache */
   /* replace50_1_0 -> 36 in the cache */
   /* replace50_1_1 -> 141 in the cache */
   /* replace50_1 -> 144 in the cache */
   /* replace50_2 -> 169 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 2,
      { 16, 144, 169 },
      -1,
   } },

   /* ('~ffmaz', 'a', 'b', ('fmulz(is_used_once)', 'a', 'c')) => ('fmulz', 'a', ('fadd', 'b', 'c')) */
   /* search51_0 -> 16 in the cache */
   /* search51_1 -> 36 in the cache */
   /* search51_2_0 -> 16 in the cache */
   /* search51_2_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      1, 1,
      { 16, 141 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffmaz,
      0, 2,
      { 16, 36, 173 },
      -1,
   } },

   /* replace51_0 -> 16 in the cache */
   /* replace51_1_0 -> 36 in the cache */
   /* replace51_1_1 -> 141 in the cache */
   /* replace51_1 -> 144 in the cache */
   /* replace51 -> 145 in the cache */

   /* ('~fadd', ('fmulz(is_used_once)', 'a', 'b'), ('ffmaz(is_used_once)', 'a', 'c', 'd')) => ('ffmaz', 'a', ('fadd', 'b', 'c'), 'd') */
   /* search52_0_0 -> 16 in the cache */
   /* search52_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      1, 1,
      { 16, 36 },
      0,
   } },
   /* search52_1_0 -> 16 in the cache */
   /* search52_1_1 -> 141 in the cache */
   /* search52_1_2 -> 169 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      2, 1,
      { 16, 141, 169 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 175, 176 },
      -1,
   } },

   /* replace52_0 -> 16 in the cache */
   /* replace52_1_0 -> 36 in the cache */
   /* replace52_1_1 -> 141 in the cache */
   /* replace52_1 -> 144 in the cache */
   /* replace52_2 -> 169 in the cache */
   /* replace52 -> 172 in the cache */

   /* ('~ffmaz', 'a', ('fmulz(is_used_once)', 'b', 'c'), ('fmulz(is_used_once)', 'b', 'd')) => ('fmulz', 'b', ('ffmaz', 'a', 'c', 'd')) */
   /* search53_0 -> 16 in the cache */
   /* search53_1_0 -> 36 in the cache */
   /* search53_1_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      1, 1,
      { 36, 141 },
      0,
   } },
   /* search53_2_0 -> 36 in the cache */
   /* search53_2_1 -> 169 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      2, 1,
      { 36, 169 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffmaz,
      0, 3,
      { 16, 178, 179 },
      -1,
   } },

   /* replace53_0 -> 36 in the cache */
   /* replace53_1_0 -> 16 in the cache */
   /* replace53_1_1 -> 141 in the cache */
   /* replace53_1_2 -> 169 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      1, 1,
      { 16, 141, 169 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 2,
      { 36, 181 },
      -1,
   } },

   /* ('iadd', ('imul', 'a', 'b'), ('imul', 'a', 'c')) => ('imul', 'a', ('iadd', 'b', 'c')) */
   /* search54_0_0 -> 132 in the cache */
   /* search54_0_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imul,
      1, 1,
      { 132, 133 },
      -1,
   } },
   /* search54_1_0 -> 132 in the cache */
   /* search54_1_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imul,
      2, 1,
      { 132, 135 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 183, 184 },
      -1,
   } },

   /* replace54_0 -> 132 in the cache */
   /* replace54_1_0 -> 133 in the cache */
   /* replace54_1_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 133, 135 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imul,
      0, 2,
      { 132, 186 },
      -1,
   } },

   /* ('iadd', ('ishl', 'b', 'a'), ('ishl', 'c', 'a')) => ('ishl', ('iadd', 'b', 'c'), 'a') */
   { .variable = {
      { nir_search_value_variable, -3 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 188, 189 },
      -1,
   } },
   /* search55_1_0 -> 135 in the cache */
   /* search55_1_1 -> 189 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 135, 189 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 190, 191 },
      -1,
   } },

   /* replace55_0_0 -> 188 in the cache */
   /* replace55_0_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 188, 135 },
      -1,
   } },
   /* replace55_1 -> 189 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 193, 189 },
      -1,
   } },

   /* ('iand', ('ior', 'a', 'b'), ('ior', 'a', 'c')) => ('ior', 'a', ('iand', 'b', 'c')) */
   /* search56_0_0 -> 132 in the cache */
   /* search56_0_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 132, 133 },
      -1,
   } },
   /* search56_1_0 -> 132 in the cache */
   /* search56_1_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      2, 1,
      { 132, 135 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 195, 196 },
      -1,
   } },

   /* replace56_0 -> 132 in the cache */
   /* replace56_1_0 -> 133 in the cache */
   /* replace56_1_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 133, 135 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 132, 198 },
      -1,
   } },

   /* ('ior', ('iand', 'a', 'b'), ('iand', 'a', 'c')) => ('iand', 'a', ('ior', 'b', 'c')) */
   /* search57_0_0 -> 132 in the cache */
   /* search57_0_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 132, 133 },
      -1,
   } },
   /* search57_1_0 -> 132 in the cache */
   /* search57_1_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 132, 135 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 200, 201 },
      -1,
   } },

   /* replace57_0 -> 132 in the cache */
   /* replace57_1_0 -> 133 in the cache */
   /* replace57_1_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 133, 135 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 132, 203 },
      -1,
   } },

   /* ('ieq', ('iand', 'a', '#b(is_pos_power_of_two)'), 'b') => ('ine', ('iand', 'a', 'b'), 0) */
   /* search58_0_0 -> 0 in the cache */
   /* search58_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* search58_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 205, 3 },
      -1,
   } },

   /* replace58_0_0 -> 0 in the cache */
   /* replace58_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* replace58_1 -> 86 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 207, 86 },
      -1,
   } },

   /* ('ine', ('iand', 'a', '#b(is_pos_power_of_two)'), 'b') => ('ieq', ('iand', 'a', 'b'), 0) */
   /* search59_0_0 -> 0 in the cache */
   /* search59_0_1 -> 1 in the cache */
   /* search59_0 -> 205 in the cache */
   /* search59_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 205, 3 },
      -1,
   } },

   /* replace59_0_0 -> 0 in the cache */
   /* replace59_0_1 -> 3 in the cache */
   /* replace59_0 -> 207 in the cache */
   /* replace59_1 -> 86 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 207, 86 },
      -1,
   } },

   /* ('ieq', ('ushr(is_used_once)', 'a', '#b'), 0) => ('ult', 'a', ('ishl', 1, 'b')) */
   /* search60_0_0 -> 32 in the cache */
   /* search60_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 32, 33 },
      0,
   } },
   /* search60_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 211, 61 },
      -1,
   } },

   /* replace60_0 -> 32 in the cache */
   /* replace60_1_0 -> 35 in the cache */
   /* replace60_1_1 -> 36 in the cache */
   /* replace60_1 -> 37 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 32, 37 },
      -1,
   } },

   /* ('ine', ('ushr(is_used_once)', 'a', '#b'), 0) => ('uge', 'a', ('ishl', 1, 'b')) */
   /* search61_0_0 -> 32 in the cache */
   /* search61_0_1 -> 33 in the cache */
   /* search61_0 -> 211 in the cache */
   /* search61_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 211, 61 },
      -1,
   } },

   /* replace61_0 -> 32 in the cache */
   /* replace61_1_0 -> 35 in the cache */
   /* replace61_1_1 -> 36 in the cache */
   /* replace61_1 -> 37 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 32, 37 },
      -1,
   } },

   /* ('~fadd', ('fneg', 'a'), 'a') => 0.0 */
   /* search62_0_0 -> 32 in the cache */
   /* search62_0 -> 107 in the cache */
   /* search62_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 107, 32 },
      -1,
   } },

   /* replace62 -> 117 in the cache */

   /* ('iadd', ('ineg', 'a'), 'a') => 0 */
   /* search63_0_0 -> 32 in the cache */
   /* search63_0 -> 109 in the cache */
   /* search63_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 109, 32 },
      -1,
   } },

   /* replace63 -> 61 in the cache */

   /* ('iadd', ('ineg', 'a'), ('iadd', 'a', 'b')) => b */
   /* search64_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 0 },
      -1,
   } },
   /* search64_1_0 -> 0 in the cache */
   /* search64_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 218, 219 },
      -1,
   } },

   /* replace64 -> 3 in the cache */

   /* ('iadd', 'a', ('iadd', ('ineg', 'a'), 'b')) => b */
   /* search65_0 -> 0 in the cache */
   /* search65_1_0_0 -> 0 in the cache */
   /* search65_1_0 -> 218 in the cache */
   /* search65_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 218, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 0, 221 },
      -1,
   } },

   /* replace65 -> 3 in the cache */

   /* ('~fadd', ('fneg', 'a'), ('fadd', 'a', 'b')) => b */
   /* search66_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 0 },
      -1,
   } },
   /* search66_1_0 -> 0 in the cache */
   /* search66_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 223, 224 },
      -1,
   } },

   /* replace66 -> 3 in the cache */

   /* ('~fadd', 'a', ('fadd', ('fneg', 'a'), 'b')) => b */
   /* search67_0 -> 0 in the cache */
   /* search67_1_0_0 -> 0 in the cache */
   /* search67_1_0 -> 223 in the cache */
   /* search67_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 223, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 0, 226 },
      -1,
   } },

   /* replace67 -> 3 in the cache */

   /* ('fadd', ('fsat', 'a'), ('fsat', ('fneg', 'a'))) => ('fsat', ('fabs', 'a')) */
   /* search68_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 32 },
      -1,
   } },
   /* search68_1_0_0 -> 32 in the cache */
   /* search68_1_0 -> 107 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 107 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 228, 229 },
      -1,
   } },

   /* replace68_0_0 -> 32 in the cache */
   /* replace68_0 -> 99 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 99 },
      -1,
   } },

   /* ('~fmul', 'a', 0.0) => 0.0 */
   /* search69_0 -> 32 in the cache */
   /* search69_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 32, 117 },
      -1,
   } },

   /* replace69 -> 117 in the cache */

   /* ('fmul', 'a@16', 0.0) => 0.0 */
   /* search70_0 -> 11 in the cache */
   /* search70_1 -> 119 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 11, 119 },
      -1,
   } },

   /* replace70 -> 119 in the cache */

   /* ('fmul', 'a@32', 0.0) => 0.0 */
   /* search71_0 -> 16 in the cache */
   /* search71_1 -> 121 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 16, 121 },
      -1,
   } },

   /* replace71 -> 121 in the cache */

   /* ('fmulz', 'a', 0.0) => 0.0 */
   /* search72_0 -> 16 in the cache */
   /* search72_1 -> 121 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 16, 121 },
      -1,
   } },

   /* replace72 -> 121 in the cache */

   /* ('fmulz', 'a', 'b(is_finite_not_zero)') => ('fmul', 'a', 'b') */
   /* search73_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      3,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 16, 236 },
      -1,
   } },

   /* replace73_0 -> 16 in the cache */
   /* replace73_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* ('fmulz', 'a(is_finite)', 'b(is_finite)') => ('fmul', 'a', 'b') */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_invalid,
      4,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      4,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 239, 240 },
      -1,
   } },

   /* replace74_0 -> 16 in the cache */
   /* replace74_1 -> 36 in the cache */
   /* replace74 -> 238 in the cache */

   /* ('fmulz', 'a', 'a') => ('fmul', 'a', 'a') */
   /* search75_0 -> 16 in the cache */
   /* search75_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      -1, 0,
      { 16, 16 },
      -1,
   } },

   /* replace75_0 -> 16 in the cache */
   /* replace75_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      -1, 0,
      { 16, 16 },
      -1,
   } },

   /* ('ffmaz', 'a', 'b(is_finite_not_zero)', 'c') => ('ffma', 'a', 'b', 'c') */
   /* search76_0 -> 16 in the cache */
   /* search76_1 -> 236 in the cache */
   /* search76_2 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 16, 236, 141 },
      -1,
   } },

   /* replace76_0 -> 16 in the cache */
   /* replace76_1 -> 36 in the cache */
   /* replace76_2 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 16, 36, 141 },
      -1,
   } },

   /* ('ffmaz', 'a(is_finite)', 'b(is_finite)', 'c') => ('ffma', 'a', 'b', 'c') */
   /* search77_0 -> 239 in the cache */
   /* search77_1 -> 240 in the cache */
   /* search77_2 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 239, 240, 141 },
      -1,
   } },

   /* replace77_0 -> 16 in the cache */
   /* replace77_1 -> 36 in the cache */
   /* replace77_2 -> 141 in the cache */
   /* replace77 -> 245 in the cache */

   /* ('ffmaz', 'a', 'a', 'b') => ('ffma', 'a', 'a', 'b') */
   /* search78_0 -> 16 in the cache */
   /* search78_1 -> 16 in the cache */
   /* search78_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      -1, 0,
      { 16, 16, 36 },
      -1,
   } },

   /* replace78_0 -> 16 in the cache */
   /* replace78_1 -> 16 in the cache */
   /* replace78_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffma,
      -1, 0,
      { 16, 16, 36 },
      -1,
   } },

   /* ('imul', 'a', 0) => 0 */
   /* search79_0 -> 32 in the cache */
   /* search79_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* replace79 -> 61 in the cache */

   /* ('umul_unorm_4x8_vc4', 'a', 0) => 0 */
   /* search80_0 -> 16 in the cache */
   /* search80_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_umul_unorm_4x8_vc4,
      0, 1,
      { 16, 128 },
      -1,
   } },

   /* replace80 -> 128 in the cache */

   /* ('umul_unorm_4x8_vc4', 'a', -1) => a */
   /* search81_0 -> 16 in the cache */
   /* search81_1 -> 130 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_umul_unorm_4x8_vc4,
      0, 1,
      { 16, 130 },
      -1,
   } },

   /* replace81 -> 16 in the cache */

   /* ('~fmul', 'a', 1.0) => a */
   /* search82_0 -> 32 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 32, 252 },
      -1,
   } },

   /* replace82 -> 32 in the cache */

   /* ('~fmulz', 'a', 1.0) => a */
   /* search83_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 16, 254 },
      -1,
   } },

   /* replace83 -> 16 in the cache */

   /* ('fmul(is_only_used_as_float)', 'a', 1.0) => a */
   /* search84_0 -> 32 in the cache */
   /* search84_1 -> 252 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 32, 252 },
      1,
   } },

   /* replace84 -> 32 in the cache */

   /* ('imul', 'a', 1) => a */
   /* search85_0 -> 32 in the cache */
   /* search85_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 32, 35 },
      -1,
   } },

   /* replace85 -> 32 in the cache */

   /* ('fmul', 'a', -1.0) => ('fneg', 'a') */
   /* search86_0 -> 32 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0xbff0000000000000 /* -1.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 32, 258 },
      -1,
   } },

   /* replace86_0 -> 32 in the cache */
   /* replace86 -> 107 in the cache */

   /* ('imul', 'a', -1) => ('ineg', 'a') */
   /* search87_0 -> 32 in the cache */
   /* search87_1 -> 63 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 32, 63 },
      -1,
   } },

   /* replace87_0 -> 32 in the cache */
   /* replace87 -> 109 in the cache */

   /* ('fmul', ('fsign', 'a'), ('fmul', 'a', 'a')) => ('fmul', ('fabs', 'a'), 'a') */
   /* search88_0_0 -> 32 in the cache */
   /* search88_0 -> 98 in the cache */
   /* search88_1_0 -> 32 in the cache */
   /* search88_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      -1, 0,
      { 32, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 98, 261 },
      -1,
   } },

   /* replace88_0_0 -> 32 in the cache */
   /* replace88_0 -> 99 in the cache */
   /* replace88_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 99, 32 },
      -1,
   } },

   /* ('fmul', ('fmul', ('fsign', 'a'), 'a'), 'a') => ('fmul', ('fabs', 'a'), 'a') */
   /* search89_0_0_0 -> 32 in the cache */
   /* search89_0_0 -> 98 in the cache */
   /* search89_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 98, 32 },
      -1,
   } },
   /* search89_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 264, 32 },
      -1,
   } },

   /* replace89_0_0 -> 32 in the cache */
   /* replace89_0 -> 99 in the cache */
   /* replace89_1 -> 32 in the cache */
   /* replace89 -> 263 in the cache */

   /* ('~ffma', 0.0, 'a', 'b') => b */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_float, { 0x0 /* 0.0 */ },
   } },
   /* search90_1 -> 0 in the cache */
   /* search90_2 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 266, 0, 3 },
      -1,
   } },

   /* replace90 -> 3 in the cache */

   /* ('ffma@16(is_only_used_as_float)', 0.0, 'a', 'b') => b */
   /* search91_0 -> 119 in the cache */
   /* search91_1 -> 11 in the cache */
   { .variable = {
      { nir_search_value_variable, 16 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 119, 11, 268 },
      1,
   } },

   /* replace91 -> 268 in the cache */

   /* ('ffma@32(is_only_used_as_float)', 0.0, 'a', 'b') => b */
   /* search92_0 -> 121 in the cache */
   /* search92_1 -> 16 in the cache */
   /* search92_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 121, 16, 36 },
      1,
   } },

   /* replace92 -> 36 in the cache */

   /* ('ffmaz', 0.0, 'a', 'b') => ('fadd', 0.0, 'b') */
   /* search93_0 -> 121 in the cache */
   /* search93_1 -> 16 in the cache */
   /* search93_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 121, 16, 36 },
      -1,
   } },

   /* replace93_0 -> 121 in the cache */
   /* replace93_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 121, 36 },
      -1,
   } },

   /* ('~ffma', 'a', 'b', 0.0) => ('fmul', 'a', 'b') */
   /* search94_0 -> 0 in the cache */
   /* search94_1 -> 3 in the cache */
   /* search94_2 -> 266 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 0, 3, 266 },
      -1,
   } },

   /* replace94_0 -> 0 in the cache */
   /* replace94_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('ffma@16', 'a', 'b', 0.0) => ('fmul', 'a', 'b') */
   /* search95_0 -> 11 in the cache */
   /* search95_1 -> 268 in the cache */
   /* search95_2 -> 119 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 11, 268, 119 },
      -1,
   } },

   /* replace95_0 -> 11 in the cache */
   /* replace95_1 -> 268 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 11, 268 },
      -1,
   } },

   /* ('ffma@32', 'a', 'b', 0.0) => ('fmul', 'a', 'b') */
   /* search96_0 -> 16 in the cache */
   /* search96_1 -> 36 in the cache */
   /* search96_2 -> 121 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 16, 36, 121 },
      -1,
   } },

   /* replace96_0 -> 16 in the cache */
   /* replace96_1 -> 36 in the cache */
   /* replace96 -> 238 in the cache */

   /* ('ffmaz', 'a', 'b', 0.0) => ('fmulz', 'a', 'b') */
   /* search97_0 -> 16 in the cache */
   /* search97_1 -> 36 in the cache */
   /* search97_2 -> 121 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 16, 36, 121 },
      -1,
   } },

   /* replace97_0 -> 16 in the cache */
   /* replace97_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* ('ffma', 1.0, 'a', 'b') => ('fadd', 'a', 'b') */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
   } },
   /* search98_1 -> 0 in the cache */
   /* search98_2 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 280, 0, 3 },
      -1,
   } },

   /* replace98_0 -> 0 in the cache */
   /* replace98_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('ffmaz', 1.0, 'a', 'b') => ('fadd', 'a', 'b') */
   /* search99_0 -> 254 in the cache */
   /* search99_1 -> 16 in the cache */
   /* search99_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 254, 16, 36 },
      -1,
   } },

   /* replace99_0 -> 16 in the cache */
   /* replace99_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* ('ffma', -1.0, 'a', 'b') => ('fadd', ('fneg', 'a'), 'b') */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_float, { 0xbff0000000000000 /* -1.0 */ },
   } },
   /* search100_1 -> 0 in the cache */
   /* search100_2 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 285, 0, 3 },
      -1,
   } },

   /* replace100_0_0 -> 0 in the cache */
   /* replace100_0 -> 223 in the cache */
   /* replace100_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 223, 3 },
      -1,
   } },

   /* ('ffmaz', -1.0, 'a', 'b') => ('fadd', ('fneg', 'a'), 'b') */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_float, { 0xbff0000000000000 /* -1.0 */ },
   } },
   /* search101_1 -> 16 in the cache */
   /* search101_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 288, 16, 36 },
      -1,
   } },

   /* replace101_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 16 },
      -1,
   } },
   /* replace101_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 290, 36 },
      -1,
   } },

   /* ('~ffma', '#a', '#b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   { .variable = {
      { nir_search_value_variable, -3 },
      0, /* a */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -3 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search102_2 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 292, 293, 135 },
      -1,
   } },

   /* replace102_0_0 -> 132 in the cache */
   /* replace102_0_1 -> 133 in the cache */
   /* replace102_0 -> 134 in the cache */
   /* replace102_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 134, 135 },
      -1,
   } },

   /* ('~ffmaz', '#a', '#b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c') */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search103_1 -> 33 in the cache */
   /* search103_2 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 296, 33, 141 },
      -1,
   } },

   /* replace103_0_0 -> 16 in the cache */
   /* replace103_0_1 -> 36 in the cache */
   /* replace103_0 -> 140 in the cache */
   /* replace103_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 140, 141 },
      -1,
   } },

   /* ('~flrp', 'a', 'b', 0.0) => a */
   /* search104_0 -> 0 in the cache */
   /* search104_1 -> 3 in the cache */
   /* search104_2 -> 266 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 0, 3, 266 },
      -1,
   } },

   /* replace104 -> 0 in the cache */

   /* ('~flrp', 'a', 'b', 1.0) => b */
   /* search105_0 -> 0 in the cache */
   /* search105_1 -> 3 in the cache */
   /* search105_2 -> 280 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 0, 3, 280 },
      -1,
   } },

   /* replace105 -> 3 in the cache */

   /* ('~flrp', 'a', 'a', 'b') => a */
   /* search106_0 -> 0 in the cache */
   /* search106_1 -> 0 in the cache */
   /* search106_2 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 0, 0, 3 },
      -1,
   } },

   /* replace106 -> 0 in the cache */

   /* ('~flrp', 0.0, 'a', 'b') => ('fmul', 'a', 'b') */
   /* search107_0 -> 266 in the cache */
   /* search107_1 -> 0 in the cache */
   /* search107_2 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 266, 0, 3 },
      -1,
   } },

   /* replace107_0 -> 0 in the cache */
   /* replace107_1 -> 3 in the cache */
   /* replace107 -> 274 in the cache */

   /* ('~flrp', 'a', ('fadd(is_used_once)', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a') */
   /* search108_0 -> 132 in the cache */
   /* search108_1_0 -> 132 in the cache */
   /* search108_1_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 132, 133 },
      0,
   } },
   /* search108_2 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 132, 303, 135 },
      -1,
   } },

   /* replace108_0_0 -> 133 in the cache */
   /* replace108_0_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 133, 135 },
      -1,
   } },
   /* replace108_1 -> 132 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 305, 132 },
      -1,
   } },

   /* ('sdot_4x8_iadd', 'a', 0, 'b') => b */
   /* search109_0 -> 16 in the cache */
   /* search109_1 -> 128 in the cache */
   /* search109_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      0, 1,
      { 16, 128, 36 },
      -1,
   } },

   /* replace109 -> 36 in the cache */

   /* ('udot_4x8_uadd', 'a', 0, 'b') => b */
   /* search110_0 -> 16 in the cache */
   /* search110_1 -> 128 in the cache */
   /* search110_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      0, 1,
      { 16, 128, 36 },
      -1,
   } },

   /* replace110 -> 36 in the cache */

   /* ('sdot_4x8_iadd_sat', 'a', 0, 'b') => b */
   /* search111_0 -> 16 in the cache */
   /* search111_1 -> 128 in the cache */
   /* search111_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd_sat,
      0, 1,
      { 16, 128, 36 },
      -1,
   } },

   /* replace111 -> 36 in the cache */

   /* ('udot_4x8_uadd_sat', 'a', 0, 'b') => b */
   /* search112_0 -> 16 in the cache */
   /* search112_1 -> 128 in the cache */
   /* search112_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd_sat,
      0, 1,
      { 16, 128, 36 },
      -1,
   } },

   /* replace112 -> 36 in the cache */

   /* ('sdot_2x16_iadd', 'a', 0, 'b') => b */
   /* search113_0 -> 16 in the cache */
   /* search113_1 -> 128 in the cache */
   /* search113_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      0, 1,
      { 16, 128, 36 },
      -1,
   } },

   /* replace113 -> 36 in the cache */

   /* ('udot_2x16_uadd', 'a', 0, 'b') => b */
   /* search114_0 -> 16 in the cache */
   /* search114_1 -> 128 in the cache */
   /* search114_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      0, 1,
      { 16, 128, 36 },
      -1,
   } },

   /* replace114 -> 36 in the cache */

   /* ('sdot_2x16_iadd_sat', 'a', 0, 'b') => b */
   /* search115_0 -> 16 in the cache */
   /* search115_1 -> 128 in the cache */
   /* search115_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd_sat,
      0, 1,
      { 16, 128, 36 },
      -1,
   } },

   /* replace115 -> 36 in the cache */

   /* ('udot_2x16_uadd_sat', 'a', 0, 'b') => b */
   /* search116_0 -> 16 in the cache */
   /* search116_1 -> 128 in the cache */
   /* search116_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd_sat,
      0, 1,
      { 16, 128, 36 },
      -1,
   } },

   /* replace116 -> 36 in the cache */

   /* ('sudot_4x8_iadd', 'a', 0, 'b') => b */
   /* search117_0 -> 16 in the cache */
   /* search117_1 -> 128 in the cache */
   /* search117_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 16, 128, 36 },
      -1,
   } },

   /* replace117 -> 36 in the cache */

   /* ('sudot_4x8_iadd', 0, 'a', 'b') => b */
   /* search118_0 -> 128 in the cache */
   /* search118_1 -> 16 in the cache */
   /* search118_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 128, 16, 36 },
      -1,
   } },

   /* replace118 -> 36 in the cache */

   /* ('sudot_4x8_iadd_sat', 'a', 0, 'b') => b */
   /* search119_0 -> 16 in the cache */
   /* search119_1 -> 128 in the cache */
   /* search119_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd_sat,
      -1, 0,
      { 16, 128, 36 },
      -1,
   } },

   /* replace119 -> 36 in the cache */

   /* ('sudot_4x8_iadd_sat', 0, 'a', 'b') => b */
   /* search120_0 -> 128 in the cache */
   /* search120_1 -> 16 in the cache */
   /* search120_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd_sat,
      -1, 0,
      { 128, 16, 36 },
      -1,
   } },

   /* replace120 -> 36 in the cache */

   /* ('iadd', ('sdot_4x8_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sdot_4x8_iadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search121_0_0 -> 16 in the cache */
   /* search121_0_1 -> 36 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      1, 1,
      { 16, 36, 319 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      3, /* d */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 320, 321 },
      -1,
   } },

   /* replace121_0 -> 16 in the cache */
   /* replace121_1 -> 36 in the cache */
   /* replace121_2_0 -> 141 in the cache */
   /* replace121_2_1 -> 169 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 141, 169 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      0, 2,
      { 16, 36, 323 },
      -1,
   } },

   /* ('iadd', ('udot_4x8_uadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('udot_4x8_uadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search122_0_0 -> 16 in the cache */
   /* search122_0_1 -> 36 in the cache */
   /* search122_0_2 -> 319 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      1, 1,
      { 16, 36, 319 },
      0,
   } },
   /* search122_1 -> 321 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 325, 321 },
      -1,
   } },

   /* replace122_0 -> 16 in the cache */
   /* replace122_1 -> 36 in the cache */
   /* replace122_2_0 -> 141 in the cache */
   /* replace122_2_1 -> 169 in the cache */
   /* replace122_2 -> 323 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      0, 2,
      { 16, 36, 323 },
      -1,
   } },

   /* ('iadd', ('sudot_4x8_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sudot_4x8_iadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search123_0_0 -> 16 in the cache */
   /* search123_0_1 -> 36 in the cache */
   /* search123_0_2 -> 319 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 16, 36, 319 },
      0,
   } },
   /* search123_1 -> 321 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 328, 321 },
      -1,
   } },

   /* replace123_0 -> 16 in the cache */
   /* replace123_1 -> 36 in the cache */
   /* replace123_2_0 -> 141 in the cache */
   /* replace123_2_1 -> 169 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 141, 169 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 1,
      { 16, 36, 330 },
      -1,
   } },

   /* ('iadd', ('sdot_2x16_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sdot_2x16_iadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search124_0_0 -> 16 in the cache */
   /* search124_0_1 -> 36 in the cache */
   /* search124_0_2 -> 319 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      1, 1,
      { 16, 36, 319 },
      0,
   } },
   /* search124_1 -> 321 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 332, 321 },
      -1,
   } },

   /* replace124_0 -> 16 in the cache */
   /* replace124_1 -> 36 in the cache */
   /* replace124_2_0 -> 141 in the cache */
   /* replace124_2_1 -> 169 in the cache */
   /* replace124_2 -> 323 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      0, 2,
      { 16, 36, 323 },
      -1,
   } },

   /* ('iadd', ('udot_2x16_uadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('udot_2x16_uadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search125_0_0 -> 16 in the cache */
   /* search125_0_1 -> 36 in the cache */
   /* search125_0_2 -> 319 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      1, 1,
      { 16, 36, 319 },
      0,
   } },
   /* search125_1 -> 321 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 335, 321 },
      -1,
   } },

   /* replace125_0 -> 16 in the cache */
   /* replace125_1 -> 36 in the cache */
   /* replace125_2_0 -> 141 in the cache */
   /* replace125_2_1 -> 169 in the cache */
   /* replace125_2 -> 323 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      0, 2,
      { 16, 36, 323 },
      -1,
   } },

   /* ('iadd', ('sdot_4x8_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sdot_4x8_iadd', 'a', 'b', 'c') */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_invalid,
      5,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search126_0_1 -> 36 in the cache */
   /* search126_0_2 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      1, 1,
      { 338, 36, 128 },
      -1,
   } },
   /* search126_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 339, 141 },
      -1,
   } },

   /* replace126_0 -> 16 in the cache */
   /* replace126_1 -> 36 in the cache */
   /* replace126_2 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      0, 1,
      { 16, 36, 141 },
      -1,
   } },

   /* ('iadd', ('udot_4x8_uadd', 'a(is_not_const)', 'b', 0), 'c') => ('udot_4x8_uadd', 'a', 'b', 'c') */
   /* search127_0_0 -> 338 in the cache */
   /* search127_0_1 -> 36 in the cache */
   /* search127_0_2 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      1, 1,
      { 338, 36, 128 },
      -1,
   } },
   /* search127_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 342, 141 },
      -1,
   } },

   /* replace127_0 -> 16 in the cache */
   /* replace127_1 -> 36 in the cache */
   /* replace127_2 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      0, 1,
      { 16, 36, 141 },
      -1,
   } },

   /* ('iadd', ('sudot_4x8_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sudot_4x8_iadd', 'a', 'b', 'c') */
   /* search128_0_0 -> 338 in the cache */
   /* search128_0_1 -> 36 in the cache */
   /* search128_0_2 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 338, 36, 128 },
      -1,
   } },
   /* search128_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 345, 141 },
      -1,
   } },

   /* replace128_0 -> 16 in the cache */
   /* replace128_1 -> 36 in the cache */
   /* replace128_2 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 16, 36, 141 },
      -1,
   } },

   /* ('iadd', ('sudot_4x8_iadd', 'a', 'b(is_not_const)', 0), 'c') => ('sudot_4x8_iadd', 'a', 'b', 'c') */
   /* search129_0_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      5,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search129_0_2 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 16, 348, 128 },
      -1,
   } },
   /* search129_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 349, 141 },
      -1,
   } },

   /* replace129_0 -> 16 in the cache */
   /* replace129_1 -> 36 in the cache */
   /* replace129_2 -> 141 in the cache */
   /* replace129 -> 347 in the cache */

   /* ('iadd', ('sdot_2x16_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sdot_2x16_iadd', 'a', 'b', 'c') */
   /* search130_0_0 -> 338 in the cache */
   /* search130_0_1 -> 36 in the cache */
   /* search130_0_2 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      1, 1,
      { 338, 36, 128 },
      -1,
   } },
   /* search130_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 351, 141 },
      -1,
   } },

   /* replace130_0 -> 16 in the cache */
   /* replace130_1 -> 36 in the cache */
   /* replace130_2 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      0, 1,
      { 16, 36, 141 },
      -1,
   } },

   /* ('iadd', ('udot_2x16_uadd', 'a(is_not_const)', 'b', 0), 'c') => ('udot_2x16_uadd', 'a', 'b', 'c') */
   /* search131_0_0 -> 338 in the cache */
   /* search131_0_1 -> 36 in the cache */
   /* search131_0_2 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      1, 1,
      { 338, 36, 128 },
      -1,
   } },
   /* search131_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 354, 141 },
      -1,
   } },

   /* replace131_0 -> 16 in the cache */
   /* replace131_1 -> 36 in the cache */
   /* replace131_2 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      0, 1,
      { 16, 36, 141 },
      -1,
   } },

   /* ('sdot_4x8_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sdot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search132_0 -> 296 in the cache */
   /* search132_1 -> 33 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      false,
      nir_type_invalid,
      5,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      0, 1,
      { 296, 33, 357 },
      -1,
   } },

   /* replace132_0_0 -> 16 in the cache */
   /* replace132_0_1 -> 36 in the cache */
   /* replace132_0_2 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      1, 1,
      { 16, 36, 128 },
      -1,
   } },
   /* replace132_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 359, 141 },
      -1,
   } },

   /* ('udot_4x8_uadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('udot_4x8_uadd', 'a', 'b', 0), 'c') */
   /* search133_0 -> 296 in the cache */
   /* search133_1 -> 33 in the cache */
   /* search133_2 -> 357 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      0, 1,
      { 296, 33, 357 },
      -1,
   } },

   /* replace133_0_0 -> 16 in the cache */
   /* replace133_0_1 -> 36 in the cache */
   /* replace133_0_2 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      1, 1,
      { 16, 36, 128 },
      -1,
   } },
   /* replace133_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 362, 141 },
      -1,
   } },

   /* ('sudot_4x8_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sudot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search134_0 -> 296 in the cache */
   /* search134_1 -> 33 in the cache */
   /* search134_2 -> 357 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 296, 33, 357 },
      -1,
   } },

   /* replace134_0_0 -> 16 in the cache */
   /* replace134_0_1 -> 36 in the cache */
   /* replace134_0_2 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 16, 36, 128 },
      -1,
   } },
   /* replace134_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 365, 141 },
      -1,
   } },

   /* ('sdot_2x16_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sdot_2x16_iadd', 'a', 'b', 0), 'c') */
   /* search135_0 -> 296 in the cache */
   /* search135_1 -> 33 in the cache */
   /* search135_2 -> 357 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      0, 1,
      { 296, 33, 357 },
      -1,
   } },

   /* replace135_0_0 -> 16 in the cache */
   /* replace135_0_1 -> 36 in the cache */
   /* replace135_0_2 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      1, 1,
      { 16, 36, 128 },
      -1,
   } },
   /* replace135_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 368, 141 },
      -1,
   } },

   /* ('udot_2x16_uadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('udot_2x16_uadd', 'a', 'b', 0), 'c') */
   /* search136_0 -> 296 in the cache */
   /* search136_1 -> 33 in the cache */
   /* search136_2 -> 357 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      0, 1,
      { 296, 33, 357 },
      -1,
   } },

   /* replace136_0_0 -> 16 in the cache */
   /* replace136_0_1 -> 36 in the cache */
   /* replace136_0_2 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      1, 1,
      { 16, 36, 128 },
      -1,
   } },
   /* replace136_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 371, 141 },
      -1,
   } },

   /* ('sdot_4x8_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sdot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search137_0 -> 296 in the cache */
   /* search137_1 -> 33 in the cache */
   /* search137_2 -> 357 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd_sat,
      0, 1,
      { 296, 33, 357 },
      -1,
   } },

   /* replace137_0_0 -> 16 in the cache */
   /* replace137_0_1 -> 36 in the cache */
   /* replace137_0_2 -> 128 in the cache */
   /* replace137_0 -> 359 in the cache */
   /* replace137_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 2,
      { 359, 141 },
      -1,
   } },

   /* ('udot_4x8_uadd_sat', '#a', '#b', 'c(is_not_const)') => ('uadd_sat', ('udot_4x8_uadd', 'a', 'b', 0), 'c') */
   /* search138_0 -> 296 in the cache */
   /* search138_1 -> 33 in the cache */
   /* search138_2 -> 357 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd_sat,
      0, 1,
      { 296, 33, 357 },
      -1,
   } },

   /* replace138_0_0 -> 16 in the cache */
   /* replace138_0_1 -> 36 in the cache */
   /* replace138_0_2 -> 128 in the cache */
   /* replace138_0 -> 362 in the cache */
   /* replace138_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_uadd_sat,
      0, 2,
      { 362, 141 },
      -1,
   } },

   /* ('sudot_4x8_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sudot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search139_0 -> 296 in the cache */
   /* search139_1 -> 33 in the cache */
   /* search139_2 -> 357 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd_sat,
      -1, 0,
      { 296, 33, 357 },
      -1,
   } },

   /* replace139_0_0 -> 16 in the cache */
   /* replace139_0_1 -> 36 in the cache */
   /* replace139_0_2 -> 128 in the cache */
   /* replace139_0 -> 365 in the cache */
   /* replace139_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 1,
      { 365, 141 },
      -1,
   } },

   /* ('sdot_2x16_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sdot_2x16_iadd', 'a', 'b', 0), 'c') */
   /* search140_0 -> 296 in the cache */
   /* search140_1 -> 33 in the cache */
   /* search140_2 -> 357 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd_sat,
      0, 1,
      { 296, 33, 357 },
      -1,
   } },

   /* replace140_0_0 -> 16 in the cache */
   /* replace140_0_1 -> 36 in the cache */
   /* replace140_0_2 -> 128 in the cache */
   /* replace140_0 -> 368 in the cache */
   /* replace140_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 2,
      { 368, 141 },
      -1,
   } },

   /* ('udot_2x16_uadd_sat', '#a', '#b', 'c(is_not_const)') => ('uadd_sat', ('udot_2x16_uadd', 'a', 'b', 0), 'c') */
   /* search141_0 -> 296 in the cache */
   /* search141_1 -> 33 in the cache */
   /* search141_2 -> 357 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd_sat,
      0, 1,
      { 296, 33, 357 },
      -1,
   } },

   /* replace141_0_0 -> 16 in the cache */
   /* replace141_0_1 -> 36 in the cache */
   /* replace141_0_2 -> 128 in the cache */
   /* replace141_0 -> 371 in the cache */
   /* replace141_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_uadd_sat,
      0, 2,
      { 371, 141 },
      -1,
   } },

   /* ('fmul@32', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', 'a', 'b') */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search142_0_0_1 -> 121 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      nir_op_feq,
      1, 1,
      { 383, 121 },
      -1,
   } },
   /* search142_0_1 -> 121 in the cache */
   /* search142_0_2 -> 189 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 384, 121, 189 },
      -1,
   } },
   /* search142_1_0_0 -> 189 in the cache */
   /* search142_1_0_1 -> 121 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      nir_op_feq,
      2, 1,
      { 189, 121 },
      -1,
   } },
   /* search142_1_1 -> 121 in the cache */
   /* search142_1_2 -> 383 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 386, 121, 383 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 3,
      { 385, 387 },
      -1,
   } },

   /* replace142_0 -> 189 in the cache */
   /* replace142_1 -> 383 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 189, 383 },
      -1,
   } },

   /* ('fmul@32', 'a', ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', 'a', 'b') */
   /* search143_0 -> 16 in the cache */
   /* search143_1_0_0 -> 16 in the cache */
   /* search143_1_0_1 -> 121 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      nir_op_feq,
      1, 1,
      { 16, 121 },
      -1,
   } },
   /* search143_1_1 -> 121 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      6,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 390, 121, 391 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 16, 392 },
      -1,
   } },

   /* replace143_0 -> 16 in the cache */
   /* replace143_1 -> 36 in the cache */
   /* replace143 -> 279 in the cache */

   /* ('ffma@32', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', 'a', 'b', 'c') */
   /* search144_0_0_0 -> 383 in the cache */
   /* search144_0_0_1 -> 121 in the cache */
   /* search144_0_0 -> 384 in the cache */
   /* search144_0_1 -> 121 in the cache */
   /* search144_0_2 -> 189 in the cache */
   /* search144_0 -> 385 in the cache */
   /* search144_1_0_0 -> 189 in the cache */
   /* search144_1_0_1 -> 121 in the cache */
   /* search144_1_0 -> 386 in the cache */
   /* search144_1_1 -> 121 in the cache */
   /* search144_1_2 -> 383 in the cache */
   /* search144_1 -> 387 in the cache */
   /* search144_2 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 385, 387, 141 },
      -1,
   } },

   /* replace144_0 -> 189 in the cache */
   /* replace144_1 -> 383 in the cache */
   /* replace144_2 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 189, 383, 141 },
      -1,
   } },

   /* ('ffma@32', 'a', ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', 'a', 'b', 'c') */
   /* search145_0 -> 16 in the cache */
   /* search145_1_0_0 -> 16 in the cache */
   /* search145_1_0_1 -> 121 in the cache */
   /* search145_1_0 -> 390 in the cache */
   /* search145_1_1 -> 121 in the cache */
   /* search145_1_2 -> 391 in the cache */
   /* search145_1 -> 392 in the cache */
   /* search145_2 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 16, 392, 141 },
      -1,
   } },

   /* replace145_0 -> 16 in the cache */
   /* replace145_1 -> 36 in the cache */
   /* replace145_2 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 16, 36, 141 },
      -1,
   } },

   /* ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmul@32', 'a', 'b'))) => ('fexp2', ('fmulz', 'a', 'b')) */
   /* search146_0_0 -> 383 in the cache */
   /* search146_0_1 -> 121 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      nir_op_feq,
      0, 1,
      { 383, 121 },
      -1,
   } },
   /* search146_1 -> 254 in the cache */
   /* search146_2_0_0 -> 189 in the cache */
   /* search146_2_0_1 -> 383 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 189, 383 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 399 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 398, 254, 400 },
      -1,
   } },

   /* replace146_0_0 -> 189 in the cache */
   /* replace146_0_1 -> 383 in the cache */
   /* replace146_0 -> 389 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 389 },
      -1,
   } },

   /* ('sdot_4x8_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_i8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_i8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_i8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_i8', 'b', 3)))), 'c') */
   /* search147_0 -> 16 in the cache */
   /* search147_1 -> 36 in the cache */
   /* search147_2 -> 141 in the cache */
   /* search147 -> 341 in the cache */

   /* replace147_0_0_0_0_0 -> 16 in the cache */
   /* replace147_0_0_0_0_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 16, 128 },
      -1,
   } },
   /* replace147_0_0_0_1_0 -> 36 in the cache */
   /* replace147_0_0_0_1_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 36, 128 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 403, 404 },
      -1,
   } },
   /* replace147_0_0_1_0_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x1 /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 16, 406 },
      -1,
   } },
   /* replace147_0_0_1_1_0 -> 36 in the cache */
   /* replace147_0_0_1_1_1 -> 406 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 36, 406 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      4, 1,
      { 407, 408 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      2, 3,
      { 405, 409 },
      -1,
   } },
   /* replace147_0_1_0_0_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x2 /* 2 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 16, 411 },
      -1,
   } },
   /* replace147_0_1_0_1_0 -> 36 in the cache */
   /* replace147_0_1_0_1_1 -> 411 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 36, 411 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      6, 1,
      { 412, 413 },
      -1,
   } },
   /* replace147_0_1_1_0_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x3 /* 3 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 16, 415 },
      -1,
   } },
   /* replace147_0_1_1_1_0 -> 36 in the cache */
   /* replace147_0_1_1_1_1 -> 415 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 36, 415 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      7, 1,
      { 416, 417 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      5, 3,
      { 414, 418 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 7,
      { 410, 419 },
      -1,
   } },
   /* replace147_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 8,
      { 420, 141 },
      -1,
   } },

   /* ('udot_4x8_uadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_u8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_u8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_u8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_u8', 'a', 3), ('extract_u8', 'b', 3)))), 'c') */
   /* search148_0 -> 16 in the cache */
   /* search148_1 -> 36 in the cache */
   /* search148_2 -> 141 in the cache */
   /* search148 -> 344 in the cache */

   /* replace148_0_0_0_0_0 -> 16 in the cache */
   /* replace148_0_0_0_0_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 16, 128 },
      -1,
   } },
   /* replace148_0_0_0_1_0 -> 36 in the cache */
   /* replace148_0_0_0_1_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 36, 128 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 422, 423 },
      -1,
   } },
   /* replace148_0_0_1_0_0 -> 16 in the cache */
   /* replace148_0_0_1_0_1 -> 406 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 16, 406 },
      -1,
   } },
   /* replace148_0_0_1_1_0 -> 36 in the cache */
   /* replace148_0_0_1_1_1 -> 406 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 36, 406 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      4, 1,
      { 425, 426 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      2, 3,
      { 424, 427 },
      -1,
   } },
   /* replace148_0_1_0_0_0 -> 16 in the cache */
   /* replace148_0_1_0_0_1 -> 411 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 16, 411 },
      -1,
   } },
   /* replace148_0_1_0_1_0 -> 36 in the cache */
   /* replace148_0_1_0_1_1 -> 411 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 36, 411 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      6, 1,
      { 429, 430 },
      -1,
   } },
   /* replace148_0_1_1_0_0 -> 16 in the cache */
   /* replace148_0_1_1_0_1 -> 415 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 16, 415 },
      -1,
   } },
   /* replace148_0_1_1_1_0 -> 36 in the cache */
   /* replace148_0_1_1_1_1 -> 415 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 36, 415 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      7, 1,
      { 432, 433 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      5, 3,
      { 431, 434 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 7,
      { 428, 435 },
      -1,
   } },
   /* replace148_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 8,
      { 436, 141 },
      -1,
   } },

   /* ('sudot_4x8_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_u8', 'b', 3)))), 'c') */
   /* search149_0 -> 16 in the cache */
   /* search149_1 -> 36 in the cache */
   /* search149_2 -> 141 in the cache */
   /* search149 -> 347 in the cache */

   /* replace149_0_0_0_0_0 -> 16 in the cache */
   /* replace149_0_0_0_0_1 -> 128 in the cache */
   /* replace149_0_0_0_0 -> 403 in the cache */
   /* replace149_0_0_0_1_0 -> 36 in the cache */
   /* replace149_0_0_0_1_1 -> 128 in the cache */
   /* replace149_0_0_0_1 -> 423 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 403, 423 },
      -1,
   } },
   /* replace149_0_0_1_0_0 -> 16 in the cache */
   /* replace149_0_0_1_0_1 -> 406 in the cache */
   /* replace149_0_0_1_0 -> 407 in the cache */
   /* replace149_0_0_1_1_0 -> 36 in the cache */
   /* replace149_0_0_1_1_1 -> 406 in the cache */
   /* replace149_0_0_1_1 -> 426 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      4, 1,
      { 407, 426 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      2, 3,
      { 438, 439 },
      -1,
   } },
   /* replace149_0_1_0_0_0 -> 16 in the cache */
   /* replace149_0_1_0_0_1 -> 411 in the cache */
   /* replace149_0_1_0_0 -> 412 in the cache */
   /* replace149_0_1_0_1_0 -> 36 in the cache */
   /* replace149_0_1_0_1_1 -> 411 in the cache */
   /* replace149_0_1_0_1 -> 430 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      6, 1,
      { 412, 430 },
      -1,
   } },
   /* replace149_0_1_1_0_0 -> 16 in the cache */
   /* replace149_0_1_1_0_1 -> 415 in the cache */
   /* replace149_0_1_1_0 -> 416 in the cache */
   /* replace149_0_1_1_1_0 -> 36 in the cache */
   /* replace149_0_1_1_1_1 -> 415 in the cache */
   /* replace149_0_1_1_1 -> 433 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      7, 1,
      { 416, 433 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      5, 3,
      { 441, 442 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 7,
      { 440, 443 },
      -1,
   } },
   /* replace149_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 8,
      { 444, 141 },
      -1,
   } },

   /* ('sdot_2x16_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('imul', ('extract_i16', 'a', 0), ('extract_i16', 'b', 0)), ('imul', ('extract_i16', 'a', 1), ('extract_i16', 'b', 1))), 'c') */
   /* search150_0 -> 16 in the cache */
   /* search150_1 -> 36 in the cache */
   /* search150_2 -> 141 in the cache */
   /* search150 -> 353 in the cache */

   /* replace150_0_0_0_0 -> 16 in the cache */
   /* replace150_0_0_0_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 0,
      { 16, 128 },
      -1,
   } },
   /* replace150_0_0_1_0 -> 36 in the cache */
   /* replace150_0_0_1_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 0,
      { 36, 128 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      2, 1,
      { 446, 447 },
      -1,
   } },
   /* replace150_0_1_0_0 -> 16 in the cache */
   /* replace150_0_1_0_1 -> 406 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 0,
      { 16, 406 },
      -1,
   } },
   /* replace150_0_1_1_0 -> 36 in the cache */
   /* replace150_0_1_1_1 -> 406 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 0,
      { 36, 406 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 449, 450 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 448, 451 },
      -1,
   } },
   /* replace150_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 4,
      { 452, 141 },
      -1,
   } },

   /* ('udot_2x16_uadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('imul', ('extract_u16', 'a', 0), ('extract_u16', 'b', 0)), ('imul', ('extract_u16', 'a', 1), ('extract_u16', 'b', 1))), 'c') */
   /* search151_0 -> 16 in the cache */
   /* search151_1 -> 36 in the cache */
   /* search151_2 -> 141 in the cache */
   /* search151 -> 356 in the cache */

   /* replace151_0_0_0_0 -> 16 in the cache */
   /* replace151_0_0_0_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 0,
      { 16, 128 },
      -1,
   } },
   /* replace151_0_0_1_0 -> 36 in the cache */
   /* replace151_0_0_1_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 0,
      { 36, 128 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      2, 1,
      { 454, 455 },
      -1,
   } },
   /* replace151_0_1_0_0 -> 16 in the cache */
   /* replace151_0_1_0_1 -> 406 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 0,
      { 16, 406 },
      -1,
   } },
   /* replace151_0_1_1_0 -> 36 in the cache */
   /* replace151_0_1_1_1 -> 406 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 0,
      { 36, 406 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 457, 458 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 456, 459 },
      -1,
   } },
   /* replace151_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 4,
      { 460, 141 },
      -1,
   } },

   /* ('udot_4x8_uadd_sat', 'a', 'b', '#c(is_ult_0xfffc07fc)') => ('udot_4x8_uadd', 'a', 'b', 'c') */
   /* search152_0 -> 16 in the cache */
   /* search152_1 -> 36 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      true,
      nir_type_invalid,
      7,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd_sat,
      0, 1,
      { 16, 36, 462 },
      -1,
   } },

   /* replace152_0 -> 16 in the cache */
   /* replace152_1 -> 36 in the cache */
   /* replace152_2 -> 141 in the cache */
   /* replace152 -> 344 in the cache */

   /* ('udot_4x8_uadd_sat', 'a', 'b', 'c') => ('uadd_sat', ('udot_4x8_uadd', 'a', 'b', 0), 'c') */
   /* search153_0 -> 16 in the cache */
   /* search153_1 -> 36 in the cache */
   /* search153_2 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd_sat,
      0, 1,
      { 16, 36, 141 },
      -1,
   } },

   /* replace153_0_0 -> 16 in the cache */
   /* replace153_0_1 -> 36 in the cache */
   /* replace153_0_2 -> 128 in the cache */
   /* replace153_0 -> 362 in the cache */
   /* replace153_1 -> 141 in the cache */
   /* replace153 -> 376 in the cache */

   /* ('sdot_4x8_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('sdot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search154_0 -> 16 in the cache */
   /* search154_1 -> 36 in the cache */
   /* search154_2 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd_sat,
      0, 1,
      { 16, 36, 141 },
      -1,
   } },

   /* replace154_0_0 -> 16 in the cache */
   /* replace154_0_1 -> 36 in the cache */
   /* replace154_0_2 -> 128 in the cache */
   /* replace154_0 -> 359 in the cache */
   /* replace154_1 -> 141 in the cache */
   /* replace154 -> 374 in the cache */

   /* ('sudot_4x8_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('sudot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search155_0 -> 16 in the cache */
   /* search155_1 -> 36 in the cache */
   /* search155_2 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd_sat,
      -1, 0,
      { 16, 36, 141 },
      -1,
   } },

   /* replace155_0_0 -> 16 in the cache */
   /* replace155_0_1 -> 36 in the cache */
   /* replace155_0_2 -> 128 in the cache */
   /* replace155_0 -> 365 in the cache */
   /* replace155_1 -> 141 in the cache */
   /* replace155 -> 378 in the cache */

   /* ('udot_2x16_uadd_sat', 'a', 'b', 'c') => ('uadd_sat', ('iadd', ('imul', ('extract_u16', 'a', 0), ('extract_u16', 'b', 0)), ('imul', ('extract_u16', 'a', 1), ('extract_u16', 'b', 1))), 'c') */
   /* search156_0 -> 16 in the cache */
   /* search156_1 -> 36 in the cache */
   /* search156_2 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd_sat,
      0, 1,
      { 16, 36, 141 },
      -1,
   } },

   /* replace156_0_0_0_0 -> 16 in the cache */
   /* replace156_0_0_0_1 -> 128 in the cache */
   /* replace156_0_0_0 -> 454 in the cache */
   /* replace156_0_0_1_0 -> 36 in the cache */
   /* replace156_0_0_1_1 -> 128 in the cache */
   /* replace156_0_0_1 -> 455 in the cache */
   /* replace156_0_0 -> 456 in the cache */
   /* replace156_0_1_0_0 -> 16 in the cache */
   /* replace156_0_1_0_1 -> 406 in the cache */
   /* replace156_0_1_0 -> 457 in the cache */
   /* replace156_0_1_1_0 -> 36 in the cache */
   /* replace156_0_1_1_1 -> 406 in the cache */
   /* replace156_0_1_1 -> 458 in the cache */
   /* replace156_0_1 -> 459 in the cache */
   /* replace156_0 -> 460 in the cache */
   /* replace156_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_uadd_sat,
      0, 4,
      { 460, 141 },
      -1,
   } },

   /* ('sdot_2x16_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('iadd', ('imul', ('extract_i16', 'a', 0), ('extract_i16', 'b', 0)), ('imul', ('extract_i16', 'a', 1), ('extract_i16', 'b', 1))), 'c') */
   /* search157_0 -> 16 in the cache */
   /* search157_1 -> 36 in the cache */
   /* search157_2 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd_sat,
      0, 1,
      { 16, 36, 141 },
      -1,
   } },

   /* replace157_0_0_0_0 -> 16 in the cache */
   /* replace157_0_0_0_1 -> 128 in the cache */
   /* replace157_0_0_0 -> 446 in the cache */
   /* replace157_0_0_1_0 -> 36 in the cache */
   /* replace157_0_0_1_1 -> 128 in the cache */
   /* replace157_0_0_1 -> 447 in the cache */
   /* replace157_0_0 -> 448 in the cache */
   /* replace157_0_1_0_0 -> 16 in the cache */
   /* replace157_0_1_0_1 -> 406 in the cache */
   /* replace157_0_1_0 -> 449 in the cache */
   /* replace157_0_1_1_0 -> 36 in the cache */
   /* replace157_0_1_1_1 -> 406 in the cache */
   /* replace157_0_1_1 -> 450 in the cache */
   /* replace157_0_1 -> 451 in the cache */
   /* replace157_0 -> 452 in the cache */
   /* replace157_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 4,
      { 452, 141 },
      -1,
   } },

   /* ('~flrp@16', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a') */
   /* search158_0 -> 11 in the cache */
   /* search158_1 -> 268 in the cache */
   { .variable = {
      { nir_search_value_variable, 1 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 471 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 11, 268, 472 },
      -1,
   } },

   /* replace158_0 -> 471 in the cache */
   /* replace158_1 -> 268 in the cache */
   /* replace158_2 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 471, 268, 11 },
      -1,
   } },

   /* ('~flrp@16', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a') */
   /* search159_0 -> 11 in the cache */
   /* search159_1_0 -> 11 in the cache */
   /* search159_1_1 -> 268 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 11, 268 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 16 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 11, 475, 476 },
      -1,
   } },

   /* replace159_0_0 -> 268 in the cache */
   /* replace159_0_1 -> 476 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 268, 476 },
      -1,
   } },
   /* replace159_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 478, 11 },
      -1,
   } },

   /* ('~flrp@16', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a') */
   /* search160_0_0 -> 11 in the cache */
   /* search160_0_1 -> 268 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 11, 268 },
      0,
   } },
   /* search160_1_0 -> 11 in the cache */
   /* search160_1_1 -> 476 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 11, 476 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, 16 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 2,
      { 480, 481, 482 },
      -1,
   } },

   /* replace160_0_0 -> 268 in the cache */
   /* replace160_0_1 -> 476 in the cache */
   /* replace160_0_2 -> 482 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 268, 476, 482 },
      -1,
   } },
   /* replace160_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 484, 11 },
      -1,
   } },

   /* ('~flrp@16', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a') */
   /* search161_0 -> 11 in the cache */
   /* search161_1_0 -> 11 in the cache */
   /* search161_1_1 -> 268 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 11, 268 },
      0,
   } },
   /* search161_2 -> 476 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 11, 486, 476 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
   } },
   /* replace161_0_1 -> 268 in the cache */
   /* replace161_0_2 -> 476 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 488, 268, 476 },
      -1,
   } },
   /* replace161_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 489, 11 },
      -1,
   } },

   /* ('~fadd@16', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c') */
   /* search162_0_0 -> 11 in the cache */
   /* search162_0_1_0 -> 488 in the cache */
   { .variable = {
      { nir_search_value_variable, 16 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 491 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 488, 492 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 11, 493 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 16 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search162_1_1 -> 491 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 495, 491 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 494, 496 },
      -1,
   } },

   /* replace162_0 -> 11 in the cache */
   /* replace162_1 -> 495 in the cache */
   /* replace162_2 -> 491 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 11, 495, 491 },
      -1,
   } },

   /* ('~fadd@16', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c')) */
   /* search163_0_0 -> 11 in the cache */
   /* search163_0_1_0_0 -> 488 in the cache */
   /* search163_0_1_0_1_0 -> 491 in the cache */
   /* search163_0_1_0_1 -> 492 in the cache */
   /* search163_0_1_0 -> 493 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 493 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 11, 499 },
      -1,
   } },
   /* search163_1_0 -> 495 in the cache */
   /* search163_1_1_0 -> 491 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 491 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 495, 501 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 500, 502 },
      -1,
   } },

   /* replace163_0 -> 11 in the cache */
   /* replace163_1 -> 495 in the cache */
   /* replace163_2_0 -> 491 in the cache */
   /* replace163_2 -> 501 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 11, 495, 501 },
      -1,
   } },

   /* ('~fadd@16', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c') */
   /* search164_0 -> 11 in the cache */
   /* search164_1_0 -> 491 in the cache */
   /* search164_1_1_0 -> 495 in the cache */
   /* search164_1_1_1_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 495, 505 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 491, 506 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 11, 507 },
      -1,
   } },

   /* replace164_0 -> 11 in the cache */
   /* replace164_1 -> 495 in the cache */
   /* replace164_2 -> 491 in the cache */
   /* replace164 -> 498 in the cache */

   /* ('~fadd@16', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a') */
   /* search165_0_0 -> 11 in the cache */
   /* search165_0_1_0 -> 488 in the cache */
   { .variable = {
      { nir_search_value_variable, 1 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 509 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 510 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 488, 511 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 11, 512 },
      -1,
   } },
   /* search165_1_0 -> 495 in the cache */
   /* search165_1_1_0 -> 509 in the cache */
   /* search165_1_1 -> 510 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 495, 510 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 513, 514 },
      -1,
   } },

   /* replace165_0 -> 509 in the cache */
   /* replace165_1 -> 495 in the cache */
   /* replace165_2 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 509, 495, 11 },
      -1,
   } },

   /* ('~fadd@16', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a') */
   /* search166_0 -> 11 in the cache */
   /* search166_1_0_0 -> 509 in the cache */
   /* search166_1_0 -> 510 in the cache */
   /* search166_1_1_0 -> 495 in the cache */
   /* search166_1_1_1_0 -> 11 in the cache */
   /* search166_1_1_1 -> 505 in the cache */
   /* search166_1_1 -> 506 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 510, 506 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 11, 517 },
      -1,
   } },

   /* replace166_0 -> 509 in the cache */
   /* replace166_1 -> 495 in the cache */
   /* replace166_2 -> 11 in the cache */
   /* replace166 -> 516 in the cache */

   /* ('~ffma@16', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a') */
   /* search167_0 -> 11 in the cache */
   /* search167_1_0 -> 488 in the cache */
   /* search167_1_1_0_0 -> 509 in the cache */
   /* search167_1_1_0 -> 510 in the cache */
   /* search167_1_1 -> 511 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 488, 511 },
      -1,
   } },
   /* search167_2_0 -> 495 in the cache */
   /* search167_2_1_0 -> 509 in the cache */
   /* search167_2_1 -> 510 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 495, 510 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 11, 519, 520 },
      -1,
   } },

   /* replace167_0 -> 509 in the cache */
   /* replace167_1 -> 495 in the cache */
   /* replace167_2 -> 11 in the cache */
   /* replace167 -> 516 in the cache */

   /* ('~ffma@16', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a') */
   { .variable = {
      { nir_search_value_variable, 16 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search168_1_0 -> 509 in the cache */
   /* search168_1 -> 510 in the cache */
   { .variable = {
      { nir_search_value_variable, 16 },
      2, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 523 },
      -1,
   } },
   /* search168_2_1_0 -> 509 in the cache */
   /* search168_2_1 -> 510 in the cache */
   /* search168_2_2 -> 523 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 524, 510, 523 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 522, 510, 525 },
      -1,
   } },

   /* replace168_0 -> 509 in the cache */
   /* replace168_1 -> 522 in the cache */
   /* replace168_2 -> 523 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 509, 522, 523 },
      -1,
   } },

   /* ('~ffma@16', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a') */
   { .variable = {
      { nir_search_value_variable, 1 },
      0, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 528 },
      -1,
   } },
   /* search169_1_0 -> 268 in the cache */
   /* search169_1_1_0 -> 523 in the cache */
   /* search169_1_1 -> 524 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 268, 524 },
      -1,
   } },
   /* search169_2 -> 523 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 529, 530, 523 },
      -1,
   } },

   /* replace169_0 -> 528 in the cache */
   /* replace169_1 -> 268 in the cache */
   /* replace169_2 -> 523 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 528, 268, 523 },
      -1,
   } },

   /* ('~ffma@16', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b')) */
   /* search170_0_0 -> 528 in the cache */
   /* search170_0 -> 529 in the cache */
   { .variable = {
      { nir_search_value_variable, 16 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 533 },
      -1,
   } },
   /* search170_1_1 -> 495 in the cache */
   /* search170_1_2 -> 482 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 534, 495, 482 },
      -1,
   } },
   /* search170_2_0 -> 533 in the cache */
   /* search170_2_1 -> 495 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 533, 495 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 529, 535, 536 },
      -1,
   } },

   /* replace170_0 -> 528 in the cache */
   /* replace170_1 -> 482 in the cache */
   /* replace170_2_0 -> 533 in the cache */
   /* replace170_2_1 -> 495 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 533, 495 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 528, 482, 538 },
      -1,
   } },

   /* ('~fadd@16', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a') */
   /* search171_0 -> 488 in the cache */
   /* search171_1_0_0_0 -> 488 in the cache */
   /* search171_1_0_0_1_0 -> 11 in the cache */
   /* search171_1_0_0_1 -> 505 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 488, 505 },
      -1,
   } },
   /* search171_1_0_1_0 -> 488 in the cache */
   /* search171_1_0_1_1_0 -> 268 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 268 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      3, 1,
      { 488, 541 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 3,
      { 540, 542 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 3,
      { 543 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 488, 544 },
      -1,
   } },

   /* replace171_0 -> 268 in the cache */
   /* replace171_1 -> 488 in the cache */
   /* replace171_2 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 268, 488, 11 },
      -1,
   } },

   /* ('~flrp@32', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a') */
   /* search172_0 -> 16 in the cache */
   /* search172_1 -> 36 in the cache */
   /* search172_2_0 -> 471 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 471 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 16, 36, 547 },
      -1,
   } },

   /* replace172_0 -> 471 in the cache */
   /* replace172_1 -> 36 in the cache */
   /* replace172_2 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 471, 36, 16 },
      -1,
   } },

   /* ('~flrp@32', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a') */
   /* search173_0 -> 16 in the cache */
   /* search173_1_0 -> 16 in the cache */
   /* search173_1_1 -> 36 in the cache */
   /* search173_1 -> 284 in the cache */
   /* search173_2 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 16, 284, 141 },
      -1,
   } },

   /* replace173_0_0 -> 36 in the cache */
   /* replace173_0_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 36, 141 },
      -1,
   } },
   /* replace173_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 551, 16 },
      -1,
   } },

   /* ('~flrp@32', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a') */
   /* search174_0_0 -> 16 in the cache */
   /* search174_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 16, 36 },
      0,
   } },
   /* search174_1_0 -> 16 in the cache */
   /* search174_1_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 16, 141 },
      0,
   } },
   /* search174_2 -> 169 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 2,
      { 553, 554, 169 },
      -1,
   } },

   /* replace174_0_0 -> 36 in the cache */
   /* replace174_0_1 -> 141 in the cache */
   /* replace174_0_2 -> 169 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 36, 141, 169 },
      -1,
   } },
   /* replace174_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 556, 16 },
      -1,
   } },

   /* ('~flrp@32', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a') */
   /* search175_0 -> 16 in the cache */
   /* search175_1_0 -> 16 in the cache */
   /* search175_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 16, 36 },
      0,
   } },
   /* search175_2 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 16, 558, 141 },
      -1,
   } },

   /* replace175_0_0 -> 254 in the cache */
   /* replace175_0_1 -> 36 in the cache */
   /* replace175_0_2 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 254, 36, 141 },
      -1,
   } },
   /* replace175_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 560, 16 },
      -1,
   } },

   /* ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c') */
   /* search176_0_0 -> 16 in the cache */
   /* search176_0_1_0 -> 254 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 562 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 254, 563 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 16, 564 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search176_1_1 -> 562 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 566, 562 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 565, 567 },
      -1,
   } },

   /* replace176_0 -> 16 in the cache */
   /* replace176_1 -> 566 in the cache */
   /* replace176_2 -> 562 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 16, 566, 562 },
      -1,
   } },

   /* ('~fadd@32', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c')) */
   /* search177_0_0 -> 16 in the cache */
   /* search177_0_1_0_0 -> 254 in the cache */
   /* search177_0_1_0_1_0 -> 562 in the cache */
   /* search177_0_1_0_1 -> 563 in the cache */
   /* search177_0_1_0 -> 564 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 564 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 16, 570 },
      -1,
   } },
   /* search177_1_0 -> 566 in the cache */
   /* search177_1_1_0 -> 562 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 562 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 566, 572 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 571, 573 },
      -1,
   } },

   /* replace177_0 -> 16 in the cache */
   /* replace177_1 -> 566 in the cache */
   /* replace177_2_0 -> 562 in the cache */
   /* replace177_2 -> 572 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 16, 566, 572 },
      -1,
   } },

   /* ('~fadd@32', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c') */
   /* search178_0 -> 16 in the cache */
   /* search178_1_0 -> 562 in the cache */
   /* search178_1_1_0 -> 566 in the cache */
   /* search178_1_1_1_0 -> 16 in the cache */
   /* search178_1_1_1 -> 290 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 566, 290 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 562, 576 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 16, 577 },
      -1,
   } },

   /* replace178_0 -> 16 in the cache */
   /* replace178_1 -> 566 in the cache */
   /* replace178_2 -> 562 in the cache */
   /* replace178 -> 569 in the cache */

   /* ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a') */
   /* search179_0_0 -> 16 in the cache */
   /* search179_0_1_0 -> 254 in the cache */
   /* search179_0_1_1_0_0 -> 509 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 509 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 579 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 254, 580 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 16, 581 },
      -1,
   } },
   /* search179_1_0 -> 566 in the cache */
   /* search179_1_1_0 -> 509 in the cache */
   /* search179_1_1 -> 579 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 566, 579 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 582, 583 },
      -1,
   } },

   /* replace179_0 -> 509 in the cache */
   /* replace179_1 -> 566 in the cache */
   /* replace179_2 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 509, 566, 16 },
      -1,
   } },

   /* ('~fadd@32', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a') */
   /* search180_0 -> 16 in the cache */
   /* search180_1_0_0 -> 509 in the cache */
   /* search180_1_0 -> 579 in the cache */
   /* search180_1_1_0 -> 566 in the cache */
   /* search180_1_1_1_0 -> 16 in the cache */
   /* search180_1_1_1 -> 290 in the cache */
   /* search180_1_1 -> 576 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 579, 576 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 16, 586 },
      -1,
   } },

   /* replace180_0 -> 509 in the cache */
   /* replace180_1 -> 566 in the cache */
   /* replace180_2 -> 16 in the cache */
   /* replace180 -> 585 in the cache */

   /* ('~ffma@32', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a') */
   /* search181_0 -> 16 in the cache */
   /* search181_1_0 -> 254 in the cache */
   /* search181_1_1_0_0 -> 509 in the cache */
   /* search181_1_1_0 -> 579 in the cache */
   /* search181_1_1 -> 580 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 254, 580 },
      -1,
   } },
   /* search181_2_0 -> 566 in the cache */
   /* search181_2_1_0 -> 509 in the cache */
   /* search181_2_1 -> 579 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 566, 579 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 16, 588, 589 },
      -1,
   } },

   /* replace181_0 -> 509 in the cache */
   /* replace181_1 -> 566 in the cache */
   /* replace181_2 -> 16 in the cache */
   /* replace181 -> 585 in the cache */

   /* ('~ffma@32', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a') */
   /* search182_0 -> 383 in the cache */
   /* search182_1_0 -> 509 in the cache */
   /* search182_1 -> 579 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 591 },
      -1,
   } },
   /* search182_2_1_0 -> 509 in the cache */
   /* search182_2_1 -> 579 in the cache */
   /* search182_2_2 -> 591 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 592, 579, 591 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 383, 579, 593 },
      -1,
   } },

   /* replace182_0 -> 509 in the cache */
   /* replace182_1 -> 383 in the cache */
   /* replace182_2 -> 591 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 509, 383, 591 },
      -1,
   } },

   /* ('~ffma@32', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a') */
   /* search183_0_0 -> 528 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 528 },
      -1,
   } },
   /* search183_1_0 -> 36 in the cache */
   /* search183_1_1_0 -> 591 in the cache */
   /* search183_1_1 -> 592 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 36, 592 },
      -1,
   } },
   /* search183_2 -> 591 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 596, 597, 591 },
      -1,
   } },

   /* replace183_0 -> 528 in the cache */
   /* replace183_1 -> 36 in the cache */
   /* replace183_2 -> 591 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 528, 36, 591 },
      -1,
   } },

   /* ('~ffma@32', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b')) */
   /* search184_0_0 -> 528 in the cache */
   /* search184_0 -> 596 in the cache */
   /* search184_1_0_0 -> 189 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 189 },
      -1,
   } },
   /* search184_1_1 -> 566 in the cache */
   /* search184_1_2 -> 169 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 600, 566, 169 },
      -1,
   } },
   /* search184_2_0 -> 189 in the cache */
   /* search184_2_1 -> 566 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 189, 566 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 596, 601, 602 },
      -1,
   } },

   /* replace184_0 -> 528 in the cache */
   /* replace184_1 -> 169 in the cache */
   /* replace184_2_0 -> 189 in the cache */
   /* replace184_2_1 -> 566 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 189, 566 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 528, 169, 604 },
      -1,
   } },

   /* ('~fadd@32', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a') */
   /* search185_0 -> 254 in the cache */
   /* search185_1_0_0_0 -> 254 in the cache */
   /* search185_1_0_0_1_0 -> 16 in the cache */
   /* search185_1_0_0_1 -> 290 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 254, 290 },
      -1,
   } },
   /* search185_1_0_1_0 -> 254 in the cache */
   /* search185_1_0_1_1_0 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      3, 1,
      { 254, 607 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 3,
      { 606, 608 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 3,
      { 609 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 254, 610 },
      -1,
   } },

   /* replace185_0 -> 36 in the cache */
   /* replace185_1 -> 254 in the cache */
   /* replace185_2 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 36, 254, 16 },
      -1,
   } },

   /* ('~flrp@64', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a') */
   /* search186_0 -> 21 in the cache */
   /* search186_1 -> 41 in the cache */
   /* search186_2_0 -> 471 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 471 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 21, 41, 613 },
      -1,
   } },

   /* replace186_0 -> 471 in the cache */
   /* replace186_1 -> 41 in the cache */
   /* replace186_2 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 471, 41, 21 },
      -1,
   } },

   /* ('~flrp@64', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a') */
   /* search187_0 -> 21 in the cache */
   /* search187_1_0 -> 21 in the cache */
   /* search187_1_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 21, 41 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 64 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 21, 616, 617 },
      -1,
   } },

   /* replace187_0_0 -> 41 in the cache */
   /* replace187_0_1 -> 617 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 41, 617 },
      -1,
   } },
   /* replace187_1 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 619, 21 },
      -1,
   } },

   /* ('~flrp@64', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a') */
   /* search188_0_0 -> 21 in the cache */
   /* search188_0_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 21, 41 },
      0,
   } },
   /* search188_1_0 -> 21 in the cache */
   /* search188_1_1 -> 617 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 21, 617 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, 64 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 2,
      { 621, 622, 623 },
      -1,
   } },

   /* replace188_0_0 -> 41 in the cache */
   /* replace188_0_1 -> 617 in the cache */
   /* replace188_0_2 -> 623 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 41, 617, 623 },
      -1,
   } },
   /* replace188_1 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 625, 21 },
      -1,
   } },

   /* ('~flrp@64', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a') */
   /* search189_0 -> 21 in the cache */
   /* search189_1_0 -> 21 in the cache */
   /* search189_1_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 21, 41 },
      0,
   } },
   /* search189_2 -> 617 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 21, 627, 617 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
   } },
   /* replace189_0_1 -> 41 in the cache */
   /* replace189_0_2 -> 617 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 629, 41, 617 },
      -1,
   } },
   /* replace189_1 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 630, 21 },
      -1,
   } },

   /* ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c') */
   /* search190_0_0 -> 21 in the cache */
   /* search190_0_1_0 -> 629 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 632 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 629, 633 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 21, 634 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 64 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search190_1_1 -> 632 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 636, 632 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 635, 637 },
      -1,
   } },

   /* replace190_0 -> 21 in the cache */
   /* replace190_1 -> 636 in the cache */
   /* replace190_2 -> 632 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 21, 636, 632 },
      -1,
   } },

   /* ('~fadd@64', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c')) */
   /* search191_0_0 -> 21 in the cache */
   /* search191_0_1_0_0 -> 629 in the cache */
   /* search191_0_1_0_1_0 -> 632 in the cache */
   /* search191_0_1_0_1 -> 633 in the cache */
   /* search191_0_1_0 -> 634 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 634 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 21, 640 },
      -1,
   } },
   /* search191_1_0 -> 636 in the cache */
   /* search191_1_1_0 -> 632 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 632 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 636, 642 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 641, 643 },
      -1,
   } },

   /* replace191_0 -> 21 in the cache */
   /* replace191_1 -> 636 in the cache */
   /* replace191_2_0 -> 632 in the cache */
   /* replace191_2 -> 642 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 21, 636, 642 },
      -1,
   } },

   /* ('~fadd@64', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c') */
   /* search192_0 -> 21 in the cache */
   /* search192_1_0 -> 632 in the cache */
   /* search192_1_1_0 -> 636 in the cache */
   /* search192_1_1_1_0 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 21 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 636, 646 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 632, 647 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 21, 648 },
      -1,
   } },

   /* replace192_0 -> 21 in the cache */
   /* replace192_1 -> 636 in the cache */
   /* replace192_2 -> 632 in the cache */
   /* replace192 -> 639 in the cache */

   /* ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a') */
   /* search193_0_0 -> 21 in the cache */
   /* search193_0_1_0 -> 629 in the cache */
   /* search193_0_1_1_0_0 -> 509 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 509 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 650 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 629, 651 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 21, 652 },
      -1,
   } },
   /* search193_1_0 -> 636 in the cache */
   /* search193_1_1_0 -> 509 in the cache */
   /* search193_1_1 -> 650 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 636, 650 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 653, 654 },
      -1,
   } },

   /* replace193_0 -> 509 in the cache */
   /* replace193_1 -> 636 in the cache */
   /* replace193_2 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 509, 636, 21 },
      -1,
   } },

   /* ('~fadd@64', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a') */
   /* search194_0 -> 21 in the cache */
   /* search194_1_0_0 -> 509 in the cache */
   /* search194_1_0 -> 650 in the cache */
   /* search194_1_1_0 -> 636 in the cache */
   /* search194_1_1_1_0 -> 21 in the cache */
   /* search194_1_1_1 -> 646 in the cache */
   /* search194_1_1 -> 647 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 650, 647 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 21, 657 },
      -1,
   } },

   /* replace194_0 -> 509 in the cache */
   /* replace194_1 -> 636 in the cache */
   /* replace194_2 -> 21 in the cache */
   /* replace194 -> 656 in the cache */

   /* ('~ffma@64', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a') */
   /* search195_0 -> 21 in the cache */
   /* search195_1_0 -> 629 in the cache */
   /* search195_1_1_0_0 -> 509 in the cache */
   /* search195_1_1_0 -> 650 in the cache */
   /* search195_1_1 -> 651 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 629, 651 },
      -1,
   } },
   /* search195_2_0 -> 636 in the cache */
   /* search195_2_1_0 -> 509 in the cache */
   /* search195_2_1 -> 650 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 636, 650 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 21, 659, 660 },
      -1,
   } },

   /* replace195_0 -> 509 in the cache */
   /* replace195_1 -> 636 in the cache */
   /* replace195_2 -> 21 in the cache */
   /* replace195 -> 656 in the cache */

   /* ('~ffma@64', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a') */
   { .variable = {
      { nir_search_value_variable, 64 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search196_1_0 -> 509 in the cache */
   /* search196_1 -> 650 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      2, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 663 },
      -1,
   } },
   /* search196_2_1_0 -> 509 in the cache */
   /* search196_2_1 -> 650 in the cache */
   /* search196_2_2 -> 663 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 664, 650, 663 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 662, 650, 665 },
      -1,
   } },

   /* replace196_0 -> 509 in the cache */
   /* replace196_1 -> 662 in the cache */
   /* replace196_2 -> 663 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 509, 662, 663 },
      -1,
   } },

   /* ('~ffma@64', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a') */
   /* search197_0_0 -> 528 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 528 },
      -1,
   } },
   /* search197_1_0 -> 41 in the cache */
   /* search197_1_1_0 -> 663 in the cache */
   /* search197_1_1 -> 664 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 41, 664 },
      -1,
   } },
   /* search197_2 -> 663 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 668, 669, 663 },
      -1,
   } },

   /* replace197_0 -> 528 in the cache */
   /* replace197_1 -> 41 in the cache */
   /* replace197_2 -> 663 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 528, 41, 663 },
      -1,
   } },

   /* ('~ffma@64', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b')) */
   /* search198_0_0 -> 528 in the cache */
   /* search198_0 -> 668 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 672 },
      -1,
   } },
   /* search198_1_1 -> 636 in the cache */
   /* search198_1_2 -> 623 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 673, 636, 623 },
      -1,
   } },
   /* search198_2_0 -> 672 in the cache */
   /* search198_2_1 -> 636 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 672, 636 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 668, 674, 675 },
      -1,
   } },

   /* replace198_0 -> 528 in the cache */
   /* replace198_1 -> 623 in the cache */
   /* replace198_2_0 -> 672 in the cache */
   /* replace198_2_1 -> 636 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 672, 636 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 528, 623, 677 },
      -1,
   } },

   /* ('~fadd@64', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a') */
   /* search199_0 -> 629 in the cache */
   /* search199_1_0_0_0 -> 629 in the cache */
   /* search199_1_0_0_1_0 -> 21 in the cache */
   /* search199_1_0_0_1 -> 646 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 629, 646 },
      -1,
   } },
   /* search199_1_0_1_0 -> 629 in the cache */
   /* search199_1_0_1_1_0 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 41 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      3, 1,
      { 629, 680 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 3,
      { 679, 681 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 3,
      { 682 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 629, 683 },
      -1,
   } },

   /* replace199_0 -> 41 in the cache */
   /* replace199_1 -> 629 in the cache */
   /* replace199_2 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 41, 629, 21 },
      -1,
   } },

   /* ('~flrp', ('fmul(is_used_once)', 'a', 'b'), ('fmul(is_used_once)', 'a', 'c'), 'd') => ('fmul', ('flrp', 'b', 'c', 'd'), 'a') */
   /* search200_0_0 -> 155 in the cache */
   /* search200_0_1 -> 156 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 155, 156 },
      0,
   } },
   /* search200_1_0 -> 155 in the cache */
   /* search200_1_1 -> 158 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 155, 158 },
      0,
   } },
   /* search200_2 -> 159 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 2,
      { 686, 687, 159 },
      -1,
   } },

   /* replace200_0_0 -> 156 in the cache */
   /* replace200_0_1 -> 158 in the cache */
   /* replace200_0_2 -> 159 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 156, 158, 159 },
      -1,
   } },
   /* replace200_1 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 689, 155 },
      -1,
   } },

   /* ('~flrp', 'a', 0.0, 'c') => ('fadd', ('fmul', ('fneg', 'a'), 'c'), 'a') */
   /* search201_0 -> 0 in the cache */
   /* search201_1 -> 266 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 0, 266, 691 },
      -1,
   } },

   /* replace201_0_0_0 -> 0 in the cache */
   /* replace201_0_0 -> 223 in the cache */
   /* replace201_0_1 -> 691 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 223, 691 },
      -1,
   } },
   /* replace201_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 693, 0 },
      -1,
   } },

   /* ('ftrunc@16', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a'))) */
   /* search202_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ftrunc,
      -1, 0,
      { 11 },
      -1,
   } },

   /* replace202_0_0 -> 11 in the cache */
   /* replace202_0_1 -> 119 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 11, 119 },
      -1,
   } },
   /* replace202_1_0_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 697 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 698 },
      -1,
   } },
   /* replace202_2_0_0 -> 11 in the cache */
   /* replace202_2_0 -> 697 in the cache */
   /* replace202_2 -> 698 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 696, 699, 698 },
      -1,
   } },

   /* ('ftrunc@32', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a'))) */
   /* search203_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ftrunc,
      -1, 0,
      { 16 },
      -1,
   } },

   /* replace203_0_0 -> 16 in the cache */
   /* replace203_0_1 -> 121 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 16, 121 },
      -1,
   } },
   /* replace203_1_0_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 703 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 704 },
      -1,
   } },
   /* replace203_2_0_0 -> 16 in the cache */
   /* replace203_2_0 -> 703 in the cache */
   /* replace203_2 -> 704 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 702, 705, 704 },
      -1,
   } },

   /* ('ftrunc@64', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a'))) */
   /* search204_0 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ftrunc,
      -1, 0,
      { 21 },
      -1,
   } },

   /* replace204_0_0 -> 21 in the cache */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_float, { 0x0 /* 0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 21, 708 },
      -1,
   } },
   /* replace204_1_0_0_0 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 21 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 710 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 711 },
      -1,
   } },
   /* replace204_2_0_0 -> 21 in the cache */
   /* replace204_2_0 -> 710 in the cache */
   /* replace204_2 -> 711 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 709, 712, 711 },
      -1,
   } },

   /* ('ffloor@16', 'a') => ('fsub', 'a', ('ffract', 'a')) */
   /* search205_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 11 },
      -1,
   } },

   /* replace205_0 -> 11 in the cache */
   /* replace205_1_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 0,
      { 11, 715 },
      -1,
   } },

   /* ('ffloor@32', 'a') => ('fsub', 'a', ('ffract', 'a')) */
   /* search206_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 16 },
      -1,
   } },

   /* replace206_0 -> 16 in the cache */
   /* replace206_1_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 0,
      { 16, 718 },
      -1,
   } },

   /* ('ffloor@64', 'a') => ('fsub', 'a', ('ffract', 'a')) */
   /* search207_0 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 21 },
      -1,
   } },

   /* replace207_0 -> 21 in the cache */
   /* replace207_1_0 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 0,
      { 21 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 0,
      { 21, 721 },
      -1,
   } },

   /* ('fadd@16', 'a', ('fadd@16', 'b', ('fneg', ('ffract', 'a')))) => ('fadd@16', 'b', ('ffloor', 'a')) */
   /* search208_0 -> 11 in the cache */
   /* search208_1_0 -> 268 in the cache */
   /* search208_1_1_0_0 -> 11 in the cache */
   /* search208_1_1_0 -> 715 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 715 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 268, 723 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 11, 724 },
      -1,
   } },

   /* replace208_0 -> 268 in the cache */
   /* replace208_1_0 -> 11 in the cache */
   /* replace208_1 -> 714 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 268, 714 },
      -1,
   } },

   /* ('fadd@32', 'a', ('fadd@32', 'b', ('fneg', ('ffract', 'a')))) => ('fadd@32', 'b', ('ffloor', 'a')) */
   /* search209_0 -> 16 in the cache */
   /* search209_1_0 -> 36 in the cache */
   /* search209_1_1_0_0 -> 16 in the cache */
   /* search209_1_1_0 -> 718 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 718 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 36, 727 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 16, 728 },
      -1,
   } },

   /* replace209_0 -> 36 in the cache */
   /* replace209_1_0 -> 16 in the cache */
   /* replace209_1 -> 717 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 36, 717 },
      -1,
   } },

   /* ('fadd@64', 'a', ('fadd@64', 'b', ('fneg', ('ffract', 'a')))) => ('fadd@64', 'b', ('ffloor', 'a')) */
   /* search210_0 -> 21 in the cache */
   /* search210_1_0 -> 41 in the cache */
   /* search210_1_1_0_0 -> 21 in the cache */
   /* search210_1_1_0 -> 721 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 721 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 41, 731 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 21, 732 },
      -1,
   } },

   /* replace210_0 -> 41 in the cache */
   /* replace210_1_0 -> 21 in the cache */
   /* replace210_1 -> 720 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 41, 720 },
      -1,
   } },

   /* ('fadd@16', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a') */
   /* search211_0 -> 11 in the cache */
   /* search211_1_0_0 -> 11 in the cache */
   /* search211_1_0 -> 715 in the cache */
   /* search211_1 -> 723 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 11, 723 },
      -1,
   } },

   /* replace211_0 -> 11 in the cache */
   /* replace211 -> 714 in the cache */

   /* ('fadd@32', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a') */
   /* search212_0 -> 16 in the cache */
   /* search212_1_0_0 -> 16 in the cache */
   /* search212_1_0 -> 718 in the cache */
   /* search212_1 -> 727 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 16, 727 },
      -1,
   } },

   /* replace212_0 -> 16 in the cache */
   /* replace212 -> 717 in the cache */

   /* ('fadd@64', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a') */
   /* search213_0 -> 21 in the cache */
   /* search213_1_0_0 -> 21 in the cache */
   /* search213_1_0 -> 721 in the cache */
   /* search213_1 -> 731 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 21, 731 },
      -1,
   } },

   /* replace213_0 -> 21 in the cache */
   /* replace213 -> 720 in the cache */

   /* ('ffract@16', 'a') => ('fsub', 'a', ('ffloor', 'a')) */
   /* search214_0 -> 11 in the cache */
   /* search214 -> 715 in the cache */

   /* replace214_0 -> 11 in the cache */
   /* replace214_1_0 -> 11 in the cache */
   /* replace214_1 -> 714 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 0,
      { 11, 714 },
      -1,
   } },

   /* ('ffract@32', 'a') => ('fsub', 'a', ('ffloor', 'a')) */
   /* search215_0 -> 16 in the cache */
   /* search215 -> 718 in the cache */

   /* replace215_0 -> 16 in the cache */
   /* replace215_1_0 -> 16 in the cache */
   /* replace215_1 -> 717 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 0,
      { 16, 717 },
      -1,
   } },

   /* ('ffract@64', 'a') => ('fsub', 'a', ('ffloor', 'a')) */
   /* search216_0 -> 21 in the cache */
   /* search216 -> 721 in the cache */

   /* replace216_0 -> 21 in the cache */
   /* replace216_1_0 -> 21 in the cache */
   /* replace216_1 -> 720 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 0,
      { 21, 720 },
      -1,
   } },

   /* ('fceil', 'a') => ('fneg', ('ffloor', ('fneg', 'a'))) */
   /* search217_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fceil,
      -1, 0,
      { 32 },
      -1,
   } },

   /* replace217_0_0_0 -> 32 in the cache */
   /* replace217_0_0 -> 107 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 107 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 742 },
      -1,
   } },

   /* ('ffma@16', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search218_0 -> 11 in the cache */
   /* search218_1 -> 268 in the cache */
   /* search218_2 -> 476 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 11, 268, 476 },
      -1,
   } },

   /* replace218_0_0 -> 11 in the cache */
   /* replace218_0_1 -> 268 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 11, 268 },
      -1,
   } },
   /* replace218_1 -> 476 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 745, 476 },
      -1,
   } },

   /* ('ffma@32', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search219_0 -> 16 in the cache */
   /* search219_1 -> 36 in the cache */
   /* search219_2 -> 141 in the cache */
   /* search219 -> 245 in the cache */

   /* replace219_0_0 -> 16 in the cache */
   /* replace219_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 16, 36 },
      -1,
   } },
   /* replace219_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 747, 141 },
      -1,
   } },

   /* ('ffma@64', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search220_0 -> 21 in the cache */
   /* search220_1 -> 41 in the cache */
   /* search220_2 -> 617 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 21, 41, 617 },
      -1,
   } },

   /* replace220_0_0 -> 21 in the cache */
   /* replace220_0_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 21, 41 },
      -1,
   } },
   /* replace220_1 -> 617 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 750, 617 },
      -1,
   } },

   /* ('ffmaz', 'a', 'b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c') */
   /* search221_0 -> 16 in the cache */
   /* search221_1 -> 36 in the cache */
   /* search221_2 -> 141 in the cache */
   /* search221 -> 397 in the cache */

   /* replace221_0_0 -> 16 in the cache */
   /* replace221_0_1 -> 36 in the cache */
   /* replace221_0 -> 140 in the cache */
   /* replace221_1 -> 141 in the cache */
   /* replace221 -> 298 in the cache */

   /* ('~ffma@16', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search222_0 -> 11 in the cache */
   /* search222_1 -> 268 in the cache */
   /* search222_2 -> 476 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 11, 268, 476 },
      -1,
   } },

   /* replace222_0_0 -> 11 in the cache */
   /* replace222_0_1 -> 268 in the cache */
   /* replace222_0 -> 745 in the cache */
   /* replace222_1 -> 476 in the cache */
   /* replace222 -> 746 in the cache */

   /* ('~ffma@32', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search223_0 -> 16 in the cache */
   /* search223_1 -> 36 in the cache */
   /* search223_2 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 16, 36, 141 },
      -1,
   } },

   /* replace223_0_0 -> 16 in the cache */
   /* replace223_0_1 -> 36 in the cache */
   /* replace223_0 -> 747 in the cache */
   /* replace223_1 -> 141 in the cache */
   /* replace223 -> 748 in the cache */

   /* ('~ffma@64', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search224_0 -> 21 in the cache */
   /* search224_1 -> 41 in the cache */
   /* search224_2 -> 617 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 21, 41, 617 },
      -1,
   } },

   /* replace224_0_0 -> 21 in the cache */
   /* replace224_0_1 -> 41 in the cache */
   /* replace224_0 -> 750 in the cache */
   /* replace224_1 -> 617 in the cache */
   /* replace224 -> 751 in the cache */

   /* ('~ffmaz', 'a', 'b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c') */
   /* search225_0 -> 16 in the cache */
   /* search225_1 -> 36 in the cache */
   /* search225_2 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 16, 36, 141 },
      -1,
   } },

   /* replace225_0_0 -> 16 in the cache */
   /* replace225_0_1 -> 36 in the cache */
   /* replace225_0 -> 140 in the cache */
   /* replace225_1 -> 141 in the cache */
   /* replace225 -> 298 in the cache */

   /* ('~fmul', ('fadd', ('iand', ('ineg', ('b2i', 'a@bool')), ('fmul', 'b', 'c')), '#d'), '#e') => ('bcsel', 'a', ('fmul', ('fadd', ('fmul', 'b', 'c'), 'd'), 'e'), ('fmul', 'd', 'e')) */
   { .variable = {
      { nir_search_value_variable, 1 },
      0, /* a */
      false,
      nir_type_bool,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 0,
      { 756 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 757 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 759, 760 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_iand,
      2, 2,
      { 758, 761 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      3, /* d */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 3,
      { 762, 763 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      4, /* e */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      true,
      false,
      false,
      nir_op_fmul,
      0, 4,
      { 764, 765 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, 1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* replace226_1_0_0_0 -> 759 in the cache */
   /* replace226_1_0_0_1 -> 760 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 759, 760 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 2,
      { 768, 769 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      4, /* e */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 3,
      { 770, 771 },
      -1,
   } },
   /* replace226_2_0 -> 769 in the cache */
   /* replace226_2_1 -> 771 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 769, 771 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 767, 772, 773 },
      -1,
   } },

   /* ('fdph', 'a', 'b') => ('fdot4', ('vec4', 'a.x', 'a.y', 'a.z', 1.0), 'b') */
   /* search227_0 -> 0 in the cache */
   /* search227_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fdph,
      -1, 0,
      { 0, 3 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {1},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {2},
   } },
   /* replace227_0_3 -> 280 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_vec4,
      -1, 0,
      { 776, 777, 778, 280 },
      -1,
   } },
   /* replace227_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 779, 3 },
      -1,
   } },

   /* ('fdot4', 'a', 0.0) => 0.0 */
   /* search228_0 -> 32 in the cache */
   /* search228_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 32, 117 },
      -1,
   } },

   /* replace228 -> 117 in the cache */

   /* ('fdot3', 'a', 0.0) => 0.0 */
   /* search229_0 -> 32 in the cache */
   /* search229_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fdot3,
      0, 1,
      { 32, 117 },
      -1,
   } },

   /* replace229 -> 117 in the cache */

   /* ('fdot2', 'a', 0.0) => 0.0 */
   /* search230_0 -> 32 in the cache */
   /* search230_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fdot2,
      0, 1,
      { 32, 117 },
      -1,
   } },

   /* replace230 -> 117 in the cache */

   /* ('fdot4', ('vec4', 'a', 'b', 'c', 1.0), 'd') => ('fdph', ('vec3', 'a', 'b', 'c'), 'd') */
   /* search231_0_0 -> 155 in the cache */
   /* search231_0_1 -> 156 in the cache */
   /* search231_0_2 -> 158 in the cache */
   { .constant = {
      { nir_search_value_constant, -4 },
      nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_vec4,
      -1, 0,
      { 155, 156, 158, 784 },
      -1,
   } },
   /* search231_1 -> 159 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 785, 159 },
      -1,
   } },

   /* replace231_0_0 -> 155 in the cache */
   /* replace231_0_1 -> 156 in the cache */
   /* replace231_0_2 -> 158 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_vec3,
      -1, 0,
      { 155, 156, 158 },
      -1,
   } },
   /* replace231_1 -> 159 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fdph,
      -1, 0,
      { 787, 159 },
      -1,
   } },

   /* ('fdot4', ('vec4', 'a', 0.0, 0.0, 0.0), 'b') => ('fmul', 'a', 'b') */
   /* search232_0_0 -> 0 in the cache */
   /* search232_0_1 -> 266 in the cache */
   /* search232_0_2 -> 266 in the cache */
   /* search232_0_3 -> 266 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_vec4,
      -1, 0,
      { 0, 266, 266, 266 },
      -1,
   } },
   /* search232_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 789, 3 },
      -1,
   } },

   /* replace232_0 -> 0 in the cache */
   /* replace232_1 -> 3 in the cache */
   /* replace232 -> 274 in the cache */

   /* ('fdot4', ('vec4', 'a', 'b', 0.0, 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c') */
   /* search233_0_0 -> 132 in the cache */
   /* search233_0_1 -> 133 in the cache */
   { .constant = {
      { nir_search_value_constant, -3 },
      nir_type_float, { 0x0 /* 0.0 */ },
   } },
   /* search233_0_3 -> 791 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_vec4,
      -1, 0,
      { 132, 133, 791, 791 },
      -1,
   } },
   /* search233_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 792, 135 },
      -1,
   } },

   /* replace233_0_0 -> 132 in the cache */
   /* replace233_0_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_vec2,
      -1, 0,
      { 132, 133 },
      -1,
   } },
   /* replace233_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fdot2,
      0, 1,
      { 794, 135 },
      -1,
   } },

   /* ('fdot4', ('vec4', 'a', 'b', 'c', 0.0), 'd') => ('fdot3', ('vec3', 'a', 'b', 'c'), 'd') */
   /* search234_0_0 -> 155 in the cache */
   /* search234_0_1 -> 156 in the cache */
   /* search234_0_2 -> 158 in the cache */
   { .constant = {
      { nir_search_value_constant, -4 },
      nir_type_float, { 0x0 /* 0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_vec4,
      -1, 0,
      { 155, 156, 158, 796 },
      -1,
   } },
   /* search234_1 -> 159 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 797, 159 },
      -1,
   } },

   /* replace234_0_0 -> 155 in the cache */
   /* replace234_0_1 -> 156 in the cache */
   /* replace234_0_2 -> 158 in the cache */
   /* replace234_0 -> 787 in the cache */
   /* replace234_1 -> 159 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fdot3,
      0, 1,
      { 787, 159 },
      -1,
   } },

   /* ('fdot3', ('vec3', 'a', 0.0, 0.0), 'b') => ('fmul', 'a', 'b') */
   /* search235_0_0 -> 0 in the cache */
   /* search235_0_1 -> 266 in the cache */
   /* search235_0_2 -> 266 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_vec3,
      -1, 0,
      { 0, 266, 266 },
      -1,
   } },
   /* search235_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fdot3,
      0, 1,
      { 800, 3 },
      -1,
   } },

   /* replace235_0 -> 0 in the cache */
   /* replace235_1 -> 3 in the cache */
   /* replace235 -> 274 in the cache */

   /* ('fdot3', ('vec3', 'a', 'b', 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c') */
   /* search236_0_0 -> 132 in the cache */
   /* search236_0_1 -> 133 in the cache */
   /* search236_0_2 -> 791 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_vec3,
      -1, 0,
      { 132, 133, 791 },
      -1,
   } },
   /* search236_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fdot3,
      0, 1,
      { 802, 135 },
      -1,
   } },

   /* replace236_0_0 -> 132 in the cache */
   /* replace236_0_1 -> 133 in the cache */
   /* replace236_0 -> 794 in the cache */
   /* replace236_1 -> 135 in the cache */
   /* replace236 -> 795 in the cache */

   /* ('fdot2', ('vec2', 'a', 0.0), 'b') => ('fmul', 'a', 'b') */
   /* search237_0_0 -> 0 in the cache */
   /* search237_0_1 -> 266 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_vec2,
      -1, 0,
      { 0, 266 },
      -1,
   } },
   /* search237_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fdot2,
      0, 1,
      { 804, 3 },
      -1,
   } },

   /* replace237_0 -> 0 in the cache */
   /* replace237_1 -> 3 in the cache */
   /* replace237 -> 274 in the cache */

   /* ('fdot2', 'a', 1.0) => ('fadd', 'a.x', 'a.y') */
   /* search238_0 -> 32 in the cache */
   /* search238_1 -> 252 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fdot2,
      0, 1,
      { 32, 252 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0},
   } },
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {1},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      -1, 0,
      { 807, 808 },
      -1,
   } },

   /* ('fdot2', 'a', 'b') => ('fsum2', ('fmul', 'a', 'b')) */
   /* search239_0 -> 0 in the cache */
   /* search239_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fdot2,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace239_0_0 -> 0 in the cache */
   /* replace239_0_1 -> 3 in the cache */
   /* replace239_0 -> 274 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsum2,
      -1, 1,
      { 274 },
      -1,
   } },

   /* ('fdot3', 'a', 'b') => ('fsum3', ('fmul', 'a', 'b')) */
   /* search240_0 -> 0 in the cache */
   /* search240_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fdot3,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace240_0_0 -> 0 in the cache */
   /* replace240_0_1 -> 3 in the cache */
   /* replace240_0 -> 274 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsum3,
      -1, 1,
      { 274 },
      -1,
   } },

   /* ('fdot4', 'a', 'b') => ('fsum4', ('fmul', 'a', 'b')) */
   /* search241_0 -> 0 in the cache */
   /* search241_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace241_0_0 -> 0 in the cache */
   /* replace241_0_1 -> 3 in the cache */
   /* replace241_0 -> 274 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsum4,
      -1, 1,
      { 274 },
      -1,
   } },

   /* ('fsum2', 'a') => ('fadd', 'a.x', 'a.y') */
   /* search242_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsum2,
      -1, 0,
      { 32 },
      -1,
   } },

   /* replace242_0 -> 807 in the cache */
   /* replace242_1 -> 808 in the cache */
   /* replace242 -> 809 in the cache */

   /* ('~fadd', ('fneg(is_used_once)', ('fsat(is_used_once)', 'a(is_not_fmul)')), 1.0) => ('fsat', ('fadd', 1.0, ('fneg', 'a'))) */
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      8,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 817 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 818 },
      0,
   } },
   /* search243_1 -> 252 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 819, 252 },
      -1,
   } },

   /* replace243_0_0 -> 252 in the cache */
   /* replace243_0_1_0 -> 32 in the cache */
   /* replace243_0_1 -> 107 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 252, 107 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 821 },
      -1,
   } },

   /* ('ishl', ('iadd', ('imul', 'a', '#b'), '#c'), '#d') => ('iadd', ('imul', 'a', ('ishl', 'b', 'd')), ('ishl', 'c', 'd')) */
   /* search244_0_0_0 -> 132 in the cache */
   /* search244_0_0_1 -> 293 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imul,
      1, 1,
      { 132, 293 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -3 },
      2, /* c */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 823, 824 },
      -1,
   } },
   /* search244_1 -> 321 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 2,
      { 825, 321 },
      -1,
   } },

   /* replace244_0_0 -> 132 in the cache */
   /* replace244_0_1_0 -> 133 in the cache */
   /* replace244_0_1_1 -> 169 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 133, 169 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imul,
      1, 1,
      { 132, 827 },
      -1,
   } },
   /* replace244_1_0 -> 135 in the cache */
   /* replace244_1_1 -> 169 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 135, 169 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 828, 829 },
      -1,
   } },

   /* ('ishl', ('imul', 'a', '#b'), '#c') => ('imul', 'a', ('ishl', 'b', 'c')) */
   /* search245_0_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 0, 831 },
      -1,
   } },
   /* search245_1 -> 319 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 832, 319 },
      -1,
   } },

   /* replace245_0 -> 0 in the cache */
   /* replace245_1_0 -> 3 in the cache */
   /* replace245_1_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 3, 141 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 0, 834 },
      -1,
   } },

   /* ('ishl@8', ('ishl@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 8), ('ishl@8', 'a', ('iadd', 'b', 'c')), 0) */
   /* search246_0_0 -> 6 in the cache */
   /* search246_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 6, 33 },
      -1,
   } },
   /* search246_1 -> 319 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 836, 319 },
      -1,
   } },

   /* replace246_0_0_0_0 -> 36 in the cache */
   /* replace246_0_0_0_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 36, 9 },
      -1,
   } },
   /* replace246_0_0_1_0 -> 141 in the cache */
   /* replace246_0_0_1_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 141, 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 838, 839 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x8 /* 8 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 3,
      { 840, 841 },
      -1,
   } },
   /* replace246_1_0 -> 6 in the cache */
   /* replace246_1_1_0 -> 36 in the cache */
   /* replace246_1_1_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      3, 1,
      { 36, 141 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 6, 843 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { 0x0 /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 842, 844, 845 },
      -1,
   } },

   /* ('ushr@8', ('ushr@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 8), ('ushr@8', 'a', ('iadd', 'b', 'c')), 0) */
   /* search247_0_0 -> 6 in the cache */
   /* search247_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 6, 33 },
      -1,
   } },
   /* search247_1 -> 319 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 847, 319 },
      -1,
   } },

   /* replace247_0_0_0_0 -> 36 in the cache */
   /* replace247_0_0_0_1 -> 9 in the cache */
   /* replace247_0_0_0 -> 838 in the cache */
   /* replace247_0_0_1_0 -> 141 in the cache */
   /* replace247_0_0_1_1 -> 9 in the cache */
   /* replace247_0_0_1 -> 839 in the cache */
   /* replace247_0_0 -> 840 in the cache */
   /* replace247_0_1 -> 841 in the cache */
   /* replace247_0 -> 842 in the cache */
   /* replace247_1_0 -> 6 in the cache */
   /* replace247_1_1_0 -> 36 in the cache */
   /* replace247_1_1_1 -> 141 in the cache */
   /* replace247_1_1 -> 843 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 6, 843 },
      -1,
   } },
   /* replace247_2 -> 845 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 842, 849, 845 },
      -1,
   } },

   /* ('ishr@8', ('ishr@8', 'a', '#b'), '#c') => ('ishr@8', 'a', ('imin', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 7)) */
   /* search248_0_0 -> 6 in the cache */
   /* search248_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 6, 33 },
      -1,
   } },
   /* search248_1 -> 319 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 851, 319 },
      -1,
   } },

   /* replace248_0 -> 6 in the cache */
   /* replace248_1_0_0_0 -> 36 in the cache */
   /* replace248_1_0_0_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 36, 9 },
      -1,
   } },
   /* replace248_1_0_1_0 -> 141 in the cache */
   /* replace248_1_0_1_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      3, 1,
      { 141, 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 853, 854 },
      -1,
   } },
   /* replace248_1_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imin,
      0, 4,
      { 855, 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 4,
      { 6, 856 },
      -1,
   } },

   /* ('ishl@16', ('ishl@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 16), ('ishl@16', 'a', ('iadd', 'b', 'c')), 0) */
   /* search249_0_0 -> 11 in the cache */
   /* search249_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 11, 33 },
      -1,
   } },
   /* search249_1 -> 319 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 858, 319 },
      -1,
   } },

   /* replace249_0_0_0_0 -> 36 in the cache */
   /* replace249_0_0_0_1 -> 14 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 36, 14 },
      -1,
   } },
   /* replace249_0_0_1_0 -> 141 in the cache */
   /* replace249_0_0_1_1 -> 14 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 141, 14 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 860, 861 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x10 /* 16 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 3,
      { 862, 863 },
      -1,
   } },
   /* replace249_1_0 -> 11 in the cache */
   /* replace249_1_1_0 -> 36 in the cache */
   /* replace249_1_1_1 -> 141 in the cache */
   /* replace249_1_1 -> 843 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 11, 843 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0x0 /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 864, 865, 866 },
      -1,
   } },

   /* ('ushr@16', ('ushr@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 16), ('ushr@16', 'a', ('iadd', 'b', 'c')), 0) */
   /* search250_0_0 -> 11 in the cache */
   /* search250_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 11, 33 },
      -1,
   } },
   /* search250_1 -> 319 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 868, 319 },
      -1,
   } },

   /* replace250_0_0_0_0 -> 36 in the cache */
   /* replace250_0_0_0_1 -> 14 in the cache */
   /* replace250_0_0_0 -> 860 in the cache */
   /* replace250_0_0_1_0 -> 141 in the cache */
   /* replace250_0_0_1_1 -> 14 in the cache */
   /* replace250_0_0_1 -> 861 in the cache */
   /* replace250_0_0 -> 862 in the cache */
   /* replace250_0_1 -> 863 in the cache */
   /* replace250_0 -> 864 in the cache */
   /* replace250_1_0 -> 11 in the cache */
   /* replace250_1_1_0 -> 36 in the cache */
   /* replace250_1_1_1 -> 141 in the cache */
   /* replace250_1_1 -> 843 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 11, 843 },
      -1,
   } },
   /* replace250_2 -> 866 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 864, 870, 866 },
      -1,
   } },

   /* ('ishr@16', ('ishr@16', 'a', '#b'), '#c') => ('ishr@16', 'a', ('imin', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 15)) */
   /* search251_0_0 -> 11 in the cache */
   /* search251_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 11, 33 },
      -1,
   } },
   /* search251_1 -> 319 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 872, 319 },
      -1,
   } },

   /* replace251_0 -> 11 in the cache */
   /* replace251_1_0_0_0 -> 36 in the cache */
   /* replace251_1_0_0_1 -> 14 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 36, 14 },
      -1,
   } },
   /* replace251_1_0_1_0 -> 141 in the cache */
   /* replace251_1_0_1_1 -> 14 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      3, 1,
      { 141, 14 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 874, 875 },
      -1,
   } },
   /* replace251_1_1 -> 14 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imin,
      0, 4,
      { 876, 14 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 4,
      { 11, 877 },
      -1,
   } },

   /* ('ishl@32', ('ishl@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 32), ('ishl@32', 'a', ('iadd', 'b', 'c')), 0) */
   /* search252_0_0 -> 16 in the cache */
   /* search252_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 16, 33 },
      -1,
   } },
   /* search252_1 -> 319 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 879, 319 },
      -1,
   } },

   /* replace252_0_0_0_0 -> 36 in the cache */
   /* replace252_0_0_0_1 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 36, 19 },
      -1,
   } },
   /* replace252_0_0_1_0 -> 141 in the cache */
   /* replace252_0_0_1_1 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 141, 19 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 881, 882 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x20 /* 32 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 3,
      { 883, 884 },
      -1,
   } },
   /* replace252_1_0 -> 16 in the cache */
   /* replace252_1_1_0 -> 36 in the cache */
   /* replace252_1_1_1 -> 141 in the cache */
   /* replace252_1_1 -> 843 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 16, 843 },
      -1,
   } },
   /* replace252_2 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 885, 886, 128 },
      -1,
   } },

   /* ('ushr@32', ('ushr@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 32), ('ushr@32', 'a', ('iadd', 'b', 'c')), 0) */
   /* search253_0_0 -> 16 in the cache */
   /* search253_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 16, 33 },
      -1,
   } },
   /* search253_1 -> 319 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 888, 319 },
      -1,
   } },

   /* replace253_0_0_0_0 -> 36 in the cache */
   /* replace253_0_0_0_1 -> 19 in the cache */
   /* replace253_0_0_0 -> 881 in the cache */
   /* replace253_0_0_1_0 -> 141 in the cache */
   /* replace253_0_0_1_1 -> 19 in the cache */
   /* replace253_0_0_1 -> 882 in the cache */
   /* replace253_0_0 -> 883 in the cache */
   /* replace253_0_1 -> 884 in the cache */
   /* replace253_0 -> 885 in the cache */
   /* replace253_1_0 -> 16 in the cache */
   /* replace253_1_1_0 -> 36 in the cache */
   /* replace253_1_1_1 -> 141 in the cache */
   /* replace253_1_1 -> 843 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 16, 843 },
      -1,
   } },
   /* replace253_2 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 885, 890, 128 },
      -1,
   } },

   /* ('ishr@32', ('ishr@32', 'a', '#b'), '#c') => ('ishr@32', 'a', ('imin', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 31)) */
   /* search254_0_0 -> 16 in the cache */
   /* search254_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 16, 33 },
      -1,
   } },
   /* search254_1 -> 319 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 892, 319 },
      -1,
   } },

   /* replace254_0 -> 16 in the cache */
   /* replace254_1_0_0_0 -> 36 in the cache */
   /* replace254_1_0_0_1 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 36, 19 },
      -1,
   } },
   /* replace254_1_0_1_0 -> 141 in the cache */
   /* replace254_1_0_1_1 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      3, 1,
      { 141, 19 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 894, 895 },
      -1,
   } },
   /* replace254_1_1 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imin,
      0, 4,
      { 896, 19 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 4,
      { 16, 897 },
      -1,
   } },

   /* ('ishl@64', ('ishl@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 64), ('ishl@64', 'a', ('iadd', 'b', 'c')), 0) */
   /* search255_0_0 -> 21 in the cache */
   /* search255_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 21, 33 },
      -1,
   } },
   /* search255_1 -> 319 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 899, 319 },
      -1,
   } },

   /* replace255_0_0_0_0 -> 36 in the cache */
   /* replace255_0_0_0_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 36, 24 },
      -1,
   } },
   /* replace255_0_0_1_0 -> 141 in the cache */
   /* replace255_0_0_1_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 141, 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 901, 902 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x40 /* 64 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 3,
      { 903, 904 },
      -1,
   } },
   /* replace255_1_0 -> 21 in the cache */
   /* replace255_1_1_0 -> 36 in the cache */
   /* replace255_1_1_1 -> 141 in the cache */
   /* replace255_1_1 -> 843 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 21, 843 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0x0 /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 905, 906, 907 },
      -1,
   } },

   /* ('ushr@64', ('ushr@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 64), ('ushr@64', 'a', ('iadd', 'b', 'c')), 0) */
   /* search256_0_0 -> 21 in the cache */
   /* search256_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 21, 33 },
      -1,
   } },
   /* search256_1 -> 319 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 909, 319 },
      -1,
   } },

   /* replace256_0_0_0_0 -> 36 in the cache */
   /* replace256_0_0_0_1 -> 24 in the cache */
   /* replace256_0_0_0 -> 901 in the cache */
   /* replace256_0_0_1_0 -> 141 in the cache */
   /* replace256_0_0_1_1 -> 24 in the cache */
   /* replace256_0_0_1 -> 902 in the cache */
   /* replace256_0_0 -> 903 in the cache */
   /* replace256_0_1 -> 904 in the cache */
   /* replace256_0 -> 905 in the cache */
   /* replace256_1_0 -> 21 in the cache */
   /* replace256_1_1_0 -> 36 in the cache */
   /* replace256_1_1_1 -> 141 in the cache */
   /* replace256_1_1 -> 843 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 21, 843 },
      -1,
   } },
   /* replace256_2 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 905, 911, 907 },
      -1,
   } },

   /* ('ishr@64', ('ishr@64', 'a', '#b'), '#c') => ('ishr@64', 'a', ('imin', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 63)) */
   /* search257_0_0 -> 21 in the cache */
   /* search257_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 21, 33 },
      -1,
   } },
   /* search257_1 -> 319 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 913, 319 },
      -1,
   } },

   /* replace257_0 -> 21 in the cache */
   /* replace257_1_0_0_0 -> 36 in the cache */
   /* replace257_1_0_0_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 36, 24 },
      -1,
   } },
   /* replace257_1_0_1_0 -> 141 in the cache */
   /* replace257_1_0_1_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      3, 1,
      { 141, 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 915, 916 },
      -1,
   } },
   /* replace257_1_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imin,
      0, 4,
      { 917, 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 4,
      { 21, 918 },
      -1,
   } },

   /* ('ishl', ('ushr', 'a@8', '#b'), 'b') => ('iand', 'a', ('ishl', 255, 'b')) */
   /* search258_0_0 -> 6 in the cache */
   /* search258_0_1 -> 33 in the cache */
   /* search258_0 -> 847 in the cache */
   /* search258_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 847, 36 },
      -1,
   } },

   /* replace258_0 -> 6 in the cache */
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { 0xff /* 255 */ },
   } },
   /* replace258_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 921, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 6, 922 },
      -1,
   } },

   /* ('ishl', ('ishr', 'a@8', '#b'), 'b') => ('iand', 'a', ('ishl', 255, 'b')) */
   /* search259_0_0 -> 6 in the cache */
   /* search259_0_1 -> 33 in the cache */
   /* search259_0 -> 851 in the cache */
   /* search259_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 851, 36 },
      -1,
   } },

   /* replace259_0 -> 6 in the cache */
   /* replace259_1_0 -> 921 in the cache */
   /* replace259_1_1 -> 36 in the cache */
   /* replace259_1 -> 922 in the cache */
   /* replace259 -> 923 in the cache */

   /* ('ushr', ('ishl', 'a@8', '#b'), 'b') => ('iand', 'a', ('ushr', 255, 'b')) */
   /* search260_0_0 -> 6 in the cache */
   /* search260_0_1 -> 33 in the cache */
   /* search260_0 -> 836 in the cache */
   /* search260_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 836, 36 },
      -1,
   } },

   /* replace260_0 -> 6 in the cache */
   /* replace260_1_0 -> 921 in the cache */
   /* replace260_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 921, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 6, 926 },
      -1,
   } },

   /* ('ishl', ('ushr', 'a@16', '#b'), 'b') => ('iand', 'a', ('ishl', 65535, 'b')) */
   /* search261_0_0 -> 11 in the cache */
   /* search261_0_1 -> 33 in the cache */
   /* search261_0 -> 868 in the cache */
   /* search261_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 868, 36 },
      -1,
   } },

   /* replace261_0 -> 11 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0xffff /* 65535 */ },
   } },
   /* replace261_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 929, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 11, 930 },
      -1,
   } },

   /* ('ishl', ('ishr', 'a@16', '#b'), 'b') => ('iand', 'a', ('ishl', 65535, 'b')) */
   /* search262_0_0 -> 11 in the cache */
   /* search262_0_1 -> 33 in the cache */
   /* search262_0 -> 872 in the cache */
   /* search262_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 872, 36 },
      -1,
   } },

   /* replace262_0 -> 11 in the cache */
   /* replace262_1_0 -> 929 in the cache */
   /* replace262_1_1 -> 36 in the cache */
   /* replace262_1 -> 930 in the cache */
   /* replace262 -> 931 in the cache */

   /* ('ushr', ('ishl', 'a@16', '#b'), 'b') => ('iand', 'a', ('ushr', 65535, 'b')) */
   /* search263_0_0 -> 11 in the cache */
   /* search263_0_1 -> 33 in the cache */
   /* search263_0 -> 858 in the cache */
   /* search263_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 858, 36 },
      -1,
   } },

   /* replace263_0 -> 11 in the cache */
   /* replace263_1_0 -> 929 in the cache */
   /* replace263_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 929, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 11, 934 },
      -1,
   } },

   /* ('ishl', ('ushr', 'a@32', '#b'), 'b') => ('iand', 'a', ('ishl', 4294967295, 'b')) */
   /* search264_0_0 -> 16 in the cache */
   /* search264_0_1 -> 33 in the cache */
   /* search264_0 -> 888 in the cache */
   /* search264_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 888, 36 },
      -1,
   } },

   /* replace264_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffffff /* 4294967295 */ },
   } },
   /* replace264_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 937, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 16, 938 },
      -1,
   } },

   /* ('ishl', ('ishr', 'a@32', '#b'), 'b') => ('iand', 'a', ('ishl', 4294967295, 'b')) */
   /* search265_0_0 -> 16 in the cache */
   /* search265_0_1 -> 33 in the cache */
   /* search265_0 -> 892 in the cache */
   /* search265_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 892, 36 },
      -1,
   } },

   /* replace265_0 -> 16 in the cache */
   /* replace265_1_0 -> 937 in the cache */
   /* replace265_1_1 -> 36 in the cache */
   /* replace265_1 -> 938 in the cache */
   /* replace265 -> 939 in the cache */

   /* ('ushr', ('ishl', 'a@32', '#b'), 'b') => ('iand', 'a', ('ushr', 4294967295, 'b')) */
   /* search266_0_0 -> 16 in the cache */
   /* search266_0_1 -> 33 in the cache */
   /* search266_0 -> 879 in the cache */
   /* search266_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 879, 36 },
      -1,
   } },

   /* replace266_0 -> 16 in the cache */
   /* replace266_1_0 -> 937 in the cache */
   /* replace266_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 937, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 16, 942 },
      -1,
   } },

   /* ('ishl', ('ushr', 'a@64', '#b'), 'b') => ('iand', 'a', ('ishl', 18446744073709551615, 'b')) */
   /* search267_0_0 -> 21 in the cache */
   /* search267_0_1 -> 33 in the cache */
   /* search267_0 -> 909 in the cache */
   /* search267_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 909, 36 },
      -1,
   } },

   /* replace267_0 -> 21 in the cache */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0xffffffffffffffff /* 18446744073709551615 */ },
   } },
   /* replace267_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 945, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 21, 946 },
      -1,
   } },

   /* ('ishl', ('ishr', 'a@64', '#b'), 'b') => ('iand', 'a', ('ishl', 18446744073709551615, 'b')) */
   /* search268_0_0 -> 21 in the cache */
   /* search268_0_1 -> 33 in the cache */
   /* search268_0 -> 913 in the cache */
   /* search268_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 913, 36 },
      -1,
   } },

   /* replace268_0 -> 21 in the cache */
   /* replace268_1_0 -> 945 in the cache */
   /* replace268_1_1 -> 36 in the cache */
   /* replace268_1 -> 946 in the cache */
   /* replace268 -> 947 in the cache */

   /* ('ushr', ('ishl', 'a@64', '#b'), 'b') => ('iand', 'a', ('ushr', 18446744073709551615, 'b')) */
   /* search269_0_0 -> 21 in the cache */
   /* search269_0_1 -> 33 in the cache */
   /* search269_0 -> 899 in the cache */
   /* search269_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 899, 36 },
      -1,
   } },

   /* replace269_0 -> 21 in the cache */
   /* replace269_1_0 -> 945 in the cache */
   /* replace269_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 945, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 21, 950 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', '#b(is_first_5_bits_uge_2)'), -4) => ('ishl', 'a', 'b') */
   /* search270_0_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      9,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 16, 952 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { -0x4 /* -4 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 953, 954 },
      -1,
   } },

   /* replace270_0 -> 16 in the cache */
   /* replace270_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 16, 36 },
      -1,
   } },

   /* ('iand', ('imul', 'a', '#b(is_unsigned_multiple_of_4)'), -4) => ('imul', 'a', 'b') */
   /* search271_0_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      10,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imul,
      1, 1,
      { 0, 957 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_int, { -0x4 /* -4 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 958, 959 },
      -1,
   } },

   /* replace271_0 -> 0 in the cache */
   /* replace271_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_2)'), 4294967294) => ('iadd', ('iand', 'a', 4294967294), 'b') */
   /* search272_0_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      11,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 16, 962 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffffe /* 4294967294 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 963, 964 },
      -1,
   } },

   /* replace272_0_0 -> 16 in the cache */
   /* replace272_0_1 -> 964 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 16, 964 },
      -1,
   } },
   /* replace272_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 966, 36 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_4)'), 4294967292) => ('iadd', ('iand', 'a', 4294967292), 'b') */
   /* search273_0_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      10,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 16, 968 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffffc /* 4294967292 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 969, 970 },
      -1,
   } },

   /* replace273_0_0 -> 16 in the cache */
   /* replace273_0_1 -> 970 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 16, 970 },
      -1,
   } },
   /* replace273_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 972, 36 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_8)'), 4294967288) => ('iadd', ('iand', 'a', 4294967288), 'b') */
   /* search274_0_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      12,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 16, 974 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffff8 /* 4294967288 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 975, 976 },
      -1,
   } },

   /* replace274_0_0 -> 16 in the cache */
   /* replace274_0_1 -> 976 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 16, 976 },
      -1,
   } },
   /* replace274_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 978, 36 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_16)'), 4294967280) => ('iadd', ('iand', 'a', 4294967280), 'b') */
   /* search275_0_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      13,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 16, 980 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffff0 /* 4294967280 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 981, 982 },
      -1,
   } },

   /* replace275_0_0 -> 16 in the cache */
   /* replace275_0_1 -> 982 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 16, 982 },
      -1,
   } },
   /* replace275_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 984, 36 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_32)'), 4294967264) => ('iadd', ('iand', 'a', 4294967264), 'b') */
   /* search276_0_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      14,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 16, 986 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffffe0 /* 4294967264 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 987, 988 },
      -1,
   } },

   /* replace276_0_0 -> 16 in the cache */
   /* replace276_0_1 -> 988 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 16, 988 },
      -1,
   } },
   /* replace276_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 990, 36 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_64)'), 4294967232) => ('iadd', ('iand', 'a', 4294967232), 'b') */
   /* search277_0_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      15,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 16, 992 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffffc0 /* 4294967232 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 993, 994 },
      -1,
   } },

   /* replace277_0_0 -> 16 in the cache */
   /* replace277_0_1 -> 994 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 16, 994 },
      -1,
   } },
   /* replace277_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 996, 36 },
      -1,
   } },

   /* ('ishl@32', ('iand', 'a@32', 2147483647), 1) => ('ishl', 'a', 1) */
   /* search278_0_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x7fffffff /* 2147483647 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 16, 998 },
      -1,
   } },
   /* search278_1 -> 406 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 999, 406 },
      -1,
   } },

   /* replace278_0 -> 16 in the cache */
   /* replace278_1 -> 406 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 16, 406 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', 1), 4294967294) => ('ishl', 'a', 1) */
   /* search279_0_0 -> 16 in the cache */
   /* search279_0_1 -> 406 in the cache */
   /* search279_0 -> 1001 in the cache */
   /* search279_1 -> 964 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1001, 964 },
      -1,
   } },

   /* replace279_0 -> 16 in the cache */
   /* replace279_1 -> 406 in the cache */
   /* replace279 -> 1001 in the cache */

   /* ('iand', ('ushr', 'a@32', 1), 2147483647) => ('ushr', 'a', 1) */
   /* search280_0_0 -> 16 in the cache */
   /* search280_0_1 -> 406 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 16, 406 },
      -1,
   } },
   /* search280_1 -> 998 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1003, 998 },
      -1,
   } },

   /* replace280_0 -> 16 in the cache */
   /* replace280_1 -> 406 in the cache */
   /* replace280 -> 1003 in the cache */

   /* ('ishl@32', ('iand', 'a@32', 1073741823), 2) => ('ishl', 'a', 2) */
   /* search281_0_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x3fffffff /* 1073741823 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 16, 1005 },
      -1,
   } },
   /* search281_1 -> 411 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 1006, 411 },
      -1,
   } },

   /* replace281_0 -> 16 in the cache */
   /* replace281_1 -> 411 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 16, 411 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', 2), 4294967292) => ('ishl', 'a', 2) */
   /* search282_0_0 -> 16 in the cache */
   /* search282_0_1 -> 411 in the cache */
   /* search282_0 -> 1008 in the cache */
   /* search282_1 -> 970 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1008, 970 },
      -1,
   } },

   /* replace282_0 -> 16 in the cache */
   /* replace282_1 -> 411 in the cache */
   /* replace282 -> 1008 in the cache */

   /* ('iand', ('ushr', 'a@32', 2), 1073741823) => ('ushr', 'a', 2) */
   /* search283_0_0 -> 16 in the cache */
   /* search283_0_1 -> 411 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 16, 411 },
      -1,
   } },
   /* search283_1 -> 1005 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1010, 1005 },
      -1,
   } },

   /* replace283_0 -> 16 in the cache */
   /* replace283_1 -> 411 in the cache */
   /* replace283 -> 1010 in the cache */

   /* ('ishl@32', ('iand', 'a@32', 65535), 16) => ('ishl', 'a', 16) */
   /* search284_0_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffff /* 65535 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 16, 1012 },
      -1,
   } },
   /* search284_1 -> 863 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 1013, 863 },
      -1,
   } },

   /* replace284_0 -> 16 in the cache */
   /* replace284_1 -> 863 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 16, 863 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', 16), 4294901760) => ('ishl', 'a', 16) */
   /* search285_0_0 -> 16 in the cache */
   /* search285_0_1 -> 863 in the cache */
   /* search285_0 -> 1015 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffff0000 /* 4294901760 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1015, 1016 },
      -1,
   } },

   /* replace285_0 -> 16 in the cache */
   /* replace285_1 -> 863 in the cache */
   /* replace285 -> 1015 in the cache */

   /* ('iand', ('ushr', 'a@32', 16), 65535) => ('ushr', 'a', 16) */
   /* search286_0_0 -> 16 in the cache */
   /* search286_0_1 -> 863 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 16, 863 },
      -1,
   } },
   /* search286_1 -> 1012 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1018, 1012 },
      -1,
   } },

   /* replace286_0 -> 16 in the cache */
   /* replace286_1 -> 863 in the cache */
   /* replace286 -> 1018 in the cache */

   /* ('ishl@32', ('iand', 'a@32', 255), 24) => ('ishl', 'a', 24) */
   /* search287_0_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xff /* 255 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 16, 1020 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x18 /* 24 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 1021, 1022 },
      -1,
   } },

   /* replace287_0 -> 16 in the cache */
   /* replace287_1 -> 1022 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 16, 1022 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', 24), 4278190080) => ('ishl', 'a', 24) */
   /* search288_0_0 -> 16 in the cache */
   /* search288_0_1 -> 1022 in the cache */
   /* search288_0 -> 1024 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xff000000 /* 4278190080 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1024, 1025 },
      -1,
   } },

   /* replace288_0 -> 16 in the cache */
   /* replace288_1 -> 1022 in the cache */
   /* replace288 -> 1024 in the cache */

   /* ('iand', ('ushr', 'a@32', 24), 255) => ('ushr', 'a', 24) */
   /* search289_0_0 -> 16 in the cache */
   /* search289_0_1 -> 1022 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 16, 1022 },
      -1,
   } },
   /* search289_1 -> 1020 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1027, 1020 },
      -1,
   } },

   /* replace289_0 -> 16 in the cache */
   /* replace289_1 -> 1022 in the cache */
   /* replace289 -> 1027 in the cache */

   /* ('ishl', ('iadd', 'a', '#b'), '#c') => ('iadd', ('ishl', 'a', 'c'), ('ishl', 'b', 'c')) */
   /* search290_0_0 -> 0 in the cache */
   /* search290_0_1 -> 831 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 0, 831 },
      -1,
   } },
   /* search290_1 -> 319 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 1029, 319 },
      -1,
   } },

   /* replace290_0_0 -> 0 in the cache */
   /* replace290_0_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 0, 141 },
      -1,
   } },
   /* replace290_1_0 -> 3 in the cache */
   /* replace290_1_1 -> 141 in the cache */
   /* replace290_1 -> 834 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 1031, 834 },
      -1,
   } },

   /* ('imul', ('iadd(is_used_once)', 'a', '#b'), '#c') => ('iadd', ('imul', 'a', 'c'), ('imul', 'b', 'c')) */
   /* search291_0_0 -> 132 in the cache */
   /* search291_0_1 -> 293 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 132, 293 },
      0,
   } },
   /* search291_1 -> 824 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imul,
      0, 2,
      { 1033, 824 },
      -1,
   } },

   /* replace291_0_0 -> 132 in the cache */
   /* replace291_0_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imul,
      1, 1,
      { 132, 135 },
      -1,
   } },
   /* replace291_1_0 -> 133 in the cache */
   /* replace291_1_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imul,
      2, 1,
      { 133, 135 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 1035, 1036 },
      -1,
   } },

   /* ('imul', ('iadd(is_used_once)', ('iadd(is_used_once)', 'a', '#b'), 'c'), '#d') => ('iadd', ('imul', ('iadd', 'a', 'c'), 'd'), ('imul', 'b', 'd')) */
   /* search292_0_0_0 -> 155 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_iadd,
      2, 1,
      { 155, 1038 },
      0,
   } },
   /* search292_0_1 -> 158 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 2,
      { 1039, 158 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, -4 },
      3, /* d */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_imul,
      0, 3,
      { 1040, 1041 },
      -1,
   } },

   /* replace292_0_0_0 -> 155 in the cache */
   /* replace292_0_0_1 -> 158 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_iadd,
      2, 1,
      { 155, 158 },
      -1,
   } },
   /* replace292_0_1 -> 159 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_imul,
      1, 2,
      { 1043, 159 },
      -1,
   } },
   /* replace292_1_0 -> 156 in the cache */
   /* replace292_1_1 -> 159 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 156, 159 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 4,
      { 1044, 1045 },
      -1,
   } },

   /* ('ishl', ('iadd(is_used_once)', ('iadd(is_used_once)', 'a', '#b'), 'c'), '#d') => ('iadd', ('ishl', ('iadd', 'a', 'c'), 'd'), ('ishl', 'b', 'd')) */
   /* search293_0_0_0 -> 132 in the cache */
   /* search293_0_0_1 -> 293 in the cache */
   /* search293_0_0 -> 1033 in the cache */
   /* search293_0_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 1033, 135 },
      0,
   } },
   /* search293_1 -> 321 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 2,
      { 1047, 321 },
      -1,
   } },

   /* replace293_0_0_0 -> 132 in the cache */
   /* replace293_0_0_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 132, 135 },
      -1,
   } },
   /* replace293_0_1 -> 169 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 1049, 169 },
      -1,
   } },
   /* replace293_1_0 -> 133 in the cache */
   /* replace293_1_1 -> 169 in the cache */
   /* replace293_1 -> 827 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 1050, 827 },
      -1,
   } },

   /* ('inot', ('flt(is_used_once)', 'a(is_a_number)', 'b(is_a_number)')) => ('fge', 'a', 'b') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      16,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      16,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1052, 1053 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1054 },
      -1,
   } },

   /* replace294_0 -> 0 in the cache */
   /* replace294_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('fge(is_used_once)', 'a(is_a_number)', 'b(is_a_number)')) => ('flt', 'a', 'b') */
   /* search295_0_0 -> 1052 in the cache */
   /* search295_0_1 -> 1053 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1052, 1053 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1057 },
      -1,
   } },

   /* replace295_0 -> 0 in the cache */
   /* replace295_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('feq(is_used_once)', 'a', 'b')) => ('fneu', 'a', 'b') */
   /* search296_0_0 -> 0 in the cache */
   /* search296_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1060 },
      -1,
   } },

   /* replace296_0 -> 0 in the cache */
   /* replace296_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('fneu(is_used_once)', 'a', 'b')) => ('feq', 'a', 'b') */
   /* search297_0_0 -> 0 in the cache */
   /* search297_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1063 },
      -1,
   } },

   /* replace297_0 -> 0 in the cache */
   /* replace297_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('ilt(is_used_once)', 'a', 'b')) => ('ige', 'a', 'b') */
   /* search298_0_0 -> 0 in the cache */
   /* search298_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1066 },
      -1,
   } },

   /* replace298_0 -> 0 in the cache */
   /* replace298_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('ult(is_used_once)', 'a', 'b')) => ('uge', 'a', 'b') */
   /* search299_0_0 -> 0 in the cache */
   /* search299_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1069 },
      -1,
   } },

   /* replace299_0 -> 0 in the cache */
   /* replace299_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('ige(is_used_once)', 'a', 'b')) => ('ilt', 'a', 'b') */
   /* search300_0_0 -> 0 in the cache */
   /* search300_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1072 },
      -1,
   } },

   /* replace300_0 -> 0 in the cache */
   /* replace300_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('uge(is_used_once)', 'a', 'b')) => ('ult', 'a', 'b') */
   /* search301_0_0 -> 0 in the cache */
   /* search301_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1075 },
      -1,
   } },

   /* replace301_0 -> 0 in the cache */
   /* replace301_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('ieq(is_used_once)', 'a', 'b')) => ('ine', 'a', 'b') */
   /* search302_0_0 -> 0 in the cache */
   /* search302_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1078 },
      -1,
   } },

   /* replace302_0 -> 0 in the cache */
   /* replace302_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('ine(is_used_once)', 'a', 'b')) => ('ieq', 'a', 'b') */
   /* search303_0_0 -> 0 in the cache */
   /* search303_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1081 },
      -1,
   } },

   /* replace303_0 -> 0 in the cache */
   /* replace303_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('iand', ('feq', 'a', 'b'), ('fneu', 'a', 'b')) => False */
   /* search304_0_0 -> 0 in the cache */
   /* search304_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search304_1_0 -> 0 in the cache */
   /* search304_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      2, 1,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 1084, 1085 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, 1 },
      nir_type_bool, { NIR_FALSE /* False */ },
   } },

   /* ('iand', ('flt', 'a', 'b'), ('flt', 'b', 'a')) => False */
   /* search305_0_0 -> 0 in the cache */
   /* search305_0_1 -> 3 in the cache */
   /* search305_0 -> 1059 in the cache */
   /* search305_1_0 -> 3 in the cache */
   /* search305_1_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 3, 0 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1059, 1088 },
      -1,
   } },

   /* replace305 -> 1087 in the cache */

   /* ('iand', ('ieq', 'a', 'b'), ('ine', 'a', 'b')) => False */
   /* search306_0_0 -> 0 in the cache */
   /* search306_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search306_1_0 -> 0 in the cache */
   /* search306_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      2, 1,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 1090, 1091 },
      -1,
   } },

   /* replace306 -> 1087 in the cache */

   /* ('iand', ('ilt', 'a', 'b'), ('ilt', 'b', 'a')) => False */
   /* search307_0_0 -> 0 in the cache */
   /* search307_0_1 -> 3 in the cache */
   /* search307_0 -> 1074 in the cache */
   /* search307_1_0 -> 3 in the cache */
   /* search307_1_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 3, 0 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1074, 1093 },
      -1,
   } },

   /* replace307 -> 1087 in the cache */

   /* ('iand', ('ult', 'a', 'b'), ('ult', 'b', 'a')) => False */
   /* search308_0_0 -> 0 in the cache */
   /* search308_0_1 -> 3 in the cache */
   /* search308_0 -> 1077 in the cache */
   /* search308_1_0 -> 3 in the cache */
   /* search308_1_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 3, 0 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1077, 1095 },
      -1,
   } },

   /* replace308 -> 1087 in the cache */

   /* ('flt', ('fneg', 'a'), ('fneg', 'b')) => ('flt', 'b', 'a') */
   /* search309_0_0 -> 0 in the cache */
   /* search309_0 -> 223 in the cache */
   /* search309_1_0 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 223, 1097 },
      -1,
   } },

   /* replace309_0 -> 3 in the cache */
   /* replace309_1 -> 0 in the cache */
   /* replace309 -> 1088 in the cache */

   /* ('fge', ('fneg', 'a'), ('fneg', 'b')) => ('fge', 'b', 'a') */
   /* search310_0_0 -> 0 in the cache */
   /* search310_0 -> 223 in the cache */
   /* search310_1_0 -> 3 in the cache */
   /* search310_1 -> 1097 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 223, 1097 },
      -1,
   } },

   /* replace310_0 -> 3 in the cache */
   /* replace310_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 3, 0 },
      -1,
   } },

   /* ('feq', ('fneg', 'a'), ('fneg', 'b')) => ('feq', 'b', 'a') */
   /* search311_0_0 -> 0 in the cache */
   /* search311_0 -> 223 in the cache */
   /* search311_1_0 -> 3 in the cache */
   /* search311_1 -> 1097 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 223, 1097 },
      -1,
   } },

   /* replace311_0 -> 3 in the cache */
   /* replace311_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 3, 0 },
      -1,
   } },

   /* ('fneu', ('fneg', 'a'), ('fneg', 'b')) => ('fneu', 'b', 'a') */
   /* search312_0_0 -> 0 in the cache */
   /* search312_0 -> 223 in the cache */
   /* search312_1_0 -> 3 in the cache */
   /* search312_1 -> 1097 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 223, 1097 },
      -1,
   } },

   /* replace312_0 -> 3 in the cache */
   /* replace312_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 3, 0 },
      -1,
   } },

   /* ('flt', ('fneg', 'a'), -1.0) => ('flt', 1.0, 'a') */
   /* search313_0_0 -> 32 in the cache */
   /* search313_0 -> 107 in the cache */
   /* search313_1 -> 258 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 107, 258 },
      -1,
   } },

   /* replace313_0 -> 252 in the cache */
   /* replace313_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 252, 32 },
      -1,
   } },

   /* ('flt', -1.0, ('fneg', 'a')) => ('flt', 'a', 1.0) */
   /* search314_0 -> 258 in the cache */
   /* search314_1_0 -> 32 in the cache */
   /* search314_1 -> 107 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 258, 107 },
      -1,
   } },

   /* replace314_0 -> 32 in the cache */
   /* replace314_1 -> 252 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 32, 252 },
      -1,
   } },

   /* ('fge', ('fneg', 'a'), -1.0) => ('fge', 1.0, 'a') */
   /* search315_0_0 -> 32 in the cache */
   /* search315_0 -> 107 in the cache */
   /* search315_1 -> 258 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 107, 258 },
      -1,
   } },

   /* replace315_0 -> 252 in the cache */
   /* replace315_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 252, 32 },
      -1,
   } },

   /* ('fge', -1.0, ('fneg', 'a')) => ('fge', 'a', 1.0) */
   /* search316_0 -> 258 in the cache */
   /* search316_1_0 -> 32 in the cache */
   /* search316_1 -> 107 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 258, 107 },
      -1,
   } },

   /* replace316_0 -> 32 in the cache */
   /* replace316_1 -> 252 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 32, 252 },
      -1,
   } },

   /* ('fneu', ('fneg', 'a'), -1.0) => ('fneu', 1.0, 'a') */
   /* search317_0_0 -> 32 in the cache */
   /* search317_0 -> 107 in the cache */
   /* search317_1 -> 258 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 107, 258 },
      -1,
   } },

   /* replace317_0 -> 252 in the cache */
   /* replace317_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 252, 32 },
      -1,
   } },

   /* ('feq', -1.0, ('fneg', 'a')) => ('feq', 'a', 1.0) */
   /* search318_0 -> 258 in the cache */
   /* search318_1_0 -> 32 in the cache */
   /* search318_1 -> 107 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 258, 107 },
      -1,
   } },

   /* replace318_0 -> 32 in the cache */
   /* replace318_1 -> 252 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 32, 252 },
      -1,
   } },

   /* ('ieq', ('ineg', 'a'), 0) => ('ieq', 'a', 0) */
   /* search319_0_0 -> 32 in the cache */
   /* search319_0 -> 109 in the cache */
   /* search319_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 109, 61 },
      -1,
   } },

   /* replace319_0 -> 32 in the cache */
   /* replace319_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* ('ine', ('ineg', 'a'), 0) => ('ine', 'a', 0) */
   /* search320_0_0 -> 32 in the cache */
   /* search320_0 -> 109 in the cache */
   /* search320_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 109, 61 },
      -1,
   } },

   /* replace320_0 -> 32 in the cache */
   /* replace320_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* ('ieq', ('iabs', 'a'), 0) => ('ieq', 'a', 0) */
   /* search321_0_0 -> 32 in the cache */
   /* search321_0 -> 114 in the cache */
   /* search321_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 114, 61 },
      -1,
   } },

   /* replace321_0 -> 32 in the cache */
   /* replace321_1 -> 61 in the cache */
   /* replace321 -> 1118 in the cache */

   /* ('ine', ('iabs', 'a'), 0) => ('ine', 'a', 0) */
   /* search322_0_0 -> 32 in the cache */
   /* search322_0 -> 114 in the cache */
   /* search322_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 114, 61 },
      -1,
   } },

   /* replace322_0 -> 32 in the cache */
   /* replace322_1 -> 61 in the cache */
   /* replace322 -> 1120 in the cache */

   /* ('flt', '#b(is_gt_0_and_lt_1)', ('fsat(is_used_once)', 'a')) => ('flt', 'b', 'a') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* b */
      true,
      nir_type_invalid,
      17,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 1124 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1123, 1125 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* replace323_1 -> 1124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1127, 1124 },
      -1,
   } },

   /* ('fge', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fge', 'a', 'b') */
   /* search324_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 0 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      17,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1129, 1130 },
      -1,
   } },

   /* replace324_0 -> 0 in the cache */
   /* replace324_1 -> 3 in the cache */
   /* replace324 -> 1056 in the cache */

   /* ('feq', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('feq', 'a', 'b') */
   /* search325_0_0 -> 0 in the cache */
   /* search325_0 -> 1129 in the cache */
   /* search325_1 -> 1130 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1129, 1130 },
      -1,
   } },

   /* replace325_0 -> 0 in the cache */
   /* replace325_1 -> 3 in the cache */
   /* replace325 -> 1065 in the cache */

   /* ('fneu', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fneu', 'a', 'b') */
   /* search326_0_0 -> 0 in the cache */
   /* search326_0 -> 1129 in the cache */
   /* search326_1 -> 1130 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1129, 1130 },
      -1,
   } },

   /* replace326_0 -> 0 in the cache */
   /* replace326_1 -> 3 in the cache */
   /* replace326 -> 1062 in the cache */

   /* ('fge', ('fsat(is_used_once)', 'a'), 1.0) => ('fge', 'a', 1.0) */
   /* search327_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 32 },
      0,
   } },
   /* search327_1 -> 252 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1134, 252 },
      -1,
   } },

   /* replace327_0 -> 32 in the cache */
   /* replace327_1 -> 252 in the cache */
   /* replace327 -> 1112 in the cache */

   /* ('flt', 0.0, ('fsat(is_used_once)', 'a')) => ('flt', 0.0, 'a') */
   /* search328_0 -> 117 in the cache */
   /* search328_1_0 -> 32 in the cache */
   /* search328_1 -> 1134 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 117, 1134 },
      -1,
   } },

   /* replace328_0 -> 117 in the cache */
   /* replace328_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 117, 32 },
      -1,
   } },

   /* ('fge', 0.0, ('b2f', 'a@1')) => ('inot', 'a') */
   { .constant = {
      { nir_search_value_constant, 0 },
      nir_type_float, { 0x0 /* 0.0 */ },
   } },
   /* search329_1_0 -> 767 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 767 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1138, 1139 },
      -1,
   } },

   /* replace329_0 -> 767 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 767 },
      -1,
   } },

   /* ('fge', ('fneg', ('b2f', 'a@1')), 0.0) => ('inot', 'a') */
   /* search330_0_0_0 -> 767 in the cache */
   /* search330_0_0 -> 1139 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1139 },
      -1,
   } },
   /* search330_1 -> 1138 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1142, 1138 },
      -1,
   } },

   /* replace330_0 -> 767 in the cache */
   /* replace330 -> 1141 in the cache */

   /* ('fneu', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b') */
   /* search331_0_0_0 -> 767 in the cache */
   /* search331_0_0 -> 1139 in the cache */
   { .variable = {
      { nir_search_value_variable, 1 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1144 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 1139, 1145 },
      -1,
   } },
   /* search331_1 -> 1138 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1146, 1138 },
      -1,
   } },

   /* replace331_0 -> 767 in the cache */
   /* replace331_1 -> 1144 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 767, 1144 },
      -1,
   } },

   /* ('fneu', ('bcsel', 'a', 1.0, ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b') */
   /* search332_0_0 -> 767 in the cache */
   { .constant = {
      { nir_search_value_constant, 0 },
      nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
   } },
   /* search332_0_2_0 -> 1144 in the cache */
   /* search332_0_2 -> 1145 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 767, 1149, 1145 },
      -1,
   } },
   /* search332_1 -> 1138 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1150, 1138 },
      -1,
   } },

   /* replace332_0 -> 767 in the cache */
   /* replace332_1 -> 1144 in the cache */
   /* replace332 -> 1148 in the cache */

   /* ('fneu', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('ior', 'a', 'b') */
   /* search333_0_0 -> 767 in the cache */
   /* search333_0 -> 1139 in the cache */
   /* search333_1_0_0 -> 1144 in the cache */
   /* search333_1_0 -> 1145 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1145 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1139, 1152 },
      -1,
   } },

   /* replace333_0 -> 767 in the cache */
   /* replace333_1 -> 1144 in the cache */
   /* replace333 -> 1148 in the cache */

   /* ('fneu', ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('iand', 'a', 'b') */
   /* search334_0_0_0 -> 767 in the cache */
   /* search334_0_0 -> 1139 in the cache */
   /* search334_0_1_0 -> 1144 in the cache */
   /* search334_0_1 -> 1145 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 1139, 1145 },
      -1,
   } },
   /* search334_1 -> 1138 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1154, 1138 },
      -1,
   } },

   /* replace334_0 -> 767 in the cache */
   /* replace334_1 -> 1144 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 767, 1144 },
      -1,
   } },

   /* ('fneu', ('bcsel', 'a', ('b2f', 'b@1'), 0.0), 0.0) => ('iand', 'a', 'b') */
   /* search335_0_0 -> 767 in the cache */
   /* search335_0_1_0 -> 1144 in the cache */
   /* search335_0_1 -> 1145 in the cache */
   /* search335_0_2 -> 1138 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 767, 1145, 1138 },
      -1,
   } },
   /* search335_1 -> 1138 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1157, 1138 },
      -1,
   } },

   /* replace335_0 -> 767 in the cache */
   /* replace335_1 -> 1144 in the cache */
   /* replace335 -> 1156 in the cache */

   /* ('fneu', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ixor', 'a', 'b') */
   /* search336_0_0_0 -> 767 in the cache */
   /* search336_0_0 -> 1139 in the cache */
   /* search336_0_1_0_0 -> 1144 in the cache */
   /* search336_0_1_0 -> 1145 in the cache */
   /* search336_0_1 -> 1152 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 1139, 1152 },
      -1,
   } },
   /* search336_1 -> 1138 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1159, 1138 },
      -1,
   } },

   /* replace336_0 -> 767 in the cache */
   /* replace336_1 -> 1144 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 767, 1144 },
      -1,
   } },

   /* ('fneu', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ixor', 'a', 'b') */
   /* search337_0_0 -> 767 in the cache */
   /* search337_0 -> 1139 in the cache */
   /* search337_1_0 -> 1144 in the cache */
   /* search337_1 -> 1145 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1139, 1145 },
      -1,
   } },

   /* replace337_0 -> 767 in the cache */
   /* replace337_1 -> 1144 in the cache */
   /* replace337 -> 1161 in the cache */

   /* ('fneu', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ixor', 'a', 'b') */
   /* search338_0_0_0 -> 767 in the cache */
   /* search338_0_0 -> 1139 in the cache */
   /* search338_0 -> 1142 in the cache */
   /* search338_1_0_0 -> 1144 in the cache */
   /* search338_1_0 -> 1145 in the cache */
   /* search338_1 -> 1152 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1142, 1152 },
      -1,
   } },

   /* replace338_0 -> 767 in the cache */
   /* replace338_1 -> 1144 in the cache */
   /* replace338 -> 1161 in the cache */

   /* ('feq', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b')) */
   /* search339_0_0_0 -> 767 in the cache */
   /* search339_0_0 -> 1139 in the cache */
   /* search339_0_1_0 -> 1144 in the cache */
   /* search339_0_1 -> 1145 in the cache */
   /* search339_0 -> 1146 in the cache */
   /* search339_1 -> 1138 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1146, 1138 },
      -1,
   } },

   /* replace339_0_0 -> 767 in the cache */
   /* replace339_0_1 -> 1144 in the cache */
   /* replace339_0 -> 1148 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1148 },
      -1,
   } },

   /* ('feq', ('bcsel', 'a', 1.0, ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b')) */
   /* search340_0_0 -> 767 in the cache */
   /* search340_0_1 -> 1149 in the cache */
   /* search340_0_2_0 -> 1144 in the cache */
   /* search340_0_2 -> 1145 in the cache */
   /* search340_0 -> 1150 in the cache */
   /* search340_1 -> 1138 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1150, 1138 },
      -1,
   } },

   /* replace340_0_0 -> 767 in the cache */
   /* replace340_0_1 -> 1144 in the cache */
   /* replace340_0 -> 1148 in the cache */
   /* replace340 -> 1165 in the cache */

   /* ('feq', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b')) */
   /* search341_0_0 -> 767 in the cache */
   /* search341_0 -> 1139 in the cache */
   /* search341_1_0_0 -> 1144 in the cache */
   /* search341_1_0 -> 1145 in the cache */
   /* search341_1 -> 1152 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1139, 1152 },
      -1,
   } },

   /* replace341_0_0 -> 767 in the cache */
   /* replace341_0_1 -> 1144 in the cache */
   /* replace341_0 -> 1148 in the cache */
   /* replace341 -> 1165 in the cache */

   /* ('feq', ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('iand', 'a', 'b')) */
   /* search342_0_0_0 -> 767 in the cache */
   /* search342_0_0 -> 1139 in the cache */
   /* search342_0_1_0 -> 1144 in the cache */
   /* search342_0_1 -> 1145 in the cache */
   /* search342_0 -> 1154 in the cache */
   /* search342_1 -> 1138 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1154, 1138 },
      -1,
   } },

   /* replace342_0_0 -> 767 in the cache */
   /* replace342_0_1 -> 1144 in the cache */
   /* replace342_0 -> 1156 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1156 },
      -1,
   } },

   /* ('feq', ('bcsel', 'a', ('b2f', 'b@1'), 0.0), 0.0) => ('inot', ('iand', 'a', 'b')) */
   /* search343_0_0 -> 767 in the cache */
   /* search343_0_1_0 -> 1144 in the cache */
   /* search343_0_1 -> 1145 in the cache */
   /* search343_0_2 -> 1138 in the cache */
   /* search343_0 -> 1157 in the cache */
   /* search343_1 -> 1138 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1157, 1138 },
      -1,
   } },

   /* replace343_0_0 -> 767 in the cache */
   /* replace343_0_1 -> 1144 in the cache */
   /* replace343_0 -> 1156 in the cache */
   /* replace343 -> 1169 in the cache */

   /* ('feq', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ieq', 'a', 'b') */
   /* search344_0_0_0 -> 767 in the cache */
   /* search344_0_0 -> 1139 in the cache */
   /* search344_0_1_0_0 -> 1144 in the cache */
   /* search344_0_1_0 -> 1145 in the cache */
   /* search344_0_1 -> 1152 in the cache */
   /* search344_0 -> 1159 in the cache */
   /* search344_1 -> 1138 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1159, 1138 },
      -1,
   } },

   /* replace344_0 -> 767 in the cache */
   /* replace344_1 -> 1144 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 767, 1144 },
      -1,
   } },

   /* ('feq', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ieq', 'a', 'b') */
   /* search345_0_0 -> 767 in the cache */
   /* search345_0 -> 1139 in the cache */
   /* search345_1_0 -> 1144 in the cache */
   /* search345_1 -> 1145 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1139, 1145 },
      -1,
   } },

   /* replace345_0 -> 767 in the cache */
   /* replace345_1 -> 1144 in the cache */
   /* replace345 -> 1172 in the cache */

   /* ('feq', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ieq', 'a', 'b') */
   /* search346_0_0_0 -> 767 in the cache */
   /* search346_0_0 -> 1139 in the cache */
   /* search346_0 -> 1142 in the cache */
   /* search346_1_0_0 -> 1144 in the cache */
   /* search346_1_0 -> 1145 in the cache */
   /* search346_1 -> 1152 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1142, 1152 },
      -1,
   } },

   /* replace346_0 -> 767 in the cache */
   /* replace346_1 -> 1144 in the cache */
   /* replace346 -> 1172 in the cache */

   /* ('flt', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('ior', 'a', 'b') */
   /* search347_0_0_0_0 -> 767 in the cache */
   /* search347_0_0_0 -> 1139 in the cache */
   /* search347_0_0_1_0 -> 1144 in the cache */
   /* search347_0_0_1 -> 1145 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 1139, 1145 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1175 },
      -1,
   } },
   /* search347_1 -> 1138 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1176, 1138 },
      -1,
   } },

   /* replace347_0 -> 767 in the cache */
   /* replace347_1 -> 1144 in the cache */
   /* replace347 -> 1148 in the cache */

   /* ('flt', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('ior', 'a', 'b') */
   /* search348_0 -> 1138 in the cache */
   /* search348_1_0_0 -> 767 in the cache */
   /* search348_1_0 -> 1139 in the cache */
   /* search348_1_1_0 -> 1144 in the cache */
   /* search348_1_1 -> 1145 in the cache */
   /* search348_1 -> 1175 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1138, 1175 },
      -1,
   } },

   /* replace348_0 -> 767 in the cache */
   /* replace348_1 -> 1144 in the cache */
   /* replace348 -> 1148 in the cache */

   /* ('fge', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('inot', ('ior', 'a', 'b')) */
   /* search349_0_0_0_0 -> 767 in the cache */
   /* search349_0_0_0 -> 1139 in the cache */
   /* search349_0_0_1_0 -> 1144 in the cache */
   /* search349_0_0_1 -> 1145 in the cache */
   /* search349_0_0 -> 1175 in the cache */
   /* search349_0 -> 1176 in the cache */
   /* search349_1 -> 1138 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1176, 1138 },
      -1,
   } },

   /* replace349_0_0 -> 767 in the cache */
   /* replace349_0_1 -> 1144 in the cache */
   /* replace349_0 -> 1148 in the cache */
   /* replace349 -> 1165 in the cache */

   /* ('fge', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b')) */
   /* search350_0 -> 1138 in the cache */
   /* search350_1_0_0 -> 767 in the cache */
   /* search350_1_0 -> 1139 in the cache */
   /* search350_1_1_0 -> 1144 in the cache */
   /* search350_1_1 -> 1145 in the cache */
   /* search350_1 -> 1175 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1138, 1175 },
      -1,
   } },

   /* replace350_0_0 -> 767 in the cache */
   /* replace350_0_1 -> 1144 in the cache */
   /* replace350_0 -> 1148 in the cache */
   /* replace350 -> 1165 in the cache */

   /* ('flt', 'a', ('fneg', 'a')) => ('flt', 'a', 0.0) */
   /* search351_0 -> 32 in the cache */
   /* search351_1_0 -> 32 in the cache */
   /* search351_1 -> 107 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 32, 107 },
      -1,
   } },

   /* replace351_0 -> 32 in the cache */
   /* replace351_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 32, 117 },
      -1,
   } },

   /* ('fge', 'a', ('fneg', 'a')) => ('fge', 'a', 0.0) */
   /* search352_0 -> 32 in the cache */
   /* search352_1_0 -> 32 in the cache */
   /* search352_1 -> 107 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 32, 107 },
      -1,
   } },

   /* replace352_0 -> 32 in the cache */
   /* replace352_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 32, 117 },
      -1,
   } },

   /* ('flt', ('fmin', 'c', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')))), 0.0) => ('ior', ('flt', 'c', 0.0), ('ior', 'a', 'b')) */
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 1 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1186 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 1 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1188 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 1187, 1189 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1190 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1185, 1191 },
      -1,
   } },
   /* search353_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 2,
      { 1192, 117 },
      -1,
   } },

   /* replace353_0_0 -> 1185 in the cache */
   /* replace353_0_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1185, 117 },
      -1,
   } },
   /* replace353_1_0 -> 1186 in the cache */
   /* replace353_1_1 -> 1188 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 1186, 1188 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1194, 1195 },
      -1,
   } },

   /* ('~flt', ('fadd', 'a', 'b'), 'a') => ('flt', 'b', 0.0) */
   /* search354_0_0 -> 0 in the cache */
   /* search354_0_1 -> 3 in the cache */
   /* search354_0 -> 282 in the cache */
   /* search354_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 282, 0 },
      -1,
   } },

   /* replace354_0 -> 3 in the cache */
   /* replace354_1 -> 266 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 3, 266 },
      -1,
   } },

   /* ('~fge', ('fadd', 'a', 'b'), 'a') => ('fge', 'b', 0.0) */
   /* search355_0_0 -> 0 in the cache */
   /* search355_0_1 -> 3 in the cache */
   /* search355_0 -> 282 in the cache */
   /* search355_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 282, 0 },
      -1,
   } },

   /* replace355_0 -> 3 in the cache */
   /* replace355_1 -> 266 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 3, 266 },
      -1,
   } },

   /* ('~feq', ('fadd', 'a', 'b'), 'a') => ('feq', 'b', 0.0) */
   /* search356_0_0 -> 0 in the cache */
   /* search356_0_1 -> 3 in the cache */
   /* search356_0 -> 224 in the cache */
   /* search356_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 224, 0 },
      -1,
   } },

   /* replace356_0 -> 3 in the cache */
   /* replace356_1 -> 266 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 3, 266 },
      -1,
   } },

   /* ('~fneu', ('fadd', 'a', 'b'), 'a') => ('fneu', 'b', 0.0) */
   /* search357_0_0 -> 0 in the cache */
   /* search357_0_1 -> 3 in the cache */
   /* search357_0 -> 224 in the cache */
   /* search357_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 224, 0 },
      -1,
   } },

   /* replace357_0 -> 3 in the cache */
   /* replace357_1 -> 266 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 3, 266 },
      -1,
   } },

   /* ('~flt', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('flt', 'a', ('fadd', 'c', ('fneg', 'b'))) */
   /* search358_0_0 -> 132 in the cache */
   /* search358_0_1 -> 293 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 132, 293 },
      0,
   } },
   /* search358_1 -> 824 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1205, 824 },
      -1,
   } },

   /* replace358_0 -> 132 in the cache */
   /* replace358_1_0 -> 135 in the cache */
   /* replace358_1_1_0 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 133 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 135, 1207 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 132, 1208 },
      -1,
   } },

   /* ('~flt', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('flt', ('fneg', ('fadd', 'c', 'b')), 'a') */
   /* search359_0_0_0 -> 132 in the cache */
   /* search359_0_0_1 -> 293 in the cache */
   /* search359_0_0 -> 1205 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1205 },
      0,
   } },
   /* search359_1 -> 824 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1210, 824 },
      -1,
   } },

   /* replace359_0_0_0 -> 135 in the cache */
   /* replace359_0_0_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 135, 133 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1212 },
      -1,
   } },
   /* replace359_1 -> 132 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1213, 132 },
      -1,
   } },

   /* ('~fge', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fge', 'a', ('fadd', 'c', ('fneg', 'b'))) */
   /* search360_0_0 -> 132 in the cache */
   /* search360_0_1 -> 293 in the cache */
   /* search360_0 -> 1205 in the cache */
   /* search360_1 -> 824 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1205, 824 },
      -1,
   } },

   /* replace360_0 -> 132 in the cache */
   /* replace360_1_0 -> 135 in the cache */
   /* replace360_1_1_0 -> 133 in the cache */
   /* replace360_1_1 -> 1207 in the cache */
   /* replace360_1 -> 1208 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 132, 1208 },
      -1,
   } },

   /* ('~fge', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fge', ('fneg', ('fadd', 'c', 'b')), 'a') */
   /* search361_0_0_0 -> 132 in the cache */
   /* search361_0_0_1 -> 293 in the cache */
   /* search361_0_0 -> 1205 in the cache */
   /* search361_0 -> 1210 in the cache */
   /* search361_1 -> 824 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1210, 824 },
      -1,
   } },

   /* replace361_0_0_0 -> 135 in the cache */
   /* replace361_0_0_1 -> 133 in the cache */
   /* replace361_0_0 -> 1212 in the cache */
   /* replace361_0 -> 1213 in the cache */
   /* replace361_1 -> 132 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1213, 132 },
      -1,
   } },

   /* ('~feq', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('feq', 'a', ('fadd', 'c', ('fneg', 'b'))) */
   /* search362_0_0 -> 132 in the cache */
   /* search362_0_1 -> 293 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 132, 293 },
      0,
   } },
   /* search362_1 -> 824 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1219, 824 },
      -1,
   } },

   /* replace362_0 -> 132 in the cache */
   /* replace362_1_0 -> 135 in the cache */
   /* replace362_1_1_0 -> 133 in the cache */
   /* replace362_1_1 -> 1207 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 135, 1207 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 132, 1221 },
      -1,
   } },

   /* ('~feq', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('feq', ('fneg', ('fadd', 'c', 'b')), 'a') */
   /* search363_0_0_0 -> 132 in the cache */
   /* search363_0_0_1 -> 293 in the cache */
   /* search363_0_0 -> 1219 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1219 },
      0,
   } },
   /* search363_1 -> 824 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1223, 824 },
      -1,
   } },

   /* replace363_0_0_0 -> 135 in the cache */
   /* replace363_0_0_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 135, 133 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1225 },
      -1,
   } },
   /* replace363_1 -> 132 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1226, 132 },
      -1,
   } },

   /* ('~fneu', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fneu', 'a', ('fadd', 'c', ('fneg', 'b'))) */
   /* search364_0_0 -> 132 in the cache */
   /* search364_0_1 -> 293 in the cache */
   /* search364_0 -> 1219 in the cache */
   /* search364_1 -> 824 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1219, 824 },
      -1,
   } },

   /* replace364_0 -> 132 in the cache */
   /* replace364_1_0 -> 135 in the cache */
   /* replace364_1_1_0 -> 133 in the cache */
   /* replace364_1_1 -> 1207 in the cache */
   /* replace364_1 -> 1221 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 132, 1221 },
      -1,
   } },

   /* ('~fneu', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fneu', ('fneg', ('fadd', 'c', 'b')), 'a') */
   /* search365_0_0_0 -> 132 in the cache */
   /* search365_0_0_1 -> 293 in the cache */
   /* search365_0_0 -> 1219 in the cache */
   /* search365_0 -> 1223 in the cache */
   /* search365_1 -> 824 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1223, 824 },
      -1,
   } },

   /* replace365_0_0_0 -> 135 in the cache */
   /* replace365_0_0_1 -> 133 in the cache */
   /* replace365_0_0 -> 1225 in the cache */
   /* replace365_0 -> 1226 in the cache */
   /* replace365_1 -> 132 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1226, 132 },
      -1,
   } },

   /* ('ieq', ('iadd', 'a', 'b'), 'a') => ('ieq', 'b', 0) */
   /* search366_0_0 -> 0 in the cache */
   /* search366_0_1 -> 3 in the cache */
   /* search366_0 -> 219 in the cache */
   /* search366_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 219, 0 },
      -1,
   } },

   /* replace366_0 -> 3 in the cache */
   /* replace366_1 -> 86 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 3, 86 },
      -1,
   } },

   /* ('ine', ('iadd', 'a', 'b'), 'a') => ('ine', 'b', 0) */
   /* search367_0_0 -> 0 in the cache */
   /* search367_0_1 -> 3 in the cache */
   /* search367_0 -> 219 in the cache */
   /* search367_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 219, 0 },
      -1,
   } },

   /* replace367_0 -> 3 in the cache */
   /* replace367_1 -> 86 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 3, 86 },
      -1,
   } },

   /* ('feq', ('b2f', 'a@1'), 0.0) => ('inot', 'a') */
   /* search368_0_0 -> 767 in the cache */
   /* search368_0 -> 1139 in the cache */
   /* search368_1 -> 1138 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1139, 1138 },
      -1,
   } },

   /* replace368_0 -> 767 in the cache */
   /* replace368 -> 1141 in the cache */

   /* ('fneu', ('b2f', 'a@1'), 0.0) => a */
   /* search369_0_0 -> 767 in the cache */
   /* search369_0 -> 1139 in the cache */
   /* search369_1 -> 1138 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1139, 1138 },
      -1,
   } },

   /* replace369 -> 767 in the cache */

   /* ('ieq', ('b2i', 'a@1'), 0) => ('inot', 'a') */
   /* search370_0_0 -> 767 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 0,
      { 767 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 0 },
      nir_type_int, { 0x0 /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1238, 1239 },
      -1,
   } },

   /* replace370_0 -> 767 in the cache */
   /* replace370 -> 1141 in the cache */

   /* ('ine', ('b2i', 'a@1'), 0) => a */
   /* search371_0_0 -> 767 in the cache */
   /* search371_0 -> 1238 in the cache */
   /* search371_1 -> 1239 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1238, 1239 },
      -1,
   } },

   /* replace371 -> 767 in the cache */

   /* ('ieq', 'a@1', False) => ('inot', 'a') */
   /* search372_0 -> 767 in the cache */
   /* search372_1 -> 1087 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 767, 1087 },
      -1,
   } },

   /* replace372_0 -> 767 in the cache */
   /* replace372 -> 1141 in the cache */

   /* ('ieq', 'a@1', True) => a */
   /* search373_0 -> 767 in the cache */
   { .constant = {
      { nir_search_value_constant, 1 },
      nir_type_bool, { NIR_TRUE /* True */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 767, 1243 },
      -1,
   } },

   /* replace373 -> 767 in the cache */

   /* ('ine', 'a@1', False) => a */
   /* search374_0 -> 767 in the cache */
   /* search374_1 -> 1087 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 767, 1087 },
      -1,
   } },

   /* replace374 -> 767 in the cache */

   /* ('ine', 'a@1', True) => ('inot', 'a') */
   /* search375_0 -> 767 in the cache */
   /* search375_1 -> 1243 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 767, 1243 },
      -1,
   } },

   /* replace375_0 -> 767 in the cache */
   /* replace375 -> 1141 in the cache */

   /* ('fneu', ('u2f', 'a'), 0.0) => ('ine', 'a', 0) */
   /* search376_0_0 -> 32 in the cache */
   /* search376_0 -> 112 in the cache */
   /* search376_1 -> 1138 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 112, 1138 },
      -1,
   } },

   /* replace376_0 -> 32 in the cache */
   /* replace376_1 -> 61 in the cache */
   /* replace376 -> 1120 in the cache */

   /* ('feq', ('u2f', 'a'), 0.0) => ('ieq', 'a', 0) */
   /* search377_0_0 -> 32 in the cache */
   /* search377_0 -> 112 in the cache */
   /* search377_1 -> 1138 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 112, 1138 },
      -1,
   } },

   /* replace377_0 -> 32 in the cache */
   /* replace377_1 -> 61 in the cache */
   /* replace377 -> 1118 in the cache */

   /* ('fge', ('u2f', 'a'), 0.0) => True */
   /* search378_0_0 -> 32 in the cache */
   /* search378_0 -> 112 in the cache */
   /* search378_1 -> 1138 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 112, 1138 },
      -1,
   } },

   /* replace378 -> 1243 in the cache */

   /* ('fge', 0.0, ('u2f', 'a')) => ('uge', 0, 'a') */
   /* search379_0 -> 1138 in the cache */
   /* search379_1_0 -> 32 in the cache */
   /* search379_1 -> 112 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1138, 112 },
      -1,
   } },

   /* replace379_0 -> 61 in the cache */
   /* replace379_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 61, 32 },
      -1,
   } },

   /* ('flt', ('u2f', 'a'), 0.0) => False */
   /* search380_0_0 -> 32 in the cache */
   /* search380_0 -> 112 in the cache */
   /* search380_1 -> 1138 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 112, 1138 },
      -1,
   } },

   /* replace380 -> 1087 in the cache */

   /* ('flt', 0.0, ('u2f', 'a')) => ('ult', 0, 'a') */
   /* search381_0 -> 1138 in the cache */
   /* search381_1_0 -> 32 in the cache */
   /* search381_1 -> 112 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1138, 112 },
      -1,
   } },

   /* replace381_0 -> 61 in the cache */
   /* replace381_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 61, 32 },
      -1,
   } },

   /* ('fneu', ('i2f', 'a'), 0.0) => ('ine', 'a', 0) */
   /* search382_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_i2f,
      -1, 0,
      { 32 },
      -1,
   } },
   /* search382_1 -> 1138 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1255, 1138 },
      -1,
   } },

   /* replace382_0 -> 32 in the cache */
   /* replace382_1 -> 61 in the cache */
   /* replace382 -> 1120 in the cache */

   /* ('feq', ('i2f', 'a'), 0.0) => ('ieq', 'a', 0) */
   /* search383_0_0 -> 32 in the cache */
   /* search383_0 -> 1255 in the cache */
   /* search383_1 -> 1138 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1255, 1138 },
      -1,
   } },

   /* replace383_0 -> 32 in the cache */
   /* replace383_1 -> 61 in the cache */
   /* replace383 -> 1118 in the cache */

   /* ('fge', ('i2f', 'a'), 0.0) => ('ige', 'a', 0) */
   /* search384_0_0 -> 32 in the cache */
   /* search384_0 -> 1255 in the cache */
   /* search384_1 -> 1138 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1255, 1138 },
      -1,
   } },

   /* replace384_0 -> 32 in the cache */
   /* replace384_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 32, 61 },
      -1,
   } },

   /* ('fge', 0.0, ('i2f', 'a')) => ('ige', 0, 'a') */
   /* search385_0 -> 1138 in the cache */
   /* search385_1_0 -> 32 in the cache */
   /* search385_1 -> 1255 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1138, 1255 },
      -1,
   } },

   /* replace385_0 -> 61 in the cache */
   /* replace385_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 61, 32 },
      -1,
   } },

   /* ('flt', ('i2f', 'a'), 0.0) => ('ilt', 'a', 0) */
   /* search386_0_0 -> 32 in the cache */
   /* search386_0 -> 1255 in the cache */
   /* search386_1 -> 1138 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1255, 1138 },
      -1,
   } },

   /* replace386_0 -> 32 in the cache */
   /* replace386_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 32, 61 },
      -1,
   } },

   /* ('flt', 0.0, ('i2f', 'a')) => ('ilt', 0, 'a') */
   /* search387_0 -> 1138 in the cache */
   /* search387_1_0 -> 32 in the cache */
   /* search387_1 -> 1255 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1138, 1255 },
      -1,
   } },

   /* replace387_0 -> 61 in the cache */
   /* replace387_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 61, 32 },
      -1,
   } },

   /* ('~flt', 0.0, ('fabs', 'a')) => ('fneu', 'a', 0.0) */
   /* search388_0 -> 117 in the cache */
   /* search388_1_0 -> 32 in the cache */
   /* search388_1 -> 99 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 117, 99 },
      -1,
   } },

   /* replace388_0 -> 32 in the cache */
   /* replace388_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 32, 117 },
      -1,
   } },

   /* ('~flt', ('fneg', ('fabs', 'a')), 0.0) => ('fneu', 'a', 0.0) */
   /* search389_0_0_0 -> 32 in the cache */
   /* search389_0_0 -> 99 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 99 },
      -1,
   } },
   /* search389_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1268, 117 },
      -1,
   } },

   /* replace389_0 -> 32 in the cache */
   /* replace389_1 -> 117 in the cache */
   /* replace389 -> 1267 in the cache */

   /* ('fge', 0.0, ('fabs', 'a')) => ('feq', 'a', 0.0) */
   /* search390_0 -> 117 in the cache */
   /* search390_1_0 -> 32 in the cache */
   /* search390_1 -> 99 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 117, 99 },
      -1,
   } },

   /* replace390_0 -> 32 in the cache */
   /* replace390_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 32, 117 },
      -1,
   } },

   /* ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0) */
   /* search391_0_0_0 -> 32 in the cache */
   /* search391_0_0 -> 99 in the cache */
   /* search391_0 -> 1268 in the cache */
   /* search391_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1268, 117 },
      -1,
   } },

   /* replace391_0 -> 32 in the cache */
   /* replace391_1 -> 117 in the cache */
   /* replace391 -> 1271 in the cache */

   /* ('iand', ('fge', 'a', 0.0), ('fge', 1.0, 'a')) => ('feq', 'a', ('fsat', 'a')) */
   /* search392_0_0 -> 32 in the cache */
   /* search392_0_1 -> 117 in the cache */
   /* search392_0 -> 1184 in the cache */
   /* search392_1_0 -> 252 in the cache */
   /* search392_1_1 -> 32 in the cache */
   /* search392_1 -> 1110 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1184, 1110 },
      -1,
   } },

   /* replace392_0 -> 32 in the cache */
   /* replace392_1_0 -> 32 in the cache */
   /* replace392_1 -> 228 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 32, 228 },
      -1,
   } },

   /* ('fmax', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('ior', 'a', 'b')) */
   /* search393_0_0 -> 767 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 767 },
      0,
   } },
   /* search393_1_0 -> 1144 in the cache */
   /* search393_1 -> 1145 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 1275, 1145 },
      -1,
   } },

   /* replace393_0_0 -> 767 in the cache */
   /* replace393_0_1 -> 1144 in the cache */
   /* replace393_0 -> 1148 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 1,
      { 1148 },
      -1,
   } },

   /* ('fmax', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('iand', 'a', 'b'))) */
   /* search394_0_0_0 -> 767 in the cache */
   /* search394_0_0 -> 1275 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1275 },
      0,
   } },
   /* search394_1_0_0 -> 1144 in the cache */
   /* search394_1_0 -> 1145 in the cache */
   /* search394_1 -> 1152 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 1278, 1152 },
      -1,
   } },

   /* replace394_0_0_0 -> 767 in the cache */
   /* replace394_0_0_1 -> 1144 in the cache */
   /* replace394_0_0 -> 1156 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 1,
      { 1156 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1280 },
      -1,
   } },

   /* ('fmin', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('iand', 'a', 'b')) */
   /* search395_0_0 -> 767 in the cache */
   /* search395_0 -> 1275 in the cache */
   /* search395_1_0 -> 1144 in the cache */
   /* search395_1 -> 1145 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1275, 1145 },
      -1,
   } },

   /* replace395_0_0 -> 767 in the cache */
   /* replace395_0_1 -> 1144 in the cache */
   /* replace395_0 -> 1156 in the cache */
   /* replace395 -> 1280 in the cache */

   /* ('fmin', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('ior', 'a', 'b'))) */
   /* search396_0_0_0 -> 767 in the cache */
   /* search396_0_0 -> 1275 in the cache */
   /* search396_0 -> 1278 in the cache */
   /* search396_1_0_0 -> 1144 in the cache */
   /* search396_1_0 -> 1145 in the cache */
   /* search396_1 -> 1152 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1278, 1152 },
      -1,
   } },

   /* replace396_0_0_0 -> 767 in the cache */
   /* replace396_0_0_1 -> 1144 in the cache */
   /* replace396_0_0 -> 1148 in the cache */
   /* replace396_0 -> 1277 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1277 },
      -1,
   } },

   /* ('fmin', ('b2f', 'a@1'), '#b') => ('bcsel', 'a', ('fmin', 'b', 1.0), ('fmin', 'b', 0.0)) */
   /* search397_0_0 -> 767 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 767 },
      -1,
   } },
   /* search397_1 -> 831 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1285, 831 },
      -1,
   } },

   /* replace397_0 -> 767 in the cache */
   /* replace397_1_0 -> 3 in the cache */
   /* replace397_1_1 -> 280 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 3, 280 },
      -1,
   } },
   /* replace397_2_0 -> 3 in the cache */
   /* replace397_2_1 -> 266 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 3, 266 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 767, 1287, 1288 },
      -1,
   } },

   /* ('flt', ('fadd(is_used_once)', 'a', ('fneg', 'b')), 0.0) => ('flt', 'a', 'b') */
   /* search398_0_0 -> 0 in the cache */
   /* search398_0_1_0 -> 3 in the cache */
   /* search398_0_1 -> 1097 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 0, 1097 },
      0,
   } },
   /* search398_1 -> 266 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1290, 266 },
      -1,
   } },

   /* replace398_0 -> 0 in the cache */
   /* replace398_1 -> 3 in the cache */
   /* replace398 -> 1059 in the cache */

   /* ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0) */
   /* search399_0_0_0 -> 32 in the cache */
   /* search399_0_0 -> 99 in the cache */
   /* search399_0 -> 1268 in the cache */
   /* search399_1 -> 117 in the cache */
   /* search399 -> 1272 in the cache */

   /* replace399_0 -> 32 in the cache */
   /* replace399_1 -> 117 in the cache */
   /* replace399 -> 1271 in the cache */

   /* ('~bcsel', ('flt', 'b', 'a'), 'b', 'a') => ('fmin', 'a', 'b') */
   /* search400_0_0 -> 1127 in the cache */
   /* search400_0_1 -> 1124 in the cache */
   /* search400_0 -> 1128 in the cache */
   /* search400_1 -> 1127 in the cache */
   /* search400_2 -> 1124 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1128, 1127, 1124 },
      -1,
   } },

   /* replace400_0 -> 1124 in the cache */
   /* replace400_1 -> 1127 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1124, 1127 },
      -1,
   } },

   /* ('~bcsel', ('flt', 'a', 'b'), 'b', 'a') => ('fmax', 'a', 'b') */
   /* search401_0_0 -> 0 in the cache */
   /* search401_0_1 -> 3 in the cache */
   /* search401_0 -> 1059 in the cache */
   /* search401_1 -> 3 in the cache */
   /* search401_2 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1059, 3, 0 },
      -1,
   } },

   /* replace401_0 -> 0 in the cache */
   /* replace401_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('~bcsel', ('fge', 'a', 'b'), 'b', 'a') => ('fmin', 'a', 'b') */
   /* search402_0_0 -> 0 in the cache */
   /* search402_0_1 -> 3 in the cache */
   /* search402_0 -> 1056 in the cache */
   /* search402_1 -> 3 in the cache */
   /* search402_2 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1056, 3, 0 },
      -1,
   } },

   /* replace402_0 -> 0 in the cache */
   /* replace402_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('~bcsel', ('fge', 'b', 'a'), 'b', 'a') => ('fmax', 'a', 'b') */
   /* search403_0_0 -> 1127 in the cache */
   /* search403_0_1 -> 1124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1127, 1124 },
      -1,
   } },
   /* search403_1 -> 1127 in the cache */
   /* search403_2 -> 1124 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1298, 1127, 1124 },
      -1,
   } },

   /* replace403_0 -> 1124 in the cache */
   /* replace403_1 -> 1127 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 1124, 1127 },
      -1,
   } },

   /* ('bcsel', ('inot', 'a'), 'b', 'c') => ('bcsel', 'a', 'c', 'b') */
   /* search404_0_0 -> 767 in the cache */
   /* search404_0 -> 1141 in the cache */
   /* search404_1 -> 133 in the cache */
   /* search404_2 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1141, 133, 135 },
      -1,
   } },

   /* replace404_0 -> 767 in the cache */
   /* replace404_1 -> 135 in the cache */
   /* replace404_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 767, 135, 133 },
      -1,
   } },

   /* ('bcsel', 'a', ('bcsel', 'a', 'b', 'c'), 'd') => ('bcsel', 'a', 'b', 'd') */
   /* search405_0 -> 767 in the cache */
   /* search405_1_0 -> 767 in the cache */
   /* search405_1_1 -> 156 in the cache */
   /* search405_1_2 -> 158 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 767, 156, 158 },
      -1,
   } },
   /* search405_2 -> 159 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 767, 1303, 159 },
      -1,
   } },

   /* replace405_0 -> 767 in the cache */
   /* replace405_1 -> 156 in the cache */
   /* replace405_2 -> 159 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 767, 156, 159 },
      -1,
   } },

   /* ('bcsel', 'a', 'b', ('bcsel', 'a', 'c', 'd')) => ('bcsel', 'a', 'b', 'd') */
   /* search406_0 -> 767 in the cache */
   /* search406_1 -> 156 in the cache */
   /* search406_2_0 -> 767 in the cache */
   /* search406_2_1 -> 158 in the cache */
   /* search406_2_2 -> 159 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 767, 158, 159 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 767, 156, 1306 },
      -1,
   } },

   /* replace406_0 -> 767 in the cache */
   /* replace406_1 -> 156 in the cache */
   /* replace406_2 -> 159 in the cache */
   /* replace406 -> 1305 in the cache */

   /* ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e')) */
   /* search407_0 -> 767 in the cache */
   /* search407_1_0 -> 1144 in the cache */
   /* search407_1_1 -> 760 in the cache */
   /* search407_1_2 -> 769 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1144, 760, 769 },
      -1,
   } },
   /* search407_2_0 -> 1144 in the cache */
   /* search407_2_1 -> 760 in the cache */
   /* search407_2_2 -> 771 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1144, 760, 771 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 767, 1308, 1309 },
      -1,
   } },

   /* replace407_0 -> 1144 in the cache */
   /* replace407_1 -> 760 in the cache */
   /* replace407_2_0 -> 767 in the cache */
   /* replace407_2_1 -> 769 in the cache */
   /* replace407_2_2 -> 771 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 767, 769, 771 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1144, 760, 1311 },
      -1,
   } },

   /* ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e')) */
   /* search408_0 -> 767 in the cache */
   /* search408_1_0 -> 1144 in the cache */
   /* search408_1_1 -> 760 in the cache */
   /* search408_1_2 -> 769 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1144, 760, 769 },
      0,
   } },
   /* search408_2_0 -> 1144 in the cache */
   /* search408_2_1 -> 760 in the cache */
   /* search408_2_2 -> 771 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1144, 760, 771 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 767, 1313, 1314 },
      -1,
   } },

   /* replace408_0 -> 1144 in the cache */
   /* replace408_1 -> 760 in the cache */
   /* replace408_2_0 -> 767 in the cache */
   /* replace408_2_1 -> 769 in the cache */
   /* replace408_2_2 -> 771 in the cache */
   /* replace408_2 -> 1311 in the cache */
   /* replace408 -> 1312 in the cache */

   /* ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd') */
   /* search409_0 -> 767 in the cache */
   /* search409_1_0 -> 1144 in the cache */
   /* search409_1_1 -> 158 in the cache */
   /* search409_1_2 -> 159 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1144, 158, 159 },
      -1,
   } },
   /* search409_2_0 -> 1144 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      4, /* e */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search409_2_2 -> 159 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1144, 1317, 159 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 767, 1316, 1318 },
      -1,
   } },

   /* replace409_0 -> 1144 in the cache */
   /* replace409_1_0 -> 767 in the cache */
   /* replace409_1_1 -> 158 in the cache */
   /* replace409_1_2 -> 1317 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 767, 158, 1317 },
      -1,
   } },
   /* replace409_2 -> 159 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1144, 1320, 159 },
      -1,
   } },

   /* ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd') */
   /* search410_0 -> 767 in the cache */
   /* search410_1_0 -> 1144 in the cache */
   /* search410_1_1 -> 158 in the cache */
   /* search410_1_2 -> 159 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1144, 158, 159 },
      0,
   } },
   /* search410_2_0 -> 1144 in the cache */
   /* search410_2_1 -> 1317 in the cache */
   /* search410_2_2 -> 159 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1144, 1317, 159 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 767, 1322, 1323 },
      -1,
   } },

   /* replace410_0 -> 1144 in the cache */
   /* replace410_1_0 -> 767 in the cache */
   /* replace410_1_1 -> 158 in the cache */
   /* replace410_1_2 -> 1317 in the cache */
   /* replace410_1 -> 1320 in the cache */
   /* replace410_2 -> 159 in the cache */
   /* replace410 -> 1321 in the cache */

   /* ('bcsel', 'a', True, 'b') => ('ior', 'a', 'b') */
   /* search411_0 -> 767 in the cache */
   /* search411_1 -> 1243 in the cache */
   /* search411_2 -> 1144 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 767, 1243, 1144 },
      -1,
   } },

   /* replace411_0 -> 767 in the cache */
   /* replace411_1 -> 1144 in the cache */
   /* replace411 -> 1148 in the cache */

   /* ('bcsel', 'a', 'a', 'b') => ('ior', 'a', 'b') */
   /* search412_0 -> 767 in the cache */
   /* search412_1 -> 767 in the cache */
   /* search412_2 -> 1144 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 767, 767, 1144 },
      -1,
   } },

   /* replace412_0 -> 767 in the cache */
   /* replace412_1 -> 1144 in the cache */
   /* replace412 -> 1148 in the cache */

   /* ('bcsel', 'a', 'b', False) => ('iand', 'a', 'b') */
   /* search413_0 -> 767 in the cache */
   /* search413_1 -> 1144 in the cache */
   /* search413_2 -> 1087 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 767, 1144, 1087 },
      -1,
   } },

   /* replace413_0 -> 767 in the cache */
   /* replace413_1 -> 1144 in the cache */
   /* replace413 -> 1156 in the cache */

   /* ('bcsel', 'a', 'b', 'a') => ('iand', 'a', 'b') */
   /* search414_0 -> 767 in the cache */
   /* search414_1 -> 1144 in the cache */
   /* search414_2 -> 767 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 767, 1144, 767 },
      -1,
   } },

   /* replace414_0 -> 767 in the cache */
   /* replace414_1 -> 1144 in the cache */
   /* replace414 -> 1156 in the cache */

   /* ('~fmin', 'a', 'a') => a */
   /* search415_0 -> 32 in the cache */
   /* search415_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmin,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace415 -> 32 in the cache */

   /* ('~fmax', 'a', 'a') => a */
   /* search416_0 -> 32 in the cache */
   /* search416_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmax,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace416 -> 32 in the cache */

   /* ('imin', 'a', 'a') => a */
   /* search417_0 -> 32 in the cache */
   /* search417_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imin,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace417 -> 32 in the cache */

   /* ('imax', 'a', 'a') => a */
   /* search418_0 -> 32 in the cache */
   /* search418_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imax,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace418 -> 32 in the cache */

   /* ('umin', 'a', 'a') => a */
   /* search419_0 -> 32 in the cache */
   /* search419_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umin,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace419 -> 32 in the cache */

   /* ('umin', 'a', 0) => 0 */
   /* search420_0 -> 32 in the cache */
   /* search420_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* replace420 -> 61 in the cache */

   /* ('umin', 'a', -1) => a */
   /* search421_0 -> 32 in the cache */
   /* search421_1 -> 63 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 32, 63 },
      -1,
   } },

   /* replace421 -> 32 in the cache */

   /* ('umax', 'a', 'a') => a */
   /* search422_0 -> 32 in the cache */
   /* search422_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umax,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace422 -> 32 in the cache */

   /* ('umax', 'a', 0) => a */
   /* search423_0 -> 32 in the cache */
   /* search423_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* replace423 -> 32 in the cache */

   /* ('umax', 'a', -1) => -1 */
   /* search424_0 -> 32 in the cache */
   /* search424_1 -> 63 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 32, 63 },
      -1,
   } },

   /* replace424 -> 63 in the cache */

   /* ('fmax', ('fmax', 'a', 'b'), 'b') => ('fmax', 'a', 'b') */
   /* search425_0_0 -> 0 in the cache */
   /* search425_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search425_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1339, 3 },
      -1,
   } },

   /* replace425_0 -> 0 in the cache */
   /* replace425_1 -> 3 in the cache */
   /* replace425 -> 1295 in the cache */

   /* ('umax', ('umax', 'a', 'b'), 'b') => ('umax', 'a', 'b') */
   /* search426_0_0 -> 0 in the cache */
   /* search426_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umax,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search426_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umax,
      0, 2,
      { 1341, 3 },
      -1,
   } },

   /* replace426_0 -> 0 in the cache */
   /* replace426_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('imax', ('imax', 'a', 'b'), 'b') => ('imax', 'a', 'b') */
   /* search427_0_0 -> 0 in the cache */
   /* search427_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imax,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search427_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imax,
      0, 2,
      { 1344, 3 },
      -1,
   } },

   /* replace427_0 -> 0 in the cache */
   /* replace427_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('fmin', ('fmin', 'a', 'b'), 'b') => ('fmin', 'a', 'b') */
   /* search428_0_0 -> 0 in the cache */
   /* search428_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search428_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1347, 3 },
      -1,
   } },

   /* replace428_0 -> 0 in the cache */
   /* replace428_1 -> 3 in the cache */
   /* replace428 -> 1297 in the cache */

   /* ('umin', ('umin', 'a', 'b'), 'b') => ('umin', 'a', 'b') */
   /* search429_0_0 -> 0 in the cache */
   /* search429_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umin,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search429_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umin,
      0, 2,
      { 1349, 3 },
      -1,
   } },

   /* replace429_0 -> 0 in the cache */
   /* replace429_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('imin', ('imin', 'a', 'b'), 'b') => ('imin', 'a', 'b') */
   /* search430_0_0 -> 0 in the cache */
   /* search430_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imin,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search430_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imin,
      0, 2,
      { 1352, 3 },
      -1,
   } },

   /* replace430_0 -> 0 in the cache */
   /* replace430_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('fmax', ('fmax', ('fmax', 'a', 'b'), 'c'), 'a') => ('fmax', ('fmax', 'a', 'b'), 'c') */
   /* search431_0_0_0 -> 132 in the cache */
   /* search431_0_0_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmax,
      2, 1,
      { 132, 133 },
      -1,
   } },
   /* search431_0_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmax,
      1, 2,
      { 1355, 135 },
      -1,
   } },
   /* search431_1 -> 132 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 3,
      { 1356, 132 },
      -1,
   } },

   /* replace431_0_0 -> 132 in the cache */
   /* replace431_0_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmax,
      1, 1,
      { 132, 133 },
      -1,
   } },
   /* replace431_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1358, 135 },
      -1,
   } },

   /* ('umax', ('umax', ('umax', 'a', 'b'), 'c'), 'a') => ('umax', ('umax', 'a', 'b'), 'c') */
   /* search432_0_0_0 -> 132 in the cache */
   /* search432_0_0_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      2, 1,
      { 132, 133 },
      -1,
   } },
   /* search432_0_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      1, 2,
      { 1360, 135 },
      -1,
   } },
   /* search432_1 -> 132 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      0, 3,
      { 1361, 132 },
      -1,
   } },

   /* replace432_0_0 -> 132 in the cache */
   /* replace432_0_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      1, 1,
      { 132, 133 },
      -1,
   } },
   /* replace432_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      0, 2,
      { 1363, 135 },
      -1,
   } },

   /* ('imax', ('imax', ('imax', 'a', 'b'), 'c'), 'a') => ('imax', ('imax', 'a', 'b'), 'c') */
   /* search433_0_0_0 -> 132 in the cache */
   /* search433_0_0_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      2, 1,
      { 132, 133 },
      -1,
   } },
   /* search433_0_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      1, 2,
      { 1365, 135 },
      -1,
   } },
   /* search433_1 -> 132 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      0, 3,
      { 1366, 132 },
      -1,
   } },

   /* replace433_0_0 -> 132 in the cache */
   /* replace433_0_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      1, 1,
      { 132, 133 },
      -1,
   } },
   /* replace433_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      0, 2,
      { 1368, 135 },
      -1,
   } },

   /* ('fmin', ('fmin', ('fmin', 'a', 'b'), 'c'), 'a') => ('fmin', ('fmin', 'a', 'b'), 'c') */
   /* search434_0_0_0 -> 132 in the cache */
   /* search434_0_0_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      2, 1,
      { 132, 133 },
      -1,
   } },
   /* search434_0_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      1, 2,
      { 1370, 135 },
      -1,
   } },
   /* search434_1 -> 132 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 3,
      { 1371, 132 },
      -1,
   } },

   /* replace434_0_0 -> 132 in the cache */
   /* replace434_0_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 132, 133 },
      -1,
   } },
   /* replace434_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1373, 135 },
      -1,
   } },

   /* ('umin', ('umin', ('umin', 'a', 'b'), 'c'), 'a') => ('umin', ('umin', 'a', 'b'), 'c') */
   /* search435_0_0_0 -> 132 in the cache */
   /* search435_0_0_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      2, 1,
      { 132, 133 },
      -1,
   } },
   /* search435_0_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      1, 2,
      { 1375, 135 },
      -1,
   } },
   /* search435_1 -> 132 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      0, 3,
      { 1376, 132 },
      -1,
   } },

   /* replace435_0_0 -> 132 in the cache */
   /* replace435_0_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      1, 1,
      { 132, 133 },
      -1,
   } },
   /* replace435_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      0, 2,
      { 1378, 135 },
      -1,
   } },

   /* ('imin', ('imin', ('imin', 'a', 'b'), 'c'), 'a') => ('imin', ('imin', 'a', 'b'), 'c') */
   /* search436_0_0_0 -> 132 in the cache */
   /* search436_0_0_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      2, 1,
      { 132, 133 },
      -1,
   } },
   /* search436_0_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      1, 2,
      { 1380, 135 },
      -1,
   } },
   /* search436_1 -> 132 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      0, 3,
      { 1381, 132 },
      -1,
   } },

   /* replace436_0_0 -> 132 in the cache */
   /* replace436_0_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      1, 1,
      { 132, 133 },
      -1,
   } },
   /* replace436_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      0, 2,
      { 1383, 135 },
      -1,
   } },

   /* ('ieq', ('b2i8', 'a@1'), ('b2i8', 'b@1')) => ('ieq', 'a', 'b') */
   /* search437_0_0 -> 767 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_b2i8,
      -1, 0,
      { 767 },
      -1,
   } },
   /* search437_1_0 -> 1144 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_b2i8,
      -1, 0,
      { 1144 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1385, 1386 },
      -1,
   } },

   /* replace437_0 -> 767 in the cache */
   /* replace437_1 -> 1144 in the cache */
   /* replace437 -> 1172 in the cache */

   /* ('ine', ('b2i8', 'a@1'), ('b2i8', 'b@1')) => ('ine', 'a', 'b') */
   /* search438_0_0 -> 767 in the cache */
   /* search438_0 -> 1385 in the cache */
   /* search438_1_0 -> 1144 in the cache */
   /* search438_1 -> 1386 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1385, 1386 },
      -1,
   } },

   /* replace438_0 -> 767 in the cache */
   /* replace438_1 -> 1144 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 767, 1144 },
      -1,
   } },

   /* ('ieq', ('b2i16', 'a@1'), ('b2i16', 'b@1')) => ('ieq', 'a', 'b') */
   /* search439_0_0 -> 767 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 767 },
      -1,
   } },
   /* search439_1_0 -> 1144 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 1144 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1390, 1391 },
      -1,
   } },

   /* replace439_0 -> 767 in the cache */
   /* replace439_1 -> 1144 in the cache */
   /* replace439 -> 1172 in the cache */

   /* ('ine', ('b2i16', 'a@1'), ('b2i16', 'b@1')) => ('ine', 'a', 'b') */
   /* search440_0_0 -> 767 in the cache */
   /* search440_0 -> 1390 in the cache */
   /* search440_1_0 -> 1144 in the cache */
   /* search440_1 -> 1391 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1390, 1391 },
      -1,
   } },

   /* replace440_0 -> 767 in the cache */
   /* replace440_1 -> 1144 in the cache */
   /* replace440 -> 1389 in the cache */

   /* ('ieq', ('b2i32', 'a@1'), ('b2i32', 'b@1')) => ('ieq', 'a', 'b') */
   /* search441_0_0 -> 767 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 767 },
      -1,
   } },
   /* search441_1_0 -> 1144 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1144 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1394, 1395 },
      -1,
   } },

   /* replace441_0 -> 767 in the cache */
   /* replace441_1 -> 1144 in the cache */
   /* replace441 -> 1172 in the cache */

   /* ('ine', ('b2i32', 'a@1'), ('b2i32', 'b@1')) => ('ine', 'a', 'b') */
   /* search442_0_0 -> 767 in the cache */
   /* search442_0 -> 1394 in the cache */
   /* search442_1_0 -> 1144 in the cache */
   /* search442_1 -> 1395 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1394, 1395 },
      -1,
   } },

   /* replace442_0 -> 767 in the cache */
   /* replace442_1 -> 1144 in the cache */
   /* replace442 -> 1389 in the cache */

   /* ('ieq', ('b2i64', 'a@1'), ('b2i64', 'b@1')) => ('ieq', 'a', 'b') */
   /* search443_0_0 -> 767 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 767 },
      -1,
   } },
   /* search443_1_0 -> 1144 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 1144 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1398, 1399 },
      -1,
   } },

   /* replace443_0 -> 767 in the cache */
   /* replace443_1 -> 1144 in the cache */
   /* replace443 -> 1172 in the cache */

   /* ('ine', ('b2i64', 'a@1'), ('b2i64', 'b@1')) => ('ine', 'a', 'b') */
   /* search444_0_0 -> 767 in the cache */
   /* search444_0 -> 1398 in the cache */
   /* search444_1_0 -> 1144 in the cache */
   /* search444_1 -> 1399 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1398, 1399 },
      -1,
   } },

   /* replace444_0 -> 767 in the cache */
   /* replace444_1 -> 1144 in the cache */
   /* replace444 -> 1389 in the cache */

   /* ('feq', ('b2f16', 'a@1'), ('b2f16', 'b@1')) => ('ieq', 'a', 'b') */
   /* search445_0_0 -> 767 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2f16,
      -1, 0,
      { 767 },
      -1,
   } },
   /* search445_1_0 -> 1144 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2f16,
      -1, 0,
      { 1144 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1402, 1403 },
      -1,
   } },

   /* replace445_0 -> 767 in the cache */
   /* replace445_1 -> 1144 in the cache */
   /* replace445 -> 1172 in the cache */

   /* ('fneu', ('b2f16', 'a@1'), ('b2f16', 'b@1')) => ('ine', 'a', 'b') */
   /* search446_0_0 -> 767 in the cache */
   /* search446_0 -> 1402 in the cache */
   /* search446_1_0 -> 1144 in the cache */
   /* search446_1 -> 1403 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1402, 1403 },
      -1,
   } },

   /* replace446_0 -> 767 in the cache */
   /* replace446_1 -> 1144 in the cache */
   /* replace446 -> 1389 in the cache */

   /* ('feq', ('b2f32', 'a@1'), ('b2f32', 'b@1')) => ('ieq', 'a', 'b') */
   /* search447_0_0 -> 767 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2f32,
      -1, 0,
      { 767 },
      -1,
   } },
   /* search447_1_0 -> 1144 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2f32,
      -1, 0,
      { 1144 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1406, 1407 },
      -1,
   } },

   /* replace447_0 -> 767 in the cache */
   /* replace447_1 -> 1144 in the cache */
   /* replace447 -> 1172 in the cache */

   /* ('fneu', ('b2f32', 'a@1'), ('b2f32', 'b@1')) => ('ine', 'a', 'b') */
   /* search448_0_0 -> 767 in the cache */
   /* search448_0 -> 1406 in the cache */
   /* search448_1_0 -> 1144 in the cache */
   /* search448_1 -> 1407 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1406, 1407 },
      -1,
   } },

   /* replace448_0 -> 767 in the cache */
   /* replace448_1 -> 1144 in the cache */
   /* replace448 -> 1389 in the cache */

   /* ('feq', ('b2f64', 'a@1'), ('b2f64', 'b@1')) => ('ieq', 'a', 'b') */
   /* search449_0_0 -> 767 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2f64,
      -1, 0,
      { 767 },
      -1,
   } },
   /* search449_1_0 -> 1144 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2f64,
      -1, 0,
      { 1144 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1410, 1411 },
      -1,
   } },

   /* replace449_0 -> 767 in the cache */
   /* replace449_1 -> 1144 in the cache */
   /* replace449 -> 1172 in the cache */

   /* ('fneu', ('b2f64', 'a@1'), ('b2f64', 'b@1')) => ('ine', 'a', 'b') */
   /* search450_0_0 -> 767 in the cache */
   /* search450_0 -> 1410 in the cache */
   /* search450_1_0 -> 1144 in the cache */
   /* search450_1 -> 1411 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1410, 1411 },
      -1,
   } },

   /* replace450_0 -> 767 in the cache */
   /* replace450_1 -> 1144 in the cache */
   /* replace450 -> 1389 in the cache */

   /* ('iand@8', 'a', ('inot', ('ishr', 'a', 7))) => ('imax', 'a', 0) */
   /* search451_0 -> 6 in the cache */
   /* search451_1_0_0 -> 6 in the cache */
   /* search451_1_0_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 6, 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1414 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 6, 1415 },
      -1,
   } },

   /* replace451_0 -> 6 in the cache */
   /* replace451_1 -> 845 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 6, 845 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@8', 128), 0) => ('ige', 'a', 0) */
   /* search452_0_0 -> 6 in the cache */
   /* search452_0_1 -> 7 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 6, 7 },
      -1,
   } },
   /* search452_1 -> 845 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1418, 845 },
      -1,
   } },

   /* replace452_0 -> 6 in the cache */
   /* replace452_1 -> 845 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 6, 845 },
      -1,
   } },

   /* ('ine', ('iand', 'a@8', 128), 128) => ('ige', 'a', 0) */
   /* search453_0_0 -> 6 in the cache */
   /* search453_0_1 -> 7 in the cache */
   /* search453_0 -> 1418 in the cache */
   /* search453_1 -> 7 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1418, 7 },
      -1,
   } },

   /* replace453_0 -> 6 in the cache */
   /* replace453_1 -> 845 in the cache */
   /* replace453 -> 1420 in the cache */

   /* ('ine', ('iand', 'a@8', 128), 0) => ('ilt', 'a', 0) */
   /* search454_0_0 -> 6 in the cache */
   /* search454_0_1 -> 7 in the cache */
   /* search454_0 -> 1418 in the cache */
   /* search454_1 -> 845 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1418, 845 },
      -1,
   } },

   /* replace454_0 -> 6 in the cache */
   /* replace454_1 -> 845 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 6, 845 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@8', 128), 128) => ('ilt', 'a', 0) */
   /* search455_0_0 -> 6 in the cache */
   /* search455_0_1 -> 7 in the cache */
   /* search455_0 -> 1418 in the cache */
   /* search455_1 -> 7 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1418, 7 },
      -1,
   } },

   /* replace455_0 -> 6 in the cache */
   /* replace455_1 -> 845 in the cache */
   /* replace455 -> 1423 in the cache */

   /* ('ine', ('ushr', 'a@8', 7), 0) => ('ilt', 'a', 0) */
   /* search456_0_0 -> 6 in the cache */
   /* search456_0_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 6, 9 },
      -1,
   } },
   /* search456_1 -> 845 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1425, 845 },
      -1,
   } },

   /* replace456_0 -> 6 in the cache */
   /* replace456_1 -> 845 in the cache */
   /* replace456 -> 1423 in the cache */

   /* ('ieq', ('ushr', 'a@8', 7), 0) => ('ige', 'a', 0) */
   /* search457_0_0 -> 6 in the cache */
   /* search457_0_1 -> 9 in the cache */
   /* search457_0 -> 1425 in the cache */
   /* search457_1 -> 845 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1425, 845 },
      -1,
   } },

   /* replace457_0 -> 6 in the cache */
   /* replace457_1 -> 845 in the cache */
   /* replace457 -> 1420 in the cache */

   /* ('ieq', ('ushr', 'a@8', 7), 1) => ('ilt', 'a', 0) */
   /* search458_0_0 -> 6 in the cache */
   /* search458_0_1 -> 9 in the cache */
   /* search458_0 -> 1425 in the cache */
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { 0x1 /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1425, 1428 },
      -1,
   } },

   /* replace458_0 -> 6 in the cache */
   /* replace458_1 -> 845 in the cache */
   /* replace458 -> 1423 in the cache */

   /* ('ine', ('ushr', 'a@8', 7), 1) => ('ige', 'a', 0) */
   /* search459_0_0 -> 6 in the cache */
   /* search459_0_1 -> 9 in the cache */
   /* search459_0 -> 1425 in the cache */
   /* search459_1 -> 1428 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1425, 1428 },
      -1,
   } },

   /* replace459_0 -> 6 in the cache */
   /* replace459_1 -> 845 in the cache */
   /* replace459 -> 1420 in the cache */

   /* ('ine', ('ishr', 'a@8', 7), 0) => ('ilt', 'a', 0) */
   /* search460_0_0 -> 6 in the cache */
   /* search460_0_1 -> 9 in the cache */
   /* search460_0 -> 1414 in the cache */
   /* search460_1 -> 845 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1414, 845 },
      -1,
   } },

   /* replace460_0 -> 6 in the cache */
   /* replace460_1 -> 845 in the cache */
   /* replace460 -> 1423 in the cache */

   /* ('ieq', ('ishr', 'a@8', 7), 0) => ('ige', 'a', 0) */
   /* search461_0_0 -> 6 in the cache */
   /* search461_0_1 -> 9 in the cache */
   /* search461_0 -> 1414 in the cache */
   /* search461_1 -> 845 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1414, 845 },
      -1,
   } },

   /* replace461_0 -> 6 in the cache */
   /* replace461_1 -> 845 in the cache */
   /* replace461 -> 1420 in the cache */

   /* ('ieq', ('ishr', 'a@8', 7), -1) => ('ilt', 'a', 0) */
   /* search462_0_0 -> 6 in the cache */
   /* search462_0_1 -> 9 in the cache */
   /* search462_0 -> 1414 in the cache */
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { -0x1 /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1414, 1433 },
      -1,
   } },

   /* replace462_0 -> 6 in the cache */
   /* replace462_1 -> 845 in the cache */
   /* replace462 -> 1423 in the cache */

   /* ('ine', ('ishr', 'a@8', 7), -1) => ('ige', 'a', 0) */
   /* search463_0_0 -> 6 in the cache */
   /* search463_0_1 -> 9 in the cache */
   /* search463_0 -> 1414 in the cache */
   /* search463_1 -> 1433 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1414, 1433 },
      -1,
   } },

   /* replace463_0 -> 6 in the cache */
   /* replace463_1 -> 845 in the cache */
   /* replace463 -> 1420 in the cache */

   /* ('iand@16', 'a', ('inot', ('ishr', 'a', 15))) => ('imax', 'a', 0) */
   /* search464_0 -> 11 in the cache */
   /* search464_1_0_0 -> 11 in the cache */
   /* search464_1_0_1 -> 14 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 11, 14 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1436 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 11, 1437 },
      -1,
   } },

   /* replace464_0 -> 11 in the cache */
   /* replace464_1 -> 866 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 11, 866 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@16', 32768), 0) => ('ige', 'a', 0) */
   /* search465_0_0 -> 11 in the cache */
   /* search465_0_1 -> 12 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 11, 12 },
      -1,
   } },
   /* search465_1 -> 866 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1440, 866 },
      -1,
   } },

   /* replace465_0 -> 11 in the cache */
   /* replace465_1 -> 866 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 11, 866 },
      -1,
   } },

   /* ('ine', ('iand', 'a@16', 32768), 32768) => ('ige', 'a', 0) */
   /* search466_0_0 -> 11 in the cache */
   /* search466_0_1 -> 12 in the cache */
   /* search466_0 -> 1440 in the cache */
   /* search466_1 -> 12 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1440, 12 },
      -1,
   } },

   /* replace466_0 -> 11 in the cache */
   /* replace466_1 -> 866 in the cache */
   /* replace466 -> 1442 in the cache */

   /* ('ine', ('iand', 'a@16', 32768), 0) => ('ilt', 'a', 0) */
   /* search467_0_0 -> 11 in the cache */
   /* search467_0_1 -> 12 in the cache */
   /* search467_0 -> 1440 in the cache */
   /* search467_1 -> 866 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1440, 866 },
      -1,
   } },

   /* replace467_0 -> 11 in the cache */
   /* replace467_1 -> 866 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 11, 866 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@16', 32768), 32768) => ('ilt', 'a', 0) */
   /* search468_0_0 -> 11 in the cache */
   /* search468_0_1 -> 12 in the cache */
   /* search468_0 -> 1440 in the cache */
   /* search468_1 -> 12 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1440, 12 },
      -1,
   } },

   /* replace468_0 -> 11 in the cache */
   /* replace468_1 -> 866 in the cache */
   /* replace468 -> 1445 in the cache */

   /* ('ine', ('ushr', 'a@16', 15), 0) => ('ilt', 'a', 0) */
   /* search469_0_0 -> 11 in the cache */
   /* search469_0_1 -> 14 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 11, 14 },
      -1,
   } },
   /* search469_1 -> 866 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1447, 866 },
      -1,
   } },

   /* replace469_0 -> 11 in the cache */
   /* replace469_1 -> 866 in the cache */
   /* replace469 -> 1445 in the cache */

   /* ('ieq', ('ushr', 'a@16', 15), 0) => ('ige', 'a', 0) */
   /* search470_0_0 -> 11 in the cache */
   /* search470_0_1 -> 14 in the cache */
   /* search470_0 -> 1447 in the cache */
   /* search470_1 -> 866 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1447, 866 },
      -1,
   } },

   /* replace470_0 -> 11 in the cache */
   /* replace470_1 -> 866 in the cache */
   /* replace470 -> 1442 in the cache */

   /* ('ieq', ('ushr', 'a@16', 15), 1) => ('ilt', 'a', 0) */
   /* search471_0_0 -> 11 in the cache */
   /* search471_0_1 -> 14 in the cache */
   /* search471_0 -> 1447 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0x1 /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1447, 1450 },
      -1,
   } },

   /* replace471_0 -> 11 in the cache */
   /* replace471_1 -> 866 in the cache */
   /* replace471 -> 1445 in the cache */

   /* ('ine', ('ushr', 'a@16', 15), 1) => ('ige', 'a', 0) */
   /* search472_0_0 -> 11 in the cache */
   /* search472_0_1 -> 14 in the cache */
   /* search472_0 -> 1447 in the cache */
   /* search472_1 -> 1450 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1447, 1450 },
      -1,
   } },

   /* replace472_0 -> 11 in the cache */
   /* replace472_1 -> 866 in the cache */
   /* replace472 -> 1442 in the cache */

   /* ('ine', ('ishr', 'a@16', 15), 0) => ('ilt', 'a', 0) */
   /* search473_0_0 -> 11 in the cache */
   /* search473_0_1 -> 14 in the cache */
   /* search473_0 -> 1436 in the cache */
   /* search473_1 -> 866 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1436, 866 },
      -1,
   } },

   /* replace473_0 -> 11 in the cache */
   /* replace473_1 -> 866 in the cache */
   /* replace473 -> 1445 in the cache */

   /* ('ieq', ('ishr', 'a@16', 15), 0) => ('ige', 'a', 0) */
   /* search474_0_0 -> 11 in the cache */
   /* search474_0_1 -> 14 in the cache */
   /* search474_0 -> 1436 in the cache */
   /* search474_1 -> 866 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1436, 866 },
      -1,
   } },

   /* replace474_0 -> 11 in the cache */
   /* replace474_1 -> 866 in the cache */
   /* replace474 -> 1442 in the cache */

   /* ('ieq', ('ishr', 'a@16', 15), -1) => ('ilt', 'a', 0) */
   /* search475_0_0 -> 11 in the cache */
   /* search475_0_1 -> 14 in the cache */
   /* search475_0 -> 1436 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { -0x1 /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1436, 1455 },
      -1,
   } },

   /* replace475_0 -> 11 in the cache */
   /* replace475_1 -> 866 in the cache */
   /* replace475 -> 1445 in the cache */

   /* ('ine', ('ishr', 'a@16', 15), -1) => ('ige', 'a', 0) */
   /* search476_0_0 -> 11 in the cache */
   /* search476_0_1 -> 14 in the cache */
   /* search476_0 -> 1436 in the cache */
   /* search476_1 -> 1455 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1436, 1455 },
      -1,
   } },

   /* replace476_0 -> 11 in the cache */
   /* replace476_1 -> 866 in the cache */
   /* replace476 -> 1442 in the cache */

   /* ('iand@32', 'a', ('inot', ('ishr', 'a', 31))) => ('imax', 'a', 0) */
   /* search477_0 -> 16 in the cache */
   /* search477_1_0_0 -> 16 in the cache */
   /* search477_1_0_1 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 16, 19 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1458 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 16, 1459 },
      -1,
   } },

   /* replace477_0 -> 16 in the cache */
   /* replace477_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 16, 128 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@32', 2147483648), 0) => ('ige', 'a', 0) */
   /* search478_0_0 -> 16 in the cache */
   /* search478_0_1 -> 17 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 16, 17 },
      -1,
   } },
   /* search478_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1462, 128 },
      -1,
   } },

   /* replace478_0 -> 16 in the cache */
   /* replace478_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 16, 128 },
      -1,
   } },

   /* ('ine', ('iand', 'a@32', 2147483648), 2147483648) => ('ige', 'a', 0) */
   /* search479_0_0 -> 16 in the cache */
   /* search479_0_1 -> 17 in the cache */
   /* search479_0 -> 1462 in the cache */
   /* search479_1 -> 17 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1462, 17 },
      -1,
   } },

   /* replace479_0 -> 16 in the cache */
   /* replace479_1 -> 128 in the cache */
   /* replace479 -> 1464 in the cache */

   /* ('ine', ('iand', 'a@32', 2147483648), 0) => ('ilt', 'a', 0) */
   /* search480_0_0 -> 16 in the cache */
   /* search480_0_1 -> 17 in the cache */
   /* search480_0 -> 1462 in the cache */
   /* search480_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1462, 128 },
      -1,
   } },

   /* replace480_0 -> 16 in the cache */
   /* replace480_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 16, 128 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@32', 2147483648), 2147483648) => ('ilt', 'a', 0) */
   /* search481_0_0 -> 16 in the cache */
   /* search481_0_1 -> 17 in the cache */
   /* search481_0 -> 1462 in the cache */
   /* search481_1 -> 17 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1462, 17 },
      -1,
   } },

   /* replace481_0 -> 16 in the cache */
   /* replace481_1 -> 128 in the cache */
   /* replace481 -> 1467 in the cache */

   /* ('ine', ('ushr', 'a@32', 31), 0) => ('ilt', 'a', 0) */
   /* search482_0_0 -> 16 in the cache */
   /* search482_0_1 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 16, 19 },
      -1,
   } },
   /* search482_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1469, 128 },
      -1,
   } },

   /* replace482_0 -> 16 in the cache */
   /* replace482_1 -> 128 in the cache */
   /* replace482 -> 1467 in the cache */

   /* ('ieq', ('ushr', 'a@32', 31), 0) => ('ige', 'a', 0) */
   /* search483_0_0 -> 16 in the cache */
   /* search483_0_1 -> 19 in the cache */
   /* search483_0 -> 1469 in the cache */
   /* search483_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1469, 128 },
      -1,
   } },

   /* replace483_0 -> 16 in the cache */
   /* replace483_1 -> 128 in the cache */
   /* replace483 -> 1464 in the cache */

   /* ('ieq', ('ushr', 'a@32', 31), 1) => ('ilt', 'a', 0) */
   /* search484_0_0 -> 16 in the cache */
   /* search484_0_1 -> 19 in the cache */
   /* search484_0 -> 1469 in the cache */
   /* search484_1 -> 406 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1469, 406 },
      -1,
   } },

   /* replace484_0 -> 16 in the cache */
   /* replace484_1 -> 128 in the cache */
   /* replace484 -> 1467 in the cache */

   /* ('ine', ('ushr', 'a@32', 31), 1) => ('ige', 'a', 0) */
   /* search485_0_0 -> 16 in the cache */
   /* search485_0_1 -> 19 in the cache */
   /* search485_0 -> 1469 in the cache */
   /* search485_1 -> 406 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1469, 406 },
      -1,
   } },

   /* replace485_0 -> 16 in the cache */
   /* replace485_1 -> 128 in the cache */
   /* replace485 -> 1464 in the cache */

   /* ('ine', ('ishr', 'a@32', 31), 0) => ('ilt', 'a', 0) */
   /* search486_0_0 -> 16 in the cache */
   /* search486_0_1 -> 19 in the cache */
   /* search486_0 -> 1458 in the cache */
   /* search486_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1458, 128 },
      -1,
   } },

   /* replace486_0 -> 16 in the cache */
   /* replace486_1 -> 128 in the cache */
   /* replace486 -> 1467 in the cache */

   /* ('ieq', ('ishr', 'a@32', 31), 0) => ('ige', 'a', 0) */
   /* search487_0_0 -> 16 in the cache */
   /* search487_0_1 -> 19 in the cache */
   /* search487_0 -> 1458 in the cache */
   /* search487_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1458, 128 },
      -1,
   } },

   /* replace487_0 -> 16 in the cache */
   /* replace487_1 -> 128 in the cache */
   /* replace487 -> 1464 in the cache */

   /* ('ieq', ('ishr', 'a@32', 31), -1) => ('ilt', 'a', 0) */
   /* search488_0_0 -> 16 in the cache */
   /* search488_0_1 -> 19 in the cache */
   /* search488_0 -> 1458 in the cache */
   /* search488_1 -> 130 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1458, 130 },
      -1,
   } },

   /* replace488_0 -> 16 in the cache */
   /* replace488_1 -> 128 in the cache */
   /* replace488 -> 1467 in the cache */

   /* ('ine', ('ishr', 'a@32', 31), -1) => ('ige', 'a', 0) */
   /* search489_0_0 -> 16 in the cache */
   /* search489_0_1 -> 19 in the cache */
   /* search489_0 -> 1458 in the cache */
   /* search489_1 -> 130 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1458, 130 },
      -1,
   } },

   /* replace489_0 -> 16 in the cache */
   /* replace489_1 -> 128 in the cache */
   /* replace489 -> 1464 in the cache */

   /* ('iand@64', 'a', ('inot', ('ishr', 'a', 63))) => ('imax', 'a', 0) */
   /* search490_0 -> 21 in the cache */
   /* search490_1_0_0 -> 21 in the cache */
   /* search490_1_0_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 21, 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1478 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 21, 1479 },
      -1,
   } },

   /* replace490_0 -> 21 in the cache */
   /* replace490_1 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 21, 907 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@64', 9223372036854775808), 0) => ('ige', 'a', 0) */
   /* search491_0_0 -> 21 in the cache */
   /* search491_0_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 21, 22 },
      -1,
   } },
   /* search491_1 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1482, 907 },
      -1,
   } },

   /* replace491_0 -> 21 in the cache */
   /* replace491_1 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 21, 907 },
      -1,
   } },

   /* ('ine', ('iand', 'a@64', 9223372036854775808), 9223372036854775808) => ('ige', 'a', 0) */
   /* search492_0_0 -> 21 in the cache */
   /* search492_0_1 -> 22 in the cache */
   /* search492_0 -> 1482 in the cache */
   /* search492_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1482, 22 },
      -1,
   } },

   /* replace492_0 -> 21 in the cache */
   /* replace492_1 -> 907 in the cache */
   /* replace492 -> 1484 in the cache */

   /* ('ine', ('iand', 'a@64', 9223372036854775808), 0) => ('ilt', 'a', 0) */
   /* search493_0_0 -> 21 in the cache */
   /* search493_0_1 -> 22 in the cache */
   /* search493_0 -> 1482 in the cache */
   /* search493_1 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1482, 907 },
      -1,
   } },

   /* replace493_0 -> 21 in the cache */
   /* replace493_1 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 21, 907 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@64', 9223372036854775808), 9223372036854775808) => ('ilt', 'a', 0) */
   /* search494_0_0 -> 21 in the cache */
   /* search494_0_1 -> 22 in the cache */
   /* search494_0 -> 1482 in the cache */
   /* search494_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1482, 22 },
      -1,
   } },

   /* replace494_0 -> 21 in the cache */
   /* replace494_1 -> 907 in the cache */
   /* replace494 -> 1487 in the cache */

   /* ('ine', ('ushr', 'a@64', 63), 0) => ('ilt', 'a', 0) */
   /* search495_0_0 -> 21 in the cache */
   /* search495_0_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 21, 24 },
      -1,
   } },
   /* search495_1 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1489, 907 },
      -1,
   } },

   /* replace495_0 -> 21 in the cache */
   /* replace495_1 -> 907 in the cache */
   /* replace495 -> 1487 in the cache */

   /* ('ieq', ('ushr', 'a@64', 63), 0) => ('ige', 'a', 0) */
   /* search496_0_0 -> 21 in the cache */
   /* search496_0_1 -> 24 in the cache */
   /* search496_0 -> 1489 in the cache */
   /* search496_1 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1489, 907 },
      -1,
   } },

   /* replace496_0 -> 21 in the cache */
   /* replace496_1 -> 907 in the cache */
   /* replace496 -> 1484 in the cache */

   /* ('ieq', ('ushr', 'a@64', 63), 1) => ('ilt', 'a', 0) */
   /* search497_0_0 -> 21 in the cache */
   /* search497_0_1 -> 24 in the cache */
   /* search497_0 -> 1489 in the cache */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0x1 /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1489, 1492 },
      -1,
   } },

   /* replace497_0 -> 21 in the cache */
   /* replace497_1 -> 907 in the cache */
   /* replace497 -> 1487 in the cache */

   /* ('ine', ('ushr', 'a@64', 63), 1) => ('ige', 'a', 0) */
   /* search498_0_0 -> 21 in the cache */
   /* search498_0_1 -> 24 in the cache */
   /* search498_0 -> 1489 in the cache */
   /* search498_1 -> 1492 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1489, 1492 },
      -1,
   } },

   /* replace498_0 -> 21 in the cache */
   /* replace498_1 -> 907 in the cache */
   /* replace498 -> 1484 in the cache */

   /* ('ine', ('ishr', 'a@64', 63), 0) => ('ilt', 'a', 0) */
   /* search499_0_0 -> 21 in the cache */
   /* search499_0_1 -> 24 in the cache */
   /* search499_0 -> 1478 in the cache */
   /* search499_1 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1478, 907 },
      -1,
   } },

   /* replace499_0 -> 21 in the cache */
   /* replace499_1 -> 907 in the cache */
   /* replace499 -> 1487 in the cache */

   /* ('ieq', ('ishr', 'a@64', 63), 0) => ('ige', 'a', 0) */
   /* search500_0_0 -> 21 in the cache */
   /* search500_0_1 -> 24 in the cache */
   /* search500_0 -> 1478 in the cache */
   /* search500_1 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1478, 907 },
      -1,
   } },

   /* replace500_0 -> 21 in the cache */
   /* replace500_1 -> 907 in the cache */
   /* replace500 -> 1484 in the cache */

   /* ('ieq', ('ishr', 'a@64', 63), -1) => ('ilt', 'a', 0) */
   /* search501_0_0 -> 21 in the cache */
   /* search501_0_1 -> 24 in the cache */
   /* search501_0 -> 1478 in the cache */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { -0x1 /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1478, 1497 },
      -1,
   } },

   /* replace501_0 -> 21 in the cache */
   /* replace501_1 -> 907 in the cache */
   /* replace501 -> 1487 in the cache */

   /* ('ine', ('ishr', 'a@64', 63), -1) => ('ige', 'a', 0) */
   /* search502_0_0 -> 21 in the cache */
   /* search502_0_1 -> 24 in the cache */
   /* search502_0 -> 1478 in the cache */
   /* search502_1 -> 1497 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1478, 1497 },
      -1,
   } },

   /* replace502_0 -> 21 in the cache */
   /* replace502_1 -> 907 in the cache */
   /* replace502 -> 1484 in the cache */

   /* ('fmin', 'a', ('fneg', 'a')) => ('fneg', ('fabs', 'a')) */
   /* search503_0 -> 32 in the cache */
   /* search503_1_0 -> 32 in the cache */
   /* search503_1 -> 107 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 32, 107 },
      -1,
   } },

   /* replace503_0_0 -> 32 in the cache */
   /* replace503_0 -> 99 in the cache */
   /* replace503 -> 1268 in the cache */

   /* ('imin', 'a', ('ineg', 'a')) => ('ineg', ('iabs', 'a')) */
   /* search504_0 -> 32 in the cache */
   /* search504_1_0 -> 32 in the cache */
   /* search504_1 -> 109 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 32, 109 },
      -1,
   } },

   /* replace504_0_0 -> 32 in the cache */
   /* replace504_0 -> 114 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 114 },
      -1,
   } },

   /* ('fmin', 'a', ('fneg', ('fabs', 'a'))) => ('fneg', ('fabs', 'a')) */
   /* search505_0 -> 32 in the cache */
   /* search505_1_0_0 -> 32 in the cache */
   /* search505_1_0 -> 99 in the cache */
   /* search505_1 -> 1268 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 32, 1268 },
      -1,
   } },

   /* replace505_0_0 -> 32 in the cache */
   /* replace505_0 -> 99 in the cache */
   /* replace505 -> 1268 in the cache */

   /* ('imin', 'a', ('ineg', ('iabs', 'a'))) => ('ineg', ('iabs', 'a')) */
   /* search506_0 -> 32 in the cache */
   /* search506_1_0_0 -> 32 in the cache */
   /* search506_1_0 -> 114 in the cache */
   /* search506_1 -> 1502 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 32, 1502 },
      -1,
   } },

   /* replace506_0_0 -> 32 in the cache */
   /* replace506_0 -> 114 in the cache */
   /* replace506 -> 1502 in the cache */

   /* ('~fmin', 'a', ('fabs', 'a')) => a */
   /* search507_0 -> 32 in the cache */
   /* search507_1_0 -> 32 in the cache */
   /* search507_1 -> 99 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 32, 99 },
      -1,
   } },

   /* replace507 -> 32 in the cache */

   /* ('imin', 'a', ('iabs', 'a')) => a */
   /* search508_0 -> 32 in the cache */
   /* search508_1_0 -> 32 in the cache */
   /* search508_1 -> 114 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 32, 114 },
      -1,
   } },

   /* replace508 -> 32 in the cache */

   /* ('~fmax', 'a', ('fneg', ('fabs', 'a'))) => a */
   /* search509_0 -> 32 in the cache */
   /* search509_1_0_0 -> 32 in the cache */
   /* search509_1_0 -> 99 in the cache */
   /* search509_1 -> 1268 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 32, 1268 },
      -1,
   } },

   /* replace509 -> 32 in the cache */

   /* ('imax', 'a', ('ineg', ('iabs', 'a'))) => a */
   /* search510_0 -> 32 in the cache */
   /* search510_1_0_0 -> 32 in the cache */
   /* search510_1_0 -> 114 in the cache */
   /* search510_1 -> 1502 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 32, 1502 },
      -1,
   } },

   /* replace510 -> 32 in the cache */

   /* ('fmax', 'a', ('fabs', 'a')) => ('fabs', 'a') */
   /* search511_0 -> 32 in the cache */
   /* search511_1_0 -> 32 in the cache */
   /* search511_1 -> 99 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 32, 99 },
      -1,
   } },

   /* replace511_0 -> 32 in the cache */
   /* replace511 -> 99 in the cache */

   /* ('imax', 'a', ('iabs', 'a')) => ('iabs', 'a') */
   /* search512_0 -> 32 in the cache */
   /* search512_1_0 -> 32 in the cache */
   /* search512_1 -> 114 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 32, 114 },
      -1,
   } },

   /* replace512_0 -> 32 in the cache */
   /* replace512 -> 114 in the cache */

   /* ('fmax', 'a', ('fneg', 'a')) => ('fabs', 'a') */
   /* search513_0 -> 32 in the cache */
   /* search513_1_0 -> 32 in the cache */
   /* search513_1 -> 107 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 32, 107 },
      -1,
   } },

   /* replace513_0 -> 32 in the cache */
   /* replace513 -> 99 in the cache */

   /* ('imax', 'a', ('ineg', 'a')) => ('iabs', 'a') */
   /* search514_0 -> 32 in the cache */
   /* search514_1_0 -> 32 in the cache */
   /* search514_1 -> 109 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 32, 109 },
      -1,
   } },

   /* replace514_0 -> 32 in the cache */
   /* replace514 -> 114 in the cache */

   /* ('~fmax', ('fabs', 'a'), 0.0) => ('fabs', 'a') */
   /* search515_0_0 -> 32 in the cache */
   /* search515_0 -> 99 in the cache */
   /* search515_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 99, 117 },
      -1,
   } },

   /* replace515_0 -> 32 in the cache */
   /* replace515 -> 99 in the cache */

   /* ('fmin', ('fmax', 'a', 0.0), 1.0) => ('fsat', 'a') */
   /* search516_0_0 -> 32 in the cache */
   /* search516_0_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmax,
      1, 1,
      { 32, 117 },
      -1,
   } },
   /* search516_1 -> 252 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1514, 252 },
      -1,
   } },

   /* replace516_0 -> 32 in the cache */
   /* replace516 -> 228 in the cache */

   /* ('~fmax', ('fmin', 'a', 1.0), 0.0) => ('fsat', 'a') */
   /* search517_0_0 -> 32 in the cache */
   /* search517_0_1 -> 252 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 32, 252 },
      -1,
   } },
   /* search517_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1516, 117 },
      -1,
   } },

   /* replace517_0 -> 32 in the cache */
   /* replace517 -> 228 in the cache */

   /* ('~fmin', ('fmax', 'a', -1.0), 0.0) => ('fneg', ('fsat', ('fneg', 'a'))) */
   /* search518_0_0 -> 32 in the cache */
   /* search518_0_1 -> 258 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmax,
      1, 1,
      { 32, 258 },
      -1,
   } },
   /* search518_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1518, 117 },
      -1,
   } },

   /* replace518_0_0_0 -> 32 in the cache */
   /* replace518_0_0 -> 107 in the cache */
   /* replace518_0 -> 229 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 229 },
      -1,
   } },

   /* ('~fmax', ('fmin', 'a', 0.0), -1.0) => ('fneg', ('fsat', ('fneg', 'a'))) */
   /* search519_0_0 -> 32 in the cache */
   /* search519_0_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 32, 117 },
      -1,
   } },
   /* search519_1 -> 258 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1521, 258 },
      -1,
   } },

   /* replace519_0_0_0 -> 32 in the cache */
   /* replace519_0_0 -> 107 in the cache */
   /* replace519_0 -> 229 in the cache */
   /* replace519 -> 1520 in the cache */

   /* ('fsat', ('fsign', 'a')) => ('b2f', ('!flt', 0.0, 'a')) */
   /* search520_0_0 -> 32 in the cache */
   /* search520_0 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 98 },
      -1,
   } },

   /* replace520_0_0 -> 117 in the cache */
   /* replace520_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      nir_op_flt,
      -1, 0,
      { 117, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1524 },
      -1,
   } },

   /* ('fsat', ('b2f', 'a')) => ('b2f', 'a') */
   /* search521_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 1526 },
      -1,
   } },

   /* replace521_0 -> 32 in the cache */
   /* replace521 -> 1526 in the cache */

   /* ('fsat', 'a') => ('fmin', ('fmax', 'a', 0.0), 1.0) */
   /* search522_0 -> 32 in the cache */
   /* search522 -> 228 in the cache */

   /* replace522_0_0 -> 32 in the cache */
   /* replace522_0_1 -> 117 in the cache */
   /* replace522_0 -> 1514 in the cache */
   /* replace522_1 -> 252 in the cache */
   /* replace522 -> 1515 in the cache */

   /* ('fsat', ('fsat', 'a')) => ('fsat', 'a') */
   /* search523_0_0 -> 32 in the cache */
   /* search523_0 -> 228 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 228 },
      -1,
   } },

   /* replace523_0 -> 32 in the cache */
   /* replace523 -> 228 in the cache */

   /* ('fsat', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', 'b'))) => ('fsat', ('fadd', ('fneg', 'a'), ('fneg', 'b'))) */
   /* search524_0_0_0 -> 0 in the cache */
   /* search524_0_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1529 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1530 },
      -1,
   } },

   /* replace524_0_0_0 -> 0 in the cache */
   /* replace524_0_0 -> 223 in the cache */
   /* replace524_0_1_0 -> 3 in the cache */
   /* replace524_0_1 -> 1097 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 223, 1097 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1532 },
      -1,
   } },

   /* ('fsat', ('fneg(is_used_once)', ('fmul(is_used_once)', 'a', 'b'))) => ('fsat', ('fmul', ('fneg', 'a'), 'b')) */
   /* search525_0_0_0 -> 0 in the cache */
   /* search525_0_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1534 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1535 },
      -1,
   } },

   /* replace525_0_0_0 -> 0 in the cache */
   /* replace525_0_0 -> 223 in the cache */
   /* replace525_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 223, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1537 },
      -1,
   } },

   /* ('fsat', ('fneg(is_used_once)', ('fmulz(is_used_once)', 'a', 'b'))) => ('fsat', ('fmulz', ('fneg', 'a'), 'b')) */
   /* search526_0_0_0 -> 16 in the cache */
   /* search526_0_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 16, 36 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1539 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1540 },
      -1,
   } },

   /* replace526_0_0_0 -> 16 in the cache */
   /* replace526_0_0 -> 290 in the cache */
   /* replace526_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 290, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1542 },
      -1,
   } },

   /* ('fsat', ('fabs(is_used_once)', ('fmul(is_used_once)', 'a', 'b'))) => ('fsat', ('fmul', ('fabs', 'a'), ('fabs', 'b'))) */
   /* search527_0_0_0 -> 0 in the cache */
   /* search527_0_0_1 -> 3 in the cache */
   /* search527_0_0 -> 1534 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 1,
      { 1534 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1544 },
      -1,
   } },

   /* replace527_0_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 0 },
      -1,
   } },
   /* replace527_0_1_0 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 1546, 1547 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1548 },
      -1,
   } },

   /* ('fmin', ('fmax', ('fmin', ('fmax', 'a', 'b'), 'c'), 'b'), 'c') => ('fmin', ('fmax', 'a', 'b'), 'c') */
   /* search528_0_0_0_0 -> 132 in the cache */
   /* search528_0_0_0_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmax,
      3, 1,
      { 132, 133 },
      -1,
   } },
   /* search528_0_0_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      2, 2,
      { 1550, 135 },
      -1,
   } },
   /* search528_0_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmax,
      1, 3,
      { 1551, 133 },
      -1,
   } },
   /* search528_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 4,
      { 1552, 135 },
      -1,
   } },

   /* replace528_0_0 -> 132 in the cache */
   /* replace528_0_1 -> 133 in the cache */
   /* replace528_0 -> 1358 in the cache */
   /* replace528_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1358, 135 },
      -1,
   } },

   /* ('imin', ('imax', ('imin', ('imax', 'a', 'b'), 'c'), 'b'), 'c') => ('imin', ('imax', 'a', 'b'), 'c') */
   /* search529_0_0_0_0 -> 132 in the cache */
   /* search529_0_0_0_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      3, 1,
      { 132, 133 },
      -1,
   } },
   /* search529_0_0_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      2, 2,
      { 1555, 135 },
      -1,
   } },
   /* search529_0_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      1, 3,
      { 1556, 133 },
      -1,
   } },
   /* search529_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      0, 4,
      { 1557, 135 },
      -1,
   } },

   /* replace529_0_0 -> 132 in the cache */
   /* replace529_0_1 -> 133 in the cache */
   /* replace529_0 -> 1368 in the cache */
   /* replace529_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      0, 2,
      { 1368, 135 },
      -1,
   } },

   /* ('umin', ('umax', ('umin', ('umax', 'a', 'b'), 'c'), 'b'), 'c') => ('umin', ('umax', 'a', 'b'), 'c') */
   /* search530_0_0_0_0 -> 132 in the cache */
   /* search530_0_0_0_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      3, 1,
      { 132, 133 },
      -1,
   } },
   /* search530_0_0_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      2, 2,
      { 1560, 135 },
      -1,
   } },
   /* search530_0_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      1, 3,
      { 1561, 133 },
      -1,
   } },
   /* search530_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      0, 4,
      { 1562, 135 },
      -1,
   } },

   /* replace530_0_0 -> 132 in the cache */
   /* replace530_0_1 -> 133 in the cache */
   /* replace530_0 -> 1363 in the cache */
   /* replace530_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      0, 2,
      { 1363, 135 },
      -1,
   } },

   /* ('fmax', ('fsat', 'a'), '#b(is_zero_to_one)') => ('fsat', ('fmax', 'a', 'b')) */
   /* search531_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 0 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      18,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 1565, 1566 },
      -1,
   } },

   /* replace531_0_0 -> 0 in the cache */
   /* replace531_0_1 -> 3 in the cache */
   /* replace531_0 -> 1295 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1295 },
      -1,
   } },

   /* ('fmax', ('fsat(is_used_once)', 'a'), ('fsat(is_used_once)', 'b')) => ('fsat', ('fmax', 'a', 'b')) */
   /* search532_0_0 -> 0 in the cache */
   /* search532_0 -> 1129 in the cache */
   /* search532_1_0 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 1129, 1569 },
      -1,
   } },

   /* replace532_0_0 -> 0 in the cache */
   /* replace532_0_1 -> 3 in the cache */
   /* replace532_0 -> 1295 in the cache */
   /* replace532 -> 1568 in the cache */

   /* ('~fmin', ('fsat', 'a'), '#b(is_zero_to_one)') => ('fsat', ('fmin', 'a', 'b')) */
   /* search533_0_0 -> 0 in the cache */
   /* search533_0 -> 1565 in the cache */
   /* search533_1 -> 1566 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1565, 1566 },
      -1,
   } },

   /* replace533_0_0 -> 0 in the cache */
   /* replace533_0_1 -> 3 in the cache */
   /* replace533_0 -> 1297 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1297 },
      -1,
   } },

   /* ('fmax', ('fneg', ('fmin', 'b', 'a')), 'b') => ('fmax', ('fabs', 'b'), ('fneg', 'a')) */
   /* search534_0_0_0 -> 1127 in the cache */
   /* search534_0_0_1 -> 1124 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 1127, 1124 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1573 },
      -1,
   } },
   /* search534_1 -> 1127 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1574, 1127 },
      -1,
   } },

   /* replace534_0_0 -> 1127 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 1127 },
      -1,
   } },
   /* replace534_1_0 -> 1124 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1124 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 1576, 1577 },
      -1,
   } },

   /* ('fmin', ('fneg', ('fmax', 'b', 'a')), 'b') => ('fmin', ('fneg', ('fabs', 'b')), ('fneg', 'a')) */
   /* search535_0_0_0 -> 1127 in the cache */
   /* search535_0_0_1 -> 1124 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      1, 1,
      { 1127, 1124 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1579 },
      -1,
   } },
   /* search535_1 -> 1127 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1580, 1127 },
      -1,
   } },

   /* replace535_0_0_0 -> 1127 in the cache */
   /* replace535_0_0 -> 1576 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1576 },
      -1,
   } },
   /* replace535_1_0 -> 1124 in the cache */
   /* replace535_1 -> 1577 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1582, 1577 },
      -1,
   } },

   /* ('fmax', ('fadd(is_used_once)', ('fneg', 'a(is_not_negative)'), '#b(is_zero_to_one)'), 0.0) => ('fsat', ('fadd', ('fneg', 'a'), 'b')) */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      19,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1584 },
      -1,
   } },
   /* search536_0_1 -> 1566 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 1585, 1566 },
      0,
   } },
   /* search536_1 -> 266 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1586, 266 },
      -1,
   } },

   /* replace536_0_0_0 -> 0 in the cache */
   /* replace536_0_0 -> 223 in the cache */
   /* replace536_0_1 -> 3 in the cache */
   /* replace536_0 -> 287 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 287 },
      -1,
   } },

   /* ('extract_u8', ('imin', ('imax', 'a', 0), 255), 0) => ('imin', ('imax', 'a', 0), 255) */
   /* search537_0_0_0 -> 32 in the cache */
   /* search537_0_0_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imax,
      1, 1,
      { 32, 61 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0xff /* 255 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imin,
      0, 2,
      { 1589, 1590 },
      -1,
   } },
   /* search537_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 2,
      { 1591, 61 },
      -1,
   } },

   /* replace537_0_0 -> 32 in the cache */
   /* replace537_0_1 -> 61 in the cache */
   /* replace537_0 -> 1589 in the cache */
   /* replace537_1 -> 1590 in the cache */
   /* replace537 -> 1591 in the cache */

   /* ('ior', ('flt(is_used_once)', 'a', 'b'), ('flt', 'a', 'c')) => ('flt', 'a', ('!fmax', 'b', 'c')) */
   /* search538_0_0 -> 132 in the cache */
   /* search538_0_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 132, 133 },
      0,
   } },
   /* search538_1_0 -> 132 in the cache */
   /* search538_1_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 132, 135 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1593, 1594 },
      -1,
   } },

   /* replace538_0 -> 132 in the cache */
   /* replace538_1_0 -> 133 in the cache */
   /* replace538_1_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      true,
      false,
      nir_op_fmax,
      0, 1,
      { 133, 135 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 132, 1596 },
      -1,
   } },

   /* ('ior', ('flt(is_used_once)', 'a', 'c'), ('flt', 'b', 'c')) => ('flt', ('!fmin', 'a', 'b'), 'c') */
   /* search539_0_0 -> 0 in the cache */
   /* search539_0_1 -> 691 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 0, 691 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search539_1_1 -> 691 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1599, 691 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1598, 1600 },
      -1,
   } },

   /* replace539_0_0 -> 0 in the cache */
   /* replace539_0_1 -> 1599 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      true,
      false,
      nir_op_fmin,
      0, 1,
      { 0, 1599 },
      -1,
   } },
   /* replace539_1 -> 691 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1602, 691 },
      -1,
   } },

   /* ('ior', ('fge(is_used_once)', 'a', 'b'), ('fge', 'a', 'c')) => ('fge', 'a', ('!fmin', 'b', 'c')) */
   /* search540_0_0 -> 132 in the cache */
   /* search540_0_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 132, 133 },
      0,
   } },
   /* search540_1_0 -> 132 in the cache */
   /* search540_1_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 132, 135 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1604, 1605 },
      -1,
   } },

   /* replace540_0 -> 132 in the cache */
   /* replace540_1_0 -> 133 in the cache */
   /* replace540_1_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      true,
      false,
      nir_op_fmin,
      0, 1,
      { 133, 135 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 132, 1607 },
      -1,
   } },

   /* ('ior', ('fge(is_used_once)', 'a', 'c'), ('fge', 'b', 'c')) => ('fge', ('!fmax', 'a', 'b'), 'c') */
   /* search541_0_0 -> 0 in the cache */
   /* search541_0_1 -> 691 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 0, 691 },
      0,
   } },
   /* search541_1_0 -> 1599 in the cache */
   /* search541_1_1 -> 691 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1599, 691 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1609, 1610 },
      -1,
   } },

   /* replace541_0_0 -> 0 in the cache */
   /* replace541_0_1 -> 1599 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      true,
      false,
      nir_op_fmax,
      0, 1,
      { 0, 1599 },
      -1,
   } },
   /* replace541_1 -> 691 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1612, 691 },
      -1,
   } },

   /* ('ior', ('flt', 'a', '#b'), ('flt', 'a', '#c')) => ('flt', 'a', ('!fmax', 'b', 'c')) */
   /* search542_0_0 -> 132 in the cache */
   /* search542_0_1 -> 293 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 132, 293 },
      -1,
   } },
   /* search542_1_0 -> 132 in the cache */
   /* search542_1_1 -> 824 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 132, 824 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1614, 1615 },
      -1,
   } },

   /* replace542_0 -> 132 in the cache */
   /* replace542_1_0 -> 133 in the cache */
   /* replace542_1_1 -> 135 in the cache */
   /* replace542_1 -> 1596 in the cache */
   /* replace542 -> 1597 in the cache */

   /* ('ior', ('flt', '#a', 'c'), ('flt', '#b', 'c')) => ('flt', ('!fmin', 'a', 'b'), 'c') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search543_0_1 -> 691 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1617, 691 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      2, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search543_1_1 -> 691 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1619, 691 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1618, 1620 },
      -1,
   } },

   /* replace543_0_0 -> 0 in the cache */
   /* replace543_0_1 -> 1599 in the cache */
   /* replace543_0 -> 1602 in the cache */
   /* replace543_1 -> 691 in the cache */
   /* replace543 -> 1603 in the cache */

   /* ('ior', ('fge', 'a', '#b'), ('fge', 'a', '#c')) => ('fge', 'a', ('!fmin', 'b', 'c')) */
   /* search544_0_0 -> 132 in the cache */
   /* search544_0_1 -> 293 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 132, 293 },
      -1,
   } },
   /* search544_1_0 -> 132 in the cache */
   /* search544_1_1 -> 824 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 132, 824 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1622, 1623 },
      -1,
   } },

   /* replace544_0 -> 132 in the cache */
   /* replace544_1_0 -> 133 in the cache */
   /* replace544_1_1 -> 135 in the cache */
   /* replace544_1 -> 1607 in the cache */
   /* replace544 -> 1608 in the cache */

   /* ('ior', ('fge', '#a', 'c'), ('fge', '#b', 'c')) => ('fge', ('!fmax', 'a', 'b'), 'c') */
   /* search545_0_0 -> 1617 in the cache */
   /* search545_0_1 -> 691 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1617, 691 },
      -1,
   } },
   /* search545_1_0 -> 1619 in the cache */
   /* search545_1_1 -> 691 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1619, 691 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1625, 1626 },
      -1,
   } },

   /* replace545_0_0 -> 0 in the cache */
   /* replace545_0_1 -> 1599 in the cache */
   /* replace545_0 -> 1612 in the cache */
   /* replace545_1 -> 691 in the cache */
   /* replace545 -> 1613 in the cache */

   /* ('~iand', ('flt(is_used_once)', 'a', 'b'), ('flt', 'a', 'c')) => ('flt', 'a', ('fmin', 'b', 'c')) */
   /* search546_0_0 -> 132 in the cache */
   /* search546_0_1 -> 133 in the cache */
   /* search546_0 -> 1593 in the cache */
   /* search546_1_0 -> 132 in the cache */
   /* search546_1_1 -> 135 in the cache */
   /* search546_1 -> 1594 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1593, 1594 },
      -1,
   } },

   /* replace546_0 -> 132 in the cache */
   /* replace546_1_0 -> 133 in the cache */
   /* replace546_1_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 133, 135 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 132, 1629 },
      -1,
   } },

   /* ('~iand', ('flt(is_used_once)', 'a', 'c'), ('flt', 'b', 'c')) => ('flt', ('fmax', 'a', 'b'), 'c') */
   /* search547_0_0 -> 0 in the cache */
   /* search547_0_1 -> 691 in the cache */
   /* search547_0 -> 1598 in the cache */
   /* search547_1_0 -> 1599 in the cache */
   /* search547_1_1 -> 691 in the cache */
   /* search547_1 -> 1600 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1598, 1600 },
      -1,
   } },

   /* replace547_0_0 -> 0 in the cache */
   /* replace547_0_1 -> 1599 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 0, 1599 },
      -1,
   } },
   /* replace547_1 -> 691 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1632, 691 },
      -1,
   } },

   /* ('~iand', ('fge(is_used_once)', 'a', 'b'), ('fge', 'a', 'c')) => ('fge', 'a', ('fmax', 'b', 'c')) */
   /* search548_0_0 -> 132 in the cache */
   /* search548_0_1 -> 133 in the cache */
   /* search548_0 -> 1604 in the cache */
   /* search548_1_0 -> 132 in the cache */
   /* search548_1_1 -> 135 in the cache */
   /* search548_1 -> 1605 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1604, 1605 },
      -1,
   } },

   /* replace548_0 -> 132 in the cache */
   /* replace548_1_0 -> 133 in the cache */
   /* replace548_1_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 133, 135 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 132, 1635 },
      -1,
   } },

   /* ('~iand', ('fge(is_used_once)', 'a', 'c'), ('fge', 'b', 'c')) => ('fge', ('fmin', 'a', 'b'), 'c') */
   /* search549_0_0 -> 0 in the cache */
   /* search549_0_1 -> 691 in the cache */
   /* search549_0 -> 1609 in the cache */
   /* search549_1_0 -> 1599 in the cache */
   /* search549_1_1 -> 691 in the cache */
   /* search549_1 -> 1610 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1609, 1610 },
      -1,
   } },

   /* replace549_0_0 -> 0 in the cache */
   /* replace549_0_1 -> 1599 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 0, 1599 },
      -1,
   } },
   /* replace549_1 -> 691 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1638, 691 },
      -1,
   } },

   /* ('iand', ('flt', 'a', '#b(is_a_number)'), ('flt', 'a', '#c(is_a_number)')) => ('flt', 'a', ('fmin', 'b', 'c')) */
   /* search550_0_0 -> 132 in the cache */
   { .variable = {
      { nir_search_value_variable, -3 },
      1, /* b */
      true,
      nir_type_invalid,
      16,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 132, 1640 },
      -1,
   } },
   /* search550_1_0 -> 132 in the cache */
   { .variable = {
      { nir_search_value_variable, -3 },
      2, /* c */
      true,
      nir_type_invalid,
      16,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 132, 1642 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1641, 1643 },
      -1,
   } },

   /* replace550_0 -> 132 in the cache */
   /* replace550_1_0 -> 133 in the cache */
   /* replace550_1_1 -> 135 in the cache */
   /* replace550_1 -> 1629 in the cache */
   /* replace550 -> 1630 in the cache */

   /* ('iand', ('flt', '#a(is_a_number)', 'c'), ('flt', '#b(is_a_number)', 'c')) => ('flt', ('fmax', 'a', 'b'), 'c') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      true,
      nir_type_invalid,
      16,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search551_0_1 -> 691 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1645, 691 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      2, /* b */
      true,
      nir_type_invalid,
      16,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search551_1_1 -> 691 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1647, 691 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1646, 1648 },
      -1,
   } },

   /* replace551_0_0 -> 0 in the cache */
   /* replace551_0_1 -> 1599 in the cache */
   /* replace551_0 -> 1632 in the cache */
   /* replace551_1 -> 691 in the cache */
   /* replace551 -> 1633 in the cache */

   /* ('iand', ('fge', 'a', '#b(is_a_number)'), ('fge', 'a', '#c(is_a_number)')) => ('fge', 'a', ('fmax', 'b', 'c')) */
   /* search552_0_0 -> 132 in the cache */
   /* search552_0_1 -> 1640 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 132, 1640 },
      -1,
   } },
   /* search552_1_0 -> 132 in the cache */
   /* search552_1_1 -> 1642 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 132, 1642 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1650, 1651 },
      -1,
   } },

   /* replace552_0 -> 132 in the cache */
   /* replace552_1_0 -> 133 in the cache */
   /* replace552_1_1 -> 135 in the cache */
   /* replace552_1 -> 1635 in the cache */
   /* replace552 -> 1636 in the cache */

   /* ('iand', ('fge', '#a(is_a_number)', 'c'), ('fge', '#b(is_a_number)', 'c')) => ('fge', ('fmin', 'a', 'b'), 'c') */
   /* search553_0_0 -> 1645 in the cache */
   /* search553_0_1 -> 691 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1645, 691 },
      -1,
   } },
   /* search553_1_0 -> 1647 in the cache */
   /* search553_1_1 -> 691 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1647, 691 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1653, 1654 },
      -1,
   } },

   /* replace553_0_0 -> 0 in the cache */
   /* replace553_0_1 -> 1599 in the cache */
   /* replace553_0 -> 1638 in the cache */
   /* replace553_1 -> 691 in the cache */
   /* replace553 -> 1639 in the cache */

   /* ('ior', ('ilt(is_used_once)', 'a', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imax', 'b', 'c')) */
   /* search554_0_0 -> 132 in the cache */
   /* search554_0_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 132, 133 },
      0,
   } },
   /* search554_1_0 -> 132 in the cache */
   /* search554_1_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 132, 135 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1656, 1657 },
      -1,
   } },

   /* replace554_0 -> 132 in the cache */
   /* replace554_1_0 -> 133 in the cache */
   /* replace554_1_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 133, 135 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 132, 1659 },
      -1,
   } },

   /* ('ior', ('ilt(is_used_once)', 'a', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imin', 'a', 'b'), 'c') */
   /* search555_0_0 -> 0 in the cache */
   /* search555_0_1 -> 691 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 0, 691 },
      0,
   } },
   /* search555_1_0 -> 1599 in the cache */
   /* search555_1_1 -> 691 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 1599, 691 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1661, 1662 },
      -1,
   } },

   /* replace555_0_0 -> 0 in the cache */
   /* replace555_0_1 -> 1599 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 0, 1599 },
      -1,
   } },
   /* replace555_1 -> 691 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 1664, 691 },
      -1,
   } },

   /* ('ior', ('ige(is_used_once)', 'a', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imin', 'b', 'c')) */
   /* search556_0_0 -> 132 in the cache */
   /* search556_0_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 132, 133 },
      0,
   } },
   /* search556_1_0 -> 132 in the cache */
   /* search556_1_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 132, 135 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1666, 1667 },
      -1,
   } },

   /* replace556_0 -> 132 in the cache */
   /* replace556_1_0 -> 133 in the cache */
   /* replace556_1_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 133, 135 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 132, 1669 },
      -1,
   } },

   /* ('ior', ('ige(is_used_once)', 'a', 'c'), ('ige', 'b', 'c')) => ('ige', ('imax', 'a', 'b'), 'c') */
   /* search557_0_0 -> 0 in the cache */
   /* search557_0_1 -> 691 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 0, 691 },
      0,
   } },
   /* search557_1_0 -> 1599 in the cache */
   /* search557_1_1 -> 691 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 1599, 691 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1671, 1672 },
      -1,
   } },

   /* replace557_0_0 -> 0 in the cache */
   /* replace557_0_1 -> 1599 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 0, 1599 },
      -1,
   } },
   /* replace557_1 -> 691 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 1674, 691 },
      -1,
   } },

   /* ('ior', ('ult(is_used_once)', 'a', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umax', 'b', 'c')) */
   /* search558_0_0 -> 132 in the cache */
   /* search558_0_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 132, 133 },
      0,
   } },
   /* search558_1_0 -> 132 in the cache */
   /* search558_1_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 132, 135 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1676, 1677 },
      -1,
   } },

   /* replace558_0 -> 132 in the cache */
   /* replace558_1_0 -> 133 in the cache */
   /* replace558_1_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 133, 135 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 132, 1679 },
      -1,
   } },

   /* ('ior', ('ult(is_used_once)', 'a', 'c'), ('ult', 'b', 'c')) => ('ult', ('umin', 'a', 'b'), 'c') */
   /* search559_0_0 -> 0 in the cache */
   /* search559_0_1 -> 691 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 0, 691 },
      0,
   } },
   /* search559_1_0 -> 1599 in the cache */
   /* search559_1_1 -> 691 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 1599, 691 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1681, 1682 },
      -1,
   } },

   /* replace559_0_0 -> 0 in the cache */
   /* replace559_0_1 -> 1599 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 0, 1599 },
      -1,
   } },
   /* replace559_1 -> 691 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 1684, 691 },
      -1,
   } },

   /* ('ior', ('uge(is_used_once)', 'a', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umin', 'b', 'c')) */
   /* search560_0_0 -> 132 in the cache */
   /* search560_0_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 132, 133 },
      0,
   } },
   /* search560_1_0 -> 132 in the cache */
   /* search560_1_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 132, 135 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1686, 1687 },
      -1,
   } },

   /* replace560_0 -> 132 in the cache */
   /* replace560_1_0 -> 133 in the cache */
   /* replace560_1_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 133, 135 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 132, 1689 },
      -1,
   } },

   /* ('ior', ('uge(is_used_once)', 'a', 'c'), ('uge', 'b', 'c')) => ('uge', ('umax', 'a', 'b'), 'c') */
   /* search561_0_0 -> 0 in the cache */
   /* search561_0_1 -> 691 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 0, 691 },
      0,
   } },
   /* search561_1_0 -> 1599 in the cache */
   /* search561_1_1 -> 691 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 1599, 691 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1691, 1692 },
      -1,
   } },

   /* replace561_0_0 -> 0 in the cache */
   /* replace561_0_1 -> 1599 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 0, 1599 },
      -1,
   } },
   /* replace561_1 -> 691 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 1694, 691 },
      -1,
   } },

   /* ('iand', ('ilt(is_used_once)', 'a', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imin', 'b', 'c')) */
   /* search562_0_0 -> 132 in the cache */
   /* search562_0_1 -> 133 in the cache */
   /* search562_0 -> 1656 in the cache */
   /* search562_1_0 -> 132 in the cache */
   /* search562_1_1 -> 135 in the cache */
   /* search562_1 -> 1657 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1656, 1657 },
      -1,
   } },

   /* replace562_0 -> 132 in the cache */
   /* replace562_1_0 -> 133 in the cache */
   /* replace562_1_1 -> 135 in the cache */
   /* replace562_1 -> 1669 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 132, 1669 },
      -1,
   } },

   /* ('iand', ('ilt(is_used_once)', 'a', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imax', 'a', 'b'), 'c') */
   /* search563_0_0 -> 0 in the cache */
   /* search563_0_1 -> 691 in the cache */
   /* search563_0 -> 1661 in the cache */
   /* search563_1_0 -> 1599 in the cache */
   /* search563_1_1 -> 691 in the cache */
   /* search563_1 -> 1662 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1661, 1662 },
      -1,
   } },

   /* replace563_0_0 -> 0 in the cache */
   /* replace563_0_1 -> 1599 in the cache */
   /* replace563_0 -> 1674 in the cache */
   /* replace563_1 -> 691 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 1674, 691 },
      -1,
   } },

   /* ('iand', ('ige(is_used_once)', 'a', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imax', 'b', 'c')) */
   /* search564_0_0 -> 132 in the cache */
   /* search564_0_1 -> 133 in the cache */
   /* search564_0 -> 1666 in the cache */
   /* search564_1_0 -> 132 in the cache */
   /* search564_1_1 -> 135 in the cache */
   /* search564_1 -> 1667 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1666, 1667 },
      -1,
   } },

   /* replace564_0 -> 132 in the cache */
   /* replace564_1_0 -> 133 in the cache */
   /* replace564_1_1 -> 135 in the cache */
   /* replace564_1 -> 1659 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 132, 1659 },
      -1,
   } },

   /* ('iand', ('ige(is_used_once)', 'a', 'c'), ('ige', 'b', 'c')) => ('ige', ('imin', 'a', 'b'), 'c') */
   /* search565_0_0 -> 0 in the cache */
   /* search565_0_1 -> 691 in the cache */
   /* search565_0 -> 1671 in the cache */
   /* search565_1_0 -> 1599 in the cache */
   /* search565_1_1 -> 691 in the cache */
   /* search565_1 -> 1672 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1671, 1672 },
      -1,
   } },

   /* replace565_0_0 -> 0 in the cache */
   /* replace565_0_1 -> 1599 in the cache */
   /* replace565_0 -> 1664 in the cache */
   /* replace565_1 -> 691 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 1664, 691 },
      -1,
   } },

   /* ('iand', ('ult(is_used_once)', 'a', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umin', 'b', 'c')) */
   /* search566_0_0 -> 132 in the cache */
   /* search566_0_1 -> 133 in the cache */
   /* search566_0 -> 1676 in the cache */
   /* search566_1_0 -> 132 in the cache */
   /* search566_1_1 -> 135 in the cache */
   /* search566_1 -> 1677 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1676, 1677 },
      -1,
   } },

   /* replace566_0 -> 132 in the cache */
   /* replace566_1_0 -> 133 in the cache */
   /* replace566_1_1 -> 135 in the cache */
   /* replace566_1 -> 1689 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 132, 1689 },
      -1,
   } },

   /* ('iand', ('ult(is_used_once)', 'a', 'c'), ('ult', 'b', 'c')) => ('ult', ('umax', 'a', 'b'), 'c') */
   /* search567_0_0 -> 0 in the cache */
   /* search567_0_1 -> 691 in the cache */
   /* search567_0 -> 1681 in the cache */
   /* search567_1_0 -> 1599 in the cache */
   /* search567_1_1 -> 691 in the cache */
   /* search567_1 -> 1682 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1681, 1682 },
      -1,
   } },

   /* replace567_0_0 -> 0 in the cache */
   /* replace567_0_1 -> 1599 in the cache */
   /* replace567_0 -> 1694 in the cache */
   /* replace567_1 -> 691 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 1694, 691 },
      -1,
   } },

   /* ('iand', ('uge(is_used_once)', 'a', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umax', 'b', 'c')) */
   /* search568_0_0 -> 132 in the cache */
   /* search568_0_1 -> 133 in the cache */
   /* search568_0 -> 1686 in the cache */
   /* search568_1_0 -> 132 in the cache */
   /* search568_1_1 -> 135 in the cache */
   /* search568_1 -> 1687 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1686, 1687 },
      -1,
   } },

   /* replace568_0 -> 132 in the cache */
   /* replace568_1_0 -> 133 in the cache */
   /* replace568_1_1 -> 135 in the cache */
   /* replace568_1 -> 1679 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 132, 1679 },
      -1,
   } },

   /* ('iand', ('uge(is_used_once)', 'a', 'c'), ('uge', 'b', 'c')) => ('uge', ('umin', 'a', 'b'), 'c') */
   /* search569_0_0 -> 0 in the cache */
   /* search569_0_1 -> 691 in the cache */
   /* search569_0 -> 1691 in the cache */
   /* search569_1_0 -> 1599 in the cache */
   /* search569_1_1 -> 691 in the cache */
   /* search569_1 -> 1692 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1691, 1692 },
      -1,
   } },

   /* replace569_0_0 -> 0 in the cache */
   /* replace569_0_1 -> 1599 in the cache */
   /* replace569_0 -> 1684 in the cache */
   /* replace569_1 -> 691 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 1684, 691 },
      -1,
   } },

   /* ('ior', ('ior(is_used_once)', ('flt(is_used_once)', 'a', 'c'), 'd'), ('flt', 'b', 'c')) => ('ior', ('flt', ('!fmin', 'a', 'b'), 'c'), 'd') */
   /* search570_0_0_0 -> 0 in the cache */
   /* search570_0_0_1 -> 691 in the cache */
   /* search570_0_0 -> 1598 in the cache */
   { .variable = {
      { nir_search_value_variable, 1 },
      2, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 1598, 1712 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      3, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search570_1_1 -> 691 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1714, 691 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1713, 1715 },
      -1,
   } },

   /* replace570_0_0_0 -> 0 in the cache */
   /* replace570_0_0_1 -> 1714 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      true,
      false,
      nir_op_fmin,
      1, 1,
      { 0, 1714 },
      -1,
   } },
   /* replace570_0_1 -> 691 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1717, 691 },
      -1,
   } },
   /* replace570_1 -> 1712 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1718, 1712 },
      -1,
   } },

   /* ('ior', ('ior(is_used_once)', ('flt', 'a', 'c'), 'd'), ('flt(is_used_once)', 'b', 'c')) => ('ior', ('flt', ('!fmin', 'a', 'b'), 'c'), 'd') */
   /* search571_0_0_0 -> 0 in the cache */
   /* search571_0_0_1 -> 691 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 0, 691 },
      -1,
   } },
   /* search571_0_1 -> 1712 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 1720, 1712 },
      0,
   } },
   /* search571_1_0 -> 1714 in the cache */
   /* search571_1_1 -> 691 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1714, 691 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1721, 1722 },
      -1,
   } },

   /* replace571_0_0_0 -> 0 in the cache */
   /* replace571_0_0_1 -> 1714 in the cache */
   /* replace571_0_0 -> 1717 in the cache */
   /* replace571_0_1 -> 691 in the cache */
   /* replace571_0 -> 1718 in the cache */
   /* replace571_1 -> 1712 in the cache */
   /* replace571 -> 1719 in the cache */

   /* ('ior', ('ior(is_used_once)', ('flt(is_used_once)', 'a', 'b'), 'd'), ('flt', 'a', 'c')) => ('ior', ('flt', 'a', ('!fmax', 'b', 'c')), 'd') */
   /* search572_0_0_0 -> 155 in the cache */
   /* search572_0_0_1 -> 156 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 155, 156 },
      0,
   } },
   /* search572_0_1 -> 1712 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 1724, 1712 },
      0,
   } },
   /* search572_1_0 -> 155 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      3, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 155, 1726 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1725, 1727 },
      -1,
   } },

   /* replace572_0_0 -> 155 in the cache */
   /* replace572_0_1_0 -> 156 in the cache */
   /* replace572_0_1_1 -> 1726 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      true,
      false,
      nir_op_fmax,
      1, 1,
      { 156, 1726 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 155, 1729 },
      -1,
   } },
   /* replace572_1 -> 1712 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1730, 1712 },
      -1,
   } },

   /* ('ior', ('ior(is_used_once)', ('flt', 'a', 'b'), 'd'), ('flt(is_used_once)', 'a', 'c')) => ('ior', ('flt', 'a', ('!fmax', 'b', 'c')), 'd') */
   /* search573_0_0_0 -> 155 in the cache */
   /* search573_0_0_1 -> 156 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 155, 156 },
      -1,
   } },
   /* search573_0_1 -> 1712 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 1732, 1712 },
      0,
   } },
   /* search573_1_0 -> 155 in the cache */
   /* search573_1_1 -> 1726 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 155, 1726 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1733, 1734 },
      -1,
   } },

   /* replace573_0_0 -> 155 in the cache */
   /* replace573_0_1_0 -> 156 in the cache */
   /* replace573_0_1_1 -> 1726 in the cache */
   /* replace573_0_1 -> 1729 in the cache */
   /* replace573_0 -> 1730 in the cache */
   /* replace573_1 -> 1712 in the cache */
   /* replace573 -> 1731 in the cache */

   /* ('ior', ('flt', 'a(is_a_number)', 'b(is_a_number)'), ('flt', 'b', 'a')) => ('fneu', 'a', 'b') */
   /* search574_0_0 -> 1052 in the cache */
   /* search574_0_1 -> 1053 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1052, 1053 },
      -1,
   } },
   /* search574_1_0 -> 3 in the cache */
   /* search574_1_1 -> 0 in the cache */
   /* search574_1 -> 1088 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1736, 1088 },
      -1,
   } },

   /* replace574_0 -> 0 in the cache */
   /* replace574_1 -> 3 in the cache */
   /* replace574 -> 1062 in the cache */

   /* ('umin', ('iand', 'a', '#b(is_pos_power_of_two)'), ('iand', 'c', 'b')) => ('iand', ('iand', 'a', 'b'), ('iand', 'c', 'b')) */
   /* search575_0_0 -> 0 in the cache */
   /* search575_0_1 -> 1 in the cache */
   /* search575_0 -> 205 in the cache */
   /* search575_1_0 -> 146 in the cache */
   /* search575_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 146, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umin,
      0, 3,
      { 205, 1738 },
      -1,
   } },

   /* replace575_0_0 -> 0 in the cache */
   /* replace575_0_1 -> 3 in the cache */
   /* replace575_0 -> 207 in the cache */
   /* replace575_1_0 -> 146 in the cache */
   /* replace575_1_1 -> 3 in the cache */
   /* replace575_1 -> 1738 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 207, 1738 },
      -1,
   } },

   /* ('ior', ('flt(is_used_once)', 0.0, 'a@16'), ('flt', 'b@16', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search576_0_0 -> 119 in the cache */
   /* search576_0_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 119, 11 },
      0,
   } },
   /* search576_1_0 -> 268 in the cache */
   /* search576_1_1 -> 119 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 268, 119 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1741, 1742 },
      -1,
   } },

   /* replace576_0 -> 119 in the cache */
   /* replace576_1_0 -> 11 in the cache */
   /* replace576_1_1_0 -> 268 in the cache */
   /* replace576_1_1 -> 541 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 11, 541 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 119, 1744 },
      -1,
   } },

   /* ('ior', ('flt', 0.0, 'a@16'), ('flt(is_used_once)', 'b@16', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search577_0_0 -> 119 in the cache */
   /* search577_0_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 119, 11 },
      -1,
   } },
   /* search577_1_0 -> 268 in the cache */
   /* search577_1_1 -> 119 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 268, 119 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1746, 1747 },
      -1,
   } },

   /* replace577_0 -> 119 in the cache */
   /* replace577_1_0 -> 11 in the cache */
   /* replace577_1_1_0 -> 268 in the cache */
   /* replace577_1_1 -> 541 in the cache */
   /* replace577_1 -> 1744 in the cache */
   /* replace577 -> 1745 in the cache */

   /* ('ior', ('fge(is_used_once)', 0.0, 'a@16'), ('fge', 'b@16', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search578_0_0 -> 119 in the cache */
   /* search578_0_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 119, 11 },
      0,
   } },
   /* search578_1_0 -> 268 in the cache */
   /* search578_1_1 -> 119 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 268, 119 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1749, 1750 },
      -1,
   } },

   /* replace578_0 -> 119 in the cache */
   /* replace578_1_0 -> 11 in the cache */
   /* replace578_1_1_0 -> 268 in the cache */
   /* replace578_1_1 -> 541 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 11, 541 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 119, 1752 },
      -1,
   } },

   /* ('ior', ('fge', 0.0, 'a@16'), ('fge(is_used_once)', 'b@16', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search579_0_0 -> 119 in the cache */
   /* search579_0_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 119, 11 },
      -1,
   } },
   /* search579_1_0 -> 268 in the cache */
   /* search579_1_1 -> 119 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 268, 119 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1754, 1755 },
      -1,
   } },

   /* replace579_0 -> 119 in the cache */
   /* replace579_1_0 -> 11 in the cache */
   /* replace579_1_1_0 -> 268 in the cache */
   /* replace579_1_1 -> 541 in the cache */
   /* replace579_1 -> 1752 in the cache */
   /* replace579 -> 1753 in the cache */

   /* ('~iand', ('flt(is_used_once)', 0.0, 'a@16'), ('flt', 'b@16', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search580_0_0 -> 119 in the cache */
   /* search580_0_1 -> 11 in the cache */
   /* search580_0 -> 1741 in the cache */
   /* search580_1_0 -> 268 in the cache */
   /* search580_1_1 -> 119 in the cache */
   /* search580_1 -> 1742 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1741, 1742 },
      -1,
   } },

   /* replace580_0 -> 119 in the cache */
   /* replace580_1_0 -> 11 in the cache */
   /* replace580_1_1_0 -> 268 in the cache */
   /* replace580_1_1 -> 541 in the cache */
   /* replace580_1 -> 1752 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 119, 1752 },
      -1,
   } },

   /* ('~iand', ('flt', 0.0, 'a@16'), ('flt(is_used_once)', 'b@16', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search581_0_0 -> 119 in the cache */
   /* search581_0_1 -> 11 in the cache */
   /* search581_0 -> 1746 in the cache */
   /* search581_1_0 -> 268 in the cache */
   /* search581_1_1 -> 119 in the cache */
   /* search581_1 -> 1747 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1746, 1747 },
      -1,
   } },

   /* replace581_0 -> 119 in the cache */
   /* replace581_1_0 -> 11 in the cache */
   /* replace581_1_1_0 -> 268 in the cache */
   /* replace581_1_1 -> 541 in the cache */
   /* replace581_1 -> 1752 in the cache */
   /* replace581 -> 1758 in the cache */

   /* ('~iand', ('fge(is_used_once)', 0.0, 'a@16'), ('fge', 'b@16', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search582_0_0 -> 119 in the cache */
   /* search582_0_1 -> 11 in the cache */
   /* search582_0 -> 1749 in the cache */
   /* search582_1_0 -> 268 in the cache */
   /* search582_1_1 -> 119 in the cache */
   /* search582_1 -> 1750 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1749, 1750 },
      -1,
   } },

   /* replace582_0 -> 119 in the cache */
   /* replace582_1_0 -> 11 in the cache */
   /* replace582_1_1_0 -> 268 in the cache */
   /* replace582_1_1 -> 541 in the cache */
   /* replace582_1 -> 1744 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 119, 1744 },
      -1,
   } },

   /* ('~iand', ('fge', 0.0, 'a@16'), ('fge(is_used_once)', 'b@16', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search583_0_0 -> 119 in the cache */
   /* search583_0_1 -> 11 in the cache */
   /* search583_0 -> 1754 in the cache */
   /* search583_1_0 -> 268 in the cache */
   /* search583_1_1 -> 119 in the cache */
   /* search583_1 -> 1755 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1754, 1755 },
      -1,
   } },

   /* replace583_0 -> 119 in the cache */
   /* replace583_1_0 -> 11 in the cache */
   /* replace583_1_1_0 -> 268 in the cache */
   /* replace583_1_1 -> 541 in the cache */
   /* replace583_1 -> 1744 in the cache */
   /* replace583 -> 1761 in the cache */

   /* ('ior', ('feq(is_used_once)', 'a@16', 0.0), ('feq', 'b@16', 0.0)) => ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search584_0_0 -> 11 in the cache */
   /* search584_0_1 -> 119 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      1, 1,
      { 11, 119 },
      0,
   } },
   /* search584_1_0 -> 268 in the cache */
   /* search584_1_1 -> 119 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      2, 1,
      { 268, 119 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 1763, 1764 },
      -1,
   } },

   /* replace584_0_0_0 -> 11 in the cache */
   /* replace584_0_0 -> 697 in the cache */
   /* replace584_0_1_0 -> 268 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 268 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 697, 1766 },
      -1,
   } },
   /* replace584_1 -> 119 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1767, 119 },
      -1,
   } },

   /* ('ior', ('fneu(is_used_once)', 'a@16', 0.0), ('fneu', 'b@16', 0.0)) => ('fneu', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search585_0_0 -> 11 in the cache */
   /* search585_0_1 -> 119 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      1, 1,
      { 11, 119 },
      0,
   } },
   /* search585_1_0 -> 268 in the cache */
   /* search585_1_1 -> 119 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      2, 1,
      { 268, 119 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 1769, 1770 },
      -1,
   } },

   /* replace585_0_0_0 -> 11 in the cache */
   /* replace585_0_0 -> 697 in the cache */
   /* replace585_0_1_0 -> 268 in the cache */
   /* replace585_0_1 -> 1766 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 697, 1766 },
      -1,
   } },
   /* replace585_1 -> 119 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1772, 119 },
      -1,
   } },

   /* ('iand', ('feq(is_used_once)', 'a@16', 0.0), ('feq', 'b@16', 0.0)) => ('feq', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search586_0_0 -> 11 in the cache */
   /* search586_0_1 -> 119 in the cache */
   /* search586_0 -> 1763 in the cache */
   /* search586_1_0 -> 268 in the cache */
   /* search586_1_1 -> 119 in the cache */
   /* search586_1 -> 1764 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 1763, 1764 },
      -1,
   } },

   /* replace586_0_0_0 -> 11 in the cache */
   /* replace586_0_0 -> 697 in the cache */
   /* replace586_0_1_0 -> 268 in the cache */
   /* replace586_0_1 -> 1766 in the cache */
   /* replace586_0 -> 1772 in the cache */
   /* replace586_1 -> 119 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1772, 119 },
      -1,
   } },

   /* ('iand', ('fneu(is_used_once)', 'a@16', 0.0), ('fneu', 'b@16', 0.0)) => ('fneu', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search587_0_0 -> 11 in the cache */
   /* search587_0_1 -> 119 in the cache */
   /* search587_0 -> 1769 in the cache */
   /* search587_1_0 -> 268 in the cache */
   /* search587_1_1 -> 119 in the cache */
   /* search587_1 -> 1770 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 1769, 1770 },
      -1,
   } },

   /* replace587_0_0_0 -> 11 in the cache */
   /* replace587_0_0 -> 697 in the cache */
   /* replace587_0_1_0 -> 268 in the cache */
   /* replace587_0_1 -> 1766 in the cache */
   /* replace587_0 -> 1767 in the cache */
   /* replace587_1 -> 119 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1767, 119 },
      -1,
   } },

   /* ('bcsel@16', ('feq', 'a', 0.0), 1.0, ('i2f16', ('iadd', ('b2i16', ('flt', 0.0, 'a@16')), ('ineg', ('b2i16', ('flt', 'a@16', 0.0)))))) => ('i2f16', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0))))) */
   /* search588_0_0 -> 11 in the cache */
   /* search588_0_1 -> 119 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 11, 119 },
      -1,
   } },
   /* search588_1 -> 488 in the cache */
   /* search588_2_0_0_0_0 -> 119 in the cache */
   /* search588_2_0_0_0_1 -> 11 in the cache */
   /* search588_2_0_0_0 -> 1746 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 1746 },
      -1,
   } },
   /* search588_2_0_1_0_0_0 -> 11 in the cache */
   /* search588_2_0_1_0_0_1 -> 119 in the cache */
   /* search588_2_0_1_0_0 -> 696 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 696 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1780 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 1779, 1781 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 1,
      { 1782 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 1778, 488, 1783 },
      -1,
   } },

   /* replace588_0_0_0_0 -> 11 in the cache */
   /* replace588_0_0_0_1 -> 119 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      nir_op_fge,
      -1, 0,
      { 11, 119 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1785 },
      -1,
   } },
   /* replace588_0_1_0_0_0 -> 11 in the cache */
   /* replace588_0_1_0_0_1 -> 119 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      nir_op_flt,
      -1, 0,
      { 11, 119 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1787 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1788 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 1786, 1789 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 1,
      { 1790 },
      -1,
   } },

   /* ('bcsel', 'a', ('b2f(is_used_once)', 'b@16'), ('b2f', 'c@16')) => ('b2f', ('bcsel', 'a', 'b', 'c')) */
   /* search589_0 -> 767 in the cache */
   /* search589_1_0 -> 268 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 268 },
      0,
   } },
   /* search589_2_0 -> 476 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 476 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 767, 1792, 1793 },
      -1,
   } },

   /* replace589_0_0 -> 767 in the cache */
   /* replace589_0_1 -> 268 in the cache */
   /* replace589_0_2 -> 476 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 767, 268, 476 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1795 },
      -1,
   } },

   /* ('~i2f16', ('f2i', 'a@16')) => ('ftrunc', 'a') */
   /* search590_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_f2i,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 1797 },
      -1,
   } },

   /* replace590_0 -> 11 in the cache */
   /* replace590 -> 695 in the cache */

   /* ('~f2i16', ('i2f', 'a@16')) => a */
   /* search591_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_i2f,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 1799 },
      -1,
   } },

   /* replace591 -> 11 in the cache */

   /* ('~f2i16', ('u2f', 'a@16')) => a */
   /* search592_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_u2f,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 1801 },
      -1,
   } },

   /* replace592 -> 11 in the cache */

   /* ('~f2u16', ('i2f', 'a@16')) => a */
   /* search593_0_0 -> 11 in the cache */
   /* search593_0 -> 1799 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_f2u16,
      -1, 0,
      { 1799 },
      -1,
   } },

   /* replace593 -> 11 in the cache */

   /* ('~f2u16', ('u2f', 'a@16')) => a */
   /* search594_0_0 -> 11 in the cache */
   /* search594_0 -> 1801 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_f2u16,
      -1, 0,
      { 1801 },
      -1,
   } },

   /* replace594 -> 11 in the cache */

   /* ('fadd', ('b2f16', ('flt', 0.0, 'a@16')), ('fneg', ('b2f16', ('flt', 'a@16', 0.0)))) => ('fsign', 'a') */
   /* search595_0_0_0 -> 119 in the cache */
   /* search595_0_0_1 -> 11 in the cache */
   /* search595_0_0 -> 1746 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2f16,
      -1, 0,
      { 1746 },
      -1,
   } },
   /* search595_1_0_0_0 -> 11 in the cache */
   /* search595_1_0_0_1 -> 119 in the cache */
   /* search595_1_0_0 -> 696 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2f16,
      -1, 0,
      { 696 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1806 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 1805, 1807 },
      -1,
   } },

   /* replace595_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fsign,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('iadd', ('b2i16', ('flt', 0, 'a@16')), ('ineg', ('b2i16', ('flt', 'a@16', 0)))) => ('f2i16', ('fsign', 'a')) */
   /* search596_0_0_0 -> 866 in the cache */
   /* search596_0_0_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 866, 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 1810 },
      -1,
   } },
   /* search596_1_0_0_0 -> 11 in the cache */
   /* search596_1_0_0_1 -> 866 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 11, 866 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 1812 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1813 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 1811, 1814 },
      -1,
   } },

   /* replace596_0_0 -> 11 in the cache */
   /* replace596_0 -> 1809 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 1809 },
      -1,
   } },

   /* ('~f2f16', ('f2f', 'a')) => ('f2f16', 'a') */
   /* search597_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_f2f,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1817 },
      -1,
   } },

   /* replace597_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 32 },
      -1,
   } },

   /* ('~f2f16', ('u2f', 'a')) => ('u2f16', 'a') */
   /* search598_0_0 -> 32 in the cache */
   /* search598_0 -> 112 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 112 },
      -1,
   } },

   /* replace598_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 32 },
      -1,
   } },

   /* ('~f2f16', ('i2f', 'a')) => ('i2f16', 'a') */
   /* search599_0_0 -> 32 in the cache */
   /* search599_0 -> 1255 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1255 },
      -1,
   } },

   /* replace599_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 32 },
      -1,
   } },

   /* ('~f2u16', ('f2f', 'a')) => ('f2u16', 'a') */
   /* search600_0_0 -> 32 in the cache */
   /* search600_0 -> 1817 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_f2u16,
      -1, 0,
      { 1817 },
      -1,
   } },

   /* replace600_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2u16,
      -1, 0,
      { 32 },
      -1,
   } },

   /* ('~f2i16', ('f2f', 'a')) => ('f2i16', 'a') */
   /* search601_0_0 -> 32 in the cache */
   /* search601_0 -> 1817 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 1817 },
      -1,
   } },

   /* replace601_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 32 },
      -1,
   } },

   /* ('i2f16', ('f2i', ('fsign', 'a@16'))) => ('fsign', 'a') */
   /* search602_0_0_0 -> 11 in the cache */
   /* search602_0_0 -> 1809 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_f2i,
      -1, 0,
      { 1809 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 1828 },
      -1,
   } },

   /* replace602_0 -> 11 in the cache */
   /* replace602 -> 1809 in the cache */

   /* ('~f2f16', ('f2f32', 'a@16')) => a */
   /* search603_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1830 },
      -1,
   } },

   /* replace603 -> 11 in the cache */

   /* ('f2u32', ('f2f32', 'a@16')) => ('f2u32', 'a') */
   /* search604_0_0 -> 11 in the cache */
   /* search604_0 -> 1830 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 1830 },
      -1,
   } },

   /* replace604_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('f2i32', ('f2f32', 'a@16')) => ('f2i32', 'a') */
   /* search605_0_0 -> 11 in the cache */
   /* search605_0 -> 1830 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 1830 },
      -1,
   } },

   /* replace605_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('f2f16', ('u2f32', 'a')) => ('u2f16', 'a') */
   /* search606_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1836 },
      -1,
   } },

   /* replace606_0 -> 32 in the cache */
   /* replace606 -> 1821 in the cache */

   /* ('f2f16', ('i2f32', 'a')) => ('i2f16', 'a') */
   /* search607_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1838 },
      -1,
   } },

   /* replace607_0 -> 32 in the cache */
   /* replace607 -> 1823 in the cache */

   /* ('~f2f16', ('f2f64', 'a@16')) => a */
   /* search608_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2f64,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1840 },
      -1,
   } },

   /* replace608 -> 11 in the cache */

   /* ('f2u64', ('f2f64', 'a@16')) => ('f2u64', 'a') */
   /* search609_0_0 -> 11 in the cache */
   /* search609_0 -> 1840 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 1840 },
      -1,
   } },

   /* replace609_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('f2i64', ('f2f64', 'a@16')) => ('f2i64', 'a') */
   /* search610_0_0 -> 11 in the cache */
   /* search610_0 -> 1840 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 1840 },
      -1,
   } },

   /* replace610_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('f2f16', ('u2f64', 'a')) => ('u2f16', 'a') */
   /* search611_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1846 },
      -1,
   } },

   /* replace611_0 -> 32 in the cache */
   /* replace611 -> 1821 in the cache */

   /* ('f2f16', ('i2f64', 'a')) => ('i2f16', 'a') */
   /* search612_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1848 },
      -1,
   } },

   /* replace612_0 -> 32 in the cache */
   /* replace612 -> 1823 in the cache */

   /* ('ior', ('flt(is_used_once)', 0.0, 'a@32'), ('flt', 'b@32', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search613_0_0 -> 121 in the cache */
   /* search613_0_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 121, 16 },
      0,
   } },
   /* search613_1_0 -> 36 in the cache */
   /* search613_1_1 -> 121 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 36, 121 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1850, 1851 },
      -1,
   } },

   /* replace613_0 -> 121 in the cache */
   /* replace613_1_0 -> 16 in the cache */
   /* replace613_1_1_0 -> 36 in the cache */
   /* replace613_1_1 -> 607 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 16, 607 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 121, 1853 },
      -1,
   } },

   /* ('ior', ('flt', 0.0, 'a@32'), ('flt(is_used_once)', 'b@32', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search614_0_0 -> 121 in the cache */
   /* search614_0_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 121, 16 },
      -1,
   } },
   /* search614_1_0 -> 36 in the cache */
   /* search614_1_1 -> 121 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 36, 121 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1855, 1856 },
      -1,
   } },

   /* replace614_0 -> 121 in the cache */
   /* replace614_1_0 -> 16 in the cache */
   /* replace614_1_1_0 -> 36 in the cache */
   /* replace614_1_1 -> 607 in the cache */
   /* replace614_1 -> 1853 in the cache */
   /* replace614 -> 1854 in the cache */

   /* ('ior', ('fge(is_used_once)', 0.0, 'a@32'), ('fge', 'b@32', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search615_0_0 -> 121 in the cache */
   /* search615_0_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 121, 16 },
      0,
   } },
   /* search615_1_0 -> 36 in the cache */
   /* search615_1_1 -> 121 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 36, 121 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1858, 1859 },
      -1,
   } },

   /* replace615_0 -> 121 in the cache */
   /* replace615_1_0 -> 16 in the cache */
   /* replace615_1_1_0 -> 36 in the cache */
   /* replace615_1_1 -> 607 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 16, 607 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 121, 1861 },
      -1,
   } },

   /* ('ior', ('fge', 0.0, 'a@32'), ('fge(is_used_once)', 'b@32', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search616_0_0 -> 121 in the cache */
   /* search616_0_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 121, 16 },
      -1,
   } },
   /* search616_1_0 -> 36 in the cache */
   /* search616_1_1 -> 121 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 36, 121 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1863, 1864 },
      -1,
   } },

   /* replace616_0 -> 121 in the cache */
   /* replace616_1_0 -> 16 in the cache */
   /* replace616_1_1_0 -> 36 in the cache */
   /* replace616_1_1 -> 607 in the cache */
   /* replace616_1 -> 1861 in the cache */
   /* replace616 -> 1862 in the cache */

   /* ('~iand', ('flt(is_used_once)', 0.0, 'a@32'), ('flt', 'b@32', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search617_0_0 -> 121 in the cache */
   /* search617_0_1 -> 16 in the cache */
   /* search617_0 -> 1850 in the cache */
   /* search617_1_0 -> 36 in the cache */
   /* search617_1_1 -> 121 in the cache */
   /* search617_1 -> 1851 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1850, 1851 },
      -1,
   } },

   /* replace617_0 -> 121 in the cache */
   /* replace617_1_0 -> 16 in the cache */
   /* replace617_1_1_0 -> 36 in the cache */
   /* replace617_1_1 -> 607 in the cache */
   /* replace617_1 -> 1861 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 121, 1861 },
      -1,
   } },

   /* ('~iand', ('flt', 0.0, 'a@32'), ('flt(is_used_once)', 'b@32', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search618_0_0 -> 121 in the cache */
   /* search618_0_1 -> 16 in the cache */
   /* search618_0 -> 1855 in the cache */
   /* search618_1_0 -> 36 in the cache */
   /* search618_1_1 -> 121 in the cache */
   /* search618_1 -> 1856 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1855, 1856 },
      -1,
   } },

   /* replace618_0 -> 121 in the cache */
   /* replace618_1_0 -> 16 in the cache */
   /* replace618_1_1_0 -> 36 in the cache */
   /* replace618_1_1 -> 607 in the cache */
   /* replace618_1 -> 1861 in the cache */
   /* replace618 -> 1867 in the cache */

   /* ('~iand', ('fge(is_used_once)', 0.0, 'a@32'), ('fge', 'b@32', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search619_0_0 -> 121 in the cache */
   /* search619_0_1 -> 16 in the cache */
   /* search619_0 -> 1858 in the cache */
   /* search619_1_0 -> 36 in the cache */
   /* search619_1_1 -> 121 in the cache */
   /* search619_1 -> 1859 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1858, 1859 },
      -1,
   } },

   /* replace619_0 -> 121 in the cache */
   /* replace619_1_0 -> 16 in the cache */
   /* replace619_1_1_0 -> 36 in the cache */
   /* replace619_1_1 -> 607 in the cache */
   /* replace619_1 -> 1853 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 121, 1853 },
      -1,
   } },

   /* ('~iand', ('fge', 0.0, 'a@32'), ('fge(is_used_once)', 'b@32', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search620_0_0 -> 121 in the cache */
   /* search620_0_1 -> 16 in the cache */
   /* search620_0 -> 1863 in the cache */
   /* search620_1_0 -> 36 in the cache */
   /* search620_1_1 -> 121 in the cache */
   /* search620_1 -> 1864 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1863, 1864 },
      -1,
   } },

   /* replace620_0 -> 121 in the cache */
   /* replace620_1_0 -> 16 in the cache */
   /* replace620_1_1_0 -> 36 in the cache */
   /* replace620_1_1 -> 607 in the cache */
   /* replace620_1 -> 1853 in the cache */
   /* replace620 -> 1870 in the cache */

   /* ('ior', ('feq(is_used_once)', 'a@32', 0.0), ('feq', 'b@32', 0.0)) => ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search621_0_0 -> 16 in the cache */
   /* search621_0_1 -> 121 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      1, 1,
      { 16, 121 },
      0,
   } },
   /* search621_1_0 -> 36 in the cache */
   /* search621_1_1 -> 121 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      2, 1,
      { 36, 121 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 1872, 1873 },
      -1,
   } },

   /* replace621_0_0_0 -> 16 in the cache */
   /* replace621_0_0 -> 703 in the cache */
   /* replace621_0_1_0 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 703, 1875 },
      -1,
   } },
   /* replace621_1 -> 121 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1876, 121 },
      -1,
   } },

   /* ('ior', ('fneu(is_used_once)', 'a@32', 0.0), ('fneu', 'b@32', 0.0)) => ('fneu', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search622_0_0 -> 16 in the cache */
   /* search622_0_1 -> 121 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      1, 1,
      { 16, 121 },
      0,
   } },
   /* search622_1_0 -> 36 in the cache */
   /* search622_1_1 -> 121 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      2, 1,
      { 36, 121 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 1878, 1879 },
      -1,
   } },

   /* replace622_0_0_0 -> 16 in the cache */
   /* replace622_0_0 -> 703 in the cache */
   /* replace622_0_1_0 -> 36 in the cache */
   /* replace622_0_1 -> 1875 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 703, 1875 },
      -1,
   } },
   /* replace622_1 -> 121 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1881, 121 },
      -1,
   } },

   /* ('iand', ('feq(is_used_once)', 'a@32', 0.0), ('feq', 'b@32', 0.0)) => ('feq', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search623_0_0 -> 16 in the cache */
   /* search623_0_1 -> 121 in the cache */
   /* search623_0 -> 1872 in the cache */
   /* search623_1_0 -> 36 in the cache */
   /* search623_1_1 -> 121 in the cache */
   /* search623_1 -> 1873 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 1872, 1873 },
      -1,
   } },

   /* replace623_0_0_0 -> 16 in the cache */
   /* replace623_0_0 -> 703 in the cache */
   /* replace623_0_1_0 -> 36 in the cache */
   /* replace623_0_1 -> 1875 in the cache */
   /* replace623_0 -> 1881 in the cache */
   /* replace623_1 -> 121 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1881, 121 },
      -1,
   } },

   /* ('iand', ('fneu(is_used_once)', 'a@32', 0.0), ('fneu', 'b@32', 0.0)) => ('fneu', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search624_0_0 -> 16 in the cache */
   /* search624_0_1 -> 121 in the cache */
   /* search624_0 -> 1878 in the cache */
   /* search624_1_0 -> 36 in the cache */
   /* search624_1_1 -> 121 in the cache */
   /* search624_1 -> 1879 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 1878, 1879 },
      -1,
   } },

   /* replace624_0_0_0 -> 16 in the cache */
   /* replace624_0_0 -> 703 in the cache */
   /* replace624_0_1_0 -> 36 in the cache */
   /* replace624_0_1 -> 1875 in the cache */
   /* replace624_0 -> 1876 in the cache */
   /* replace624_1 -> 121 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1876, 121 },
      -1,
   } },

   /* ('bcsel@32', ('feq', 'a', 0.0), 1.0, ('i2f32', ('iadd', ('b2i32', ('flt', 0.0, 'a@32')), ('ineg', ('b2i32', ('flt', 'a@32', 0.0)))))) => ('i2f32', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0))))) */
   /* search625_0_0 -> 16 in the cache */
   /* search625_0_1 -> 121 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 16, 121 },
      -1,
   } },
   /* search625_1 -> 254 in the cache */
   /* search625_2_0_0_0_0 -> 121 in the cache */
   /* search625_2_0_0_0_1 -> 16 in the cache */
   /* search625_2_0_0_0 -> 1855 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1855 },
      -1,
   } },
   /* search625_2_0_1_0_0_0 -> 16 in the cache */
   /* search625_2_0_1_0_0_1 -> 121 in the cache */
   /* search625_2_0_1_0_0 -> 702 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 702 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1889 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 1888, 1890 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 1,
      { 1891 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 1887, 254, 1892 },
      -1,
   } },

   /* replace625_0_0_0_0 -> 16 in the cache */
   /* replace625_0_0_0_1 -> 121 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      nir_op_fge,
      -1, 0,
      { 16, 121 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1894 },
      -1,
   } },
   /* replace625_0_1_0_0_0 -> 16 in the cache */
   /* replace625_0_1_0_0_1 -> 121 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      nir_op_flt,
      -1, 0,
      { 16, 121 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1896 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1897 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 1895, 1898 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 1,
      { 1899 },
      -1,
   } },

   /* ('bcsel', 'a', ('b2f(is_used_once)', 'b@32'), ('b2f', 'c@32')) => ('b2f', ('bcsel', 'a', 'b', 'c')) */
   /* search626_0 -> 767 in the cache */
   /* search626_1_0 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 36 },
      0,
   } },
   /* search626_2_0 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 141 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 767, 1901, 1902 },
      -1,
   } },

   /* replace626_0_0 -> 767 in the cache */
   /* replace626_0_1 -> 36 in the cache */
   /* replace626_0_2 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 767, 36, 141 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1904 },
      -1,
   } },

   /* ('~i2f32', ('f2i', 'a@32')) => ('ftrunc', 'a') */
   /* search627_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_f2i,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 1906 },
      -1,
   } },

   /* replace627_0 -> 16 in the cache */
   /* replace627 -> 701 in the cache */

   /* ('~f2i32', ('i2f', 'a@32')) => a */
   /* search628_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_i2f,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 1908 },
      -1,
   } },

   /* replace628 -> 16 in the cache */

   /* ('~f2i32', ('u2f', 'a@32')) => a */
   /* search629_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_u2f,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 1910 },
      -1,
   } },

   /* replace629 -> 16 in the cache */

   /* ('~f2u32', ('i2f', 'a@32')) => a */
   /* search630_0_0 -> 16 in the cache */
   /* search630_0 -> 1908 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 1908 },
      -1,
   } },

   /* replace630 -> 16 in the cache */

   /* ('~f2u32', ('u2f', 'a@32')) => a */
   /* search631_0_0 -> 16 in the cache */
   /* search631_0 -> 1910 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 1910 },
      -1,
   } },

   /* replace631 -> 16 in the cache */

   /* ('fadd', ('b2f32', ('flt', 0.0, 'a@32')), ('fneg', ('b2f32', ('flt', 'a@32', 0.0)))) => ('fsign', 'a') */
   /* search632_0_0_0 -> 121 in the cache */
   /* search632_0_0_1 -> 16 in the cache */
   /* search632_0_0 -> 1855 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2f32,
      -1, 0,
      { 1855 },
      -1,
   } },
   /* search632_1_0_0_0 -> 16 in the cache */
   /* search632_1_0_0_1 -> 121 in the cache */
   /* search632_1_0_0 -> 702 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2f32,
      -1, 0,
      { 702 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1915 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 1914, 1916 },
      -1,
   } },

   /* replace632_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fsign,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('iadd', ('b2i32', ('flt', 0, 'a@32')), ('ineg', ('b2i32', ('flt', 'a@32', 0)))) => ('f2i32', ('fsign', 'a')) */
   /* search633_0_0_0 -> 128 in the cache */
   /* search633_0_0_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 128, 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1919 },
      -1,
   } },
   /* search633_1_0_0_0 -> 16 in the cache */
   /* search633_1_0_0_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 16, 128 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1921 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1922 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 1920, 1923 },
      -1,
   } },

   /* replace633_0_0 -> 16 in the cache */
   /* replace633_0 -> 1918 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 1918 },
      -1,
   } },

   /* ('~f2f32', ('f2f', 'a')) => ('f2f32', 'a') */
   /* search634_0_0 -> 32 in the cache */
   /* search634_0 -> 1817 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 1817 },
      -1,
   } },

   /* replace634_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 32 },
      -1,
   } },

   /* ('~f2f32', ('u2f', 'a')) => ('u2f32', 'a') */
   /* search635_0_0 -> 32 in the cache */
   /* search635_0 -> 112 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 112 },
      -1,
   } },

   /* replace635_0 -> 32 in the cache */
   /* replace635 -> 1836 in the cache */

   /* ('~f2f32', ('i2f', 'a')) => ('i2f32', 'a') */
   /* search636_0_0 -> 32 in the cache */
   /* search636_0 -> 1255 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 1255 },
      -1,
   } },

   /* replace636_0 -> 32 in the cache */
   /* replace636 -> 1838 in the cache */

   /* ('~f2u32', ('f2f', 'a')) => ('f2u32', 'a') */
   /* search637_0_0 -> 32 in the cache */
   /* search637_0 -> 1817 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 1817 },
      -1,
   } },

   /* replace637_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 32 },
      -1,
   } },

   /* ('~f2i32', ('f2f', 'a')) => ('f2i32', 'a') */
   /* search638_0_0 -> 32 in the cache */
   /* search638_0 -> 1817 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 1817 },
      -1,
   } },

   /* replace638_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 32 },
      -1,
   } },

   /* ('i2f32', ('f2i', ('fsign', 'a@32'))) => ('fsign', 'a') */
   /* search639_0_0_0 -> 16 in the cache */
   /* search639_0_0 -> 1918 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_f2i,
      -1, 0,
      { 1918 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 1934 },
      -1,
   } },

   /* replace639_0 -> 16 in the cache */
   /* replace639 -> 1918 in the cache */

   /* ('~f2f32', ('f2f64', 'a@32')) => a */
   /* search640_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2f64,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 1936 },
      -1,
   } },

   /* replace640 -> 16 in the cache */

   /* ('f2u64', ('f2f64', 'a@32')) => ('f2u64', 'a') */
   /* search641_0_0 -> 16 in the cache */
   /* search641_0 -> 1936 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 1936 },
      -1,
   } },

   /* replace641_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('f2i64', ('f2f64', 'a@32')) => ('f2i64', 'a') */
   /* search642_0_0 -> 16 in the cache */
   /* search642_0 -> 1936 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 1936 },
      -1,
   } },

   /* replace642_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('f2f32', ('u2f64', 'a')) => ('u2f32', 'a') */
   /* search643_0_0 -> 32 in the cache */
   /* search643_0 -> 1846 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 1846 },
      -1,
   } },

   /* replace643_0 -> 32 in the cache */
   /* replace643 -> 1836 in the cache */

   /* ('f2f32', ('i2f64', 'a')) => ('i2f32', 'a') */
   /* search644_0_0 -> 32 in the cache */
   /* search644_0 -> 1848 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 1848 },
      -1,
   } },

   /* replace644_0 -> 32 in the cache */
   /* replace644 -> 1838 in the cache */

   /* ('ior', ('flt(is_used_once)', 0.0, 'a@64'), ('flt', 'b@64', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search645_0_0 -> 708 in the cache */
   /* search645_0_1 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 708, 21 },
      0,
   } },
   /* search645_1_0 -> 41 in the cache */
   /* search645_1_1 -> 708 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 41, 708 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1944, 1945 },
      -1,
   } },

   /* replace645_0 -> 708 in the cache */
   /* replace645_1_0 -> 21 in the cache */
   /* replace645_1_1_0 -> 41 in the cache */
   /* replace645_1_1 -> 680 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 21, 680 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 708, 1947 },
      -1,
   } },

   /* ('ior', ('flt', 0.0, 'a@64'), ('flt(is_used_once)', 'b@64', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search646_0_0 -> 708 in the cache */
   /* search646_0_1 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 708, 21 },
      -1,
   } },
   /* search646_1_0 -> 41 in the cache */
   /* search646_1_1 -> 708 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 41, 708 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1949, 1950 },
      -1,
   } },

   /* replace646_0 -> 708 in the cache */
   /* replace646_1_0 -> 21 in the cache */
   /* replace646_1_1_0 -> 41 in the cache */
   /* replace646_1_1 -> 680 in the cache */
   /* replace646_1 -> 1947 in the cache */
   /* replace646 -> 1948 in the cache */

   /* ('ior', ('fge(is_used_once)', 0.0, 'a@64'), ('fge', 'b@64', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search647_0_0 -> 708 in the cache */
   /* search647_0_1 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 708, 21 },
      0,
   } },
   /* search647_1_0 -> 41 in the cache */
   /* search647_1_1 -> 708 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 41, 708 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1952, 1953 },
      -1,
   } },

   /* replace647_0 -> 708 in the cache */
   /* replace647_1_0 -> 21 in the cache */
   /* replace647_1_1_0 -> 41 in the cache */
   /* replace647_1_1 -> 680 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 21, 680 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 708, 1955 },
      -1,
   } },

   /* ('ior', ('fge', 0.0, 'a@64'), ('fge(is_used_once)', 'b@64', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search648_0_0 -> 708 in the cache */
   /* search648_0_1 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 708, 21 },
      -1,
   } },
   /* search648_1_0 -> 41 in the cache */
   /* search648_1_1 -> 708 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 41, 708 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1957, 1958 },
      -1,
   } },

   /* replace648_0 -> 708 in the cache */
   /* replace648_1_0 -> 21 in the cache */
   /* replace648_1_1_0 -> 41 in the cache */
   /* replace648_1_1 -> 680 in the cache */
   /* replace648_1 -> 1955 in the cache */
   /* replace648 -> 1956 in the cache */

   /* ('~iand', ('flt(is_used_once)', 0.0, 'a@64'), ('flt', 'b@64', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search649_0_0 -> 708 in the cache */
   /* search649_0_1 -> 21 in the cache */
   /* search649_0 -> 1944 in the cache */
   /* search649_1_0 -> 41 in the cache */
   /* search649_1_1 -> 708 in the cache */
   /* search649_1 -> 1945 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1944, 1945 },
      -1,
   } },

   /* replace649_0 -> 708 in the cache */
   /* replace649_1_0 -> 21 in the cache */
   /* replace649_1_1_0 -> 41 in the cache */
   /* replace649_1_1 -> 680 in the cache */
   /* replace649_1 -> 1955 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 708, 1955 },
      -1,
   } },

   /* ('~iand', ('flt', 0.0, 'a@64'), ('flt(is_used_once)', 'b@64', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search650_0_0 -> 708 in the cache */
   /* search650_0_1 -> 21 in the cache */
   /* search650_0 -> 1949 in the cache */
   /* search650_1_0 -> 41 in the cache */
   /* search650_1_1 -> 708 in the cache */
   /* search650_1 -> 1950 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1949, 1950 },
      -1,
   } },

   /* replace650_0 -> 708 in the cache */
   /* replace650_1_0 -> 21 in the cache */
   /* replace650_1_1_0 -> 41 in the cache */
   /* replace650_1_1 -> 680 in the cache */
   /* replace650_1 -> 1955 in the cache */
   /* replace650 -> 1961 in the cache */

   /* ('~iand', ('fge(is_used_once)', 0.0, 'a@64'), ('fge', 'b@64', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search651_0_0 -> 708 in the cache */
   /* search651_0_1 -> 21 in the cache */
   /* search651_0 -> 1952 in the cache */
   /* search651_1_0 -> 41 in the cache */
   /* search651_1_1 -> 708 in the cache */
   /* search651_1 -> 1953 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1952, 1953 },
      -1,
   } },

   /* replace651_0 -> 708 in the cache */
   /* replace651_1_0 -> 21 in the cache */
   /* replace651_1_1_0 -> 41 in the cache */
   /* replace651_1_1 -> 680 in the cache */
   /* replace651_1 -> 1947 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 708, 1947 },
      -1,
   } },

   /* ('~iand', ('fge', 0.0, 'a@64'), ('fge(is_used_once)', 'b@64', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search652_0_0 -> 708 in the cache */
   /* search652_0_1 -> 21 in the cache */
   /* search652_0 -> 1957 in the cache */
   /* search652_1_0 -> 41 in the cache */
   /* search652_1_1 -> 708 in the cache */
   /* search652_1 -> 1958 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1957, 1958 },
      -1,
   } },

   /* replace652_0 -> 708 in the cache */
   /* replace652_1_0 -> 21 in the cache */
   /* replace652_1_1_0 -> 41 in the cache */
   /* replace652_1_1 -> 680 in the cache */
   /* replace652_1 -> 1947 in the cache */
   /* replace652 -> 1964 in the cache */

   /* ('ior', ('feq(is_used_once)', 'a@64', 0.0), ('feq', 'b@64', 0.0)) => ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search653_0_0 -> 21 in the cache */
   /* search653_0_1 -> 708 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      1, 1,
      { 21, 708 },
      0,
   } },
   /* search653_1_0 -> 41 in the cache */
   /* search653_1_1 -> 708 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      2, 1,
      { 41, 708 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 1966, 1967 },
      -1,
   } },

   /* replace653_0_0_0 -> 21 in the cache */
   /* replace653_0_0 -> 710 in the cache */
   /* replace653_0_1_0 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 41 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 710, 1969 },
      -1,
   } },
   /* replace653_1 -> 708 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1970, 708 },
      -1,
   } },

   /* ('ior', ('fneu(is_used_once)', 'a@64', 0.0), ('fneu', 'b@64', 0.0)) => ('fneu', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search654_0_0 -> 21 in the cache */
   /* search654_0_1 -> 708 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      1, 1,
      { 21, 708 },
      0,
   } },
   /* search654_1_0 -> 41 in the cache */
   /* search654_1_1 -> 708 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      2, 1,
      { 41, 708 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 1972, 1973 },
      -1,
   } },

   /* replace654_0_0_0 -> 21 in the cache */
   /* replace654_0_0 -> 710 in the cache */
   /* replace654_0_1_0 -> 41 in the cache */
   /* replace654_0_1 -> 1969 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 710, 1969 },
      -1,
   } },
   /* replace654_1 -> 708 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1975, 708 },
      -1,
   } },

   /* ('iand', ('feq(is_used_once)', 'a@64', 0.0), ('feq', 'b@64', 0.0)) => ('feq', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search655_0_0 -> 21 in the cache */
   /* search655_0_1 -> 708 in the cache */
   /* search655_0 -> 1966 in the cache */
   /* search655_1_0 -> 41 in the cache */
   /* search655_1_1 -> 708 in the cache */
   /* search655_1 -> 1967 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 1966, 1967 },
      -1,
   } },

   /* replace655_0_0_0 -> 21 in the cache */
   /* replace655_0_0 -> 710 in the cache */
   /* replace655_0_1_0 -> 41 in the cache */
   /* replace655_0_1 -> 1969 in the cache */
   /* replace655_0 -> 1975 in the cache */
   /* replace655_1 -> 708 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1975, 708 },
      -1,
   } },

   /* ('iand', ('fneu(is_used_once)', 'a@64', 0.0), ('fneu', 'b@64', 0.0)) => ('fneu', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0) */
   /* search656_0_0 -> 21 in the cache */
   /* search656_0_1 -> 708 in the cache */
   /* search656_0 -> 1972 in the cache */
   /* search656_1_0 -> 41 in the cache */
   /* search656_1_1 -> 708 in the cache */
   /* search656_1 -> 1973 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 1972, 1973 },
      -1,
   } },

   /* replace656_0_0_0 -> 21 in the cache */
   /* replace656_0_0 -> 710 in the cache */
   /* replace656_0_1_0 -> 41 in the cache */
   /* replace656_0_1 -> 1969 in the cache */
   /* replace656_0 -> 1970 in the cache */
   /* replace656_1 -> 708 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1970, 708 },
      -1,
   } },

   /* ('bcsel@64', ('feq', 'a', 0.0), 1.0, ('i2f64', ('iadd', ('b2i64', ('flt', 0.0, 'a@64')), ('ineg', ('b2i64', ('flt', 'a@64', 0.0)))))) => ('i2f64', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0))))) */
   /* search657_0_0 -> 21 in the cache */
   /* search657_0_1 -> 708 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 21, 708 },
      -1,
   } },
   /* search657_1 -> 629 in the cache */
   /* search657_2_0_0_0_0 -> 708 in the cache */
   /* search657_2_0_0_0_1 -> 21 in the cache */
   /* search657_2_0_0_0 -> 1949 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 1949 },
      -1,
   } },
   /* search657_2_0_1_0_0_0 -> 21 in the cache */
   /* search657_2_0_1_0_0_1 -> 708 in the cache */
   /* search657_2_0_1_0_0 -> 709 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 709 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1983 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 1982, 1984 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 1,
      { 1985 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 1981, 629, 1986 },
      -1,
   } },

   /* replace657_0_0_0_0 -> 21 in the cache */
   /* replace657_0_0_0_1 -> 708 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      nir_op_fge,
      -1, 0,
      { 21, 708 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1988 },
      -1,
   } },
   /* replace657_0_1_0_0_0 -> 21 in the cache */
   /* replace657_0_1_0_0_1 -> 708 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      nir_op_flt,
      -1, 0,
      { 21, 708 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1990 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1991 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 1989, 1992 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 1,
      { 1993 },
      -1,
   } },

   /* ('bcsel', 'a', ('b2f(is_used_once)', 'b@64'), ('b2f', 'c@64')) => ('b2f', ('bcsel', 'a', 'b', 'c')) */
   /* search658_0 -> 767 in the cache */
   /* search658_1_0 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 41 },
      0,
   } },
   /* search658_2_0 -> 617 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 617 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 767, 1995, 1996 },
      -1,
   } },

   /* replace658_0_0 -> 767 in the cache */
   /* replace658_0_1 -> 41 in the cache */
   /* replace658_0_2 -> 617 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 767, 41, 617 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1998 },
      -1,
   } },

   /* ('~i2f64', ('f2i', 'a@64')) => ('ftrunc', 'a') */
   /* search659_0_0 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_f2i,
      -1, 0,
      { 21 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 2000 },
      -1,
   } },

   /* replace659_0 -> 21 in the cache */
   /* replace659 -> 707 in the cache */

   /* ('~f2i64', ('i2f', 'a@64')) => a */
   /* search660_0_0 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_i2f,
      -1, 0,
      { 21 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 2002 },
      -1,
   } },

   /* replace660 -> 21 in the cache */

   /* ('~f2i64', ('u2f', 'a@64')) => a */
   /* search661_0_0 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_u2f,
      -1, 0,
      { 21 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 2004 },
      -1,
   } },

   /* replace661 -> 21 in the cache */

   /* ('~f2u64', ('i2f', 'a@64')) => a */
   /* search662_0_0 -> 21 in the cache */
   /* search662_0 -> 2002 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 2002 },
      -1,
   } },

   /* replace662 -> 21 in the cache */

   /* ('~f2u64', ('u2f', 'a@64')) => a */
   /* search663_0_0 -> 21 in the cache */
   /* search663_0 -> 2004 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 2004 },
      -1,
   } },

   /* replace663 -> 21 in the cache */

   /* ('fadd', ('b2f64', ('flt', 0.0, 'a@64')), ('fneg', ('b2f64', ('flt', 'a@64', 0.0)))) => ('fsign', 'a') */
   /* search664_0_0_0 -> 708 in the cache */
   /* search664_0_0_1 -> 21 in the cache */
   /* search664_0_0 -> 1949 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2f64,
      -1, 0,
      { 1949 },
      -1,
   } },
   /* search664_1_0_0_0 -> 21 in the cache */
   /* search664_1_0_0_1 -> 708 in the cache */
   /* search664_1_0_0 -> 709 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2f64,
      -1, 0,
      { 709 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 2009 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 2008, 2010 },
      -1,
   } },

   /* replace664_0 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fsign,
      -1, 0,
      { 21 },
      -1,
   } },

   /* ('iadd', ('b2i64', ('flt', 0, 'a@64')), ('ineg', ('b2i64', ('flt', 'a@64', 0)))) => ('f2i64', ('fsign', 'a')) */
   /* search665_0_0_0 -> 907 in the cache */
   /* search665_0_0_1 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 907, 21 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 2013 },
      -1,
   } },
   /* search665_1_0_0_0 -> 21 in the cache */
   /* search665_1_0_0_1 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 21, 907 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 2015 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2016 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 2014, 2017 },
      -1,
   } },

   /* replace665_0_0 -> 21 in the cache */
   /* replace665_0 -> 2012 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 2012 },
      -1,
   } },

   /* ('~f2f64', ('f2f', 'a')) => ('f2f64', 'a') */
   /* search666_0_0 -> 32 in the cache */
   /* search666_0 -> 1817 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_f2f64,
      -1, 0,
      { 1817 },
      -1,
   } },

   /* replace666_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2f64,
      -1, 0,
      { 32 },
      -1,
   } },

   /* ('~f2f64', ('u2f', 'a')) => ('u2f64', 'a') */
   /* search667_0_0 -> 32 in the cache */
   /* search667_0 -> 112 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_f2f64,
      -1, 0,
      { 112 },
      -1,
   } },

   /* replace667_0 -> 32 in the cache */
   /* replace667 -> 1846 in the cache */

   /* ('~f2f64', ('i2f', 'a')) => ('i2f64', 'a') */
   /* search668_0_0 -> 32 in the cache */
   /* search668_0 -> 1255 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_f2f64,
      -1, 0,
      { 1255 },
      -1,
   } },

   /* replace668_0 -> 32 in the cache */
   /* replace668 -> 1848 in the cache */

   /* ('~f2u64', ('f2f', 'a')) => ('f2u64', 'a') */
   /* search669_0_0 -> 32 in the cache */
   /* search669_0 -> 1817 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 1817 },
      -1,
   } },

   /* replace669_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 32 },
      -1,
   } },

   /* ('~f2i64', ('f2f', 'a')) => ('f2i64', 'a') */
   /* search670_0_0 -> 32 in the cache */
   /* search670_0 -> 1817 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 1817 },
      -1,
   } },

   /* replace670_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 32 },
      -1,
   } },

   /* ('i2f64', ('f2i', ('fsign', 'a@64'))) => ('fsign', 'a') */
   /* search671_0_0_0 -> 21 in the cache */
   /* search671_0_0 -> 2012 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_f2i,
      -1, 0,
      { 2012 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 2028 },
      -1,
   } },

   /* replace671_0 -> 21 in the cache */
   /* replace671 -> 2012 in the cache */

   /* ('i2i1', ('i2i8', 'a@1')) => a */
   /* search672_0_0 -> 767 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_i2i8,
      -1, 0,
      { 767 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_i2i1,
      -1, 0,
      { 2030 },
      -1,
   } },

   /* replace672 -> 767 in the cache */

   /* ('u2u1', ('u2u8', 'a@1')) => a */
   /* search673_0_0 -> 767 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 0,
      { 767 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_u2u1,
      -1, 0,
      { 2032 },
      -1,
   } },

   /* replace673 -> 767 in the cache */

   /* ('i2i1', ('i2i16', 'a@1')) => a */
   /* search674_0_0 -> 767 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2i16,
      -1, 0,
      { 767 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_i2i1,
      -1, 0,
      { 2034 },
      -1,
   } },

   /* replace674 -> 767 in the cache */

   /* ('u2u1', ('u2u16', 'a@1')) => a */
   /* search675_0_0 -> 767 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 767 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_u2u1,
      -1, 0,
      { 2036 },
      -1,
   } },

   /* replace675 -> 767 in the cache */

   /* ('u2f16', ('u2u8', 'a@1')) => ('u2f16', 'a') */
   /* search676_0_0 -> 767 in the cache */
   /* search676_0 -> 2032 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 2032 },
      -1,
   } },

   /* replace676_0 -> 767 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 767 },
      -1,
   } },

   /* ('i2f16', ('i2i8', 'a@1')) => ('i2f16', 'a') */
   /* search677_0_0 -> 767 in the cache */
   /* search677_0 -> 2030 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 2030 },
      -1,
   } },

   /* replace677_0 -> 767 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 767 },
      -1,
   } },

   /* ('u2f16', ('u2u16', 'a@1')) => ('u2f16', 'a') */
   /* search678_0_0 -> 767 in the cache */
   /* search678_0 -> 2036 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 2036 },
      -1,
   } },

   /* replace678_0 -> 767 in the cache */
   /* replace678 -> 2039 in the cache */

   /* ('i2f16', ('i2i16', 'a@1')) => ('i2f16', 'a') */
   /* search679_0_0 -> 767 in the cache */
   /* search679_0 -> 2034 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 2034 },
      -1,
   } },

   /* replace679_0 -> 767 in the cache */
   /* replace679 -> 2041 in the cache */

   /* ('u2f16', ('u2u32', 'a@1')) => ('u2f16', 'a') */
   /* search680_0_0 -> 767 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2u32,
      -1, 0,
      { 767 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 2044 },
      -1,
   } },

   /* replace680_0 -> 767 in the cache */
   /* replace680 -> 2039 in the cache */

   /* ('i2f16', ('i2i32', 'a@1')) => ('i2f16', 'a') */
   /* search681_0_0 -> 767 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2i32,
      -1, 0,
      { 767 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 2046 },
      -1,
   } },

   /* replace681_0 -> 767 in the cache */
   /* replace681 -> 2041 in the cache */

   /* ('u2f16', ('u2u64', 'a@1')) => ('u2f16', 'a') */
   /* search682_0_0 -> 767 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2u64,
      -1, 0,
      { 767 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 2048 },
      -1,
   } },

   /* replace682_0 -> 767 in the cache */
   /* replace682 -> 2039 in the cache */

   /* ('i2f16', ('i2i64', 'a@1')) => ('i2f16', 'a') */
   /* search683_0_0 -> 767 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2i64,
      -1, 0,
      { 767 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 2050 },
      -1,
   } },

   /* replace683_0 -> 767 in the cache */
   /* replace683 -> 2041 in the cache */

   /* ('i2i1', ('i2i32', 'a@1')) => a */
   /* search684_0_0 -> 767 in the cache */
   /* search684_0 -> 2046 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_i2i1,
      -1, 0,
      { 2046 },
      -1,
   } },

   /* replace684 -> 767 in the cache */

   /* ('u2u1', ('u2u32', 'a@1')) => a */
   /* search685_0_0 -> 767 in the cache */
   /* search685_0 -> 2044 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_u2u1,
      -1, 0,
      { 2044 },
      -1,
   } },

   /* replace685 -> 767 in the cache */

   /* ('u2f32', ('u2u8', 'a@1')) => ('u2f32', 'a') */
   /* search686_0_0 -> 767 in the cache */
   /* search686_0 -> 2032 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 2032 },
      -1,
   } },

   /* replace686_0 -> 767 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 767 },
      -1,
   } },

   /* ('i2f32', ('i2i8', 'a@1')) => ('i2f32', 'a') */
   /* search687_0_0 -> 767 in the cache */
   /* search687_0 -> 2030 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 2030 },
      -1,
   } },

   /* replace687_0 -> 767 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 767 },
      -1,
   } },

   /* ('u2f32', ('u2u16', 'a@1')) => ('u2f32', 'a') */
   /* search688_0_0 -> 767 in the cache */
   /* search688_0 -> 2036 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 2036 },
      -1,
   } },

   /* replace688_0 -> 767 in the cache */
   /* replace688 -> 2055 in the cache */

   /* ('i2f32', ('i2i16', 'a@1')) => ('i2f32', 'a') */
   /* search689_0_0 -> 767 in the cache */
   /* search689_0 -> 2034 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 2034 },
      -1,
   } },

   /* replace689_0 -> 767 in the cache */
   /* replace689 -> 2057 in the cache */

   /* ('u2f32', ('u2u32', 'a@1')) => ('u2f32', 'a') */
   /* search690_0_0 -> 767 in the cache */
   /* search690_0 -> 2044 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 2044 },
      -1,
   } },

   /* replace690_0 -> 767 in the cache */
   /* replace690 -> 2055 in the cache */

   /* ('i2f32', ('i2i32', 'a@1')) => ('i2f32', 'a') */
   /* search691_0_0 -> 767 in the cache */
   /* search691_0 -> 2046 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 2046 },
      -1,
   } },

   /* replace691_0 -> 767 in the cache */
   /* replace691 -> 2057 in the cache */

   /* ('u2f32', ('u2u64', 'a@1')) => ('u2f32', 'a') */
   /* search692_0_0 -> 767 in the cache */
   /* search692_0 -> 2048 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 2048 },
      -1,
   } },

   /* replace692_0 -> 767 in the cache */
   /* replace692 -> 2055 in the cache */

   /* ('i2f32', ('i2i64', 'a@1')) => ('i2f32', 'a') */
   /* search693_0_0 -> 767 in the cache */
   /* search693_0 -> 2050 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 2050 },
      -1,
   } },

   /* replace693_0 -> 767 in the cache */
   /* replace693 -> 2057 in the cache */

   /* ('i2i1', ('i2i64', 'a@1')) => a */
   /* search694_0_0 -> 767 in the cache */
   /* search694_0 -> 2050 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_i2i1,
      -1, 0,
      { 2050 },
      -1,
   } },

   /* replace694 -> 767 in the cache */

   /* ('u2u1', ('u2u64', 'a@1')) => a */
   /* search695_0_0 -> 767 in the cache */
   /* search695_0 -> 2048 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_u2u1,
      -1, 0,
      { 2048 },
      -1,
   } },

   /* replace695 -> 767 in the cache */

   /* ('u2f64', ('u2u8', 'a@1')) => ('u2f64', 'a') */
   /* search696_0_0 -> 767 in the cache */
   /* search696_0 -> 2032 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 2032 },
      -1,
   } },

   /* replace696_0 -> 767 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 767 },
      -1,
   } },

   /* ('i2f64', ('i2i8', 'a@1')) => ('i2f64', 'a') */
   /* search697_0_0 -> 767 in the cache */
   /* search697_0 -> 2030 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 2030 },
      -1,
   } },

   /* replace697_0 -> 767 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 767 },
      -1,
   } },

   /* ('u2f64', ('u2u16', 'a@1')) => ('u2f64', 'a') */
   /* search698_0_0 -> 767 in the cache */
   /* search698_0 -> 2036 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 2036 },
      -1,
   } },

   /* replace698_0 -> 767 in the cache */
   /* replace698 -> 2067 in the cache */

   /* ('i2f64', ('i2i16', 'a@1')) => ('i2f64', 'a') */
   /* search699_0_0 -> 767 in the cache */
   /* search699_0 -> 2034 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 2034 },
      -1,
   } },

   /* replace699_0 -> 767 in the cache */
   /* replace699 -> 2069 in the cache */

   /* ('u2f64', ('u2u32', 'a@1')) => ('u2f64', 'a') */
   /* search700_0_0 -> 767 in the cache */
   /* search700_0 -> 2044 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 2044 },
      -1,
   } },

   /* replace700_0 -> 767 in the cache */
   /* replace700 -> 2067 in the cache */

   /* ('i2f64', ('i2i32', 'a@1')) => ('i2f64', 'a') */
   /* search701_0_0 -> 767 in the cache */
   /* search701_0 -> 2046 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 2046 },
      -1,
   } },

   /* replace701_0 -> 767 in the cache */
   /* replace701 -> 2069 in the cache */

   /* ('u2f64', ('u2u64', 'a@1')) => ('u2f64', 'a') */
   /* search702_0_0 -> 767 in the cache */
   /* search702_0 -> 2048 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 2048 },
      -1,
   } },

   /* replace702_0 -> 767 in the cache */
   /* replace702 -> 2067 in the cache */

   /* ('i2f64', ('i2i64', 'a@1')) => ('i2f64', 'a') */
   /* search703_0_0 -> 767 in the cache */
   /* search703_0 -> 2050 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 2050 },
      -1,
   } },

   /* replace703_0 -> 767 in the cache */
   /* replace703 -> 2069 in the cache */

   /* ('i2i8', ('i2i16', 'a@8')) => a */
   /* search704_0_0 -> 6 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2i16,
      -1, 0,
      { 6 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_i2i8,
      -1, 0,
      { 2076 },
      -1,
   } },

   /* replace704 -> 6 in the cache */

   /* ('u2u8', ('u2u16', 'a@8')) => a */
   /* search705_0_0 -> 6 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 6 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 0,
      { 2078 },
      -1,
   } },

   /* replace705 -> 6 in the cache */

   /* ('u2f16', ('u2u16', 'a@8')) => ('u2f16', 'a') */
   /* search706_0_0 -> 6 in the cache */
   /* search706_0 -> 2078 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 2078 },
      -1,
   } },

   /* replace706_0 -> 6 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 6 },
      -1,
   } },

   /* ('i2f16', ('i2i16', 'a@8')) => ('i2f16', 'a') */
   /* search707_0_0 -> 6 in the cache */
   /* search707_0 -> 2076 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 2076 },
      -1,
   } },

   /* replace707_0 -> 6 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 6 },
      -1,
   } },

   /* ('u2f16', ('u2u32', 'a@8')) => ('u2f16', 'a') */
   /* search708_0_0 -> 6 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2u32,
      -1, 0,
      { 6 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 2084 },
      -1,
   } },

   /* replace708_0 -> 6 in the cache */
   /* replace708 -> 2081 in the cache */

   /* ('i2f16', ('i2i32', 'a@8')) => ('i2f16', 'a') */
   /* search709_0_0 -> 6 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2i32,
      -1, 0,
      { 6 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 2086 },
      -1,
   } },

   /* replace709_0 -> 6 in the cache */
   /* replace709 -> 2083 in the cache */

   /* ('u2f16', ('u2u64', 'a@8')) => ('u2f16', 'a') */
   /* search710_0_0 -> 6 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2u64,
      -1, 0,
      { 6 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 2088 },
      -1,
   } },

   /* replace710_0 -> 6 in the cache */
   /* replace710 -> 2081 in the cache */

   /* ('i2f16', ('i2i64', 'a@8')) => ('i2f16', 'a') */
   /* search711_0_0 -> 6 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2i64,
      -1, 0,
      { 6 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 2090 },
      -1,
   } },

   /* replace711_0 -> 6 in the cache */
   /* replace711 -> 2083 in the cache */

   /* ('i2i8', ('i2i32', 'a@8')) => a */
   /* search712_0_0 -> 6 in the cache */
   /* search712_0 -> 2086 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_i2i8,
      -1, 0,
      { 2086 },
      -1,
   } },

   /* replace712 -> 6 in the cache */

   /* ('u2u8', ('u2u32', 'a@8')) => a */
   /* search713_0_0 -> 6 in the cache */
   /* search713_0 -> 2084 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 0,
      { 2084 },
      -1,
   } },

   /* replace713 -> 6 in the cache */

   /* ('u2f32', ('u2u16', 'a@8')) => ('u2f32', 'a') */
   /* search714_0_0 -> 6 in the cache */
   /* search714_0 -> 2078 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 2078 },
      -1,
   } },

   /* replace714_0 -> 6 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 6 },
      -1,
   } },

   /* ('i2f32', ('i2i16', 'a@8')) => ('i2f32', 'a') */
   /* search715_0_0 -> 6 in the cache */
   /* search715_0 -> 2076 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 2076 },
      -1,
   } },

   /* replace715_0 -> 6 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 6 },
      -1,
   } },

   /* ('u2f32', ('u2u32', 'a@8')) => ('u2f32', 'a') */
   /* search716_0_0 -> 6 in the cache */
   /* search716_0 -> 2084 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 2084 },
      -1,
   } },

   /* replace716_0 -> 6 in the cache */
   /* replace716 -> 2095 in the cache */

   /* ('i2f32', ('i2i32', 'a@8')) => ('i2f32', 'a') */
   /* search717_0_0 -> 6 in the cache */
   /* search717_0 -> 2086 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 2086 },
      -1,
   } },

   /* replace717_0 -> 6 in the cache */
   /* replace717 -> 2097 in the cache */

   /* ('u2f32', ('u2u64', 'a@8')) => ('u2f32', 'a') */
   /* search718_0_0 -> 6 in the cache */
   /* search718_0 -> 2088 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 2088 },
      -1,
   } },

   /* replace718_0 -> 6 in the cache */
   /* replace718 -> 2095 in the cache */

   /* ('i2f32', ('i2i64', 'a@8')) => ('i2f32', 'a') */
   /* search719_0_0 -> 6 in the cache */
   /* search719_0 -> 2090 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 2090 },
      -1,
   } },

   /* replace719_0 -> 6 in the cache */
   /* replace719 -> 2097 in the cache */

   /* ('i2i8', ('i2i64', 'a@8')) => a */
   /* search720_0_0 -> 6 in the cache */
   /* search720_0 -> 2090 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_i2i8,
      -1, 0,
      { 2090 },
      -1,
   } },

   /* replace720 -> 6 in the cache */

   /* ('u2u8', ('u2u64', 'a@8')) => a */
   /* search721_0_0 -> 6 in the cache */
   /* search721_0 -> 2088 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 0,
      { 2088 },
      -1,
   } },

   /* replace721 -> 6 in the cache */

   /* ('u2f64', ('u2u16', 'a@8')) => ('u2f64', 'a') */
   /* search722_0_0 -> 6 in the cache */
   /* search722_0 -> 2078 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 2078 },
      -1,
   } },

   /* replace722_0 -> 6 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 6 },
      -1,
   } },

   /* ('i2f64', ('i2i16', 'a@8')) => ('i2f64', 'a') */
   /* search723_0_0 -> 6 in the cache */
   /* search723_0 -> 2076 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 2076 },
      -1,
   } },

   /* replace723_0 -> 6 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 6 },
      -1,
   } },

   /* ('u2f64', ('u2u32', 'a@8')) => ('u2f64', 'a') */
   /* search724_0_0 -> 6 in the cache */
   /* search724_0 -> 2084 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 2084 },
      -1,
   } },

   /* replace724_0 -> 6 in the cache */
   /* replace724 -> 2105 in the cache */

   /* ('i2f64', ('i2i32', 'a@8')) => ('i2f64', 'a') */
   /* search725_0_0 -> 6 in the cache */
   /* search725_0 -> 2086 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 2086 },
      -1,
   } },

   /* replace725_0 -> 6 in the cache */
   /* replace725 -> 2107 in the cache */

   /* ('u2f64', ('u2u64', 'a@8')) => ('u2f64', 'a') */
   /* search726_0_0 -> 6 in the cache */
   /* search726_0 -> 2088 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 2088 },
      -1,
   } },

   /* replace726_0 -> 6 in the cache */
   /* replace726 -> 2105 in the cache */

   /* ('i2f64', ('i2i64', 'a@8')) => ('i2f64', 'a') */
   /* search727_0_0 -> 6 in the cache */
   /* search727_0 -> 2090 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 2090 },
      -1,
   } },

   /* replace727_0 -> 6 in the cache */
   /* replace727 -> 2107 in the cache */

   /* ('i2i16', ('i2i32', 'a@16')) => a */
   /* search728_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2i32,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2i16,
      -1, 0,
      { 2112 },
      -1,
   } },

   /* replace728 -> 11 in the cache */

   /* ('u2u16', ('u2u32', 'a@16')) => a */
   /* search729_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2u32,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 2114 },
      -1,
   } },

   /* replace729 -> 11 in the cache */

   /* ('u2f32', ('u2u32', 'a@16')) => ('u2f32', 'a') */
   /* search730_0_0 -> 11 in the cache */
   /* search730_0 -> 2114 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 2114 },
      -1,
   } },

   /* replace730_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('i2f32', ('i2i32', 'a@16')) => ('i2f32', 'a') */
   /* search731_0_0 -> 11 in the cache */
   /* search731_0 -> 2112 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 2112 },
      -1,
   } },

   /* replace731_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('u2f32', ('u2u64', 'a@16')) => ('u2f32', 'a') */
   /* search732_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2u64,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 2120 },
      -1,
   } },

   /* replace732_0 -> 11 in the cache */
   /* replace732 -> 2117 in the cache */

   /* ('i2f32', ('i2i64', 'a@16')) => ('i2f32', 'a') */
   /* search733_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2i64,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 2122 },
      -1,
   } },

   /* replace733_0 -> 11 in the cache */
   /* replace733 -> 2119 in the cache */

   /* ('i2i16', ('i2i64', 'a@16')) => a */
   /* search734_0_0 -> 11 in the cache */
   /* search734_0 -> 2122 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2i16,
      -1, 0,
      { 2122 },
      -1,
   } },

   /* replace734 -> 11 in the cache */

   /* ('u2u16', ('u2u64', 'a@16')) => a */
   /* search735_0_0 -> 11 in the cache */
   /* search735_0 -> 2120 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 2120 },
      -1,
   } },

   /* replace735 -> 11 in the cache */

   /* ('u2f64', ('u2u32', 'a@16')) => ('u2f64', 'a') */
   /* search736_0_0 -> 11 in the cache */
   /* search736_0 -> 2114 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 2114 },
      -1,
   } },

   /* replace736_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('i2f64', ('i2i32', 'a@16')) => ('i2f64', 'a') */
   /* search737_0_0 -> 11 in the cache */
   /* search737_0 -> 2112 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 2112 },
      -1,
   } },

   /* replace737_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('u2f64', ('u2u64', 'a@16')) => ('u2f64', 'a') */
   /* search738_0_0 -> 11 in the cache */
   /* search738_0 -> 2120 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 2120 },
      -1,
   } },

   /* replace738_0 -> 11 in the cache */
   /* replace738 -> 2127 in the cache */

   /* ('i2f64', ('i2i64', 'a@16')) => ('i2f64', 'a') */
   /* search739_0_0 -> 11 in the cache */
   /* search739_0 -> 2122 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 2122 },
      -1,
   } },

   /* replace739_0 -> 11 in the cache */
   /* replace739 -> 2129 in the cache */

   /* ('i2i32', ('i2i64', 'a@32')) => a */
   /* search740_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2i64,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2i32,
      -1, 0,
      { 2132 },
      -1,
   } },

   /* replace740 -> 16 in the cache */

   /* ('u2u32', ('u2u64', 'a@32')) => a */
   /* search741_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2u64,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2u32,
      -1, 0,
      { 2134 },
      -1,
   } },

   /* replace741 -> 16 in the cache */

   /* ('u2f64', ('u2u64', 'a@32')) => ('u2f64', 'a') */
   /* search742_0_0 -> 16 in the cache */
   /* search742_0 -> 2134 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 2134 },
      -1,
   } },

   /* replace742_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('i2f64', ('i2i64', 'a@32')) => ('i2f64', 'a') */
   /* search743_0_0 -> 16 in the cache */
   /* search743_0 -> 2132 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 2132 },
      -1,
   } },

   /* replace743_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('f2fmp', ('u2f32', 'a@32')) => ('u2fmp', 'a') */
   /* search744_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2fmp,
      -1, 0,
      { 2140 },
      -1,
   } },

   /* replace744_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2fmp,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('f2fmp', ('i2f32', 'a@32')) => ('i2fmp', 'a') */
   /* search745_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2fmp,
      -1, 0,
      { 2143 },
      -1,
   } },

   /* replace745_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2fmp,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('f2u16', ('f2fmp', 'a@32')) => ('f2u16', 'a') */
   /* search746_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2fmp,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2u16,
      -1, 0,
      { 2146 },
      -1,
   } },

   /* replace746_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2u16,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('f2i16', ('f2fmp', 'a@32')) => ('f2i16', 'a') */
   /* search747_0_0 -> 16 in the cache */
   /* search747_0 -> 2146 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 2146 },
      -1,
   } },

   /* replace747_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('i2imp', ('f2u32', 'a@32')) => ('f2ump', 'a') */
   /* search748_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2imp,
      -1, 0,
      { 2151 },
      -1,
   } },

   /* replace748_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2ump,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('i2imp', ('f2i32', 'a@32')) => ('f2imp', 'a') */
   /* search749_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2imp,
      -1, 0,
      { 2154 },
      -1,
   } },

   /* replace749_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2imp,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('u2f16', ('i2imp', 'a@32')) => ('u2f16', 'a') */
   /* search750_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2imp,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 2157 },
      -1,
   } },

   /* replace750_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('i2f16', ('i2imp', 'a@32')) => ('i2f16', 'a') */
   /* search751_0_0 -> 16 in the cache */
   /* search751_0 -> 2157 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 2157 },
      -1,
   } },

   /* replace751_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('iand', ('u2u16', ('u2u8', 'a@16')), '#b') => ('iand', 'a', ('iand', 'b', 255)) */
   /* search752_0_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 2162 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 16 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2163, 2164 },
      -1,
   } },

   /* replace752_0 -> 11 in the cache */
   /* replace752_1_0 -> 268 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0xff /* 255 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 268, 2166 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 11, 2167 },
      -1,
   } },

   /* ('u2u16', ('u2u8(is_used_once)', ('iand', 'a@16', '#b'))) => ('iand', 'a', ('iand', 'b', 255)) */
   /* search753_0_0_0 -> 11 in the cache */
   /* search753_0_0_1 -> 2164 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 11, 2164 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2169 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 1,
      { 2170 },
      -1,
   } },

   /* replace753_0 -> 11 in the cache */
   /* replace753_1_0 -> 268 in the cache */
   /* replace753_1_1 -> 2166 in the cache */
   /* replace753_1 -> 2167 in the cache */
   /* replace753 -> 2168 in the cache */

   /* ('u2u8', ('iand', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('iand', 'a', 'b')) */
   /* search754_0_0_0_0 -> 11 in the cache */
   /* search754_0_0_0 -> 2162 in the cache */
   /* search754_0_0 -> 2163 in the cache */
   /* search754_0_1_0_0 -> 268 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 0,
      { 268 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 2172 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2163, 2173 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2174 },
      -1,
   } },

   /* replace754_0_0 -> 11 in the cache */
   /* replace754_0_1 -> 268 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 11, 268 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2176 },
      -1,
   } },

   /* ('u2u8', ('iand', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('iand', 'a', 'b')) */
   /* search755_0_0_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 2178 },
      -1,
   } },
   /* search755_0_1_0_0 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 0,
      { 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 2180 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2179, 2181 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2182 },
      -1,
   } },

   /* replace755_0_0 -> 16 in the cache */
   /* replace755_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 16, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2184 },
      -1,
   } },

   /* ('iand', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('iand', 'a', 'c'), 'b') */
   /* search756_0_0 -> 0 in the cache */
   /* search756_0_1 -> 831 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 0, 831 },
      -1,
   } },
   /* search756_1_0 -> 146 in the cache */
   /* search756_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 146, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2186, 2187 },
      -1,
   } },

   /* replace756_0_0 -> 0 in the cache */
   /* replace756_0_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 0, 146 },
      -1,
   } },
   /* replace756_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 1,
      { 2189, 3 },
      -1,
   } },

   /* ('iand', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('iand', 'a', 'c'), 'b') */
   /* search757_0_0 -> 0 in the cache */
   /* search757_0_1 -> 831 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 0, 831 },
      -1,
   } },
   /* search757_1_0 -> 146 in the cache */
   /* search757_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 146, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2191, 2192 },
      -1,
   } },

   /* replace757_0_0 -> 0 in the cache */
   /* replace757_0_1 -> 146 in the cache */
   /* replace757_0 -> 2189 in the cache */
   /* replace757_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 1,
      { 2189, 3 },
      -1,
   } },

   /* ('iand', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('iand', 'a', 'c'), 'b') */
   /* search758_0_0 -> 0 in the cache */
   /* search758_0_1 -> 831 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 0,
      { 0, 831 },
      -1,
   } },
   /* search758_1_0 -> 146 in the cache */
   /* search758_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 0,
      { 146, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2195, 2196 },
      -1,
   } },

   /* replace758_0_0 -> 0 in the cache */
   /* replace758_0_1 -> 146 in the cache */
   /* replace758_0 -> 2189 in the cache */
   /* replace758_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 1,
      { 2189, 3 },
      -1,
   } },

   /* ('iand', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('iand', 'a', 'c'), 'b') */
   /* search759_0_0 -> 0 in the cache */
   /* search759_0_1 -> 831 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 0,
      { 0, 831 },
      -1,
   } },
   /* search759_1_0 -> 146 in the cache */
   /* search759_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 0,
      { 146, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2199, 2200 },
      -1,
   } },

   /* replace759_0_0 -> 0 in the cache */
   /* replace759_0_1 -> 146 in the cache */
   /* replace759_0 -> 2189 in the cache */
   /* replace759_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 1,
      { 2189, 3 },
      -1,
   } },

   /* ('iand', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('iand', 'a', 'c'), 'b') */
   /* search760_0_0 -> 132 in the cache */
   /* search760_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 132, 33 },
      0,
   } },
   /* search760_1_0 -> 135 in the cache */
   /* search760_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 135, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2203, 2204 },
      -1,
   } },

   /* replace760_0_0 -> 132 in the cache */
   /* replace760_0_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 132, 135 },
      -1,
   } },
   /* replace760_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 2206, 36 },
      -1,
   } },

   /* ('iand', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('iand', 'a', 'c'), 'b') */
   /* search761_0_0 -> 132 in the cache */
   /* search761_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 132, 33 },
      0,
   } },
   /* search761_1_0 -> 135 in the cache */
   /* search761_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 135, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2208, 2209 },
      -1,
   } },

   /* replace761_0_0 -> 132 in the cache */
   /* replace761_0_1 -> 135 in the cache */
   /* replace761_0 -> 2206 in the cache */
   /* replace761_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 1,
      { 2206, 36 },
      -1,
   } },

   /* ('iand', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('iand', 'a', 'c'), 'b') */
   /* search762_0_0 -> 132 in the cache */
   /* search762_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 132, 33 },
      0,
   } },
   /* search762_1_0 -> 135 in the cache */
   /* search762_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 135, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2212, 2213 },
      -1,
   } },

   /* replace762_0_0 -> 132 in the cache */
   /* replace762_0_1 -> 135 in the cache */
   /* replace762_0 -> 2206 in the cache */
   /* replace762_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 2206, 36 },
      -1,
   } },

   /* ('u2u8', ('ior', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('ior', 'a', 'b')) */
   /* search763_0_0_0_0 -> 11 in the cache */
   /* search763_0_0_0 -> 2162 in the cache */
   /* search763_0_0 -> 2163 in the cache */
   /* search763_0_1_0_0 -> 268 in the cache */
   /* search763_0_1_0 -> 2172 in the cache */
   /* search763_0_1 -> 2173 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2163, 2173 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2216 },
      -1,
   } },

   /* replace763_0_0 -> 11 in the cache */
   /* replace763_0_1 -> 268 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 11, 268 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2218 },
      -1,
   } },

   /* ('u2u8', ('ior', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('ior', 'a', 'b')) */
   /* search764_0_0_0_0 -> 16 in the cache */
   /* search764_0_0_0 -> 2178 in the cache */
   /* search764_0_0 -> 2179 in the cache */
   /* search764_0_1_0_0 -> 36 in the cache */
   /* search764_0_1_0 -> 2180 in the cache */
   /* search764_0_1 -> 2181 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2179, 2181 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2220 },
      -1,
   } },

   /* replace764_0_0 -> 16 in the cache */
   /* replace764_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 16, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2222 },
      -1,
   } },

   /* ('ior', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('ior', 'a', 'c'), 'b') */
   /* search765_0_0 -> 0 in the cache */
   /* search765_0_1 -> 831 in the cache */
   /* search765_0 -> 2186 in the cache */
   /* search765_1_0 -> 146 in the cache */
   /* search765_1_1 -> 3 in the cache */
   /* search765_1 -> 2187 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2186, 2187 },
      -1,
   } },

   /* replace765_0_0 -> 0 in the cache */
   /* replace765_0_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 0, 146 },
      -1,
   } },
   /* replace765_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 1,
      { 2225, 3 },
      -1,
   } },

   /* ('ior', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('ior', 'a', 'c'), 'b') */
   /* search766_0_0 -> 0 in the cache */
   /* search766_0_1 -> 831 in the cache */
   /* search766_0 -> 2191 in the cache */
   /* search766_1_0 -> 146 in the cache */
   /* search766_1_1 -> 3 in the cache */
   /* search766_1 -> 2192 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2191, 2192 },
      -1,
   } },

   /* replace766_0_0 -> 0 in the cache */
   /* replace766_0_1 -> 146 in the cache */
   /* replace766_0 -> 2225 in the cache */
   /* replace766_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 1,
      { 2225, 3 },
      -1,
   } },

   /* ('ior', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('ior', 'a', 'c'), 'b') */
   /* search767_0_0 -> 0 in the cache */
   /* search767_0_1 -> 831 in the cache */
   /* search767_0 -> 2195 in the cache */
   /* search767_1_0 -> 146 in the cache */
   /* search767_1_1 -> 3 in the cache */
   /* search767_1 -> 2196 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2195, 2196 },
      -1,
   } },

   /* replace767_0_0 -> 0 in the cache */
   /* replace767_0_1 -> 146 in the cache */
   /* replace767_0 -> 2225 in the cache */
   /* replace767_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 1,
      { 2225, 3 },
      -1,
   } },

   /* ('ior', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('ior', 'a', 'c'), 'b') */
   /* search768_0_0 -> 0 in the cache */
   /* search768_0_1 -> 831 in the cache */
   /* search768_0 -> 2199 in the cache */
   /* search768_1_0 -> 146 in the cache */
   /* search768_1_1 -> 3 in the cache */
   /* search768_1 -> 2200 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2199, 2200 },
      -1,
   } },

   /* replace768_0_0 -> 0 in the cache */
   /* replace768_0_1 -> 146 in the cache */
   /* replace768_0 -> 2225 in the cache */
   /* replace768_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 1,
      { 2225, 3 },
      -1,
   } },

   /* ('ior', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('ior', 'a', 'c'), 'b') */
   /* search769_0_0 -> 132 in the cache */
   /* search769_0_1 -> 33 in the cache */
   /* search769_0 -> 2203 in the cache */
   /* search769_1_0 -> 135 in the cache */
   /* search769_1_1 -> 36 in the cache */
   /* search769_1 -> 2204 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2203, 2204 },
      -1,
   } },

   /* replace769_0_0 -> 132 in the cache */
   /* replace769_0_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 132, 135 },
      -1,
   } },
   /* replace769_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 2234, 36 },
      -1,
   } },

   /* ('ior', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('ior', 'a', 'c'), 'b') */
   /* search770_0_0 -> 132 in the cache */
   /* search770_0_1 -> 33 in the cache */
   /* search770_0 -> 2208 in the cache */
   /* search770_1_0 -> 135 in the cache */
   /* search770_1_1 -> 36 in the cache */
   /* search770_1 -> 2209 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2208, 2209 },
      -1,
   } },

   /* replace770_0_0 -> 132 in the cache */
   /* replace770_0_1 -> 135 in the cache */
   /* replace770_0 -> 2234 in the cache */
   /* replace770_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 1,
      { 2234, 36 },
      -1,
   } },

   /* ('ior', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('ior', 'a', 'c'), 'b') */
   /* search771_0_0 -> 132 in the cache */
   /* search771_0_1 -> 33 in the cache */
   /* search771_0 -> 2212 in the cache */
   /* search771_1_0 -> 135 in the cache */
   /* search771_1_1 -> 36 in the cache */
   /* search771_1 -> 2213 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2212, 2213 },
      -1,
   } },

   /* replace771_0_0 -> 132 in the cache */
   /* replace771_0_1 -> 135 in the cache */
   /* replace771_0 -> 2234 in the cache */
   /* replace771_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 2234, 36 },
      -1,
   } },

   /* ('u2u8', ('ixor', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('ixor', 'a', 'b')) */
   /* search772_0_0_0_0 -> 11 in the cache */
   /* search772_0_0_0 -> 2162 in the cache */
   /* search772_0_0 -> 2163 in the cache */
   /* search772_0_1_0_0 -> 268 in the cache */
   /* search772_0_1_0 -> 2172 in the cache */
   /* search772_0_1 -> 2173 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 2163, 2173 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2240 },
      -1,
   } },

   /* replace772_0_0 -> 11 in the cache */
   /* replace772_0_1 -> 268 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 11, 268 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2242 },
      -1,
   } },

   /* ('u2u8', ('ixor', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('ixor', 'a', 'b')) */
   /* search773_0_0_0_0 -> 16 in the cache */
   /* search773_0_0_0 -> 2178 in the cache */
   /* search773_0_0 -> 2179 in the cache */
   /* search773_0_1_0_0 -> 36 in the cache */
   /* search773_0_1_0 -> 2180 in the cache */
   /* search773_0_1 -> 2181 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 2179, 2181 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2244 },
      -1,
   } },

   /* replace773_0_0 -> 16 in the cache */
   /* replace773_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 16, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2246 },
      -1,
   } },

   /* ('ixor', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('ixor', 'a', 'c'), 'b') */
   /* search774_0_0 -> 0 in the cache */
   /* search774_0_1 -> 831 in the cache */
   /* search774_0 -> 2186 in the cache */
   /* search774_1_0 -> 146 in the cache */
   /* search774_1_1 -> 3 in the cache */
   /* search774_1 -> 2187 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 2186, 2187 },
      -1,
   } },

   /* replace774_0_0 -> 0 in the cache */
   /* replace774_0_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 0, 146 },
      -1,
   } },
   /* replace774_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 1,
      { 2249, 3 },
      -1,
   } },

   /* ('ixor', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('ixor', 'a', 'c'), 'b') */
   /* search775_0_0 -> 0 in the cache */
   /* search775_0_1 -> 831 in the cache */
   /* search775_0 -> 2191 in the cache */
   /* search775_1_0 -> 146 in the cache */
   /* search775_1_1 -> 3 in the cache */
   /* search775_1 -> 2192 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 2191, 2192 },
      -1,
   } },

   /* replace775_0_0 -> 0 in the cache */
   /* replace775_0_1 -> 146 in the cache */
   /* replace775_0 -> 2249 in the cache */
   /* replace775_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 1,
      { 2249, 3 },
      -1,
   } },

   /* ('ixor', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('ixor', 'a', 'c'), 'b') */
   /* search776_0_0 -> 0 in the cache */
   /* search776_0_1 -> 831 in the cache */
   /* search776_0 -> 2195 in the cache */
   /* search776_1_0 -> 146 in the cache */
   /* search776_1_1 -> 3 in the cache */
   /* search776_1 -> 2196 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 2195, 2196 },
      -1,
   } },

   /* replace776_0_0 -> 0 in the cache */
   /* replace776_0_1 -> 146 in the cache */
   /* replace776_0 -> 2249 in the cache */
   /* replace776_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 1,
      { 2249, 3 },
      -1,
   } },

   /* ('ixor', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('ixor', 'a', 'c'), 'b') */
   /* search777_0_0 -> 0 in the cache */
   /* search777_0_1 -> 831 in the cache */
   /* search777_0 -> 2199 in the cache */
   /* search777_1_0 -> 146 in the cache */
   /* search777_1_1 -> 3 in the cache */
   /* search777_1 -> 2200 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 2199, 2200 },
      -1,
   } },

   /* replace777_0_0 -> 0 in the cache */
   /* replace777_0_1 -> 146 in the cache */
   /* replace777_0 -> 2249 in the cache */
   /* replace777_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 1,
      { 2249, 3 },
      -1,
   } },

   /* ('ixor', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('ixor', 'a', 'c'), 'b') */
   /* search778_0_0 -> 132 in the cache */
   /* search778_0_1 -> 33 in the cache */
   /* search778_0 -> 2203 in the cache */
   /* search778_1_0 -> 135 in the cache */
   /* search778_1_1 -> 36 in the cache */
   /* search778_1 -> 2204 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 2203, 2204 },
      -1,
   } },

   /* replace778_0_0 -> 132 in the cache */
   /* replace778_0_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 132, 135 },
      -1,
   } },
   /* replace778_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 2258, 36 },
      -1,
   } },

   /* ('ixor', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('ixor', 'a', 'c'), 'b') */
   /* search779_0_0 -> 132 in the cache */
   /* search779_0_1 -> 33 in the cache */
   /* search779_0 -> 2208 in the cache */
   /* search779_1_0 -> 135 in the cache */
   /* search779_1_1 -> 36 in the cache */
   /* search779_1 -> 2209 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 2208, 2209 },
      -1,
   } },

   /* replace779_0_0 -> 132 in the cache */
   /* replace779_0_1 -> 135 in the cache */
   /* replace779_0 -> 2258 in the cache */
   /* replace779_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 1,
      { 2258, 36 },
      -1,
   } },

   /* ('ixor', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('ixor', 'a', 'c'), 'b') */
   /* search780_0_0 -> 132 in the cache */
   /* search780_0_1 -> 33 in the cache */
   /* search780_0 -> 2212 in the cache */
   /* search780_1_0 -> 135 in the cache */
   /* search780_1_1 -> 36 in the cache */
   /* search780_1 -> 2213 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 2212, 2213 },
      -1,
   } },

   /* replace780_0_0 -> 132 in the cache */
   /* replace780_0_1 -> 135 in the cache */
   /* replace780_0 -> 2258 in the cache */
   /* replace780_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 2258, 36 },
      -1,
   } },

   /* ('iand', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('ior', 'a', 'b'), 0) */
   /* search781_0_0 -> 6 in the cache */
   /* search781_0_1 -> 845 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 6, 845 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 8 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search781_1_1 -> 845 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      2, 1,
      { 2265, 845 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2264, 2266 },
      -1,
   } },

   /* replace781_0_0 -> 6 in the cache */
   /* replace781_0_1 -> 2265 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 6, 2265 },
      -1,
   } },
   /* replace781_1 -> 845 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2268, 845 },
      -1,
   } },

   /* ('ior', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('ior', 'a', 'b'), 0) */
   /* search782_0_0 -> 6 in the cache */
   /* search782_0_1 -> 845 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      1, 1,
      { 6, 845 },
      -1,
   } },
   /* search782_1_0 -> 2265 in the cache */
   /* search782_1_1 -> 845 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      2, 1,
      { 2265, 845 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2270, 2271 },
      -1,
   } },

   /* replace782_0_0 -> 6 in the cache */
   /* replace782_0_1 -> 2265 in the cache */
   /* replace782_0 -> 2268 in the cache */
   /* replace782_1 -> 845 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2268, 845 },
      -1,
   } },

   /* ('iand', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('umax', 'a', 'b'), 0) */
   /* search783_0_0 -> 6 in the cache */
   /* search783_0_1 -> 845 in the cache */
   /* search783_0 -> 2264 in the cache */
   /* search783_1_0 -> 2265 in the cache */
   /* search783_1_1 -> 845 in the cache */
   /* search783_1 -> 2266 in the cache */
   /* search783 -> 2267 in the cache */

   /* replace783_0_0 -> 6 in the cache */
   /* replace783_0_1 -> 2265 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_umax,
      1, 1,
      { 6, 2265 },
      -1,
   } },
   /* replace783_1 -> 845 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2274, 845 },
      -1,
   } },

   /* ('ior', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('umin', 'a', 'b'), 0) */
   /* search784_0_0 -> 6 in the cache */
   /* search784_0_1 -> 845 in the cache */
   /* search784_0 -> 2264 in the cache */
   /* search784_1_0 -> 2265 in the cache */
   /* search784_1_1 -> 845 in the cache */
   /* search784_1 -> 2266 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2264, 2266 },
      -1,
   } },

   /* replace784_0_0 -> 6 in the cache */
   /* replace784_0_1 -> 2265 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_umin,
      1, 1,
      { 6, 2265 },
      -1,
   } },
   /* replace784_1 -> 845 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2277, 845 },
      -1,
   } },

   /* ('iand', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('umin', 'a', 'b'), 0) */
   /* search785_0_0 -> 6 in the cache */
   /* search785_0_1 -> 845 in the cache */
   /* search785_0 -> 2270 in the cache */
   /* search785_1_0 -> 2265 in the cache */
   /* search785_1_1 -> 845 in the cache */
   /* search785_1 -> 2271 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2270, 2271 },
      -1,
   } },

   /* replace785_0_0 -> 6 in the cache */
   /* replace785_0_1 -> 2265 in the cache */
   /* replace785_0 -> 2277 in the cache */
   /* replace785_1 -> 845 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2277, 845 },
      -1,
   } },

   /* ('ior', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('umax', 'a', 'b'), 0) */
   /* search786_0_0 -> 6 in the cache */
   /* search786_0_1 -> 845 in the cache */
   /* search786_0 -> 2270 in the cache */
   /* search786_1_0 -> 2265 in the cache */
   /* search786_1_1 -> 845 in the cache */
   /* search786_1 -> 2271 in the cache */
   /* search786 -> 2272 in the cache */

   /* replace786_0_0 -> 6 in the cache */
   /* replace786_0_1 -> 2265 in the cache */
   /* replace786_0 -> 2274 in the cache */
   /* replace786_1 -> 845 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2274, 845 },
      -1,
   } },

   /* ('bcsel', ('ult', 'b@8', 'a'), 'b', 'a') => ('umin', 'a', 'b') */
   { .variable = {
      { nir_search_value_variable, 8 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 8 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 2282, 2283 },
      -1,
   } },
   /* search787_1 -> 2282 in the cache */
   /* search787_2 -> 2283 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 2284, 2282, 2283 },
      -1,
   } },

   /* replace787_0 -> 2283 in the cache */
   /* replace787_1 -> 2282 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 2283, 2282 },
      -1,
   } },

   /* ('bcsel', ('ult', 'a@8', 'b'), 'b', 'a') => ('umax', 'a', 'b') */
   /* search788_0_0 -> 6 in the cache */
   /* search788_0_1 -> 2265 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 6, 2265 },
      -1,
   } },
   /* search788_1 -> 2265 in the cache */
   /* search788_2 -> 6 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 2287, 2265, 6 },
      -1,
   } },

   /* replace788_0 -> 6 in the cache */
   /* replace788_1 -> 2265 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 6, 2265 },
      -1,
   } },

   /* ('bcsel', ('uge', 'a@8', 'b'), 'b', 'a') => ('umin', 'a', 'b') */
   /* search789_0_0 -> 6 in the cache */
   /* search789_0_1 -> 2265 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 6, 2265 },
      -1,
   } },
   /* search789_1 -> 2265 in the cache */
   /* search789_2 -> 6 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 2290, 2265, 6 },
      -1,
   } },

   /* replace789_0 -> 6 in the cache */
   /* replace789_1 -> 2265 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 6, 2265 },
      -1,
   } },

   /* ('bcsel', ('uge', 'b@8', 'a'), 'b', 'a') => ('umax', 'a', 'b') */
   /* search790_0_0 -> 2282 in the cache */
   /* search790_0_1 -> 2283 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 2282, 2283 },
      -1,
   } },
   /* search790_1 -> 2282 in the cache */
   /* search790_2 -> 2283 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 2293, 2282, 2283 },
      -1,
   } },

   /* replace790_0 -> 2283 in the cache */
   /* replace790_1 -> 2282 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 2283, 2282 },
      -1,
   } },

   /* ('bcsel', ('ilt', 'b@8', 'a'), 'b', 'a') => ('imin', 'a', 'b') */
   /* search791_0_0 -> 2282 in the cache */
   /* search791_0_1 -> 2283 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 2282, 2283 },
      -1,
   } },
   /* search791_1 -> 2282 in the cache */
   /* search791_2 -> 2283 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 2296, 2282, 2283 },
      -1,
   } },

   /* replace791_0 -> 2283 in the cache */
   /* replace791_1 -> 2282 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 2283, 2282 },
      -1,
   } },

   /* ('bcsel', ('ilt', 'a@8', 'b'), 'b', 'a') => ('imax', 'a', 'b') */
   /* search792_0_0 -> 6 in the cache */
   /* search792_0_1 -> 2265 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 6, 2265 },
      -1,
   } },
   /* search792_1 -> 2265 in the cache */
   /* search792_2 -> 6 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 2299, 2265, 6 },
      -1,
   } },

   /* replace792_0 -> 6 in the cache */
   /* replace792_1 -> 2265 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 6, 2265 },
      -1,
   } },

   /* ('bcsel', ('ige', 'a@8', 'b'), 'b', 'a') => ('imin', 'a', 'b') */
   /* search793_0_0 -> 6 in the cache */
   /* search793_0_1 -> 2265 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 6, 2265 },
      -1,
   } },
   /* search793_1 -> 2265 in the cache */
   /* search793_2 -> 6 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 2302, 2265, 6 },
      -1,
   } },

   /* replace793_0 -> 6 in the cache */
   /* replace793_1 -> 2265 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 6, 2265 },
      -1,
   } },

   /* ('bcsel', ('ige', 'b@8', 'a'), 'b', 'a') => ('imax', 'a', 'b') */
   /* search794_0_0 -> 2282 in the cache */
   /* search794_0_1 -> 2283 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 2282, 2283 },
      -1,
   } },
   /* search794_1 -> 2282 in the cache */
   /* search794_2 -> 2283 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 2305, 2282, 2283 },
      -1,
   } },

   /* replace794_0 -> 2283 in the cache */
   /* replace794_1 -> 2282 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 2283, 2282 },
      -1,
   } },

   /* ('ineg', ('b2i8', 'a@8')) => a */
   /* search795_0_0 -> 6 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_b2i8,
      -1, 0,
      { 6 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2308 },
      -1,
   } },

   /* replace795 -> 6 in the cache */

   /* ('ishl', 'a@8', ('iand', 7, 'b')) => ('ishl', 'a', 'b') */
   /* search796_0 -> 6 in the cache */
   /* search796_1_0 -> 9 in the cache */
   /* search796_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 9, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 6, 2310 },
      -1,
   } },

   /* replace796_0 -> 6 in the cache */
   /* replace796_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 6, 36 },
      -1,
   } },

   /* ('ishr', 'a@8', ('iand', 7, 'b')) => ('ishr', 'a', 'b') */
   /* search797_0 -> 6 in the cache */
   /* search797_1_0 -> 9 in the cache */
   /* search797_1_1 -> 36 in the cache */
   /* search797_1 -> 2310 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 1,
      { 6, 2310 },
      -1,
   } },

   /* replace797_0 -> 6 in the cache */
   /* replace797_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 6, 36 },
      -1,
   } },

   /* ('ushr', 'a@8', ('iand', 7, 'b')) => ('ushr', 'a', 'b') */
   /* search798_0 -> 6 in the cache */
   /* search798_1_0 -> 9 in the cache */
   /* search798_1_1 -> 36 in the cache */
   /* search798_1 -> 2310 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 6, 2310 },
      -1,
   } },

   /* replace798_0 -> 6 in the cache */
   /* replace798_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 6, 36 },
      -1,
   } },

   /* ('ushr', 'a@8', ('ishl(is_used_once)', ('iand', 'b', 1), 2)) => ('ushr', 'a', ('ishl', 'b', 2)) */
   /* search799_0 -> 6 in the cache */
   /* search799_1_0_0 -> 36 in the cache */
   /* search799_1_0_1 -> 406 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 36, 406 },
      -1,
   } },
   /* search799_1_1 -> 411 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 2317, 411 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 6, 2318 },
      -1,
   } },

   /* replace799_0 -> 6 in the cache */
   /* replace799_1_0 -> 36 in the cache */
   /* replace799_1_1 -> 411 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 36, 411 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 6, 2320 },
      -1,
   } },

   /* ('iand', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('ior', 'a', 'b'), 0) */
   /* search800_0_0 -> 11 in the cache */
   /* search800_0_1 -> 866 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 11, 866 },
      -1,
   } },
   /* search800_1_0 -> 268 in the cache */
   /* search800_1_1 -> 866 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      2, 1,
      { 268, 866 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2322, 2323 },
      -1,
   } },

   /* replace800_0_0 -> 11 in the cache */
   /* replace800_0_1 -> 268 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 11, 268 },
      -1,
   } },
   /* replace800_1 -> 866 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2325, 866 },
      -1,
   } },

   /* ('ior', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('ior', 'a', 'b'), 0) */
   /* search801_0_0 -> 11 in the cache */
   /* search801_0_1 -> 866 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      1, 1,
      { 11, 866 },
      -1,
   } },
   /* search801_1_0 -> 268 in the cache */
   /* search801_1_1 -> 866 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      2, 1,
      { 268, 866 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2327, 2328 },
      -1,
   } },

   /* replace801_0_0 -> 11 in the cache */
   /* replace801_0_1 -> 268 in the cache */
   /* replace801_0 -> 2325 in the cache */
   /* replace801_1 -> 866 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2325, 866 },
      -1,
   } },

   /* ('iand', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('umax', 'a', 'b'), 0) */
   /* search802_0_0 -> 11 in the cache */
   /* search802_0_1 -> 866 in the cache */
   /* search802_0 -> 2322 in the cache */
   /* search802_1_0 -> 268 in the cache */
   /* search802_1_1 -> 866 in the cache */
   /* search802_1 -> 2323 in the cache */
   /* search802 -> 2324 in the cache */

   /* replace802_0_0 -> 11 in the cache */
   /* replace802_0_1 -> 268 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_umax,
      1, 1,
      { 11, 268 },
      -1,
   } },
   /* replace802_1 -> 866 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2331, 866 },
      -1,
   } },

   /* ('ior', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('umin', 'a', 'b'), 0) */
   /* search803_0_0 -> 11 in the cache */
   /* search803_0_1 -> 866 in the cache */
   /* search803_0 -> 2322 in the cache */
   /* search803_1_0 -> 268 in the cache */
   /* search803_1_1 -> 866 in the cache */
   /* search803_1 -> 2323 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2322, 2323 },
      -1,
   } },

   /* replace803_0_0 -> 11 in the cache */
   /* replace803_0_1 -> 268 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_umin,
      1, 1,
      { 11, 268 },
      -1,
   } },
   /* replace803_1 -> 866 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2334, 866 },
      -1,
   } },

   /* ('iand', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('umin', 'a', 'b'), 0) */
   /* search804_0_0 -> 11 in the cache */
   /* search804_0_1 -> 866 in the cache */
   /* search804_0 -> 2327 in the cache */
   /* search804_1_0 -> 268 in the cache */
   /* search804_1_1 -> 866 in the cache */
   /* search804_1 -> 2328 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2327, 2328 },
      -1,
   } },

   /* replace804_0_0 -> 11 in the cache */
   /* replace804_0_1 -> 268 in the cache */
   /* replace804_0 -> 2334 in the cache */
   /* replace804_1 -> 866 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2334, 866 },
      -1,
   } },

   /* ('ior', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('umax', 'a', 'b'), 0) */
   /* search805_0_0 -> 11 in the cache */
   /* search805_0_1 -> 866 in the cache */
   /* search805_0 -> 2327 in the cache */
   /* search805_1_0 -> 268 in the cache */
   /* search805_1_1 -> 866 in the cache */
   /* search805_1 -> 2328 in the cache */
   /* search805 -> 2329 in the cache */

   /* replace805_0_0 -> 11 in the cache */
   /* replace805_0_1 -> 268 in the cache */
   /* replace805_0 -> 2331 in the cache */
   /* replace805_1 -> 866 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2331, 866 },
      -1,
   } },

   /* ('bcsel', ('ult', 'b@16', 'a'), 'b', 'a') => ('umin', 'a', 'b') */
   /* search806_0_0 -> 522 in the cache */
   /* search806_0_1 -> 533 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 522, 533 },
      -1,
   } },
   /* search806_1 -> 522 in the cache */
   /* search806_2 -> 533 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 2339, 522, 533 },
      -1,
   } },

   /* replace806_0 -> 533 in the cache */
   /* replace806_1 -> 522 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 533, 522 },
      -1,
   } },

   /* ('bcsel', ('ult', 'a@16', 'b'), 'b', 'a') => ('umax', 'a', 'b') */
   /* search807_0_0 -> 11 in the cache */
   /* search807_0_1 -> 268 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 11, 268 },
      -1,
   } },
   /* search807_1 -> 268 in the cache */
   /* search807_2 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 2342, 268, 11 },
      -1,
   } },

   /* replace807_0 -> 11 in the cache */
   /* replace807_1 -> 268 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 11, 268 },
      -1,
   } },

   /* ('bcsel', ('uge', 'a@16', 'b'), 'b', 'a') => ('umin', 'a', 'b') */
   /* search808_0_0 -> 11 in the cache */
   /* search808_0_1 -> 268 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 11, 268 },
      -1,
   } },
   /* search808_1 -> 268 in the cache */
   /* search808_2 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 2345, 268, 11 },
      -1,
   } },

   /* replace808_0 -> 11 in the cache */
   /* replace808_1 -> 268 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 11, 268 },
      -1,
   } },

   /* ('bcsel', ('uge', 'b@16', 'a'), 'b', 'a') => ('umax', 'a', 'b') */
   /* search809_0_0 -> 522 in the cache */
   /* search809_0_1 -> 533 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 522, 533 },
      -1,
   } },
   /* search809_1 -> 522 in the cache */
   /* search809_2 -> 533 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 2348, 522, 533 },
      -1,
   } },

   /* replace809_0 -> 533 in the cache */
   /* replace809_1 -> 522 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 533, 522 },
      -1,
   } },

   /* ('bcsel', ('ilt', 'b@16', 'a'), 'b', 'a') => ('imin', 'a', 'b') */
   /* search810_0_0 -> 522 in the cache */
   /* search810_0_1 -> 533 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 522, 533 },
      -1,
   } },
   /* search810_1 -> 522 in the cache */
   /* search810_2 -> 533 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 2351, 522, 533 },
      -1,
   } },

   /* replace810_0 -> 533 in the cache */
   /* replace810_1 -> 522 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 533, 522 },
      -1,
   } },

   /* ('bcsel', ('ilt', 'a@16', 'b'), 'b', 'a') => ('imax', 'a', 'b') */
   /* search811_0_0 -> 11 in the cache */
   /* search811_0_1 -> 268 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 11, 268 },
      -1,
   } },
   /* search811_1 -> 268 in the cache */
   /* search811_2 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 2354, 268, 11 },
      -1,
   } },

   /* replace811_0 -> 11 in the cache */
   /* replace811_1 -> 268 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 11, 268 },
      -1,
   } },

   /* ('bcsel', ('ige', 'a@16', 'b'), 'b', 'a') => ('imin', 'a', 'b') */
   /* search812_0_0 -> 11 in the cache */
   /* search812_0_1 -> 268 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 11, 268 },
      -1,
   } },
   /* search812_1 -> 268 in the cache */
   /* search812_2 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 2357, 268, 11 },
      -1,
   } },

   /* replace812_0 -> 11 in the cache */
   /* replace812_1 -> 268 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 11, 268 },
      -1,
   } },

   /* ('bcsel', ('ige', 'b@16', 'a'), 'b', 'a') => ('imax', 'a', 'b') */
   /* search813_0_0 -> 522 in the cache */
   /* search813_0_1 -> 533 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 522, 533 },
      -1,
   } },
   /* search813_1 -> 522 in the cache */
   /* search813_2 -> 533 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 2360, 522, 533 },
      -1,
   } },

   /* replace813_0 -> 533 in the cache */
   /* replace813_1 -> 522 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 533, 522 },
      -1,
   } },

   /* ('ineg', ('b2i16', 'a@16')) => a */
   /* search814_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2363 },
      -1,
   } },

   /* replace814 -> 11 in the cache */

   /* ('ishl', 'a@16', ('iand', 15, 'b')) => ('ishl', 'a', 'b') */
   /* search815_0 -> 11 in the cache */
   /* search815_1_0 -> 14 in the cache */
   /* search815_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 14, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 11, 2365 },
      -1,
   } },

   /* replace815_0 -> 11 in the cache */
   /* replace815_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 11, 36 },
      -1,
   } },

   /* ('ishr', 'a@16', ('iand', 15, 'b')) => ('ishr', 'a', 'b') */
   /* search816_0 -> 11 in the cache */
   /* search816_1_0 -> 14 in the cache */
   /* search816_1_1 -> 36 in the cache */
   /* search816_1 -> 2365 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 1,
      { 11, 2365 },
      -1,
   } },

   /* replace816_0 -> 11 in the cache */
   /* replace816_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 11, 36 },
      -1,
   } },

   /* ('ushr', 'a@16', ('iand', 15, 'b')) => ('ushr', 'a', 'b') */
   /* search817_0 -> 11 in the cache */
   /* search817_1_0 -> 14 in the cache */
   /* search817_1_1 -> 36 in the cache */
   /* search817_1 -> 2365 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 11, 2365 },
      -1,
   } },

   /* replace817_0 -> 11 in the cache */
   /* replace817_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 11, 36 },
      -1,
   } },

   /* ('ushr', 'a@16', ('ishl(is_used_once)', ('iand', 'b', 1), 3)) => ('ushr', 'a', ('ishl', 'b', 3)) */
   /* search818_0 -> 11 in the cache */
   /* search818_1_0_0 -> 36 in the cache */
   /* search818_1_0_1 -> 406 in the cache */
   /* search818_1_0 -> 2317 in the cache */
   /* search818_1_1 -> 415 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 2317, 415 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 11, 2372 },
      -1,
   } },

   /* replace818_0 -> 11 in the cache */
   /* replace818_1_0 -> 36 in the cache */
   /* replace818_1_1 -> 415 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 36, 415 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 11, 2374 },
      -1,
   } },

   /* ('iand', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('ior', 'a', 'b'), 0) */
   /* search819_0_0 -> 16 in the cache */
   /* search819_0_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 16, 128 },
      -1,
   } },
   /* search819_1_0 -> 36 in the cache */
   /* search819_1_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      2, 1,
      { 36, 128 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2376, 2377 },
      -1,
   } },

   /* replace819_0_0 -> 16 in the cache */
   /* replace819_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 16, 36 },
      -1,
   } },
   /* replace819_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2379, 128 },
      -1,
   } },

   /* ('ior', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('ior', 'a', 'b'), 0) */
   /* search820_0_0 -> 16 in the cache */
   /* search820_0_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      1, 1,
      { 16, 128 },
      -1,
   } },
   /* search820_1_0 -> 36 in the cache */
   /* search820_1_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      2, 1,
      { 36, 128 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2381, 2382 },
      -1,
   } },

   /* replace820_0_0 -> 16 in the cache */
   /* replace820_0_1 -> 36 in the cache */
   /* replace820_0 -> 2379 in the cache */
   /* replace820_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2379, 128 },
      -1,
   } },

   /* ('iand', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('umax', 'a', 'b'), 0) */
   /* search821_0_0 -> 16 in the cache */
   /* search821_0_1 -> 128 in the cache */
   /* search821_0 -> 2376 in the cache */
   /* search821_1_0 -> 36 in the cache */
   /* search821_1_1 -> 128 in the cache */
   /* search821_1 -> 2377 in the cache */
   /* search821 -> 2378 in the cache */

   /* replace821_0_0 -> 16 in the cache */
   /* replace821_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_umax,
      1, 1,
      { 16, 36 },
      -1,
   } },
   /* replace821_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2385, 128 },
      -1,
   } },

   /* ('ior', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('umin', 'a', 'b'), 0) */
   /* search822_0_0 -> 16 in the cache */
   /* search822_0_1 -> 128 in the cache */
   /* search822_0 -> 2376 in the cache */
   /* search822_1_0 -> 36 in the cache */
   /* search822_1_1 -> 128 in the cache */
   /* search822_1 -> 2377 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2376, 2377 },
      -1,
   } },

   /* replace822_0_0 -> 16 in the cache */
   /* replace822_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_umin,
      1, 1,
      { 16, 36 },
      -1,
   } },
   /* replace822_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2388, 128 },
      -1,
   } },

   /* ('iand', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('umin', 'a', 'b'), 0) */
   /* search823_0_0 -> 16 in the cache */
   /* search823_0_1 -> 128 in the cache */
   /* search823_0 -> 2381 in the cache */
   /* search823_1_0 -> 36 in the cache */
   /* search823_1_1 -> 128 in the cache */
   /* search823_1 -> 2382 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2381, 2382 },
      -1,
   } },

   /* replace823_0_0 -> 16 in the cache */
   /* replace823_0_1 -> 36 in the cache */
   /* replace823_0 -> 2388 in the cache */
   /* replace823_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2388, 128 },
      -1,
   } },

   /* ('ior', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('umax', 'a', 'b'), 0) */
   /* search824_0_0 -> 16 in the cache */
   /* search824_0_1 -> 128 in the cache */
   /* search824_0 -> 2381 in the cache */
   /* search824_1_0 -> 36 in the cache */
   /* search824_1_1 -> 128 in the cache */
   /* search824_1 -> 2382 in the cache */
   /* search824 -> 2383 in the cache */

   /* replace824_0_0 -> 16 in the cache */
   /* replace824_0_1 -> 36 in the cache */
   /* replace824_0 -> 2385 in the cache */
   /* replace824_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2385, 128 },
      -1,
   } },

   /* ('bcsel', ('ult', 'b@32', 'a'), 'b', 'a') => ('umin', 'a', 'b') */
   /* search825_0_0 -> 383 in the cache */
   /* search825_0_1 -> 189 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 383, 189 },
      -1,
   } },
   /* search825_1 -> 383 in the cache */
   /* search825_2 -> 189 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 2393, 383, 189 },
      -1,
   } },

   /* replace825_0 -> 189 in the cache */
   /* replace825_1 -> 383 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 189, 383 },
      -1,
   } },

   /* ('bcsel', ('ult', 'a@32', 'b'), 'b', 'a') => ('umax', 'a', 'b') */
   /* search826_0_0 -> 16 in the cache */
   /* search826_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 16, 36 },
      -1,
   } },
   /* search826_1 -> 36 in the cache */
   /* search826_2 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 2396, 36, 16 },
      -1,
   } },

   /* replace826_0 -> 16 in the cache */
   /* replace826_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* ('bcsel', ('uge', 'a@32', 'b'), 'b', 'a') => ('umin', 'a', 'b') */
   /* search827_0_0 -> 16 in the cache */
   /* search827_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 16, 36 },
      -1,
   } },
   /* search827_1 -> 36 in the cache */
   /* search827_2 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 2399, 36, 16 },
      -1,
   } },

   /* replace827_0 -> 16 in the cache */
   /* replace827_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* ('bcsel', ('uge', 'b@32', 'a'), 'b', 'a') => ('umax', 'a', 'b') */
   /* search828_0_0 -> 383 in the cache */
   /* search828_0_1 -> 189 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 383, 189 },
      -1,
   } },
   /* search828_1 -> 383 in the cache */
   /* search828_2 -> 189 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 2402, 383, 189 },
      -1,
   } },

   /* replace828_0 -> 189 in the cache */
   /* replace828_1 -> 383 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 189, 383 },
      -1,
   } },

   /* ('bcsel', ('ilt', 'b@32', 'a'), 'b', 'a') => ('imin', 'a', 'b') */
   /* search829_0_0 -> 383 in the cache */
   /* search829_0_1 -> 189 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 383, 189 },
      -1,
   } },
   /* search829_1 -> 383 in the cache */
   /* search829_2 -> 189 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 2405, 383, 189 },
      -1,
   } },

   /* replace829_0 -> 189 in the cache */
   /* replace829_1 -> 383 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 189, 383 },
      -1,
   } },

   /* ('bcsel', ('ilt', 'a@32', 'b'), 'b', 'a') => ('imax', 'a', 'b') */
   /* search830_0_0 -> 16 in the cache */
   /* search830_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 16, 36 },
      -1,
   } },
   /* search830_1 -> 36 in the cache */
   /* search830_2 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 2408, 36, 16 },
      -1,
   } },

   /* replace830_0 -> 16 in the cache */
   /* replace830_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* ('bcsel', ('ige', 'a@32', 'b'), 'b', 'a') => ('imin', 'a', 'b') */
   /* search831_0_0 -> 16 in the cache */
   /* search831_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 16, 36 },
      -1,
   } },
   /* search831_1 -> 36 in the cache */
   /* search831_2 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 2411, 36, 16 },
      -1,
   } },

   /* replace831_0 -> 16 in the cache */
   /* replace831_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* ('bcsel', ('ige', 'b@32', 'a'), 'b', 'a') => ('imax', 'a', 'b') */
   /* search832_0_0 -> 383 in the cache */
   /* search832_0_1 -> 189 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 383, 189 },
      -1,
   } },
   /* search832_1 -> 383 in the cache */
   /* search832_2 -> 189 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 2414, 383, 189 },
      -1,
   } },

   /* replace832_0 -> 189 in the cache */
   /* replace832_1 -> 383 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 189, 383 },
      -1,
   } },

   /* ('ineg', ('b2i32', 'a@32')) => a */
   /* search833_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2417 },
      -1,
   } },

   /* replace833 -> 16 in the cache */

   /* ('ishl', 'a@32', ('iand', 31, 'b')) => ('ishl', 'a', 'b') */
   /* search834_0 -> 16 in the cache */
   /* search834_1_0 -> 19 in the cache */
   /* search834_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 19, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 16, 2419 },
      -1,
   } },

   /* replace834_0 -> 16 in the cache */
   /* replace834_1 -> 36 in the cache */
   /* replace834 -> 956 in the cache */

   /* ('ishr', 'a@32', ('iand', 31, 'b')) => ('ishr', 'a', 'b') */
   /* search835_0 -> 16 in the cache */
   /* search835_1_0 -> 19 in the cache */
   /* search835_1_1 -> 36 in the cache */
   /* search835_1 -> 2419 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 1,
      { 16, 2419 },
      -1,
   } },

   /* replace835_0 -> 16 in the cache */
   /* replace835_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 16, 36 },
      -1,
   } },

   /* ('ushr', 'a@32', ('iand', 31, 'b')) => ('ushr', 'a', 'b') */
   /* search836_0 -> 16 in the cache */
   /* search836_1_0 -> 19 in the cache */
   /* search836_1_1 -> 36 in the cache */
   /* search836_1 -> 2419 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 16, 2419 },
      -1,
   } },

   /* replace836_0 -> 16 in the cache */
   /* replace836_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 16, 36 },
      -1,
   } },

   /* ('ushr', 'a@32', ('ishl(is_used_once)', ('iand', 'b', 1), 4)) => ('ushr', 'a', ('ishl', 'b', 4)) */
   /* search837_0 -> 16 in the cache */
   /* search837_1_0_0 -> 36 in the cache */
   /* search837_1_0_1 -> 406 in the cache */
   /* search837_1_0 -> 2317 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x4 /* 4 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 2317, 2425 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 16, 2426 },
      -1,
   } },

   /* replace837_0 -> 16 in the cache */
   /* replace837_1_0 -> 36 in the cache */
   /* replace837_1_1 -> 2425 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 36, 2425 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 16, 2428 },
      -1,
   } },

   /* ('iand', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('ior', 'a', 'b'), 0) */
   /* search838_0_0 -> 21 in the cache */
   /* search838_0_1 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 21, 907 },
      -1,
   } },
   /* search838_1_0 -> 41 in the cache */
   /* search838_1_1 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      2, 1,
      { 41, 907 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2430, 2431 },
      -1,
   } },

   /* replace838_0_0 -> 21 in the cache */
   /* replace838_0_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 21, 41 },
      -1,
   } },
   /* replace838_1 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2433, 907 },
      -1,
   } },

   /* ('ior', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('ior', 'a', 'b'), 0) */
   /* search839_0_0 -> 21 in the cache */
   /* search839_0_1 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      1, 1,
      { 21, 907 },
      -1,
   } },
   /* search839_1_0 -> 41 in the cache */
   /* search839_1_1 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      2, 1,
      { 41, 907 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2435, 2436 },
      -1,
   } },

   /* replace839_0_0 -> 21 in the cache */
   /* replace839_0_1 -> 41 in the cache */
   /* replace839_0 -> 2433 in the cache */
   /* replace839_1 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2433, 907 },
      -1,
   } },

   /* ('iand', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('umax', 'a', 'b'), 0) */
   /* search840_0_0 -> 21 in the cache */
   /* search840_0_1 -> 907 in the cache */
   /* search840_0 -> 2430 in the cache */
   /* search840_1_0 -> 41 in the cache */
   /* search840_1_1 -> 907 in the cache */
   /* search840_1 -> 2431 in the cache */
   /* search840 -> 2432 in the cache */

   /* replace840_0_0 -> 21 in the cache */
   /* replace840_0_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_umax,
      1, 1,
      { 21, 41 },
      -1,
   } },
   /* replace840_1 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2439, 907 },
      -1,
   } },

   /* ('ior', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('umin', 'a', 'b'), 0) */
   /* search841_0_0 -> 21 in the cache */
   /* search841_0_1 -> 907 in the cache */
   /* search841_0 -> 2430 in the cache */
   /* search841_1_0 -> 41 in the cache */
   /* search841_1_1 -> 907 in the cache */
   /* search841_1 -> 2431 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2430, 2431 },
      -1,
   } },

   /* replace841_0_0 -> 21 in the cache */
   /* replace841_0_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_umin,
      1, 1,
      { 21, 41 },
      -1,
   } },
   /* replace841_1 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2442, 907 },
      -1,
   } },

   /* ('iand', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('umin', 'a', 'b'), 0) */
   /* search842_0_0 -> 21 in the cache */
   /* search842_0_1 -> 907 in the cache */
   /* search842_0 -> 2435 in the cache */
   /* search842_1_0 -> 41 in the cache */
   /* search842_1_1 -> 907 in the cache */
   /* search842_1 -> 2436 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2435, 2436 },
      -1,
   } },

   /* replace842_0_0 -> 21 in the cache */
   /* replace842_0_1 -> 41 in the cache */
   /* replace842_0 -> 2442 in the cache */
   /* replace842_1 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2442, 907 },
      -1,
   } },

   /* ('ior', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('umax', 'a', 'b'), 0) */
   /* search843_0_0 -> 21 in the cache */
   /* search843_0_1 -> 907 in the cache */
   /* search843_0 -> 2435 in the cache */
   /* search843_1_0 -> 41 in the cache */
   /* search843_1_1 -> 907 in the cache */
   /* search843_1 -> 2436 in the cache */
   /* search843 -> 2437 in the cache */

   /* replace843_0_0 -> 21 in the cache */
   /* replace843_0_1 -> 41 in the cache */
   /* replace843_0 -> 2439 in the cache */
   /* replace843_1 -> 907 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2439, 907 },
      -1,
   } },

   /* ('bcsel', ('ult', 'b@64', 'a'), 'b', 'a') => ('umin', 'a', 'b') */
   /* search844_0_0 -> 662 in the cache */
   /* search844_0_1 -> 672 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 662, 672 },
      -1,
   } },
   /* search844_1 -> 662 in the cache */
   /* search844_2 -> 672 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 2447, 662, 672 },
      -1,
   } },

   /* replace844_0 -> 672 in the cache */
   /* replace844_1 -> 662 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 672, 662 },
      -1,
   } },

   /* ('bcsel', ('ult', 'a@64', 'b'), 'b', 'a') => ('umax', 'a', 'b') */
   /* search845_0_0 -> 21 in the cache */
   /* search845_0_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 21, 41 },
      -1,
   } },
   /* search845_1 -> 41 in the cache */
   /* search845_2 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 2450, 41, 21 },
      -1,
   } },

   /* replace845_0 -> 21 in the cache */
   /* replace845_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 21, 41 },
      -1,
   } },

   /* ('bcsel', ('uge', 'a@64', 'b'), 'b', 'a') => ('umin', 'a', 'b') */
   /* search846_0_0 -> 21 in the cache */
   /* search846_0_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 21, 41 },
      -1,
   } },
   /* search846_1 -> 41 in the cache */
   /* search846_2 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 2453, 41, 21 },
      -1,
   } },

   /* replace846_0 -> 21 in the cache */
   /* replace846_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 21, 41 },
      -1,
   } },

   /* ('bcsel', ('uge', 'b@64', 'a'), 'b', 'a') => ('umax', 'a', 'b') */
   /* search847_0_0 -> 662 in the cache */
   /* search847_0_1 -> 672 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 662, 672 },
      -1,
   } },
   /* search847_1 -> 662 in the cache */
   /* search847_2 -> 672 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 2456, 662, 672 },
      -1,
   } },

   /* replace847_0 -> 672 in the cache */
   /* replace847_1 -> 662 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 672, 662 },
      -1,
   } },

   /* ('bcsel', ('ilt', 'b@64', 'a'), 'b', 'a') => ('imin', 'a', 'b') */
   /* search848_0_0 -> 662 in the cache */
   /* search848_0_1 -> 672 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 662, 672 },
      -1,
   } },
   /* search848_1 -> 662 in the cache */
   /* search848_2 -> 672 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 2459, 662, 672 },
      -1,
   } },

   /* replace848_0 -> 672 in the cache */
   /* replace848_1 -> 662 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 672, 662 },
      -1,
   } },

   /* ('bcsel', ('ilt', 'a@64', 'b'), 'b', 'a') => ('imax', 'a', 'b') */
   /* search849_0_0 -> 21 in the cache */
   /* search849_0_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 21, 41 },
      -1,
   } },
   /* search849_1 -> 41 in the cache */
   /* search849_2 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 2462, 41, 21 },
      -1,
   } },

   /* replace849_0 -> 21 in the cache */
   /* replace849_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 21, 41 },
      -1,
   } },

   /* ('bcsel', ('ige', 'a@64', 'b'), 'b', 'a') => ('imin', 'a', 'b') */
   /* search850_0_0 -> 21 in the cache */
   /* search850_0_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 21, 41 },
      -1,
   } },
   /* search850_1 -> 41 in the cache */
   /* search850_2 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 2465, 41, 21 },
      -1,
   } },

   /* replace850_0 -> 21 in the cache */
   /* replace850_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 21, 41 },
      -1,
   } },

   /* ('bcsel', ('ige', 'b@64', 'a'), 'b', 'a') => ('imax', 'a', 'b') */
   /* search851_0_0 -> 662 in the cache */
   /* search851_0_1 -> 672 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 662, 672 },
      -1,
   } },
   /* search851_1 -> 662 in the cache */
   /* search851_2 -> 672 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 2468, 662, 672 },
      -1,
   } },

   /* replace851_0 -> 672 in the cache */
   /* replace851_1 -> 662 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 672, 662 },
      -1,
   } },

   /* ('ineg', ('b2i64', 'a@64')) => a */
   /* search852_0_0 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 21 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2471 },
      -1,
   } },

   /* replace852 -> 21 in the cache */

   /* ('ishl', 'a@64', ('iand', 63, 'b')) => ('ishl', 'a', 'b') */
   /* search853_0 -> 21 in the cache */
   /* search853_1_0 -> 24 in the cache */
   /* search853_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 24, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 21, 2473 },
      -1,
   } },

   /* replace853_0 -> 21 in the cache */
   /* replace853_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 21, 36 },
      -1,
   } },

   /* ('ishr', 'a@64', ('iand', 63, 'b')) => ('ishr', 'a', 'b') */
   /* search854_0 -> 21 in the cache */
   /* search854_1_0 -> 24 in the cache */
   /* search854_1_1 -> 36 in the cache */
   /* search854_1 -> 2473 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 1,
      { 21, 2473 },
      -1,
   } },

   /* replace854_0 -> 21 in the cache */
   /* replace854_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 21, 36 },
      -1,
   } },

   /* ('ushr', 'a@64', ('iand', 63, 'b')) => ('ushr', 'a', 'b') */
   /* search855_0 -> 21 in the cache */
   /* search855_1_0 -> 24 in the cache */
   /* search855_1_1 -> 36 in the cache */
   /* search855_1 -> 2473 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 21, 2473 },
      -1,
   } },

   /* replace855_0 -> 21 in the cache */
   /* replace855_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 21, 36 },
      -1,
   } },

   /* ('ushr', 'a@64', ('ishl(is_used_once)', ('iand', 'b', 1), 5)) => ('ushr', 'a', ('ishl', 'b', 5)) */
   /* search856_0 -> 21 in the cache */
   /* search856_1_0_0 -> 36 in the cache */
   /* search856_1_0_1 -> 406 in the cache */
   /* search856_1_0 -> 2317 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x5 /* 5 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 2317, 2480 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 21, 2481 },
      -1,
   } },

   /* replace856_0 -> 21 in the cache */
   /* replace856_1_0 -> 36 in the cache */
   /* replace856_1_1 -> 2480 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 36, 2480 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 21, 2483 },
      -1,
   } },

   /* ('ior', ('ieq', 'a', 0), ('ieq', 'a', 1)) => ('uge', 1, 'a') */
   /* search857_0_0 -> 32 in the cache */
   /* search857_0_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 32, 61 },
      -1,
   } },
   /* search857_1_0 -> 32 in the cache */
   /* search857_1_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      2, 1,
      { 32, 35 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2485, 2486 },
      -1,
   } },

   /* replace857_0 -> 35 in the cache */
   /* replace857_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 35, 32 },
      -1,
   } },

   /* ('ior', ('uge', 1, 'a'), ('ieq', 'a', 2)) => ('uge', 2, 'a') */
   /* search858_0_0 -> 35 in the cache */
   /* search858_0_1 -> 32 in the cache */
   /* search858_0 -> 2488 in the cache */
   /* search858_1_0 -> 32 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0x2 /* 2 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 32, 2489 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 2488, 2490 },
      -1,
   } },

   /* replace858_0 -> 2489 in the cache */
   /* replace858_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 2489, 32 },
      -1,
   } },

   /* ('ior', ('uge', 2, 'a'), ('ieq', 'a', 3)) => ('uge', 3, 'a') */
   /* search859_0_0 -> 2489 in the cache */
   /* search859_0_1 -> 32 in the cache */
   /* search859_0 -> 2492 in the cache */
   /* search859_1_0 -> 32 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0x3 /* 3 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 32, 2493 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 2492, 2494 },
      -1,
   } },

   /* replace859_0 -> 2493 in the cache */
   /* replace859_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 2493, 32 },
      -1,
   } },

   /* ('ior', 'a', ('ieq', 'a', False)) => True */
   /* search860_0 -> 767 in the cache */
   /* search860_1_0 -> 767 in the cache */
   /* search860_1_1 -> 1087 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 767, 1087 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 767, 2497 },
      -1,
   } },

   /* replace860 -> 1243 in the cache */

   /* ('ine', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ine', 'a', 'b') */
   /* search861_0_0_0 -> 767 in the cache */
   /* search861_0_0 -> 1238 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1238 },
      -1,
   } },
   /* search861_1_0_0 -> 1144 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 0,
      { 1144 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2500 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 2499, 2501 },
      -1,
   } },

   /* replace861_0 -> 767 in the cache */
   /* replace861_1 -> 1144 in the cache */
   /* replace861 -> 1389 in the cache */

   /* ('b2i', ('ine', 'a@1', 'b@1')) => ('b2i', ('ixor', 'a', 'b')) */
   /* search862_0_0 -> 767 in the cache */
   /* search862_0_1 -> 1144 in the cache */
   /* search862_0 -> 1389 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 1,
      { 1389 },
      -1,
   } },

   /* replace862_0_0 -> 767 in the cache */
   /* replace862_0_1 -> 1144 in the cache */
   /* replace862_0 -> 1161 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 1,
      { 1161 },
      -1,
   } },

   /* ('ishl', ('b2i32', ('ine', ('iand', 'a@32', '#b(is_pos_power_of_two)'), 0)), '#c') => ('bcsel', ('ige', ('iand', 'c', 31), ('find_lsb', 'b')), ('ishl', ('iand', 'a', 'b'), ('iadd', ('iand', 'c', 31), ('ineg', ('find_lsb', 'b')))), ('ushr', ('iand', 'a', 'b'), ('iadd', ('ineg', ('iand', 'c', 31)), ('find_lsb', 'b')))) */
   /* search863_0_0_0_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      0,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 16, 2505 },
      -1,
   } },
   /* search863_0_0_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2506, 128 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 2,
      { 2507 },
      -1,
   } },
   /* search863_1 -> 319 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 2,
      { 2508, 319 },
      -1,
   } },

   /* replace863_0_0_0 -> 141 in the cache */
   /* replace863_0_0_1 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 141, 19 },
      -1,
   } },
   /* replace863_0_1_0 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_find_lsb,
      -1, 0,
      { 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 2510, 2511 },
      -1,
   } },
   /* replace863_1_0_0 -> 16 in the cache */
   /* replace863_1_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 16, 36 },
      -1,
   } },
   /* replace863_1_1_0_0 -> 141 in the cache */
   /* replace863_1_1_0_1 -> 19 in the cache */
   /* replace863_1_1_0 -> 895 in the cache */
   /* replace863_1_1_1_0_0 -> 36 in the cache */
   /* replace863_1_1_1_0 -> 2511 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2511 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      2, 2,
      { 895, 2514 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 3,
      { 2513, 2515 },
      -1,
   } },
   /* replace863_2_0_0 -> 16 in the cache */
   /* replace863_2_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      4, 1,
      { 16, 36 },
      -1,
   } },
   /* replace863_2_1_0_0_0 -> 141 in the cache */
   /* replace863_2_1_0_0_1 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      6, 1,
      { 141, 19 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 1,
      { 2518 },
      -1,
   } },
   /* replace863_2_1_1_0 -> 36 in the cache */
   /* replace863_2_1_1 -> 2511 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      5, 2,
      { 2519, 2511 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 3,
      { 2517, 2520 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 7,
      { 2512, 2516, 2521 },
      -1,
   } },

   /* ('b2i32', ('ine', ('iand', 'a@32', '#b(is_pos_power_of_two)'), 0)) => ('ushr', ('iand', 'a', 'b'), ('find_lsb', 'b')) */
   /* search864_0_0_0 -> 16 in the cache */
   /* search864_0_0_1 -> 2505 in the cache */
   /* search864_0_0 -> 2506 in the cache */
   /* search864_0_1 -> 128 in the cache */
   /* search864_0 -> 2507 in the cache */
   /* search864 -> 2508 in the cache */

   /* replace864_0_0 -> 16 in the cache */
   /* replace864_0_1 -> 36 in the cache */
   /* replace864_0 -> 2184 in the cache */
   /* replace864_1_0 -> 36 in the cache */
   /* replace864_1 -> 2511 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 2184, 2511 },
      -1,
   } },

   /* ('ior', ('b2i', 'a'), ('iand', 'b', 1)) => ('iand', ('ior', ('b2i', 'a'), 'b'), 1) */
   /* search865_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 0,
      { 32 },
      -1,
   } },
   /* search865_1_0 -> 3 in the cache */
   /* search865_1_1 -> 79 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 3, 79 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 2524, 2525 },
      -1,
   } },

   /* replace865_0_0_0 -> 32 in the cache */
   /* replace865_0_0 -> 2524 in the cache */
   /* replace865_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 2524, 3 },
      -1,
   } },
   /* replace865_1 -> 79 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 2527, 79 },
      -1,
   } },

   /* ('iand', ('b2i', 'a'), ('iand', 'b', 1)) => ('iand', ('b2i', 'a'), 'b') */
   /* search866_0_0 -> 32 in the cache */
   /* search866_0 -> 2524 in the cache */
   /* search866_1_0 -> 3 in the cache */
   /* search866_1_1 -> 79 in the cache */
   /* search866_1 -> 2525 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 2524, 2525 },
      -1,
   } },

   /* replace866_0_0 -> 32 in the cache */
   /* replace866_0 -> 2524 in the cache */
   /* replace866_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2524, 3 },
      -1,
   } },

   /* ('iand', ('inot', ('iand', ('ior', ('ieq', 'a', 0), 'b'), 'c')), ('ilt', 'a', 0)) => ('iand', ('inot', ('iand', 'b', 'c')), ('ilt', 'a', 0)) */
   /* search867_0_0_0_0_0 -> 32 in the cache */
   /* search867_0_0_0_0_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      3, 1,
      { 32, 61 },
      -1,
   } },
   /* search867_0_0_0_1 -> 1144 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      2, 2,
      { 2531, 1144 },
      -1,
   } },
   /* search867_0_0_1 -> 471 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      1, 3,
      { 2532, 471 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 3,
      { 2533 },
      -1,
   } },
   /* search867_1_0 -> 32 in the cache */
   /* search867_1_1 -> 61 in the cache */
   /* search867_1 -> 1263 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 4,
      { 2534, 1263 },
      -1,
   } },

   /* replace867_0_0_0 -> 1144 in the cache */
   /* replace867_0_0_1 -> 471 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 1144, 471 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 2536 },
      -1,
   } },
   /* replace867_1_0 -> 32 in the cache */
   /* replace867_1_1 -> 61 in the cache */
   /* replace867_1 -> 1263 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 2537, 1263 },
      -1,
   } },

   /* ('iand', ('inot', ('iand', ('ieq', ('umin', 'a', 'b'), 0), 'c')), ('ilt', 'a', 0)) => ('iand', ('inot', ('iand', ('ieq', 'b', 0), 'c')), ('ilt', 'a', 0)) */
   /* search868_0_0_0_0_0 -> 0 in the cache */
   /* search868_0_0_0_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umin,
      3, 1,
      { 0, 3 },
      -1,
   } },
   /* search868_0_0_0_1 -> 86 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      2, 2,
      { 2539, 86 },
      -1,
   } },
   /* search868_0_0_1 -> 471 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      1, 3,
      { 2540, 471 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 3,
      { 2541 },
      -1,
   } },
   /* search868_1_0 -> 0 in the cache */
   /* search868_1_1 -> 86 in the cache */
   /* search868_1 -> 90 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 4,
      { 2542, 90 },
      -1,
   } },

   /* replace868_0_0_0_0 -> 3 in the cache */
   /* replace868_0_0_0_1 -> 86 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      2, 1,
      { 3, 86 },
      -1,
   } },
   /* replace868_0_0_1 -> 471 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      1, 2,
      { 2544, 471 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 2,
      { 2545 },
      -1,
   } },
   /* replace868_1_0 -> 0 in the cache */
   /* replace868_1_1 -> 86 in the cache */
   /* replace868_1 -> 90 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2546, 90 },
      -1,
   } },

   /* ('flt', 'a', ('fmax', 'b', 'a')) => ('flt', 'a', 'b') */
   /* search869_0 -> 32 in the cache */
   { .variable = {
      { nir_search_value_variable, -1 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search869_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 2548, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 32, 2549 },
      -1,
   } },

   /* replace869_0 -> 32 in the cache */
   /* replace869_1 -> 2548 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 32, 2548 },
      -1,
   } },

   /* ('flt', ('fmin', 'a', 'b'), 'a') => ('flt', 'b', 'a') */
   /* search870_0_0 -> 0 in the cache */
   /* search870_0_1 -> 3 in the cache */
   /* search870_0 -> 1297 in the cache */
   /* search870_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1297, 0 },
      -1,
   } },

   /* replace870_0 -> 3 in the cache */
   /* replace870_1 -> 0 in the cache */
   /* replace870 -> 1088 in the cache */

   /* ('~fge', 'a', ('fmin', 'b', 'a')) => True */
   /* search871_0 -> 32 in the cache */
   /* search871_1_0 -> 2548 in the cache */
   /* search871_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 2548, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 32, 2553 },
      -1,
   } },

   /* replace871 -> 1243 in the cache */

   /* ('~fge', ('fmax', 'a', 'b'), 'a') => True */
   /* search872_0_0 -> 0 in the cache */
   /* search872_0_1 -> 3 in the cache */
   /* search872_0 -> 1295 in the cache */
   /* search872_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1295, 0 },
      -1,
   } },

   /* replace872 -> 1243 in the cache */

   /* ('flt', 'a', ('fmin', 'b', 'a')) => False */
   /* search873_0 -> 32 in the cache */
   /* search873_1_0 -> 2548 in the cache */
   /* search873_1_1 -> 32 in the cache */
   /* search873_1 -> 2553 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 32, 2553 },
      -1,
   } },

   /* replace873 -> 1087 in the cache */

   /* ('flt', ('fmax', 'a', 'b'), 'a') => False */
   /* search874_0_0 -> 0 in the cache */
   /* search874_0_1 -> 3 in the cache */
   /* search874_0 -> 1295 in the cache */
   /* search874_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1295, 0 },
      -1,
   } },

   /* replace874 -> 1087 in the cache */

   /* ('~fge', 'a', ('fmax', 'b', 'a')) => ('fge', 'a', 'b') */
   /* search875_0 -> 32 in the cache */
   /* search875_1_0 -> 2548 in the cache */
   /* search875_1_1 -> 32 in the cache */
   /* search875_1 -> 2549 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 32, 2549 },
      -1,
   } },

   /* replace875_0 -> 32 in the cache */
   /* replace875_1 -> 2548 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 32, 2548 },
      -1,
   } },

   /* ('~fge', ('fmin', 'a', 'b'), 'a') => ('fge', 'b', 'a') */
   /* search876_0_0 -> 0 in the cache */
   /* search876_0_1 -> 3 in the cache */
   /* search876_0 -> 1297 in the cache */
   /* search876_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1297, 0 },
      -1,
   } },

   /* replace876_0 -> 3 in the cache */
   /* replace876_1 -> 0 in the cache */
   /* replace876 -> 1100 in the cache */

   /* ('ilt', 'a', ('imax', 'b', 'a')) => ('ilt', 'a', 'b') */
   /* search877_0 -> 32 in the cache */
   /* search877_1_0 -> 2548 in the cache */
   /* search877_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 2548, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 32, 2561 },
      -1,
   } },

   /* replace877_0 -> 32 in the cache */
   /* replace877_1 -> 2548 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 32, 2548 },
      -1,
   } },

   /* ('ilt', ('imin', 'a', 'b'), 'a') => ('ilt', 'b', 'a') */
   /* search878_0_0 -> 0 in the cache */
   /* search878_0_1 -> 3 in the cache */
   /* search878_0 -> 1354 in the cache */
   /* search878_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 1354, 0 },
      -1,
   } },

   /* replace878_0 -> 3 in the cache */
   /* replace878_1 -> 0 in the cache */
   /* replace878 -> 1093 in the cache */

   /* ('ige', 'a', ('imin', 'b', 'a')) => True */
   /* search879_0 -> 32 in the cache */
   /* search879_1_0 -> 2548 in the cache */
   /* search879_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 2548, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 32, 2565 },
      -1,
   } },

   /* replace879 -> 1243 in the cache */

   /* ('ige', ('imax', 'a', 'b'), 'a') => True */
   /* search880_0_0 -> 0 in the cache */
   /* search880_0_1 -> 3 in the cache */
   /* search880_0 -> 1346 in the cache */
   /* search880_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 1346, 0 },
      -1,
   } },

   /* replace880 -> 1243 in the cache */

   /* ('ult', 'a', ('umax', 'b', 'a')) => ('ult', 'a', 'b') */
   /* search881_0 -> 32 in the cache */
   /* search881_1_0 -> 2548 in the cache */
   /* search881_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 2548, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 32, 2568 },
      -1,
   } },

   /* replace881_0 -> 32 in the cache */
   /* replace881_1 -> 2548 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 32, 2548 },
      -1,
   } },

   /* ('ult', ('umin', 'a', 'b'), 'a') => ('ult', 'b', 'a') */
   /* search882_0_0 -> 0 in the cache */
   /* search882_0_1 -> 3 in the cache */
   /* search882_0 -> 1351 in the cache */
   /* search882_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 1351, 0 },
      -1,
   } },

   /* replace882_0 -> 3 in the cache */
   /* replace882_1 -> 0 in the cache */
   /* replace882 -> 1095 in the cache */

   /* ('uge', 'a', ('umin', 'b', 'a')) => True */
   /* search883_0 -> 32 in the cache */
   /* search883_1_0 -> 2548 in the cache */
   /* search883_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 2548, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 32, 2572 },
      -1,
   } },

   /* replace883 -> 1243 in the cache */

   /* ('uge', ('umax', 'a', 'b'), 'a') => True */
   /* search884_0_0 -> 0 in the cache */
   /* search884_0_1 -> 3 in the cache */
   /* search884_0 -> 1343 in the cache */
   /* search884_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 1343, 0 },
      -1,
   } },

   /* replace884 -> 1243 in the cache */

   /* ('ilt', 'a', ('imin', 'b', 'a')) => False */
   /* search885_0 -> 32 in the cache */
   /* search885_1_0 -> 2548 in the cache */
   /* search885_1_1 -> 32 in the cache */
   /* search885_1 -> 2565 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 32, 2565 },
      -1,
   } },

   /* replace885 -> 1087 in the cache */

   /* ('ilt', ('imax', 'a', 'b'), 'a') => False */
   /* search886_0_0 -> 0 in the cache */
   /* search886_0_1 -> 3 in the cache */
   /* search886_0 -> 1346 in the cache */
   /* search886_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 1346, 0 },
      -1,
   } },

   /* replace886 -> 1087 in the cache */

   /* ('ige', 'a', ('imax', 'b', 'a')) => ('ige', 'a', 'b') */
   /* search887_0 -> 32 in the cache */
   /* search887_1_0 -> 2548 in the cache */
   /* search887_1_1 -> 32 in the cache */
   /* search887_1 -> 2561 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 32, 2561 },
      -1,
   } },

   /* replace887_0 -> 32 in the cache */
   /* replace887_1 -> 2548 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 32, 2548 },
      -1,
   } },

   /* ('ige', ('imin', 'a', 'b'), 'a') => ('ige', 'b', 'a') */
   /* search888_0_0 -> 0 in the cache */
   /* search888_0_1 -> 3 in the cache */
   /* search888_0 -> 1354 in the cache */
   /* search888_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 1354, 0 },
      -1,
   } },

   /* replace888_0 -> 3 in the cache */
   /* replace888_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 3, 0 },
      -1,
   } },

   /* ('ult', 'a', ('umin', 'b', 'a')) => False */
   /* search889_0 -> 32 in the cache */
   /* search889_1_0 -> 2548 in the cache */
   /* search889_1_1 -> 32 in the cache */
   /* search889_1 -> 2572 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 32, 2572 },
      -1,
   } },

   /* replace889 -> 1087 in the cache */

   /* ('ult', ('umax', 'a', 'b'), 'a') => False */
   /* search890_0_0 -> 0 in the cache */
   /* search890_0_1 -> 3 in the cache */
   /* search890_0 -> 1343 in the cache */
   /* search890_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 1343, 0 },
      -1,
   } },

   /* replace890 -> 1087 in the cache */

   /* ('uge', 'a', ('umax', 'b', 'a')) => ('uge', 'a', 'b') */
   /* search891_0 -> 32 in the cache */
   /* search891_1_0 -> 2548 in the cache */
   /* search891_1_1 -> 32 in the cache */
   /* search891_1 -> 2568 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 32, 2568 },
      -1,
   } },

   /* replace891_0 -> 32 in the cache */
   /* replace891_1 -> 2548 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 32, 2548 },
      -1,
   } },

   /* ('uge', ('umin', 'a', 'b'), 'a') => ('uge', 'b', 'a') */
   /* search892_0_0 -> 0 in the cache */
   /* search892_0_1 -> 3 in the cache */
   /* search892_0 -> 1351 in the cache */
   /* search892_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 1351, 0 },
      -1,
   } },

   /* replace892_0 -> 3 in the cache */
   /* replace892_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 3, 0 },
      -1,
   } },

   /* ('ult', 'a', ('iand', 'b', 'a')) => False */
   /* search893_0 -> 32 in the cache */
   /* search893_1_0 -> 2548 in the cache */
   /* search893_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2548, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 32, 2587 },
      -1,
   } },

   /* replace893 -> 1087 in the cache */

   /* ('ult', ('ior', 'a', 'b'), 'a') => False */
   /* search894_0_0 -> 0 in the cache */
   /* search894_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 0, 3 },
      -1,
   } },
   /* search894_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 2589, 0 },
      -1,
   } },

   /* replace894 -> 1087 in the cache */

   /* ('uge', 'a', ('iand', 'b', 'a')) => True */
   /* search895_0 -> 32 in the cache */
   /* search895_1_0 -> 2548 in the cache */
   /* search895_1_1 -> 32 in the cache */
   /* search895_1 -> 2587 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 32, 2587 },
      -1,
   } },

   /* replace895 -> 1243 in the cache */

   /* ('uge', ('ior', 'a', 'b'), 'a') => True */
   /* search896_0_0 -> 0 in the cache */
   /* search896_0_1 -> 3 in the cache */
   /* search896_0 -> 2589 in the cache */
   /* search896_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 2589, 0 },
      -1,
   } },

   /* replace896 -> 1243 in the cache */

   /* ('ilt', '#a', ('imax', '#b', 'c')) => ('ior', ('ilt', 'a', 'b'), ('ilt', 'a', 'c')) */
   /* search897_0 -> 292 in the cache */
   /* search897_1_0 -> 293 in the cache */
   /* search897_1_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 293, 135 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 292, 2593 },
      -1,
   } },

   /* replace897_0_0 -> 132 in the cache */
   /* replace897_0_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 132, 133 },
      -1,
   } },
   /* replace897_1_0 -> 132 in the cache */
   /* replace897_1_1 -> 135 in the cache */
   /* replace897_1 -> 1657 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2595, 1657 },
      -1,
   } },

   /* ('ilt', ('imin', '#a', 'b'), '#c') => ('ior', ('ilt', 'a', 'c'), ('ilt', 'b', 'c')) */
   /* search898_0_0 -> 292 in the cache */
   /* search898_0_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 292, 133 },
      -1,
   } },
   /* search898_1 -> 824 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 2597, 824 },
      -1,
   } },

   /* replace898_0_0 -> 132 in the cache */
   /* replace898_0_1 -> 135 in the cache */
   /* replace898_0 -> 1657 in the cache */
   /* replace898_1_0 -> 133 in the cache */
   /* replace898_1_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 133, 135 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1657, 2599 },
      -1,
   } },

   /* ('ige', '#a', ('imin', '#b', 'c')) => ('ior', ('ige', 'a', 'b'), ('ige', 'a', 'c')) */
   /* search899_0 -> 292 in the cache */
   /* search899_1_0 -> 293 in the cache */
   /* search899_1_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 293, 135 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 292, 2601 },
      -1,
   } },

   /* replace899_0_0 -> 132 in the cache */
   /* replace899_0_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 132, 133 },
      -1,
   } },
   /* replace899_1_0 -> 132 in the cache */
   /* replace899_1_1 -> 135 in the cache */
   /* replace899_1 -> 1667 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2603, 1667 },
      -1,
   } },

   /* ('ige', ('imax', '#a', 'b'), '#c') => ('ior', ('ige', 'a', 'c'), ('ige', 'b', 'c')) */
   /* search900_0_0 -> 292 in the cache */
   /* search900_0_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 292, 133 },
      -1,
   } },
   /* search900_1 -> 824 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 2605, 824 },
      -1,
   } },

   /* replace900_0_0 -> 132 in the cache */
   /* replace900_0_1 -> 135 in the cache */
   /* replace900_0 -> 1667 in the cache */
   /* replace900_1_0 -> 133 in the cache */
   /* replace900_1_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 133, 135 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1667, 2607 },
      -1,
   } },

   /* ('ult', '#a', ('umax', '#b', 'c')) => ('ior', ('ult', 'a', 'b'), ('ult', 'a', 'c')) */
   /* search901_0 -> 292 in the cache */
   /* search901_1_0 -> 293 in the cache */
   /* search901_1_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 293, 135 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 292, 2609 },
      -1,
   } },

   /* replace901_0_0 -> 132 in the cache */
   /* replace901_0_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 132, 133 },
      -1,
   } },
   /* replace901_1_0 -> 132 in the cache */
   /* replace901_1_1 -> 135 in the cache */
   /* replace901_1 -> 1677 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2611, 1677 },
      -1,
   } },

   /* ('ult', ('umin', '#a', 'b'), '#c') => ('ior', ('ult', 'a', 'c'), ('ult', 'b', 'c')) */
   /* search902_0_0 -> 292 in the cache */
   /* search902_0_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 292, 133 },
      -1,
   } },
   /* search902_1 -> 824 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 2613, 824 },
      -1,
   } },

   /* replace902_0_0 -> 132 in the cache */
   /* replace902_0_1 -> 135 in the cache */
   /* replace902_0 -> 1677 in the cache */
   /* replace902_1_0 -> 133 in the cache */
   /* replace902_1_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 133, 135 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1677, 2615 },
      -1,
   } },

   /* ('uge', '#a', ('umin', '#b', 'c')) => ('ior', ('uge', 'a', 'b'), ('uge', 'a', 'c')) */
   /* search903_0 -> 292 in the cache */
   /* search903_1_0 -> 293 in the cache */
   /* search903_1_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 293, 135 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 292, 2617 },
      -1,
   } },

   /* replace903_0_0 -> 132 in the cache */
   /* replace903_0_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 132, 133 },
      -1,
   } },
   /* replace903_1_0 -> 132 in the cache */
   /* replace903_1_1 -> 135 in the cache */
   /* replace903_1 -> 1687 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2619, 1687 },
      -1,
   } },

   /* ('uge', ('umax', '#a', 'b'), '#c') => ('ior', ('uge', 'a', 'c'), ('uge', 'b', 'c')) */
   /* search904_0_0 -> 292 in the cache */
   /* search904_0_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 292, 133 },
      -1,
   } },
   /* search904_1 -> 824 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 2621, 824 },
      -1,
   } },

   /* replace904_0_0 -> 132 in the cache */
   /* replace904_0_1 -> 135 in the cache */
   /* replace904_0 -> 1687 in the cache */
   /* replace904_1_0 -> 133 in the cache */
   /* replace904_1_1 -> 135 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 133, 135 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1687, 2623 },
      -1,
   } },

   /* ('ilt', '#a', ('imin', '#b', 'c')) => ('iand', ('ilt', 'a', 'b'), ('ilt', 'a', 'c')) */
   /* search905_0 -> 292 in the cache */
   /* search905_1_0 -> 293 in the cache */
   /* search905_1_1 -> 135 in the cache */
   /* search905_1 -> 2601 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 292, 2601 },
      -1,
   } },

   /* replace905_0_0 -> 132 in the cache */
   /* replace905_0_1 -> 133 in the cache */
   /* replace905_0 -> 2595 in the cache */
   /* replace905_1_0 -> 132 in the cache */
   /* replace905_1_1 -> 135 in the cache */
   /* replace905_1 -> 1657 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2595, 1657 },
      -1,
   } },

   /* ('ilt', ('imax', '#a', 'b'), '#c') => ('iand', ('ilt', 'a', 'c'), ('ilt', 'b', 'c')) */
   /* search906_0_0 -> 292 in the cache */
   /* search906_0_1 -> 133 in the cache */
   /* search906_0 -> 2605 in the cache */
   /* search906_1 -> 824 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 2605, 824 },
      -1,
   } },

   /* replace906_0_0 -> 132 in the cache */
   /* replace906_0_1 -> 135 in the cache */
   /* replace906_0 -> 1657 in the cache */
   /* replace906_1_0 -> 133 in the cache */
   /* replace906_1_1 -> 135 in the cache */
   /* replace906_1 -> 2599 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1657, 2599 },
      -1,
   } },

   /* ('ige', '#a', ('imax', '#b', 'c')) => ('iand', ('ige', 'a', 'b'), ('ige', 'a', 'c')) */
   /* search907_0 -> 292 in the cache */
   /* search907_1_0 -> 293 in the cache */
   /* search907_1_1 -> 135 in the cache */
   /* search907_1 -> 2593 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 292, 2593 },
      -1,
   } },

   /* replace907_0_0 -> 132 in the cache */
   /* replace907_0_1 -> 133 in the cache */
   /* replace907_0 -> 2603 in the cache */
   /* replace907_1_0 -> 132 in the cache */
   /* replace907_1_1 -> 135 in the cache */
   /* replace907_1 -> 1667 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2603, 1667 },
      -1,
   } },

   /* ('ige', ('imin', '#a', 'b'), '#c') => ('iand', ('ige', 'a', 'c'), ('ige', 'b', 'c')) */
   /* search908_0_0 -> 292 in the cache */
   /* search908_0_1 -> 133 in the cache */
   /* search908_0 -> 2597 in the cache */
   /* search908_1 -> 824 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 2597, 824 },
      -1,
   } },

   /* replace908_0_0 -> 132 in the cache */
   /* replace908_0_1 -> 135 in the cache */
   /* replace908_0 -> 1667 in the cache */
   /* replace908_1_0 -> 133 in the cache */
   /* replace908_1_1 -> 135 in the cache */
   /* replace908_1 -> 2607 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1667, 2607 },
      -1,
   } },

   /* ('ult', '#a', ('umin', '#b', 'c')) => ('iand', ('ult', 'a', 'b'), ('ult', 'a', 'c')) */
   /* search909_0 -> 292 in the cache */
   /* search909_1_0 -> 293 in the cache */
   /* search909_1_1 -> 135 in the cache */
   /* search909_1 -> 2617 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 292, 2617 },
      -1,
   } },

   /* replace909_0_0 -> 132 in the cache */
   /* replace909_0_1 -> 133 in the cache */
   /* replace909_0 -> 2611 in the cache */
   /* replace909_1_0 -> 132 in the cache */
   /* replace909_1_1 -> 135 in the cache */
   /* replace909_1 -> 1677 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2611, 1677 },
      -1,
   } },

   /* ('ult', ('umax', '#a', 'b'), '#c') => ('iand', ('ult', 'a', 'c'), ('ult', 'b', 'c')) */
   /* search910_0_0 -> 292 in the cache */
   /* search910_0_1 -> 133 in the cache */
   /* search910_0 -> 2621 in the cache */
   /* search910_1 -> 824 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 2621, 824 },
      -1,
   } },

   /* replace910_0_0 -> 132 in the cache */
   /* replace910_0_1 -> 135 in the cache */
   /* replace910_0 -> 1677 in the cache */
   /* replace910_1_0 -> 133 in the cache */
   /* replace910_1_1 -> 135 in the cache */
   /* replace910_1 -> 2615 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1677, 2615 },
      -1,
   } },

   /* ('uge', '#a', ('umax', '#b', 'c')) => ('iand', ('uge', 'a', 'b'), ('uge', 'a', 'c')) */
   /* search911_0 -> 292 in the cache */
   /* search911_1_0 -> 293 in the cache */
   /* search911_1_1 -> 135 in the cache */
   /* search911_1 -> 2609 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 292, 2609 },
      -1,
   } },

   /* replace911_0_0 -> 132 in the cache */
   /* replace911_0_1 -> 133 in the cache */
   /* replace911_0 -> 2619 in the cache */
   /* replace911_1_0 -> 132 in the cache */
   /* replace911_1_1 -> 135 in the cache */
   /* replace911_1 -> 1687 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2619, 1687 },
      -1,
   } },

   /* ('uge', ('umin', '#a', 'b'), '#c') => ('iand', ('uge', 'a', 'c'), ('uge', 'b', 'c')) */
   /* search912_0_0 -> 292 in the cache */
   /* search912_0_1 -> 133 in the cache */
   /* search912_0 -> 2613 in the cache */
   /* search912_1 -> 824 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 2613, 824 },
      -1,
   } },

   /* replace912_0_0 -> 132 in the cache */
   /* replace912_0_1 -> 135 in the cache */
   /* replace912_0 -> 1687 in the cache */
   /* replace912_1_0 -> 133 in the cache */
   /* replace912_1_1 -> 135 in the cache */
   /* replace912_1 -> 2623 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1687, 2623 },
      -1,
   } },

   /* ('bcsel', ('ilt', 'a', 0), ('ineg', ('ishr', 'a', 'b')), ('ishr', 'a', 'b')) => ('iabs', ('ishr', 'a', 'b')) */
   /* search913_0_0 -> 32 in the cache */
   /* search913_0_1 -> 61 in the cache */
   /* search913_0 -> 1263 in the cache */
   /* search913_1_0_0 -> 32 in the cache */
   /* search913_1_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 32, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2641 },
      -1,
   } },
   /* search913_2_0 -> 32 in the cache */
   /* search913_2_1 -> 36 in the cache */
   /* search913_2 -> 2641 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1263, 2642, 2641 },
      -1,
   } },

   /* replace913_0_0 -> 32 in the cache */
   /* replace913_0_1 -> 36 in the cache */
   /* replace913_0 -> 2641 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 2641 },
      -1,
   } },

   /* ('iabs', ('ishr', ('iabs', 'a'), 'b')) => ('ishr', ('iabs', 'a'), 'b') */
   /* search914_0_0_0 -> 32 in the cache */
   /* search914_0_0 -> 114 in the cache */
   /* search914_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 114, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 2645 },
      -1,
   } },

   /* replace914_0_0 -> 32 in the cache */
   /* replace914_0 -> 114 in the cache */
   /* replace914_1 -> 36 in the cache */
   /* replace914 -> 2645 in the cache */

   /* ('fabs', ('slt', 'a', 'b')) => ('slt', 'a', 'b') */
   /* search915_0_0 -> 0 in the cache */
   /* search915_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_slt,
      -1, 0,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 2647 },
      -1,
   } },

   /* replace915_0 -> 0 in the cache */
   /* replace915_1 -> 3 in the cache */
   /* replace915 -> 2647 in the cache */

   /* ('fabs', ('sge', 'a', 'b')) => ('sge', 'a', 'b') */
   /* search916_0_0 -> 0 in the cache */
   /* search916_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sge,
      -1, 0,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 2649 },
      -1,
   } },

   /* replace916_0 -> 0 in the cache */
   /* replace916_1 -> 3 in the cache */
   /* replace916 -> 2649 in the cache */

   /* ('fabs', ('seq', 'a', 'b')) => ('seq', 'a', 'b') */
   /* search917_0_0 -> 0 in the cache */
   /* search917_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 1,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 1,
      { 2651 },
      -1,
   } },

   /* replace917_0 -> 0 in the cache */
   /* replace917_1 -> 3 in the cache */
   /* replace917 -> 2651 in the cache */

   /* ('fabs', ('sne', 'a', 'b')) => ('sne', 'a', 'b') */
   /* search918_0_0 -> 0 in the cache */
   /* search918_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 1,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 1,
      { 2653 },
      -1,
   } },

   /* replace918_0 -> 0 in the cache */
   /* replace918_1 -> 3 in the cache */
   /* replace918 -> 2653 in the cache */

   /* ('slt', 'a', 'b') => ('b2f', ('flt', 'a', 'b')) */
   /* search919_0 -> 0 in the cache */
   /* search919_1 -> 3 in the cache */
   /* search919 -> 2647 in the cache */

   /* replace919_0_0 -> 0 in the cache */
   /* replace919_0_1 -> 3 in the cache */
   /* replace919_0 -> 1059 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1059 },
      -1,
   } },

   /* ('sge', 'a', 'b') => ('b2f', ('fge', 'a', 'b')) */
   /* search920_0 -> 0 in the cache */
   /* search920_1 -> 3 in the cache */
   /* search920 -> 2649 in the cache */

   /* replace920_0_0 -> 0 in the cache */
   /* replace920_0_1 -> 3 in the cache */
   /* replace920_0 -> 1056 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1056 },
      -1,
   } },

   /* ('seq', 'a', 'b') => ('b2f', ('feq', 'a', 'b')) */
   /* search921_0 -> 0 in the cache */
   /* search921_1 -> 3 in the cache */
   /* search921 -> 2651 in the cache */

   /* replace921_0_0 -> 0 in the cache */
   /* replace921_0_1 -> 3 in the cache */
   /* replace921_0 -> 1065 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 1,
      { 1065 },
      -1,
   } },

   /* ('sne', 'a', 'b') => ('b2f', ('fneu', 'a', 'b')) */
   /* search922_0 -> 0 in the cache */
   /* search922_1 -> 3 in the cache */
   /* search922 -> 2653 in the cache */

   /* replace922_0_0 -> 0 in the cache */
   /* replace922_0_1 -> 3 in the cache */
   /* replace922_0 -> 1062 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 1,
      { 1062 },
      -1,
   } },

   /* ('seq', ('seq', 'a', 'b'), 1.0) => ('seq', 'a', 'b') */
   /* search923_0_0 -> 0 in the cache */
   /* search923_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search923_1 -> 280 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 2,
      { 2659, 280 },
      -1,
   } },

   /* replace923_0 -> 0 in the cache */
   /* replace923_1 -> 3 in the cache */
   /* replace923 -> 2651 in the cache */

   /* ('seq', ('sne', 'a', 'b'), 1.0) => ('sne', 'a', 'b') */
   /* search924_0_0 -> 0 in the cache */
   /* search924_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search924_1 -> 280 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 2,
      { 2661, 280 },
      -1,
   } },

   /* replace924_0 -> 0 in the cache */
   /* replace924_1 -> 3 in the cache */
   /* replace924 -> 2653 in the cache */

   /* ('seq', ('slt', 'a', 'b'), 1.0) => ('slt', 'a', 'b') */
   /* search925_0_0 -> 0 in the cache */
   /* search925_0_1 -> 3 in the cache */
   /* search925_0 -> 2647 in the cache */
   /* search925_1 -> 280 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 1,
      { 2647, 280 },
      -1,
   } },

   /* replace925_0 -> 0 in the cache */
   /* replace925_1 -> 3 in the cache */
   /* replace925 -> 2647 in the cache */

   /* ('seq', ('sge', 'a', 'b'), 1.0) => ('sge', 'a', 'b') */
   /* search926_0_0 -> 0 in the cache */
   /* search926_0_1 -> 3 in the cache */
   /* search926_0 -> 2649 in the cache */
   /* search926_1 -> 280 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 1,
      { 2649, 280 },
      -1,
   } },

   /* replace926_0 -> 0 in the cache */
   /* replace926_1 -> 3 in the cache */
   /* replace926 -> 2649 in the cache */

   /* ('sne', ('seq', 'a', 'b'), 0.0) => ('seq', 'a', 'b') */
   /* search927_0_0 -> 0 in the cache */
   /* search927_0_1 -> 3 in the cache */
   /* search927_0 -> 2659 in the cache */
   /* search927_1 -> 266 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 2,
      { 2659, 266 },
      -1,
   } },

   /* replace927_0 -> 0 in the cache */
   /* replace927_1 -> 3 in the cache */
   /* replace927 -> 2651 in the cache */

   /* ('sne', ('sne', 'a', 'b'), 0.0) => ('sne', 'a', 'b') */
   /* search928_0_0 -> 0 in the cache */
   /* search928_0_1 -> 3 in the cache */
   /* search928_0 -> 2661 in the cache */
   /* search928_1 -> 266 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 2,
      { 2661, 266 },
      -1,
   } },

   /* replace928_0 -> 0 in the cache */
   /* replace928_1 -> 3 in the cache */
   /* replace928 -> 2653 in the cache */

   /* ('sne', ('slt', 'a', 'b'), 0.0) => ('slt', 'a', 'b') */
   /* search929_0_0 -> 0 in the cache */
   /* search929_0_1 -> 3 in the cache */
   /* search929_0 -> 2647 in the cache */
   /* search929_1 -> 266 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 1,
      { 2647, 266 },
      -1,
   } },

   /* replace929_0 -> 0 in the cache */
   /* replace929_1 -> 3 in the cache */
   /* replace929 -> 2647 in the cache */

   /* ('sne', ('sge', 'a', 'b'), 0.0) => ('sge', 'a', 'b') */
   /* search930_0_0 -> 0 in the cache */
   /* search930_0_1 -> 3 in the cache */
   /* search930_0 -> 2649 in the cache */
   /* search930_1 -> 266 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 1,
      { 2649, 266 },
      -1,
   } },

   /* replace930_0 -> 0 in the cache */
   /* replace930_1 -> 3 in the cache */
   /* replace930 -> 2649 in the cache */

   /* ('seq', ('seq', 'a', 'b'), 0.0) => ('sne', 'a', 'b') */
   /* search931_0_0 -> 0 in the cache */
   /* search931_0_1 -> 3 in the cache */
   /* search931_0 -> 2659 in the cache */
   /* search931_1 -> 266 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 2,
      { 2659, 266 },
      -1,
   } },

   /* replace931_0 -> 0 in the cache */
   /* replace931_1 -> 3 in the cache */
   /* replace931 -> 2653 in the cache */

   /* ('seq', ('sne', 'a', 'b'), 0.0) => ('seq', 'a', 'b') */
   /* search932_0_0 -> 0 in the cache */
   /* search932_0_1 -> 3 in the cache */
   /* search932_0 -> 2661 in the cache */
   /* search932_1 -> 266 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 2,
      { 2661, 266 },
      -1,
   } },

   /* replace932_0 -> 0 in the cache */
   /* replace932_1 -> 3 in the cache */
   /* replace932 -> 2651 in the cache */

   /* ('seq', ('slt', 'a', 'b'), 0.0) => ('sge', 'a', 'b') */
   /* search933_0_0 -> 0 in the cache */
   /* search933_0_1 -> 3 in the cache */
   /* search933_0 -> 2647 in the cache */
   /* search933_1 -> 266 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 1,
      { 2647, 266 },
      -1,
   } },

   /* replace933_0 -> 0 in the cache */
   /* replace933_1 -> 3 in the cache */
   /* replace933 -> 2649 in the cache */

   /* ('seq', ('sge', 'a', 'b'), 0.0) => ('slt', 'a', 'b') */
   /* search934_0_0 -> 0 in the cache */
   /* search934_0_1 -> 3 in the cache */
   /* search934_0 -> 2649 in the cache */
   /* search934_1 -> 266 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 1,
      { 2649, 266 },
      -1,
   } },

   /* replace934_0 -> 0 in the cache */
   /* replace934_1 -> 3 in the cache */
   /* replace934 -> 2647 in the cache */

   /* ('sne', ('seq', 'a', 'b'), 1.0) => ('sne', 'a', 'b') */
   /* search935_0_0 -> 0 in the cache */
   /* search935_0_1 -> 3 in the cache */
   /* search935_0 -> 2659 in the cache */
   /* search935_1 -> 280 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 2,
      { 2659, 280 },
      -1,
   } },

   /* replace935_0 -> 0 in the cache */
   /* replace935_1 -> 3 in the cache */
   /* replace935 -> 2653 in the cache */

   /* ('sne', ('sne', 'a', 'b'), 1.0) => ('seq', 'a', 'b') */
   /* search936_0_0 -> 0 in the cache */
   /* search936_0_1 -> 3 in the cache */
   /* search936_0 -> 2661 in the cache */
   /* search936_1 -> 280 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 2,
      { 2661, 280 },
      -1,
   } },

   /* replace936_0 -> 0 in the cache */
   /* replace936_1 -> 3 in the cache */
   /* replace936 -> 2651 in the cache */

   /* ('sne', ('slt', 'a', 'b'), 1.0) => ('sge', 'a', 'b') */
   /* search937_0_0 -> 0 in the cache */
   /* search937_0_1 -> 3 in the cache */
   /* search937_0 -> 2647 in the cache */
   /* search937_1 -> 280 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 1,
      { 2647, 280 },
      -1,
   } },

   /* replace937_0 -> 0 in the cache */
   /* replace937_1 -> 3 in the cache */
   /* replace937 -> 2649 in the cache */

   /* ('sne', ('sge', 'a', 'b'), 1.0) => ('slt', 'a', 'b') */
   /* search938_0_0 -> 0 in the cache */
   /* search938_0_1 -> 3 in the cache */
   /* search938_0 -> 2649 in the cache */
   /* search938_1 -> 280 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 1,
      { 2649, 280 },
      -1,
   } },

   /* replace938_0 -> 0 in the cache */
   /* replace938_1 -> 3 in the cache */
   /* replace938 -> 2647 in the cache */

   /* ('fall_equal2', 'a', 'b') => ('fmin', ('seq', 'a.x', 'b.x'), ('seq', 'a.y', 'b.y')) */
   /* search939_0 -> 16 in the cache */
   /* search939_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fall_equal2,
      0, 1,
      { 16, 36 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0},
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_seq,
      0, 1,
      { 2678, 2679 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {1},
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {1},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_seq,
      1, 1,
      { 2681, 2682 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmin,
      -1, 2,
      { 2680, 2683 },
      -1,
   } },

   /* ('fall_equal3', 'a', 'b') => ('seq', ('fany_nequal3', 'a', 'b'), 0.0) */
   /* search940_0 -> 16 in the cache */
   /* search940_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fall_equal3,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* replace940_0_0 -> 16 in the cache */
   /* replace940_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fany_nequal3,
      1, 1,
      { 16, 36 },
      -1,
   } },
   /* replace940_1 -> 121 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_seq,
      0, 2,
      { 2686, 121 },
      -1,
   } },

   /* ('fall_equal4', 'a', 'b') => ('seq', ('fany_nequal4', 'a', 'b'), 0.0) */
   /* search941_0 -> 16 in the cache */
   /* search941_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fall_equal4,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* replace941_0_0 -> 16 in the cache */
   /* replace941_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fany_nequal4,
      1, 1,
      { 16, 36 },
      -1,
   } },
   /* replace941_1 -> 121 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_seq,
      0, 2,
      { 2689, 121 },
      -1,
   } },

   /* ('fall_equal8', 'a', 'b') => ('seq', ('fany_nequal8', 'a', 'b'), 0.0) */
   /* search942_0 -> 16 in the cache */
   /* search942_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fall_equal8,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* replace942_0_0 -> 16 in the cache */
   /* replace942_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fany_nequal8,
      1, 1,
      { 16, 36 },
      -1,
   } },
   /* replace942_1 -> 121 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_seq,
      0, 2,
      { 2692, 121 },
      -1,
   } },

   /* ('fall_equal16', 'a', 'b') => ('seq', ('fany_nequal16', 'a', 'b'), 0.0) */
   /* search943_0 -> 16 in the cache */
   /* search943_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fall_equal16,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* replace943_0_0 -> 16 in the cache */
   /* replace943_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fany_nequal16,
      1, 1,
      { 16, 36 },
      -1,
   } },
   /* replace943_1 -> 121 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_seq,
      0, 2,
      { 2695, 121 },
      -1,
   } },

   /* ('fany_nequal2', 'a', 'b') => ('fmax', ('sne', 'a.x', 'b.x'), ('sne', 'a.y', 'b.y')) */
   /* search944_0 -> 16 in the cache */
   /* search944_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fany_nequal2,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* replace944_0_0 -> 2678 in the cache */
   /* replace944_0_1 -> 2679 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sne,
      0, 1,
      { 2678, 2679 },
      -1,
   } },
   /* replace944_1_0 -> 2681 in the cache */
   /* replace944_1_1 -> 2682 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sne,
      1, 1,
      { 2681, 2682 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmax,
      -1, 2,
      { 2698, 2699 },
      -1,
   } },

   /* ('fany_nequal3', 'a', 'b') => ('fsat', ('fdot3', ('sne', 'a', 'b'), ('sne', 'a', 'b'))) */
   /* search945_0 -> 16 in the cache */
   /* search945_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fany_nequal3,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* replace945_0_0_0 -> 16 in the cache */
   /* replace945_0_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sne,
      0, 1,
      { 16, 36 },
      -1,
   } },
   /* replace945_0_1_0 -> 16 in the cache */
   /* replace945_0_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sne,
      1, 1,
      { 16, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fdot3,
      -1, 2,
      { 2702, 2703 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
    