/* DO NOT EDIT - This file generated automatically by api_exec_init.py script */

/*
 * Copyright (C) 2012 Intel Corporation
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.  IN NO EVENT SHALL
 * Intel Corporation,
 * AND/OR THEIR SUPPLIERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
 * OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

/**
 * \file api_exec_init.c
 * Initialize dispatch table.
 */


#include "api_exec_decl.h"
#include "glapi/glapi.h"
#include "main/context.h"
#include "main/dispatch.h"


/**
 * Initialize a context's OutsideBeginEnd table with pointers to Mesa's supported
 * GL functions.
 *
 * This function depends on ctx->Version.
 *
 * \param ctx  GL context
 */
void
_mesa_init_dispatch(struct gl_context *ctx)
{
   struct _glapi_table *table = ctx->Dispatch.OutsideBeginEnd;

   assert(table != NULL);
   assert(ctx->Version > 0);

   if (!_mesa_is_no_error_enabled(ctx) && (_mesa_is_desktop_gl(ctx) || (_mesa_is_gles2(ctx) && ctx->Version >= 30))) {
      SET_BeginTransformFeedback(table, _mesa_BeginTransformFeedback);
      SET_BindBufferRange(table, _mesa_BindBufferRange);
      SET_BindFragDataLocation(table, _mesa_BindFragDataLocation);
      SET_BindFragDataLocationIndexed(table, _mesa_BindFragDataLocationIndexed);
      SET_BindTransformFeedback(table, _mesa_BindTransformFeedback);
      SET_BlendEquationSeparateiARB(table, _mesa_BlendEquationSeparateiARB);
      SET_BlendEquationiARB(table, _mesa_BlendEquationiARB);
      SET_BlendFuncSeparateiARB(table, _mesa_BlendFuncSeparateiARB);
      SET_BlendFunciARB(table, _mesa_BlendFunciARB);
      SET_BlitFramebuffer(table, _mesa_BlitFramebuffer);
      SET_ClearBufferfi(table, _mesa_ClearBufferfi);
      SET_ClearBufferfv(table, _mesa_ClearBufferfv);
      SET_ClearBufferiv(table, _mesa_ClearBufferiv);
      SET_ClearBufferuiv(table, _mesa_ClearBufferuiv);
      SET_CopyBufferSubData(table, _mesa_CopyBufferSubData);
      SET_CopyImageSubData(table, _mesa_CopyImageSubData);
      SET_EndTransformFeedback(table, _mesa_EndTransformFeedback);
      SET_FramebufferTextureLayer(table, _mesa_FramebufferTextureLayer);
      SET_InvalidateFramebuffer(table, _mesa_InvalidateFramebuffer);
      SET_InvalidateSubFramebuffer(table, _mesa_InvalidateSubFramebuffer);
      SET_MinSampleShading(table, _mesa_MinSampleShading);
      SET_PauseTransformFeedback(table, _mesa_PauseTransformFeedback);
      SET_ResumeTransformFeedback(table, _mesa_ResumeTransformFeedback);
      SET_TransformFeedbackVaryings(table, _mesa_TransformFeedbackVaryings);
      SET_UniformBlockBinding(table, _mesa_UniformBlockBinding);
      SET_VertexAttribIPointer(table, _mesa_VertexAttribIPointer);
   }
   if (!_mesa_is_no_error_enabled(ctx) && (_mesa_is_desktop_gl(ctx) || (_mesa_is_gles2(ctx) && ctx->Version >= 31))) {
      SET_BindImageTexture(table, _mesa_BindImageTexture);
      SET_BindVertexBuffer(table, _mesa_BindVertexBuffer);
      SET_BufferStorage(table, _mesa_BufferStorage);
      SET_DispatchCompute(table, _mesa_DispatchCompute);
      SET_DispatchComputeIndirect(table, _mesa_DispatchComputeIndirect);
      SET_FramebufferSampleLocationsfvARB(table, _mesa_FramebufferSampleLocationsfvARB);
      SET_MemoryBarrierByRegion(table, _mesa_MemoryBarrierByRegion);
      SET_NamedFramebufferSampleLocationsfvARB(table, _mesa_NamedFramebufferSampleLocationsfvARB);
      SET_PatchParameteri(table, _mesa_PatchParameteri);
      SET_SampleMaski(table, _mesa_SampleMaski);
      SET_TextureView(table, _mesa_TextureView);
      SET_VertexAttribBinding(table, _mesa_VertexAttribBinding);
      SET_VertexBindingDivisor(table, _mesa_VertexBindingDivisor);
      SET_ViewportSwizzleNV(table, _mesa_ViewportSwizzleNV);
   }
   if (!_mesa_is_no_error_enabled(ctx) && (_mesa_is_desktop_gl(ctx) || (_mesa_is_gles2(ctx) && ctx->Version >= 32))) {
      SET_BufferStorageMemEXT(table, _mesa_BufferStorageMemEXT);
      SET_NamedBufferStorageMemEXT(table, _mesa_NamedBufferStorageMemEXT);
   }
   if (!_mesa_is_no_error_enabled(ctx) && (_mesa_is_desktop_gl(ctx) || _mesa_is_gles1(ctx) || _mesa_is_gles2(ctx))) {
      SET_ActiveTexture(table, _mesa_ActiveTexture);
      SET_BindBuffer(table, _mesa_BindBuffer);
      SET_BindTexture(table, _mesa_BindTexture);
      SET_BlendEquationSeparate(table, _mesa_BlendEquationSeparate);
      SET_BlendFunc(table, _mesa_BlendFunc);
      SET_BlendFuncSeparate(table, _mesa_BlendFuncSeparate);
      SET_BufferData(table, _mesa_BufferData);
      SET_BufferSubData(table, _mesa_BufferSubData);
      SET_CheckFramebufferStatus(table, _mesa_CheckFramebufferStatus);
      SET_Clear(table, _mesa_Clear);
      SET_ClientWaitSync(table, _mesa_ClientWaitSync);
      SET_CompressedTexImage2D(table, _mesa_CompressedTexImage2D);
      SET_CompressedTexSubImage2D(table, _mesa_CompressedTexSubImage2D);
      SET_ConservativeRasterParameterfNV(table, _mesa_ConservativeRasterParameterfNV);
      SET_ConservativeRasterParameteriNV(table, _mesa_ConservativeRasterParameteriNV);
      SET_CopyTexImage2D(table, _mesa_CopyTexImage2D);
      SET_CopyTexSubImage2D(table, _mesa_CopyTexSubImage2D);
      SET_CullFace(table, _mesa_CullFace);
      SET_DeleteBuffers(table, _mesa_DeleteBuffers);
      SET_DeleteSync(table, _mesa_DeleteSync);
      SET_DeleteTextures(table, _mesa_DeleteTextures);
      SET_DepthFunc(table, _mesa_DepthFunc);
      SET_FenceSync(table, _mesa_FenceSync);
      SET_FlushMappedBufferRange(table, _mesa_FlushMappedBufferRange);
      SET_FramebufferRenderbuffer(table, _mesa_FramebufferRenderbuffer);
      SET_FramebufferTexture2D(table, _mesa_FramebufferTexture2D);
      SET_FrontFace(table, _mesa_FrontFace);
      SET_GenBuffers(table, _mesa_GenBuffers);
      SET_GenRenderbuffers(table, _mesa_GenRenderbuffers);
      SET_GenTextures(table, _mesa_GenTextures);
      SET_GenerateMipmap(table, _mesa_GenerateMipmap);
      SET_LineWidth(table, _mesa_LineWidth);
      SET_MapBuffer(table, _mesa_MapBuffer);
      SET_MapBufferRange(table, _mesa_MapBufferRange);
      SET_PixelStorei(table, _mesa_PixelStorei);
      SET_ReadPixels(table, _mesa_ReadPixels);
      SET_Scissor(table, _mesa_Scissor);
      SET_StencilFunc(table, _mesa_StencilFunc);
      SET_StencilOp(table, _mesa_StencilOp);
      SET_SubpixelPrecisionBiasNV(table, _mesa_SubpixelPrecisionBiasNV);
      SET_TexImage2D(table, _mesa_TexImage2D);
      SET_TexSubImage2D(table, _mesa_TexSubImage2D);
      SET_UnmapBuffer(table, _mesa_UnmapBuffer);
      SET_Viewport(table, _mesa_Viewport);
      SET_WaitSync(table, _mesa_WaitSync);
   }
   if (!_mesa_is_no_error_enabled(ctx) && (_mesa_is_desktop_gl(ctx) || _mesa_is_gles1(ctx))) {
      SET_LogicOp(table, _mesa_LogicOp);
      SET_PointSize(table, _mesa_PointSize);
   }
   if (!_mesa_is_no_error_enabled(ctx) && (_mesa_is_desktop_gl(ctx) || _mesa_is_gles2(ctx))) {
      SET_ActiveShaderProgram(table, _mesa_ActiveShaderProgram);
      SET_AttachShader(table, _mesa_AttachShader);
      SET_BeginConditionalRender(table, _mesa_BeginConditionalRender);
      SET_BindAttribLocation(table, _mesa_BindAttribLocation);
      SET_BindProgramPipeline(table, _mesa_BindProgramPipeline);
      SET_BindSampler(table, _mesa_BindSampler);
      SET_BindVertexArray(table, _mesa_BindVertexArray);
      SET_ClipControl(table, _mesa_ClipControl);
      SET_CompressedTexImage3D(table, _mesa_CompressedTexImage3D);
      SET_CompressedTexSubImage3D(table, _mesa_CompressedTexSubImage3D);
      SET_CopyTexSubImage3D(table, _mesa_CopyTexSubImage3D);
      SET_CreateShader(table, _mesa_CreateShader);
      SET_DeleteSamplers(table, _mesa_DeleteSamplers);
      SET_DeleteVertexArrays(table, _mesa_DeleteVertexArrays);
      SET_DetachShader(table, _mesa_DetachShader);
      SET_DisableVertexAttribArray(table, _mesa_DisableVertexAttribArray);
      SET_DrawBuffers(table, _mesa_DrawBuffers);
      SET_EnableVertexAttribArray(table, _mesa_EnableVertexAttribArray);
      SET_EndConditionalRender(table, _mesa_EndConditionalRender);
      SET_FramebufferTexture3D(table, _mesa_FramebufferTexture3D);
      SET_GenProgramPipelines(table, _mesa_GenProgramPipelines);
      SET_GenSamplers(table, _mesa_GenSamplers);
      SET_GenVertexArrays(table, _mesa_GenVertexArrays);
      SET_GetUniformLocation(table, _mesa_GetUniformLocation);
      SET_LinkProgram(table, _mesa_LinkProgram);
      SET_ProgramParameteri(table, _mesa_ProgramParameteri);
      SET_ReadBuffer(table, _mesa_ReadBuffer);
      SET_ReadnPixelsARB(table, _mesa_ReadnPixelsARB);
      SET_ShaderSource(table, _mesa_ShaderSource);
      SET_StencilFuncSeparate(table, _mesa_StencilFuncSeparate);
      SET_StencilMaskSeparate(table, _mesa_StencilMaskSeparate);
      SET_StencilOpSeparate(table, _mesa_StencilOpSeparate);
      SET_TexImage3D(table, _mesa_TexImage3D);
      SET_TexStorage2D(table, _mesa_TexStorage2D);
      SET_TexStorage3D(table, _mesa_TexStorage3D);
      SET_TexSubImage3D(table, _mesa_TexSubImage3D);
      SET_UseProgram(table, _mesa_UseProgram);
      SET_UseProgramStages(table, _mesa_UseProgramStages);
      SET_VertexAttribDivisor(table, _mesa_VertexAttribDivisor);
      SET_VertexAttribPointer(table, _mesa_VertexAttribPointer);
   }
   if (!_mesa_is_no_error_enabled(ctx) && (_mesa_is_desktop_gl(ctx))) {
      SET_AlphaToCoverageDitherControlNV(table, _mesa_AlphaToCoverageDitherControlNV);
      SET_AttachObjectARB(table, _mesa_AttachObjectARB);
      SET_BindBufferOffsetEXT(table, _mesa_BindBufferOffsetEXT);
      SET_BindImageTextures(table, _mesa_BindImageTextures);
      SET_BindSamplers(table, _mesa_BindSamplers);
      SET_BindTextures(table, _mesa_BindTextures);
      SET_BindVertexBuffers(table, _mesa_BindVertexBuffers);
      SET_ClearBufferData(table, _mesa_ClearBufferData);
      SET_ClearBufferSubData(table, _mesa_ClearBufferSubData);
      SET_CompressedTexImage1D(table, _mesa_CompressedTexImage1D);
      SET_CompressedTexSubImage1D(table, _mesa_CompressedTexSubImage1D);
      SET_CopyImageSubDataNV(table, _mesa_CopyImageSubDataNV);
      SET_CopyTexImage1D(table, _mesa_CopyTexImage1D);
      SET_CopyTexSubImage1D(table, _mesa_CopyTexSubImage1D);
      SET_CreateShaderObjectARB(table, _mesa_CreateShaderObjectARB);
      SET_DetachObjectARB(table, _mesa_DetachObjectARB);
      SET_DispatchComputeGroupSizeARB(table, _mesa_DispatchComputeGroupSizeARB);
      SET_DrawBuffer(table, _mesa_DrawBuffer);
      SET_FramebufferTexture1D(table, _mesa_FramebufferTexture1D);
      SET_GetImageHandleARB(table, _mesa_GetImageHandleARB);
      SET_GetTextureHandleARB(table, _mesa_GetTextureHandleARB);
      SET_GetTextureSamplerHandleARB(table, _mesa_GetTextureSamplerHandleARB);
      SET_InvalidateBufferData(table, _mesa_InvalidateBufferData);
      SET_InvalidateBufferSubData(table, _mesa_InvalidateBufferSubData);
      SET_InvalidateTexImage(table, _mesa_InvalidateTexImage);
      SET_InvalidateTexSubImage(table, _mesa_InvalidateTexSubImage);
      SET_IsImageHandleResidentARB(table, _mesa_IsImageHandleResidentARB);
      SET_IsTextureHandleResidentARB(table, _mesa_IsTextureHandleResidentARB);
      SET_MakeImageHandleNonResidentARB(table, _mesa_MakeImageHandleNonResidentARB);
      SET_MakeImageHandleResidentARB(table, _mesa_MakeImageHandleResidentARB);
      SET_MakeTextureHandleNonResidentARB(table, _mesa_MakeTextureHandleNonResidentARB);
      SET_MakeTextureHandleResidentARB(table, _mesa_MakeTextureHandleResidentARB);
      SET_PixelStoref(table, _mesa_PixelStoref);
      SET_PolygonMode(table, _mesa_PolygonMode);
      SET_PrimitiveRestartIndex(table, _mesa_PrimitiveRestartIndex);
      SET_ShaderStorageBlockBinding(table, _mesa_ShaderStorageBlockBinding);
      SET_TexImage1D(table, _mesa_TexImage1D);
      SET_TexStorage1D(table, _mesa_TexStorage1D);
      SET_TexSubImage1D(table, _mesa_TexSubImage1D);
      SET_UnmapNamedBufferEXT(table, _mesa_UnmapNamedBufferEXT);
   }
   if (!_mesa_is_no_error_enabled(ctx) && (_mesa_is_desktop_gl_compat(ctx) || _mesa_is_desktop_gl_core(ctx) || (_mesa_is_gles2(ctx) && ctx->Version >= 31))) {
      SET_FramebufferTexture(table, _mesa_FramebufferTexture);
      SET_ScissorArrayv(table, _mesa_ScissorArrayv);
      SET_ScissorIndexed(table, _mesa_ScissorIndexed);
      SET_ScissorIndexedv(table, _mesa_ScissorIndexedv);
      SET_ViewportArrayv(table, _mesa_ViewportArrayv);
      SET_ViewportIndexedf(table, _mesa_ViewportIndexedf);
      SET_ViewportIndexedfv(table, _mesa_ViewportIndexedfv);
   }
   if (!_mesa_is_no_error_enabled(ctx) && (_mesa_is_desktop_gl_compat(ctx) || _mesa_is_desktop_gl_core(ctx))) {
      SET_BindTextureUnit(table, _mesa_BindTextureUnit);
      SET_BlitNamedFramebuffer(table, _mesa_BlitNamedFramebuffer);
      SET_ClearNamedBufferData(table, _mesa_ClearNamedBufferData);
      SET_ClearNamedBufferSubData(table, _mesa_ClearNamedBufferSubData);
      SET_CompressedTextureSubImage1D(table, _mesa_CompressedTextureSubImage1D);
      SET_CompressedTextureSubImage2D(table, _mesa_CompressedTextureSubImage2D);
      SET_CompressedTextureSubImage3D(table, _mesa_CompressedTextureSubImage3D);
      SET_CopyNamedBufferSubData(table, _mesa_CopyNamedBufferSubData);
      SET_CopyTextureSubImage1D(table, _mesa_CopyTextureSubImage1D);
      SET_CopyTextureSubImage2D(table, _mesa_CopyTextureSubImage2D);
      SET_CopyTextureSubImage3D(table, _mesa_CopyTextureSubImage3D);
      SET_CreateBuffers(table, _mesa_CreateBuffers);
      SET_CreateProgramPipelines(table, _mesa_CreateProgramPipelines);
      SET_CreateRenderbuffers(table, _mesa_CreateRenderbuffers);
      SET_CreateSamplers(table, _mesa_CreateSamplers);
      SET_CreateTextures(table, _mesa_CreateTextures);
      SET_CreateVertexArrays(table, _mesa_CreateVertexArrays);
      SET_DepthRangeArrayv(table, _mesa_DepthRangeArrayv);
      SET_DepthRangeIndexed(table, _mesa_DepthRangeIndexed);
      SET_DisableVertexArrayAttrib(table, _mesa_DisableVertexArrayAttrib);
      SET_EnableVertexArrayAttrib(table, _mesa_EnableVertexArrayAttrib);
      SET_FlushMappedNamedBufferRange(table, _mesa_FlushMappedNamedBufferRange);
      SET_GenerateTextureMipmap(table, _mesa_GenerateTextureMipmap);
      SET_MapNamedBuffer(table, _mesa_MapNamedBuffer);
      SET_MapNamedBufferRange(table, _mesa_MapNamedBufferRange);
      SET_NamedBufferData(table, _mesa_NamedBufferData);
      SET_NamedBufferStorage(table, _mesa_NamedBufferStorage);
      SET_NamedBufferSubData(table, _mesa_NamedBufferSubData);
      SET_NamedFramebufferDrawBuffer(table, _mesa_NamedFramebufferDrawBuffer);
      SET_NamedFramebufferDrawBuffers(table, _mesa_NamedFramebufferDrawBuffers);
      SET_NamedFramebufferReadBuffer(table, _mesa_NamedFramebufferReadBuffer);
      SET_NamedFramebufferRenderbuffer(table, _mesa_NamedFramebufferRenderbuffer);
      SET_NamedFramebufferTexture(table, _mesa_NamedFramebufferTexture);
      SET_NamedFramebufferTextureLayer(table, _mesa_NamedFramebufferTextureLayer);
      SET_TextureStorage1D(table, _mesa_TextureStorage1D);
      SET_TextureStorage2D(table, _mesa_TextureStorage2D);
      SET_TextureStorage3D(table, _mesa_TextureStorage3D);
      SET_TextureSubImage1D(table, _mesa_TextureSubImage1D);
      SET_TextureSubImage2D(table, _mesa_TextureSubImage2D);
      SET_TextureSubImage3D(table, _mesa_TextureSubImage3D);
      SET_VertexArrayAttribBinding(table, _mesa_VertexArrayAttribBinding);
      SET_VertexArrayBindingDivisor(table, _mesa_VertexArrayBindingDivisor);
      SET_VertexArrayElementBuffer(table, _mesa_VertexArrayElementBuffer);
      SET_VertexArrayVertexBuffer(table, _mesa_VertexArrayVertexBuffer);
      SET_VertexArrayVertexBuffers(table, _mesa_VertexArrayVertexBuffers);
      SET_VertexAttribLPointer(table, _mesa_VertexAttribLPointer);
   }
   if (!_mesa_is_no_error_enabled(ctx) && (_mesa_is_desktop_gl_compat(ctx) || _mesa_is_gles1(ctx))) {
      SET_ColorPointer(table, _mesa_ColorPointer);
      SET_NormalPointer(table, _mesa_NormalPointer);
      SET_TexCoordPointer(table, _mesa_TexCoordPointer);
      SET_VertexPointer(table, _mesa_VertexPointer);
   }
   if (!_mesa_is_no_error_enabled(ctx) && (_mesa_is_desktop_gl_compat(ctx))) {
      SET_EdgeFlagPointer(table, _mesa_EdgeFlagPointer);
      SET_FogCoordPointer(table, _mesa_FogCoordPointer);
      SET_IndexPointer(table, _mesa_IndexPointer);
      SET_SecondaryColorPointer(table, _mesa_SecondaryColorPointer);
   }
   if (!_mesa_is_no_error_enabled(ctx) && (_mesa_is_gles1(ctx))) {
      SET_PointSizePointerOES(table, _mesa_PointSizePointerOES);
   }
   if ((_mesa_is_gles2(ctx) && ctx->Version >= 31)) {
      SET_DepthRangeArrayfvOES(table, _mesa_DepthRangeArrayfvOES);
      SET_DepthRangeIndexedfOES(table, _mesa_DepthRangeIndexedfOES);
   }
   if (_mesa_is_desktop_gl(ctx)) {
      SET_BeginQueryIndexed(table, _mesa_BeginQueryIndexed);
      SET_BindBuffersBase(table, _mesa_BindBuffersBase);
      SET_BindBuffersRange(table, _mesa_BindBuffersRange);
      SET_BindFramebufferEXT(table, _mesa_BindFramebufferEXT);
      SET_BindImageTextureEXT(table, _mesa_BindImageTextureEXT);
      SET_BindRenderbufferEXT(table, _mesa_BindRenderbufferEXT);
      SET_BufferPageCommitmentARB(table, _mesa_BufferPageCommitmentARB);
      SET_ClampColor(table, _mesa_ClampColor);
      SET_ClearColorIiEXT(table, _mesa_ClearColorIiEXT);
      SET_ClearColorIuiEXT(table, _mesa_ClearColorIuiEXT);
      SET_ClearDepth(table, _mesa_ClearDepth);
      SET_ClearNamedBufferDataEXT(table, _mesa_ClearNamedBufferDataEXT);
      SET_ClearNamedBufferSubDataEXT(table, _mesa_ClearNamedBufferSubDataEXT);
      SET_CompileShaderIncludeARB(table, _mesa_CompileShaderIncludeARB);
      SET_CreateProgramObjectARB(table, _mesa_CreateProgramObjectARB);
      SET_DeleteNamedStringARB(table, _mesa_DeleteNamedStringARB);
      SET_DeleteObjectARB(table, _mesa_DeleteObjectARB);
      SET_DepthBoundsEXT(table, _mesa_DepthBoundsEXT);
      SET_DepthRange(table, _mesa_DepthRange);
      SET_DrawTransformFeedback(table, _mesa_DrawTransformFeedback);
      SET_DrawTransformFeedbackInstanced(table, _mesa_DrawTransformFeedbackInstanced);
      SET_DrawTransformFeedbackStream(table, _mesa_DrawTransformFeedbackStream);
      SET_DrawTransformFeedbackStreamInstanced(table, _mesa_DrawTransformFeedbackStreamInstanced);
      SET_EGLImageTargetTextureStorageEXT(table, _mesa_EGLImageTargetTextureStorageEXT);
      SET_EndQueryIndexed(table, _mesa_EndQueryIndexed);
      SET_FlushMappedNamedBufferRangeEXT(table, _mesa_FlushMappedNamedBufferRangeEXT);
      SET_GetActiveAtomicCounterBufferiv(table, _mesa_GetActiveAtomicCounterBufferiv);
      SET_GetActiveUniformName(table, _mesa_GetActiveUniformName);
      SET_GetAttachedObjectsARB(table, _mesa_GetAttachedObjectsARB);
      SET_GetBufferSubData(table, _mesa_GetBufferSubData);
      SET_GetCompressedTexImage(table, _mesa_GetCompressedTexImage);
      SET_GetCompressedTextureSubImage(table, _mesa_GetCompressedTextureSubImage);
      SET_GetDoublei_v(table, _mesa_GetDoublei_v);
      SET_GetDoublev(table, _mesa_GetDoublev);
      SET_GetHandleARB(table, _mesa_GetHandleARB);
      SET_GetInfoLogARB(table, _mesa_GetInfoLogARB);
      SET_GetNamedBufferParameterivEXT(table, _mesa_GetNamedBufferParameterivEXT);
      SET_GetNamedBufferPointervEXT(table, _mesa_GetNamedBufferPointervEXT);
      SET_GetNamedBufferSubDataEXT(table, _mesa_GetNamedBufferSubDataEXT);
      SET_GetNamedFramebufferParameterivEXT(table, _mesa_GetNamedFramebufferParameterivEXT);
      SET_GetNamedStringARB(table, _mesa_GetNamedStringARB);
      SET_GetNamedStringivARB(table, _mesa_GetNamedStringivARB);
      SET_GetObjectParameterfvARB(table, _mesa_GetObjectParameterfvARB);
      SET_GetObjectParameterivARB(table, _mesa_GetObjectParameterivARB);
      SET_GetQueryIndexediv(table, _mesa_GetQueryIndexediv);
      SET_GetTexImage(table, _mesa_GetTexImage);
      SET_GetTextureSubImage(table, _mesa_GetTextureSubImage);
      SET_GetVertexAttribdv(table, _mesa_GetVertexAttribdv);
      SET_GetnCompressedTexImageARB(table, _mesa_GetnCompressedTexImageARB);
      SET_GetnPolygonStippleARB(table, _mesa_GetnPolygonStippleARB);
      SET_GetnTexImageARB(table, _mesa_GetnTexImageARB);
      SET_GetnUniformdvARB(table, _mesa_GetnUniformdvARB);
      SET_IsNamedStringARB(table, _mesa_IsNamedStringARB);
      SET_MapNamedBufferEXT(table, _mesa_MapNamedBufferEXT);
      SET_MultiDrawArraysIndirect(table, _mesa_MultiDrawArraysIndirect);
      SET_MultiDrawArraysIndirectCountARB(table, _mesa_MultiDrawArraysIndirectCountARB);
      SET_MultiDrawElementsIndirect(table, _mesa_MultiDrawElementsIndirect);
      SET_MultiDrawElementsIndirectCountARB(table, _mesa_MultiDrawElementsIndirectCountARB);
      SET_MultiModeDrawArraysIBM(table, _mesa_MultiModeDrawArraysIBM);
      SET_MultiModeDrawElementsIBM(table, _mesa_MultiModeDrawElementsIBM);
      SET_NamedBufferDataEXT(table, _mesa_NamedBufferDataEXT);
      SET_NamedBufferPageCommitmentARB(table, _mesa_NamedBufferPageCommitmentARB);
      SET_NamedBufferPageCommitmentEXT(table, _mesa_NamedBufferPageCommitmentEXT);
      SET_NamedBufferStorageEXT(table, _mesa_NamedBufferStorageEXT);
      SET_NamedBufferSubDataEXT(table, _mesa_NamedBufferSubDataEXT);
      SET_NamedFramebufferParameteriEXT(table, _mesa_NamedFramebufferParameteriEXT);
      SET_NamedStringARB(table, _mesa_NamedStringARB);
      SET_PatchParameterfv(table, _mesa_PatchParameterfv);
      SET_PointParameteri(table, _mesa_PointParameteri);
      SET_PointParameteriv(table, _mesa_PointParameteriv);
      SET_ProgramUniform1d(table, _mesa_ProgramUniform1d);
      SET_ProgramUniform1dv(table, _mesa_ProgramUniform1dv);
      SET_ProgramUniform2d(table, _mesa_ProgramUniform2d);
      SET_ProgramUniform2dv(table, _mesa_ProgramUniform2dv);
      SET_ProgramUniform3d(table, _mesa_ProgramUniform3d);
      SET_ProgramUniform3dv(table, _mesa_ProgramUniform3dv);
      SET_ProgramUniform4d(table, _mesa_ProgramUniform4d);
      SET_ProgramUniform4dv(table, _mesa_ProgramUniform4dv);
      SET_ProgramUniformHandleui64ARB(table, _mesa_ProgramUniformHandleui64ARB);
      SET_ProgramUniformHandleui64vARB(table, _mesa_ProgramUniformHandleui64vARB);
      SET_ProgramUniformMatrix2dv(table, _mesa_ProgramUniformMatrix2dv);
      SET_ProgramUniformMatrix2x3dv(table, _mesa_ProgramUniformMatrix2x3dv);
      SET_ProgramUniformMatrix2x4dv(table, _mesa_ProgramUniformMatrix2x4dv);
      SET_ProgramUniformMatrix3dv(table, _mesa_ProgramUniformMatrix3dv);
      SET_ProgramUniformMatrix3x2dv(table, _mesa_ProgramUniformMatrix3x2dv);
      SET_ProgramUniformMatrix3x4dv(table, _mesa_ProgramUniformMatrix3x4dv);
      SET_ProgramUniformMatrix4dv(table, _mesa_ProgramUniformMatrix4dv);
      SET_ProgramUniformMatrix4x2dv(table, _mesa_ProgramUniformMatrix4x2dv);
      SET_ProgramUniformMatrix4x3dv(table, _mesa_ProgramUniformMatrix4x3dv);
      SET_ProvokingVertex(table, _mesa_ProvokingVertex);
      SET_SpecializeShaderARB(table, _mesa_SpecializeShaderARB);
      SET_StringMarkerGREMEDY(table, _mesa_StringMarkerGREMEDY);
      SET_TexImage2DMultisample(table, _mesa_TexImage2DMultisample);
      SET_TexImage3DMultisample(table, _mesa_TexImage3DMultisample);
      SET_TexPageCommitmentARB(table, _mesa_TexPageCommitmentARB);
      SET_TexStorageMem1DEXT(table, _mesa_TexStorageMem1DEXT);
      SET_TextureBufferRangeEXT(table, _mesa_TextureBufferRangeEXT);
      SET_TexturePageCommitmentEXT(table, _mesa_TexturePageCommitmentEXT);
      SET_TextureStorage1DEXT(table, _mesa_TextureStorage1DEXT);
      SET_TextureStorage2DEXT(table, _mesa_TextureStorage2DEXT);
      SET_TextureStorage2DMultisampleEXT(table, _mesa_TextureStorage2DMultisampleEXT);
      SET_TextureStorage3DEXT(table, _mesa_TextureStorage3DEXT);
      SET_TextureStorage3DMultisampleEXT(table, _mesa_TextureStorage3DMultisampleEXT);
      SET_TextureStorageMem1DEXT(table, _mesa_TextureStorageMem1DEXT);
      SET_UniformHandleui64ARB(table, _mesa_UniformHandleui64ARB);
      SET_UniformHandleui64vARB(table, _mesa_UniformHandleui64vARB);
      SET_VDPAUFiniNV(table, _mesa_VDPAUFiniNV);
      SET_VDPAUGetSurfaceivNV(table, _mesa_VDPAUGetSurfaceivNV);
      SET_VDPAUInitNV(table, _mesa_VDPAUInitNV);
      SET_VDPAUIsSurfaceNV(table, _mesa_VDPAUIsSurfaceNV);
      SET_VDPAUMapSurfacesNV(table, _mesa_VDPAUMapSurfacesNV);
      SET_VDPAURegisterOutputSurfaceNV(table, _mesa_VDPAURegisterOutputSurfaceNV);
      SET_VDPAURegisterVideoSurfaceNV(table, _mesa_VDPAURegisterVideoSurfaceNV);
      SET_VDPAUSurfaceAccessNV(table, _mesa_VDPAUSurfaceAccessNV);
      SET_VDPAUUnmapSurfacesNV(table, _mesa_VDPAUUnmapSurfacesNV);
      SET_VDPAUUnregisterSurfaceNV(table, _mesa_VDPAUUnregisterSurfaceNV);
      SET_VertexAttribLFormat(table, _mesa_VertexAttribLFormat);
   }
   if (_mesa_is_desktop_gl(ctx) || (_mesa_is_gles2(ctx) && ctx->Version >= 30)) {
      SET_BindBufferBase(table, _mesa_BindBufferBase);
      SET_ColorMaski(table, _mesa_ColorMaski);
      SET_DeleteTransformFeedbacks(table, _mesa_DeleteTransformFeedbacks);
      SET_Disablei(table, _mesa_Disablei);
      SET_DrawElementsInstancedBaseInstance(table, _mesa_DrawElementsInstancedBaseInstance);
      SET_DrawRangeElements(table, _mesa_DrawRangeElements);
      SET_EGLImageTargetTexStorageEXT(table, _mesa_EGLImageTargetTexStorageEXT);
      SET_Enablei(table, _mesa_Enablei);
      SET_GenTransformFeedbacks(table, _mesa_GenTransformFeedbacks);
      SET_GetActiveUniformBlockName(table, _mesa_GetActiveUniformBlockName);
      SET_GetActiveUniformBlockiv(table, _mesa_GetActiveUniformBlockiv);
      SET_GetActiveUniformsiv(table, _mesa_GetActiveUniformsiv);
      SET_GetBufferParameteri64v(table, _mesa_GetBufferParameteri64v);
      SET_GetFragDataIndex(table, _mesa_GetFragDataIndex);
      SET_GetFragDataLocation(table, _mesa_GetFragDataLocation);
      SET_GetInteger64i_v(table, _mesa_GetInteger64i_v);
      SET_GetIntegeri_v(table, _mesa_GetIntegeri_v);
      SET_GetInternalformati64v(table, _mesa_GetInternalformati64v);
      SET_GetInternalformativ(table, _mesa_GetInternalformativ);
      SET_GetSamplerParameterIiv(table, _mesa_GetSamplerParameterIiv);
      SET_GetSamplerParameterIuiv(table, _mesa_GetSamplerParameterIuiv);
      SET_GetStringi(table, _mesa_GetStringi);
      SET_GetTexParameterIiv(table, _mesa_GetTexParameterIiv);
      SET_GetTexParameterIuiv(table, _mesa_GetTexParameterIuiv);
      SET_GetTransformFeedbackVarying(table, _mesa_GetTransformFeedbackVarying);
      SET_GetUniformBlockIndex(table, _mesa_GetUniformBlockIndex);
      SET_GetUniformIndices(table, _mesa_GetUniformIndices);
      SET_GetUniformuiv(table, _mesa_GetUniformuiv);
      SET_GetVertexAttribIiv(table, _mesa_GetVertexAttribIiv);
      SET_GetVertexAttribIuiv(table, _mesa_GetVertexAttribIuiv);
      SET_InternalInvalidateFramebufferAncillaryMESA(table, _mesa_InternalInvalidateFramebufferAncillaryMESA);
      SET_IsEnabledi(table, _mesa_IsEnabledi);
      SET_IsTransformFeedback(table, _mesa_IsTransformFeedback);
      SET_NamedRenderbufferStorageMultisampleAdvancedAMD(table, _mesa_NamedRenderbufferStorageMultisampleAdvancedAMD);
      SET_ProgramUniform1ui(table, _mesa_ProgramUniform1ui);
      SET_ProgramUniform1uiv(table, _mesa_ProgramUniform1uiv);
      SET_ProgramUniform2ui(table, _mesa_ProgramUniform2ui);
      SET_ProgramUniform2uiv(table, _mesa_ProgramUniform2uiv);
      SET_ProgramUniform3ui(table, _mesa_ProgramUniform3ui);
      SET_ProgramUniform3uiv(table, _mesa_ProgramUniform3uiv);
      SET_ProgramUniform4ui(table, _mesa_ProgramUniform4ui);
      SET_ProgramUniform4uiv(table, _mesa_ProgramUniform4uiv);
      SET_RenderbufferStorageMultisampleAdvancedAMD(table, _mesa_RenderbufferStorageMultisampleAdvancedAMD);
      SET_SamplerParameterIiv(table, _mesa_SamplerParameterIiv);
      SET_SamplerParameterIuiv(table, _mesa_SamplerParameterIuiv);
      SET_TexParameterIiv(table, _mesa_TexParameterIiv);
      SET_TexParameterIuiv(table, _mesa_TexParameterIuiv);
      SET_Uniform1ui(table, _mesa_Uniform1ui);
      SET_Uniform1uiv(table, _mesa_Uniform1uiv);
      SET_Uniform2ui(table, _mesa_Uniform2ui);
      SET_Uniform2uiv(table, _mesa_Uniform2uiv);
      SET_Uniform3ui(table, _mesa_Uniform3ui);
      SET_Uniform3uiv(table, _mesa_Uniform3uiv);
      SET_Uniform4ui(table, _mesa_Uniform4ui);
      SET_Uniform4uiv(table, _mesa_Uniform4uiv);
      SET_UniformMatrix2x3fv(table, _mesa_UniformMatrix2x3fv);
      SET_UniformMatrix2x4fv(table, _mesa_UniformMatrix2x4fv);
      SET_UniformMatrix3x2fv(table, _mesa_UniformMatrix3x2fv);
      SET_UniformMatrix3x4fv(table, _mesa_UniformMatrix3x4fv);
      SET_UniformMatrix4x2fv(table, _mesa_UniformMatrix4x2fv);
      SET_UniformMatrix4x3fv(table, _mesa_UniformMatrix4x3fv);
      SET_WindowRectanglesEXT(table, _mesa_WindowRectanglesEXT);
   }
   if (_mesa_is_desktop_gl(ctx) || (_mesa_is_gles2(ctx) && ctx->Version >= 31)) {
      SET_ClearTexImage(table, _mesa_ClearTexImage);
      SET_ClearTexSubImage(table, _mesa_ClearTexSubImage);
      SET_DrawArraysIndirect(table, _mesa_DrawArraysIndirect);
      SET_DrawElementsIndirect(table, _mesa_DrawElementsIndirect);
      SET_EvaluateDepthValuesARB(table, _mesa_EvaluateDepthValuesARB);
      SET_GetBooleani_v(table, _mesa_GetBooleani_v);
      SET_GetFloati_v(table, _mesa_GetFloati_v);
      SET_GetMultisamplefv(table, _mesa_GetMultisamplefv);
      SET_GetProgramInterfaceiv(table, _mesa_GetProgramInterfaceiv);
      SET_GetProgramResourceIndex(table, _mesa_GetProgramResourceIndex);
      SET_GetProgramResourceLocation(table, _mesa_GetProgramResourceLocation);
      SET_GetProgramResourceLocationIndex(table, _mesa_GetProgramResourceLocationIndex);
      SET_GetProgramResourceName(table, _mesa_GetProgramResourceName);
      SET_GetProgramResourceiv(table, _mesa_GetProgramResourceiv);
      SET_GetTexLevelParameterfv(table, _mesa_GetTexLevelParameterfv);
      SET_GetTexLevelParameteriv(table, _mesa_GetTexLevelParameteriv);
      SET_MemoryBarrier(table, _mesa_MemoryBarrier);
      SET_PrimitiveBoundingBox(table, _mesa_PrimitiveBoundingBox);
      SET_TexStorage2DMultisample(table, _mesa_TexStorage2DMultisample);
      SET_TexStorage3DMultisample(table, _mesa_TexStorage3DMultisample);
      SET_VertexAttribFormat(table, _mesa_VertexAttribFormat);
      SET_VertexAttribIFormat(table, _mesa_VertexAttribIFormat);
   }
   if (_mesa_is_desktop_gl(ctx) || (_mesa_is_gles2(ctx) && ctx->Version >= 32)) {
      SET_CreateMemoryObjectsEXT(table, _mesa_CreateMemoryObjectsEXT);
      SET_DeleteMemoryObjectsEXT(table, _mesa_DeleteMemoryObjectsEXT);
      SET_DeleteSemaphoresEXT(table, _mesa_DeleteSemaphoresEXT);
      SET_GenSemaphoresEXT(table, _mesa_GenSemaphoresEXT);
      SET_GetMemoryObjectParameterivEXT(table, _mesa_GetMemoryObjectParameterivEXT);
      SET_GetSemaphoreParameterui64vEXT(table, _mesa_GetSemaphoreParameterui64vEXT);
      SET_GetUnsignedBytei_vEXT(table, _mesa_GetUnsignedBytei_vEXT);
      SET_GetUnsignedBytevEXT(table, _mesa_GetUnsignedBytevEXT);
      SET_ImportMemoryFdEXT(table, _mesa_ImportMemoryFdEXT);
      SET_ImportMemoryWin32HandleEXT(table, _mesa_ImportMemoryWin32HandleEXT);
      SET_ImportMemoryWin32NameEXT(table, _mesa_ImportMemoryWin32NameEXT);
      SET_ImportSemaphoreFdEXT(table, _mesa_ImportSemaphoreFdEXT);
      SET_ImportSemaphoreWin32HandleEXT(table, _mesa_ImportSemaphoreWin32HandleEXT);
      SET_ImportSemaphoreWin32NameEXT(table, _mesa_ImportSemaphoreWin32NameEXT);
      SET_IsMemoryObjectEXT(table, _mesa_IsMemoryObjectEXT);
      SET_IsSemaphoreEXT(table, _mesa_IsSemaphoreEXT);
      SET_MemoryObjectParameterivEXT(table, _mesa_MemoryObjectParameterivEXT);
      SET_SemaphoreParameterui64vEXT(table, _mesa_SemaphoreParameterui64vEXT);
      SET_SignalSemaphoreEXT(table, _mesa_SignalSemaphoreEXT);
      SET_TexStorageMem2DEXT(table, _mesa_TexStorageMem2DEXT);
      SET_TexStorageMem2DMultisampleEXT(table, _mesa_TexStorageMem2DMultisampleEXT);
      SET_TexStorageMem3DEXT(table, _mesa_TexStorageMem3DEXT);
      SET_TexStorageMem3DMultisampleEXT(table, _mesa_TexStorageMem3DMultisampleEXT);
      SET_TextureStorageMem2DEXT(table, _mesa_TextureStorageMem2DEXT);
      SET_TextureStorageMem2DMultisampleEXT(table, _mesa_TextureStorageMem2DMultisampleEXT);
      SET_TextureStorageMem3DEXT(table, _mesa_TextureStorageMem3DEXT);
      SET_TextureStorageMem3DMultisampleEXT(table, _mesa_TextureStorageMem3DMultisampleEXT);
      SET_WaitSemaphoreEXT(table, _mesa_WaitSemaphoreEXT);
   }
   if (_mesa_is_desktop_gl(ctx) || _mesa_is_gles1(ctx)) {
      SET_PointParameterf(table, _mesa_PointParameterf);
      SET_PointParameterfv(table, _mesa_PointParameterfv);
   }
   if (_mesa_is_desktop_gl(ctx) || _mesa_is_gles1(ctx) || (_mesa_is_gles2(ctx) && ctx->Version >= 30)) {
      SET_DrawArraysInstancedBaseInstance(table, _mesa_DrawArraysInstancedBaseInstance);
      SET_DrawElementsInstancedBaseVertexBaseInstance(table, _mesa_DrawElementsInstancedBaseVertexBaseInstance);
      SET_DrawRangeElementsBaseVertex(table, _mesa_DrawRangeElementsBaseVertex);
   }
   if (_mesa_is_desktop_gl(ctx) || _mesa_is_gles1(ctx) || _mesa_is_gles2(ctx)) {
      SET_BindFramebuffer(table, _mesa_BindFramebuffer);
      SET_BindRenderbuffer(table, _mesa_BindRenderbuffer);
      SET_BlendEquation(table, _mesa_BlendEquation);
      SET_ClearColor(table, _mesa_ClearColor);
      SET_ClearDepthf(table, _mesa_ClearDepthf);
      SET_ClearStencil(table, _mesa_ClearStencil);
      SET_ColorMask(table, _mesa_ColorMask);
      SET_DebugMessageCallback(table, _mesa_DebugMessageCallback);
      SET_DebugMessageControl(table, _mesa_DebugMessageControl);
      SET_DebugMessageInsert(table, _mesa_DebugMessageInsert);
      SET_DeleteFramebuffers(table, _mesa_DeleteFramebuffers);
      SET_DeleteRenderbuffers(table, _mesa_DeleteRenderbuffers);
      SET_DepthMask(table, _mesa_DepthMask);
      SET_DepthRangef(table, _mesa_DepthRangef);
      SET_Disable(table, _mesa_Disable);
      SET_DrawArrays(table, _mesa_DrawArrays);
      SET_DrawArraysInstancedBaseInstanceDrawID(table, _mesa_DrawArraysInstancedBaseInstanceDrawID);
      SET_DrawArraysUserBuf(table, _mesa_DrawArraysUserBuf);
      SET_DrawElements(table, _mesa_DrawElements);
      SET_DrawElementsInstancedBaseVertexBaseInstanceDrawID(table, _mesa_DrawElementsInstancedBaseVertexBaseInstanceDrawID);
      SET_DrawElementsPacked(table, _mesa_DrawElementsPacked);
      SET_DrawElementsUserBuf(table, _mesa_DrawElementsUserBuf);
      SET_DrawElementsUserBufPacked(table, _mesa_DrawElementsUserBufPacked);
      SET_EGLImageTargetRenderbufferStorageOES(table, _mesa_EGLImageTargetRenderbufferStorageOES);
      SET_EGLImageTargetTexture2DOES(table, _mesa_EGLImageTargetTexture2DOES);
      SET_Enable(table, _mesa_Enable);
      SET_Finish(table, _mesa_Finish);
      SET_Flush(table, _mesa_Flush);
      SET_GenFramebuffers(table, _mesa_GenFramebuffers);
      SET_GetBooleanv(table, _mesa_GetBooleanv);
      SET_GetBufferParameteriv(table, _mesa_GetBufferParameteriv);
      SET_GetBufferPointerv(table, _mesa_GetBufferPointerv);
      SET_GetDebugMessageLog(table, _mesa_GetDebugMessageLog);
      SET_GetError(table, _mesa_GetError);
      SET_GetFloatv(table, _mesa_GetFloatv);
      SET_GetFramebufferAttachmentParameteriv(table, _mesa_GetFramebufferAttachmentParameteriv);
      SET_GetInteger64v(table, _mesa_GetInteger64v);
      SET_GetIntegerv(table, _mesa_GetIntegerv);
      SET_GetObjectLabel(table, _mesa_GetObjectLabel);
      SET_GetObjectLabelEXT(table, _mesa_GetObjectLabelEXT);
      SET_GetObjectPtrLabel(table, _mesa_GetObjectPtrLabel);
      SET_GetPointerv(table, _mesa_GetPointerv);
      SET_GetRenderbufferParameteriv(table, _mesa_GetRenderbufferParameteriv);
      SET_GetString(table, _mesa_GetString);
      SET_GetSynciv(table, _mesa_GetSynciv);
      SET_GetTexParameterfv(table, _mesa_GetTexParameterfv);
      SET_GetTexParameteriv(table, _mesa_GetTexParameteriv);
      SET_Hint(table, _mesa_Hint);
      SET_InternalSetError(table, _mesa_InternalSetError);
      SET_IsBuffer(table, _mesa_IsBuffer);
      SET_IsEnabled(table, _mesa_IsEnabled);
      SET_IsFramebuffer(table, _mesa_IsFramebuffer);
      SET_IsRenderbuffer(table, _mesa_IsRenderbuffer);
      SET_IsSync(table, _mesa_IsSync);
      SET_IsTexture(table, _mesa_IsTexture);
      SET_LabelObjectEXT(table, _mesa_LabelObjectEXT);
      SET_MultiDrawArrays(table, _mesa_MultiDrawArrays);
      SET_MultiDrawArraysUserBuf(table, _mesa_MultiDrawArraysUserBuf);
      SET_MultiDrawElements(table, _mesa_MultiDrawElements);
      SET_MultiDrawElementsBaseVertex(table, _mesa_MultiDrawElementsBaseVertex);
      SET_MultiDrawElementsUserBuf(table, _mesa_MultiDrawElementsUserBuf);
      SET_ObjectLabel(table, _mesa_ObjectLabel);
      SET_ObjectPtrLabel(table, _mesa_ObjectPtrLabel);
      SET_PolygonOffset(table, _mesa_PolygonOffset);
      SET_PolygonOffsetClampEXT(table, _mesa_PolygonOffsetClampEXT);
      SET_PopDebugGroup(table, _mesa_PopDebugGroup);
      SET_PushDebugGroup(table, _mesa_PushDebugGroup);
      SET_RenderbufferStorage(table, _mesa_RenderbufferStorage);
      SET_SampleCoverage(table, _mesa_SampleCoverage);
      SET_StencilMask(table, _mesa_StencilMask);
      SET_TexParameterf(table, _mesa_TexParameterf);
      SET_TexParameterfv(table, _mesa_TexParameterfv);
      SET_TexParameteri(table, _mesa_TexParameteri);
      SET_TexParameteriv(table, _mesa_TexParameteriv);
   }
   if (_mesa_is_desktop_gl(ctx) || _mesa_is_gles2(ctx)) {
      SET_BeginPerfMonitorAMD(table, _mesa_BeginPerfMonitorAMD);
      SET_BeginPerfQueryINTEL(table, _mesa_BeginPerfQueryINTEL);
      SET_BeginQuery(table, _mesa_BeginQuery);
      SET_BlendBarrier(table, _mesa_BlendBarrier);
      SET_BlendColor(table, _mesa_BlendColor);
      SET_CompileShader(table, _mesa_CompileShader);
      SET_CreatePerfQueryINTEL(table, _mesa_CreatePerfQueryINTEL);
      SET_CreateProgram(table, _mesa_CreateProgram);
      SET_CreateShaderProgramv(table, _mesa_CreateShaderProgramv);
      SET_DeletePerfMonitorsAMD(table, _mesa_DeletePerfMonitorsAMD);
      SET_DeletePerfQueryINTEL(table, _mesa_DeletePerfQueryINTEL);
      SET_DeleteProgram(table, _mesa_DeleteProgram);
      SET_DeleteProgramPipelines(table, _mesa_DeleteProgramPipelines);
      SET_DeleteQueries(table, _mesa_DeleteQueries);
      SET_DeleteShader(table, _mesa_DeleteShader);
      SET_DrawArraysInstanced(table, _mesa_DrawArraysInstanced);
      SET_DrawElementsBaseVertex(table, _mesa_DrawElementsBaseVertex);
      SET_DrawElementsInstanced(table, _mesa_DrawElementsInstanced);
      SET_DrawElementsInstancedBaseVertex(table, _mesa_DrawElementsInstancedBaseVertex);
      SET_EndPerfMonitorAMD(table, _mesa_EndPerfMonitorAMD);
      SET_EndPerfQueryINTEL(table, _mesa_EndPerfQueryINTEL);
      SET_EndQuery(table, _mesa_EndQuery);
      SET_FramebufferFetchBarrierEXT(table, _mesa_FramebufferFetchBarrierEXT);
      SET_GenPerfMonitorsAMD(table, _mesa_GenPerfMonitorsAMD);
      SET_GenQueries(table, _mesa_GenQueries);
      SET_GetActiveAttrib(table, _mesa_GetActiveAttrib);
      SET_GetActiveUniform(table, _mesa_GetActiveUniform);
      SET_GetAttachedShaders(table, _mesa_GetAttachedShaders);
      SET_GetAttribLocation(table, _mesa_GetAttribLocation);
      SET_GetFirstPerfQueryIdINTEL(table, _mesa_GetFirstPerfQueryIdINTEL);
      SET_GetGraphicsResetStatusARB(table, _mesa_GetGraphicsResetStatusARB);
      SET_GetNextPerfQueryIdINTEL(table, _mesa_GetNextPerfQueryIdINTEL);
      SET_GetPerfCounterInfoINTEL(table, _mesa_GetPerfCounterInfoINTEL);
      SET_GetPerfMonitorCounterDataAMD(table, _mesa_GetPerfMonitorCounterDataAMD);
      SET_GetPerfMonitorCounterInfoAMD(table, _mesa_GetPerfMonitorCounterInfoAMD);
      SET_GetPerfMonitorCounterStringAMD(table, _mesa_GetPerfMonitorCounterStringAMD);
      SET_GetPerfMonitorCountersAMD(table, _mesa_GetPerfMonitorCountersAMD);
      SET_GetPerfMonitorGroupStringAMD(table, _mesa_GetPerfMonitorGroupStringAMD);
      SET_GetPerfMonitorGroupsAMD(table, _mesa_GetPerfMonitorGroupsAMD);
      SET_GetPerfQueryDataINTEL(table, _mesa_GetPerfQueryDataINTEL);
      SET_GetPerfQueryIdByNameINTEL(table, _mesa_GetPerfQueryIdByNameINTEL);
      SET_GetPerfQueryInfoINTEL(table, _mesa_GetPerfQueryInfoINTEL);
      SET_GetProgramBinary(table, _mesa_GetProgramBinary);
      SET_GetProgramInfoLog(table, _mesa_GetProgramInfoLog);
      SET_GetProgramPipelineInfoLog(table, _mesa_GetProgramPipelineInfoLog);
      SET_GetProgramPipelineiv(table, _mesa_GetProgramPipelineiv);
      SET_GetProgramiv(table, _mesa_GetProgramiv);
      SET_GetQueryObjecti64v(table, _mesa_GetQueryObjecti64v);
      SET_GetQueryObjectiv(table, _mesa_GetQueryObjectiv);
      SET_GetQueryObjectui64v(table, _mesa_GetQueryObjectui64v);
      SET_GetQueryObjectuiv(table, _mesa_GetQueryObjectuiv);
      SET_GetQueryiv(table, _mesa_GetQueryiv);
      SET_GetSamplerParameterfv(table, _mesa_GetSamplerParameterfv);
      SET_GetSamplerParameteriv(table, _mesa_GetSamplerParameteriv);
      SET_GetShaderInfoLog(table, _mesa_GetShaderInfoLog);
      SET_GetShaderPrecisionFormat(table, _mesa_GetShaderPrecisionFormat);
      SET_GetShaderSource(table, _mesa_GetShaderSource);
      SET_GetShaderiv(table, _mesa_GetShaderiv);
      SET_GetUniformfv(table, _mesa_GetUniformfv);
      SET_GetUniformiv(table, _mesa_GetUniformiv);
      SET_GetVertexAttribPointerv(table, _mesa_GetVertexAttribPointerv);
      SET_GetVertexAttribfv(table, _mesa_GetVertexAttribfv);
      SET_GetVertexAttribiv(table, _mesa_GetVertexAttribiv);
      SET_GetnUniformfvARB(table, _mesa_GetnUniformfvARB);
      SET_GetnUniformivARB(table, _mesa_GetnUniformivARB);
      SET_GetnUniformuivARB(table, _mesa_GetnUniformuivARB);
      SET_InternalBufferSubDataCopyMESA(table, _mesa_InternalBufferSubDataCopyMESA);
      SET_IsProgram(table, _mesa_IsProgram);
      SET_IsProgramPipeline(table, _mesa_IsProgramPipeline);
      SET_IsQuery(table, _mesa_IsQuery);
      SET_IsSampler(table, _mesa_IsSampler);
      SET_IsShader(table, _mesa_IsShader);
      SET_IsVertexArray(table, _mesa_IsVertexArray);
      SET_MaxShaderCompilerThreadsKHR(table, _mesa_MaxShaderCompilerThreadsKHR);
      SET_ProgramBinary(table, _mesa_ProgramBinary);
      SET_ProgramUniform1f(table, _mesa_ProgramUniform1f);
      SET_ProgramUniform1fv(table, _mesa_ProgramUniform1fv);
      SET_ProgramUniform1i(table, _mesa_ProgramUniform1i);
      SET_ProgramUniform1iv(table, _mesa_ProgramUniform1iv);
      SET_ProgramUniform2f(table, _mesa_ProgramUniform2f);
      SET_ProgramUniform2fv(table, _mesa_ProgramUniform2fv);
      SET_ProgramUniform2i(table, _mesa_ProgramUniform2i);
      SET_ProgramUniform2iv(table, _mesa_ProgramUniform2iv);
      SET_ProgramUniform3f(table, _mesa_ProgramUniform3f);
      SET_ProgramUniform3fv(table, _mesa_ProgramUniform3fv);
      SET_ProgramUniform3i(table, _mesa_ProgramUniform3i);
      SET_ProgramUniform3iv(table, _mesa_ProgramUniform3iv);
      SET_ProgramUniform4f(table, _mesa_ProgramUniform4f);
      SET_ProgramUniform4fv(table, _mesa_ProgramUniform4fv);
      SET_ProgramUniform4i(table, _mesa_ProgramUniform4i);
      SET_ProgramUniform4iv(table, _mesa_ProgramUniform4iv);
      SET_ProgramUniformMatrix2fv(table, _mesa_ProgramUniformMatrix2fv);
      SET_ProgramUniformMatrix2x3fv(table, _mesa_ProgramUniformMatrix2x3fv);
      SET_ProgramUniformMatrix2x4fv(table, _mesa_ProgramUniformMatrix2x4fv);
      SET_ProgramUniformMatrix3fv(table, _mesa_ProgramUniformMatrix3fv);
      SET_ProgramUniformMatrix3x2fv(table, _mesa_ProgramUniformMatrix3x2fv);
      SET_ProgramUniformMatrix3x4fv(table, _mesa_ProgramUniformMatrix3x4fv);
      SET_ProgramUniformMatrix4fv(table, _mesa_ProgramUniformMatrix4fv);
      SET_ProgramUniformMatrix4x2fv(table, _mesa_ProgramUniformMatrix4x2fv);
      SET_ProgramUniformMatrix4x3fv(table, _mesa_ProgramUniformMatrix4x3fv);
      SET_QueryCounter(table, _mesa_QueryCounter);
      SET_ReleaseShaderCompiler(table, _mesa_ReleaseShaderCompiler);
      SET_RenderbufferStorageMultisample(table, _mesa_RenderbufferStorageMultisample);
      SET_SamplerParameterf(table, _mesa_SamplerParameterf);
      SET_SamplerParameterfv(table, _mesa_SamplerParameterfv);
      SET_SamplerParameteri(table, _mesa_SamplerParameteri);
      SET_SamplerParameteriv(table, _mesa_SamplerParameteriv);
      SET_SelectPerfMonitorCountersAMD(table, _mesa_SelectPerfMonitorCountersAMD);
      SET_ShaderBinary(table, _mesa_ShaderBinary);
      SET_TextureBarrierNV(table, _mesa_TextureBarrierNV);
      SET_Uniform1f(table, _mesa_Uniform1f);
      SET_Uniform1fv(table, _mesa_Uniform1fv);
      SET_Uniform1i(table, _mesa_Uniform1i);
      SET_Uniform1iv(table, _mesa_Uniform1iv);
      SET_Uniform2f(table, _mesa_Uniform2f);
      SET_Uniform2fv(table, _mesa_Uniform2fv);
      SET_Uniform2i(table, _mesa_Uniform2i);
      SET_Uniform2iv(table, _mesa_Uniform2iv);
      SET_Uniform3f(table, _mesa_Uniform3f);
      SET_Uniform3fv(table, _mesa_Uniform3fv);
      SET_Uniform3i(table, _mesa_Uniform3i);
      SET_Uniform3iv(table, _mesa_Uniform3iv);
      SET_Uniform4f(table, _mesa_Uniform4f);
      SET_Uniform4fv(table, _mesa_Uniform4fv);
      SET_Uniform4i(table, _mesa_Uniform4i);
      SET_Uniform4iv(table, _mesa_Uniform4iv);
      SET_UniformMatrix2fv(table, _mesa_UniformMatrix2fv);
      SET_UniformMatrix3fv(table, _mesa_UniformMatrix3fv);
      SET_UniformMatrix4fv(table, _mesa_UniformMatrix4fv);
      SET_ValidateProgram(table, _mesa_ValidateProgram);
      SET_ValidateProgramPipeline(table, _mesa_ValidateProgramPipeline);
   }
   if (_mesa_is_desktop_gl_compat(ctx)) {
      SET_Accum(table, _mesa_Accum);
      SET_ActiveStencilFaceEXT(table, _mesa_ActiveStencilFaceEXT);
      SET_AlphaFragmentOp1ATI(table, _mesa_AlphaFragmentOp1ATI);
      SET_AlphaFragmentOp2ATI(table, _mesa_AlphaFragmentOp2ATI);
      SET_AlphaFragmentOp3ATI(table, _mesa_AlphaFragmentOp3ATI);
      SET_AreTexturesResident(table, _mesa_AreTexturesResident);
      SET_BeginFragmentShaderATI(table, _mesa_BeginFragmentShaderATI);
      SET_BindFragmentShaderATI(table, _mesa_BindFragmentShaderATI);
      SET_BindMultiTextureEXT(table, _mesa_BindMultiTextureEXT);
      SET_BindProgramARB(table, _mesa_BindProgramARB);
      SET_Bitmap(table, _mesa_Bitmap);
      SET_CheckNamedFramebufferStatusEXT(table, _mesa_CheckNamedFramebufferStatusEXT);
      SET_ClearAccum(table, _mesa_ClearAccum);
      SET_ClearIndex(table, _mesa_ClearIndex);
      SET_ClientAttribDefaultEXT(table, _mesa_ClientAttribDefaultEXT);
      SET_ClipPlane(table, _mesa_ClipPlane);
      SET_ColorFragmentOp1ATI(table, _mesa_ColorFragmentOp1ATI);
      SET_ColorFragmentOp2ATI(table, _mesa_ColorFragmentOp2ATI);
      SET_ColorFragmentOp3ATI(table, _mesa_ColorFragmentOp3ATI);
      SET_ColorMaterial(table, _mesa_ColorMaterial);
      SET_ColorPointerEXT(table, _mesa_ColorPointerEXT);
      SET_CompressedMultiTexImage1DEXT(table, _mesa_CompressedMultiTexImage1DEXT);
      SET_CompressedMultiTexImage2DEXT(table, _mesa_CompressedMultiTexImage2DEXT);
      SET_CompressedMultiTexImage3DEXT(table, _mesa_CompressedMultiTexImage3DEXT);
      SET_CompressedMultiTexSubImage1DEXT(table, _mesa_CompressedMultiTexSubImage1DEXT);
      SET_CompressedMultiTexSubImage2DEXT(table, _mesa_CompressedMultiTexSubImage2DEXT);
      SET_CompressedMultiTexSubImage3DEXT(table, _mesa_CompressedMultiTexSubImage3DEXT);
      SET_CompressedTextureImage1DEXT(table, _mesa_CompressedTextureImage1DEXT);
      SET_CompressedTextureImage2DEXT(table, _mesa_CompressedTextureImage2DEXT);
      SET_CompressedTextureImage3DEXT(table, _mesa_CompressedTextureImage3DEXT);
      SET_CompressedTextureSubImage1DEXT(table, _mesa_CompressedTextureSubImage1DEXT);
      SET_CompressedTextureSubImage2DEXT(table, _mesa_CompressedTextureSubImage2DEXT);
      SET_CompressedTextureSubImage3DEXT(table, _mesa_CompressedTextureSubImage3DEXT);
      SET_CopyMultiTexImage1DEXT(table, _mesa_CopyMultiTexImage1DEXT);
      SET_CopyMultiTexImage2DEXT(table, _mesa_CopyMultiTexImage2DEXT);
      SET_CopyMultiTexSubImage1DEXT(table, _mesa_CopyMultiTexSubImage1DEXT);
      SET_CopyMultiTexSubImage2DEXT(table, _mesa_CopyMultiTexSubImage2DEXT);
      SET_CopyMultiTexSubImage3DEXT(table, _mesa_CopyMultiTexSubImage3DEXT);
      SET_CopyPixels(table, _mesa_CopyPixels);
      SET_CopyTextureImage1DEXT(table, _mesa_CopyTextureImage1DEXT);
      SET_CopyTextureImage2DEXT(table, _mesa_CopyTextureImage2DEXT);
      SET_CopyTextureSubImage1DEXT(table, _mesa_CopyTextureSubImage1DEXT);
      SET_CopyTextureSubImage2DEXT(table, _mesa_CopyTextureSubImage2DEXT);
      SET_CopyTextureSubImage3DEXT(table, _mesa_CopyTextureSubImage3DEXT);
      SET_DeleteFragmentShaderATI(table, _mesa_DeleteFragmentShaderATI);
      SET_DeleteLists(table, _mesa_DeleteLists);
      SET_DeleteProgramsARB(table, _mesa_DeleteProgramsARB);
      SET_DisableClientStateiEXT(table, _mesa_DisableClientStateiEXT);
      SET_DisableVertexArrayAttribEXT(table, _mesa_DisableVertexArrayAttribEXT);
      SET_DisableVertexArrayEXT(table, _mesa_DisableVertexArrayEXT);
      SET_DrawPixels(table, _mesa_DrawPixels);
      SET_EdgeFlagPointerEXT(table, _mesa_EdgeFlagPointerEXT);
      SET_EnableClientStateiEXT(table, _mesa_EnableClientStateiEXT);
      SET_EnableVertexArrayAttribEXT(table, _mesa_EnableVertexArrayAttribEXT);
      SET_EnableVertexArrayEXT(table, _mesa_EnableVertexArrayEXT);
      SET_EndFragmentShaderATI(table, _mesa_EndFragmentShaderATI);
      SET_EndList(table, _mesa_EndList);
      SET_EvalMesh1(table, _mesa_EvalMesh1);
      SET_EvalMesh2(table, _mesa_EvalMesh2);
      SET_FeedbackBuffer(table, _mesa_FeedbackBuffer);
      SET_Fogi(table, _mesa_Fogi);
      SET_Fogiv(table, _mesa_Fogiv);
      SET_FramebufferDrawBufferEXT(table, _mesa_FramebufferDrawBufferEXT);
      SET_FramebufferDrawBuffersEXT(table, _mesa_FramebufferDrawBuffersEXT);
      SET_FramebufferReadBufferEXT(table, _mesa_FramebufferReadBufferEXT);
      SET_Frustum(table, _mesa_Frustum);
      SET_GenFragmentShadersATI(table, _mesa_GenFragmentShadersATI);
      SET_GenLists(table, _mesa_GenLists);
      SET_GenProgramsARB(table, _mesa_GenProgramsARB);
      SET_GenerateMultiTexMipmapEXT(table, _mesa_GenerateMultiTexMipmapEXT);
      SET_GenerateTextureMipmapEXT(table, _mesa_GenerateTextureMipmapEXT);
      SET_GetClipPlane(table, _mesa_GetClipPlane);
      SET_GetCompressedMultiTexImageEXT(table, _mesa_GetCompressedMultiTexImageEXT);
      SET_GetCompressedTextureImageEXT(table, _mesa_GetCompressedTextureImageEXT);
      SET_GetFramebufferParameterivEXT(table, _mesa_GetFramebufferParameterivEXT);
      SET_GetLightiv(table, _mesa_GetLightiv);
      SET_GetMapdv(table, _mesa_GetMapdv);
      SET_GetMapfv(table, _mesa_GetMapfv);
      SET_GetMapiv(table, _mesa_GetMapiv);
      SET_GetMaterialiv(table, _mesa_GetMaterialiv);
      SET_GetMultiTexEnvfvEXT(table, _mesa_GetMultiTexEnvfvEXT);
      SET_GetMultiTexEnvivEXT(table, _mesa_GetMultiTexEnvivEXT);
      SET_GetMultiTexGendvEXT(table, _mesa_GetMultiTexGendvEXT);
      SET_GetMultiTexGenfvEXT(table, _mesa_GetMultiTexGenfvEXT);
      SET_GetMultiTexGenivEXT(table, _mesa_GetMultiTexGenivEXT);
      SET_GetMultiTexImageEXT(table, _mesa_GetMultiTexImageEXT);
      SET_GetMultiTexLevelParameterfvEXT(table, _mesa_GetMultiTexLevelParameterfvEXT);
      SET_GetMultiTexLevelParameterivEXT(table, _mesa_GetMultiTexLevelParameterivEXT);
      SET_GetMultiTexParameterIivEXT(table, _mesa_GetMultiTexParameterIivEXT);
      SET_GetMultiTexParameterIuivEXT(table, _mesa_GetMultiTexParameterIuivEXT);
      SET_GetMultiTexParameterfvEXT(table, _mesa_GetMultiTexParameterfvEXT);
      SET_GetMultiTexParameterivEXT(table, _mesa_GetMultiTexParameterivEXT);
      SET_GetNamedFramebufferAttachmentParameterivEXT(table, _mesa_GetNamedFramebufferAttachmentParameterivEXT);
      SET_GetNamedProgramLocalParameterdvEXT(table, _mesa_GetNamedProgramLocalParameterdvEXT);
      SET_GetNamedProgramLocalParameterfvEXT(table, _mesa_GetNamedProgramLocalParameterfvEXT);
      SET_GetNamedProgramStringEXT(table, _mesa_GetNamedProgramStringEXT);
      SET_GetNamedProgramivEXT(table, _mesa_GetNamedProgramivEXT);
      SET_GetNamedRenderbufferParameterivEXT(table, _mesa_GetNamedRenderbufferParameterivEXT);
      SET_GetPixelMapfv(table, _mesa_GetPixelMapfv);
      SET_GetPixelMapuiv(table, _mesa_GetPixelMapuiv);
      SET_GetPixelMapusv(table, _mesa_GetPixelMapusv);
      SET_GetPointerIndexedvEXT(table, _mesa_GetPointerIndexedvEXT);
      SET_GetPolygonStipple(table, _mesa_GetPolygonStipple);
      SET_GetProgramEnvParameterdvARB(table, _mesa_GetProgramEnvParameterdvARB);
      SET_GetProgramEnvParameterfvARB(table, _mesa_GetProgramEnvParameterfvARB);
      SET_GetProgramLocalParameterdvARB(table, _mesa_GetProgramLocalParameterdvARB);
      SET_GetProgramLocalParameterfvARB(table, _mesa_GetProgramLocalParameterfvARB);
      SET_GetProgramStringARB(table, _mesa_GetProgramStringARB);
      SET_GetProgramivARB(table, _mesa_GetProgramivARB);
      SET_GetTexGendv(table, _mesa_GetTexGendv);
      SET_GetTextureImageEXT(table, _mesa_GetTextureImageEXT);
      SET_GetTextureLevelParameterfvEXT(table, _mesa_GetTextureLevelParameterfvEXT);
      SET_GetTextureLevelParameterivEXT(table, _mesa_GetTextureLevelParameterivEXT);
      SET_GetTextureParameterIivEXT(table, _mesa_GetTextureParameterIivEXT);
      SET_GetTextureParameterIuivEXT(table, _mesa_GetTextureParameterIuivEXT);
      SET_GetTextureParameterfvEXT(table, _mesa_GetTextureParameterfvEXT);
      SET_GetTextureParameterivEXT(table, _mesa_GetTextureParameterivEXT);
      SET_GetVertexArrayIntegeri_vEXT(table, _mesa_GetVertexArrayIntegeri_vEXT);
      SET_GetVertexArrayIntegervEXT(table, _mesa_GetVertexArrayIntegervEXT);
      SET_GetVertexArrayPointeri_vEXT(table, _mesa_GetVertexArrayPointeri_vEXT);
      SET_GetVertexArrayPointervEXT(table, _mesa_GetVertexArrayPointervEXT);
      SET_GetnMapdvARB(table, _mesa_GetnMapdvARB);
      SET_GetnMapfvARB(table, _mesa_GetnMapfvARB);
      SET_GetnMapivARB(table, _mesa_GetnMapivARB);
      SET_GetnPixelMapfvARB(table, _mesa_GetnPixelMapfvARB);
      SET_GetnPixelMapuivARB(table, _mesa_GetnPixelMapuivARB);
      SET_GetnPixelMapusvARB(table, _mesa_GetnPixelMapusvARB);
      SET_IndexMask(table, _mesa_IndexMask);
      SET_IndexPointerEXT(table, _mesa_IndexPointerEXT);
      SET_InitNames(table, _mesa_InitNames);
      SET_InterleavedArrays(table, _mesa_InterleavedArrays);
      SET_IsList(table, _mesa_IsList);
      SET_IsProgramARB(table, _mesa_IsProgramARB);
      SET_LightModeli(table, _mesa_LightModeli);
      SET_LightModeliv(table, _mesa_LightModeliv);
      SET_Lighti(table, _mesa_Lighti);
      SET_Lightiv(table, _mesa_Lightiv);
      SET_LineStipple(table, _mesa_LineStipple);
      SET_ListBase(table, _mesa_ListBase);
      SET_LoadMatrixd(table, _mesa_LoadMatrixd);
      SET_LoadName(table, _mesa_LoadName);
      SET_LoadTransposeMatrixd(table, _mesa_LoadTransposeMatrixd);
      SET_LoadTransposeMatrixf(table, _mesa_LoadTransposeMatrixf);
      SET_LockArraysEXT(table, _mesa_LockArraysEXT);
      SET_Map1d(table, _mesa_Map1d);
      SET_Map1f(table, _mesa_Map1f);
      SET_Map2d(table, _mesa_Map2d);
      SET_Map2f(table, _mesa_Map2f);
      SET_MapGrid1d(table, _mesa_MapGrid1d);
      SET_MapGrid1f(table, _mesa_MapGrid1f);
      SET_MapGrid2d(table, _mesa_MapGrid2d);
      SET_MapGrid2f(table, _mesa_MapGrid2f);
      SET_MapNamedBufferRangeEXT(table, _mesa_MapNamedBufferRangeEXT);
      SET_MatrixFrustumEXT(table, _mesa_MatrixFrustumEXT);
      SET_MatrixLoadIdentityEXT(table, _mesa_MatrixLoadIdentityEXT);
      SET_MatrixLoadTransposedEXT(table, _mesa_MatrixLoadTransposedEXT);
      SET_MatrixLoadTransposefEXT(table, _mesa_MatrixLoadTransposefEXT);
      SET_MatrixLoaddEXT(table, _mesa_MatrixLoaddEXT);
      SET_MatrixLoadfEXT(table, _mesa_MatrixLoadfEXT);
      SET_MatrixMultTransposedEXT(table, _mesa_MatrixMultTransposedEXT);
      SET_MatrixMultTransposefEXT(table, _mesa_MatrixMultTransposefEXT);
      SET_MatrixMultdEXT(table, _mesa_MatrixMultdEXT);
      SET_MatrixMultfEXT(table, _mesa_MatrixMultfEXT);
      SET_MatrixOrthoEXT(table, _mesa_MatrixOrthoEXT);
      SET_MatrixPopEXT(table, _mesa_MatrixPopEXT);
      SET_MatrixPushEXT(table, _mesa_MatrixPushEXT);
      SET_MatrixRotatedEXT(table, _mesa_MatrixRotatedEXT);
      SET_MatrixRotatefEXT(table, _mesa_MatrixRotatefEXT);
      SET_MatrixScaledEXT(table, _mesa_MatrixScaledEXT);
      SET_MatrixScalefEXT(table, _mesa_MatrixScalefEXT);
      SET_MatrixTranslatedEXT(table, _mesa_MatrixTranslatedEXT);
      SET_MatrixTranslatefEXT(table, _mesa_MatrixTranslatefEXT);
      SET_MultMatrixd(table, _mesa_MultMatrixd);
      SET_MultTransposeMatrixd(table, _mesa_MultTransposeMatrixd);
      SET_MultTransposeMatrixf(table, _mesa_MultTransposeMatrixf);
      SET_MultiTexBufferEXT(table, _mesa_MultiTexBufferEXT);
      SET_MultiTexCoordPointerEXT(table, _mesa_MultiTexCoordPointerEXT);
      SET_MultiTexEnvfEXT(table, _mesa_MultiTexEnvfEXT);
      SET_MultiTexEnvfvEXT(table, _mesa_MultiTexEnvfvEXT);
      SET_MultiTexEnviEXT(table, _mesa_MultiTexEnviEXT);
      SET_MultiTexEnvivEXT(table, _mesa_MultiTexEnvivEXT);
      SET_MultiTexGendEXT(table, _mesa_MultiTexGendEXT);
      SET_MultiTexGendvEXT(table, _mesa_MultiTexGendvEXT);
      SET_MultiTexGenfEXT(table, _mesa_MultiTexGenfEXT);
      SET_MultiTexGenfvEXT(table, _mesa_MultiTexGenfvEXT);
      SET_MultiTexGeniEXT(table, _mesa_MultiTexGeniEXT);
      SET_MultiTexGenivEXT(table, _mesa_MultiTexGenivEXT);
      SET_MultiTexImage1DEXT(table, _mesa_MultiTexImage1DEXT);
      SET_MultiTexImage2DEXT(table, _mesa_MultiTexImage2DEXT);
      SET_MultiTexImage3DEXT(table, _mesa_MultiTexImage3DEXT);
      SET_MultiTexParameterIivEXT(table, _mesa_MultiTexParameterIivEXT);
      SET_MultiTexParameterIuivEXT(table, _mesa_MultiTexParameterIuivEXT);
      SET_MultiTexParameterfEXT(table, _mesa_MultiTexParameterfEXT);
      SET_MultiTexParameterfvEXT(table, _mesa_MultiTexParameterfvEXT);
      SET_MultiTexParameteriEXT(table, _mesa_MultiTexParameteriEXT);
      SET_MultiTexParameterivEXT(table, _mesa_MultiTexParameterivEXT);
      SET_MultiTexSubImage1DEXT(table, _mesa_MultiTexSubImage1DEXT);
      SET_MultiTexSubImage2DEXT(table, _mesa_MultiTexSubImage2DEXT);
      SET_MultiTexSubImage3DEXT(table, _mesa_MultiTexSubImage3DEXT);
      SET_NamedCopyBufferSubDataEXT(table, _mesa_NamedCopyBufferSubDataEXT);
      SET_NamedFramebufferRenderbufferEXT(table, _mesa_NamedFramebufferRenderbufferEXT);
      SET_NamedFramebufferTexture1DEXT(table, _mesa_NamedFramebufferTexture1DEXT);
      SET_NamedFramebufferTexture2DEXT(table, _mesa_NamedFramebufferTexture2DEXT);
      SET_NamedFramebufferTexture3DEXT(table, _mesa_NamedFramebufferTexture3DEXT);
      SET_NamedProgramLocalParameter4dEXT(table, _mesa_NamedProgramLocalParameter4dEXT);
      SET_NamedProgramLocalParameter4dvEXT(table, _mesa_NamedProgramLocalParameter4dvEXT);
      SET_NamedProgramLocalParameter4fEXT(table, _mesa_NamedProgramLocalParameter4fEXT);
      SET_NamedProgramLocalParameter4fvEXT(table, _mesa_NamedProgramLocalParameter4fvEXT);
      SET_NamedProgramLocalParameters4fvEXT(table, _mesa_NamedProgramLocalParameters4fvEXT);
      SET_NamedProgramStringEXT(table, _mesa_NamedProgramStringEXT);
      SET_NamedRenderbufferStorageEXT(table, _mesa_NamedRenderbufferStorageEXT);
      SET_NamedRenderbufferStorageMultisampleEXT(table, _mesa_NamedRenderbufferStorageMultisampleEXT);
      SET_NewList(table, _mesa_NewList);
      SET_NormalPointerEXT(table, _mesa_NormalPointerEXT);
      SET_Ortho(table, _mesa_Ortho);
      SET_PassTexCoordATI(table, _mesa_PassTexCoordATI);
      SET_PassThrough(table, _mesa_PassThrough);
      SET_PixelMapfv(table, _mesa_PixelMapfv);
      SET_PixelMapuiv(table, _mesa_PixelMapuiv);
      SET_PixelMapusv(table, _mesa_PixelMapusv);
      SET_PixelTransferf(table, _mesa_PixelTransferf);
      SET_PixelTransferi(table, _mesa_PixelTransferi);
      SET_PixelZoom(table, _mesa_PixelZoom);
      SET_PolygonStipple(table, _mesa_PolygonStipple);
      SET_PopAttrib(table, _mesa_PopAttrib);
      SET_PopClientAttrib(table, _mesa_PopClientAttrib);
      SET_PopName(table, _mesa_PopName);
      SET_PrioritizeTextures(table, _mesa_PrioritizeTextures);
      SET_ProgramEnvParameter4dARB(table, _mesa_ProgramEnvParameter4dARB);
      SET_ProgramEnvParameter4dvARB(table, _mesa_ProgramEnvParameter4dvARB);
      SET_ProgramEnvParameter4fARB(table, _mesa_ProgramEnvParameter4fARB);
      SET_ProgramEnvParameter4fvARB(table, _mesa_ProgramEnvParameter4fvARB);
      SET_ProgramEnvParameters4fvEXT(table, _mesa_ProgramEnvParameters4fvEXT);
      SET_ProgramLocalParameter4dARB(table, _mesa_ProgramLocalParameter4dARB);
      SET_ProgramLocalParameter4dvARB(table, _mesa_ProgramLocalParameter4dvARB);
      SET_ProgramLocalParameter4fARB(table, _mesa_ProgramLocalParameter4fARB);
      SET_ProgramLocalParameter4fvARB(table, _mesa_ProgramLocalParameter4fvARB);
      SET_ProgramLocalParameters4fvEXT(table, _mesa_ProgramLocalParameters4fvEXT);
      SET_ProgramStringARB(table, _mesa_ProgramStringARB);
      SET_PushAttrib(table, _mesa_PushAttrib);
      SET_PushClientAttrib(table, _mesa_PushClientAttrib);
      SET_PushClientAttribDefaultEXT(table, _mesa_PushClientAttribDefaultEXT);
      SET_PushName(table, _mesa_PushName);
      SET_RasterPos2d(table, _mesa_RasterPos2d);
      SET_RasterPos2dv(table, _mesa_RasterPos2dv);
      SET_RasterPos2f(table, _mesa_RasterPos2f);
      SET_RasterPos2fv(table, _mesa_RasterPos2fv);
      SET_RasterPos2i(table, _mesa_RasterPos2i);
      SET_RasterPos2iv(table, _mesa_RasterPos2iv);
      SET_RasterPos2s(table, _mesa_RasterPos2s);
      SET_RasterPos2sv(table, _mesa_RasterPos2sv);
      SET_RasterPos3d(table, _mesa_RasterPos3d);
      SET_RasterPos3dv(table, _mesa_RasterPos3dv);
      SET_RasterPos3f(table, _mesa_RasterPos3f);
      SET_RasterPos3fv(table, _mesa_RasterPos3fv);
      SET_RasterPos3i(table, _mesa_RasterPos3i);
      SET_RasterPos3iv(table, _mesa_RasterPos3iv);
      SET_RasterPos3s(table, _mesa_RasterPos3s);
      SET_RasterPos3sv(table, _mesa_RasterPos3sv);
      SET_RasterPos4d(table, _mesa_RasterPos4d);
      SET_RasterPos4dv(table, _mesa_RasterPos4dv);
      SET_RasterPos4f(table, _mesa_RasterPos4f);
      SET_RasterPos4fv(table, _mesa_RasterPos4fv);
      SET_RasterPos4i(table, _mesa_RasterPos4i);
      SET_RasterPos4iv(table, _mesa_RasterPos4iv);
      SET_RasterPos4s(table, _mesa_RasterPos4s);
      SET_RasterPos4sv(table, _mesa_RasterPos4sv);
      SET_Rectd(table, _mesa_Rectd);
      SET_Rectdv(table, _mesa_Rectdv);
      SET_Rectf(table, _mesa_Rectf);
      SET_Rectfv(table, _mesa_Rectfv);
      SET_Recti(table, _mesa_Recti);
      SET_Rectiv(table, _mesa_Rectiv);
      SET_Rects(table, _mesa_Rects);
      SET_Rectsv(table, _mesa_Rectsv);
      SET_RenderMode(table, _mesa_RenderMode);
      SET_Rotated(table, _mesa_Rotated);
      SET_SampleMapATI(table, _mesa_SampleMapATI);
      SET_Scaled(table, _mesa_Scaled);
      SET_SelectBuffer(table, _mesa_SelectBuffer);
      SET_SetFragmentShaderConstantATI(table, _mesa_SetFragmentShaderConstantATI);
      SET_StencilFuncSeparateATI(table, _mesa_StencilFuncSeparateATI);
      SET_TexCoordPointerEXT(table, _mesa_TexCoordPointerEXT);
      SET_TexGend(table, _mesa_TexGend);
      SET_TexGendv(table, _mesa_TexGendv);
      SET_TextureBufferEXT(table, _mesa_TextureBufferEXT);
      SET_TextureImage1DEXT(table, _mesa_TextureImage1DEXT);
      SET_TextureImage2DEXT(table, _mesa_TextureImage2DEXT);
      SET_TextureImage3DEXT(table, _mesa_TextureImage3DEXT);
      SET_TextureParameterIivEXT(table, _mesa_TextureParameterIivEXT);
      SET_TextureParameterIuivEXT(table, _mesa_TextureParameterIuivEXT);
      SET_TextureParameterfEXT(table, _mesa_TextureParameterfEXT);
      SET_TextureParameterfvEXT(table, _mesa_TextureParameterfvEXT);
      SET_TextureParameteriEXT(table, _mesa_TextureParameteriEXT);
      SET_TextureParameterivEXT(table, _mesa_TextureParameterivEXT);
      SET_TextureSubImage1DEXT(table, _mesa_TextureSubImage1DEXT);
      SET_TextureSubImage2DEXT(table, _mesa_TextureSubImage2DEXT);
      SET_TextureSubImage3DEXT(table, _mesa_TextureSubImage3DEXT);
      SET_Translated(table, _mesa_Translated);
      SET_UnlockArraysEXT(table, _mesa_UnlockArraysEXT);
      SET_VertexArrayBindVertexBufferEXT(table, _mesa_VertexArrayBindVertexBufferEXT);
      SET_VertexArrayColorOffsetEXT(table, _mesa_VertexArrayColorOffsetEXT);
      SET_VertexArrayEdgeFlagOffsetEXT(table, _mesa_VertexArrayEdgeFlagOffsetEXT);
      SET_VertexArrayFogCoordOffsetEXT(table, _mesa_VertexArrayFogCoordOffsetEXT);
      SET_VertexArrayIndexOffsetEXT(table, _mesa_VertexArrayIndexOffsetEXT);
      SET_VertexArrayMultiTexCoordOffsetEXT(table, _mesa_VertexArrayMultiTexCoordOffsetEXT);
      SET_VertexArrayNormalOffsetEXT(table, _mesa_VertexArrayNormalOffsetEXT);
      SET_VertexArraySecondaryColorOffsetEXT(table, _mesa_VertexArraySecondaryColorOffsetEXT);
      SET_VertexArrayTexCoordOffsetEXT(table, _mesa_VertexArrayTexCoordOffsetEXT);
      SET_VertexArrayVertexAttribBindingEXT(table, _mesa_VertexArrayVertexAttribBindingEXT);
      SET_VertexArrayVertexAttribDivisorEXT(table, _mesa_VertexArrayVertexAttribDivisorEXT);
      SET_VertexArrayVertexAttribFormatEXT(table, _mesa_VertexArrayVertexAttribFormatEXT);
      SET_VertexArrayVertexAttribIFormatEXT(table, _mesa_VertexArrayVertexAttribIFormatEXT);
      SET_VertexArrayVertexAttribIOffsetEXT(table, _mesa_VertexArrayVertexAttribIOffsetEXT);
      SET_VertexArrayVertexAttribLFormatEXT(table, _mesa_VertexArrayVertexAttribLFormatEXT);
      SET_VertexArrayVertexAttribLOffsetEXT(table, _mesa_VertexArrayVertexAttribLOffsetEXT);
      SET_VertexArrayVertexAttribOffsetEXT(table, _mesa_VertexArrayVertexAttribOffsetEXT);
      SET_VertexArrayVertexBindingDivisorEXT(table, _mesa_VertexArrayVertexBindingDivisorEXT);
      SET_VertexArrayVertexOffsetEXT(table, _mesa_VertexArrayVertexOffsetEXT);
      SET_VertexPointerEXT(table, _mesa_VertexPointerEXT);
      SET_WindowPos2d(table, _mesa_WindowPos2d);
      SET_WindowPos2dv(table, _mesa_WindowPos2dv);
      SET_WindowPos2f(table, _mesa_WindowPos2f);
      SET_WindowPos2fv(table, _mesa_WindowPos2fv);
      SET_WindowPos2i(table, _mesa_WindowPos2i);
      SET_WindowPos2iv(table, _mesa_WindowPos2iv);
      SET_WindowPos2s(table, _mesa_WindowPos2s);
      SET_WindowPos2sv(table, _mesa_WindowPos2sv);
      SET_WindowPos3d(table, _mesa_WindowPos3d);
      SET_WindowPos3dv(table, _mesa_WindowPos3dv);
      SET_WindowPos3f(table, _mesa_WindowPos3f);
      SET_WindowPos3fv(table, _mesa_WindowPos3fv);
      SET_WindowPos3i(table, _mesa_WindowPos3i);
      SET_WindowPos3iv(table, _mesa_WindowPos3iv);
      SET_WindowPos3s(table, _mesa_WindowPos3s);
      SET_WindowPos3sv(table, _mesa_WindowPos3sv);
      SET_WindowPos4dMESA(table, _mesa_WindowPos4dMESA);
      SET_WindowPos4dvMESA(table, _mesa_WindowPos4dvMESA);
      SET_WindowPos4fMESA(table, _mesa_WindowPos4fMESA);
      SET_WindowPos4fvMESA(table, _mesa_WindowPos4fvMESA);
      SET_WindowPos4iMESA(table, _mesa_WindowPos4iMESA);
      SET_WindowPos4ivMESA(table, _mesa_WindowPos4ivMESA);
      SET_WindowPos4sMESA(table, _mesa_WindowPos4sMESA);
      SET_WindowPos4svMESA(table, _mesa_WindowPos4svMESA);
   }
   if (_mesa_is_desktop_gl_compat(ctx) || _mesa_is_desktop_gl_core(ctx)) {
      SET_CheckNamedFramebufferStatus(table, _mesa_CheckNamedFramebufferStatus);
      SET_ClearNamedFramebufferfi(table, _mesa_ClearNamedFramebufferfi);
      SET_ClearNamedFramebufferfv(table, _mesa_ClearNamedFramebufferfv);
      SET_ClearNamedFramebufferiv(table, _mesa_ClearNamedFramebufferiv);
      SET_ClearNamedFramebufferuiv(table, _mesa_ClearNamedFramebufferuiv);
      SET_CreateFramebuffers(table, _mesa_CreateFramebuffers);
      SET_CreateQueries(table, _mesa_CreateQueries);
      SET_CreateTransformFeedbacks(table, _mesa_CreateTransformFeedbacks);
      SET_GetActiveSubroutineName(table, _mesa_GetActiveSubroutineName);
      SET_GetActiveSubroutineUniformName(table, _mesa_GetActiveSubroutineUniformName);
      SET_GetActiveSubroutineUniformiv(table, _mesa_GetActiveSubroutineUniformiv);
      SET_GetCompressedTextureImage(table, _mesa_GetCompressedTextureImage);
      SET_GetNamedBufferParameteri64v(table, _mesa_GetNamedBufferParameteri64v);
      SET_GetNamedBufferParameteriv(table, _mesa_GetNamedBufferParameteriv);
      SET_GetNamedBufferPointerv(table, _mesa_GetNamedBufferPointerv);
      SET_GetNamedBufferSubData(table, _mesa_GetNamedBufferSubData);
      SET_GetNamedFramebufferAttachmentParameteriv(table, _mesa_GetNamedFramebufferAttachmentParameteriv);
      SET_GetNamedFramebufferParameteriv(table, _mesa_GetNamedFramebufferParameteriv);
      SET_GetNamedRenderbufferParameteriv(table, _mesa_GetNamedRenderbufferParameteriv);
      SET_GetProgramStageiv(table, _mesa_GetProgramStageiv);
      SET_GetQueryBufferObjecti64v(table, _mesa_GetQueryBufferObjecti64v);
      SET_GetQueryBufferObjectiv(table, _mesa_GetQueryBufferObjectiv);
      SET_GetQueryBufferObjectui64v(table, _mesa_GetQueryBufferObjectui64v);
      SET_GetQueryBufferObjectuiv(table, _mesa_GetQueryBufferObjectuiv);
      SET_GetSubroutineIndex(table, _mesa_GetSubroutineIndex);
      SET_GetSubroutineUniformLocation(table, _mesa_GetSubroutineUniformLocation);
      SET_GetTextureImage(table, _mesa_GetTextureImage);
      SET_GetTextureLevelParameterfv(table, _mesa_GetTextureLevelParameterfv);
      SET_GetTextureLevelParameteriv(table, _mesa_GetTextureLevelParameteriv);
      SET_GetTextureParameterIiv(table, _mesa_GetTextureParameterIiv);
      SET_GetTextureParameterIuiv(table, _mesa_GetTextureParameterIuiv);
      SET_GetTextureParameterfv(table, _mesa_GetTextureParameterfv);
      SET_GetTextureParameteriv(table, _mesa_GetTextureParameteriv);
      SET_GetTransformFeedbacki64_v(table, _mesa_GetTransformFeedbacki64_v);
      SET_GetTransformFeedbacki_v(table, _mesa_GetTransformFeedbacki_v);
      SET_GetTransformFeedbackiv(table, _mesa_GetTransformFeedbackiv);
      SET_GetUniformSubroutineuiv(table, _mesa_GetUniformSubroutineuiv);
      SET_GetUniformdv(table, _mesa_GetUniformdv);
      SET_GetUniformi64vARB(table, _mesa_GetUniformi64vARB);
      SET_GetUniformui64vARB(table, _mesa_GetUniformui64vARB);
      SET_GetVertexArrayIndexed64iv(table, _mesa_GetVertexArrayIndexed64iv);
      SET_GetVertexArrayIndexediv(table, _mesa_GetVertexArrayIndexediv);
      SET_GetVertexArrayiv(table, _mesa_GetVertexArrayiv);
      SET_GetVertexAttribLdv(table, _mesa_GetVertexAttribLdv);
      SET_GetVertexAttribLui64vARB(table, _mesa_GetVertexAttribLui64vARB);
      SET_GetnUniformi64vARB(table, _mesa_GetnUniformi64vARB);
      SET_GetnUniformui64vARB(table, _mesa_GetnUniformui64vARB);
      SET_InvalidateNamedFramebufferData(table, _mesa_InvalidateNamedFramebufferData);
      SET_InvalidateNamedFramebufferSubData(table, _mesa_InvalidateNamedFramebufferSubData);
      SET_NamedFramebufferParameteri(table, _mesa_NamedFramebufferParameteri);
      SET_NamedRenderbufferStorage(table, _mesa_NamedRenderbufferStorage);
      SET_NamedRenderbufferStorageMultisample(table, _mesa_NamedRenderbufferStorageMultisample);
      SET_ProgramUniform1i64ARB(table, _mesa_ProgramUniform1i64ARB);
      SET_ProgramUniform1i64vARB(table, _mesa_ProgramUniform1i64vARB);
      SET_ProgramUniform1ui64ARB(table, _mesa_ProgramUniform1ui64ARB);
      SET_ProgramUniform1ui64vARB(table, _mesa_ProgramUniform1ui64vARB);
      SET_ProgramUniform2i64ARB(table, _mesa_ProgramUniform2i64ARB);
      SET_ProgramUniform2i64vARB(table, _mesa_ProgramUniform2i64vARB);
      SET_ProgramUniform2ui64ARB(table, _mesa_ProgramUniform2ui64ARB);
      SET_ProgramUniform2ui64vARB(table, _mesa_ProgramUniform2ui64vARB);
      SET_ProgramUniform3i64ARB(table, _mesa_ProgramUniform3i64ARB);
      SET_ProgramUniform3i64vARB(table, _mesa_ProgramUniform3i64vARB);
      SET_ProgramUniform3ui64ARB(table, _mesa_ProgramUniform3ui64ARB);
      SET_ProgramUniform3ui64vARB(table, _mesa_ProgramUniform3ui64vARB);
      SET_ProgramUniform4i64ARB(table, _mesa_ProgramUniform4i64ARB);
      SET_ProgramUniform4i64vARB(table, _mesa_ProgramUniform4i64vARB);
      SET_ProgramUniform4ui64ARB(table, _mesa_ProgramUniform4ui64ARB);
      SET_ProgramUniform4ui64vARB(table, _mesa_ProgramUniform4ui64vARB);
      SET_TextureBuffer(table, _mesa_TextureBuffer);
      SET_TextureBufferRange(table, _mesa_TextureBufferRange);
      SET_TextureParameterIiv(table, _mesa_TextureParameterIiv);
      SET_TextureParameterIuiv(table, _mesa_TextureParameterIuiv);
      SET_TextureParameterf(table, _mesa_TextureParameterf);
      SET_TextureParameterfv(table, _mesa_TextureParameterfv);
      SET_TextureParameteri(table, _mesa_TextureParameteri);
      SET_TextureParameteriv(table, _mesa_TextureParameteriv);
      SET_TextureStorage2DMultisample(table, _mesa_TextureStorage2DMultisample);
      SET_TextureStorage3DMultisample(table, _mesa_TextureStorage3DMultisample);
      SET_TransformFeedbackBufferBase(table, _mesa_TransformFeedbackBufferBase);
      SET_TransformFeedbackBufferRange(table, _mesa_TransformFeedbackBufferRange);
      SET_Uniform1d(table, _mesa_Uniform1d);
      SET_Uniform1dv(table, _mesa_Uniform1dv);
      SET_Uniform1i64ARB(table, _mesa_Uniform1i64ARB);
      SET_Uniform1i64vARB(table, _mesa_Uniform1i64vARB);
      SET_Uniform1ui64ARB(table, _mesa_Uniform1ui64ARB);
      SET_Uniform1ui64vARB(table, _mesa_Uniform1ui64vARB);
      SET_Uniform2d(table, _mesa_Uniform2d);
      SET_Uniform2dv(table, _mesa_Uniform2dv);
      SET_Uniform2i64ARB(table, _mesa_Uniform2i64ARB);
      SET_Uniform2i64vARB(table, _mesa_Uniform2i64vARB);
      SET_Uniform2ui64ARB(table, _mesa_Uniform2ui64ARB);
      SET_Uniform2ui64vARB(table, _mesa_Uniform2ui64vARB);
      SET_Uniform3d(table, _mesa_Uniform3d);
      SET_Uniform3dv(table, _mesa_Uniform3dv);
      SET_Uniform3i64ARB(table, _mesa_Uniform3i64ARB);
      SET_Uniform3i64vARB(table, _mesa_Uniform3i64vARB);
      SET_Uniform3ui64ARB(table, _mesa_Uniform3ui64ARB);
      SET_Uniform3ui64vARB(table, _mesa_Uniform3ui64vARB);
      SET_Uniform4d(table, _mesa_Uniform4d);
      SET_Uniform4dv(table, _mesa_Uniform4dv);
      SET_Uniform4i64ARB(table, _mesa_Uniform4i64ARB);
      SET_Uniform4i64vARB(table, _mesa_Uniform4i64vARB);
      SET_Uniform4ui64ARB(table, _mesa_Uniform4ui64ARB);
      SET_Uniform4ui64vARB(table, _mesa_Uniform4ui64vARB);
      SET_UniformMatrix2dv(table, _mesa_UniformMatrix2dv);
      SET_UniformMatrix2x3dv(table, _mesa_UniformMatrix2x3dv);
      SET_UniformMatrix2x4dv(table, _mesa_UniformMatrix2x4dv);
      SET_UniformMatrix3dv(table, _mesa_UniformMatrix3dv);
      SET_UniformMatrix3x2dv(table, _mesa_UniformMatrix3x2dv);
      SET_UniformMatrix3x4dv(table, _mesa_UniformMatrix3x4dv);
      SET_UniformMatrix4dv(table, _mesa_UniformMatrix4dv);
      SET_UniformMatrix4x2dv(table, _mesa_UniformMatrix4x2dv);
      SET_UniformMatrix4x3dv(table, _mesa_UniformMatrix4x3dv);
      SET_UniformSubroutinesuiv(table, _mesa_UniformSubroutinesuiv);
      SET_VertexArrayAttribFormat(table, _mesa_VertexArrayAttribFormat);
      SET_VertexArrayAttribIFormat(table, _mesa_VertexArrayAttribIFormat);
      SET_VertexArrayAttribLFormat(table, _mesa_VertexArrayAttribLFormat);
   }
   if (_mesa_is_desktop_gl_compat(ctx) || _mesa_is_desktop_gl_core(ctx) || (_mesa_is_gles2(ctx) && ctx->Version >= 31)) {
      SET_FramebufferParameteri(table, _mesa_FramebufferParameteri);
      SET_GetFramebufferParameteriv(table, _mesa_GetFramebufferParameteriv);
      SET_TexBuffer(table, _mesa_TexBuffer);
      SET_TexBufferRange(table, _mesa_TexBufferRange);
   }
   if (_mesa_is_desktop_gl_compat(ctx) || _mesa_is_gles1(ctx)) {
      SET_AlphaFunc(table, _mesa_AlphaFunc);
      SET_AlphaFuncx(table, _mesa_AlphaFuncx);
      SET_ClearColorx(table, _mesa_ClearColorx);
      SET_ClearDepthx(table, _mesa_ClearDepthx);
      SET_ClientActiveTexture(table, _mesa_ClientActiveTexture);
      SET_ClipPlanef(table, _mesa_ClipPlanef);
      SET_ClipPlanex(table, _mesa_ClipPlanex);
      SET_Color4x(table, _mesa_Color4x);
      SET_DepthRangex(table, _mesa_DepthRangex);
      SET_DisableClientState(table, _mesa_DisableClientState);
      SET_EnableClientState(table, _mesa_EnableClientState);
      SET_Fogf(table, _mesa_Fogf);
      SET_Fogfv(table, _mesa_Fogfv);
      SET_Fogx(table, _mesa_Fogx);
      SET_Fogxv(table, _mesa_Fogxv);
      SET_Frustumf(table, _mesa_Frustumf);
      SET_Frustumx(table, _mesa_Frustumx);
      SET_GetFixedv(table, _mesa_GetFixedv);
      SET_GetLightfv(table, _mesa_GetLightfv);
      SET_GetLightxv(table, _mesa_GetLightxv);
      SET_GetMaterialfv(table, _mesa_GetMaterialfv);
      SET_GetMaterialxv(table, _mesa_GetMaterialxv);
      SET_GetTexEnvfv(table, _mesa_GetTexEnvfv);
      SET_GetTexEnviv(table, _mesa_GetTexEnviv);
      SET_GetTexEnvxv(table, _mesa_GetTexEnvxv);
      SET_GetTexGenfv(table, _mesa_GetTexGenfv);
      SET_GetTexGeniv(table, _mesa_GetTexGeniv);
      SET_GetTexParameterxv(table, _mesa_GetTexParameterxv);
      SET_LightModelf(table, _mesa_LightModelf);
      SET_LightModelfv(table, _mesa_LightModelfv);
      SET_LightModelx(table, _mesa_LightModelx);
      SET_LightModelxv(table, _mesa_LightModelxv);
      SET_Lightf(table, _mesa_Lightf);
      SET_Lightfv(table, _mesa_Lightfv);
      SET_Lightx(table, _mesa_Lightx);
      SET_Lightxv(table, _mesa_Lightxv);
      SET_LineWidthx(table, _mesa_LineWidthx);
      SET_LoadIdentity(table, _mesa_LoadIdentity);
      SET_LoadMatrixf(table, _mesa_LoadMatrixf);
      SET_LoadMatrixx(table, _mesa_LoadMatrixx);
      SET_Materialx(table, _mesa_Materialx);
      SET_Materialxv(table, _mesa_Materialxv);
      SET_MatrixMode(table, _mesa_MatrixMode);
      SET_MultMatrixf(table, _mesa_MultMatrixf);
      SET_MultMatrixx(table, _mesa_MultMatrixx);
      SET_MultiTexCoord4x(table, _mesa_MultiTexCoord4x);
      SET_Normal3x(table, _mesa_Normal3x);
      SET_Orthof(table, _mesa_Orthof);
      SET_Orthox(table, _mesa_Orthox);
      SET_PointParameterx(table, _mesa_PointParameterx);
      SET_PointParameterxv(table, _mesa_PointParameterxv);
      SET_PointSizex(table, _mesa_PointSizex);
      SET_PolygonOffsetx(table, _mesa_PolygonOffsetx);
      SET_PopMatrix(table, _mesa_PopMatrix);
      SET_PushMatrix(table, _mesa_PushMatrix);
      SET_Rotatef(table, _mesa_Rotatef);
      SET_Rotatex(table, _mesa_Rotatex);
      SET_SampleCoveragex(table, _mesa_SampleCoveragex);
      SET_Scalef(table, _mesa_Scalef);
      SET_Scalex(table, _mesa_Scalex);
      SET_ShadeModel(table, _mesa_ShadeModel);
      SET_TexEnvf(table, _mesa_TexEnvf);
      SET_TexEnvfv(table, _mesa_TexEnvfv);
      SET_TexEnvi(table, _mesa_TexEnvi);
      SET_TexEnviv(table, _mesa_TexEnviv);
      SET_TexEnvx(table, _mesa_TexEnvx);
      SET_TexEnvxv(table, _mesa_TexEnvxv);
      SET_TexGenf(table, _mesa_TexGenf);
      SET_TexGenfv(table, _mesa_TexGenfv);
      SET_TexGeni(table, _mesa_TexGeni);
      SET_TexGeniv(table, _mesa_TexGeniv);
      SET_TexParameterx(table, _mesa_TexParameterx);
      SET_TexParameterxv(table, _mesa_TexParameterxv);
      SET_Translatef(table, _mesa_Translatef);
      SET_Translatex(table, _mesa_Translatex);
   }
   if (_mesa_is_desktop_gl_core(ctx) || (_mesa_is_gles2(ctx) && ctx->Version >= 30)) {
      SET_FramebufferParameteriMESA(table, _mesa_FramebufferParameteriMESA);
      SET_GetFramebufferParameterivMESA(table, _mesa_GetFramebufferParameterivMESA);
   }
   if (_mesa_is_gles1(ctx)) {
      SET_DrawTexfOES(table, _mesa_DrawTexfOES);
      SET_DrawTexfvOES(table, _mesa_DrawTexfvOES);
      SET_DrawTexiOES(table, _mesa_DrawTexiOES);
      SET_DrawTexivOES(table, _mesa_DrawTexivOES);
      SET_DrawTexsOES(table, _mesa_DrawTexsOES);
      SET_DrawTexsvOES(table, _mesa_DrawTexsvOES);
      SET_DrawTexxOES(table, _mesa_DrawTexxOES);
      SET_DrawTexxvOES(table, _mesa_DrawTexxvOES);
      SET_GetClipPlanef(table, _mesa_GetClipPlanef);
      SET_GetClipPlanex(table, _mesa_GetClipPlanex);
      SET_GetTexGenxvOES(table, _mesa_GetTexGenxvOES);
      SET_QueryMatrixxOES(table, _mesa_QueryMatrixxOES);
      SET_TexGenxOES(table, _mesa_TexGenxOES);
      SET_TexGenxvOES(table, _mesa_TexGenxvOES);
   }
   if (_mesa_is_gles1(ctx) || _mesa_is_gles2(ctx)) {
      SET_DiscardFramebufferEXT(table, _mesa_DiscardFramebufferEXT);
   }
   if (_mesa_is_gles2(ctx)) {
      SET_FramebufferTexture2DMultisampleEXT(table, _mesa_FramebufferTexture2DMultisampleEXT);
   }
   if (_mesa_is_no_error_enabled(ctx) && (_mesa_is_desktop_gl(ctx) || (_mesa_is_gles2(ctx) && ctx->Version >= 30))) {
      SET_BeginTransformFeedback(table, _mesa_BeginTransformFeedback_no_error);
      SET_BindBufferRange(table, _mesa_BindBufferRange_no_error);
      SET_BindFragDataLocation(table, _mesa_BindFragDataLocation_no_error);
      SET_BindFragDataLocationIndexed(table, _mesa_BindFragDataLocationIndexed_no_error);
      SET_BindTransformFeedback(table, _mesa_BindTransformFeedback_no_error);
      SET_BlendEquationSeparateiARB(table, _mesa_BlendEquationSeparateiARB_no_error);
      SET_BlendEquationiARB(table, _mesa_BlendEquationiARB_no_error);
      SET_BlendFuncSeparateiARB(table, _mesa_BlendFuncSeparateiARB_no_error);
      SET_BlendFunciARB(table, _mesa_BlendFunciARB_no_error);
      SET_BlitFramebuffer(table, _mesa_BlitFramebuffer_no_error);
      SET_ClearBufferfi(table, _mesa_ClearBufferfi_no_error);
      SET_ClearBufferfv(table, _mesa_ClearBufferfv_no_error);
      SET_ClearBufferiv(table, _mesa_ClearBufferiv_no_error);
      SET_ClearBufferuiv(table, _mesa_ClearBufferuiv_no_error);
      SET_CopyBufferSubData(table, _mesa_CopyBufferSubData_no_error);
      SET_CopyImageSubData(table, _mesa_CopyImageSubData_no_error);
      SET_EndTransformFeedback(table, _mesa_EndTransformFeedback_no_error);
      SET_FramebufferTextureLayer(table, _mesa_FramebufferTextureLayer_no_error);
      SET_InvalidateFramebuffer(table, _mesa_InvalidateFramebuffer_no_error);
      SET_InvalidateSubFramebuffer(table, _mesa_InvalidateSubFramebuffer_no_error);
      SET_MinSampleShading(table, _mesa_MinSampleShading_no_error);
      SET_PauseTransformFeedback(table, _mesa_PauseTransformFeedback_no_error);
      SET_ResumeTransformFeedback(table, _mesa_ResumeTransformFeedback_no_error);
      SET_TransformFeedbackVaryings(table, _mesa_TransformFeedbackVaryings_no_error);
      SET_UniformBlockBinding(table, _mesa_UniformBlockBinding_no_error);
      SET_VertexAttribIPointer(table, _mesa_VertexAttribIPointer_no_error);
   }
   if (_mesa_is_no_error_enabled(ctx) && (_mesa_is_desktop_gl(ctx) || (_mesa_is_gles2(ctx) && ctx->Version >= 31))) {
      SET_BindImageTexture(table, _mesa_BindImageTexture_no_error);
      SET_BindVertexBuffer(table, _mesa_BindVertexBuffer_no_error);
      SET_BufferStorage(table, _mesa_BufferStorage_no_error);
      SET_DispatchCompute(table, _mesa_DispatchCompute_no_error);
      SET_DispatchComputeIndirect(table, _mesa_DispatchComputeIndirect_no_error);
      SET_FramebufferSampleLocationsfvARB(table, _mesa_FramebufferSampleLocationsfvARB_no_error);
      SET_MemoryBarrierByRegion(table, _mesa_MemoryBarrierByRegion_no_error);
      SET_NamedFramebufferSampleLocationsfvARB(table, _mesa_NamedFramebufferSampleLocationsfvARB_no_error);
      SET_PatchParameteri(table, _mesa_PatchParameteri_no_error);
      SET_SampleMaski(table, _mesa_SampleMaski_no_error);
      SET_TextureView(table, _mesa_TextureView_no_error);
      SET_VertexAttribBinding(table, _mesa_VertexAttribBinding_no_error);
      SET_VertexBindingDivisor(table, _mesa_VertexBindingDivisor_no_error);
      SET_ViewportSwizzleNV(table, _mesa_ViewportSwizzleNV_no_error);
   }
   if (_mesa_is_no_error_enabled(ctx) && (_mesa_is_desktop_gl(ctx) || (_mesa_is_gles2(ctx) && ctx->Version >= 32))) {
      SET_BufferStorageMemEXT(table, _mesa_BufferStorageMemEXT_no_error);
      SET_NamedBufferStorageMemEXT(table, _mesa_NamedBufferStorageMemEXT_no_error);
   }
   if (_mesa_is_no_error_enabled(ctx) && (_mesa_is_desktop_gl(ctx) || _mesa_is_gles1(ctx) || _mesa_is_gles2(ctx))) {
      SET_ActiveTexture(table, _mesa_ActiveTexture_no_error);
      SET_BindBuffer(table, _mesa_BindBuffer_no_error);
      SET_BindTexture(table, _mesa_BindTexture_no_error);
      SET_BlendEquationSeparate(table, _mesa_BlendEquationSeparate_no_error);
      SET_BlendFunc(table, _mesa_BlendFunc_no_error);
      SET_BlendFuncSeparate(table, _mesa_BlendFuncSeparate_no_error);
      SET_BufferData(table, _mesa_BufferData_no_error);
      SET_BufferSubData(table, _mesa_BufferSubData_no_error);
      SET_CheckFramebufferStatus(table, _mesa_CheckFramebufferStatus_no_error);
      SET_Clear(table, _mesa_Clear_no_error);
      SET_ClientWaitSync(table, _mesa_ClientWaitSync_no_error);
      SET_CompressedTexImage2D(table, _mesa_CompressedTexImage2D_no_error);
      SET_CompressedTexSubImage2D(table, _mesa_CompressedTexSubImage2D_no_error);
      SET_ConservativeRasterParameterfNV(table, _mesa_ConservativeRasterParameterfNV_no_error);
      SET_ConservativeRasterParameteriNV(table, _mesa_ConservativeRasterParameteriNV_no_error);
      SET_CopyTexImage2D(table, _mesa_CopyTexImage2D_no_error);
      SET_CopyTexSubImage2D(table, _mesa_CopyTexSubImage2D_no_error);
      SET_CullFace(table, _mesa_CullFace_no_error);
      SET_DeleteBuffers(table, _mesa_DeleteBuffers_no_error);
      SET_DeleteSync(table, _mesa_DeleteSync_no_error);
      SET_DeleteTextures(table, _mesa_DeleteTextures_no_error);
      SET_DepthFunc(table, _mesa_DepthFunc_no_error);
      SET_FenceSync(table, _mesa_FenceSync_no_error);
      SET_FlushMappedBufferRange(table, _mesa_FlushMappedBufferRange_no_error);
      SET_FramebufferRenderbuffer(table, _mesa_FramebufferRenderbuffer_no_error);
      SET_FramebufferTexture2D(table, _mesa_FramebufferTexture2D_no_error);
      SET_FrontFace(table, _mesa_FrontFace_no_error);
      SET_GenBuffers(table, _mesa_GenBuffers_no_error);
      SET_GenRenderbuffers(table, _mesa_GenRenderbuffers_no_error);
      SET_GenTextures(table, _mesa_GenTextures_no_error);
      SET_GenerateMipmap(table, _mesa_GenerateMipmap_no_error);
      SET_LineWidth(table, _mesa_LineWidth_no_error);
      SET_MapBuffer(table, _mesa_MapBuffer_no_error);
      SET_MapBufferRange(table, _mesa_MapBufferRange_no_error);
      SET_PixelStorei(table, _mesa_PixelStorei_no_error);
      SET_ReadPixels(table, _mesa_ReadPixels_no_error);
      SET_Scissor(table, _mesa_Scissor_no_error);
      SET_StencilFunc(table, _mesa_StencilFunc_no_error);
      SET_StencilOp(table, _mesa_StencilOp_no_error);
      SET_SubpixelPrecisionBiasNV(table, _mesa_SubpixelPrecisionBiasNV_no_error);
      SET_TexImage2D(table, _mesa_TexImage2D_no_error);
      SET_TexSubImage2D(table, _mesa_TexSubImage2D_no_error);
      SET_UnmapBuffer(table, _mesa_UnmapBuffer_no_error);
      SET_Viewport(table, _mesa_Viewport_no_error);
      SET_WaitSync(table, _mesa_WaitSync_no_error);
   }
   if (_mesa_is_no_error_enabled(ctx) && (_mesa_is_desktop_gl(ctx) || _mesa_is_gles1(ctx))) {
      SET_LogicOp(table, _mesa_LogicOp_no_error);
      SET_PointSize(table, _mesa_PointSize_no_error);
   }
   if (_mesa_is_no_error_enabled(ctx) && (_mesa_is_desktop_gl(ctx) || _mesa_is_gles2(ctx))) {
      SET_ActiveShaderProgram(table, _mesa_ActiveShaderProgram_no_error);
      SET_AttachShader(table, _mesa_AttachShader_no_error);
      SET_BeginConditionalRender(table, _mesa_BeginConditionalRender_no_error);
      SET_BindAttribLocation(table, _mesa_BindAttribLocation_no_error);
      SET_BindProgramPipeline(table, _mesa_BindProgramPipeline_no_error);
      SET_BindSampler(table, _mesa_BindSampler_no_error);
      SET_BindVertexArray(table, _mesa_BindVertexArray_no_error);
      SET_ClipControl(table, _mesa_ClipControl_no_error);
      SET_CompressedTexImage3D(table, _mesa_CompressedTexImage3D_no_error);
      SET_CompressedTexSubImage3D(table, _mesa_CompressedTexSubImage3D_no_error);
      SET_CopyTexSubImage3D(table, _mesa_CopyTexSubImage3D_no_error);
      SET_CreateShader(table, _mesa_CreateShader_no_error);
      SET_DeleteSamplers(table, _mesa_DeleteSamplers_no_error);
      SET_DeleteVertexArrays(table, _mesa_DeleteVertexArrays_no_error);
      SET_DetachShader(table, _mesa_DetachShader_no_error);
      SET_DisableVertexAttribArray(table, _mesa_DisableVertexAttribArray_no_error);
      SET_DrawBuffers(table, _mesa_DrawBuffers_no_error);
      SET_EnableVertexAttribArray(table, _mesa_EnableVertexAttribArray_no_error);
      SET_EndConditionalRender(table, _mesa_EndConditionalRender_no_error);
      SET_FramebufferTexture3D(table, _mesa_FramebufferTexture3D_no_error);
      SET_GenProgramPipelines(table, _mesa_GenProgramPipelines_no_error);
      SET_GenSamplers(table, _mesa_GenSamplers_no_error);
      SET_GenVertexArrays(table, _mesa_GenVertexArrays_no_error);
      SET_GetUniformLocation(table, _mesa_GetUniformLocation_no_error);
      SET_LinkProgram(table, _mesa_LinkProgram_no_error);
      SET_ProgramParameteri(table, _mesa_ProgramParameteri_no_error);
      SET_ReadBuffer(table, _mesa_ReadBuffer_no_error);
      SET_ReadnPixelsARB(table, _mesa_ReadnPixelsARB_no_error);
      SET_ShaderSource(table, _mesa_ShaderSource_no_error);
      SET_StencilFuncSeparate(table, _mesa_StencilFuncSeparate_no_error);
      SET_StencilMaskSeparate(table, _mesa_StencilMaskSeparate_no_error);
      SET_StencilOpSeparate(table, _mesa_StencilOpSeparate_no_error);
      SET_TexImage3D(table, _mesa_TexImage3D_no_error);
      SET_TexStorage2D(table, _mesa_TexStorage2D_no_error);
      SET_TexStorage3D(table, _mesa_TexStorage3D_no_error);
      SET_TexSubImage3D(table, _mesa_TexSubImage3D_no_error);
      SET_UseProgram(table, _mesa_UseProgram_no_error);
      SET_UseProgramStages(table, _mesa_UseProgramStages_no_error);
      SET_VertexAttribDivisor(table, _mesa_VertexAttribDivisor_no_error);
      SET_VertexAttribPointer(table, _mesa_VertexAttribPointer_no_error);
   }
   if (_mesa_is_no_error_enabled(ctx) && (_mesa_is_desktop_gl(ctx))) {
      SET_AlphaToCoverageDitherControlNV(table, _mesa_AlphaToCoverageDitherControlNV_no_error);
      SET_AttachObjectARB(table, _mesa_AttachObjectARB_no_error);
      SET_BindBufferOffsetEXT(table, _mesa_BindBufferOffsetEXT_no_error);
      SET_BindImageTextures(table, _mesa_BindImageTextures_no_error);
      SET_BindSamplers(table, _mesa_BindSamplers_no_error);
      SET_BindTextures(table, _mesa_BindTextures_no_error);
      SET_BindVertexBuffers(table, _mesa_BindVertexBuffers_no_error);
      SET_ClearBufferData(table, _mesa_ClearBufferData_no_error);
      SET_ClearBufferSubData(table, _mesa_ClearBufferSubData_no_error);
      SET_CompressedTexImage1D(table, _mesa_CompressedTexImage1D_no_error);
      SET_CompressedTexSubImage1D(table, _mesa_CompressedTexSubImage1D_no_error);
      SET_CopyImageSubDataNV(table, _mesa_CopyImageSubDataNV_no_error);
      SET_CopyTexImage1D(table, _mesa_CopyTexImage1D_no_error);
      SET_CopyTexSubImage1D(table, _mesa_CopyTexSubImage1D_no_error);
      SET_CreateShaderObjectARB(table, _mesa_CreateShaderObjectARB_no_error);
      SET_DetachObjectARB(table, _mesa_DetachObjectARB_no_error);
      SET_DispatchComputeGroupSizeARB(table, _mesa_DispatchComputeGroupSizeARB_no_error);
      SET_DrawBuffer(table, _mesa_DrawBuffer_no_error);
      SET_FramebufferTexture1D(table, _mesa_FramebufferTexture1D_no_error);
      SET_GetImageHandleARB(table, _mesa_GetImageHandleARB_no_error);
      SET_GetTextureHandleARB(table, _mesa_GetTextureHandleARB_no_error);
      SET_GetTextureSamplerHandleARB(table, _mesa_GetTextureSamplerHandleARB_no_error);
      SET_InvalidateBufferData(table, _mesa_InvalidateBufferData_no_error);
      SET_InvalidateBufferSubData(table, _mesa_InvalidateBufferSubData_no_error);
      SET_InvalidateTexImage(table, _mesa_InvalidateTexImage_no_error);
      SET_InvalidateTexSubImage(table, _mesa_InvalidateTexSubImage_no_error);
      SET_IsImageHandleResidentARB(table, _mesa_IsImageHandleResidentARB_no_error);
      SET_IsTextureHandleResidentARB(table, _mesa_IsTextureHandleResidentARB_no_error);
      SET_MakeImageHandleNonResidentARB(table, _mesa_MakeImageHandleNonResidentARB_no_error);
      SET_MakeImageHandleResidentARB(table, _mesa_MakeImageHandleResidentARB_no_error);
      SET_MakeTextureHandleNonResidentARB(table, _mesa_MakeTextureHandleNonResidentARB_no_error);
      SET_MakeTextureHandleResidentARB(table, _mesa_MakeTextureHandleResidentARB_no_error);
      SET_PixelStoref(table, _mesa_PixelStoref_no_error);
      SET_PolygonMode(table, _mesa_PolygonMode_no_error);
      SET_PrimitiveRestartIndex(table, _mesa_PrimitiveRestartIndex_no_error);
      SET_ShaderStorageBlockBinding(table, _mesa_ShaderStorageBlockBinding_no_error);
      SET_TexImage1D(table, _mesa_TexImage1D_no_error);
      SET_TexStorage1D(table, _mesa_TexStorage1D_no_error);
      SET_TexSubImage1D(table, _mesa_TexSubImage1D_no_error);
      SET_UnmapNamedBufferEXT(table, _mesa_UnmapNamedBufferEXT_no_error);
   }
   if (_mesa_is_no_error_enabled(ctx) && (_mesa_is_desktop_gl_compat(ctx) || _mesa_is_desktop_gl_core(ctx) || (_mesa_is_gles2(ctx) && ctx->Version >= 31))) {
      SET_FramebufferTexture(table, _mesa_FramebufferTexture_no_error);
      SET_ScissorArrayv(table, _mesa_ScissorArrayv_no_error);
      SET_ScissorIndexed(table, _mesa_ScissorIndexed_no_error);
      SET_ScissorIndexedv(table, _mesa_ScissorIndexedv_no_error);
      SET_ViewportArrayv(table, _mesa_ViewportArrayv_no_error);
      SET_ViewportIndexedf(table, _mesa_ViewportIndexedf_no_error);
      SET_ViewportIndexedfv(table, _mesa_ViewportIndexedfv_no_error);
   }
   if (_mesa_is_no_error_enabled(ctx) && (_mesa_is_desktop_gl_compat(ctx) || _mesa_is_desktop_gl_core(ctx))) {
      SET_BindTextureUnit(table, _mesa_BindTextureUnit_no_error);
      SET_BlitNamedFramebuffer(table, _mesa_BlitNamedFramebuffer_no_error);
      SET_ClearNamedBufferData(table, _mesa_ClearNamedBufferData_no_error);
      SET_ClearNamedBufferSubData(table, _mesa_ClearNamedBufferSubData_no_error);
      SET_CompressedTextureSubImage1D(table, _mesa_CompressedTextureSubImage1D_no_error);
      SET_CompressedTextureSubImage2D(table, _mesa_CompressedTextureSubImage2D_no_error);
      SET_CompressedTextureSubImage3D(table, _mesa_CompressedTextureSubImage3D_no_error);
      SET_CopyNamedBufferSubData(table, _mesa_CopyNamedBufferSubData_no_error);
      SET_CopyTextureSubImage1D(table, _mesa_CopyTextureSubImage1D_no_error);
      SET_CopyTextureSubImage2D(table, _mesa_CopyTextureSubImage2D_no_error);
      SET_CopyTextureSubImage3D(table, _mesa_CopyTextureSubImage3D_no_error);
      SET_CreateBuffers(table, _mesa_CreateBuffers_no_error);
      SET_CreateProgramPipelines(table, _mesa_CreateProgramPipelines_no_error);
      SET_CreateRenderbuffers(table, _mesa_CreateRenderbuffers_no_error);
      SET_CreateSamplers(table, _mesa_CreateSamplers_no_error);
      SET_CreateTextures(table, _mesa_CreateTextures_no_error);
      SET_CreateVertexArrays(table, _mesa_CreateVertexArrays_no_error);
      SET_DepthRangeArrayv(table, _mesa_DepthRangeArrayv_no_error);
      SET_DepthRangeIndexed(table, _mesa_DepthRangeIndexed_no_error);
      SET_DisableVertexArrayAttrib(table, _mesa_DisableVertexArrayAttrib_no_error);
      SET_EnableVertexArrayAttrib(table, _mesa_EnableVertexArrayAttrib_no_error);
      SET_FlushMappedNamedBufferRange(table, _mesa_FlushMappedNamedBufferRange_no_error);
      SET_GenerateTextureMipmap(table, _mesa_GenerateTextureMipmap_no_error);
      SET_MapNamedBuffer(table, _mesa_MapNamedBuffer_no_error);
      SET_MapNamedBufferRange(table, _mesa_MapNamedBufferRange_no_error);
      SET_NamedBufferData(table, _mesa_NamedBufferData_no_error);
      SET_NamedBufferStorage(table, _mesa_NamedBufferStorage_no_error);
      SET_NamedBufferSubData(table, _mesa_NamedBufferSubData_no_error);
      SET_NamedFramebufferDrawBuffer(table, _mesa_NamedFramebufferDrawBuffer_no_error);
      SET_NamedFramebufferDrawBuffers(table, _mesa_NamedFramebufferDrawBuffers_no_error);
      SET_NamedFramebufferReadBuffer(table, _mesa_NamedFramebufferReadBuffer_no_error);
      SET_NamedFramebufferRenderbuffer(table, _mesa_NamedFramebufferRenderbuffer_no_error);
      SET_NamedFramebufferTexture(table, _mesa_NamedFramebufferTexture_no_error);
      SET_NamedFramebufferTextureLayer(table, _mesa_NamedFramebufferTextureLayer_no_error);
      SET_TextureStorage1D(table, _mesa_TextureStorage1D_no_error);
      SET_TextureStorage2D(table, _mesa_TextureStorage2D_no_error);
      SET_TextureStorage3D(table, _mesa_TextureStorage3D_no_error);
      SET_TextureSubImage1D(table, _mesa_TextureSubImage1D_no_error);
      SET_TextureSubImage2D(table, _mesa_TextureSubImage2D_no_error);
      SET_TextureSubImage3D(table, _mesa_TextureSubImage3D_no_error);
      SET_VertexArrayAttribBinding(table, _mesa_VertexArrayAttribBinding_no_error);
      SET_VertexArrayBindingDivisor(table, _mesa_VertexArrayBindingDivisor_no_error);
      SET_VertexArrayElementBuffer(table, _mesa_VertexArrayElementBuffer_no_error);
      SET_VertexArrayVertexBuffer(table, _mesa_VertexArrayVertexBuffer_no_error);
      SET_VertexArrayVertexBuffers(table, _mesa_VertexArrayVertexBuffers_no_error);
      SET_VertexAttribLPointer(table, _mesa_VertexAttribLPointer_no_error);
   }
   if (_mesa_is_no_error_enabled(ctx) && (_mesa_is_desktop_gl_compat(ctx) || _mesa_is_gles1(ctx))) {
      SET_ColorPointer(table, _mesa_ColorPointer_no_error);
      SET_NormalPointer(table, _mesa_NormalPointer_no_error);
      SET_TexCoordPointer(table, _mesa_TexCoordPointer_no_error);
      SET_VertexPointer(table, _mesa_VertexPointer_no_error);
   }
   if (_mesa_is_no_error_enabled(ctx) && (_mesa_is_desktop_gl_compat(ctx))) {
      SET_EdgeFlagPointer(table, _mesa_EdgeFlagPointer_no_error);
      SET_FogCoordPointer(table, _mesa_FogCoordPointer_no_error);
      SET_IndexPointer(table, _mesa_IndexPointer_no_error);
      SET_SecondaryColorPointer(table, _mesa_SecondaryColorPointer_no_error);
   }
   if (_mesa_is_no_error_enabled(ctx) && (_mesa_is_gles1(ctx))) {
      SET_PointSizePointerOES(table, _mesa_PointSizePointerOES_no_error);
   }

}

