/* This file is autogenerated by sid_tables.py from sid.h. Do not edit directly. */

/*
 * Copyright 2015-2019 Advanced Micro Devices, Inc.
 *
 * SPDX-License-Identifier: MIT
 */

#ifndef SID_TABLES_H
#define SID_TABLES_H

struct si_field {
        unsigned name_offset;
        unsigned mask;
        unsigned num_values;
        unsigned values_offset; /* offset into sid_strings_offsets */
};

struct si_reg {
        unsigned name_offset;
        unsigned offset;
        unsigned num_fields;
        unsigned fields_offset;
};

struct si_packet3 {
        unsigned name_offset;
        unsigned op;
};

static const struct si_packet3 packet3_table[] = {
	{0, PKT3_NOP},
	{4, PKT3_SET_BASE},
	{13, PKT3_CLEAR_STATE},
	{25, PKT3_INDEX_BUFFER_SIZE},
	{43, PKT3_DISPATCH_DIRECT},
	{59, PKT3_DISPATCH_INDIRECT},
	{77, PKT3_ATOMIC_MEM},
	{88, PKT3_OCCLUSION_QUERY},
	{104, PKT3_SET_PREDICATION},
	{120, PKT3_COND_EXEC},
	{130, PKT3_PRED_EXEC},
	{140, PKT3_DRAW_INDIRECT},
	{154, PKT3_DRAW_INDEX_INDIRECT},
	{174, PKT3_INDEX_BASE},
	{185, PKT3_DRAW_INDEX_2},
	{198, PKT3_CONTEXT_CONTROL},
	{214, PKT3_INDEX_TYPE},
	{225, PKT3_DRAW_INDIRECT_MULTI},
	{245, PKT3_DRAW_INDEX_AUTO},
	{261, PKT3_DRAW_INDEX_IMMD},
	{277, PKT3_NUM_INSTANCES},
	{291, PKT3_DRAW_INDEX_MULTI_AUTO},
	{313, PKT3_INDIRECT_BUFFER_SI},
	{332, PKT3_INDIRECT_BUFFER_CONST},
	{354, PKT3_STRMOUT_BUFFER_UPDATE},
	{376, PKT3_DRAW_INDEX_OFFSET_2},
	{396, PKT3_WRITE_DATA},
	{407, PKT3_DRAW_INDEX_INDIRECT_MULTI},
	{433, PKT3_MEM_SEMAPHORE},
	{447, PKT3_MPEG_INDEX},
	{458, PKT3_WAIT_REG_MEM},
	{471, PKT3_MEM_WRITE},
	{481, PKT3_INDIRECT_BUFFER},
	{497, PKT3_COPY_DATA},
	{507, PKT3_CP_DMA},
	{514, PKT3_PFP_SYNC_ME},
	{526, PKT3_SURFACE_SYNC},
	{539, PKT3_ME_INITIALIZE},
	{553, PKT3_COND_WRITE},
	{564, PKT3_EVENT_WRITE},
	{576, PKT3_EVENT_WRITE_EOP},
	{592, PKT3_EVENT_WRITE_EOS},
	{592, PKT3_EVENT_WRITE_EOS},
	{608, PKT3_RELEASE_MEM},
	{620, PKT3_DISPATCH_MESH_INDIRECT_MULTI},
	{649, PKT3_DISPATCH_TASKMESH_GFX},
	{671, PKT3_DISPATCH_MESH_DIRECT},
	{692, PKT3_DMA_DATA},
	{701, PKT3_CONTEXT_REG_RMW},
	{717, PKT3_ONE_REG_WRITE},
	{731, PKT3_ACQUIRE_MEM},
	{743, PKT3_REWIND},
	{750, PKT3_PRIME_UTCL2},
	{762, PKT3_LOAD_UCONFIG_REG},
	{779, PKT3_LOAD_SH_REG},
	{791, PKT3_LOAD_CONTEXT_REG},
	{808, PKT3_LOAD_SH_REG_INDEX},
	{826, PKT3_SET_CONFIG_REG},
	{841, PKT3_SET_CONTEXT_REG},
	{857, PKT3_SET_SH_REG},
	{868, PKT3_SET_SH_REG_OFFSET},
	{886, PKT3_SET_UCONFIG_REG},
	{902, PKT3_SET_UCONFIG_REG_INDEX},
	{924, PKT3_LOAD_CONST_RAM},
	{939, PKT3_WRITE_CONST_RAM},
	{955, PKT3_DUMP_CONST_RAM},
	{970, PKT3_INCREMENT_CE_COUNTER},
	{991, PKT3_INCREMENT_DE_COUNTER},
	{1012, PKT3_WAIT_ON_CE_COUNTER},
	{1031, PKT3_SET_SH_REG_INDEX},
	{1048, PKT3_LOAD_CONTEXT_REG_INDEX},
	{1071, PKT3_DISPATCH_TASK_STATE_INIT},
	{1096, PKT3_DISPATCH_TASKMESH_DIRECT_ACE},
	{1125, PKT3_DISPATCH_TASKMESH_INDIRECT_MULTI_ACE},
	{1162, PKT3_EVENT_WRITE_ZPASS},
	{1180, PKT3_SET_CONTEXT_REG_PAIRS},
	{1202, PKT3_SET_CONTEXT_REG_PAIRS_PACKED},
	{1231, PKT3_SET_SH_REG_PAIRS},
	{1248, PKT3_SET_SH_REG_PAIRS_PACKED},
	{1272, PKT3_SET_SH_REG_PAIRS_PACKED_N},
	{1298, PKT3_IT_OPCODE_C},
};

static const struct si_reg gfx10_reg_table[] = {
	{1310, 1028, 10, 0},
	{1323, 1032, 20, 10},
	{1338, 1036, 10, 30},
	{1354, 1040, 12, 40},
	{1375, 1044, 4, 52},
	{1393, 1048, 3, 56},
	{1411, 1052, 11, 59},
	{1426, 1056},
	{1440, 1060, 1, 70},
	{1454, 1064},
	{1471, 1076, 9, 71},
	{1487, 1080},
	{1504, 1116, 5, 80},
	{1519, 1120, 7, 85},
	{1534, 1124, 2, 92},
	{1554, 1128, 1, 94},
	{1573, 1132, 4, 95},
	{1593, 1136, 7, 99},
	{1609, 2480},
	{1623, 2484},
	{1637, 2488},
	{1651, 2492},
	{1665, 2496},
	{1679, 2500},
	{1693, 2504},
	{1707, 2508},
	{1721, 2512},
	{1735, 2516},
	{1749, 2520},
	{1764, 2524},
	{1779, 2528},
	{1794, 2532},
	{1809, 2536},
	{1824, 2540},
	{1839, 2544},
	{1850, 2552},
	{1866, 2556},
	{1882, 2560},
	{1906, 2564},
	{1930, 2568},
	{1954, 32776, 27, 106},
	{1967, 32784, 21, 133},
	{1979, 32788, 14, 154},
	{1995, 32792, 14, 154},
	{2011, 32796, 15, 168},
	{2024, 32824, 14, 154},
	{2040, 32828, 14, 154},
	{2056, 33296, 21, 183},
	{2070, 33300, 28, 204},
	{2087, 33304, 15, 232},
	{2108, 33308, 28, 247},
	{2122, 33312, 32, 275},
	{2139, 33316, 13, 307},
	{2160, 33320, 9, 320},
	{2178, 33324, 1, 329},
	{2201, 33344, 2, 330},
	{2222, 33348},
	{2242, 33352, 1, 332},
	{2265, 33356, 9, 333},
	{2283, 33436, 1, 342},
	{2306, 36096},
	{2332, 36100, 2, 343},
	{2358, 36104},
	{2384, 36108, 2, 343},
	{2410, 36112, 2, 345},
	{2431, 36116, 4, 347},
	{2452, 36120, 4, 351},
	{2479, 36124, 17, 355},
	{2500, 36128, 6, 372},
	{2523, 36132},
	{2552, 36140},
	{2582, 36144},
	{2614, 36148},
	{2645, 36152},
	{2678, 36348, 5, 378},
	{2687, 36608},
	{2705, 36612, 4, 383},
	{2723, 36616},
	{2741, 36620, 10, 387},
	{2759, 36656, 14, 397},
	{2777, 36660, 4, 411},
	{2795, 36664, 9, 415},
	{2813, 36668, 2, 424},
	{2831, 37120, 9, 426},
	{2847, 39160, 5, 435},
	{2862, 39184, 5, 440},
	{2876, 39188, 5, 440},
	{2890, 39192, 5, 440},
	{2904, 39196, 5, 440},
	{2918, 39200, 5, 440},
	{2932, 39204, 5, 440},
	{2946, 39208, 5, 440},
	{2960, 39212, 5, 440},
	{2974, 39216, 5, 440},
	{2988, 39220, 5, 440},
	{3002, 39224, 5, 440},
	{3017, 39228, 5, 440},
	{3032, 39232, 5, 440},
	{3047, 39236, 5, 440},
	{3062, 39240, 5, 440},
	{3077, 39244, 5, 440},
	{3092, 39248, 5, 440},
	{3107, 39252, 5, 440},
	{3122, 39256, 5, 440},
	{3137, 39260, 5, 440},
	{3152, 39264, 5, 440},
	{3167, 39268, 5, 440},
	{3182, 39272, 5, 440},
	{3197, 39276, 5, 440},
	{3212, 39280, 5, 440},
	{3227, 39284, 5, 440},
	{3242, 39288, 5, 440},
	{3257, 39292, 5, 440},
	{3272, 39296, 5, 440},
	{3287, 39300, 5, 440},
	{3302, 39304, 5, 440},
	{3317, 39308, 5, 440},
	{3332, 39312, 4, 445},
	{3351, 39316, 4, 445},
	{3370, 39320, 4, 445},
	{3389, 39324, 4, 445},
	{3408, 39328, 4, 445},
	{3427, 39332, 4, 445},
	{3446, 39336, 4, 445},
	{3465, 39340, 4, 445},
	{3484, 39344, 4, 445},
	{3503, 39348, 4, 445},
	{3522, 39352, 4, 445},
	{3542, 39356, 4, 445},
	{3562, 39360, 4, 445},
	{3582, 39364, 4, 445},
	{3602, 39368, 4, 445},
	{3622, 39372, 4, 445},
	{3642, 40960},
	{3660, 40964, 4, 449},
	{3678, 40968, 3, 453},
	{3696, 40972, 9, 456},
	{3714, 40976, 2, 465},
	{3732, 40980, 7, 467},
	{3750, 40984, 10, 474},
	{3768, 40988},
	{3786, 41264, 10, 484},
	{3818, 45060, 1, 494},
	{3842, 45080},
	{3867, 45084, 3, 495},
	{3891, 45088},
	{3912, 45092, 1, 498},
	{3933, 45096, 11, 499},
	{3957, 45100, 10, 510},
	{3981, 45104},
	{4007, 45108},
	{4033, 45112},
	{4059, 45116},
	{4085, 45120},
	{4111, 45124},
	{4137, 45128},
	{4163, 45132},
	{4189, 45136},
	{4215, 45140},
	{4241, 45144},
	{4268, 45148},
	{4295, 45152},
	{4322, 45156},
	{4349, 45160},
	{4376, 45164},
	{4403, 45168},
	{4430, 45172},
	{4457, 45176},
	{4484, 45180},
	{4511, 45184},
	{4538, 45188},
	{4565, 45192},
	{4592, 45196},
	{4619, 45200},
	{4646, 45204},
	{4673, 45208},
	{4700, 45212},
	{4727, 45216},
	{4754, 45220},
	{4781, 45224},
	{4808, 45228},
	{4835, 45248, 8, 520},
	{4858, 45252, 5, 528},
	{4891, 45256, 1, 533},
	{4918, 45260, 1, 533},
	{4945, 45264, 1, 533},
	{4972, 45268, 1, 533},
	{4999, 45316, 1, 494},
	{5023, 45332},
	{5048, 45336, 3, 495},
	{5072, 45340, 1, 534},
	{5097, 45344},
	{5118, 45348, 1, 498},
	{5139, 45352, 12, 535},
	{5163, 45356, 14, 547},
	{5187, 45360},
	{5213, 45364},
	{5239, 45368},
	{5265, 45372},
	{5291, 45376},
	{5317, 45380},
	{5343, 45384},
	{5369, 45388},
	{5395, 45392},
	{5421, 45396},
	{5447, 45400},
	{5474, 45404},
	{5501, 45408},
	{5528, 45412},
	{5555, 45416},
	{5582, 45420},
	{5609, 45424},
	{5636, 45428},
	{5663, 45432},
	{5690, 45436},
	{5717, 45440},
	{5744, 45444},
	{5771, 45448},
	{5798, 45452},
	{5825, 45456},
	{5852, 45460},
	{5879, 45464},
	{5906, 45468},
	{5933, 45472},
	{5960, 45476},
	{5987, 45480},
	{6014, 45484},
	{6041, 45504, 8, 520},
	{6064, 45508, 5, 528},
	{6097, 45512, 1, 533},
	{6124, 45516, 1, 533},
	{6151, 45520, 1, 533},
	{6178, 45524, 1, 533},
	{6205, 45548, 9, 561},
	{6232, 45552, 6, 570},
	{6259, 45556, 5, 576},
	{6286, 45568},
	{6311, 45572, 2, 581},
	{6335, 45576},
	{6367, 45580},
	{6399, 45584},
	{6423, 45588, 1, 498},
	{6447, 45596, 4, 583},
	{6471, 45600},
	{6492, 45604, 1, 498},
	{6513, 45608, 13, 587},
	{6537, 45612, 9, 600},
	{6561, 45616},
	{6587, 45620},
	{6613, 45624},
	{6639, 45628},
	{6665, 45632},
	{6691, 45636},
	{6717, 45640},
	{6743, 45644},
	{6769, 45648},
	{6795, 45652},
	{6821, 45656},
	{6848, 45660},
	{6875, 45664},
	{6902, 45668},
	{6929, 45672},
	{6956, 45676},
	{6983, 45680},
	{7010, 45684},
	{7037, 45688},
	{7064, 45692},
	{7091, 45696},
	{7118, 45700},
	{7145, 45704},
	{7172, 45708},
	{7199, 45712},
	{7226, 45716},
	{7253, 45720},
	{7280, 45724},
	{7307, 45728},
	{7334, 45732},
	{7361, 45736},
	{7388, 45740},
	{7415, 45760, 8, 520},
	{7440, 45764, 5, 528},
	{7475, 45768, 1, 533},
	{7504, 45772, 1, 533},
	{7533, 45776, 1, 533},
	{7562, 45780, 1, 533},
	{7591, 45808, 6, 570},
	{7618, 45852, 4, 583},
	{7642, 45856},
	{7663, 45860, 1, 498},
	{7684, 45864, 10, 609},
	{7708, 45868, 6, 570},
	{7732, 45872},
	{7758, 45876},
	{7784, 45880},
	{7810, 45884},
	{7836, 45888},
	{7862, 45892},
	{7888, 45896},
	{7914, 45900},
	{7940, 45904},
	{7966, 45908},
	{7992, 45912},
	{8019, 45916},
	{8046, 45920},
	{8073, 45924},
	{8100, 45928},
	{8127, 45932},
	{8154, 46068, 5, 576},
	{8181, 46080},
	{8206, 46084, 1, 494},
	{8230, 46088},
	{8262, 46092},
	{8294, 46096},
	{8318, 46100, 1, 498},
	{8342, 46108, 4, 619},
	{8366, 46112},
	{8387, 46116, 1, 498},
	{8408, 46120, 12, 623},
	{8432, 46124, 9, 635},
	{8456, 46128},
	{8482, 46132},
	{8508, 46136},
	{8534, 46140},
	{8560, 46144},
	{8586, 46148},
	{8612, 46152},
	{8638, 46156},
	{8664, 46160},
	{8690, 46164},
	{8716, 46168},
	{8743, 46172},
	{8770, 46176},
	{8797, 46180},
	{8824, 46184},
	{8851, 46188},
	{8878, 46192},
	{8905, 46196},
	{8932, 46200},
	{8959, 46204},
	{8986, 46208},
	{9013, 46212},
	{9040, 46216},
	{9067, 46220},
	{9094, 46224},
	{9121, 46228},
	{9148, 46232},
	{9175, 46236},
	{9202, 46240},
	{9229, 46244},
	{9256, 46248},
	{9283, 46252},
	{9310, 46272, 8, 520},
	{9335, 46276, 5, 528},
	{9370, 46280, 1, 533},
	{9399, 46284, 1, 533},
	{9428, 46288, 1, 533},
	{9457, 46292, 1, 533},
	{9486, 46324, 5, 576},
	{9513, 46364, 4, 583},
	{9537, 46368},
	{9558, 46372, 1, 498},
	{9579, 46376, 9, 644},
	{9603, 46380, 5, 576},
	{9627, 46384},
	{9653, 46388},
	{9679, 46392},
	{9705, 46396},
	{9731, 46400},
	{9757, 46404},
	{9783, 46408},
	{9809, 46412},
	{9835, 46416},
	{9861, 46420},
	{9887, 46424},
	{9914, 46428},
	{9941, 46432},
	{9968, 46436},
	{9995, 46440},
	{10022, 46444},
	{10049, 47104, 13, 653},
	{10076, 47108},
	{10090, 47112},
	{10104, 47116},
	{10118, 47120},
	{10134, 47124},
	{10150, 47128},
	{10166, 47132, 2, 666},
	{10187, 47136, 2, 666},
	{10208, 47140, 2, 666},
	{10229, 47144, 1, 668},
	{10257, 47148, 1, 669},
	{10282, 47152},
	{10297, 47156, 1, 670},
	{10312, 47160},
	{10341, 47164, 1, 670},
	{10370, 47168},
	{10403, 47172, 1, 670},
	{10436, 47176, 12, 671},
	{10454, 47180, 11, 683},
	{10472, 47184, 1, 694},
	{10485, 47188, 6, 695},
	{10509, 47192},
	{10536, 47196},
	{10563, 47200, 2, 701},
	{10584, 47204},
	{10611, 47208},
	{10638, 47212},
	{10656, 47216},
	{10674, 47220},
	{10692, 47224, 1, 703},
	{10720, 47228, 5, 704},
	{10742, 47232},
	{10762, 47236},
	{10785, 47240, 9, 709},
	{10802, 47248, 1, 533},
	{10823, 47252, 1, 533},
	{10844, 47256, 1, 533},
	{10865, 47260, 1, 533},
	{10886, 47264, 1, 718},
	{10904, 47268, 1, 719},
	{10923, 47272},
	{10945, 47276, 3, 720},
	{10962, 47280},
	{10991, 47284, 1, 723},
	{11020, 47288, 3, 720},
	{11038, 47360},
	{11058, 47364},
	{11078, 47368},
	{11098, 47372},
	{11118, 47376},
	{11138, 47380},
	{11158, 47384},
	{11178, 47388},
	{11198, 47392},
	{11218, 47396},
	{11238, 47400},
	{11259, 47404},
	{11280, 47408},
	{11301, 47412},
	{11322, 47416},
	{11343, 47420},
	{11364, 47604, 2, 724},
	{11388, 47608},
	{11409, 47612},
	{11425, 163840, 10, 726},
	{11443, 163844, 11, 736},
	{11460, 163848, 7, 747},
	{11474, 163852, 23, 754},
	{11493, 163856, 16, 777},
	{11513, 163860},
	{11532, 163868, 2, 793},
	{11549, 163872},
	{11569, 163876},
	{11589, 163880, 1, 795},
	{11606, 163884},
	{11621, 163888, 2, 796},
	{11645, 163892, 2, 798},
	{11669, 163896, 3, 800},
	{11685, 163900, 8, 803},
	{11703, 163904, 14, 811},
	{11713, 163908, 9, 825},
	{11729, 163912},
	{11744, 163916},
	{11765, 163920},
	{11781, 163924},
	{11803, 163928, 2, 834},
	{11821, 163932, 1, 836},
	{11839, 163944, 1, 837},
	{11857, 163948, 1, 837},
	{11881, 163952, 1, 837},
	{11900, 163956, 1, 837},
	{11925, 163960, 1, 837},
	{11947, 163964, 9, 838},
	{11971, 163968},
	{11987, 163972, 1, 847},
	{12006, 164328, 1, 848},
	{12027, 164332, 1, 848},
	{12048, 164336, 1, 848},
	{12069, 164340, 1, 848},
	{12090, 164344},
	{12108, 164348},
	{12126, 164352, 2, 849},
	{12146, 164356, 3, 851},
	{12170, 164360, 2, 854},
	{12194, 164364, 1, 856},
	{12214, 164368, 2, 851},
	{12234, 164372, 2, 854},
	{12254, 164376, 2, 851},
	{12274, 164380, 2, 854},
	{12294, 164384, 2, 851},
	{12314, 164388, 2, 854},
	{12334, 164392, 2, 851},
	{12354, 164396, 2, 854},
	{12374, 164400, 7, 857},
	{12389, 164404, 2, 864},
	{12418, 164408, 8, 866},
	{12433, 164412, 8, 874},
	{12448, 164416, 3, 851},
	{12473, 164420, 2, 854},
	{12498, 164424},
	{12516, 164428},
	{12534, 164432, 3, 851},
	{12559, 164436, 2, 854},
	{12584, 164440, 3, 851},
	{12609, 164444, 2, 854},
	{12634, 164448, 3, 851},
	{12659, 164452, 2, 854},
	{12684, 164456, 3, 851},
	{12709, 164460, 2, 854},
	{12734, 164464, 3, 851},
	{12759, 164468, 2, 854},
	{12784, 164472, 3, 851},
	{12809, 164476, 2, 854},
	{12834, 164480, 3, 851},
	{12859, 164484, 2, 854},
	{12884, 164488, 3, 851},
	{12909, 164492, 2, 854},
	{12934, 164496, 3, 851},
	{12959, 164500, 2, 854},
	{12984, 164504, 3, 851},
	{13009, 164508, 2, 854},
	{13034, 164512, 3, 851},
	{13060, 164516, 2, 854},
	{13086, 164520, 3, 851},
	{13112, 164524, 2, 854},
	{13138, 164528, 3, 851},
	{13164, 164532, 2, 854},
	{13190, 164536, 3, 851},
	{13216, 164540, 2, 854},
	{13242, 164544, 3, 851},
	{13268, 164548, 2, 854},
	{13294, 164552, 3, 851},
	{13320, 164556, 2, 854},
	{13346, 164560},
	{13365, 164564},
	{13384, 164568},
	{13403, 164572},
	{13422, 164576},
	{13441, 164580},
	{13460, 164584},
	{13479, 164588},
	{13498, 164592},
	{13517, 164596},
	{13536, 164600},
	{13555, 164604},
	{13574, 164608},
	{13593, 164612},
	{13612, 164616},
	{13631, 164620},
	{13650, 164624},
	{13669, 164628},
	{13688, 164632},
	{13707, 164636},
	{13726, 164640},
	{13746, 164644},
	{13766, 164648},
	{13786, 164652},
	{13806, 164656},
	{13826, 164660},
	{13846, 164664},
	{13866, 164668},
	{13886, 164672},
	{13906, 164676},
	{13926, 164680},
	{13946, 164684},
	{13966, 164688, 15, 882},
	{13986, 164692, 3, 897},
	{14008, 164696, 2, 900},
	{14036, 164700, 7, 902},
	{14065, 164704, 1, 909},
	{14086, 164708, 1, 910},
	{14096, 164712, 1, 911},
	{14104, 164768, 4, 912},
	{14126, 164772, 4, 912},
	{14147, 164776, 4, 916},
	{14164, 164864},
	{14181, 164868},
	{14198, 164872},
	{14214, 164876},
	{14243, 164880, 10, 920},
	{14268, 164884},
	{14281, 164888},
	{14296, 164892},
	{14310, 164896},
	{14325, 164900, 8, 930},
	{14340, 164904, 4, 938},
	{14364, 164908, 6, 942},
	{14383, 164912, 4, 948},
	{14401, 164916, 4, 952},
	{14422, 164924},
	{14441, 164928},
	{14461, 164932},
	{14480, 164936},
	{14500, 164940},
	{14519, 164944},
	{14539, 164948},
	{14560, 164952},
	{14582, 164956},
	{14603, 164960},
	{14625, 164964},
	{14646, 164968},
	{14668, 164972},
	{14689, 164976},
	{14711, 164980},
	{14732, 164984},
	{14754, 164988},
	{14775, 164992},
	{14797, 164996},
	{14818, 165000},
	{14840, 165004},
	{14861, 165008},
	{14883, 165012},
	{14904, 165016},
	{14926, 165020},
	{14947, 165024},
	{14969, 165028},
	{14990, 165032},
	{15012, 165036},
	{15033, 165040},
	{15055, 165044},
	{15076, 165048},
	{15098, 165052},
	{15119, 165056},
	{15141, 165060},
	{15162, 165064},
	{15184, 165068},
	{15205, 165072},
	{15227, 165076},
	{15248, 165080},
	{15270, 165084},
	{15291, 165088},
	{15313, 165092},
	{15334, 165096},
	{15356, 165100},
	{15377, 165104},
	{15399, 165108},
	{15420, 165112},
	{15442, 165116},
	{15463, 165120},
	{15485, 165124},
	{15506, 165128},
	{15528, 165132},
	{15549, 165136},
	{15571, 165140},
	{15592, 165144},
	{15614, 165148},
	{15635, 165152},
	{15657, 165156},
	{15678, 165160},
	{15700, 165164},
	{15722, 165168},
	{15745, 165172},
	{15767, 165176},
	{15790, 165180},
	{15812, 165184},
	{15835, 165188},
	{15857, 165192},
	{15880, 165196},
	{15902, 165200},
	{15925, 165204},
	{15947, 165208},
	{15970, 165212},
	{15992, 165216},
	{16015, 165220},
	{16037, 165224},
	{16060, 165228},
	{16082, 165232},
	{16105, 165236},
	{16127, 165240},
	{16150, 165244},
	{16172, 165248},
	{16195, 165252},
	{16217, 165256},
	{16240, 165260},
	{16262, 165264},
	{16285, 165268},
	{16307, 165272},
	{16330, 165276},
	{16352, 165280},
	{16375, 165284},
	{16397, 165288},
	{16420, 165292},
	{16442, 165296},
	{16465, 165300},
	{16487, 165304},
	{16510, 165308},
	{16524, 165312},
	{16538, 165316},
	{16552, 165320},
	{16566, 165324},
	{16580, 165328},
	{16594, 165332},
	{16608, 165336},
	{16622, 165340},
	{16636, 165344},
	{16650, 165348},
	{16664, 165352},
	{16678, 165356},
	{16692, 165360},
	{16706, 165364},
	{16720, 165368},
	{16734, 165372},
	{16748, 165376},
	{16762, 165380},
	{16776, 165384},
	{16790, 165388},
	{16804, 165392},
	{16818, 165396},
	{16832, 165400},
	{16846, 165404},
	{16869, 165444, 12, 956},
	{16889, 165448, 12, 956},
	{16909, 165452, 12, 956},
	{16929, 165456, 12, 956},
	{16949, 165460, 12, 956},
	{16969, 165464, 12, 956},
	{16989, 165468, 12, 956},
	{17009, 165472, 12, 956},
	{17029, 165476, 12, 956},
	{17049, 165480, 12, 956},
	{17069, 165484, 12, 956},
	{17090, 165488, 12, 956},
	{17111, 165492, 12, 956},
	{17132, 165496, 12, 956},
	{17153, 165500, 12, 956},
	{17174, 165504, 12, 956},
	{17195, 165508, 12, 956},
	{17216, 165512, 12, 956},
	{17237, 165516, 12, 956},
	{17258, 165520, 12, 956},
	{17279, 165524, 9, 968},
	{17300, 165528, 9, 968},
	{17321, 165532, 9, 968},
	{17342, 165536, 9, 968},
	{17363, 165540, 9, 968},
	{17384, 165544, 9, 968},
	{17405, 165548, 9, 968},
	{17426, 165552, 9, 968},
	{17447, 165556, 9, 968},
	{17468, 165560, 9, 968},
	{17489, 165564, 9, 968},
	{17510, 165568, 9, 968},
	{17531, 165572, 3, 977},
	{17549, 165580, 16, 980},
	{17566, 165584, 16, 980},
	{17584, 165588, 7, 996},
	{17605, 165592, 6, 1003},
	{17623, 165600, 7, 1009},
	{17638, 165608, 2, 701},
	{17655, 165640, 1, 1016},
	{17677, 165644, 5, 1017},
	{17699, 165648, 1, 1022},
	{17719, 165652, 8, 1023},
	{17741, 165716, 8, 1031},
	{17759, 165720, 8, 1039},
	{17780, 165724, 17, 1047},
	{17801, 165728, 6, 1064},
	{17819, 165732, 6, 1064},
	{17837, 165736, 6, 1064},
	{17855, 165740, 6, 1064},
	{17873, 165744, 6, 1064},
	{17891, 165748, 6, 1064},
	{17909, 165752, 6, 1064},
	{17927, 165756, 6, 1064},
	{17945, 165760, 9, 1070},
	{17963, 165764, 9, 1070},
	{17981, 165768, 9, 1070},
	{17999, 165772, 9, 1070},
	{18017, 165776, 9, 1070},
	{18035, 165780, 9, 1070},
	{18053, 165784, 9, 1070},
	{18071, 165788, 9, 1070},
	{18089, 165836, 1, 1079},
	{18103, 165840, 1, 1079},
	{18118, 165844},
	{18136, 165848},
	{18154, 165852},
	{18171, 165856},
	{18192, 165860, 1, 1080},
	{18208, 165864},
	{18221, 165872, 8, 1081},
	{18240, 165876},
	{18255, 165880, 1, 1089},
	{18277, 165884, 1, 1090},
	{18304, 165888, 10, 1091},
	{18321, 165892, 12, 1101},
	{18329, 165896, 4, 1113},
	{18346, 165900, 17, 1117},
	{18364, 165904, 20, 1134},
	{18380, 165908, 16, 1154},
	{18399, 165912, 10, 1170},
	{18414, 165916, 28, 1180},
	{18432, 165920, 16, 1208},
	{18450, 165924, 4, 1224},
	{18474, 165928},
	{18499, 165932, 11, 1228},
	{18522, 165936, 7, 1239},
	{18551, 165940, 2, 1246},
	{18573, 165944, 2, 1248},
	{18588, 165948, 5, 1250},
	{18618, 165952, 5, 1255},
	{18633, 165956},
	{18651, 166400, 2, 1260},
	{18668, 166404, 2, 1262},
	{18687, 166408, 1, 1264},
	{18703, 166412, 4, 1265},
	{18722, 166416, 1, 1269},
	{18743, 166420, 1, 1270},
	{18756, 166424},
	{18779, 166428},
	{18802, 166432, 1, 1271},
	{18822, 166436, 4, 1272},
	{18842, 166440, 1, 1276},
	{18863, 166444, 1, 1277},
	{18878, 166448, 6, 1278},
	{18900, 166452, 6, 1278},
	{18922, 166456, 8, 1284},
	{18948, 166460, 8, 1284},
	{18974, 166464, 15, 1292},
	{18986, 166468, 3, 1307},
	{19005, 166472, 7, 1310},
	{19023, 166476, 24, 1317},
	{19041, 166480},
	{19053, 166484, 1, 1341},
	{19067, 166488, 1, 1342},
	{19081, 166492, 1, 1343},
	{19095, 166496, 1, 1344},
	{19118, 166500, 1, 1344},
	{19141, 166504, 1, 1344},
	{19164, 166508, 5, 1345},
	{19185, 166512},
	{19196, 166516},
	{19209, 166520},
	{19226, 166524, 8, 1350},
	{19245, 166528},
	{19256, 166532, 3, 1358},
	{19275, 166536},
	{19297, 166540},
	{19319, 166544, 3, 1361},
	{19339, 166548, 2, 1364},
	{19366, 166552, 5, 1366},
	{19388, 166560},
	{19413, 166564},
	{19438, 166568, 6, 1371},
	{19457, 166572, 1, 1377},
	{19480, 166576, 1, 1377},
	{19503, 166580, 1, 1378},
	{19517, 166584, 1, 1379},
	{19532, 166588, 9, 1380},
	{19549, 166592, 4, 1389},
	{19576, 166596, 4, 1393},
	{19603, 166600, 4, 1397},
	{19622, 166608},
	{19648, 166612, 1, 1401},
	{19673, 166620},
	{19701, 166624},
	{19727, 166628, 1, 1401},
	{19752, 166636},
	{19780, 166640},
	{19806, 166644, 1, 1401},
	{19831, 166652},
	{19859, 166656},
	{19885, 166660, 1, 1401},
	{19910, 166668},
	{19938, 166696},
	{19969, 166700},
	{20012, 166704, 1, 1402},
	{20050, 166712, 1, 1403},
	{20070, 166732, 2, 1404},
	{20089, 166736, 5, 1406},
	{20111, 166740, 19, 1411},
	{20132, 166744, 3, 1430},
	{20149, 166748, 1, 1377},
	{20170, 166752, 1, 1377},
	{20193, 166756, 1, 1377},
	{20216, 166760, 1, 1377},
	{20239, 166764, 12, 1433},
	{20252, 166768, 6, 1445},
	{20269, 166772},
	{20293, 166776, 2, 1451},
	{20323, 166780},
	{20347, 166784},
	{20377, 166788},
	{20408, 166792},
	{20437, 166796},
	{20467, 166800, 3, 1453},
	{20487, 166804, 8, 1456},
	{20506, 166808, 4, 1464},
	{20532, 166812, 3, 1361},
	{20556, 166868, 8, 1468},
	{20582, 166872, 8, 1476},
	{20608, 166876, 5, 1484},
	{20624, 166880, 6, 1489},
	{20640, 166884, 3, 1495},
	{20655, 166888},
	{20678, 166892},
	{20701, 166896},
	{20724, 166900},
	{20747, 166904, 8, 1498},
	{20781, 166908, 8, 1506},
	{20815, 166912, 8, 1514},
	{20849, 166916, 8, 1522},
	{20883, 166920, 8, 1498},
	{20917, 166924, 8, 1506},
	{20951, 166928, 8, 1514},
	{20985, 166932, 8, 1522},
	{21019, 166936, 8, 1498},
	{21053, 166940, 8, 1506},
	{21087, 166944, 8, 1514},
	{21121, 166948, 8, 1522},
	{21155, 166952, 8, 1498},
	{21189, 166956, 8, 1506},
	{21223, 166960, 8, 1514},
	{21257, 166964, 8, 1522},
	{21291, 166968, 2, 1530},
	{21315, 166972, 2, 1532},
	{21339, 166976, 4, 1534},
	{21360, 166980, 12, 1538},
	{21380, 166984, 2, 1550},
	{21400, 166988, 20, 1552},
	{21438, 166992, 2, 1572},
	{21458, 167000, 1, 1574},
	{21486, 167004, 1, 1575},
	{21507, 167008},
	{21522, 167012, 2, 1576},
	{21538, 167016, 1, 1578},
	{21554, 167020, 3, 1579},
	{21569, 167024, 19, 1582},
	{21584, 167028, 8, 1601},
	{21601, 167032, 12, 1609},
	{21623, 167036},
	{21639, 167040, 1, 1621},
	{21661, 167044},
	{21677, 167048, 1, 1578},
	{21699, 167052},
	{21721, 167056},
	{21743, 167060},
	{21762, 167068},
	{21777, 167072, 2, 1576},
	{21793, 167076, 1, 1578},
	{21809, 167080, 3, 1579},
	{21824, 167084, 19, 1582},
	{21839, 167088, 8, 1601},
	{21856, 167092, 12, 1609},
	{21878, 167096},
	{21894, 167100, 1, 1621},
	{21916, 167104},
	{21932, 167108, 1, 1578},
	{21954, 167112},
	{21976, 167116},
	{21998, 167120},
	{22017, 167128},
	{22032, 167132, 2, 1576},
	{22048, 167136, 1, 1578},
	{22064, 167140, 3, 1579},
	{22079, 167144, 19, 1582},
	{22094, 167148, 8, 1601},
	{22111, 167152, 12, 1609},
	{22133, 167156},
	{22149, 167160, 1, 1621},
	{22171, 167164},
	{22187, 167168, 1, 1578},
	{22209, 167172},
	{22231, 167176},
	{22253, 167180},
	{22272, 167188},
	{22287, 167192, 2, 1576},
	{22303, 167196, 1, 1578},
	{22319, 167200, 3, 1579},
	{22334, 167204, 19, 1582},
	{22349, 167208, 8, 1601},
	{22366, 167212, 12, 1609},
	{22388, 167216},
	{22404, 167220, 1, 1621},
	{22426, 167224},
	{22442, 167228, 1, 1578},
	{22464, 167232},
	{22486, 167236},
	{22508, 167240},
	{22527, 167248},
	{22542, 167252, 2, 1576},
	{22558, 167256, 1, 1578},
	{22574, 167260, 3, 1579},
	{22589, 167264, 19, 1582},
	{22604, 167268, 8, 1601},
	{22621, 167272, 12, 1609},
	{22643, 167276},
	{22659, 167280, 1, 1621},
	{22681, 167284},
	{22697, 167288, 1, 1578},
	{22719, 167292},
	{22741, 167296},
	{22763, 167300},
	{22782, 167308},
	{22797, 167312, 2, 1576},
	{22813, 167316, 1, 1578},
	{22829, 167320, 3, 1579},
	{22844, 167324, 19, 1582},
	{22859, 167328, 8, 1601},
	{22876, 167332, 12, 1609},
	{22898, 167336},
	{22914, 167340, 1, 1621},
	{22936, 167344},
	{22952, 167348, 1, 1578},
	{22974, 167352},
	{22996, 167356},
	{23018, 167360},
	{23037, 167368},
	{23052, 167372, 2, 1576},
	{23068, 167376, 1, 1578},
	{23084, 167380, 3, 1579},
	{23099, 167384, 19, 1582},
	{23114, 167388, 8, 1601},
	{23131, 167392, 12, 1609},
	{23153, 167396},
	{23169, 167400, 1, 1621},
	{23191, 167404},
	{23207, 167408, 1, 1578},
	{23229, 167412},
	{23251, 167416},
	{23273, 167420},
	{23292, 167428},
	{23307, 167432, 2, 1576},
	{23323, 167436, 1, 1578},
	{23339, 167440, 3, 1579},
	{23354, 167444, 19, 1582},
	{23369, 167448, 8, 1601},
	{23386, 167452, 12, 1609},
	{23408, 167456},
	{23424, 167460, 1, 1621},
	{23446, 167464},
	{23462, 167468, 1, 1578},
	{23484, 167472},
	{23506, 167476},
	{23528, 167480},
	{23547, 167488, 1, 1622},
	{23566, 167492, 1, 1622},
	{23585, 167496, 1, 1622},
	{23604, 167500, 1, 1622},
	{23623, 167504, 1, 1622},
	{23642, 167508, 1, 1622},
	{23661, 167512, 1, 1622},
	{23680, 167516, 1, 1622},
	{23699, 167520, 1, 1622},
	{23724, 167524, 1, 1622},
	{23749, 167528, 1, 1622},
	{23774, 167532, 1, 1622},
	{23799, 167536, 1, 1622},
	{23824, 167540, 1, 1622},
	{23849, 167544, 1, 1622},
	{23874, 167548, 1, 1622},
	{23899, 167552, 1, 1622},
	{23924, 167556, 1, 1622},
	{23949, 167560, 1, 1622},
	{23974, 167564, 1, 1622},
	{23999, 167568, 1, 1622},
	{24024, 167572, 1, 1622},
	{24049, 167576, 1, 1622},
	{24074, 167580, 1, 1622},
	{24099, 167584, 1, 1622},
	{24122, 167588, 1, 1622},
	{24145, 167592, 1, 1622},
	{24168, 167596, 1, 1622},
	{24191, 167600, 1, 1622},
	{24214, 167604, 1, 1622},
	{24237, 167608, 1, 1622},
	{24260, 167612, 1, 1622},
	{24283, 167616, 3, 1623},
	{24301, 167620, 3, 1623},
	{24319, 167624, 3, 1623},
	{24337, 167628, 3, 1623},
	{24355, 167632, 3, 1623},
	{24373, 167636, 3, 1623},
	{24391, 167640, 3, 1623},
	{24409, 167644, 3, 1623},
	{24427, 167648, 8, 1626},
	{24445, 167652, 8, 1626},
	{24463, 167656, 8, 1626},
	{24481, 167660, 8, 1626},
	{24499, 167664, 8, 1626},
	{24517, 167668, 8, 1626},
	{24535, 167672, 8, 1626},
	{24553, 167676, 8, 1626},
	{24571, 196608, 1, 1634},
	{24591, 196612, 1, 1635},
	{24611, 196616},
	{24631, 196620},
	{24651, 196624},
	{24672, 196628},
	{24693, 196632, 1, 1636},
	{24715, 196636, 1, 1637},
	{24737, 196640},
	{24767, 196644},
	{24797, 196648},
	{24826, 196652},
	{24855, 196656},
	{24885, 196660},
	{24915, 196664},
	{24944, 196668},
	{24973, 196672},
	{25003, 196676},
	{25033, 196680},
	{25062, 196684},
	{25091, 196688},
	{25121, 196692},
	{25151, 196696},
	{25180, 196700},
	{25209, 196704, 1, 1638},
	{25231, 196708, 1, 1639},
	{25253, 196712},
	{25276, 196716},
	{25299, 196720},
	{25322, 196724},
	{25345, 196728},
	{25368, 196732},
	{25391, 196736},
	{25415, 196740},
	{25439, 196744},
	{25463, 196748},
	{25487, 196752},
	{25511, 196756},
	{25535, 196760},
	{25559, 196764},
	{25583, 196768},
	{25605, 196772},
	{25627, 196776},
	{25648, 196780},
	{25669, 196784},
	{25693, 196788},
	{25717, 196792},
	{25741, 196796},
	{25765, 196800},
	{25789, 196804},
	{25813, 196808, 1, 1640},
	{25834, 196812, 1, 1640},
	{25857, 196816, 1, 1640},
	{25873, 196852, 1, 1641},
	{25895, 196856, 1, 1641},
	{25917, 196860, 1, 1642},
	{25933, 196864},
	{25946, 196868},
	{25959, 196872},
	{25972, 196876},
	{25985, 196880},
	{25998, 196884},
	{26011, 196888},
	{26024, 196892},
	{26037, 196896, 1, 1640},
	{26060, 196908, 1, 670},
	{26079, 196912},
	{26097, 196916},
	{26124, 196920},
	{26151, 196928, 2, 1643},
	{26164, 196932},
	{26177, 196936},
	{26200, 196940},
	{26223, 196944},
	{26251, 196948},
	{26279, 196952},
	{26307, 196956},
	{26335, 196960, 1, 1645},
	{26353, 196964, 4, 1646},
	{26371, 196968},
	{26386, 196972},
	{26410, 196976},
	{26434, 196980},
	{26453, 196984},
	{26472, 196988},
	{26496, 196992},
	{26520, 196996},
	{26544, 197000},
	{26568, 197028, 1, 1650},
	{26586, 197032, 2, 1651},
	{26604, 197036},
	{26622, 197040},
	{26640, 197044, 1, 1653},
	{26658, 197048, 2, 1654},
	{26676, 197052},
	{26694, 197056, 2, 1656},
	{26713, 197060, 5, 1658},
	{26732, 197072},
	{26756, 197076, 2, 1656},
	{26776, 197080, 5, 1658},
	{26796, 197084, 7, 1663},
	{26815, 197088, 7, 1663},
	{26833, 197092, 1, 1670},
	{26850, 197100, 1, 1671},
	{26871, 197104, 13, 1672},
	{26885, 197108},
	{26899, 197112},
	{26913, 197116, 2, 1685},
	{26929, 197120},
	{26948, 197124, 1, 1687},
	{26970, 197128},
	{26989, 197132, 1, 1688},
	{27011, 197136, 7, 1689},
	{27029, 197140},
	{27049, 197144, 1, 1687},
	{27072, 197148},
	{27092, 197152, 1, 1688},
	{27115, 197156, 7, 1689},
	{27134, 197160, 7, 1696},
	{27146, 197164, 2, 1703},
	{27163, 197168, 1, 1705},
	{27180, 197172, 1, 1706},
	{27198, 197176, 4, 1707},
	{27218, 197180, 2, 1711},
	{27235, 197184},
	{27251, 197188, 1, 1713},
	{27264, 197192, 1, 1714},
	{27278, 197196, 1, 1715},
	{27292, 197200, 1, 1716},
	{27314, 197204, 1, 1717},
	{27334, 197208, 1, 1718},
	{27356, 197212, 1, 1719},
	{27376, 197216, 1, 1714},
	{27393, 197220, 1, 1715},
	{27410, 197224},
	{27424, 197232, 2, 1720},
	{27446, 197236, 2, 1722},
	{27468, 197240, 2, 1720},
	{27491, 197244, 2, 1722},
	{27514, 197248, 2, 1720},
	{27536, 197252, 2, 1722},
	{27558, 197364, 1, 1724},
	{27579, 197368, 1, 1725},
	{27599, 197372, 1, 1726},
	{27619, 197376, 1, 1725},
	{27636, 197380, 1, 1726},
	{27653, 197384, 1, 1727},
	{27669, 197388, 1, 1728},
	{27688, 197392, 1, 1729},
	{27707, 197396, 1, 1730},
	{27724, 197400, 1, 1731},
	{27742, 197404, 1, 1732},
	{27760, 197408, 1, 1733},
	{27776, 197412, 1, 1734},
	{27794, 197416, 1, 1735},
	{27812, 197420, 1, 1736},
	{27828, 197424, 1, 1731},
	{27843, 197428, 1, 1732},
	{27858, 197432, 1, 1733},
	{27871, 197436, 1, 1734},
	{27886, 197440, 1, 1735},
	{27901, 197444, 1, 1736},
	{27914, 197448, 1, 1737},
	{27928, 197452, 1, 1738},
	{27942, 197456, 1, 1739},
	{27954, 197460, 4, 1740},
	{27977, 197464, 3, 1744},
	{27999, 197468, 1, 1747},
	{28019, 197472, 1, 1748},
	{28033, 197476, 1, 1749},
	{28047, 197480, 1, 1750},
	{28059, 197484, 1, 1751},
	{28075, 197488, 1, 1748},
	{28092, 197492, 1, 1749},
	{28109, 197496, 1, 1750},
	{28124, 197500, 1, 1751},
	{28143, 197552, 1, 1752},
	{28168, 197556, 1, 1752},
	{28192, 197560, 1, 1753},
	{28212, 197568},
	{28238, 197572, 1, 1635},
	{28267, 197576},
	{28292, 197580, 1, 1635},
	{28320, 197584},
	{28343, 197588, 1, 1635},
	{28369, 197592},
	{28391, 197596, 1, 1635},
	{28416, 197600},
	{28435, 197604, 1, 1635},
	{28457, 197608, 1, 1350},
	{28471, 197612},
	{28488, 197616, 1, 1635},
	{28508, 197620, 8, 1754},
	{28525, 197624, 13, 1762},
	{28542, 197628},
	{28559, 197632, 1, 1705},
	{28579, 197636},
	{28596, 197640, 1, 1670},
	{28616, 197644, 2, 1775},
	{28635, 197888, 8, 1777},
	{28656, 197892, 8, 1777},
	{28677, 198656, 6, 1785},
	{28692, 198912},
	{28711, 198916},
	{28730, 198920, 1, 1791},
	{28749, 198924, 1, 1350},
	{28764, 198928},
	{28797, 198932},
	{28830, 198936},
	{28863, 198940},
	{28896, 198948},
	{28912, 198952},
	{28927, 198956, 2, 1364},
	{28953, 198960},
	{28969, 198964},
	{28987, 198968, 1, 1792},
	{29004, 198972, 2, 1793},
	{29025, 198976},
	{29044, 198980},
	{29063, 198984},
	{29079, 198988, 1, 837},
	{29098, 198992},
	{29118, 198996, 1, 837},
	{29141, 199000},
	{29159, 199004, 1, 837},
	{29180, 199008, 9, 1795},
	{29205, 199012},
	{29221, 199016},
	{29242, 199020, 4, 1804},
	{29250, 199024},
	{29264, 199028},
	{29278, 199032},
	{29292, 199036, 3, 1808},
	{29307, 199040, 2, 1811},
	{29319, 199044, 1, 837},
	{29341, 199048, 3, 1813},
	{29357, 199168, 1, 1816},
	{29382, 199172, 2, 1817},
	{29407, 199184, 2, 1819},
	{29433, 199188, 2, 1819},
	{29459, 199192, 2, 1819},
	{29485, 199212, 2, 1819},
	{29511, 199296, 2, 1821},
	{29539, 199300, 1, 1823},
	{29563, 199304, 1, 1824},
	{29587, 199308, 1, 1825},
	{29620, 199312, 1, 1825},
	{29648, 199328, 2, 1821},
	{29677, 199332, 1, 1823},
	{29702, 199336, 1, 1824},
	{29727, 199340, 1, 1825},
	{29761, 199344, 1, 1825},
	{29790, 199360, 2, 1821},
	{29814, 199364, 1, 1823},
	{29834, 199368, 1, 1824},
	{29854, 199372, 1, 1825},
	{29883, 199376, 1, 1825},
	{29907, 199936},
	{29934, 199940},
	{29961, 199944},
	{29988, 199948},
	{30015, 199952},
	{30042, 199956},
	{30069, 199960},
	{30096, 199964},
	{30123, 199968, 7, 1826},
	{30134, 199972, 2, 1833},
	{30148, 200192},
	{30167, 200196, 1, 847},
	{30189, 200448},
	{30213, 200452, 1, 1835},
	{30236, 200456},
	{30260, 200460, 1, 1835},
	{30283, 200464},
	{30307, 200468, 1, 1835},
	{30330, 200472},
	{30354, 200476, 1, 1835},
	{30377, 200696},
	{30396, 200700, 1, 1835},
	{30414, 200704},
	{30426, 200708},
	{30438, 200712},
	{30456, 200716},
	{30475, 200720},
	{30493, 200724},
	{30505, 200728},
	{30517, 200732},
	{30535, 200736},
	{30553, 200740},
	{30572, 200744, 4, 1836},
	{30586, 200748, 2, 1840},
	{30604, 200752, 2, 1842},
	{30618, 200756, 2, 1844},
	{30632, 200760, 2, 1846},
	{30649, 200764, 2, 1848},
	{30666, 200768},
	{30679, 200772, 2, 1850},
	{30691, 200776},
	{30705, 200780},
	{30721, 200784},
	{30735, 200788},
	{30751, 200792},
	{30766, 200796},
	{30783, 200800},
	{30798, 200804},
	{30815, 200808, 2, 1852},
	{30837, 200812, 10, 1854},
	{30854, 200816, 2, 1864},
	{30875, 200820, 2, 1866},
	{30887, 200824},
	{30902, 200828, 6, 1868},
	{30917, 200832, 2, 1874},
	{30931, 200836},
	{30948, 200960},
	{30970, 200964},
	{30994, 200968},
	{31018, 200972},
	{31044, 212992},
	{31064, 212996},
	{31084, 213000},
	{31104, 213004},
	{31124, 213008},
	{31144, 213012},
	{31164, 213016},
	{31184, 213020},
	{31204, 213024},
	{31224, 213028},
	{31244, 213032},
	{31264, 213036},
	{31284, 213040},
	{31307, 213044},
	{31330, 213048},
	{31353, 213248},
	{31374, 213252},
	{31395, 213260},
	{31416, 213264},
	{31437, 213268},
	{31461, 213272},
	{31485, 213276},
	{31509, 213280},
	{31533, 213284},
	{31557, 213288},
	{31581, 213292},
	{31605, 213296},
	{31629, 213504},
	{31648, 213508},
	{31667, 213512},
	{31686, 213516},
	{31705, 213520},
	{31724, 213524},
	{31743, 213528},
	{31762, 213532},
	{31781, 213536},
	{31800, 213540},
	{31819, 213544},
	{31838, 213548},
	{31857, 213552},
	{31876, 213556},
	{31895, 213560},
	{31914, 213564},
	{31933, 213568},
	{31952, 213572},
	{31971, 213576},
	{31990, 213580},
	{32009, 213584},
	{32029, 213588},
	{32049, 213592},
	{32069, 213596},
	{32089, 214016},
	{32111, 214020, 1, 1876},
	{32133, 214024},
	{32155, 214028, 1, 1876},
	{32177, 214032},
	{32199, 214036, 1, 1876},
	{32221, 214040},
	{32243, 214044, 1, 1876},
	{32265, 214272},
	{32287, 214276},
	{32309, 214280},
	{32331, 214284},
	{32353, 214288},
	{32375, 214292},
	{32397, 214296},
	{32419, 214300},
	{32441, 214304},
	{32463, 214308},
	{32485, 214312},
	{32507, 214316},
	{32529, 214320},
	{32551, 214324},
	{32573, 214328},
	{32595, 214332},
	{32617, 214528},
	{32637, 214532},
	{32657, 214536},
	{32677, 214540},
	{32697, 214544},
	{32717, 214548},
	{32737, 214552},
	{32757, 214556},
	{32777, 214560},
	{32797, 214564},
	{32817, 214568},
	{32837, 214572},
	{32857, 214784},
	{32876, 214788},
	{32895, 214792},
	{32914, 214796},
	{32933, 214800},
	{32952, 214804},
	{32971, 214808},
	{32990, 214812},
	{33009, 214816},
	{33028, 214820},
	{33047, 214824},
	{33066, 214828},
	{33085, 214832},
	{33104, 214836},
	{33123, 214840},
	{33142, 214844},
	{33161, 214848},
	{33180, 214852},
	{33199, 214856},
	{33218, 214860},
	{33237, 214864},
	{33257, 214868},
	{33277, 214872},
	{33297, 214876},
	{33317, 214880},
	{33337, 214884},
	{33357, 214888},
	{33377, 214892},
	{33397, 214896},
	{33417, 214900},
	{33437, 214904},
	{33457, 214908},
	{33477, 215296},
	{33496, 215300},
	{33515, 215304},
	{33534, 215308},
	{33553, 215312},
	{33572, 215316},
	{33591, 215320},
	{33610, 215324},
	{33629, 215424},
	{33650, 215428},
	{33671, 215552},
	{33691, 215556},
	{33711, 215560},
	{33731, 215564},
	{33751, 215568},
	{33771, 215572},
	{33791, 215576},
	{33811, 215580},
	{33831, 215808},
	{33850, 215812},
	{33869, 215816},
	{33888, 215820},
	{33907, 216064},
	{33926, 216068},
	{33945, 216072},
	{33964, 216076},
	{33983, 216320},
	{34003, 216324},
	{34023, 216328},
	{34043, 216332},
	{34063, 216336},
	{34083, 216340},
	{34103, 216344},
	{34123, 216348},
	{34143, 216576},
	{34164, 216580},
	{34185, 216584},
	{34206, 216588},
	{34227, 216592},
	{34248, 216596},
	{34269, 216600},
	{34290, 216604},
	{34311, 216640},
	{34332, 216644},
	{34353, 216648},
	{34374, 216652},
	{34395, 216656},
	{34416, 216660},
	{34437, 216664},
	{34458, 216668},
	{34479, 216704},
	{34500, 216708},
	{34521, 216712},
	{34542, 216716},
	{34563, 216720},
	{34584, 216724},
	{34605, 216728},
	{34626, 216732},
	{34647, 216832},
	{34667, 216836},
	{34687, 216840},
	{34707, 216844},
	{34727, 216848},
	{34747, 216852},
	{34767, 216856},
	{34787, 216860},
	{34807, 216864},
	{34828, 216868},
	{34849, 216872},
	{34870, 216876},
	{34891, 216880},
	{34912, 216884},
	{34933, 216888},
	{34954, 216892},
	{34975, 217112},
	{34994, 217116},
	{35013, 217120},
	{35032, 217124},
	{35051, 217128},
	{35070, 217132},
	{35089, 217136},
	{35108, 217140},
	{35127, 217344},
	{35146, 217348},
	{35165, 217352},
	{35184, 217356},
	{35203, 217360},
	{35222, 217364},
	{35241, 217368},
	{35260, 217372},
	{35279, 217600},
	{35299, 217604},
	{35319, 217608},
	{35339, 217612},
	{35359, 217856},
	{35379, 217860},
	{35399, 217864},
	{35419, 217868},
	{35439, 217872},
	{35459, 217876},
	{35479, 217880},
	{35499, 217884},
	{35519, 217984},
	{35544, 217988, 2, 1877},
	{35569, 218016},
	{35595, 218020, 2, 1877},
	{35621, 218080},
	{35646, 218084},
	{35671, 218088},
	{35696, 218092},
	{35721, 218096},
	{35747, 218100},
	{35773, 218224},
	{35795, 218228},
	{35817, 218232},
	{35839, 218236},
	{35861, 218240},
	{35881, 218244},
	{35901, 218248},
	{35921, 218252},
	{35941, 218624},
	{35963, 218628},
	{35985, 218632},
	{36007, 218636},
	{36029, 218640},
	{36051, 218644},
	{36073, 218648},
	{36095, 218652},
	{36117, 218656},
	{36139, 218660},
	{36161, 218664},
	{36183, 218668},
	{36205, 218672},
	{36227, 218676},
	{36249, 218680},
	{36271, 218684},
	{36293, 218880},
	{36314, 218884},
	{36335, 218888},
	{36356, 218892},
	{36377, 218896},
	{36398, 218900},
	{36419, 218904},
	{36440, 218908},
	{36461, 219136},
	{36481, 219140},
	{36501, 219144},
	{36521, 219148},
	{36541, 219152},
	{36561, 219156},
	{36581, 219160},
	{36601, 219164},
	{36621, 219392},
	{36641, 219396},
	{36661, 221184, 5, 1879},
	{36685, 221188, 4, 1884},
	{36710, 221192, 5, 1879},
	{36734, 221196, 5, 1879},
	{36758, 221200, 4, 1884},
	{36783, 221204, 5, 1879},
	{36807, 221208, 4, 1884},
	{36832, 221212, 5, 1879},
	{36856, 221216, 4, 1888},
	{36872, 221220, 5, 1879},
	{36896, 221224, 3, 1892},
	{36930, 221228, 3, 1895},
	{36964, 221232, 3, 1898},
	{36989, 221236, 3, 1901},
	{37014, 221240, 3, 1898},
	{37039, 221248},
	{37054, 221252, 1, 1825},
	{37077, 221256},
	{37100, 221260},
	{37118, 221264, 2, 1904},
	{37136, 221268, 4, 1906},
	{37156, 221440, 20, 1910},
	{37181, 221444, 20, 1910},
	{37206, 221448, 15, 1930},
	{37234, 221452, 15, 1930},
	{37262, 221456, 15, 1930},
	{37290, 221460, 15, 1930},
	{37318, 221492, 8, 1945},
	{37346, 221496, 8, 1945},
	{37374, 221696, 5, 1953},
	{37397, 221700, 4, 1958},
	{37421, 221704, 5, 1953},
	{37444, 221708, 4, 1958},
	{37468, 221712, 5, 1953},
	{37491, 221716, 4, 1958},
	{37515, 221720, 5, 1953},
	{37538, 221724, 4, 1958},
	{37562, 221728, 2, 1962},
	{37585, 221736, 2, 1962},
	{37608, 221744, 2, 1962},
	{37631, 221752, 2, 1962},
	{37654, 221760, 2, 1962},
	{37677, 221768, 2, 1962},
	{37700, 221776, 2, 1962},
	{37724, 221784, 2, 1962},
	{37748, 222208, 5, 1964},
	{37774, 222212, 4, 1969},
	{37801, 222216, 5, 1964},
	{37827, 222220, 4, 1969},
	{37854, 222224, 5, 1964},
	{37880, 222228, 4, 1969},
	{37907, 222232, 5, 1964},
	{37933, 222236, 4, 1969},
	{37960, 222464, 5, 1964},
	{37986, 222468, 4, 1969},
	{38013, 222472, 1, 1879},
	{38039, 222476, 1, 1879},
	{38065, 222480, 1, 1879},
	{38091, 222484, 1, 1879},
	{38117, 222488, 1, 1879},
	{38143, 222492, 1, 1879},
	{38169, 222496, 1, 1879},
	{38195, 222720, 5, 1964},
	{38219, 222724, 5, 1964},
	{38243, 222728, 5, 1964},
	{38267, 222732, 5, 1964},
	{38291, 222736, 4, 1969},
	{38316, 222740, 4, 1969},
	{38341, 222744, 4, 1969},
	{38366, 222748, 4, 1969},
	{38391, 222752, 1, 1879},
	{38415, 222756, 1, 1879},
	{38439, 222760, 8, 1973},
	{38460, 222976, 4, 1981},
	{38483, 222980, 4, 1981},
	{38506, 222984, 4, 1981},
	{38529, 222988, 4, 1981},
	{38552, 222992, 4, 1981},
	{38575, 222996, 4, 1981},
	{38598, 223000, 4, 1981},
	{38621, 223004, 4, 1981},
	{38644, 223008, 4, 1981},
	{38667, 223012, 4, 1981},
	{38690, 223016, 4, 1981},
	{38714, 223020, 4, 1981},
	{38738, 223024, 4, 1981},
	{38762, 223028, 4, 1981},
	{38786, 223032, 4, 1981},
	{38810, 223036, 4, 1981},
	{38834, 223104, 9, 1985},
	{38854, 223112, 1, 1994},
	{38875, 223232, 5, 1964},
	{38900, 223236, 4, 1969},
	{38926, 223240, 8, 1995},
	{38949, 223488, 3, 2003},
	{38972, 223492, 3, 2003},
	{38995, 223496, 3, 2003},
	{39018, 223500, 3, 2003},
	{39041, 223504, 2, 2006},
	{39065, 223508, 2, 2006},
	{39089, 223744, 5, 1964},
	{39113, 223748, 5, 1964},
	{39137, 223752, 5, 1964},
	{39161, 223756, 5, 1964},
	{39185, 223760, 4, 1969},
	{39210, 224000, 5, 2008},
	{39233, 224004, 4, 2013},
	{39257, 224008, 3, 2017},
	{39280, 224256, 5, 2008},
	{39303, 224260, 4, 2013},
	{39327, 224264, 3, 2017},
	{39350, 224512, 5, 1964},
	{39374, 224516, 4, 1969},
	{39399, 224520, 5, 1964},
	{39423, 224524, 4, 1969},
	{39448, 224528, 3, 2020},
	{39472, 224532, 3, 2020},
	{39496, 224768, 5, 1964},
	{39521, 224772, 4, 1958},
	{39547, 224776, 5, 1964},
	{39572, 224780, 4, 1958},
	{39598, 224784, 3, 2020},
	{39623, 224788, 3, 2020},
	{39648, 224832, 5, 1964},
	{39673, 224836, 4, 1958},
	{39699, 224840, 5, 1964},
	{39724, 224844, 4, 1958},
	{39750, 224848, 3, 2020},
	{39775, 224852, 3, 2020},
	{39800, 224896, 5, 1964},
	{39825, 224900, 4, 1958},
	{39851, 224904, 3, 2020},
	{39876, 224908, 3, 2020},
	{39901, 224912, 3, 2020},
	{39926, 225024, 5, 1964},
	{39950, 225028, 4, 1958},
	{39975, 225032, 3, 2020},
	{39999, 225036, 3, 2020},
	{40023, 225040, 3, 2020},
	{40047, 225048, 5, 1964},
	{40072, 225052, 4, 1958},
	{40098, 225056, 3, 2020},
	{40123, 225060, 3, 2020},
	{40148, 225064, 3, 2020},
	{40173, 225280, 12, 2023},
	{40195, 225284, 5, 2035},
	{40218, 225288, 4, 2040},
	{40242, 225292, 2, 2044},
	{40265, 225296, 2, 2044},
	{40288, 225300, 2, 2044},
	{40311, 225536, 5, 1964},
	{40334, 225540, 4, 1969},
	{40358, 225544, 5, 1964},
	{40381, 225548, 4, 1969},
	{40405, 225552, 5, 1964},
	{40428, 225560, 5, 1964},
	{40451, 225792, 4, 2046},
	{40472, 225796},
	{40501, 225800, 2, 2050},
	{40530, 225804},
	{40556, 225808, 7, 2052},
	{40585, 225812},
	{40604, 225816, 2, 2059},
	{40630, 225820, 2, 2061},
	{40653, 225824},
	{40676, 225828, 2, 2063},
	{40703, 225832},
	{40730, 225836, 2, 2065},
	{40755, 225840, 2, 2067},
	{40783, 225844, 2, 2069},
	{40811, 225848, 2, 2071},
	{40834, 225852, 2, 2073},
	{40857, 225856},
	{40890, 225860, 2, 2075},
	{40923, 225864},
	{40955, 225868, 2, 2075},
	{40987, 225872, 2, 2077},
	{41006, 225876, 2, 2079},
	{41033, 225880},
	{41060, 225884, 2, 2081},
	{41087, 225888, 2, 2083},
	{41114, 225892, 10, 2085},
	{41135, 225896, 8, 2095},
	{41154, 225900, 8, 2103},
	{41173, 225904, 2, 2111},
	{41197, 225908, 2, 2113},
	{41229, 225912, 2, 2115},
	{41259, 225916, 4, 2117},
	{41295, 225920, 3, 2121},
	{41328, 225924, 1, 2124},
	{41346, 225932, 1, 2125},
	{41366, 226048, 2, 2126},
	{41383, 226052, 1, 2128},
	{41407, 226056, 1, 2128},
	{41431, 226060, 4, 2129},
	{41457, 226064, 3, 2133},
	{41486, 226068, 1, 694},
	{41515, 226072, 3, 2133},
	{41544, 226076, 1, 694},
	{41573, 226192, 1, 2136},
	{41594, 226196, 1, 2136},
	{41621, 226304, 5, 2035},
	{41645, 226308, 4, 2040},
	{41670, 226312, 2, 2044},
	{41694, 226316, 5, 2035},
	{41718, 226320, 4, 2040},
	{41743, 226324, 2, 2044},
	{41767, 226328, 10, 2137},
	{41789, 226432, 5, 2147},
	{41816, 226436, 5, 2147},
	{41843, 226440, 6, 2152},
	{41875, 226480, 5, 2147},
	{41903, 226484, 5, 2147},
	{41931, 226488, 5, 2147},
	{41959, 226492, 5, 2147},
	{41987, 226496, 5, 2147},
	{42015, 226500, 5, 2147},
	{42043, 226504, 5, 2147},
	{42071, 226508, 5, 2147},
	{42099, 226512, 6, 2152},
	{42132, 226544, 5, 1964},
	{42161, 226548, 5, 1964},
	{42190, 226552, 4, 1969},
	{42220, 226556, 4, 1969},
	{42250, 226560, 8, 1995},
	{42277, 226564, 8, 1995},
	{42304, 226608, 5, 1964},
	{42334, 226612, 4, 1969},
	{42365, 226616, 8, 1995},
	{42393, 226688, 5, 2035},
	{42417, 226692, 4, 2040},
	{42442, 226696, 3, 2158},
	{42466, 226700, 2, 2161},
	{42492, 226704, 2, 2161},
	{42518, 226816, 5, 1964},
	{42544, 226820, 4, 1969},
	{42571, 226824, 5, 1964},
	{42597, 226828, 5, 1964},
	{42623, 226832, 5, 1964},
	{42649, 226836, 1, 1879},
	{42675, 226840, 1, 1879},
	{42701, 226844, 1, 1879},
	{42727, 226848, 1, 1879},
	{42753, 226880, 4, 1969},
	{42780, 226884, 4, 1969},
	{42807, 226888, 4, 1969},
	{42834, 227072, 5, 1964},
	{42859, 227076, 4, 1958},
	{42885, 227080, 3, 2020},
	{42910, 227084, 3, 2020},
	{42935, 227088, 3, 2020},
	{42960, 227200, 5, 1964},
	{42984, 227204, 4, 1958},
	{43009, 227208, 3, 2020},
	{43033, 227212, 3, 2020},
	{43057, 227216, 3, 2020},
	{43081, 227328, 5, 1964},
	{43105, 227332, 4, 1969},
	{43130, 227336, 8, 1995},
	{206, 880, 4, 2163},
	{43152, 881},
	{26999, 882},
	{43164, 1008},
	{43175, 1009},
	{27187, 1010, 4, 2167},
	{43186, 1040, 1, 2171},
	{43199, 1041, 5, 2172},
	{43212, 1042, 1, 2177},
	{43225, 1043, 1, 1688},
	{27021, 1045, 7, 2178},
	{43238, 1168, 12, 2185},
	{43253, 1281, 6, 2197},
	{43268, 1282},
	{26958, 1283},
	{43152, 1285},
	{26999, 1286},
	{43280, 1414, 15, 2203},
};

static const struct si_reg gfx103_reg_table[] = {
	{43289, 40, 1, 2218},
	{43304, 44, 1, 2218},
	{1310, 1028, 8, 0},
	{1323, 1032, 20, 10},
	{1338, 1036, 10, 2219},
	{1354, 1040, 12, 40},
	{1375, 1044, 4, 52},
	{1393, 1048, 3, 56},
	{1411, 1052, 8, 2229},
	{1426, 1056},
	{1440, 1060, 1, 70},
	{1454, 1064},
	{1471, 1076, 2, 78},
	{1487, 1080},
	{1882, 1104},
	{1906, 1108},
	{1504, 1116, 5, 80},
	{1519, 1120, 6, 85},
	{1534, 1124, 2, 92},
	{1554, 1128, 1, 94},
	{1573, 1132, 4, 95},
	{1593, 1136, 5, 99},
	{43327, 1140, 1, 2237},
	{1609, 2480},
	{1623, 2484},
	{1637, 2488},
	{1651, 2492},
	{1665, 2496},
	{1679, 2500},
	{1693, 2504},
	{1707, 2508},
	{1721, 2512},
	{1735, 2516},
	{1749, 2520},
	{1764, 2524},
	{1779, 2528},
	{1794, 2532},
	{1809, 2536},
	{1824, 2540},
	{1839, 2544},
	{1850, 2552},
	{1866, 2556},
	{1954, 32776, 29, 2238},
	{1967, 32784, 20, 2267},
	{1979, 32788, 14, 154},
	{1995, 32792, 14, 154},
	{2011, 32796, 15, 168},
	{2024, 32824, 14, 154},
	{2040, 32828, 14, 154},
	{2056, 33296, 21, 183},
	{2070, 33300, 28, 204},
	{2087, 33304, 15, 232},
	{2108, 33308, 28, 247},
	{2122, 33312, 32, 275},
	{2139, 33316, 13, 307},
	{2160, 33320, 9, 320},
	{2178, 33324, 1, 329},
	{43349, 33328, 1, 2287},
	{2201, 33344, 2, 330},
	{2222, 33348},
	{2242, 33352, 1, 332},
	{2265, 33356, 9, 333},
	{2283, 33436, 1, 342},
	{2306, 36096},
	{2332, 36100, 2, 343},
	{2358, 36104},
	{2384, 36108, 2, 343},
	{2410, 36112, 2, 345},
	{2431, 36116, 4, 347},
	{2452, 36120, 6, 2288},
	{2479, 36124, 20, 2294},
	{2500, 36128, 7, 2314},
	{2523, 36132},
	{2552, 36140},
	{2582, 36144},
	{2614, 36148},
	{2645, 36152},
	{43376, 36156, 3, 2321},
	{2678, 36348, 5, 378},
	{2687, 36608},
	{2705, 36612, 4, 383},
	{2723, 36616},
	{2741, 36620, 11, 2324},
	{2759, 36656, 14, 397},
	{2777, 36660, 4, 411},
	{2795, 36664, 9, 415},
	{2813, 36668, 2, 424},
	{2831, 37168, 9, 2335},
	{2847, 39160, 6, 2344},
	{3642, 40960},
	{3660, 40964, 4, 449},
	{3678, 40968, 3, 453},
	{3696, 40972, 9, 456},
	{3714, 40976, 3, 2350},
	{3732, 40980, 8, 2353},
	{3750, 40984, 11, 2361},
	{3768, 40988},
	{3786, 41120, 10, 484},
	{3818, 45060, 1, 494},
	{3842, 45080},
	{3867, 45084, 3, 495},
	{3891, 45088},
	{3912, 45092, 1, 498},
	{3933, 45096, 12, 2372},
	{3957, 45100, 10, 510},
	{3981, 45104},
	{4007, 45108},
	{4033, 45112},
	{4059, 45116},
	{4085, 45120},
	{4111, 45124},
	{4137, 45128},
	{4163, 45132},
	{4189, 45136},
	{4215, 45140},
	{4241, 45144},
	{4268, 45148},
	{4295, 45152},
	{4322, 45156},
	{4349, 45160},
	{4376, 45164},
	{4403, 45168},
	{4430, 45172},
	{4457, 45176},
	{4484, 45180},
	{4511, 45184},
	{4538, 45188},
	{4565, 45192},
	{4592, 45196},
	{4619, 45200},
	{4646, 45204},
	{4673, 45208},
	{4700, 45212},
	{4727, 45216},
	{4754, 45220},
	{4781, 45224},
	{4808, 45228},
	{4835, 45248, 8, 520},
	{4891, 45256, 1, 533},
	{4918, 45260, 1, 533},
	{4945, 45264, 1, 533},
	{4972, 45268, 1, 533},
	{4999, 45316, 1, 494},
	{5023, 45332},
	{5048, 45336, 3, 495},
	{5072, 45340, 1, 534},
	{5097, 45344},
	{5118, 45348, 1, 498},
	{5139, 45352, 12, 535},
	{5163, 45356, 14, 547},
	{5187, 45360},
	{5213, 45364},
	{5239, 45368},
	{5265, 45372},
	{5291, 45376},
	{5317, 45380},
	{5343, 45384},
	{5369, 45388},
	{5395, 45392},
	{5421, 45396},
	{5447, 45400},
	{5474, 45404},
	{5501, 45408},
	{5528, 45412},
	{5555, 45416},
	{5582, 45420},
	{5609, 45424},
	{5636, 45428},
	{5663, 45432},
	{5690, 45436},
	{5717, 45440},
	{5744, 45444},
	{5771, 45448},
	{5798, 45452},
	{5825, 45456},
	{5852, 45460},
	{5879, 45464},
	{5906, 45468},
	{5933, 45472},
	{5960, 45476},
	{5987, 45480},
	{6014, 45484},
	{6041, 45504, 8, 520},
	{6097, 45512, 1, 533},
	{6124, 45516, 1, 533},
	{6151, 45520, 1, 533},
	{6178, 45524, 1, 533},
	{6205, 45548, 9, 561},
	{6286, 45568},
	{6311, 45572, 2, 581},
	{6335, 45576},
	{6367, 45580},
	{6399, 45584},
	{6423, 45588, 1, 498},
	{6447, 45596, 4, 583},
	{6471, 45600},
	{6492, 45604, 1, 498},
	{6513, 45608, 13, 587},
	{6537, 45612, 9, 600},
	{6561, 45616},
	{6587, 45620},
	{6613, 45624},
	{6639, 45628},
	{6665, 45632},
	{6691, 45636},
	{6717, 45640},
	{6743, 45644},
	{6769, 45648},
	{6795, 45652},
	{6821, 45656},
	{6848, 45660},
	{6875, 45664},
	{6902, 45668},
	{6929, 45672},
	{6956, 45676},
	{6983, 45680},
	{7010, 45684},
	{7037, 45688},
	{7064, 45692},
	{7091, 45696},
	{7118, 45700},
	{7145, 45704},
	{7172, 45708},
	{7199, 45712},
	{7226, 45716},
	{7253, 45720},
	{7280, 45724},
	{7307, 45728},
	{7334, 45732},
	{7361, 45736},
	{7388, 45740},
	{7415, 45760, 8, 520},
	{7475, 45768, 1, 533},
	{7504, 45772, 1, 533},
	{7533, 45776, 1, 533},
	{7562, 45780, 1, 533},
	{7642, 45856},
	{7663, 45860, 1, 498},
	{8181, 46080},
	{8206, 46084, 1, 494},
	{8230, 46088},
	{8262, 46092},
	{8294, 46096},
	{8318, 46100, 1, 498},
	{8342, 46108, 4, 619},
	{8366, 46112},
	{8387, 46116, 1, 498},
	{8408, 46120, 12, 623},
	{8432, 46124, 9, 635},
	{8456, 46128},
	{8482, 46132},
	{8508, 46136},
	{8534, 46140},
	{8560, 46144},
	{8586, 46148},
	{8612, 46152},
	{8638, 46156},
	{8664, 46160},
	{8690, 46164},
	{8716, 46168},
	{8743, 46172},
	{8770, 46176},
	{8797, 46180},
	{8824, 46184},
	{8851, 46188},
	{8878, 46192},
	{8905, 46196},
	{8932, 46200},
	{8959, 46204},
	{8986, 46208},
	{9013, 46212},
	{9040, 46216},
	{9067, 46220},
	{9094, 46224},
	{9121, 46228},
	{9148, 46232},
	{9175, 46236},
	{9202, 46240},
	{9229, 46244},
	{9256, 46248},
	{9283, 46252},
	{9310, 46272, 8, 520},
	{9370, 46280, 1, 533},
	{9399, 46284, 1, 533},
	{9428, 46288, 1, 533},
	{9457, 46292, 1, 533},
	{9537, 46368},
	{9558, 46372, 1, 498},
	{10049, 47104, 13, 653},
	{10076, 47108},
	{10090, 47112},
	{10104, 47116},
	{10118, 47120},
	{10134, 47124},
	{10150, 47128},
	{10166, 47132, 2, 666},
	{10187, 47136, 2, 666},
	{10208, 47140, 2, 666},
	{10229, 47144, 1, 668},
	{10257, 47148, 1, 669},
	{10282, 47152},
	{10297, 47156, 1, 670},
	{10312, 47160},
	{10341, 47164, 1, 670},
	{10370, 47168},
	{10403, 47172, 1, 670},
	{10436, 47176, 12, 671},
	{10454, 47180, 11, 683},
	{10472, 47184, 1, 694},
	{10485, 47188, 6, 695},
	{10509, 47192},
	{10536, 47196},
	{10563, 47200, 2, 701},
	{10584, 47204},
	{10611, 47208},
	{10638, 47212},
	{10656, 47216},
	{10674, 47220},
	{10692, 47224, 1, 703},
	{10720, 47228, 5, 704},
	{10742, 47232},
	{10762, 47236},
	{10785, 47240, 9, 709},
	{10802, 47248, 1, 533},
	{10823, 47252, 1, 533},
	{10844, 47256, 1, 533},
	{10865, 47260, 1, 533},
	{10886, 47264, 1, 718},
	{10904, 47268, 1, 719},
	{10923, 47272},
	{10945, 47276, 3, 720},
	{10962, 47280},
	{10991, 47284, 1, 723},
	{11020, 47288, 3, 720},
	{11038, 47360},
	{11058, 47364},
	{11078, 47368},
	{11098, 47372},
	{11118, 47376},
	{11138, 47380},
	{11158, 47384},
	{11178, 47388},
	{11198, 47392},
	{11218, 47396},
	{11238, 47400},
	{11259, 47404},
	{11280, 47408},
	{11301, 47412},
	{11322, 47416},
	{11343, 47420},
	{11364, 47604, 2, 724},
	{11388, 47608},
	{11409, 47612},
	{11425, 163840, 11, 2384},
	{11443, 163844, 11, 736},
	{11460, 163848, 7, 747},
	{11474, 163852, 23, 754},
	{11493, 163856, 18, 2395},
	{11513, 163860},
	{11532, 163868, 2, 793},
	{11549, 163872},
	{11569, 163876},
	{11589, 163880, 1, 795},
	{11606, 163884},
	{11621, 163888, 2, 796},
	{11645, 163892, 2, 798},
	{11669, 163896, 3, 800},
	{11685, 163900, 8, 803},
	{11703, 163904, 14, 811},
	{11713, 163908, 9, 825},
	{11729, 163912},
	{11744, 163916},
	{11765, 163920},
	{11781, 163924},
	{11803, 163928, 2, 834},
	{11821, 163932, 1, 836},
	{43400, 163940, 3, 2413},
	{11839, 163944, 1, 837},
	{11857, 163948, 1, 837},
	{11881, 163952, 1, 837},
	{11900, 163956, 1, 837},
	{11925, 163960, 1, 837},
	{11947, 163964, 13, 2416},
	{11971, 163968},
	{11987, 163972, 1, 847},
	{12006, 164328, 1, 848},
	{12027, 164332, 1, 848},
	{12048, 164336, 1, 848},
	{12069, 164340, 1, 848},
	{12090, 164344},
	{12108, 164348},
	{12126, 164352, 2, 849},
	{12146, 164356, 3, 851},
	{12170, 164360, 2, 854},
	{12194, 164364, 1, 856},
	{12214, 164368, 2, 851},
	{12234, 164372, 2, 854},
	{12254, 164376, 2, 851},
	{12274, 164380, 2, 854},
	{12294, 164384, 2, 851},
	{12314, 164388, 2, 854},
	{12334, 164392, 2, 851},
	{12354, 164396, 2, 854},
	{12374, 164400, 7, 857},
	{12389, 164404, 2, 864},
	{12418, 164408, 8, 866},
	{12433, 164412, 8, 874},
	{12448, 164416, 3, 851},
	{12473, 164420, 2, 854},
	{12498, 164424},
	{12516, 164428},
	{12534, 164432, 3, 851},
	{12559, 164436, 2, 854},
	{12584, 164440, 3, 851},
	{12609, 164444, 2, 854},
	{12634, 164448, 3, 851},
	{12659, 164452, 2, 854},
	{12684, 164456, 3, 851},
	{12709, 164460, 2, 854},
	{12734, 164464, 3, 851},
	{12759, 164468, 2, 854},
	{12784, 164472, 3, 851},
	{12809, 164476, 2, 854},
	{12834, 164480, 3, 851},
	{12859, 164484, 2, 854},
	{12884, 164488, 3, 851},
	{12909, 164492, 2, 854},
	{12934, 164496, 3, 851},
	{12959, 164500, 2, 854},
	{12984, 164504, 3, 851},
	{13009, 164508, 2, 854},
	{13034, 164512, 3, 851},
	{13060, 164516, 2, 854},
	{13086, 164520, 3, 851},
	{13112, 164524, 2, 854},
	{13138, 164528, 3, 851},
	{13164, 164532, 2, 854},
	{13190, 164536, 3, 851},
	{13216, 164540, 2, 854},
	{13242, 164544, 3, 851},
	{13268, 164548, 2, 854},
	{13294, 164552, 3, 851},
	{13320, 164556, 2, 854},
	{13346, 164560},
	{13365, 164564},
	{13384, 164568},
	{13403, 164572},
	{13422, 164576},
	{13441, 164580},
	{13460, 164584},
	{13479, 164588},
	{13498, 164592},
	{13517, 164596},
	{13536, 164600},
	{13555, 164604},
	{13574, 164608},
	{13593, 164612},
	{13612, 164616},
	{13631, 164620},
	{13650, 164624},
	{13669, 164628},
	{13688, 164632},
	{13707, 164636},
	{13726, 164640},
	{13746, 164644},
	{13766, 164648},
	{13786, 164652},
	{13806, 164656},
	{13826, 164660},
	{13846, 164664},
	{13866, 164668},
	{13886, 164672},
	{13906, 164676},
	{13926, 164680},
	{13946, 164684},
	{13966, 164688, 15, 882},
	{13986, 164692, 3, 897},
	{14008, 164696, 2, 900},
	{14036, 164700, 6, 2429},
	{14065, 164704, 1, 909},
	{14086, 164708, 1, 910},
	{14096, 164712, 1, 911},
	{43421, 164716},
	{43443, 164720},
	{14164, 164864},
	{14181, 164868},
	{14198, 164872},
	{14214, 164876},
	{14243, 164880, 14, 2435},
	{14268, 164884},
	{14281, 164888},
	{14296, 164892},
	{14310, 164896},
	{14325, 164900, 8, 930},
	{14340, 164904, 4, 938},
	{14364, 164908, 6, 942},
	{14383, 164912, 4, 948},
	{14401, 164916, 4, 952},
	{14422, 164924},
	{14441, 164928},
	{14461, 164932},
	{14480, 164936},
	{14500, 164940},
	{14519, 164944},
	{14539, 164948},
	{14560, 164952},
	{14582, 164956},
	{14603, 164960},
	{14625, 164964},
	{14646, 164968},
	{14668, 164972},
	{14689, 164976},
	{14711, 164980},
	{14732, 164984},
	{14754, 164988},
	{14775, 164992},
	{14797, 164996},
	{14818, 165000},
	{14840, 165004},
	{14861, 165008},
	{14883, 165012},
	{14904, 165016},
	{14926, 165020},
	{14947, 165024},
	{14969, 165028},
	{14990, 165032},
	{15012, 165036},
	{15033, 165040},
	{15055, 165044},
	{15076, 165048},
	{15098, 165052},
	{15119, 165056},
	{15141, 165060},
	{15162, 165064},
	{15184, 165068},
	{15205, 165072},
	{15227, 165076},
	{15248, 165080},
	{15270, 165084},
	{15291, 165088},
	{15313, 165092},
	{15334, 165096},
	{15356, 165100},
	{15377, 165104},
	{15399, 165108},
	{15420, 165112},
	{15442, 165116},
	{15463, 165120},
	{15485, 165124},
	{15506, 165128},
	{15528, 165132},
	{15549, 165136},
	{15571, 165140},
	{15592, 165144},
	{15614, 165148},
	{15635, 165152},
	{15657, 165156},
	{15678, 165160},
	{15700, 165164},
	{15722, 165168},
	{15745, 165172},
	{15767, 165176},
	{15790, 165180},
	{15812, 165184},
	{15835, 165188},
	{15857, 165192},
	{15880, 165196},
	{15902, 165200},
	{15925, 165204},
	{15947, 165208},
	{15970, 165212},
	{15992, 165216},
	{16015, 165220},
	{16037, 165224},
	{16060, 165228},
	{16082, 165232},
	{16105, 165236},
	{16127, 165240},
	{16150, 165244},
	{16172, 165248},
	{16195, 165252},
	{16217, 165256},
	{16240, 165260},
	{16262, 165264},
	{16285, 165268},
	{16307, 165272},
	{16330, 165276},
	{16352, 165280},
	{16375, 165284},
	{16397, 165288},
	{16420, 165292},
	{16442, 165296},
	{16465, 165300},
	{16487, 165304},
	{16510, 165308},
	{16524, 165312},
	{16538, 165316},
	{16552, 165320},
	{16566, 165324},
	{16580, 165328},
	{16594, 165332},
	{16608, 165336},
	{16622, 165340},
	{16636, 165344},
	{16650, 165348},
	{16664, 165352},
	{16678, 165356},
	{16692, 165360},
	{16706, 165364},
	{16720, 165368},
	{16734, 165372},
	{16748, 165376},
	{16762, 165380},
	{16776, 165384},
	{16790, 165388},
	{16804, 165392},
	{16818, 165396},
	{16832, 165400},
	{16846, 165404},
	{16869, 165444, 13, 2449},
	{16889, 165448, 13, 2449},
	{16909, 165452, 13, 2449},
	{16929, 165456, 13, 2449},
	{16949, 165460, 13, 2449},
	{16969, 165464, 13, 2449},
	{16989, 165468, 13, 2449},
	{17009, 165472, 13, 2449},
	{17029, 165476, 13, 2449},
	{17049, 165480, 13, 2449},
	{17069, 165484, 13, 2449},
	{17090, 165488, 13, 2449},
	{17111, 165492, 13, 2449},
	{17132, 165496, 13, 2449},
	{17153, 165500, 13, 2449},
	{17174, 165504, 13, 2449},
	{17195, 165508, 13, 2449},
	{17216, 165512, 13, 2449},
	{17237, 165516, 13, 2449},
	{17258, 165520, 13, 2449},
	{17279, 165524, 10, 2462},
	{17300, 165528, 10, 2462},
	{17321, 165532, 10, 2462},
	{17342, 165536, 10, 2462},
	{17363, 165540, 10, 2462},
	{17384, 165544, 10, 2462},
	{17405, 165548, 10, 2462},
	{17426, 165552, 10, 2462},
	{17447, 165556, 10, 2462},
	{17468, 165560, 10, 2462},
	{17489, 165564, 10, 2462},
	{17510, 165568, 10, 2462},
	{17531, 165572, 4, 2472},
	{17549, 165580, 16, 980},
	{17566, 165584, 16, 980},
	{17584, 165588, 7, 996},
	{17605, 165592, 6, 2476},
	{17623, 165600, 7, 1009},
	{17638, 165608, 2, 701},
	{17655, 165640, 1, 1016},
	{17677, 165644, 5, 1017},
	{17699, 165648, 1, 1022},
	{17719, 165652, 8, 1023},
	{43465, 165712, 8, 2482},
	{17741, 165716, 8, 2490},
	{17759, 165720, 8, 1039},
	{17780, 165724, 17, 1047},
	{17801, 165728, 6, 1064},
	{17819, 165732, 6, 1064},
	{17837, 165736, 6, 1064},
	{17855, 165740, 6, 1064},
	{17873, 165744, 6, 1064},
	{17891, 165748, 6, 1064},
	{17909, 165752, 6, 1064},
	{17927, 165756, 6, 1064},
	{17945, 165760, 9, 1070},
	{17963, 165764, 9, 1070},
	{17981, 165768, 9, 1070},
	{17999, 165772, 9, 1070},
	{18017, 165776, 9, 1070},
	{18035, 165780, 9, 1070},
	{18053, 165784, 9, 1070},
	{18071, 165788, 9, 1070},
	{18089, 165836, 1, 1079},
	{18103, 165840, 1, 1079},
	{18118, 165844},
	{18136, 165848},
	{18154, 165852},
	{18171, 165856},
	{18192, 165860, 1, 1080},
	{18208, 165864},
	{18221, 165872, 6, 2498},
	{18240, 165876},
	{18255, 165880, 1, 1089},
	{18277, 165884, 1, 1090},
	{18304, 165888, 10, 1091},
	{18321, 165892, 12, 1101},
	{18329, 165896, 5, 2504},
	{18346, 165900, 17, 1117},
	{18364, 165904, 20, 1134},
	{18380, 165908, 16, 1154},
	{18399, 165912, 10, 1170},
	{18414, 165916, 30, 2509},
	{18432, 165920, 16, 1208},
	{18450, 165924, 4, 1224},
	{18474, 165928},
	{18499, 165932, 11, 1228},
	{18522, 165936, 5, 1239},
	{18573, 165944, 3, 2539},
	{18588, 165948, 5, 1250},
	{18618, 165952, 5, 1255},
	{18633, 165956},
	{43491, 165960, 6, 2542},
	{18651, 166400, 2, 1260},
	{18668, 166404, 2, 1262},
	{18687, 166408, 1, 1264},
	{18703, 166412, 4, 1265},
	{18722, 166416, 1, 1269},
	{18743, 166420, 1, 1270},
	{18756, 166424},
	{18779, 166428},
	{18802, 166432, 1, 1271},
	{18822, 166436, 4, 1272},
	{18842, 166440, 1, 1276},
	{18863, 166444, 1, 1277},
	{18878, 166448, 6, 1278},
	{18900, 166452, 6, 1278},
	{18922, 166456, 8, 1284},
	{18948, 166460, 8, 1284},
	{18974, 166464, 15, 1292},
	{18986, 166468, 3, 1307},
	{19005, 166472, 6, 2548},
	{19023, 166476, 24, 1317},
	{19041, 166480},
	{19053, 166484, 1, 1341},
	{19067, 166488, 1, 1342},
	{19081, 166492, 1, 1343},
	{19095, 166496, 1, 1344},
	{19118, 166500, 1, 1344},
	{19141, 166504, 1, 1344},
	{19164, 166508, 5, 1345},
	{19185, 166512},
	{19196, 166516},
	{19209, 166520},
	{19226, 166524, 9, 2554},
	{19245, 166528},
	{19256, 166532, 3, 1358},
	{19275, 166536},
	{19297, 166540},
	{19319, 166544, 3, 1361},
	{19339, 166548, 2, 1364},
	{19366, 166552, 4, 2563},
	{19388, 166560},
	{19413, 166564},
	{19438, 166568, 6, 1371},
	{19457, 166572, 1, 1377},
	{19480, 166576, 1, 1377},
	{19503, 166580, 1, 1378},
	{19517, 166584, 1, 1379},
	{19532, 166588, 10, 2567},
	{19549, 166592, 4, 1389},
	{19576, 166596, 4, 1393},
	{19603, 166600, 4, 1397},
	{19622, 166608},
	{19648, 166612, 1, 1401},
	{19673, 166620},
	{19701, 166624},
	{19727, 166628, 1, 1401},
	{19752, 166636},
	{19780, 166640},
	{19806, 166644, 1, 1401},
	{19831, 166652},
	{19859, 166656},
	{19885, 166660, 1, 1401},
	{19910, 166668},
	{19938, 166696},
	{19969, 166700},
	{20012, 166704, 1, 1402},
	{20050, 166712, 1, 1403},
	{20070, 166732, 2, 1404},
	{20089, 166736, 5, 1406},
	{20111, 166740, 20, 2577},
	{20132, 166744, 3, 1430},
	{20149, 166748, 1, 1377},
	{20170, 166752, 1, 1377},
	{20193, 166756, 1, 1377},
	{20216, 166760, 1, 1377},
	{20239, 166764, 12, 1433},
	{20252, 166768, 6, 1445},
	{20269, 166772},
	{20293, 166776, 2, 1451},
	{20323, 166780},
	{20347, 166784},
	{20377, 166788},
	{20408, 166792},
	{20437, 166796},
	{20467, 166800, 3, 1453},
	{20487, 166804, 8, 1456},
	{20506, 166808, 4, 1464},
	{20532, 166812, 3, 1361},
	{20556, 166868, 8, 1468},
	{20582, 166872, 8, 1476},
	{20608, 166876, 5, 1484},
	{20624, 166880, 8, 2597},
	{20640, 166884, 3, 1495},
	{20655, 166888},
	{20678, 166892},
	{20701, 166896},
	{20724, 166900},
	{20747, 166904, 8, 1498},
	{20781, 166908, 8, 1506},
	{20815, 166912, 8, 1514},
	{20849, 166916, 8, 1522},
	{20883, 166920, 8, 1498},
	{20917, 166924, 8, 1506},
	{20951, 166928, 8, 1514},
	{20985, 166932, 8, 1522},
	{21019, 166936, 8, 1498},
	{21053, 166940, 8, 1506},
	{21087, 166944, 8, 1514},
	{21121, 166948, 8, 1522},
	{21155, 166952, 8, 1498},
	{21189, 166956, 8, 1506},
	{21223, 166960, 8, 1514},
	{21257, 166964, 8, 1522},
	{21291, 166968, 2, 1530},
	{21315, 166972, 2, 1532},
	{21339, 166976, 4, 1534},
	{21360, 166980, 12, 1538},
	{21380, 166984, 2, 1550},
	{21400, 166988, 20, 1552},
	{21438, 166992, 2, 1572},
	{21458, 167000, 1, 1574},
	{21486, 167004, 1, 1575},
	{21507, 167008},
	{21522, 167012, 2, 1576},
	{21538, 167016, 1, 1578},
	{21554, 167020, 3, 1579},
	{21569, 167024, 19, 2605},
	{21584, 167028, 8, 1601},
	{21601, 167032, 14, 2624},
	{21623, 167036},
	{21639, 167040, 1, 1621},
	{21661, 167044},
	{21677, 167048, 1, 1578},
	{21699, 167052},
	{21721, 167056},
	{21743, 167060},
	{21762, 167068},
	{21777, 167072, 2, 1576},
	{21793, 167076, 1, 1578},
	{21809, 167080, 3, 1579},
	{21824, 167084, 19, 2605},
	{21839, 167088, 8, 1601},
	{21856, 167092, 14, 2624},
	{21878, 167096},
	{21894, 167100, 1, 1621},
	{21916, 167104},
	{21932, 167108, 1, 1578},
	{21954, 167112},
	{21976, 167116},
	{21998, 167120},
	{22017, 167128},
	{22032, 167132, 2, 1576},
	{22048, 167136, 1, 1578},
	{22064, 167140, 3, 1579},
	{22079, 167144, 19, 2605},
	{22094, 167148, 8, 1601},
	{22111, 167152, 14, 2624},
	{22133, 167156},
	{22149, 167160, 1, 1621},
	{22171, 167164},
	{22187, 167168, 1, 1578},
	{22209, 167172},
	{22231, 167176},
	{22253, 167180},
	{22272, 167188},
	{22287, 167192, 2, 1576},
	{22303, 167196, 1, 1578},
	{22319, 167200, 3, 1579},
	{22334, 167204, 19, 2605},
	{22349, 167208, 8, 1601},
	{22366, 167212, 14, 2624},
	{22388, 167216},
	{22404, 167220, 1, 1621},
	{22426, 167224},
	{22442, 167228, 1, 1578},
	{22464, 167232},
	{22486, 167236},
	{22508, 167240},
	{22527, 167248},
	{22542, 167252, 2, 1576},
	{22558, 167256, 1, 1578},
	{22574, 167260, 3, 1579},
	{22589, 167264, 19, 2605},
	{22604, 167268, 8, 1601},
	{22621, 167272, 14, 2624},
	{22643, 167276},
	{22659, 167280, 1, 1621},
	{22681, 167284},
	{22697, 167288, 1, 1578},
	{22719, 167292},
	{22741, 167296},
	{22763, 167300},
	{22782, 167308},
	{22797, 167312, 2, 1576},
	{22813, 167316, 1, 1578},
	{22829, 167320, 3, 1579},
	{22844, 167324, 19, 2605},
	{22859, 167328, 8, 1601},
	{22876, 167332, 14, 2624},
	{22898, 167336},
	{22914, 167340, 1, 1621},
	{22936, 167344},
	{22952, 167348, 1, 1578},
	{22974, 167352},
	{22996, 167356},
	{23018, 167360},
	{23037, 167368},
	{23052, 167372, 2, 1576},
	{23068, 167376, 1, 1578},
	{23084, 167380, 3, 1579},
	{23099, 167384, 19, 2605},
	{23114, 167388, 8, 1601},
	{23131, 167392, 14, 2624},
	{23153, 167396},
	{23169, 167400, 1, 1621},
	{23191, 167404},
	{23207, 167408, 1, 1578},
	{23229, 167412},
	{23251, 167416},
	{23273, 167420},
	{23292, 167428},
	{23307, 167432, 2, 1576},
	{23323, 167436, 1, 1578},
	{23339, 167440, 3, 1579},
	{23354, 167444, 19, 2605},
	{23369, 167448, 8, 1601},
	{23386, 167452, 14, 2624},
	{23408, 167456},
	{23424, 167460, 1, 1621},
	{23446, 167464},
	{23462, 167468, 1, 1578},
	{23484, 167472},
	{23506, 167476},
	{23528, 167480},
	{23547, 167488, 1, 1622},
	{23566, 167492, 1, 1622},
	{23585, 167496, 1, 1622},
	{23604, 167500, 1, 1622},
	{23623, 167504, 1, 1622},
	{23642, 167508, 1, 1622},
	{23661, 167512, 1, 1622},
	{23680, 167516, 1, 1622},
	{23699, 167520, 1, 1622},
	{23724, 167524, 1, 1622},
	{23749, 167528, 1, 1622},
	{23774, 167532, 1, 1622},
	{23799, 167536, 1, 1622},
	{23824, 167540, 1, 1622},
	{23849, 167544, 1, 1622},
	{23874, 167548, 1, 1622},
	{23899, 167552, 1, 1622},
	{23924, 167556, 1, 1622},
	{23949, 167560, 1, 1622},
	{23974, 167564, 1, 1622},
	{23999, 167568, 1, 1622},
	{24024, 167572, 1, 1622},
	{24049, 167576, 1, 1622},
	{24074, 167580, 1, 1622},
	{24099, 167584, 1, 1622},
	{24122, 167588, 1, 1622},
	{24145, 167592, 1, 1622},
	{24168, 167596, 1, 1622},
	{24191, 167600, 1, 1622},
	{24214, 167604, 1, 1622},
	{24237, 167608, 1, 1622},
	{24260, 167612, 1, 1622},
	{24283, 167616, 3, 1623},
	{24301, 167620, 3, 1623},
	{24319, 167624, 3, 1623},
	{24337, 167628, 3, 1623},
	{24355, 167632, 3, 1623},
	{24373, 167636, 3, 1623},
	{24391, 167640, 3, 1623},
	{24409, 167644, 3, 1623},
	{24427, 167648, 9, 2638},
	{24445, 167652, 9, 2638},
	{24463, 167656, 9, 2638},
	{24481, 167660, 9, 2638},
	{24499, 167664, 9, 2638},
	{24517, 167668, 9, 2638},
	{24535, 167672, 9, 2638},
	{24553, 167676, 9, 2638},
	{24571, 196608, 1, 1634},
	{24591, 196612, 1, 1635},
	{24611, 196616},
	{24631, 196620},
	{24651, 196624},
	{24672, 196628},
	{24693, 196632, 1, 1636},
	{24715, 196636, 1, 1637},
	{24737, 196640},
	{24767, 196644},
	{24797, 196648},
	{24826, 196652},
	{24855, 196656},
	{24885, 196660},
	{24915, 196664},
	{24944, 196668},
	{24973, 196672},
	{25003, 196676},
	{25033, 196680},
	{25062, 196684},
	{25091, 196688},
	{25121, 196692},
	{25151, 196696},
	{25180, 196700},
	{25209, 196704, 1, 1638},
	{25231, 196708, 1, 1639},
	{25253, 196712},
	{25276, 196716},
	{25299, 196720},
	{25322, 196724},
	{25345, 196728},
	{25368, 196732},
	{25391, 196736},
	{25415, 196740},
	{25439, 196744},
	{25463, 196748},
	{25487, 196752},
	{25511, 196756},
	{25535, 196760},
	{25559, 196764},
	{25583, 196768},
	{25605, 196772},
	{25627, 196776},
	{25648, 196780},
	{25669, 196784},
	{25693, 196788},
	{25717, 196792},
	{25741, 196796},
	{25765, 196800},
	{25789, 196804},
	{25873, 196852, 1, 1641},
	{25895, 196856, 1, 1641},
	{25917, 196860, 1, 1642},
	{25933, 196864},
	{25946, 196868},
	{25959, 196872},
	{25972, 196876},
	{25985, 196880},
	{25998, 196884},
	{26011, 196888},
	{26024, 196892},
	{43506, 196896, 5, 2647},
	{26060, 196908, 1, 670},
	{26079, 196912},
	{26097, 196916},
	{26124, 196920},
	{26151, 196928, 2, 1643},
	{26164, 196932},
	{26177, 196936},
	{26200, 196940},
	{26223, 196944},
	{26251, 196948},
	{26279, 196952},
	{26307, 196956},
	{26335, 196960, 1, 1645},
	{26353, 196964, 4, 1646},
	{26371, 196968},
	{26386, 196972},
	{26410, 196976},
	{26434, 196980},
	{26453, 196984},
	{26472, 196988},
	{26496, 196992},
	{26520, 196996},
	{26544, 197000},
	{26568, 197028, 1, 1650},
	{26586, 197032, 2, 1651},
	{26604, 197036},
	{26622, 197040},
	{26640, 197044, 1, 1653},
	{26658, 197048, 2, 1654},
	{26676, 197052},
	{26694, 197056, 2, 2652},
	{26713, 197060, 5, 1658},
	{26732, 197072},
	{26756, 197076, 2, 2652},
	{26776, 197080, 5, 1658},
	{26796, 197084, 7, 1663},
	{26815, 197088, 7, 1663},
	{26833, 197092, 1, 1670},
	{26850, 197100, 1, 1671},
	{26871, 197104, 13, 1672},
	{26885, 197108},
	{26899, 197112},
	{26913, 197116, 2, 1685},
	{26929, 197120},
	{26948, 197124, 1, 1687},
	{26970, 197128},
	{26989, 197132, 1, 1688},
	{27011, 197136, 7, 1689},
	{27029, 197140},
	{27049, 197144, 1, 1687},
	{27072, 197148},
	{27092, 197152, 1, 1688},
	{27115, 197156, 7, 1689},
	{27134, 197160, 7, 1696},
	{27146, 197164, 2, 1703},
	{27163, 197168, 1, 1705},
	{27180, 197172, 1, 1706},
	{27198, 197176, 5, 2654},
	{27218, 197180, 2, 330},
	{27235, 197184},
	{27251, 197188, 1, 1713},
	{27278, 197196, 1, 1715},
	{27334, 197208, 1, 1718},
	{27356, 197212, 1, 1719},
	{27376, 197216, 1, 1714},
	{27393, 197220, 1, 1715},
	{27410, 197224},
	{27424, 197232, 2, 1720},
	{27446, 197236, 2, 1722},
	{27468, 197240, 2, 1720},
	{27491, 197244, 2, 1722},
	{27514, 197248, 2, 1720},
	{27536, 197252, 2, 1722},
	{43525, 197256},
	{43547, 197260},
	{43569, 197280},
	{43591, 197284},
	{43613, 197288},
	{43640, 197292},
	{43667, 197296},
	{43694, 197300},
	{27558, 197364, 1, 1724},
	{27579, 197368, 1, 1725},
	{27599, 197372, 1, 1726},
	{27636, 197380, 1, 1726},
	{27653, 197384, 1, 1727},
	{27669, 197388, 1, 1728},
	{27688, 197392, 1, 1729},
	{27707, 197396, 1, 1730},
	{27724, 197400, 1, 1731},
	{27742, 197404, 1, 1732},
	{27760, 197408, 1, 1733},
	{27776, 197412, 1, 1734},
	{27794, 197416, 1, 1735},
	{27812, 197420, 1, 1736},
	{27828, 197424, 1, 1731},
	{27843, 197428, 1, 1732},
	{27858, 197432, 1, 1733},
	{27871, 197436, 1, 1734},
	{27886, 197440, 1, 1735},
	{27901, 197444, 1, 1736},
	{27914, 197448, 1, 1737},
	{27928, 197452, 1, 1738},
	{27942, 197456, 1, 1739},
	{27954, 197460, 4, 1740},
	{27977, 197464, 5, 2659},
	{27999, 197468, 1, 1747},
	{28019, 197472, 1, 1748},
	{28033, 197476, 1, 1749},
	{28047, 197480, 1, 1750},
	{28059, 197484, 1, 1751},
	{28075, 197488, 1, 1748},
	{28092, 197492, 1, 1749},
	{28109, 197496, 1, 1750},
	{28124, 197500, 1, 1751},
	{28143, 197552, 1, 1752},
	{28168, 197556, 1, 1752},
	{28192, 197560, 1, 1753},
	{28212, 197568},
	{28238, 197572, 1, 1635},
	{28267, 197576},
	{28292, 197580, 1, 1635},
	{28320, 197584},
	{28343, 197588, 1, 1635},
	{28369, 197592},
	{28391, 197596, 1, 1635},
	{28416, 197600},
	{28435, 197604, 1, 1635},
	{28457, 197608, 1, 1350},
	{28471, 197612},
	{28488, 197616, 1, 1635},
	{28508, 197620, 8, 1754},
	{28525, 197624, 13, 1762},
	{28542, 197628},
	{28559, 197632, 1, 1705},
	{28579, 197636},
	{28596, 197640, 1, 1670},
	{28616, 197644, 2, 1775},
	{28635, 197888, 8, 1777},
	{28656, 197892, 8, 1777},
	{28677, 198656, 6, 1785},
	{28692, 198912},
	{28711, 198916},
	{28730, 198920, 1, 1791},
	{28749, 198924, 2, 2664},
	{28764, 198928},
	{28797, 198932},
	{28830, 198936},
	{28863, 198940},
	{28896, 198948},
	{28912, 198952},
	{28927, 198956, 2, 1364},
	{28953, 198960},
	{28969, 198964},
	{28987, 198968, 1, 1792},
	{29004, 198972, 2, 2666},
	{29025, 198976},
	{29044, 198980},
	{29063, 198984},
	{29079, 198988, 1, 837},
	{29098, 198992},
	{29118, 198996, 1, 837},
	{29141, 199000},
	{29159, 199004, 1, 837},
	{29180, 199008, 9, 1795},
	{29205, 199012},
	{29221, 199016},
	{29242, 199020, 4, 1804},
	{29250, 199024},
	{29264, 199028},
	{29278, 199032},
	{29292, 199036, 3, 1808},
	{29307, 199040, 2, 1811},
	{29319, 199044, 1, 837},
	{29341, 199048, 3, 1813},
	{43721, 199052, 2, 2668},
	{29357, 199168, 1, 1816},
	{29382, 199172, 2, 1817},
	{29407, 199184, 2, 1819},
	{29433, 199188, 2, 1819},
	{29459, 199192, 2, 1819},
	{29485, 199212, 2, 1819},
	{29511, 199296, 2, 1821},
	{29539, 199300, 1, 1823},
	{29563, 199304, 1, 1824},
	{29587, 199308, 1, 1825},
	{29620, 199312, 1, 1825},
	{29648, 199328, 2, 1821},
	{29677, 199332, 1, 1823},
	{29702, 199336, 1, 1824},
	{29727, 199340, 1, 1825},
	{29761, 199344, 1, 1825},
	{29790, 199360, 2, 1821},
	{29814, 199364, 1, 1823},
	{29834, 199368, 1, 1824},
	{29854, 199372, 1, 1825},
	{29883, 199376, 1, 1825},
	{29907, 199936},
	{29934, 199940},
	{29961, 199944},
	{29988, 199948},
	{30015, 199952},
	{30042, 199956},
	{30069, 199960},
	{30096, 199964},
	{30123, 199968, 5, 2670},
	{30148, 200192},
	{30167, 200196, 1, 847},
	{30189, 200448},
	{30213, 200452, 1, 1835},
	{30236, 200456},
	{30260, 200460, 1, 1835},
	{30283, 200464},
	{30307, 200468, 1, 1835},
	{30330, 200472},
	{30354, 200476, 1, 1835},
	{30377, 200696},
	{30396, 200700, 1, 1835},
	{30414, 200704},
	{30426, 200708},
	{30438, 200712},
	{30456, 200716},
	{30475, 200720},
	{30493, 200724},
	{30505, 200728},
	{30517, 200732},
	{30535, 200736},
	{30553, 200740},
	{30572, 200744, 4, 1836},
	{30586, 200748, 2, 1840},
	{30604, 200752, 2, 1842},
	{30618, 200756, 2, 1844},
	{30632, 200760, 2, 1846},
	{30649, 200764, 2, 1848},
	{30666, 200768},
	{30679, 200772, 2, 1850},
	{30691, 200776},
	{30705, 200780},
	{30721, 200784},
	{30735, 200788},
	{30751, 200792},
	{30766, 200796},
	{30783, 200800},
	{30798, 200804},
	{30815, 200808, 2, 1852},
	{30837, 200812, 11, 2675},
	{30854, 200816, 2, 1864},
	{30875, 200820, 2, 1866},
	{30887, 200824},
	{30902, 200828, 6, 1868},
	{30917, 200832, 2, 1874},
	{30931, 200836},
	{30948, 200960},
	{30970, 200964},
	{30994, 200968},
	{31018, 200972},
	{31044, 212992},
	{31064, 212996},
	{31084, 213000},
	{31104, 213004},
	{31124, 213008},
	{31144, 213012},
	{31164, 213016},
	{31184, 213020},
	{31204, 213024},
	{31224, 213028},
	{31244, 213032},
	{31264, 213036},
	{31284, 213040},
	{31307, 213044},
	{31330, 213048},
	{31353, 213248},
	{31374, 213252},
	{31395, 213260},
	{31416, 213264},
	{31437, 213268},
	{31461, 213272},
	{31485, 213276},
	{31509, 213280},
	{31533, 213284},
	{31557, 213288},
	{31581, 213292},
	{31605, 213296},
	{43733, 213648},
	{43753, 213652},
	{43773, 213656},
	{43793, 213660},
	{43813, 213664},
	{43833, 213668},
	{43853, 213672},
	{43873, 213676},
	{43893, 213680},
	{43918, 213684},
	{43943, 213688},
	{43968, 213692},
	{43993, 213696},
	{44018, 213700},
	{44043, 213704},
	{44068, 213708},
	{44093, 213712},
	{44116, 213716},
	{44139, 213720},
	{44162, 213724},
	{44185, 213728},
	{44208, 213732},
	{44231, 213736},
	{44254, 213740},
	{32089, 214016},
	{32111, 214020, 1, 1876},
	{32133, 214024},
	{32155, 214028, 1, 1876},
	{32177, 214032},
	{32199, 214036, 1, 1876},
	{32221, 214040},
	{32243, 214044, 1, 1876},
	{32265, 214272},
	{32287, 214276},
	{32309, 214280},
	{32331, 214284},
	{32353, 214288},
	{32375, 214292},
	{32397, 214296},
	{32419, 214300},
	{32441, 214304},
	{32463, 214308},
	{32485, 214312},
	{32507, 214316},
	{32529, 214320},
	{32551, 214324},
	{32573, 214328},
	{32595, 214332},
	{32617, 214528},
	{32637, 214532},
	{32657, 214536},
	{32677, 214540},
	{32697, 214544},
	{32717, 214548},
	{32737, 214552},
	{32757, 214556},
	{32777, 214560},
	{32797, 214564},
	{32817, 214568},
	{32837, 214572},
	{32857, 214784},
	{32876, 214788},
	{32895, 214792},
	{32914, 214796},
	{32933, 214800},
	{32952, 214804},
	{32971, 214808},
	{32990, 214812},
	{33009, 214816},
	{33028, 214820},
	{33047, 214824},
	{33066, 214828},
	{33085, 214832},
	{33104, 214836},
	{33123, 214840},
	{33142, 214844},
	{33161, 214848},
	{33180, 214852},
	{33199, 214856},
	{33218, 214860},
	{33237, 214864},
	{33257, 214868},
	{33277, 214872},
	{33297, 214876},
	{33317, 214880},
	{33337, 214884},
	{33357, 214888},
	{33377, 214892},
	{33397, 214896},
	{33417, 214900},
	{33437, 214904},
	{33457, 214908},
	{33477, 215296},
	{33496, 215300},
	{33515, 215304},
	{33534, 215308},
	{33553, 215312},
	{33572, 215316},
	{33591, 215320},
	{33610, 215324},
	{33629, 215424},
	{33650, 215428},
	{44277, 215432},
	{44297, 215436, 2, 1877},
	{33671, 215552},
	{33691, 215556},
	{33711, 215560},
	{33731, 215564},
	{33751, 215568},
	{33771, 215572},
	{33791, 215576},
	{33811, 215580},
	{33831, 215808},
	{33850, 215812},
	{33869, 215816},
	{33888, 215820},
	{33907, 216064},
	{33926, 216068},
	{33945, 216072},
	{33964, 216076},
	{33983, 216320},
	{34003, 216324},
	{34023, 216328},
	{34043, 216332},
	{34063, 216336},
	{34083, 216340},
	{34103, 216344},
	{34123, 216348},
	{34143, 216576},
	{34164, 216580},
	{34185, 216584},
	{34206, 216588},
	{34227, 216592},
	{34248, 216596},
	{34269, 216600},
	{34290, 216604},
	{34311, 216640},
	{34332, 216644},
	{34353, 216648},
	{34374, 216652},
	{34395, 216656},
	{34416, 216660},
	{34437, 216664},
	{34458, 216668},
	{34479, 216704},
	{34500, 216708},
	{34521, 216712},
	{34542, 216716},
	{34563, 216720},
	{34584, 216724},
	{34605, 216728},
	{34626, 216732},
	{34647, 216832},
	{34667, 216836},
	{34687, 216840},
	{34707, 216844},
	{34727, 216848},
	{34747, 216852},
	{34767, 216856},
	{34787, 216860},
	{34807, 216864},
	{34828, 216868},
	{34849, 216872},
	{34870, 216876},
	{34891, 216880},
	{34912, 216884},
	{34933, 216888},
	{34954, 216892},
	{34975, 217112},
	{34994, 217116},
	{35013, 217120},
	{35032, 217124},
	{35051, 217128},
	{35070, 217132},
	{35089, 217136},
	{35108, 217140},
	{35127, 217344},
	{35146, 217348},
	{35165, 217352},
	{35184, 217356},
	{35203, 217360},
	{35222, 217364},
	{35241, 217368},
	{35260, 217372},
	{35279, 217600},
	{35299, 217604},
	{35319, 217608},
	{35339, 217612},
	{35359, 217856},
	{35379, 217860},
	{35399, 217864},
	{35419, 217868},
	{35439, 217872},
	{35459, 217876},
	{35479, 217880},
	{35499, 217884},
	{35569, 218016},
	{35595, 218020, 2, 1877},
	{44317, 218024},
	{44340, 218028, 2, 1877},
	{35621, 218080},
	{35646, 218084},
	{35671, 218088},
	{35696, 218092},
	{35773, 218224},
	{35795, 218228},
	{35817, 218232},
	{35839, 218236},
	{35861, 218240},
	{35881, 218244},
	{35901, 218248},
	{35921, 218252},
	{35941, 218624},
	{35963, 218628},
	{35985, 218632},
	{36007, 218636},
	{36029, 218640},
	{36051, 218644},
	{36073, 218648},
	{36095, 218652},
	{36117, 218656},
	{36139, 218660},
	{36161, 218664},
	{36183, 218668},
	{36205, 218672},
	{36227, 218676},
	{36249, 218680},
	{36271, 218684},
	{36293, 218880},
	{36314, 218884},
	{36335, 218888},
	{36356, 218892},
	{36377, 218896},
	{36398, 218900},
	{36419, 218904},
	{36440, 218908},
	{36461, 219136},
	{36481, 219140},
	{36501, 219144},
	{36521, 219148},
	{36541, 219152},
	{36561, 219156},
	{36581, 219160},
	{36601, 219164},
	{36621, 219392},
	{36641, 219396},
	{44363, 219400},
	{44382, 219404, 2, 1877},
	{44401, 219520},
	{44430, 219524, 2, 1877},
	{44459, 219528},
	{44481, 219532},
	{44503, 219536},
	{44525, 219540},
	{44547, 219568},
	{44576, 219572, 2, 1877},
	{44605, 219576},
	{44627, 219580},
	{44649, 219584},
	{44671, 219588},
	{44693, 219616},
	{44722, 219620, 2, 1877},
	{44751, 219624},
	{44773, 219628},
	{44795, 219632},
	{44817, 219636},
	{44839, 219664},
	{44868, 219668, 2, 1877},
	{44897, 219672},
	{44919, 219676},
	{44941, 219680},
	{44963, 219684},
	{36661, 221184, 5, 1879},
	{36685, 221188, 4, 1884},
	{36710, 221192, 5, 1879},
	{36734, 221196, 5, 1879},
	{36758, 221200, 4, 1884},
	{36783, 221204, 5, 1879},
	{36807, 221208, 4, 1884},
	{36832, 221212, 5, 1879},
	{36856, 221216, 4, 1888},
	{36872, 221220, 5, 1879},
	{36896, 221224, 3, 1892},
	{36930, 221228, 3, 1895},
	{36964, 221232, 3, 1898},
	{36989, 221236, 3, 1901},
	{37014, 221240, 3, 1898},
	{37039, 221248},
	{37054, 221252, 1, 1825},
	{37077, 221256},
	{37100, 221260},
	{37118, 221264, 2, 1904},
	{37136, 221268, 4, 1906},
	{37156, 221440, 20, 1910},
	{37181, 221444, 20, 1910},
	{37206, 221448, 15, 1930},
	{37234, 221452, 15, 1930},
	{37262, 221456, 15, 1930},
	{37290, 221460, 15, 1930},
	{37318, 221492, 8, 1945},
	{37346, 221496, 8, 1945},
	{44985, 221840, 5, 1953},
	{45009, 221844, 4, 1958},
	{45034, 221848, 5, 1953},
	{45058, 221852, 4, 1958},
	{45083, 221856, 5, 1953},
	{45107, 221860, 4, 1958},
	{45132, 221864, 5, 1953},
	{45156, 221868, 4, 1958},
	{45181, 221872, 5, 1953},
	{45210, 221876, 4, 1958},
	{45240, 221880, 5, 1953},
	{45269, 221884, 4, 1958},
	{45299, 221888, 5, 1953},
	{45328, 221892, 4, 1958},
	{45358, 221896, 5, 1953},
	{45387, 221900, 4, 1958},
	{45417, 221904, 5, 1953},
	{45444, 221908, 4, 1958},
	{45472, 221912, 5, 1953},
	{45499, 221916, 4, 1958},
	{45527, 221920, 5, 1953},
	{45554, 221924, 4, 1958},
	{45582, 221928, 5, 1953},
	{45609, 221932, 4, 1958},
	{37748, 222208, 5, 1964},
	{37774, 222212, 4, 1969},
	{37801, 222216, 5, 1964},
	{37827, 222220, 4, 1969},
	{37854, 222224, 5, 1964},
	{37880, 222228, 4, 1969},
	{37907, 222232, 5, 1964},
	{37933, 222236, 4, 1969},
	{37960, 222464, 5, 1964},
	{37986, 222468, 4, 1969},
	{38013, 222472, 1, 1879},
	{38039, 222476, 1, 1879},
	{38065, 222480, 1, 1879},
	{38091, 222484, 1, 1879},
	{38117, 222488, 1, 1879},
	{38143, 222492, 1, 1879},
	{38169, 222496, 1, 1879},
	{38195, 222720, 5, 1964},
	{38219, 222724, 5, 1964},
	{38243, 222728, 5, 1964},
	{38267, 222732, 5, 1964},
	{38291, 222736, 4, 1969},
	{38316, 222740, 4, 1969},
	{38341, 222744, 4, 1969},
	{38366, 222748, 4, 1969},
	{38391, 222752, 1, 1879},
	{38415, 222756, 1, 1879},
	{38439, 222760, 8, 1973},
	{38460, 222976, 3, 2686},
	{38483, 222980, 3, 2686},
	{38506, 222984, 3, 2686},
	{38529, 222988, 3, 2686},
	{38552, 222992, 3, 2686},
	{38575, 222996, 3, 2686},
	{38598, 223000, 3, 2686},
	{38621, 223004, 3, 2686},
	{38644, 223008, 3, 2686},
	{38667, 223012, 3, 2686},
	{38690, 223016, 3, 2686},
	{38714, 223020, 3, 2686},
	{38738, 223024, 3, 2686},
	{38762, 223028, 3, 2686},
	{38786, 223032, 3, 2686},
	{38810, 223036, 3, 2686},
	{38834, 223104, 15, 2689},
	{38854, 223112, 1, 1994},
	{38875, 223232, 5, 1964},
	{38900, 223236, 4, 1969},
	{38926, 223240, 8, 1995},
	{45637, 223244, 5, 2147},
	{45659, 223248, 5, 2147},
	{45681, 223252, 6, 2152},
	{38949, 223488, 5, 1964},
	{38972, 223492, 5, 1964},
	{38995, 223496, 3, 2020},
	{39018, 223500, 3, 2020},
	{39041, 223504, 4, 1969},
	{39065, 223508, 4, 1969},
	{39089, 223744, 5, 1964},
	{39113, 223748, 5, 1964},
	{39137, 223752, 5, 1964},
	{39161, 223756, 5, 1964},
	{39185, 223760, 4, 1969},
	{45708, 223764, 4, 1969},
	{45733, 223768, 4, 1969},
	{45758, 223772, 4, 1969},
	{39210, 224000, 5, 1964},
	{39233, 224004, 4, 1969},
	{39257, 224008, 3, 2020},
	{39280, 224256, 5, 1964},
	{39303, 224260, 4, 1969},
	{39327, 224264, 3, 2020},
	{39350, 224512, 5, 1964},
	{39374, 224516, 4, 1969},
	{39399, 224520, 5, 1964},
	{39423, 224524, 4, 1969},
	{39448, 224528, 3, 2020},
	{39472, 224532, 3, 2020},
	{39496, 224768, 5, 1964},
	{39521, 224772, 4, 1958},
	{39547, 224776, 5, 1964},
	{39572, 224780, 4, 1958},
	{39598, 224784, 3, 2020},
	{39623, 224788, 3, 2020},
	{39648, 224832, 5, 1964},
	{39673, 224836, 4, 1958},
	{39699, 224840, 5, 1964},
	{39724, 224844, 4, 1958},
	{39750, 224848, 3, 2020},
	{39775, 224852, 3, 2020},
	{39800, 224896, 5, 1964},
	{39825, 224900, 4, 1958},
	{39851, 224904, 3, 2020},
	{39876, 224908, 3, 2020},
	{39901, 224912, 3, 2020},
	{39926, 225024, 5, 1964},
	{39950, 225028, 4, 1958},
	{39975, 225032, 3, 2020},
	{39999, 225036, 3, 2020},
	{40023, 225040, 3, 2020},
	{40047, 225048, 5, 1964},
	{40072, 225052, 4, 1958},
	{40098, 225056, 3, 2020},
	{40123, 225060, 3, 2020},
	{40148, 225064, 3, 2020},
	{40173, 225280, 12, 2023},
	{40195, 225284, 5, 2035},
	{40218, 225288, 4, 2040},
	{40242, 225292, 2, 2044},
	{40265, 225296, 2, 2044},
	{40288, 225300, 2, 2044},
	{40311, 225536, 5, 1964},
	{40334, 225540, 4, 1969},
	{40358, 225544, 5, 1964},
	{40381, 225548, 4, 1969},
	{40405, 225552, 5, 1964},
	{40428, 225560, 5, 1964},
	{40451, 225792, 4, 2046},
	{40472, 225796},
	{40501, 225800, 2, 2050},
	{40530, 225804},
	{40556, 225808, 7, 2052},
	{40585, 225812},
	{40604, 225816, 2, 2059},
	{40630, 225820, 2, 2061},
	{40653, 225824},
	{40676, 225828, 2, 2063},
	{40703, 225832},
	{40730, 225836, 2, 2065},
	{40755, 225840, 2, 2067},
	{40783, 225844, 2, 2069},
	{40811, 225848, 2, 2071},
	{40834, 225852, 2, 2073},
	{40857, 225856},
	{40890, 225860, 2, 2075},
	{40923, 225864},
	{40955, 225868, 2, 2075},
	{40987, 225872, 2, 2077},
	{41006, 225876, 2, 2079},
	{41033, 225880},
	{41060, 225884, 2, 2704},
	{41087, 225888, 2, 2083},
	{41114, 225892, 17, 2706},
	{41135, 225896, 9, 2723},
	{41154, 225900, 19, 2732},
	{41173, 225904, 1, 2111},
	{41197, 225908, 1, 2113},
	{41229, 225912, 2, 2115},
	{41259, 225916, 4, 2117},
	{41295, 225920, 3, 2121},
	{41328, 225924, 1, 2124},
	{45783, 225928, 7, 2052},
	{41346, 225932, 1, 2125},
	{45816, 225936},
	{45843, 225940},
	{45869, 225944, 4, 2117},
	{45909, 225948, 2, 2751},
	{45943, 225952, 2, 2751},
	{45973, 225956, 2, 2079},
	{46004, 225960},
	{46035, 225964, 4, 2753},
	{46069, 225968, 3, 2121},
	{46106, 225972, 3, 2757},
	{41366, 226048, 2, 2126},
	{41383, 226052, 1, 2128},
	{41407, 226056, 1, 2128},
	{41431, 226060, 4, 2129},
	{41457, 226064, 3, 2133},
	{41486, 226068, 1, 694},
	{41515, 226072, 3, 2133},
	{41544, 226076, 1, 694},
	{41573, 226192, 1, 2136},
	{41621, 226304, 5, 2035},
	{41645, 226308, 4, 2040},
	{41670, 226312, 2, 2044},
	{41694, 226316, 5, 2035},
	{41718, 226320, 4, 2040},
	{41743, 226324, 2, 2044},
	{41767, 226328, 10, 2137},
	{41875, 226480, 5, 2147},
	{41903, 226484, 5, 2147},
	{41931, 226488, 5, 2147},
	{41959, 226492, 5, 2147},
	{41987, 226496, 5, 2147},
	{42015, 226500, 5, 2147},
	{42043, 226504, 5, 2147},
	{42071, 226508, 5, 2147},
	{42099, 226512, 6, 2152},
	{46147, 226516, 5, 2147},
	{46172, 226520, 5, 2147},
	{46197, 226524, 5, 2147},
	{46222, 226528, 5, 2147},
	{46247, 226532, 6, 2152},
	{42132, 226544, 5, 1964},
	{42161, 226548, 5, 1964},
	{42190, 226552, 4, 1969},
	{42220, 226556, 4, 1969},
	{42250, 226560, 8, 1995},
	{42277, 226564, 8, 1995},
	{42393, 226688, 5, 2035},
	{42417, 226692, 4, 2040},
	{42442, 226696, 3, 2158},
	{42466, 226700, 2, 2161},
	{42492, 226704, 2, 2161},
	{42518, 226816, 5, 1964},
	{42544, 226820, 4, 1969},
	{42571, 226824, 5, 1964},
	{42597, 226828, 5, 1964},
	{42623, 226832, 5, 1964},
	{42649, 226836, 1, 1879},
	{42675, 226840, 1, 1879},
	{42701, 226844, 1, 1879},
	{42727, 226848, 1, 1879},
	{42753, 226880, 4, 1969},
	{42780, 226884, 4, 1969},
	{42807, 226888, 4, 1969},
	{42834, 227072, 5, 1964},
	{42859, 227076, 4, 1958},
	{42885, 227080, 3, 2020},
	{42910, 227084, 3, 2020},
	{42935, 227088, 3, 2020},
	{42960, 227200, 5, 1964},
	{42984, 227204, 4, 1958},
	{43009, 227208, 3, 2020},
	{43033, 227212, 3, 2020},
	{43057, 227216, 3, 2020},
	{43081, 227328, 5, 1964},
	{43105, 227332, 4, 1969},
	{43130, 227336, 8, 1995},
	{46277, 227340, 5, 2147},
	{46298, 227344, 5, 2147},
	{46319, 227348, 6, 2152},
	{46345, 227456, 5, 2147},
	{46376, 227460, 5, 2147},
	{46407, 227464, 6, 2152},
	{46443, 227468, 1, 2760},
	{46467, 227472, 5, 1964},
	{46493, 227476, 4, 1969},
	{46520, 227480, 5, 1964},
	{46546, 227484, 4, 1969},
	{46573, 227504, 5, 2147},
	{46604, 227508, 5, 2147},
	{46635, 227512, 6, 2152},
	{46671, 227516, 1, 2760},
	{46695, 227520, 5, 1964},
	{46721, 227524, 4, 1969},
	{46748, 227528, 5, 1964},
	{46774, 227532, 4, 1969},
	{46801, 227552, 5, 2147},
	{46832, 227556, 5, 2147},
	{46863, 227560, 6, 2152},
	{46899, 227564, 1, 2760},
	{46923, 227568, 5, 1964},
	{46949, 227572, 4, 1969},
	{46976, 227576, 5, 1964},
	{47002, 227580, 4, 1969},
	{47029, 227600, 5, 2147},
	{47060, 227604, 5, 2147},
	{47091, 227608, 6, 2152},
	{47127, 227612, 1, 2760},
	{47151, 227616, 5, 1964},
	{47177, 227620, 4, 1969},
	{47204, 227624, 5, 1964},
	{47230, 227628, 4, 1969},
	{206, 880, 4, 2163},
	{43152, 881},
	{26999, 882},
	{43164, 1008},
	{43175, 1009},
	{27187, 1010, 4, 2167},
	{43186, 1040, 1, 2171},
	{43199, 1041, 5, 2172},
	{43212, 1042, 1, 2177},
	{43225, 1043, 1, 1688},
	{27021, 1045, 7, 2178},
	{43238, 1168, 12, 2185},
	{43253, 1281, 6, 2197},
	{43268, 1282},
	{26958, 1283},
	{43152, 1285},
	{26999, 1286},
	{43280, 1414, 15, 2203},
};

static const struct si_reg gfx11_reg_table[] = {
	{43289, 40, 1, 2218},
	{43304, 44, 1, 2218},
	{1310, 1028, 10, 2761},
	{1323, 1032, 26, 2771},
	{1338, 1036, 11, 2797},
	{1375, 1044, 2, 2808},
	{1393, 1048, 3, 56},
	{1411, 1052, 4, 2810},
	{1426, 1056},
	{1440, 1060, 1, 70},
	{1471, 1076, 2, 78},
	{1487, 1080},
	{1882, 1104},
	{1906, 1108},
	{1504, 1116, 6, 2814},
	{1519, 1120, 6, 85},
	{1534, 1124, 2, 92},
	{1554, 1128, 1, 94},
	{1593, 1136, 4, 2820},
	{43327, 1140, 1, 2237},
	{1609, 2480},
	{1623, 2484},
	{1651, 2492},
	{1665, 2496},
	{1679, 2500},
	{1693, 2504},
	{1707, 2508},
	{1721, 2512},
	{1735, 2516},
	{1749, 2520},
	{1764, 2524},
	{1779, 2528},
	{1794, 2532},
	{1809, 2536},
	{1824, 2540},
	{1839, 2548},
	{1850, 2552},
	{1866, 2556},
	{1954, 32776, 22, 2824},
	{1967, 32784, 22, 2846},
	{1979, 32788, 17, 2868},
	{1995, 32792, 17, 2868},
	{2011, 32796, 15, 2885},
	{2024, 32824, 17, 2868},
	{2040, 32828, 17, 2868},
	{47257, 32832, 17, 2868},
	{47273, 32836, 17, 2868},
	{47289, 33280, 1, 2900},
	{47307, 33284},
	{2056, 33296, 23, 2901},
	{2070, 33300, 28, 2924},
	{2087, 33304, 16, 2952},
	{2108, 33308, 28, 247},
	{2122, 33312, 32, 275},
	{2139, 33316, 13, 307},
	{2160, 33320, 9, 320},
	{2178, 33324, 1, 329},
	{43349, 33328, 1, 2968},
	{2201, 33344, 2, 330},
	{2222, 33348},
	{2242, 33352, 1, 332},
	{2265, 33356, 11, 2969},
	{2283, 33436, 1, 342},
	{2687, 36608},
	{2705, 36612, 3, 2980},
	{2723, 36616},
	{2741, 36620, 10, 2983},
	{2759, 36656, 14, 397},
	{2777, 36660, 4, 411},
	{2795, 36664, 8, 2993},
	{2813, 36668, 2, 3001},
	{2847, 39160, 6, 2344},
	{3642, 40960},
	{3660, 40964, 6, 3003},
	{3678, 40968, 2, 453},
	{3696, 40972, 9, 456},
	{3714, 40976, 3, 2350},
	{3732, 40980, 6, 3009},
	{3750, 40984, 11, 3015},
	{3768, 40988},
	{3786, 41120, 11, 3026},
	{3818, 45060, 5, 3037},
	{3842, 45080},
	{3867, 45084, 3, 3042},
	{3891, 45088},
	{3912, 45092, 1, 498},
	{3933, 45096, 12, 2372},
	{3957, 45100, 10, 510},
	{3981, 45104},
	{4007, 45108},
	{4033, 45112},
	{4059, 45116},
	{4085, 45120},
	{4111, 45124},
	{4137, 45128},
	{4163, 45132},
	{4189, 45136},
	{4215, 45140},
	{4241, 45144},
	{4268, 45148},
	{4295, 45152},
	{4322, 45156},
	{4349, 45160},
	{4376, 45164},
	{4403, 45168},
	{4430, 45172},
	{4457, 45176},
	{4484, 45180},
	{4511, 45184},
	{4538, 45188},
	{4565, 45192},
	{4592, 45196},
	{4619, 45200},
	{4646, 45204},
	{4673, 45208},
	{4700, 45212},
	{4727, 45216},
	{4754, 45220},
	{4781, 45224},
	{4808, 45228},
	{4835, 45248, 8, 520},
	{4891, 45256, 1, 533},
	{4918, 45260, 1, 533},
	{4945, 45264, 1, 533},
	{4972, 45268, 1, 533},
	{6286, 45568},
	{6311, 45572, 9, 3045},
	{6335, 45576},
	{6367, 45580},
	{6399, 45584},
	{6423, 45588, 1, 498},
	{6447, 45596, 4, 583},
	{6471, 45600},
	{6492, 45604, 1, 498},
	{6513, 45608, 13, 587},
	{6537, 45612, 9, 600},
	{6561, 45616},
	{6587, 45620},
	{6613, 45624},
	{6639, 45628},
	{6665, 45632},
	{6691, 45636},
	{6717, 45640},
	{6743, 45644},
	{6769, 45648},
	{6795, 45652},
	{6821, 45656},
	{6848, 45660},
	{6875, 45664},
	{6902, 45668},
	{6929, 45672},
	{6956, 45676},
	{6983, 45680},
	{7010, 45684},
	{7037, 45688},
	{7064, 45692},
	{7091, 45696},
	{7118, 45700},
	{7145, 45704},
	{7172, 45708},
	{7199, 45712},
	{7226, 45716},
	{7253, 45720},
	{7280, 45724},
	{7307, 45728},
	{7334, 45732},
	{7361, 45736},
	{7388, 45740},
	{47325, 45744, 4, 3054},
	{47351, 45748, 2, 3058},
	{7415, 45760, 8, 520},
	{7475, 45768, 1, 533},
	{7504, 45772, 1, 533},
	{7533, 45776, 1, 533},
	{7562, 45780, 1, 533},
	{7642, 45856},
	{7663, 45860, 1, 498},
	{8181, 46080},
	{8206, 46084, 5, 3037},
	{8230, 46088},
	{8262, 46092},
	{8294, 46096},
	{8318, 46100, 1, 498},
	{8342, 46108, 4, 619},
	{8366, 46112},
	{8387, 46116, 1, 498},
	{8408, 46120, 12, 623},
	{8432, 46124, 9, 635},
	{8456, 46128},
	{8482, 46132},
	{8508, 46136},
	{8534, 46140},
	{8560, 46144},
	{8586, 46148},
	{8612, 46152},
	{8638, 46156},
	{8664, 46160},
	{8690, 46164},
	{8716, 46168},
	{8743, 46172},
	{8770, 46176},
	{8797, 46180},
	{8824, 46184},
	{8851, 46188},
	{8878, 46192},
	{8905, 46196},
	{8932, 46200},
	{8959, 46204},
	{8986, 46208},
	{9013, 46212},
	{9040, 46216},
	{9067, 46220},
	{9094, 46224},
	{9121, 46228},
	{9148, 46232},
	{9175, 46236},
	{9202, 46240},
	{9229, 46244},
	{9256, 46248},
	{9283, 46252},
	{9310, 46272, 8, 520},
	{9370, 46280, 1, 533},
	{9399, 46284, 1, 533},
	{9428, 46288, 1, 533},
	{9457, 46292, 1, 533},
	{9537, 46368},
	{9558, 46372, 1, 498},
	{10049, 47104, 15, 3060},
	{10076, 47108},
	{10090, 47112},
	{10104, 47116},
	{10118, 47120},
	{10134, 47124},
	{10150, 47128},
	{10166, 47132, 2, 666},
	{10187, 47136, 2, 666},
	{10208, 47140, 2, 666},
	{10229, 47144, 1, 668},
	{10257, 47148, 1, 669},
	{10282, 47152},
	{10297, 47156, 1, 670},
	{10312, 47160},
	{10341, 47164, 1, 670},
	{10370, 47168},
	{10403, 47172, 1, 670},
	{10436, 47176, 12, 671},
	{10454, 47180, 11, 683},
	{10472, 47184, 1, 694},
	{10485, 47188, 6, 695},
	{10509, 47192},
	{10536, 47196},
	{10563, 47200, 2, 3075},
	{10584, 47204},
	{10611, 47208},
	{10638, 47212},
	{10656, 47216},
	{10674, 47220},
	{10692, 47224, 1, 703},
	{10720, 47228, 4, 3077},
	{10742, 47232},
	{10762, 47236},
	{10785, 47240, 9, 709},
	{10802, 47248, 1, 533},
	{10823, 47252, 1, 533},
	{10844, 47256, 1, 533},
	{10865, 47260, 1, 533},
	{10886, 47264, 5, 3081},
	{10904, 47268, 1, 719},
	{10923, 47272},
	{47383, 47276, 2, 3086},
	{47414, 47280, 2, 3086},
	{47445, 47284, 2, 3086},
	{47476, 47288, 2, 3086},
	{47507, 47292, 1, 3088},
	{10945, 47296, 3, 720},
	{10962, 47300},
	{10991, 47304, 1, 723},
	{11020, 47308, 3, 720},
	{11038, 47360},
	{11058, 47364},
	{11078, 47368},
	{11098, 47372},
	{11118, 47376},
	{11138, 47380},
	{11158, 47384},
	{11178, 47388},
	{11198, 47392},
	{11218, 47396},
	{11238, 47400},
	{11259, 47404},
	{11280, 47408},
	{11301, 47412},
	{11322, 47416},
	{11343, 47420},
	{11364, 47604, 2, 724},
	{11388, 47608},
	{11409, 47612},
	{11425, 163840, 15, 3089},
	{11443, 163844, 10, 737},
	{11460, 163848, 7, 747},
	{11474, 163852, 22, 3104},
	{11493, 163856, 18, 3126},
	{11513, 163860},
	{11532, 163868, 2, 793},
	{11549, 163872},
	{11569, 163876},
	{11589, 163880, 1, 795},
	{11606, 163884},
	{11621, 163888, 2, 796},
	{11645, 163892, 2, 798},
	{11685, 163900, 8, 3144},
	{11703, 163904, 14, 811},
	{11713, 163908, 9, 825},
	{11729, 163912},
	{11744, 163916},
	{11765, 163920},
	{11781, 163924},
	{11803, 163928, 2, 834},
	{11821, 163932, 1, 836},
	{11839, 163944, 1, 837},
	{11857, 163948, 1, 837},
	{11881, 163952, 1, 837},
	{11900, 163956, 1, 837},
	{11925, 163960, 1, 837},
	{11947, 163964, 13, 3152},
	{11971, 163968},
	{11987, 163972, 1, 847},
	{12006, 164328, 1, 848},
	{12027, 164332, 1, 848},
	{12048, 164336, 1, 848},
	{12069, 164340, 1, 848},
	{12090, 164344},
	{12108, 164348},
	{12126, 164352, 2, 849},
	{12146, 164356, 3, 851},
	{12170, 164360, 2, 854},
	{12194, 164364, 1, 856},
	{12214, 164368, 2, 851},
	{12234, 164372, 2, 854},
	{12254, 164376, 2, 851},
	{12274, 164380, 2, 854},
	{12294, 164384, 2, 851},
	{12314, 164388, 2, 854},
	{12334, 164392, 2, 851},
	{12354, 164396, 2, 854},
	{12374, 164400, 7, 857},
	{12389, 164404, 2, 864},
	{12418, 164408, 8, 866},
	{12433, 164412, 8, 874},
	{12448, 164416, 3, 851},
	{12473, 164420, 2, 854},
	{12498, 164424},
	{12516, 164428},
	{12534, 164432, 3, 851},
	{12559, 164436, 2, 854},
	{12584, 164440, 3, 851},
	{12609, 164444, 2, 854},
	{12634, 164448, 3, 851},
	{12659, 164452, 2, 854},
	{12684, 164456, 3, 851},
	{12709, 164460, 2, 854},
	{12734, 164464, 3, 851},
	{12759, 164468, 2, 854},
	{12784, 164472, 3, 851},
	{12809, 164476, 2, 854},
	{12834, 164480, 3, 851},
	{12859, 164484, 2, 854},
	{12884, 164488, 3, 851},
	{12909, 164492, 2, 854},
	{12934, 164496, 3, 851},
	{12959, 164500, 2, 854},
	{12984, 164504, 3, 851},
	{13009, 164508, 2, 854},
	{13034, 164512, 3, 851},
	{13060, 164516, 2, 854},
	{13086, 164520, 3, 851},
	{13112, 164524, 2, 854},
	{13138, 164528, 3, 851},
	{13164, 164532, 2, 854},
	{13190, 164536, 3, 851},
	{13216, 164540, 2, 854},
	{13242, 164544, 3, 851},
	{13268, 164548, 2, 854},
	{13294, 164552, 3, 851},
	{13320, 164556, 2, 854},
	{13346, 164560},
	{13365, 164564},
	{13384, 164568},
	{13403, 164572},
	{13422, 164576},
	{13441, 164580},
	{13460, 164584},
	{13479, 164588},
	{13498, 164592},
	{13517, 164596},
	{13536, 164600},
	{13555, 164604},
	{13574, 164608},
	{13593, 164612},
	{13612, 164616},
	{13631, 164620},
	{13650, 164624},
	{13669, 164628},
	{13688, 164632},
	{13707, 164636},
	{13726, 164640},
	{13746, 164644},
	{13766, 164648},
	{13786, 164652},
	{13806, 164656},
	{13826, 164660},
	{13846, 164664},
	{13866, 164668},
	{13886, 164672},
	{13906, 164676},
	{13926, 164680},
	{13946, 164684},
	{13966, 164688, 15, 882},
	{13986, 164692, 3, 897},
	{14008, 164696, 2, 900},
	{14036, 164700, 4, 3165},
	{14065, 164704, 1, 909},
	{14086, 164708, 1, 910},
	{14096, 164712, 1, 911},
	{43421, 164716},
	{43443, 164720},
	{47535, 164816, 5, 3169},
	{47559, 164820},
	{47588, 164824, 1, 1622},
	{47621, 164828, 2, 3174},
	{47653, 164836, 11, 3176},
	{47679, 164848},
	{47699, 164852, 2, 3187},
	{47723, 164856, 2, 3174},
	{14214, 164876},
	{14243, 164880, 7, 3189},
	{14268, 164884},
	{14281, 164888},
	{14296, 164892},
	{14310, 164896},
	{47746, 164900, 8, 3196},
	{14340, 164904, 4, 938},
	{14364, 164908, 6, 942},
	{14383, 164912, 4, 948},
	{14401, 164916, 4, 952},
	{14422, 164924},
	{14441, 164928},
	{14461, 164932},
	{14480, 164936},
	{14500, 164940},
	{14519, 164944},
	{14539, 164948},
	{14560, 164952},
	{14582, 164956},
	{14603, 164960},
	{14625, 164964},
	{14646, 164968},
	{14668, 164972},
	{14689, 164976},
	{14711, 164980},
	{14732, 164984},
	{14754, 164988},
	{14775, 164992},
	{14797, 164996},
	{14818, 165000},
	{14840, 165004},
	{14861, 165008},
	{14883, 165012},
	{14904, 165016},
	{14926, 165020},
	{14947, 165024},
	{14969, 165028},
	{14990, 165032},
	{15012, 165036},
	{15033, 165040},
	{15055, 165044},
	{15076, 165048},
	{15098, 165052},
	{15119, 165056},
	{15141, 165060},
	{15162, 165064},
	{15184, 165068},
	{15205, 165072},
	{15227, 165076},
	{15248, 165080},
	{15270, 165084},
	{15291, 165088},
	{15313, 165092},
	{15334, 165096},
	{15356, 165100},
	{15377, 165104},
	{15399, 165108},
	{15420, 165112},
	{15442, 165116},
	{15463, 165120},
	{15485, 165124},
	{15506, 165128},
	{15528, 165132},
	{15549, 165136},
	{15571, 165140},
	{15592, 165144},
	{15614, 165148},
	{15635, 165152},
	{15657, 165156},
	{15678, 165160},
	{15700, 165164},
	{15722, 165168},
	{15745, 165172},
	{15767, 165176},
	{15790, 165180},
	{15812, 165184},
	{15835, 165188},
	{15857, 165192},
	{15880, 165196},
	{15902, 165200},
	{15925, 165204},
	{15947, 165208},
	{15970, 165212},
	{15992, 165216},
	{16015, 165220},
	{16037, 165224},
	{16060, 165228},
	{16082, 165232},
	{16105, 165236},
	{16127, 165240},
	{16150, 165244},
	{16172, 165248},
	{16195, 165252},
	{16217, 165256},
	{16240, 165260},
	{16262, 165264},
	{16285, 165268},
	{16307, 165272},
	{16330, 165276},
	{16352, 165280},
	{16375, 165284},
	{16397, 165288},
	{16420, 165292},
	{16442, 165296},
	{16465, 165300},
	{16487, 165304},
	{16510, 165308},
	{16524, 165312},
	{16538, 165316},
	{16552, 165320},
	{16566, 165324},
	{16580, 165328},
	{16594, 165332},
	{16608, 165336},
	{16622, 165340},
	{16636, 165344},
	{16650, 165348},
	{16664, 165352},
	{16678, 165356},
	{16692, 165360},
	{16706, 165364},
	{16720, 165368},
	{16734, 165372},
	{16748, 165376},
	{16762, 165380},
	{16776, 165384},
	{16790, 165388},
	{16804, 165392},
	{16818, 165396},
	{16832, 165400},
	{16846, 165404},
	{47762, 165408, 2, 3204},
	{16869, 165444, 13, 3206},
	{16889, 165448, 13, 3206},
	{16909, 165452, 13, 3206},
	{16929, 165456, 13, 3206},
	{16949, 165460, 13, 3206},
	{16969, 165464, 13, 3206},
	{16989, 165468, 13, 3206},
	{17009, 165472, 13, 3206},
	{17029, 165476, 13, 3206},
	{17049, 165480, 13, 3206},
	{17069, 165484, 13, 3206},
	{17090, 165488, 13, 3206},
	{17111, 165492, 13, 3206},
	{17132, 165496, 13, 3206},
	{17153, 165500, 13, 3206},
	{17174, 165504, 13, 3206},
	{17195, 165508, 13, 3206},
	{17216, 165512, 13, 3206},
	{17237, 165516, 13, 3206},
	{17258, 165520, 13, 3206},
	{17279, 165524, 11, 3219},
	{17300, 165528, 11, 3219},
	{17321, 165532, 11, 3219},
	{17342, 165536, 11, 3219},
	{17363, 165540, 11, 3219},
	{17384, 165544, 11, 3219},
	{17405, 165548, 11, 3219},
	{17426, 165552, 11, 3219},
	{17447, 165556, 11, 3219},
	{17468, 165560, 11, 3219},
	{17489, 165564, 11, 3219},
	{17510, 165568, 11, 3219},
	{17531, 165572, 3, 3230},
	{17549, 165580, 16, 980},
	{17566, 165584, 16, 980},
	{17584, 165588, 7, 996},
	{17605, 165592, 7, 3233},
	{17623, 165600, 7, 1009},
	{17638, 165608, 2, 3075},
	{47775, 165612},
	{47799, 165616, 1, 670},
	{17655, 165640, 1, 1016},
	{17677, 165644, 5, 1017},
	{17699, 165648, 1, 1022},
	{17719, 165652, 8, 1023},
	{43465, 165712, 8, 2482},
	{17741, 165716, 8, 3240},
	{17759, 165720, 8, 1039},
	{17780, 165724, 17, 1047},
	{17801, 165728, 6, 1064},
	{17819, 165732, 6, 1064},
	{17837, 165736, 6, 1064},
	{17855, 165740, 6, 1064},
	{17873, 165744, 6, 1064},
	{17891, 165748, 6, 1064},
	{17909, 165752, 6, 1064},
	{17927, 165756, 6, 1064},
	{17945, 165760, 9, 3248},
	{17963, 165764, 9, 3248},
	{17981, 165768, 9, 3248},
	{17999, 165772, 9, 3248},
	{18017, 165776, 9, 3248},
	{18035, 165780, 9, 3248},
	{18053, 165784, 9, 3248},
	{18071, 165788, 9, 3248},
	{18103, 165840, 1, 1079},
	{18118, 165844},
	{18136, 165848},
	{18154, 165852},
	{18171, 165856},
	{18192, 165860, 1, 1080},
	{18208, 165864},
	{18221, 165872, 6, 2498},
	{18255, 165880, 1, 1089},
	{18277, 165884, 1, 1090},
	{18304, 165888, 10, 1091},
	{18321, 165892, 12, 1101},
	{18329, 165896, 5, 3257},
	{18346, 165900, 18, 3262},
	{18364, 165904, 20, 1134},
	{18380, 165908, 16, 1154},
	{18399, 165912, 10, 1170},
	{18414, 165916, 29, 3280},
	{18432, 165920, 16, 1208},
	{18450, 165924, 3, 1224},
	{18474, 165928},
	{18499, 165932, 11, 1228},
	{18522, 165936, 5, 1239},
	{18573, 165944, 3, 2539},
	{18588, 165948, 5, 1250},
	{18618, 165952, 5, 1255},
	{18633, 165956},
	{43491, 165960, 6, 2542},
	{18651, 166400, 2, 1260},
	{18668, 166404, 2, 1262},
	{18687, 166408, 1, 1264},
	{18703, 166412, 4, 1265},
	{18756, 166424},
	{18779, 166428},
	{19005, 166472, 6, 2548},
	{19023, 166476, 24, 1317},
	{19041, 166480},
	{19185, 166512},
	{19196, 166516},
	{19209, 166520},
	{19226, 166524, 9, 2554},
	{19245, 166528},
	{19256, 166532, 3, 1358},
	{19275, 166536},
	{19297, 166540},
	{19319, 166544, 3, 3309},
	{19366, 166552, 4, 2563},
	{19457, 166572, 1, 1377},
	{19503, 166580, 1, 1378},
	{19532, 166588, 9, 1380},
	{19549, 166592, 4, 1389},
	{19576, 166596, 4, 1393},
	{19603, 166600, 4, 1397},
	{19938, 166696},
	{19969, 166700},
	{20012, 166704, 1, 1402},
	{20050, 166712, 1, 1403},
	{20070, 166732, 2, 1404},
	{20089, 166736, 5, 1406},
	{20111, 166740, 17, 3312},
	{20132, 166744, 3, 1430},
	{20239, 166764, 11, 3329},
	{20252, 166768, 6, 1445},
	{20293, 166776, 2, 1451},
	{20323, 166780},
	{20347, 166784},
	{20377, 166788},
	{20408, 166792},
	{20437, 166796},
	{20467, 166800, 3, 1453},
	{20556, 166868, 8, 1468},
	{20582, 166872, 8, 1476},
	{20608, 166876, 5, 1484},
	{20624, 166880, 8, 2597},
	{20640, 166884, 3, 1495},
	{20655, 166888},
	{20678, 166892},
	{20701, 166896},
	{20724, 166900},
	{20747, 166904, 8, 1498},
	{20781, 166908, 8, 1506},
	{20815, 166912, 8, 1514},
	{20849, 166916, 8, 1522},
	{20883, 166920, 8, 1498},
	{20917, 166924, 8, 1506},
	{20951, 166928, 8, 1514},
	{20985, 166932, 8, 1522},
	{21019, 166936, 8, 1498},
	{21053, 166940, 8, 1506},
	{21087, 166944, 8, 1514},
	{21121, 166948, 8, 1522},
	{21155, 166952, 8, 1498},
	{21189, 166956, 8, 1506},
	{21223, 166960, 8, 1514},
	{21257, 166964, 8, 1522},
	{21291, 166968, 2, 1530},
	{21315, 166972, 2, 1532},
	{21339, 166976, 5, 3340},
	{21360, 166980, 12, 3345},
	{21380, 166984, 2, 1550},
	{21400, 166988, 20, 1552},
	{21438, 166992, 6, 3357},
	{47823, 166996, 10, 3363},
	{21507, 167008},
	{21554, 167020, 3, 1579},
	{21569, 167024, 10, 3373},
	{21584, 167028, 5, 3383},
	{47843, 167032, 17, 3388},
	{21743, 167060},
	{21762, 167068},
	{21809, 167080, 3, 1579},
	{21824, 167084, 10, 3373},
	{21839, 167088, 5, 3383},
	{47866, 167092, 17, 3388},
	{21998, 167120},
	{22017, 167128},
	{22064, 167140, 3, 1579},
	{22079, 167144, 10, 3373},
	{22094, 167148, 5, 3383},
	{47889, 167152, 17, 3388},
	{22253, 167180},
	{22272, 167188},
	{22319, 167200, 3, 1579},
	{22334, 167204, 10, 3373},
	{22349, 167208, 5, 3383},
	{47912, 167212, 17, 3388},
	{22508, 167240},
	{22527, 167248},
	{22574, 167260, 3, 1579},
	{22589, 167264, 10, 3373},
	{22604, 167268, 5, 3383},
	{47935, 167272, 17, 3388},
	{22763, 167300},
	{22782, 167308},
	{22829, 167320, 3, 1579},
	{22844, 167324, 10, 3373},
	{22859, 167328, 5, 3383},
	{47958, 167332, 17, 3388},
	{23018, 167360},
	{23037, 167368},
	{23084, 167380, 3, 1579},
	{23099, 167384, 10, 3373},
	{23114, 167388, 5, 3383},
	{47981, 167392, 17, 3388},
	{23273, 167420},
	{23292, 167428},
	{23339, 167440, 3, 1579},
	{23354, 167444, 10, 3373},
	{23369, 167448, 5, 3383},
	{48004, 167452, 17, 3388},
	{23528, 167480},
	{23547, 167488, 1, 1622},
	{23566, 167492, 1, 1622},
	{23585, 167496, 1, 1622},
	{23604, 167500, 1, 1622},
	{23623, 167504, 1, 1622},
	{23642, 167508, 1, 1622},
	{23661, 167512, 1, 1622},
	{23680, 167516, 1, 1622},
	{24099, 167584, 1, 1622},
	{24122, 167588, 1, 1622},
	{24145, 167592, 1, 1622},
	{24168, 167596, 1, 1622},
	{24191, 167600, 1, 1622},
	{24214, 167604, 1, 1622},
	{24237, 167608, 1, 1622},
	{24260, 167612, 1, 1622},
	{24283, 167616, 3, 1623},
	{24301, 167620, 3, 1623},
	{24319, 167624, 3, 1623},
	{24337, 167628, 3, 1623},
	{24355, 167632, 3, 1623},
	{24373, 167636, 3, 1623},
	{24391, 167640, 3, 1623},
	{24409, 167644, 3, 1623},
	{24427, 167648, 5, 3405},
	{24445, 167652, 5, 3405},
	{24463, 167656, 5, 3405},
	{24481, 167660, 5, 3405},
	{24499, 167664, 5, 3405},
	{24517, 167668, 5, 3405},
	{24535, 167672, 5, 3405},
	{24553, 167676, 5, 3405},
	{24571, 196608, 1, 1634},
	{24591, 196612, 1, 1635},
	{24611, 196616},
	{24631, 196620},
	{24651, 196624},
	{24672, 196628},
	{25209, 196704, 1, 1638},
	{25231, 196708, 1, 1639},
	{25253, 196712},
	{25276, 196716},
	{25299, 196720},
	{25322, 196724},
	{25345, 196728},
	{25368, 196732},
	{25391, 196736},
	{25415, 196740},
	{25439, 196744},
	{25463, 196748},
	{25487, 196752},
	{25511, 196756},
	{25535, 196760},
	{25559, 196764},
	{25583, 196768},
	{25605, 196772},
	{25627, 196776},
	{25648, 196780},
	{25669, 196784},
	{25693, 196788},
	{25717, 196792},
	{25741, 196796},
	{25765, 196800},
	{25789, 196804},
	{48027, 196808},
	{48051, 196812},
	{25873, 196852, 1, 1641},
	{25933, 196864},
	{25946, 196868},
	{25959, 196872},
	{25972, 196876},
	{25985, 196880},
	{25998, 196884},
	{26011, 196888},
	{26024, 196892},
	{43506, 196896, 5, 2647},
	{26060, 196908, 1, 670},
	{26079, 196912},
	{26097, 196916},
	{26124, 196920},
	{26177, 196936},
	{26200, 196940},
	{26223, 196944},
	{26251, 196948},
	{26279, 196952},
	{26307, 196956},
	{26335, 196960, 1, 1645},
	{26353, 196964, 6, 3410},
	{26371, 196968},
	{26386, 196972},
	{26410, 196976},
	{26434, 196980},
	{26453, 196984},
	{26472, 196988},
	{26496, 196992},
	{26520, 196996},
	{26544, 197000},
	{26568, 197028, 1, 1650},
	{26586, 197032, 7, 3416},
	{26604, 197036},
	{26622, 197040},
	{26640, 197044, 1, 1653},
	{26658, 197048, 5, 3423},
	{26676, 197052},
	{26694, 197056, 2, 2652},
	{26713, 197060, 5, 1658},
	{26732, 197072},
	{26756, 197076, 2, 2652},
	{26776, 197080, 5, 1658},
	{26796, 197084, 9, 3428},
	{26815, 197088, 9, 3428},
	{26929, 197120},
	{26948, 197124, 1, 1687},
	{26970, 197128},
	{26989, 197132, 1, 1688},
	{27011, 197136, 7, 1689},
	{27029, 197140},
	{27049, 197144, 1, 1687},
	{27072, 197148},
	{27092, 197152, 1, 1688},
	{27115, 197156, 7, 1689},
	{27134, 197160, 7, 1696},
	{27146, 197164, 2, 1703},
	{27180, 197172, 1, 1706},
	{27198, 197176, 6, 3437},
	{27218, 197180, 2, 330},
	{27235, 197184},
	{27251, 197188, 1, 1713},
	{27278, 197196, 1, 1715},
	{27334, 197208, 1, 1718},
	{27356, 197212, 1, 1719},
	{27424, 197232, 2, 1720},
	{27446, 197236, 2, 1722},
	{27468, 197240, 2, 1720},
	{27491, 197244, 2, 1722},
	{27514, 197248, 2, 1720},
	{27536, 197252, 2, 1722},
	{43525, 197256},
	{43547, 197260},
	{48075, 197264},
	{48097, 197268},
	{48119, 197272},
	{48142, 197276},
	{27636, 197380, 1, 1726},
	{27653, 197384, 1, 1727},
	{27871, 197436, 1, 1734},
	{27886, 197440, 1, 1735},
	{27901, 197444, 1, 1736},
	{27914, 197448, 1, 1737},
	{27928, 197452, 1, 1738},
	{27942, 197456, 1, 1739},
	{27954, 197460, 6, 3443},
	{27977, 197464, 6, 3449},
	{27999, 197468, 1, 1747},
	{28019, 197472, 1, 1748},
	{28033, 197476, 1, 1749},
	{28047, 197480, 1, 1750},
	{28059, 197484, 1, 1751},
	{28143, 197552, 1, 1752},
	{28192, 197560, 1, 1753},
	{28212, 197568},
	{28238, 197572, 1, 1635},
	{28320, 197584},
	{28343, 197588, 1, 1635},
	{28369, 197592},
	{28391, 197596, 1, 1635},
	{28416, 197600},
	{28435, 197604, 1, 1635},
	{28457, 197608, 1, 1350},
	{28471, 197612},
	{28488, 197616, 1, 1635},
	{28508, 197620, 8, 1754},
	{28525, 197624, 13, 1762},
	{28542, 197628},
	{28559, 197632, 1, 1705},
	{28579, 197636},
	{28596, 197640, 1, 1670},
	{28616, 197644, 2, 1775},
	{28635, 197888, 8, 1777},
	{28656, 197892, 8, 1777},
	{28677, 198656, 6, 1785},
	{28730, 198920, 1, 3455},
	{28749, 198924, 2, 2664},
	{28896, 198948},
	{28912, 198952},
	{28927, 198956, 3, 3456},
	{28953, 198960},
	{28969, 198964},
	{28987, 198968, 1, 3459},
	{29004, 198972, 2, 2666},
	{29025, 198976},
	{29205, 199012},
	{29221, 199016},
	{29242, 199020, 8, 3460},
	{29250, 199024},
	{29264, 199028},
	{29278, 199032},
	{29292, 199036, 3, 1808},
	{29307, 199040, 2, 1811},
	{29319, 199044, 1, 837},
	{29341, 199048, 3, 1813},
	{43721, 199052, 2, 2668},
	{48165, 199056, 2, 3468},
	{48190, 199060, 1, 3470},
	{19164, 199064, 1, 3471},
	{29357, 199168, 1, 1816},
	{29382, 199172, 2, 1817},
	{29407, 199184, 2, 1819},
	{29433, 199188, 2, 1819},
	{29459, 199192, 2, 1819},
	{29485, 199212, 2, 1819},
	{29511, 199296, 2, 1821},
	{29539, 199300, 1, 1823},
	{29563, 199304, 1, 1824},
	{29587, 199308, 1, 1825},
	{29620, 199312, 1, 1825},
	{29648, 199328, 2, 1821},
	{29677, 199332, 1, 1823},
	{29702, 199336, 1, 1824},
	{29727, 199340, 1, 1825},
	{29761, 199344, 1, 1825},
	{29790, 199360, 2, 1821},
	{29814, 199364, 1, 1823},
	{29834, 199368, 1, 1824},
	{29854, 199372, 1, 1825},
	{29883, 199376, 1, 1825},
	{29907, 199936},
	{29934, 199940},
	{29961, 199944},
	{29988, 199948},
	{30015, 199952},
	{30042, 199956},
	{30069, 199960},
	{30096, 199964},
	{30123, 199968, 4, 2670},
	{30148, 200192},
	{30167, 200196, 1, 847},
	{30189, 200448},
	{30213, 200452, 1, 1835},
	{30236, 200456},
	{30260, 200460, 1, 1835},
	{30283, 200464},
	{30307, 200468, 1, 1835},
	{30330, 200472},
	{30354, 200476, 1, 1835},
	{30414, 200704},
	{30426, 200708},
	{30438, 200712},
	{30456, 200716},
	{30475, 200720},
	{30493, 200724},
	{30505, 200728},
	{30517, 200732},
	{30535, 200736},
	{30553, 200740},
	{30572, 200744, 4, 1836},
	{30586, 200748, 2, 1840},
	{30604, 200752, 2, 3472},
	{30618, 200756, 2, 3474},
	{30632, 200760, 2, 1846},
	{30649, 200764, 2, 1848},
	{30666, 200768},
	{30679, 200772, 2, 1850},
	{30691, 200776},
	{30705, 200780},
	{30721, 200784},
	{30735, 200788},
	{30751, 200792},
	{30766, 200796},
	{30783, 200800},
	{30798, 200804},
	{30815, 200808, 2, 1852},
	{30837, 200812, 9, 3476},
	{30854, 200816, 2, 1864},
	{30875, 200820, 2, 1866},
	{30887, 200824},
	{30902, 200828, 6, 1868},
	{30917, 200832, 2, 1874},
	{30931, 200836},
	{48217, 200840},
	{48246, 200844},
	{48275, 200848},
	{48304, 200852},
	{48333, 200856},
	{48342, 200860},
	{48351, 200864},
	{48360, 200868},
	{48369, 200872},
	{48399, 200876},
	{48429, 200880},
	{48460, 200884},
	{48491, 200888},
	{48521, 200892},
	{48551, 200896},
	{48582, 200900},
	{48613, 200904},
	{48643, 200908},
	{48673, 200912},
	{48704, 200916},
	{48735, 200920},
	{48765, 200924},
	{48795, 200928},
	{48826, 200932},
	{2831, 200960, 7, 3485},
	{48857, 200964, 13, 3492},
	{48875, 200968, 7, 3505},
	{48893, 200972, 3, 3512},
	{48913, 200976, 8, 3515},
	{48935, 200980, 8, 3523},
	{48957, 200984},
	{48981, 200988, 6, 3531},
	{31044, 212992},
	{31064, 212996},
	{31084, 213000},
	{31104, 213004},
	{31124, 213008},
	{31144, 213012},
	{31164, 213016},
	{31184, 213020},
	{31204, 213024},
	{31224, 213028},
	{31244, 213032},
	{31264, 213036},
	{31284, 213040},
	{31307, 213044},
	{31330, 213048},
	{31353, 213248},
	{31374, 213252},
	{31395, 213260},
	{31416, 213264},
	{31437, 213268},
	{31461, 213272},
	{31485, 213276},
	{31509, 213280},
	{31533, 213284},
	{31557, 213288},
	{31581, 213292},
	{31605, 213296},
	{49005, 213300},
	{49029, 213304},
	{49053, 213308},
	{49077, 213312},
	{49101, 213316},
	{49125, 213320},
	{43733, 213648},
	{43753, 213652},
	{43773, 213656},
	{43793, 213660},
	{43813, 213664},
	{43833, 213668},
	{43853, 213672},
	{43873, 213676},
	{43893, 213680},
	{43918, 213684},
	{43943, 213688},
	{43968, 213692},
	{43993, 213696},
	{44018, 213700},
	{44043, 213704},
	{44068, 213708},
	{44093, 213712},
	{44116, 213716},
	{44139, 213720},
	{44162, 213724},
	{44185, 213728},
	{44208, 213732},
	{44231, 213736},
	{44254, 213740},
	{32089, 214016},
	{32111, 214020, 1, 1876},
	{32133, 214024},
	{32155, 214028, 1, 1876},
	{32177, 214032},
	{32199, 214036, 1, 1876},
	{32221, 214040},
	{32243, 214044, 1, 1876},
	{32265, 214272},
	{32287, 214276},
	{32309, 214280},
	{32331, 214284},
	{32353, 214288},
	{32375, 214292},
	{32397, 214296},
	{32419, 214300},
	{32441, 214304},
	{32463, 214308},
	{32485, 214312},
	{32507, 214316},
	{32529, 214320},
	{32551, 214324},
	{32573, 214328},
	{32595, 214332},
	{32617, 214528},
	{32637, 214532},
	{32657, 214536},
	{32677, 214540},
	{32697, 214544},
	{32717, 214548},
	{32737, 214552},
	{32757, 214556},
	{32777, 214560},
	{32797, 214564},
	{32817, 214568},
	{32837, 214572},
	{31185, 214576},
	{31165, 214580},
	{31145, 214584},
	{31125, 214588},
	{49149, 214592},
	{49168, 214596},
	{49187, 214600},
	{49206, 214604},
	{32857, 214784},
	{32895, 214792},
	{32933, 214800},
	{32971, 214808},
	{33009, 214816},
	{33047, 214824},
	{33085, 214832},
	{33123, 214840},
	{49225, 214928},
	{49245, 214932},
	{49265, 214936},
	{49285, 214940},
	{49305, 214944},
	{49325, 214948},
	{49345, 214952},
	{49365, 214956},
	{49385, 214960},
	{49405, 214964},
	{49425, 214968},
	{49445, 214972},
	{49465, 214976},
	{49485, 214980},
	{49505, 214984},
	{49525, 214988},
	{33477, 215296},
	{33496, 215300},
	{33515, 215304},
	{33534, 215308},
	{33553, 215312},
	{33572, 215316},
	{33591, 215320},
	{33610, 215324},
	{33629, 215424},
	{33650, 215428},
	{44277, 215432},
	{44297, 215436, 2, 1877},
	{33671, 215552},
	{33691, 215556},
	{33711, 215560},
	{33731, 215564},
	{33751, 215568},
	{33771, 215572},
	{33791, 215576},
	{33811, 215580},
	{33831, 215808},
	{33850, 215812},
	{33869, 215816},
	{33888, 215820},
	{33907, 216064},
	{33926, 216068},
	{33945, 216072},
	{33964, 216076},
	{33983, 216320},
	{34003, 216324},
	{34023, 216328},
	{34043, 216332},
	{34063, 216336},
	{34083, 216340},
	{34103, 216344},
	{34123, 216348},
	{49545, 216352, 12, 3537},
	{49568, 216356, 1, 3549},
	{49592, 216360, 13, 3550},
	{34143, 216576},
	{34164, 216580},
	{34185, 216584},
	{34206, 216588},
	{34227, 216592},
	{34248, 216596},
	{34269, 216600},
	{34290, 216604},
	{34311, 216640},
	{34332, 216644},
	{34353, 216648},
	{34374, 216652},
	{34395, 216656},
	{34416, 216660},
	{34437, 216664},
	{34458, 216668},
	{34479, 216704},
	{34500, 216708},
	{34521, 216712},
	{34542, 216716},
	{34563, 216720},
	{34584, 216724},
	{34605, 216728},
	{34626, 216732},
	{34647, 216832},
	{34667, 216836},
	{34687, 216840},
	{34707, 216844},
	{34727, 216848},
	{34747, 216852},
	{34767, 216856},
	{34787, 216860},
	{34807, 216864},
	{34828, 216868},
	{34849, 216872},
	{34870, 216876},
	{34891, 216880},
	{34912, 216884},
	{34933, 216888},
	{34954, 216892},
	{34975, 217112},
	{34994, 217116},
	{35013, 217120},
	{35032, 217124},
	{35051, 217128},
	{35070, 217132},
	{35089, 217136},
	{35108, 217140},
	{35127, 217344},
	{35146, 217348},
	{35165, 217352},
	{35184, 217356},
	{35203, 217360},
	{35222, 217364},
	{35241, 217368},
	{35260, 217372},
	{35279, 217600},
	{35299, 217604},
	{35319, 217608},
	{35339, 217612},
	{35359, 217856},
	{35379, 217860},
	{35399, 217864},
	{35419, 217868},
	{35439, 217872},
	{35459, 217876},
	{35479, 217880},
	{35499, 217884},
	{35621, 217984},
	{35646, 217988},
	{35671, 217992},
	{35696, 217996},
	{35569, 218000},
	{35595, 218004, 2, 1877},
	{44317, 218008},
	{44340, 218012, 2, 1877},
	{35861, 218240},
	{35881, 218244},
	{35901, 218248},
	{35921, 218252},
	{35941, 218624},
	{35963, 218628},
	{35985, 218632},
	{36007, 218636},
	{36029, 218640},
	{36051, 218644},
	{36073, 218648},
	{36095, 218652},
	{36117, 218656},
	{36139, 218660},
	{36161, 218664},
	{36183, 218668},
	{36205, 218672},
	{36227, 218676},
	{36249, 218680},
	{36271, 218684},
	{35773, 218752},
	{35795, 218756},
	{35817, 218760},
	{35839, 218764},
	{49618, 218768},
	{49640, 218772},
	{49662, 218776},
	{49684, 218780},
	{36293, 218880},
	{36314, 218884},
	{36335, 218888},
	{36356, 218892},
	{36377, 218896},
	{36398, 218900},
	{36419, 218904},
	{36440, 218908},
	{49706, 218944},
	{49727, 218948},
	{49748, 218952},
	{49769, 218956},
	{49790, 218960},
	{49811, 218964},
	{49832, 218968},
	{49853, 218972},
	{36461, 219136},
	{36481, 219140},
	{36501, 219144},
	{36521, 219148},
	{36541, 219152},
	{36561, 219156},
	{36581, 219160},
	{36601, 219164},
	{36621, 219392},
	{36641, 219396},
	{44363, 219400},
	{44382, 219404, 2, 1877},
	{44401, 219520},
	{44430, 219524, 2, 1877},
	{44459, 219528},
	{44481, 219532},
	{44503, 219536},
	{44525, 219540},
	{44547, 219568},
	{44576, 219572, 2, 1877},
	{44605, 219576},
	{44627, 219580},
	{44649, 219584},
	{44671, 219588},
	{36661, 221184, 3, 3563},
	{36685, 221188, 4, 1884},
	{36710, 221192, 5, 1879},
	{36734, 221196, 3, 3563},
	{36758, 221200, 4, 1884},
	{36783, 221204, 3, 3563},
	{36807, 221208, 4, 1884},
	{36832, 221212, 5, 1879},
	{36856, 221216, 4, 1888},
	{36872, 221220, 5, 1879},
	{36896, 221224, 3, 1892},
	{36930, 221228, 3, 1895},
	{36964, 221232, 3, 1898},
	{36989, 221236, 3, 1901},
	{37014, 221240, 3, 1898},
	{49874, 221244, 3, 1895},
	{37039, 221248},
	{37054, 221252, 1, 1825},
	{37077, 221256},
	{37100, 221260},
	{37118, 221264, 2, 1904},
	{37136, 221268, 4, 1906},
	{37156, 221440, 20, 1910},
	{37181, 221444, 20, 1910},
	{37206, 221448, 18, 3566},
	{37234, 221452, 18, 3566},
	{37262, 221456, 18, 3566},
	{37290, 221460, 18, 3566},
	{49908, 221464, 18, 3566},
	{49936, 221468, 18, 3566},
	{49964, 221472, 18, 3566},
	{37318, 221492, 9, 3584},
	{37346, 221496, 9, 3584},
	{44985, 221840, 5, 3593},
	{45009, 221844, 4, 1969},
	{45034, 221848, 5, 3593},
	{45058, 221852, 4, 1969},
	{45083, 221856, 5, 3593},
	{45107, 221860, 4, 1969},
	{45132, 221864, 5, 3593},
	{45156, 221868, 4, 1969},
	{45181, 221872, 5, 3593},
	{45210, 221876, 4, 1969},
	{45240, 221880, 5, 3593},
	{45269, 221884, 4, 1969},
	{45299, 221888, 5, 3593},
	{45328, 221892, 4, 1969},
	{45358, 221896, 5, 3593},
	{45387, 221900, 4, 1969},
	{45417, 221904, 5, 3593},
	{45444, 221908, 4, 1969},
	{45472, 221912, 5, 3593},
	{45499, 221916, 4, 1969},
	{45527, 221920, 5, 3593},
	{45554, 221924, 4, 1969},
	{45582, 221928, 5, 3593},
	{45609, 221932, 4, 1969},
	{37748, 222208, 5, 1964},
	{37774, 222212, 4, 1969},
	{37801, 222216, 5, 1964},
	{37827, 222220, 4, 1969},
	{37854, 222224, 5, 1964},
	{37880, 222228, 4, 1969},
	{37907, 222232, 5, 1964},
	{37933, 222236, 4, 1969},
	{37960, 222464, 5, 1964},
	{37986, 222468, 4, 1969},
	{38013, 222472, 1, 1879},
	{38039, 222476, 1, 1879},
	{38065, 222480, 1, 1879},
	{38091, 222484, 1, 1879},
	{38117, 222488, 1, 1879},
	{38143, 222492, 1, 1879},
	{38169, 222496, 1, 1879},
	{38195, 222720, 5, 1964},
	{38219, 222724, 5, 1964},
	{38243, 222728, 5, 1964},
	{38267, 222732, 5, 1964},
	{38291, 222736, 4, 1969},
	{38316, 222740, 4, 1969},
	{38341, 222744, 4, 1969},
	{38366, 222748, 4, 1969},
	{38391, 222752, 1, 1879},
	{38415, 222756, 1, 1879},
	{38439, 222760, 8, 1973},
	{36873, 222768, 5, 1964},
	{36735, 222772, 5, 1964},
	{49992, 222776, 5, 1964},
	{50015, 222780, 5, 1964},
	{36759, 222784, 4, 1969},
	{50038, 222788, 4, 1969},
	{50062, 222792, 4, 1969},
	{50086, 222796, 4, 1969},
	{38460, 222976, 3, 2686},
	{38483, 222980, 3, 2686},
	{38506, 222984, 3, 2686},
	{38529, 222988, 3, 2686},
	{38552, 222992, 3, 2686},
	{38575, 222996, 3, 2686},
	{38598, 223000, 3, 2686},
	{38621, 223004, 3, 2686},
	{38644, 223008, 3, 2686},
	{38667, 223012, 3, 2686},
	{38690, 223016, 3, 2686},
	{38714, 223020, 3, 2686},
	{38738, 223024, 3, 2686},
	{38762, 223028, 3, 2686},
	{38786, 223032, 3, 2686},
	{38810, 223036, 3, 2686},
	{50110, 223040, 3, 2686},
	{50134, 223044, 3, 2686},
	{50158, 223048, 3, 2686},
	{50182, 223052, 3, 2686},
	{50206, 223056, 3, 2686},
	{50230, 223060, 3, 2686},
	{50254, 223064, 3, 2686},
	{50278, 223068, 3, 2686},
	{50302, 223072, 10, 3598},
	{50323, 223080, 2, 3608},
	{50345, 223084, 1, 3610},
	{38834, 223104, 10, 3598},
	{38854, 223112, 2, 3608},
	{2306, 223136},
	{2332, 223140, 2, 343},
	{2358, 223144},
	{2384, 223148, 2, 343},
	{2479, 223152, 18, 3611},
	{2431, 223156, 5, 3629},
	{2452, 223160, 7, 3634},
	{2410, 223164, 2, 345},
	{2500, 223184, 5, 3641},
	{43376, 223188, 6, 3646},
	{2552, 223192},
	{2582, 223196},
	{2614, 223200},
	{2645, 223204},
	{2523, 223208},
	{38875, 223232, 5, 1964},
	{38900, 223236, 4, 1969},
	{38926, 223240, 8, 1995},
	{45637, 223244, 5, 2147},
	{45659, 223248, 5, 2147},
	{45681, 223252, 6, 2152},
	{38949, 223488, 5, 1964},
	{38972, 223492, 5, 1964},
	{38995, 223496, 3, 2020},
	{39018, 223500, 3, 2020},
	{39041, 223504, 4, 1969},
	{39065, 223508, 4, 1969},
	{39089, 223744, 5, 1964},
	{39113, 223748, 5, 1964},
	{39137, 223752, 5, 1964},
	{39161, 223756, 5, 1964},
	{39185, 223760, 4, 1969},
	{45708, 223764, 4, 1969},
	{45733, 223768, 4, 1969},
	{45758, 223772, 4, 1969},
	{39210, 224000, 5, 1964},
	{39233, 224004, 4, 1969},
	{39257, 224008, 3, 2020},
	{39280, 224256, 5, 1964},
	{39303, 224260, 4, 1969},
	{39327, 224264, 3, 2020},
	{39350, 224512, 5, 1964},
	{39374, 224516, 4, 1969},
	{39399, 224520, 5, 1964},
	{39423, 224524, 4, 1969},
	{39448, 224528, 3, 2020},
	{39472, 224532, 3, 2020},
	{39496, 224768, 5, 1964},
	{39521, 224772, 4, 1958},
	{39547, 224776, 5, 1964},
	{39572, 224780, 4, 1958},
	{39598, 224784, 3, 2020},
	{39623, 224788, 3, 2020},
	{39648, 224832, 5, 1964},
	{39673, 224836, 4, 1958},
	{39699, 224840, 5, 1964},
	{39724, 224844, 4, 1958},
	{39750, 224848, 3, 2020},
	{39775, 224852, 3, 2020},
	{39800, 224896, 5, 1964},
	{39825, 224900, 4, 1958},
	{39851, 224904, 3, 2020},
	{39876, 224908, 3, 2020},
	{39901, 224912, 3, 2020},
	{39926, 225024, 5, 1964},
	{39950, 225028, 4, 1958},
	{39975, 225032, 3, 2020},
	{39999, 225036, 3, 2020},
	{40023, 225040, 3, 2020},
	{40047, 225048, 5, 1964},
	{40072, 225052, 4, 1958},
	{40098, 225056, 3, 2020},
	{40123, 225060, 3, 2020},
	{40148, 225064, 3, 2020},
	{40173, 225280, 12, 2023},
	{40195, 225284, 5, 1964},
	{40218, 225288, 4, 1969},
	{40242, 225292, 2, 3652},
	{40265, 225296, 2, 3652},
	{40288, 225300, 2, 3652},
	{40311, 225536, 5, 1964},
	{40334, 225540, 4, 1969},
	{40358, 225544, 5, 1964},
	{40381, 225548, 4, 1969},
	{40405, 225552, 5, 1964},
	{40428, 225560, 5, 1964},
	{40451, 225792, 5, 3654},
	{40472, 225796},
	{40501, 225800, 2, 2050},
	{40530, 225804},
	{40987, 225808, 2, 2077},
	{40585, 225812},
	{40604, 225816, 2, 2059},
	{40556, 225820, 3, 3659},
	{40676, 225824, 1, 3662},
	{40703, 225828, 2, 3663},
	{40630, 225832, 1, 3662},
	{40653, 225836, 2, 3663},
	{41006, 225864, 2, 2079},
	{41033, 225868},
	{45973, 225872, 2, 2079},
	{46004, 225876},
	{41060, 225880, 2, 2704},
	{41087, 225884, 2, 2083},
	{46035, 225888, 4, 2753},
	{41114, 225892, 18, 3665},
	{41135, 225896, 9, 2723},
	{41154, 225900, 22, 3683},
	{41173, 225904, 1, 2111},
	{41197, 225908, 1, 2113},
	{41229, 225912, 2, 2115},
	{46106, 225916, 3, 2757},
	{50368, 225928, 2, 3705},
	{50382, 225932, 10, 3707},
	{45843, 225936},
	{45816, 225940},
	{50397, 225972, 1, 3717},
	{50410, 225976},
	{50435, 225980, 1, 3718},
	{50460, 225984, 1, 3719},
	{50480, 225988},
	{50502, 225992, 2, 3720},
	{50522, 225996},
	{50550, 226000, 1, 3718},
	{50578, 226004, 1, 3719},
	{50601, 226008},
	{50626, 226012, 2, 3720},
	{50649, 226016, 1, 3722},
	{50666, 226020, 9, 3723},
	{50687, 226044},
	{41366, 226048, 2, 2126},
	{41383, 226052, 1, 2128},
	{41407, 226056, 1, 2128},
	{41431, 226060, 4, 2129},
	{41457, 226064, 3, 2133},
	{41486, 226068, 1, 694},
	{41515, 226072, 3, 2133},
	{41544, 226076, 1, 694},
	{41621, 226304, 5, 1964},
	{41645, 226308, 4, 1969},
	{41670, 226312, 2, 3652},
	{41694, 226316, 5, 1964},
	{41718, 226320, 4, 1969},
	{41743, 226324, 2, 3652},
	{41767, 226328, 10, 2137},
	{42132, 226432, 5, 1964},
	{42161, 226436, 5, 1964},
	{42190, 226440, 4, 1969},
	{42220, 226444, 4, 1969},
	{42250, 226448, 8, 1995},
	{42277, 226452, 8, 1995},
	{41875, 226496, 5, 2147},
	{41903, 226500, 5, 2147},
	{41931, 226504, 5, 2147},
	{41959, 226508, 5, 2147},
	{41987, 226512, 5, 2147},
	{42015, 226516, 5, 2147},
	{42043, 226520, 5, 2147},
	{42071, 226524, 5, 2147},
	{42099, 226528, 6, 2152},
	{46147, 226532, 5, 2147},
	{46172, 226536, 5, 2147},
	{46197, 226540, 5, 2147},
	{46222, 226544, 5, 2147},
	{46247, 226548, 6, 2152},
	{42393, 226688, 5, 1964},
	{42417, 226692, 4, 1969},
	{42442, 226696, 3, 2020},
	{42518, 226816, 5, 1964},
	{42544, 226820, 4, 1969},
	{42571, 226824, 5, 1964},
	{42597, 226828, 5, 1964},
	{42623, 226832, 5, 1964},
	{42649, 226836, 1, 1879},
	{42675, 226840, 1, 1879},
	{42701, 226844, 1, 1879},
	{42727, 226848, 1, 1879},
	{42753, 226880, 4, 1969},
	{42780, 226884, 4, 1969},
	{42807, 226888, 4, 1969},
	{42466, 226944, 2, 2161},
	{42492, 226948, 2, 2161},
	{50701, 226952, 2, 2161},
	{50727, 226956, 2, 2161},
	{42834, 227072, 5, 1964},
	{42859, 227076, 4, 1958},
	{42885, 227080, 3, 2020},
	{42910, 227084, 3, 2020},
	{42935, 227088, 3, 2020},
	{50753, 227136, 5, 1964},
	{50778, 227140, 4, 1958},
	{50804, 227144, 3, 2020},
	{50829, 227148, 3, 2020},
	{50854, 227152, 3, 2020},
	{42960, 227200, 5, 1964},
	{42984, 227204, 4, 1958},
	{43009, 227208, 3, 2020},
	{43033, 227212, 3, 2020},
	{43057, 227216, 3, 2020},
	{43081, 227328, 5, 1964},
	{43105, 227332, 4, 1969},
	{43130, 227336, 8, 1995},
	{46277, 227340, 5, 2147},
	{46298, 227344, 5, 2147},
	{46319, 227348, 6, 2152},
	{46345, 227456, 5, 2147},
	{46376, 227460, 5, 2147},
	{46407, 227464, 6, 2152},
	{46443, 227468, 1, 2760},
	{46467, 227472, 5, 1964},
	{46493, 227476, 4, 1969},
	{46520, 227480, 5, 1964},
	{46546, 227484, 4, 1969},
	{46573, 227504, 5, 2147},
	{46604, 227508, 5, 2147},
	{46635, 227512, 6, 2152},
	{46671, 227516, 1, 2760},
	{46695, 227520, 5, 1964},
	{46721, 227524, 4, 1969},
	{46748, 227528, 5, 1964},
	{46774, 227532, 4, 1969},
	{206, 880, 4, 2163},
	{43152, 881},
	{26999, 882},
	{43164, 1008},
	{43175, 1009},
	{27187, 1010, 4, 2167},
	{43186, 1040, 1, 2171},
	{43199, 1041, 5, 2172},
	{43212, 1042, 1, 2177},
	{43225, 1043, 1, 1688},
	{27021, 1045, 7, 2178},
	{43238, 1168, 18, 3732},
	{43253, 1281, 6, 2197},
	{43268, 1282},
	{26958, 1283},
	{43152, 1285},
	{26999, 1286},
	{50879, 1408, 4, 3750},
	{50897, 1413, 1, 3754},
	{43280, 1414, 15, 2203},
};

static const struct si_reg gfx115_reg_table[] = {
	{43289, 40, 1, 2218},
	{43304, 44, 1, 2218},
	{1310, 1028, 10, 2761},
	{1323, 1032, 26, 2771},
	{1338, 1036, 11, 2797},
	{1375, 1044, 2, 2808},
	{1393, 1048, 3, 56},
	{1411, 1052, 4, 2810},
	{1426, 1056},
	{1440, 1060, 1, 70},
	{1471, 1076, 2, 78},
	{1487, 1080},
	{1882, 1104},
	{1906, 1108},
	{1504, 1116, 6, 2814},
	{1519, 1120, 6, 85},
	{1534, 1124, 2, 92},
	{1554, 1128, 1, 94},
	{1593, 1136, 4, 2820},
	{43327, 1140, 1, 2237},
	{1609, 2480},
	{1623, 2484},
	{1637, 2488},
	{1651, 2492},
	{1665, 2496},
	{1679, 2500},
	{1693, 2504},
	{1707, 2508},
	{1721, 2512},
	{1735, 2516},
	{1749, 2520},
	{1764, 2524},
	{1779, 2528},
	{1794, 2532},
	{1809, 2536},
	{1824, 2540},
	{1839, 2548},
	{1850, 2552},
	{1866, 2556},
	{1954, 32776, 22, 3755},
	{1967, 32784, 22, 2846},
	{1979, 32788, 16, 3777},
	{2011, 32796, 14, 3793},
	{47289, 33280, 1, 2900},
	{47307, 33284},
	{2056, 33296, 23, 2901},
	{2070, 33300, 28, 2924},
	{2087, 33304, 16, 2952},
	{2108, 33308, 28, 247},
	{2122, 33312, 32, 275},
	{2139, 33316, 13, 307},
	{2160, 33320, 9, 320},
	{2178, 33324, 1, 329},
	{2201, 33344, 2, 330},
	{2222, 33348},
	{2242, 33352, 1, 332},
	{2265, 33356, 11, 2969},
	{2283, 33436, 1, 342},
	{2847, 39160, 6, 2344},
	{3786, 41136, 12, 3807},
	{3818, 45060, 5, 3037},
	{3842, 45080},
	{3867, 45084, 3, 3042},
	{3891, 45088},
	{3912, 45092, 1, 498},
	{3933, 45096, 12, 2372},
	{3957, 45100, 10, 510},
	{3981, 45104},
	{4007, 45108},
	{4033, 45112},
	{4059, 45116},
	{4085, 45120},
	{4111, 45124},
	{4137, 45128},
	{4163, 45132},
	{4189, 45136},
	{4215, 45140},
	{4241, 45144},
	{4268, 45148},
	{4295, 45152},
	{4322, 45156},
	{4349, 45160},
	{4376, 45164},
	{4403, 45168},
	{4430, 45172},
	{4457, 45176},
	{4484, 45180},
	{4511, 45184},
	{4538, 45188},
	{4565, 45192},
	{4592, 45196},
	{4619, 45200},
	{4646, 45204},
	{4673, 45208},
	{4700, 45212},
	{4727, 45216},
	{4754, 45220},
	{4781, 45224},
	{4808, 45228},
	{4835, 45248, 8, 520},
	{4891, 45256, 1, 533},
	{4918, 45260, 1, 533},
	{4945, 45264, 1, 533},
	{4972, 45268, 1, 533},
	{6286, 45568},
	{6311, 45572, 9, 3045},
	{6335, 45576},
	{6367, 45580},
	{6399, 45584},
	{6423, 45588, 1, 498},
	{6447, 45596, 4, 583},
	{6471, 45600},
	{6492, 45604, 1, 498},
	{6513, 45608, 13, 587},
	{6537, 45612, 9, 600},
	{6561, 45616},
	{6587, 45620},
	{6613, 45624},
	{6639, 45628},
	{6665, 45632},
	{6691, 45636},
	{6717, 45640},
	{6743, 45644},
	{6769, 45648},
	{6795, 45652},
	{6821, 45656},
	{6848, 45660},
	{6875, 45664},
	{6902, 45668},
	{6929, 45672},
	{6956, 45676},
	{6983, 45680},
	{7010, 45684},
	{7037, 45688},
	{7064, 45692},
	{7091, 45696},
	{7118, 45700},
	{7145, 45704},
	{7172, 45708},
	{7199, 45712},
	{7226, 45716},
	{7253, 45720},
	{7280, 45724},
	{7307, 45728},
	{7334, 45732},
	{7361, 45736},
	{7388, 45740},
	{47325, 45744, 4, 3054},
	{47351, 45748, 2, 3058},
	{7415, 45760, 8, 520},
	{7475, 45768, 1, 533},
	{7504, 45772, 1, 533},
	{7533, 45776, 1, 533},
	{7562, 45780, 1, 533},
	{7642, 45856},
	{7663, 45860, 1, 498},
	{8181, 46080},
	{8206, 46084, 5, 3037},
	{8230, 46088},
	{8262, 46092},
	{8294, 46096},
	{8318, 46100, 1, 498},
	{8342, 46108, 4, 619},
	{8366, 46112},
	{8387, 46116, 1, 498},
	{8408, 46120, 12, 623},
	{8432, 46124, 9, 635},
	{8456, 46128},
	{8482, 46132},
	{8508, 46136},
	{8534, 46140},
	{8560, 46144},
	{8586, 46148},
	{8612, 46152},
	{8638, 46156},
	{8664, 46160},
	{8690, 46164},
	{8716, 46168},
	{8743, 46172},
	{8770, 46176},
	{8797, 46180},
	{8824, 46184},
	{8851, 46188},
	{8878, 46192},
	{8905, 46196},
	{8932, 46200},
	{8959, 46204},
	{8986, 46208},
	{9013, 46212},
	{9040, 46216},
	{9067, 46220},
	{9094, 46224},
	{9121, 46228},
	{9148, 46232},
	{9175, 46236},
	{9202, 46240},
	{9229, 46244},
	{9256, 46248},
	{9283, 46252},
	{9310, 46272, 8, 520},
	{9370, 46280, 1, 533},
	{9399, 46284, 1, 533},
	{9428, 46288, 1, 533},
	{9457, 46292, 1, 533},
	{9537, 46368},
	{9558, 46372, 1, 498},
	{10049, 47104, 15, 3060},
	{10076, 47108},
	{10090, 47112},
	{10104, 47116},
	{10118, 47120},
	{10134, 47124},
	{10150, 47128},
	{10166, 47132, 2, 666},
	{10187, 47136, 2, 666},
	{10208, 47140, 2, 666},
	{10229, 47144, 1, 668},
	{10257, 47148, 1, 669},
	{10282, 47152},
	{10297, 47156, 1, 670},
	{10312, 47160},
	{10341, 47164, 1, 670},
	{10370, 47168},
	{10403, 47172, 1, 670},
	{10436, 47176, 12, 671},
	{10454, 47180, 11, 683},
	{10472, 47184, 1, 694},
	{10485, 47188, 6, 695},
	{10509, 47192},
	{10536, 47196},
	{10563, 47200, 2, 3075},
	{10584, 47204},
	{10611, 47208},
	{10638, 47212},
	{10656, 47216},
	{10674, 47220},
	{10692, 47224, 1, 703},
	{10720, 47228, 4, 3077},
	{10742, 47232},
	{10762, 47236},
	{10785, 47240, 9, 709},
	{10802, 47248, 1, 533},
	{10823, 47252, 1, 533},
	{10844, 47256, 1, 533},
	{10865, 47260, 1, 533},
	{10886, 47264, 5, 3081},
	{10904, 47268, 1, 719},
	{10923, 47272},
	{47383, 47276, 2, 3086},
	{47414, 47280, 2, 3086},
	{47445, 47284, 2, 3086},
	{47476, 47288, 2, 3086},
	{47507, 47292, 1, 3088},
	{10945, 47296, 3, 720},
	{10962, 47300},
	{10991, 47304, 1, 723},
	{11020, 47308, 3, 720},
	{11038, 47360},
	{11058, 47364},
	{11078, 47368},
	{11098, 47372},
	{11118, 47376},
	{11138, 47380},
	{11158, 47384},
	{11178, 47388},
	{11198, 47392},
	{11218, 47396},
	{11238, 47400},
	{11259, 47404},
	{11280, 47408},
	{11301, 47412},
	{11322, 47416},
	{11343, 47420},
	{11364, 47604, 2, 724},
	{11388, 47608},
	{11409, 47612},
	{11425, 163840, 15, 3089},
	{11443, 163844, 10, 737},
	{11460, 163848, 7, 747},
	{11474, 163852, 22, 3104},
	{11493, 163856, 18, 3126},
	{11513, 163860},
	{11532, 163868, 2, 793},
	{11549, 163872},
	{11569, 163876},
	{11589, 163880, 1, 795},
	{11606, 163884},
	{11621, 163888, 2, 796},
	{11645, 163892, 2, 798},
	{11685, 163900, 8, 3144},
	{11703, 163904, 14, 811},
	{11713, 163908, 9, 825},
	{11729, 163912},
	{11744, 163916},
	{11765, 163920},
	{11781, 163924},
	{11803, 163928, 2, 834},
	{11821, 163932, 1, 836},
	{50915, 163936, 8, 3819},
	{11839, 163944, 1, 837},
	{11857, 163948, 1, 837},
	{11881, 163952, 1, 837},
	{11900, 163956, 1, 837},
	{11925, 163960, 1, 837},
	{11947, 163964, 13, 3152},
	{11971, 163968},
	{11987, 163972, 1, 847},
	{12006, 164328, 1, 848},
	{12027, 164332, 1, 848},
	{12048, 164336, 1, 848},
	{12069, 164340, 1, 848},
	{12090, 164344},
	{12108, 164348},
	{12126, 164352, 2, 849},
	{12146, 164356, 3, 851},
	{12170, 164360, 2, 854},
	{12194, 164364, 1, 856},
	{12214, 164368, 2, 851},
	{12234, 164372, 2, 854},
	{12254, 164376, 2, 851},
	{12274, 164380, 2, 854},
	{12294, 164384, 2, 851},
	{12314, 164388, 2, 854},
	{12334, 164392, 2, 851},
	{12354, 164396, 2, 854},
	{12374, 164400, 7, 857},
	{12389, 164404, 2, 864},
	{12418, 164408, 8, 866},
	{12433, 164412, 8, 874},
	{12448, 164416, 3, 851},
	{12473, 164420, 2, 854},
	{12498, 164424},
	{12516, 164428},
	{12534, 164432, 3, 851},
	{12559, 164436, 2, 854},
	{12584, 164440, 3, 851},
	{12609, 164444, 2, 854},
	{12634, 164448, 3, 851},
	{12659, 164452, 2, 854},
	{12684, 164456, 3, 851},
	{12709, 164460, 2, 854},
	{12734, 164464, 3, 851},
	{12759, 164468, 2, 854},
	{12784, 164472, 3, 851},
	{12809, 164476, 2, 854},
	{12834, 164480, 3, 851},
	{12859, 164484, 2, 854},
	{12884, 164488, 3, 851},
	{12909, 164492, 2, 854},
	{12934, 164496, 3, 851},
	{12959, 164500, 2, 854},
	{12984, 164504, 3, 851},
	{13009, 164508, 2, 854},
	{13034, 164512, 3, 851},
	{13060, 164516, 2, 854},
	{13086, 164520, 3, 851},
	{13112, 164524, 2, 854},
	{13138, 164528, 3, 851},
	{13164, 164532, 2, 854},
	{13190, 164536, 3, 851},
	{13216, 164540, 2, 854},
	{13242, 164544, 3, 851},
	{13268, 164548, 2, 854},
	{13294, 164552, 3, 851},
	{13320, 164556, 2, 854},
	{13346, 164560},
	{13365, 164564},
	{13384, 164568},
	{13403, 164572},
	{13422, 164576},
	{13441, 164580},
	{13460, 164584},
	{13479, 164588},
	{13498, 164592},
	{13517, 164596},
	{13536, 164600},
	{13555, 164604},
	{13574, 164608},
	{13593, 164612},
	{13612, 164616},
	{13631, 164620},
	{13650, 164624},
	{13669, 164628},
	{13688, 164632},
	{13707, 164636},
	{13726, 164640},
	{13746, 164644},
	{13766, 164648},
	{13786, 164652},
	{13806, 164656},
	{13826, 164660},
	{13846, 164664},
	{13866, 164668},
	{13886, 164672},
	{13906, 164676},
	{13926, 164680},
	{13946, 164684},
	{13966, 164688, 15, 882},
	{13986, 164692, 3, 897},
	{14008, 164696, 2, 900},
	{14036, 164700, 4, 3165},
	{14065, 164704, 1, 909},
	{14086, 164708, 1, 910},
	{14096, 164712, 1, 911},
	{43421, 164716},
	{43443, 164720},
	{47535, 164816, 5, 3169},
	{47559, 164820},
	{47588, 164824, 1, 1622},
	{47621, 164828, 2, 3174},
	{47653, 164836, 11, 3176},
	{47679, 164848},
	{47699, 164852, 2, 3187},
	{47723, 164856, 2, 3174},
	{14214, 164876},
	{14243, 164880, 7, 3189},
	{14268, 164884},
	{14281, 164888},
	{14296, 164892},
	{14310, 164896},
	{47746, 164900, 8, 3196},
	{14340, 164904, 4, 938},
	{14364, 164908, 6, 942},
	{14383, 164912, 4, 948},
	{14401, 164916, 4, 952},
	{14422, 164924},
	{14441, 164928},
	{14461, 164932},
	{14480, 164936},
	{14500, 164940},
	{14519, 164944},
	{14539, 164948},
	{14560, 164952},
	{14582, 164956},
	{14603, 164960},
	{14625, 164964},
	{14646, 164968},
	{14668, 164972},
	{14689, 164976},
	{14711, 164980},
	{14732, 164984},
	{14754, 164988},
	{14775, 164992},
	{14797, 164996},
	{14818, 165000},
	{14840, 165004},
	{14861, 165008},
	{14883, 165012},
	{14904, 165016},
	{14926, 165020},
	{14947, 165024},
	{14969, 165028},
	{14990, 165032},
	{15012, 165036},
	{15033, 165040},
	{15055, 165044},
	{15076, 165048},
	{15098, 165052},
	{15119, 165056},
	{15141, 165060},
	{15162, 165064},
	{15184, 165068},
	{15205, 165072},
	{15227, 165076},
	{15248, 165080},
	{15270, 165084},
	{15291, 165088},
	{15313, 165092},
	{15334, 165096},
	{15356, 165100},
	{15377, 165104},
	{15399, 165108},
	{15420, 165112},
	{15442, 165116},
	{15463, 165120},
	{15485, 165124},
	{15506, 165128},
	{15528, 165132},
	{15549, 165136},
	{15571, 165140},
	{15592, 165144},
	{15614, 165148},
	{15635, 165152},
	{15657, 165156},
	{15678, 165160},
	{15700, 165164},
	{15722, 165168},
	{15745, 165172},
	{15767, 165176},
	{15790, 165180},
	{15812, 165184},
	{15835, 165188},
	{15857, 165192},
	{15880, 165196},
	{15902, 165200},
	{15925, 165204},
	{15947, 165208},
	{15970, 165212},
	{15992, 165216},
	{16015, 165220},
	{16037, 165224},
	{16060, 165228},
	{16082, 165232},
	{16105, 165236},
	{16127, 165240},
	{16150, 165244},
	{16172, 165248},
	{16195, 165252},
	{16217, 165256},
	{16240, 165260},
	{16262, 165264},
	{16285, 165268},
	{16307, 165272},
	{16330, 165276},
	{16352, 165280},
	{16375, 165284},
	{16397, 165288},
	{16420, 165292},
	{16442, 165296},
	{16465, 165300},
	{16487, 165304},
	{16510, 165308},
	{16524, 165312},
	{16538, 165316},
	{16552, 165320},
	{16566, 165324},
	{16580, 165328},
	{16594, 165332},
	{16608, 165336},
	{16622, 165340},
	{16636, 165344},
	{16650, 165348},
	{16664, 165352},
	{16678, 165356},
	{16692, 165360},
	{16706, 165364},
	{16720, 165368},
	{16734, 165372},
	{16748, 165376},
	{16762, 165380},
	{16776, 165384},
	{16790, 165388},
	{16804, 165392},
	{16818, 165396},
	{16832, 165400},
	{16846, 165404},
	{47762, 165408, 2, 3204},
	{16869, 165444, 13, 3206},
	{16889, 165448, 13, 3206},
	{16909, 165452, 13, 3206},
	{16929, 165456, 13, 3206},
	{16949, 165460, 13, 3206},
	{16969, 165464, 13, 3206},
	{16989, 165468, 13, 3206},
	{17009, 165472, 13, 3206},
	{17029, 165476, 13, 3206},
	{17049, 165480, 13, 3206},
	{17069, 165484, 13, 3206},
	{17090, 165488, 13, 3206},
	{17111, 165492, 13, 3206},
	{17132, 165496, 13, 3206},
	{17153, 165500, 13, 3206},
	{17174, 165504, 13, 3206},
	{17195, 165508, 13, 3206},
	{17216, 165512, 13, 3206},
	{17237, 165516, 13, 3206},
	{17258, 165520, 13, 3206},
	{17279, 165524, 11, 3219},
	{17300, 165528, 11, 3219},
	{17321, 165532, 11, 3219},
	{17342, 165536, 11, 3219},
	{17363, 165540, 11, 3219},
	{17384, 165544, 11, 3219},
	{17405, 165548, 11, 3219},
	{17426, 165552, 11, 3219},
	{17447, 165556, 11, 3219},
	{17468, 165560, 11, 3219},
	{17489, 165564, 11, 3219},
	{17510, 165568, 11, 3219},
	{17531, 165572, 3, 3230},
	{17549, 165580, 16, 980},
	{17566, 165584, 16, 980},
	{17584, 165588, 7, 996},
	{17605, 165592, 7, 3233},
	{50942, 165596, 2, 3827},
	{17623, 165600, 7, 1009},
	{17638, 165608, 2, 3075},
	{47775, 165612},
	{47799, 165616, 1, 670},
	{17655, 165640, 1, 1016},
	{17677, 165644, 5, 1017},
	{17699, 165648, 1, 1022},
	{17719, 165652, 8, 1023},
	{43465, 165712, 8, 2482},
	{17741, 165716, 8, 3240},
	{17759, 165720, 8, 1039},
	{17780, 165724, 17, 1047},
	{17801, 165728, 6, 1064},
	{17819, 165732, 6, 1064},
	{17837, 165736, 6, 1064},
	{17855, 165740, 6, 1064},
	{17873, 165744, 6, 1064},
	{17891, 165748, 6, 1064},
	{17909, 165752, 6, 1064},
	{17927, 165756, 6, 1064},
	{17945, 165760, 9, 3248},
	{17963, 165764, 9, 3248},
	{17981, 165768, 9, 3248},
	{17999, 165772, 9, 3248},
	{18017, 165776, 9, 3248},
	{18035, 165780, 9, 3248},
	{18053, 165784, 9, 3248},
	{18071, 165788, 9, 3248},
	{18103, 165840, 1, 1079},
	{18118, 165844},
	{18136, 165848},
	{18154, 165852},
	{18171, 165856},
	{18192, 165860, 1, 1080},
	{18208, 165864},
	{18221, 165872, 6, 2498},
	{18255, 165880, 1, 1089},
	{18277, 165884, 1, 1090},
	{18304, 165888, 10, 1091},
	{18321, 165892, 12, 1101},
	{18329, 165896, 5, 3257},
	{18346, 165900, 18, 3262},
	{18364, 165904, 20, 1134},
	{18380, 165908, 16, 1154},
	{18399, 165912, 10, 1170},
	{18414, 165916, 29, 3280},
	{18432, 165920, 16, 1208},
	{18450, 165924, 3, 1224},
	{18474, 165928},
	{18499, 165932, 11, 1228},
	{18522, 165936, 6, 3829},
	{18573, 165944, 3, 2539},
	{18588, 165948, 5, 1250},
	{18618, 165952, 5, 1255},
	{18633, 165956},
	{43491, 165960, 6, 2542},
	{18651, 166400, 2, 1260},
	{18668, 166404, 2, 1262},
	{18687, 166408, 1, 1264},
	{18703, 166412, 4, 1265},
	{18756, 166424},
	{18779, 166428},
	{19005, 166472, 6, 2548},
	{19023, 166476, 24, 1317},
	{19041, 166480},
	{19185, 166512},
	{19196, 166516},
	{19209, 166520},
	{19226, 166524, 9, 2554},
	{19245, 166528},
	{19256, 166532, 3, 1358},
	{19275, 166536},
	{19297, 166540},
	{19319, 166544, 3, 3309},
	{19366, 166552, 4, 2563},
	{19457, 166572, 1, 1377},
	{19503, 166580, 1, 1378},
	{19532, 166588, 9, 1380},
	{19549, 166592, 4, 1389},
	{19576, 166596, 4, 1393},
	{19603, 166600, 4, 1397},
	{19938, 166696},
	{19969, 166700},
	{20012, 166704, 1, 1402},
	{20050, 166712, 1, 1403},
	{20070, 166732, 2, 1404},
	{20089, 166736, 5, 1406},
	{20111, 166740, 17, 3312},
	{20132, 166744, 3, 1430},
	{20239, 166764, 12, 3835},
	{20252, 166768, 6, 1445},
	{20293, 166776, 2, 1451},
	{20323, 166780},
	{20347, 166784},
	{20377, 166788},
	{20408, 166792},
	{20437, 166796},
	{20467, 166800, 3, 1453},
	{20556, 166868, 8, 1468},
	{20582, 166872, 8, 1476},
	{20608, 166876, 5, 1484},
	{20624, 166880, 8, 2597},
	{20640, 166884, 3, 1495},
	{20655, 166888},
	{20678, 166892},
	{20701, 166896},
	{20724, 166900},
	{20747, 166904, 8, 1498},
	{20781, 166908, 8, 1506},
	{20815, 166912, 8, 1514},
	{20849, 166916, 8, 1522},
	{20883, 166920, 8, 1498},
	{20917, 166924, 8, 1506},
	{20951, 166928, 8, 1514},
	{20985, 166932, 8, 1522},
	{21019, 166936, 8, 1498},
	{21053, 166940, 8, 1506},
	{21087, 166944, 8, 1514},
	{21121, 166948, 8, 1522},
	{21155, 166952, 8, 1498},
	{21189, 166956, 8, 1506},
	{21223, 166960, 8, 1514},
	{21257, 166964, 8, 1522},
	{21291, 166968, 2, 1530},
	{21315, 166972, 2, 1532},
	{21339, 166976, 5, 3340},
	{21360, 166980, 12, 3847},
	{21380, 166984, 2, 1550},
	{21400, 166988, 20, 1552},
	{21438, 166992, 6, 3357},
	{47823, 166996, 14, 3859},
	{50962, 167000, 1, 3873},
	{21507, 167008},
	{21554, 167020, 3, 1579},
	{21569, 167024, 10, 3373},
	{21584, 167028, 5, 3383},
	{47843, 167032, 17, 3388},
	{21743, 167060},
	{21762, 167068},
	{21809, 167080, 3, 1579},
	{21824, 167084, 10, 3373},
	{21839, 167088, 5, 3383},
	{47866, 167092, 17, 3388},
	{21998, 167120},
	{22017, 167128},
	{22064, 167140, 3, 1579},
	{22079, 167144, 10, 3373},
	{22094, 167148, 5, 3383},
	{47889, 167152, 17, 3388},
	{22253, 167180},
	{22272, 167188},
	{22319, 167200, 3, 1579},
	{22334, 167204, 10, 3373},
	{22349, 167208, 5, 3383},
	{47912, 167212, 17, 3388},
	{22508, 167240},
	{22527, 167248},
	{22574, 167260, 3, 1579},
	{22589, 167264, 10, 3373},
	{22604, 167268, 5, 3383},
	{47935, 167272, 17, 3388},
	{22763, 167300},
	{22782, 167308},
	{22829, 167320, 3, 1579},
	{22844, 167324, 10, 3373},
	{22859, 167328, 5, 3383},
	{47958, 167332, 17, 3388},
	{23018, 167360},
	{23037, 167368},
	{23084, 167380, 3, 1579},
	{23099, 167384, 10, 3373},
	{23114, 167388, 5, 3383},
	{47981, 167392, 17, 3388},
	{23273, 167420},
	{23292, 167428},
	{23339, 167440, 3, 1579},
	{23354, 167444, 10, 3373},
	{23369, 167448, 5, 3383},
	{48004, 167452, 17, 3388},
	{23528, 167480},
	{23547, 167488, 1, 1622},
	{23566, 167492, 1, 1622},
	{23585, 167496, 1, 1622},
	{23604, 167500, 1, 1622},
	{23623, 167504, 1, 1622},
	{23642, 167508, 1, 1622},
	{23661, 167512, 1, 1622},
	{23680, 167516, 1, 1622},
	{24099, 167584, 1, 1622},
	{24122, 167588, 1, 1622},
	{24145, 167592, 1, 1622},
	{24168, 167596, 1, 1622},
	{24191, 167600, 1, 1622},
	{24214, 167604, 1, 1622},
	{24237, 167608, 1, 1622},
	{24260, 167612, 1, 1622},
	{24283, 167616, 3, 1623},
	{24301, 167620, 3, 1623},
	{24319, 167624, 3, 1623},
	{24337, 167628, 3, 1623},
	{24355, 167632, 3, 1623},
	{24373, 167636, 3, 1623},
	{24391, 167640, 3, 1623},
	{24409, 167644, 3, 1623},
	{24427, 167648, 5, 3405},
	{24445, 167652, 5, 3405},
	{24463, 167656, 5, 3405},
	{24481, 167660, 5, 3405},
	{24499, 167664, 5, 3405},
	{24517, 167668, 5, 3405},
	{24535, 167672, 5, 3405},
	{24553, 167676, 5, 3405},
	{24571, 196608, 1, 1634},
	{24591, 196612, 1, 1635},
	{24611, 196616},
	{24631, 196620},
	{24651, 196624},
	{24672, 196628},
	{25209, 196704, 1, 1638},
	{25231, 196708, 1, 1639},
	{25253, 196712},
	{25276, 196716},
	{25299, 196720},
	{25322, 196724},
	{25345, 196728},
	{25368, 196732},
	{25391, 196736},
	{25415, 196740},
	{25439, 196744},
	{25463, 196748},
	{25487, 196752},
	{25511, 196756},
	{25535, 196760},
	{25559, 196764},
	{25583, 196768},
	{25605, 196772},
	{25627, 196776},
	{25648, 196780},
	{25669, 196784},
	{25693, 196788},
	{25717, 196792},
	{25741, 196796},
	{25765, 196800},
	{25789, 196804},
	{48027, 196808},
	{48051, 196812},
	{25873, 196852, 1, 1641},
	{25933, 196864},
	{25946, 196868},
	{25959, 196872},
	{25972, 196876},
	{25985, 196880},
	{25998, 196884},
	{26011, 196888},
	{26024, 196892},
	{43506, 196896, 5, 2647},
	{26060, 196908, 1, 670},
	{26079, 196912},
	{26097, 196916},
	{26124, 196920},
	{26177, 196936},
	{26200, 196940},
	{26223, 196944},
	{26251, 196948},
	{26279, 196952},
	{26307, 196956},
	{26335, 196960, 1, 1645},
	{26353, 196964, 6, 3410},
	{26371, 196968},
	{26386, 196972},
	{26410, 196976},
	{26434, 196980},
	{26453, 196984},
	{26472, 196988},
	{26496, 196992},
	{26520, 196996},
	{26544, 197000},
	{26568, 197028, 1, 1650},
	{26586, 197032, 7, 3416},
	{26604, 197036},
	{26622, 197040},
	{26640, 197044, 1, 1653},
	{26658, 197048, 5, 3423},
	{26676, 197052},
	{26694, 197056, 2, 2652},
	{26713, 197060, 5, 1658},
	{26732, 197072},
	{26756, 197076, 2, 2652},
	{26776, 197080, 5, 1658},
	{26796, 197084, 9, 3428},
	{26815, 197088, 9, 3428},
	{26929, 197120},
	{26948, 197124, 1, 1687},
	{26970, 197128},
	{26989, 197132, 1, 1688},
	{27011, 197136, 7, 1689},
	{27029, 197140},
	{27049, 197144, 1, 1687},
	{27072, 197148},
	{27092, 197152, 1, 1688},
	{27115, 197156, 7, 1689},
	{27134, 197160, 7, 1696},
	{27146, 197164, 2, 1703},
	{27180, 197172, 1, 1706},
	{27198, 197176, 6, 3437},
	{27218, 197180, 2, 330},
	{27235, 197184},
	{27251, 197188, 1, 1713},
	{27264, 197192, 1, 1714},
	{27278, 197196, 1, 1715},
	{27292, 197200, 1, 1716},
	{27314, 197204, 1, 1717},
	{27334, 197208, 1, 1718},
	{27356, 197212, 1, 1719},
	{27424, 197232, 2, 1720},
	{27446, 197236, 2, 1722},
	{27468, 197240, 2, 1720},
	{27491, 197244, 2, 1722},
	{27514, 197248, 2, 1720},
	{27536, 197252, 2, 1722},
	{43525, 197256},
	{43547, 197260},
	{48075, 197264},
	{48097, 197268},
	{48119, 197272},
	{48142, 197276},
	{27619, 197376, 1, 1725},
	{27636, 197380, 1, 1726},
	{27653, 197384, 1, 1727},
	{27828, 197424, 1, 1731},
	{27843, 197428, 1, 1732},
	{27858, 197432, 1, 1733},
	{27871, 197436, 1, 1734},
	{27886, 197440, 1, 1735},
	{27901, 197444, 1, 1736},
	{27914, 197448, 1, 1737},
	{27928, 197452, 1, 1738},
	{27942, 197456, 1, 1739},
	{27954, 197460, 6, 3443},
	{27977, 197464, 6, 3449},
	{27999, 197468, 1, 1747},
	{28019, 197472, 1, 1748},
	{28033, 197476, 1, 1749},
	{28047, 197480, 1, 1750},
	{28059, 197484, 1, 1751},
	{28143, 197552, 1, 1752},
	{28192, 197560, 1, 1753},
	{28212, 197568},
	{28238, 197572, 1, 1635},
	{28320, 197584},
	{28343, 197588, 1, 1635},
	{28369, 197592},
	{28391, 197596, 1, 1635},
	{28416, 197600},
	{28435, 197604, 1, 1635},
	{28457, 197608, 1, 1350},
	{28471, 197612},
	{28488, 197616, 1, 1635},
	{28508, 197620, 8, 1754},
	{28525, 197624, 13, 1762},
	{28542, 197628},
	{28559, 197632, 1, 1705},
	{28579, 197636},
	{28596, 197640, 1, 1670},
	{28616, 197644, 2, 1775},
	{28635, 197888, 8, 1777},
	{28656, 197892, 8, 1777},
	{28677, 198656, 6, 3874},
	{28730, 198920, 1, 3455},
	{28749, 198924, 2, 2664},
	{28896, 198948},
	{28912, 198952},
	{28927, 198956, 3, 3456},
	{28953, 198960},
	{28969, 198964},
	{28987, 198968, 1, 3459},
	{29004, 198972, 2, 2666},
	{29025, 198976},
	{29205, 199012},
	{29221, 199016},
	{29242, 199020, 8, 3460},
	{29250, 199024},
	{29264, 199028},
	{29278, 199032},
	{29292, 199036, 3, 1808},
	{29307, 199040, 2, 1811},
	{29319, 199044, 1, 837},
	{29341, 199048, 3, 1813},
	{43721, 199052, 2, 2668},
	{48165, 199056, 2, 3468},
	{48190, 199060, 1, 3470},
	{19164, 199064, 1, 3471},
	{29357, 199168, 1, 1816},
	{29382, 199172, 2, 1817},
	{29407, 199184, 2, 1819},
	{29433, 199188, 2, 1819},
	{29459, 199192, 2, 1819},
	{29485, 199212, 2, 1819},
	{29511, 199296, 2, 1821},
	{29539, 199300, 1, 1823},
	{29563, 199304, 1, 1824},
	{29587, 199308, 1, 1825},
	{29620, 199312, 1, 1825},
	{29648, 199328, 2, 1821},
	{29677, 199332, 1, 1823},
	{29702, 199336, 1, 1824},
	{29727, 199340, 1, 1825},
	{29761, 199344, 1, 1825},
	{29790, 199360, 2, 1821},
	{29814, 199364, 1, 1823},
	{29834, 199368, 1, 1824},
	{29854, 199372, 1, 1825},
	{29883, 199376, 1, 1825},
	{29907, 199936},
	{29934, 199940},
	{29961, 199944},
	{29988, 199948},
	{30015, 199952},
	{30042, 199956},
	{30069, 199960},
	{30096, 199964},
	{30123, 199968, 4, 2670},
	{30148, 200192},
	{30167, 200196, 1, 847},
	{30189, 200448},
	{30213, 200452, 1, 1835},
	{30236, 200456},
	{30260, 200460, 1, 1835},
	{30283, 200464},
	{30307, 200468, 1, 1835},
	{30330, 200472},
	{30354, 200476, 1, 1835},
	{30414, 200704},
	{30426, 200708},
	{30438, 200712},
	{30456, 200716},
	{30475, 200720},
	{30493, 200724},
	{30505, 200728},
	{30517, 200732},
	{30535, 200736},
	{30553, 200740},
	{30572, 200744, 4, 1836},
	{30586, 200748, 2, 1840},
	{30604, 200752, 2, 3472},
	{30618, 200756, 2, 3474},
	{30632, 200760, 2, 1846},
	{30649, 200764, 2, 1848},
	{30666, 200768},
	{30679, 200772, 2, 1850},
	{30691, 200776},
	{30705, 200780},
	{30721, 200784},
	{30735, 200788},
	{30751, 200792},
	{30766, 200796},
	{30783, 200800},
	{30798, 200804},
	{30815, 200808, 2, 1852},
	{30837, 200812, 9, 3476},
	{30854, 200816, 2, 1864},
	{30875, 200820, 2, 1866},
	{30887, 200824},
	{30902, 200828, 6, 1868},
	{30917, 200832, 2, 1874},
	{30931, 200836},
	{48217, 200840},
	{48246, 200844},
	{48275, 200848},
	{48304, 200852},
	{48333, 200856},
	{48342, 200860},
	{48351, 200864},
	{48360, 200868},
	{48369, 200872},
	{48399, 200876},
	{48429, 200880},
	{48460, 200884},
	{48491, 200888},
	{48521, 200892},
	{48551, 200896},
	{48582, 200900},
	{48613, 200904},
	{48643, 200908},
	{48673, 200912},
	{48704, 200916},
	{48735, 200920},
	{48765, 200924},
	{48795, 200928},
	{48826, 200932},
	{2831, 200960, 7, 3485},
	{48857, 200964, 13, 3492},
	{48875, 200968, 7, 3505},
	{48893, 200972, 3, 3512},
	{48913, 200976, 8, 3515},
	{48935, 200980, 8, 3523},
	{48957, 200984},
	{48981, 200988, 6, 3531},
	{31044, 212992},
	{31064, 212996},
	{31084, 213000},
	{31104, 213004},
	{31124, 213008},
	{31144, 213012},
	{31164, 213016},
	{31184, 213020},
	{31204, 213024},
	{31224, 213028},
	{31244, 213032},
	{31264, 213036},
	{31284, 213040},
	{31307, 213044},
	{31330, 213048},
	{31353, 213248},
	{31374, 213252},
	{31395, 213260},
	{31416, 213264},
	{31437, 213268},
	{31461, 213272},
	{31485, 213276},
	{31509, 213280},
	{43733, 213648},
	{43753, 213652},
	{43773, 213656},
	{43793, 213660},
	{43813, 213664},
	{43833, 213668},
	{43853, 213672},
	{43873, 213676},
	{43893, 213680},
	{43918, 213684},
	{43943, 213688},
	{43968, 213692},
	{43993, 213696},
	{44018, 213700},
	{44043, 213704},
	{44068, 213708},
	{44093, 213712},
	{44116, 213716},
	{44139, 213720},
	{44162, 213724},
	{44185, 213728},
	{44208, 213732},
	{44231, 213736},
	{44254, 213740},
	{32089, 214016},
	{32111, 214020, 1, 1876},
	{32133, 214024},
	{32155, 214028, 1, 1876},
	{32177, 214032},
	{32199, 214036, 1, 1876},
	{32221, 214040},
	{32243, 214044, 1, 1876},
	{32265, 214272},
	{32287, 214276},
	{32309, 214280},
	{32331, 214284},
	{32353, 214288},
	{32375, 214292},
	{32397, 214296},
	{32419, 214300},
	{32441, 214304},
	{32463, 214308},
	{32485, 214312},
	{32507, 214316},
	{32529, 214320},
	{32551, 214324},
	{32573, 214328},
	{32595, 214332},
	{32617, 214528},
	{32637, 214532},
	{32657, 214536},
	{32677, 214540},
	{32697, 214544},
	{32717, 214548},
	{32737, 214552},
	{32757, 214556},
	{32777, 214560},
	{32797, 214564},
	{32817, 214568},
	{32837, 214572},
	{31185, 214576},
	{31165, 214580},
	{31145, 214584},
	{31125, 214588},
	{49149, 214592},
	{49168, 214596},
	{49187, 214600},
	{49206, 214604},
	{32857, 214784},
	{32895, 214792},
	{32933, 214800},
	{32971, 214808},
	{33009, 214816},
	{33047, 214824},
	{33085, 214832},
	{33123, 214840},
	{49225, 214928},
	{49245, 214932},
	{49265, 214936},
	{49285, 214940},
	{49305, 214944},
	{49325, 214948},
	{49345, 214952},
	{49365, 214956},
	{49385, 214960},
	{49405, 214964},
	{49425, 214968},
	{49445, 214972},
	{49465, 214976},
	{49485, 214980},
	{49505, 214984},
	{49525, 214988},
	{33477, 215296},
	{33496, 215300},
	{33515, 215304},
	{33534, 215308},
	{33553, 215312},
	{33572, 215316},
	{33591, 215320},
	{33610, 215324},
	{33629, 215424},
	{33650, 215428},
	{44277, 215432},
	{44297, 215436, 2, 1877},
	{33671, 215552},
	{33691, 215556},
	{33711, 215560},
	{33731, 215564},
	{33751, 215568},
	{33771, 215572},
	{33791, 215576},
	{33811, 215580},
	{33831, 215808},
	{33850, 215812},
	{33869, 215816},
	{33888, 215820},
	{33907, 216064},
	{33926, 216068},
	{33945, 216072},
	{33964, 216076},
	{33983, 216320},
	{34003, 216324},
	{34023, 216328},
	{34043, 216332},
	{34063, 216336},
	{34083, 216340},
	{34103, 216344},
	{34123, 216348},
	{49545, 216352, 12, 3537},
	{49568, 216356, 1, 3549},
	{49592, 216360, 13, 3550},
	{34143, 216576},
	{34164, 216580},
	{34185, 216584},
	{34206, 216588},
	{34227, 216592},
	{34248, 216596},
	{34269, 216600},
	{34290, 216604},
	{34311, 216640},
	{34332, 216644},
	{34353, 216648},
	{34374, 216652},
	{34395, 216656},
	{34416, 216660},
	{34437, 216664},
	{34458, 216668},
	{34479, 216704},
	{34500, 216708},
	{34521, 216712},
	{34542, 216716},
	{34563, 216720},
	{34584, 216724},
	{34605, 216728},
	{34626, 216732},
	{34647, 216832},
	{34667, 216836},
	{34687, 216840},
	{34707, 216844},
	{34727, 216848},
	{34747, 216852},
	{34767, 216856},
	{34787, 216860},
	{34975, 217112},
	{34994, 217116},
	{35013, 217120},
	{35032, 217124},
	{35051, 217128},
	{35070, 217132},
	{35089, 217136},
	{35108, 217140},
	{35127, 217344},
	{35146, 217348},
	{35165, 217352},
	{35184, 217356},
	{35203, 217360},
	{35222, 217364},
	{35241, 217368},
	{35260, 217372},
	{35279, 217600},
	{35299, 217604},
	{35319, 217608},
	{35339, 217612},
	{35359, 217856},
	{35379, 217860},
	{35399, 217864},
	{35419, 217868},
	{35439, 217872},
	{35459, 217876},
	{35479, 217880},
	{35499, 217884},
	{35621, 217984},
	{35646, 217988},
	{35671, 217992},
	{35696, 217996},
	{35569, 218000},
	{35595, 218004, 2, 1877},
	{44317, 218008},
	{44340, 218012, 2, 1877},
	{35721, 218064},
	{35747, 218068},
	{35519, 218080},
	{35544, 218084, 2, 1877},
	{50995, 218088},
	{51018, 218092, 2, 1877},
	{35861, 218240},
	{35881, 218244},
	{35901, 218248},
	{35921, 218252},
	{35941, 218624},
	{35963, 218628},
	{35985, 218632},
	{36007, 218636},
	{36029, 218640},
	{36051, 218644},
	{36073, 218648},
	{36095, 218652},
	{36117, 218656},
	{36139, 218660},
	{36161, 218664},
	{36183, 218668},
	{36205, 218672},
	{36227, 218676},
	{36249, 218680},
	{36271, 218684},
	{35773, 218752},
	{35795, 218756},
	{35817, 218760},
	{35839, 218764},
	{49618, 218768},
	{49640, 218772},
	{49662, 218776},
	{49684, 218780},
	{36293, 218880},
	{36314, 218884},
	{36335, 218888},
	{36356, 218892},
	{36377, 218896},
	{36398, 218900},
	{36419, 218904},
	{36440, 218908},
	{49706, 218944},
	{49727, 218948},
	{49748, 218952},
	{49769, 218956},
	{49790, 218960},
	{49811, 218964},
	{49832, 218968},
	{49853, 218972},
	{36461, 219136},
	{36481, 219140},
	{36501, 219144},
	{36521, 219148},
	{36541, 219152},
	{36561, 219156},
	{36581, 219160},
	{36601, 219164},
	{44401, 219520},
	{44430, 219524, 2, 1877},
	{44459, 219528},
	{44481, 219532},
	{44503, 219536},
	{44525, 219540},
	{36661, 221184, 3, 3563},
	{36685, 221188, 4, 1884},
	{36710, 221192, 5, 1879},
	{36734, 221196, 3, 3563},
	{36758, 221200, 4, 1884},
	{36783, 221204, 3, 3563},
	{36807, 221208, 4, 1884},
	{36832, 221212, 5, 1879},
	{36856, 221216, 4, 1888},
	{36872, 221220, 5, 1879},
	{36896, 221224, 3, 1892},
	{36930, 221228, 3, 1895},
	{36964, 221232, 3, 1898},
	{36989, 221236, 3, 1901},
	{37014, 221240, 3, 1898},
	{49874, 221244, 3, 1895},
	{37039, 221248},
	{37054, 221252, 1, 1825},
	{37077, 221256},
	{37100, 221260},
	{37118, 221264, 2, 1904},
	{37136, 221268, 4, 1906},
	{37156, 221440, 20, 1910},
	{37181, 221444, 20, 1910},
	{37206, 221448, 17, 3566},
	{37234, 221452, 17, 3566},
	{37318, 221492, 9, 3584},
	{37346, 221496, 9, 3584},
	{44985, 221840, 5, 3593},
	{45009, 221844, 4, 1969},
	{45034, 221848, 5, 3593},
	{45058, 221852, 4, 1969},
	{45083, 221856, 5, 3593},
	{45107, 221860, 4, 1969},
	{45132, 221864, 5, 3593},
	{45156, 221868, 4, 1969},
	{45181, 221872, 5, 3593},
	{45210, 221876, 4, 1969},
	{45240, 221880, 5, 3593},
	{45269, 221884, 4, 1969},
	{45299, 221888, 5, 3593},
	{45328, 221892, 4, 1969},
	{45358, 221896, 5, 3593},
	{45387, 221900, 4, 1969},
	{45417, 221904, 5, 3593},
	{45444, 221908, 4, 1969},
	{45472, 221912, 5, 3593},
	{45499, 221916, 4, 1969},
	{45527, 221920, 5, 3593},
	{45554, 221924, 4, 1969},
	{45582, 221928, 5, 3593},
	{45609, 221932, 4, 1969},
	{37748, 222208, 5, 1964},
	{37774, 222212, 4, 1969},
	{37801, 222216, 5, 1964},
	{37827, 222220, 4, 1969},
	{37854, 222224, 5, 1964},
	{37880, 222228, 4, 1969},
	{37907, 222232, 5, 1964},
	{37933, 222236, 4, 1969},
	{37960, 222464, 5, 1964},
	{37986, 222468, 4, 1969},
	{38013, 222472, 1, 1879},
	{38039, 222476, 1, 1879},
	{38065, 222480, 1, 1879},
	{38091, 222484, 1, 1879},
	{38117, 222488, 1, 1879},
	{38143, 222492, 1, 1879},
	{38169, 222496, 1, 1879},
	{38195, 222720, 5, 1964},
	{38219, 222724, 5, 1964},
	{38243, 222728, 5, 1964},
	{38267, 222732, 5, 1964},
	{38291, 222736, 4, 1969},
	{38316, 222740, 4, 1969},
	{38341, 222744, 4, 1969},
	{38366, 222748, 4, 1969},
	{38391, 222752, 1, 1879},
	{38415, 222756, 1, 1879},
	{38439, 222760, 8, 1973},
	{36873, 222768, 5, 1964},
	{36735, 222772, 5, 1964},
	{49992, 222776, 5, 1964},
	{50015, 222780, 5, 1964},
	{36759, 222784, 4, 1969},
	{50038, 222788, 4, 1969},
	{50062, 222792, 4, 1969},
	{50086, 222796, 4, 1969},
	{38460, 222976, 3, 2686},
	{38483, 222980, 3, 2686},
	{38506, 222984, 3, 2686},
	{38529, 222988, 3, 2686},
	{38552, 222992, 3, 2686},
	{38575, 222996, 3, 2686},
	{38598, 223000, 3, 2686},
	{38621, 223004, 3, 2686},
	{38644, 223008, 3, 2686},
	{38667, 223012, 3, 2686},
	{38690, 223016, 3, 2686},
	{38714, 223020, 3, 2686},
	{38738, 223024, 3, 2686},
	{38762, 223028, 3, 2686},
	{38786, 223032, 3, 2686},
	{38810, 223036, 3, 2686},
	{50110, 223040, 3, 2686},
	{50134, 223044, 3, 2686},
	{50158, 223048, 3, 2686},
	{50182, 223052, 3, 2686},
	{50206, 223056, 3, 2686},
	{50230, 223060, 3, 2686},
	{50254, 223064, 3, 2686},
	{50278, 223068, 3, 2686},
	{50302, 223072, 10, 3598},
	{50323, 223080, 2, 3608},
	{50345, 223084, 1, 3610},
	{38834, 223104, 10, 3598},
	{38854, 223112, 2, 3608},
	{2306, 223136},
	{2332, 223140, 2, 343},
	{2358, 223144},
	{2384, 223148, 2, 343},
	{2479, 223152, 18, 3611},
	{2431, 223156, 5, 3629},
	{2452, 223160, 7, 3634},
	{2410, 223164, 2, 345},
	{2500, 223184, 5, 3641},
	{43376, 223188, 6, 3646},
	{2552, 223192},
	{2582, 223196},
	{2614, 223200},
	{2645, 223204},
	{2523, 223208},
	{38875, 223232, 5, 1964},
	{38900, 223236, 4, 1969},
	{38926, 223240, 8, 1995},
	{45637, 223244, 5, 2147},
	{45659, 223248, 5, 2147},
	{45681, 223252, 4, 3880},
	{38949, 223488, 5, 1964},
	{38972, 223492, 5, 1964},
	{38995, 223496, 3, 2020},
	{39018, 223500, 3, 2020},
	{39041, 223504, 4, 1969},
	{39065, 223508, 4, 1969},
	{39089, 223744, 5, 1964},
	{39113, 223748, 5, 1964},
	{39137, 223752, 5, 1964},
	{39161, 223756, 5, 1964},
	{39185, 223760, 4, 1969},
	{45708, 223764, 4, 1969},
	{45733, 223768, 4, 1969},
	{45758, 223772, 4, 1969},
	{39210, 224000, 5, 1964},
	{39233, 224004, 4, 1969},
	{39257, 224008, 3, 2020},
	{39280, 224256, 5, 1964},
	{39303, 224260, 4, 1969},
	{39327, 224264, 3, 2020},
	{39350, 224512, 5, 1964},
	{39374, 224516, 4, 1969},
	{39399, 224520, 5, 1964},
	{39423, 224524, 4, 1969},
	{39448, 224528, 3, 2020},
	{39472, 224532, 3, 2020},
	{39496, 224768, 5, 1964},
	{39521, 224772, 4, 1958},
	{39547, 224776, 5, 1964},
	{39572, 224780, 4, 1958},
	{39598, 224784, 3, 2020},
	{39623, 224788, 3, 2020},
	{39648, 224832, 5, 1964},
	{39673, 224836, 4, 1958},
	{39699, 224840, 5, 1964},
	{39724, 224844, 4, 1958},
	{39750, 224848, 3, 2020},
	{39775, 224852, 3, 2020},
	{39800, 224896, 5, 1964},
	{39825, 224900, 4, 1958},
	{39851, 224904, 3, 2020},
	{39876, 224908, 3, 2020},
	{39901, 224912, 3, 2020},
	{39926, 225024, 5, 1964},
	{39950, 225028, 4, 1958},
	{39975, 225032, 3, 2020},
	{39999, 225036, 3, 2020},
	{40023, 225040, 3, 2020},
	{40173, 225280, 12, 2023},
	{40195, 225284, 5, 1964},
	{40218, 225288, 4, 1969},
	{40242, 225292, 2, 3652},
	{40265, 225296, 2, 3652},
	{40288, 225300, 2, 3652},
	{40311, 225536, 5, 1964},
	{40334, 225540, 4, 1969},
	{40358, 225544, 5, 1964},
	{40381, 225548, 4, 1969},
	{40405, 225552, 5, 1964},
	{40428, 225560, 5, 1964},
	{40451, 225792, 5, 3654},
	{40472, 225796},
	{40501, 225800, 2, 2050},
	{40530, 225804},
	{40987, 225808, 2, 2077},
	{40585, 225812},
	{40604, 225816, 2, 2059},
	{40556, 225820, 3, 3659},
	{40676, 225824, 1, 3662},
	{40703, 225828, 2, 3663},
	{40630, 225832, 1, 3662},
	{40653, 225836, 2, 3663},
	{41006, 225864, 2, 2079},
	{41033, 225868},
	{45973, 225872, 2, 2079},
	{46004, 225876},
	{41060, 225880, 2, 2081},
	{41087, 225884, 2, 2083},
	{46035, 225888, 4, 2753},
	{41114, 225892, 18, 3665},
	{41135, 225896, 9, 2723},
	{41154, 225900, 12, 3683},
	{41173, 225904, 1, 2111},
	{41197, 225908, 1, 2113},
	{41229, 225912, 2, 2115},
	{46106, 225916, 3, 2757},
	{50368, 225928, 2, 3705},
	{50382, 225932, 10, 3707},
	{45843, 225936},
	{45816, 225940},
	{50397, 225972, 1, 3717},
	{50410, 225976},
	{50435, 225980, 1, 3718},
	{50460, 225984, 1, 3719},
	{50480, 225988},
	{50502, 225992, 2, 3720},
	{50522, 225996},
	{50550, 226000, 1, 3718},
	{50578, 226004, 1, 3719},
	{50601, 226008},
	{50626, 226012, 2, 3720},
	{50649, 226016, 1, 3722},
	{50666, 226020, 9, 3723},
	{50687, 226044},
	{41366, 226048, 2, 2126},
	{41383, 226052, 1, 2128},
	{41407, 226056, 1, 2128},
	{41621, 226304, 5, 1964},
	{41645, 226308, 4, 1969},
	{41670, 226312, 2, 3652},
	{41694, 226316, 5, 1964},
	{41718, 226320, 4, 1969},
	{41743, 226324, 2, 3652},
	{41767, 226328, 10, 2137},
	{42132, 226432, 5, 1964},
	{42161, 226436, 5, 1964},
	{42190, 226440, 4, 1969},
	{42220, 226444, 4, 1969},
	{42250, 226448, 8, 1995},
	{42277, 226452, 8, 1995},
	{41875, 226496, 5, 2147},
	{41903, 226500, 5, 2147},
	{41931, 226504, 5, 2147},
	{41959, 226508, 5, 2147},
	{41987, 226512, 5, 2147},
	{42015, 226516, 5, 2147},
	{42043, 226520, 5, 2147},
	{42071, 226524, 5, 2147},
	{42099, 226528, 4, 3880},
	{46147, 226532, 5, 2147},
	{46172, 226536, 5, 2147},
	{46197, 226540, 5, 2147},
	{46222, 226544, 5, 2147},
	{46247, 226548, 4, 3880},
	{42304, 226560, 5, 3593},
	{42334, 226564, 4, 1969},
	{42365, 226568, 8, 1995},
	{41789, 226576, 5, 2147},
	{41816, 226580, 5, 2147},
	{41843, 226584, 4, 3880},
	{51041, 226600, 5, 2147},
	{51066, 226604, 5, 2147},
	{51091, 226608, 5, 2147},
	{51116, 226612, 5, 2147},
	{51141, 226616, 4, 3880},
	{42393, 226688, 5, 1964},
	{42417, 226692, 4, 1969},
	{42442, 226696, 3, 2020},
	{42518, 226816, 5, 1964},
	{42544, 226820, 4, 1969},
	{42571, 226824, 5, 1964},
	{42597, 226828, 5, 1964},
	{42623, 226832, 5, 1964},
	{42649, 226836, 1, 1879},
	{42675, 226840, 1, 1879},
	{42701, 226844, 1, 1879},
	{42727, 226848, 1, 1879},
	{42753, 226880, 4, 1969},
	{42780, 226884, 4, 1969},
	{42807, 226888, 4, 1969},
	{42466, 226944, 2, 2161},
	{42492, 226948, 2, 2161},
	{50701, 226952, 2, 2161},
	{50727, 226956, 2, 2161},
	{42834, 227072, 5, 1964},
	{42859, 227076, 4, 1958},
	{42885, 227080, 3, 2020},
	{42910, 227084, 3, 2020},
	{42935, 227088, 3, 2020},
	{50753, 227136, 5, 1964},
	{50778, 227140, 4, 1958},
	{50804, 227144, 3, 2020},
	{50829, 227148, 3, 2020},
	{50854, 227152, 3, 2020},
	{42960, 227200, 5, 1964},
	{42984, 227204, 4, 1958},
	{43009, 227208, 3, 2020},
	{43033, 227212, 3, 2020},
	{43057, 227216, 3, 2020},
	{46345, 227456, 5, 2147},
	{46376, 227460, 5, 2147},
	{46407, 227464, 4, 3880},
	{46443, 227468, 1, 2760},
	{46467, 227472, 5, 1964},
	{46493, 227476, 4, 1969},
	{46520, 227480, 5, 1964},
	{46546, 227484, 4, 1969},
};

static const struct si_reg gfx6_reg_table[] = {
	{1310, 68, 9, 3884},
	{1323, 72, 24, 3893},
	{1338, 76, 3, 3917},
	{51171, 80, 11, 3920},
	{1375, 84, 4, 3931},
	{1393, 88, 2, 3935},
	{1411, 92, 4, 3937},
	{1426, 96},
	{1440, 100, 1, 3941},
	{1454, 104},
	{51185, 108},
	{51202, 112, 13, 3942},
	{51218, 2480},
	{51233, 2484, 1, 3955},
	{51248, 2488},
	{51263, 2492, 1, 3955},
	{1609, 2496},
	{1623, 2500},
	{1637, 2504},
	{1651, 2508},
	{1665, 2512},
	{1679, 2516},
	{1693, 2520},
	{1707, 2524},
	{1721, 2528},
	{1735, 2532},
	{1749, 2536},
	{1764, 2540},
	{1839, 2544},
	{1850, 2552},
	{1866, 2556},
	{51278, 3660, 21, 3956},
	{51291, 3664, 20, 3977},
	{51303, 3668, 16, 3997},
	{51316, 32768, 1, 4013},
	{51326, 32772, 2, 4014},
	{1954, 32776, 17, 4016},
	{51341, 32780, 2, 4033},
	{1967, 32784, 24, 4035},
	{1979, 32788, 11, 4059},
	{1995, 32792, 11, 4059},
	{51355, 32800, 6, 4070},
	{51371, 32804, 1, 4076},
	{51387, 32808},
	{28677, 32812, 6, 4077},
	{51403, 32816, 2, 4083},
	{51423, 32820, 1, 4085},
	{51445, 32848, 6, 4086},
	{51456, 32852, 22, 4092},
	{51476, 32856, 4, 4114},
	{51492, 32864, 2, 4118},
	{37156, 32880, 19, 4120},
	{37181, 32884, 19, 4120},
	{31353, 32888},
	{31374, 32892},
	{31395, 32896},
	{31416, 32900},
	{37206, 32920, 12, 4139},
	{37234, 32924, 12, 4139},
	{31437, 32936},
	{31461, 32940},
	{31485, 32944},
	{31509, 32948},
	{51506, 33008, 1, 4151},
	{47314, 33012},
	{51518, 33020},
	{51531, 33024},
	{51549, 33028},
	{51567, 33032},
	{51585, 33036},
	{51603, 33040},
	{51621, 33044},
	{51639, 33048},
	{51657, 33052},
	{51675, 33536, 10, 4152},
	{24571, 33792, 2, 4162},
	{24591, 33796, 1, 1635},
	{24611, 33800},
	{24631, 33804},
	{24651, 33808},
	{24672, 33812},
	{24693, 33816, 2, 4164},
	{24715, 33820},
	{24737, 33824},
	{24767, 33828},
	{24797, 33832},
	{24826, 33836},
	{24855, 33840},
	{24885, 33844},
	{24915, 33848},
	{24944, 33852},
	{24973, 33856},
	{25003, 33860},
	{25033, 33864},
	{25062, 33868},
	{25091, 33872},
	{25121, 33876},
	{25151, 33880},
	{25180, 33884},
	{25209, 33888, 2, 4166},
	{25231, 33892},
	{25253, 33896},
	{25276, 33900},
	{25299, 33904},
	{25322, 33908},
	{25345, 33912},
	{25368, 33916},
	{25391, 33920},
	{25415, 33924},
	{25439, 33928},
	{25463, 33932},
	{25487, 33936},
	{25511, 33940},
	{25535, 33944},
	{25559, 33948},
	{25583, 33952},
	{25605, 33956},
	{25627, 33960},
	{25648, 33964},
	{25669, 33968},
	{25693, 33972},
	{25717, 33976},
	{25741, 33980},
	{25765, 33984},
	{25789, 33988},
	{25917, 34044, 1, 1642},
	{25933, 34048},
	{25946, 34052},
	{25959, 34056},
	{25972, 34060},
	{25985, 34064},
	{25998, 34068},
	{26011, 34072},
	{26024, 34076},
	{26151, 34112, 2, 1643},
	{26164, 34116},
	{26335, 34144, 1, 1645},
	{26353, 34148, 3, 4168},
	{26371, 34152},
	{26386, 34156},
	{26410, 34160},
	{26434, 34164},
	{26453, 34168},
	{26472, 34172},
	{26496, 34176},
	{26520, 34180},
	{26544, 34184},
	{26568, 34212, 2, 4171},
	{26586, 34216, 1, 4173},
	{26604, 34220},
	{26622, 34224},
	{26640, 34228, 2, 4174},
	{26658, 34232, 1, 4176},
	{26676, 34236},
	{26694, 34240, 2, 1656},
	{26713, 34244, 5, 4177},
	{26732, 34256},
	{26756, 34260, 2, 1656},
	{26776, 34264, 5, 4177},
	{26850, 34284, 1, 1671},
	{26871, 34288, 23, 4182},
	{26885, 34292},
	{26899, 34296},
	{26913, 34300, 4, 4205},
	{26929, 34304},
	{26948, 34308, 1, 4209},
	{26970, 34312},
	{26989, 34316, 1, 4210},
	{27011, 34320, 9, 4211},
	{27029, 34324},
	{27049, 34328, 1, 4209},
	{27072, 34332},
	{27092, 34336, 1, 4210},
	{27115, 34340, 9, 4211},
	{27134, 34344, 5, 4220},
	{27146, 34348, 2, 1703},
	{27180, 34356, 1, 4225},
	{27198, 34360, 5, 2654},
	{27218, 34364, 1, 1711},
	{27235, 34368},
	{27251, 34372, 1, 1713},
	{27264, 34376, 1, 1714},
	{27278, 34380, 1, 1715},
	{27292, 34384, 1, 1716},
	{27314, 34388, 1, 1717},
	{27334, 34392, 1, 1718},
	{27356, 34396, 1, 1719},
	{51698, 34416, 15, 4226},
	{51715, 34420, 18, 4241},
	{51732, 34424, 31, 4259},
	{51749, 34428, 16, 4290},
	{51762, 34432, 24, 4306},
	{51770, 34436},
	{51788, 34440},
	{51807, 34444, 3, 4330},
	{51826, 34448},
	{51844, 34460, 1, 4333},
	{51865, 34512, 2, 4334},
	{51877, 34516, 1, 4336},
	{51889, 34520, 9, 4337},
	{51900, 34528, 4, 4346},
	{51913, 34532, 1, 4350},
	{51930, 34552, 1, 4351},
	{51942, 34556, 1, 4351},
	{51954, 34560, 1, 4351},
	{51966, 34564, 2, 4352},
	{51983, 34568, 2, 4354},
	{27669, 34572, 1, 1728},
	{27688, 34576, 1, 4356},
	{27707, 34580, 1, 1730},
	{27724, 34584, 1, 1731},
	{27742, 34588, 1, 4357},
	{27760, 34592, 1, 1733},
	{27776, 34596, 1, 1734},
	{27794, 34600, 1, 4358},
	{27812, 34604, 1, 1736},
	{27828, 34608, 1, 1731},
	{27843, 34612, 1, 4357},
	{27858, 34616, 1, 1733},
	{27871, 34620, 1, 1734},
	{27886, 34624, 1, 4358},
	{27901, 34628, 1, 1736},
	{27914, 34632, 1, 1737},
	{27928, 34636, 1, 4359},
	{27942, 34640, 1, 1739},
	{52004, 34644, 4, 4360},
	{52023, 34648, 4, 4364},
	{52042, 34652, 3, 4368},
	{52060, 34656, 2, 4371},
	{52080, 34660, 2, 4373},
	{52098, 34664, 2, 4375},
	{52111, 34668, 1, 4377},
	{52124, 34672, 1, 4378},
	{52138, 34676, 1, 4379},
	{52151, 34680, 3, 4380},
	{52164, 34684},
	{52176, 34688, 2, 4383},
	{52191, 34692, 2, 4385},
	{52207, 34696, 2, 4387},
	{52223, 34700, 1, 4389},
	{52235, 34708, 2, 4390},
	{52247, 34712, 2, 4392},
	{52261, 34716, 1, 4394},
	{52275, 34720, 2, 4395},
	{52293, 34724, 2, 4397},
	{52312, 34728, 2, 4399},
	{52331, 34780, 12, 4401},
	{36856, 34812, 4, 1888},
	{52349, 34944, 5, 4413},
	{52372, 34948, 2, 4418},
	{52395, 34952, 2, 4418},
	{52418, 34956, 2, 4418},
	{52441, 34960},
	{52460, 34964},
	{52479, 34968},
	{52498, 34972},
	{52517, 34976},
	{52536, 34980},
	{52555, 34984},
	{52574, 34988},
	{52593, 34992, 1, 4420},
	{52616, 34996, 1, 4421},
	{52640, 35000, 1, 4422},
	{52663, 35004, 1, 4423},
	{52688, 35008, 2, 4424},
	{52708, 35012, 8, 4426},
	{28692, 35016},
	{28711, 35020},
	{52731, 35024, 4, 4434},
	{52747, 35028, 1, 4438},
	{52767, 35032, 1, 4439},
	{52783, 35036, 5, 4440},
	{52798, 35040, 2, 4445},
	{52813, 35044},
	{52828, 35048, 2, 4447},
	{52842, 35052},
	{52856, 35056, 10, 4449},
	{52872, 35100, 1, 4459},
	{52898, 35104, 5, 4413},
	{52922, 35108, 5, 4413},
	{52946, 35112, 2, 4418},
	{52970, 35116, 2, 4418},
	{52994, 35120},
	{53014, 35124},
	{53034, 35128},
	{53054, 35132},
	{53074, 35136},
	{53094, 35140},
	{53114, 35144},
	{53134, 35148},
	{28730, 35160, 1, 4460},
	{28749, 35164, 1, 4461},
	{28764, 35168},
	{28797, 35172},
	{28830, 35176},
	{28863, 35180},
	{28953, 35184},
	{28969, 35188},
	{53154, 35196, 10, 4462},
	{53172, 35200, 2, 4472},
	{53189, 35204, 10, 4474},
	{28987, 35208, 1, 1792},
	{53206, 35212, 3, 4484},
	{29004, 35248, 2, 4487},
	{29025, 35256},
	{53221, 35260, 4, 4489},
	{53247, 35264, 4, 4489},
	{53275, 35328, 1, 4493},
	{53292, 35332},
	{53309, 35344, 1, 4494},
	{53327, 35348, 9, 4495},
	{53341, 35352, 10, 4504},
	{37748, 35360, 3, 4413},
	{37801, 35364, 3, 4413},
	{37854, 35368, 2, 2017},
	{37907, 35372, 2, 2017},
	{32089, 35376},
	{32111, 35380, 1, 1876},
	{32133, 35384},
	{32155, 35388, 1, 1876},
	{32177, 35392},
	{32199, 35396, 1, 1876},
	{32221, 35400},
	{32243, 35404, 1, 1876},
	{53358, 35408, 1, 4514},
	{53376, 35412, 1, 4515},
	{29357, 35424, 1, 1816},
	{37960, 35456, 3, 4516},
	{38013, 35460, 1, 1981},
	{38039, 35464, 1, 1981},
	{38065, 35468, 1, 1981},
	{38091, 35472, 1, 1981},
	{38117, 35476, 1, 1981},
	{38143, 35480, 1, 1981},
	{38169, 35484, 1, 1981},
	{32265, 35488},
	{32287, 35492},
	{32309, 35496},
	{32331, 35500},
	{32353, 35504},
	{32375, 35508},
	{32397, 35512},
	{32419, 35516},
	{32441, 35520},
	{32463, 35524},
	{32485, 35528},
	{32507, 35532},
	{32529, 35536},
	{32551, 35540},
	{32573, 35544},
	{32595, 35548},
	{29382, 35600, 2, 1817},
	{53398, 35620, 2, 4519},
	{53423, 35624, 10, 4521},
	{53440, 35788, 4, 4531},
	{53456, 35796, 4, 4535},
	{53475, 35800, 1, 4539},
	{53492, 35804},
	{53509, 35824, 26, 4540},
	{53523, 35840, 9, 4566},
	{53533, 35844, 9, 4575},
	{30123, 35848, 3, 4584},
	{53544, 35852, 3, 4587},
	{53563, 35856, 6, 4590},
	{53578, 35860, 4, 4596},
	{38834, 35864, 9, 4600},
	{53592, 35868, 4, 4609},
	{53612, 35872, 4, 4609},
	{53634, 35876, 4, 4613},
	{32857, 35968},
	{32876, 35972},
	{32895, 35976},
	{32914, 35980},
	{32933, 35984},
	{32952, 35988},
	{32971, 35992},
	{32990, 35996},
	{33009, 36000},
	{33028, 36004},
	{33047, 36008},
	{33066, 36012},
	{33085, 36016},
	{33104, 36020},
	{33123, 36024},
	{33142, 36028},
	{33161, 36032},
	{33180, 36036},
	{33199, 36040},
	{33218, 36044},
	{33237, 36048},
	{33257, 36052},
	{33277, 36056},
	{33297, 36060},
	{33317, 36064},
	{33337, 36068},
	{33357, 36072},
	{33377, 36076},
	{33397, 36080},
	{33417, 36084},
	{33437, 36088},
	{33457, 36092},
	{38460, 36096, 6, 4617},
	{38483, 36100, 6, 4617},
	{38506, 36104, 6, 4617},
	{38529, 36108, 6, 4617},
	{38552, 36112, 6, 4617},
	{38575, 36116, 6, 4617},
	{38598, 36120, 6, 4617},
	{38621, 36124, 6, 4617},
	{38644, 36128, 6, 4617},
	{38667, 36132, 6, 4617},
	{38690, 36136, 6, 4617},
	{38714, 36140, 6, 4617},
	{38738, 36144, 6, 4617},
	{38762, 36148, 6, 4617},
	{38786, 36152, 6, 4617},
	{38810, 36156, 6, 4617},
	{53654, 36224, 2, 4623},
	{53670, 36228, 2, 4623},
	{53686, 36232, 4, 4625},
	{53703, 36236, 4, 4625},
	{53721, 36320, 8, 4629},
	{53734, 36324},
	{53746, 36336},
	{53757, 36340},
	{53768, 36352},
	{53789, 36356, 1, 4637},
	{2431, 36360, 8, 4638},
	{2452, 36364, 3, 4646},
	{53810, 36368, 2, 4649},
	{29907, 36384},
	{29934, 36388},
	{29961, 36392},
	{29988, 36396},
	{2410, 36400, 2, 4651},
	{2500, 36404, 5, 4653},
	{53836, 36408, 15, 4658},
	{2479, 36412, 1, 4673},
	{53857, 36416},
	{53878, 36424, 1, 4674},
	{53902, 36440, 3, 4675},
	{53920, 36444, 4, 4678},
	{53939, 36448, 3, 4682},
	{53954, 36452},
	{53976, 36456},
	{53998, 36460},
	{54020, 36464},
	{54042, 36480, 4, 4685},
	{54057, 36484, 3, 4689},
	{54068, 36488, 3, 4692},
	{54079, 36492, 4, 4695},
	{2687, 36608},
	{2705, 36612, 4, 383},
	{2723, 36616},
	{2741, 36620, 14, 4699},
	{3642, 36624},
	{3660, 36628, 5, 4713},
	{3678, 36632, 4, 4718},
	{3696, 36636, 11, 4722},
	{3714, 36640, 2, 4733},
	{3732, 36644, 2, 4735},
	{3750, 36648, 4, 4737},
	{3768, 36652},
	{2759, 36656, 13, 4741},
	{2777, 36660, 4, 411},
	{2795, 36664, 9, 4754},
	{2813, 36668, 3, 4763},
	{2831, 37120, 6, 426},
	{30148, 38156},
	{2847, 39160, 9, 4766},
	{2862, 39184, 6, 4775},
	{2876, 39188, 5, 4776},
	{2890, 39192, 5, 4776},
	{2904, 39196, 5, 4776},
	{2918, 39200, 5, 4776},
	{2932, 39204, 5, 4776},
	{2946, 39208, 5, 4776},
	{2960, 39212, 5, 4776},
	{2974, 39216, 5, 4776},
	{2988, 39220, 5, 4776},
	{3002, 39224, 5, 4776},
	{3017, 39228, 5, 4776},
	{3032, 39232, 5, 4776},
	{3047, 39236, 5, 4776},
	{3062, 39240, 5, 4776},
	{3077, 39244, 5, 4776},
	{3092, 39248, 5, 4776},
	{3107, 39252, 5, 4776},
	{3122, 39256, 5, 4776},
	{3137, 39260, 5, 4776},
	{3152, 39264, 5, 4776},
	{3167, 39268, 5, 4776},
	{3182, 39272, 5, 4776},
	{3197, 39276, 5, 4776},
	{3212, 39280, 5, 4776},
	{3227, 39284, 5, 4776},
	{3242, 39288, 5, 4776},
	{3257, 39292, 5, 4776},
	{3272, 39296, 5, 4776},
	{3287, 39300, 5, 4776},
	{3302, 39304, 5, 4776},
	{3317, 39308, 5, 4776},
	{54091, 45056},
	{54112, 45060, 1, 498},
	{54133, 45064},
	{54154, 45068, 1, 498},
	{3891, 45088},
	{3912, 45092, 1, 498},
	{3933, 45096, 11, 4781},
	{3957, 45100, 6, 4792},
	{3981, 45104},
	{4007, 45108},
	{4033, 45112},
	{4059, 45116},
	{4085, 45120},
	{4111, 45124},
	{4137, 45128},
	{4163, 45132},
	{4189, 45136},
	{4215, 45140},
	{4241, 45144},
	{4268, 45148},
	{4295, 45152},
	{4322, 45156},
	{4349, 45160},
	{4376, 45164},
	{54175, 45312},
	{54196, 45316, 1, 498},
	{54217, 45320},
	{54238, 45324, 1, 498},
	{5097, 45344},
	{5118, 45348, 1, 498},
	{5139, 45352, 12, 4798},
	{5163, 45356, 10, 4810},
	{5187, 45360},
	{5213, 45364},
	{5239, 45368},
	{5265, 45372},
	{5291, 45376},
	{5317, 45380},
	{5343, 45384},
	{5369, 45388},
	{5395, 45392},
	{5421, 45396},
	{5447, 45400},
	{5474, 45404},
	{5501, 45408},
	{5528, 45412},
	{5555, 45416},
	{5582, 45420},
	{54259, 45568},
	{54280, 45572, 1, 498},
	{54301, 45576},
	{54322, 45580, 1, 498},
	{6471, 45600},
	{6492, 45604, 1, 498},
	{6513, 45608, 11, 4820},
	{6537, 45612, 4, 4831},
	{6561, 45616},
	{6587, 45620},
	{6613, 45624},
	{6639, 45628},
	{6665, 45632},
	{6691, 45636},
	{6717, 45640},
	{6743, 45644},
	{6769, 45648},
	{6795, 45652},
	{6821, 45656},
	{6848, 45660},
	{6875, 45664},
	{6902, 45668},
	{6929, 45672},
	{6956, 45676},
	{54343, 45824},
	{54364, 45828, 1, 498},
	{54385, 45832},
	{54406, 45836, 1, 498},
	{7642, 45856},
	{7663, 45860, 1, 498},
	{7684, 45864, 12, 4798},
	{7708, 45868, 6, 4835},
	{7732, 45872},
	{7758, 45876},
	{7784, 45880},
	{7810, 45884},
	{7836, 45888},
	{7862, 45892},
	{7888, 45896},
	{7914, 45900},
	{7940, 45904},
	{7966, 45908},
	{7992, 45912},
	{8019, 45916},
	{8046, 45920},
	{8073, 45924},
	{8100, 45928},
	{8127, 45932},
	{54427, 46080},
	{54448, 46084, 1, 498},
	{54469, 46088},
	{54490, 46092, 1, 498},
	{8366, 46112},
	{8387, 46116, 1, 498},
	{8408, 46120, 10, 4841},
	{8432, 46124, 6, 4851},
	{8456, 46128},
	{8482, 46132},
	{8508, 46136},
	{8534, 46140},
	{8560, 46144},
	{8586, 46148},
	{8612, 46152},
	{8638, 46156},
	{8664, 46160},
	{8690, 46164},
	{8716, 46168},
	{8743, 46172},
	{8770, 46176},
	{8797, 46180},
	{8824, 46184},
	{8851, 46188},
	{54511, 46336},
	{54532, 46340, 1, 498},
	{54553, 46344},
	{54574, 46348, 1, 498},
	{9537, 46368},
	{9558, 46372, 1, 498},
	{9579, 46376, 11, 4857},
	{9603, 46380, 5, 4868},
	{9627, 46384},
	{9653, 46388},
	{9679, 46392},
	{9705, 46396},
	{9731, 46400},
	{9757, 46404},
	{9783, 46408},
	{9809, 46412},
	{9835, 46416},
	{9861, 46420},
	{9887, 46424},
	{9914, 46428},
	{9941, 46432},
	{9968, 46436},
	{9995, 46440},
	{10022, 46444},
	{10049, 47104, 12, 4873},
	{10076, 47108},
	{10090, 47112},
	{10104, 47116},
	{10118, 47120},
	{10134, 47124},
	{10150, 47128},
	{10166, 47132, 2, 666},
	{10187, 47136, 2, 666},
	{10208, 47140, 2, 666},
	{54595, 47148, 1, 4885},
	{10282, 47152},
	{10297, 47156, 2, 4886},
	{54615, 47160},
	{54630, 47164, 1, 670},
	{54645, 47168},
	{54660, 47172, 1, 670},
	{10436, 47176, 10, 4888},
	{10454, 47180, 11, 683},
	{10472, 47184, 1, 694},
	{10485, 47188, 7, 4898},
	{54675, 47192, 2, 4905},
	{54706, 47196, 2, 4905},
	{10563, 47200, 2, 701},
	{11038, 47360},
	{11058, 47364},
	{11078, 47368},
	{11098, 47372},
	{11118, 47376},
	{11138, 47380},
	{11158, 47384},
	{11178, 47388},
	{11198, 47392},
	{11218, 47396},
	{11238, 47400},
	{11259, 47404},
	{11280, 47408},
	{11301, 47412},
	{11322, 47416},
	{11343, 47420},
	{54737, 53300, 29, 4907},
	{54754, 55348, 29, 4907},
	{11425, 163840, 9, 726},
	{11443, 163844, 9, 4936},
	{11460, 163848, 4, 4945},
	{11474, 163852, 23, 754},
	{11493, 163856, 15, 777},
	{11513, 163860},
	{11549, 163872},
	{11569, 163876},
	{11589, 163880, 1, 795},
	{11606, 163884},
	{11621, 163888, 2, 796},
	{11645, 163892, 2, 798},
	{54771, 163900, 7, 4949},
	{11703, 163904, 8, 4956},
	{11713, 163908, 5, 4964},
	{11729, 163912},
	{11744, 163916},
	{11765, 163920},
	{11781, 163924},
	{54785, 163928, 2, 4969},
	{54799, 163932, 1, 4971},
	{11971, 163968},
	{12090, 164344},
	{12108, 164348},
	{12126, 164352, 2, 849},
	{12146, 164356, 3, 851},
	{12170, 164360, 2, 854},
	{12194, 164364, 1, 856},
	{12214, 164368, 2, 851},
	{12234, 164372, 2, 854},
	{12254, 164376, 2, 851},
	{12274, 164380, 2, 854},
	{12294, 164384, 2, 851},
	{12314, 164388, 2, 854},
	{12334, 164392, 2, 851},
	{12354, 164396, 2, 854},
	{12374, 164400, 7, 857},
	{12389, 164404, 2, 864},
	{12418, 164408, 8, 866},
	{12433, 164412, 8, 874},
	{12448, 164416, 3, 851},
	{12473, 164420, 2, 854},
	{12498, 164424},
	{12516, 164428},
	{12534, 164432, 3, 851},
	{12559, 164436, 2, 854},
	{12584, 164440, 3, 851},
	{12609, 164444, 2, 854},
	{12634, 164448, 3, 851},
	{12659, 164452, 2, 854},
	{12684, 164456, 3, 851},
	{12709, 164460, 2, 854},
	{12734, 164464, 3, 851},
	{12759, 164468, 2, 854},
	{12784, 164472, 3, 851},
	{12809, 164476, 2, 854},
	{12834, 164480, 3, 851},
	{12859, 164484, 2, 854},
	{12884, 164488, 3, 851},
	{12909, 164492, 2, 854},
	{12934, 164496, 3, 851},
	{12959, 164500, 2, 854},
	{12984, 164504, 3, 851},
	{13009, 164508, 2, 854},
	{13034, 164512, 3, 851},
	{13060, 164516, 2, 854},
	{13086, 164520, 3, 851},
	{13112, 164524, 2, 854},
	{13138, 164528, 3, 851},
	{13164, 164532, 2, 854},
	{13190, 164536, 3, 851},
	{13216, 164540, 2, 854},
	{13242, 164544, 3, 851},
	{13268, 164548, 2, 854},
	{13294, 164552, 3, 851},
	{13320, 164556, 2, 854},
	{13346, 164560},
	{13365, 164564},
	{13384, 164568},
	{13403, 164572},
	{13422, 164576},
	{13441, 164580},
	{13460, 164584},
	{13479, 164588},
	{13498, 164592},
	{13517, 164596},
	{13536, 164600},
	{13555, 164604},
	{13574, 164608},
	{13593, 164612},
	{13612, 164616},
	{13631, 164620},
	{13650, 164624},
	{13669, 164628},
	{13688, 164632},
	{13707, 164636},
	{13726, 164640},
	{13746, 164644},
	{13766, 164648},
	{13786, 164652},
	{13806, 164656},
	{13826, 164660},
	{13846, 164664},
	{13866, 164668},
	{13886, 164672},
	{13906, 164676},
	{13926, 164680},
	{13946, 164684},
	{13966, 164688, 15, 882},
	{14065, 164704, 1, 909},
	{54814, 164708, 1, 4972},
	{14096, 164712, 1, 911},
	{14164, 164864},
	{14181, 164868},
	{14198, 164872},
	{14214, 164876},
	{14268, 164884},
	{14281, 164888},
	{14296, 164892},
	{14310, 164896},
	{14364, 164908, 6, 942},
	{14383, 164912, 4, 948},
	{14401, 164916, 4, 952},
	{14422, 164924},
	{14441, 164928},
	{14461, 164932},
	{14480, 164936},
	{14500, 164940},
	{14519, 164944},
	{14539, 164948},
	{14560, 164952},
	{14582, 164956},
	{14603, 164960},
	{14625, 164964},
	{14646, 164968},
	{14668, 164972},
	{14689, 164976},
	{14711, 164980},
	{14732, 164984},
	{14754, 164988},
	{14775, 164992},
	{14797, 164996},
	{14818, 165000},
	{14840, 165004},
	{14861, 165008},
	{14883, 165012},
	{14904, 165016},
	{14926, 165020},
	{14947, 165024},
	{14969, 165028},
	{14990, 165032},
	{15012, 165036},
	{15033, 165040},
	{15055, 165044},
	{15076, 165048},
	{15098, 165052},
	{15119, 165056},
	{15141, 165060},
	{15162, 165064},
	{15184, 165068},
	{15205, 165072},
	{15227, 165076},
	{15248, 165080},
	{15270, 165084},
	{15291, 165088},
	{15313, 165092},
	{15334, 165096},
	{15356, 165100},
	{15377, 165104},
	{15399, 165108},
	{15420, 165112},
	{15442, 165116},
	{15463, 165120},
	{15485, 165124},
	{15506, 165128},
	{15528, 165132},
	{15549, 165136},
	{15571, 165140},
	{15592, 165144},
	{15614, 165148},
	{15635, 165152},
	{15657, 165156},
	{15678, 165160},
	{15700, 165164},
	{15722, 165168},
	{15745, 165172},
	{15767, 165176},
	{15790, 165180},
	{15812, 165184},
	{15835, 165188},
	{15857, 165192},
	{15880, 165196},
	{15902, 165200},
	{15925, 165204},
	{15947, 165208},
	{15970, 165212},
	{15992, 165216},
	{16015, 165220},
	{16037, 165224},
	{16060, 165228},
	{16082, 165232},
	{16105, 165236},
	{16127, 165240},
	{16150, 165244},
	{16172, 165248},
	{16195, 165252},
	{16217, 165256},
	{16240, 165260},
	{16262, 165264},
	{16285, 165268},
	{16307, 165272},
	{16330, 165276},
	{16352, 165280},
	{16375, 165284},
	{16397, 165288},
	{16420, 165292},
	{16442, 165296},
	{16465, 165300},
	{16487, 165304},
	{16510, 165308},
	{16524, 165312},
	{16538, 165316},
	{16552, 165320},
	{16566, 165324},
	{16580, 165328},
	{16594, 165332},
	{16608, 165336},
	{16622, 165340},
	{16636, 165344},
	{16650, 165348},
	{16664, 165352},
	{16678, 165356},
	{16692, 165360},
	{16706, 165364},
	{16720, 165368},
	{16734, 165372},
	{16748, 165376},
	{16762, 165380},
	{16776, 165384},
	{16790, 165388},
	{16804, 165392},
	{16818, 165396},
	{16832, 165400},
	{16869, 165444, 6, 956},
	{16889, 165448, 6, 956},
	{16909, 165452, 6, 956},
	{16929, 165456, 6, 956},
	{16949, 165460, 6, 956},
	{16969, 165464, 6, 956},
	{16989, 165468, 6, 956},
	{17009, 165472, 6, 956},
	{17029, 165476, 6, 956},
	{17049, 165480, 6, 956},
	{17069, 165484, 6, 956},
	{17090, 165488, 6, 956},
	{17111, 165492, 6, 956},
	{17132, 165496, 6, 956},
	{17153, 165500, 6, 956},
	{17174, 165504, 6, 956},
	{17195, 165508, 6, 956},
	{17216, 165512, 6, 956},
	{17237, 165516, 6, 956},
	{17258, 165520, 6, 956},
	{17279, 165524, 4, 968},
	{17300, 165528, 4, 968},
	{17321, 165532, 4, 968},
	{17342, 165536, 4, 968},
	{17363, 165540, 4, 968},
	{17384, 165544, 4, 968},
	{17405, 165548, 4, 968},
	{17426, 165552, 4, 968},
	{17447, 165556, 4, 968},
	{17468, 165560, 4, 968},
	{17489, 165564, 4, 968},
	{17510, 165568, 4, 968},
	{17531, 165572, 2, 977},
	{17549, 165580, 16, 980},
	{17566, 165584, 16, 980},
	{17584, 165588, 7, 996},
	{17605, 165592, 3, 4973},
	{17623, 165600, 7, 1009},
	{17638, 165608, 2, 701},
	{17677, 165644, 4, 1017},
	{17699, 165648, 1, 1022},
	{17719, 165652, 8, 1023},
	{17945, 165760, 9, 1070},
	{17963, 165764, 9, 1070},
	{17981, 165768, 9, 1070},
	{17999, 165772, 9, 1070},
	{18017, 165776, 9, 1070},
	{18035, 165780, 9, 1070},
	{18053, 165784, 9, 1070},
	{18071, 165788, 9, 1070},
	{18089, 165836, 1, 1079},
	{18103, 165840, 1, 1079},
	{18118, 165844},
	{18136, 165848},
	{18154, 165852},
	{18171, 165856},
	{18192, 165860, 1, 4976},
	{18208, 165864},
	{18221, 165872, 5, 1081},
	{18240, 165876},
	{18255, 165880, 1, 1089},
	{18304, 165888, 10, 1091},
	{18321, 165892, 12, 1101},
	{18329, 165896, 3, 4977},
	{18346, 165900, 12, 1117},
	{18364, 165904, 19, 1134},
	{18380, 165908, 13, 1154},
	{18399, 165912, 10, 1170},
	{18414, 165916, 26, 1180},
	{18432, 165920, 16, 1208},
	{18450, 165924, 4, 1224},
	{18474, 165928},
	{18499, 165932, 11, 1228},
	{18651, 166400, 2, 1260},
	{18668, 166404, 2, 1262},
	{18687, 166408, 1, 1264},
	{18703, 166412, 4, 1265},
	{18722, 166416, 1, 1269},
	{18743, 166420, 1, 1270},
	{18756, 166424},
	{18779, 166428},
	{18802, 166432, 1, 1271},
	{18822, 166436, 4, 4980},
	{18842, 166440, 1, 1276},
	{18863, 166444, 1, 1277},
	{18878, 166448, 6, 1278},
	{18900, 166452, 6, 1278},
	{18922, 166456, 8, 1284},
	{18948, 166460, 8, 1284},
	{18974, 166464, 15, 1292},
	{19005, 166472, 4, 1310},
	{19023, 166476, 24, 1317},
	{19041, 166480},
	{19053, 166484, 1, 1341},
	{19067, 166488, 1, 1342},
	{19081, 166492, 1, 1343},
	{19095, 166496, 1, 1344},
	{19118, 166500, 1, 1344},
	{19141, 166504, 1, 1344},
	{19164, 166508, 5, 4984},
	{19185, 166512},
	{19196, 166516},
	{19209, 166520},
	{19226, 166524, 7, 4989},
	{19256, 166532, 2, 1358},
	{19275, 166536},
	{19297, 166540},
	{19319, 166544, 3, 4996},
	{19339, 166548, 1, 1364},
	{19388, 166560},
	{19413, 166564},
	{19438, 166568, 6, 1371},
	{19457, 166572, 1, 1377},
	{19480, 166576, 1, 1377},
	{19503, 166580, 1, 1378},
	{19517, 166584, 1, 1379},
	{19532, 166588, 7, 4999},
	{19549, 166592, 4, 1389},
	{19576, 166596, 4, 1393},
	{19603, 166600, 4, 1397},
	{19622, 166608},
	{19648, 166612, 1, 1401},
	{19673, 166620},
	{19701, 166624},
	{19727, 166628, 1, 1401},
	{19752, 166636},
	{19780, 166640},
	{19806, 166644, 1, 1401},
	{19831, 166652},
	{19859, 166656},
	{19885, 166660, 1, 1401},
	{19910, 166668},
	{19938, 166696},
	{19969, 166700},
	{20012, 166704, 1, 1402},
	{20050, 166712, 1, 1403},
	{20111, 166740, 6, 1411},
	{20132, 166744, 3, 1430},
	{20149, 166748, 1, 1377},
	{20170, 166752, 1, 1377},
	{20193, 166756, 1, 1377},
	{20216, 166760, 1, 1377},
	{20239, 166764, 8, 5006},
	{20252, 166768, 6, 1445},
	{20293, 166776, 2, 1451},
	{20323, 166780},
	{20347, 166784},
	{20377, 166788},
	{20408, 166792},
	{20437, 166796},
	{20467, 166800, 2, 1453},
	{20487, 166804, 7, 5014},
	{20506, 166808, 4, 1464},
	{20556, 166868, 8, 1468},
	{20582, 166872, 8, 1476},
	{20608, 166876, 4, 1484},
	{20624, 166880, 5, 1489},
	{20640, 166884, 3, 1495},
	{20655, 166888},
	{20678, 166892},
	{20701, 166896},
	{20724, 166900},
	{20747, 166904, 8, 1498},
	{20781, 166908, 8, 1506},
	{20815, 166912, 8, 1514},
	{20849, 166916, 8, 1522},
	{20883, 166920, 8, 1498},
	{20917, 166924, 8, 1506},
	{20951, 166928, 8, 1514},
	{20985, 166932, 8, 1522},
	{21019, 166936, 8, 1498},
	{21053, 166940, 8, 1506},
	{21087, 166944, 8, 1514},
	{21121, 166948, 8, 1522},
	{21155, 166952, 8, 1498},
	{21189, 166956, 8, 1506},
	{21223, 166960, 8, 1514},
	{21257, 166964, 8, 1522},
	{21291, 166968, 2, 1530},
	{21315, 166972, 2, 1532},
	{21458, 167000, 1, 1574},
	{21486, 167004, 1, 1575},
	{21507, 167008},
	{21522, 167012, 2, 1576},
	{21538, 167016, 1, 1578},
	{21554, 167020, 2, 4945},
	{21569, 167024, 15, 5021},
	{21584, 167028, 6, 1601},
	{21623, 167036},
	{21639, 167040, 1, 1621},
	{21661, 167044},
	{21677, 167048, 1, 1578},
	{21699, 167052},
	{21721, 167056},
	{21762, 167068},
	{21777, 167072, 2, 1576},
	{21793, 167076, 1, 1578},
	{21809, 167080, 2, 4945},
	{21824, 167084, 15, 5021},
	{21839, 167088, 6, 1601},
	{21878, 167096},
	{21894, 167100, 1, 1621},
	{21916, 167104},
	{21932, 167108, 1, 1578},
	{21954, 167112},
	{21976, 167116},
	{22017, 167128},
	{22032, 167132, 2, 1576},
	{22048, 167136, 1, 1578},
	{22064, 167140, 2, 4945},
	{22079, 167144, 15, 5021},
	{22094, 167148, 6, 1601},
	{22133, 167156},
	{22149, 167160, 1, 1621},
	{22171, 167164},
	{22187, 167168, 1, 1578},
	{22209, 167172},
	{22231, 167176},
	{22272, 167188},
	{22287, 167192, 2, 1576},
	{22303, 167196, 1, 1578},
	{22319, 167200, 2, 4945},
	{22334, 167204, 15, 5021},
	{22349, 167208, 6, 1601},
	{22388, 167216},
	{22404, 167220, 1, 1621},
	{22426, 167224},
	{22442, 167228, 1, 1578},
	{22464, 167232},
	{22486, 167236},
	{22527, 167248},
	{22542, 167252, 2, 1576},
	{22558, 167256, 1, 1578},
	{22574, 167260, 2, 4945},
	{22589, 167264, 15, 5021},
	{22604, 167268, 6, 1601},
	{22643, 167276},
	{22659, 167280, 1, 1621},
	{22681, 167284},
	{22697, 167288, 1, 1578},
	{22719, 167292},
	{22741, 167296},
	{22782, 167308},
	{22797, 167312, 2, 1576},
	{22813, 167316, 1, 1578},
	{22829, 167320, 2, 4945},
	{22844, 167324, 15, 5021},
	{22859, 167328, 6, 1601},
	{22898, 167336},
	{22914, 167340, 1, 1621},
	{22936, 167344},
	{22952, 167348, 1, 1578},
	{22974, 167352},
	{22996, 167356},
	{23037, 167368},
	{23052, 167372, 2, 1576},
	{23068, 167376, 1, 1578},
	{23084, 167380, 2, 4945},
	{23099, 167384, 15, 5021},
	{23114, 167388, 6, 1601},
	{23153, 167396},
	{23169, 167400, 1, 1621},
	{23191, 167404},
	{23207, 167408, 1, 1578},
	{23229, 167412},
	{23251, 167416},
	{23292, 167428},
	{23307, 167432, 2, 1576},
	{23323, 167436, 1, 1578},
	{23339, 167440, 2, 4945},
	{23354, 167444, 15, 5021},
	{23369, 167448, 6, 1601},
	{23408, 167456},
	{23424, 167460, 1, 1621},
	{23446, 167464},
	{23462, 167468, 1, 1578},
	{23484, 167472},
	{23506, 167476},
	{206, 880, 4, 5036},
	{43152, 881},
	{26999, 882},
	{43164, 1008},
	{43175, 1009},
	{27187, 1010, 4, 2167},
	{43186, 1040, 1, 2171},
	{43199, 1041, 5, 5040},
	{43212, 1042, 1, 2177},
	{43225, 1043, 1, 1688},
	{27021, 1045, 9, 5045},
	{43253, 1281, 4, 5054},
	{43268, 1282},
	{26958, 1283},
	{43152, 1285},
	{26999, 1286},
};

static const struct si_reg gfx7_reg_table[] = {
	{1310, 68, 9, 5058},
	{1323, 72, 24, 3893},
	{1338, 76, 3, 5067},
	{51171, 80, 11, 5070},
	{1375, 84, 4, 3931},
	{1393, 88, 2, 3935},
	{1411, 92, 4, 5081},
	{1426, 96},
	{1440, 100, 1, 3941},
	{1454, 104},
	{51185, 108},
	{51202, 112, 13, 3942},
	{51218, 2480},
	{51233, 2484, 1, 3955},
	{51248, 2488},
	{51263, 2492, 1, 3955},
	{1609, 2496},
	{1623, 2500},
	{1637, 2504},
	{1651, 2508},
	{1665, 2512},
	{1679, 2516},
	{1693, 2520},
	{1707, 2524},
	{1721, 2528},
	{1735, 2532},
	{1749, 2536},
	{1764, 2540},
	{1839, 2544},
	{1850, 2552},
	{1866, 2556},
	{51278, 3660, 21, 3956},
	{51291, 3664, 20, 3977},
	{51303, 3668, 16, 3997},
	{1954, 32776, 17, 5085},
	{1967, 32784, 24, 4035},
	{1979, 32788, 11, 4059},
	{1995, 32792, 11, 4059},
	{2024, 32824, 11, 4059},
	{2040, 32828, 11, 4059},
	{2056, 33296, 16, 5102},
	{2070, 33300, 28, 204},
	{2087, 33304, 17, 5118},
	{2108, 33308, 18, 5135},
	{2122, 33312, 31, 5153},
	{2139, 33316, 7, 5184},
	{54824, 33320, 1, 4333},
	{2178, 33324, 1, 329},
	{2201, 33344, 1, 1711},
	{2222, 33348},
	{2283, 33436, 1, 342},
	{53768, 36352},
	{53789, 36356, 1, 4637},
	{2431, 36360, 9, 5191},
	{2452, 36364, 3, 4646},
	{53810, 36368, 2, 4649},
	{54839, 36372, 2, 5200},
	{54861, 36376, 1, 5202},
	{2410, 36400, 2, 4651},
	{2500, 36404, 5, 5203},
	{53836, 36408, 15, 4658},
	{2479, 36412, 1, 4673},
	{53857, 36416},
	{53878, 36424, 1, 4674},
	{2687, 36608},
	{2705, 36612, 4, 383},
	{2723, 36616},
	{2741, 36620, 14, 4699},
	{3642, 36624},
	{3660, 36628, 5, 4713},
	{3678, 36632, 4, 4718},
	{3696, 36636, 11, 4722},
	{3714, 36640, 2, 4733},
	{3732, 36644, 2, 4735},
	{3750, 36648, 4, 4737},
	{3768, 36652},
	{2759, 36656, 13, 4741},
	{2777, 36660, 4, 411},
	{2795, 36664, 9, 4754},
	{2813, 36668, 3, 4763},
	{2831, 37120, 6, 426},
	{2847, 39160, 9, 4766},
	{2862, 39184, 5, 4776},
	{2876, 39188, 5, 4776},
	{2890, 39192, 5, 4776},
	{2904, 39196, 5, 4776},
	{2918, 39200, 5, 4776},
	{2932, 39204, 5, 4776},
	{2946, 39208, 5, 4776},
	{2960, 39212, 5, 4776},
	{2974, 39216, 5, 4776},
	{2988, 39220, 5, 4776},
	{3002, 39224, 5, 4776},
	{3017, 39228, 5, 4776},
	{3032, 39232, 5, 4776},
	{3047, 39236, 5, 4776},
	{3062, 39240, 5, 4776},
	{3077, 39244, 5, 4776},
	{3092, 39248, 5, 4776},
	{3107, 39252, 5, 4776},
	{3122, 39256, 5, 4776},
	{3137, 39260, 5, 4776},
	{3152, 39264, 5, 4776},
	{3167, 39268, 5, 4776},
	{3182, 39272, 5, 4776},
	{3197, 39276, 5, 4776},
	{3212, 39280, 5, 4776},
	{3227, 39284, 5, 4776},
	{3242, 39288, 5, 4776},
	{3257, 39292, 5, 4776},
	{3272, 39296, 5, 4776},
	{3287, 39300, 5, 4776},
	{3302, 39304, 5, 4776},
	{3317, 39308, 5, 4776},
	{3332, 39312, 4, 445},
	{3351, 39316, 4, 445},
	{3370, 39320, 4, 445},
	{3389, 39324, 4, 445},
	{3408, 39328, 4, 445},
	{3427, 39332, 4, 445},
	{3446, 39336, 4, 445},
	{3465, 39340, 4, 445},
	{3484, 39344, 4, 445},
	{3503, 39348, 4, 445},
	{3522, 39352, 4, 445},
	{3542, 39356, 4, 445},
	{3562, 39360, 4, 445},
	{3582, 39364, 4, 445},
	{3602, 39368, 4, 445},
	{3622, 39372, 4, 445},
	{54091, 45056},
	{54112, 45060, 1, 498},
	{54133, 45064},
	{54154, 45068, 1, 498},
	{3867, 45084, 3, 495},
	{3891, 45088},
	{3912, 45092, 1, 498},
	{3933, 45096, 11, 4781},
	{3957, 45100, 6, 510},
	{3981, 45104},
	{4007, 45108},
	{4033, 45112},
	{4059, 45116},
	{4085, 45120},
	{4111, 45124},
	{4137, 45128},
	{4163, 45132},
	{4189, 45136},
	{4215, 45140},
	{4241, 45144},
	{4268, 45148},
	{4295, 45152},
	{4322, 45156},
	{4349, 45160},
	{4376, 45164},
	{54175, 45312},
	{54196, 45316, 1, 498},
	{54217, 45320},
	{54238, 45324, 1, 498},
	{5048, 45336, 3, 495},
	{5072, 45340, 1, 534},
	{5097, 45344},
	{5118, 45348, 1, 498},
	{5139, 45352, 12, 4798},
	{5163, 45356, 10, 547},
	{5187, 45360},
	{5213, 45364},
	{5239, 45368},
	{5265, 45372},
	{5291, 45376},
	{5317, 45380},
	{5343, 45384},
	{5369, 45388},
	{5395, 45392},
	{5421, 45396},
	{5447, 45400},
	{5474, 45404},
	{5501, 45408},
	{5528, 45412},
	{5555, 45416},
	{5582, 45420},
	{6232, 45552, 6, 570},
	{6259, 45556, 5, 576},
	{54259, 45568},
	{54280, 45572, 1, 498},
	{54301, 45576},
	{54322, 45580, 1, 498},
	{6447, 45596, 3, 495},
	{6471, 45600},
	{6492, 45604, 1, 498},
	{6513, 45608, 11, 4820},
	{6537, 45612, 4, 561},
	{6561, 45616},
	{6587, 45620},
	{6613, 45624},
	{6639, 45628},
	{6665, 45632},
	{6691, 45636},
	{6717, 45640},
	{6743, 45644},
	{6769, 45648},
	{6795, 45652},
	{6821, 45656},
	{6848, 45660},
	{6875, 45664},
	{6902, 45668},
	{6929, 45672},
	{6956, 45676},
	{7591, 45808, 6, 570},
	{54343, 45824},
	{54364, 45828, 1, 498},
	{54385, 45832},
	{54406, 45836, 1, 498},
	{7618, 45852, 3, 495},
	{7642, 45856},
	{7663, 45860, 1, 498},
	{7684, 45864, 12, 4798},
	{7708, 45868, 6, 570},
	{7732, 45872},
	{7758, 45876},
	{7784, 45880},
	{7810, 45884},
	{7836, 45888},
	{7862, 45892},
	{7888, 45896},
	{7914, 45900},
	{7940, 45904},
	{7966, 45908},
	{7992, 45912},
	{8019, 45916},
	{8046, 45920},
	{8073, 45924},
	{8100, 45928},
	{8127, 45932},
	{8154, 46068, 5, 576},
	{54427, 46080},
	{54448, 46084, 1, 498},
	{54469, 46088},
	{54490, 46092, 1, 498},
	{8342, 46108, 2, 619},
	{8366, 46112},
	{8387, 46116, 1, 498},
	{8408, 46120, 10, 4841},
	{8432, 46124, 6, 635},
	{8456, 46128},
	{8482, 46132},
	{8508, 46136},
	{8534, 46140},
	{8560, 46144},
	{8586, 46148},
	{8612, 46152},
	{8638, 46156},
	{8664, 46160},
	{8690, 46164},
	{8716, 46168},
	{8743, 46172},
	{8770, 46176},
	{8797, 46180},
	{8824, 46184},
	{8851, 46188},
	{9486, 46324, 5, 576},
	{54511, 46336},
	{54532, 46340, 1, 498},
	{54553, 46344},
	{54574, 46348, 1, 498},
	{9513, 46364, 3, 495},
	{9537, 46368},
	{9558, 46372, 1, 498},
	{9579, 46376, 11, 4857},
	{9603, 46380, 5, 576},
	{9627, 46384},
	{9653, 46388},
	{9679, 46392},
	{9705, 46396},
	{9731, 46400},
	{9757, 46404},
	{9783, 46408},
	{9809, 46412},
	{9835, 46416},
	{9861, 46420},
	{9887, 46424},
	{9914, 46428},
	{9941, 46432},
	{9968, 46436},
	{9995, 46440},
	{10022, 46444},
	{10049, 47104, 12, 4873},
	{10076, 47108},
	{10090, 47112},
	{10104, 47116},
	{10118, 47120},
	{10134, 47124},
	{10150, 47128},
	{10166, 47132, 2, 666},
	{10187, 47136, 2, 666},
	{10208, 47140, 2, 666},
	{10229, 47144, 1, 668},
	{10257, 47148, 1, 669},
	{10282, 47152},
	{10297, 47156, 2, 4886},
	{54615, 47160},
	{54630, 47164, 1, 670},
	{54645, 47168},
	{54660, 47172, 1, 670},
	{10436, 47176, 10, 4888},
	{10454, 47180, 11, 683},
	{10472, 47184, 1, 694},
	{10485, 47188, 6, 695},
	{54675, 47192, 2, 4905},
	{54706, 47196, 2, 4905},
	{10563, 47200, 2, 701},
	{54889, 47204, 2, 4905},
	{54920, 47208, 2, 4905},
	{10638, 47212},
	{10656, 47216},
	{10674, 47220},
	{10692, 47224, 1, 703},
	{10720, 47228, 4, 704},
	{11038, 47360},
	{11058, 47364},
	{11078, 47368},
	{11098, 47372},
	{11118, 47376},
	{11138, 47380},
	{11158, 47384},
	{11178, 47388},
	{11198, 47392},
	{11218, 47396},
	{11238, 47400},
	{11259, 47404},
	{11280, 47408},
	{11301, 47412},
	{11322, 47416},
	{11343, 47420},
	{54737, 53300, 29, 4907},
	{54754, 55348, 29, 4907},
	{11425, 163840, 9, 726},
	{11443, 163844, 9, 4936},
	{11460, 163848, 4, 4945},
	{11474, 163852, 23, 754},
	{11493, 163856, 15, 777},
	{11513, 163860},
	{11549, 163872},
	{11569, 163876},
	{11589, 163880, 1, 795},
	{11606, 163884},
	{11621, 163888, 2, 796},
	{11645, 163892, 2, 798},
	{54771, 163900, 7, 4949},
	{11703, 163904, 8, 4956},
	{11713, 163908, 5, 4964},
	{11729, 163912},
	{11744, 163916},
	{11765, 163920},
	{11781, 163924},
	{54785, 163928, 2, 4969},
	{54799, 163932, 1, 4971},
	{11971, 163968},
	{11987, 163972, 1, 847},
	{12006, 164328, 1, 848},
	{12027, 164332, 1, 848},
	{12048, 164336, 1, 848},
	{12069, 164340, 1, 848},
	{12090, 164344},
	{12108, 164348},
	{12126, 164352, 2, 849},
	{12146, 164356, 3, 851},
	{12170, 164360, 2, 854},
	{12194, 164364, 1, 856},
	{12214, 164368, 2, 851},
	{12234, 164372, 2, 854},
	{12254, 164376, 2, 851},
	{12274, 164380, 2, 854},
	{12294, 164384, 2, 851},
	{12314, 164388, 2, 854},
	{12334, 164392, 2, 851},
	{12354, 164396, 2, 854},
	{12374, 164400, 7, 857},
	{12389, 164404, 2, 864},
	{12418, 164408, 8, 866},
	{12433, 164412, 8, 874},
	{12448, 164416, 3, 851},
	{12473, 164420, 2, 854},
	{12498, 164424},
	{12516, 164428},
	{12534, 164432, 3, 851},
	{12559, 164436, 2, 854},
	{12584, 164440, 3, 851},
	{12609, 164444, 2, 854},
	{12634, 164448, 3, 851},
	{12659, 164452, 2, 854},
	{12684, 164456, 3, 851},
	{12709, 164460, 2, 854},
	{12734, 164464, 3, 851},
	{12759, 164468, 2, 854},
	{12784, 164472, 3, 851},
	{12809, 164476, 2, 854},
	{12834, 164480, 3, 851},
	{12859, 164484, 2, 854},
	{12884, 164488, 3, 851},
	{12909, 164492, 2, 854},
	{12934, 164496, 3, 851},
	{12959, 164500, 2, 854},
	{12984, 164504, 3, 851},
	{13009, 164508, 2, 854},
	{13034, 164512, 3, 851},
	{13060, 164516, 2, 854},
	{13086, 164520, 3, 851},
	{13112, 164524, 2, 854},
	{13138, 164528, 3, 851},
	{13164, 164532, 2, 854},
	{13190, 164536, 3, 851},
	{13216, 164540, 2, 854},
	{13242, 164544, 3, 851},
	{13268, 164548, 2, 854},
	{13294, 164552, 3, 851},
	{13320, 164556, 2, 854},
	{13346, 164560},
	{13365, 164564},
	{13384, 164568},
	{13403, 164572},
	{13422, 164576},
	{13441, 164580},
	{13460, 164584},
	{13479, 164588},
	{13498, 164592},
	{13517, 164596},
	{13536, 164600},
	{13555, 164604},
	{13574, 164608},
	{13593, 164612},
	{13612, 164616},
	{13631, 164620},
	{13650, 164624},
	{13669, 164628},
	{13688, 164632},
	{13707, 164636},
	{13726, 164640},
	{13746, 164644},
	{13766, 164648},
	{13786, 164652},
	{13806, 164656},
	{13826, 164660},
	{13846, 164664},
	{13866, 164668},
	{13886, 164672},
	{13906, 164676},
	{13926, 164680},
	{13946, 164684},
	{13966, 164688, 15, 882},
	{13986, 164692, 3, 897},
	{14008, 164696, 2, 900},
	{14065, 164704, 1, 909},
	{54814, 164708, 1, 4972},
	{14096, 164712, 1, 911},
	{14164, 164864},
	{14181, 164868},
	{14198, 164872},
	{14214, 164876},
	{14268, 164884},
	{14281, 164888},
	{14296, 164892},
	{14310, 164896},
	{14364, 164908, 6, 942},
	{14383, 164912, 4, 948},
	{14401, 164916, 4, 952},
	{14422, 164924},
	{14441, 164928},
	{14461, 164932},
	{14480, 164936},
	{14500, 164940},
	{14519, 164944},
	{14539, 164948},
	{14560, 164952},
	{14582, 164956},
	{14603, 164960},
	{14625, 164964},
	{14646, 164968},
	{14668, 164972},
	{14689, 164976},
	{14711, 164980},
	{14732, 164984},
	{14754, 164988},
	{14775, 164992},
	{14797, 164996},
	{14818, 165000},
	{14840, 165004},
	{14861, 165008},
	{14883, 165012},
	{14904, 165016},
	{14926, 165020},
	{14947, 165024},
	{14969, 165028},
	{14990, 165032},
	{15012, 165036},
	{15033, 165040},
	{15055, 165044},
	{15076, 165048},
	{15098, 165052},
	{15119, 165056},
	{15141, 165060},
	{15162, 165064},
	{15184, 165068},
	{15205, 165072},
	{15227, 165076},
	{15248, 165080},
	{15270, 165084},
	{15291, 165088},
	{15313, 165092},
	{15334, 165096},
	{15356, 165100},
	{15377, 165104},
	{15399, 165108},
	{15420, 165112},
	{15442, 165116},
	{15463, 165120},
	{15485, 165124},
	{15506, 165128},
	{15528, 165132},
	{15549, 165136},
	{15571, 165140},
	{15592, 165144},
	{15614, 165148},
	{15635, 165152},
	{15657, 165156},
	{15678, 165160},
	{15700, 165164},
	{15722, 165168},
	{15745, 165172},
	{15767, 165176},
	{15790, 165180},
	{15812, 165184},
	{15835, 165188},
	{15857, 165192},
	{15880, 165196},
	{15902, 165200},
	{15925, 165204},
	{15947, 165208},
	{15970, 165212},
	{15992, 165216},
	{16015, 165220},
	{16037, 165224},
	{16060, 165228},
	{16082, 165232},
	{16105, 165236},
	{16127, 165240},
	{16150, 165244},
	{16172, 165248},
	{16195, 165252},
	{16217, 165256},
	{16240, 165260},
	{16262, 165264},
	{16285, 165268},
	{16307, 165272},
	{16330, 165276},
	{16352, 165280},
	{16375, 165284},
	{16397, 165288},
	{16420, 165292},
	{16442, 165296},
	{16465, 165300},
	{16487, 165304},
	{16510, 165308},
	{16524, 165312},
	{16538, 165316},
	{16552, 165320},
	{16566, 165324},
	{16580, 165328},
	{16594, 165332},
	{16608, 165336},
	{16622, 165340},
	{16636, 165344},
	{16650, 165348},
	{16664, 165352},
	{16678, 165356},
	{16692, 165360},
	{16706, 165364},
	{16720, 165368},
	{16734, 165372},
	{16748, 165376},
	{16762, 165380},
	{16776, 165384},
	{16790, 165388},
	{16804, 165392},
	{16818, 165396},
	{16832, 165400},
	{16869, 165444, 6, 956},
	{16889, 165448, 6, 956},
	{16909, 165452, 6, 956},
	{16929, 165456, 6, 956},
	{16949, 165460, 6, 956},
	{16969, 165464, 6, 956},
	{16989, 165468, 6, 956},
	{17009, 165472, 6, 956},
	{17029, 165476, 6, 956},
	{17049, 165480, 6, 956},
	{17069, 165484, 6, 956},
	{17090, 165488, 6, 956},
	{17111, 165492, 6, 956},
	{17132, 165496, 6, 956},
	{17153, 165500, 6, 956},
	{17174, 165504, 6, 956},
	{17195, 165508, 6, 956},
	{17216, 165512, 6, 956},
	{17237, 165516, 6, 956},
	{17258, 165520, 6, 956},
	{17279, 165524, 4, 968},
	{17300, 165528, 4, 968},
	{17321, 165532, 4, 968},
	{17342, 165536, 4, 968},
	{17363, 165540, 4, 968},
	{17384, 165544, 4, 968},
	{17405, 165548, 4, 968},
	{17426, 165552, 4, 968},
	{17447, 165556, 4, 968},
	{17468, 165560, 4, 968},
	{17489, 165564, 4, 968},
	{17510, 165568, 4, 968},
	{17531, 165572, 2, 977},
	{17549, 165580, 16, 980},
	{17566, 165584, 16, 980},
	{17584, 165588, 7, 996},
	{17605, 165592, 3, 4973},
	{17623, 165600, 7, 1009},
	{17638, 165608, 2, 701},
	{17677, 165644, 4, 1017},
	{17699, 165648, 1, 1022},
	{17719, 165652, 8, 1023},
	{17945, 165760, 9, 1070},
	{17963, 165764, 9, 1070},
	{17981, 165768, 9, 1070},
	{17999, 165772, 9, 1070},
	{18017, 165776, 9, 1070},
	{18035, 165780, 9, 1070},
	{18053, 165784, 9, 1070},
	{18071, 165788, 9, 1070},
	{18089, 165836, 1, 1079},
	{18103, 165840, 1, 1079},
	{18118, 165844},
	{18136, 165848},
	{18154, 165852},
	{18171, 165856},
	{18192, 165860, 1, 4976},
	{18208, 165864},
	{18221, 165872, 5, 1081},
	{18240, 165876},
	{18255, 165880, 1, 1089},
	{18304, 165888, 10, 1091},
	{18321, 165892, 12, 1101},
	{18329, 165896, 3, 4977},
	{18346, 165900, 12, 1117},
	{18364, 165904, 19, 1134},
	{18380, 165908, 13, 1154},
	{18399, 165912, 10, 1170},
	{18414, 165916, 26, 1180},
	{18432, 165920, 16, 1208},
	{18450, 165924, 4, 1224},
	{18474, 165928},
	{18499, 165932, 11, 1228},
	{18651, 166400, 2, 1260},
	{18668, 166404, 2, 1262},
	{18687, 166408, 1, 1264},
	{18703, 166412, 4, 1265},
	{18722, 166416, 1, 1269},
	{18743, 166420, 1, 1270},
	{18756, 166424},
	{18779, 166428},
	{18802, 166432, 1, 1271},
	{18822, 166436, 4, 4980},
	{18842, 166440, 1, 1276},
	{18863, 166444, 1, 1277},
	{18878, 166448, 6, 1278},
	{18900, 166452, 6, 1278},
	{18922, 166456, 8, 1284},
	{18948, 166460, 8, 1284},
	{18974, 166464, 15, 1292},
	{18986, 166468, 2, 1307},
	{19005, 166472, 4, 1310},
	{19023, 166476, 24, 1317},
	{19041, 166480},
	{19053, 166484, 1, 1341},
	{19067, 166488, 1, 1342},
	{19081, 166492, 1, 1343},
	{19095, 166496, 1, 1344},
	{19118, 166500, 1, 1344},
	{19141, 166504, 1, 1344},
	{19164, 166508, 5, 4984},
	{19185, 166512},
	{19196, 166516},
	{19209, 166520},
	{19226, 166524, 7, 4989},
	{19245, 166528},
	{19256, 166532, 2, 1358},
	{19275, 166536},
	{19297, 166540},
	{19319, 166544, 3, 4996},
	{19339, 166548, 1, 1364},
	{19388, 166560},
	{19413, 166564},
	{19438, 166568, 6, 1371},
	{19457, 166572, 1, 1377},
	{19480, 166576, 1, 1377},
	{19503, 166580, 1, 1378},
	{19517, 166584, 1, 1379},
	{19532, 166588, 7, 4999},
	{19549, 166592, 4, 1389},
	{19576, 166596, 4, 1393},
	{19603, 166600, 4, 1397},
	{19622, 166608},
	{19648, 166612, 1, 1401},
	{19673, 166620},
	{19701, 166624},
	{19727, 166628, 1, 1401},
	{19752, 166636},
	{19780, 166640},
	{19806, 166644, 1, 1401},
	{19831, 166652},
	{19859, 166656},
	{19885, 166660, 1, 1401},
	{19910, 166668},
	{19938, 166696},
	{19969, 166700},
	{20012, 166704, 1, 1402},
	{20050, 166712, 1, 1403},
	{20111, 166740, 6, 1411},
	{20132, 166744, 3, 1430},
	{20149, 166748, 1, 1377},
	{20170, 166752, 1, 1377},
	{20193, 166756, 1, 1377},
	{20216, 166760, 1, 1377},
	{20239, 166764, 8, 5006},
	{20252, 166768, 6, 1445},
	{20269, 166772},
	{20293, 166776, 2, 1451},
	{20323, 166780},
	{20347, 166784},
	{20377, 166788},
	{20408, 166792},
	{20437, 166796},
	{20467, 166800, 2, 1453},
	{20487, 166804, 7, 5014},
	{20506, 166808, 4, 1464},
	{20556, 166868, 8, 1468},
	{20582, 166872, 8, 1476},
	{20608, 166876, 4, 1484},
	{20624, 166880, 5, 1489},
	{20640, 166884, 3, 1495},
	{20655, 166888},
	{20678, 166892},
	{20701, 166896},
	{20724, 166900},
	{20747, 166904, 8, 1498},
	{20781, 166908, 8, 1506},
	{20815, 166912, 8, 1514},
	{20849, 166916, 8, 1522},
	{20883, 166920, 8, 1498},
	{20917, 166924, 8, 1506},
	{20951, 166928, 8, 1514},
	{20985, 166932, 8, 1522},
	{21019, 166936, 8, 1498},
	{21053, 166940, 8, 1506},
	{21087, 166944, 8, 1514},
	{21121, 166948, 8, 1522},
	{21155, 166952, 8, 1498},
	{21189, 166956, 8, 1506},
	{21223, 166960, 8, 1514},
	{21257, 166964, 8, 1522},
	{21291, 166968, 2, 1530},
	{21315, 166972, 2, 1532},
	{21458, 167000, 1, 1574},
	{21486, 167004, 1, 1575},
	{21507, 167008},
	{21522, 167012, 2, 1576},
	{21538, 167016, 1, 1578},
	{21554, 167020, 2, 4945},
	{21569, 167024, 15, 5021},
	{21584, 167028, 6, 1601},
	{21623, 167036},
	{21639, 167040, 1, 1621},
	{21661, 167044},
	{21677, 167048, 1, 1578},
	{21699, 167052},
	{21721, 167056},
	{21762, 167068},
	{21777, 167072, 2, 1576},
	{21793, 167076, 1, 1578},
	{21809, 167080, 2, 4945},
	{21824, 167084, 15, 5021},
	{21839, 167088, 6, 1601},
	{21878, 167096},
	{21894, 167100, 1, 1621},
	{21916, 167104},
	{21932, 167108, 1, 1578},
	{21954, 167112},
	{21976, 167116},
	{22017, 167128},
	{22032, 167132, 2, 1576},
	{22048, 167136, 1, 1578},
	{22064, 167140, 2, 4945},
	{22079, 167144, 15, 5021},
	{22094, 167148, 6, 1601},
	{22133, 167156},
	{22149, 167160, 1, 1621},
	{22171, 167164},
	{22187, 167168, 1, 1578},
	{22209, 167172},
	{22231, 167176},
	{22272, 167188},
	{22287, 167192, 2, 1576},
	{22303, 167196, 1, 1578},
	{22319, 167200, 2, 4945},
	{22334, 167204, 15, 5021},
	{22349, 167208, 6, 1601},
	{22388, 167216},
	{22404, 167220, 1, 1621},
	{22426, 167224},
	{22442, 167228, 1, 1578},
	{22464, 167232},
	{22486, 167236},
	{22527, 167248},
	{22542, 167252, 2, 1576},
	{22558, 167256, 1, 1578},
	{22574, 167260, 2, 4945},
	{22589, 167264, 15, 5021},
	{22604, 167268, 6, 1601},
	{22643, 167276},
	{22659, 167280, 1, 1621},
	{22681, 167284},
	{22697, 167288, 1, 1578},
	{22719, 167292},
	{22741, 167296},
	{22782, 167308},
	{22797, 167312, 2, 1576},
	{22813, 167316, 1, 1578},
	{22829, 167320, 2, 4945},
	{22844, 167324, 15, 5021},
	{22859, 167328, 6, 1601},
	{22898, 167336},
	{22914, 167340, 1, 1621},
	{22936, 167344},
	{22952, 167348, 1, 1578},
	{22974, 167352},
	{22996, 167356},
	{23037, 167368},
	{23052, 167372, 2, 1576},
	{23068, 167376, 1, 1578},
	{23084, 167380, 2, 4945},
	{23099, 167384, 15, 5021},
	{23114, 167388, 6, 1601},
	{23153, 167396},
	{23169, 167400, 1, 1621},
	{23191, 167404},
	{23207, 167408, 1, 1578},
	{23229, 167412},
	{23251, 167416},
	{23292, 167428},
	{23307, 167432, 2, 1576},
	{23323, 167436, 1, 1578},
	{23339, 167440, 2, 4945},
	{23354, 167444, 15, 5021},
	{23369, 167448, 6, 1601},
	{23408, 167456},
	{23424, 167460, 1, 1621},
	{23446, 167464},
	{23462, 167468, 1, 1578},
	{23484, 167472},
	{23506, 167476},
	{24571, 196608, 2, 4162},
	{24591, 196612, 1, 1635},
	{24611, 196616},
	{24631, 196620},
	{24651, 196624},
	{24672, 196628},
	{24693, 196632, 2, 4164},
	{24715, 196636, 1, 1637},
	{24737, 196640},
	{24767, 196644},
	{24797, 196648},
	{24826, 196652},
	{24855, 196656},
	{24885, 196660},
	{24915, 196664},
	{24944, 196668},
	{24973, 196672},
	{25003, 196676},
	{25033, 196680},
	{25062, 196684},
	{25091, 196688},
	{25121, 196692},
	{25151, 196696},
	{25180, 196700},
	{25209, 196704, 2, 4166},
	{25231, 196708, 1, 1639},
	{25253, 196712},
	{25276, 196716},
	{25299, 196720},
	{25322, 196724},
	{25345, 196728},
	{25368, 196732},
	{25391, 196736},
	{25415, 196740},
	{25439, 196744},
	{25463, 196748},
	{25487, 196752},
	{25511, 196756},
	{25535, 196760},
	{25559, 196764},
	{25583, 196768},
	{25605, 196772},
	{25627, 196776},
	{25648, 196780},
	{25669, 196784},
	{25693, 196788},
	{25717, 196792},
	{25741, 196796},
	{25765, 196800},
	{25789, 196804},
	{25917, 196860, 1, 1642},
	{25933, 196864},
	{25946, 196868},
	{25959, 196872},
	{25972, 196876},
	{25985, 196880},
	{25998, 196884},
	{26011, 196888},
	{26024, 196892},
	{26151, 196928, 2, 1643},
	{26164, 196932},
	{26177, 196936},
	{26200, 196940},
	{26223, 196944},
	{26251, 196948},
	{26279, 196952},
	{26307, 196956},
	{26335, 196960, 1, 1645},
	{26353, 196964, 3, 5208},
	{26371, 196968},
	{26386, 196972},
	{26410, 196976},
	{26434, 196980},
	{26453, 196984},
	{26472, 196988},
	{26496, 196992},
	{26520, 196996},
	{26544, 197000},
	{26568, 197028, 2, 4171},
	{26586, 197032, 1, 1651},
	{26604, 197036},
	{26622, 197040},
	{26640, 197044, 2, 4174},
	{26658, 197048, 1, 1654},
	{26676, 197052},
	{26694, 197056, 2, 1656},
	{26713, 197060, 5, 1658},
	{26732, 197072},
	{26756, 197076, 2, 1656},
	{26776, 197080, 5, 1658},
	{26796, 197084, 8, 5211},
	{26815, 197088, 8, 5211},
	{26833, 197092, 1, 1670},
	{26850, 197100, 1, 1671},
	{26871, 197104, 23, 4182},
	{26885, 197108},
	{26899, 197112},
	{26913, 197116, 4, 4205},
	{26929, 197120},
	{26948, 197124, 1, 1687},
	{26970, 197128},
	{26989, 197132, 1, 1688},
	{27011, 197136, 9, 4211},
	{27029, 197140},
	{27049, 197144, 1, 1687},
	{27072, 197148},
	{27092, 197152, 1, 1688},
	{27115, 197156, 9, 4211},
	{27134, 197160, 5, 4220},
	{27146, 197164, 2, 1703},
	{27163, 197168, 1, 1705},
	{27180, 197172, 1, 1706},
	{27198, 197176, 5, 2654},
	{27218, 197180, 1, 1711},
	{27235, 197184},
	{27251, 197188, 1, 1713},
	{27264, 197192, 1, 1714},
	{27278, 197196, 1, 1715},
	{27292, 197200, 1, 1716},
	{27314, 197204, 1, 1717},
	{27334, 197208, 1, 1718},
	{27356, 197212, 1, 1719},
	{27376, 197216, 1, 1714},
	{27393, 197220, 1, 1715},
	{27410, 197224},
	{27669, 197388, 1, 1728},
	{27688, 197392, 1, 1729},
	{27707, 197396, 1, 1730},
	{27724, 197400, 1, 1731},
	{27742, 197404, 1, 1732},
	{27760, 197408, 1, 1733},
	{27776, 197412, 1, 1734},
	{27794, 197416, 1, 1735},
	{27812, 197420, 1, 1736},
	{27828, 197424, 1, 1731},
	{27843, 197428, 1, 1732},
	{27858, 197432, 1, 1733},
	{27871, 197436, 1, 1734},
	{27886, 197440, 1, 1735},
	{27901, 197444, 1, 1736},
	{27914, 197448, 1, 1737},
	{27928, 197452, 1, 1738},
	{27942, 197456, 1, 1739},
	{27954, 197460, 4, 5219},
	{27977, 197464, 4, 5223},
	{28677, 198656, 6, 4077},
	{28692, 198912},
	{28711, 198916},
	{28730, 198920, 1, 4460},
	{28749, 198924, 1, 4461},
	{28764, 198928},
	{28797, 198932},
	{28830, 198936},
	{28863, 198940},
	{28953, 198960},
	{28969, 198964},
	{28987, 198968, 1, 1792},
	{29004, 198972, 2, 1793},
	{29025, 198976},
	{29357, 199168, 1, 1816},
	{29382, 199172, 2, 1817},
	{29407, 199184, 2, 1819},
	{29433, 199188, 2, 1819},
	{29459, 199192, 2, 1819},
	{29485, 199212, 2, 1819},
	{29511, 199296, 2, 1821},
	{29539, 199300, 1, 1823},
	{29563, 199304, 1, 1824},
	{29587, 199308, 1, 1825},
	{29620, 199312, 1, 1825},
	{29648, 199328, 2, 1821},
	{29677, 199332, 1, 1823},
	{29702, 199336, 1, 1824},
	{29727, 199340, 1, 1825},
	{29761, 199344, 1, 1825},
	{29790, 199360, 2, 1821},
	{29814, 199364, 1, 1823},
	{29834, 199368, 1, 1824},
	{29854, 199372, 1, 1825},
	{29883, 199376, 1, 1825},
	{29907, 199936},
	{29934, 199940},
	{29961, 199944},
	{29988, 199948},
	{30123, 199968, 3, 4584},
	{30148, 200192},
	{30167, 200196, 1, 847},
	{30189, 200448},
	{30213, 200452, 1, 1835},
	{30236, 200456},
	{30260, 200460, 1, 1835},
	{30283, 200464},
	{30307, 200468, 1, 1835},
	{30330, 200472},
	{30354, 200476, 1, 1835},
	{30377, 200696},
	{30396, 200700, 1, 1835},
	{30414, 200704},
	{30426, 200708},
	{30438, 200712},
	{30456, 200716},
	{30475, 200720},
	{30493, 200724},
	{30505, 200728},
	{30517, 200732},
	{30535, 200736},
	{30553, 200740},
	{30572, 200744, 4, 5227},
	{30586, 200748, 2, 1840},
	{30604, 200752, 2, 1842},
	{30618, 200756, 2, 1844},
	{30632, 200760, 2, 1846},
	{30649, 200764, 2, 1848},
	{30666, 200768},
	{30679, 200772, 2, 1850},
	{30691, 200776},
	{30705, 200780},
	{30721, 200784},
	{30735, 200788},
	{30751, 200792},
	{30766, 200796},
	{30783, 200800},
	{30798, 200804},
	{30815, 200808, 2, 1852},
	{30837, 200812, 9, 5231},
	{30854, 200816, 2, 1864},
	{30875, 200820, 2, 1866},
	{30887, 200824},
	{30902, 200828, 6, 1868},
	{30917, 200832, 2, 1874},
	{30931, 200836},
	{31044, 212992},
	{31064, 212996},
	{31084, 213000},
	{31104, 213004},
	{31124, 213008},
	{31144, 213012},
	{31164, 213016},
	{31184, 213020},
	{31204, 213024},
	{31224, 213028},
	{31244, 213032},
	{31264, 213036},
	{31353, 213248},
	{31374, 213252},
	{31395, 213260},
	{31416, 213264},
	{31437, 213268},
	{31461, 213272},
	{31485, 213276},
	{31509, 213280},
	{31533, 213284},
	{31557, 213288},
	{31581, 213292},
	{31605, 213296},
	{54951, 213504},
	{54970, 213508},
	{54989, 213512},
	{55008, 213516},
	{55027, 213520},
	{55046, 213524},
	{55065, 213528},
	{55084, 213532},
	{52441, 213536},
	{52460, 213540},
	{52479, 213544},
	{52498, 213548},
	{52517, 213552},
	{52536, 213556},
	{52555, 213560},
	{52574, 213564},
	{52994, 213568},
	{53014, 213572},
	{53034, 213576},
	{53054, 213580},
	{53074, 213584},
	{53094, 213588},
	{53114, 213592},
	{53134, 213596},
	{32089, 214016},
	{32111, 214020, 1, 1876},
	{32133, 214024},
	{32155, 214028, 1, 1876},
	{32177, 214032},
	{32199, 214036, 1, 1876},
	{32221, 214040},
	{32243, 214044, 1, 1876},
	{32265, 214272},
	{32287, 214276},
	{32309, 214280},
	{32331, 214284},
	{32353, 214288},
	{32375, 214292},
	{32397, 214296},
	{32419, 214300},
	{32441, 214304},
	{32463, 214308},
	{32485, 214312},
	{32507, 214316},
	{32529, 214320},
	{32551, 214324},
	{32573, 214328},
	{32595, 214332},
	{32617, 214528},
	{32637, 214532},
	{32657, 214536},
	{32677, 214540},
	{32697, 214544},
	{32717, 214548},
	{32737, 214552},
	{32757, 214556},
	{32777, 214560},
	{32797, 214564},
	{32817, 214568},
	{32837, 214572},
	{32857, 214784},
	{32876, 214788},
	{32895, 214792},
	{32914, 214796},
	{32933, 214800},
	{32952, 214804},
	{32971, 214808},
	{32990, 214812},
	{33009, 214816},
	{33028, 214820},
	{33047, 214824},
	{33066, 214828},
	{33085, 214832},
	{33104, 214836},
	{33123, 214840},
	{33142, 214844},
	{33161, 214848},
	{33180, 214852},
	{33199, 214856},
	{33218, 214860},
	{33237, 214864},
	{33257, 214868},
	{33277, 214872},
	{33297, 214876},
	{33317, 214880},
	{33337, 214884},
	{33357, 214888},
	{33377, 214892},
	{33397, 214896},
	{33417, 214900},
	{33437, 214904},
	{33457, 214908},
	{33477, 215296},
	{33496, 215300},
	{33515, 215304},
	{33534, 215308},
	{33553, 215312},
	{33572, 215316},
	{33591, 215320},
	{33610, 215324},
	{33671, 215552},
	{33691, 215556},
	{33711, 215560},
	{33731, 215564},
	{33751, 215568},
	{33771, 215572},
	{33791, 215576},
	{33811, 215580},
	{33831, 215808},
	{33850, 215812},
	{33869, 215816},
	{33888, 215820},
	{33907, 216064},
	{33926, 216068},
	{33945, 216072},
	{33964, 216076},
	{33983, 216320},
	{34003, 216324},
	{34023, 216328},
	{34043, 216332},
	{34063, 216336},
	{34083, 216340},
	{34103, 216344},
	{34123, 216348},
	{55103, 216576},
	{55123, 216580},
	{55143, 216584},
	{55163, 216588},
	{55183, 216592},
	{55203, 216596},
	{55223, 216600},
	{55243, 216604},
	{55263, 216640},
	{55283, 216644},
	{55303, 216648},
	{55323, 216652},
	{55343, 216656},
	{55363, 216660},
	{55383, 216664},
	{55403, 216668},
	{55423, 216704},
	{55443, 216708},
	{55463, 216712},
	{55483, 216716},
	{55503, 216720},
	{55523, 216724},
	{55543, 216728},
	{55563, 216732},
	{34975, 217112},
	{34994, 217116},
	{35013, 217120},
	{35032, 217124},
	{35051, 217128},
	{35070, 217132},
	{35089, 217136},
	{35108, 217140},
	{35127, 217344},
	{35146, 217348},
	{35165, 217352},
	{35184, 217356},
	{35203, 217360},
	{35222, 217364},
	{35241, 217368},
	{35260, 217372},
	{35279, 217600},
	{35299, 217604},
	{35319, 217608},
	{35339, 217612},
	{36661, 221184, 1, 1910},
	{36685, 221188, 2, 5240},
	{36710, 221192, 3, 5242},
	{36734, 221196, 1, 1910},
	{36758, 221200, 2, 5240},
	{36783, 221204, 1, 1910},
	{36807, 221208, 2, 5240},
	{36832, 221212, 3, 5242},
	{36856, 221216, 4, 1888},
	{36872, 221220, 3, 5242},
	{37039, 221248},
	{37054, 221252, 1, 1825},
	{37077, 221256},
	{37100, 221260},
	{37118, 221264, 2, 1904},
	{37136, 221268, 4, 1906},
	{37156, 221440, 19, 4120},
	{37181, 221444, 19, 4120},
	{37206, 221448, 12, 4139},
	{37234, 221452, 12, 4139},
	{37262, 221456, 12, 4139},
	{37290, 221460, 12, 4139},
	{55583, 221696, 2, 4418},
	{55606, 221700, 2, 4418},
	{55629, 221704, 2, 4418},
	{55652, 221708, 2, 4418},
	{52349, 221712, 5, 1964},
	{52372, 221716, 2, 4418},
	{52395, 221720, 2, 4418},
	{52418, 221724, 2, 4418},
	{55675, 221728, 4, 1969},
	{52898, 221744, 5, 1964},
	{52922, 221748, 5, 1964},
	{52946, 221752, 2, 4418},
	{52970, 221756, 2, 4418},
	{55699, 221760, 4, 1969},
	{55724, 221764, 4, 1969},
	{52872, 221776, 1, 4459},
	{37748, 222208, 3, 1964},
	{37774, 222212, 2, 1884},
	{37801, 222216, 3, 1964},
	{37827, 222220, 2, 1884},
	{37854, 222224, 2, 2020},
	{37907, 222228, 2, 2020},
	{37960, 222464, 3, 1964},
	{37986, 222468, 2, 1884},
	{38013, 222472, 1, 1879},
	{38039, 222476, 1, 1879},
	{38065, 222480, 1, 1879},
	{38091, 222484, 1, 1879},
	{38117, 222488, 1, 1879},
	{38143, 222492, 1, 1879},
	{38169, 222496, 1, 1879},
	{38195, 222720, 3, 1964},
	{38219, 222724, 3, 1964},
	{38243, 222728, 3, 1964},
	{38267, 222732, 3, 1964},
	{38291, 222736, 2, 1884},
	{38316, 222740, 2, 1884},
	{38341, 222744, 2, 1884},
	{38366, 222748, 2, 1884},
	{38391, 222752, 1, 2008},
	{38415, 222756, 1, 2008},
	{38439, 222760, 8, 1973},
	{38460, 222976, 6, 5245},
	{38483, 222980, 6, 5245},
	{38506, 222984, 6, 5245},
	{38529, 222988, 6, 5245},
	{38552, 222992, 6, 5245},
	{38575, 222996, 6, 5245},
	{38598, 223000, 6, 5245},
	{38621, 223004, 6, 5245},
	{38644, 223008, 6, 5245},
	{38667, 223012, 6, 5245},
	{38690, 223016, 6, 5245},
	{38714, 223020, 6, 5245},
	{38738, 223024, 6, 5245},
	{38762, 223028, 6, 5245},
	{38786, 223032, 6, 5245},
	{38810, 223036, 6, 5245},
	{38834, 223104, 9, 4600},
	{55749, 223108, 2, 4649},
	{38854, 223112, 1, 1994},
	{38949, 223488, 3, 2003},
	{38972, 223492, 3, 2003},
	{38995, 223496, 3, 2003},
	{39018, 223500, 3, 2003},
	{39041, 223504, 2, 2006},
	{39065, 223508, 2, 2006},
	{39089, 223744, 3, 2003},
	{39113, 223748, 3, 2003},
	{39137, 223752, 3, 2003},
	{39161, 223756, 3, 2003},
	{39185, 223760, 2, 2006},
	{39210, 224000, 5, 2008},
	{39233, 224004, 4, 2013},
	{39257, 224008, 5, 2008},
	{39280, 224256, 5, 2008},
	{39303, 224260, 4, 2013},
	{39327, 224264, 5, 2008},
	{39350, 224512, 5, 1964},
	{39374, 224516, 4, 1969},
	{39399, 224520, 5, 1964},
	{39423, 224524, 4, 1969},
	{39448, 224528, 3, 2020},
	{39472, 224532, 3, 2020},
	{55769, 224768, 5, 1964},
	{55793, 224772, 4, 1958},
	{55818, 224776, 5, 1964},
	{55842, 224780, 4, 1958},
	{55867, 224784, 3, 2020},
	{55891, 224788, 3, 2020},
	{55915, 224832, 5, 1964},
	{55939, 224836, 4, 1958},
	{55964, 224840, 5, 1964},
	{55988, 224844, 4, 1958},
	{56013, 224848, 3, 2020},
	{56037, 224852, 3, 2020},
	{56061, 224896, 5, 1964},
	{56085, 224900, 4, 1958},
	{56110, 224904, 3, 2020},
	{56134, 224908, 3, 2020},
	{56158, 224912, 3, 2020},
	{40173, 225280, 12, 2023},
	{40195, 225284, 5, 2035},
	{40218, 225288, 4, 2040},
	{40242, 225292, 2, 2044},
	{40265, 225296, 2, 2044},
	{40288, 225300, 2, 2044},
	{40311, 225536, 5, 1964},
	{40334, 225540, 4, 1969},
	{40358, 225544, 5, 1964},
	{40381, 225548, 4, 1969},
	{40405, 225552, 5, 1964},
	{40428, 225560, 5, 1964},
	{40451, 225792, 4, 2046},
	{40472, 225796},
	{40501, 225800, 2, 2050},
	{40530, 225804},
	{40556, 225808, 7, 2052},
	{40630, 225812},
	{40653, 225816},
	{56182, 225820, 2, 5251},
	{56215, 225824, 2, 5251},
	{56248, 225828, 2, 5251},
	{56281, 225832, 2, 5251},
	{56313, 225836, 2, 5251},
	{56345, 225840, 2, 5251},
	{56377, 225844, 2, 5251},
	{56410, 225848, 2, 5251},
	{56442, 225856, 2, 5251},
	{56474, 225860, 2, 5251},
	{56507, 225864, 2, 5251},
	{56540, 225868, 2, 5251},
	{56573, 225872, 2, 5251},
	{56605, 225876, 2, 5251},
	{56637, 225880, 2, 5251},
	{56670, 225884, 2, 5251},
	{56703, 225888, 2, 5251},
	{56736, 225892, 2, 5251},
	{56769, 225896, 2, 5251},
	{40676, 225900},
	{40703, 225904},
	{40585, 225908},
	{40604, 225912},
	{56801, 225916, 2, 5251},
	{56835, 225920, 2, 5251},
	{56869, 225924, 2, 5251},
	{56903, 225928, 2, 5251},
	{41366, 226048, 2, 2126},
	{41383, 226052, 1, 2128},
	{41407, 226056, 1, 2128},
	{206, 880, 4, 2163},
	{43152, 881},
	{26999, 882},
	{43164, 1008},
	{43175, 1009},
	{27187, 1010, 4, 2167},
	{43186, 1040, 1, 2171},
	{43199, 1041, 5, 5253},
	{43212, 1042, 1, 2177},
	{43225, 1043, 1, 1688},
	{27021, 1045, 9, 5045},
	{43253, 1281, 6, 5258},
	{43268, 1282},
	{26958, 1283},
	{43152, 1285},
	{26999, 1286},
};

static const struct si_reg gfx8_reg_table[] = {
	{1310, 68, 10, 5264},
	{1323, 72, 23, 5274},
	{1338, 76, 4, 5297},
	{51171, 80, 11, 5070},
	{1375, 84, 4, 3931},
	{1393, 88, 2, 3935},
	{1411, 92, 6, 5301},
	{1426, 96},
	{1440, 100, 1, 3941},
	{1454, 104},
	{51185, 108},
	{51202, 112, 13, 5307},
	{1471, 116, 5, 5320},
	{51218, 2480},
	{51233, 2484, 1, 3955},
	{51248, 2488},
	{51263, 2492, 1, 3955},
	{1609, 2496},
	{1623, 2500},
	{1637, 2504},
	{1651, 2508},
	{1665, 2512},
	{1679, 2516},
	{1693, 2520},
	{1707, 2524},
	{1721, 2528},
	{1735, 2532},
	{1749, 2536},
	{1764, 2540},
	{1839, 2544},
	{1850, 2552},
	{1866, 2556},
	{51278, 3660, 21, 3956},
	{51291, 3664, 20, 3977},
	{51303, 3668, 16, 3997},
	{1954, 32776, 18, 5325},
	{1967, 32784, 24, 4035},
	{1979, 32788, 11, 4059},
	{1995, 32792, 11, 4059},
	{2024, 32824, 11, 4059},
	{2040, 32828, 11, 4059},
	{2056, 33296, 15, 5343},
	{2070, 33300, 28, 204},
	{2087, 33304, 14, 5358},
	{2108, 33308, 21, 5372},
	{2122, 33312, 31, 5153},
	{2139, 33316, 9, 5393},
	{2178, 33324, 1, 329},
	{2201, 33344, 1, 330},
	{2222, 33348},
	{2283, 33436, 1, 342},
	{53857, 36416},
	{2687, 36608},
	{2705, 36612, 4, 383},
	{2723, 36616},
	{2741, 36620, 14, 5402},
	{3642, 36624},
	{3660, 36628, 5, 5416},
	{3678, 36632, 4, 4718},
	{3696, 36636, 11, 4722},
	{3714, 36640, 2, 4733},
	{3732, 36644, 2, 4735},
	{3750, 36648, 8, 5421},
	{3768, 36652},
	{2759, 36656, 14, 5429},
	{2777, 36660, 4, 411},
	{2795, 36664, 10, 5443},
	{2813, 36668, 3, 4763},
	{2831, 37120, 6, 426},
	{2847, 39160, 9, 4766},
	{2862, 39184, 5, 4776},
	{2876, 39188, 5, 4776},
	{2890, 39192, 5, 4776},
	{2904, 39196, 5, 4776},
	{2918, 39200, 5, 4776},
	{2932, 39204, 5, 4776},
	{2946, 39208, 5, 4776},
	{2960, 39212, 5, 4776},
	{2974, 39216, 5, 4776},
	{2988, 39220, 5, 4776},
	{3002, 39224, 5, 4776},
	{3017, 39228, 5, 4776},
	{3032, 39232, 5, 4776},
	{3047, 39236, 5, 4776},
	{3062, 39240, 5, 4776},
	{3077, 39244, 5, 4776},
	{3092, 39248, 5, 4776},
	{3107, 39252, 5, 4776},
	{3122, 39256, 5, 4776},
	{3137, 39260, 5, 4776},
	{3152, 39264, 5, 4776},
	{3167, 39268, 5, 4776},
	{3182, 39272, 5, 4776},
	{3197, 39276, 5, 4776},
	{3212, 39280, 5, 4776},
	{3227, 39284, 5, 4776},
	{3242, 39288, 5, 4776},
	{3257, 39292, 5, 4776},
	{3272, 39296, 5, 4776},
	{3287, 39300, 5, 4776},
	{3302, 39304, 5, 4776},
	{3317, 39308, 5, 4776},
	{3332, 39312, 4, 445},
	{3351, 39316, 4, 445},
	{3370, 39320, 4, 445},
	{3389, 39324, 4, 445},
	{3408, 39328, 4, 445},
	{3427, 39332, 4, 445},
	{3446, 39336, 4, 445},
	{3465, 39340, 4, 445},
	{3484, 39344, 4, 445},
	{3503, 39348, 4, 445},
	{3522, 39352, 4, 445},
	{3542, 39356, 4, 445},
	{3562, 39360, 4, 445},
	{3582, 39364, 4, 445},
	{3602, 39368, 4, 445},
	{3622, 39372, 4, 445},
	{54091, 45056},
	{54112, 45060, 1, 498},
	{54133, 45064},
	{54154, 45068, 1, 498},
	{3867, 45084, 3, 495},
	{3891, 45088},
	{3912, 45092, 1, 498},
	{3933, 45096, 11, 4781},
	{3957, 45100, 6, 510},
	{3981, 45104},
	{4007, 45108},
	{4033, 45112},
	{4059, 45116},
	{4085, 45120},
	{4111, 45124},
	{4137, 45128},
	{4163, 45132},
	{4189, 45136},
	{4215, 45140},
	{4241, 45144},
	{4268, 45148},
	{4295, 45152},
	{4322, 45156},
	{4349, 45160},
	{4376, 45164},
	{54175, 45312},
	{54196, 45316, 1, 498},
	{54217, 45320},
	{54238, 45324, 1, 498},
	{5048, 45336, 3, 495},
	{5072, 45340, 1, 534},
	{5097, 45344},
	{5118, 45348, 1, 498},
	{5139, 45352, 12, 4798},
	{5163, 45356, 11, 5453},
	{5187, 45360},
	{5213, 45364},
	{5239, 45368},
	{5265, 45372},
	{5291, 45376},
	{5317, 45380},
	{5343, 45384},
	{5369, 45388},
	{5395, 45392},
	{5421, 45396},
	{5447, 45400},
	{5474, 45404},
	{5501, 45408},
	{5528, 45412},
	{5555, 45416},
	{5582, 45420},
	{6232, 45552, 6, 570},
	{6259, 45556, 5, 576},
	{54259, 45568},
	{54280, 45572, 1, 498},
	{54301, 45576},
	{54322, 45580, 1, 498},
	{6447, 45596, 4, 583},
	{6471, 45600},
	{6492, 45604, 1, 498},
	{6513, 45608, 11, 4820},
	{6537, 45612, 4, 561},
	{6561, 45616},
	{6587, 45620},
	{6613, 45624},
	{6639, 45628},
	{6665, 45632},
	{6691, 45636},
	{6717, 45640},
	{6743, 45644},
	{6769, 45648},
	{6795, 45652},
	{6821, 45656},
	{6848, 45660},
	{6875, 45664},
	{6902, 45668},
	{6929, 45672},
	{6956, 45676},
	{7591, 45808, 6, 570},
	{54343, 45824},
	{54364, 45828, 1, 498},
	{54385, 45832},
	{54406, 45836, 1, 498},
	{7618, 45852, 4, 583},
	{7642, 45856},
	{7663, 45860, 1, 498},
	{7684, 45864, 12, 4798},
	{7708, 45868, 6, 570},
	{7732, 45872},
	{7758, 45876},
	{7784, 45880},
	{7810, 45884},
	{7836, 45888},
	{7862, 45892},
	{7888, 45896},
	{7914, 45900},
	{7940, 45904},
	{7966, 45908},
	{7992, 45912},
	{8019, 45916},
	{8046, 45920},
	{8073, 45924},
	{8100, 45928},
	{8127, 45932},
	{8154, 46068, 5, 576},
	{54427, 46080},
	{54448, 46084, 1, 498},
	{54469, 46088},
	{54490, 46092, 1, 498},
	{8342, 46108, 3, 619},
	{8366, 46112},
	{8387, 46116, 1, 498},
	{8408, 46120, 10, 4841},
	{8432, 46124, 6, 635},
	{8456, 46128},
	{8482, 46132},
	{8508, 46136},
	{8534, 46140},
	{8560, 46144},
	{8586, 46148},
	{8612, 46152},
	{8638, 46156},
	{8664, 46160},
	{8690, 46164},
	{8716, 46168},
	{8743, 46172},
	{8770, 46176},
	{8797, 46180},
	{8824, 46184},
	{8851, 46188},
	{9486, 46324, 5, 576},
	{54511, 46336},
	{54532, 46340, 1, 498},
	{54553, 46344},
	{54574, 46348, 1, 498},
	{9513, 46364, 4, 583},
	{9537, 46368},
	{9558, 46372, 1, 498},
	{9579, 46376, 11, 4857},
	{9603, 46380, 5, 576},
	{9627, 46384},
	{9653, 46388},
	{9679, 46392},
	{9705, 46396},
	{9731, 46400},
	{9757, 46404},
	{9783, 46408},
	{9809, 46412},
	{9835, 46416},
	{9861, 46420},
	{9887, 46424},
	{9914, 46428},
	{9941, 46432},
	{9968, 46436},
	{9995, 46440},
	{10022, 46444},
	{10049, 47104, 12, 4873},
	{10076, 47108},
	{10090, 47112},
	{10104, 47116},
	{10118, 47120},
	{10134, 47124},
	{10150, 47128},
	{10166, 47132, 2, 666},
	{10187, 47136, 2, 666},
	{10208, 47140, 2, 666},
	{10229, 47144, 1, 668},
	{10257, 47148, 1, 669},
	{10282, 47152},
	{10297, 47156, 2, 4886},
	{54615, 47160},
	{54630, 47164, 1, 670},
	{54645, 47168},
	{54660, 47172, 1, 670},
	{10436, 47176, 10, 4888},
	{10454, 47180, 11, 683},
	{10472, 47184, 1, 694},
	{10485, 47188, 6, 695},
	{54675, 47192, 2, 4905},
	{54706, 47196, 2, 4905},
	{10563, 47200, 2, 701},
	{54889, 47204, 2, 4905},
	{54920, 47208, 2, 4905},
	{10638, 47212},
	{10656, 47216},
	{10674, 47220},
	{10692, 47224, 1, 703},
	{10720, 47228, 5, 704},
	{10742, 47232},
	{10762, 47236},
	{10945, 47240, 3, 720},
	{10962, 47244},
	{10991, 47248, 1, 723},
	{56937, 47252, 2, 5464},
	{11038, 47360},
	{11058, 47364},
	{11078, 47368},
	{11098, 47372},
	{11118, 47376},
	{11138, 47380},
	{11158, 47384},
	{11178, 47388},
	{11198, 47392},
	{11218, 47396},
	{11238, 47400},
	{11259, 47404},
	{11280, 47408},
	{11301, 47412},
	{11322, 47416},
	{11343, 47420},
	{11409, 47612},
	{54737, 53300, 29, 4907},
	{54754, 55348, 29, 4907},
	{11425, 163840, 10, 726},
	{11443, 163844, 9, 4936},
	{11460, 163848, 4, 4945},
	{11474, 163852, 23, 754},
	{11493, 163856, 15, 777},
	{11513, 163860},
	{11549, 163872},
	{11569, 163876},
	{11589, 163880, 1, 795},
	{11606, 163884},
	{11621, 163888, 2, 796},
	{11645, 163892, 2, 798},
	{54771, 163900, 7, 4949},
	{11703, 163904, 10, 5466},
	{11713, 163908, 6, 5476},
	{11729, 163912},
	{11744, 163916},
	{11765, 163920},
	{11781, 163924},
	{54785, 163928, 2, 4969},
	{54799, 163932, 1, 4971},
	{11971, 163968},
	{11987, 163972, 1, 847},
	{12006, 164328, 1, 848},
	{12027, 164332, 1, 848},
	{12048, 164336, 1, 848},
	{12069, 164340, 1, 848},
	{12090, 164344},
	{12108, 164348},
	{12126, 164352, 2, 849},
	{12146, 164356, 3, 851},
	{12170, 164360, 2, 854},
	{12194, 164364, 1, 856},
	{12214, 164368, 2, 851},
	{12234, 164372, 2, 854},
	{12254, 164376, 2, 851},
	{12274, 164380, 2, 854},
	{12294, 164384, 2, 851},
	{12314, 164388, 2, 854},
	{12334, 164392, 2, 851},
	{12354, 164396, 2, 854},
	{12374, 164400, 7, 857},
	{12389, 164404, 2, 864},
	{12418, 164408, 8, 866},
	{12433, 164412, 8, 874},
	{12448, 164416, 3, 851},
	{12473, 164420, 2, 854},
	{12498, 164424},
	{12516, 164428},
	{12534, 164432, 3, 851},
	{12559, 164436, 2, 854},
	{12584, 164440, 3, 851},
	{12609, 164444, 2, 854},
	{12634, 164448, 3, 851},
	{12659, 164452, 2, 854},
	{12684, 164456, 3, 851},
	{12709, 164460, 2, 854},
	{12734, 164464, 3, 851},
	{12759, 164468, 2, 854},
	{12784, 164472, 3, 851},
	{12809, 164476, 2, 854},
	{12834, 164480, 3, 851},
	{12859, 164484, 2, 854},
	{12884, 164488, 3, 851},
	{12909, 164492, 2, 854},
	{12934, 164496, 3, 851},
	{12959, 164500, 2, 854},
	{12984, 164504, 3, 851},
	{13009, 164508, 2, 854},
	{13034, 164512, 3, 851},
	{13060, 164516, 2, 854},
	{13086, 164520, 3, 851},
	{13112, 164524, 2, 854},
	{13138, 164528, 3, 851},
	{13164, 164532, 2, 854},
	{13190, 164536, 3, 851},
	{13216, 164540, 2, 854},
	{13242, 164544, 3, 851},
	{13268, 164548, 2, 854},
	{13294, 164552, 3, 851},
	{13320, 164556, 2, 854},
	{13346, 164560},
	{13365, 164564},
	{13384, 164568},
	{13403, 164572},
	{13422, 164576},
	{13441, 164580},
	{13460, 164584},
	{13479, 164588},
	{13498, 164592},
	{13517, 164596},
	{13536, 164600},
	{13555, 164604},
	{13574, 164608},
	{13593, 164612},
	{13612, 164616},
	{13631, 164620},
	{13650, 164624},
	{13669, 164628},
	{13688, 164632},
	{13707, 164636},
	{13726, 164640},
	{13746, 164644},
	{13766, 164648},
	{13786, 164652},
	{13806, 164656},
	{13826, 164660},
	{13846, 164664},
	{13866, 164668},
	{13886, 164672},
	{13906, 164676},
	{13926, 164680},
	{13946, 164684},
	{13966, 164688, 15, 882},
	{13986, 164692, 3, 897},
	{14008, 164696, 2, 900},
	{14065, 164704, 1, 909},
	{54814, 164708, 1, 4972},
	{14096, 164712, 1, 911},
	{14164, 164864},
	{14181, 164868},
	{14198, 164872},
	{14214, 164876},
	{14268, 164884},
	{14281, 164888},
	{14296, 164892},
	{14310, 164896},
	{14325, 164900, 3, 5482},
	{14364, 164908, 6, 942},
	{14383, 164912, 4, 948},
	{14401, 164916, 4, 952},
	{14422, 164924},
	{14441, 164928},
	{14461, 164932},
	{14480, 164936},
	{14500, 164940},
	{14519, 164944},
	{14539, 164948},
	{14560, 164952},
	{14582, 164956},
	{14603, 164960},
	{14625, 164964},
	{14646, 164968},
	{14668, 164972},
	{14689, 164976},
	{14711, 164980},
	{14732, 164984},
	{14754, 164988},
	{14775, 164992},
	{14797, 164996},
	{14818, 165000},
	{14840, 165004},
	{14861, 165008},
	{14883, 165012},
	{14904, 165016},
	{14926, 165020},
	{14947, 165024},
	{14969, 165028},
	{14990, 165032},
	{15012, 165036},
	{15033, 165040},
	{15055, 165044},
	{15076, 165048},
	{15098, 165052},
	{15119, 165056},
	{15141, 165060},
	{15162, 165064},
	{15184, 165068},
	{15205, 165072},
	{15227, 165076},
	{15248, 165080},
	{15270, 165084},
	{15291, 165088},
	{15313, 165092},
	{15334, 165096},
	{15356, 165100},
	{15377, 165104},
	{15399, 165108},
	{15420, 165112},
	{15442, 165116},
	{15463, 165120},
	{15485, 165124},
	{15506, 165128},
	{15528, 165132},
	{15549, 165136},
	{15571, 165140},
	{15592, 165144},
	{15614, 165148},
	{15635, 165152},
	{15657, 165156},
	{15678, 165160},
	{15700, 165164},
	{15722, 165168},
	{15745, 165172},
	{15767, 165176},
	{15790, 165180},
	{15812, 165184},
	{15835, 165188},
	{15857, 165192},
	{15880, 165196},
	{15902, 165200},
	{15925, 165204},
	{15947, 165208},
	{15970, 165212},
	{15992, 165216},
	{16015, 165220},
	{16037, 165224},
	{16060, 165228},
	{16082, 165232},
	{16105, 165236},
	{16127, 165240},
	{16150, 165244},
	{16172, 165248},
	{16195, 165252},
	{16217, 165256},
	{16240, 165260},
	{16262, 165264},
	{16285, 165268},
	{16307, 165272},
	{16330, 165276},
	{16352, 165280},
	{16375, 165284},
	{16397, 165288},
	{16420, 165292},
	{16442, 165296},
	{16465, 165300},
	{16487, 165304},
	{16510, 165308},
	{16524, 165312},
	{16538, 165316},
	{16552, 165320},
	{16566, 165324},
	{16580, 165328},
	{16594, 165332},
	{16608, 165336},
	{16622, 165340},
	{16636, 165344},
	{16650, 165348},
	{16664, 165352},
	{16678, 165356},
	{16692, 165360},
	{16706, 165364},
	{16720, 165368},
	{16734, 165372},
	{16748, 165376},
	{16762, 165380},
	{16776, 165384},
	{16790, 165388},
	{16804, 165392},
	{16818, 165396},
	{16832, 165400},
	{16869, 165444, 12, 956},
	{16889, 165448, 12, 956},
	{16909, 165452, 12, 956},
	{16929, 165456, 12, 956},
	{16949, 165460, 12, 956},
	{16969, 165464, 12, 956},
	{16989, 165468, 12, 956},
	{17009, 165472, 12, 956},
	{17029, 165476, 12, 956},
	{17049, 165480, 12, 956},
	{17069, 165484, 12, 956},
	{17090, 165488, 12, 956},
	{17111, 165492, 12, 956},
	{17132, 165496, 12, 956},
	{17153, 165500, 12, 956},
	{17174, 165504, 12, 956},
	{17195, 165508, 12, 956},
	{17216, 165512, 12, 956},
	{17237, 165516, 12, 956},
	{17258, 165520, 12, 956},
	{17279, 165524, 9, 968},
	{17300, 165528, 9, 968},
	{17321, 165532, 9, 968},
	{17342, 165536, 9, 968},
	{17363, 165540, 9, 968},
	{17384, 165544, 9, 968},
	{17405, 165548, 9, 968},
	{17426, 165552, 9, 968},
	{17447, 165556, 9, 968},
	{17468, 165560, 9, 968},
	{17489, 165564, 9, 968},
	{17510, 165568, 9, 968},
	{17531, 165572, 2, 977},
	{17549, 165580, 16, 980},
	{17566, 165584, 16, 980},
	{17584, 165588, 7, 996},
	{17605, 165592, 3, 4973},
	{17623, 165600, 7, 1009},
	{17638, 165608, 2, 701},
	{17677, 165644, 4, 1017},
	{17699, 165648, 1, 1022},
	{17719, 165652, 8, 1023},
	{17945, 165760, 9, 1070},
	{17963, 165764, 9, 1070},
	{17981, 165768, 9, 1070},
	{17999, 165772, 9, 1070},
	{18017, 165776, 9, 1070},
	{18035, 165780, 9, 1070},
	{18053, 165784, 9, 1070},
	{18071, 165788, 9, 1070},
	{18089, 165836, 1, 1079},
	{18103, 165840, 1, 1079},
	{18118, 165844},
	{18136, 165848},
	{18154, 165852},
	{18171, 165856},
	{18192, 165860, 1, 4976},
	{18208, 165864},
	{18221, 165872, 5, 1081},
	{18240, 165876},
	{18255, 165880, 1, 1089},
	{18304, 165888, 10, 1091},
	{18321, 165892, 12, 1101},
	{18329, 165896, 3, 5485},
	{18346, 165900, 12, 1117},
	{18364, 165904, 19, 1134},
	{18380, 165908, 13, 1154},
	{18399, 165912, 10, 1170},
	{18414, 165916, 27, 5488},
	{18432, 165920, 16, 1208},
	{18450, 165924, 4, 1224},
	{18474, 165928},
	{18499, 165932, 11, 1228},
	{18651, 166400, 2, 1260},
	{18668, 166404, 2, 1262},
	{18687, 166408, 1, 1264},
	{18703, 166412, 4, 1265},
	{18722, 166416, 1, 1269},
	{18743, 166420, 1, 1270},
	{18756, 166424},
	{18779, 166428},
	{18802, 166432, 1, 1271},
	{18822, 166436, 4, 4980},
	{18842, 166440, 1, 1276},
	{18863, 166444, 1, 1277},
	{18878, 166448, 6, 1278},
	{18900, 166452, 6, 1278},
	{18922, 166456, 8, 1284},
	{18948, 166460, 8, 1284},
	{18974, 166464, 15, 5515},
	{18986, 166468, 2, 1307},
	{19005, 166472, 4, 1310},
	{19023, 166476, 24, 1317},
	{19041, 166480},
	{19053, 166484, 1, 1341},
	{19067, 166488, 1, 1342},
	{19081, 166492, 1, 1343},
	{19095, 166496, 1, 1344},
	{19118, 166500, 1, 1344},
	{19141, 166504, 1, 1344},
	{19164, 166508, 5, 4984},
	{19185, 166512},
	{19196, 166516},
	{19209, 166520},
	{19226, 166524, 7, 5530},
	{19245, 166528},
	{19256, 166532, 2, 1358},
	{19275, 166536},
	{19297, 166540},
	{19319, 166544, 3, 5537},
	{19339, 166548, 1, 1364},
	{19388, 166560},
	{19413, 166564},
	{19438, 166568, 7, 5540},
	{19457, 166572, 1, 1377},
	{19480, 166576, 1, 1377},
	{19503, 166580, 1, 1378},
	{19517, 166584, 1, 1379},
	{19532, 166588, 8, 5547},
	{19549, 166592, 4, 1389},
	{19576, 166596, 4, 1393},
	{19603, 166600, 4, 1397},
	{19622, 166608},
	{19648, 166612, 1, 1401},
	{19673, 166620},
	{19701, 166624},
	{19727, 166628, 1, 1401},
	{19752, 166636},
	{19780, 166640},
	{19806, 166644, 1, 1401},
	{19831, 166652},
	{19859, 166656},
	{19885, 166660, 1, 1401},
	{19910, 166668},
	{19938, 166696},
	{19969, 166700},
	{20012, 166704, 1, 1402},
	{20050, 166712, 1, 1403},
	{20089, 166736, 3, 1406},
	{20111, 166740, 10, 1411},
	{20132, 166744, 3, 1430},
	{20149, 166748, 1, 1377},
	{20170, 166752, 1, 1377},
	{20193, 166756, 1, 1377},
	{20216, 166760, 1, 1377},
	{20239, 166764, 10, 5555},
	{20252, 166768, 6, 1445},
	{20269, 166772},
	{20293, 166776, 2, 1451},
	{20323, 166780},
	{20347, 166784},
	{20377, 166788},
	{20408, 166792},
	{20437, 166796},
	{20467, 166800, 2, 1453},
	{20487, 166804, 7, 5014},
	{20506, 166808, 4, 1464},
	{20556, 166868, 8, 1468},
	{20582, 166872, 8, 1476},
	{20608, 166876, 4, 1484},
	{20624, 166880, 5, 1489},
	{20640, 166884, 3, 1495},
	{20655, 166888},
	{20678, 166892},
	{20701, 166896},
	{20724, 166900},
	{20747, 166904, 8, 1498},
	{20781, 166908, 8, 1506},
	{20815, 166912, 8, 1514},
	{20849, 166916, 8, 1522},
	{20883, 166920, 8, 1498},
	{20917, 166924, 8, 1506},
	{20951, 166928, 8, 1514},
	{20985, 166932, 8, 1522},
	{21019, 166936, 8, 1498},
	{21053, 166940, 8, 1506},
	{21087, 166944, 8, 1514},
	{21121, 166948, 8, 1522},
	{21155, 166952, 8, 1498},
	{21189, 166956, 8, 1506},
	{21223, 166960, 8, 1514},
	{21257, 166964, 8, 1522},
	{21291, 166968, 2, 1530},
	{21315, 166972, 2, 1532},
	{21458, 167000, 1, 1574},
	{21486, 167004, 1, 1575},
	{21507, 167008},
	{21522, 167012, 2, 1576},
	{21538, 167016, 1, 1578},
	{21554, 167020, 2, 4945},
	{21569, 167024, 18, 5565},
	{21584, 167028, 6, 1601},
	{21601, 167032, 9, 1609},
	{21623, 167036},
	{21639, 167040, 1, 1621},
	{21661, 167044},
	{21677, 167048, 1, 1578},
	{21699, 167052},
	{21721, 167056},
	{21743, 167060},
	{21762, 167068},
	{21777, 167072, 2, 1576},
	{21793, 167076, 1, 1578},
	{21809, 167080, 2, 4945},
	{21824, 167084, 18, 5565},
	{21839, 167088, 6, 1601},
	{21856, 167092, 9, 1609},
	{21878, 167096},
	{21894, 167100, 1, 1621},
	{21916, 167104},
	{21932, 167108, 1, 1578},
	{21954, 167112},
	{21976, 167116},
	{21998, 167120},
	{22017, 167128},
	{22032, 167132, 2, 1576},
	{22048, 167136, 1, 1578},
	{22064, 167140, 2, 4945},
	{22079, 167144, 18, 5565},
	{22094, 167148, 6, 1601},
	{22111, 167152, 9, 1609},
	{22133, 167156},
	{22149, 167160, 1, 1621},
	{22171, 167164},
	{22187, 167168, 1, 1578},
	{22209, 167172},
	{22231, 167176},
	{22253, 167180},
	{22272, 167188},
	{22287, 167192, 2, 1576},
	{22303, 167196, 1, 1578},
	{22319, 167200, 2, 4945},
	{22334, 167204, 18, 5565},
	{22349, 167208, 6, 1601},
	{22366, 167212, 9, 1609},
	{22388, 167216},
	{22404, 167220, 1, 1621},
	{22426, 167224},
	{22442, 167228, 1, 1578},
	{22464, 167232},
	{22486, 167236},
	{22508, 167240},
	{22527, 167248},
	{22542, 167252, 2, 1576},
	{22558, 167256, 1, 1578},
	{22574, 167260, 2, 4945},
	{22589, 167264, 18, 5565},
	{22604, 167268, 6, 1601},
	{22621, 167272, 9, 1609},
	{22643, 167276},
	{22659, 167280, 1, 1621},
	{22681, 167284},
	{22697, 167288, 1, 1578},
	{22719, 167292},
	{22741, 167296},
	{22763, 167300},
	{22782, 167308},
	{22797, 167312, 2, 1576},
	{22813, 167316, 1, 1578},
	{22829, 167320, 2, 4945},
	{22844, 167324, 18, 5565},
	{22859, 167328, 6, 1601},
	{22876, 167332, 9, 1609},
	{22898, 167336},
	{22914, 167340, 1, 1621},
	{22936, 167344},
	{22952, 167348, 1, 1578},
	{22974, 167352},
	{22996, 167356},
	{23018, 167360},
	{23037, 167368},
	{23052, 167372, 2, 1576},
	{23068, 167376, 1, 1578},
	{23084, 167380, 2, 4945},
	{23099, 167384, 18, 5565},
	{23114, 167388, 6, 1601},
	{23131, 167392, 9, 1609},
	{23153, 167396},
	{23169, 167400, 1, 1621},
	{23191, 167404},
	{23207, 167408, 1, 1578},
	{23229, 167412},
	{23251, 167416},
	{23273, 167420},
	{23292, 167428},
	{23307, 167432, 2, 1576},
	{23323, 167436, 1, 1578},
	{23339, 167440, 2, 4945},
	{23354, 167444, 18, 5565},
	{23369, 167448, 6, 1601},
	{23386, 167452, 9, 1609},
	{23408, 167456},
	{23424, 167460, 1, 1621},
	{23446, 167464},
	{23462, 167468, 1, 1578},
	{23484, 167472},
	{23506, 167476},
	{23528, 167480},
	{24571, 196608, 1, 1634},
	{24591, 196612, 1, 1635},
	{24611, 196616},
	{24631, 196620},
	{24651, 196624},
	{24672, 196628},
	{24693, 196632, 1, 1636},
	{24715, 196636, 1, 1637},
	{24737, 196640},
	{24767, 196644},
	{24797, 196648},
	{24826, 196652},
	{24855, 196656},
	{24885, 196660},
	{24915, 196664},
	{24944, 196668},
	{24973, 196672},
	{25003, 196676},
	{25033, 196680},
	{25062, 196684},
	{25091, 196688},
	{25121, 196692},
	{25151, 196696},
	{25180, 196700},
	{25209, 196704, 1, 1638},
	{25231, 196708, 1, 1639},
	{25253, 196712},
	{25276, 196716},
	{25299, 196720},
	{25322, 196724},
	{25345, 196728},
	{25368, 196732},
	{25391, 196736},
	{25415, 196740},
	{25439, 196744},
	{25463, 196748},
	{25487, 196752},
	{25511, 196756},
	{25535, 196760},
	{25559, 196764},
	{25583, 196768},
	{25605, 196772},
	{25627, 196776},
	{25648, 196780},
	{25669, 196784},
	{25693, 196788},
	{25717, 196792},
	{25741, 196796},
	{25765, 196800},
	{25789, 196804},
	{25873, 196852, 2, 5583},
	{25895, 196856, 2, 5583},
	{25917, 196860, 1, 1642},
	{25933, 196864},
	{25946, 196868},
	{25959, 196872},
	{25972, 196876},
	{25985, 196880},
	{25998, 196884},
	{26011, 196888},
	{26024, 196892},
	{26151, 196928, 2, 1643},
	{26164, 196932},
	{26177, 196936},
	{26200, 196940},
	{26223, 196944},
	{26251, 196948},
	{26279, 196952},
	{26307, 196956},
	{26335, 196960, 1, 1645},
	{26353, 196964, 5, 5585},
	{26371, 196968},
	{26386, 196972},
	{26410, 196976},
	{26434, 196980},
	{26453, 196984},
	{26472, 196988},
	{26496, 196992},
	{26520, 196996},
	{26544, 197000},
	{26568, 197028, 2, 4171},
	{26586, 197032, 3, 5590},
	{26604, 197036},
	{26622, 197040},
	{26640, 197044, 2, 4174},
	{26658, 197048, 3, 5593},
	{26676, 197052},
	{26694, 197056, 2, 1656},
	{26713, 197060, 5, 1658},
	{26732, 197072},
	{26756, 197076, 2, 1656},
	{26776, 197080, 5, 1658},
	{26796, 197084, 8, 5596},
	{26815, 197088, 8, 5596},
	{26833, 197092, 1, 1670},
	{26850, 197100, 1, 1671},
	{26871, 197104, 26, 5604},
	{26885, 197108},
	{26899, 197112},
	{26913, 197116, 4, 4205},
	{26929, 197120},
	{26948, 197124, 1, 1687},
	{26970, 197128},
	{26989, 197132, 1, 1688},
	{27011, 197136, 9, 4211},
	{27029, 197140},
	{27049, 197144, 1, 1687},
	{27072, 197148},
	{27092, 197152, 1, 1688},
	{27115, 197156, 9, 4211},
	{27134, 197160, 5, 4220},
	{27146, 197164, 2, 1703},
	{27163, 197168, 1, 1705},
	{27180, 197172, 1, 1706},
	{27198, 197176, 4, 1707},
	{27218, 197180, 1, 1711},
	{27235, 197184},
	{27251, 197188, 1, 1713},
	{27264, 197192, 1, 1714},
	{27278, 197196, 1, 1715},
	{27292, 197200, 1, 1716},
	{27314, 197204, 1, 1717},
	{27334, 197208, 1, 1718},
	{27356, 197212, 1, 1719},
	{27376, 197216, 1, 1714},
	{27393, 197220, 1, 1715},
	{27410, 197224},
	{56966, 197228, 1, 1713},
	{27669, 197388, 1, 1728},
	{27688, 197392, 1, 1729},
	{27707, 197396, 1, 1730},
	{27724, 197400, 1, 1731},
	{27742, 197404, 1, 1732},
	{27760, 197408, 1, 1733},
	{27776, 197412, 1, 1734},
	{27794, 197416, 1, 1735},
	{27812, 197420, 1, 1736},
	{27828, 197424, 1, 1731},
	{27843, 197428, 1, 1732},
	{27858, 197432, 1, 1733},
	{27871, 197436, 1, 1734},
	{27886, 197440, 1, 1735},
	{27901, 197444, 1, 1736},
	{27914, 197448, 1, 1737},
	{27928, 197452, 1, 1738},
	{27942, 197456, 1, 1739},
	{27954, 197460, 4, 5630},
	{27977, 197464, 4, 5223},
	{27999, 197468, 1, 1747},
	{28143, 197552, 1, 1752},
	{28168, 197556, 1, 1752},
	{28192, 197560, 1, 1753},
	{28212, 197568},
	{28238, 197572, 1, 1635},
	{28267, 197576},
	{28292, 197580, 1, 1635},
	{28320, 197584},
	{28343, 197588, 1, 1635},
	{28369, 197592},
	{28391, 197596, 1, 1635},
	{28416, 197600},
	{28435, 197604, 1, 1635},
	{28457, 197608, 1, 1350},
	{28471, 197612},
	{28488, 197616, 1, 1635},
	{28508, 197620, 8, 1754},
	{28677, 198656, 6, 4077},
	{28692, 198912},
	{28711, 198916},
	{28730, 198920, 1, 4460},
	{28749, 198924, 1, 1350},
	{28764, 198928},
	{28797, 198932},
	{28830, 198936},
	{28863, 198940},
	{28953, 198960},
	{28969, 198964},
	{28987, 198968, 1, 1792},
	{29004, 198972, 2, 1793},
	{29025, 198976},
	{29357, 199168, 1, 1816},
	{29382, 199172, 2, 1817},
	{29407, 199184, 2, 1819},
	{29433, 199188, 2, 1819},
	{29459, 199192, 2, 1819},
	{29485, 199212, 2, 1819},
	{29511, 199296, 2, 1821},
	{29539, 199300, 1, 1823},
	{29563, 199304, 1, 1824},
	{29587, 199308, 1, 1825},
	{29620, 199312, 1, 1825},
	{29648, 199328, 2, 1821},
	{29677, 199332, 1, 1823},
	{29702, 199336, 1, 1824},
	{29727, 199340, 1, 1825},
	{29761, 199344, 1, 1825},
	{29790, 199360, 2, 1821},
	{29814, 199364, 1, 1823},
	{29834, 199368, 1, 1824},
	{29854, 199372, 1, 1825},
	{29883, 199376, 1, 1825},
	{53768, 199872},
	{53789, 199876, 1, 4637},
	{2431, 199880, 8, 5191},
	{2452, 199884, 3, 4646},
	{53810, 199888, 2, 4649},
	{2479, 199892, 1, 4673},
	{53836, 199896, 15, 4658},
	{54839, 199900, 1, 5200},
	{54861, 199904},
	{2410, 199908, 2, 4651},
	{2500, 199912, 5, 5203},
	{53878, 199916, 1, 4674},
	{29907, 199936},
	{29934, 199940},
	{29961, 199944},
	{29988, 199948},
	{30123, 199968, 6, 1826},
	{30134, 199972, 2, 1833},
	{30148, 200192},
	{30167, 200196, 1, 847},
	{30189, 200448},
	{30213, 200452, 1, 1835},
	{30236, 200456},
	{30260, 200460, 1, 1835},
	{30283, 200464},
	{30307, 200468, 1, 1835},
	{30330, 200472},
	{30354, 200476, 1, 1835},
	{30377, 200696},
	{30396, 200700, 1, 1835},
	{30414, 200704},
	{30426, 200708},
	{30438, 200712},
	{30456, 200716},
	{30475, 200720},
	{30493, 200724},
	{30505, 200728},
	{30517, 200732},
	{30535, 200736},
	{30553, 200740},
	{30572, 200744, 4, 1836},
	{30586, 200748, 2, 1840},
	{30604, 200752, 2, 1842},
	{30618, 200756, 2, 1844},
	{30632, 200760, 2, 1846},
	{30649, 200764, 2, 1848},
	{30666, 200768},
	{30679, 200772, 2, 1850},
	{30691, 200776},
	{30705, 200780},
	{30721, 200784},
	{30735, 200788},
	{30751, 200792},
	{30766, 200796},
	{30783, 200800},
	{30798, 200804},
	{30815, 200808, 2, 1852},
	{30837, 200812, 9, 5231},
	{30854, 200816, 2, 1864},
	{30875, 200820, 2, 1866},
	{30887, 200824},
	{30902, 200828, 6, 5634},
	{30917, 200832, 2, 1874},
	{30931, 200836},
	{31044, 212992},
	{31064, 212996},
	{31084, 213000},
	{31104, 213004},
	{31124, 213008},
	{31144, 213012},
	{31164, 213016},
	{31184, 213020},
	{31204, 213024},
	{31224, 213028},
	{31244, 213032},
	{31264, 213036},
	{31353, 213248},
	{31374, 213252},
	{31395, 213260},
	{31416, 213264},
	{31437, 213268},
	{31461, 213272},
	{31485, 213276},
	{31509, 213280},
	{31533, 213284},
	{31557, 213288},
	{31581, 213292},
	{31605, 213296},
	{54951, 213504},
	{54970, 213508},
	{54989, 213512},
	{55008, 213516},
	{55027, 213520},
	{55046, 213524},
	{55065, 213528},
	{55084, 213532},
	{52441, 213536},
	{52460, 213540},
	{52479, 213544},
	{52498, 213548},
	{52517, 213552},
	{52536, 213556},
	{52555, 213560},
	{52574, 213564},
	{52994, 213568},
	{53014, 213572},
	{53034, 213576},
	{53054, 213580},
	{53074, 213584},
	{53094, 213588},
	{53114, 213592},
	{53134, 213596},
	{32089, 214016},
	{32111, 214020, 1, 1876},
	{32133, 214024},
	{32155, 214028, 1, 1876},
	{32177, 214032},
	{32199, 214036, 1, 1876},
	{32221, 214040},
	{32243, 214044, 1, 1876},
	{32265, 214272},
	{32287, 214276},
	{32309, 214280},
	{32331, 214284},
	{32353, 214288},
	{32375, 214292},
	{32397, 214296},
	{32419, 214300},
	{32441, 214304},
	{32463, 214308},
	{32485, 214312},
	{32507, 214316},
	{32529, 214320},
	{32551, 214324},
	{32573, 214328},
	{32595, 214332},
	{32617, 214528},
	{32637, 214532},
	{32657, 214536},
	{32677, 214540},
	{32697, 214544},
	{32717, 214548},
	{32737, 214552},
	{32757, 214556},
	{32777, 214560},
	{32797, 214564},
	{32817, 214568},
	{32837, 214572},
	{32857, 214784},
	{32876, 214788},
	{32895, 214792},
	{32914, 214796},
	{32933, 214800},
	{32952, 214804},
	{32971, 214808},
	{32990, 214812},
	{33009, 214816},
	{33028, 214820},
	{33047, 214824},
	{33066, 214828},
	{33085, 214832},
	{33104, 214836},
	{33123, 214840},
	{33142, 214844},
	{33161, 214848},
	{33180, 214852},
	{33199, 214856},
	{33218, 214860},
	{33237, 214864},
	{33257, 214868},
	{33277, 214872},
	{33297, 214876},
	{33317, 214880},
	{33337, 214884},
	{33357, 214888},
	{33377, 214892},
	{33397, 214896},
	{33417, 214900},
	{33437, 214904},
	{33457, 214908},
	{33477, 215296},
	{33496, 215300},
	{33515, 215304},
	{33534, 215308},
	{33553, 215312},
	{33572, 215316},
	{33591, 215320},
	{33610, 215324},
	{33671, 215552},
	{33691, 215556},
	{33711, 215560},
	{33731, 215564},
	{33751, 215568},
	{33771, 215572},
	{33791, 215576},
	{33811, 215580},
	{33831, 215808},
	{33850, 215812},
	{33869, 215816},
	{33888, 215820},
	{33907, 216064},
	{33926, 216068},
	{33945, 216072},
	{33964, 216076},
	{33983, 216320},
	{34003, 216324},
	{34023, 216328},
	{34043, 216332},
	{34063, 216336},
	{34083, 216340},
	{34103, 216344},
	{34123, 216348},
	{55103, 216576},
	{55123, 216580},
	{55143, 216584},
	{55163, 216588},
	{55183, 216592},
	{55203, 216596},
	{55223, 216600},
	{55243, 216604},
	{55263, 216640},
	{55283, 216644},
	{55303, 216648},
	{55323, 216652},
	{55343, 216656},
	{55363, 216660},
	{55383, 216664},
	{55403, 216668},
	{34975, 217112},
	{34994, 217116},
	{35013, 217120},
	{35032, 217124},
	{35051, 217128},
	{35070, 217132},
	{35089, 217136},
	{35108, 217140},
	{35127, 217344},
	{35146, 217348},
	{35165, 217352},
	{35184, 217356},
	{35203, 217360},
	{35222, 217364},
	{35241, 217368},
	{35260, 217372},
	{35279, 217600},
	{35299, 217604},
	{35319, 217608},
	{35339, 217612},
	{36661, 221184, 1, 1910},
	{36685, 221188, 2, 5240},
	{36710, 221192, 3, 5242},
	{36734, 221196, 1, 1910},
	{36758, 221200, 2, 5240},
	{36783, 221204, 1, 1910},
	{36807, 221208, 2, 5240},
	{36832, 221212, 3, 5242},
	{36856, 221216, 4, 1888},
	{36872, 221220, 3, 5242},
	{37039, 221248},
	{37054, 221252, 1, 1825},
	{37077, 221256},
	{37100, 221260},
	{37118, 221264, 2, 1904},
	{37136, 221268, 4, 1906},
	{37156, 221440, 19, 4120},
	{37181, 221444, 19, 4120},
	{37206, 221448, 12, 4139},
	{37234, 221452, 12, 4139},
	{37262, 221456, 12, 4139},
	{37290, 221460, 12, 4139},
	{55583, 221696, 2, 4418},
	{55606, 221700, 2, 4418},
	{55629, 221704, 2, 4418},
	{55652, 221708, 2, 4418},
	{52349, 221712, 5, 1964},
	{52372, 221716, 2, 4418},
	{52395, 221720, 2, 4418},
	{52418, 221724, 2, 4418},
	{55675, 221728, 4, 1969},
	{52898, 221744, 5, 1964},
	{52922, 221748, 5, 1964},
	{52946, 221752, 2, 4418},
	{52970, 221756, 2, 4418},
	{55699, 221760, 4, 1969},
	{55724, 221764, 4, 1969},
	{52872, 221776, 1, 4459},
	{37748, 222208, 3, 1964},
	{37774, 222212, 2, 1884},
	{37801, 222216, 3, 1964},
	{37827, 222220, 2, 1884},
	{37854, 222224, 2, 2020},
	{37907, 222228, 2, 2020},
	{37960, 222464, 3, 1964},
	{37986, 222468, 2, 1884},
	{38013, 222472, 1, 1879},
	{38039, 222476, 1, 1879},
	{38065, 222480, 1, 1879},
	{38091, 222484, 1, 1879},
	{38117, 222488, 1, 1879},
	{38143, 222492, 1, 1879},
	{38169, 222496, 1, 1879},
	{38195, 222720, 3, 1964},
	{38219, 222724, 3, 1964},
	{38243, 222728, 3, 1964},
	{38267, 222732, 3, 1964},
	{38291, 222736, 2, 1884},
	{38316, 222740, 2, 1884},
	{38341, 222744, 2, 1884},
	{38366, 222748, 2, 1884},
	{38391, 222752, 1, 2008},
	{38415, 222756, 1, 2008},
	{38439, 222760, 8, 1973},
	{38460, 222976, 6, 4617},
	{38483, 222980, 6, 4617},
	{38506, 222984, 6, 4617},
	{38529, 222988, 6, 4617},
	{38552, 222992, 6, 4617},
	{38575, 222996, 6, 4617},
	{38598, 223000, 6, 4617},
	{38621, 223004, 6, 4617},
	{38644, 223008, 6, 4617},
	{38667, 223012, 6, 4617},
	{38690, 223016, 6, 4617},
	{38714, 223020, 6, 4617},
	{38738, 223024, 6, 4617},
	{38762, 223028, 6, 4617},
	{38786, 223032, 6, 4617},
	{38810, 223036, 6, 4617},
	{38834, 223104, 9, 4600},
	{55749, 223108, 2, 4649},
	{38854, 223112, 1, 1994},
	{38949, 223488, 3, 2003},
	{38972, 223492, 3, 2003},
	{38995, 223496, 3, 2003},
	{39018, 223500, 3, 2003},
	{39041, 223504, 2, 2006},
	{39065, 223508, 2, 2006},
	{39089, 223744, 3, 2003},
	{39113, 223748, 3, 2003},
	{39137, 223752, 3, 2003},
	{39161, 223756, 3, 2003},
	{39185, 223760, 2, 2006},
	{39210, 224000, 5, 2008},
	{39233, 224004, 4, 2013},
	{39257, 224008, 5, 2008},
	{39280, 224256, 5, 2008},
	{39303, 224260, 4, 2013},
	{39327, 224264, 5, 2008},
	{39350, 224512, 5, 1964},
	{39374, 224516, 4, 1969},
	{39399, 224520, 5, 1964},
	{39423, 224524, 4, 1969},
	{39448, 224528, 3, 2020},
	{39472, 224532, 3, 2020},
	{55769, 224768, 5, 1964},
	{55793, 224772, 4, 1958},
	{55818, 224776, 5, 1964},
	{55842, 224780, 4, 1958},
	{55867, 224784, 3, 2020},
	{55891, 224788, 3, 2020},
	{55915, 224832, 5, 1964},
	{55939, 224836, 4, 1958},
	{55964, 224840, 5, 1964},
	{55988, 224844, 4, 1958},
	{56013, 224848, 3, 2020},
	{56037, 224852, 3, 2020},
	{40173, 225280, 12, 2023},
	{40195, 225284, 5, 2035},
	{40218, 225288, 4, 2040},
	{40242, 225292, 2, 2044},
	{40265, 225296, 2, 2044},
	{40288, 225300, 2, 2044},
	{40311, 225536, 5, 1964},
	{40334, 225540, 4, 1969},
	{40358, 225544, 5, 1964},
	{40381, 225548, 4, 1969},
	{40405, 225552, 5, 1964},
	{40428, 225560, 5, 1964},
	{40451, 225792, 4, 2046},
	{40472, 225796},
	{40501, 225800, 2, 2050},
	{40530, 225804},
	{40556, 225808, 7, 2052},
	{40630, 225812},
	{40653, 225816},
	{56182, 225820, 2, 5251},
	{56215, 225824, 2, 5251},
	{56248, 225828, 2, 5251},
	{56281, 225832, 2, 5251},
	{56313, 225836, 2, 5251},
	{56345, 225840, 2, 5251},
	{56377, 225844, 2, 5251},
	{56410, 225848, 2, 5251},
	{56442, 225856, 2, 5251},
	{56474, 225860, 2, 5251},
	{56507, 225864, 2, 5251},
	{56540, 225868, 2, 5251},
	{56573, 225872, 2, 5251},
	{56605, 225876, 2, 5251},
	{56637, 225880, 2, 5251},
	{56670, 225884, 2, 5251},
	{56703, 225888, 2, 5251},
	{56769, 225896, 2, 5251},
	{40676, 225900},
	{40703, 225904},
	{40585, 225908},
	{40604, 225912},
	{56801, 225916, 2, 5251},
	{56835, 225920, 2, 5251},
	{56869, 225924, 2, 5251},
	{56903, 225928, 2, 5251},
	{41573, 226044, 1, 2136},
	{41366, 226048, 2, 2126},
	{41383, 226052, 1, 2128},
	{41407, 226056, 1, 2128},
	{206, 880, 4, 2163},
	{43152, 881},
	{26999, 882},
	{43164, 1008},
	{43175, 1009},
	{27187, 1010, 4, 2167},
	{43186, 1040, 1, 2171},
	{43199, 1041, 5, 5253},
	{43212, 1042, 1, 2177},
	{43225, 1043, 1, 1688},
	{27021, 1045, 9, 5045},
	{43253, 1281, 6, 5258},
	{43268, 1282},
	{26958, 1283},
	{43152, 1285},
	{26999, 1286},
};

static const struct si_reg gfx81_reg_table[] = {
	{1310, 68, 10, 5264},
	{1323, 72, 23, 5274},
	{1338, 76, 4, 5297},
	{51171, 80, 11, 5070},
	{1375, 84, 4, 3931},
	{1393, 88, 2, 3935},
	{1411, 92, 6, 5301},
	{1426, 96},
	{1440, 100, 1, 70},
	{1454, 104},
	{51185, 108},
	{51202, 112, 13, 5307},
	{1471, 116, 5, 5320},
	{51218, 2480},
	{51233, 2484, 1, 3955},
	{51248, 2488},
	{51263, 2492, 1, 3955},
	{1609, 2496},
	{1623, 2500},
	{1637, 2504},
	{1651, 2508},
	{1665, 2512},
	{1679, 2516},
	{1693, 2520},
	{1707, 2524},
	{1721, 2528},
	{1735, 2532},
	{1749, 2536},
	{1764, 2540},
	{1839, 2544},
	{1850, 2552},
	{1866, 2556},
	{51278, 3660, 21, 3956},
	{51291, 3664, 20, 3977},
	{51303, 3668, 16, 3997},
	{1954, 32776, 18, 5325},
	{1967, 32784, 24, 4035},
	{1979, 32788, 11, 4059},
	{1995, 32792, 11, 4059},
	{2024, 32824, 11, 4059},
	{2040, 32828, 11, 4059},
	{2056, 33296, 15, 5343},
	{2070, 33300, 28, 204},
	{2087, 33304, 14, 5358},
	{2108, 33308, 21, 5372},
	{2122, 33312, 31, 5153},
	{2139, 33316, 9, 5393},
	{2178, 33324, 1, 329},
	{2201, 33344, 1, 330},
	{2222, 33348},
	{2283, 33436, 1, 342},
	{53857, 36416},
	{2687, 36608},
	{2705, 36612, 4, 383},
	{2723, 36616},
	{2741, 36620, 14, 5402},
	{3642, 36624},
	{3660, 36628, 5, 5640},
	{3678, 36632, 4, 4718},
	{3696, 36636, 11, 4722},
	{3714, 36640, 2, 4733},
	{3732, 36644, 2, 4735},
	{3750, 36648, 8, 5421},
	{3768, 36652},
	{2759, 36656, 14, 5429},
	{2777, 36660, 4, 411},
	{2795, 36664, 10, 5443},
	{2813, 36668, 3, 4763},
	{2831, 37120, 6, 426},
	{2847, 39160, 9, 4766},
	{2862, 39184, 5, 4776},
	{2876, 39188, 5, 4776},
	{2890, 39192, 5, 4776},
	{2904, 39196, 5, 4776},
	{2918, 39200, 5, 4776},
	{2932, 39204, 5, 4776},
	{2946, 39208, 5, 4776},
	{2960, 39212, 5, 4776},
	{2974, 39216, 5, 4776},
	{2988, 39220, 5, 4776},
	{3002, 39224, 5, 4776},
	{3017, 39228, 5, 4776},
	{3032, 39232, 5, 4776},
	{3047, 39236, 5, 4776},
	{3062, 39240, 5, 4776},
	{3077, 39244, 5, 4776},
	{3092, 39248, 5, 4776},
	{3107, 39252, 5, 4776},
	{3122, 39256, 5, 4776},
	{3137, 39260, 5, 4776},
	{3152, 39264, 5, 4776},
	{3167, 39268, 5, 4776},
	{3182, 39272, 5, 4776},
	{3197, 39276, 5, 4776},
	{3212, 39280, 5, 4776},
	{3227, 39284, 5, 4776},
	{3242, 39288, 5, 4776},
	{3257, 39292, 5, 4776},
	{3272, 39296, 5, 4776},
	{3287, 39300, 5, 4776},
	{3302, 39304, 5, 4776},
	{3317, 39308, 5, 4776},
	{3332, 39312, 4, 445},
	{3351, 39316, 4, 445},
	{3370, 39320, 4, 445},
	{3389, 39324, 4, 445},
	{3408, 39328, 4, 445},
	{3427, 39332, 4, 445},
	{3446, 39336, 4, 445},
	{3465, 39340, 4, 445},
	{3484, 39344, 4, 445},
	{3503, 39348, 4, 445},
	{3522, 39352, 4, 445},
	{3542, 39356, 4, 445},
	{3562, 39360, 4, 445},
	{3582, 39364, 4, 445},
	{3602, 39368, 4, 445},
	{3622, 39372, 4, 445},
	{54091, 45056},
	{54112, 45060, 1, 498},
	{54133, 45064},
	{54154, 45068, 1, 498},
	{3867, 45084, 3, 495},
	{3891, 45088},
	{3912, 45092, 1, 498},
	{3933, 45096, 11, 4781},
	{3957, 45100, 6, 510},
	{3981, 45104},
	{4007, 45108},
	{4033, 45112},
	{4059, 45116},
	{4085, 45120},
	{4111, 45124},
	{4137, 45128},
	{4163, 45132},
	{4189, 45136},
	{4215, 45140},
	{4241, 45144},
	{4268, 45148},
	{4295, 45152},
	{4322, 45156},
	{4349, 45160},
	{4376, 45164},
	{54175, 45312},
	{54196, 45316, 1, 498},
	{54217, 45320},
	{54238, 45324, 1, 498},
	{5048, 45336, 3, 495},
	{5072, 45340, 1, 534},
	{5097, 45344},
	{5118, 45348, 1, 498},
	{5139, 45352, 12, 4798},
	{5163, 45356, 11, 5453},
	{5187, 45360},
	{5213, 45364},
	{5239, 45368},
	{5265, 45372},
	{5291, 45376},
	{5317, 45380},
	{5343, 45384},
	{5369, 45388},
	{5395, 45392},
	{5421, 45396},
	{5447, 45400},
	{5474, 45404},
	{5501, 45408},
	{5528, 45412},
	{5555, 45416},
	{5582, 45420},
	{6232, 45552, 6, 570},
	{6259, 45556, 5, 576},
	{54259, 45568},
	{54280, 45572, 1, 498},
	{54301, 45576},
	{54322, 45580, 1, 498},
	{6447, 45596, 4, 583},
	{6471, 45600},
	{6492, 45604, 1, 498},
	{6513, 45608, 11, 4820},
	{6537, 45612, 4, 561},
	{6561, 45616},
	{6587, 45620},
	{6613, 45624},
	{6639, 45628},
	{6665, 45632},
	{6691, 45636},
	{6717, 45640},
	{6743, 45644},
	{6769, 45648},
	{6795, 45652},
	{6821, 45656},
	{6848, 45660},
	{6875, 45664},
	{6902, 45668},
	{6929, 45672},
	{6956, 45676},
	{7591, 45808, 6, 570},
	{54343, 45824},
	{54364, 45828, 1, 498},
	{54385, 45832},
	{54406, 45836, 1, 498},
	{7618, 45852, 4, 583},
	{7642, 45856},
	{7663, 45860, 1, 498},
	{7684, 45864, 12, 4798},
	{7708, 45868, 6, 570},
	{7732, 45872},
	{7758, 45876},
	{7784, 45880},
	{7810, 45884},
	{7836, 45888},
	{7862, 45892},
	{7888, 45896},
	{7914, 45900},
	{7940, 45904},
	{7966, 45908},
	{7992, 45912},
	{8019, 45916},
	{8046, 45920},
	{8073, 45924},
	{8100, 45928},
	{8127, 45932},
	{8154, 46068, 5, 576},
	{54427, 46080},
	{54448, 46084, 1, 498},
	{54469, 46088},
	{54490, 46092, 1, 498},
	{8342, 46108, 3, 619},
	{8366, 46112},
	{8387, 46116, 1, 498},
	{8408, 46120, 10, 4841},
	{8432, 46124, 6, 635},
	{8456, 46128},
	{8482, 46132},
	{8508, 46136},
	{8534, 46140},
	{8560, 46144},
	{8586, 46148},
	{8612, 46152},
	{8638, 46156},
	{8664, 46160},
	{8690, 46164},
	{8716, 46168},
	{8743, 46172},
	{8770, 46176},
	{8797, 46180},
	{8824, 46184},
	{8851, 46188},
	{9486, 46324, 5, 576},
	{54511, 46336},
	{54532, 46340, 1, 498},
	{54553, 46344},
	{54574, 46348, 1, 498},
	{9513, 46364, 4, 583},
	{9537, 46368},
	{9558, 46372, 1, 498},
	{9579, 46376, 11, 4857},
	{9603, 46380, 5, 576},
	{9627, 46384},
	{9653, 46388},
	{9679, 46392},
	{9705, 46396},
	{9731, 46400},
	{9757, 46404},
	{9783, 46408},
	{9809, 46412},
	{9835, 46416},
	{9861, 46420},
	{9887, 46424},
	{9914, 46428},
	{9941, 46432},
	{9968, 46436},
	{9995, 46440},
	{10022, 46444},
	{10049, 47104, 12, 4873},
	{10076, 47108},
	{10090, 47112},
	{10104, 47116},
	{10118, 47120},
	{10134, 47124},
	{10150, 47128},
	{10166, 47132, 2, 666},
	{10187, 47136, 2, 666},
	{10208, 47140, 2, 666},
	{10229, 47144, 1, 668},
	{10257, 47148, 1, 669},
	{10282, 47152},
	{10297, 47156, 2, 4886},
	{54615, 47160},
	{54630, 47164, 1, 670},
	{54645, 47168},
	{54660, 47172, 1, 670},
	{10436, 47176, 10, 4888},
	{10454, 47180, 11, 683},
	{10472, 47184, 1, 694},
	{10485, 47188, 6, 695},
	{54675, 47192, 2, 4905},
	{54706, 47196, 2, 4905},
	{10563, 47200, 2, 701},
	{54889, 47204, 2, 4905},
	{54920, 47208, 2, 4905},
	{10638, 47212},
	{10656, 47216},
	{10674, 47220},
	{10692, 47224, 1, 703},
	{10720, 47228, 5, 704},
	{10742, 47232},
	{10762, 47236},
	{10945, 47240, 3, 720},
	{10962, 47244},
	{10991, 47248, 1, 723},
	{56937, 47252, 2, 5464},
	{11038, 47360},
	{11058, 47364},
	{11078, 47368},
	{11098, 47372},
	{11118, 47376},
	{11138, 47380},
	{11158, 47384},
	{11178, 47388},
	{11198, 47392},
	{11218, 47396},
	{11238, 47400},
	{11259, 47404},
	{11280, 47408},
	{11301, 47412},
	{11322, 47416},
	{11343, 47420},
	{11409, 47612},
	{54737, 53300, 29, 4907},
	{54754, 55348, 29, 4907},
	{11425, 163840, 10, 726},
	{11443, 163844, 9, 4936},
	{11460, 163848, 4, 4945},
	{11474, 163852, 23, 754},
	{11493, 163856, 15, 777},
	{11513, 163860},
	{11549, 163872},
	{11569, 163876},
	{11589, 163880, 1, 795},
	{11606, 163884},
	{11621, 163888, 2, 796},
	{11645, 163892, 2, 798},
	{54771, 163900, 7, 4949},
	{11703, 163904, 10, 5466},
	{11713, 163908, 6, 5476},
	{11729, 163912},
	{11744, 163916},
	{11765, 163920},
	{11781, 163924},
	{54785, 163928, 2, 4969},
	{54799, 163932, 1, 4971},
	{11971, 163968},
	{11987, 163972, 1, 847},
	{12006, 164328, 1, 848},
	{12027, 164332, 1, 848},
	{12048, 164336, 1, 848},
	{12069, 164340, 1, 848},
	{12090, 164344},
	{12108, 164348},
	{12126, 164352, 2, 849},
	{12146, 164356, 3, 851},
	{12170, 164360, 2, 854},
	{12194, 164364, 1, 856},
	{12214, 164368, 2, 851},
	{12234, 164372, 2, 854},
	{12254, 164376, 2, 851},
	{12274, 164380, 2, 854},
	{12294, 164384, 2, 851},
	{12314, 164388, 2, 854},
	{12334, 164392, 2, 851},
	{12354, 164396, 2, 854},
	{12374, 164400, 7, 857},
	{12389, 164404, 2, 864},
	{12418, 164408, 8, 866},
	{12433, 164412, 8, 874},
	{12448, 164416, 3, 851},
	{12473, 164420, 2, 854},
	{12498, 164424},
	{12516, 164428},
	{12534, 164432, 3, 851},
	{12559, 164436, 2, 854},
	{12584, 164440, 3, 851},
	{12609, 164444, 2, 854},
	{12634, 164448, 3, 851},
	{12659, 164452, 2, 854},
	{12684, 164456, 3, 851},
	{12709, 164460, 2, 854},
	{12734, 164464, 3, 851},
	{12759, 164468, 2, 854},
	{12784, 164472, 3, 851},
	{12809, 164476, 2, 854},
	{12834, 164480, 3, 851},
	{12859, 164484, 2, 854},
	{12884, 164488, 3, 851},
	{12909, 164492, 2, 854},
	{12934, 164496, 3, 851},
	{12959, 164500, 2, 854},
	{12984, 164504, 3, 851},
	{13009, 164508, 2, 854},
	{13034, 164512, 3, 851},
	{13060, 164516, 2, 854},
	{13086, 164520, 3, 851},
	{13112, 164524, 2, 854},
	{13138, 164528, 3, 851},
	{13164, 164532, 2, 854},
	{13190, 164536, 3, 851},
	{13216, 164540, 2, 854},
	{13242, 164544, 3, 851},
	{13268, 164548, 2, 854},
	{13294, 164552, 3, 851},
	{13320, 164556, 2, 854},
	{13346, 164560},
	{13365, 164564},
	{13384, 164568},
	{13403, 164572},
	{13422, 164576},
	{13441, 164580},
	{13460, 164584},
	{13479, 164588},
	{13498, 164592},
	{13517, 164596},
	{13536, 164600},
	{13555, 164604},
	{13574, 164608},
	{13593, 164612},
	{13612, 164616},
	{13631, 164620},
	{13650, 164624},
	{13669, 164628},
	{13688, 164632},
	{13707, 164636},
	{13726, 164640},
	{13746, 164644},
	{13766, 164648},
	{13786, 164652},
	{13806, 164656},
	{13826, 164660},
	{13846, 164664},
	{13866, 164668},
	{13886, 164672},
	{13906, 164676},
	{13926, 164680},
	{13946, 164684},
	{13966, 164688, 15, 882},
	{13986, 164692, 3, 897},
	{14008, 164696, 2, 900},
	{14065, 164704, 1, 909},
	{54814, 164708, 1, 4972},
	{14096, 164712, 1, 911},
	{14164, 164864},
	{14181, 164868},
	{14198, 164872},
	{14214, 164876},
	{14268, 164884},
	{14281, 164888},
	{14296, 164892},
	{14310, 164896},
	{14325, 164900, 3, 5482},
	{14364, 164908, 6, 942},
	{14383, 164912, 4, 948},
	{14401, 164916, 4, 952},
	{14422, 164924},
	{14441, 164928},
	{14461, 164932},
	{14480, 164936},
	{14500, 164940},
	{14519, 164944},
	{14539, 164948},
	{14560, 164952},
	{14582, 164956},
	{14603, 164960},
	{14625, 164964},
	{14646, 164968},
	{14668, 164972},
	{14689, 164976},
	{14711, 164980},
	{14732, 164984},
	{14754, 164988},
	{14775, 164992},
	{14797, 164996},
	{14818, 165000},
	{14840, 165004},
	{14861, 165008},
	{14883, 165012},
	{14904, 165016},
	{14926, 165020},
	{14947, 165024},
	{14969, 165028},
	{14990, 165032},
	{15012, 165036},
	{15033, 165040},
	{15055, 165044},
	{15076, 165048},
	{15098, 165052},
	{15119, 165056},
	{15141, 165060},
	{15162, 165064},
	{15184, 165068},
	{15205, 165072},
	{15227, 165076},
	{15248, 165080},
	{15270, 165084},
	{15291, 165088},
	{15313, 165092},
	{15334, 165096},
	{15356, 165100},
	{15377, 165104},
	{15399, 165108},
	{15420, 165112},
	{15442, 165116},
	{15463, 165120},
	{15485, 165124},
	{15506, 165128},
	{15528, 165132},
	{15549, 165136},
	{15571, 165140},
	{15592, 165144},
	{15614, 165148},
	{15635, 165152},
	{15657, 165156},
	{15678, 165160},
	{15700, 165164},
	{15722, 165168},
	{15745, 165172},
	{15767, 165176},
	{15790, 165180},
	{15812, 165184},
	{15835, 165188},
	{15857, 165192},
	{15880, 165196},
	{15902, 165200},
	{15925, 165204},
	{15947, 165208},
	{15970, 165212},
	{15992, 165216},
	{16015, 165220},
	{16037, 165224},
	{16060, 165228},
	{16082, 165232},
	{16105, 165236},
	{16127, 165240},
	{16150, 165244},
	{16172, 165248},
	{16195, 165252},
	{16217, 165256},
	{16240, 165260},
	{16262, 165264},
	{16285, 165268},
	{16307, 165272},
	{16330, 165276},
	{16352, 165280},
	{16375, 165284},
	{16397, 165288},
	{16420, 165292},
	{16442, 165296},
	{16465, 165300},
	{16487, 165304},
	{16510, 165308},
	{16524, 165312},
	{16538, 165316},
	{16552, 165320},
	{16566, 165324},
	{16580, 165328},
	{16594, 165332},
	{16608, 165336},
	{16622, 165340},
	{16636, 165344},
	{16650, 165348},
	{16664, 165352},
	{16678, 165356},
	{16692, 165360},
	{16706, 165364},
	{16720, 165368},
	{16734, 165372},
	{16748, 165376},
	{16762, 165380},
	{16776, 165384},
	{16790, 165388},
	{16804, 165392},
	{16818, 165396},
	{16832, 165400},
	{16869, 165444, 12, 956},
	{16889, 165448, 12, 956},
	{16909, 165452, 12, 956},
	{16929, 165456, 12, 956},
	{16949, 165460, 12, 956},
	{16969, 165464, 12, 956},
	{16989, 165468, 12, 956},
	{17009, 165472, 12, 956},
	{17029, 165476, 12, 956},
	{17049, 165480, 12, 956},
	{17069, 165484, 12, 956},
	{17090, 165488, 12, 956},
	{17111, 165492, 12, 956},
	{17132, 165496, 12, 956},
	{17153, 165500, 12, 956},
	{17174, 165504, 12, 956},
	{17195, 165508, 12, 956},
	{17216, 165512, 12, 956},
	{17237, 165516, 12, 956},
	{17258, 165520, 12, 956},
	{17279, 165524, 9, 968},
	{17300, 165528, 9, 968},
	{17321, 165532, 9, 968},
	{17342, 165536, 9, 968},
	{17363, 165540, 9, 968},
	{17384, 165544, 9, 968},
	{17405, 165548, 9, 968},
	{17426, 165552, 9, 968},
	{17447, 165556, 9, 968},
	{17468, 165560, 9, 968},
	{17489, 165564, 9, 968},
	{17510, 165568, 9, 968},
	{17531, 165572, 2, 977},
	{17549, 165580, 16, 980},
	{17566, 165584, 16, 980},
	{17584, 165588, 7, 996},
	{17605, 165592, 3, 4973},
	{17623, 165600, 7, 1009},
	{17638, 165608, 2, 701},
	{17677, 165644, 4, 1017},
	{17699, 165648, 1, 1022},
	{17719, 165652, 8, 1023},
	{17741, 165716, 8, 1031},
	{17759, 165720, 8, 1039},
	{17780, 165724, 17, 1047},
	{17801, 165728, 6, 1064},
	{17819, 165732, 6, 1064},
	{17837, 165736, 6, 1064},
	{17855, 165740, 6, 1064},
	{17873, 165744, 6, 1064},
	{17891, 165748, 6, 1064},
	{17909, 165752, 6, 1064},
	{17927, 165756, 6, 1064},
	{17945, 165760, 9, 1070},
	{17963, 165764, 9, 1070},
	{17981, 165768, 9, 1070},
	{17999, 165772, 9, 1070},
	{18017, 165776, 9, 1070},
	{18035, 165780, 9, 1070},
	{18053, 165784, 9, 1070},
	{18071, 165788, 9, 1070},
	{18089, 165836, 1, 1079},
	{18103, 165840, 1, 1079},
	{18118, 165844},
	{18136, 165848},
	{18154, 165852},
	{18171, 165856},
	{18192, 165860, 1, 4976},
	{18208, 165864},
	{18221, 165872, 5, 1081},
	{18240, 165876},
	{18255, 165880, 1, 1089},
	{18304, 165888, 10, 1091},
	{18321, 165892, 12, 1101},
	{18329, 165896, 4, 5645},
	{18346, 165900, 13, 1117},
	{18364, 165904, 19, 1134},
	{18380, 165908, 13, 1154},
	{18399, 165912, 10, 1170},
	{18414, 165916, 27, 5488},
	{18432, 165920, 16, 1208},
	{18450, 165924, 4, 1224},
	{18474, 165928},
	{18499, 165932, 11, 1228},
	{18651, 166400, 2, 1260},
	{18668, 166404, 2, 1262},
	{18687, 166408, 1, 1264},
	{18703, 166412, 4, 1265},
	{18722, 166416, 1, 1269},
	{18743, 166420, 1, 1270},
	{18756, 166424},
	{18779, 166428},
	{18802, 166432, 1, 1271},
	{18822, 166436, 4, 4980},
	{18842, 166440, 1, 1276},
	{18863, 166444, 1, 1277},
	{18878, 166448, 6, 1278},
	{18900, 166452, 6, 1278},
	{18922, 166456, 8, 1284},
	{18948, 166460, 8, 1284},
	{18974, 166464, 15, 5515},
	{18986, 166468, 2, 1307},
	{19005, 166472, 4, 1310},
	{19023, 166476, 24, 1317},
	{19041, 166480},
	{19053, 166484, 1, 1341},
	{19067, 166488, 1, 1342},
	{19081, 166492, 1, 1343},
	{19095, 166496, 1, 1344},
	{19118, 166500, 1, 1344},
	{19141, 166504, 1, 1344},
	{19164, 166508, 5, 4984},
	{19185, 166512},
	{19196, 166516},
	{19209, 166520},
	{19226, 166524, 7, 5530},
	{19245, 166528},
	{19256, 166532, 2, 1358},
	{19275, 166536},
	{19297, 166540},
	{19319, 166544, 3, 5537},
	{19339, 166548, 1, 1364},
	{19388, 166560},
	{19413, 166564},
	{19438, 166568, 7, 5540},
	{19457, 166572, 1, 1377},
	{19480, 166576, 1, 1377},
	{19503, 166580, 1, 1378},
	{19517, 166584, 1, 1379},
	{19532, 166588, 8, 5547},
	{19549, 166592, 4, 1389},
	{19576, 166596, 4, 1393},
	{19603, 166600, 4, 1397},
	{19622, 166608},
	{19648, 166612, 1, 1401},
	{19673, 166620},
	{19701, 166624},
	{19727, 166628, 1, 1401},
	{19752, 166636},
	{19780, 166640},
	{19806, 166644, 1, 1401},
	{19831, 166652},
	{19859, 166656},
	{19885, 166660, 1, 1401},
	{19910, 166668},
	{19938, 166696},
	{19969, 166700},
	{20012, 166704, 1, 1402},
	{20050, 166712, 1, 1403},
	{20089, 166736, 4, 5649},
	{20111, 166740, 10, 1411},
	{20132, 166744, 3, 1430},
	{20149, 166748, 1, 1377},
	{20170, 166752, 1, 1377},
	{20193, 166756, 1, 1377},
	{20216, 166760, 1, 1377},
	{20239, 166764, 10, 5555},
	{20252, 166768, 6, 1445},
	{20269, 166772},
	{20293, 166776, 2, 1451},
	{20323, 166780},
	{20347, 166784},
	{20377, 166788},
	{20408, 166792},
	{20437, 166796},
	{20467, 166800, 2, 1453},
	{20487, 166804, 7, 5014},
	{20506, 166808, 4, 1464},
	{20556, 166868, 8, 1468},
	{20582, 166872, 8, 1476},
	{20608, 166876, 4, 1484},
	{20624, 166880, 5, 1489},
	{20640, 166884, 3, 1495},
	{20655, 166888},
	{20678, 166892},
	{20701, 166896},
	{20724, 166900},
	{20747, 166904, 8, 1498},
	{20781, 166908, 8, 1506},
	{20815, 166912, 8, 1514},
	{20849, 166916, 8, 1522},
	{20883, 166920, 8, 1498},
	{20917, 166924, 8, 1506},
	{20951, 166928, 8, 1514},
	{20985, 166932, 8, 1522},
	{21019, 166936, 8, 1498},
	{21053, 166940, 8, 1506},
	{21087, 166944, 8, 1514},
	{21121, 166948, 8, 1522},
	{21155, 166952, 8, 1498},
	{21189, 166956, 8, 1506},
	{21223, 166960, 8, 1514},
	{21257, 166964, 8, 1522},
	{21291, 166968, 2, 1530},
	{21315, 166972, 2, 1532},
	{21339, 166976, 1, 1534},
	{21458, 167000, 1, 1574},
	{21486, 167004, 1, 1575},
	{21507, 167008},
	{21522, 167012, 2, 1576},
	{21538, 167016, 1, 1578},
	{21554, 167020, 2, 4945},
	{21569, 167024, 18, 5653},
	{21584, 167028, 6, 1601},
	{21601, 167032, 9, 1609},
	{21623, 167036},
	{21639, 167040, 1, 1621},
	{21661, 167044},
	{21677, 167048, 1, 1578},
	{21699, 167052},
	{21721, 167056},
	{21743, 167060},
	{21762, 167068},
	{21777, 167072, 2, 1576},
	{21793, 167076, 1, 1578},
	{21809, 167080, 2, 4945},
	{21824, 167084, 18, 5653},
	{21839, 167088, 6, 1601},
	{21856, 167092, 9, 1609},
	{21878, 167096},
	{21894, 167100, 1, 1621},
	{21916, 167104},
	{21932, 167108, 1, 1578},
	{21954, 167112},
	{21976, 167116},
	{21998, 167120},
	{22017, 167128},
	{22032, 167132, 2, 1576},
	{22048, 167136, 1, 1578},
	{22064, 167140, 2, 4945},
	{22079, 167144, 18, 5653},
	{22094, 167148, 6, 1601},
	{22111, 167152, 9, 1609},
	{22133, 167156},
	{22149, 167160, 1, 1621},
	{22171, 167164},
	{22187, 167168, 1, 1578},
	{22209, 167172},
	{22231, 167176},
	{22253, 167180},
	{22272, 167188},
	{22287, 167192, 2, 1576},
	{22303, 167196, 1, 1578},
	{22319, 167200, 2, 4945},
	{22334, 167204, 18, 5653},
	{22349, 167208, 6, 1601},
	{22366, 167212, 9, 1609},
	{22388, 167216},
	{22404, 167220, 1, 1621},
	{22426, 167224},
	{22442, 167228, 1, 1578},
	{22464, 167232},
	{22486, 167236},
	{22508, 167240},
	{22527, 167248},
	{22542, 167252, 2, 1576},
	{22558, 167256, 1, 1578},
	{22574, 167260, 2, 4945},
	{22589, 167264, 18, 5653},
	{22604, 167268, 6, 1601},
	{22621, 167272, 9, 1609},
	{22643, 167276},
	{22659, 167280, 1, 1621},
	{22681, 167284},
	{22697, 167288, 1, 1578},
	{22719, 167292},
	{22741, 167296},
	{22763, 167300},
	{22782, 167308},
	{22797, 167312, 2, 1576},
	{22813, 167316, 1, 1578},
	{22829, 167320, 2, 4945},
	{22844, 167324, 18, 5653},
	{22859, 167328, 6, 1601},
	{22876, 167332, 9, 1609},
	{22898, 167336},
	{22914, 167340, 1, 1621},
	{22936, 167344},
	{22952, 167348, 1, 1578},
	{22974, 167352},
	{22996, 167356},
	{23018, 167360},
	{23037, 167368},
	{23052, 167372, 2, 1576},
	{23068, 167376, 1, 1578},
	{23084, 167380, 2, 4945},
	{23099, 167384, 18, 5653},
	{23114, 167388, 6, 1601},
	{23131, 167392, 9, 1609},
	{23153, 167396},
	{23169, 167400, 1, 1621},
	{23191, 167404},
	{23207, 167408, 1, 1578},
	{23229, 167412},
	{23251, 167416},
	{23273, 167420},
	{23292, 167428},
	{23307, 167432, 2, 1576},
	{23323, 167436, 1, 1578},
	{23339, 167440, 2, 4945},
	{23354, 167444, 18, 5653},
	{23369, 167448, 6, 1601},
	{23386, 167452, 9, 1609},
	{23408, 167456},
	{23424, 167460, 1, 1621},
	{23446, 167464},
	{23462, 167468, 1, 1578},
	{23484, 167472},
	{23506, 167476},
	{23528, 167480},
	{24571, 196608, 1, 1634},
	{24591, 196612, 1, 1635},
	{24611, 196616},
	{24631, 196620},
	{24651, 196624},
	{24672, 196628},
	{24693, 196632, 1, 1636},
	{24715, 196636, 1, 1637},
	{24737, 196640},
	{24767, 196644},
	{24797, 196648},
	{24826, 196652},
	{24855, 196656},
	{24885, 196660},
	{24915, 196664},
	{24944, 196668},
	{24973, 196672},
	{25003, 196676},
	{25033, 196680},
	{25062, 196684},
	{25091, 196688},
	{25121, 196692},
	{25151, 196696},
	{25180, 196700},
	{25209, 196704, 1, 1638},
	{25231, 196708, 1, 1639},
	{25253, 196712},
	{25276, 196716},
	{25299, 196720},
	{25322, 196724},
	{25345, 196728},
	{25368, 196732},
	{25391, 196736},
	{25415, 196740},
	{25439, 196744},
	{25463, 196748},
	{25487, 196752},
	{25511, 196756},
	{25535, 196760},
	{25559, 196764},
	{25583, 196768},
	{25605, 196772},
	{25627, 196776},
	{25648, 196780},
	{25669, 196784},
	{25693, 196788},
	{25717, 196792},
	{25741, 196796},
	{25765, 196800},
	{25789, 196804},
	{25873, 196852, 2, 5583},
	{25895, 196856, 2, 5583},
	{25917, 196860, 1, 1642},
	{25933, 196864},
	{25946, 196868},
	{25959, 196872},
	{25972, 196876},
	{25985, 196880},
	{25998, 196884},
	{26011, 196888},
	{26024, 196892},
	{26151, 196928, 2, 1643},
	{26164, 196932},
	{26177, 196936},
	{26200, 196940},
	{26223, 196944},
	{26251, 196948},
	{26279, 196952},
	{26307, 196956},
	{26335, 196960, 1, 1645},
	{26353, 196964, 5, 5585},
	{26371, 196968},
	{26386, 196972},
	{26410, 196976},
	{26434, 196980},
	{26453, 196984},
	{26472, 196988},
	{26496, 196992},
	{26520, 196996},
	{26544, 197000},
	{26568, 197028, 2, 4171},
	{26586, 197032, 3, 5590},
	{26604, 197036},
	{26622, 197040},
	{26640, 197044, 2, 4174},
	{26658, 197048, 3, 5593},
	{26676, 197052},
	{26694, 197056, 2, 1656},
	{26713, 197060, 5, 1658},
	{26732, 197072},
	{26756, 197076, 2, 1656},
	{26776, 197080, 5, 1658},
	{26796, 197084, 8, 5596},
	{26815, 197088, 8, 5596},
	{26833, 197092, 1, 1670},
	{26850, 197100, 1, 1671},
	{26871, 197104, 26, 5604},
	{26885, 197108},
	{26899, 197112},
	{26913, 197116, 4, 4205},
	{26929, 197120},
	{26948, 197124, 1, 1687},
	{26970, 197128},
	{26989, 197132, 1, 1688},
	{27011, 197136, 9, 4211},
	{27029, 197140},
	{27049, 197144, 1, 1687},
	{27072, 197148},
	{27092, 197152, 1, 1688},
	{27115, 197156, 9, 4211},
	{27134, 197160, 5, 4220},
	{27146, 197164, 2, 1703},
	{27163, 197168, 1, 1705},
	{27180, 197172, 1, 1706},
	{27198, 197176, 4, 1707},
	{27218, 197180, 1, 1711},
	{27235, 197184},
	{27251, 197188, 1, 1713},
	{27264, 197192, 1, 1714},
	{27278, 197196, 1, 1715},
	{27292, 197200, 1, 1716},
	{27314, 197204, 1, 1717},
	{27334, 197208, 1, 1718},
	{27356, 197212, 1, 1719},
	{27376, 197216, 1, 1714},
	{27393, 197220, 1, 1715},
	{27410, 197224},
	{56966, 197228, 1, 1713},
	{27669, 197388, 1, 1728},
	{27688, 197392, 1, 1729},
	{27707, 197396, 1, 1730},
	{27724, 197400, 1, 1731},
	{27742, 197404, 1, 1732},
	{27760, 197408, 1, 1733},
	{27776, 197412, 1, 1734},
	{27794, 197416, 1, 1735},
	{27812, 197420, 1, 1736},
	{27828, 197424, 1, 1731},
	{27843, 197428, 1, 1732},
	{27858, 197432, 1, 1733},
	{27871, 197436, 1, 1734},
	{27886, 197440, 1, 1735},
	{27901, 197444, 1, 1736},
	{27914, 197448, 1, 1737},
	{27928, 197452, 1, 1738},
	{27942, 197456, 1, 1739},
	{27954, 197460, 4, 5630},
	{27977, 197464, 4, 5223},
	{27999, 197468, 1, 1747},
	{28143, 197552, 1, 1752},
	{28168, 197556, 1, 1752},
	{28192, 197560, 1, 1753},
	{28212, 197568},
	{28238, 197572, 1, 1635},
	{28267, 197576},
	{28292, 197580, 1, 1635},
	{28320, 197584},
	{28343, 197588, 1, 1635},
	{28369, 197592},
	{28391, 197596, 1, 1635},
	{28416, 197600},
	{28435, 197604, 1, 1635},
	{28457, 197608, 1, 1350},
	{28471, 197612},
	{28488, 197616, 1, 1635},
	{28508, 197620, 8, 1754},
	{28677, 198656, 6, 4077},
	{28692, 198912},
	{28711, 198916},
	{28730, 198920, 1, 4460},
	{28749, 198924, 1, 1350},
	{28764, 198928},
	{28797, 198932},
	{28830, 198936},
	{28863, 198940},
	{28953, 198960},
	{28969, 198964},
	{28987, 198968, 1, 1792},
	{29004, 198972, 2, 1793},
	{29025, 198976},
	{29357, 199168, 1, 1816},
	{29382, 199172, 2, 1817},
	{29407, 199184, 2, 1819},
	{29433, 199188, 2, 1819},
	{29459, 199192, 2, 1819},
	{29485, 199212, 2, 1819},
	{29511, 199296, 2, 1821},
	{29539, 199300, 1, 1823},
	{29563, 199304, 1, 1824},
	{29587, 199308, 1, 1825},
	{29620, 199312, 1, 1825},
	{29648, 199328, 2, 1821},
	{29677, 199332, 1, 1823},
	{29702, 199336, 1, 1824},
	{29727, 199340, 1, 1825},
	{29761, 199344, 1, 1825},
	{29790, 199360, 2, 1821},
	{29814, 199364, 1, 1823},
	{29834, 199368, 1, 1824},
	{29854, 199372, 1, 1825},
	{29883, 199376, 1, 1825},
	{53768, 199872},
	{53789, 199876, 1, 4637},
	{2431, 199880, 8, 5191},
	{2452, 199884, 3, 4646},
	{53810, 199888, 2, 4649},
	{2479, 199892, 1, 4673},
	{53836, 199896, 15, 4658},
	{54839, 199900, 1, 5200},
	{54861, 199904},
	{2410, 199908, 2, 4651},
	{2500, 199912, 5, 5203},
	{53878, 199916, 1, 4674},
	{29907, 199936},
	{29934, 199940},
	{29961, 199944},
	{29988, 199948},
	{30123, 199968, 6, 1826},
	{30134, 199972, 2, 1833},
	{30148, 200192},
	{30167, 200196, 1, 847},
	{30189, 200448},
	{30213, 200452, 1, 1835},
	{30236, 200456},
	{30260, 200460, 1, 1835},
	{30283, 200464},
	{30307, 200468, 1, 1835},
	{30330, 200472},
	{30354, 200476, 1, 1835},
	{30377, 200696},
	{30396, 200700, 1, 1835},
	{30414, 200704},
	{30426, 200708},
	{30438, 200712},
	{30456, 200716},
	{30475, 200720},
	{30493, 200724},
	{30505, 200728},
	{30517, 200732},
	{30535, 200736},
	{30553, 200740},
	{30572, 200744, 4, 1836},
	{30586, 200748, 2, 1840},
	{30604, 200752, 2, 1842},
	{30618, 200756, 2, 1844},
	{30632, 200760, 2, 1846},
	{30649, 200764, 2, 1848},
	{30666, 200768},
	{30679, 200772, 2, 1850},
	{30691, 200776},
	{30705, 200780},
	{30721, 200784},
	{30735, 200788},
	{30751, 200792},
	{30766, 200796},
	{30783, 200800},
	{30798, 200804},
	{30815, 200808, 2, 1852},
	{30837, 200812, 9, 5671},
	{30854, 200816, 2, 1864},
	{30875, 200820, 2, 1866},
	{30887, 200824},
	{30902, 200828, 6, 5634},
	{30917, 200832, 2, 1874},
	{30931, 200836},
	{31044, 212992},
	{31064, 212996},
	{31084, 213000},
	{31104, 213004},
	{31124, 213008},
	{31144, 213012},
	{31164, 213016},
	{31184, 213020},
	{31204, 213024},
	{31224, 213028},
	{31244, 213032},
	{31264, 213036},
	{31353, 213248},
	{31374, 213252},
	{31395, 213260},
	{31416, 213264},
	{31437, 213268},
	{31461, 213272},
	{31485, 213276},
	{31509, 213280},
	{31533, 213284},
	{31557, 213288},
	{31581, 213292},
	{31605, 213296},
	{54951, 213504},
	{54970, 213508},
	{54989, 213512},
	{55008, 213516},
	{55027, 213520},
	{55046, 213524},
	{55065, 213528},
	{55084, 213532},
	{52441, 213536},
	{52460, 213540},
	{52479, 213544},
	{52498, 213548},
	{52517, 213552},
	{52536, 213556},
	{52555, 213560},
	{52574, 213564},
	{52994, 213568},
	{53014, 213572},
	{53034, 213576},
	{53054, 213580},
	{53074, 213584},
	{53094, 213588},
	{53114, 213592},
	{53134, 213596},
	{32089, 214016},
	{32111, 214020, 1, 1876},
	{32133, 214024},
	{32155, 214028, 1, 1876},
	{32177, 214032},
	{32199, 214036, 1, 1876},
	{32221, 214040},
	{32243, 214044, 1, 1876},
	{32265, 214272},
	{32287, 214276},
	{32309, 214280},
	{32331, 214284},
	{32353, 214288},
	{32375, 214292},
	{32397, 214296},
	{32419, 214300},
	{32441, 214304},
	{32463, 214308},
	{32485, 214312},
	{32507, 214316},
	{32529, 214320},
	{32551, 214324},
	{32573, 214328},
	{32595, 214332},
	{32617, 214528},
	{32637, 214532},
	{32657, 214536},
	{32677, 214540},
	{32697, 214544},
	{32717, 214548},
	{32737, 214552},
	{32757, 214556},
	{32777, 214560},
	{32797, 214564},
	{32817, 214568},
	{32837, 214572},
	{32857, 214784},
	{32876, 214788},
	{32895, 214792},
	{32914, 214796},
	{32933, 214800},
	{32952, 214804},
	{32971, 214808},
	{32990, 214812},
	{33009, 214816},
	{33028, 214820},
	{33047, 214824},
	{33066, 214828},
	{33085, 214832},
	{33104, 214836},
	{33123, 214840},
	{33142, 214844},
	{33161, 214848},
	{33180, 214852},
	{33199, 214856},
	{33218, 214860},
	{33237, 214864},
	{33257, 214868},
	{33277, 214872},
	{33297, 214876},
	{33317, 214880},
	{33337, 214884},
	{33357, 214888},
	{33377, 214892},
	{33397, 214896},
	{33417, 214900},
	{33437, 214904},
	{33457, 214908},
	{33477, 215296},
	{33496, 215300},
	{33515, 215304},
	{33534, 215308},
	{33553, 215312},
	{33572, 215316},
	{33591, 215320},
	{33610, 215324},
	{33671, 215552},
	{33691, 215556},
	{33711, 215560},
	{33731, 215564},
	{33751, 215568},
	{33771, 215572},
	{33791, 215576},
	{33811, 215580},
	{33831, 215808},
	{33850, 215812},
	{33869, 215816},
	{33888, 215820},
	{33907, 216064},
	{33926, 216068},
	{33945, 216072},
	{33964, 216076},
	{33983, 216320},
	{34003, 216324},
	{34023, 216328},
	{34043, 216332},
	{34063, 216336},
	{34083, 216340},
	{34103, 216344},
	{34123, 216348},
	{55103, 216576},
	{55123, 216580},
	{55143, 216584},
	{55163, 216588},
	{55183, 216592},
	{55203, 216596},
	{55223, 216600},
	{55243, 216604},
	{55263, 216640},
	{55283, 216644},
	{55303, 216648},
	{55323, 216652},
	{55343, 216656},
	{55363, 216660},
	{55383, 216664},
	{55403, 216668},
	{34975, 217112},
	{34994, 217116},
	{35013, 217120},
	{35032, 217124},
	{35051, 217128},
	{35070, 217132},
	{35089, 217136},
	{35108, 217140},
	{35127, 217344},
	{35146, 217348},
	{35165, 217352},
	{35184, 217356},
	{35203, 217360},
	{35222, 217364},
	{35241, 217368},
	{35260, 217372},
	{35279, 217600},
	{35299, 217604},
	{35319, 217608},
	{35339, 217612},
	{36661, 221184, 1, 1910},
	{36685, 221188, 2, 5240},
	{36710, 221192, 3, 5242},
	{36734, 221196, 1, 1910},
	{36758, 221200, 2, 5240},
	{36783, 221204, 1, 1910},
	{36807, 221208, 2, 5240},
	{36832, 221212, 3, 5242},
	{36856, 221216, 4, 1888},
	{36872, 221220, 3, 5242},
	{37039, 221248},
	{37054, 221252, 1, 1825},
	{37077, 221256},
	{37100, 221260},
	{37118, 221264, 2, 1904},
	{37136, 221268, 4, 1906},
	{37156, 221440, 19, 4120},
	{37181, 221444, 19, 4120},
	{37206, 221448, 12, 4139},
	{37234, 221452, 12, 4139},
	{37262, 221456, 12, 4139},
	{37290, 221460, 12, 4139},
	{55583, 221696, 2, 4418},
	{55606, 221700, 2, 4418},
	{55629, 221704, 2, 4418},
	{55652, 221708, 2, 4418},
	{52349, 221712, 5, 1964},
	{52372, 221716, 2, 4418},
	{52395, 221720, 2, 4418},
	{52418, 221724, 2, 4418},
	{55675, 221728, 4, 1969},
	{52898, 221744, 5, 1964},
	{52922, 221748, 5, 1964},
	{52946, 221752, 2, 4418},
	{52970, 221756, 2, 4418},
	{55699, 221760, 4, 1969},
	{55724, 221764, 4, 1969},
	{52872, 221776, 1, 4459},
	{37748, 222208, 3, 1964},
	{37774, 222212, 2, 1884},
	{37801, 222216, 3, 1964},
	{37827, 222220, 2, 1884},
	{37854, 222224, 2, 2020},
	{37907, 222228, 2, 2020},
	{37960, 222464, 3, 1964},
	{37986, 222468, 2, 1884},
	{38013, 222472, 1, 1879},
	{38039, 222476, 1, 1879},
	{38065, 222480, 1, 1879},
	{38091, 222484, 1, 1879},
	{38117, 222488, 1, 1879},
	{38143, 222492, 1, 1879},
	{38169, 222496, 1, 1879},
	{38195, 222720, 3, 1964},
	{38219, 222724, 3, 1964},
	{38243, 222728, 3, 1964},
	{38267, 222732, 3, 1964},
	{38291, 222736, 2, 1884},
	{38316, 222740, 2, 1884},
	{38341, 222744, 2, 1884},
	{38366, 222748, 2, 1884},
	{38391, 222752, 1, 2008},
	{38415, 222756, 1, 2008},
	{38439, 222760, 8, 1973},
	{38460, 222976, 6, 4617},
	{38483, 222980, 6, 4617},
	{38506, 222984, 6, 4617},
	{38529, 222988, 6, 4617},
	{38552, 222992, 6, 4617},
	{38575, 222996, 6, 4617},
	{38598, 223000, 6, 4617},
	{38621, 223004, 6, 4617},
	{38644, 223008, 6, 4617},
	{38667, 223012, 6, 4617},
	{38690, 223016, 6, 4617},
	{38714, 223020, 6, 4617},
	{38738, 223024, 6, 4617},
	{38762, 223028, 6, 4617},
	{38786, 223032, 6, 4617},
	{38810, 223036, 6, 4617},
	{38834, 223104, 9, 4600},
	{55749, 223108, 2, 4649},
	{38854, 223112, 1, 1994},
	{38949, 223488, 3, 2003},
	{38972, 223492, 3, 2003},
	{38995, 223496, 3, 2003},
	{39018, 223500, 3, 2003},
	{39041, 223504, 2, 2006},
	{39065, 223508, 2, 2006},
	{39089, 223744, 3, 2003},
	{39113, 223748, 3, 2003},
	{39137, 223752, 3, 2003},
	{39161, 223756, 3, 2003},
	{39185, 223760, 2, 2006},
	{39210, 224000, 5, 2008},
	{39233, 224004, 4, 2013},
	{39257, 224008, 5, 2008},
	{39280, 224256, 5, 2008},
	{39303, 224260, 4, 2013},
	{39327, 224264, 5, 2008},
	{39350, 224512, 5, 1964},
	{39374, 224516, 4, 1969},
	{39399, 224520, 5, 1964},
	{39423, 224524, 4, 1969},
	{39448, 224528, 3, 2020},
	{39472, 224532, 3, 2020},
	{55769, 224768, 5, 1964},
	{55793, 224772, 4, 1958},
	{55818, 224776, 5, 1964},
	{55842, 224780, 4, 1958},
	{55867, 224784, 3, 2020},
	{55891, 224788, 3, 2020},
	{55915, 224832, 5, 1964},
	{55939, 224836, 4, 1958},
	{55964, 224840, 5, 1964},
	{55988, 224844, 4, 1958},
	{56013, 224848, 3, 2020},
	{56037, 224852, 3, 2020},
	{40173, 225280, 12, 2023},
	{40195, 225284, 5, 2035},
	{40218, 225288, 4, 2040},
	{40242, 225292, 2, 2044},
	{40265, 225296, 2, 2044},
	{40288, 225300, 2, 2044},
	{40311, 225536, 5, 1964},
	{40334, 225540, 4, 1969},
	{40358, 225544, 5, 1964},
	{40381, 225548, 4, 1969},
	{40405, 225552, 5, 1964},
	{40428, 225560, 5, 1964},
	{40451, 225792, 4, 2046},
	{40472, 225796},
	{40501, 225800, 2, 2050},
	{40530, 225804},
	{40556, 225808, 7, 2052},
	{40630, 225812},
	{40653, 225816},
	{56182, 225820, 2, 5251},
	{56215, 225824, 2, 5251},
	{56248, 225828, 2, 5251},
	{56281, 225832, 2, 5251},
	{56313, 225836, 2, 5251},
	{56345, 225840, 2, 5251},
	{56377, 225844, 2, 5251},
	{56410, 225848, 2, 5251},
	{56442, 225856, 2, 5251},
	{56474, 225860, 2, 5251},
	{56507, 225864, 2, 5251},
	{56540, 225868, 2, 5251},
	{56573, 225872, 2, 5251},
	{56605, 225876, 2, 5251},
	{56637, 225880, 2, 5251},
	{56670, 225884, 2, 5251},
	{56703, 225888, 2, 5251},
	{56769, 225896, 2, 5251},
	{40676, 225900},
	{40703, 225904},
	{40585, 225908},
	{40604, 225912},
	{41573, 226044, 1, 2136},
	{41366, 226048, 2, 2126},
	{41383, 226052, 1, 2128},
	{41407, 226056, 1, 2128},
	{206, 880, 4, 2163},
	{43152, 881},
	{26999, 882},
	{43164, 1008},
	{43175, 1009},
	{27187, 1010, 4, 2167},
	{43186, 1040, 1, 2171},
	{43199, 1041, 5, 5253},
	{43212, 1042, 1, 2177},
	{43225, 1043, 1, 1688},
	{27021, 1045, 9, 5045},
	{43253, 1281, 6, 5258},
	{43268, 1282},
	{26958, 1283},
	{43152, 1285},
	{26999, 1286},
};

static const struct si_reg gfx9_reg_table[] = {
	{1310, 68, 14, 5680},
	{1323, 72, 23, 5694},
	{1338, 76, 7, 5717},
	{51171, 80, 11, 5070},
	{1375, 84, 4, 3931},
	{1393, 88, 2, 3935},
	{1411, 92, 7, 5724},
	{1426, 96},
	{1440, 100, 1, 70},
	{1454, 104},
	{51185, 108},
	{51202, 112, 13, 5731},
	{1471, 116, 7, 5744},
	{1487, 120},
	{1609, 2480},
	{1623, 2484},
	{1637, 2488},
	{1651, 2492},
	{1665, 2496},
	{1679, 2500},
	{1693, 2504},
	{1707, 2508},
	{1721, 2512},
	{1735, 2516},
	{1749, 2520},
	{1764, 2524},
	{1779, 2528},
	{1794, 2532},
	{1809, 2536},
	{1824, 2540},
	{1839, 2544},
	{1850, 2552},
	{1866, 2556},
	{1954, 32776, 25, 5751},
	{1967, 32784, 24, 5776},
	{1979, 32788, 12, 5800},
	{1995, 32792, 12, 5800},
	{2024, 32824, 12, 5800},
	{2040, 32828, 12, 5800},
	{2056, 33296, 16, 5812},
	{2070, 33300, 28, 204},
	{2087, 33304, 14, 232},
	{2108, 33308, 21, 5828},
	{2122, 33312, 31, 5153},
	{2139, 33316, 11, 307},
	{2178, 33324, 1, 329},
	{2201, 33344, 1, 330},
	{2222, 33348},
	{2242, 33352, 1, 332},
	{2283, 33436, 1, 342},
	{2687, 36608},
	{2705, 36612, 4, 383},
	{2723, 36616},
	{2741, 36620, 12, 5849},
	{3642, 36624},
	{3660, 36628, 8, 5861},
	{3678, 36632, 3, 4718},
	{3696, 36636, 8, 5869},
	{3714, 36640, 3, 5877},
	{3732, 36644, 7, 5880},
	{3750, 36648, 8, 5421},
	{3768, 36652},
	{2759, 36656, 14, 5429},
	{2777, 36660, 4, 411},
	{2795, 36664, 10, 5887},
	{2813, 36668, 3, 5897},
	{2847, 39160, 13, 5900},
	{2862, 39184, 5, 4776},
	{2876, 39188, 5, 4776},
	{2890, 39192, 5, 4776},
	{2904, 39196, 5, 4776},
	{2918, 39200, 5, 4776},
	{2932, 39204, 5, 4776},
	{2946, 39208, 5, 4776},
	{2960, 39212, 5, 4776},
	{2974, 39216, 5, 4776},
	{2988, 39220, 5, 4776},
	{3002, 39224, 5, 4776},
	{3017, 39228, 5, 4776},
	{3032, 39232, 5, 4776},
	{3047, 39236, 5, 4776},
	{3062, 39240, 5, 4776},
	{3077, 39244, 5, 4776},
	{3092, 39248, 5, 4776},
	{3107, 39252, 5, 4776},
	{3122, 39256, 5, 4776},
	{3137, 39260, 5, 4776},
	{3152, 39264, 5, 4776},
	{3167, 39268, 5, 4776},
	{3182, 39272, 5, 4776},
	{3197, 39276, 5, 4776},
	{3212, 39280, 5, 4776},
	{3227, 39284, 5, 4776},
	{3242, 39288, 5, 4776},
	{3257, 39292, 5, 4776},
	{3272, 39296, 5, 4776},
	{3287, 39300, 5, 4776},
	{3302, 39304, 5, 4776},
	{3317, 39308, 5, 4776},
	{3332, 39312, 4, 445},
	{3351, 39316, 4, 445},
	{3370, 39320, 4, 445},
	{3389, 39324, 4, 445},
	{3408, 39328, 4, 445},
	{3427, 39332, 4, 445},
	{3446, 39336, 4, 445},
	{3465, 39340, 4, 445},
	{3484, 39344, 4, 445},
	{3503, 39348, 4, 445},
	{3522, 39352, 4, 445},
	{3542, 39356, 4, 445},
	{3562, 39360, 4, 445},
	{3582, 39364, 4, 445},
	{3602, 39368, 4, 445},
	{3622, 39372, 4, 445},
	{3867, 45084, 4, 5913},
	{3891, 45088},
	{3912, 45092, 1, 498},
	{3933, 45096, 11, 5917},
	{3957, 45100, 10, 5928},
	{3981, 45104},
	{4007, 45108},
	{4033, 45112},
	{4059, 45116},
	{4085, 45120},
	{4111, 45124},
	{4137, 45128},
	{4163, 45132},
	{4189, 45136},
	{4215, 45140},
	{4241, 45144},
	{4268, 45148},
	{4295, 45152},
	{4322, 45156},
	{4349, 45160},
	{4376, 45164},
	{4403, 45168},
	{4430, 45172},
	{4457, 45176},
	{4484, 45180},
	{4511, 45184},
	{4538, 45188},
	{4565, 45192},
	{4592, 45196},
	{4619, 45200},
	{4646, 45204},
	{4673, 45208},
	{4700, 45212},
	{4727, 45216},
	{4754, 45220},
	{4781, 45224},
	{4808, 45228},
	{5048, 45336, 4, 5913},
	{5072, 45340, 1, 534},
	{5097, 45344},
	{5118, 45348, 1, 498},
	{5139, 45352, 12, 5938},
	{5163, 45356, 14, 5950},
	{5187, 45360},
	{5213, 45364},
	{5239, 45368},
	{5265, 45372},
	{5291, 45376},
	{5317, 45380},
	{5343, 45384},
	{5369, 45388},
	{5395, 45392},
	{5421, 45396},
	{5447, 45400},
	{5474, 45404},
	{5501, 45408},
	{5528, 45412},
	{5555, 45416},
	{5582, 45420},
	{5609, 45424},
	{5636, 45428},
	{5663, 45432},
	{5690, 45436},
	{5717, 45440},
	{5744, 45444},
	{5771, 45448},
	{5798, 45452},
	{5825, 45456},
	{5852, 45460},
	{5879, 45464},
	{5906, 45468},
	{5933, 45472},
	{5960, 45476},
	{5987, 45480},
	{6014, 45484},
	{6205, 45552, 9, 561},
	{6311, 45572, 2, 5964},
	{6335, 45576},
	{6367, 45580},
	{7642, 45584},
	{7663, 45588, 1, 498},
	{6447, 45596, 4, 5913},
	{6471, 45600},
	{6492, 45604, 1, 498},
	{6513, 45608, 12, 5966},
	{6537, 45612, 9, 5978},
	{7732, 45872},
	{7758, 45876},
	{7784, 45880},
	{7810, 45884},
	{7836, 45888},
	{7862, 45892},
	{7888, 45896},
	{7914, 45900},
	{7940, 45904},
	{7966, 45908},
	{7992, 45912},
	{8019, 45916},
	{8046, 45920},
	{8073, 45924},
	{8100, 45928},
	{8127, 45932},
	{56982, 45936},
	{57009, 45940},
	{57036, 45944},
	{57063, 45948},
	{57090, 45952},
	{57117, 45956},
	{57144, 45960},
	{57171, 45964},
	{57198, 45968},
	{57225, 45972},
	{57252, 45976},
	{57279, 45980},
	{57306, 45984},
	{57333, 45988},
	{57360, 45992},
	{57387, 45996},
	{8206, 46084, 1, 5964},
	{8230, 46088},
	{8262, 46092},
	{9537, 46096},
	{9558, 46100, 1, 498},
	{8342, 46108, 4, 5987},
	{8366, 46112},
	{8387, 46116, 1, 498},
	{8408, 46120, 11, 5991},
	{8432, 46124, 7, 6002},
	{9627, 46128},
	{9653, 46132},
	{9679, 46136},
	{9705, 46140},
	{9731, 46144},
	{9757, 46148},
	{9783, 46152},
	{9809, 46156},
	{9835, 46160},
	{9861, 46164},
	{9887, 46168},
	{9914, 46172},
	{9941, 46176},
	{9968, 46180},
	{9995, 46184},
	{10022, 46188},
	{57414, 46192},
	{57441, 46196},
	{57468, 46200},
	{57495, 46204},
	{57522, 46208},
	{57549, 46212},
	{57576, 46216},
	{57603, 46220},
	{57630, 46224},
	{57657, 46228},
	{57684, 46232},
	{57711, 46236},
	{57738, 46240},
	{57765, 46244},
	{57792, 46248},
	{57819, 46252},
	{57846, 46384},
	{57876, 46388},
	{57906, 46392},
	{57936, 46396},
	{57966, 46400},
	{57996, 46404},
	{58026, 46408},
	{58056, 46412},
	{58086, 46416},
	{58116, 46420},
	{58146, 46424},
	{58177, 46428},
	{58208, 46432},
	{58239, 46436},
	{58270, 46440},
	{58301, 46444},
	{58332, 46448},
	{58363, 46452},
	{58394, 46456},
	{58425, 46460},
	{58456, 46464},
	{58487, 46468},
	{58518, 46472},
	{58549, 46476},
	{58580, 46480},
	{58611, 46484},
	{58642, 46488},
	{58673, 46492},
	{58704, 46496},
	{58735, 46500},
	{58766, 46504},
	{58797, 46508},
	{10049, 47104, 11, 6009},
	{10076, 47108},
	{10090, 47112},
	{10104, 47116},
	{10118, 47120},
	{10134, 47124},
	{10150, 47128},
	{10166, 47132, 2, 666},
	{10187, 47136, 2, 666},
	{10208, 47140, 2, 666},
	{10229, 47144, 1, 668},
	{10257, 47148, 1, 669},
	{10282, 47152},
	{10297, 47156, 1, 670},
	{10312, 47160},
	{10341, 47164, 1, 670},
	{10370, 47168},
	{10403, 47172, 1, 670},
	{10436, 47176, 11, 6020},
	{10454, 47180, 12, 6031},
	{10472, 47184, 1, 694},
	{10485, 47188, 7, 6043},
	{54675, 47192, 2, 4905},
	{54706, 47196, 2, 4905},
	{10563, 47200, 2, 701},
	{54889, 47204, 2, 4905},
	{54920, 47208, 2, 4905},
	{10638, 47212},
	{10656, 47216},
	{10674, 47220},
	{10692, 47224, 1, 703},
	{10720, 47228, 5, 704},
	{10742, 47232},
	{10762, 47236},
	{10945, 47240, 3, 720},
	{10962, 47244},
	{10991, 47248, 1, 723},
	{10923, 47252},
	{47383, 47252},
	{47414, 47256},
	{47445, 47260},
	{47476, 47264},
	{11038, 47360},
	{11058, 47364},
	{11078, 47368},
	{11098, 47372},
	{11118, 47376},
	{11138, 47380},
	{11158, 47384},
	{11178, 47388},
	{11198, 47392},
	{11218, 47396},
	{11238, 47400},
	{11259, 47404},
	{11280, 47408},
	{11301, 47412},
	{11322, 47416},
	{11343, 47420},
	{11388, 47608},
	{11409, 47612},
	{11425, 163840, 10, 726},
	{11443, 163844, 9, 4936},
	{11460, 163848, 5, 6050},
	{11474, 163852, 23, 754},
	{11493, 163856, 16, 777},
	{11513, 163860},
	{11925, 163864, 1, 837},
	{54785, 163868, 2, 793},
	{11549, 163872},
	{11569, 163876},
	{11589, 163880, 1, 795},
	{11606, 163884},
	{11621, 163888, 2, 796},
	{11645, 163892, 2, 798},
	{11703, 163896, 13, 6055},
	{11713, 163900, 8, 6068},
	{11729, 163904},
	{11839, 163908, 1, 837},
	{11744, 163912},
	{11857, 163916, 1, 837},
	{11765, 163920},
	{11881, 163924, 1, 837},
	{11781, 163928},
	{11900, 163932, 1, 837},
	{11669, 163936, 3, 800},
	{58828, 163944, 1, 6076},
	{58839, 163948, 1, 6076},
	{11971, 163968},
	{11987, 163972, 1, 847},
	{12006, 164328, 1, 848},
	{12027, 164332, 1, 848},
	{12048, 164336, 1, 848},
	{12069, 164340, 1, 848},
	{12090, 164344},
	{12108, 164348},
	{12126, 164352, 2, 849},
	{12146, 164356, 3, 851},
	{12170, 164360, 2, 854},
	{12194, 164364, 1, 856},
	{12214, 164368, 2, 851},
	{12234, 164372, 2, 854},
	{12254, 164376, 2, 851},
	{12274, 164380, 2, 854},
	{12294, 164384, 2, 851},
	{12314, 164388, 2, 854},
	{12334, 164392, 2, 851},
	{12354, 164396, 2, 854},
	{12374, 164400, 7, 857},
	{12389, 164404, 2, 864},
	{12418, 164408, 8, 866},
	{12433, 164412, 8, 874},
	{12448, 164416, 3, 851},
	{12473, 164420, 2, 854},
	{12498, 164424},
	{12516, 164428},
	{12534, 164432, 3, 851},
	{12559, 164436, 2, 854},
	{12584, 164440, 3, 851},
	{12609, 164444, 2, 854},
	{12634, 164448, 3, 851},
	{12659, 164452, 2, 854},
	{12684, 164456, 3, 851},
	{12709, 164460, 2, 854},
	{12734, 164464, 3, 851},
	{12759, 164468, 2, 854},
	{12784, 164472, 3, 851},
	{12809, 164476, 2, 854},
	{12834, 164480, 3, 851},
	{12859, 164484, 2, 854},
	{12884, 164488, 3, 851},
	{12909, 164492, 2, 854},
	{12934, 164496, 3, 851},
	{12959, 164500, 2, 854},
	{12984, 164504, 3, 851},
	{13009, 164508, 2, 854},
	{13034, 164512, 3, 851},
	{13060, 164516, 2, 854},
	{13086, 164520, 3, 851},
	{13112, 164524, 2, 854},
	{13138, 164528, 3, 851},
	{13164, 164532, 2, 854},
	{13190, 164536, 3, 851},
	{13216, 164540, 2, 854},
	{13242, 164544, 3, 851},
	{13268, 164548, 2, 854},
	{13294, 164552, 3, 851},
	{13320, 164556, 2, 854},
	{13346, 164560},
	{13365, 164564},
	{13384, 164568},
	{13403, 164572},
	{13422, 164576},
	{13441, 164580},
	{13460, 164584},
	{13479, 164588},
	{13498, 164592},
	{13517, 164596},
	{13536, 164600},
	{13555, 164604},
	{13574, 164608},
	{13593, 164612},
	{13612, 164616},
	{13631, 164620},
	{13650, 164624},
	{13669, 164628},
	{13688, 164632},
	{13707, 164636},
	{13726, 164640},
	{13746, 164644},
	{13766, 164648},
	{13786, 164652},
	{13806, 164656},
	{13826, 164660},
	{13846, 164664},
	{13866, 164668},
	{13886, 164672},
	{13906, 164676},
	{13926, 164680},
	{13946, 164684},
	{13966, 164688, 15, 6077},
	{13986, 164692, 3, 6092},
	{14008, 164696, 2, 900},
	{14036, 164700, 3, 902},
	{14065, 164704, 1, 909},
	{14086, 164708, 1, 910},
	{14096, 164712, 1, 911},
	{14104, 164768, 4, 912},
	{14126, 164772, 4, 912},
	{14147, 164776, 4, 916},
	{14214, 164876},
	{14268, 164884},
	{14281, 164888},
	{14296, 164892},
	{14310, 164896},
	{14325, 164900, 9, 6095},
	{14364, 164908, 6, 942},
	{14383, 164912, 4, 948},
	{14401, 164916, 4, 952},
	{14422, 164924},
	{14441, 164928},
	{14461, 164932},
	{14480, 164936},
	{14500, 164940},
	{14519, 164944},
	{14539, 164948},
	{14560, 164952},
	{14582, 164956},
	{14603, 164960},
	{14625, 164964},
	{14646, 164968},
	{14668, 164972},
	{14689, 164976},
	{14711, 164980},
	{14732, 164984},
	{14754, 164988},
	{14775, 164992},
	{14797, 164996},
	{14818, 165000},
	{14840, 165004},
	{14861, 165008},
	{14883, 165012},
	{14904, 165016},
	{14926, 165020},
	{14947, 165024},
	{14969, 165028},
	{14990, 165032},
	{15012, 165036},
	{15033, 165040},
	{15055, 165044},
	{15076, 165048},
	{15098, 165052},
	{15119, 165056},
	{15141, 165060},
	{15162, 165064},
	{15184, 165068},
	{15205, 165072},
	{15227, 165076},
	{15248, 165080},
	{15270, 165084},
	{15291, 165088},
	{15313, 165092},
	{15334, 165096},
	{15356, 165100},
	{15377, 165104},
	{15399, 165108},
	{15420, 165112},
	{15442, 165116},
	{15463, 165120},
	{15485, 165124},
	{15506, 165128},
	{15528, 165132},
	{15549, 165136},
	{15571, 165140},
	{15592, 165144},
	{15614, 165148},
	{15635, 165152},
	{15657, 165156},
	{15678, 165160},
	{15700, 165164},
	{15722, 165168},
	{15745, 165172},
	{15767, 165176},
	{15790, 165180},
	{15812, 165184},
	{15835, 165188},
	{15857, 165192},
	{15880, 165196},
	{15902, 165200},
	{15925, 165204},
	{15947, 165208},
	{15970, 165212},
	{15992, 165216},
	{16015, 165220},
	{16037, 165224},
	{16060, 165228},
	{16082, 165232},
	{16105, 165236},
	{16127, 165240},
	{16150, 165244},
	{16172, 165248},
	{16195, 165252},
	{16217, 165256},
	{16240, 165260},
	{16262, 165264},
	{16285, 165268},
	{16307, 165272},
	{16330, 165276},
	{16352, 165280},
	{16375, 165284},
	{16397, 165288},
	{16420, 165292},
	{16442, 165296},
	{16465, 165300},
	{16487, 165304},
	{16510, 165308},
	{16524, 165312},
	{16538, 165316},
	{16552, 165320},
	{16566, 165324},
	{16580, 165328},
	{16594, 165332},
	{16608, 165336},
	{16622, 165340},
	{16636, 165344},
	{16650, 165348},
	{16664, 165352},
	{16678, 165356},
	{16692, 165360},
	{16706, 165364},
	{16720, 165368},
	{16734, 165372},
	{16748, 165376},
	{16762, 165380},
	{16776, 165384},
	{16790, 165388},
	{16804, 165392},
	{16818, 165396},
	{16832, 165400},
	{16846, 165404},
	{16869, 165444, 12, 956},
	{16889, 165448, 12, 956},
	{16909, 165452, 12, 956},
	{16929, 165456, 12, 956},
	{16949, 165460, 12, 956},
	{16969, 165464, 12, 956},
	{16989, 165468, 12, 956},
	{17009, 165472, 12, 956},
	{17029, 165476, 12, 956},
	{17049, 165480, 12, 956},
	{17069, 165484, 12, 956},
	{17090, 165488, 12, 956},
	{17111, 165492, 12, 956},
	{17132, 165496, 12, 956},
	{17153, 165500, 12, 956},
	{17174, 165504, 12, 956},
	{17195, 165508, 12, 956},
	{17216, 165512, 12, 956},
	{17237, 165516, 12, 956},
	{17258, 165520, 12, 956},
	{17279, 165524, 9, 968},
	{17300, 165528, 9, 968},
	{17321, 165532, 9, 968},
	{17342, 165536, 9, 968},
	{17363, 165540, 9, 968},
	{17384, 165544, 9, 968},
	{17405, 165548, 9, 968},
	{17426, 165552, 9, 968},
	{17447, 165556, 9, 968},
	{17468, 165560, 9, 968},
	{17489, 165564, 9, 968},
	{17510, 165568, 9, 968},
	{17531, 165572, 2, 977},
	{17549, 165580, 16, 980},
	{17566, 165584, 16, 980},
	{17584, 165588, 7, 996},
	{17605, 165592, 5, 1003},
	{17623, 165600, 7, 1009},
	{17638, 165608, 2, 701},
	{17677, 165644, 4, 1017},
	{17699, 165648, 1, 1022},
	{17719, 165652, 8, 1023},
	{17741, 165716, 8, 1031},
	{17759, 165720, 8, 1039},
	{17780, 165724, 17, 1047},
	{17801, 165728, 6, 1064},
	{17819, 165732, 6, 1064},
	{17837, 165736, 6, 1064},
	{17855, 165740, 6, 1064},
	{17873, 165744, 6, 1064},
	{17891, 165748, 6, 1064},
	{17909, 165752, 6, 1064},
	{17927, 165756, 6, 1064},
	{17945, 165760, 9, 1070},
	{17963, 165764, 9, 1070},
	{17981, 165768, 9, 1070},
	{17999, 165772, 9, 1070},
	{18017, 165776, 9, 1070},
	{18035, 165780, 9, 1070},
	{18053, 165784, 9, 1070},
	{18071, 165788, 9, 1070},
	{58856, 165792, 1, 6076},
	{58871, 165796, 1, 6076},
	{58886, 165800, 1, 6076},
	{58901, 165804, 1, 6076},
	{58916, 165808, 1, 6076},
	{58931, 165812, 1, 6076},
	{58946, 165816, 1, 6076},
	{58961, 165820, 1, 6076},
	{18089, 165836, 1, 1079},
	{18103, 165840, 1, 1079},
	{18118, 165844},
	{18136, 165848},
	{18154, 165852},
	{18171, 165856},
	{18192, 165860, 1, 1080},
	{18208, 165864},
	{18221, 165872, 8, 1081},
	{18240, 165876},
	{18255, 165880, 1, 1089},
	{18304, 165888, 10, 1091},
	{18321, 165892, 12, 1101},
	{18329, 165896, 4, 5645},
	{18346, 165900, 16, 1117},
	{18364, 165904, 20, 1134},
	{18380, 165908, 15, 1154},
	{18399, 165912, 10, 1170},
	{18414, 165916, 28, 6104},
	{18432, 165920, 16, 1208},
	{18450, 165924, 4, 1224},
	{18474, 165928},
	{18499, 165932, 11, 1228},
	{18522, 165936, 6, 3829},
	{18551, 165940, 3, 6132},
	{18573, 165944, 2, 1248},
	{18588, 165948, 5, 1250},
	{18618, 165952, 6, 6135},
	{18651, 166400, 2, 1260},
	{18668, 166404, 2, 1262},
	{18687, 166408, 1, 1264},
	{18703, 166412, 4, 1265},
	{18722, 166416, 1, 1269},
	{18743, 166420, 1, 1270},
	{18756, 166424},
	{18779, 166428},
	{18802, 166432, 1, 1271},
	{18822, 166436, 4, 1272},
	{18842, 166440, 1, 1276},
	{18863, 166444, 1, 1277},
	{18878, 166448, 6, 1278},
	{18900, 166452, 6, 1278},
	{18922, 166456, 8, 1284},
	{18948, 166460, 8, 1284},
	{18974, 166464, 15, 5515},
	{18986, 166468, 3, 1307},
	{19005, 166472, 7, 1310},
	{19023, 166476, 24, 1317},
	{19041, 166480},
	{19053, 166484, 1, 1341},
	{19067, 166488, 1, 1342},
	{19081, 166492, 1, 1343},
	{19095, 166496, 1, 1344},
	{19118, 166500, 1, 1344},
	{19141, 166504, 1, 1344},
	{19164, 166508, 5, 1345},
	{19185, 166512},
	{19196, 166516},
	{19209, 166520},
	{19226, 166524, 7, 6141},
	{19245, 166528},
	{19256, 166532, 3, 1358},
	{19275, 166536},
	{19297, 166540},
	{19319, 166544, 3, 6148},
	{58976, 166548, 1, 6151},
	{19366, 166552, 4, 6152},
	{19388, 166560},
	{19413, 166564},
	{19457, 166572, 1, 1377},
	{19480, 166576, 1, 1377},
	{19503, 166580, 1, 1378},
	{19517, 166584, 1, 1379},
	{19532, 166588, 8, 6156},
	{19549, 166592, 4, 1389},
	{19576, 166596, 4, 1393},
	{19603, 166600, 4, 1397},
	{19622, 166608},
	{19648, 166612, 1, 1401},
	{19673, 166620},
	{19701, 166624},
	{19727, 166628, 1, 1401},
	{19752, 166636},
	{19780, 166640},
	{19806, 166644, 1, 1401},
	{19831, 166652},
	{19859, 166656},
	{19885, 166660, 1, 1401},
	{19910, 166668},
	{19938, 166696},
	{19969, 166700},
	{20012, 166704, 1, 1402},
	{20050, 166712, 1, 1403},
	{20089, 166736, 5, 1406},
	{20111, 166740, 13, 6164},
	{20132, 166744, 3, 1430},
	{20149, 166748, 1, 1377},
	{20170, 166752, 1, 1377},
	{20193, 166756, 1, 1377},
	{20216, 166760, 1, 1377},
	{20239, 166764, 8, 6177},
	{20252, 166768, 6, 1445},
	{20269, 166772},
	{20293, 166776, 2, 1451},
	{20323, 166780},
	{20347, 166784},
	{20377, 166788},
	{20408, 166792},
	{20437, 166796},
	{20467, 166800, 2, 1453},
	{20487, 166804, 8, 1456},
	{20506, 166808, 4, 1464},
	{20532, 166812, 3, 6148},
	{20556, 166868, 8, 1468},
	{20582, 166872, 8, 1476},
	{20608, 166876, 5, 1484},
	{20624, 166880, 6, 1489},
	{20640, 166884, 3, 1495},
	{20655, 166888},
	{20678, 166892},
	{20701, 166896},
	{20724, 166900},
	{20747, 166904, 8, 1498},
	{20781, 166908, 8, 1506},
	{20815, 166912, 8, 1514},
	{20849, 166916, 8, 1522},
	{20883, 166920, 8, 1498},
	{20917, 166924, 8, 1506},
	{20951, 166928, 8, 1514},
	{20985, 166932, 8, 1522},
	{21019, 166936, 8, 1498},
	{21053, 166940, 8, 1506},
	{21087, 166944, 8, 1514},
	{21121, 166948, 8, 1522},
	{21155, 166952, 8, 1498},
	{21189, 166956, 8, 1506},
	{21223, 166960, 8, 1514},
	{21257, 166964, 8, 1522},
	{21291, 166968, 2, 1530},
	{21315, 166972, 2, 1532},
	{21339, 166976, 3, 1534},
	{21360, 166980, 11, 1538},
	{21380, 166984, 2, 1550},
	{21400, 166988, 18, 1552},
	{21438, 166992, 1, 1572},
	{21458, 167000, 1, 1574},
	{21486, 167004, 1, 1575},
	{21507, 167008},
	{23547, 167012, 1, 1622},
	{24283, 167016, 3, 1623},
	{21554, 167020, 3, 6185},
	{21569, 167024, 16, 6188},
	{21584, 167028, 10, 6204},
	{21601, 167032, 11, 1609},
	{21623, 167036},
	{23699, 167040, 1, 1622},
	{21661, 167044},
	{23899, 167048, 1, 1622},
	{21699, 167052},
	{21721, 167056},
	{21743, 167060},
	{24099, 167064, 1, 1622},
	{21762, 167068},
	{23566, 167072, 1, 1622},
	{24301, 167076, 3, 1623},
	{21809, 167080, 3, 6185},
	{21824, 167084, 16, 6188},
	{21839, 167088, 10, 6204},
	{21856, 167092, 11, 1609},
	{21878, 167096},
	{23724, 167100, 1, 1622},
	{21916, 167104},
	{23924, 167108, 1, 1622},
	{21954, 167112},
	{21976, 167116},
	{21998, 167120},
	{24122, 167124, 1, 1622},
	{22017, 167128},
	{23585, 167132, 1, 1622},
	{24319, 167136, 3, 1623},
	{22064, 167140, 3, 6185},
	{22079, 167144, 16, 6188},
	{22094, 167148, 10, 6204},
	{22111, 167152, 11, 1609},
	{22133, 167156},
	{23749, 167160, 1, 1622},
	{22171, 167164},
	{23949, 167168, 1, 1622},
	{22209, 167172},
	{22231, 167176},
	{22253, 167180},
	{24145, 167184, 1, 1622},
	{22272, 167188},
	{23604, 167192, 1, 1622},
	{24337, 167196, 3, 1623},
	{22319, 167200, 3, 6185},
	{22334, 167204, 16, 6188},
	{22349, 167208, 10, 6204},
	{22366, 167212, 11, 1609},
	{22388, 167216},
	{23774, 167220, 1, 1622},
	{22426, 167224},
	{23974, 167228, 1, 1622},
	{22464, 167232},
	{22486, 167236},
	{22508, 167240},
	{24168, 167244, 1, 1622},
	{22527, 167248},
	{23623, 167252, 1, 1622},
	{24355, 167256, 3, 1623},
	{22574, 167260, 3, 6185},
	{22589, 167264, 16, 6188},
	{22604, 167268, 10, 6204},
	{22621, 167272, 11, 1609},
	{22643, 167276},
	{23799, 167280, 1, 1622},
	{22681, 167284},
	{23999, 167288, 1, 1622},
	{22719, 167292},
	{22741, 167296},
	{22763, 167300},
	{24191, 167304, 1, 1622},
	{22782, 167308},
	{23642, 167312, 1, 1622},
	{24373, 167316, 3, 1623},
	{22829, 167320, 3, 6185},
	{22844, 167324, 16, 6188},
	{22859, 167328, 10, 6204},
	{22876, 167332, 11, 1609},
	{22898, 167336},
	{23824, 167340, 1, 1622},
	{22936, 167344},
	{24024, 167348, 1, 1622},
	{22974, 167352},
	{22996, 167356},
	{23018, 167360},
	{24214, 167364, 1, 1622},
	{23037, 167368},
	{23661, 167372, 1, 1622},
	{24391, 167376, 3, 1623},
	{23084, 167380, 3, 6185},
	{23099, 167384, 16, 6188},
	{23114, 167388, 10, 6204},
	{23131, 167392, 11, 1609},
	{23153, 167396},
	{23849, 167400, 1, 1622},
	{23191, 167404},
	{24049, 167408, 1, 1622},
	{23229, 167412},
	{23251, 167416},
	{23273, 167420},
	{24237, 167424, 1, 1622},
	{23292, 167428},
	{23680, 167432, 1, 1622},
	{24409, 167436, 3, 1623},
	{23339, 167440, 3, 6185},
	{23354, 167444, 16, 6188},
	{23369, 167448, 10, 6204},
	{23386, 167452, 11, 1609},
	{23408, 167456},
	{23874, 167460, 1, 1622},
	{23446, 167464},
	{24074, 167468, 1, 1622},
	{23484, 167472},
	{23506, 167476},
	{23528, 167480},
	{24260, 167484, 1, 1622},
	{24571, 196608, 1, 1634},
	{24591, 196612, 1, 1635},
	{24611, 196616},
	{24631, 196620},
	{24651, 196624},
	{24672, 196628},
	{24693, 196632, 1, 1636},
	{24715, 196636, 1, 1637},
	{24737, 196640},
	{24767, 196644},
	{24797, 196648},
	{24826, 196652},
	{24855, 196656},
	{24885, 196660},
	{24915, 196664},
	{24944, 196668},
	{24973, 196672},
	{25003, 196676},
	{25033, 196680},
	{25062, 196684},
	{25091, 196688},
	{25121, 196692},
	{25151, 196696},
	{25180, 196700},
	{25209, 196704, 1, 1638},
	{25231, 196708, 1, 1639},
	{25253, 196712},
	{25276, 196716},
	{25299, 196720},
	{25322, 196724},
	{25345, 196728},
	{25368, 196732},
	{25391, 196736},
	{25415, 196740},
	{25439, 196744},
	{25463, 196748},
	{25487, 196752},
	{25511, 196756},
	{25535, 196760},
	{25559, 196764},
	{25583, 196768},
	{25605, 196772},
	{25627, 196776},
	{25648, 196780},
	{25669, 196784},
	{25693, 196788},
	{25717, 196792},
	{25741, 196796},
	{25765, 196800},
	{25789, 196804},
	{25873, 196852, 1, 5587},
	{25895, 196856, 1, 5587},
	{25917, 196860, 1, 1642},
	{25933, 196864},
	{25946, 196868},
	{25959, 196872},
	{25972, 196876},
	{25985, 196880},
	{25998, 196884},
	{26011, 196888},
	{26024, 196892},
	{26079, 196912},
	{26097, 196916},
	{26124, 196920},
	{26151, 196928, 2, 1643},
	{26164, 196932},
	{26177, 196936},
	{26200, 196940},
	{26223, 196944},
	{26251, 196948},
	{26279, 196952},
	{26307, 196956},
	{26335, 196960, 1, 1645},
	{26353, 196964, 4, 6214},
	{59006, 196968},
	{59024, 196972},
	{59051, 196976},
	{26434, 196980},
	{26453, 196984},
	{26472, 196988},
	{26496, 196992},
	{26520, 196996},
	{26544, 197000},
	{26568, 197028, 1, 1650},
	{26586, 197032, 2, 6218},
	{26604, 197036},
	{26622, 197040},
	{26640, 197044, 1, 1653},
	{26658, 197048, 2, 6220},
	{26676, 197052},
	{26694, 197056, 2, 1656},
	{26713, 197060, 5, 1658},
	{26732, 197072},
	{26756, 197076, 2, 1656},
	{26776, 197080, 5, 1658},
	{26796, 197084, 5, 6222},
	{26815, 197088, 5, 6222},
	{26833, 197092, 1, 1670},
	{26850, 197100, 1, 1671},
	{26871, 197104, 13, 1672},
	{26885, 197108},
	{26899, 197112},
	{26913, 197116, 2, 1685},
	{26929, 197120},
	{26948, 197124, 1, 1687},
	{26970, 197128},
	{26989, 197132, 1, 1688},
	{27011, 197136, 7, 1689},
	{27029, 197140},
	{27049, 197144, 1, 1687},
	{27072, 197148},
	{27092, 197152, 1, 1688},
	{27115, 197156, 7, 1689},
	{27134, 197160, 6, 6227},
	{27146, 197164, 2, 1703},
	{27163, 197168, 1, 1705},
	{27180, 197172, 1, 1706},
	{27198, 197176, 4, 1707},
	{27218, 197180, 1, 1711},
	{27235, 197184},
	{27251, 197188, 1, 1713},
	{27264, 197192, 1, 1714},
	{27278, 197196, 1, 1715},
	{27292, 197200, 1, 1716},
	{27314, 197204, 1, 1717},
	{27334, 197208, 1, 1718},
	{27356, 197212, 1, 1719},
	{27376, 197216, 1, 1714},
	{27393, 197220, 1, 1715},
	{27410, 197224},
	{56966, 197228, 1, 1713},
	{27558, 197364, 1, 1724},
	{27579, 197368, 1, 1725},
	{27599, 197372, 1, 1726},
	{27619, 197376, 1, 1725},
	{27636, 197380, 1, 1726},
	{27653, 197384, 1, 1727},
	{27669, 197388, 1, 1728},
	{27688, 197392, 1, 1729},
	{27707, 197396, 1, 1730},
	{27724, 197400, 1, 1731},
	{27742, 197404, 1, 1732},
	{27760, 197408, 1, 1733},
	{27776, 197412, 1, 1734},
	{27794, 197416, 1, 1735},
	{27812, 197420, 1, 1736},
	{27828, 197424, 1, 1731},
	{27843, 197428, 1, 1732},
	{27858, 197432, 1, 1733},
	{27871, 197436, 1, 1734},
	{27886, 197440, 1, 1735},
	{27901, 197444, 1, 1736},
	{27914, 197448, 1, 1737},
	{27928, 197452, 1, 1738},
	{27942, 197456, 1, 1739},
	{27954, 197460, 4, 6233},
	{27977, 197464, 3, 1744},
	{27999, 197468, 1, 1747},
	{28143, 197552, 1, 1752},
	{28168, 197556, 1, 1752},
	{28192, 197560, 1, 1753},
	{28212, 197568},
	{28238, 197572, 1, 1635},
	{28267, 197576},
	{28292, 197580, 1, 1635},
	{28320, 197584},
	{28343, 197588, 1, 1635},
	{28369, 197592},
	{28391, 197596, 1, 1635},
	{28416, 197600},
	{28435, 197604, 1, 1635},
	{28457, 197608, 1, 1350},
	{28471, 197612},
	{28488, 197616, 1, 1635},
	{28508, 197620, 8, 1754},
	{28525, 197624, 13, 1762},
	{28542, 197628},
	{28559, 197632, 1, 1705},
	{28579, 197636},
	{28596, 197640, 1, 1670},
	{28616, 197644, 2, 1775},
	{28635, 197888, 8, 6237},
	{28656, 197892, 8, 6237},
	{28677, 198656, 6, 4077},
	{28711, 198916},
	{28730, 198920, 1, 1791},
	{28749, 198924, 2, 6245},
	{28764, 198928},
	{28797, 198932},
	{28830, 198936},
	{28863, 198940},
	{14164, 198944},
	{14181, 198948},
	{14198, 198952},
	{19339, 198956, 2, 1364},
	{28953, 198960},
	{28969, 198964},
	{28987, 198968, 1, 1792},
	{29004, 198972, 2, 1793},
	{29025, 198976},
	{29319, 198980, 1, 837},
	{29063, 198984},
	{29079, 198988, 1, 837},
	{29098, 198992},
	{29118, 198996, 1, 837},
	{29141, 199000},
	{29159, 199004, 1, 837},
	{19438, 199008, 9, 1795},
	{29221, 199016},
	{29357, 199168, 1, 1816},
	{29382, 199172, 2, 1817},
	{29407, 199184, 2, 1819},
	{29433, 199188, 2, 1819},
	{29459, 199192, 2, 1819},
	{29485, 199212, 2, 1819},
	{29511, 199296, 2, 1821},
	{29539, 199300, 1, 1823},
	{29563, 199304, 1, 1824},
	{29587, 199308, 1, 1825},
	{29620, 199312, 1, 1825},
	{29648, 199328, 2, 1821},
	{29677, 199332, 1, 1823},
	{29702, 199336, 1, 1824},
	{29727, 199340, 1, 1825},
	{29761, 199344, 1, 1825},
	{29790, 199360, 2, 1821},
	{29814, 199364, 1, 1823},
	{29834, 199368, 1, 1824},
	{29854, 199372, 1, 1825},
	{29883, 199376, 1, 1825},
	{18633, 199380},
	{53768, 199872},
	{53789, 199876, 1, 4637},
	{2431, 199880, 7, 5191},
	{2452, 199884, 3, 4646},
	{53810, 199888, 2, 4649},
	{2479, 199892, 1, 4673},
	{53836, 199896, 15, 6247},
	{54839, 199900, 1, 5200},
	{54861, 199904},
	{2410, 199908, 2, 4651},
	{2500, 199912, 6, 6262},
	{53878, 199916, 1, 4674},
	{53857, 199920},
	{29907, 199936},
	{29934, 199940},
	{29961, 199944},
	{29988, 199948},
	{30123, 199968, 6, 1826},
	{30134, 199972, 2, 1833},
	{30148, 200192},
	{30167, 200196, 1, 847},
	{30189, 200448},
	{30213, 200452, 1, 1835},
	{30236, 200456},
	{30260, 200460, 1, 1835},
	{30283, 200464},
	{30307, 200468, 1, 1835},
	{30330, 200472},
	{30354, 200476, 1, 1835},
	{30377, 200696},
	{30396, 200700, 1, 1835},
	{30414, 200704},
	{30426, 200708},
	{30438, 200712},
	{30456, 200716},
	{30475, 200720},
	{30493, 200724},
	{30505, 200728},
	{30517, 200732},
	{30535, 200736},
	{30553, 200740},
	{30572, 200744, 4, 1836},
	{30586, 200748, 2, 1840},
	{30604, 200752, 2, 1842},
	{30618, 200756, 2, 1844},
	{30632, 200760, 2, 1846},
	{30649, 200764, 2, 1848},
	{30666, 200768},
	{30679, 200772, 2, 1850},
	{30691, 200776},
	{30705, 200780},
	{30721, 200784},
	{30735, 200788},
	{30751, 200792},
	{30766, 200796},
	{30783, 200800},
	{30798, 200804},
	{30815, 200808, 2, 1852},
	{30837, 200812, 10, 6268},
	{30854, 200816, 2, 1864},
	{30875, 200820, 2, 1866},
	{30887, 200824},
	{30902, 200828, 6, 5634},
	{30917, 200832, 2, 1874},
	{30931, 200836},
	{2831, 200960, 9, 426},
	{48857, 200964, 11, 6278},
	{48875, 200968, 2, 3505},
	{48893, 200972, 4, 6289},
	{31044, 212992},
	{31064, 212996},
	{31084, 213000},
	{31104, 213004},
	{31124, 213008},
	{31144, 213012},
	{31164, 213016},
	{31184, 213020},
	{31204, 213024},
	{31224, 213028},
	{31244, 213032},
	{31264, 213036},
	{31284, 213040},
	{31307, 213044},
	{31330, 213048},
	{31353, 213248},
	{31374, 213252},
	{31395, 213260},
	{31416, 213264},
	{31437, 213268},
	{31461, 213272},
	{31485, 213276},
	{31509, 213280},
	{31533, 213284},
	{31557, 213288},
	{31581, 213292},
	{31605, 213296},
	{54951, 213504},
	{54970, 213508},
	{54989, 213512},
	{55008, 213516},
	{55027, 213520},
	{55046, 213524},
	{55065, 213528},
	{55084, 213532},
	{52441, 213536},
	{52460, 213540},
	{52479, 213544},
	{52498, 213548},
	{52517, 213552},
	{52536, 213556},
	{52555, 213560},
	{52574, 213564},
	{52994, 213568},
	{53014, 213572},
	{53034, 213576},
	{53054, 213580},
	{53074, 213584},
	{53094, 213588},
	{53114, 213592},
	{53134, 213596},
	{32089, 214016},
	{32111, 214020, 1, 1876},
	{32133, 214024},
	{32155, 214028, 1, 1876},
	{32177, 214032},
	{32199, 214036, 1, 1876},
	{32221, 214040},
	{32243, 214044, 1, 1876},
	{32265, 214272},
	{32287, 214276},
	{32309, 214280},
	{32331, 214284},
	{32353, 214288},
	{32375, 214292},
	{32397, 214296},
	{32419, 214300},
	{32441, 214304},
	{32463, 214308},
	{32485, 214312},
	{32507, 214316},
	{32529, 214320},
	{32551, 214324},
	{32573, 214328},
	{32595, 214332},
	{32617, 214528},
	{32637, 214532},
	{32657, 214536},
	{32677, 214540},
	{32697, 214544},
	{32717, 214548},
	{32737, 214552},
	{32757, 214556},
	{32777, 214560},
	{32797, 214564},
	{32817, 214568},
	{32837, 214572},
	{32857, 214784},
	{32876, 214788},
	{32895, 214792},
	{32914, 214796},
	{32933, 214800},
	{32952, 214804},
	{32971, 214808},
	{32990, 214812},
	{33009, 214816},
	{33028, 214820},
	{33047, 214824},
	{33066, 214828},
	{33085, 214832},
	{33104, 214836},
	{33123, 214840},
	{33142, 214844},
	{33161, 214848},
	{33180, 214852},
	{33199, 214856},
	{33218, 214860},
	{33237, 214864},
	{33257, 214868},
	{33277, 214872},
	{33297, 214876},
	{33317, 214880},
	{33337, 214884},
	{33357, 214888},
	{33377, 214892},
	{33397, 214896},
	{33417, 214900},
	{33437, 214904},
	{33457, 214908},
	{33477, 215296},
	{33496, 215300},
	{33515, 215304},
	{33534, 215308},
	{33553, 215312},
	{33572, 215316},
	{33591, 215320},
	{33610, 215324},
	{33671, 215552},
	{33691, 215556},
	{33711, 215560},
	{33731, 215564},
	{33751, 215568},
	{33771, 215572},
	{33791, 215576},
	{33811, 215580},
	{33831, 215808},
	{33850, 215812},
	{33869, 215816},
	{33888, 215820},
	{33907, 216064},
	{33926, 216068},
	{33945, 216072},
	{33964, 216076},
	{33983, 216320},
	{34003, 216324},
	{34023, 216328},
	{34043, 216332},
	{34063, 216336},
	{34083, 216340},
	{34103, 216344},
	{34123, 216348},
	{55103, 216576},
	{55123, 216580},
	{55143, 216584},
	{55163, 216588},
	{55183, 216592},
	{55203, 216596},
	{55223, 216600},
	{55243, 216604},
	{55263, 216640},
	{55283, 216644},
	{55303, 216648},
	{55323, 216652},
	{55343, 216656},
	{55363, 216660},
	{55383, 216664},
	{55403, 216668},
	{34975, 217112},
	{34994, 217116},
	{35013, 217120},
	{35032, 217124},
	{35051, 217128},
	{35070, 217132},
	{35089, 217136},
	{35108, 217140},
	{35127, 217344},
	{35146, 217348},
	{35165, 217352},
	{35184, 217356},
	{35203, 217360},
	{35222, 217364},
	{35241, 217368},
	{35260, 217372},
	{35279, 217600},
	{35299, 217604},
	{35319, 217608},
	{35339, 217612},
	{35359, 217856},
	{35379, 217860},
	{35399, 217864},
	{35419, 217868},
	{35439, 217872},
	{35459, 217876},
	{35479, 217880},
	{35499, 217884},
	{35522, 218112},
	{35547, 218116, 2, 1877},
	{35571, 218144},
	{35597, 218148, 2, 1877},
	{36661, 221184, 5, 6293},
	{36685, 221188, 4, 6298},
	{36710, 221192, 5, 6293},
	{36734, 221196, 5, 6293},
	{36758, 221200, 4, 6298},
	{36783, 221204, 5, 6293},
	{36807, 221208, 4, 6298},
	{36832, 221212, 5, 6293},
	{36856, 221216, 4, 1888},
	{36872, 221220, 5, 6293},
	{36896, 221224, 3, 1892},
	{36930, 221228, 3, 1895},
	{36964, 221232, 3, 1898},
	{36989, 221236, 3, 1901},
	{37014, 221240, 3, 6302},
	{37039, 221248},
	{37054, 221252, 1, 1825},
	{37077, 221256},
	{37100, 221260},
	{37118, 221264, 2, 1904},
	{37136, 221268, 4, 1906},
	{37156, 221440, 22, 6305},
	{37181, 221444, 22, 6305},
	{37206, 221448, 13, 6327},
	{37234, 221452, 13, 6327},
	{37262, 221456, 13, 6327},
	{37290, 221460, 13, 6327},
	{55583, 221696, 2, 4418},
	{55606, 221700, 2, 4418},
	{55629, 221704, 2, 4418},
	{55652, 221708, 2, 4418},
	{52349, 221712, 5, 1964},
	{52372, 221716, 2, 4418},
	{52395, 221720, 2, 4418},
	{52418, 221724, 2, 4418},
	{55675, 221728, 4, 1969},
	{52898, 221744, 5, 1964},
	{52922, 221748, 5, 1964},
	{52946, 221752, 2, 4418},
	{52970, 221756, 2, 4418},
	{55699, 221760, 4, 1969},
	{55724, 221764, 4, 1969},
	{52872, 221776, 1, 4459},
	{37748, 222208, 5, 1964},
	{37774, 222212, 4, 1969},
	{37801, 222216, 5, 1964},
	{37827, 222220, 4, 1969},
	{37854, 222224, 3, 2020},
	{37907, 222228, 3, 2020},
	{37960, 222464, 5, 1964},
	{37986, 222468, 4, 1969},
	{38013, 222472, 1, 1879},
	{38039, 222476, 1, 1879},
	{38065, 222480, 1, 1879},
	{38091, 222484, 1, 1879},
	{38117, 222488, 1, 1879},
	{38143, 222492, 1, 1879},
	{38169, 222496, 1, 1879},
	{38195, 222720, 5, 1964},
	{38219, 222724, 5, 1964},
	{38243, 222728, 5, 1964},
	{38267, 222732, 5, 1964},
	{38291, 222736, 4, 1969},
	{38316, 222740, 4, 1969},
	{38341, 222744, 4, 1969},
	{38366, 222748, 4, 1969},
	{38391, 222752, 1, 2008},
	{38415, 222756, 1, 2008},
	{38439, 222760, 8, 1973},
	{38460, 222976, 6, 4617},
	{38483, 222980, 6, 4617},
	{38506, 222984, 6, 4617},
	{38529, 222988, 6, 4617},
	{38552, 222992, 6, 4617},
	{38575, 222996, 6, 4617},
	{38598, 223000, 6, 4617},
	{38621, 223004, 6, 4617},
	{38644, 223008, 6, 4617},
	{38667, 223012, 6, 4617},
	{38690, 223016, 6, 4617},
	{38714, 223020, 6, 4617},
	{38738, 223024, 6, 4617},
	{38762, 223028, 6, 4617},
	{38786, 223032, 6, 4617},
	{38810, 223036, 6, 4617},
	{38834, 223104, 9, 4600},
	{55749, 223108, 2, 4649},
	{38854, 223112, 1, 1994},
	{38949, 223488, 5, 1964},
	{38972, 223492, 5, 1964},
	{38995, 223496, 3, 2020},
	{39018, 223500, 3, 2020},
	{39041, 223504, 4, 1969},
	{39065, 223508, 4, 1969},
	{39089, 223744, 5, 1964},
	{39113, 223748, 5, 1964},
	{39137, 223752, 5, 1964},
	{39161, 223756, 5, 1964},
	{39185, 223760, 4, 1969},
	{39210, 224000, 5, 2008},
	{39233, 224004, 4, 2013},
	{39257, 224008, 3, 2017},
	{39280, 224256, 5, 2008},
	{39303, 224260, 4, 2013},
	{39327, 224264, 3, 2017},
	{39350, 224512, 5, 1964},
	{39374, 224516, 4, 1969},
	{39399, 224520, 5, 1964},
	{39423, 224524, 4, 1969},
	{39448, 224528, 3, 2020},
	{39472, 224532, 3, 2020},
	{55769, 224768, 5, 1964},
	{55793, 224772, 4, 1958},
	{55818, 224776, 5, 1964},
	{55842, 224780, 4, 1958},
	{55867, 224784, 3, 2020},
	{55891, 224788, 3, 2020},
	{55915, 224832, 5, 1964},
	{55939, 224836, 4, 1958},
	{55964, 224840, 5, 1964},
	{55988, 224844, 4, 1958},
	{56013, 224848, 3, 2020},
	{56037, 224852, 3, 2020},
	{40173, 225280, 12, 2023},
	{40195, 225284, 5, 2035},
	{40218, 225288, 4, 2040},
	{40242, 225292, 2, 2044},
	{40265, 225296, 2, 2044},
	{40288, 225300, 2, 2044},
	{40311, 225536, 5, 1964},
	{40334, 225540, 4, 1969},
	{40358, 225544, 5, 1964},
	{40381, 225548, 4, 1969},
	{40405, 225552, 5, 1964},
	{40428, 225560, 5, 1964},
	{40451, 225792, 4, 2046},
	{40472, 225796},
	{40501, 225800, 2, 2050},
	{40530, 225804},
	{40556, 225808, 7, 2052},
	{40630, 225812},
	{40653, 225816},
	{56182, 225820, 2, 5251},
	{56215, 225824, 2, 5251},
	{56248, 225828, 2, 5251},
	{56281, 225832, 2, 5251},
	{56313, 225836, 2, 5251},
	{56345, 225840, 2, 5251},
	{56377, 225844, 2, 5251},
	{56410, 225848, 2, 5251},
	{56442, 225856, 2, 5251},
	{56474, 225860, 2, 5251},
	{56507, 225864, 2, 5251},
	{56540, 225868, 2, 5251},
	{56573, 225872, 2, 5251},
	{56605, 225876, 2, 5251},
	{56637, 225880, 2, 5251},
	{56670, 225884, 2, 5251},
	{56703, 225888, 2, 5251},
	{56769, 225896, 2, 5251},
	{40676, 225900},
	{40703, 225904},
	{40585, 225908},
	{40604, 225912},
	{59078, 225932, 2, 5251},
	{59111, 225936, 2, 6340},
	{41594, 226040, 1, 2136},
	{41573, 226044, 1, 2136},
	{41366, 226048, 2, 2126},
	{41383, 226052, 1, 2128},
	{41407, 226056, 1, 2128},
	{41431, 226060, 4, 2129},
	{41457, 226064, 3, 2133},
	{41486, 226068, 1, 694},
	{41515, 226072, 3, 2133},
	{41544, 226076, 1, 694},
	{41621, 226304, 5, 2035},
	{41645, 226308, 4, 2040},
	{41670, 226312, 2, 2044},
	{41694, 226316, 5, 2035},
	{41718, 226320, 4, 2040},
	{41743, 226324, 2, 2044},
	{41767, 226328, 10, 2137},
	{41792, 226560, 5, 2147},
	{41819, 226564, 5, 2147},
	{41846, 226568, 6, 2152},
	{41877, 226608, 5, 2147},
	{41905, 226612, 5, 2147},
	{41933, 226616, 5, 2147},
	{41961, 226620, 5, 2147},
	{41989, 226624, 5, 2147},
	{42017, 226628, 5, 2147},
	{42045, 226632, 5, 2147},
	{42073, 226636, 5, 2147},
	{42101, 226640, 6, 2152},
	{206, 880, 4, 2163},
	{43152, 881},
	{26999, 882},
	{43164, 1008},
	{43175, 1009},
	{27187, 1010, 4, 2167},
	{43186, 1040, 1, 2171},
	{43199, 1041, 5, 2172},
	{43212, 1042, 1, 2177},
	{43225, 1043, 1, 1688},
	{27021, 1045, 7, 2178},
	{43253, 1281, 6, 2197},
	{43268, 1282},
	{26958, 1283},
	{43152, 1285},
	{26999, 1286},
};

static const struct si_reg gfx940_reg_table[] = {
	{43304, 40},
	{1310, 68, 14, 5680},
	{1323, 72, 25, 6342},
	{1338, 76, 11, 6367},
	{51171, 80, 11, 6378},
	{1375, 84, 5, 6389},
	{1393, 88, 2, 3935},
	{1411, 92, 7, 5724},
	{1426, 96},
	{1440, 100, 1, 70},
	{1454, 104},
	{51185, 108},
	{51202, 112, 13, 5731},
	{1471, 116, 7, 5744},
	{1487, 120},
	{1609, 2480},
	{1623, 2484},
	{1637, 2488},
	{1651, 2492},
	{1665, 2496},
	{1679, 2500},
	{1693, 2504},
	{1707, 2508},
	{1721, 2512},
	{1735, 2516},
	{1749, 2520},
	{1764, 2524},
	{1779, 2528},
	{1794, 2532},
	{1809, 2536},
	{1824, 2540},
	{1839, 2544},
	{1850, 2552},
	{1866, 2556},
	{1954, 32776, 27, 6394},
	{1967, 32784, 24, 5776},
	{1979, 32788, 12, 5800},
	{1995, 32792, 12, 5800},
	{2024, 32824, 12, 5800},
	{2040, 32828, 12, 5800},
	{47289, 33280, 4, 6421},
	{59144, 33288, 3, 6425},
	{2056, 33296, 16, 5812},
	{2070, 33300, 28, 204},
	{2087, 33304, 14, 232},
	{2108, 33308, 21, 5828},
	{2122, 33312, 31, 5153},
	{2139, 33316, 11, 307},
	{2178, 33324, 1, 329},
	{43349, 33328, 4, 6428},
	{2201, 33344, 1, 6432},
	{2222, 33348},
	{2242, 33352, 1, 332},
	{2283, 33436, 1, 342},
	{53768, 36032},
	{53789, 36036, 1, 4637},
	{2431, 36040, 7, 5191},
	{2452, 36044, 3, 4646},
	{53810, 36048, 2, 4649},
	{2479, 36052, 1, 4673},
	{53836, 36056, 15, 6247},
	{54839, 36060, 1, 5200},
	{54861, 36064},
	{2410, 36068, 2, 4651},
	{2500, 36072, 6, 6262},
	{53878, 36076, 1, 4674},
	{53857, 36080},
	{29907, 36096},
	{29934, 36100},
	{29961, 36104},
	{29988, 36108},
	{2687, 36608},
	{2705, 36612, 4, 383},
	{2723, 36616},
	{2741, 36620, 12, 5849},
	{3642, 36624},
	{3660, 36628, 6, 6433},
	{3678, 36632, 3, 4718},
	{3696, 36636, 8, 5869},
	{3714, 36640, 3, 5877},
	{3732, 36644, 7, 5880},
	{3750, 36648, 8, 5421},
	{3768, 36652},
	{2759, 36656, 14, 5429},
	{2777, 36660, 4, 411},
	{2795, 36664, 10, 5887},
	{2813, 36668, 3, 5897},
	{2831, 37120, 9, 426},
	{2847, 39160, 13, 5900},
	{2862, 39184, 5, 4776},
	{2876, 39188, 5, 4776},
	{2890, 39192, 5, 4776},
	{2904, 39196, 5, 4776},
	{2918, 39200, 5, 4776},
	{2932, 39204, 5, 4776},
	{2946, 39208, 5, 4776},
	{2960, 39212, 5, 4776},
	{2974, 39216, 5, 4776},
	{2988, 39220, 5, 4776},
	{3002, 39224, 5, 4776},
	{3017, 39228, 5, 4776},
	{3032, 39232, 5, 4776},
	{3047, 39236, 5, 4776},
	{3062, 39240, 5, 4776},
	{3077, 39244, 5, 4776},
	{3092, 39248, 5, 4776},
	{3107, 39252, 5, 4776},
	{3122, 39256, 5, 4776},
	{3137, 39260, 5, 4776},
	{3152, 39264, 5, 4776},
	{3167, 39268, 5, 4776},
	{3182, 39272, 5, 4776},
	{3197, 39276, 5, 4776},
	{3212, 39280, 5, 4776},
	{3227, 39284, 5, 4776},
	{3242, 39288, 5, 4776},
	{3257, 39292, 5, 4776},
	{3272, 39296, 5, 4776},
	{3287, 39300, 5, 4776},
	{3302, 39304, 5, 4776},
	{3317, 39308, 5, 4776},
	{3332, 39312, 4, 445},
	{3351, 39316, 4, 445},
	{3370, 39320, 4, 445},
	{3389, 39324, 4, 445},
	{3408, 39328, 4, 445},
	{3427, 39332, 4, 445},
	{3446, 39336, 4, 445},
	{3465, 39340, 4, 445},
	{3484, 39344, 4, 445},
	{3503, 39348, 4, 445},
	{3522, 39352, 4, 445},
	{3542, 39356, 4, 445},
	{3562, 39360, 4, 445},
	{3582, 39364, 4, 445},
	{3602, 39368, 4, 445},
	{3622, 39372, 4, 445},
	{3867, 45084, 4, 5913},
	{3891, 45088},
	{3912, 45092, 1, 498},
	{3933, 45096, 11, 5917},
	{3957, 45100, 10, 5928},
	{3981, 45104},
	{4007, 45108},
	{4033, 45112},
	{4059, 45116},
	{4085, 45120},
	{4111, 45124},
	{4137, 45128},
	{4163, 45132},
	{4189, 45136},
	{4215, 45140},
	{4241, 45144},
	{4268, 45148},
	{4295, 45152},
	{4322, 45156},
	{4349, 45160},
	{4376, 45164},
	{4403, 45168},
	{4430, 45172},
	{4457, 45176},
	{4484, 45180},
	{4511, 45184},
	{4538, 45188},
	{4565, 45192},
	{4592, 45196},
	{4619, 45200},
	{4646, 45204},
	{4673, 45208},
	{4700, 45212},
	{4727, 45216},
	{4754, 45220},
	{4781, 45224},
	{4808, 45228},
	{5048, 45336, 4, 5913},
	{5072, 45340, 1, 534},
	{5097, 45344},
	{5118, 45348, 1, 498},
	{5139, 45352, 12, 5938},
	{5163, 45356, 14, 5950},
	{5187, 45360},
	{5213, 45364},
	{5239, 45368},
	{5265, 45372},
	{5291, 45376},
	{5317, 45380},
	{5343, 45384},
	{5369, 45388},
	{5395, 45392},
	{5421, 45396},
	{5447, 45400},
	{5474, 45404},
	{5501, 45408},
	{5528, 45412},
	{5555, 45416},
	{5582, 45420},
	{5609, 45424},
	{5636, 45428},
	{5663, 45432},
	{5690, 45436},
	{5717, 45440},
	{5744, 45444},
	{5771, 45448},
	{5798, 45452},
	{5825, 45456},
	{5852, 45460},
	{5879, 45464},
	{5906, 45468},
	{5933, 45472},
	{5960, 45476},
	{5987, 45480},
	{6014, 45484},
	{6205, 45552, 9, 561},
	{6311, 45572, 2, 5964},
	{6335, 45576},
	{6367, 45580},
	{7642, 45584},
	{7663, 45588, 1, 498},
	{6447, 45596, 4, 5913},
	{6471, 45600},
	{6492, 45604, 1, 498},
	{6513, 45608, 12, 5966},
	{6537, 45612, 9, 5978},
	{7732, 45872},
	{7758, 45876},
	{7784, 45880},
	{7810, 45884},
	{7836, 45888},
	{7862, 45892},
	{7888, 45896},
	{7914, 45900},
	{7940, 45904},
	{7966, 45908},
	{7992, 45912},
	{8019, 45916},
	{8046, 45920},
	{8073, 45924},
	{8100, 45928},
	{8127, 45932},
	{56982, 45936},
	{57009, 45940},
	{57036, 45944},
	{57063, 45948},
	{57090, 45952},
	{57117, 45956},
	{57144, 45960},
	{57171, 45964},
	{57198, 45968},
	{57225, 45972},
	{57252, 45976},
	{57279, 45980},
	{57306, 45984},
	{57333, 45988},
	{57360, 45992},
	{57387, 45996},
	{8206, 46084, 1, 5964},
	{8230, 46088},
	{8262, 46092},
	{9537, 46096},
	{9558, 46100, 1, 498},
	{8342, 46108, 4, 5987},
	{8366, 46112},
	{8387, 46116, 1, 498},
	{8408, 46120, 11, 5991},
	{8432, 46124, 7, 6002},
	{9627, 46128},
	{9653, 46132},
	{9679, 46136},
	{9705, 46140},
	{9731, 46144},
	{9757, 46148},
	{9783, 46152},
	{9809, 46156},
	{9835, 46160},
	{9861, 46164},
	{9887, 46168},
	{9914, 46172},
	{9941, 46176},
	{9968, 46180},
	{9995, 46184},
	{10022, 46188},
	{57414, 46192},
	{57441, 46196},
	{57468, 46200},
	{57495, 46204},
	{57522, 46208},
	{57549, 46212},
	{57576, 46216},
	{57603, 46220},
	{57630, 46224},
	{57657, 46228},
	{57684, 46232},
	{57711, 46236},
	{57738, 46240},
	{57765, 46244},
	{57792, 46248},
	{57819, 46252},
	{57846, 46384},
	{57876, 46388},
	{57906, 46392},
	{57936, 46396},
	{57966, 46400},
	{57996, 46404},
	{58026, 46408},
	{58056, 46412},
	{58086, 46416},
	{58116, 46420},
	{58146, 46424},
	{58177, 46428},
	{58208, 46432},
	{58239, 46436},
	{58270, 46440},
	{58301, 46444},
	{58332, 46448},
	{58363, 46452},
	{58394, 46456},
	{58425, 46460},
	{58456, 46464},
	{58487, 46468},
	{58518, 46472},
	{58549, 46476},
	{58580, 46480},
	{58611, 46484},
	{58642, 46488},
	{58673, 46492},
	{58704, 46496},
	{58735, 46500},
	{58766, 46504},
	{58797, 46508},
	{10049, 47104, 11, 6009},
	{10076, 47108},
	{10090, 47112},
	{10104, 47116},
	{10118, 47120},
	{10134, 47124},
	{10150, 47128},
	{10166, 47132, 2, 666},
	{10187, 47136, 2, 666},
	{10208, 47140, 2, 666},
	{10229, 47144, 1, 668},
	{10257, 47148, 1, 669},
	{10282, 47152},
	{10297, 47156, 1, 670},
	{10312, 47160},
	{10341, 47164, 1, 670},
	{10370, 47168},
	{10403, 47172, 1, 670},
	{10436, 47176, 11, 6020},
	{10454, 47180, 12, 6031},
	{10472, 47184, 1, 694},
	{10485, 47188, 7, 6043},
	{54675, 47192, 2, 4905},
	{54706, 47196, 2, 4905},
	{10563, 47200, 2, 701},
	{54889, 47204, 2, 4905},
	{54920, 47208, 2, 4905},
	{10638, 47212},
	{10656, 47216},
	{10674, 47220},
	{10692, 47224, 1, 703},
	{10720, 47228, 2, 6439},
	{10742, 47232},
	{10762, 47236},
	{10945, 47240, 3, 720},
	{10962, 47244},
	{10991, 47248, 1, 723},
	{59162, 47260, 1, 6441},
	{10923, 47280},
	{10886, 47284, 4, 6442},
	{11038, 47360},
	{11058, 47364},
	{11078, 47368},
	{11098, 47372},
	{11118, 47376},
	{11138, 47380},
	{11158, 47384},
	{11178, 47388},
	{11198, 47392},
	{11218, 47396},
	{11238, 47400},
	{11259, 47404},
	{11280, 47408},
	{11301, 47412},
	{11322, 47416},
	{11343, 47420},
	{11388, 47608},
	{11409, 47612},
	{26833, 197092, 1, 1670},
	{26850, 197100, 1, 1671},
	{26871, 197104, 13, 1672},
	{26885, 197108},
	{26899, 197112},
	{26913, 197116, 2, 1685},
	{27163, 197168, 1, 1705},
	{206, 880, 4, 2163},
	{43152, 881},
	{26999, 882},
	{43164, 1008},
	{43175, 1009},
	{27187, 1010, 4, 2167},
	{43186, 1040, 1, 2171},
	{43199, 1041, 5, 2172},
	{43212, 1042, 1, 2177},
	{43225, 1043, 1, 1688},
	{27021, 1045, 7, 2178},
	{43253, 1281, 6, 2197},
	{43268, 1282},
	{26958, 1283},
	{43152, 1285},
	{26999, 1286},
};

static const struct si_field sid_fields_table[] = {
	/* 0 */
	{59184, 0xF},
	{59193, 0xF0},
	{59203, 0x100},
	{59214, 0x200},
	{59219, 0x400},
	{59346, 0x1FF000, 257, 0},
	{59354, 0x800000},
	{59364, 0x8000000},
	{59377, 0x10000000},
	{59383, 0xE0000000},
	/* 10 */
	{59387, 0x1},
	{59391, 0x6},
	{59400, 0x18},
	{59410, 0x20},
	{59415, 0x40},
	{59423, 0x80},
	{59433, 0x100},
	{59444, 0x200},
	{59450, 0x400},
	{59455, 0x800},
	{59461, 0x1000},
	{59472, 0x2000},
	{59477, 0x4000},
	{59482, 0x8000},
	{59233, 0x10000},
	{59497, 0x20000},
	{59505, 0x40000},
	{59517, 0x80000},
	{59525, 0x800000},
	{59536, 0x8000000},
	/* 30 */
	{59548, 0x1FF, 257, 0},
	{59553, 0x400},
	{59561, 0x800},
	{59574, 0x7000},
	{59582, 0x8000},
	{59593, 0xF0000},
	{59604, 0xF00000},
	{59620, 0x1000000},
	{59634, 0x10000000},
	{59646, 0xE0000000},
	/* 40 */
	{54607, 0xF},
	{59654, 0x30},
	{59662, 0xC0},
	{59670, 0xF00},
	{59676, 0x1000},
	{29236, 0x6000},
	{59682, 0x8000},
	{59694, 0xF0000},
	{59700, 0xF00000},
	{59706, 0x7000000},
	{59715, 0x38000000},
	{59724, 0xC0000000},
	/* 52 */
	{59730, 0xFF},
	{59740, 0xFF00},
	{59750, 0xFF0000},
	{59760, 0xF000000},
	/* 56 */
	{59770, 0x1FF},
	{59779, 0x1FF000},
	{59788, 0xF000000},
	/* 59 */
	{59805, 0xF},
	{59812, 0x70},
	{59820, 0x80},
	{59834, 0xF00},
	{59843, 0x7000},
	{59852, 0x8000},
	{59865, 0x3F0000},
	{59870, 0xC00000},
	{59880, 0x1000000},
	{59894, 0x2000000},
	{59906, 0xFC000000},
	/* 70 */
	{1448, 0xFFFF},
	/* 71 */
	{59634, 0x1},
	{59913, 0x2},
	{59919, 0x4},
	{59933, 0x8},
	{59948, 0x3F0},
	{59953, 0x1F800},
	{59865, 0xFC0000},
	{59958, 0x1000000},
	{59968, 0xFE000000},
	/* 80 */
	{54607, 0x1F},
	{59654, 0x300},
	{59977, 0x3C00},
	{59984, 0x10000},
	{29236, 0xC0000},
	/* 85 */
	{59706, 0xF},
	{59662, 0x30},
	{59724, 0x300},
	{59715, 0x7000},
	{59990, 0x1F0000},
	{59700, 0xF000000},
	{59996, 0x60000000},
	/* 92 */
	{60009, 0x1},
	{60017, 0x6},
	/* 94 */
	{60032, 0x3},
	/* 95 */
	{30700, 0x3F},
	{10449, 0xFC0},
	{10467, 0x3F000},
	{30675, 0xFC0000},
	/* 99 */
	{60041, 0x3},
	{60055, 0x80},
	{60073, 0x300},
	{60083, 0x400},
	{60096, 0x800},
	{59625, 0x1000},
	{60103, 0x2000},
	/* 106 */
	{60113, 0xF},
	{60136, 0x10},
	{60159, 0x20},
	{60182, 0x40},
	{60202, 0x80},
	{60222, 0x100},
	{60242, 0x200},
	{60262, 0x400},
	{60282, 0x800},
	{60302, 0x1000},
	{60322, 0x2000},
	{60342, 0x4000},
	{60357, 0x8000},
	{60368, 0x10000},
	{60376, 0x20000},
	{60385, 0x40000},
	{60402, 0x80000},
	{60417, 0x100000},
	{60430, 0x200000},
	{60440, 0x400000},
	{60457, 0x800000},
	{60474, 0x1000000},
	{60483, 0x2000000},
	{60492, 0x10000000},
	{60501, 0x20000000},
	{60510, 0x40000000},
	{60519, 0x80000000},
	/* 133 */
	{60530, 0xF},
	{60553, 0x20},
	{60569, 0x80},
	{60592, 0x100},
	{60615, 0x200},
	{60634, 0x1000},
	{60643, 0x2000},
	{60652, 0x4000},
	{60660, 0x8000},
	{60669, 0x10000},
	{60684, 0x100000},
	{60692, 0x200000},
	{60700, 0x400000},
	{60709, 0x800000},
	{60718, 0x1000000},
	{60726, 0x2000000},
	{60734, 0x4000000},
	{60742, 0x10000000},
	{60484, 0x20000000},
	{60760, 0x40000000},
	{60768, 0x80000000},
	/* 154 */
	{60634, 0x2},
	{60643, 0x4},
	{60779, 0x8},
	{60483, 0x10},
	{60790, 0x20},
	{60376, 0x200000},
	{60709, 0x400000},
	{60726, 0x1000000},
	{60652, 0x2000000},
	{60684, 0x4000000},
	{60700, 0x8000000},
	{60718, 0x20000000},
	{60734, 0x40000000},
	{60760, 0x80000000},
	/* 168 */
	{60801, 0x20},
	{60830, 0x40},
	{60861, 0x80},
	{60890, 0x100},
	{60910, 0x200},
	{60930, 0x400},
	{60950, 0x800},
	{60970, 0x2000},
	{60978, 0x4000},
	{60986, 0x8000},
	{60790, 0x10000},
	{60997, 0x10000000},
	{61011, 0x20000000},
	{60779, 0x40000000},
	{61020, 0x80000000},
	/* 183 */
	{61029, 0x1},
	{61039, 0x2},
	{61049, 0x4},
	{61058, 0x8},
	{61067, 0x10},
	{61078, 0x20},
	{61089, 0x40},
	{61099, 0x80},
	{61109, 0x400},
	{61119, 0x800},
	{61136, 0x1000},
	{61144, 0x2000},
	{61157, 0x4000},
	{61175, 0x8000},
	{61186, 0x10000},
	{61195, 0x20000},
	{61216, 0x40000},
	{61227, 0x80000},
	{61254, 0x20000000},
	{61267, 0x40000000},
	{60501, 0x80000000},
	/* 204 */
	{61280, 0x1},
	{61295, 0x2},
	{61315, 0x4},
	{61331, 0x8},
	{61349, 0x10},
	{61369, 0x20},
	{61388, 0x40},
	{61407, 0x80},
	{61420, 0x100},
	{61434, 0x200},
	{61458, 0x400},
	{61474, 0x800},
	{61490, 0x1000},
	{61506, 0x2000},
	{61522, 0x10000},
	{61537, 0x20000},
	{61557, 0x40000},
	{61573, 0x80000},
	{61591, 0x100000},
	{61611, 0x200000},
	{61630, 0x400000},
	{61649, 0x800000},
	{61662, 0x1000000},
	{61676, 0x2000000},
	{61700, 0x4000000},
	{61716, 0x8000000},
	{61732, 0x10000000},
	{61748, 0x20000000},
	/* 232 */
	{61764, 0x8},
	{61783, 0x10},
	{61803, 0x40},
	{61822, 0x100},
	{61843, 0x200},
	{61861, 0x400},
	{61884, 0x2000},
	{61906, 0x10000},
	{61927, 0x20000},
	{61945, 0x40000},
	{61968, 0x200000},
	{61990, 0x400000},
	{62014, 0x800000},
	{62038, 0x1000000},
	{62061, 0x2000000},
	/* 247 */
	{62083, 0x1},
	{62102, 0x2},
	{62111, 0x10},
	{62126, 0x20},
	{62140, 0x40},
	{62159, 0x80},
	{62178, 0x100},
	{62193, 0x200},
	{62210, 0x400},
	{62232, 0x800},
	{62254, 0x1000},
	{62269, 0x2000},
	{61109, 0x4000},
	{62284, 0x8000},
	{62293, 0x10000},
	{61144, 0x20000},
	{62302, 0x40000},
	{62312, 0x80000},
	{62326, 0x100000},
	{62340, 0x200000},
	{62354, 0x400000},
	{61175, 0x800000},
	{62371, 0x1000000},
	{62384, 0x4000000},
	{62397, 0x8000000},
	{62410, 0x30000000},
	{62429, 0x40000000},
	{60492, 0x80000000},
	/* 275 */
	{62442, 0x1},
	{62460, 0x2},
	{62474, 0x4},
	{62493, 0x8},
	{62512, 0x10},
	{62527, 0x20},
	{62545, 0x40},
	{62563, 0x80},
	{62580, 0x100},
	{62595, 0x200},
	{62609, 0x400},
	{62626, 0x800},
	{62650, 0x1000},
	{62668, 0x2000},
	{62686, 0x4000},
	{62707, 0x8000},
	{62731, 0x10000},
	{62757, 0x20000},
	{62774, 0x40000},
	{62794, 0x80000},
	{62814, 0x100000},
	{62834, 0x200000},
	{62855, 0x400000},
	{62878, 0x800000},
	{62899, 0x1000000},
	{62918, 0x2000000},
	{62935, 0x4000000},
	{62951, 0x8000000},
	{62967, 0x10000000},
	{62983, 0x20000000},
	{63002, 0x40000000},
	{63014, 0x80000000},
	/* 307 */
	{63026, 0x1},
	{63045, 0x2},
	{63065, 0x4},
	{63085, 0x8},
	{63105, 0x20},
	{63126, 0x40},
	{61990, 0x80},
	{62014, 0x100},
	{63147, 0x200},
	{63174, 0x400},
	{63201, 0x800},
	{63222, 0x1000},
	{63241, 0x2000},
	/* 320 */
	{63260, 0x1},
	{63274, 0x4},
	{63289, 0x8},
	{63306, 0x80},
	{63318, 0x100},
	{63331, 0x400},
	{63346, 0x800},
	{63361, 0x1000},
	{63376, 0x2000},
	/* 329 */
	{2190, 0x3F},
	/* 330 */
	{2208, 0x1FF},
	{63391, 0x80000000},
	/* 332 */
	{2190, 0x7},
	/* 333 */
	{63416, 0x1000},
	{63438, 0x4000},
	{63463, 0x20000},
	{63484, 0x40000},
	{63508, 0x400000},
	{63535, 0x800000},
	{63560, 0x1000000},
	{63583, 0x8000000},
	{63603, 0x40000000},
	/* 342 */
	{2195, 0xF},
	/* 343 */
	{10428, 0xF},
	{38, 0x3FFFFF00},
	/* 345 */
	{879, 0x1FFFFFFF},
	{63619, 0x80000000},
	/* 347 */
	{63629, 0x3},
	{63638, 0xF0},
	{63646, 0x200},
	{63653, 0x1FC00},
	/* 351 */
	{63924, 0xFFF, 2049, 257},
	{64086, 0xFF0000, 129, 2306},
	{64098, 0x3000000},
	{64111, 0x80000000},
	/* 355 */
	{1318, 0x3},
	{64126, 0x4},
	{64135, 0x8},
	{64146, 0x10},
	{64159, 0x20},
	{53894, 0x1C0},
	{64173, 0x200},
	{64186, 0x400},
	{64199, 0x800},
	{64211, 0x1000},
	{64229, 0x2000},
	{64240, 0xC000},
	{64255, 0x30000},
	{64263, 0x40000},
	{64282, 0x80000},
	{64299, 0x40000000},
	{64311, 0x80000000},
	/* 372 */
	{64325, 0xFFF},
	{64340, 0xFFF000},
	{64352, 0x1000000},
	{60363, 0x2000000},
	{64360, 0x4000000},
	{64380, 0x8000000},
	/* 378 */
	{14293, 0xF},
	{64468, 0x3F0, 33, 2435},
	{64472, 0x400},
	{64347, 0x800},
	{64478, 0x1000},
	/* 383 */
	{64481, 0xFFFF},
	{20043, 0x3FFF0000},
	{64497, 0x40000000},
	{64511, 0x80000000},
	/* 387 */
	{64526, 0x7},
	{64536, 0x38},
	{64546, 0x1C0},
	{64556, 0xE00},
	{17670, 0x7F000, 293, 2468},
	{68793, 0x600000},
	{68806, 0x800000},
	{68821, 0x1000000},
	{68927, 0x30000000, 4, 2761},
	{220, 0xC0000000},
	/* 397 */
	{68938, 0x7},
	{68946, 0x38},
	{68954, 0x1C0},
	{68962, 0xE00},
	{68978, 0x7000},
	{68997, 0x8000},
	{69016, 0x70000},
	{69032, 0x80000},
	{69047, 0x100000},
	{69061, 0x7E00000},
	{69072, 0x8000000},
	{69084, 0x10000000},
	{69102, 0x60000000},
	{69114, 0x80000000},
	/* 411 */
	{69127, 0xFFF},
	{69135, 0xFFF000},
	{69143, 0xF000000},
	{69152, 0xF0000000},
	/* 415 */
	{69159, 0x3FFF},
	{69168, 0xFC000},
	{69181, 0x300000},
	{69195, 0xC00000},
	{69209, 0x3000000},
	{69218, 0xC000000},
	{69229, 0x10000000},
	{69248, 0x20000000},
	{69263, 0x40000000},
	/* 424 */
	{69278, 0xFFF},
	{69295, 0xC0000000},
	/* 426 */
	{69313, 0x1FFFFF},
	{69332, 0xE00000},
	{69351, 0x1000000},
	{69373, 0x2000000},
	{69395, 0x4000000},
	{69411, 0x8000000},
	{69428, 0x10000000},
	{69446, 0x20000000},
	{69462, 0xC0000000},
	/* 435 */
	{69483, 0x7},
	{69493, 0x38},
	{69514, 0xC0},
	{69535, 0x180000},
	{69554, 0xC000000},
	/* 440 */
	{69924, 0x3C, 16, 2765},
	{70352, 0x7C0, 19, 2781},
	{70542, 0x3800, 7, 2800},
	{70701, 0x1C00000, 5, 2807},
	{70721, 0x6000000},
	/* 445 */
	{70826, 0x3, 4, 2812},
	{70933, 0xC, 4, 2816},
	{71045, 0x30, 4, 2820},
	{71132, 0xC0, 4, 2824},
	/* 449 */
	{64481, 0xFF},
	{69127, 0xFFF00},
	{17670, 0x1FF00000, 293, 2468},
	{71142, 0xC0000000},
	/* 453 */
	{71151, 0xFFF},
	{70938, 0xFFFC000},
	{68821, 0x80000000},
	/* 456 */
	{64526, 0x7},
	{64536, 0x38},
	{64546, 0x1C0},
	{64556, 0xE00},
	{71160, 0xF000},
	{71171, 0xF0000},
	{71182, 0x1F00000},
	{71286, 0xE000000, 6, 2828},
	{220, 0xF0000000},
	/* 465 */
	{18816, 0x1FFF},
	{71297, 0x1FFF0000},
	/* 467 */
	{71308, 0xF},
	{71320, 0xF0},
	{71328, 0xFFF00},
	{71341, 0x700000},
	{71350, 0x800000},
	{71365, 0x2000000},
	{71380, 0x4000000},
	/* 474 */
	{71392, 0xFF},
	{71408, 0x400},
	{71420, 0x18000},
	{71448, 0x60000},
	{71474, 0x80000},
	{71492, 0x100000},
	{71514, 0x200000},
	{71529, 0x400000},
	{71545, 0x800000},
	{71561, 0xFF000000},
	/* 484 */
	{71582, 0x1},
	{71594, 0xE},
	{71607, 0xF0},
	{71625, 0x100},
	{71639, 0x3FE00},
	{71643, 0x40000},
	{43518, 0x80000},
	{10480, 0xF00000},
	{71646, 0x1000000},
	{71649, 0x3E000000},
	/* 494 */
	{71654, 0xFFFF},
	/* 495 */
	{71654, 0xFFFF},
	{71660, 0x3F0000},
	{71671, 0x3C00000},
	/* 498 */
	{71690, 0xFF},
	/* 499 */
	{71699, 0x3F},
	{71705, 0x3C0},
	{69323, 0xC00},
	{71795, 0xFF000, 193, 2834},
	{59410, 0x100000},
	{59203, 0x200000},
	{71806, 0x800000},
	{71816, 0x1000000},
	{71833, 0x2000000},
	{60083, 0x4000000},
	{59354, 0x20000000},
	/* 510 */
	{71845, 0x1},
	{71856, 0x3E},
	{71866, 0x40},
	{71879, 0x80},
	{71891, 0xFF00},
	{59346, 0x1FF0000, 257, 0},
	{71906, 0x2000000},
	{71928, 0x4000000},
	{71953, 0x8000000},
	{71967, 0xF0000000},
	/* 520 */
	{71983, 0x1},
	{72000, 0x1E},
	{72026, 0x1E0},
	{72059, 0x200},
	{72080, 0x7C00},
	{72104, 0x8000},
	{72129, 0x10000},
	{72148, 0xE0000},
	/* 528 */
	{72185, 0x7},
	{72214, 0x38},
	{72246, 0x40},
	{72262, 0xFF00},
	{72291, 0xFF0000},
	/* 533 */
	{72323, 0x7F},
	/* 534 */
	{71665, 0x3F},
	/* 535 */
	{71699, 0x3F},
	{71705, 0x3C0},
	{69323, 0xC00},
	{71795, 0xFF000, 193, 2834},
	{59410, 0x100000},
	{59203, 0x200000},
	{71806, 0x800000},
	{72336, 0x3000000},
	{72350, 0x4000000},
	{71833, 0x8000000},
	{60083, 0x10000000},
	{59354, 0x80000000},
	/* 547 */
	{71845, 0x1},
	{71856, 0x3E},
	{71866, 0x40},
	{72366, 0x80},
	{72376, 0x100},
	{72388, 0x200},
	{72400, 0x400},
	{72412, 0x800},
	{72424, 0x1000},
	{59346, 0x3FE000, 257, 0},
	{72430, 0x400000},
	{72441, 0x1000000},
	{71953, 0x8000000},
	{71967, 0xF0000000},
	/* 561 */
	{71845, 0x1},
	{71856, 0x3E},
	{71866, 0x40},
	{59346, 0xFF80, 257, 0},
	{72336, 0x30000},
	{72366, 0x40000},
	{59779, 0x7F80000},
	{72458, 0x8000000},
	{71953, 0x10000000},
	/* 570 */
	{71845, 0x1},
	{71856, 0x3E},
	{71866, 0x40},
	{72366, 0x80},
	{59346, 0x1FF00, 257, 0},
	{59779, 0x1FF00000},
	/* 576 */
	{71845, 0x1},
	{71856, 0x3E},
	{71866, 0x40},
	{59779, 0xFF80},
	{59346, 0x1FF0000, 257, 0},
	/* 581 */
	{71654, 0xFFFF},
	{72470, 0x7F0000},
	/* 583 */
	{71654, 0xFFFF},
	{71660, 0x3F0000},
	{71671, 0x3C00000},
	{72495, 0xFC000000},
	/* 587 */
	{71699, 0x3F},
	{71705, 0x3C0},
	{69323, 0xC00},
	{71795, 0xFF000, 193, 2834},
	{59410, 0x100000},
	{59203, 0x200000},
	{71806, 0x800000},
	{72350, 0x1000000},
	{71833, 0x2000000},
	{60083, 0x4000000},
	{72512, 0x8000000},
	{72521, 0x60000000},
	{59354, 0x80000000},
	/* 600 */
	{71845, 0x1},
	{71856, 0x3E},
	{71866, 0x40},
	{59346, 0xFF80, 257, 0},
	{72538, 0x30000},
	{72366, 0x40000},
	{59779, 0x7F80000},
	{71953, 0x8000000},
	{71967, 0xF0000000},
	/* 609 */
	{71699, 0x3F},
	{71705, 0x3C0},
	{69323, 0xC00},
	{71795, 0xFF000, 193, 2834},
	{59410, 0x100000},
	{59203, 0x200000},
	{71806, 0x800000},
	{72336, 0x3000000},
	{72350, 0x4000000},
	{59354, 0x80000000},
	/* 619 */
	{71660, 0x3F},
	{71671, 0x3C0},
	{72495, 0xFC00},
	{71654, 0xFFFF0000},
	/* 623 */
	{71699, 0x3F},
	{71705, 0x3C0},
	{69323, 0xC00},
	{71795, 0xFF000, 193, 2834},
	{59410, 0x100000},
	{59203, 0x200000},
	{71806, 0x800000},
	{71833, 0x1000000},
	{60083, 0x2000000},
	{72512, 0x4000000},
	{72555, 0x30000000},
	{59354, 0x40000000},
	/* 635 */
	{71845, 0x1},
	{71856, 0x3E},
	{71866, 0x40},
	{72366, 0x80},
	{72572, 0x100},
	{59346, 0x3FE00, 257, 0},
	{59779, 0x7FC0000},
	{71953, 0x8000000},
	{71967, 0xF0000000},
	/* 644 */
	{71699, 0x3F},
	{71705, 0x3C0},
	{69323, 0xC00},
	{71795, 0xFF000, 193, 2834},
	{59410, 0x100000},
	{59203, 0x200000},
	{71806, 0x800000},
	{72336, 0x3000000},
	{59354, 0x40000000},
	/* 653 */
	{72583, 0x1},
	{72601, 0x2},
	{72615, 0x4},
	{72634, 0x8},
	{72654, 0x10},
	{72674, 0x20},
	{72696, 0x40},
	{72707, 0x400},
	{72725, 0x800},
	{10733, 0x1000},
	{72743, 0x2000},
	{72757, 0x4000},
	{72765, 0x8000},
	/* 666 */
	{72775, 0xFFFF},
	{72791, 0xFFFF0000},
	/* 668 */
	{10237, 0x1},
	/* 669 */
	{10265, 0x1},
	/* 670 */
	{402, 0xFF},
	/* 671 */
	{71699, 0x3F},
	{71705, 0x3C0},
	{69323, 0xC00},
	{71795, 0xFF000, 193, 2834},
	{59410, 0x100000},
	{59203, 0x200000},
	{71806, 0x800000},
	{72810, 0x1000000},
	{59354, 0x4000000},
	{72512, 0x20000000},
	{71833, 0x40000000},
	{60083, 0x80000000},
	/* 683 */
	{71845, 0x1},
	{71856, 0x3E},
	{71866, 0x40},
	{72816, 0x80},
	{72826, 0x100},
	{72836, 0x200},
	{72572, 0x400},
	{72846, 0x1800},
	{72861, 0x6000},
	{59779, 0xFF8000},
	{59346, 0x7F000000, 257, 0},
	/* 694 */
	{402, 0xF},
	/* 695 */
	{72873, 0x3FF},
	{72886, 0xF000},
	{72896, 0x3F0000},
	{72911, 0x400000},
	{72926, 0x800000},
	{72942, 0x7000000},
	/* 701 */
	{72957, 0xFFF},
	{72963, 0x1FFF000},
	/* 703 */
	{10700, 0x1},
	/* 704 */
	{72972, 0x3},
	{70007, 0x4},
	{72982, 0x8},
	{72992, 0x10},
	{73002, 0x1FFE0},
	/* 709 */
	{71983, 0x1},
	{72000, 0x1E},
	{72026, 0x1E0},
	{72059, 0x200},
	{72080, 0x7C00},
	{72104, 0x8000},
	{72129, 0x10000},
	{72148, 0xE0000},
	{73015, 0x7F00000},
	/* 718 */
	{71967, 0xF},
	/* 719 */
	{452, 0x7FF},
	/* 720 */
	{73052, 0x3FFFFFFF},
	{73060, 0x40000000},
	{73069, 0x80000000},
	/* 723 */
	{11982, 0xFFFF},
	/* 724 */
	{73078, 0x3FF},
	{63792, 0x400},
	/* 726 */
	{73088, 0x1},
	{73107, 0x2},
	{73128, 0x4},
	{73139, 0x8},
	{73152, 0x10},
	{73171, 0x20},
	{73196, 0x40},
	{73219, 0x80},
	{73233, 0xF00},
	{73245, 0x1000},
	/* 736 */
	{73263, 0x1},
	{73287, 0x2},
	{73308, 0x4},
	{73342, 0x8},
	{73377, 0x70},
	{73389, 0xF00},
	{73402, 0xF000},
	{73415, 0xF0000},
	{73428, 0xF00000},
	{73442, 0xF000000},
	{73460, 0xF0000000},
	/* 747 */
	{73477, 0x7FF},
	{73489, 0x1800},
	{73504, 0xFFE000},
	{73514, 0x1000000},
	{73526, 0x2000000},
	{73544, 0x3C000000},
	{73550, 0xC0000000},
	/* 754 */
	{73615, 0x3, 4, 3027},
	{73632, 0xC, 4, 3027},
	{73650, 0x30, 4, 3027},
	{73668, 0x40},
	{73689, 0x80},
	{73704, 0x100},
	{73725, 0x200},
	{73743, 0x400},
	{73760, 0x800},
	{73773, 0x1000},
	{73792, 0x6000, 4, 3027},
	{73811, 0x8000},
	{73835, 0x10000},
	{73858, 0x20000},
	{73875, 0x40000},
	{73960, 0x180000, 4, 3031},
	{73979, 0x3E00000},
	{73996, 0x4000000},
	{74020, 0x8000000},
	{74034, 0x10000000},
	{74054, 0x20000000},
	{74068, 0x40000000},
	{74088, 0x80000000},
	/* 777 */
	{74162, 0x3, 4, 3035},
	{74191, 0x1C},
	{74222, 0x20},
	{74258, 0x40},
	{74293, 0x80},
	{74321, 0x100},
	{74343, 0x200},
	{74361, 0x400},
	{74393, 0x800},
	{74514, 0x7000, 8, 3039},
	{74524, 0x38000},
	{74537, 0x1C0000},
	{74550, 0x200000},
	{74566, 0x400000},
	{74584, 0x800000},
	{74602, 0x2000000},
	/* 793 */
	{74630, 0x3FFF},
	{59138, 0x3FFF0000},
	/* 795 */
	{11600, 0xFF},
	/* 796 */
	{74636, 0xFFFF},
	{74641, 0xFFFF0000},
	/* 798 */
	{74646, 0xFFFF},
	{74651, 0xFFFF0000},
	/* 800 */
	{74665, 0x3, 4, 3047},
	{74679, 0x4},
	{74704, 0x8},
	/* 803 */
	{74722, 0xF},
	{74730, 0xF0},
	{74738, 0x1F00},
	{74746, 0x6000},
	{74754, 0x18000},
	{74762, 0x60000},
	{74770, 0x180000},
	{68821, 0xF0000000},
	/* 811 */
	{17670, 0x3, 4, 3051},
	{74809, 0xC},
	{71182, 0x1F0},
	{74864, 0x600, 4, 3055},
	{74879, 0x800},
	{74893, 0x1000},
	{74912, 0xE000},
	{74929, 0xF0000},
	{71408, 0x100000},
	{74936, 0x7800000},
	{74960, 0x8000000},
	{74975, 0x10000000},
	{74985, 0x20000000},
	{75005, 0x80000000},
	/* 825 */
	{17670, 0x1, 2, 3059},
	{71182, 0x1F0},
	{74864, 0x600, 4, 3055},
	{74879, 0x800},
	{74893, 0x1000},
	{74912, 0xE000},
	{71408, 0x100000},
	{74960, 0x8000000},
	{75048, 0x20000000},
	/* 834 */
	{74722, 0x7FF},
	{74730, 0x3FF800},
	/* 836 */
	{74722, 0x3FFFFF},
	/* 837 */
	{10428, 0xFF},
	/* 838 */
	{75120, 0x3, 4, 3061},
	{75132, 0xC, 4, 3061},
	{75144, 0x30, 4, 3061},
	{75160, 0xC0, 4, 3061},
	{75230, 0x30000, 4, 3065},
	{75242, 0xC0000, 4, 3065},
	{75254, 0x300000, 4, 3065},
	{75270, 0x1000000},
	{75281, 0x2000000},
	/* 847 */
	{30909, 0xFF},
	/* 848 */
	{75292, 0xFF},
	/* 849 */
	{75310, 0xFFFF},
	{75326, 0xFFFF0000},
	/* 851 */
	{74636, 0x7FFF},
	{74641, 0x7FFF0000},
	{75342, 0x80000000},
	/* 854 */
	{74646, 0x7FFF},
	{74651, 0x7FFF0000},
	/* 856 */
	{75430, 0xFFFF, 32769, 3069},
	/* 857 */
	{75440, 0xF},
	{75447, 0xF0},
	{75456, 0xF00},
	{75464, 0x3F000},
	{75475, 0xFC0000},
	{75486, 0xF000000},
	{75497, 0xF0000000},
	/* 864 */
	{75508, 0x1FF},
	{75527, 0x1FF0000},
	/* 866 */
	{75546, 0xF},
	{75561, 0xF0},
	{75576, 0xF00},
	{75591, 0xF000},
	{75606, 0xF0000},
	{75621, 0xF00000},
	{75636, 0xF000000},
	{75651, 0xF0000000},
	/* 874 */
	{75666, 0xF},
	{75681, 0xF0},
	{75696, 0xF00},
	{75711, 0xF000},
	{75726, 0xF0000},
	{75741, 0xF00000},
	{75756, 0xF000000},
	{75771, 0xF0000000},
	/* 882 */
	{75878, 0x3, 4, 35838},
	{75890, 0xC, 4, 35838},
	{76002, 0x30, 4, 35842},
	{76059, 0x40, 2, 35846},
	{76115, 0x80, 2, 35848},
	{76219, 0x300, 4, 35850},
	{76327, 0xC00, 4, 35854},
	{76436, 0x3000, 4, 35858},
	{76549, 0xC000, 4, 35862},
	{76651, 0x30000, 4, 35866},
	{76797, 0xC0000, 4, 35870},
	{76944, 0x300000, 4, 35874},
	{77044, 0x3000000, 4, 35878},
	{77190, 0xC000000, 4, 35882},
	{77337, 0x30000000, 4, 35886},
	/* 897 */
	{77457, 0x3, 4, 35890},
	{77628, 0xC, 4, 35894},
	{77800, 0x30, 4, 35898},
	/* 900 */
	{73442, 0x3},
	{73460, 0xC},
	/* 902 */
	{10250, 0x1},
	{77813, 0x6},
	{69554, 0x60},
	{77820, 0x100},
	{77855, 0x3000},
	{77862, 0x30000},
	{77876, 0x100000},
	/* 909 */
	{77894, 0x80000000},
	/* 910 */
	{59662, 0x3},
	/* 911 */
	{10480, 0xF},
	/* 912 */
	{77909, 0xFF},
	{77918, 0xFF00},
	{77928, 0xFF0000},
	{77939, 0xFF000000},
	/* 916 */
	{77949, 0xFF},
	{77957, 0xFF00},
	{77966, 0xFF0000},
	{77975, 0xFF000000},
	/* 920 */
	{77983, 0x3, 4, 3061},
	{77999, 0xC, 4, 3061},
	{78015, 0x30, 4, 3061},
	{78029, 0xC0, 4, 3061},
	{78045, 0x30000, 4, 3065},
	{78061, 0xC0000, 4, 3065},
	{78077, 0x300000, 4, 3065},
	{78091, 0xC00000, 4, 3065},
	{78107, 0x40000000},
	{78122, 0x80000000},
	/* 930 */
	{78137, 0x1},
	{78164, 0x7C},
	{78193, 0x100},
	{78222, 0x200},
	{78253, 0x400},
	{78281, 0x1000},
	{78309, 0x2000},
	{78339, 0x4000},
	/* 938 */
	{78365, 0x1},
	{78385, 0xE},
	{78402, 0x30},
	{78423, 0xF00},
	/* 942 */
	{78681, 0xF, 16, 35902},
	{78693, 0xF0, 16, 35902},
	{78706, 0xF00, 16, 35902},
	{78719, 0xF000, 16, 35902},
	{78734, 0xF0000, 16, 35902},
	{78750, 0xF00000, 16, 35902},
	/* 948 */
	{78766, 0xFF},
	{78781, 0xFF00},
	{78793, 0xFF0000},
	{78810, 0xFF000000},
	/* 952 */
	{78823, 0xFF},
	{78841, 0xFF00},
	{78856, 0xFF0000},
	{78876, 0xFF000000},
	/* 956 */
	{879, 0x3F},
	{78892, 0x300},
	{78904, 0x400},
	{78915, 0x1E000},
	{78924, 0x20000},
	{78938, 0x40000},
	{78942, 0x80000},
	{78959, 0x100000},
	{78977, 0x600000},
	{78995, 0x800000},
	{79015, 0x1000000},
	{79027, 0x2000000},
	/* 968 */
	{879, 0x3F},
	{78892, 0x300},
	{78904, 0x400},
	{78938, 0x40000},
	{78942, 0x80000},
	{78959, 0x100000},
	{78977, 0x600000},
	{79015, 0x1000000},
	{79027, 0x2000000},
	/* 977 */
	{79039, 0x3E},
	{79055, 0x40},
	{79068, 0x80},
	/* 980 */
	{79081, 0x1},
	{79098, 0x2},
	{79115, 0x4},
	{79134, 0x8},
	{79155, 0x10},
	{79173, 0x20},
	{79191, 0x40},
	{79211, 0x80},
	{79232, 0x100},
	{79248, 0x200},
	{79264, 0x400},
	{79280, 0x800},
	{79296, 0x1000},
	{79311, 0x2000},
	{79325, 0x4000},
	{79345, 0x8000},
	/* 996 */
	{79362, 0x1},
	{79377, 0x2},
	{79500, 0x1C, 5, 35918},
	{79518, 0xE0, 5, 35918},
	{79536, 0x700, 5, 35918},
	{79554, 0x3800, 5, 35918},
	{79572, 0x4000},
	/* 1003 */
	{79589, 0x3F},
	{79600, 0x40},
	{79610, 0x80},
	{79627, 0x100},
	{79643, 0x4000},
	{79663, 0x8000},
	/* 1009 */
	{79673, 0x1},
	{79691, 0x10},
	{79711, 0x100},
	{79730, 0x1000},
	{79751, 0x30000},
	{79770, 0x100000},
	{79784, 0x1000000},
	/* 1016 */
	{79892, 0xF, 5, 35923},
	/* 1017 */
	{79911, 0xF, 5, 35923},
	{79930, 0xF0, 5, 35923},
	{79949, 0xF00, 5, 35923},
	{79968, 0xF000, 5, 35923},
	{79987, 0xF0000, 5, 35923},
	/* 1022 */
	{80206, 0xF, 10, 35928},
	/* 1023 */
	{80222, 0xF, 10, 35928},
	{80241, 0xF0, 10, 35928},
	{80260, 0xF00, 10, 35928},
	{80279, 0xF000, 10, 35928},
	{80298, 0xF0000, 10, 35928},
	{80317, 0xF00000, 10, 35928},
	{80336, 0xF000000, 10, 35928},
	{80355, 0xF0000000, 10, 35928},
	/* 1031 */
	{80609, 0xF, 11, 35938},
	{80614, 0xF0, 11, 35938},
	{80619, 0xF00, 11, 35938},
	{80624, 0xF000, 11, 35938},
	{80629, 0xF0000, 11, 35938},
	{80634, 0xF00000, 11, 35938},
	{80639, 0xF000000, 11, 35938},
	{80644, 0xF0000000, 11, 35938},
	/* 1039 */
	{80816, 0xF, 16, 35949},
	{80829, 0xF0},
	{80842, 0xF00},
	{80855, 0xF000},
	{80868, 0xF0000},
	{80881, 0xF00000},
	{80894, 0xF000000},
	{80907, 0xF0000000},
	/* 1047 */
	{80920, 0x1},
	{80943, 0x2},
	{80966, 0x10},
	{80989, 0x20},
	{81012, 0x100},
	{81035, 0x200},
	{81058, 0x1000},
	{81081, 0x2000},
	{81104, 0x10000},
	{81127, 0x20000},
	{81150, 0x100000},
	{81173, 0x200000},
	{81196, 0x1000000},
	{81219, 0x2000000},
	{81242, 0x10000000},
	{81265, 0x20000000},
	{81288, 0x80000000},
	/* 1064 */
	{81579, 0x7, 8, 35965},
	{81593, 0x70, 8, 35965},
	{81741, 0x700, 8, 35973},
	{81756, 0x70000, 8, 35965},
	{81770, 0x700000, 8, 35965},
	{81784, 0x7000000, 8, 35973},
	/* 1070 */
	{82239, 0x1F, 21, 35981},
	{81741, 0xE0, 5, 36002},
	{82344, 0x1F00, 21, 35981},
	{82360, 0x1F0000, 21, 35981},
	{81784, 0xE00000, 5, 36002},
	{82375, 0x1F000000, 21, 35981},
	{82391, 0x20000000},
	{10250, 0x40000000},
	{82412, 0x80000000},
	/* 1079 */
	{82425, 0x7},
	/* 1080 */
	{11977, 0xFFFF},
	/* 1081 */
	{82516, 0x3, 4, 36007},
	{82562, 0xC, 2, 36011},
	{82573, 0x10},
	{82588, 0x20},
	{82596, 0x40},
	{82607, 0x80},
	{82621, 0x100},
	{82638, 0xE0000000},
	/* 1089 */
	{82651, 0xFFFFFFF},
	/* 1090 */
	{82663, 0x3FF},
	/* 1091 */
	{82686, 0x1},
	{73623, 0x2},
	{82701, 0x4},
	{82716, 0x8},
	{74518, 0x70, 8, 3039},
	{82736, 0x80},
	{82752, 0x700, 8, 3039},
	{82764, 0x700000, 8, 3039},
	{82779, 0x40000000},
	{82813, 0x80000000},
	/* 1101 */
	{82848, 0x7},
	{82867, 0x70},
	{82883, 0x700},
	{82907, 0x7000},
	{82933, 0x10000},
	{82960, 0x20000},
	{82982, 0x40000},
	{83001, 0x80000},
	{83019, 0x100000},
	{83046, 0x200000},
	{83073, 0x7000000},
	{83098, 0x8000000},
	/* 1113 */
	{83129, 0x1},
	{83147, 0x8},
	{1318, 0x70, 8, 36013},
	{82420, 0xFF0000, 256, 36021},
	/* 1117 */
	{83567, 0x1},
	{83583, 0x2},
	{83614, 0x4},
	{73681, 0x30, 4, 36277},
	{83693, 0x40},
	{83705, 0x80},
	{83729, 0x100},
	{83748, 0x200},
	{83766, 0x400},
	{83779, 0x800},
	{83801, 0x1000},
	{83891, 0x6000, 4, 36281},
	{83913, 0x8000},
	{83931, 0x10000},
	{83962, 0x20000},
	{83981, 0x700000},
	{84006, 0x800000},
	/* 1134 */
	{84039, 0x1},
	{84049, 0x2},
	{84059, 0x4},
	{84069, 0x8},
	{84079, 0x10},
	{84089, 0x20},
	{84099, 0x2000},
	{84118, 0xC000},
	{84130, 0x10000},
	{84143, 0x20000},
	{84161, 0x40000},
	{84184, 0x80000},
	{84202, 0x100000},
	{84222, 0x200000},
	{84234, 0x400000},
	{84256, 0x1000000},
	{84280, 0x2000000},
	{84306, 0x4000000},
	{84325, 0x8000000},
	{84343, 0x10000000},
	/* 1154 */
	{84363, 0x1},
	{84374, 0x2},
	{19544, 0x4},
	{84394, 0x18, 2, 36285},
	{84460, 0xE0, 3, 36287},
	{84481, 0x700, 3, 36287},
	{84501, 0x800},
	{84526, 0x1000},
	{84550, 0x2000},
	{84574, 0x10000},
	{84599, 0x80000},
	{84618, 0x100000},
	{84633, 0x200000},
	{84651, 0x400000},
	{84689, 0x800000},
	{84712, 0x1000000},
	/* 1170 */
	{84733, 0x1},
	{84751, 0x2},
	{84770, 0x4},
	{84788, 0x8},
	{84807, 0x10},
	{84825, 0x20},
	{84844, 0x100},
	{84855, 0x200},
	{84865, 0x400},
	{84876, 0x800},
	/* 1180 */
	{84892, 0x1},
	{84908, 0x2},
	{84924, 0x4},
	{84940, 0x8},
	{84956, 0x10},
	{84972, 0x20},
	{84988, 0x40},
	{85004, 0x80},
	{85020, 0x100},
	{85036, 0x200},
	{85052, 0x400},
	{85068, 0x800},
	{85084, 0x1000},
	{85100, 0x2000},
	{85116, 0x4000},
	{85132, 0x8000},
	{85148, 0x10000},
	{85167, 0x20000},
	{85185, 0x40000},
	{85212, 0x80000},
	{85234, 0x100000},
	{85252, 0x200000},
	{85272, 0x400000},
	{85295, 0x800000},
	{85318, 0x1000000},
	{85343, 0x2000000},
	{85363, 0x4000000},
	{85386, 0x8000000},
	/* 1208 */
	{85405, 0x1},
	{85424, 0x2},
	{85442, 0x4},
	{85460, 0x8},
	{85478, 0x10},
	{85496, 0x20},
	{85513, 0x40},
	{85530, 0x80},
	{85551, 0x100},
	{85568, 0x200},
	{85585, 0x400},
	{85601, 0x800},
	{85617, 0x1000},
	{85633, 0x2000},
	{85649, 0x4000},
	{85674, 0x100000},
	/* 1224 */
	{85694, 0x3},
	{85713, 0x4},
	{85732, 0x8},
	{85749, 0x10},
	/* 1228 */
	{85764, 0x1},
	{85788, 0x2},
	{85808, 0x4},
	{85829, 0x8},
	{85854, 0x10},
	{85874, 0x20},
	{85890, 0x40},
	{85907, 0x80},
	{85928, 0xFF00},
	{85949, 0x40000000},
	{85970, 0x80000000},
	/* 1239 */
	{85992, 0x1},
	{85764, 0x2},
	{85788, 0x4},
	{85808, 0x8},
	{85829, 0x10},
	{86017, 0x20},
	{86030, 0x40},
	/* 1246 */
	{86059, 0x1},
	{86070, 0x2},
	/* 1248 */
	{86088, 0x1},
	{86105, 0x2},
	/* 1250 */
	{86129, 0x1},
	{86154, 0x2},
	{86175, 0x4},
	{86197, 0x8},
	{86223, 0x10},
	/* 1255 */
	{86240, 0x1E},
	{86252, 0xE0},
	{86266, 0xF00},
	{86282, 0x70000},
	{86293, 0x780000},
	/* 1260 */
	{70938, 0xFFFF},
	{70831, 0xFFFF0000},
	/* 1262 */
	{86306, 0xFFFF},
	{19217, 0xFFFF0000},
	/* 1264 */
	{70831, 0xFFFF},
	/* 1265 */
	{86315, 0xFFFF},
	{86328, 0xFF0000},
	{86341, 0x10000000},
	{86359, 0x60000000},
	/* 1269 */
	{86375, 0x7},
	/* 1270 */
	{86387, 0x3},
	/* 1271 */
	{18810, 0xFF},
	/* 1272 */
	{18832, 0x1F, 22, 36290},
	{86746, 0x4000},
	{86759, 0x8000},
	{86772, 0x70000},
	/* 1276 */
	{18852, 0xF},
	/* 1277 */
	{18858, 0xF},
	/* 1278 */
	{86783, 0x1},
	{86793, 0x2},
	{86803, 0x4},
	{86813, 0x8},
	{20043, 0xFF00},
	{86823, 0xFF0000},
	/* 1284 */
	{86829, 0xF},
	{14205, 0xF0},
	{86836, 0xF00},
	{75333, 0xF000},
	{86843, 0xF0000},
	{86850, 0xF00000},
	{86859, 0xF000000},
	{12137, 0xF0000000},
	/* 1292 */
	{1318, 0x7, 6, 36312},
	{86939, 0x8},
	{86995, 0x30, 4, 36318},
	{87004, 0x7C0},
	{87015, 0x800},
	{87028, 0x1000},
	{87039, 0x2000},
	{87051, 0x4000},
	{87064, 0x8000},
	{87082, 0x10000},
	{87098, 0x20000},
	{87117, 0x40000},
	{87131, 0x80000},
	{87149, 0x100000},
	{87167, 0x600000},
	/* 1307 */
	{87174, 0x7FF},
	{87194, 0x3FF800},
	{87214, 0xFFC00000},
	/* 1310 */
	{87238, 0x1},
	{87250, 0x2},
	{87271, 0x4},
	{87291, 0x8},
	{87316, 0x10},
	{87337, 0x20},
	{87360, 0x40},
	/* 1317 */
	{87390, 0x1},
	{87400, 0x2},
	{87415, 0x4},
	{87440, 0x8},
	{87458, 0x70},
	{87474, 0x80},
	{87479, 0x100},
	{87502, 0x200},
	{87521, 0x400},
	{87543, 0x800},
	{87559, 0x1000},
	{87575, 0x2000},
	{87591, 0x4000},
	{87610, 0x8000},
	{87636, 0x10000},
	{87651, 0x20000},
	{87691, 0x40000},
	{87718, 0x80000},
	{87741, 0xF00000},
	{87757, 0x1000000},
	{87787, 0x2000000},
	{87811, 0x4000000},
	{87832, 0x8000000},
	{87862, 0x70000000},
	/* 1341 */
	{19057, 0x7FF},
	/* 1342 */
	{19071, 0x7FF},
	/* 1343 */
	{19085, 0xF},
	/* 1344 */
	{879, 0x7FFF},
	/* 1345 */
	{87886, 0x3F, 4, 36322},
	{87899, 0x3F00, 4, 36322},
	{87914, 0x3F0000, 4, 36322},
	{87929, 0xFC00000, 4, 36322},
	{87944, 0x80000000},
	/* 1350 */
	{214, 0x3, 3, 36326},
	{88081, 0xC, 4, 36329},
	{88161, 0x30, 4, 36333},
	{88221, 0xC0, 3, 36337},
	{88234, 0x100},
	{82588, 0x200},
	{88238, 0x400},
	{88247, 0x3800},
	/* 1358 */
	{19260, 0x1},
	{88253, 0x2},
	{88274, 0x4},
	/* 1361 */
	{89457, 0x3F, 64, 36340},
	{64486, 0x7FFFC00},
	{89468, 0x8000000},
	/* 1364 */
	{19357, 0x1},
	{89483, 0x2},
	/* 1366 */
	{89498, 0x1},
	{89512, 0x2},
	{89528, 0x4},
	{89546, 0x8},
	{89562, 0x10},
	/* 1371 */
	{89573, 0xFFFF},
	{89588, 0x10000},
	{89607, 0x20000},
	{89621, 0x40000},
	{89640, 0x80000},
	{89654, 0x100000},
	/* 1377 */
	{19471, 0x7FFF},
	/* 1378 */
	{19507, 0x1},
	/* 1379 */
	{19521, 0x1},
	/* 1380 */
	{74912, 0x1},
	{89671, 0x2},
	{89682, 0x4},
	{89699, 0x8},
	{89716, 0x3F0},
	{89733, 0xFC00},
	{89750, 0x10000},
	{89774, 0x20000},
	{71479, 0x40000},
	/* 1389 */
	{89791, 0x7, 8, 3039},
	{89804, 0xFF0},
	{89818, 0xFF000},
	{73642, 0x1000000},
	/* 1393 */
	{89831, 0x7, 8, 3039},
	{89844, 0xFF0},
	{89858, 0xFF000},
	{73660, 0x1000000},
	/* 1397 */
	{10126, 0xFF},
	{10142, 0xFF00},
	{89871, 0xFF0000},
	{89877, 0xFF000000},
	/* 1401 */
	{20043, 0x3FF},
	/* 1402 */
	{20036, 0x1FF},
	/* 1403 */
	{20057, 0x7FF},
	/* 1404 */
	{89883, 0x1FF},
	{89899, 0x3FE00},
	/* 1406 */
	{89915, 0xFF},
	{89929, 0xFF00},
	{89939, 0xFF0000},
	{89950, 0x1F000000},
	{89962, 0xE0000000},
	/* 1411 */
	{90022, 0x3, 4, 36404},
	{90053, 0x4, 2, 36408},
	{20126, 0x18, 4, 36410},
	{90135, 0x20, 2, 36414},
	{90200, 0xC0, 4, 36416},
	{90206, 0x100},
	{72441, 0x200},
	{90217, 0x400},
	{90237, 0x800},
	{90257, 0x1000},
	{90271, 0x2000},
	{90282, 0x4000},
	{90298, 0x78000},
	{90318, 0x180000},
	{90333, 0x200000},
	{90343, 0x400000},
	{90353, 0x800000},
	{90363, 0x1000000},
	{90378, 0x2000000},
	/* 1430 */
	{90398, 0xFF},
	{90410, 0x3F00},
	{90426, 0xFC000},
	/* 1433 */
	{220, 0x3, 3, 36420},
	{90532, 0x1C, 4, 36423},
	{90609, 0xE0, 4, 36427},
	{90618, 0x100},
	{90638, 0x200},
	{90649, 0x3C00},
	{90671, 0x4000},
	{88221, 0x18000, 3, 36337},
	{90705, 0x60000, 4, 36431},
	{90764, 0x80000, 3, 36435},
	{90816, 0x100000, 3, 36438},
	{88247, 0x3800000},
	/* 1445 */
	{90828, 0x1},
	{90849, 0x300},
	{90871, 0xC00},
	{90893, 0x3000},
	{90915, 0xC000},
	{90937, 0x10000},
	/* 1451 */
	{90950, 0xFF},
	{90978, 0x100},
	/* 1453 */
	{10250, 0x1},
	{20483, 0x1FC},
	{91006, 0x80000000},
	/* 1456 */
	{91038, 0x1},
	{91053, 0x2},
	{91068, 0x4},
	{91083, 0x8},
	{91098, 0x70},
	{91110, 0x80},
	{91130, 0xF00},
	{91147, 0x80000000},
	/* 1464 */
	{91168, 0xF},
	{91187, 0xF0},
	{91206, 0xF00},
	{91225, 0xF000},
	/* 1468 */
	{91244, 0xF},
	{91255, 0xF0},
	{91266, 0xF00},
	{91277, 0xF000},
	{91288, 0xF0000},
	{91299, 0xF00000},
	{91310, 0xF000000},
	{91321, 0xF0000000},
	/* 1476 */
	{91332, 0xF},
	{91343, 0xF0},
	{91354, 0xF00},
	{91366, 0xF000},
	{91378, 0xF0000},
	{91390, 0xF00000},
	{91402, 0xF000000},
	{91414, 0xF0000000},
	/* 1484 */
	{91426, 0x200},
	{91444, 0x400},
	{91455, 0x800},
	{91480, 0x1000},
	{91502, 0x2000},
	/* 1489 */
	{91524, 0x7},
	{91541, 0x10},
	{91563, 0x1E000},
	{91579, 0x700000},
	{91600, 0x3000000},
	{91680, 0xC000000, 4, 36441},
	/* 1495 */
	{91706, 0x1},
	{91767, 0x6, 4, 36445},
	{91983, 0x38, 8, 36449},
	/* 1498 */
	{91994, 0xF},
	{91999, 0xF0},
	{92004, 0xF00},
	{92009, 0xF000},
	{92014, 0xF0000},
	{92019, 0xF00000},
	{92024, 0xF000000},
	{92029, 0xF0000000},
	/* 1506 */
	{92034, 0xF},
	{92039, 0xF0},
	{92044, 0xF00},
	{92049, 0xF000},
	{92054, 0xF0000},
	{92059, 0xF00000},
	{92064, 0xF000000},
	{92069, 0xF0000000},
	/* 1514 */
	{92074, 0xF},
	{92079, 0xF0},
	{92084, 0xF00},
	{92089, 0xF000},
	{92094, 0xF0000},
	{92100, 0xF00000},
	{92106, 0xF000000},
	{92112, 0xF0000000},
	/* 1522 */
	{92118, 0xF},
	{92124, 0xF0},
	{92130, 0xF00},
	{92136, 0xF000},
	{92142, 0xF0000},
	{92148, 0xF00000},
	{92154, 0xF000000},
	{92160, 0xF0000000},
	/* 1530 */
	{92166, 0xFFFF},
	{92179, 0xFFFF0000},
	/* 1532 */
	{92192, 0xFFFF},
	{92205, 0xFFFF0000},
	/* 1534 */
	{92218, 0x3},
	{71906, 0x4},
	{71928, 0x8},
	{92247, 0x60},
	/* 1538 */
	{92360, 0x3, 4, 36457},
	{92373, 0x4},
	{92384, 0x8},
	{92493, 0x70, 5, 36461},
	{92511, 0x380, 5, 36461},
	{92529, 0x1C00},
	{92552, 0x3E000},
	{92578, 0x40000},
	{92600, 0x7F80000},
	{92616, 0x8000000},
	{92638, 0x10000000},
	{92725, 0x60000000, 3, 36466},
	/* 1550 */
	{92742, 0xFFFF},
	{92758, 0xFFFF0000},
	/* 1552 */
	{92777, 0x1},
	{92794, 0x1E},
	{92818, 0x20},
	{92836, 0x3C0},
	{92861, 0x400},
	{92891, 0x800},
	{92906, 0x1000},
	{92921, 0x2000},
	{92956, 0x4000},
	{92992, 0x8000},
	{93082, 0x30000, 3, 36469},
	{93106, 0x40000},
	{93142, 0x80000},
	{93178, 0x100000},
	{93204, 0x200000},
	{93228, 0x400000},
	{93248, 0x800000},
	{93269, 0x1000000},
	{93294, 0x6000000},
	{93318, 0x18000000},
	/* 1572 */
	{93346, 0x7FF},
	{93367, 0xFF0000},
	/* 1574 */
	{93385, 0xFF},
	/* 1575 */
	{93401, 0x7F},
	/* 1576 */
	{93414, 0x7FF},
	{93423, 0x7FF00000},
	/* 1578 */
	{93414, 0x3FFFFF},
	/* 1579 */
	{73477, 0x1FFF},
	{73504, 0x3FFE000},
	{93438, 0x3C000000},
	/* 1582 */
	{93499, 0x3, 4, 36472},
	{17670, 0x7C, 32, 36476},
	{69574, 0x80},
	{94097, 0x700, 8, 36508},
	{94153, 0x1800, 4, 36516},
	{83196, 0x2000},
	{74097, 0x4000},
	{94163, 0x8000},
	{94175, 0x10000},
	{94188, 0x20000},
	{91767, 0x40000},
	{94201, 0x80000},
	{94428, 0x700000, 8, 36520},
	{94450, 0x3800000, 8, 36520},
	{94474, 0x4000000},
	{94500, 0x8000000},
	{94526, 0x10000000},
	{94594, 0x60000000, 3, 36528},
	{94610, 0x80000000},
	/* 1601 */
	{94624, 0x1F},
	{94640, 0x3E0},
	{94662, 0xC00},
	{74809, 0x7000},
	{94680, 0x18000},
	{94694, 0x20000},
	{94712, 0x40000},
	{94738, 0x80000},
	/* 1609 */
	{78137, 0x1},
	{94768, 0x2},
	{71420, 0xC, 3, 36531},
	{94882, 0x10, 2, 36534},
	{71448, 0x60},
	{71545, 0x180},
	{94908, 0x200},
	{94931, 0x3C00},
	{94951, 0x3C000},
	{78253, 0x40000},
	{94973, 0x80000},
	{95006, 0x100000},
	/* 1621 */
	{93414, 0x3FFF},
	/* 1622 */
	{95030, 0xFF},
	/* 1623 */
	{95040, 0x3FFF},
	{95052, 0xFFFC000},
	{71320, 0xF0000000},
	/* 1626 */
	{95063, 0x1FFF},
	{95074, 0x2000},
	{95086, 0x7C000},
	{95100, 0xF80000},
	{95114, 0x3000000},
	{95128, 0x4000000},
	{68821, 0x38000000},
	{95147, 0x40000000},
	/* 1634 */
	{10333, 0xFFFFFFFC},
	/* 1635 */
	{10362, 0xFFFF},
	/* 1636 */
	{24696, 0xFFFFFFFC},
	/* 1637 */
	{24718, 0xFFFF},
	/* 1638 */
	{25212, 0xFFFFFFFC},
	/* 1639 */
	{25234, 0xFFFF},
	/* 1640 */
	{95164, 0xFFFFFFC},
	/* 1641 */
	{95180, 0x6000000},
	/* 1642 */
	{95193, 0x1},
	/* 1643 */
	{95212, 0xFF},
	{95226, 0x30000},
	/* 1645 */
	{95240, 0xFFFFFFFC},
	/* 1646 */
	{95252, 0xFFFF},
	{95264, 0x10000},
	{95180, 0x6000000},
	{27021, 0xE0000000},
	/* 1650 */
	{26571, 0xFFFFFFFC},
	/* 1651 */
	{26589, 0xFFFF},
	{95180, 0xC00000},
	/* 1653 */
	{26643, 0xFFFFFFFC},
	/* 1654 */
	{26661, 0xFFFF},
	{95180, 0xC00000},
	/* 1656 */
	{95274, 0x3},
	{26701, 0xFFFFFFF8},
	/* 1658 */
	{26720, 0xFFFF},
	{95288, 0x10000},
	{95304, 0x100000},
	{95320, 0x3000000},
	{95336, 0xE0000000},
	/* 1663 */
	{95347, 0x400},
	{95360, 0x6000},
	{95377, 0x8000},
	{95389, 0x300000},
	{95400, 0x6000000},
	{95417, 0x8000000},
	{95429, 0x60000000},
	/* 1670 */
	{95440, 0xFF},
	/* 1671 */
	{95459, 0x3F},
	/* 1672 */
	{95477, 0x8},
	{95494, 0x10},
	{95511, 0x20},
	{95538, 0x8000},
	{95558, 0x40000},
	{95575, 0x400000},
	{95591, 0x800000},
	{95605, 0x2000000},
	{95619, 0x4000000},
	{95633, 0x8000000},
	{95654, 0x10000000},
	{95679, 0x20000000},
	{95700, 0x40000000},
	/* 1685 */
	{95724, 0x3000000},
	{1331, 0x80000000},
	/* 1687 */
	{26958, 0xFFFF},
	/* 1688 */
	{26999, 0xFFFF},
	/* 1689 */
	{95729, 0x3FFFFFF},
	{95740, 0x4000000},
	{95744, 0x8000000},
	{95748, 0x10000000},
	{95753, 0x20000000},
	{95758, 0x40000000},
	{95767, 0x80000000},
	/* 1696 */
	{95774, 0x1},
	{95794, 0x2},
	{95808, 0x30},
	{95820, 0x1FF0000},
	{95833, 0x10000000},
	{95848, 0x20000000},
	{95862, 0xC0000000},
	/* 1703 */
	{95872, 0x3FFFFFF},
	{95885, 0x10000000},
	/* 1705 */
	{95904, 0xFF},
	/* 1706 */
	{95923, 0xFF},
	/* 1707 */
	{95929, 0x1},
	{95943, 0x2},
	{95955, 0x10000},
	{95969, 0x1000000},
	/* 1711 */
	{2208, 0xFF},
	{63391, 0x80000000},
	/* 1713 */
	{27254, 0xFFFFF},
	/* 1714 */
	{27267, 0xFFFFF},
	/* 1715 */
	{27281, 0xFFFFF},
	/* 1716 */
	{27295, 0xFFFFF},
	/* 1717 */
	{27317, 0xFFFFF},
	/* 1718 */
	{27337, 0xFFFFF},
	/* 1719 */
	{27359, 0xFFFFF},
	/* 1720 */
	{95982, 0x3},
	{10333, 0xFFFFFFFC},
	/* 1722 */
	{10362, 0xFFFF},
	{95982, 0xFFFF0000},
	/* 1724 */
	{95987, 0xFFF},
	/* 1725 */
	{96002, 0xFFFFF},
	/* 1726 */
	{96016, 0xFFFFF},
	/* 1727 */
	{96030, 0xFFFFF},
	/* 1728 */
	{27675, 0xFFFFFFE0},
	/* 1729 */
	{27694, 0xFFFF},
	/* 1730 */
	{27713, 0xFFF},
	/* 1731 */
	{27730, 0xFFFFFFFC},
	/* 1732 */
	{27748, 0xFFFF},
	/* 1733 */
	{27766, 0xFFFFF},
	/* 1734 */
	{27782, 0xFFFFFFFC},
	/* 1735 */
	{27800, 0xFFFF},
	/* 1736 */
	{27818, 0xFFFFF},
	/* 1737 */
	{27917, 0xFFFFFFFC},
	/* 1738 */
	{27931, 0xFFFF},
	/* 1739 */
	{27945, 0xFFFFF},
	/* 1740 */
	{43280, 0xFFF000},
	{95180, 0x6000000},
	{96043, 0x8000000},
	{96056, 0x10000000},
	/* 1744 */
	{96064, 0x30000},
	{96072, 0x7000000},
	{96080, 0xE0000000},
	/* 1747 */
	{28011, 0xFFFFFFF},
	/* 1748 */
	{28022, 0xFFFFFFFC},
	/* 1749 */
	{28036, 0xFFFF},
	/* 1750 */
	{28050, 0xFFFFF},
	/* 1751 */
	{96089, 0xFFFFF},
	/* 1752 */
	{1331, 0x3},
	/* 1753 */
	{28200, 0x1},
	/* 1754 */
	{96102, 0x1},
	{96116, 0x2},
	{96133, 0x4},
	{96149, 0x8},
	{96164, 0x10},
	{96183, 0x20},
	{96201, 0x40},
	{96222, 0x80},
	/* 1762 */
	{96243, 0x1},
	{96259, 0x2},
	{96275, 0x40},
	{96293, 0x80},
	{96311, 0x100},
	{96329, 0x200},
	{96347, 0x400},
	{96365, 0x800},
	{96383, 0x1000},
	{96401, 0x2000},
	{96419, 0x4000},
	{96436, 0x80000},
	{96452, 0x200000},
	/* 1775 */
	{96468, 0xFF},
	{1331, 0x80000000},
	/* 1777 */
	{96486, 0xF},
	{96498, 0xF0},
	{96507, 0xF00},
	{96516, 0xF000},
	{96526, 0x30000},
	{96536, 0xC0000},
	{10250, 0x100000},
	{10733, 0xFFE00000},
	/* 1785 */
	{96543, 0xFF},
	{96507, 0xFF00},
	{96498, 0xFF0000},
	{96558, 0x20000000},
	{96578, 0x40000000},
	{96604, 0x80000000},
	/* 1791 */
	{18832, 0x3F, 22, 36290},
	/* 1792 */
	{38, 0xFFFF},
	/* 1793 */
	{96624, 0x1FF},
	{96690, 0x600, 4, 36536},
	/* 1795 */
	{89573, 0xFFFF},
	{89588, 0x10000},
	{89607, 0x20000},
	{89621, 0x40000},
	{89640, 0x80000},
	{89654, 0x100000},
	{96710, 0x200000},
	{96728, 0x400000},
	{96744, 0x800000},
	/* 1804 */
	{96756, 0x1FF},
	{96770, 0x3FE00},
	{96784, 0x40000},
	{96802, 0x80000},
	/* 1808 */
	{96819, 0x7},
	{96828, 0x78},
	{96837, 0x100},
	/* 1811 */
	{96847, 0x1},
	{96858, 0x7FE},
	/* 1813 */
	{96871, 0x1},
	{96885, 0x2},
	{96899, 0x4},
	/* 1816 */
	{29363, 0xFFFFFF},
	/* 1817 */
	{96913, 0xF},
	{96925, 0xFF00},
	/* 1819 */
	{456, 0xFFFF},
	{102, 0xFFFF0000},
	/* 1821 */
	{96939, 0x1},
	{96960, 0x2},
	/* 1823 */
	{96988, 0x3FFF},
	/* 1824 */
	{96996, 0x3FFF},
	/* 1825 */
	{2195, 0xFFFF},
	/* 1826 */
	{97004, 0x1},
	{97016, 0x2},
	{97028, 0x4},
	{30138, 0x8},
	{72721, 0x10},
	{30563, 0x10000},
	{97039, 0x60000},
	/* 1833 */
	{97052, 0x1},
	{74028, 0x2},
	/* 1835 */
	{25290, 0x7FFFFFFF},
	/* 1836 */
	{97056, 0x3F},
	{97061, 0xC0},
	{97069, 0x300},
	{97075, 0xFFFFFC00},
	/* 1840 */
	{30563, 0x1},
	{96536, 0xFFFFFFFE},
	/* 1842 */
	{8, 0xFFFF},
	{96536, 0xFFFF0000},
	/* 1844 */
	{38, 0xFFFF},
	{96536, 0xFFFF0000},
	/* 1846 */
	{30641, 0xFF},
	{96536, 0xFFFFFF00},
	/* 1848 */
	{30658, 0xFF},
	{96536, 0xFFFFFF00},
	/* 1850 */
	{1, 0xFF},
	{96536, 0xFFFFFF00},
	/* 1852 */
	{452, 0x3F},
	{96536, 0xFFFFFFC0},
	/* 1854 */
	{85180, 0x1},
	{983, 0x1FFE},
	{220, 0x2000},
	{93061, 0x4000},
	{97083, 0x8000},
	{97095, 0x7FF0000},
	{97106, 0x8000000},
	{97117, 0x10000000},
	{97127, 0x20000000},
	{97061, 0xC0000000},
	/* 1864 */
	{30862, 0xFFFF},
	{96536, 0xFFFF0000},
	/* 1866 */
	{452, 0xF},
	{96536, 0xFFFFFFF0},
	/* 1868 */
	{97134, 0xFFFF},
	{97145, 0xF0000},
	{97158, 0xF00000},
	{96536, 0x3F000000},
	{97166, 0x40000000},
	{10250, 0x80000000},
	/* 1874 */
	{29376, 0x7FFFFFFF},
	{30924, 0x80000000},
	/* 1876 */
	{31470, 0xFFFF},
	/* 1877 */
	{31474, 0xFFFF},
	{97175, 0xFFFF0000},
	/* 1879 */
	{97189, 0x3FF},
	{97198, 0xFFC00},
	{50401, 0xF00000},
	{97208, 0xF000000},
	{97219, 0xF0000000},
	/* 1884 */
	{97230, 0x3FF},
	{97240, 0xFFC00},
	{97250, 0xF000000},
	{97261, 0xF0000000},
	/* 1888 */
	{97481, 0xF, 6, 36540},
	{97716, 0xF0, 6, 36546},
	{97889, 0x300, 4, 36552},
	{97909, 0x400},
	/* 1892 */
	{452, 0x7},
	{74507, 0x40000000},
	{10250, 0x80000000},
	/* 1895 */
	{452, 0x1F},
	{74507, 0x40000000},
	{10250, 0x80000000},
	/* 1898 */
	{452, 0xF},
	{11600, 0x40000000},
	{10250, 0x80000000},
	/* 1901 */
	{452, 0x1F},
	{11600, 0x40000000},
	{10250, 0x80000000},
	/* 1904 */
	{11565, 0xFFFF},
	{11585, 0xFFFF0000},
	/* 1906 */
	{97931, 0x1},
	{97958, 0x2},
	{97985, 0x4},
	{1318, 0x100},
	/* 1910 */
	{97189, 0x3F},
	{98008, 0x400},
	{98035, 0x800},
	{98062, 0x2000},
	{98088, 0x4000},
	{98114, 0x10000},
	{98141, 0x20000},
	{98167, 0x40000},
	{98193, 0x80000},
	{98221, 0x100000},
	{98247, 0x200000},
	{98273, 0x400000},
	{98299, 0x1000000},
	{98326, 0x2000000},
	{98353, 0x4000000},
	{98380, 0x8000000},
	{98407, 0x10000000},
	{98433, 0x20000000},
	{98462, 0x40000000},
	{98488, 0x80000000},
	/* 1930 */
	{97189, 0x3F},
	{98008, 0x400},
	{98035, 0x800},
	{98062, 0x1000},
	{98088, 0x2000},
	{98114, 0x8000},
	{98141, 0x10000},
	{98221, 0x20000},
	{98247, 0x40000},
	{98167, 0x100000},
	{98326, 0x200000},
	{98488, 0x400000},
	{98515, 0x800000},
	{98380, 0x1000000},
	{98544, 0x2000000},
	/* 1945 */
	{98515, 0x2},
	{98573, 0x4},
	{98602, 0x8},
	{98630, 0x10},
	{98656, 0x20},
	{98682, 0x40},
	{98709, 0x80},
	{98544, 0x100},
	/* 1953 */
	{98736, 0x3FF},
	{97198, 0xFFC00},
	{98746, 0xF00000},
	{98756, 0xF000000},
	{98767, 0xF0000000},
	/* 1958 */
	{97230, 0x3FF},
	{97240, 0xFFC00},
	{98778, 0xF000000},
	{98789, 0xF0000000},
	/* 1962 */
	{98736, 0x3FF},
	{98800, 0xF0000000},
	/* 1964 */
	{97189, 0x3FF},
	{97198, 0xFFC00},
	{98746, 0xF00000},
	{98767, 0xF000000},
	{98800, 0xF0000000},
	/* 1969 */
	{97230, 0x3FF},
	{97240, 0xFFC00},
	{98789, 0xF000000},
	{98778, 0xF0000000},
	/* 1973 */
	{98810, 0xF},
	{98819, 0xF0},
	{98828, 0xF00},
	{98837, 0xF000},
	{98846, 0xF0000},
	{98855, 0xF00000},
	{98864, 0xF000000},
	{98873, 0xF0000000},
	/* 1981 */
	{97189, 0x1FF},
	{98882, 0xF000},
	{50401, 0xF00000},
	{98800, 0xF0000000},
	/* 1985 */
	{60011, 0x1},
	{90200, 0x2, 4, 36416},
	{90135, 0x4, 2, 36414},
	{20126, 0x8, 4, 36410},
	{90053, 0x10, 2, 36408},
	{90022, 0x20, 4, 36404},
	{98896, 0x40},
	{98902, 0x300},
	{98912, 0x2000},
	/* 1994 */
	{98926, 0x1},
	/* 1995 */
	{98935, 0x3},
	{98949, 0xC},
	{98963, 0x30},
	{98977, 0xC0},
	{98991, 0xF00},
	{99006, 0xF000},
	{99021, 0xF0000},
	{99036, 0xF00000},
	/* 2003 */
	{37215, 0x3FF},
	{99051, 0xFFC00},
	{98746, 0xF00000},
	/* 2006 */
	{99071, 0x3FF},
	{99091, 0xFFC00},
	/* 2008 */
	{97189, 0xFF},
	{97198, 0x3FC00},
	{98746, 0xF00000},
	{98767, 0xF000000},
	{98800, 0xF0000000},
	/* 2013 */
	{97230, 0xFF},
	{97240, 0x3FC00},
	{98789, 0xF000000},
	{98778, 0xF0000000},
	/* 2017 */
	{97189, 0xFF},
	{98746, 0xF00000},
	{98800, 0xF0000000},
	/* 2020 */
	{97189, 0x3FF},
	{98746, 0xF00000},
	{98800, 0xF0000000},
	/* 2023 */
	{99111, 0x1},
	{99346, 0xE, 6, 36556},
	{99360, 0x10},
	{99381, 0x3E0},
	{99399, 0x400},
	{99484, 0x800, 2, 36562},
	{99501, 0x1000},
	{99519, 0xE000},
	{99534, 0x20000},
	{99560, 0x1C0000},
	{99583, 0x200000},
	{99611, 0xC00000},
	/* 2035 */
	{97189, 0x1FF},
	{97198, 0x7FC00},
	{98746, 0xF00000},
	{98767, 0xF000000},
	{98800, 0xF0000000},
	/* 2040 */
	{97230, 0x1FF},
	{97240, 0x7FC00},
	{98789, 0xF000000},
	{98778, 0xF0000000},
	/* 2044 */
	{97189, 0x1FF},
	{98800, 0xF0000000},
	/* 2046 */
	{69984, 0xFFF},
	{99636, 0x3000},
	{10733, 0xC000},
	{99654, 0xFFFF0000},
	/* 2050 */
	{40517, 0xFFFF},
	{10733, 0xFFFF0000},
	/* 2052 */
	{40564, 0xFF},
	{69984, 0x700},
	{99678, 0xF800},
	{99694, 0x1F0000},
	{99707, 0x3E00000},
	{99720, 0x7C000000},
	{10733, 0x80000000},
	/* 2059 */
	{99733, 0xFF},
	{10733, 0xFFFFFF00},
	/* 2061 */
	{99755, 0x1FF},
	{10733, 0xFFFFFE00},
	/* 2063 */
	{99755, 0xFF},
	{10733, 0xFFFFFF00},
	/* 2065 */
	{40738, 0x7F},
	{10733, 0xFFFFFF80},
	/* 2067 */
	{40763, 0x7F},
	{10733, 0xFFFFFF80},
	/* 2069 */
	{40791, 0x7F},
	{10733, 0xFFFFFF80},
	/* 2071 */
	{40819, 0x7F},
	{10733, 0xFFFFFF80},
	/* 2073 */
	{40842, 0x7F},
	{10733, 0xFFFFFF80},
	/* 2075 */
	{99772, 0x7F},
	{10733, 0xFFFFFF80},
	/* 2077 */
	{10733, 0x1F},
	{99777, 0xFFFFFFE0},
	/* 2079 */
	{99796, 0x7F},
	{10733, 0xFFFFFF80},
	/* 2081 */
	{99796, 0x1FF},
	{10733, 0xFFFFFE00},
	/* 2083 */
	{99772, 0xFF},
	{10733, 0xFFFFFF00},
	/* 2085 */
	{99801, 0xFF},
	{99822, 0x100},
	{99832, 0x200},
	{99840, 0x400},
	{99854, 0x800},
	{99865, 0x1000},
	{99884, 0x2000},
	{99908, 0x4000},
	{99922, 0x8000},
	{10733, 0xFFFF0000},
	/* 2095 */
	{99932, 0x1},
	{99956, 0x2},
	{99980, 0x4},
	{99997, 0x8},
	{100014, 0x10},
	{100033, 0x20},
	{100050, 0x3C0},
	{10733, 0xFFFFFC00},
	/* 2103 */
	{100065, 0x1},
	{100077, 0x2},
	{100089, 0x4},
	{100099, 0x8},
	{100120, 0x10},
	{100137, 0x20},
	{100154, 0x40},
	{10733, 0xFFFFFF80},
	/* 2111 */
	{100178, 0xFFFF},
	{10733, 0xFFFF0000},
	/* 2113 */
	{100188, 0xFF},
	{10733, 0xFFFFFF00},
	/* 2115 */
	{100205, 0x7FFFF},
	{10733, 0xFFF80000},
	/* 2117 */
	{99694, 0xFF},
	{99707, 0xFF00},
	{99720, 0xFF0000},
	{100220, 0xFF000000},
	/* 2121 */
	{40564, 0xFF},
	{99678, 0xFF00},
	{10733, 0xFFFF0000},
	/* 2124 */
	{100233, 0x1},
	/* 2125 */
	{100257, 0x1},
	/* 2126 */
	{97481, 0x7, 6, 36540},
	{97909, 0x400},
	/* 2128 */
	{37215, 0xFF},
	/* 2129 */
	{10250, 0x1},
	{100275, 0x2},
	{19313, 0x4},
	{10733, 0xFFFFFFF8},
	/* 2133 */
	{71649, 0xF},
	{100287, 0x30},
	{10733, 0xFFFFFFC0},
	/* 2136 */
	{100294, 0x1},
	/* 2137 */
	{100314, 0x3},
	{100338, 0xC},
	{100362, 0x30},
	{100377, 0xC0},
	{100401, 0x300},
	{100425, 0x3C00},
	{100442, 0x7C000},
	{100460, 0x1F80000},
	{100496, 0x2000000},
	{100512, 0x4000000},
	/* 2147 */
	{97189, 0xFF},
	{100530, 0xFF00},
	{98800, 0xF000000},
	{10250, 0x10000000},
	{11600, 0x20000000},
	/* 2152 */
	{100543, 0xF},
	{100563, 0xFF00},
	{100577, 0xFF0000},
	{100590, 0x1000000},
	{100601, 0x2000000},
	{100611, 0x4000000},
	/* 2158 */
	{97189, 0x1FF},
	{98800, 0xF000000},
	{100632, 0xF0000000},
	/* 2161 */
	{97189, 0x3FF},
	{100642, 0xF0000000},
	/* 2163 */
	{96064, 0xF00, 6, 36564},
	{100694, 0x10000},
	{100706, 0x100000},
	{100721, 0xC0000000, 4, 36570},
	/* 2167 */
	{100732, 0xFFFFF},
	{100740, 0x100000},
	{100746, 0x200000},
	{59233, 0x800000},
	/* 2171 */
	{43268, 0xFFFFFFFF},
	/* 2172 */
	{26958, 0xFFFF},
	{96064, 0x300000, 4, 36574},
	{100769, 0x8000000, 2, 36570},
	{100791, 0x60000000, 4, 36578},
	{100799, 0x80000000},
	/* 2177 */
	{43152, 0xFFFFFFFF},
	/* 2178 */
	{95729, 0x3FFFFFF},
	{95740, 0x4000000, 2, 36582},
	{95744, 0x8000000, 2, 36582},
	{95748, 0x10000000, 2, 36584},
	{95753, 0x20000000, 2, 36584},
	{95758, 0x40000000},
	{100837, 0x80000000},
	/* 2185 */
	{89457, 0x3F},
	{100856, 0xF00},
	{100868, 0x1000},
	{100875, 0x2000},
	{100883, 0x4000},
	{100891, 0x8000},
	{100899, 0x10000},
	{100922, 0x60000, 4, 36586},
	{100947, 0x80000},
	{100959, 0x100000},
	{100967, 0x200000},
	{101011, 0xC00000, 3, 36590},
	/* 2197 */
	{100769, 0x1, 2, 36570},
	{95360, 0x6000},
	{96064, 0x300000, 4, 36574},
	{95400, 0x6000000},
	{100791, 0x60000000, 4, 36578},
	{100799, 0x80000000},
	/* 2203 */
	{101056, 0x3, 4, 36593},
	{101072, 0xC, 4, 36597},
	{100868, 0x10},
	{100875, 0x20},
	{101097, 0x40},
	{101104, 0x80},
	{100883, 0x100},
	{100891, 0x200},
	{100899, 0x400},
	{100922, 0x1800, 4, 36586},
	{100947, 0x2000},
	{100959, 0x4000},
	{100967, 0x8000},
	{101011, 0x30000, 3, 36590},
	{101112, 0x40000},
	/* 2218 */
	{101124, 0xFFFFF},
	/* 2219 */
	{59548, 0x1FF, 257, 0},
	{59553, 0x400},
	{59561, 0x800},
	{59574, 0x7000},
	{59582, 0x8000},
	{59593, 0xF0000},
	{59604, 0xF00000},
	{59620, 0x1000000},
	{101134, 0x10000000},
	{59646, 0xE0000000},
	/* 2229 */
	{59805, 0xF},
	{59812, 0x70},
	{59820, 0x80},
	{59834, 0xF00},
	{59843, 0x7000},
	{59870, 0xC00000},
	{59880, 0x1000000},
	{59906, 0xFC000000},
	/* 2237 */
	{43342, 0xFFFFF},
	/* 2238 */
	{60113, 0xF},
	{60136, 0x10},
	{60159, 0x20},
	{60182, 0x40},
	{60202, 0x80},
	{60222, 0x100},
	{60242, 0x200},
	{60262, 0x400},
	{60282, 0x800},
	{60302, 0x1000},
	{60322, 0x2000},
	{60342, 0x4000},
	{60357, 0x8000},
	{60368, 0x10000},
	{60376, 0x20000},
	{60385, 0x40000},
	{101144, 0x80000},
	{60417, 0x100000},
	{60430, 0x200000},
	{60440, 0x400000},
	{60457, 0x800000},
	{101164, 0x1000000},
	{101181, 0x2000000},
	{60474, 0x4000000},
	{60483, 0x8000000},
	{60492, 0x10000000},
	{60501, 0x20000000},
	{60510, 0x40000000},
	{60519, 0x80000000},
	/* 2267 */
	{60530, 0xF},
	{60569, 0x80},
	{60592, 0x100},
	{60615, 0x200},
	{60634, 0x1000},
	{60643, 0x2000},
	{60652, 0x4000},
	{60660, 0x8000},
	{60669, 0x10000},
	{60684, 0x100000},
	{60692, 0x200000},
	{60700, 0x400000},
	{60709, 0x800000},
	{60718, 0x1000000},
	{60726, 0x2000000},
	{60734, 0x4000000},
	{60742, 0x10000000},
	{60484, 0x20000000},
	{60760, 0x40000000},
	{60768, 0x80000000},
	/* 2287 */
	{43356, 0xFFFF},
	/* 2288 */
	{63924, 0x7FF, 2049, 257},
	{101198, 0x1000},
	{64086, 0xFF0000, 129, 2306},
	{64098, 0x3000000},
	{101223, 0x1C000000},
	{64111, 0x80000000},
	/* 2294 */
	{1318, 0x3},
	{64126, 0x4},
	{64135, 0x8},
	{64146, 0x10},
	{64159, 0x20},
	{53894, 0x1C0},
	{64173, 0x200},
	{64186, 0x400},
	{64199, 0x800},
	{64211, 0x1000},
	{64229, 0x2000},
	{64240, 0xC000},
	{64255, 0x30000},
	{64263, 0x40000},
	{64282, 0x80000},
	{101235, 0x700000},
	{101250, 0x10000000},
	{101273, 0x20000000},
	{64299, 0x40000000},
	{64311, 0x80000000},
	/* 2314 */
	{64325, 0xFFF},
	{64340, 0xFFF000},
	{64352, 0x1000000},
	{60363, 0x2000000},
	{64360, 0x4000000},
	{64380, 0x8000000},
	{101289, 0xF0000000},
	/* 2321 */
	{101300, 0x1},
	{101310, 0x2},
	{101320, 0x10},
	/* 2324 */
	{64526, 0x7},
	{64536, 0x38},
	{64546, 0x1C0},
	{64556, 0xE00},
	{17670, 0x7F000, 293, 2468},
	{68793, 0x600000},
	{68806, 0x800000},
	{68821, 0x1000000},
	{101348, 0xC000000},
	{68927, 0x30000000, 4, 2761},
	{220, 0xC0000000},
	/* 2335 */
	{69313, 0x1FFFFF},
	{69332, 0xE00000},
	{69351, 0x1000000},
	{69373, 0x2000000},
	{101360, 0x4000000},
	{69411, 0x8000000},
	{69428, 0x10000000},
	{69446, 0x20000000},
	{69462, 0xC0000000},
	/* 2344 */
	{69483, 0x7},
	{69493, 0x38},
	{69514, 0xC0},
	{101383, 0x700},
	{69535, 0x180000},
	{69554, 0xC000000},
	/* 2350 */
	{18816, 0x1FFF},
	{101392, 0x2000},
	{71297, 0x1FFF0000},
	/* 2353 */
	{71308, 0xF},
	{71320, 0xF0},
	{71328, 0xFFF00},
	{71341, 0x700000},
	{71350, 0x800000},
	{71365, 0x2000000},
	{71380, 0x4000000},
	{75272, 0x80000000},
	/* 2361 */
	{71392, 0xFF},
	{101348, 0x300},
	{71408, 0x400},
	{71420, 0x18000},
	{71448, 0x60000},
	{71474, 0x80000},
	{71492, 0x100000},
	{71514, 0x200000},
	{71529, 0x400000},
	{71545, 0x800000},
	{71561, 0xFF000000},
	/* 2372 */
	{71699, 0x3F},
	{71705, 0x3C0},
	{69323, 0xC00},
	{71795, 0xFF000, 193, 2834},
	{59410, 0x100000},
	{59203, 0x200000},
	{71806, 0x800000},
	{71816, 0x1000000},
	{71833, 0x2000000},
	{60083, 0x4000000},
	{101402, 0x8000000},
	{59354, 0x20000000},
	/* 2384 */
	{73088, 0x1},
	{73107, 0x2},
	{73128, 0x4},
	{73139, 0x8},
	{73152, 0x10},
	{73171, 0x20},
	{73196, 0x40},
	{73219, 0x80},
	{73233, 0xF00},
	{73245, 0x1000},
	{101421, 0x2000},
	/* 2395 */
	{74162, 0x3, 4, 3035},
	{74191, 0x1C},
	{74222, 0x20},
	{74258, 0x40},
	{74293, 0x80},
	{74321, 0x100},
	{74343, 0x200},
	{74361, 0x400},
	{74393, 0x800},
	{74514, 0x7000, 8, 3039},
	{74524, 0x38000},
	{74537, 0x1C0000},
	{74550, 0x200000},
	{74566, 0x400000},
	{74584, 0x800000},
	{74602, 0x2000000},
	{101439, 0x4000000},
	{101459, 0x18000000},
	/* 2413 */
	{101605, 0x7, 5, 36601},
	{101637, 0x30},
	{101657, 0xC0},
	/* 2416 */
	{75120, 0x3, 4, 3061},
	{75132, 0xC, 4, 3061},
	{75144, 0x30, 4, 3061},
	{75160, 0xC0, 4, 3061},
	{75230, 0x30000, 4, 3065},
	{75242, 0xC0000, 4, 3065},
	{75254, 0x300000, 4, 3065},
	{75270, 0x1000000},
	{75281, 0x2000000},
	{101677, 0x4000000},
	{101687, 0x8000000},
	{101697, 0x10000000},
	{101711, 0x20000000},
	/* 2429 */
	{10250, 0x1},
	{77813, 0x6},
	{69554, 0x60},
	{77855, 0x3000},
	{77862, 0x30000},
	{77876, 0x300000},
	/* 2435 */
	{77983, 0x3, 4, 3061},
	{77999, 0xC, 4, 3061},
	{78015, 0x30, 4, 3061},
	{78029, 0xC0, 4, 3061},
	{78045, 0x30000, 4, 3065},
	{78061, 0xC0000, 4, 3065},
	{78077, 0x300000, 4, 3065},
	{78091, 0xC00000, 4, 3065},
	{101726, 0x1000000},
	{101742, 0x2000000},
	{101758, 0x4000000},
	{101772, 0x8000000},
	{78107, 0x40000000},
	{78122, 0x80000000},
	/* 2449 */
	{879, 0x3F},
	{78892, 0x300},
	{78904, 0x400},
	{101788, 0x800},
	{78915, 0x1E000},
	{78924, 0x20000},
	{78938, 0x40000},
	{78942, 0x80000},
	{78959, 0x100000},
	{78977, 0x600000},
	{78995, 0x800000},
	{79015, 0x1000000},
	{79027, 0x2000000},
	/* 2462 */
	{879, 0x3F},
	{78892, 0x300},
	{78904, 0x400},
	{101788, 0x800},
	{78938, 0x40000},
	{78942, 0x80000},
	{78959, 0x100000},
	{78977, 0x600000},
	{79015, 0x1000000},
	{79027, 0x2000000},
	/* 2472 */
	{79039, 0x3E},
	{79055, 0x40},
	{79068, 0x80},
	{101802, 0x1F00},
	/* 2476 */
	{79589, 0x3F},
	{79610, 0x80},
	{79627, 0x100},
	{101820, 0x3E00},
	{79643, 0x4000},
	{79663, 0x8000},
	/* 2482 */
	{101836, 0x1},
	{101861, 0x2},
	{101886, 0x4},
	{101911, 0x8},
	{101936, 0x10},
	{101961, 0x20},
	{101986, 0x40},
	{102011, 0x80},
	/* 2490 */
	{80609, 0xF, 12, 36606},
	{80614, 0xF0, 12, 36606},
	{80619, 0xF00, 12, 36606},
	{80624, 0xF000, 12, 36606},
	{80629, 0xF0000, 12, 36606},
	{80634, 0xF00000, 12, 36606},
	{80639, 0xF000000, 12, 36606},
	{80644, 0xF0000000, 12, 36606},
	/* 2498 */
	{82516, 0x3, 4, 36007},
	{82562, 0xC, 2, 36011},
	{82573, 0x10},
	{82588, 0x20},
	{82596, 0x40},
	{82638, 0xE0000000},
	/* 2504 */
	{83129, 0x1},
	{102058, 0x2},
	{83147, 0x8},
	{1318, 0x70, 8, 36013},
	{82420, 0xFF0000, 256, 36021},
	/* 2509 */
	{84892, 0x1},
	{84908, 0x2},
	{84924, 0x4},
	{84940, 0x8},
	{84956, 0x10},
	{84972, 0x20},
	{84988, 0x40},
	{85004, 0x80},
	{85020, 0x100},
	{85036, 0x200},
	{85052, 0x400},
	{85068, 0x800},
	{85084, 0x1000},
	{85100, 0x2000},
	{85116, 0x4000},
	{85132, 0x8000},
	{85148, 0x10000},
	{85167, 0x20000},
	{85185, 0x40000},
	{85212, 0x80000},
	{85234, 0x100000},
	{85252, 0x200000},
	{85272, 0x400000},
	{85295, 0x800000},
	{85318, 0x1000000},
	{85343, 0x2000000},
	{85386, 0x8000000},
	{102081, 0x10000000},
	{102098, 0x20000000},
	{102123, 0x40000000},
	/* 2539 */
	{86088, 0x1},
	{86105, 0x2},
	{102149, 0x3FC},
	/* 2542 */
	{102168, 0x7, 5, 36601},
	{102194, 0x38, 5, 36601},
	{102223, 0x1C0, 5, 36601},
	{102248, 0xE00, 5, 36601},
	{102274, 0x2000},
	{102297, 0x4000},
	/* 2548 */
	{87238, 0x1},
	{87250, 0x2},
	{87271, 0x4},
	{87291, 0x8},
	{87337, 0x20},
	{87360, 0x40},
	/* 2554 */
	{214, 0x3, 3, 36326},
	{88081, 0xC, 4, 36329},
	{88161, 0x30, 4, 36333},
	{88221, 0xC0, 3, 36337},
	{88234, 0x100},
	{82588, 0x200},
	{88238, 0x400},
	{88247, 0x3800},
	{102324, 0x4000},
	/* 2563 */
	{89512, 0x2},
	{89546, 0x8},
	{89562, 0x10},
	{102349, 0x40},
	/* 2567 */
	{74912, 0x1},
	{89671, 0x2},
	{89682, 0x4},
	{89699, 0x8},
	{89716, 0x3F0},
	{89733, 0xFC00},
	{89750, 0x10000},
	{89774, 0x20000},
	{71479, 0x40000},
	{102427, 0x180000, 3, 36618},
	/* 2577 */
	{90022, 0x3, 4, 36404},
	{90053, 0x4, 2, 36408},
	{20126, 0x18, 4, 36410},
	{90135, 0x20, 2, 36414},
	{90200, 0xC0, 4, 36416},
	{90206, 0x100},
	{72441, 0x200},
	{90217, 0x400},
	{90237, 0x800},
	{90257, 0x1000},
	{90271, 0x2000},
	{90282, 0x4000},
	{90298, 0x78000},
	{90318, 0x180000},
	{90333, 0x200000},
	{90343, 0x400000},
	{90353, 0x800000},
	{90363, 0x1000000},
	{90378, 0x2000000},
	{102446, 0x4000000},
	/* 2597 */
	{91524, 0x7},
	{91541, 0x10},
	{91563, 0x1E000},
	{91579, 0x700000},
	{91600, 0x3000000},
	{91680, 0xC000000, 4, 36441},
	{102470, 0x10000000},
	{102495, 0x20000000},
	/* 2605 */
	{93499, 0x3, 4, 36472},
	{17670, 0x7C, 25, 36621},
	{69574, 0x80},
	{94097, 0x700, 8, 36508},
	{94153, 0x1800, 4, 36516},
	{83196, 0x2000},
	{74097, 0x4000},
	{94163, 0x8000},
	{94175, 0x10000},
	{94188, 0x20000},
	{91767, 0x40000},
	{94201, 0x80000},
	{94428, 0x700000, 8, 36520},
	{94450, 0x3800000, 8, 36520},
	{94474, 0x4000000},
	{94500, 0x8000000},
	{94526, 0x10000000},
	{94594, 0x60000000, 3, 36528},
	{102536, 0x80000000},
	/* 2624 */
	{78137, 0x1},
	{94768, 0x2},
	{71420, 0xC, 3, 36531},
	{94882, 0x10, 2, 36534},
	{71448, 0x60},
	{71545, 0x180},
	{94908, 0x200},
	{94931, 0x3C00},
	{94951, 0x3C000},
	{78253, 0x40000},
	{94973, 0x80000},
	{95006, 0x100000},
	{102547, 0x200000},
	{102567, 0x400000},
	/* 2638 */
	{95063, 0x1FFF},
	{95074, 0x2000},
	{95086, 0x7C000},
	{95100, 0xF80000},
	{95114, 0x3000000},
	{95128, 0x4000000},
	{68821, 0x38000000},
	{95147, 0x40000000},
	{102588, 0x80000000},
	/* 2647 */
	{102609, 0xFFFFFF},
	{10482, 0x7000000},
	{102615, 0x8000000},
	{1, 0x70000000},
	{102626, 0x80000000},
	/* 2652 */
	{102637, 0x1},
	{26701, 0xFFFFFFF8},
	/* 2654 */
	{95929, 0x1},
	{95943, 0x2},
	{102646, 0x8000},
	{95955, 0x10000},
	{95969, 0x1000000},
	/* 2659 */
	{96064, 0x30000},
	{102661, 0x300000},
	{102676, 0xC00000},
	{96072, 0x7000000},
	{96080, 0xE0000000},
	/* 2664 */
	{214, 0x3, 3, 36326},
	{102324, 0x4000},
	/* 2666 */
	{96624, 0x3FF},
	{96690, 0xC00, 4, 36536},
	/* 2668 */
	{101650, 0x3},
	{101670, 0x30},
	/* 2670 */
	{97004, 0x1},
	{97016, 0x2},
	{97028, 0x4},
	{30563, 0x10000},
	{97039, 0x60000},
	/* 2675 */
	{85180, 0x1},
	{983, 0x1FFE},
	{220, 0x2000},
	{93061, 0x4000},
	{97083, 0x8000},
	{97095, 0x7FF0000},
	{97106, 0x8000000},
	{97117, 0x10000000},
	{97127, 0x20000000},
	{102686, 0x40000000},
	{97061, 0x80000000},
	/* 2686 */
	{97189, 0x1FF},
	{50401, 0xF00000},
	{98800, 0xF0000000},
	/* 2689 */
	{60011, 0x1},
	{90200, 0x2, 4, 36416},
	{90135, 0x4, 2, 36414},
	{20126, 0x8, 4, 36410},
	{90053, 0x10, 2, 36408},
	{90022, 0x20, 4, 36404},
	{98896, 0x40},
	{98902, 0x300},
	{98912, 0x2000},
	{102698, 0x4000},
	{102720, 0x8000},
	{102742, 0x10000},
	{102764, 0x20000},
	{102786, 0x40000},
	{102808, 0x80000},
	/* 2704 */
	{99796, 0x7FF},
	{10733, 0xFFFFF800},
	/* 2706 */
	{99801, 0xFF},
	{99822, 0x100},
	{99832, 0x200},
	{99840, 0x400},
	{99854, 0x800},
	{99865, 0x1000},
	{99884, 0x2000},
	{99908, 0x4000},
	{99922, 0x8000},
	{102830, 0x10000},
	{102843, 0x20000},
	{102854, 0x40000},
	{102871, 0x80000},
	{102885, 0x100000},
	{102897, 0x200000},
	{102913, 0x400000},
	{10733, 0xFF800000},
	/* 2723 */
	{99932, 0x1},
	{99956, 0x2},
	{99980, 0x4},
	{102929, 0x8},
	{100050, 0xF0},
	{102949, 0x100},
	{102969, 0x200},
	{102984, 0x400},
	{10733, 0xFFFFF800},
	/* 2732 */
	{100065, 0x1},
	{103009, 0x2},
	{103032, 0x4},
	{100154, 0x8},
	{103046, 0x10},
	{100077, 0x20},
	{103073, 0x40},
	{100089, 0x80},
	{103088, 0x100},
	{100099, 0x200},
	{103101, 0x400},
	{100120, 0x800},
	{103125, 0x1000},
	{100137, 0x2000},
	{103145, 0x4000},
	{103165, 0x8000},
	{103182, 0x10000},
	{103202, 0x20000},
	{103219, 0x40000},
	/* 2751 */
	{879, 0xFFFF},
	{10733, 0xFFFF0000},
	/* 2753 */
	{103239, 0xFF},
	{103253, 0xFF00},
	{103276, 0xFF0000},
	{10733, 0xFF000000},
	/* 2757 */
	{103303, 0xFF},
	{103319, 0xFF00},
	{10733, 0xFFFF0000},
	/* 2760 */
	{103335, 0xFFFF},
	/* 2761 */
	{59184, 0xF},
	{59193, 0xF0},
	{59203, 0x100},
	{59214, 0x200},
	{59219, 0x400},
	{103342, 0x800},
	{59346, 0x1FF000, 257, 0},
	{103361, 0x200000},
	{59354, 0x800000},
	{59364, 0x8000000},
	/* 2771 */
	{59387, 0x1},
	{59391, 0x6},
	{59400, 0x18},
	{59410, 0x20},
	{59415, 0x40},
	{59423, 0x80},
	{59433, 0x100},
	{59444, 0x200},
	{59450, 0x400},
	{59455, 0x800},
	{59461, 0x1000},
	{59472, 0x2000},
	{59477, 0x4000},
	{59482, 0x8000},
	{59233, 0x10000},
	{59497, 0x20000},
	{59505, 0x40000},
	{59517, 0x80000},
	{103370, 0x400000},
	{59525, 0x800000},
	{103384, 0x1000000},
	{103393, 0x2000000},
	{103409, 0x4000000},
	{59536, 0x8000000},
	{43322, 0x10000000},
	{71845, 0x20000000},
	/* 2797 */
	{59548, 0x1FF, 257, 0},
	{59553, 0x400},
	{59561, 0x800},
	{59574, 0x7000},
	{59582, 0x8000},
	{103423, 0x10000},
	{103433, 0x20000},
	{103361, 0x40000},
	{103443, 0x80000},
	{103457, 0x100000},
	{101134, 0x10000000},
	/* 2808 */
	{59730, 0x1FF},
	{59740, 0xFF000},
	/* 2810 */
	{59812, 0x7},
	{59834, 0x3F0},
	{59805, 0xFC00},
	{59906, 0xFC000000},
	/* 2814 */
	{54607, 0x1F},
	{59654, 0x300},
	{59977, 0x3C00},
	{59984, 0x10000},
	{29236, 0x1C0000},
	{59646, 0xE0000000},
	/* 2820 */
	{60041, 0x3},
	{60073, 0x300},
	{60083, 0x400},
	{60096, 0x800},
	/* 2824 */
	{60113, 0xF},
	{60136, 0x10},
	{60159, 0x20},
	{60182, 0x40},
	{60202, 0x80},
	{60222, 0x100},
	{60242, 0x200},
	{60342, 0x4000},
	{60357, 0x8000},
	{60368, 0x10000},
	{60376, 0x20000},
	{60385, 0x40000},
	{101144, 0x80000},
	{60417, 0x100000},
	{60430, 0x200000},
	{60440, 0x400000},
	{60457, 0x800000},
	{60474, 0x4000000},
	{60483, 0x8000000},
	{60492, 0x10000000},
	{60501, 0x20000000},
	{60510, 0x40000000},
	/* 2846 */
	{60530, 0xF},
	{103473, 0x40},
	{60569, 0x80},
	{60592, 0x100},
	{60615, 0x200},
	{60634, 0x1000},
	{60643, 0x2000},
	{60652, 0x4000},
	{60660, 0x8000},
	{60669, 0x10000},
	{60684, 0x100000},
	{60692, 0x200000},
	{60700, 0x400000},
	{60709, 0x800000},
	{60718, 0x1000000},
	{60726, 0x2000000},
	{60734, 0x4000000},
	{103489, 0x8000000},
	{60742, 0x10000000},
	{60484, 0x20000000},
	{60760, 0x40000000},
	{60768, 0x80000000},
	/* 2868 */
	{60634, 0x2},
	{60643, 0x4},
	{60779, 0x8},
	{60483, 0x10},
	{60790, 0x20},
	{103500, 0x40},
	{60502, 0x80},
	{103510, 0x100},
	{60376, 0x200000},
	{60709, 0x400000},
	{60726, 0x1000000},
	{60652, 0x2000000},
	{60684, 0x4000000},
	{60700, 0x8000000},
	{60718, 0x20000000},
	{60734, 0x40000000},
	{60760, 0x80000000},
	/* 2885 */
	{60801, 0x20},
	{60861, 0x80},
	{60890, 0x100},
	{60910, 0x200},
	{60970, 0x2000},
	{60978, 0x4000},
	{60986, 0x8000},
	{60790, 0x10000},
	{103510, 0x2000000},
	{60502, 0x4000000},
	{103500, 0x8000000},
	{60997, 0x10000000},
	{61011, 0x20000000},
	{60779, 0x40000000},
	{61020, 0x80000000},
	/* 2900 */
	{103520, 0x7F},
	/* 2901 */
	{61029, 0x1},
	{61039, 0x2},
	{61049, 0x4},
	{61058, 0x8},
	{61067, 0x10},
	{61078, 0x20},
	{61089, 0x40},
	{61099, 0x80},
	{61109, 0x400},
	{61119, 0x800},
	{61136, 0x1000},
	{61144, 0x2000},
	{61157, 0x4000},
	{61175, 0x8000},
	{61186, 0x10000},
	{61195, 0x20000},
	{61216, 0x40000},
	{61227, 0x80000},
	{103531, 0x100000},
	{103551, 0x200000},
	{61254, 0x20000000},
	{61267, 0x40000000},
	{60501, 0x80000000},
	/* 2924 */
	{61280, 0x1},
	{103571, 0x2},
	{61315, 0x4},
	{61331, 0x8},
	{61349, 0x10},
	{61369, 0x20},
	{61388, 0x40},
	{61407, 0x80},
	{61420, 0x100},
	{61434, 0x200},
	{61458, 0x400},
	{61474, 0x800},
	{61490, 0x1000},
	{61506, 0x2000},
	{61522, 0x10000},
	{103591, 0x20000},
	{61557, 0x40000},
	{61573, 0x80000},
	{61591, 0x100000},
	{61611, 0x200000},
	{61630, 0x400000},
	{61649, 0x800000},
	{61662, 0x1000000},
	{61676, 0x2000000},
	{61700, 0x4000000},
	{61716, 0x8000000},
	{61732, 0x10000000},
	{61748, 0x20000000},
	/* 2952 */
	{61764, 0x8},
	{61783, 0x10},
	{61803, 0x40},
	{63126, 0x80},
	{61822, 0x100},
	{61843, 0x200},
	{61861, 0x400},
	{61884, 0x2000},
	{61906, 0x10000},
	{61927, 0x20000},
	{61945, 0x40000},
	{61968, 0x200000},
	{61990, 0x400000},
	{62014, 0x800000},
	{62038, 0x1000000},
	{62061, 0x2000000},
	/* 2968 */
	{43356, 0x3FFFF},
	/* 2969 */
	{103611, 0x1},
	{103628, 0x2},
	{63416, 0x1000},
	{63438, 0x4000},
	{63463, 0x20000},
	{63484, 0x40000},
	{63508, 0x400000},
	{63535, 0x800000},
	{63560, 0x1000000},
	{63583, 0x8000000},
	{63603, 0x40000000},
	/* 2980 */
	{64481, 0xFFFF},
	{20043, 0x3FFF0000},
	{64511, 0xC0000000},
	/* 2983 */
	{64526, 0x7},
	{64536, 0x38},
	{64546, 0x1C0},
	{64556, 0xE00},
	{17670, 0x3F000, 229, 36646},
	{68793, 0x600000},
	{68806, 0x800000},
	{101348, 0xC000000},
	{68927, 0x30000000, 4, 2761},
	{220, 0xC0000000},
	/* 2993 */
	{69159, 0x3FFF},
	{69168, 0xFC000},
	{69181, 0x300000},
	{69195, 0xC00000},
	{69209, 0x3000000},
	{69218, 0xC000000},
	{69248, 0x20000000},
	{107199, 0x40000000},
	/* 3001 */
	{69278, 0x3FFC0000},
	{69295, 0xC0000000},
	/* 3003 */
	{64481, 0xFF},
	{101348, 0x6000},
	{75272, 0x8000},
	{71320, 0xF0000},
	{17670, 0xFF00000, 229, 36646},
	{71142, 0xC0000000},
	/* 3009 */
	{71308, 0xF},
	{71328, 0xFFF00},
	{71341, 0x700000},
	{71350, 0x800000},
	{71380, 0x4000000},
	{107209, 0xF8000000},
	/* 3015 */
	{107220, 0x7F},
	{71408, 0x400},
	{107231, 0x7800},
	{71420, 0x18000},
	{71448, 0x60000},
	{71474, 0x80000},
	{71492, 0x100000},
	{71514, 0x200000},
	{71529, 0x400000},
	{71545, 0x800000},
	{71561, 0xFF000000},
	/* 3026 */
	{71582, 0x1},
	{71594, 0xE},
	{71607, 0xF0},
	{71625, 0x100},
	{71639, 0x3FE00},
	{71643, 0x40000},
	{43518, 0x80000},
	{10480, 0xF00000},
	{71646, 0x1000000},
	{71649, 0x1E000000},
	{69274, 0x20000000},
	/* 3037 */
	{71654, 0xFFFF},
	{107253, 0x3F0000},
	{107268, 0x20000000},
	{107282, 0x40000000},
	{107294, 0x80000000},
	/* 3042 */
	{71654, 0xFFFF},
	{71660, 0x3F0000},
	{107303, 0xC00000},
	/* 3045 */
	{71654, 0x1},
	{10733, 0x3FFE},
	{107318, 0x4000},
	{107333, 0x8000},
	{72470, 0x7F0000},
	{107253, 0x1F800000},
	{107268, 0x20000000},
	{107282, 0x40000000},
	{107294, 0x80000000},
	/* 3054 */
	{107349, 0xFF},
	{107370, 0xFF00},
	{107391, 0xFF0000},
	{107412, 0xFF000000},
	/* 3058 */
	{107437, 0x1FF},
	{107451, 0x3FE00},
	/* 3060 */
	{72583, 0x1},
	{72601, 0x2},
	{72615, 0x4},
	{72634, 0x8},
	{72654, 0x10},
	{72674, 0x20},
	{72696, 0x40},
	{72707, 0x400},
	{72725, 0x800},
	{10733, 0x1000},
	{72743, 0x2000},
	{72757, 0x4000},
	{72765, 0x8000},
	{107465, 0x10000},
	{107479, 0x20000},
	/* 3075 */
	{72957, 0xFFF},
	{72963, 0x7FFF000},
	/* 3077 */
	{72972, 0x7},
	{72982, 0x8},
	{72992, 0x10},
	{73002, 0x1FFE0},
	/* 3081 */
	{71967, 0xF},
	{107253, 0x3F0},
	{107268, 0x400},
	{107282, 0x800},
	{107294, 0x80000000},
	/* 3086 */
	{107502, 0xFFFF},
	{107512, 0xFFFF0000},
	/* 3088 */
	{47524, 0x3FF},
	/* 3089 */
	{73088, 0x1},
	{73107, 0x2},
	{73128, 0x4},
	{73139, 0x8},
	{73152, 0x10},
	{73171, 0x20},
	{73196, 0x40},
	{73219, 0x80},
	{73233, 0xF00},
	{73245, 0x1000},
	{101421, 0x4000},
	{107588, 0x30000, 4, 36875},
	{107598, 0x40000},
	{107614, 0x80000},
	{107633, 0xF00000},
	/* 3104 */
	{73615, 0x3, 4, 3027},
	{73632, 0xC, 4, 3027},
	{73650, 0x30, 4, 3027},
	{73668, 0x40},
	{73689, 0x80},
	{73704, 0x100},
	{73725, 0x200},
	{73743, 0x400},
	{73760, 0x800},
	{73773, 0x1000},
	{73792, 0x6000, 4, 3027},
	{73835, 0x10000},
	{73858, 0x20000},
	{73875, 0x40000},
	{73960, 0x180000, 4, 3031},
	{73979, 0x3E00000},
	{73996, 0x4000000},
	{74020, 0x8000000},
	{74034, 0x10000000},
	{74054, 0x20000000},
	{74068, 0x40000000},
	{74088, 0x80000000},
	/* 3126 */
	{74162, 0x3, 4, 3035},
	{74191, 0x1C},
	{74222, 0x20},
	{74258, 0x40},
	{74293, 0x80},
	{74321, 0x100},
	{74343, 0x200},
	{74361, 0x400},
	{74393, 0x800},
	{74514, 0x7000, 8, 3039},
	{74524, 0x38000},
	{74537, 0x1C0000},
	{74550, 0x200000},
	{74566, 0x400000},
	{74584, 0x800000},
	{74602, 0x2000000},
	{101459, 0x18000000},
	{107659, 0x20000000},
	/* 3144 */
	{74722, 0xF},
	{74730, 0xF0},
	{74738, 0x1F00},
	{74746, 0x6000},
	{74754, 0x18000},
	{74762, 0x60000},
	{74770, 0x180000},
	{107671, 0xF0000000},
	/* 3152 */
	{75120, 0x3, 4, 36879},
	{75132, 0xC, 4, 36879},
	{75144, 0x30, 4, 36879},
	{75160, 0xC0, 4, 36879},
	{75230, 0x30000, 4, 36883},
	{75242, 0xC0000, 4, 36883},
	{75254, 0x300000, 4, 36883},
	{75270, 0x1000000},
	{75281, 0x2000000},
	{101677, 0x4000000},
	{101687, 0x8000000},
	{101697, 0x10000000},
	{101711, 0x20000000},
	/* 3165 */
	{10250, 0x1},
	{77855, 0x3000},
	{77862, 0x30000},
	{77876, 0x300000},
	/* 3169 */
	{101605, 0x7, 5, 36601},
	{43724, 0xF0, 16, 36887},
	{108096, 0x1000},
	{108115, 0x2000},
	{108143, 0x4000},
	/* 3174 */
	{74630, 0x7FF},
	{59138, 0x7FF0000},
	/* 3176 */
	{108170, 0x1},
	{108182, 0x2},
	{108194, 0xC},
	{108207, 0x30},
	{108220, 0xC0},
	{108233, 0x100},
	{108248, 0x200},
	{108263, 0x400},
	{108273, 0x800},
	{108283, 0x1000},
	{108299, 0x2000},
	/* 3187 */
	{95030, 0xFF},
	{108315, 0xF0000000},
	/* 3189 */
	{78015, 0x3, 4, 36879},
	{78029, 0xC, 4, 36879},
	{78077, 0x300000, 4, 36883},
	{78091, 0xC00000, 4, 36883},
	{101758, 0x4000000},
	{101772, 0x8000000},
	{78122, 0x80000000},
	/* 3196 */
	{108330, 0x1},
	{108358, 0x7C},
	{78193, 0x100},
	{78222, 0x200},
	{78253, 0x400},
	{78281, 0x1000},
	{78309, 0x2000},
	{78339, 0x4000},
	/* 3204 */
	{108388, 0xF},
	{108400, 0xF0},
	/* 3206 */
	{879, 0x3F},
	{78892, 0x300},
	{78904, 0x400},
	{101788, 0x800},
	{108410, 0x1000},
	{78924, 0x20000},
	{78938, 0x40000},
	{78942, 0x80000},
	{78959, 0x100000},
	{78977, 0x600000},
	{78995, 0x800000},
	{79015, 0x1000000},
	{79027, 0x2000000},
	/* 3219 */
	{879, 0x3F},
	{78892, 0x300},
	{78904, 0x400},
	{101788, 0x800},
	{108410, 0x1000},
	{78938, 0x40000},
	{78942, 0x80000},
	{78959, 0x100000},
	{78977, 0x600000},
	{79015, 0x1000000},
	{79027, 0x2000000},
	/* 3230 */
	{79039, 0x3E},
	{79068, 0x80},
	{101802, 0x1F00},
	/* 3233 */
	{79589, 0x3F},
	{79600, 0x40},
	{79610, 0x80},
	{79627, 0x100},
	{101820, 0x3E00},
	{79643, 0x4000},
	{79663, 0x8000},
	/* 3240 */
	{80609, 0xF, 14, 36903},
	{80614, 0xF0, 14, 36903},
	{80619, 0xF00, 14, 36903},
	{80624, 0xF000, 14, 36903},
	{80629, 0xF0000, 14, 36903},
	{80634, 0xF00000, 14, 36903},
	{80639, 0xF000000, 14, 36903},
	{80644, 0xF0000000, 14, 36903},
	/* 3248 */
	{82239, 0x1F, 19, 36917},
	{81741, 0xE0, 5, 36002},
	{82344, 0x1F00, 19, 36917},
	{82360, 0x1F0000, 19, 36917},
	{81784, 0xE00000, 5, 36002},
	{82375, 0x1F000000, 19, 36917},
	{82391, 0x20000000},
	{10250, 0x40000000},
	{82412, 0x80000000},
	/* 3257 */
	{83129, 0x1},
	{102058, 0x2},
	{83147, 0x8},
	{1318, 0x70, 5, 36936},
	{82420, 0xFF0000, 256, 36021},
	/* 3262 */
	{83567, 0x1},
	{83583, 0x2},
	{83614, 0x4},
	{73681, 0x30, 4, 36277},
	{83693, 0x40},
	{83705, 0x80},
	{83729, 0x100},
	{83748, 0x200},
	{83766, 0x400},
	{83779, 0x800},
	{83801, 0x1000},
	{83891, 0x6000, 4, 36281},
	{83913, 0x8000},
	{83931, 0x10000},
	{84006, 0x800000},
	{108476, 0x1000000},
	{108494, 0x2000000},
	{108525, 0x1C000000},
	/* 3280 */
	{84892, 0x1},
	{84908, 0x2},
	{84924, 0x4},
	{84940, 0x8},
	{84956, 0x10},
	{84972, 0x20},
	{84988, 0x40},
	{85004, 0x80},
	{85020, 0x100},
	{85036, 0x200},
	{85052, 0x400},
	{85068, 0x800},
	{85084, 0x1000},
	{85100, 0x2000},
	{85116, 0x4000},
	{85132, 0x8000},
	{85148, 0x10000},
	{85167, 0x20000},
	{85185, 0x40000},
	{85212, 0x80000},
	{85234, 0x100000},
	{85252, 0x200000},
	{85272, 0x400000},
	{85295, 0x800000},
	{85318, 0x1000000},
	{85386, 0x8000000},
	{102081, 0x10000000},
	{102098, 0x20000000},
	{102123, 0x40000000},
	/* 3309 */
	{89457, 0x3F, 64, 36941},
	{64486, 0x7FFFC00},
	{89468, 0x8000000},
	/* 3312 */
	{90022, 0x3, 4, 36404},
	{90053, 0x4, 2, 36408},
	{20126, 0x18, 4, 36410},
	{90135, 0x20, 2, 36414},
	{90200, 0xC0, 4, 36416},
	{90206, 0x100},
	{90257, 0x1000},
	{90271, 0x2000},
	{90282, 0x4000},
	{90298, 0x78000},
	{90318, 0x180000},
	{90333, 0x200000},
	{90343, 0x400000},
	{90353, 0x800000},
	{90363, 0x1000000},
	{90378, 0x2000000},
	{102446, 0x4000000},
	/* 3329 */
	{220, 0x3, 3, 36420},
	{90532, 0x1C, 4, 36423},
	{90609, 0xE0, 4, 36427},
	{108573, 0x200},
	{90649, 0x3C00},
	{90671, 0x4000},
	{88221, 0x18000, 3, 36337},
	{90705, 0x60000, 4, 36431},
	{90764, 0x80000, 2, 37005},
	{90816, 0x100000, 2, 37007},
	{88247, 0x3800000},
	/* 3340 */
	{92218, 0x3},
	{71906, 0x4},
	{71928, 0x8},
	{92247, 0x60},
	{108644, 0x80},
	/* 3345 */
	{92360, 0x3, 4, 37009},
	{92373, 0x4},
	{92384, 0x8},
	{92493, 0x70, 5, 36461},
	{92511, 0x380, 5, 36461},
	{92529, 0x1C00},
	{92552, 0x3E000},
	{92578, 0x40000},
	{92600, 0x7F80000},
	{92616, 0x8000000},
	{92638, 0x10000000},
	{92725, 0x60000000, 3, 36466},
	/* 3357 */
	{93346, 0x7FF},
	{108715, 0x1000},
	{108749, 0x2000},
	{108769, 0x4000},
	{93367, 0xFF0000},
	{108792, 0xFF000000},
	/* 3363 */
	{108815, 0x1},
	{108839, 0x2},
	{108863, 0x4},
	{108906, 0x8},
	{108931, 0x70},
	{108959, 0x780},
	{108987, 0x800},
	{108999, 0x1000},
	{109024, 0x1FE000},
	{109043, 0x200000},
	/* 3373 */
	{17670, 0x1F, 25, 36621},
	{69574, 0x80},
	{94097, 0x700, 8, 36508},
	{94153, 0x1800, 4, 36516},
	{94163, 0x8000},
	{94175, 0x10000},
	{94188, 0x20000},
	{91767, 0x40000},
	{94428, 0x700000, 8, 36520},
	{94450, 0x3800000, 8, 36520},
	/* 3383 */
	{94680, 0x3},
	{94694, 0x4},
	{109083, 0x8},
	{94738, 0x10},
	{109109, 0x20},
	/* 3388 */
	{108330, 0x1},
	{109146, 0x2},
	{71420, 0xC, 3, 36531},
	{94882, 0x10, 2, 36534},
	{71448, 0x60},
	{71545, 0x180},
	{94908, 0x200},
	{95006, 0x400},
	{78253, 0x40000},
	{94973, 0x80000},
	{102547, 0x200000},
	{109176, 0x400000},
	{102567, 0x800000},
	{109188, 0x1000000},
	{109214, 0x2000000},
	{109249, 0x4000000},
	{109279, 0x38000000},
	/* 3405 */
	{95063, 0x1FFF},
	{95074, 0x2000},
	{95086, 0x7C000},
	{95114, 0x3000000},
	{95147, 0x40000000},
	/* 3410 */
	{95252, 0xFFFF},
	{95264, 0x30000},
	{87463, 0x40000},
	{109294, 0x80000},
	{95180, 0x6000000},
	{27021, 0xE0000000},
	/* 3416 */
	{26589, 0xFFFF},
	{109305, 0x20000},
	{109319, 0x40000},
	{95180, 0xC00000},
	{10480, 0xF000000},
	{54817, 0x30000000},
	{109327, 0x80000000},
	/* 3423 */
	{26661, 0xFFFF},
	{38, 0xF0000},
	{95180, 0xC00000},
	{10480, 0xF000000},
	{109327, 0x80000000},
	/* 3428 */
	{10480, 0xF},
	{109337, 0x10},
	{95347, 0x400},
	{95360, 0x6000},
	{95377, 0x8000},
	{95389, 0x300000},
	{95400, 0x6000000},
	{95417, 0x8000000},
	{95429, 0x60000000},
	/* 3437 */
	{95929, 0x1},
	{95943, 0x2},
	{102646, 0x8000},
	{95955, 0x10000},
	{95969, 0x1000000},
	{109341, 0x80000000},
	/* 3443 */
	{43280, 0x1FFF000},
	{95180, 0x6000000},
	{96043, 0x8000000},
	{96056, 0x10000000},
	{101104, 0x40000000},
	{109294, 0x80000000},
	/* 3449 */
	{96064, 0x30000},
	{109354, 0x80000},
	{102661, 0x300000},
	{102676, 0xC00000},
	{96072, 0x7000000},
	{96080, 0xE0000000},
	/* 3455 */
	{18832, 0x3F, 22, 37013},
	/* 3456 */
	{19357, 0x1},
	{89483, 0x2},
	{109391, 0x4},
	/* 3459 */
	{38, 0x1FFFF},
	/* 3460 */
	{87197, 0x1FF},
	{87177, 0x3FE00},
	{109414, 0x40000},
	{96802, 0x80000},
	{109434, 0x100000},
	{96756, 0x3FE00000},
	{109455, 0x40000000},
	{109467, 0x80000000},
	/* 3468 */
	{109496, 0xFFFF},
	{109508, 0xFFFF0000},
	/* 3470 */
	{109520, 0xFFFF},
	/* 3471 */
	{87886, 0x3F, 5, 37035},
	/* 3472 */
	{8, 0xFFF},
	{96536, 0xFFFFF000},
	/* 3474 */
	{38, 0x1FFF},
	{96536, 0xFFFFE000},
	/* 3476 */
	{85180, 0x1},
	{983, 0x1FFE},
	{220, 0x2000},
	{93061, 0x4000},
	{97083, 0x8000},
	{97095, 0x1FFF0000},
	{97106, 0x20000000},
	{97117, 0x40000000},
	{97127, 0x80000000},
	/* 3485 */
	{69313, 0x1FFFFF},
	{69332, 0xE00000},
	{69351, 0x1000000},
	{69373, 0x2000000},
	{69428, 0x10000000},
	{69446, 0x20000000},
	{69462, 0xC0000000},
	/* 3492 */
	{109540, 0xF},
	{109555, 0x10},
	{109579, 0x60},
	{109595, 0x80},
	{109611, 0x100},
	{109633, 0x200},
	{109653, 0x3C00},
	{109669, 0x4000},
	{109690, 0x8000},
	{109711, 0x1F0000},
	{109728, 0x200000},
	{109742, 0x400000},
	{109756, 0xFF800000},
	/* 3505 */
	{109773, 0xF},
	{109814, 0xF0},
	{109853, 0x100},
	{109874, 0x200},
	{109894, 0x400},
	{109914, 0x800},
	{109934, 0x1F000},
	/* 3512 */
	{109953, 0x3},
	{109966, 0x30},
	{109979, 0xC0},
	/* 3515 */
	{109992, 0xF},
	{110009, 0xF0},
	{110026, 0xF00},
	{110048, 0xF000},
	{110067, 0xF0000},
	{110085, 0xF00000},
	{110103, 0xF000000},
	{110121, 0xF0000000},
	/* 3523 */
	{110144, 0x3},
	{110162, 0x3C},
	{110185, 0xC0},
	{110215, 0x700},
	{110237, 0x3800},
	{110259, 0xC000},
	{110278, 0x10000},
	{10733, 0xFFFE0000},
	/* 3531 */
	{110286, 0xFF},
	{75272, 0x10000},
	{110295, 0x60000},
	{110305, 0x180000},
	{101348, 0x200000},
	{110315, 0x400000},
	/* 3537 */
	{490, 0x1},
	{110340, 0x2},
	{47347, 0x1C},
	{110345, 0xFE0},
	{110357, 0x1E000},
	{71182, 0x3E0000},
	{74809, 0xC00000},
	{110368, 0x7000000},
	{110380, 0x8000000},
	{110384, 0x10000000},
	{110388, 0x20000000},
	{110392, 0x40000000},
	/* 3549 */
	{110411, 0x7},
	/* 3550 */
	{490, 0x1},
	{110340, 0x2},
	{47347, 0x4},
	{110345, 0x8},
	{110357, 0x10},
	{71182, 0x20},
	{74809, 0x40},
	{110368, 0x80},
	{110380, 0x100},
	{110384, 0x200},
	{110388, 0x400},
	{110392, 0x800},
	{110411, 0x1000},
	/* 3563 */
	{97189, 0x3FF},
	{50401, 0xF00000},
	{98746, 0xF0000000},
	/* 3566 */
	{97189, 0x3F},
	{98008, 0x400},
	{98035, 0x800},
	{98062, 0x1000},
	{98088, 0x2000},
	{98114, 0x8000},
	{98141, 0x10000},
	{98221, 0x20000},
	{98247, 0x40000},
	{98167, 0x100000},
	{98326, 0x200000},
	{98488, 0x400000},
	{98515, 0x800000},
	{98380, 0x1000000},
	{98544, 0x2000000},
	{110420, 0x4000000},
	{110448, 0x8000000},
	{110474, 0x10000000},
	/* 3584 */
	{98515, 0x2},
	{98573, 0x4},
	{98602, 0x8},
	{98630, 0x10},
	{98656, 0x20},
	{98682, 0x40},
	{98709, 0x80},
	{98544, 0x100},
	{110420, 0x200},
	/* 3593 */
	{98736, 0x3FF},
	{97198, 0xFFC00},
	{98746, 0xF00000},
	{98767, 0xF000000},
	{98756, 0xF0000000},
	/* 3598 */
	{60011, 0x1},
	{90135, 0x4, 2, 36414},
	{90053, 0x10, 2, 36408},
	{98896, 0x40},
	{102698, 0x4000},
	{102720, 0x8000},
	{102742, 0x10000},
	{102764, 0x20000},
	{102786, 0x40000},
	{102808, 0x80000},
	/* 3608 */
	{98926, 0x1},
	{110502, 0x1FFFE},
	/* 3610 */
	{1331, 0x7F},
	/* 3611 */
	{1318, 0x3},
	{64126, 0x4},
	{110510, 0x8},
	{64146, 0x10},
	{64159, 0x20},
	{53894, 0x1C0},
	{110522, 0x600},
	{64186, 0x800},
	{64199, 0x1000},
	{64229, 0x2000},
	{64240, 0xC000},
	{64255, 0x30000},
	{64263, 0x40000},
	{64282, 0x80000},
	{101235, 0x700000},
	{101250, 0x10000000},
	{101273, 0x20000000},
	{64311, 0x80000000},
	/* 3629 */
	{63629, 0x3},
	{63638, 0xF0},
	{63646, 0x200},
	{63653, 0x1FC00},
	{110533, 0x20000},
	/* 3634 */
	{63924, 0x7FF, 2049, 257},
	{110562, 0x800},
	{101198, 0x1000},
	{64086, 0xFF0000, 129, 2306},
	{64098, 0x3000000},
	{101223, 0x1C000000},
	{64111, 0x80000000},
	/* 3641 */
	{64325, 0xFFF},
	{64340, 0xFFF000},
	{110574, 0x1000000},
	{60363, 0x2000000},
	{101289, 0xF0000000},
	/* 3646 */
	{101300, 0x1},
	{101310, 0x2},
	{101320, 0x10},
	{110586, 0x1F00},
	{110603, 0x2000},
	{110613, 0x4000},
	/* 3652 */
	{97189, 0x3FF},
	{98800, 0xF0000000},
	/* 3654 */
	{69984, 0xFFF},
	{99636, 0x3000},
	{110628, 0x4000},
	{10733, 0x8000},
	{99654, 0xFFFF0000},
	/* 3659 */
	{110651, 0xFFFF},
	{110669, 0xFF0000},
	{110688, 0xFF000000},
	/* 3662 */
	{11982, 0xFFF},
	/* 3663 */
	{98741, 0xFFFF},
	{97203, 0xFFFF0000},
	/* 3665 */
	{99801, 0xFF},
	{99822, 0x100},
	{99832, 0x200},
	{99840, 0x400},
	{99854, 0x800},
	{99865, 0x1000},
	{99884, 0x2000},
	{99908, 0x4000},
	{99922, 0x8000},
	{102830, 0x10000},
	{102843, 0x20000},
	{102854, 0x40000},
	{102871, 0x80000},
	{102885, 0x100000},
	{102897, 0x200000},
	{102913, 0x400000},
	{110703, 0x800000},
	{10733, 0xFF000000},
	/* 3683 */
	{100065, 0x1},
	{103009, 0x2},
	{103032, 0x4},
	{100154, 0x8},
	{100077, 0x20},
	{103073, 0x40},
	{100089, 0x80},
	{103088, 0x100},
	{100099, 0x200},
	{103101, 0x400},
	{100120, 0x800},
	{103125, 0x1000},
	{100137, 0x2000},
	{103145, 0x4000},
	{103165, 0x8000},
	{103182, 0x10000},
	{103202, 0x20000},
	{103219, 0x40000},
	{110722, 0x80000},
	{110739, 0x100000},
	{110759, 0x200000},
	{110776, 0x400000},
	/* 3705 */
	{50376, 0x1},
	{110796, 0x2},
	/* 3707 */
	{110803, 0x1},
	{110812, 0x2},
	{110826, 0x4},
	{110840, 0x8},
	{110857, 0xFF0},
	{110873, 0x8000},
	{110884, 0xF0000},
	{110901, 0xF00000},
	{110918, 0x3000000},
	{110932, 0x4000000},
	/* 3717 */
	{1318, 0x1},
	/* 3718 */
	{402, 0xFFF},
	/* 3719 */
	{1, 0xF},
	/* 3720 */
	{1, 0xF},
	{59233, 0x100},
	/* 3722 */
	{50662, 0xF},
	/* 3723 */
	{110946, 0x1},
	{110954, 0x2},
	{110962, 0x4},
	{110970, 0x8},
	{110978, 0x10},
	{110986, 0x20},
	{110994, 0x40},
	{111002, 0x80},
	{111010, 0x100},
	/* 3732 */
	{89457, 0x3F, 64, 36941},
	{108563, 0x80},
	{100856, 0xF00},
	{100868, 0x1000},
	{100875, 0x2000},
	{100883, 0x4000},
	{100891, 0x8000},
	{100899, 0x10000},
	{100922, 0x60000, 4, 36586},
	{100947, 0x80000},
	{100959, 0x100000},
	{100967, 0x200000},
	{101011, 0xC00000, 3, 36590},
	{101097, 0x1000000},
	{95180, 0x6000000},
	{96056, 0x30000000},
	{101104, 0x40000000},
	{109294, 0x80000000},
	/* 3750 */
	{111066, 0x3800, 6, 37040},
	{111100, 0xC000, 3, 37046},
	{111116, 0x20000},
	{111125, 0xFC0000},
	/* 3754 */
	{111135, 0x80000000},
	/* 3755 */
	{60113, 0xF},
	{60136, 0x10},
	{60159, 0x20},
	{60182, 0x40},
	{60202, 0x80},
	{60222, 0x100},
	{60242, 0x200},
	{60342, 0x4000},
	{60357, 0x8000},
	{60368, 0x10000},
	{60376, 0x20000},
	{60385, 0x40000},
	{101144, 0x80000},
	{60417, 0x100000},
	{60430, 0x200000},
	{60440, 0x400000},
	{60474, 0x4000000},
	{60483, 0x8000000},
	{60492, 0x10000000},
	{60501, 0x20000000},
	{60510, 0x40000000},
	{60519, 0x80000000},
	/* 3777 */
	{60634, 0x2},
	{60643, 0x4},
	{60779, 0x8},
	{60483, 0x10},
	{60790, 0x20},
	{103500, 0x40},
	{60502, 0x80},
	{60376, 0x200000},
	{60709, 0x400000},
	{60726, 0x1000000},
	{60652, 0x2000000},
	{60684, 0x4000000},
	{60700, 0x8000000},
	{60718, 0x20000000},
	{60734, 0x40000000},
	{60760, 0x80000000},
	/* 3793 */
	{60801, 0x20},
	{60861, 0x80},
	{60890, 0x100},
	{60910, 0x200},
	{60970, 0x2000},
	{60978, 0x4000},
	{60986, 0x8000},
	{60790, 0x10000},
	{60502, 0x4000000},
	{103500, 0x8000000},
	{60997, 0x10000000},
	{61011, 0x20000000},
	{60779, 0x40000000},
	{61020, 0x80000000},
	/* 3807 */
	{71582, 0x1},
	{71594, 0xE},
	{71607, 0xF0},
	{71625, 0x100},
	{71639, 0x3FE00},
	{71643, 0x40000},
	{43518, 0x80000},
	{10480, 0xF00000},
	{71646, 0x1000000},
	{71649, 0x1E000000},
	{69274, 0x20000000},
	{111143, 0x40000000},
	/* 3819 */
	{111147, 0xF},
	{111167, 0xF0},
	{111187, 0xF00},
	{111207, 0xF000},
	{111227, 0xF0000},
	{111247, 0xF00000},
	{111267, 0xF000000},
	{111287, 0xF0000000},
	/* 3827 */
	{111307, 0x1},
	{111324, 0x2},
	/* 3829 */
	{85992, 0x1},
	{85764, 0x2},
	{85788, 0x4},
	{85808, 0x8},
	{85829, 0x10},
	{86030, 0x40},
	/* 3835 */
	{220, 0x3, 3, 36420},
	{90532, 0x1C, 4, 36423},
	{90609, 0xE0, 4, 36427},
	{90618, 0x100},
	{108573, 0x200},
	{90649, 0x3C00},
	{90671, 0x4000},
	{88221, 0x18000, 3, 36337},
	{90705, 0x60000, 4, 36431},
	{90764, 0x80000, 2, 37005},
	{90816, 0x100000, 2, 37007},
	{88247, 0x3800000},
	/* 3847 */
	{92360, 0x3, 4, 37049},
	{92373, 0x4},
	{92384, 0x8},
	{92493, 0x70, 5, 36461},
	{92511, 0x380, 5, 36461},
	{92529, 0x1C00},
	{92552, 0x3E000},
	{92578, 0x40000},
	{92600, 0x7F80000},
	{92616, 0x8000000},
	{92638, 0x10000000},
	{92725, 0x60000000, 3, 36466},
	/* 3859 */
	{108815, 0x1},
	{108839, 0x2},
	{108863, 0x4},
	{108906, 0x8},
	{111343, 0x70},
	{108959, 0x780},
	{108987, 0x800},
	{108999, 0x1000},
	{109024, 0x1FE000},
	{109043, 0x200000},
	{111380, 0x400000},
	{111391, 0x800000},
	{111418, 0x3000000},
	{108931, 0x7C000000},
	/* 3873 */
	{40620, 0xFFFF},
	/* 3874 */
	{96543, 0x7F},
	{96507, 0xFF00},
	{96498, 0xFF0000},
	{96558, 0x20000000},
	{96578, 0x40000000},
	{96604, 0x80000000},
	/* 3880 */
	{100543, 0xF},
	{100590, 0x1000000},
	{100601, 0x2000000},
	{100611, 0x4000000},
	/* 3884 */
	{59184, 0xF},
	{59193, 0xF0},
	{59203, 0x100},
	{59214, 0x200},
	{59219, 0x400},
	{111443, 0x800},
	{59346, 0x7F000, 257, 0},
	{59377, 0x10000000},
	{59383, 0xE0000000},
	/* 3893 */
	{59387, 0x1},
	{59391, 0x6},
	{111452, 0x18},
	{59410, 0x20},
	{59415, 0x40},
	{59423, 0x80},
	{59433, 0x100},
	{59444, 0x200},
	{59450, 0x400},
	{59455, 0x800},
	{59461, 0x1000},
	{59472, 0x2000},
	{59477, 0x4000},
	{111462, 0x8000},
	{59233, 0x10000},
	{59497, 0x20000},
	{59505, 0x40000},
	{59517, 0x80000},
	{111475, 0x100000},
	{111489, 0x200000},
	{111502, 0x400000},
	{111511, 0x800000},
	{111520, 0x7000000},
	{59536, 0x8000000},
	/* 3917 */
	{59548, 0x7F, 257, 0},
	{59593, 0x3F0000},
	{59646, 0xE0000000},
	/* 3920 */
	{54607, 0xF},
	{59654, 0x30},
	{59662, 0xC0},
	{59670, 0xF00},
	{59676, 0x1000},
	{29236, 0x2000},
	{59694, 0xF0000},
	{59700, 0xF00000},
	{59706, 0x7000000},
	{59715, 0x38000000},
	{59724, 0xC0000000},
	/* 3931 */
	{59730, 0x3F},
	{59740, 0x3F00},
	{59750, 0x3F0000},
	{59760, 0xF000000},
	/* 3935 */
	{59770, 0xFF},
	{59779, 0x1FF000},
	/* 3937 */
	{59805, 0xF},
	{59812, 0x70},
	{59834, 0x1F00},
	{59843, 0xE000},
	/* 3941 */
	{1448, 0xFF},
	/* 3942 */
	{111540, 0x7},
	{111548, 0x8},
	{111559, 0x10},
	{111572, 0xE0},
	{111588, 0x300},
	{111598, 0xC00},
	{111608, 0x70000},
	{59968, 0x380000},
	{111620, 0xC00000},
	{111627, 0x1000000},
	{111634, 0x6000000},
	{73755, 0x8000000},
	{111642, 0x10000000},
	/* 3955 */
	{10362, 0xFF},
	/* 3956 */
	{103473, 0x1},
	{111659, 0x2},
	{60457, 0x4},
	{111674, 0x8},
	{111690, 0x10},
	{60430, 0x20},
	{111699, 0x40},
	{111710, 0x80},
	{111720, 0x100},
	{111730, 0x200},
	{111740, 0x400},
	{111751, 0x800},
	{111762, 0x1000},
	{111774, 0x2000},
	{111783, 0x4000},
	{111793, 0x8000},
	{101164, 0x10000},
	{101181, 0x20000},
	{111802, 0x40000},
	{111820, 0x80000},
	{111835, 0x100000},
	/* 3977 */
	{111851, 0x2},
	{111866, 0x4},
	{111884, 0x8},
	{60554, 0x10},
	{111899, 0x20},
	{111915, 0x40},
	{111929, 0x100},
	{111938, 0x200},
	{111947, 0x400},
	{111968, 0x800},
	{111977, 0x1000},
	{111986, 0x2000},
	{111996, 0x4000},
	{112005, 0x10000},
	{112014, 0x20000},
	{112022, 0x80000},
	{112031, 0x100000},
	{112043, 0x200000},
	{112056, 0x400000},
	{112069, 0x20000000},
	/* 3997 */
	{112078, 0x1},
	{112088, 0x2},
	{112098, 0x4},
	{112108, 0x8},
	{112118, 0x10},
	{112128, 0x20},
	{112138, 0x40},
	{112148, 0x80},
	{112158, 0x100},
	{112168, 0x200},
	{112178, 0x400},
	{112188, 0x800},
	{112198, 0x1000},
	{112208, 0x2000},
	{112218, 0x4000},
	{112228, 0x8000},
	/* 4013 */
	{112238, 0xFF},
	/* 4014 */
	{112251, 0x3F},
	{112270, 0xFC0},
	/* 4016 */
	{60113, 0xF},
	{60342, 0x1},
	{60136, 0x10},
	{60159, 0x20},
	{60182, 0x40},
	{60202, 0x80},
	{60222, 0x100},
	{60474, 0x100},
	{60242, 0x200},
	{61412, 0x200},
	{60262, 0x400},
	{60282, 0x800},
	{60302, 0x1000},
	{60322, 0x2000},
	{60492, 0x10000000},
	{60501, 0x20000000},
	{60510, 0x40000000},
	/* 4033 */
	{112281, 0xF},
	{112290, 0xF0},
	/* 4035 */
	{60530, 0xF},
	{112299, 0x20},
	{60569, 0x80},
	{60592, 0x100},
	{60615, 0x200},
	{60634, 0x1000},
	{60643, 0x2000},
	{60652, 0x4000},
	{60660, 0x8000},
	{112315, 0x10000},
	{112330, 0x20000},
	{112339, 0x40000},
	{112354, 0x80000},
	{60684, 0x100000},
	{112362, 0x200000},
	{60700, 0x400000},
	{60709, 0x800000},
	{60718, 0x1000000},
	{60726, 0x2000000},
	{60734, 0x4000000},
	{60742, 0x10000000},
	{60484, 0x20000000},
	{60760, 0x40000000},
	{60768, 0x80000000},
	/* 4059 */
	{60634, 0x2},
	{60643, 0x4},
	{60709, 0x400000},
	{112330, 0x800000},
	{60726, 0x1000000},
	{60652, 0x2000000},
	{60684, 0x4000000},
	{60700, 0x8000000},
	{60718, 0x20000000},
	{60734, 0x40000000},
	{60760, 0x80000000},
	/* 4070 */
	{112370, 0x1},
	{112384, 0x4},
	{112399, 0x10000},
	{112414, 0x20000},
	{112429, 0x40000},
	{112444, 0x80000},
	/* 4076 */
	{112459, 0x3F},
	/* 4077 */
	{96543, 0xFF},
	{112476, 0xFF00},
	{96498, 0xFF0000},
	{112485, 0x20000000},
	{96578, 0x40000000},
	{96604, 0x80000000},
	/* 4083 */
	{112505, 0xF},
	{112522, 0x1F00},
	/* 4085 */
	{51428, 0xFF},
	/* 4086 */
	{112537, 0x2},
	{112548, 0x20},
	{112559, 0x40},
	{112580, 0x80},
	{112600, 0xF00},
	{112622, 0x1000},
	/* 4092 */
	{112648, 0x1},
	{112656, 0x2},
	{112664, 0x2},
	{112673, 0x8},
	{112689, 0x10},
	{112705, 0x40},
	{112726, 0x80},
	{112747, 0x100},
	{112768, 0x200},
	{112776, 0x200},
	{112797, 0x400},
	{112818, 0x800},
	{112839, 0x1000},
	{112860, 0x2000},
	{112881, 0x4000},
	{112902, 0x8000},
	{112923, 0x10000},
	{112944, 0x20000},
	{112965, 0x40000},
	{112986, 0x80000},
	{113007, 0x100000},
	{113028, 0x200000},
	/* 4114 */
	{113049, 0x3FFFC},
	{113062, 0x300000},
	{113074, 0xC00000},
	{51481, 0x80000000},
	/* 4118 */
	{113084, 0x1},
	{113101, 0x80000},
	/* 4120 */
	{97189, 0x3F},
	{98008, 0x400},
	{98035, 0x800},
	{113121, 0x1000},
	{98062, 0x2000},
	{98088, 0x4000},
	{98114, 0x10000},
	{98141, 0x20000},
	{98167, 0x40000},
	{98193, 0x80000},
	{98221, 0x100000},
	{98247, 0x200000},
	{98273, 0x400000},
	{113148, 0x800000},
	{98299, 0x1000000},
	{98326, 0x2000000},
	{98353, 0x4000000},
	{113174, 0x8000000},
	{113200, 0x10000000},
	/* 4139 */
	{97189, 0x3F},
	{98008, 0x400},
	{98035, 0x800},
	{98062, 0x1000},
	{98088, 0x2000},
	{98114, 0x8000},
	{98141, 0x10000},
	{98221, 0x20000},
	{98247, 0x40000},
	{113121, 0x80000},
	{98167, 0x100000},
	{98326, 0x200000},
	/* 4151 */
	{51506, 0x3FFFF},
	/* 4152 */
	{113226, 0x1},
	{113239, 0x2},
	{113243, 0x4},
	{113265, 0x8},
	{113279, 0x10},
	{113293, 0x20},
	{113311, 0x40},
	{113329, 0x80},
	{29236, 0x2000000},
	{102394, 0xC000000},
	/* 4162 */
	{95278, 0x3},
	{10333, 0xFFFFFFFC},
	/* 4164 */
	{113344, 0x3},
	{24696, 0xFFFFFFFC},
	/* 4166 */
	{113365, 0x3},
	{25212, 0xFFFFFFFC},
	/* 4168 */
	{95252, 0xFF},
	{95264, 0x30000},
	{27021, 0xE0000000},
	/* 4171 */
	{113386, 0x3},
	{26571, 0xFFFFFFFC},
	/* 4173 */
	{26589, 0xFF},
	/* 4174 */
	{113403, 0x3},
	{26643, 0xFFFFFFFC},
	/* 4176 */
	{26661, 0xFF},
	/* 4177 */
	{26720, 0xFF},
	{95288, 0x10000},
	{95304, 0x100000},
	{95320, 0x3000000},
	{95336, 0xE0000000},
	/* 4182 */
	{96243, 0x1},
	{96259, 0x2},
	{96275, 0x40},
	{96293, 0x80},
	{96311, 0x100},
	{96329, 0x200},
	{96347, 0x400},
	{96365, 0x800},
	{96383, 0x1000},
	{96401, 0x2000},
	{96419, 0x4000},
	{95538, 0x8000},
	{113420, 0x10000},
	{95558, 0x40000},
	{96436, 0x80000},
	{96452, 0x200000},
	{95575, 0x400000},
	{95591, 0x800000},
	{95605, 0x2000000},
	{95619, 0x4000000},
	{95633, 0x8000000},
	{95654, 0x10000000},
	{95679, 0x20000000},
	/* 4205 */
	{96468, 0xFF},
	{95724, 0x3000000},
	{113438, 0x40000000},
	{1331, 0x80000000},
	/* 4209 */
	{26958, 0xFF},
	/* 4210 */
	{26999, 0xFF},
	/* 4211 */
	{95729, 0x1FFFFF},
	{95767, 0x200000},
	{113452, 0xC00000},
	{113461, 0x3000000},
	{95740, 0x4000000},
	{95744, 0x8000000},
	{95748, 0x10000000},
	{95753, 0x20000000},
	{95758, 0x40000000},
	/* 4220 */
	{95808, 0x30},
	{95820, 0xF0000},
	{95833, 0x10000000},
	{95848, 0x20000000},
	{95862, 0xC0000000},
	/* 4225 */
	{95923, 0x1},
	/* 4226 */
	{113470, 0x1},
	{113495, 0x2},
	{113533, 0x4},
	{113574, 0x8},
	{113597, 0x10},
	{113620, 0x20},
	{113644, 0x40},
	{113674, 0x80},
	{113703, 0x100},
	{113734, 0x400},
	{113760, 0x800},
	{113789, 0x1000},
	{113814, 0x2000},
	{63105, 0x4000},
	{63126, 0x8000},
	/* 4241 */
	{113849, 0x1},
	{113876, 0x4},
	{113903, 0x10},
	{113932, 0x400},
	{113961, 0x800},
	{113990, 0x1000},
	{114018, 0x2000},
	{114048, 0x4000},
	{114075, 0x8000},
	{114103, 0x10000},
	{114129, 0x20000},
	{114155, 0x800000},
	{114180, 0x1000000},
	{114206, 0x2000000},
	{114231, 0x4000000},
	{114255, 0x8000000},
	{114280, 0x10000000},
	{114309, 0x10000000},
	/* 4259 */
	{114337, 0x1},
	{114363, 0x2},
	{114389, 0x4},
	{114416, 0x10},
	{114442, 0x20},
	{114464, 0x40},
	{114485, 0x80},
	{114517, 0x100},
	{114544, 0x200},
	{114566, 0x400},
	{114590, 0x800},
	{114615, 0x1000},
	{114638, 0x2000},
	{114665, 0x4000},
	{114690, 0x8000},
	{114718, 0x10000},
	{114743, 0x20000},
	{114768, 0x40000},
	{114793, 0x80000},
	{114822, 0x100000},
	{114853, 0x200000},
	{114881, 0x400000},
	{114908, 0x800000},
	{114938, 0x1000000},
	{114965, 0x2000000},
	{114992, 0x4000000},
	{115019, 0x8000000},
	{115045, 0x10000000},
	{115069, 0x20000000},
	{115101, 0x40000000},
	{115128, 0x80000000},
	/* 4290 */
	{62442, 0x1},
	{115154, 0x40},
	{115173, 0x80},
	{115193, 0x100},
	{115212, 0x200},
	{115226, 0x400},
	{115239, 0x1000},
	{115261, 0x2000},
	{115284, 0x4000},
	{115305, 0x8000},
	{115322, 0x20000},
	{115337, 0x40000},
	{115351, 0x80000},
	{115365, 0x100000},
	{115381, 0x200000},
	{115394, 0x400000},
	/* 4306 */
	{115413, 0x80},
	{115428, 0x100},
	{62126, 0x200},
	{62140, 0x400},
	{62159, 0x800},
	{62178, 0x1000},
	{103512, 0x2000},
	{115217, 0x8000},
	{115443, 0x10000},
	{115231, 0x20000},
	{115452, 0x40000},
	{62254, 0x80000},
	{62269, 0x100000},
	{115463, 0x200000},
	{60431, 0x400000},
	{62302, 0x800000},
	{61119, 0x1000000},
	{115481, 0x2000000},
	{115386, 0x4000000},
	{61109, 0x8000000},
	{62193, 0x10000000},
	{62210, 0x20000000},
	{62232, 0x40000000},
	{60484, 0x80000000},
	/* 4330 */
	{2190, 0x3F},
	{115494, 0x3F00},
	{115509, 0x3F0000},
	/* 4333 */
	{51850, 0x1F},
	/* 4334 */
	{115524, 0xF},
	{115547, 0x3F00},
	/* 4336 */
	{115568, 0xF},
	/* 4337 */
	{115587, 0x10},
	{115608, 0x40},
	{115630, 0x100},
	{115651, 0x1000000},
	{115659, 0x2000000},
	{115667, 0x4000000},
	{115676, 0x8000000},
	{115685, 0x10000000},
	{115693, 0x20000000},
	/* 4346 */
	{115701, 0xFF},
	{115722, 0x700},
	{115743, 0xFF00000},
	{115763, 0x70000000},
	/* 4350 */
	{115783, 0x1},
	/* 4351 */
	{115804, 0xFFFFF},
	/* 4352 */
	{115812, 0xFFFFFFF},
	{115828, 0xF0000000},
	/* 4354 */
	{115844, 0xFFFF},
	{115859, 0xFFFF0000},
	/* 4356 */
	{27694, 0xFF},
	/* 4357 */
	{27748, 0xFF},
	/* 4358 */
	{27800, 0xFF},
	/* 4359 */
	{27931, 0xFF},
	/* 4360 */
	{115875, 0xFF},
	{115885, 0xFF00},
	{115895, 0xFF0000},
	{115908, 0xFF000000},
	/* 4364 */
	{115921, 0xFF},
	{115934, 0xFF00},
	{115947, 0xFF0000},
	{115960, 0xFF000000},
	/* 4368 */
	{115973, 0xFF},
	{115984, 0xFF00},
	{115995, 0xFF0000},
	/* 4371 */
	{116006, 0x3F},
	{116020, 0x3F00},
	/* 4373 */
	{116034, 0xFF},
	{116045, 0xFF00},
	/* 4375 */
	{116056, 0x7FF},
	{116069, 0x7FF0000},
	/* 4377 */
	{116081, 0x1FF},
	/* 4378 */
	{116089, 0x7FF},
	/* 4379 */
	{116101, 0x3FF},
	/* 4380 */
	{52154, 0x7FF},
	{116109, 0x3000},
	{116120, 0x30000},
	/* 4383 */
	{116134, 0x3FF},
	{116151, 0x3FF0000},
	/* 4385 */
	{116168, 0x3FF},
	{116187, 0x3FF0000},
	/* 4387 */
	{116206, 0x3FF},
	{116225, 0x3FF0000},
	/* 4389 */
	{116244, 0x3FF},
	/* 4390 */
	{116253, 0x3FF},
	{116262, 0x3FF0000},
	/* 4392 */
	{116271, 0x7FF},
	{116284, 0x7FF0000},
	/* 4394 */
	{116296, 0x7FF},
	/* 4395 */
	{116308, 0x3FF},
	{116325, 0x3FF0000},
	/* 4397 */
	{116342, 0x3FF},
	{116361, 0x3FF0000},
	/* 4399 */
	{116380, 0x3FF},
	{116399, 0x3FF0000},
	/* 4401 */
	{116418, 0x4000},
	{116444, 0x20000},
	{116474, 0x80000},
	{116497, 0x100000},
	{116521, 0x400000},
	{116545, 0x800000},
	{116567, 0x1000000},
	{116593, 0x4000000},
	{116617, 0x8000000},
	{116649, 0x20000000},
	{116671, 0x40000000},
	{116693, 0x80000000},
	/* 4413 */
	{97189, 0xFF},
	{97198, 0xFFC00},
	{98746, 0xF00000},
	{98767, 0xF000000},
	{98800, 0xF0000000},
	/* 4418 */
	{97189, 0xFF},
	{98800, 0xF0000000},
	/* 4420 */
	{116715, 0x3FF},
	/* 4421 */
	{52620, 0x1FF},
	/* 4422 */
	{52644, 0x3F},
	/* 4423 */
	{52667, 0x3F},
	/* 4424 */
	{82425, 0x7},
	{116726, 0x70000},
	/* 4426 */
	{52712, 0x3},
	{116739, 0x20},
	{116758, 0xC0},
	{116772, 0x200},
	{116784, 0x800},
	{116805, 0x1000},
	{116822, 0x2000},
	{116843, 0x1F0000},
	/* 4434 */
	{116852, 0x7F},
	{86939, 0x80},
	{116873, 0x3FFF00},
	{87004, 0xFFC00000},
	/* 4438 */
	{116890, 0x1F},
	/* 4439 */
	{116901, 0x3},
	/* 4440 */
	{112354, 0x1},
	{116919, 0x2},
	{116931, 0x4},
	{116947, 0x8},
	{116959, 0x10},
	/* 4445 */
	{116971, 0x3F},
	{116986, 0x40},
	/* 4447 */
	{117006, 0x3F},
	{117020, 0x40},
	/* 4449 */
	{112330, 0x1},
	{117039, 0x2},
	{117057, 0x4},
	{117070, 0x8},
	{117082, 0x10},
	{117094, 0x20},
	{117106, 0x40},
	{117118, 0x80},
	{117130, 0x100},
	{117142, 0x200},
	/* 4459 */
	{117156, 0xFF},
	/* 4460 */
	{18832, 0x3F, 29, 37053},
	/* 4461 */
	{214, 0x3, 2, 36326},
	/* 4462 */
	{117364, 0xF},
	{117373, 0xFF0},
	{117388, 0x1000000},
	{117403, 0x2000000},
	{117415, 0x4000000},
	{117426, 0x8000000},
	{117441, 0x10000000},
	{117456, 0x20000000},
	{117468, 0x40000000},
	{117482, 0x80000000},
	/* 4472 */
	{10250, 0x1},
	{10480, 0x1E},
	/* 4474 */
	{117364, 0xF},
	{117373, 0xFF0},
	{117388, 0x1000000},
	{117403, 0x2000000},
	{117415, 0x4000000},
	{117426, 0x8000000},
	{117441, 0x10000000},
	{117468, 0x20000000},
	{117495, 0x20000000},
	{117482, 0x80000000},
	/* 4484 */
	{117510, 0x1},
	{117523, 0x7E},
	{117540, 0x80},
	/* 4487 */
	{96624, 0x7F},
	{96690, 0x600, 4, 36536},
	/* 4489 */
	{117565, 0x6},
	{117575, 0x8},
	{117595, 0x10},
	{117604, 0xFFFF0000},
	/* 4493 */
	{117617, 0x1F},
	/* 4494 */
	{117631, 0x80000000},
	/* 4495 */
	{117639, 0x1},
	{117660, 0x6},
	{117673, 0x8},
	{117696, 0x10},
	{117716, 0x20},
	{117735, 0x10000000},
	{117746, 0x20000000},
	{117757, 0x40000000},
	{117768, 0x80000000},
	/* 4504 */
	{117364, 0xF},
	{117373, 0xFF0},
	{117388, 0x1000000},
	{117779, 0x2000000},
	{117794, 0x4000000},
	{117426, 0x8000000},
	{117441, 0x10000000},
	{117809, 0x20000000},
	{117825, 0x40000000},
	{117841, 0x80000000},
	/* 4514 */
	{117858, 0x80000000},
	/* 4515 */
	{18816, 0xFF},
	/* 4516 */
	{97189, 0x1FF},
	{97198, 0xFFC00},
	{98746, 0xF00000},
	/* 4519 */
	{117866, 0xFFFF},
	{117888, 0xFFFF0000},
	/* 4521 */
	{117364, 0xF},
	{117373, 0xFF0},
	{117388, 0x1000000},
	{117779, 0x2000000},
	{117794, 0x4000000},
	{117426, 0x8000000},
	{117441, 0x10000000},
	{117495, 0x20000000},
	{117910, 0x40000000},
	{117925, 0x80000000},
	/* 4531 */
	{117940, 0x3F},
	{117967, 0x7FC0},
	{117993, 0x1F8000},
	{118015, 0xFF800000},
	/* 4535 */
	{118040, 0x3F},
	{118064, 0xFC0},
	{118088, 0x3F000},
	{118108, 0xFC0000},
	/* 4539 */
	{118128, 0x3F},
	/* 4540 */
	{118142, 0x1},
	{118168, 0x2},
	{118191, 0x4},
	{118216, 0x8},
	{118247, 0x10},
	{118281, 0x20},
	{118301, 0xC0},
	{118328, 0x100},
	{118356, 0x200},
	{118391, 0x400},
	{118421, 0x800},
	{118456, 0x1000},
	{118486, 0x2000},
	{118509, 0x4000},
	{118548, 0x8000},
	{118580, 0x10000},
	{118616, 0x20000},
	{118646, 0x40000},
	{118692, 0x80000},
	{118733, 0x100000},
	{118783, 0x200000},
	{118833, 0x400000},
	{118884, 0x800000},
	{118932, 0x1000000},
	{117757, 0x40000000},
	{117768, 0x80000000},
	/* 4566 */
	{96536, 0xFF},
	{111443, 0x100},
	{118978, 0x200},
	{118997, 0x400},
	{119018, 0x800},
	{119037, 0x1000},
	{119059, 0x2000},
	{119080, 0x4000},
	{119103, 0x8000},
	/* 4575 */
	{119133, 0x3},
	{119149, 0xC},
	{119165, 0x30},
	{119181, 0x40},
	{119196, 0x80},
	{119214, 0x100},
	{119229, 0x200},
	{119248, 0x400},
	{119266, 0x800},
	/* 4584 */
	{119287, 0x1},
	{119303, 0x2},
	{119319, 0x4},
	/* 4587 */
	{119339, 0x7F},
	{119343, 0x380},
	{119347, 0x1FFC00},
	/* 4590 */
	{119351, 0x3F},
	{119364, 0xF00},
	{110817, 0x10000000},
	{119376, 0x20000000},
	{113329, 0x40000000},
	{113298, 0x80000000},
	/* 4596 */
	{119390, 0xF},
	{119410, 0xF00},
	{119427, 0x30000},
	{119443, 0xC0000},
	/* 4600 */
	{60011, 0x1},
	{90200, 0x2, 4, 36416},
	{90135, 0x4, 2, 36414},
	{20126, 0x8, 4, 36410},
	{90053, 0x10, 2, 36408},
	{90022, 0x20, 4, 36404},
	{98896, 0x40},
	{98902, 0x1F00},
	{98912, 0x2000},
	/* 4609 */
	{119463, 0xF0000},
	{119481, 0xF00000},
	{119499, 0xF000000},
	{119517, 0xF0000000},
	/* 4613 */
	{60363, 0x1},
	{119535, 0x2},
	{119554, 0xFFF0},
	{119569, 0xFFF0000},
	/* 4617 */
	{97189, 0x1FF},
	{98882, 0xF000},
	{119584, 0xF0000},
	{50401, 0xF00000},
	{119600, 0xF000000},
	{98800, 0xF0000000},
	/* 4623 */
	{119610, 0xFFFF},
	{119626, 0xFFFF0000},
	/* 4625 */
	{117364, 0xF},
	{117373, 0xFF0},
	{117468, 0x40000000},
	{117482, 0x80000000},
	/* 4629 */
	{54607, 0xF},
	{59654, 0x30},
	{119642, 0xFC0},
	{119652, 0x1000},
	{119662, 0x2000},
	{112238, 0x4000},
	{119673, 0x8000},
	{452, 0xFFFF0000},
	/* 4637 */
	{38, 0x3FFFFF},
	/* 4638 */
	{119683, 0x1F},
	{119690, 0x20},
	{64173, 0x80},
	{119697, 0x3000},
	{64186, 0x4000},
	{64199, 0x8000},
	{119708, 0xFFFF0000},
	{119708, 0xFFFF0000},
	/* 4646 */
	{2468, 0xFFFF},
	{119720, 0xFF0000},
	{64211, 0x1000000},
	/* 4649 */
	{119729, 0xFFFF},
	{119738, 0xFFFF0000},
	/* 4651 */
	{2426, 0x3FFFFFFF},
	{119747, 0xC0000000},
	/* 4653 */
	{64325, 0x7},
	{64340, 0x70000},
	{119759, 0x20000000},
	{60363, 0x40000000},
	{72786, 0x80000000},
	/* 4658 */
	{119767, 0x7},
	{119775, 0x38},
	{119783, 0x1C0},
	{119791, 0xE00},
	{119799, 0x7000},
	{119807, 0x38000},
	{119815, 0x1C0000},
	{1318, 0x600000},
	{119823, 0x1800000},
	{119836, 0x2000000},
	{59410, 0x4000000},
	{119849, 0x18000000},
	{119860, 0x20000000},
	{64146, 0x40000000},
	{69097, 0x80000000},
	/* 4673 */
	{119870, 0x80000000},
	/* 4674 */
	{53894, 0x7},
	/* 4675 */
	{119883, 0x3FFF},
	{119893, 0x3FFF0000},
	{119903, 0xC0000000},
	/* 4678 */
	{119916, 0x3FFF},
	{119932, 0x3FF0000},
	{119957, 0x78000000},
	{119982, 0x80000000},
	/* 4682 */
	{73483, 0x1},
	{73055, 0x2},
	{11600, 0x4},
	/* 4685 */
	{119996, 0xFF},
	{120005, 0xFF00},
	{120014, 0xFF0000},
	{120023, 0xFF000000},
	/* 4689 */
	{120032, 0x3F},
	{120040, 0x1F00},
	{120049, 0x1FF0000},
	/* 4692 */
	{120058, 0x3F},
	{120066, 0x1F00},
	{120075, 0x1FF0000},
	/* 4695 */
	{54607, 0xF},
	{59654, 0x30},
	{30847, 0x1C0},
	{59700, 0x1E00},
	/* 4699 */
	{64526, 0x7, 8, 37082},
	{64536, 0x38, 8, 37082},
	{64546, 0x1C0, 8, 37082},
	{64556, 0xE00, 8, 37082},
	{110357, 0x7000, 8, 37090},
	{110345, 0x78000, 16, 37098},
	{120729, 0x180000},
	{68793, 0x600000},
	{68806, 0x800000},
	{88234, 0x1000000},
	{120742, 0x2000000},
	{120754, 0x4000000},
	{88247, 0x38000000},
	{220, 0xC0000000, 4, 37114},
	/* 4713 */
	{64481, 0xFF},
	{69127, 0xFFF00},
	{110345, 0x3F00000, 64, 37118},
	{110357, 0x3C000000, 16, 37182},
	{88247, 0xC0000000},
	/* 4718 */
	{70831, 0x3FFF},
	{70938, 0xFFFC000},
	{71341, 0x70000000},
	{122812, 0x80000000},
	/* 4722 */
	{64526, 0x7, 8, 37082},
	{64536, 0x38, 8, 37082},
	{64546, 0x1C0, 8, 37082},
	{64556, 0xE00, 8, 37082},
	{71160, 0xF000},
	{71171, 0xF0000},
	{122823, 0x1F00000},
	{122836, 0x2000000},
	{88247, 0x4000000},
	{88234, 0x8000000},
	{220, 0xF0000000, 16, 37198},
	/* 4733 */
	{18816, 0x1FFF},
	{21532, 0x7FFE000},
	/* 4735 */
	{71297, 0x1FFF},
	{123147, 0x3FFE000},
	/* 4737 */
	{71328, 0xFFF},
	{71392, 0xFF000},
	{71365, 0x100000},
	{123158, 0xFFE00000},
	/* 4741 */
	{68938, 0x7, 8, 37214},
	{68946, 0x38, 8, 37214},
	{68954, 0x1C0, 8, 37214},
	{68962, 0xE00},
	{68978, 0x7000, 8, 37222},
	{68997, 0x8000},
	{69016, 0x70000},
	{69032, 0x80000},
	{69047, 0x100000},
	{69061, 0x7E00000},
	{69072, 0x8000000},
	{69084, 0x10000000},
	{69102, 0x60000000, 3, 37230},
	/* 4754 */
	{69159, 0x3FFF},
	{69168, 0xFC000},
	{69181, 0x300000, 4, 37233},
	{69195, 0xC00000, 4, 37233},
	{69209, 0x3000000, 3, 37237},
	{69218, 0xC000000, 3, 37240},
	{69229, 0x10000000},
	{123899, 0x20000000},
	{123916, 0x40000000},
	/* 4763 */
	{69278, 0xFFF},
	{123932, 0x20000000},
	{69295, 0xC0000000, 4, 37243},
	/* 4766 */
	{69483, 0x7},
	{69493, 0x70},
	{124074, 0x700},
	{69535, 0x3000},
	{124095, 0x70000},
	{124119, 0x700000},
	{124128, 0x3000000},
	{124148, 0x30000000},
	{124157, 0x40000000},
	/* 4775 */
	{124207, 0x3, 4, 37247},
	{69924, 0x3C, 16, 2765},
	{70352, 0x7C0, 18, 2781},
	{70542, 0x3800, 7, 2800},
	{70701, 0x1C00000, 5, 2807},
	{70721, 0x6000000},
	/* 4781 */
	{71699, 0x3F},
	{71705, 0x3C0},
	{69323, 0xC00},
	{71795, 0xFF000, 193, 2834},
	{59410, 0x100000},
	{59203, 0x200000},
	{124223, 0x400000},
	{71806, 0x800000},
	{71816, 0x1000000},
	{124234, 0xE000000},
	{124244, 0x10000000},
	/* 4792 */
	{71845, 0x1},
	{71856, 0x3E},
	{71866, 0x40},
	{71879, 0x80},
	{71891, 0xFF00},
	{59346, 0x7F0000, 257, 0},
	/* 4798 */
	{71699, 0x3F},
	{71705, 0x3C0},
	{69323, 0xC00},
	{71795, 0xFF000, 193, 2834},
	{59410, 0x100000},
	{59203, 0x200000},
	{124223, 0x400000},
	{71806, 0x800000},
	{72336, 0x3000000},
	{72350, 0x4000000},
	{124234, 0x38000000},
	{124244, 0x40000000},
	/* 4810 */
	{71845, 0x1},
	{71856, 0x3E},
	{71866, 0x40},
	{72366, 0x80},
	{72376, 0x100},
	{72388, 0x200},
	{72400, 0x400},
	{72412, 0x800},
	{72424, 0x1000},
	{59346, 0xFE000, 257, 0},
	/* 4820 */
	{71699, 0x3F},
	{71705, 0x3C0},
	{69323, 0xC00},
	{71795, 0xFF000, 193, 2834},
	{59410, 0x100000},
	{59203, 0x200000},
	{124223, 0x400000},
	{71806, 0x800000},
	{72350, 0x1000000},
	{124234, 0xE000000},
	{124244, 0x10000000},
	/* 4831 */
	{71845, 0x1},
	{71856, 0x3E},
	{71866, 0x40},
	{59346, 0x3F80, 257, 0},
	/* 4835 */
	{71845, 0x1},
	{71856, 0x3E},
	{71866, 0x40},
	{72366, 0x80},
	{59346, 0x7F00, 257, 0},
	{59779, 0x1FF00000},
	/* 4841 */
	{71699, 0x3F},
	{71705, 0x3C0},
	{69323, 0xC00},
	{71795, 0xFF000, 193, 2834},
	{59410, 0x100000},
	{59203, 0x200000},
	{124223, 0x400000},
	{71806, 0x800000},
	{124234, 0x7000000},
	{124244, 0x8000000},
	/* 4851 */
	{71845, 0x1},
	{71856, 0x3E},
	{71866, 0x40},
	{72366, 0x80},
	{72572, 0x100},
	{59346, 0xFE00, 257, 0},
	/* 4857 */
	{71699, 0x3F},
	{71705, 0x3C0},
	{69323, 0xC00},
	{71795, 0xFF000, 193, 2834},
	{59410, 0x100000},
	{59203, 0x200000},
	{124223, 0x400000},
	{71806, 0x800000},
	{72336, 0x3000000},
	{124234, 0x1C000000},
	{124244, 0x20000000},
	/* 4868 */
	{71845, 0x1},
	{71856, 0x3E},
	{71866, 0x40},
	{59779, 0xFF80},
	{59346, 0x7F0000, 257, 0},
	/* 4873 */
	{72583, 0x1},
	{72601, 0x2},
	{72615, 0x4},
	{72634, 0x8},
	{72654, 0x10},
	{72674, 0x20},
	{72696, 0x40},
	{124254, 0x380},
	{72707, 0x400},
	{72725, 0x800},
	{111502, 0x1000},
	{72757, 0x4000},
	/* 4885 */
	{54603, 0xFFF},
	/* 4886 */
	{402, 0xFF},
	{111511, 0x100},
	/* 4888 */
	{71699, 0x3F},
	{71705, 0x3C0},
	{69323, 0xC00},
	{71795, 0xFF000, 193, 2834},
	{59410, 0x100000},
	{59203, 0x200000},
	{124223, 0x400000},
	{71806, 0x800000},
	{72810, 0x1000000},
	{124244, 0x2000000},
	/* 4898 */
	{72873, 0x3F},
	{124274, 0x3F},
	{72886, 0xF000},
	{72896, 0x3F0000},
	{72911, 0x400000},
	{72926, 0x800000},
	{72942, 0x7000000},
	/* 4905 */
	{124292, 0xFFFF},
	{124302, 0xFFFF0000},
	/* 4907 */
	{43322, 0x1},
	{124312, 0x2},
	{124321, 0x4},
	{124330, 0x8},
	{124338, 0x10},
	{124350, 0x20},
	{124362, 0x40},
	{124374, 0x80},
	{124386, 0x100},
	{124397, 0x200},
	{124407, 0x400},
	{124415, 0x800},
	{124441, 0x1000},
	{124454, 0x2000},
	{124465, 0x4000},
	{124475, 0x8000},
	{124489, 0x10000},
	{124505, 0x20000},
	{124521, 0x40000},
	{124537, 0x80000},
	{124548, 0x100000},
	{124565, 0x200000},
	{124581, 0x400000},
	{124600, 0x2000000},
	{124614, 0x4000000},
	{124623, 0x8000000},
	{124637, 0x30000000},
	{124652, 0x40000000},
	{124661, 0x80000000},
	/* 4936 */
	{73263, 0x1},
	{73287, 0x2},
	{73377, 0x70},
	{73389, 0xF00},
	{73402, 0xF000},
	{73415, 0xF0000},
	{73428, 0xF00000},
	{73442, 0xF000000},
	{73460, 0xF0000000},
	/* 4945 */
	{73477, 0x7FF},
	{73504, 0xFFE000},
	{73514, 0x1000000},
	{73526, 0x2000000},
	/* 4949 */
	{124675, 0xF},
	{69924, 0xF0, 16, 2765},
	{70352, 0x1F00, 18, 2781},
	{70826, 0x6000, 4, 2812},
	{70933, 0x18000, 4, 2816},
	{71045, 0x60000, 4, 2820},
	{71132, 0x180000, 4, 2824},
	/* 4956 */
	{17670, 0x3, 4, 3051},
	{74809, 0xC},
	{70542, 0xE000, 7, 2800},
	{94624, 0x700000},
	{74960, 0x8000000},
	{74975, 0x10000000},
	{74985, 0x20000000},
	{75005, 0x80000000},
	/* 4964 */
	{17670, 0x1, 2, 3059},
	{70542, 0xE000, 7, 2800},
	{94624, 0x700000},
	{74960, 0x8000000},
	{75048, 0x20000000},
	/* 4969 */
	{124694, 0x7FF},
	{124709, 0x3FF800},
	/* 4971 */
	{124725, 0x3FFFFF},
	/* 4972 */
	{54817, 0x3},
	/* 4973 */
	{79589, 0x3F},
	{79600, 0x40},
	{79643, 0x4000},
	/* 4976 */
	{11977, 0xFF},
	/* 4977 */
	{83147, 0x8},
	{1318, 0x70, 6, 36013},
	{82420, 0xFF0000, 256, 36021},
	/* 4980 */
	{18832, 0x1F, 29, 37053},
	{86746, 0x4000},
	{86759, 0x8000},
	{86772, 0x70000},
	/* 4984 */
	{87886, 0x3F, 3, 36322},
	{87899, 0x3F00, 3, 36322},
	{87914, 0x3F0000, 3, 36322},
	{87929, 0xFC00000, 3, 36322},
	{87944, 0x80000000},
	/* 4989 */
	{214, 0x3, 2, 36326},
	{88081, 0xC, 4, 36329},
	{88161, 0x30, 3, 36333},
	{88221, 0xC0, 4, 37251},
	{88234, 0x100},
	{82588, 0x200},
	{88238, 0x400},
	/* 4996 */
	{89457, 0x3F, 60, 37255},
	{64486, 0x7FC0000},
	{89468, 0x8000000},
	/* 4999 */
	{94210, 0x1},
	{89671, 0x2},
	{124853, 0x4},
	{124876, 0x8},
	{124884, 0x3F0},
	{124899, 0xFC00},
	{89750, 0x10000},
	/* 5006 */
	{220, 0x3, 3, 36420},
	{90532, 0x1C, 4, 36423},
	{90609, 0xE0, 4, 36427},
	{90618, 0x100},
	{90638, 0x200},
	{90649, 0x3C00},
	{90671, 0x4000},
	{88221, 0x18000, 4, 37251},
	/* 5014 */
	{91038, 0x1},
	{91053, 0x2},
	{91068, 0x4},
	{91083, 0x8},
	{91098, 0x70},
	{91130, 0xF00},
	{91147, 0x80000000},
	/* 5021 */
	{93499, 0x3, 4, 36472},
	{17670, 0x7C, 24, 36476},
	{69574, 0x80},
	{94097, 0x700, 8, 36508},
	{94153, 0x1800, 4, 36516},
	{83196, 0x2000},
	{74097, 0x4000},
	{94163, 0x8000},
	{94175, 0x10000},
	{94188, 0x20000},
	{91767, 0x40000},
	{94201, 0x80000},
	{94428, 0x700000, 8, 36520},
	{94450, 0x3800000, 8, 36520},
	{94474, 0x4000000},
	/* 5036 */
	{96064, 0xF00, 5, 36564},
	{100694, 0x10000},
	{100706, 0x100000},
	{100721, 0xC0000000, 4, 36570},
	/* 5040 */
	{26958, 0xFFFF},
	{96064, 0x300000, 2, 36574},
	{100769, 0x8000000, 2, 36570},
	{100791, 0x60000000, 3, 36578},
	{100799, 0x80000000},
	/* 5045 */
	{95729, 0x1FFFFF},
	{100837, 0x200000},
	{113452, 0xC00000, 4, 37315},
	{113461, 0x3000000, 4, 37315},
	{95740, 0x4000000, 2, 36582},
	{95744, 0x8000000, 2, 36582},
	{95748, 0x10000000, 2, 36584},
	{95753, 0x20000000, 2, 36584},
	{95758, 0x40000000},
	/* 5054 */
	{100769, 0x1, 2, 36570},
	{96064, 0x300000, 2, 36574},
	{100791, 0x60000000, 3, 36578},
	{100799, 0x80000000},
	/* 5058 */
	{59184, 0xF},
	{59193, 0xF0},
	{59203, 0x100},
	{59214, 0x200},
	{59219, 0x400},
	{111443, 0x800},
	{59346, 0x1FF000, 257, 0},
	{59377, 0x10000000},
	{59383, 0xE0000000},
	/* 5067 */
	{59548, 0x1FF, 257, 0},
	{59593, 0x3F0000},
	{59646, 0xE0000000},
	/* 5070 */
	{54607, 0xF},
	{59654, 0x30},
	{59662, 0xC0},
	{59670, 0xF00},
	{59676, 0x1000},
	{29236, 0x6000},
	{59694, 0xF0000},
	{59700, 0xF00000},
	{59706, 0x7000000},
	{59715, 0x38000000},
	{59724, 0xC0000000},
	/* 5081 */
	{59805, 0xF},
	{59812, 0x70},
	{59834, 0xF00},
	{59843, 0x7000},
	/* 5085 */
	{60113, 0xF},
	{60136, 0x10},
	{60159, 0x20},
	{60182, 0x40},
	{60202, 0x80},
	{60222, 0x100},
	{60242, 0x200},
	{60262, 0x400},
	{60282, 0x800},
	{60302, 0x1000},
	{60322, 0x2000},
	{60342, 0x4000},
	{60474, 0x1000000},
	{61412, 0x2000000},
	{60492, 0x10000000},
	{60501, 0x20000000},
	{60510, 0x40000000},
	/* 5102 */
	{61029, 0x1},
	{61039, 0x2},
	{61049, 0x4},
	{61058, 0x8},
	{61067, 0x10},
	{61078, 0x20},
	{61089, 0x40},
	{61099, 0x80},
	{115413, 0x100},
	{115428, 0x200},
	{61109, 0x400},
	{61119, 0x800},
	{61136, 0x1000},
	{61254, 0x20000000},
	{61267, 0x40000000},
	{60501, 0x80000000},
	/* 5118 */
	{124939, 0x1},
	{124960, 0x2},
	{61764, 0x8},
	{61783, 0x10},
	{61803, 0x40},
	{61822, 0x100},
	{61843, 0x200},
	{61861, 0x400},
	{124981, 0x800},
	{125002, 0x1000},
	{61884, 0x2000},
	{61906, 0x10000},
	{61927, 0x20000},
	{61945, 0x40000},
	{125025, 0x80000},
	{125046, 0x100000},
	{61968, 0x200000},
	/* 5135 */
	{62083, 0x1},
	{62102, 0x2},
	{115413, 0x4},
	{115428, 0x8},
	{62111, 0x10},
	{62126, 0x20},
	{62140, 0x40},
	{62159, 0x80},
	{62178, 0x100},
	{62193, 0x200},
	{62210, 0x400},
	{62232, 0x800},
	{62254, 0x1000},
	{62269, 0x2000},
	{61109, 0x4000},
	{62284, 0x8000},
	{62429, 0x40000000},
	{60492, 0x80000000},
	/* 5153 */
	{62442, 0x1},
	{62460, 0x2},
	{62474, 0x4},
	{62493, 0x8},
	{62512, 0x10},
	{62527, 0x20},
	{62545, 0x40},
	{62563, 0x80},
	{62580, 0x100},
	{125069, 0x200},
	{62626, 0x800},
	{62650, 0x1000},
	{62668, 0x2000},
	{62686, 0x4000},
	{62707, 0x8000},
	{62731, 0x10000},
	{62757, 0x20000},
	{62774, 0x40000},
	{62794, 0x80000},
	{62814, 0x100000},
	{62834, 0x200000},
	{62855, 0x400000},
	{62878, 0x800000},
	{62899, 0x1000000},
	{62918, 0x2000000},
	{62935, 0x4000000},
	{62951, 0x8000000},
	{62967, 0x10000000},
	{62983, 0x20000000},
	{63002, 0x40000000},
	{63014, 0x80000000},
	/* 5184 */
	{63026, 0x1},
	{63045, 0x2},
	{63065, 0x4},
	{63085, 0x8},
	{114103, 0x10},
	{63105, 0x20},
	{63126, 0x40},
	/* 5191 */
	{119683, 0x1F},
	{119690, 0x20},
	{64173, 0x80},
	{59489, 0xF00},
	{119697, 0x3000},
	{64186, 0x4000},
	{64199, 0x8000},
	{119708, 0xFFFF0000},
	{119708, 0xFFFF0000},
	/* 5200 */
	{10362, 0xF},
	{88234, 0x10},
	/* 5202 */
	{125091, 0xFFFF},
	/* 5203 */
	{64325, 0x3FF},
	{64340, 0x3FF0000},
	{119759, 0x20000000},
	{60363, 0x40000000},
	{72786, 0x80000000},
	/* 5208 */
	{95252, 0xFFFF},
	{95264, 0x10000},
	{27021, 0xE0000000},
	/* 5211 */
	{125101, 0x1000},
	{95360, 0x6000},
	{125109, 0x8000},
	{95389, 0x300000},
	{125122, 0x1000000},
	{95400, 0x6000000},
	{125130, 0x8000000},
	{95429, 0x60000000},
	/* 5219 */
	{125143, 0x7F},
	{125155, 0x3F000},
	{11957, 0x6000000},
	{96043, 0x8000000},
	/* 5223 */
	{28011, 0xFFFF},
	{96064, 0x30000},
	{96072, 0x7000000},
	{96080, 0xE0000000},
	/* 5227 */
	{97056, 0x3F},
	{97061, 0xC0},
	{97069, 0x100},
	{97075, 0xFFFFFE00},
	/* 5231 */
	{85180, 0x1},
	{983, 0x1FFE},
	{220, 0x2000},
	{93061, 0x4000},
	{97083, 0x8000},
	{97095, 0x7FF0000},
	{97106, 0x8000000},
	{97117, 0x10000000},
	{97061, 0xE0000000},
	/* 5240 */
	{97230, 0x3F},
	{97240, 0xFC00},
	/* 5242 */
	{97189, 0x3F},
	{97198, 0xFC00},
	{98746, 0xF00000},
	/* 5245 */
	{97189, 0xFF},
	{98882, 0xF000},
	{119584, 0xF0000},
	{50401, 0xF00000},
	{119600, 0xF000000},
	{98800, 0xF0000000},
	/* 5251 */
	{56194, 0xFF},
	{10733, 0xFFFFFF00},
	/* 5253 */
	{26958, 0xFFFF},
	{96064, 0x300000, 4, 37319},
	{100769, 0x8000000, 2, 36570},
	{100791, 0x60000000, 4, 36578},
	{100799, 0x80000000},
	/* 5258 */
	{100769, 0x1, 2, 36570},
	{95360, 0x6000},
	{96064, 0x300000, 4, 37319},
	{95400, 0x6000000},
	{100791, 0x60000000, 4, 36578},
	{100799, 0x80000000},
	/* 5264 */
	{59184, 0xF},
	{59193, 0xF0},
	{59203, 0x100},
	{59214, 0x200},
	{59219, 0x400},
	{111443, 0x800},
	{59346, 0x1FF000, 257, 0},
	{125172, 0x8000000},
	{59377, 0x10000000},
	{59383, 0xE0000000},
	/* 5274 */
	{59387, 0x1},
	{59391, 0x6},
	{59400, 0x18},
	{59410, 0x20},
	{59415, 0x40},
	{59423, 0x80},
	{59433, 0x100},
	{59444, 0x200},
	{59450, 0x400},
	{59455, 0x800},
	{59461, 0x1000},
	{59472, 0x2000},
	{59477, 0x4000},
	{111462, 0x8000},
	{59233, 0x10000},
	{59497, 0x20000},
	{59505, 0x40000},
	{59517, 0x80000},
	{111475, 0x100000},
	{111489, 0x200000},
	{125183, 0x400000},
	{111511, 0x800000},
	{59536, 0x8000000},
	/* 5297 */
	{59548, 0x1FF, 257, 0},
	{59553, 0x400},
	{59593, 0x3F0000},
	{59646, 0xE0000000},
	/* 5301 */
	{59805, 0xF},
	{59812, 0x70},
	{59834, 0xF00},
	{59843, 0x7000},
	{59852, 0x8000},
	{59865, 0xF0000},
	/* 5307 */
	{111540, 0x7},
	{111548, 0x8},
	{111559, 0x10},
	{111572, 0xE0},
	{111588, 0x300},
	{111598, 0xC00},
	{111608, 0xF0000},
	{59968, 0xF00000},
	{111620, 0x3000000},
	{111627, 0x4000000},
	{111634, 0x18000000},
	{73755, 0x20000000},
	{111642, 0x40000000},
	/* 5320 */
	{125196, 0x1},
	{59913, 0x2},
	{59919, 0x4},
	{59948, 0xF0},
	{59953, 0xF00},
	/* 5325 */
	{60113, 0xF},
	{60136, 0x10},
	{60159, 0x20},
	{60182, 0x40},
	{60202, 0x80},
	{60222, 0x100},
	{60242, 0x200},
	{60262, 0x400},
	{60282, 0x800},
	{60302, 0x1000},
	{60322, 0x2000},
	{60342, 0x4000},
	{60474, 0x1000000},
	{61412, 0x2000000},
	{125203, 0x4000000},
	{60492, 0x10000000},
	{60501, 0x20000000},
	{60510, 0x40000000},
	/* 5343 */
	{61029, 0x1},
	{61039, 0x2},
	{61049, 0x4},
	{61058, 0x8},
	{61067, 0x10},
	{61078, 0x20},
	{61089, 0x40},
	{61099, 0x80},
	{61109, 0x400},
	{61119, 0x800},
	{61136, 0x1000},
	{125219, 0x2000},
	{61254, 0x20000000},
	{61267, 0x40000000},
	{60501, 0x80000000},
	/* 5358 */
	{61764, 0x8},
	{61783, 0x10},
	{61803, 0x40},
	{61822, 0x100},
	{61843, 0x200},
	{61861, 0x400},
	{61884, 0x2000},
	{61906, 0x10000},
	{61927, 0x20000},
	{61945, 0x40000},
	{61968, 0x200000},
	{125232, 0x400000},
	{125256, 0x800000},
	{125280, 0x1000000},
	/* 5372 */
	{62083, 0x1},
	{62102, 0x2},
	{62111, 0x10},
	{62126, 0x20},
	{62140, 0x40},
	{62159, 0x80},
	{62178, 0x100},
	{62193, 0x200},
	{62210, 0x400},
	{62232, 0x800},
	{62254, 0x1000},
	{62269, 0x2000},
	{61109, 0x4000},
	{62284, 0x8000},
	{62293, 0x10000},
	{125219, 0x20000},
	{62384, 0x4000000},
	{62397, 0x8000000},
	{62410, 0x30000000},
	{62429, 0x40000000},
	{60492, 0x80000000},
	/* 5393 */
	{63026, 0x1},
	{63045, 0x2},
	{63065, 0x4},
	{63085, 0x8},
	{63105, 0x20},
	{63126, 0x40},
	{125232, 0x80},
	{125256, 0x100},
	{125280, 0x200},
	/* 5402 */
	{64526, 0x7, 8, 37082},
	{64536, 0x38, 8, 37082},
	{64546, 0x1C0, 8, 37082},
	{64556, 0xE00, 8, 37082},
	{110357, 0x7000, 8, 37323},
	{110345, 0x78000, 16, 37098},
	{120729, 0x180000},
	{68793, 0x600000},
	{68806, 0x800000},
	{88234, 0x1000000},
	{120742, 0x2000000},
	{120754, 0x4000000},
	{88247, 0x38000000},
	{220, 0xC0000000, 4, 37114},
	/* 5416 */
	{64481, 0xFF},
	{69127, 0xFFF00},
	{110345, 0x3F00000, 64, 37118},
	{110357, 0x3C000000, 16, 37331},
	{88247, 0xC0000000},
	/* 5421 */
	{71328, 0xFFF},
	{71392, 0xFF000},
	{71365, 0x100000},
	{71514, 0x200000},
	{71529, 0x400000},
	{71545, 0x800000},
	{125463, 0xF000000},
	{125479, 0xF0000000},
	/* 5429 */
	{68938, 0x7, 8, 37214},
	{68946, 0x38, 8, 37214},
	{68954, 0x1C0, 8, 37214},
	{68962, 0xE00},
	{68978, 0x7000, 8, 37222},
	{68997, 0x8000},
	{69016, 0x70000},
	{69032, 0x80000},
	{69047, 0x100000},
	{69061, 0x7E00000},
	{69072, 0x8000000},
	{69084, 0x10000000},
	{69102, 0x60000000, 3, 37230},
	{125495, 0x80000000},
	/* 5443 */
	{69159, 0x3FFF},
	{69168, 0xFC000},
	{69181, 0x300000, 4, 37233},
	{69195, 0xC00000, 4, 37233},
	{69209, 0x3000000, 3, 37237},
	{69218, 0xC000000, 4, 37347},
	{69229, 0x10000000},
	{123899, 0x20000000},
	{123916, 0x40000000},
	{69248, 0x80000000},
	/* 5453 */
	{71845, 0x1},
	{71856, 0x3E},
	{71866, 0x40},
	{72366, 0x80},
	{72376, 0x100},
	{72388, 0x200},
	{72400, 0x400},
	{72412, 0x800},
	{72424, 0x1000},
	{59346, 0x3FE000, 257, 0},
	{72441, 0x1000000},
	/* 5464 */
	{88234, 0x1},
	{88247, 0x6},
	/* 5466 */
	{17670, 0x3, 4, 3051},
	{74809, 0xC},
	{70542, 0xE000, 7, 2800},
	{94624, 0x700000},
	{74936, 0x7800000},
	{74960, 0x8000000},
	{74975, 0x10000000},
	{74985, 0x20000000},
	{125541, 0x40000000},
	{75005, 0x80000000},
	/* 5476 */
	{17670, 0x1, 2, 3059},
	{70542, 0xE000, 7, 2800},
	{94624, 0x700000},
	{74960, 0x8000000},
	{75048, 0x20000000},
	{125541, 0x40000000},
	/* 5482 */
	{78137, 0x1},
	{125558, 0x2},
	{78164, 0x7C},
	/* 5485 */
	{83147, 0x8},
	{1318, 0x70, 7, 36013},
	{82420, 0xFF0000, 256, 36021},
	/* 5488 */
	{84892, 0x1},
	{84908, 0x2},
	{84924, 0x4},
	{84940, 0x8},
	{84956, 0x10},
	{84972, 0x20},
	{84988, 0x40},
	{85004, 0x80},
	{85020, 0x100},
	{85036, 0x200},
	{85052, 0x400},
	{85068, 0x800},
	{85084, 0x1000},
	{85100, 0x2000},
	{85116, 0x4000},
	{85132, 0x8000},
	{85148, 0x10000},
	{85167, 0x20000},
	{85185, 0x40000},
	{85212, 0x80000},
	{85234, 0x100000},
	{85252, 0x200000},
	{85272, 0x400000},
	{85295, 0x800000},
	{85318, 0x1000000},
	{85343, 0x2000000},
	{85386, 0x4000000},
	/* 5515 */
	{1318, 0x7, 6, 36312},
	{86939, 0x8},
	{86995, 0x30, 4, 36318},
	{87004, 0x7C0},
	{87015, 0x800},
	{87028, 0x1000},
	{87039, 0x2000},
	{97387, 0x4000},
	{125597, 0x8000},
	{125608, 0x10000},
	{87098, 0x20000},
	{87117, 0x40000},
	{87131, 0x80000},
	{87149, 0x100000},
	{87167, 0x600000},
	/* 5530 */
	{214, 0x3, 3, 36326},
	{88081, 0xC, 4, 36329},
	{88161, 0x30, 4, 36333},
	{88221, 0x40, 2, 36337},
	{82588, 0x200},
	{88238, 0x400},
	{88247, 0x1800},
	/* 5537 */
	{89457, 0x3F, 61, 37351},
	{64486, 0x7FC0000},
	{89468, 0x8000000},
	/* 5540 */
	{89573, 0xFFFF},
	{89588, 0x10000},
	{89607, 0x20000},
	{89621, 0x40000},
	{89640, 0x80000},
	{89654, 0x100000},
	{90298, 0xF0000000},
	/* 5547 */
	{94210, 0x1},
	{89671, 0x2},
	{124853, 0x4},
	{124876, 0x8},
	{124884, 0x3F0},
	{124899, 0xFC00},
	{89750, 0x10000},
	{125619, 0x20000},
	/* 5555 */
	{220, 0x3, 3, 36420},
	{90532, 0x1C, 4, 36423},
	{90609, 0xE0, 4, 36427},
	{90618, 0x100},
	{90638, 0x200},
	{90649, 0x3C00},
	{90671, 0x4000},
	{88221, 0x8000, 2, 36337},
	{90705, 0x60000, 3, 36431},
	{88247, 0x180000},
	/* 5565 */
	{93499, 0x3, 4, 36472},
	{17670, 0x7C, 24, 36476},
	{69574, 0x80},
	{94097, 0x700, 8, 36508},
	{94153, 0x1800, 4, 36516},
	{83196, 0x2000},
	{74097, 0x4000},
	{94163, 0x8000},
	{94175, 0x10000},
	{94188, 0x20000},
	{91767, 0x40000},
	{94201, 0x80000},
	{94428, 0x700000, 8, 36520},
	{94450, 0x3800000, 8, 36520},
	{94474, 0x4000000},
	{94500, 0x8000000},
	{94526, 0x10000000},
	{94594, 0x60000000, 3, 36528},
	/* 5583 */
	{11957, 0x2000000},
	{88247, 0x18000000},
	/* 5585 */
	{95252, 0xFFFF},
	{95264, 0x10000},
	{95180, 0x2000000},
	{88247, 0x18000000},
	{27021, 0xE0000000},
	/* 5590 */
	{26589, 0xFFFF},
	{88247, 0x300000},
	{95180, 0x400000},
	/* 5593 */
	{26661, 0xFFFF},
	{88247, 0x300000},
	{95180, 0x400000},
	/* 5596 */
	{125633, 0xC00},
	{125101, 0x1000},
	{95360, 0x2000},
	{95389, 0x300000},
	{125643, 0xC00000},
	{125122, 0x1000000},
	{95400, 0x2000000},
	{95429, 0x60000000},
	/* 5604 */
	{96243, 0x1},
	{96259, 0x2},
	{125653, 0x4},
	{95477, 0x8},
	{96275, 0x40},
	{96293, 0x80},
	{96311, 0x100},
	{96329, 0x200},
	{96347, 0x400},
	{96365, 0x800},
	{96383, 0x1000},
	{96401, 0x2000},
	{96419, 0x4000},
	{95538, 0x8000},
	{95558, 0x40000},
	{96436, 0x80000},
	{96452, 0x200000},
	{95575, 0x400000},
	{95591, 0x800000},
	{95605, 0x2000000},
	{95619, 0x4000000},
	{95633, 0x8000000},
	{95654, 0x10000000},
	{95679, 0x20000000},
	{95700, 0x40000000},
	{125670, 0x80000000},
	/* 5630 */
	{125143, 0x7F},
	{125155, 0x3F000},
	{11957, 0x2000000},
	{88247, 0x18000000},
	/* 5634 */
	{97134, 0xFFFF},
	{97158, 0xF0000},
	{97145, 0x300000},
	{96536, 0x3FC00000},
	{97166, 0x40000000},
	{10250, 0x80000000},
	/* 5640 */
	{64481, 0xFF},
	{69127, 0xFFF00},
	{110345, 0x3F00000, 64, 37412},
	{110357, 0x3C000000, 16, 37331},
	{88247, 0xC0000000},
	/* 5645 */
	{83129, 0x1},
	{83147, 0x8},
	{1318, 0x70, 7, 36013},
	{82420, 0xFF0000, 256, 36021},
	/* 5649 */
	{89915, 0xFF},
	{89929, 0xFF00},
	{89939, 0xFF0000},
	{89950, 0xFF000000},
	/* 5653 */
	{93499, 0x3, 4, 36472},
	{17670, 0x7C, 31, 36476},
	{69574, 0x80},
	{94097, 0x700, 8, 36508},
	{94153, 0x1800, 4, 36516},
	{83196, 0x2000},
	{74097, 0x4000},
	{94163, 0x8000},
	{94175, 0x10000},
	{94188, 0x20000},
	{91767, 0x40000},
	{94201, 0x80000},
	{94428, 0x700000, 8, 36520},
	{94450, 0x3800000, 8, 36520},
	{94474, 0x4000000},
	{94500, 0x8000000},
	{94526, 0x10000000},
	{94594, 0x60000000, 3, 36528},
	/* 5671 */
	{85180, 0x1},
	{983, 0x1FFE},
	{220, 0x2000},
	{93061, 0x4000},
	{97083, 0x8000},
	{97095, 0xFFF0000},
	{97106, 0x10000000},
	{97117, 0x20000000},
	{97061, 0xC0000000},
	/* 5680 */
	{59184, 0xF},
	{59193, 0xF0},
	{59203, 0x100},
	{59214, 0x200},
	{59219, 0x400},
	{111443, 0x800},
	{59346, 0x1FF000, 257, 0},
	{59354, 0x800000},
	{125988, 0x1000000},
	{126001, 0x2000000},
	{59364, 0x4000000},
	{125172, 0x8000000},
	{59377, 0x10000000},
	{59383, 0xE0000000},
	/* 5694 */
	{59387, 0x1},
	{59391, 0x6},
	{59400, 0x18},
	{59410, 0x20},
	{59415, 0x40},
	{59423, 0x80},
	{59433, 0x100},
	{59444, 0x200},
	{59450, 0x400},
	{59455, 0x800},
	{59461, 0x1000},
	{59472, 0x2000},
	{59477, 0x4000},
	{111462, 0x8000},
	{59233, 0x10000},
	{59497, 0x20000},
	{59505, 0x40000},
	{59517, 0x80000},
	{111475, 0x100000},
	{111489, 0x200000},
	{125183, 0x400000},
	{59525, 0x800000},
	{59536, 0x8000000},
	/* 5717 */
	{59548, 0x1FF, 257, 0},
	{59553, 0x400},
	{59561, 0x800},
	{59574, 0x7000},
	{59593, 0x3F0000},
	{59634, 0x10000000},
	{59646, 0xE0000000},
	/* 5724 */
	{59805, 0xF},
	{59812, 0x70},
	{59834, 0xF00},
	{59843, 0x7000},
	{59852, 0x8000},
	{59865, 0x1F0000},
	{59870, 0xC00000},
	/* 5731 */
	{111540, 0x7},
	{111548, 0x8},
	{111559, 0x10},
	{111572, 0xE0},
	{111588, 0x300},
	{111598, 0xC00},
	{111608, 0xF0000},
	{111620, 0x3000000},
	{111627, 0x4000000},
	{111634, 0x18000000},
	{73755, 0x20000000},
	{111642, 0x40000000},
	{126014, 0x80000000},
	/* 5744 */
	{125196, 0x1},
	{59913, 0x2},
	{59919, 0x4},
	{59948, 0x1F0},
	{59953, 0xF800},
	{59865, 0x7C0000},
	{59968, 0xFE000000},
	/* 5751 */
	{60113, 0xF},
	{60136, 0x10},
	{60159, 0x20},
	{60182, 0x40},
	{60202, 0x80},
	{60222, 0x100},
	{60242, 0x200},
	{60262, 0x400},
	{60282, 0x800},
	{60302, 0x1000},
	{60322, 0x2000},
	{60342, 0x4000},
	{60357, 0x8000},
	{60368, 0x10000},
	{60376, 0x20000},
	{60385, 0x40000},
	{60402, 0x80000},
	{60417, 0x100000},
	{60474, 0x1000000},
	{61412, 0x2000000},
	{125203, 0x4000000},
	{60492, 0x10000000},
	{60501, 0x20000000},
	{60510, 0x40000000},
	{60519, 0x80000000},
	/* 5776 */
	{60530, 0xF},
	{60553, 0x20},
	{60569, 0x80},
	{60592, 0x100},
	{60615, 0x200},
	{60634, 0x1000},
	{60643, 0x2000},
	{60652, 0x4000},
	{60660, 0x8000},
	{112315, 0x10000},
	{112330, 0x20000},
	{112339, 0x40000},
	{112354, 0x80000},
	{60684, 0x100000},
	{112362, 0x200000},
	{60700, 0x400000},
	{60709, 0x800000},
	{60718, 0x1000000},
	{60726, 0x2000000},
	{60734, 0x4000000},
	{60742, 0x10000000},
	{60484, 0x20000000},
	{60760, 0x40000000},
	{60768, 0x80000000},
	/* 5800 */
	{60634, 0x2},
	{60643, 0x4},
	{60376, 0x200000},
	{60709, 0x400000},
	{112330, 0x800000},
	{60726, 0x1000000},
	{60652, 0x2000000},
	{60684, 0x4000000},
	{60700, 0x8000000},
	{60718, 0x20000000},
	{60734, 0x40000000},
	{60760, 0x80000000},
	/* 5812 */
	{61029, 0x1},
	{61039, 0x2},
	{61049, 0x4},
	{61058, 0x8},
	{61067, 0x10},
	{61078, 0x20},
	{61089, 0x40},
	{61099, 0x80},
	{61109, 0x400},
	{61119, 0x800},
	{61136, 0x1000},
	{61144, 0x2000},
	{61157, 0x4000},
	{61254, 0x20000000},
	{61267, 0x40000000},
	{60501, 0x80000000},
	/* 5828 */
	{62083, 0x1},
	{62102, 0x2},
	{62111, 0x10},
	{62126, 0x20},
	{62140, 0x40},
	{62159, 0x80},
	{62178, 0x100},
	{62193, 0x200},
	{62210, 0x400},
	{62232, 0x800},
	{62254, 0x1000},
	{62269, 0x2000},
	{61109, 0x4000},
	{62284, 0x8000},
	{62293, 0x10000},
	{61144, 0x20000},
	{62384, 0x4000000},
	{62397, 0x8000000},
	{62410, 0x30000000},
	{62429, 0x40000000},
	{60492, 0x80000000},
	/* 5849 */
	{64526, 0x7, 8, 37082},
	{64536, 0x38, 8, 37082},
	{64546, 0x1C0, 8, 37082},
	{64556, 0xE00, 8, 37082},
	{110357, 0x7000, 8, 37476},
	{110345, 0x78000, 16, 37098},
	{126059, 0x80000},
	{126074, 0x100000},
	{68793, 0x600000},
	{68806, 0x800000},
	{86833, 0x8000000},
	{220, 0xC0000000, 4, 37114},
	/* 5861 */
	{64481, 0xFF},
	{69127, 0xFFF00},
	{110345, 0x3F00000, 64, 37484},
	{126558, 0x3F00000, 61, 37548},
	{110357, 0x3C000000, 16, 37609},
	{127065, 0x3C000000, 16, 37625},
	{86833, 0x40000000},
	{127082, 0x80000000},
	/* 5869 */
	{64526, 0x7, 8, 37082},
	{64536, 0x38, 8, 37082},
	{64546, 0x1C0, 8, 37082},
	{64556, 0xE00, 8, 37082},
	{71160, 0xF000},
	{71171, 0xF0000},
	{71182, 0x1F00000},
	{220, 0xF0000000, 16, 37198},
	/* 5877 */
	{18816, 0x1FFF},
	{21532, 0x1FFFE000},
	{71286, 0xE0000000, 6, 2828},
	/* 5880 */
	{71297, 0x1FFF},
	{71308, 0x1E000},
	{127094, 0x1FE0000},
	{95074, 0x2000000},
	{71474, 0x4000000},
	{127112, 0x8000000},
	{71320, 0xF0000000},
	/* 5887 */
	{69159, 0x3FFF},
	{69168, 0xFC000},
	{69181, 0x300000, 4, 37233},
	{69195, 0xC00000, 4, 37233},
	{69209, 0x3000000, 3, 37237},
	{69218, 0xC000000, 4, 37347},
	{69229, 0x10000000},
	{69263, 0x20000000},
	{123916, 0x40000000},
	{69248, 0x80000000},
	/* 5897 */
	{69278, 0xFFF},
	{69114, 0x1000},
	{69295, 0xC0000000, 4, 37243},
	/* 5900 */
	{69483, 0x7},
	{69493, 0x38},
	{69514, 0xC0},
	{124074, 0x700},
	{71132, 0x7000, 4, 2824},
	{124095, 0x70000},
	{69535, 0x180000},
	{124119, 0xE00000},
	{124128, 0x3000000},
	{69554, 0xC000000},
	{124148, 0x30000000},
	{124157, 0x40000000},
	{127128, 0x80000000},
	/* 5913 */
	{71654, 0xFFFF},
	{71660, 0x3F0000},
	{71671, 0x3C00000},
	{127138, 0x3C000000},
	/* 5917 */
	{71699, 0x3F},
	{71705, 0x3C0},
	{69323, 0xC00},
	{71795, 0xFF000, 193, 2834},
	{59410, 0x100000},
	{59203, 0x200000},
	{124223, 0x400000},
	{71806, 0x800000},
	{71816, 0x1000000},
	{124244, 0x10000000},
	{59354, 0x20000000},
	/* 5928 */
	{71845, 0x1},
	{71856, 0x3E},
	{71866, 0x40},
	{71879, 0x80},
	{71891, 0xFF00},
	{59346, 0x1FF0000, 257, 0},
	{71906, 0x2000000},
	{71928, 0x4000000},
	{72458, 0x8000000},
	{71953, 0x10000000},
	/* 5938 */
	{71699, 0x3F},
	{71705, 0x3C0},
	{69323, 0xC00},
	{71795, 0xFF000, 193, 2834},
	{59410, 0x100000},
	{59203, 0x200000},
	{124223, 0x400000},
	{71806, 0x800000},
	{72336, 0x3000000},
	{72350, 0x4000000},
	{124244, 0x40000000},
	{59354, 0x80000000},
	/* 5950 */
	{71845, 0x1},
	{71856, 0x3E},
	{71866, 0x40},
	{72366, 0x80},
	{72376, 0x100},
	{72388, 0x200},
	{72400, 0x400},
	{72412, 0x800},
	{72424, 0x1000},
	{59346, 0x3FE000, 257, 0},
	{72430, 0x400000},
	{72441, 0x1000000},
	{72458, 0x8000000},
	{71953, 0x10000000},
	/* 5964 */
	{72495, 0x7F},
	{72470, 0x3F80},
	/* 5966 */
	{71699, 0x3F},
	{71705, 0x3C0},
	{69323, 0xC00},
	{71795, 0xFF000, 193, 2834},
	{59410, 0x100000},
	{59203, 0x200000},
	{124223, 0x400000},
	{71806, 0x800000},
	{72350, 0x1000000},
	{124244, 0x10000000},
	{72521, 0x60000000},
	{59354, 0x80000000},
	/* 5978 */
	{71845, 0x1},
	{71856, 0x3E},
	{71866, 0x40},
	{59346, 0xFF80, 257, 0},
	{72538, 0x30000},
	{72366, 0x40000},
	{59779, 0x7F80000},
	{72458, 0x8000000},
	{71953, 0x10000000},
	/* 5987 */
	{71660, 0x3F},
	{71671, 0x3C0},
	{127138, 0x3C00},
	{71654, 0xFFFF0000},
	/* 5991 */
	{71699, 0x3F},
	{71705, 0x3C0},
	{69323, 0xC00},
	{71795, 0xFF000, 193, 2834},
	{59410, 0x100000},
	{59203, 0x200000},
	{124223, 0x400000},
	{71806, 0x800000},
	{124244, 0x8000000},
	{72555, 0x30000000},
	{59354, 0x40000000},
	/* 6002 */
	{71845, 0x1},
	{71856, 0x3E},
	{71866, 0x40},
	{59346, 0xFF80, 257, 0},
	{59779, 0x1FF0000},
	{72458, 0x8000000},
	{71953, 0x10000000},
	/* 6009 */
	{72583, 0x1},
	{72601, 0x2},
	{72615, 0x4},
	{72634, 0x8},
	{72654, 0x10},
	{72674, 0x20},
	{72696, 0x40},
	{72707, 0x400},
	{72725, 0x800},
	{10733, 0x1000},
	{72757, 0x4000},
	/* 6020 */
	{71699, 0x3F},
	{71705, 0x3C0},
	{69323, 0xC00},
	{71795, 0xFF000, 193, 2834},
	{59410, 0x100000},
	{59203, 0x200000},
	{124223, 0x400000},
	{71806, 0x800000},
	{72810, 0x1000000},
	{124244, 0x2000000},
	{59354, 0x4000000},
	/* 6031 */
	{71845, 0x1},
	{71856, 0x3E},
	{71866, 0x40},
	{72816, 0x80},
	{72826, 0x100},
	{72836, 0x200},
	{72572, 0x400},
	{72846, 0x1800},
	{72861, 0x6000},
	{59779, 0xFF8000},
	{59346, 0x7F000000, 257, 0},
	{72458, 0x80000000},
	/* 6043 */
	{72873, 0x3FF},
	{72886, 0xF000},
	{72896, 0x3F0000},
	{72911, 0x400000},
	{72926, 0x800000},
	{72942, 0x7000000},
	{127138, 0x78000000},
	/* 6050 */
	{73477, 0x7FF},
	{73504, 0xFFE000},
	{73514, 0x1000000},
	{73526, 0x2000000},
	{73544, 0x3C000000},
	/* 6055 */
	{17670, 0x3, 4, 3051},
	{74809, 0xC},
	{71182, 0x1F0},
	{74893, 0x1000},
	{74864, 0x6000, 4, 3055},
	{74879, 0x8000},
	{74929, 0xF0000},
	{74936, 0x7800000},
	{74960, 0x8000000},
	{74975, 0x10000000},
	{74985, 0x20000000},
	{125541, 0x40000000},
	{75005, 0x80000000},
	/* 6068 */
	{17670, 0x1, 2, 3059},
	{71182, 0x1F0},
	{74893, 0x1000},
	{74864, 0x6000, 4, 3055},
	{74879, 0x8000},
	{74960, 0x8000000},
	{75048, 0x20000000},
	{125541, 0x40000000},
	/* 6076 */
	{58864, 0xFFFF},
	/* 6077 */
	{75878, 0x3, 4, 35838},
	{75890, 0xC, 4, 35838},
	{76002, 0x30, 4, 35842},
	{76059, 0x40, 2, 35846},
	{76115, 0x80, 2, 35848},
	{76219, 0x300, 4, 35850},
	{76327, 0xC00, 4, 35854},
	{76436, 0x3000, 4, 35858},
	{76549, 0xC000, 4, 35862},
	{76651, 0x30000, 4, 35866},
	{76797, 0xC0000, 4, 35870},
	{76944, 0x300000, 4, 35874},
	{77044, 0x3000000, 4, 35878},
	{77190, 0x1C000000, 5, 37641},
	{77337, 0xE0000000, 5, 37646},
	/* 6092 */
	{77457, 0x3, 4, 35890},
	{77628, 0x1C, 5, 37651},
	{77800, 0xE0, 5, 37656},
	/* 6095 */
	{78137, 0x1},
	{125558, 0x2},
	{78164, 0x7C},
	{78193, 0x100},
	{78222, 0x200},
	{78253, 0x400},
	{78281, 0x1000},
	{78309, 0x2000},
	{78339, 0x4000},
	/* 6104 */
	{84892, 0x1},
	{84908, 0x2},
	{84924, 0x4},
	{84940, 0x8},
	{84956, 0x10},
	{84972, 0x20},
	{84988, 0x40},
	{85004, 0x80},
	{85020, 0x100},
	{85036, 0x200},
	{85052, 0x400},
	{85068, 0x800},
	{85084, 0x1000},
	{85100, 0x2000},
	{85116, 0x4000},
	{85132, 0x8000},
	{85148, 0x10000},
	{85167, 0x20000},
	{85185, 0x40000},
	{85212, 0x80000},
	{85234, 0x100000},
	{85252, 0x200000},
	{85272, 0x400000},
	{85295, 0x800000},
	{85318, 0x1000000},
	{85343, 0x2000000},
	{85386, 0x4000000},
	{85363, 0x8000000},
	/* 6132 */
	{86059, 0x1},
	{86070, 0x2},
	{127305, 0x4},
	/* 6135 */
	{96837, 0x1},
	{86240, 0x1E},
	{86252, 0xE0},
	{86266, 0x300},
	{86282, 0x1C00},
	{86293, 0x1E000},
	/* 6141 */
	{214, 0x3, 3, 36326},
	{88081, 0xC, 4, 36329},
	{88161, 0x30, 4, 36333},
	{88221, 0x40, 2, 36337},
	{90271, 0x100},
	{82588, 0x200},
	{88238, 0x400},
	/* 6148 */
	{89457, 0x3F, 64, 37661},
	{64486, 0x7FFFC00},
	{89468, 0x8000000},
	/* 6151 */
	{58983, 0xFFFF},
	/* 6152 */
	{89498, 0x1},
	{89512, 0x2},
	{127368, 0x4},
	{89528, 0x8},
	/* 6156 */
	{89671, 0x2},
	{124853, 0x4},
	{124876, 0x8},
	{124884, 0x3F0},
	{124899, 0xFC00},
	{89750, 0x10000},
	{71479, 0x40000},
	{127117, 0x80000},
	/* 6164 */
	{90022, 0x3, 4, 36404},
	{90053, 0x4, 2, 36408},
	{20126, 0x18, 4, 36410},
	{90135, 0x20, 2, 36414},
	{90200, 0xC0, 4, 36416},
	{72441, 0x200},
	{90217, 0x400},
	{90237, 0x800},
	{90257, 0x1000},
	{90271, 0x2000},
	{90282, 0x4000},
	{90298, 0x78000},
	{90318, 0x180000},
	/* 6177 */
	{220, 0x3, 3, 36420},
	{90532, 0x1C, 4, 36423},
	{90609, 0xE0, 4, 36427},
	{90618, 0x100},
	{90638, 0x200},
	{90671, 0x4000},
	{88221, 0x8000, 2, 36337},
	{90705, 0x60000, 4, 36431},
	/* 6185 */
	{73477, 0x7FF},
	{73504, 0xFFE000},
	{93438, 0xF000000},
	/* 6188 */
	{93499, 0x3, 4, 36472},
	{17670, 0x7C, 32, 36476},
	{94097, 0x700, 8, 36508},
	{94153, 0x1800, 4, 36516},
	{83196, 0x2000},
	{74097, 0x4000},
	{94163, 0x8000},
	{94175, 0x10000},
	{94188, 0x20000},
	{91767, 0x40000},
	{94428, 0x700000, 8, 36520},
	{94450, 0x3800000, 8, 36520},
	{94474, 0x4000000},
	{94500, 0x8000000},
	{94526, 0x10000000},
	{94594, 0x60000000, 3, 36528},
	/* 6204 */
	{95063, 0x7FF},
	{95074, 0x800},
	{74809, 0x7000},
	{94680, 0x18000},
	{94694, 0x20000},
	{95086, 0x7C0000},
	{95100, 0xF800000},
	{95114, 0x30000000},
	{127117, 0x40000000},
	{71479, 0x80000000},
	/* 6214 */
	{95252, 0xFFFF},
	{95264, 0x10000},
	{95180, 0x2000000},
	{27021, 0xE0000000},
	/* 6218 */
	{26589, 0xFFFF},
	{95180, 0x400000},
	/* 6220 */
	{26661, 0xFFFF},
	{95180, 0x400000},
	/* 6222 */
	{95347, 0x400},
	{95360, 0x2000},
	{95389, 0x300000},
	{95400, 0x2000000},
	{95429, 0x60000000},
	/* 6227 */
	{95774, 0x1},
	{95808, 0x30},
	{95820, 0xF0000},
	{95833, 0x10000000},
	{95848, 0x20000000},
	{95862, 0xC0000000},
	/* 6233 */
	{125143, 0x7F},
	{125155, 0x3F000},
	{95180, 0x2000000},
	{96056, 0x10000000},
	/* 6237 */
	{96486, 0xF},
	{96498, 0xF0},
	{112476, 0xF00},
	{127387, 0xF000},
	{96526, 0x30000},
	{96536, 0xC0000},
	{10250, 0x100000},
	{10733, 0xFFE00000},
	/* 6245 */
	{214, 0x3, 3, 36326},
	{90271, 0x100},
	/* 6247 */
	{119767, 0x7},
	{119775, 0x38},
	{119783, 0x1C0},
	{119791, 0xE00},
	{119799, 0x7000},
	{119807, 0x38000},
	{119815, 0x1C0000},
	{1318, 0x600000},
	{119823, 0x1800000},
	{119836, 0x2000000},
	{127396, 0x4000000},
	{119849, 0x18000000},
	{119860, 0x20000000},
	{64146, 0x40000000},
	{69097, 0x80000000},
	/* 6262 */
	{64325, 0x3FF},
	{64340, 0x3FF0000},
	{101134, 0x10000000},
	{119759, 0x20000000},
	{60363, 0x40000000},
	{72786, 0x80000000},
	/* 6268 */
	{85180, 0x1},
	{983, 0x1FFE},
	{220, 0x2000},
	{93061, 0x4000},
	{97083, 0x8000},
	{97095, 0xFFF0000},
	{97106, 0x10000000},
	{97117, 0x20000000},
	{97127, 0x40000000},
	{97061, 0x80000000},
	/* 6278 */
	{109540, 0xF},
	{109555, 0x10},
	{127407, 0x20},
	{109579, 0x40},
	{109595, 0x80},
	{127427, 0x100},
	{127453, 0x200},
	{109653, 0x3C00},
	{109669, 0x4000},
	{109690, 0x8000},
	{127470, 0xFFFF0000},
	/* 6289 */
	{109953, 0x3},
	{127484, 0xC},
	{109966, 0x30},
	{109979, 0xC0},
	/* 6293 */
	{127497, 0x3FF},
	{127507, 0xFFC00},
	{50401, 0xF00000},
	{97208, 0xF000000},
	{97219, 0xF0000000},
	/* 6298 */
	{127517, 0x3FF},
	{127527, 0xFFC00},
	{97250, 0xF000000},
	{97261, 0xF0000000},
	/* 6302 */
	{452, 0x7},
	{11600, 0x40000000},
	{10250, 0x80000000},
	/* 6305 */
	{97189, 0x3F},
	{98008, 0x400},
	{98035, 0x800},
	{113121, 0x1000},
	{98062, 0x2000},
	{98088, 0x4000},
	{98114, 0x10000},
	{98141, 0x20000},
	{98167, 0x40000},
	{98193, 0x80000},
	{98221, 0x100000},
	{98247, 0x200000},
	{98273, 0x400000},
	{113148, 0x800000},
	{98299, 0x1000000},
	{98326, 0x2000000},
	{98353, 0x4000000},
	{113174, 0x8000000},
	{113200, 0x10000000},
	{98433, 0x20000000},
	{98462, 0x40000000},
	{98488, 0x80000000},
	/* 6327 */
	{97189, 0x3F},
	{98008, 0x400},
	{98035, 0x800},
	{98062, 0x1000},
	{98088, 0x2000},
	{98114, 0x8000},
	{98141, 0x10000},
	{98221, 0x20000},
	{98247, 0x40000},
	{113121, 0x80000},
	{98167, 0x100000},
	{98326, 0x200000},
	{98488, 0x400000},
	/* 6340 */
	{127537, 0xFF},
	{10733, 0xFFFFFF00},
	/* 6342 */
	{59387, 0x1},
	{59391, 0x6},
	{59400, 0x18},
	{59410, 0x20},
	{59415, 0x40},
	{59423, 0x80},
	{59433, 0x100},
	{59444, 0x200},
	{59450, 0x400},
	{59455, 0x800},
	{59461, 0x1000},
	{59472, 0x2000},
	{59477, 0x4000},
	{111462, 0x8000},
	{59233, 0x10000},
	{59497, 0x20000},
	{59505, 0x40000},
	{59517, 0x80000},
	{111475, 0x100000},
	{111489, 0x200000},
	{125183, 0x400000},
	{59525, 0x800000},
	{59536, 0x8000000},
	{71845, 0x10000000},
	{43322, 0x80000000},
	/* 6367 */
	{59548, 0x1FF, 257, 0},
	{59553, 0x400},
	{59561, 0x800},
	{59574, 0x7000},
	{59593, 0x3F0000},
	{103423, 0x400000},
	{103361, 0x1000000},
	{103457, 0x2000000},
	{103443, 0x4000000},
	{59634, 0x10000000},
	{59646, 0xE0000000},
	/* 6378 */
	{54607, 0xF},
	{59654, 0x30},
	{59662, 0xC0},
	{59670, 0xF00},
	{59676, 0x1000},
	{29236, 0xE000},
	{59694, 0xF0000},
	{59700, 0xF00000},
	{59706, 0x7000000},
	{59715, 0x38000000},
	{59724, 0xC0000000},
	/* 6389 */
	{59730, 0x3F},
	{59740, 0xFC0},
	{127562, 0x3F000},
	{59750, 0xFC0000},
	{59760, 0xF000000},
	/* 6394 */
	{60113, 0xF},
	{60136, 0x10},
	{60159, 0x20},
	{60182, 0x40},
	{60202, 0x80},
	{60222, 0x100},
	{60242, 0x200},
	{60262, 0x400},
	{60282, 0x800},
	{60302, 0x1000},
	{60322, 0x2000},
	{60342, 0x4000},
	{60357, 0x8000},
	{60368, 0x10000},
	{60376, 0x20000},
	{60385, 0x40000},
	{60402, 0x80000},
	{60417, 0x100000},
	{127574, 0x200000},
	{127584, 0x400000},
	{60474, 0x1000000},
	{61412, 0x2000000},
	{125203, 0x4000000},
	{60492, 0x10000000},
	{60501, 0x20000000},
	{60510, 0x40000000},
	{60519, 0x80000000},
	/* 6421 */
	{103520, 0x7F},
	{127599, 0x700},
	{127619, 0x3F0000},
	{127641, 0x80000000},
	/* 6425 */
	{103520, 0x7F},
	{127619, 0x3F0000},
	{127641, 0x80000000},
	/* 6428 */
	{127659, 0x1},
	{127681, 0x2},
	{43356, 0xFFFFC},
	{127699, 0xFFF00000},
	/* 6432 */
	{2208, 0x3FF},
	/* 6433 */
	{64481, 0xFF},
	{69127, 0xFFF00},
	{110345, 0x3F00000, 64, 37484},
	{110357, 0x3C000000, 16, 37609},
	{86833, 0x40000000},
	{127082, 0x80000000},
	/* 6439 */
	{72972, 0x3},
	{73002, 0x1FFE0},
	/* 6441 */
	{59170, 0xFFFF},
	/* 6442 */
	{127726, 0x3F},
	{107268, 0x400},
	{107282, 0x800},
	{127739, 0x10000},
};

static const char sid_strings[] = {
	'N', 'O', 'P', '\0', /* NOP (0, 1) */
	'S', 'E', 'T', '_', 'B', 'A', 'S', 'E', '\0', /* SET_BASE (4, 8) */
	'C', 'L', 'E', 'A', 'R', '_', 'S', 'T', 'A', 'T', 'E', '\0', /* CLEAR_STATE (13) */
	'I', 'N', 'D', 'E', 'X', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '\0', /* INDEX_BUFFER_SIZE (25, 38) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'D', 'I', 'R', 'E', 'C', 'T', '\0', /* DISPATCH_DIRECT (43) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '\0', /* DISPATCH_INDIRECT (59) */
	'A', 'T', 'O', 'M', 'I', 'C', '_', 'M', 'E', 'M', '\0', /* ATOMIC_MEM (77, 84) */
	'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'Q', 'U', 'E', 'R', 'Y', '\0', /* OCCLUSION_QUERY (88, 102) */
	'S', 'E', 'T', '_', 'P', 'R', 'E', 'D', 'I', 'C', 'A', 'T', 'I', 'O', 'N', '\0', /* SET_PREDICATION (104) */
	'C', 'O', 'N', 'D', '_', 'E', 'X', 'E', 'C', '\0', /* COND_EXEC (120) */
	'P', 'R', 'E', 'D', '_', 'E', 'X', 'E', 'C', '\0', /* PRED_EXEC (130) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '\0', /* DRAW_INDIRECT (140) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '\0', /* DRAW_INDEX_INDIRECT (154) */
	'I', 'N', 'D', 'E', 'X', '_', 'B', 'A', 'S', 'E', '\0', /* INDEX_BASE (174) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', '2', '\0', /* DRAW_INDEX_2 (185) */
	'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CONTEXT_CONTROL (198, 206) */
	'I', 'N', 'D', 'E', 'X', '_', 'T', 'Y', 'P', 'E', '\0', /* INDEX_TYPE (214, 220) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'M', 'U', 'L', 'T', 'I', '\0', /* DRAW_INDIRECT_MULTI (225) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', 'A', 'U', 'T', 'O', '\0', /* DRAW_INDEX_AUTO (245, 256) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', 'I', 'M', 'M', 'D', '\0', /* DRAW_INDEX_IMMD (261) */
	'N', 'U', 'M', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', 'S', '\0', /* NUM_INSTANCES (277) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', 'M', 'U', 'L', 'T', 'I', '_', 'A', 'U', 'T', 'O', '\0', /* DRAW_INDEX_MULTI_AUTO (291) */
	'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'S', 'I', '\0', /* INDIRECT_BUFFER_SI (313) */
	'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'C', 'O', 'N', 'S', 'T', '\0', /* INDIRECT_BUFFER_CONST (332) */
	'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'U', 'P', 'D', 'A', 'T', 'E', '\0', /* STRMOUT_BUFFER_UPDATE (354) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '2', '\0', /* DRAW_INDEX_OFFSET_2 (376) */
	'W', 'R', 'I', 'T', 'E', '_', 'D', 'A', 'T', 'A', '\0', /* WRITE_DATA (396, 402) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'M', 'U', 'L', 'T', 'I', '\0', /* DRAW_INDEX_INDIRECT_MULTI (407) */
	'M', 'E', 'M', '_', 'S', 'E', 'M', 'A', 'P', 'H', 'O', 'R', 'E', '\0', /* MEM_SEMAPHORE (433) */
	'M', 'P', 'E', 'G', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* MPEG_INDEX (447, 452, 456) */
	'W', 'A', 'I', 'T', '_', 'R', 'E', 'G', '_', 'M', 'E', 'M', '\0', /* WAIT_REG_MEM (458) */
	'M', 'E', 'M', '_', 'W', 'R', 'I', 'T', 'E', '\0', /* MEM_WRITE (471) */
	'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '\0', /* INDIRECT_BUFFER (481, 490) */
	'C', 'O', 'P', 'Y', '_', 'D', 'A', 'T', 'A', '\0', /* COPY_DATA (497) */
	'C', 'P', '_', 'D', 'M', 'A', '\0', /* CP_DMA (507) */
	'P', 'F', 'P', '_', 'S', 'Y', 'N', 'C', '_', 'M', 'E', '\0', /* PFP_SYNC_ME (514, 523) */
	'S', 'U', 'R', 'F', 'A', 'C', 'E', '_', 'S', 'Y', 'N', 'C', '\0', /* SURFACE_SYNC (526) */
	'M', 'E', '_', 'I', 'N', 'I', 'T', 'I', 'A', 'L', 'I', 'Z', 'E', '\0', /* ME_INITIALIZE (539) */
	'C', 'O', 'N', 'D', '_', 'W', 'R', 'I', 'T', 'E', '\0', /* COND_WRITE (553) */
	'E', 'V', 'E', 'N', 'T', '_', 'W', 'R', 'I', 'T', 'E', '\0', /* EVENT_WRITE (564) */
	'E', 'V', 'E', 'N', 'T', '_', 'W', 'R', 'I', 'T', 'E', '_', 'E', 'O', 'P', '\0', /* EVENT_WRITE_EOP (576) */
	'E', 'V', 'E', 'N', 'T', '_', 'W', 'R', 'I', 'T', 'E', '_', 'E', 'O', 'S', '\0', /* EVENT_WRITE_EOS (592) */
	'R', 'E', 'L', 'E', 'A', 'S', 'E', '_', 'M', 'E', 'M', '\0', /* RELEASE_MEM (608) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'M', 'E', 'S', 'H', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'M', 'U', 'L', 'T', 'I', '\0', /* DISPATCH_MESH_INDIRECT_MULTI (620) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'T', 'A', 'S', 'K', 'M', 'E', 'S', 'H', '_', 'G', 'F', 'X', '\0', /* DISPATCH_TASKMESH_GFX (649) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'M', 'E', 'S', 'H', '_', 'D', 'I', 'R', 'E', 'C', 'T', '\0', /* DISPATCH_MESH_DIRECT (671) */
	'D', 'M', 'A', '_', 'D', 'A', 'T', 'A', '\0', /* DMA_DATA (692) */
	'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'G', '_', 'R', 'M', 'W', '\0', /* CONTEXT_REG_RMW (701) */
	'O', 'N', 'E', '_', 'R', 'E', 'G', '_', 'W', 'R', 'I', 'T', 'E', '\0', /* ONE_REG_WRITE (717) */
	'A', 'C', 'Q', 'U', 'I', 'R', 'E', '_', 'M', 'E', 'M', '\0', /* ACQUIRE_MEM (731) */
	'R', 'E', 'W', 'I', 'N', 'D', '\0', /* REWIND (743) */
	'P', 'R', 'I', 'M', 'E', '_', 'U', 'T', 'C', 'L', '2', '\0', /* PRIME_UTCL2 (750) */
	'L', 'O', 'A', 'D', '_', 'U', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'G', '\0', /* LOAD_UCONFIG_REG (762) */
	'L', 'O', 'A', 'D', '_', 'S', 'H', '_', 'R', 'E', 'G', '\0', /* LOAD_SH_REG (779) */
	'L', 'O', 'A', 'D', '_', 'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'G', '\0', /* LOAD_CONTEXT_REG (791) */
	'L', 'O', 'A', 'D', '_', 'S', 'H', '_', 'R', 'E', 'G', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* LOAD_SH_REG_INDEX (808) */
	'S', 'E', 'T', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'G', '\0', /* SET_CONFIG_REG (826) */
	'S', 'E', 'T', '_', 'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'G', '\0', /* SET_CONTEXT_REG (841) */
	'S', 'E', 'T', '_', 'S', 'H', '_', 'R', 'E', 'G', '\0', /* SET_SH_REG (857) */
	'S', 'E', 'T', '_', 'S', 'H', '_', 'R', 'E', 'G', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* SET_SH_REG_OFFSET (868, 879) */
	'S', 'E', 'T', '_', 'U', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'G', '\0', /* SET_UCONFIG_REG (886) */
	'S', 'E', 'T', '_', 'U', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'G', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* SET_UCONFIG_REG_INDEX (902) */
	'L', 'O', 'A', 'D', '_', 'C', 'O', 'N', 'S', 'T', '_', 'R', 'A', 'M', '\0', /* LOAD_CONST_RAM (924) */
	'W', 'R', 'I', 'T', 'E', '_', 'C', 'O', 'N', 'S', 'T', '_', 'R', 'A', 'M', '\0', /* WRITE_CONST_RAM (939) */
	'D', 'U', 'M', 'P', '_', 'C', 'O', 'N', 'S', 'T', '_', 'R', 'A', 'M', '\0', /* DUMP_CONST_RAM (955) */
	'I', 'N', 'C', 'R', 'E', 'M', 'E', 'N', 'T', '_', 'C', 'E', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '\0', /* INCREMENT_CE_COUNTER (970, 983) */
	'I', 'N', 'C', 'R', 'E', 'M', 'E', 'N', 'T', '_', 'D', 'E', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '\0', /* INCREMENT_DE_COUNTER (991) */
	'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'C', 'E', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '\0', /* WAIT_ON_CE_COUNTER (1012) */
	'S', 'E', 'T', '_', 'S', 'H', '_', 'R', 'E', 'G', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* SET_SH_REG_INDEX (1031) */
	'L', 'O', 'A', 'D', '_', 'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'G', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* LOAD_CONTEXT_REG_INDEX (1048) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'T', 'A', 'S', 'K', '_', 'S', 'T', 'A', 'T', 'E', '_', 'I', 'N', 'I', 'T', '\0', /* DISPATCH_TASK_STATE_INIT (1071) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'T', 'A', 'S', 'K', 'M', 'E', 'S', 'H', '_', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'A', 'C', 'E', '\0', /* DISPATCH_TASKMESH_DIRECT_ACE (1096, 1122) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'T', 'A', 'S', 'K', 'M', 'E', 'S', 'H', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'M', 'U', 'L', 'T', 'I', '_', 'A', 'C', 'E', '\0', /* DISPATCH_TASKMESH_INDIRECT_MULTI_ACE (1125) */
	'E', 'V', 'E', 'N', 'T', '_', 'W', 'R', 'I', 'T', 'E', '_', 'Z', 'P', 'A', 'S', 'S', '\0', /* EVENT_WRITE_ZPASS (1162) */
	'S', 'E', 'T', '_', 'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'G', '_', 'P', 'A', 'I', 'R', 'S', '\0', /* SET_CONTEXT_REG_PAIRS (1180) */
	'S', 'E', 'T', '_', 'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'G', '_', 'P', 'A', 'I', 'R', 'S', '_', 'P', 'A', 'C', 'K', 'E', 'D', '\0', /* SET_CONTEXT_REG_PAIRS_PACKED (1202) */
	'S', 'E', 'T', '_', 'S', 'H', '_', 'R', 'E', 'G', '_', 'P', 'A', 'I', 'R', 'S', '\0', /* SET_SH_REG_PAIRS (1231) */
	'S', 'E', 'T', '_', 'S', 'H', '_', 'R', 'E', 'G', '_', 'P', 'A', 'I', 'R', 'S', '_', 'P', 'A', 'C', 'K', 'E', 'D', '\0', /* SET_SH_REG_PAIRS_PACKED (1248) */
	'S', 'E', 'T', '_', 'S', 'H', '_', 'R', 'E', 'G', '_', 'P', 'A', 'I', 'R', 'S', '_', 'P', 'A', 'C', 'K', 'E', 'D', '_', 'N', '\0', /* SET_SH_REG_PAIRS_PACKED_N (1272) */
	'I', 'T', '_', 'O', 'P', 'C', 'O', 'D', 'E', '_', 'C', '\0', /* IT_OPCODE_C (1298) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'M', 'O', 'D', 'E', '\0', /* SQ_WAVE_MODE (1310, 1318, 1320) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* SQ_WAVE_STATUS (1323, 1331) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'R', 'A', 'P', 'S', 'T', 'S', '\0', /* SQ_WAVE_TRAPSTS (1338) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'H', 'W', '_', 'I', 'D', '_', 'L', 'E', 'G', 'A', 'C', 'Y', '\0', /* SQ_WAVE_HW_ID_LEGACY (1354) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'G', 'P', 'R', '_', 'A', 'L', 'L', 'O', 'C', '\0', /* SQ_WAVE_GPR_ALLOC (1375) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'L', 'D', 'S', '_', 'A', 'L', 'L', 'O', 'C', '\0', /* SQ_WAVE_LDS_ALLOC (1393) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'I', 'B', '_', 'S', 'T', 'S', '\0', /* SQ_WAVE_IB_STS (1411) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'P', 'C', '_', 'L', 'O', '\0', /* SQ_WAVE_PC_LO (1426) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'P', 'C', '_', 'H', 'I', '\0', /* SQ_WAVE_PC_HI (1440, 1448) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'I', 'N', 'S', 'T', '_', 'D', 'W', '0', '\0', /* SQ_WAVE_INST_DW0 (1454) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'I', 'B', '_', 'D', 'B', 'G', '1', '\0', /* SQ_WAVE_IB_DBG1 (1471) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'F', 'L', 'U', 'S', 'H', '_', 'I', 'B', '\0', /* SQ_WAVE_FLUSH_IB (1487) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'H', 'W', '_', 'I', 'D', '1', '\0', /* SQ_WAVE_HW_ID1 (1504) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'H', 'W', '_', 'I', 'D', '2', '\0', /* SQ_WAVE_HW_ID2 (1519) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'P', 'O', 'P', 'S', '_', 'P', 'A', 'C', 'K', 'E', 'R', '\0', /* SQ_WAVE_POPS_PACKER (1534) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'S', 'C', 'H', 'E', 'D', '_', 'M', 'O', 'D', 'E', '\0', /* SQ_WAVE_SCHED_MODE (1554) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'V', 'G', 'P', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* SQ_WAVE_VGPR_OFFSET (1573) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'I', 'B', '_', 'S', 'T', 'S', '2', '\0', /* SQ_WAVE_IB_STS2 (1593) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '0', '\0', /* SQ_WAVE_TTMP0 (1609) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '\0', /* SQ_WAVE_TTMP1 (1623) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '2', '\0', /* SQ_WAVE_TTMP2 (1637) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '3', '\0', /* SQ_WAVE_TTMP3 (1651) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '4', '\0', /* SQ_WAVE_TTMP4 (1665) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '5', '\0', /* SQ_WAVE_TTMP5 (1679) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '6', '\0', /* SQ_WAVE_TTMP6 (1693) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '7', '\0', /* SQ_WAVE_TTMP7 (1707) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '8', '\0', /* SQ_WAVE_TTMP8 (1721) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '9', '\0', /* SQ_WAVE_TTMP9 (1735) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '0', '\0', /* SQ_WAVE_TTMP10 (1749) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '1', '\0', /* SQ_WAVE_TTMP11 (1764) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '2', '\0', /* SQ_WAVE_TTMP12 (1779) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '3', '\0', /* SQ_WAVE_TTMP13 (1794) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '4', '\0', /* SQ_WAVE_TTMP14 (1809) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '5', '\0', /* SQ_WAVE_TTMP15 (1824) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'M', '0', '\0', /* SQ_WAVE_M0 (1839) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'E', 'X', 'E', 'C', '_', 'L', 'O', '\0', /* SQ_WAVE_EXEC_LO (1850) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'E', 'X', 'E', 'C', '_', 'H', 'I', '\0', /* SQ_WAVE_EXEC_HI (1866) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'F', 'L', 'A', 'T', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'L', 'O', '\0', /* SQ_WAVE_FLAT_SCRATCH_LO (1882) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'F', 'L', 'A', 'T', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'H', 'I', '\0', /* SQ_WAVE_FLAT_SCRATCH_HI (1906) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'F', 'L', 'A', 'T', '_', 'X', 'N', 'A', 'C', 'K', '_', 'M', 'A', 'S', 'K', '\0', /* SQ_WAVE_FLAT_XNACK_MASK (1930) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '2', '\0', /* GRBM_STATUS2 (1954) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* GRBM_STATUS (1967) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'S', 'E', '0', '\0', /* GRBM_STATUS_SE0 (1979) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'S', 'E', '1', '\0', /* GRBM_STATUS_SE1 (1995) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '3', '\0', /* GRBM_STATUS3 (2011) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'S', 'E', '2', '\0', /* GRBM_STATUS_SE2 (2024) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'S', 'E', '3', '\0', /* GRBM_STATUS_SE3 (2040) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_CPC_STATUS (2056) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'B', 'U', 'S', 'Y', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CPC_BUSY_STAT (2070) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'S', 'T', 'A', 'L', 'L', 'E', 'D', '_', 'S', 'T', 'A', 'T', '1', '\0', /* CP_CPC_STALLED_STAT1 (2087) */
	'C', 'P', '_', 'C', 'P', 'F', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_CPF_STATUS (2108) */
	'C', 'P', '_', 'C', 'P', 'F', '_', 'B', 'U', 'S', 'Y', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CPF_BUSY_STAT (2122) */
	'C', 'P', '_', 'C', 'P', 'F', '_', 'S', 'T', 'A', 'L', 'L', 'E', 'D', '_', 'S', 'T', 'A', 'T', '1', '\0', /* CP_CPF_STALLED_STAT1 (2139) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'B', 'U', 'S', 'Y', '_', 'S', 'T', 'A', 'T', '2', '\0', /* CP_CPC_BUSY_STAT2 (2160) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'G', 'R', 'B', 'M', '_', 'F', 'R', 'E', 'E', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* CP_CPC_GRBM_FREE_COUNT (2178, 2190, 2195) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* CP_CPC_SCRATCH_INDEX (2201, 2208) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'D', 'A', 'T', 'A', '\0', /* CP_CPC_SCRATCH_DATA (2222) */
	'C', 'P', '_', 'C', 'P', 'F', '_', 'G', 'R', 'B', 'M', '_', 'F', 'R', 'E', 'E', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* CP_CPF_GRBM_FREE_COUNT (2242) */
	'C', 'P', '_', 'C', 'P', 'F', '_', 'B', 'U', 'S', 'Y', '_', 'S', 'T', 'A', 'T', '2', '\0', /* CP_CPF_BUSY_STAT2 (2265) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'H', 'A', 'L', 'T', '_', 'H', 'Y', 'S', 'T', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* CP_CPC_HALT_HYST_COUNT (2283) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'U', 'F', '0', '_', 'B', 'A', 'S', 'E', '\0', /* SQ_THREAD_TRACE_BUF0_BASE (2306) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'U', 'F', '0', '_', 'S', 'I', 'Z', 'E', '\0', /* SQ_THREAD_TRACE_BUF0_SIZE (2332) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'U', 'F', '1', '_', 'B', 'A', 'S', 'E', '\0', /* SQ_THREAD_TRACE_BUF1_BASE (2358) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'U', 'F', '1', '_', 'S', 'I', 'Z', 'E', '\0', /* SQ_THREAD_TRACE_BUF1_SIZE (2384) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'W', 'P', 'T', 'R', '\0', /* SQ_THREAD_TRACE_WPTR (2410, 2426) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'M', 'A', 'S', 'K', '\0', /* SQ_THREAD_TRACE_MASK (2431) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'T', 'O', 'K', 'E', 'N', '_', 'M', 'A', 'S', 'K', '\0', /* SQ_THREAD_TRACE_TOKEN_MASK (2452, 2468) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'C', 'T', 'R', 'L', '\0', /* SQ_THREAD_TRACE_CTRL (2479) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* SQ_THREAD_TRACE_STATUS (2500) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'D', 'R', 'O', 'P', 'P', 'E', 'D', '_', 'C', 'N', 'T', 'R', '\0', /* SQ_THREAD_TRACE_DROPPED_CNTR (2523) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'G', 'F', 'X', '_', 'D', 'R', 'A', 'W', '_', 'C', 'N', 'T', 'R', '\0', /* SQ_THREAD_TRACE_GFX_DRAW_CNTR (2552) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'G', 'F', 'X', '_', 'M', 'A', 'R', 'K', 'E', 'R', '_', 'C', 'N', 'T', 'R', '\0', /* SQ_THREAD_TRACE_GFX_MARKER_CNTR (2582) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'H', 'P', '3', 'D', '_', 'D', 'R', 'A', 'W', '_', 'C', 'N', 'T', 'R', '\0', /* SQ_THREAD_TRACE_HP3D_DRAW_CNTR (2614) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'H', 'P', '3', 'D', '_', 'M', 'A', 'R', 'K', 'E', 'R', '_', 'C', 'N', 'T', 'R', '\0', /* SQ_THREAD_TRACE_HP3D_MARKER_CNTR (2645) */
	'S', 'Q', '_', 'E', 'X', 'P', '_', '0', '\0', /* SQ_EXP_0 (2678) */
	'S', 'Q', '_', 'B', 'U', 'F', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '0', '\0', /* SQ_BUF_RSRC_WORD0 (2687) */
	'S', 'Q', '_', 'B', 'U', 'F', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '1', '\0', /* SQ_BUF_RSRC_WORD1 (2705) */
	'S', 'Q', '_', 'B', 'U', 'F', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '2', '\0', /* SQ_BUF_RSRC_WORD2 (2723) */
	'S', 'Q', '_', 'B', 'U', 'F', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '3', '\0', /* SQ_BUF_RSRC_WORD3 (2741) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'S', 'A', 'M', 'P', '_', 'W', 'O', 'R', 'D', '0', '\0', /* SQ_IMG_SAMP_WORD0 (2759) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'S', 'A', 'M', 'P', '_', 'W', 'O', 'R', 'D', '1', '\0', /* SQ_IMG_SAMP_WORD1 (2777) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'S', 'A', 'M', 'P', '_', 'W', 'O', 'R', 'D', '2', '\0', /* SQ_IMG_SAMP_WORD2 (2795) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'S', 'A', 'M', 'P', '_', 'W', 'O', 'R', 'D', '3', '\0', /* SQ_IMG_SAMP_WORD3 (2813) */
	'S', 'P', 'I', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* SPI_CONFIG_CNTL (2831) */
	'G', 'B', '_', 'A', 'D', 'D', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* GB_ADDR_CONFIG (2847) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '0', '\0', /* GB_TILE_MODE0 (2862) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '\0', /* GB_TILE_MODE1 (2876) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '\0', /* GB_TILE_MODE2 (2890) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '3', '\0', /* GB_TILE_MODE3 (2904) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '4', '\0', /* GB_TILE_MODE4 (2918) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '5', '\0', /* GB_TILE_MODE5 (2932) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '6', '\0', /* GB_TILE_MODE6 (2946) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '7', '\0', /* GB_TILE_MODE7 (2960) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '8', '\0', /* GB_TILE_MODE8 (2974) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '9', '\0', /* GB_TILE_MODE9 (2988) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '0', '\0', /* GB_TILE_MODE10 (3002) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '1', '\0', /* GB_TILE_MODE11 (3017) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '2', '\0', /* GB_TILE_MODE12 (3032) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '3', '\0', /* GB_TILE_MODE13 (3047) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '4', '\0', /* GB_TILE_MODE14 (3062) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '5', '\0', /* GB_TILE_MODE15 (3077) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '6', '\0', /* GB_TILE_MODE16 (3092) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '7', '\0', /* GB_TILE_MODE17 (3107) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '8', '\0', /* GB_TILE_MODE18 (3122) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '9', '\0', /* GB_TILE_MODE19 (3137) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '0', '\0', /* GB_TILE_MODE20 (3152) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '1', '\0', /* GB_TILE_MODE21 (3167) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '2', '\0', /* GB_TILE_MODE22 (3182) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '3', '\0', /* GB_TILE_MODE23 (3197) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '4', '\0', /* GB_TILE_MODE24 (3212) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '5', '\0', /* GB_TILE_MODE25 (3227) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '6', '\0', /* GB_TILE_MODE26 (3242) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '7', '\0', /* GB_TILE_MODE27 (3257) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '8', '\0', /* GB_TILE_MODE28 (3272) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '9', '\0', /* GB_TILE_MODE29 (3287) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '3', '0', '\0', /* GB_TILE_MODE30 (3302) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '3', '1', '\0', /* GB_TILE_MODE31 (3317) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '0', '\0', /* GB_MACROTILE_MODE0 (3332) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '\0', /* GB_MACROTILE_MODE1 (3351) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '\0', /* GB_MACROTILE_MODE2 (3370) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '3', '\0', /* GB_MACROTILE_MODE3 (3389) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '4', '\0', /* GB_MACROTILE_MODE4 (3408) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '5', '\0', /* GB_MACROTILE_MODE5 (3427) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '6', '\0', /* GB_MACROTILE_MODE6 (3446) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '7', '\0', /* GB_MACROTILE_MODE7 (3465) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '8', '\0', /* GB_MACROTILE_MODE8 (3484) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '9', '\0', /* GB_MACROTILE_MODE9 (3503) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '0', '\0', /* GB_MACROTILE_MODE10 (3522) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '1', '\0', /* GB_MACROTILE_MODE11 (3542) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '2', '\0', /* GB_MACROTILE_MODE12 (3562) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '3', '\0', /* GB_MACROTILE_MODE13 (3582) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '4', '\0', /* GB_MACROTILE_MODE14 (3602) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '5', '\0', /* GB_MACROTILE_MODE15 (3622) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '0', '\0', /* SQ_IMG_RSRC_WORD0 (3642) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '1', '\0', /* SQ_IMG_RSRC_WORD1 (3660) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '2', '\0', /* SQ_IMG_RSRC_WORD2 (3678) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '3', '\0', /* SQ_IMG_RSRC_WORD3 (3696) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '4', '\0', /* SQ_IMG_RSRC_WORD4 (3714) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '5', '\0', /* SQ_IMG_RSRC_WORD5 (3732) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '6', '\0', /* SQ_IMG_RSRC_WORD6 (3750) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '7', '\0', /* SQ_IMG_RSRC_WORD7 (3768) */
	'G', 'C', 'V', 'M', '_', 'L', '2', '_', 'P', 'R', 'O', 'T', 'E', 'C', 'T', 'I', 'O', 'N', '_', 'F', 'A', 'U', 'L', 'T', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* GCVM_L2_PROTECTION_FAULT_STATUS (3786) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '4', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_RSRC4_PS (3818) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'C', 'H', 'K', 'S', 'U', 'M', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_CHKSUM_PS (3842) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_RSRC3_PS (3867) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_LO_PS (3891) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_HI_PS (3912) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_RSRC1_PS (3933) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_PS (3957) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '0', '\0', /* SPI_SHADER_USER_DATA_PS_0 (3981) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '\0', /* SPI_SHADER_USER_DATA_PS_1 (4007) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '\0', /* SPI_SHADER_USER_DATA_PS_2 (4033) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '3', '\0', /* SPI_SHADER_USER_DATA_PS_3 (4059) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '4', '\0', /* SPI_SHADER_USER_DATA_PS_4 (4085) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '5', '\0', /* SPI_SHADER_USER_DATA_PS_5 (4111) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '6', '\0', /* SPI_SHADER_USER_DATA_PS_6 (4137) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '7', '\0', /* SPI_SHADER_USER_DATA_PS_7 (4163) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '8', '\0', /* SPI_SHADER_USER_DATA_PS_8 (4189) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '9', '\0', /* SPI_SHADER_USER_DATA_PS_9 (4215) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_PS_10 (4241) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_PS_11 (4268) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_PS_12 (4295) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_PS_13 (4322) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_PS_14 (4349) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_PS_15 (4376) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_PS_16 (4403) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_PS_17 (4430) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_PS_18 (4457) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_PS_19 (4484) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_PS_20 (4511) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_PS_21 (4538) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_PS_22 (4565) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_PS_23 (4592) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_PS_24 (4619) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_PS_25 (4646) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_PS_26 (4673) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_PS_27 (4700) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_PS_28 (4727) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_PS_29 (4754) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_PS_30 (4781) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_PS_31 (4808) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'R', 'E', 'Q', '_', 'C', 'T', 'R', 'L', '_', 'P', 'S', '\0', /* SPI_SHADER_REQ_CTRL_PS (4835) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'R', 'E', 'F', '_', 'P', 'R', 'I', '_', 'C', 'N', 'T', 'R', '_', 'C', 'T', 'R', 'L', '_', 'P', 'S', '\0', /* SPI_SHADER_PREF_PRI_CNTR_CTRL_PS (4858) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'P', 'S', '_', '0', '\0', /* SPI_SHADER_USER_ACCUM_PS_0 (4891) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'P', 'S', '_', '1', '\0', /* SPI_SHADER_USER_ACCUM_PS_1 (4918) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'P', 'S', '_', '2', '\0', /* SPI_SHADER_USER_ACCUM_PS_2 (4945) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'P', 'S', '_', '3', '\0', /* SPI_SHADER_USER_ACCUM_PS_3 (4972) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '4', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC4_VS (4999) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'C', 'H', 'K', 'S', 'U', 'M', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_CHKSUM_VS (5023) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC3_VS (5048) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'L', 'A', 'T', 'E', '_', 'A', 'L', 'L', 'O', 'C', '_', 'V', 'S', '\0', /* SPI_SHADER_LATE_ALLOC_VS (5072) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_LO_VS (5097) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_HI_VS (5118) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC1_VS (5139) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_VS (5163) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '0', '\0', /* SPI_SHADER_USER_DATA_VS_0 (5187) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '\0', /* SPI_SHADER_USER_DATA_VS_1 (5213) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '\0', /* SPI_SHADER_USER_DATA_VS_2 (5239) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '3', '\0', /* SPI_SHADER_USER_DATA_VS_3 (5265) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '4', '\0', /* SPI_SHADER_USER_DATA_VS_4 (5291) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '5', '\0', /* SPI_SHADER_USER_DATA_VS_5 (5317) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '6', '\0', /* SPI_SHADER_USER_DATA_VS_6 (5343) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '7', '\0', /* SPI_SHADER_USER_DATA_VS_7 (5369) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '8', '\0', /* SPI_SHADER_USER_DATA_VS_8 (5395) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '9', '\0', /* SPI_SHADER_USER_DATA_VS_9 (5421) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_VS_10 (5447) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_VS_11 (5474) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_VS_12 (5501) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_VS_13 (5528) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_VS_14 (5555) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_VS_15 (5582) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_VS_16 (5609) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_VS_17 (5636) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_VS_18 (5663) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_VS_19 (5690) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_VS_20 (5717) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_VS_21 (5744) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_VS_22 (5771) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_VS_23 (5798) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_VS_24 (5825) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_VS_25 (5852) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_VS_26 (5879) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_VS_27 (5906) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_VS_28 (5933) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_VS_29 (5960) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_VS_30 (5987) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_VS_31 (6014) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'R', 'E', 'Q', '_', 'C', 'T', 'R', 'L', '_', 'V', 'S', '\0', /* SPI_SHADER_REQ_CTRL_VS (6041) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'R', 'E', 'F', '_', 'P', 'R', 'I', '_', 'C', 'N', 'T', 'R', '_', 'C', 'T', 'R', 'L', '_', 'V', 'S', '\0', /* SPI_SHADER_PREF_PRI_CNTR_CTRL_VS (6064) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'V', 'S', '_', '0', '\0', /* SPI_SHADER_USER_ACCUM_VS_0 (6097) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'V', 'S', '_', '1', '\0', /* SPI_SHADER_USER_ACCUM_VS_1 (6124) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'V', 'S', '_', '2', '\0', /* SPI_SHADER_USER_ACCUM_VS_2 (6151) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'V', 'S', '_', '3', '\0', /* SPI_SHADER_USER_ACCUM_VS_3 (6178) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'G', 'S', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_GS_VS (6205) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'E', 'S', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_ES_VS (6232) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'L', 'S', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_LS_VS (6259) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'C', 'H', 'K', 'S', 'U', 'M', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_CHKSUM_GS (6286) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '4', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_RSRC4_GS (6311) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '_', 'G', 'S', '\0', /* SPI_SHADER_USER_DATA_ADDR_LO_GS (6335) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '_', 'G', 'S', '\0', /* SPI_SHADER_USER_DATA_ADDR_HI_GS (6367) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'E', 'S', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_LO_ES_GS (6399) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'E', 'S', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_HI_ES_GS (6423) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_RSRC3_GS (6447) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_LO_GS (6471) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_HI_GS (6492) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_RSRC1_GS (6513) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_GS (6537) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '0', '\0', /* SPI_SHADER_USER_DATA_GS_0 (6561) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '\0', /* SPI_SHADER_USER_DATA_GS_1 (6587) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '\0', /* SPI_SHADER_USER_DATA_GS_2 (6613) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '3', '\0', /* SPI_SHADER_USER_DATA_GS_3 (6639) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '4', '\0', /* SPI_SHADER_USER_DATA_GS_4 (6665) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '5', '\0', /* SPI_SHADER_USER_DATA_GS_5 (6691) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '6', '\0', /* SPI_SHADER_USER_DATA_GS_6 (6717) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '7', '\0', /* SPI_SHADER_USER_DATA_GS_7 (6743) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '8', '\0', /* SPI_SHADER_USER_DATA_GS_8 (6769) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '9', '\0', /* SPI_SHADER_USER_DATA_GS_9 (6795) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_GS_10 (6821) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_GS_11 (6848) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_GS_12 (6875) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_GS_13 (6902) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_GS_14 (6929) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_GS_15 (6956) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_GS_16 (6983) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_GS_17 (7010) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_GS_18 (7037) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_GS_19 (7064) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_GS_20 (7091) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_GS_21 (7118) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_GS_22 (7145) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_GS_23 (7172) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_GS_24 (7199) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_GS_25 (7226) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_GS_26 (7253) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_GS_27 (7280) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_GS_28 (7307) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_GS_29 (7334) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_GS_30 (7361) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_GS_31 (7388) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'R', 'E', 'Q', '_', 'C', 'T', 'R', 'L', '_', 'E', 'S', 'G', 'S', '\0', /* SPI_SHADER_REQ_CTRL_ESGS (7415) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'R', 'E', 'F', '_', 'P', 'R', 'I', '_', 'C', 'N', 'T', 'R', '_', 'C', 'T', 'R', 'L', '_', 'E', 'S', 'G', 'S', '\0', /* SPI_SHADER_PREF_PRI_CNTR_CTRL_ESGS (7440) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'E', 'S', 'G', 'S', '_', '0', '\0', /* SPI_SHADER_USER_ACCUM_ESGS_0 (7475) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'E', 'S', 'G', 'S', '_', '1', '\0', /* SPI_SHADER_USER_ACCUM_ESGS_1 (7504) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'E', 'S', 'G', 'S', '_', '2', '\0', /* SPI_SHADER_USER_ACCUM_ESGS_2 (7533) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'E', 'S', 'G', 'S', '_', '3', '\0', /* SPI_SHADER_USER_ACCUM_ESGS_3 (7562) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'E', 'S', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_ES_GS (7591) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '_', 'E', 'S', '\0', /* SPI_SHADER_PGM_RSRC3_ES (7618) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'E', 'S', '\0', /* SPI_SHADER_PGM_LO_ES (7642) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'E', 'S', '\0', /* SPI_SHADER_PGM_HI_ES (7663) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '_', 'E', 'S', '\0', /* SPI_SHADER_PGM_RSRC1_ES (7684) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'E', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_ES (7708) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '0', '\0', /* SPI_SHADER_USER_DATA_ES_0 (7732) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '\0', /* SPI_SHADER_USER_DATA_ES_1 (7758) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '\0', /* SPI_SHADER_USER_DATA_ES_2 (7784) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '3', '\0', /* SPI_SHADER_USER_DATA_ES_3 (7810) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '4', '\0', /* SPI_SHADER_USER_DATA_ES_4 (7836) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '5', '\0', /* SPI_SHADER_USER_DATA_ES_5 (7862) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '6', '\0', /* SPI_SHADER_USER_DATA_ES_6 (7888) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '7', '\0', /* SPI_SHADER_USER_DATA_ES_7 (7914) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '8', '\0', /* SPI_SHADER_USER_DATA_ES_8 (7940) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '9', '\0', /* SPI_SHADER_USER_DATA_ES_9 (7966) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_ES_10 (7992) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_ES_11 (8019) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_ES_12 (8046) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_ES_13 (8073) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_ES_14 (8100) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_ES_15 (8127) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'L', 'S', '_', 'E', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_LS_ES (8154) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'C', 'H', 'K', 'S', 'U', 'M', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_CHKSUM_HS (8181) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '4', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_RSRC4_HS (8206) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '_', 'H', 'S', '\0', /* SPI_SHADER_USER_DATA_ADDR_LO_HS (8230) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '_', 'H', 'S', '\0', /* SPI_SHADER_USER_DATA_ADDR_HI_HS (8262) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'L', 'S', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_LO_LS_HS (8294) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'L', 'S', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_HI_LS_HS (8318) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_RSRC3_HS (8342) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_LO_HS (8366) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_HI_HS (8387) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_RSRC1_HS (8408) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_HS (8432) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '0', '\0', /* SPI_SHADER_USER_DATA_HS_0 (8456) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '\0', /* SPI_SHADER_USER_DATA_HS_1 (8482) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '\0', /* SPI_SHADER_USER_DATA_HS_2 (8508) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '3', '\0', /* SPI_SHADER_USER_DATA_HS_3 (8534) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '4', '\0', /* SPI_SHADER_USER_DATA_HS_4 (8560) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '5', '\0', /* SPI_SHADER_USER_DATA_HS_5 (8586) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '6', '\0', /* SPI_SHADER_USER_DATA_HS_6 (8612) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '7', '\0', /* SPI_SHADER_USER_DATA_HS_7 (8638) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '8', '\0', /* SPI_SHADER_USER_DATA_HS_8 (8664) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '9', '\0', /* SPI_SHADER_USER_DATA_HS_9 (8690) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_HS_10 (8716) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_HS_11 (8743) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_HS_12 (8770) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_HS_13 (8797) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_HS_14 (8824) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_HS_15 (8851) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_HS_16 (8878) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_HS_17 (8905) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_HS_18 (8932) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_HS_19 (8959) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_HS_20 (8986) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_HS_21 (9013) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_HS_22 (9040) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_HS_23 (9067) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_HS_24 (9094) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_HS_25 (9121) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_HS_26 (9148) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_HS_27 (9175) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_HS_28 (9202) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_HS_29 (9229) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_HS_30 (9256) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_HS_31 (9283) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'R', 'E', 'Q', '_', 'C', 'T', 'R', 'L', '_', 'L', 'S', 'H', 'S', '\0', /* SPI_SHADER_REQ_CTRL_LSHS (9310) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'R', 'E', 'F', '_', 'P', 'R', 'I', '_', 'C', 'N', 'T', 'R', '_', 'C', 'T', 'R', 'L', '_', 'L', 'S', 'H', 'S', '\0', /* SPI_SHADER_PREF_PRI_CNTR_CTRL_LSHS (9335) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'L', 'S', 'H', 'S', '_', '0', '\0', /* SPI_SHADER_USER_ACCUM_LSHS_0 (9370) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'L', 'S', 'H', 'S', '_', '1', '\0', /* SPI_SHADER_USER_ACCUM_LSHS_1 (9399) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'L', 'S', 'H', 'S', '_', '2', '\0', /* SPI_SHADER_USER_ACCUM_LSHS_2 (9428) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'L', 'S', 'H', 'S', '_', '3', '\0', /* SPI_SHADER_USER_ACCUM_LSHS_3 (9457) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'L', 'S', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_LS_HS (9486) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '_', 'L', 'S', '\0', /* SPI_SHADER_PGM_RSRC3_LS (9513) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'L', 'S', '\0', /* SPI_SHADER_PGM_LO_LS (9537) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'L', 'S', '\0', /* SPI_SHADER_PGM_HI_LS (9558) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '_', 'L', 'S', '\0', /* SPI_SHADER_PGM_RSRC1_LS (9579) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'L', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_LS (9603) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '0', '\0', /* SPI_SHADER_USER_DATA_LS_0 (9627) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '\0', /* SPI_SHADER_USER_DATA_LS_1 (9653) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '\0', /* SPI_SHADER_USER_DATA_LS_2 (9679) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '3', '\0', /* SPI_SHADER_USER_DATA_LS_3 (9705) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '4', '\0', /* SPI_SHADER_USER_DATA_LS_4 (9731) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '5', '\0', /* SPI_SHADER_USER_DATA_LS_5 (9757) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '6', '\0', /* SPI_SHADER_USER_DATA_LS_6 (9783) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '7', '\0', /* SPI_SHADER_USER_DATA_LS_7 (9809) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '8', '\0', /* SPI_SHADER_USER_DATA_LS_8 (9835) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '9', '\0', /* SPI_SHADER_USER_DATA_LS_9 (9861) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_LS_10 (9887) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_LS_11 (9914) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_LS_12 (9941) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_LS_13 (9968) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_LS_14 (9995) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_LS_15 (10022) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'I', 'T', 'I', 'A', 'T', 'O', 'R', '\0', /* COMPUTE_DISPATCH_INITIATOR (10049) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'M', '_', 'X', '\0', /* COMPUTE_DIM_X (10076) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'M', '_', 'Y', '\0', /* COMPUTE_DIM_Y (10090) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'M', '_', 'Z', '\0', /* COMPUTE_DIM_Z (10104) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'R', 'T', '_', 'X', '\0', /* COMPUTE_START_X (10118, 10126) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'R', 'T', '_', 'Y', '\0', /* COMPUTE_START_Y (10134, 10142) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'R', 'T', '_', 'Z', '\0', /* COMPUTE_START_Z (10150) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'N', 'U', 'M', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'X', '\0', /* COMPUTE_NUM_THREAD_X (10166) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'N', 'U', 'M', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'Y', '\0', /* COMPUTE_NUM_THREAD_Y (10187) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'N', 'U', 'M', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'Z', '\0', /* COMPUTE_NUM_THREAD_Z (10208) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'I', 'P', 'E', 'L', 'I', 'N', 'E', 'S', 'T', 'A', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* COMPUTE_PIPELINESTAT_ENABLE (10229, 10237, 10250) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* COMPUTE_PERFCOUNT_ENABLE (10257, 10265) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'G', 'M', '_', 'L', 'O', '\0', /* COMPUTE_PGM_LO (10282) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'G', 'M', '_', 'H', 'I', '\0', /* COMPUTE_PGM_HI (10297) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'P', 'K', 'T', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* COMPUTE_DISPATCH_PKT_ADDR_LO (10312, 10333) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'P', 'K', 'T', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* COMPUTE_DISPATCH_PKT_ADDR_HI (10341, 10362) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* COMPUTE_DISPATCH_SCRATCH_BASE_LO (10370) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* COMPUTE_DISPATCH_SCRATCH_BASE_HI (10403, 10428) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '\0', /* COMPUTE_PGM_RSRC1 (10436, 10449) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '\0', /* COMPUTE_PGM_RSRC2 (10454, 10467) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'V', 'M', 'I', 'D', '\0', /* COMPUTE_VMID (10472, 10480, 10482) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'S', 'O', 'U', 'R', 'C', 'E', '_', 'L', 'I', 'M', 'I', 'T', 'S', '\0', /* COMPUTE_RESOURCE_LIMITS (10485) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'E', 'S', 'T', 'I', 'N', 'A', 'T', 'I', 'O', 'N', '_', 'E', 'N', '_', 'S', 'E', '0', '\0', /* COMPUTE_DESTINATION_EN_SE0 (10509) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'E', 'S', 'T', 'I', 'N', 'A', 'T', 'I', 'O', 'N', '_', 'E', 'N', '_', 'S', 'E', '1', '\0', /* COMPUTE_DESTINATION_EN_SE1 (10536) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'M', 'P', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* COMPUTE_TMPRING_SIZE (10563) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'E', 'S', 'T', 'I', 'N', 'A', 'T', 'I', 'O', 'N', '_', 'E', 'N', '_', 'S', 'E', '2', '\0', /* COMPUTE_DESTINATION_EN_SE2 (10584) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'E', 'S', 'T', 'I', 'N', 'A', 'T', 'I', 'O', 'N', '_', 'E', 'N', '_', 'S', 'E', '3', '\0', /* COMPUTE_DESTINATION_EN_SE3 (10611) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'S', 'T', 'A', 'R', 'T', '_', 'X', '\0', /* COMPUTE_RESTART_X (10638) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'S', 'T', 'A', 'R', 'T', '_', 'Y', '\0', /* COMPUTE_RESTART_Y (10656) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'S', 'T', 'A', 'R', 'T', '_', 'Z', '\0', /* COMPUTE_RESTART_Z (10674) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* COMPUTE_THREAD_TRACE_ENABLE (10692, 10700) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'M', 'I', 'S', 'C', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '\0', /* COMPUTE_MISC_RESERVED (10720, 10733) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'I', 'D', '\0', /* COMPUTE_DISPATCH_ID (10742) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'H', 'R', 'E', 'A', 'D', 'G', 'R', 'O', 'U', 'P', '_', 'I', 'D', '\0', /* COMPUTE_THREADGROUP_ID (10762) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'Q', '_', 'C', 'T', 'R', 'L', '\0', /* COMPUTE_REQ_CTRL (10785) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', '0', '\0', /* COMPUTE_USER_ACCUM_0 (10802) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', '1', '\0', /* COMPUTE_USER_ACCUM_1 (10823) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', '2', '\0', /* COMPUTE_USER_ACCUM_2 (10844) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', '3', '\0', /* COMPUTE_USER_ACCUM_3 (10865) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '\0', /* COMPUTE_PGM_RSRC3 (10886) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'D', 'I', 'D', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* COMPUTE_DDID_INDEX (10904) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'C', 'H', 'K', 'S', 'U', 'M', '\0', /* COMPUTE_SHADER_CHKSUM (10923) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'L', 'A', 'U', 'N', 'C', 'H', '\0', /* COMPUTE_RELAUNCH (10945) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'W', 'A', 'V', 'E', '_', 'R', 'E', 'S', 'T', 'O', 'R', 'E', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* COMPUTE_WAVE_RESTORE_ADDR_LO (10962) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'W', 'A', 'V', 'E', '_', 'R', 'E', 'S', 'T', 'O', 'R', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* COMPUTE_WAVE_RESTORE_ADDR_HI (10991) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'L', 'A', 'U', 'N', 'C', 'H', '2', '\0', /* COMPUTE_RELAUNCH2 (11020) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '0', '\0', /* COMPUTE_USER_DATA_0 (11038) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '\0', /* COMPUTE_USER_DATA_1 (11058) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '2', '\0', /* COMPUTE_USER_DATA_2 (11078) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '3', '\0', /* COMPUTE_USER_DATA_3 (11098) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '4', '\0', /* COMPUTE_USER_DATA_4 (11118) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '5', '\0', /* COMPUTE_USER_DATA_5 (11138) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '6', '\0', /* COMPUTE_USER_DATA_6 (11158) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '7', '\0', /* COMPUTE_USER_DATA_7 (11178) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '8', '\0', /* COMPUTE_USER_DATA_8 (11198) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '9', '\0', /* COMPUTE_USER_DATA_9 (11218) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '0', '\0', /* COMPUTE_USER_DATA_10 (11238) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '1', '\0', /* COMPUTE_USER_DATA_11 (11259) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '2', '\0', /* COMPUTE_USER_DATA_12 (11280) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '3', '\0', /* COMPUTE_USER_DATA_13 (11301) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '4', '\0', /* COMPUTE_USER_DATA_14 (11322) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '5', '\0', /* COMPUTE_USER_DATA_15 (11343) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'T', 'U', 'N', 'N', 'E', 'L', '\0', /* COMPUTE_DISPATCH_TUNNEL (11364) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'E', 'N', 'D', '\0', /* COMPUTE_DISPATCH_END (11388) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'N', 'O', 'W', 'H', 'E', 'R', 'E', '\0', /* COMPUTE_NOWHERE (11409, 11417) */
	'D', 'B', '_', 'R', 'E', 'N', 'D', 'E', 'R', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_RENDER_CONTROL (11425) */
	'D', 'B', '_', 'C', 'O', 'U', 'N', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_COUNT_CONTROL (11443) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'V', 'I', 'E', 'W', '\0', /* DB_DEPTH_VIEW (11460) */
	'D', 'B', '_', 'R', 'E', 'N', 'D', 'E', 'R', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* DB_RENDER_OVERRIDE (11474) */
	'D', 'B', '_', 'R', 'E', 'N', 'D', 'E', 'R', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '2', '\0', /* DB_RENDER_OVERRIDE2 (11493) */
	'D', 'B', '_', 'H', 'T', 'I', 'L', 'E', '_', 'D', 'A', 'T', 'A', '_', 'B', 'A', 'S', 'E', '\0', /* DB_HTILE_DATA_BASE (11513) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'S', 'I', 'Z', 'E', '_', 'X', 'Y', '\0', /* DB_DEPTH_SIZE_XY (11532) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'B', 'O', 'U', 'N', 'D', 'S', '_', 'M', 'I', 'N', '\0', /* DB_DEPTH_BOUNDS_MIN (11549, 11565) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'B', 'O', 'U', 'N', 'D', 'S', '_', 'M', 'A', 'X', '\0', /* DB_DEPTH_BOUNDS_MAX (11569, 11585) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'C', 'L', 'E', 'A', 'R', '\0', /* DB_STENCIL_CLEAR (11589, 11600) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'C', 'L', 'E', 'A', 'R', '\0', /* DB_DEPTH_CLEAR (11606) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', 'T', 'L', '\0', /* PA_SC_SCREEN_SCISSOR_TL (11621) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', 'B', 'R', '\0', /* PA_SC_SCREEN_SCISSOR_BR (11645) */
	'D', 'B', '_', 'D', 'F', 'S', 'M', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_DFSM_CONTROL (11669) */
	'D', 'B', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '_', '2', '\0', /* DB_RESERVED_REG_2 (11685) */
	'D', 'B', '_', 'Z', '_', 'I', 'N', 'F', 'O', '\0', /* DB_Z_INFO (11703) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'I', 'N', 'F', 'O', '\0', /* DB_STENCIL_INFO (11713) */
	'D', 'B', '_', 'Z', '_', 'R', 'E', 'A', 'D', '_', 'B', 'A', 'S', 'E', '\0', /* DB_Z_READ_BASE (11729) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'R', 'E', 'A', 'D', '_', 'B', 'A', 'S', 'E', '\0', /* DB_STENCIL_READ_BASE (11744) */
	'D', 'B', '_', 'Z', '_', 'W', 'R', 'I', 'T', 'E', '_', 'B', 'A', 'S', 'E', '\0', /* DB_Z_WRITE_BASE (11765) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'W', 'R', 'I', 'T', 'E', '_', 'B', 'A', 'S', 'E', '\0', /* DB_STENCIL_WRITE_BASE (11781) */
	'D', 'B', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '_', '1', '\0', /* DB_RESERVED_REG_1 (11803) */
	'D', 'B', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '_', '3', '\0', /* DB_RESERVED_REG_3 (11821) */
	'D', 'B', '_', 'Z', '_', 'R', 'E', 'A', 'D', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* DB_Z_READ_BASE_HI (11839) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'R', 'E', 'A', 'D', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* DB_STENCIL_READ_BASE_HI (11857) */
	'D', 'B', '_', 'Z', '_', 'W', 'R', 'I', 'T', 'E', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* DB_Z_WRITE_BASE_HI (11881) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'W', 'R', 'I', 'T', 'E', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* DB_STENCIL_WRITE_BASE_HI (11900) */
	'D', 'B', '_', 'H', 'T', 'I', 'L', 'E', '_', 'D', 'A', 'T', 'A', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* DB_HTILE_DATA_BASE_HI (11925) */
	'D', 'B', '_', 'R', 'M', 'I', '_', 'L', '2', '_', 'C', 'A', 'C', 'H', 'E', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_RMI_L2_CACHE_CONTROL (11947, 11957) */
	'T', 'A', '_', 'B', 'C', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '\0', /* TA_BC_BASE_ADDR (11971, 11977, 11982) */
	'T', 'A', '_', 'B', 'C', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* TA_BC_BASE_ADDR_HI (11987) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '_', '0', '\0', /* COHER_DEST_BASE_HI_0 (12006) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '_', '1', '\0', /* COHER_DEST_BASE_HI_1 (12027) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '_', '2', '\0', /* COHER_DEST_BASE_HI_2 (12048) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '_', '3', '\0', /* COHER_DEST_BASE_HI_3 (12069) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', '2', '\0', /* COHER_DEST_BASE_2 (12090) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', '3', '\0', /* COHER_DEST_BASE_3 (12108) */
	'P', 'A', '_', 'S', 'C', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_SC_WINDOW_OFFSET (12126, 12137) */
	'P', 'A', '_', 'S', 'C', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', 'T', 'L', '\0', /* PA_SC_WINDOW_SCISSOR_TL (12146) */
	'P', 'A', '_', 'S', 'C', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', 'B', 'R', '\0', /* PA_SC_WINDOW_SCISSOR_BR (12170) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', 'R', 'U', 'L', 'E', '\0', /* PA_SC_CLIPRECT_RULE (12194) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '0', '_', 'T', 'L', '\0', /* PA_SC_CLIPRECT_0_TL (12214) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '0', '_', 'B', 'R', '\0', /* PA_SC_CLIPRECT_0_BR (12234) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '1', '_', 'T', 'L', '\0', /* PA_SC_CLIPRECT_1_TL (12254) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '1', '_', 'B', 'R', '\0', /* PA_SC_CLIPRECT_1_BR (12274) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '2', '_', 'T', 'L', '\0', /* PA_SC_CLIPRECT_2_TL (12294) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '2', '_', 'B', 'R', '\0', /* PA_SC_CLIPRECT_2_BR (12314) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '3', '_', 'T', 'L', '\0', /* PA_SC_CLIPRECT_3_TL (12334) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '3', '_', 'B', 'R', '\0', /* PA_SC_CLIPRECT_3_BR (12354) */
	'P', 'A', '_', 'S', 'C', '_', 'E', 'D', 'G', 'E', 'R', 'U', 'L', 'E', '\0', /* PA_SC_EDGERULE (12374) */
	'P', 'A', '_', 'S', 'U', '_', 'H', 'A', 'R', 'D', 'W', 'A', 'R', 'E', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_SU_HARDWARE_SCREEN_OFFSET (12389) */
	'C', 'B', '_', 'T', 'A', 'R', 'G', 'E', 'T', '_', 'M', 'A', 'S', 'K', '\0', /* CB_TARGET_MASK (12418) */
	'C', 'B', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'M', 'A', 'S', 'K', '\0', /* CB_SHADER_MASK (12433) */
	'P', 'A', '_', 'S', 'C', '_', 'G', 'E', 'N', 'E', 'R', 'I', 'C', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', 'T', 'L', '\0', /* PA_SC_GENERIC_SCISSOR_TL (12448) */
	'P', 'A', '_', 'S', 'C', '_', 'G', 'E', 'N', 'E', 'R', 'I', 'C', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', 'B', 'R', '\0', /* PA_SC_GENERIC_SCISSOR_BR (12473) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', '0', '\0', /* COHER_DEST_BASE_0 (12498) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', '1', '\0', /* COHER_DEST_BASE_1 (12516) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '0', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_0_TL (12534) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '0', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_0_BR (12559) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_1_TL (12584) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_1_BR (12609) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '2', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_2_TL (12634) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '2', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_2_BR (12659) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '3', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_3_TL (12684) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '3', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_3_BR (12709) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '4', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_4_TL (12734) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '4', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_4_BR (12759) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '5', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_5_TL (12784) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '5', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_5_BR (12809) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '6', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_6_TL (12834) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '6', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_6_BR (12859) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '7', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_7_TL (12884) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '7', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_7_BR (12909) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '8', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_8_TL (12934) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '8', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_8_BR (12959) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '9', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_9_TL (12984) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '9', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_9_BR (13009) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '0', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_10_TL (13034) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '0', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_10_BR (13060) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '1', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_11_TL (13086) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '1', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_11_BR (13112) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '2', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_12_TL (13138) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '2', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_12_BR (13164) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '3', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_13_TL (13190) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '3', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_13_BR (13216) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '4', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_14_TL (13242) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '4', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_14_BR (13268) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '5', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_15_TL (13294) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '5', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_15_BR (13320) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '0', '\0', /* PA_SC_VPORT_ZMIN_0 (13346, 13360) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '0', '\0', /* PA_SC_VPORT_ZMAX_0 (13365) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '\0', /* PA_SC_VPORT_ZMIN_1 (13384, 13398) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '\0', /* PA_SC_VPORT_ZMAX_1 (13403) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '2', '\0', /* PA_SC_VPORT_ZMIN_2 (13422, 13436) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '2', '\0', /* PA_SC_VPORT_ZMAX_2 (13441) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '3', '\0', /* PA_SC_VPORT_ZMIN_3 (13460, 13474) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '3', '\0', /* PA_SC_VPORT_ZMAX_3 (13479) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '4', '\0', /* PA_SC_VPORT_ZMIN_4 (13498) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '4', '\0', /* PA_SC_VPORT_ZMAX_4 (13517) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '5', '\0', /* PA_SC_VPORT_ZMIN_5 (13536) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '5', '\0', /* PA_SC_VPORT_ZMAX_5 (13555) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '6', '\0', /* PA_SC_VPORT_ZMIN_6 (13574) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '6', '\0', /* PA_SC_VPORT_ZMAX_6 (13593) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '7', '\0', /* PA_SC_VPORT_ZMIN_7 (13612) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '7', '\0', /* PA_SC_VPORT_ZMAX_7 (13631) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '8', '\0', /* PA_SC_VPORT_ZMIN_8 (13650) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '8', '\0', /* PA_SC_VPORT_ZMAX_8 (13669) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '9', '\0', /* PA_SC_VPORT_ZMIN_9 (13688) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '9', '\0', /* PA_SC_VPORT_ZMAX_9 (13707) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '0', '\0', /* PA_SC_VPORT_ZMIN_10 (13726, 13740) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '0', '\0', /* PA_SC_VPORT_ZMAX_10 (13746) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '1', '\0', /* PA_SC_VPORT_ZMIN_11 (13766) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '1', '\0', /* PA_SC_VPORT_ZMAX_11 (13786) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '2', '\0', /* PA_SC_VPORT_ZMIN_12 (13806) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '2', '\0', /* PA_SC_VPORT_ZMAX_12 (13826) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '3', '\0', /* PA_SC_VPORT_ZMIN_13 (13846) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '3', '\0', /* PA_SC_VPORT_ZMAX_13 (13866) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '4', '\0', /* PA_SC_VPORT_ZMIN_14 (13886) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '4', '\0', /* PA_SC_VPORT_ZMAX_14 (13906) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '5', '\0', /* PA_SC_VPORT_ZMIN_15 (13926) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '5', '\0', /* PA_SC_VPORT_ZMAX_15 (13946) */
	'P', 'A', '_', 'S', 'C', '_', 'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* PA_SC_RASTER_CONFIG (13966) */
	'P', 'A', '_', 'S', 'C', '_', 'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', '1', '\0', /* PA_SC_RASTER_CONFIG_1 (13986) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'E', 'X', 'T', 'E', 'N', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* PA_SC_SCREEN_EXTENT_CONTROL (14008) */
	'P', 'A', '_', 'S', 'C', '_', 'T', 'I', 'L', 'E', '_', 'S', 'T', 'E', 'E', 'R', 'I', 'N', 'G', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* PA_SC_TILE_STEERING_OVERRIDE (14036) */
	'C', 'P', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'C', 'N', 'T', 'X', '_', 'C', 'N', 'T', 'L', '\0', /* CP_PERFMON_CNTX_CNTL (14065) */
	'C', 'P', '_', 'P', 'I', 'P', 'E', 'I', 'D', '\0', /* CP_PIPEID (14086) */
	'C', 'P', '_', 'V', 'M', 'I', 'D', '\0', /* CP_VMID (14096) */
	'P', 'A', '_', 'S', 'C', '_', 'R', 'I', 'G', 'H', 'T', '_', 'V', 'E', 'R', 'T', '_', 'G', 'R', 'I', 'D', '\0', /* PA_SC_RIGHT_VERT_GRID (14104) */
	'P', 'A', '_', 'S', 'C', '_', 'L', 'E', 'F', 'T', '_', 'V', 'E', 'R', 'T', '_', 'G', 'R', 'I', 'D', '\0', /* PA_SC_LEFT_VERT_GRID (14126) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'O', 'R', 'I', 'Z', '_', 'G', 'R', 'I', 'D', '\0', /* PA_SC_HORIZ_GRID (14147) */
	'V', 'G', 'T', '_', 'M', 'A', 'X', '_', 'V', 'T', 'X', '_', 'I', 'N', 'D', 'X', '\0', /* VGT_MAX_VTX_INDX (14164) */
	'V', 'G', 'T', '_', 'M', 'I', 'N', '_', 'V', 'T', 'X', '_', 'I', 'N', 'D', 'X', '\0', /* VGT_MIN_VTX_INDX (14181) */
	'V', 'G', 'T', '_', 'I', 'N', 'D', 'X', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* VGT_INDX_OFFSET (14198, 14205) */
	'V', 'G', 'T', '_', 'M', 'U', 'L', 'T', 'I', '_', 'P', 'R', 'I', 'M', '_', 'I', 'B', '_', 'R', 'E', 'S', 'E', 'T', '_', 'I', 'N', 'D', 'X', '\0', /* VGT_MULTI_PRIM_IB_RESET_INDX (14214) */
	'C', 'B', '_', 'R', 'M', 'I', '_', 'G', 'L', '2', '_', 'C', 'A', 'C', 'H', 'E', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_RMI_GL2_CACHE_CONTROL (14243) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '_', 'R', 'E', 'D', '\0', /* CB_BLEND_RED (14268) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '_', 'G', 'R', 'E', 'E', 'N', '\0', /* CB_BLEND_GREEN (14281, 14293) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '_', 'B', 'L', 'U', 'E', '\0', /* CB_BLEND_BLUE (14296) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* CB_BLEND_ALPHA (14310) */
	'C', 'B', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_DCC_CONTROL (14325) */
	'C', 'B', '_', 'C', 'O', 'V', 'E', 'R', 'A', 'G', 'E', '_', 'O', 'U', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COVERAGE_OUT_CONTROL (14340) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_STENCIL_CONTROL (14364) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', 'R', 'E', 'F', 'M', 'A', 'S', 'K', '\0', /* DB_STENCILREFMASK (14383) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', 'R', 'E', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'F', '\0', /* DB_STENCILREFMASK_BF (14401) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '\0', /* PA_CL_VPORT_XSCALE (14422) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_CL_VPORT_XOFFSET (14441) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '\0', /* PA_CL_VPORT_YSCALE (14461) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_CL_VPORT_YOFFSET (14480) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '\0', /* PA_CL_VPORT_ZSCALE (14500) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_CL_VPORT_ZOFFSET (14519) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '\0', /* PA_CL_VPORT_XSCALE_1 (14539) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '\0', /* PA_CL_VPORT_XOFFSET_1 (14560) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '\0', /* PA_CL_VPORT_YSCALE_1 (14582) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '\0', /* PA_CL_VPORT_YOFFSET_1 (14603) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '\0', /* PA_CL_VPORT_ZSCALE_1 (14625) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '\0', /* PA_CL_VPORT_ZOFFSET_1 (14646) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '2', '\0', /* PA_CL_VPORT_XSCALE_2 (14668) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '2', '\0', /* PA_CL_VPORT_XOFFSET_2 (14689) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '2', '\0', /* PA_CL_VPORT_YSCALE_2 (14711) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '2', '\0', /* PA_CL_VPORT_YOFFSET_2 (14732) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '2', '\0', /* PA_CL_VPORT_ZSCALE_2 (14754) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '2', '\0', /* PA_CL_VPORT_ZOFFSET_2 (14775) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '3', '\0', /* PA_CL_VPORT_XSCALE_3 (14797) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '3', '\0', /* PA_CL_VPORT_XOFFSET_3 (14818) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '3', '\0', /* PA_CL_VPORT_YSCALE_3 (14840) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '3', '\0', /* PA_CL_VPORT_YOFFSET_3 (14861) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '3', '\0', /* PA_CL_VPORT_ZSCALE_3 (14883) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '3', '\0', /* PA_CL_VPORT_ZOFFSET_3 (14904) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '4', '\0', /* PA_CL_VPORT_XSCALE_4 (14926) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '4', '\0', /* PA_CL_VPORT_XOFFSET_4 (14947) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '4', '\0', /* PA_CL_VPORT_YSCALE_4 (14969) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '4', '\0', /* PA_CL_VPORT_YOFFSET_4 (14990) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '4', '\0', /* PA_CL_VPORT_ZSCALE_4 (15012) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '4', '\0', /* PA_CL_VPORT_ZOFFSET_4 (15033) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '5', '\0', /* PA_CL_VPORT_XSCALE_5 (15055) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '5', '\0', /* PA_CL_VPORT_XOFFSET_5 (15076) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '5', '\0', /* PA_CL_VPORT_YSCALE_5 (15098) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '5', '\0', /* PA_CL_VPORT_YOFFSET_5 (15119) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '5', '\0', /* PA_CL_VPORT_ZSCALE_5 (15141) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '5', '\0', /* PA_CL_VPORT_ZOFFSET_5 (15162) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '6', '\0', /* PA_CL_VPORT_XSCALE_6 (15184) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '6', '\0', /* PA_CL_VPORT_XOFFSET_6 (15205) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '6', '\0', /* PA_CL_VPORT_YSCALE_6 (15227) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '6', '\0', /* PA_CL_VPORT_YOFFSET_6 (15248) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '6', '\0', /* PA_CL_VPORT_ZSCALE_6 (15270) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '6', '\0', /* PA_CL_VPORT_ZOFFSET_6 (15291) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '7', '\0', /* PA_CL_VPORT_XSCALE_7 (15313) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '7', '\0', /* PA_CL_VPORT_XOFFSET_7 (15334) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '7', '\0', /* PA_CL_VPORT_YSCALE_7 (15356) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '7', '\0', /* PA_CL_VPORT_YOFFSET_7 (15377) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '7', '\0', /* PA_CL_VPORT_ZSCALE_7 (15399) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '7', '\0', /* PA_CL_VPORT_ZOFFSET_7 (15420) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '8', '\0', /* PA_CL_VPORT_XSCALE_8 (15442) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '8', '\0', /* PA_CL_VPORT_XOFFSET_8 (15463) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '8', '\0', /* PA_CL_VPORT_YSCALE_8 (15485) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '8', '\0', /* PA_CL_VPORT_YOFFSET_8 (15506) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '8', '\0', /* PA_CL_VPORT_ZSCALE_8 (15528) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '8', '\0', /* PA_CL_VPORT_ZOFFSET_8 (15549) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '9', '\0', /* PA_CL_VPORT_XSCALE_9 (15571) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '9', '\0', /* PA_CL_VPORT_XOFFSET_9 (15592) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '9', '\0', /* PA_CL_VPORT_YSCALE_9 (15614) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '9', '\0', /* PA_CL_VPORT_YOFFSET_9 (15635) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '9', '\0', /* PA_CL_VPORT_ZSCALE_9 (15657) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '9', '\0', /* PA_CL_VPORT_ZOFFSET_9 (15678) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '0', '\0', /* PA_CL_VPORT_XSCALE_10 (15700) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '0', '\0', /* PA_CL_VPORT_XOFFSET_10 (15722) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '0', '\0', /* PA_CL_VPORT_YSCALE_10 (15745) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '0', '\0', /* PA_CL_VPORT_YOFFSET_10 (15767) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '0', '\0', /* PA_CL_VPORT_ZSCALE_10 (15790) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '0', '\0', /* PA_CL_VPORT_ZOFFSET_10 (15812) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '1', '\0', /* PA_CL_VPORT_XSCALE_11 (15835) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '1', '\0', /* PA_CL_VPORT_XOFFSET_11 (15857) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '1', '\0', /* PA_CL_VPORT_YSCALE_11 (15880) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '1', '\0', /* PA_CL_VPORT_YOFFSET_11 (15902) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '1', '\0', /* PA_CL_VPORT_ZSCALE_11 (15925) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '1', '\0', /* PA_CL_VPORT_ZOFFSET_11 (15947) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '2', '\0', /* PA_CL_VPORT_XSCALE_12 (15970) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '2', '\0', /* PA_CL_VPORT_XOFFSET_12 (15992) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '2', '\0', /* PA_CL_VPORT_YSCALE_12 (16015) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '2', '\0', /* PA_CL_VPORT_YOFFSET_12 (16037) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '2', '\0', /* PA_CL_VPORT_ZSCALE_12 (16060) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '2', '\0', /* PA_CL_VPORT_ZOFFSET_12 (16082) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '3', '\0', /* PA_CL_VPORT_XSCALE_13 (16105) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '3', '\0', /* PA_CL_VPORT_XOFFSET_13 (16127) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '3', '\0', /* PA_CL_VPORT_YSCALE_13 (16150) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '3', '\0', /* PA_CL_VPORT_YOFFSET_13 (16172) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '3', '\0', /* PA_CL_VPORT_ZSCALE_13 (16195) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '3', '\0', /* PA_CL_VPORT_ZOFFSET_13 (16217) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '4', '\0', /* PA_CL_VPORT_XSCALE_14 (16240) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '4', '\0', /* PA_CL_VPORT_XOFFSET_14 (16262) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '4', '\0', /* PA_CL_VPORT_YSCALE_14 (16285) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '4', '\0', /* PA_CL_VPORT_YOFFSET_14 (16307) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '4', '\0', /* PA_CL_VPORT_ZSCALE_14 (16330) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '4', '\0', /* PA_CL_VPORT_ZOFFSET_14 (16352) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '5', '\0', /* PA_CL_VPORT_XSCALE_15 (16375) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '5', '\0', /* PA_CL_VPORT_XOFFSET_15 (16397) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '5', '\0', /* PA_CL_VPORT_YSCALE_15 (16420) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '5', '\0', /* PA_CL_VPORT_YOFFSET_15 (16442) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '5', '\0', /* PA_CL_VPORT_ZSCALE_15 (16465) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '5', '\0', /* PA_CL_VPORT_ZOFFSET_15 (16487) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '0', '_', 'X', '\0', /* PA_CL_UCP_0_X (16510) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '0', '_', 'Y', '\0', /* PA_CL_UCP_0_Y (16524) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '0', '_', 'Z', '\0', /* PA_CL_UCP_0_Z (16538) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '0', '_', 'W', '\0', /* PA_CL_UCP_0_W (16552) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '1', '_', 'X', '\0', /* PA_CL_UCP_1_X (16566) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '1', '_', 'Y', '\0', /* PA_CL_UCP_1_Y (16580) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '1', '_', 'Z', '\0', /* PA_CL_UCP_1_Z (16594) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '1', '_', 'W', '\0', /* PA_CL_UCP_1_W (16608) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '2', '_', 'X', '\0', /* PA_CL_UCP_2_X (16622) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '2', '_', 'Y', '\0', /* PA_CL_UCP_2_Y (16636) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '2', '_', 'Z', '\0', /* PA_CL_UCP_2_Z (16650) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '2', '_', 'W', '\0', /* PA_CL_UCP_2_W (16664) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '3', '_', 'X', '\0', /* PA_CL_UCP_3_X (16678) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '3', '_', 'Y', '\0', /* PA_CL_UCP_3_Y (16692) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '3', '_', 'Z', '\0', /* PA_CL_UCP_3_Z (16706) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '3', '_', 'W', '\0', /* PA_CL_UCP_3_W (16720) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '4', '_', 'X', '\0', /* PA_CL_UCP_4_X (16734) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '4', '_', 'Y', '\0', /* PA_CL_UCP_4_Y (16748) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '4', '_', 'Z', '\0', /* PA_CL_UCP_4_Z (16762) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '4', '_', 'W', '\0', /* PA_CL_UCP_4_W (16776) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '5', '_', 'X', '\0', /* PA_CL_UCP_5_X (16790) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '5', '_', 'Y', '\0', /* PA_CL_UCP_5_Y (16804) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '5', '_', 'Z', '\0', /* PA_CL_UCP_5_Z (16818) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '5', '_', 'W', '\0', /* PA_CL_UCP_5_W (16832) */
	'P', 'A', '_', 'C', 'L', '_', 'P', 'R', 'O', 'G', '_', 'N', 'E', 'A', 'R', '_', 'C', 'L', 'I', 'P', '_', 'Z', '\0', /* PA_CL_PROG_NEAR_CLIP_Z (16846) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '0', '\0', /* SPI_PS_INPUT_CNTL_0 (16869) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '\0', /* SPI_PS_INPUT_CNTL_1 (16889) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '\0', /* SPI_PS_INPUT_CNTL_2 (16909) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '3', '\0', /* SPI_PS_INPUT_CNTL_3 (16929) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '4', '\0', /* SPI_PS_INPUT_CNTL_4 (16949) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '5', '\0', /* SPI_PS_INPUT_CNTL_5 (16969) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '6', '\0', /* SPI_PS_INPUT_CNTL_6 (16989) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '7', '\0', /* SPI_PS_INPUT_CNTL_7 (17009) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '8', '\0', /* SPI_PS_INPUT_CNTL_8 (17029) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '9', '\0', /* SPI_PS_INPUT_CNTL_9 (17049) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '0', '\0', /* SPI_PS_INPUT_CNTL_10 (17069) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '1', '\0', /* SPI_PS_INPUT_CNTL_11 (17090) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '2', '\0', /* SPI_PS_INPUT_CNTL_12 (17111) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '3', '\0', /* SPI_PS_INPUT_CNTL_13 (17132) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '4', '\0', /* SPI_PS_INPUT_CNTL_14 (17153) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '5', '\0', /* SPI_PS_INPUT_CNTL_15 (17174) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '6', '\0', /* SPI_PS_INPUT_CNTL_16 (17195) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '7', '\0', /* SPI_PS_INPUT_CNTL_17 (17216) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '8', '\0', /* SPI_PS_INPUT_CNTL_18 (17237) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '9', '\0', /* SPI_PS_INPUT_CNTL_19 (17258) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '0', '\0', /* SPI_PS_INPUT_CNTL_20 (17279) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '1', '\0', /* SPI_PS_INPUT_CNTL_21 (17300) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '2', '\0', /* SPI_PS_INPUT_CNTL_22 (17321) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '3', '\0', /* SPI_PS_INPUT_CNTL_23 (17342) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '4', '\0', /* SPI_PS_INPUT_CNTL_24 (17363) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '5', '\0', /* SPI_PS_INPUT_CNTL_25 (17384) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '6', '\0', /* SPI_PS_INPUT_CNTL_26 (17405) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '7', '\0', /* SPI_PS_INPUT_CNTL_27 (17426) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '8', '\0', /* SPI_PS_INPUT_CNTL_28 (17447) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '9', '\0', /* SPI_PS_INPUT_CNTL_29 (17468) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '3', '0', '\0', /* SPI_PS_INPUT_CNTL_30 (17489) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '3', '1', '\0', /* SPI_PS_INPUT_CNTL_31 (17510) */
	'S', 'P', 'I', '_', 'V', 'S', '_', 'O', 'U', 'T', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* SPI_VS_OUT_CONFIG (17531) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'E', 'N', 'A', '\0', /* SPI_PS_INPUT_ENA (17549) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'A', 'D', 'D', 'R', '\0', /* SPI_PS_INPUT_ADDR (17566) */
	'S', 'P', 'I', '_', 'I', 'N', 'T', 'E', 'R', 'P', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '_', '0', '\0', /* SPI_INTERP_CONTROL_0 (17584) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* SPI_PS_IN_CONTROL (17605) */
	'S', 'P', 'I', '_', 'B', 'A', 'R', 'Y', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* SPI_BARYC_CNTL (17623) */
	'S', 'P', 'I', '_', 'T', 'M', 'P', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* SPI_TMPRING_SIZE (17638) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'I', 'D', 'X', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* SPI_SHADER_IDX_FORMAT (17655, 17670) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'O', 'S', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* SPI_SHADER_POS_FORMAT (17677) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'Z', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* SPI_SHADER_Z_FORMAT (17699) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'C', 'O', 'L', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* SPI_SHADER_COL_FORMAT (17719) */
	'S', 'X', '_', 'P', 'S', '_', 'D', 'O', 'W', 'N', 'C', 'O', 'N', 'V', 'E', 'R', 'T', '\0', /* SX_PS_DOWNCONVERT (17741) */
	'S', 'X', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'E', 'P', 'S', 'I', 'L', 'O', 'N', '\0', /* SX_BLEND_OPT_EPSILON (17759) */
	'S', 'X', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* SX_BLEND_OPT_CONTROL (17780) */
	'S', 'X', '_', 'M', 'R', 'T', '0', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT0_BLEND_OPT (17801) */
	'S', 'X', '_', 'M', 'R', 'T', '1', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT1_BLEND_OPT (17819) */
	'S', 'X', '_', 'M', 'R', 'T', '2', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT2_BLEND_OPT (17837) */
	'S', 'X', '_', 'M', 'R', 'T', '3', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT3_BLEND_OPT (17855) */
	'S', 'X', '_', 'M', 'R', 'T', '4', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT4_BLEND_OPT (17873) */
	'S', 'X', '_', 'M', 'R', 'T', '5', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT5_BLEND_OPT (17891) */
	'S', 'X', '_', 'M', 'R', 'T', '6', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT6_BLEND_OPT (17909) */
	'S', 'X', '_', 'M', 'R', 'T', '7', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT7_BLEND_OPT (17927) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '0', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND0_CONTROL (17945) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '1', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND1_CONTROL (17963) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '2', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND2_CONTROL (17981) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '3', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND3_CONTROL (17999) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '4', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND4_CONTROL (18017) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '5', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND5_CONTROL (18035) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '6', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND6_CONTROL (18053) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '7', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND7_CONTROL (18071) */
	'C', 'S', '_', 'C', 'O', 'P', 'Y', '_', 'S', 'T', 'A', 'T', 'E', '\0', /* CS_COPY_STATE (18089) */
	'G', 'F', 'X', '_', 'C', 'O', 'P', 'Y', '_', 'S', 'T', 'A', 'T', 'E', '\0', /* GFX_COPY_STATE (18103) */
	'P', 'A', '_', 'C', 'L', '_', 'P', 'O', 'I', 'N', 'T', '_', 'X', '_', 'R', 'A', 'D', '\0', /* PA_CL_POINT_X_RAD (18118) */
	'P', 'A', '_', 'C', 'L', '_', 'P', 'O', 'I', 'N', 'T', '_', 'Y', '_', 'R', 'A', 'D', '\0', /* PA_CL_POINT_Y_RAD (18136) */
	'P', 'A', '_', 'C', 'L', '_', 'P', 'O', 'I', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* PA_CL_POINT_SIZE (18154) */
	'P', 'A', '_', 'C', 'L', '_', 'P', 'O', 'I', 'N', 'T', '_', 'C', 'U', 'L', 'L', '_', 'R', 'A', 'D', '\0', /* PA_CL_POINT_CULL_RAD (18171) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* VGT_DMA_BASE_HI (18192) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'B', 'A', 'S', 'E', '\0', /* VGT_DMA_BASE (18208) */
	'V', 'G', 'T', '_', 'D', 'R', 'A', 'W', '_', 'I', 'N', 'I', 'T', 'I', 'A', 'T', 'O', 'R', '\0', /* VGT_DRAW_INITIATOR (18221) */
	'V', 'G', 'T', '_', 'I', 'M', 'M', 'E', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* VGT_IMMED_DATA (18240) */
	'V', 'G', 'T', '_', 'E', 'V', 'E', 'N', 'T', '_', 'A', 'D', 'D', 'R', 'E', 'S', 'S', '_', 'R', 'E', 'G', '\0', /* VGT_EVENT_ADDRESS_REG (18255) */
	'G', 'E', '_', 'M', 'A', 'X', '_', 'O', 'U', 'T', 'P', 'U', 'T', '_', 'P', 'E', 'R', '_', 'S', 'U', 'B', 'G', 'R', 'O', 'U', 'P', '\0', /* GE_MAX_OUTPUT_PER_SUBGROUP (18277) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_DEPTH_CONTROL (18304) */
	'D', 'B', '_', 'E', 'Q', 'A', 'A', '\0', /* DB_EQAA (18321) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR_CONTROL (18329) */
	'D', 'B', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_SHADER_CONTROL (18346) */
	'P', 'A', '_', 'C', 'L', '_', 'C', 'L', 'I', 'P', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_CLIP_CNTL (18364) */
	'P', 'A', '_', 'S', 'U', '_', 'S', 'C', '_', 'M', 'O', 'D', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_SC_MODE_CNTL (18380) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'T', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_VTE_CNTL (18399) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'S', '_', 'O', 'U', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_VS_OUT_CNTL (18414) */
	'P', 'A', '_', 'C', 'L', '_', 'N', 'A', 'N', 'I', 'N', 'F', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_NANINF_CNTL (18432) */
	'P', 'A', '_', 'S', 'U', '_', 'L', 'I', 'N', 'E', '_', 'S', 'T', 'I', 'P', 'P', 'L', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_LINE_STIPPLE_CNTL (18450) */
	'P', 'A', '_', 'S', 'U', '_', 'L', 'I', 'N', 'E', '_', 'S', 'T', 'I', 'P', 'P', 'L', 'E', '_', 'S', 'C', 'A', 'L', 'E', '\0', /* PA_SU_LINE_STIPPLE_SCALE (18474) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'R', 'I', 'M', '_', 'F', 'I', 'L', 'T', 'E', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_PRIM_FILTER_CNTL (18499) */
	'P', 'A', '_', 'S', 'U', '_', 'S', 'M', 'A', 'L', 'L', '_', 'P', 'R', 'I', 'M', '_', 'F', 'I', 'L', 'T', 'E', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_SMALL_PRIM_FILTER_CNTL (18522) */
	'P', 'A', '_', 'C', 'L', '_', 'O', 'B', 'J', 'P', 'R', 'I', 'M', '_', 'I', 'D', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_OBJPRIM_ID_CNTL (18551) */
	'P', 'A', '_', 'C', 'L', '_', 'N', 'G', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_NGG_CNTL (18573) */
	'P', 'A', '_', 'S', 'U', '_', 'O', 'V', 'E', 'R', '_', 'R', 'A', 'S', 'T', 'E', 'R', 'I', 'Z', 'A', 'T', 'I', 'O', 'N', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_OVER_RASTERIZATION_CNTL (18588) */
	'P', 'A', '_', 'S', 'T', 'E', 'R', 'E', 'O', '_', 'C', 'N', 'T', 'L', '\0', /* PA_STEREO_CNTL (18618) */
	'P', 'A', '_', 'S', 'T', 'A', 'T', 'E', '_', 'S', 'T', 'E', 'R', 'E', 'O', '_', 'X', '\0', /* PA_STATE_STEREO_X (18633) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'I', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* PA_SU_POINT_SIZE (18651) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'I', 'N', 'T', '_', 'M', 'I', 'N', 'M', 'A', 'X', '\0', /* PA_SU_POINT_MINMAX (18668) */
	'P', 'A', '_', 'S', 'U', '_', 'L', 'I', 'N', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_LINE_CNTL (18687) */
	'P', 'A', '_', 'S', 'C', '_', 'L', 'I', 'N', 'E', '_', 'S', 'T', 'I', 'P', 'P', 'L', 'E', '\0', /* PA_SC_LINE_STIPPLE (18703) */
	'V', 'G', 'T', '_', 'O', 'U', 'T', 'P', 'U', 'T', '_', 'P', 'A', 'T', 'H', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_OUTPUT_PATH_CNTL (18722) */
	'V', 'G', 'T', '_', 'H', 'O', 'S', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_HOS_CNTL (18743) */
	'V', 'G', 'T', '_', 'H', 'O', 'S', '_', 'M', 'A', 'X', '_', 'T', 'E', 'S', 'S', '_', 'L', 'E', 'V', 'E', 'L', '\0', /* VGT_HOS_MAX_TESS_LEVEL (18756) */
	'V', 'G', 'T', '_', 'H', 'O', 'S', '_', 'M', 'I', 'N', '_', 'T', 'E', 'S', 'S', '_', 'L', 'E', 'V', 'E', 'L', '\0', /* VGT_HOS_MIN_TESS_LEVEL (18779) */
	'V', 'G', 'T', '_', 'H', 'O', 'S', '_', 'R', 'E', 'U', 'S', 'E', '_', 'D', 'E', 'P', 'T', 'H', '\0', /* VGT_HOS_REUSE_DEPTH (18802, 18810, 18816) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'P', 'R', 'I', 'M', '_', 'T', 'Y', 'P', 'E', '\0', /* VGT_GROUP_PRIM_TYPE (18822, 18832) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'F', 'I', 'R', 'S', 'T', '_', 'D', 'E', 'C', 'R', '\0', /* VGT_GROUP_FIRST_DECR (18842, 18852, 18858) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'D', 'E', 'C', 'R', '\0', /* VGT_GROUP_DECR (18863) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'V', 'E', 'C', 'T', '_', '0', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_GROUP_VECT_0_CNTL (18878) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'V', 'E', 'C', 'T', '_', '1', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_GROUP_VECT_1_CNTL (18900) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'V', 'E', 'C', 'T', '_', '0', '_', 'F', 'M', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_GROUP_VECT_0_FMT_CNTL (18922) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'V', 'E', 'C', 'T', '_', '1', '_', 'F', 'M', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_GROUP_VECT_1_FMT_CNTL (18948) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'M', 'O', 'D', 'E', '\0', /* VGT_GS_MODE (18974) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'O', 'N', 'C', 'H', 'I', 'P', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_GS_ONCHIP_CNTL (18986) */
	'P', 'A', '_', 'S', 'C', '_', 'M', 'O', 'D', 'E', '_', 'C', 'N', 'T', 'L', '_', '0', '\0', /* PA_SC_MODE_CNTL_0 (19005) */
	'P', 'A', '_', 'S', 'C', '_', 'M', 'O', 'D', 'E', '_', 'C', 'N', 'T', 'L', '_', '1', '\0', /* PA_SC_MODE_CNTL_1 (19023) */
	'V', 'G', 'T', '_', 'E', 'N', 'H', 'A', 'N', 'C', 'E', '\0', /* VGT_ENHANCE (19041) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'P', 'E', 'R', '_', 'E', 'S', '\0', /* VGT_GS_PER_ES (19053, 19057) */
	'V', 'G', 'T', '_', 'E', 'S', '_', 'P', 'E', 'R', '_', 'G', 'S', '\0', /* VGT_ES_PER_GS (19067, 19071) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'P', 'E', 'R', '_', 'V', 'S', '\0', /* VGT_GS_PER_VS (19081, 19085) */
	'V', 'G', 'T', '_', 'G', 'S', 'V', 'S', '_', 'R', 'I', 'N', 'G', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '\0', /* VGT_GSVS_RING_OFFSET_1 (19095) */
	'V', 'G', 'T', '_', 'G', 'S', 'V', 'S', '_', 'R', 'I', 'N', 'G', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '2', '\0', /* VGT_GSVS_RING_OFFSET_2 (19118) */
	'V', 'G', 'T', '_', 'G', 'S', 'V', 'S', '_', 'R', 'I', 'N', 'G', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '3', '\0', /* VGT_GSVS_RING_OFFSET_3 (19141) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', '_', 'T', 'Y', 'P', 'E', '\0', /* VGT_GS_OUT_PRIM_TYPE (19164) */
	'I', 'A', '_', 'E', 'N', 'H', 'A', 'N', 'C', 'E', '\0', /* IA_ENHANCE (19185) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'S', 'I', 'Z', 'E', '\0', /* VGT_DMA_SIZE (19196) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'M', 'A', 'X', '_', 'S', 'I', 'Z', 'E', '\0', /* VGT_DMA_MAX_SIZE (19209, 19217) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'I', 'N', 'D', 'E', 'X', '_', 'T', 'Y', 'P', 'E', '\0', /* VGT_DMA_INDEX_TYPE (19226) */
	'W', 'D', '_', 'E', 'N', 'H', 'A', 'N', 'C', 'E', '\0', /* WD_ENHANCE (19245) */
	'V', 'G', 'T', '_', 'P', 'R', 'I', 'M', 'I', 'T', 'I', 'V', 'E', 'I', 'D', '_', 'E', 'N', '\0', /* VGT_PRIMITIVEID_EN (19256, 19260) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'N', 'U', 'M', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', 'S', '\0', /* VGT_DMA_NUM_INSTANCES (19275) */
	'V', 'G', 'T', '_', 'P', 'R', 'I', 'M', 'I', 'T', 'I', 'V', 'E', 'I', 'D', '_', 'R', 'E', 'S', 'E', 'T', '\0', /* VGT_PRIMITIVEID_RESET (19297, 19313) */
	'V', 'G', 'T', '_', 'E', 'V', 'E', 'N', 'T', '_', 'I', 'N', 'I', 'T', 'I', 'A', 'T', 'O', 'R', '\0', /* VGT_EVENT_INITIATOR (19319) */
	'V', 'G', 'T', '_', 'M', 'U', 'L', 'T', 'I', '_', 'P', 'R', 'I', 'M', '_', 'I', 'B', '_', 'R', 'E', 'S', 'E', 'T', '_', 'E', 'N', '\0', /* VGT_MULTI_PRIM_IB_RESET_EN (19339, 19357) */
	'V', 'G', 'T', '_', 'D', 'R', 'A', 'W', '_', 'P', 'A', 'Y', 'L', 'O', 'A', 'D', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_DRAW_PAYLOAD_CNTL (19366) */
	'V', 'G', 'T', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', '_', 'S', 'T', 'E', 'P', '_', 'R', 'A', 'T', 'E', '_', '0', '\0', /* VGT_INSTANCE_STEP_RATE_0 (19388) */
	'V', 'G', 'T', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', '_', 'S', 'T', 'E', 'P', '_', 'R', 'A', 'T', 'E', '_', '1', '\0', /* VGT_INSTANCE_STEP_RATE_1 (19413) */
	'I', 'A', '_', 'M', 'U', 'L', 'T', 'I', '_', 'V', 'G', 'T', '_', 'P', 'A', 'R', 'A', 'M', '\0', /* IA_MULTI_VGT_PARAM (19438) */
	'V', 'G', 'T', '_', 'E', 'S', 'G', 'S', '_', 'R', 'I', 'N', 'G', '_', 'I', 'T', 'E', 'M', 'S', 'I', 'Z', 'E', '\0', /* VGT_ESGS_RING_ITEMSIZE (19457, 19471) */
	'V', 'G', 'T', '_', 'G', 'S', 'V', 'S', '_', 'R', 'I', 'N', 'G', '_', 'I', 'T', 'E', 'M', 'S', 'I', 'Z', 'E', '\0', /* VGT_GSVS_RING_ITEMSIZE (19480) */
	'V', 'G', 'T', '_', 'R', 'E', 'U', 'S', 'E', '_', 'O', 'F', 'F', '\0', /* VGT_REUSE_OFF (19503, 19507) */
	'V', 'G', 'T', '_', 'V', 'T', 'X', '_', 'C', 'N', 'T', '_', 'E', 'N', '\0', /* VGT_VTX_CNT_EN (19517, 19521) */
	'D', 'B', '_', 'H', 'T', 'I', 'L', 'E', '_', 'S', 'U', 'R', 'F', 'A', 'C', 'E', '\0', /* DB_HTILE_SURFACE (19532, 19544) */
	'D', 'B', '_', 'S', 'R', 'E', 'S', 'U', 'L', 'T', 'S', '_', 'C', 'O', 'M', 'P', 'A', 'R', 'E', '_', 'S', 'T', 'A', 'T', 'E', '0', '\0', /* DB_SRESULTS_COMPARE_STATE0 (19549) */
	'D', 'B', '_', 'S', 'R', 'E', 'S', 'U', 'L', 'T', 'S', '_', 'C', 'O', 'M', 'P', 'A', 'R', 'E', '_', 'S', 'T', 'A', 'T', 'E', '1', '\0', /* DB_SRESULTS_COMPARE_STATE1 (19576) */
	'D', 'B', '_', 'P', 'R', 'E', 'L', 'O', 'A', 'D', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_PRELOAD_CONTROL (19603) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '_', '0', '\0', /* VGT_STRMOUT_BUFFER_SIZE_0 (19622) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'V', 'T', 'X', '_', 'S', 'T', 'R', 'I', 'D', 'E', '_', '0', '\0', /* VGT_STRMOUT_VTX_STRIDE_0 (19648) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '0', '\0', /* VGT_STRMOUT_BUFFER_OFFSET_0 (19673) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '_', '1', '\0', /* VGT_STRMOUT_BUFFER_SIZE_1 (19701) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'V', 'T', 'X', '_', 'S', 'T', 'R', 'I', 'D', 'E', '_', '1', '\0', /* VGT_STRMOUT_VTX_STRIDE_1 (19727) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '\0', /* VGT_STRMOUT_BUFFER_OFFSET_1 (19752) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '_', '2', '\0', /* VGT_STRMOUT_BUFFER_SIZE_2 (19780) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'V', 'T', 'X', '_', 'S', 'T', 'R', 'I', 'D', 'E', '_', '2', '\0', /* VGT_STRMOUT_VTX_STRIDE_2 (19806) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '2', '\0', /* VGT_STRMOUT_BUFFER_OFFSET_2 (19831) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '_', '3', '\0', /* VGT_STRMOUT_BUFFER_SIZE_3 (19859) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'V', 'T', 'X', '_', 'S', 'T', 'R', 'I', 'D', 'E', '_', '3', '\0', /* VGT_STRMOUT_VTX_STRIDE_3 (19885) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '3', '\0', /* VGT_STRMOUT_BUFFER_OFFSET_3 (19910) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'D', 'R', 'A', 'W', '_', 'O', 'P', 'A', 'Q', 'U', 'E', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* VGT_STRMOUT_DRAW_OPAQUE_OFFSET (19938) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'D', 'R', 'A', 'W', '_', 'O', 'P', 'A', 'Q', 'U', 'E', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'F', 'I', 'L', 'L', 'E', 'D', '_', 'S', 'I', 'Z', 'E', '\0', /* VGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE (19969) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'D', 'R', 'A', 'W', '_', 'O', 'P', 'A', 'Q', 'U', 'E', '_', 'V', 'E', 'R', 'T', 'E', 'X', '_', 'S', 'T', 'R', 'I', 'D', 'E', '\0', /* VGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE (20012, 20036, 20043) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'M', 'A', 'X', '_', 'V', 'E', 'R', 'T', '_', 'O', 'U', 'T', '\0', /* VGT_GS_MAX_VERT_OUT (20050, 20057, 20066) */
	'G', 'E', '_', 'N', 'G', 'G', '_', 'S', 'U', 'B', 'G', 'R', 'P', '_', 'C', 'N', 'T', 'L', '\0', /* GE_NGG_SUBGRP_CNTL (20070) */
	'V', 'G', 'T', '_', 'T', 'E', 'S', 'S', '_', 'D', 'I', 'S', 'T', 'R', 'I', 'B', 'U', 'T', 'I', 'O', 'N', '\0', /* VGT_TESS_DISTRIBUTION (20089) */
	'V', 'G', 'T', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'S', 'T', 'A', 'G', 'E', 'S', '_', 'E', 'N', '\0', /* VGT_SHADER_STAGES_EN (20111, 20126) */
	'V', 'G', 'T', '_', 'L', 'S', '_', 'H', 'S', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* VGT_LS_HS_CONFIG (20132) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'V', 'E', 'R', 'T', '_', 'I', 'T', 'E', 'M', 'S', 'I', 'Z', 'E', '\0', /* VGT_GS_VERT_ITEMSIZE (20149) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'V', 'E', 'R', 'T', '_', 'I', 'T', 'E', 'M', 'S', 'I', 'Z', 'E', '_', '1', '\0', /* VGT_GS_VERT_ITEMSIZE_1 (20170) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'V', 'E', 'R', 'T', '_', 'I', 'T', 'E', 'M', 'S', 'I', 'Z', 'E', '_', '2', '\0', /* VGT_GS_VERT_ITEMSIZE_2 (20193) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'V', 'E', 'R', 'T', '_', 'I', 'T', 'E', 'M', 'S', 'I', 'Z', 'E', '_', '3', '\0', /* VGT_GS_VERT_ITEMSIZE_3 (20216) */
	'V', 'G', 'T', '_', 'T', 'F', '_', 'P', 'A', 'R', 'A', 'M', '\0', /* VGT_TF_PARAM (20239) */
	'D', 'B', '_', 'A', 'L', 'P', 'H', 'A', '_', 'T', 'O', '_', 'M', 'A', 'S', 'K', '\0', /* DB_ALPHA_TO_MASK (20252) */
	'V', 'G', 'T', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* VGT_DISPATCH_DRAW_INDEX (20269) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'D', 'B', '_', 'F', 'M', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_POLY_OFFSET_DB_FMT_CNTL (20293) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'C', 'L', 'A', 'M', 'P', '\0', /* PA_SU_POLY_OFFSET_CLAMP (20323) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'F', 'R', 'O', 'N', 'T', '_', 'S', 'C', 'A', 'L', 'E', '\0', /* PA_SU_POLY_OFFSET_FRONT_SCALE (20347) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'F', 'R', 'O', 'N', 'T', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_SU_POLY_OFFSET_FRONT_OFFSET (20377) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'B', 'A', 'C', 'K', '_', 'S', 'C', 'A', 'L', 'E', '\0', /* PA_SU_POLY_OFFSET_BACK_SCALE (20408) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'B', 'A', 'C', 'K', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_SU_POLY_OFFSET_BACK_OFFSET (20437) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', '_', 'C', 'N', 'T', '\0', /* VGT_GS_INSTANCE_CNT (20467, 20483) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* VGT_STRMOUT_CONFIG (20487) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* VGT_STRMOUT_BUFFER_CONFIG (20506) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'E', 'V', 'E', 'N', 'T', '_', 'I', 'N', 'I', 'T', 'I', 'A', 'T', 'O', 'R', '\0', /* VGT_DMA_EVENT_INITIATOR (20532) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'E', 'N', 'T', 'R', 'O', 'I', 'D', '_', 'P', 'R', 'I', 'O', 'R', 'I', 'T', 'Y', '_', '0', '\0', /* PA_SC_CENTROID_PRIORITY_0 (20556) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'E', 'N', 'T', 'R', 'O', 'I', 'D', '_', 'P', 'R', 'I', 'O', 'R', 'I', 'T', 'Y', '_', '1', '\0', /* PA_SC_CENTROID_PRIORITY_1 (20582) */
	'P', 'A', '_', 'S', 'C', '_', 'L', 'I', 'N', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_LINE_CNTL (20608) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* PA_SC_AA_CONFIG (20624) */
	'P', 'A', '_', 'S', 'U', '_', 'V', 'T', 'X', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_VTX_CNTL (20640) */
	'P', 'A', '_', 'C', 'L', '_', 'G', 'B', '_', 'V', 'E', 'R', 'T', '_', 'C', 'L', 'I', 'P', '_', 'A', 'D', 'J', '\0', /* PA_CL_GB_VERT_CLIP_ADJ (20655) */
	'P', 'A', '_', 'C', 'L', '_', 'G', 'B', '_', 'V', 'E', 'R', 'T', '_', 'D', 'I', 'S', 'C', '_', 'A', 'D', 'J', '\0', /* PA_CL_GB_VERT_DISC_ADJ (20678) */
	'P', 'A', '_', 'C', 'L', '_', 'G', 'B', '_', 'H', 'O', 'R', 'Z', '_', 'C', 'L', 'I', 'P', '_', 'A', 'D', 'J', '\0', /* PA_CL_GB_HORZ_CLIP_ADJ (20701) */
	'P', 'A', '_', 'C', 'L', '_', 'G', 'B', '_', 'H', 'O', 'R', 'Z', '_', 'D', 'I', 'S', 'C', '_', 'A', 'D', 'J', '\0', /* PA_CL_GB_HORZ_DISC_ADJ (20724) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '0', '_', '0', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0 (20747) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '0', '_', '1', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_1 (20781) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '0', '_', '2', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_2 (20815) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '0', '_', '3', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_3 (20849) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '0', '_', '0', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0 (20883) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '0', '_', '1', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_1 (20917) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '0', '_', '2', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_2 (20951) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '0', '_', '3', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_3 (20985) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '1', '_', '0', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0 (21019) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '1', '_', '1', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_1 (21053) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '1', '_', '2', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_2 (21087) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '1', '_', '3', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_3 (21121) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '1', '_', '0', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_0 (21155) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '1', '_', '1', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_1 (21189) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '1', '_', '2', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_2 (21223) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '1', '_', '3', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_3 (21257) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'M', 'A', 'S', 'K', '_', 'X', '0', 'Y', '0', '_', 'X', '1', 'Y', '0', '\0', /* PA_SC_AA_MASK_X0Y0_X1Y0 (21291) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'M', 'A', 'S', 'K', '_', 'X', '0', 'Y', '1', '_', 'X', '1', 'Y', '1', '\0', /* PA_SC_AA_MASK_X0Y1_X1Y1 (21315) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* PA_SC_SHADER_CONTROL (21339) */
	'P', 'A', '_', 'S', 'C', '_', 'B', 'I', 'N', 'N', 'E', 'R', '_', 'C', 'N', 'T', 'L', '_', '0', '\0', /* PA_SC_BINNER_CNTL_0 (21360) */
	'P', 'A', '_', 'S', 'C', '_', 'B', 'I', 'N', 'N', 'E', 'R', '_', 'C', 'N', 'T', 'L', '_', '1', '\0', /* PA_SC_BINNER_CNTL_1 (21380) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'O', 'N', 'S', 'E', 'R', 'V', 'A', 'T', 'I', 'V', 'E', '_', 'R', 'A', 'S', 'T', 'E', 'R', 'I', 'Z', 'A', 'T', 'I', 'O', 'N', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_CONSERVATIVE_RASTERIZATION_CNTL (21400) */
	'P', 'A', '_', 'S', 'C', '_', 'N', 'G', 'G', '_', 'M', 'O', 'D', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_NGG_MODE_CNTL (21438) */
	'V', 'G', 'T', '_', 'V', 'E', 'R', 'T', 'E', 'X', '_', 'R', 'E', 'U', 'S', 'E', '_', 'B', 'L', 'O', 'C', 'K', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_VERTEX_REUSE_BLOCK_CNTL (21458) */
	'V', 'G', 'T', '_', 'O', 'U', 'T', '_', 'D', 'E', 'A', 'L', 'L', 'O', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_OUT_DEALLOC_CNTL (21486) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR0_BASE (21507) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR0_PITCH (21522, 21532) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR0_SLICE (21538) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR0_VIEW (21554) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR0_INFO (21569) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR0_ATTRIB (21584) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR0_DCC_CONTROL (21601) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR0_CMASK (21623) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR0_CMASK_SLICE (21639) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR0_FMASK (21661) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR0_FMASK_SLICE (21677) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR0_CLEAR_WORD0 (21699) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR0_CLEAR_WORD1 (21721) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR0_DCC_BASE (21743) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR1_BASE (21762) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR1_PITCH (21777) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR1_SLICE (21793) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR1_VIEW (21809) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR1_INFO (21824) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR1_ATTRIB (21839) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR1_DCC_CONTROL (21856) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR1_CMASK (21878) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR1_CMASK_SLICE (21894) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR1_FMASK (21916) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR1_FMASK_SLICE (21932) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR1_CLEAR_WORD0 (21954) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR1_CLEAR_WORD1 (21976) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR1_DCC_BASE (21998) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR2_BASE (22017) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR2_PITCH (22032) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR2_SLICE (22048) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR2_VIEW (22064) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR2_INFO (22079) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR2_ATTRIB (22094) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR2_DCC_CONTROL (22111) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR2_CMASK (22133) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR2_CMASK_SLICE (22149) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR2_FMASK (22171) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR2_FMASK_SLICE (22187) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR2_CLEAR_WORD0 (22209) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR2_CLEAR_WORD1 (22231) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR2_DCC_BASE (22253) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR3_BASE (22272) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR3_PITCH (22287) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR3_SLICE (22303) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR3_VIEW (22319) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR3_INFO (22334) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR3_ATTRIB (22349) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR3_DCC_CONTROL (22366) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR3_CMASK (22388) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR3_CMASK_SLICE (22404) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR3_FMASK (22426) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR3_FMASK_SLICE (22442) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR3_CLEAR_WORD0 (22464) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR3_CLEAR_WORD1 (22486) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR3_DCC_BASE (22508) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR4_BASE (22527) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR4_PITCH (22542) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR4_SLICE (22558) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR4_VIEW (22574) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR4_INFO (22589) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR4_ATTRIB (22604) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR4_DCC_CONTROL (22621) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR4_CMASK (22643) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR4_CMASK_SLICE (22659) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR4_FMASK (22681) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR4_FMASK_SLICE (22697) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR4_CLEAR_WORD0 (22719) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR4_CLEAR_WORD1 (22741) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR4_DCC_BASE (22763) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR5_BASE (22782) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR5_PITCH (22797) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR5_SLICE (22813) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR5_VIEW (22829) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR5_INFO (22844) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR5_ATTRIB (22859) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR5_DCC_CONTROL (22876) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR5_CMASK (22898) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR5_CMASK_SLICE (22914) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR5_FMASK (22936) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR5_FMASK_SLICE (22952) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR5_CLEAR_WORD0 (22974) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR5_CLEAR_WORD1 (22996) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR5_DCC_BASE (23018) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR6_BASE (23037) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR6_PITCH (23052) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR6_SLICE (23068) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR6_VIEW (23084) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR6_INFO (23099) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR6_ATTRIB (23114) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR6_DCC_CONTROL (23131) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR6_CMASK (23153) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR6_CMASK_SLICE (23169) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR6_FMASK (23191) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR6_FMASK_SLICE (23207) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR6_CLEAR_WORD0 (23229) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR6_CLEAR_WORD1 (23251) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR6_DCC_BASE (23273) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR7_BASE (23292) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR7_PITCH (23307) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR7_SLICE (23323) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR7_VIEW (23339) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR7_INFO (23354) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR7_ATTRIB (23369) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR7_DCC_CONTROL (23386) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR7_CMASK (23408) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR7_CMASK_SLICE (23424) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR7_FMASK (23446) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR7_FMASK_SLICE (23462) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR7_CLEAR_WORD0 (23484) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR7_CLEAR_WORD1 (23506) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR7_DCC_BASE (23528) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR0_BASE_EXT (23547) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR1_BASE_EXT (23566) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR2_BASE_EXT (23585) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR3_BASE_EXT (23604) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR4_BASE_EXT (23623) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR5_BASE_EXT (23642) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR6_BASE_EXT (23661) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR7_BASE_EXT (23680) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR0_CMASK_BASE_EXT (23699) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR1_CMASK_BASE_EXT (23724) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR2_CMASK_BASE_EXT (23749) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR3_CMASK_BASE_EXT (23774) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR4_CMASK_BASE_EXT (23799) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR5_CMASK_BASE_EXT (23824) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR6_CMASK_BASE_EXT (23849) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR7_CMASK_BASE_EXT (23874) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR0_FMASK_BASE_EXT (23899) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR1_FMASK_BASE_EXT (23924) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR2_FMASK_BASE_EXT (23949) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR3_FMASK_BASE_EXT (23974) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR4_FMASK_BASE_EXT (23999) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR5_FMASK_BASE_EXT (24024) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR6_FMASK_BASE_EXT (24049) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR7_FMASK_BASE_EXT (24074) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR0_DCC_BASE_EXT (24099) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR1_DCC_BASE_EXT (24122) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR2_DCC_BASE_EXT (24145) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR3_DCC_BASE_EXT (24168) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR4_DCC_BASE_EXT (24191) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR5_DCC_BASE_EXT (24214) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR6_DCC_BASE_EXT (24237) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR7_DCC_BASE_EXT (24260) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR0_ATTRIB2 (24283) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR1_ATTRIB2 (24301) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR2_ATTRIB2 (24319) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR3_ATTRIB2 (24337) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR4_ATTRIB2 (24355) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR5_ATTRIB2 (24373) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR6_ATTRIB2 (24391) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR7_ATTRIB2 (24409) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR0_ATTRIB3 (24427) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR1_ATTRIB3 (24445) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR2_ATTRIB3 (24463) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR3_ATTRIB3 (24481) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR4_ATTRIB3 (24499) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR5_ATTRIB3 (24517) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR6_ATTRIB3 (24535) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR7_ATTRIB3 (24553) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_EOP_DONE_ADDR_LO (24571) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_EOP_DONE_ADDR_HI (24591) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'D', 'A', 'T', 'A', '_', 'L', 'O', '\0', /* CP_EOP_DONE_DATA_LO (24611) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'D', 'A', 'T', 'A', '_', 'H', 'I', '\0', /* CP_EOP_DONE_DATA_HI (24631) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'L', 'A', 'S', 'T', '_', 'F', 'E', 'N', 'C', 'E', '_', 'L', 'O', '\0', /* CP_EOP_LAST_FENCE_LO (24651) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'L', 'A', 'S', 'T', '_', 'F', 'E', 'N', 'C', 'E', '_', 'H', 'I', '\0', /* CP_EOP_LAST_FENCE_HI (24672) */
	'C', 'P', '_', 'S', 'T', 'R', 'E', 'A', 'M', '_', 'O', 'U', 'T', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_STREAM_OUT_ADDR_LO (24693, 24696) */
	'C', 'P', '_', 'S', 'T', 'R', 'E', 'A', 'M', '_', 'O', 'U', 'T', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_STREAM_OUT_ADDR_HI (24715, 24718) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT0_LO (24737) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT0_HI (24767) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_NEEDED_COUNT0_LO (24797) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_NEEDED_COUNT0_HI (24826) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT1_LO (24855) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT1_HI (24885) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_NEEDED_COUNT1_LO (24915) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_NEEDED_COUNT1_HI (24944) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '2', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT2_LO (24973) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '2', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT2_HI (25003) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '2', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_NEEDED_COUNT2_LO (25033) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '2', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_NEEDED_COUNT2_HI (25062) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '3', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT3_LO (25091) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '3', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT3_HI (25121) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '3', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_NEEDED_COUNT3_LO (25151) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '3', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_NEEDED_COUNT3_HI (25180) */
	'C', 'P', '_', 'P', 'I', 'P', 'E', '_', 'S', 'T', 'A', 'T', 'S', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_PIPE_STATS_ADDR_LO (25209, 25212) */
	'C', 'P', '_', 'P', 'I', 'P', 'E', '_', 'S', 'T', 'A', 'T', 'S', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_PIPE_STATS_ADDR_HI (25231, 25234) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'I', 'A', 'V', 'E', 'R', 'T', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_IAVERT_COUNT_LO (25253) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'I', 'A', 'V', 'E', 'R', 'T', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_IAVERT_COUNT_HI (25276, 25290) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'I', 'A', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_IAPRIM_COUNT_LO (25299) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'I', 'A', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_IAPRIM_COUNT_HI (25322) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'G', 'S', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_GSPRIM_COUNT_LO (25345) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'G', 'S', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_GSPRIM_COUNT_HI (25368) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'V', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_VSINVOC_COUNT_LO (25391) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'V', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_VSINVOC_COUNT_HI (25415) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'G', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_GSINVOC_COUNT_LO (25439) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'G', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_GSINVOC_COUNT_HI (25463) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'H', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_HSINVOC_COUNT_LO (25487) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'H', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_HSINVOC_COUNT_HI (25511) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'D', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_DSINVOC_COUNT_LO (25535) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'D', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_DSINVOC_COUNT_HI (25559) */
	'C', 'P', '_', 'P', 'A', '_', 'C', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_PA_CINVOC_COUNT_LO (25583) */
	'C', 'P', '_', 'P', 'A', '_', 'C', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_PA_CINVOC_COUNT_HI (25605) */
	'C', 'P', '_', 'P', 'A', '_', 'C', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_PA_CPRIM_COUNT_LO (25627) */
	'C', 'P', '_', 'P', 'A', '_', 'C', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_PA_CPRIM_COUNT_HI (25648) */
	'C', 'P', '_', 'S', 'C', '_', 'P', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'L', 'O', '\0', /* CP_SC_PSINVOC_COUNT0_LO (25669) */
	'C', 'P', '_', 'S', 'C', '_', 'P', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'H', 'I', '\0', /* CP_SC_PSINVOC_COUNT0_HI (25693) */
	'C', 'P', '_', 'S', 'C', '_', 'P', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'L', 'O', '\0', /* CP_SC_PSINVOC_COUNT1_LO (25717) */
	'C', 'P', '_', 'S', 'C', '_', 'P', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'H', 'I', '\0', /* CP_SC_PSINVOC_COUNT1_HI (25741) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'C', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_CSINVOC_COUNT_LO (25765) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'C', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_CSINVOC_COUNT_HI (25789) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'D', 'O', 'O', 'R', 'B', 'E', 'L', 'L', '\0', /* CP_EOP_DONE_DOORBELL (25813) */
	'C', 'P', '_', 'S', 'T', 'R', 'E', 'A', 'M', '_', 'O', 'U', 'T', '_', 'D', 'O', 'O', 'R', 'B', 'E', 'L', 'L', '\0', /* CP_STREAM_OUT_DOORBELL (25834) */
	'C', 'P', '_', 'S', 'E', 'M', '_', 'D', 'O', 'O', 'R', 'B', 'E', 'L', 'L', '\0', /* CP_SEM_DOORBELL (25857) */
	'C', 'P', '_', 'P', 'I', 'P', 'E', '_', 'S', 'T', 'A', 'T', 'S', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CP_PIPE_STATS_CONTROL (25873) */
	'C', 'P', '_', 'S', 'T', 'R', 'E', 'A', 'M', '_', 'O', 'U', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CP_STREAM_OUT_CONTROL (25895) */
	'C', 'P', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* CP_STRMOUT_CNTL (25917) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '0', '\0', /* SCRATCH_REG0 (25933) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '1', '\0', /* SCRATCH_REG1 (25946) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '2', '\0', /* SCRATCH_REG2 (25959) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '3', '\0', /* SCRATCH_REG3 (25972) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '4', '\0', /* SCRATCH_REG4 (25985) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '5', '\0', /* SCRATCH_REG5 (25998) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '6', '\0', /* SCRATCH_REG6 (26011) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '7', '\0', /* SCRATCH_REG7 (26024) */
	'C', 'P', '_', 'P', 'I', 'P', 'E', '_', 'S', 'T', 'A', 'T', 'S', '_', 'D', 'O', 'O', 'R', 'B', 'E', 'L', 'L', '\0', /* CP_PIPE_STATS_DOORBELL (26037) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'D', 'D', 'I', 'D', '_', 'C', 'N', 'T', '\0', /* CP_APPEND_DDID_CNT (26060) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'D', 'A', 'T', 'A', '_', 'H', 'I', '\0', /* CP_APPEND_DATA_HI (26079) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'L', 'A', 'S', 'T', '_', 'C', 'S', '_', 'F', 'E', 'N', 'C', 'E', '_', 'H', 'I', '\0', /* CP_APPEND_LAST_CS_FENCE_HI (26097) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'L', 'A', 'S', 'T', '_', 'P', 'S', '_', 'F', 'E', 'N', 'C', 'E', '_', 'H', 'I', '\0', /* CP_APPEND_LAST_PS_FENCE_HI (26124) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'U', 'M', 'S', 'K', '\0', /* SCRATCH_UMSK (26151) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'A', 'D', 'D', 'R', '\0', /* SCRATCH_ADDR (26164) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'A', 'T', 'O', 'M', 'I', 'C', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_PFP_ATOMIC_PREOP_LO (26177) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'A', 'T', 'O', 'M', 'I', 'C', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_PFP_ATOMIC_PREOP_HI (26200) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '0', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_PFP_GDS_ATOMIC0_PREOP_LO (26223) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '0', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_PFP_GDS_ATOMIC0_PREOP_HI (26251) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '1', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_PFP_GDS_ATOMIC1_PREOP_LO (26279) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '1', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_PFP_GDS_ATOMIC1_PREOP_HI (26307) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_APPEND_ADDR_LO (26335) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_APPEND_ADDR_HI (26353) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* CP_APPEND_DATA (26371) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'L', 'A', 'S', 'T', '_', 'C', 'S', '_', 'F', 'E', 'N', 'C', 'E', '\0', /* CP_APPEND_LAST_CS_FENCE (26386) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'L', 'A', 'S', 'T', '_', 'P', 'S', '_', 'F', 'E', 'N', 'C', 'E', '\0', /* CP_APPEND_LAST_PS_FENCE (26410) */
	'C', 'P', '_', 'A', 'T', 'O', 'M', 'I', 'C', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_ATOMIC_PREOP_LO (26434) */
	'C', 'P', '_', 'A', 'T', 'O', 'M', 'I', 'C', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_ATOMIC_PREOP_HI (26453) */
	'C', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '0', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_GDS_ATOMIC0_PREOP_LO (26472) */
	'C', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '0', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_GDS_ATOMIC0_PREOP_HI (26496) */
	'C', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '1', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_GDS_ATOMIC1_PREOP_LO (26520) */
	'C', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '1', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_GDS_ATOMIC1_PREOP_HI (26544) */
	'C', 'P', '_', 'M', 'E', '_', 'M', 'C', '_', 'W', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_ME_MC_WADDR_LO (26568, 26571) */
	'C', 'P', '_', 'M', 'E', '_', 'M', 'C', '_', 'W', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_ME_MC_WADDR_HI (26586, 26589) */
	'C', 'P', '_', 'M', 'E', '_', 'M', 'C', '_', 'W', 'D', 'A', 'T', 'A', '_', 'L', 'O', '\0', /* CP_ME_MC_WDATA_LO (26604) */
	'C', 'P', '_', 'M', 'E', '_', 'M', 'C', '_', 'W', 'D', 'A', 'T', 'A', '_', 'H', 'I', '\0', /* CP_ME_MC_WDATA_HI (26622) */
	'C', 'P', '_', 'M', 'E', '_', 'M', 'C', '_', 'R', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_ME_MC_RADDR_LO (26640, 26643) */
	'C', 'P', '_', 'M', 'E', '_', 'M', 'C', '_', 'R', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_ME_MC_RADDR_HI (26658, 26661) */
	'C', 'P', '_', 'S', 'E', 'M', '_', 'W', 'A', 'I', 'T', '_', 'T', 'I', 'M', 'E', 'R', '\0', /* CP_SEM_WAIT_TIMER (26676) */
	'C', 'P', '_', 'S', 'I', 'G', '_', 'S', 'E', 'M', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_SIG_SEM_ADDR_LO (26694, 26701) */
	'C', 'P', '_', 'S', 'I', 'G', '_', 'S', 'E', 'M', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_SIG_SEM_ADDR_HI (26713, 26720) */
	'C', 'P', '_', 'W', 'A', 'I', 'T', '_', 'R', 'E', 'G', '_', 'M', 'E', 'M', '_', 'T', 'I', 'M', 'E', 'O', 'U', 'T', '\0', /* CP_WAIT_REG_MEM_TIMEOUT (26732) */
	'C', 'P', '_', 'W', 'A', 'I', 'T', '_', 'S', 'E', 'M', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_WAIT_SEM_ADDR_LO (26756) */
	'C', 'P', '_', 'W', 'A', 'I', 'T', '_', 'S', 'E', 'M', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_WAIT_SEM_ADDR_HI (26776) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CP_DMA_PFP_CONTROL (26796) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CP_DMA_ME_CONTROL (26815) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_COHER_BASE_HI (26833) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'T', 'A', 'R', 'T', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* CP_COHER_START_DELAY (26850) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* CP_COHER_CNTL (26871) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '\0', /* CP_COHER_SIZE (26885) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'B', 'A', 'S', 'E', '\0', /* CP_COHER_BASE (26899) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_COHER_STATUS (26913) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'S', 'R', 'C', '_', 'A', 'D', 'D', 'R', '\0', /* CP_DMA_ME_SRC_ADDR (26929, 26939) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'S', 'R', 'C', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DMA_ME_SRC_ADDR_HI (26948, 26958) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'D', 'S', 'T', '_', 'A', 'D', 'D', 'R', '\0', /* CP_DMA_ME_DST_ADDR (26970, 26980) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'D', 'S', 'T', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DMA_ME_DST_ADDR_HI (26989, 26999) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'C', 'O', 'M', 'M', 'A', 'N', 'D', '\0', /* CP_DMA_ME_COMMAND (27011, 27021) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'S', 'R', 'C', '_', 'A', 'D', 'D', 'R', '\0', /* CP_DMA_PFP_SRC_ADDR (27029) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'S', 'R', 'C', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DMA_PFP_SRC_ADDR_HI (27049) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'D', 'S', 'T', '_', 'A', 'D', 'D', 'R', '\0', /* CP_DMA_PFP_DST_ADDR (27072) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'D', 'S', 'T', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DMA_PFP_DST_ADDR_HI (27092) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'C', 'O', 'M', 'M', 'A', 'N', 'D', '\0', /* CP_DMA_PFP_COMMAND (27115) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'C', 'N', 'T', 'L', '\0', /* CP_DMA_CNTL (27134) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'R', 'E', 'A', 'D', '_', 'T', 'A', 'G', 'S', '\0', /* CP_DMA_READ_TAGS (27146) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '_', 'H', 'I', '\0', /* CP_COHER_SIZE_HI (27163) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'I', 'B', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CP_PFP_IB_CONTROL (27180, 27187) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'L', 'O', 'A', 'D', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CP_PFP_LOAD_CONTROL (27198) */
	'C', 'P', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* CP_SCRATCH_INDEX (27218) */
	'C', 'P', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'D', 'A', 'T', 'A', '\0', /* CP_SCRATCH_DATA (27235) */
	'C', 'P', '_', 'R', 'B', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* CP_RB_OFFSET (27251, 27254) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* CP_IB1_OFFSET (27264, 27267) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* CP_IB2_OFFSET (27278, 27281) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'P', 'R', 'E', 'A', 'M', 'B', 'L', 'E', '_', 'B', 'E', 'G', 'I', 'N', '\0', /* CP_IB1_PREAMBLE_BEGIN (27292, 27295) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'P', 'R', 'E', 'A', 'M', 'B', 'L', 'E', '_', 'E', 'N', 'D', '\0', /* CP_IB1_PREAMBLE_END (27314, 27317) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'P', 'R', 'E', 'A', 'M', 'B', 'L', 'E', '_', 'B', 'E', 'G', 'I', 'N', '\0', /* CP_IB2_PREAMBLE_BEGIN (27334, 27337) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'P', 'R', 'E', 'A', 'M', 'B', 'L', 'E', '_', 'E', 'N', 'D', '\0', /* CP_IB2_PREAMBLE_END (27356, 27359) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '1', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* CP_CE_IB1_OFFSET (27376) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '2', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* CP_CE_IB2_OFFSET (27393) */
	'C', 'P', '_', 'C', 'E', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '\0', /* CP_CE_COUNTER (27410) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'C', 'M', 'D', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_DMA_ME_CMD_ADDR_LO (27424) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'C', 'M', 'D', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DMA_ME_CMD_ADDR_HI (27446) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'C', 'M', 'D', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_DMA_PFP_CMD_ADDR_LO (27468) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'C', 'M', 'D', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DMA_PFP_CMD_ADDR_HI (27491) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'C', 'M', 'D', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_APPEND_CMD_ADDR_LO (27514) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'C', 'M', 'D', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_APPEND_CMD_ADDR_HI (27536) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'N', 'I', 'T', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_INIT_CMD_BUFSZ (27558) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '1', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_IB1_CMD_BUFSZ (27579) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '2', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_IB2_CMD_BUFSZ (27599) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_IB1_CMD_BUFSZ (27619) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_IB2_CMD_BUFSZ (27636) */
	'C', 'P', '_', 'S', 'T', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_ST_CMD_BUFSZ (27653) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'N', 'I', 'T', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_CE_INIT_BASE_LO (27669, 27675) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'N', 'I', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_CE_INIT_BASE_HI (27688, 27694) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'N', 'I', 'T', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_INIT_BUFSZ (27707, 27713) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '1', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_CE_IB1_BASE_LO (27724, 27730) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '1', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_CE_IB1_BASE_HI (27742, 27748) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '1', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_IB1_BUFSZ (27760, 27766) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '2', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_CE_IB2_BASE_LO (27776, 27782) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '2', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_CE_IB2_BASE_HI (27794, 27800) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '2', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_IB2_BUFSZ (27812, 27818) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_IB1_BASE_LO (27828) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_IB1_BASE_HI (27843) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_IB1_BUFSZ (27858) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_IB2_BASE_LO (27871) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_IB2_BASE_HI (27886) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_IB2_BUFSZ (27901) */
	'C', 'P', '_', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_ST_BASE_LO (27914, 27917) */
	'C', 'P', '_', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_ST_BASE_HI (27928, 27931) */
	'C', 'P', '_', 'S', 'T', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_ST_BUFSZ (27942, 27945) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'E', 'V', 'E', 'N', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* CP_EOP_DONE_EVENT_CNTL (27954) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'D', 'A', 'T', 'A', '_', 'C', 'N', 'T', 'L', '\0', /* CP_EOP_DONE_DATA_CNTL (27977) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'C', 'N', 'T', 'X', '_', 'I', 'D', '\0', /* CP_EOP_DONE_CNTX_ID (27999, 28011) */
	'C', 'P', '_', 'D', 'B', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_DB_BASE_LO (28019, 28022) */
	'C', 'P', '_', 'D', 'B', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_DB_BASE_HI (28033, 28036) */
	'C', 'P', '_', 'D', 'B', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_DB_BUFSZ (28047, 28050) */
	'C', 'P', '_', 'D', 'B', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_DB_CMD_BUFSZ (28059) */
	'C', 'P', '_', 'C', 'E', '_', 'D', 'B', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_CE_DB_BASE_LO (28075) */
	'C', 'P', '_', 'C', 'E', '_', 'D', 'B', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_CE_DB_BASE_HI (28092) */
	'C', 'P', '_', 'C', 'E', '_', 'D', 'B', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_DB_BUFSZ (28109) */
	'C', 'P', '_', 'C', 'E', '_', 'D', 'B', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_DB_CMD_BUFSZ (28124) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'C', 'O', 'M', 'P', 'L', 'E', 'T', 'I', 'O', 'N', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_PFP_COMPLETION_STATUS (28143) */
	'C', 'P', '_', 'C', 'E', '_', 'C', 'O', 'M', 'P', 'L', 'E', 'T', 'I', 'O', 'N', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_CE_COMPLETION_STATUS (28168) */
	'C', 'P', '_', 'P', 'R', 'E', 'D', '_', 'N', 'O', 'T', '_', 'V', 'I', 'S', 'I', 'B', 'L', 'E', '\0', /* CP_PRED_NOT_VISIBLE (28192, 28200) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'M', 'E', 'T', 'A', 'D', 'A', 'T', 'A', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '\0', /* CP_PFP_METADATA_BASE_ADDR (28212) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'M', 'E', 'T', 'A', 'D', 'A', 'T', 'A', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_PFP_METADATA_BASE_ADDR_HI (28238) */
	'C', 'P', '_', 'C', 'E', '_', 'M', 'E', 'T', 'A', 'D', 'A', 'T', 'A', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '\0', /* CP_CE_METADATA_BASE_ADDR (28267) */
	'C', 'P', '_', 'C', 'E', '_', 'M', 'E', 'T', 'A', 'D', 'A', 'T', 'A', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_CE_METADATA_BASE_ADDR_HI (28292) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'X', '_', 'I', 'N', 'D', 'R', '_', 'A', 'D', 'D', 'R', '\0', /* CP_DRAW_INDX_INDR_ADDR (28320) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'X', '_', 'I', 'N', 'D', 'R', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DRAW_INDX_INDR_ADDR_HI (28343) */
	'C', 'P', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'D', 'R', '_', 'A', 'D', 'D', 'R', '\0', /* CP_DISPATCH_INDR_ADDR (28369) */
	'C', 'P', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'D', 'R', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DISPATCH_INDR_ADDR_HI (28391) */
	'C', 'P', '_', 'I', 'N', 'D', 'E', 'X', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '\0', /* CP_INDEX_BASE_ADDR (28416) */
	'C', 'P', '_', 'I', 'N', 'D', 'E', 'X', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_INDEX_BASE_ADDR_HI (28435) */
	'C', 'P', '_', 'I', 'N', 'D', 'E', 'X', '_', 'T', 'Y', 'P', 'E', '\0', /* CP_INDEX_TYPE (28457) */
	'C', 'P', '_', 'G', 'D', 'S', '_', 'B', 'K', 'U', 'P', '_', 'A', 'D', 'D', 'R', '\0', /* CP_GDS_BKUP_ADDR (28471) */
	'C', 'P', '_', 'G', 'D', 'S', '_', 'B', 'K', 'U', 'P', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_GDS_BKUP_ADDR_HI (28488) */
	'C', 'P', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_SAMPLE_STATUS (28508) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'O', 'H', 'E', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* CP_ME_COHER_CNTL (28525) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '\0', /* CP_ME_COHER_SIZE (28542) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '_', 'H', 'I', '\0', /* CP_ME_COHER_SIZE_HI (28559) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'O', 'H', 'E', 'R', '_', 'B', 'A', 'S', 'E', '\0', /* CP_ME_COHER_BASE (28579) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'O', 'H', 'E', 'R', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_ME_COHER_BASE_HI (28596) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_ME_COHER_STATUS (28616) */
	'R', 'L', 'C', '_', 'G', 'P', 'M', '_', 'P', 'E', 'R', 'F', '_', 'C', 'O', 'U', 'N', 'T', '_', '0', '\0', /* RLC_GPM_PERF_COUNT_0 (28635) */
	'R', 'L', 'C', '_', 'G', 'P', 'M', '_', 'P', 'E', 'R', 'F', '_', 'C', 'O', 'U', 'N', 'T', '_', '1', '\0', /* RLC_GPM_PERF_COUNT_1 (28656) */
	'G', 'R', 'B', 'M', '_', 'G', 'F', 'X', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* GRBM_GFX_INDEX (28677) */
	'V', 'G', 'T', '_', 'E', 'S', 'G', 'S', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* VGT_ESGS_RING_SIZE (28692) */
	'V', 'G', 'T', '_', 'G', 'S', 'V', 'S', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* VGT_GSVS_RING_SIZE (28711) */
	'V', 'G', 'T', '_', 'P', 'R', 'I', 'M', 'I', 'T', 'I', 'V', 'E', '_', 'T', 'Y', 'P', 'E', '\0', /* VGT_PRIMITIVE_TYPE (28730) */
	'V', 'G', 'T', '_', 'I', 'N', 'D', 'E', 'X', '_', 'T', 'Y', 'P', 'E', '\0', /* VGT_INDEX_TYPE (28749) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'F', 'I', 'L', 'L', 'E', 'D', '_', 'S', 'I', 'Z', 'E', '_', '0', '\0', /* VGT_STRMOUT_BUFFER_FILLED_SIZE_0 (28764) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'F', 'I', 'L', 'L', 'E', 'D', '_', 'S', 'I', 'Z', 'E', '_', '1', '\0', /* VGT_STRMOUT_BUFFER_FILLED_SIZE_1 (28797) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'F', 'I', 'L', 'L', 'E', 'D', '_', 'S', 'I', 'Z', 'E', '_', '2', '\0', /* VGT_STRMOUT_BUFFER_FILLED_SIZE_2 (28830) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'F', 'I', 'L', 'L', 'E', 'D', '_', 'S', 'I', 'Z', 'E', '_', '3', '\0', /* VGT_STRMOUT_BUFFER_FILLED_SIZE_3 (28863) */
	'G', 'E', '_', 'M', 'I', 'N', '_', 'V', 'T', 'X', '_', 'I', 'N', 'D', 'X', '\0', /* GE_MIN_VTX_INDX (28896) */
	'G', 'E', '_', 'I', 'N', 'D', 'X', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* GE_INDX_OFFSET (28912) */
	'G', 'E', '_', 'M', 'U', 'L', 'T', 'I', '_', 'P', 'R', 'I', 'M', '_', 'I', 'B', '_', 'R', 'E', 'S', 'E', 'T', '_', 'E', 'N', '\0', /* GE_MULTI_PRIM_IB_RESET_EN (28927) */
	'V', 'G', 'T', '_', 'N', 'U', 'M', '_', 'I', 'N', 'D', 'I', 'C', 'E', 'S', '\0', /* VGT_NUM_INDICES (28953) */
	'V', 'G', 'T', '_', 'N', 'U', 'M', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', 'S', '\0', /* VGT_NUM_INSTANCES (28969) */
	'V', 'G', 'T', '_', 'T', 'F', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* VGT_TF_RING_SIZE (28987) */
	'V', 'G', 'T', '_', 'H', 'S', '_', 'O', 'F', 'F', 'C', 'H', 'I', 'P', '_', 'P', 'A', 'R', 'A', 'M', '\0', /* VGT_HS_OFFCHIP_PARAM (29004) */
	'V', 'G', 'T', '_', 'T', 'F', '_', 'M', 'E', 'M', 'O', 'R', 'Y', '_', 'B', 'A', 'S', 'E', '\0', /* VGT_TF_MEMORY_BASE (29025) */
	'G', 'E', '_', 'D', 'M', 'A', '_', 'F', 'I', 'R', 'S', 'T', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* GE_DMA_FIRST_INDEX (29044) */
	'W', 'D', '_', 'P', 'O', 'S', '_', 'B', 'U', 'F', '_', 'B', 'A', 'S', 'E', '\0', /* WD_POS_BUF_BASE (29063) */
	'W', 'D', '_', 'P', 'O', 'S', '_', 'B', 'U', 'F', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* WD_POS_BUF_BASE_HI (29079) */
	'W', 'D', '_', 'C', 'N', 'T', 'L', '_', 'S', 'B', '_', 'B', 'U', 'F', '_', 'B', 'A', 'S', 'E', '\0', /* WD_CNTL_SB_BUF_BASE (29098) */
	'W', 'D', '_', 'C', 'N', 'T', 'L', '_', 'S', 'B', '_', 'B', 'U', 'F', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* WD_CNTL_SB_BUF_BASE_HI (29118) */
	'W', 'D', '_', 'I', 'N', 'D', 'E', 'X', '_', 'B', 'U', 'F', '_', 'B', 'A', 'S', 'E', '\0', /* WD_INDEX_BUF_BASE (29141) */
	'W', 'D', '_', 'I', 'N', 'D', 'E', 'X', '_', 'B', 'U', 'F', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* WD_INDEX_BUF_BASE_HI (29159) */
	'I', 'A', '_', 'M', 'U', 'L', 'T', 'I', '_', 'V', 'G', 'T', '_', 'P', 'A', 'R', 'A', 'M', '_', 'P', 'I', 'P', 'E', 'D', '\0', /* IA_MULTI_VGT_PARAM_PIPED (29180) */
	'G', 'E', '_', 'M', 'A', 'X', '_', 'V', 'T', 'X', '_', 'I', 'N', 'D', 'X', '\0', /* GE_MAX_VTX_INDX (29205) */
	'V', 'G', 'T', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', '_', 'B', 'A', 'S', 'E', '_', 'I', 'D', '\0', /* VGT_INSTANCE_BASE_ID (29221, 29236) */
	'G', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* GE_CNTL (29242) */
	'G', 'E', '_', 'U', 'S', 'E', 'R', '_', 'V', 'G', 'P', 'R', '1', '\0', /* GE_USER_VGPR1 (29250) */
	'G', 'E', '_', 'U', 'S', 'E', 'R', '_', 'V', 'G', 'P', 'R', '2', '\0', /* GE_USER_VGPR2 (29264) */
	'G', 'E', '_', 'U', 'S', 'E', 'R', '_', 'V', 'G', 'P', 'R', '3', '\0', /* GE_USER_VGPR3 (29278) */
	'G', 'E', '_', 'S', 'T', 'E', 'R', 'E', 'O', '_', 'C', 'N', 'T', 'L', '\0', /* GE_STEREO_CNTL (29292) */
	'G', 'E', '_', 'P', 'C', '_', 'A', 'L', 'L', 'O', 'C', '\0', /* GE_PC_ALLOC (29307) */
	'V', 'G', 'T', '_', 'T', 'F', '_', 'M', 'E', 'M', 'O', 'R', 'Y', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* VGT_TF_MEMORY_BASE_HI (29319) */
	'G', 'E', '_', 'U', 'S', 'E', 'R', '_', 'V', 'G', 'P', 'R', '_', 'E', 'N', '\0', /* GE_USER_VGPR_EN (29341) */
	'P', 'A', '_', 'S', 'U', '_', 'L', 'I', 'N', 'E', '_', 'S', 'T', 'I', 'P', 'P', 'L', 'E', '_', 'V', 'A', 'L', 'U', 'E', '\0', /* PA_SU_LINE_STIPPLE_VALUE (29357, 29363, 29376) */
	'P', 'A', '_', 'S', 'C', '_', 'L', 'I', 'N', 'E', '_', 'S', 'T', 'I', 'P', 'P', 'L', 'E', '_', 'S', 'T', 'A', 'T', 'E', '\0', /* PA_SC_LINE_STIPPLE_STATE (29382) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'E', 'X', 'T', 'E', 'N', 'T', '_', 'M', 'I', 'N', '_', '0', '\0', /* PA_SC_SCREEN_EXTENT_MIN_0 (29407) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'E', 'X', 'T', 'E', 'N', 'T', '_', 'M', 'A', 'X', '_', '0', '\0', /* PA_SC_SCREEN_EXTENT_MAX_0 (29433) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'E', 'X', 'T', 'E', 'N', 'T', '_', 'M', 'I', 'N', '_', '1', '\0', /* PA_SC_SCREEN_EXTENT_MIN_1 (29459) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'E', 'X', 'T', 'E', 'N', 'T', '_', 'M', 'A', 'X', '_', '1', '\0', /* PA_SC_SCREEN_EXTENT_MAX_1 (29485) */
	'P', 'A', '_', 'S', 'C', '_', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'H', 'V', '_', 'E', 'N', '\0', /* PA_SC_P3D_TRAP_SCREEN_HV_EN (29511) */
	'P', 'A', '_', 'S', 'C', '_', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'H', '\0', /* PA_SC_P3D_TRAP_SCREEN_H (29539) */
	'P', 'A', '_', 'S', 'C', '_', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'V', '\0', /* PA_SC_P3D_TRAP_SCREEN_V (29563) */
	'P', 'A', '_', 'S', 'C', '_', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'O', 'C', 'C', 'U', 'R', 'R', 'E', 'N', 'C', 'E', '\0', /* PA_SC_P3D_TRAP_SCREEN_OCCURRENCE (29587) */
	'P', 'A', '_', 'S', 'C', '_', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* PA_SC_P3D_TRAP_SCREEN_COUNT (29620) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'H', 'V', '_', 'E', 'N', '\0', /* PA_SC_HP3D_TRAP_SCREEN_HV_EN (29648) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'H', '\0', /* PA_SC_HP3D_TRAP_SCREEN_H (29677) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'V', '\0', /* PA_SC_HP3D_TRAP_SCREEN_V (29702) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'O', 'C', 'C', 'U', 'R', 'R', 'E', 'N', 'C', 'E', '\0', /* PA_SC_HP3D_TRAP_SCREEN_OCCURRENCE (29727) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* PA_SC_HP3D_TRAP_SCREEN_COUNT (29761) */
	'P', 'A', '_', 'S', 'C', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'H', 'V', '_', 'E', 'N', '\0', /* PA_SC_TRAP_SCREEN_HV_EN (29790) */
	'P', 'A', '_', 'S', 'C', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'H', '\0', /* PA_SC_TRAP_SCREEN_H (29814) */
	'P', 'A', '_', 'S', 'C', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'V', '\0', /* PA_SC_TRAP_SCREEN_V (29834) */
	'P', 'A', '_', 'S', 'C', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'O', 'C', 'C', 'U', 'R', 'R', 'E', 'N', 'C', 'E', '\0', /* PA_SC_TRAP_SCREEN_OCCURRENCE (29854) */
	'P', 'A', '_', 'S', 'C', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* PA_SC_TRAP_SCREEN_COUNT (29883) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '0', '\0', /* SQ_THREAD_TRACE_USERDATA_0 (29907) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '1', '\0', /* SQ_THREAD_TRACE_USERDATA_1 (29934) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '2', '\0', /* SQ_THREAD_TRACE_USERDATA_2 (29961) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '3', '\0', /* SQ_THREAD_TRACE_USERDATA_3 (29988) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '4', '\0', /* SQ_THREAD_TRACE_USERDATA_4 (30015) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '5', '\0', /* SQ_THREAD_TRACE_USERDATA_5 (30042) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '6', '\0', /* SQ_THREAD_TRACE_USERDATA_6 (30069) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '7', '\0', /* SQ_THREAD_TRACE_USERDATA_7 (30096) */
	'S', 'Q', 'C', '_', 'C', 'A', 'C', 'H', 'E', 'S', '\0', /* SQC_CACHES (30123) */
	'S', 'Q', 'C', '_', 'W', 'R', 'I', 'T', 'E', 'B', 'A', 'C', 'K', '\0', /* SQC_WRITEBACK (30134, 30138) */
	'T', 'A', '_', 'C', 'S', '_', 'B', 'C', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '\0', /* TA_CS_BC_BASE_ADDR (30148) */
	'T', 'A', '_', 'C', 'S', '_', 'B', 'C', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* TA_CS_BC_BASE_ADDR_HI (30167) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'L', 'O', 'W', '\0', /* DB_OCCLUSION_COUNT0_LOW (30189) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'H', 'I', '\0', /* DB_OCCLUSION_COUNT0_HI (30213) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'L', 'O', 'W', '\0', /* DB_OCCLUSION_COUNT1_LOW (30236) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'H', 'I', '\0', /* DB_OCCLUSION_COUNT1_HI (30260) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '2', '_', 'L', 'O', 'W', '\0', /* DB_OCCLUSION_COUNT2_LOW (30283) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '2', '_', 'H', 'I', '\0', /* DB_OCCLUSION_COUNT2_HI (30307) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '3', '_', 'L', 'O', 'W', '\0', /* DB_OCCLUSION_COUNT3_LOW (30330) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '3', '_', 'H', 'I', '\0', /* DB_OCCLUSION_COUNT3_HI (30354) */
	'D', 'B', '_', 'Z', 'P', 'A', 'S', 'S', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', 'W', '\0', /* DB_ZPASS_COUNT_LOW (30377) */
	'D', 'B', '_', 'Z', 'P', 'A', 'S', 'S', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* DB_ZPASS_COUNT_HI (30396) */
	'G', 'D', 'S', '_', 'R', 'D', '_', 'A', 'D', 'D', 'R', '\0', /* GDS_RD_ADDR (30414) */
	'G', 'D', 'S', '_', 'R', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* GDS_RD_DATA (30426) */
	'G', 'D', 'S', '_', 'R', 'D', '_', 'B', 'U', 'R', 'S', 'T', '_', 'A', 'D', 'D', 'R', '\0', /* GDS_RD_BURST_ADDR (30438) */
	'G', 'D', 'S', '_', 'R', 'D', '_', 'B', 'U', 'R', 'S', 'T', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* GDS_RD_BURST_COUNT (30456) */
	'G', 'D', 'S', '_', 'R', 'D', '_', 'B', 'U', 'R', 'S', 'T', '_', 'D', 'A', 'T', 'A', '\0', /* GDS_RD_BURST_DATA (30475) */
	'G', 'D', 'S', '_', 'W', 'R', '_', 'A', 'D', 'D', 'R', '\0', /* GDS_WR_ADDR (30493) */
	'G', 'D', 'S', '_', 'W', 'R', '_', 'D', 'A', 'T', 'A', '\0', /* GDS_WR_DATA (30505) */
	'G', 'D', 'S', '_', 'W', 'R', '_', 'B', 'U', 'R', 'S', 'T', '_', 'A', 'D', 'D', 'R', '\0', /* GDS_WR_BURST_ADDR (30517) */
	'G', 'D', 'S', '_', 'W', 'R', '_', 'B', 'U', 'R', 'S', 'T', '_', 'D', 'A', 'T', 'A', '\0', /* GDS_WR_BURST_DATA (30535) */
	'G', 'D', 'S', '_', 'W', 'R', 'I', 'T', 'E', '_', 'C', 'O', 'M', 'P', 'L', 'E', 'T', 'E', '\0', /* GDS_WRITE_COMPLETE (30553, 30563) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'C', 'N', 'T', 'L', '\0', /* GDS_ATOM_CNTL (30572) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'C', 'O', 'M', 'P', 'L', 'E', 'T', 'E', '\0', /* GDS_ATOM_COMPLETE (30586) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'B', 'A', 'S', 'E', '\0', /* GDS_ATOM_BASE (30604) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'S', 'I', 'Z', 'E', '\0', /* GDS_ATOM_SIZE (30618) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'O', 'F', 'F', 'S', 'E', 'T', '0', '\0', /* GDS_ATOM_OFFSET0 (30632, 30641) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'O', 'F', 'F', 'S', 'E', 'T', '1', '\0', /* GDS_ATOM_OFFSET1 (30649, 30658) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'D', 'S', 'T', '\0', /* GDS_ATOM_DST (30666, 30675) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'O', 'P', '\0', /* GDS_ATOM_OP (30679) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'S', 'R', 'C', '0', '\0', /* GDS_ATOM_SRC0 (30691, 30700) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'S', 'R', 'C', '0', '_', 'U', '\0', /* GDS_ATOM_SRC0_U (30705) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'S', 'R', 'C', '1', '\0', /* GDS_ATOM_SRC1 (30721) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'S', 'R', 'C', '1', '_', 'U', '\0', /* GDS_ATOM_SRC1_U (30735) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'R', 'E', 'A', 'D', '0', '\0', /* GDS_ATOM_READ0 (30751) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'R', 'E', 'A', 'D', '0', '_', 'U', '\0', /* GDS_ATOM_READ0_U (30766) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'R', 'E', 'A', 'D', '1', '\0', /* GDS_ATOM_READ1 (30783) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'R', 'E', 'A', 'D', '1', '_', 'U', '\0', /* GDS_ATOM_READ1_U (30798) */
	'G', 'D', 'S', '_', 'G', 'W', 'S', '_', 'R', 'E', 'S', 'O', 'U', 'R', 'C', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* GDS_GWS_RESOURCE_CNTL (30815) */
	'G', 'D', 'S', '_', 'G', 'W', 'S', '_', 'R', 'E', 'S', 'O', 'U', 'R', 'C', 'E', '\0', /* GDS_GWS_RESOURCE (30837, 30847) */
	'G', 'D', 'S', '_', 'G', 'W', 'S', '_', 'R', 'E', 'S', 'O', 'U', 'R', 'C', 'E', '_', 'C', 'N', 'T', '\0', /* GDS_GWS_RESOURCE_CNT (30854, 30862) */
	'G', 'D', 'S', '_', 'O', 'A', '_', 'C', 'N', 'T', 'L', '\0', /* GDS_OA_CNTL (30875) */
	'G', 'D', 'S', '_', 'O', 'A', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '\0', /* GDS_OA_COUNTER (30887) */
	'G', 'D', 'S', '_', 'O', 'A', '_', 'A', 'D', 'D', 'R', 'E', 'S', 'S', '\0', /* GDS_OA_ADDRESS (30902, 30909) */
	'G', 'D', 'S', '_', 'O', 'A', '_', 'I', 'N', 'C', 'D', 'E', 'C', '\0', /* GDS_OA_INCDEC (30917, 30924) */
	'G', 'D', 'S', '_', 'O', 'A', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* GDS_OA_RING_SIZE (30931) */
	'S', 'P', 'I', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'C', 'N', 'T', 'L', '_', 'R', 'E', 'M', 'A', 'P', '\0', /* SPI_CONFIG_CNTL_REMAP (30948) */
	'S', 'P', 'I', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'C', 'N', 'T', 'L', '_', '1', '_', 'R', 'E', 'M', 'A', 'P', '\0', /* SPI_CONFIG_CNTL_1_REMAP (30970) */
	'S', 'P', 'I', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'C', 'N', 'T', 'L', '_', '2', '_', 'R', 'E', 'M', 'A', 'P', '\0', /* SPI_CONFIG_CNTL_2_REMAP (30994) */
	'S', 'P', 'I', '_', 'W', 'A', 'V', 'E', '_', 'L', 'I', 'M', 'I', 'T', '_', 'C', 'N', 'T', 'L', '_', 'R', 'E', 'M', 'A', 'P', '\0', /* SPI_WAVE_LIMIT_CNTL_REMAP (31018) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CPG_PERFCOUNTER1_LO (31044) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CPG_PERFCOUNTER1_HI (31064) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CPG_PERFCOUNTER0_LO (31084) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CPG_PERFCOUNTER0_HI (31104) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CPC_PERFCOUNTER1_LO (31124, 31125) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CPC_PERFCOUNTER1_HI (31144, 31145) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CPC_PERFCOUNTER0_LO (31164, 31165) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CPC_PERFCOUNTER0_HI (31184, 31185) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CPF_PERFCOUNTER1_LO (31204) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CPF_PERFCOUNTER1_HI (31224) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CPF_PERFCOUNTER0_LO (31244) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CPF_PERFCOUNTER0_HI (31264) */
	'C', 'P', 'F', '_', 'L', 'A', 'T', 'E', 'N', 'C', 'Y', '_', 'S', 'T', 'A', 'T', 'S', '_', 'D', 'A', 'T', 'A', '\0', /* CPF_LATENCY_STATS_DATA (31284) */
	'C', 'P', 'G', '_', 'L', 'A', 'T', 'E', 'N', 'C', 'Y', '_', 'S', 'T', 'A', 'T', 'S', '_', 'D', 'A', 'T', 'A', '\0', /* CPG_LATENCY_STATS_DATA (31307) */
	'C', 'P', 'C', '_', 'L', 'A', 'T', 'E', 'N', 'C', 'Y', '_', 'S', 'T', 'A', 'T', 'S', '_', 'D', 'A', 'T', 'A', '\0', /* CPC_LATENCY_STATS_DATA (31330) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GRBM_PERFCOUNTER0_LO (31353) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GRBM_PERFCOUNTER0_HI (31374) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GRBM_PERFCOUNTER1_LO (31395) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GRBM_PERFCOUNTER1_HI (31416) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GRBM_SE0_PERFCOUNTER_LO (31437) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GRBM_SE0_PERFCOUNTER_HI (31461, 31470, 31474) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GRBM_SE1_PERFCOUNTER_LO (31485) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GRBM_SE1_PERFCOUNTER_HI (31509) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GRBM_SE2_PERFCOUNTER_LO (31533) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GRBM_SE2_PERFCOUNTER_HI (31557) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GRBM_SE3_PERFCOUNTER_LO (31581) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GRBM_SE3_PERFCOUNTER_HI (31605) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER0_LO (31629) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER0_HI (31648) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER1_LO (31667) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER1_HI (31686) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER2_LO (31705) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER2_HI (31724) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER3_LO (31743) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER3_HI (31762) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER4_LO (31781) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER4_HI (31800) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER5_LO (31819) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER5_HI (31838) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER6_LO (31857) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER6_HI (31876) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER7_LO (31895) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER7_HI (31914) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '8', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER8_LO (31933) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '8', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER8_HI (31952) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '9', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER9_LO (31971) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '9', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER9_HI (31990) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '0', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER10_LO (32009) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '0', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER10_HI (32029) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '1', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER11_LO (32049) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '1', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER11_HI (32069) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* PA_SU_PERFCOUNTER0_LO (32089) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* PA_SU_PERFCOUNTER0_HI (32111) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* PA_SU_PERFCOUNTER1_LO (32133) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* PA_SU_PERFCOUNTER1_HI (32155) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* PA_SU_PERFCOUNTER2_LO (32177) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* PA_SU_PERFCOUNTER2_HI (32199) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* PA_SU_PERFCOUNTER3_LO (32221) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* PA_SU_PERFCOUNTER3_HI (32243) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER0_LO (32265) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER0_HI (32287) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER1_LO (32309) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER1_HI (32331) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER2_LO (32353) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER2_HI (32375) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER3_LO (32397) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER3_HI (32419) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER4_LO (32441) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER4_HI (32463) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER5_LO (32485) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER5_HI (32507) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER6_LO (32529) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER6_HI (32551) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER7_LO (32573) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER7_HI (32595) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SPI_PERFCOUNTER0_HI (32617) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SPI_PERFCOUNTER0_LO (32637) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SPI_PERFCOUNTER1_HI (32657) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SPI_PERFCOUNTER1_LO (32677) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* SPI_PERFCOUNTER2_HI (32697) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* SPI_PERFCOUNTER2_LO (32717) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* SPI_PERFCOUNTER3_HI (32737) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* SPI_PERFCOUNTER3_LO (32757) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'H', 'I', '\0', /* SPI_PERFCOUNTER4_HI (32777) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'L', 'O', '\0', /* SPI_PERFCOUNTER4_LO (32797) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'H', 'I', '\0', /* SPI_PERFCOUNTER5_HI (32817) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'L', 'O', '\0', /* SPI_PERFCOUNTER5_LO (32837) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER0_LO (32857) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER0_HI (32876) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER1_LO (32895) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER1_HI (32914) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER2_LO (32933) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER2_HI (32952) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER3_LO (32971) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER3_HI (32990) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER4_LO (33009) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER4_HI (33028) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER5_LO (33047) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER5_HI (33066) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER6_LO (33085) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER6_HI (33104) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER7_LO (33123) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER7_HI (33142) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '8', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER8_LO (33161) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '8', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER8_HI (33180) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '9', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER9_LO (33199) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '9', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER9_HI (33218) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '0', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER10_LO (33237) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '0', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER10_HI (33257) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '1', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER11_LO (33277) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '1', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER11_HI (33297) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '2', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER12_LO (33317) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '2', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER12_HI (33337) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '3', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER13_LO (33357) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '3', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER13_HI (33377) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '4', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER14_LO (33397) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '4', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER14_HI (33417) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '5', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER15_LO (33437) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '5', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER15_HI (33457) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SX_PERFCOUNTER0_LO (33477) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SX_PERFCOUNTER0_HI (33496) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SX_PERFCOUNTER1_LO (33515) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SX_PERFCOUNTER1_HI (33534) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* SX_PERFCOUNTER2_LO (33553) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* SX_PERFCOUNTER2_HI (33572) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* SX_PERFCOUNTER3_LO (33591) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* SX_PERFCOUNTER3_HI (33610) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GCEA_PERFCOUNTER2_LO (33629) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GCEA_PERFCOUNTER2_HI (33650) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GDS_PERFCOUNTER0_LO (33671) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GDS_PERFCOUNTER0_HI (33691) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GDS_PERFCOUNTER1_LO (33711) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GDS_PERFCOUNTER1_HI (33731) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GDS_PERFCOUNTER2_LO (33751) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GDS_PERFCOUNTER2_HI (33771) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GDS_PERFCOUNTER3_LO (33791) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GDS_PERFCOUNTER3_HI (33811) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* TA_PERFCOUNTER0_LO (33831) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* TA_PERFCOUNTER0_HI (33850) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* TA_PERFCOUNTER1_LO (33869) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* TA_PERFCOUNTER1_HI (33888) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* TD_PERFCOUNTER0_LO (33907) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* TD_PERFCOUNTER0_HI (33926) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* TD_PERFCOUNTER1_LO (33945) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* TD_PERFCOUNTER1_HI (33964) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* TCP_PERFCOUNTER0_LO (33983) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* TCP_PERFCOUNTER0_HI (34003) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* TCP_PERFCOUNTER1_LO (34023) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* TCP_PERFCOUNTER1_HI (34043) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* TCP_PERFCOUNTER2_LO (34063) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* TCP_PERFCOUNTER2_HI (34083) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* TCP_PERFCOUNTER3_LO (34103) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* TCP_PERFCOUNTER3_HI (34123) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GL2C_PERFCOUNTER0_LO (34143) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GL2C_PERFCOUNTER0_HI (34164) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GL2C_PERFCOUNTER1_LO (34185) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GL2C_PERFCOUNTER1_HI (34206) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GL2C_PERFCOUNTER2_LO (34227) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GL2C_PERFCOUNTER2_HI (34248) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GL2C_PERFCOUNTER3_LO (34269) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GL2C_PERFCOUNTER3_HI (34290) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GL2A_PERFCOUNTER0_LO (34311) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GL2A_PERFCOUNTER0_HI (34332) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GL2A_PERFCOUNTER1_LO (34353) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GL2A_PERFCOUNTER1_HI (34374) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GL2A_PERFCOUNTER2_LO (34395) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GL2A_PERFCOUNTER2_HI (34416) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GL2A_PERFCOUNTER3_LO (34437) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GL2A_PERFCOUNTER3_HI (34458) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GL1C_PERFCOUNTER0_LO (34479) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GL1C_PERFCOUNTER0_HI (34500) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GL1C_PERFCOUNTER1_LO (34521) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GL1C_PERFCOUNTER1_HI (34542) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GL1C_PERFCOUNTER2_LO (34563) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GL1C_PERFCOUNTER2_HI (34584) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GL1C_PERFCOUNTER3_LO (34605) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GL1C_PERFCOUNTER3_HI (34626) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CHC_PERFCOUNTER0_LO (34647) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CHC_PERFCOUNTER0_HI (34667) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CHC_PERFCOUNTER1_LO (34687) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CHC_PERFCOUNTER1_HI (34707) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* CHC_PERFCOUNTER2_LO (34727) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* CHC_PERFCOUNTER2_HI (34747) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* CHC_PERFCOUNTER3_LO (34767) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* CHC_PERFCOUNTER3_HI (34787) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CHCG_PERFCOUNTER0_LO (34807) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CHCG_PERFCOUNTER0_HI (34828) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CHCG_PERFCOUNTER1_LO (34849) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CHCG_PERFCOUNTER1_HI (34870) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* CHCG_PERFCOUNTER2_LO (34891) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* CHCG_PERFCOUNTER2_HI (34912) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* CHCG_PERFCOUNTER3_LO (34933) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* CHCG_PERFCOUNTER3_HI (34954) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CB_PERFCOUNTER0_LO (34975) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CB_PERFCOUNTER0_HI (34994) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CB_PERFCOUNTER1_LO (35013) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CB_PERFCOUNTER1_HI (35032) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* CB_PERFCOUNTER2_LO (35051) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* CB_PERFCOUNTER2_HI (35070) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* CB_PERFCOUNTER3_LO (35089) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* CB_PERFCOUNTER3_HI (35108) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* DB_PERFCOUNTER0_LO (35127) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* DB_PERFCOUNTER0_HI (35146) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* DB_PERFCOUNTER1_LO (35165) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* DB_PERFCOUNTER1_HI (35184) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* DB_PERFCOUNTER2_LO (35203) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* DB_PERFCOUNTER2_HI (35222) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* DB_PERFCOUNTER3_LO (35241) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* DB_PERFCOUNTER3_HI (35260) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* RLC_PERFCOUNTER0_LO (35279) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* RLC_PERFCOUNTER0_HI (35299) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* RLC_PERFCOUNTER1_LO (35319) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* RLC_PERFCOUNTER1_HI (35339) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* RMI_PERFCOUNTER0_LO (35359) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* RMI_PERFCOUNTER0_HI (35379) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* RMI_PERFCOUNTER1_LO (35399) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* RMI_PERFCOUNTER1_HI (35419) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* RMI_PERFCOUNTER2_LO (35439) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* RMI_PERFCOUNTER2_HI (35459) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* RMI_PERFCOUNTER3_LO (35479) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* RMI_PERFCOUNTER3_HI (35499) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GC_ATC_L2_PERFCOUNTER_LO (35519, 35522) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GC_ATC_L2_PERFCOUNTER_HI (35544, 35547) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GCMC_VM_L2_PERFCOUNTER_LO (35569, 35571) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GCMC_VM_L2_PERFCOUNTER_HI (35595, 35597) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '0', '_', 'L', 'O', '\0', /* GCVML2_PERFCOUNTER2_0_LO (35621) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '1', '_', 'L', 'O', '\0', /* GCVML2_PERFCOUNTER2_1_LO (35646) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '0', '_', 'H', 'I', '\0', /* GCVML2_PERFCOUNTER2_0_HI (35671) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '1', '_', 'H', 'I', '\0', /* GCVML2_PERFCOUNTER2_1_HI (35696) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GC_ATC_L2_PERFCOUNTER2_LO (35721) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GC_ATC_L2_PERFCOUNTER2_HI (35747) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* UTCL1_PERFCOUNTER0_LO (35773) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* UTCL1_PERFCOUNTER0_HI (35795) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* UTCL1_PERFCOUNTER1_LO (35817) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* UTCL1_PERFCOUNTER1_HI (35839) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GCR_PERFCOUNTER0_LO (35861) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GCR_PERFCOUNTER0_HI (35881) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GCR_PERFCOUNTER1_LO (35901) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GCR_PERFCOUNTER1_HI (35921) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER0_LO (35941) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER0_HI (35963) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER1_LO (35985) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER1_HI (36007) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER2_LO (36029) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER2_HI (36051) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER3_LO (36073) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER3_HI (36095) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER4_LO (36117) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER4_HI (36139) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER5_LO (36161) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER5_HI (36183) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER6_LO (36205) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER6_HI (36227) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER7_LO (36249) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER7_HI (36271) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GL1A_PERFCOUNTER0_LO (36293) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GL1A_PERFCOUNTER0_HI (36314) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GL1A_PERFCOUNTER1_LO (36335) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GL1A_PERFCOUNTER1_HI (36356) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GL1A_PERFCOUNTER2_LO (36377) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GL1A_PERFCOUNTER2_HI (36398) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GL1A_PERFCOUNTER3_LO (36419) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GL1A_PERFCOUNTER3_HI (36440) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CHA_PERFCOUNTER0_LO (36461) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CHA_PERFCOUNTER0_HI (36481) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CHA_PERFCOUNTER1_LO (36501) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CHA_PERFCOUNTER1_HI (36521) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* CHA_PERFCOUNTER2_LO (36541) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* CHA_PERFCOUNTER2_HI (36561) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* CHA_PERFCOUNTER3_LO (36581) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* CHA_PERFCOUNTER3_HI (36601) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GUS_PERFCOUNTER2_LO (36621) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GUS_PERFCOUNTER2_HI (36641) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPG_PERFCOUNTER1_SELECT (36661) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CPG_PERFCOUNTER0_SELECT1 (36685) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPG_PERFCOUNTER0_SELECT (36710) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPC_PERFCOUNTER1_SELECT (36734, 36735) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CPC_PERFCOUNTER0_SELECT1 (36758, 36759) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPF_PERFCOUNTER1_SELECT (36783) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CPF_PERFCOUNTER0_SELECT1 (36807) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPF_PERFCOUNTER0_SELECT (36832) */
	'C', 'P', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'C', 'N', 'T', 'L', '\0', /* CP_PERFMON_CNTL (36856) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPC_PERFCOUNTER0_SELECT (36872, 36873) */
	'C', 'P', 'F', '_', 'T', 'C', '_', 'P', 'E', 'R', 'F', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPF_TC_PERF_COUNTER_WINDOW_SELECT (36896) */
	'C', 'P', 'G', '_', 'T', 'C', '_', 'P', 'E', 'R', 'F', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPG_TC_PERF_COUNTER_WINDOW_SELECT (36930) */
	'C', 'P', 'F', '_', 'L', 'A', 'T', 'E', 'N', 'C', 'Y', '_', 'S', 'T', 'A', 'T', 'S', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPF_LATENCY_STATS_SELECT (36964, 36979) */
	'C', 'P', 'G', '_', 'L', 'A', 'T', 'E', 'N', 'C', 'Y', '_', 'S', 'T', 'A', 'T', 'S', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPG_LATENCY_STATS_SELECT (36989) */
	'C', 'P', 'C', '_', 'L', 'A', 'T', 'E', 'N', 'C', 'Y', '_', 'S', 'T', 'A', 'T', 'S', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPC_LATENCY_STATS_SELECT (37014) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'O', 'B', 'J', 'E', 'C', 'T', '\0', /* CP_DRAW_OBJECT (37039) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'O', 'B', 'J', 'E', 'C', 'T', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '\0', /* CP_DRAW_OBJECT_COUNTER (37054) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'M', 'A', 'S', 'K', '_', 'H', 'I', '\0', /* CP_DRAW_WINDOW_MASK_HI (37077) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'H', 'I', '\0', /* CP_DRAW_WINDOW_HI (37100) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'L', 'O', '\0', /* CP_DRAW_WINDOW_LO (37118) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'C', 'N', 'T', 'L', '\0', /* CP_DRAW_WINDOW_CNTL (37136) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_PERFCOUNTER0_SELECT (37156) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_PERFCOUNTER1_SELECT (37181) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_SE0_PERFCOUNTER_SELECT (37206, 37215) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_SE1_PERFCOUNTER_SELECT (37234) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_SE2_PERFCOUNTER_SELECT (37262) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_SE3_PERFCOUNTER_SELECT (37290) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '_', 'H', 'I', '\0', /* GRBM_PERFCOUNTER0_SELECT_HI (37318) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '_', 'H', 'I', '\0', /* GRBM_PERFCOUNTER1_SELECT_HI (37346) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER0_SELECT (37374) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE_PERFCOUNTER0_SELECT1 (37397) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER1_SELECT (37421) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE_PERFCOUNTER1_SELECT1 (37444) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER2_SELECT (37468) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE_PERFCOUNTER2_SELECT1 (37491) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER3_SELECT (37515) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE_PERFCOUNTER3_SELECT1 (37538) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER4_SELECT (37562) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER5_SELECT (37585) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER6_SELECT (37608) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER7_SELECT (37631) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '8', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER8_SELECT (37654) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '9', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER9_SELECT (37677) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER10_SELECT (37700) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER11_SELECT (37724) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SU_PERFCOUNTER0_SELECT (37748) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_SU_PERFCOUNTER0_SELECT1 (37774) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SU_PERFCOUNTER1_SELECT (37801) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_SU_PERFCOUNTER1_SELECT1 (37827) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SU_PERFCOUNTER2_SELECT (37854) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_SU_PERFCOUNTER2_SELECT1 (37880) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SU_PERFCOUNTER3_SELECT (37907) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_SU_PERFCOUNTER3_SELECT1 (37933) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER0_SELECT (37960) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_SC_PERFCOUNTER0_SELECT1 (37986) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER1_SELECT (38013) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER2_SELECT (38039) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER3_SELECT (38065) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER4_SELECT (38091) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER5_SELECT (38117) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER6_SELECT (38143) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER7_SELECT (38169) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SPI_PERFCOUNTER0_SELECT (38195) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SPI_PERFCOUNTER1_SELECT (38219) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SPI_PERFCOUNTER2_SELECT (38243) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SPI_PERFCOUNTER3_SELECT (38267) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SPI_PERFCOUNTER0_SELECT1 (38291) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SPI_PERFCOUNTER1_SELECT1 (38316) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SPI_PERFCOUNTER2_SELECT1 (38341) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SPI_PERFCOUNTER3_SELECT1 (38366) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SPI_PERFCOUNTER4_SELECT (38391) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SPI_PERFCOUNTER5_SELECT (38415) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'B', 'I', 'N', 'S', '\0', /* SPI_PERFCOUNTER_BINS (38439) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER0_SELECT (38460) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER1_SELECT (38483) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER2_SELECT (38506) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER3_SELECT (38529) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER4_SELECT (38552) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER5_SELECT (38575) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER6_SELECT (38598) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER7_SELECT (38621) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '8', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER8_SELECT (38644) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '9', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER9_SELECT (38667) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER10_SELECT (38690) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER11_SELECT (38714) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER12_SELECT (38738) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER13_SELECT (38762) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER14_SELECT (38786) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER15_SELECT (38810) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'C', 'T', 'R', 'L', '\0', /* SQ_PERFCOUNTER_CTRL (38834) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'C', 'T', 'R', 'L', '2', '\0', /* SQ_PERFCOUNTER_CTRL2 (38854) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GCEA_PERFCOUNTER2_SELECT (38875) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GCEA_PERFCOUNTER2_SELECT1 (38900) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'M', 'O', 'D', 'E', '\0', /* GCEA_PERFCOUNTER2_MODE (38926) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SX_PERFCOUNTER0_SELECT (38949) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SX_PERFCOUNTER1_SELECT (38972) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SX_PERFCOUNTER2_SELECT (38995) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SX_PERFCOUNTER3_SELECT (39018) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SX_PERFCOUNTER0_SELECT1 (39041) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SX_PERFCOUNTER1_SELECT1 (39065) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GDS_PERFCOUNTER0_SELECT (39089) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GDS_PERFCOUNTER1_SELECT (39113) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GDS_PERFCOUNTER2_SELECT (39137) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GDS_PERFCOUNTER3_SELECT (39161) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GDS_PERFCOUNTER0_SELECT1 (39185) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TA_PERFCOUNTER0_SELECT (39210) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TA_PERFCOUNTER0_SELECT1 (39233) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TA_PERFCOUNTER1_SELECT (39257) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TD_PERFCOUNTER0_SELECT (39280) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TD_PERFCOUNTER0_SELECT1 (39303) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TD_PERFCOUNTER1_SELECT (39327) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCP_PERFCOUNTER0_SELECT (39350) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCP_PERFCOUNTER0_SELECT1 (39374) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCP_PERFCOUNTER1_SELECT (39399) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCP_PERFCOUNTER1_SELECT1 (39423) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCP_PERFCOUNTER2_SELECT (39448) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCP_PERFCOUNTER3_SELECT (39472) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2C_PERFCOUNTER0_SELECT (39496) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL2C_PERFCOUNTER0_SELECT1 (39521) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2C_PERFCOUNTER1_SELECT (39547) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL2C_PERFCOUNTER1_SELECT1 (39572) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2C_PERFCOUNTER2_SELECT (39598) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2C_PERFCOUNTER3_SELECT (39623) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2A_PERFCOUNTER0_SELECT (39648) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL2A_PERFCOUNTER0_SELECT1 (39673) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2A_PERFCOUNTER1_SELECT (39699) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL2A_PERFCOUNTER1_SELECT1 (39724) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2A_PERFCOUNTER2_SELECT (39750) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2A_PERFCOUNTER3_SELECT (39775) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1C_PERFCOUNTER0_SELECT (39800) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL1C_PERFCOUNTER0_SELECT1 (39825) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1C_PERFCOUNTER1_SELECT (39851) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1C_PERFCOUNTER2_SELECT (39876) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1C_PERFCOUNTER3_SELECT (39901) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHC_PERFCOUNTER0_SELECT (39926) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CHC_PERFCOUNTER0_SELECT1 (39950) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHC_PERFCOUNTER1_SELECT (39975) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHC_PERFCOUNTER2_SELECT (39999) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHC_PERFCOUNTER3_SELECT (40023) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHCG_PERFCOUNTER0_SELECT (40047) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CHCG_PERFCOUNTER0_SELECT1 (40072) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHCG_PERFCOUNTER1_SELECT (40098) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHCG_PERFCOUNTER2_SELECT (40123) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHCG_PERFCOUNTER3_SELECT (40148) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'F', 'I', 'L', 'T', 'E', 'R', '\0', /* CB_PERFCOUNTER_FILTER (40173) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CB_PERFCOUNTER0_SELECT (40195) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CB_PERFCOUNTER0_SELECT1 (40218) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CB_PERFCOUNTER1_SELECT (40242) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CB_PERFCOUNTER2_SELECT (40265) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CB_PERFCOUNTER3_SELECT (40288) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* DB_PERFCOUNTER0_SELECT (40311) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* DB_PERFCOUNTER0_SELECT1 (40334) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* DB_PERFCOUNTER1_SELECT (40358) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* DB_PERFCOUNTER1_SELECT1 (40381) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* DB_PERFCOUNTER2_SELECT (40405) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* DB_PERFCOUNTER3_SELECT (40428) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'C', 'N', 'T', 'L', '\0', /* RLC_SPM_PERFMON_CNTL (40451) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'R', 'I', 'N', 'G', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* RLC_SPM_PERFMON_RING_BASE_LO (40472) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'R', 'I', 'N', 'G', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* RLC_SPM_PERFMON_RING_BASE_HI (40501, 40517) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_RING_SIZE (40530) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_SEGMENT_SIZE (40556, 40564) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'I', 'N', 'G', '_', 'R', 'D', 'P', 'T', 'R', '\0', /* RLC_SPM_RING_RDPTR (40585) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', '\0', /* RLC_SPM_SEGMENT_THRESHOLD (40604, 40620) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_SE_MUXSEL_ADDR (40630) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_SE_MUXSEL_DATA (40653) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'O', 'B', 'A', 'L', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_GLOBAL_MUXSEL_ADDR (40676) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'O', 'B', 'A', 'L', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_GLOBAL_MUXSEL_DATA (40703) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'D', 'E', 'S', 'E', 'R', '_', 'S', 'T', 'A', 'R', 'T', '_', 'S', 'K', 'E', 'W', '\0', /* RLC_SPM_DESER_START_SKEW (40730, 40738) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'O', 'B', 'A', 'L', 'S', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'S', 'K', 'E', 'W', '\0', /* RLC_SPM_GLOBALS_SAMPLE_SKEW (40755, 40763) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'O', 'B', 'A', 'L', 'S', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'S', 'K', 'E', 'W', '\0', /* RLC_SPM_GLOBALS_MUXSEL_SKEW (40783, 40791) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'S', 'K', 'E', 'W', '\0', /* RLC_SPM_SE_SAMPLE_SKEW (40811, 40819) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'S', 'K', 'E', 'W', '\0', /* RLC_SPM_SE_MUXSEL_SKEW (40834, 40842) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'B', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'D', 'E', 'L', 'A', 'Y', '_', 'I', 'N', 'D', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_GLB_SAMPLEDELAY_IND_ADDR (40857) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'B', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'D', 'E', 'L', 'A', 'Y', '_', 'I', 'N', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_GLB_SAMPLEDELAY_IND_DATA (40890) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'D', 'E', 'L', 'A', 'Y', '_', 'I', 'N', 'D', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_SE_SAMPLEDELAY_IND_ADDR (40923) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'D', 'E', 'L', 'A', 'Y', '_', 'I', 'N', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_SE_SAMPLEDELAY_IND_DATA (40955) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'I', 'N', 'G', '_', 'W', 'R', 'P', 'T', 'R', '\0', /* RLC_SPM_RING_WRPTR (40987) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'D', 'A', 'T', 'A', 'R', 'A', 'M', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_ACCUM_DATARAM_ADDR (41006) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'D', 'A', 'T', 'A', 'R', 'A', 'M', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_ACCUM_DATARAM_DATA (41033) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'C', 'T', 'R', 'L', 'R', 'A', 'M', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_ACCUM_CTRLRAM_ADDR (41060) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'C', 'T', 'R', 'L', 'R', 'A', 'M', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_ACCUM_CTRLRAM_DATA (41087) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* RLC_SPM_ACCUM_STATUS (41114) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'C', 'T', 'R', 'L', '\0', /* RLC_SPM_ACCUM_CTRL (41135) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'M', 'O', 'D', 'E', '\0', /* RLC_SPM_ACCUM_MODE (41154) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', '\0', /* RLC_SPM_ACCUM_THRESHOLD (41173) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '_', 'R', 'E', 'Q', 'U', 'E', 'S', 'T', 'E', 'D', '\0', /* RLC_SPM_ACCUM_SAMPLES_REQUESTED (41197) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'D', 'A', 'T', 'A', 'R', 'A', 'M', '_', 'W', 'R', 'C', 'O', 'U', 'N', 'T', '\0', /* RLC_SPM_ACCUM_DATARAM_WRCOUNT (41229) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'E', '3', 'T', 'O', '0', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_SE3TO0_SEGMENT_SIZE (41259) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'G', 'L', 'B', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_GLB_SEGMENT_SIZE (41295) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'V', 'I', 'R', 'T', '_', 'C', 'T', 'R', 'L', '\0', /* RLC_SPM_VIRT_CTRL (41328) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'V', 'I', 'R', 'T', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* RLC_SPM_VIRT_STATUS (41346) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'C', 'N', 'T', 'L', '\0', /* RLC_PERFMON_CNTL (41366) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* RLC_PERFCOUNTER0_SELECT (41383) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* RLC_PERFCOUNTER1_SELECT (41407) */
	'R', 'L', 'C', '_', 'G', 'P', 'U', '_', 'I', 'O', 'V', '_', 'P', 'E', 'R', 'F', '_', 'C', 'N', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* RLC_GPU_IOV_PERF_CNT_CNTL (41431) */
	'R', 'L', 'C', '_', 'G', 'P', 'U', '_', 'I', 'O', 'V', '_', 'P', 'E', 'R', 'F', '_', 'C', 'N', 'T', '_', 'W', 'R', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_GPU_IOV_PERF_CNT_WR_ADDR (41457) */
	'R', 'L', 'C', '_', 'G', 'P', 'U', '_', 'I', 'O', 'V', '_', 'P', 'E', 'R', 'F', '_', 'C', 'N', 'T', '_', 'W', 'R', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_GPU_IOV_PERF_CNT_WR_DATA (41486) */
	'R', 'L', 'C', '_', 'G', 'P', 'U', '_', 'I', 'O', 'V', '_', 'P', 'E', 'R', 'F', '_', 'C', 'N', 'T', '_', 'R', 'D', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_GPU_IOV_PERF_CNT_RD_ADDR (41515) */
	'R', 'L', 'C', '_', 'G', 'P', 'U', '_', 'I', 'O', 'V', '_', 'P', 'E', 'R', 'F', '_', 'C', 'N', 'T', '_', 'R', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_GPU_IOV_PERF_CNT_RD_DATA (41544) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'C', 'L', 'K', '_', 'C', 'N', 'T', 'L', '\0', /* RLC_PERFMON_CLK_CNTL (41573) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'C', 'L', 'K', '_', 'C', 'N', 'T', 'L', '_', 'U', 'C', 'O', 'D', 'E', '\0', /* RLC_PERFMON_CLK_CNTL_UCODE (41594) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* RMI_PERFCOUNTER0_SELECT (41621) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* RMI_PERFCOUNTER0_SELECT1 (41645) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* RMI_PERFCOUNTER1_SELECT (41670) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* RMI_PERFCOUNTER2_SELECT (41694) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* RMI_PERFCOUNTER2_SELECT1 (41718) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* RMI_PERFCOUNTER3_SELECT (41743) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* RMI_PERF_COUNTER_CNTL (41767) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* GC_ATC_L2_PERFCOUNTER0_CFG (41789, 41792) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* GC_ATC_L2_PERFCOUNTER1_CFG (41816, 41819) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GC_ATC_L2_PERFCOUNTER_RSLT_CNTL (41843, 41846) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER0_CFG (41875, 41877) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER1_CFG (41903, 41905) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER2_CFG (41931, 41933) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER3_CFG (41959, 41961) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER4_CFG (41987, 41989) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER5_CFG (42015, 42017) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER6_CFG (42043, 42045) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER7_CFG (42071, 42073) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GCMC_VM_L2_PERFCOUNTER_RSLT_CNTL (42099, 42101) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GCVML2_PERFCOUNTER2_0_SELECT (42132) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GCVML2_PERFCOUNTER2_1_SELECT (42161) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GCVML2_PERFCOUNTER2_0_SELECT1 (42190) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GCVML2_PERFCOUNTER2_1_SELECT1 (42220) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '0', '_', 'M', 'O', 'D', 'E', '\0', /* GCVML2_PERFCOUNTER2_0_MODE (42250) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '1', '_', 'M', 'O', 'D', 'E', '\0', /* GCVML2_PERFCOUNTER2_1_MODE (42277) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GC_ATC_L2_PERFCOUNTER2_SELECT (42304) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GC_ATC_L2_PERFCOUNTER2_SELECT1 (42334) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'M', 'O', 'D', 'E', '\0', /* GC_ATC_L2_PERFCOUNTER2_MODE (42365) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GCR_PERFCOUNTER0_SELECT (42393) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GCR_PERFCOUNTER0_SELECT1 (42417) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GCR_PERFCOUNTER1_SELECT (42442) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* UTCL1_PERFCOUNTER0_SELECT (42466) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* UTCL1_PERFCOUNTER1_SELECT (42492) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER0_SELECT (42518) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_PH_PERFCOUNTER0_SELECT1 (42544) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER1_SELECT (42571) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER2_SELECT (42597) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER3_SELECT (42623) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER4_SELECT (42649) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER5_SELECT (42675) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER6_SELECT (42701) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER7_SELECT (42727) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_PH_PERFCOUNTER1_SELECT1 (42753) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_PH_PERFCOUNTER2_SELECT1 (42780) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_PH_PERFCOUNTER3_SELECT1 (42807) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1A_PERFCOUNTER0_SELECT (42834) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL1A_PERFCOUNTER0_SELECT1 (42859) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1A_PERFCOUNTER1_SELECT (42885) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1A_PERFCOUNTER2_SELECT (42910) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1A_PERFCOUNTER3_SELECT (42935) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHA_PERFCOUNTER0_SELECT (42960) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CHA_PERFCOUNTER0_SELECT1 (42984) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHA_PERFCOUNTER1_SELECT (43009) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHA_PERFCOUNTER2_SELECT (43033) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHA_PERFCOUNTER3_SELECT (43057) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GUS_PERFCOUNTER2_SELECT (43081) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GUS_PERFCOUNTER2_SELECT1 (43105) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'M', 'O', 'D', 'E', '\0', /* GUS_PERFCOUNTER2_MODE (43130) */
	'D', 'S', 'T', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* DST_ADDR_LO (43152) */
	'I', 'B', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* IB_BASE_LO (43164) */
	'I', 'B', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* IB_BASE_HI (43175) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CP_DMA_WORD0 (43186) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CP_DMA_WORD1 (43199) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'W', 'O', 'R', 'D', '2', '\0', /* CP_DMA_WORD2 (43212) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'W', 'O', 'R', 'D', '3', '\0', /* CP_DMA_WORD3 (43225) */
	'R', 'E', 'L', 'E', 'A', 'S', 'E', '_', 'M', 'E', 'M', '_', 'O', 'P', '\0', /* RELEASE_MEM_OP (43238) */
	'D', 'M', 'A', '_', 'D', 'A', 'T', 'A', '_', 'W', 'O', 'R', 'D', '0', '\0', /* DMA_DATA_WORD0 (43253) */
	'S', 'R', 'C', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* SRC_ADDR_LO (43268) */
	'G', 'C', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* GCR_CNTL (43280) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'A', 'C', 'T', 'I', 'V', 'E', '\0', /* SQ_WAVE_ACTIVE (43289) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'V', 'A', 'L', 'I', 'D', '_', 'A', 'N', 'D', '_', 'I', 'D', 'L', 'E', '\0', /* SQ_WAVE_VALID_AND_IDLE (43304, 43322) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'C', 'Y', 'C', 'L', 'E', 'S', '\0', /* SQ_WAVE_SHADER_CYCLES (43327, 43342) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'P', 'R', 'I', 'V', '_', 'V', 'I', 'O', 'L', 'A', 'T', 'I', 'O', 'N', '_', 'A', 'D', 'D', 'R', '\0', /* CP_CPC_PRIV_VIOLATION_ADDR (43349, 43356) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'S', 'T', 'A', 'T', 'U', 'S', '2', '\0', /* SQ_THREAD_TRACE_STATUS2 (43376) */
	'D', 'B', '_', 'V', 'R', 'S', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* DB_VRS_OVERRIDE_CNTL (43400) */
	'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '0', '\0', /* CONTEXT_RESERVED_REG0 (43421) */
	'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '1', '\0', /* CONTEXT_RESERVED_REG1 (43443) */
	'S', 'X', '_', 'P', 'S', '_', 'D', 'O', 'W', 'N', 'C', 'O', 'N', 'V', 'E', 'R', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* SX_PS_DOWNCONVERT_CONTROL (43465) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'R', 'S', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_VRS_CNTL (43491) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '_', 'A', 'T', 'O', 'M', 'I', 'C', '\0', /* SCRATCH_REG_ATOMIC (43506, 43518) */
	'U', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '0', '\0', /* UCONFIG_RESERVED_REG0 (43525) */
	'U', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '1', '\0', /* UCONFIG_RESERVED_REG1 (43547) */
	'C', 'P', '_', 'C', 'E', '_', 'A', 'T', 'O', 'M', 'I', 'C', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_CE_ATOMIC_PREOP_LO (43569) */
	'C', 'P', '_', 'C', 'E', '_', 'A', 'T', 'O', 'M', 'I', 'C', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_CE_ATOMIC_PREOP_HI (43591) */
	'C', 'P', '_', 'C', 'E', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '0', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_CE_GDS_ATOMIC0_PREOP_LO (43613) */
	'C', 'P', '_', 'C', 'E', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '0', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_CE_GDS_ATOMIC0_PREOP_HI (43640) */
	'C', 'P', '_', 'C', 'E', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '1', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_CE_GDS_ATOMIC1_PREOP_LO (43667) */
	'C', 'P', '_', 'C', 'E', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '1', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_CE_GDS_ATOMIC1_PREOP_HI (43694) */
	'G', 'E', '_', 'V', 'R', 'S', '_', 'R', 'A', 'T', 'E', '\0', /* GE_VRS_RATE (43721, 43724) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GE1_PERFCOUNTER0_LO (43733) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GE1_PERFCOUNTER0_HI (43753) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GE1_PERFCOUNTER1_LO (43773) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GE1_PERFCOUNTER1_HI (43793) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GE1_PERFCOUNTER2_LO (43813) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GE1_PERFCOUNTER2_HI (43833) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GE1_PERFCOUNTER3_LO (43853) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GE1_PERFCOUNTER3_HI (43873) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GE2_DIST_PERFCOUNTER0_LO (43893) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GE2_DIST_PERFCOUNTER0_HI (43918) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GE2_DIST_PERFCOUNTER1_LO (43943) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GE2_DIST_PERFCOUNTER1_HI (43968) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GE2_DIST_PERFCOUNTER2_LO (43993) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GE2_DIST_PERFCOUNTER2_HI (44018) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GE2_DIST_PERFCOUNTER3_LO (44043) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GE2_DIST_PERFCOUNTER3_HI (44068) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GE2_SE_PERFCOUNTER0_LO (44093) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GE2_SE_PERFCOUNTER0_HI (44116) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GE2_SE_PERFCOUNTER1_LO (44139) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GE2_SE_PERFCOUNTER1_HI (44162) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GE2_SE_PERFCOUNTER2_LO (44185) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GE2_SE_PERFCOUNTER2_HI (44208) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GE2_SE_PERFCOUNTER3_LO (44231) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GE2_SE_PERFCOUNTER3_HI (44254) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GCEA_PERFCOUNTER_LO (44277) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GCEA_PERFCOUNTER_HI (44297) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GCUTCL2_PERFCOUNTER_LO (44317) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GCUTCL2_PERFCOUNTER_HI (44340) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GUS_PERFCOUNTER_LO (44363) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GUS_PERFCOUNTER_HI (44382) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* SDMA0_PERFCNT_PERFCOUNTER_LO (44401) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* SDMA0_PERFCNT_PERFCOUNTER_HI (44430) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SDMA0_PERFCOUNTER0_LO (44459) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SDMA0_PERFCOUNTER0_HI (44481) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SDMA0_PERFCOUNTER1_LO (44503) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SDMA0_PERFCOUNTER1_HI (44525) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* SDMA1_PERFCNT_PERFCOUNTER_LO (44547) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* SDMA1_PERFCNT_PERFCOUNTER_HI (44576) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SDMA1_PERFCOUNTER0_LO (44605) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SDMA1_PERFCOUNTER0_HI (44627) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SDMA1_PERFCOUNTER1_LO (44649) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SDMA1_PERFCOUNTER1_HI (44671) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* SDMA2_PERFCNT_PERFCOUNTER_LO (44693) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* SDMA2_PERFCNT_PERFCOUNTER_HI (44722) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SDMA2_PERFCOUNTER0_LO (44751) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SDMA2_PERFCOUNTER0_HI (44773) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SDMA2_PERFCOUNTER1_LO (44795) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SDMA2_PERFCOUNTER1_HI (44817) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* SDMA3_PERFCNT_PERFCOUNTER_LO (44839) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* SDMA3_PERFCNT_PERFCOUNTER_HI (44868) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SDMA3_PERFCOUNTER0_LO (44897) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SDMA3_PERFCOUNTER0_HI (44919) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SDMA3_PERFCOUNTER1_LO (44941) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SDMA3_PERFCOUNTER1_HI (44963) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE1_PERFCOUNTER0_SELECT (44985) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE1_PERFCOUNTER0_SELECT1 (45009) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE1_PERFCOUNTER1_SELECT (45034) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE1_PERFCOUNTER1_SELECT1 (45058) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE1_PERFCOUNTER2_SELECT (45083) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE1_PERFCOUNTER2_SELECT1 (45107) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE1_PERFCOUNTER3_SELECT (45132) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE1_PERFCOUNTER3_SELECT1 (45156) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_DIST_PERFCOUNTER0_SELECT (45181) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_DIST_PERFCOUNTER0_SELECT1 (45210) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_DIST_PERFCOUNTER1_SELECT (45240) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_DIST_PERFCOUNTER1_SELECT1 (45269) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_DIST_PERFCOUNTER2_SELECT (45299) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_DIST_PERFCOUNTER2_SELECT1 (45328) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_DIST_PERFCOUNTER3_SELECT (45358) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_DIST_PERFCOUNTER3_SELECT1 (45387) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_SE_PERFCOUNTER0_SELECT (45417) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_SE_PERFCOUNTER0_SELECT1 (45444) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_SE_PERFCOUNTER1_SELECT (45472) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_SE_PERFCOUNTER1_SELECT1 (45499) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_SE_PERFCOUNTER2_SELECT (45527) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_SE_PERFCOUNTER2_SELECT1 (45554) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_SE_PERFCOUNTER3_SELECT (45582) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_SE_PERFCOUNTER3_SELECT1 (45609) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* GCEA_PERFCOUNTER0_CFG (45637) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* GCEA_PERFCOUNTER1_CFG (45659) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GCEA_PERFCOUNTER_RSLT_CNTL (45681) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GDS_PERFCOUNTER1_SELECT1 (45708) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GDS_PERFCOUNTER2_SELECT1 (45733) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GDS_PERFCOUNTER3_SELECT1 (45758) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'W', 'A', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_SWA_SEGMENT_SIZE (45783) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'F', 'X', 'C', 'L', 'O', 'C', 'K', '_', 'H', 'I', 'G', 'H', 'C', 'O', 'U', 'N', 'T', '\0', /* RLC_SPM_GFXCLOCK_HIGHCOUNT (45816) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'F', 'X', 'C', 'L', 'O', 'C', 'K', '_', 'L', 'O', 'W', 'C', 'O', 'U', 'N', 'T', '\0', /* RLC_SPM_GFXCLOCK_LOWCOUNT (45843) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'W', 'A', '_', 'S', 'E', '3', 'T', 'O', '0', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_SWA_SE3TO0_SEGMENT_SIZE (45869) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'O', 'B', 'A', 'L', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'A', 'D', 'D', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* RLC_SPM_GLOBAL_MUXSEL_ADDR_OFFSET (45909) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'A', 'D', 'D', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* RLC_SPM_SE_MUXSEL_ADDR_OFFSET (45943) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'S', 'W', 'A', '_', 'D', 'A', 'T', 'A', 'R', 'A', 'M', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_ACCUM_SWA_DATARAM_ADDR (45973) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'S', 'W', 'A', '_', 'D', 'A', 'T', 'A', 'R', 'A', 'M', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_ACCUM_SWA_DATARAM_DATA (46004) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'C', 'T', 'R', 'L', 'R', 'A', 'M', '_', 'A', 'D', 'D', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* RLC_SPM_ACCUM_CTRLRAM_ADDR_OFFSET (46035) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'W', 'A', '_', 'G', 'L', 'B', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_SWA_GLB_SEGMENT_SIZE (46069) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'D', 'A', 'T', 'A', 'R', 'A', 'M', '_', '3', '2', 'B', 'I', 'T', 'C', 'N', 'T', 'R', 'S', '_', 'R', 'E', 'G', 'I', 'O', 'N', 'S', '\0', /* RLC_SPM_ACCUM_DATARAM_32BITCNTRS_REGIONS (46106) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* GCUTCL2_PERFCOUNTER0_CFG (46147) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* GCUTCL2_PERFCOUNTER1_CFG (46172) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'C', 'F', 'G', '\0', /* GCUTCL2_PERFCOUNTER2_CFG (46197) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'C', 'F', 'G', '\0', /* GCUTCL2_PERFCOUNTER3_CFG (46222) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GCUTCL2_PERFCOUNTER_RSLT_CNTL (46247) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* GUS_PERFCOUNTER0_CFG (46277) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* GUS_PERFCOUNTER1_CFG (46298) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GUS_PERFCOUNTER_RSLT_CNTL (46319) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* SDMA0_PERFCNT_PERFCOUNTER0_CFG (46345) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* SDMA0_PERFCNT_PERFCOUNTER1_CFG (46376) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA0_PERFCNT_PERFCOUNTER_RSLT_CNTL (46407) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'M', 'I', 'S', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA0_PERFCNT_MISC_CNTL (46443) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA0_PERFCOUNTER0_SELECT (46467) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA0_PERFCOUNTER0_SELECT1 (46493) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA0_PERFCOUNTER1_SELECT (46520) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA0_PERFCOUNTER1_SELECT1 (46546) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* SDMA1_PERFCNT_PERFCOUNTER0_CFG (46573) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* SDMA1_PERFCNT_PERFCOUNTER1_CFG (46604) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA1_PERFCNT_PERFCOUNTER_RSLT_CNTL (46635) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'M', 'I', 'S', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA1_PERFCNT_MISC_CNTL (46671) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA1_PERFCOUNTER0_SELECT (46695) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA1_PERFCOUNTER0_SELECT1 (46721) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA1_PERFCOUNTER1_SELECT (46748) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA1_PERFCOUNTER1_SELECT1 (46774) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* SDMA2_PERFCNT_PERFCOUNTER0_CFG (46801) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* SDMA2_PERFCNT_PERFCOUNTER1_CFG (46832) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA2_PERFCNT_PERFCOUNTER_RSLT_CNTL (46863) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'M', 'I', 'S', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA2_PERFCNT_MISC_CNTL (46899) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA2_PERFCOUNTER0_SELECT (46923) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA2_PERFCOUNTER0_SELECT1 (46949) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA2_PERFCOUNTER1_SELECT (46976) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA2_PERFCOUNTER1_SELECT1 (47002) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* SDMA3_PERFCNT_PERFCOUNTER0_CFG (47029) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* SDMA3_PERFCNT_PERFCOUNTER1_CFG (47060) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA3_PERFCNT_PERFCOUNTER_RSLT_CNTL (47091) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'M', 'I', 'S', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA3_PERFCNT_MISC_CNTL (47127) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA3_PERFCOUNTER0_SELECT (47151) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA3_PERFCOUNTER0_SELECT1 (47177) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA3_PERFCOUNTER1_SELECT (47204) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA3_PERFCOUNTER1_SELECT1 (47230) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'S', 'E', '4', '\0', /* GRBM_STATUS_SE4 (47257) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'S', 'E', '5', '\0', /* GRBM_STATUS_SE5 (47273) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'D', 'E', 'B', 'U', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* CP_CPC_DEBUG_CNTL (47289) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'D', 'E', 'B', 'U', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* CP_CPC_DEBUG_DATA (47307, 47314) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'G', 'S', '_', 'M', 'E', 'S', 'H', 'L', 'E', 'T', '_', 'D', 'I', 'M', '\0', /* SPI_SHADER_GS_MESHLET_DIM (47325, 47347) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'G', 'S', '_', 'M', 'E', 'S', 'H', 'L', 'E', 'T', '_', 'E', 'X', 'P', '_', 'A', 'L', 'L', 'O', 'C', '\0', /* SPI_SHADER_GS_MESHLET_EXP_ALLOC (47351) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '4', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE4 (47383) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '5', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE5 (47414) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '6', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE6 (47445) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '7', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE7 (47476) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'T', 'E', 'R', 'L', 'E', 'A', 'V', 'E', '\0', /* COMPUTE_DISPATCH_INTERLEAVE (47507, 47524) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'R', 'S', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_VRS_OVERRIDE_CNTL (47535) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'R', 'S', '_', 'R', 'A', 'T', 'E', '_', 'F', 'E', 'E', 'D', 'B', 'A', 'C', 'K', '_', 'B', 'A', 'S', 'E', '\0', /* PA_SC_VRS_RATE_FEEDBACK_BASE (47559) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'R', 'S', '_', 'R', 'A', 'T', 'E', '_', 'F', 'E', 'E', 'D', 'B', 'A', 'C', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* PA_SC_VRS_RATE_FEEDBACK_BASE_EXT (47588) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'R', 'S', '_', 'R', 'A', 'T', 'E', '_', 'F', 'E', 'E', 'D', 'B', 'A', 'C', 'K', '_', 'S', 'I', 'Z', 'E', '_', 'X', 'Y', '\0', /* PA_SC_VRS_RATE_FEEDBACK_SIZE_XY (47621) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'R', 'S', '_', 'R', 'A', 'T', 'E', '_', 'C', 'A', 'C', 'H', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_VRS_RATE_CACHE_CNTL (47653) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'R', 'S', '_', 'R', 'A', 'T', 'E', '_', 'B', 'A', 'S', 'E', '\0', /* PA_SC_VRS_RATE_BASE (47679) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'R', 'S', '_', 'R', 'A', 'T', 'E', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* PA_SC_VRS_RATE_BASE_EXT (47699) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'R', 'S', '_', 'R', 'A', 'T', 'E', '_', 'S', 'I', 'Z', 'E', '_', 'X', 'Y', '\0', /* PA_SC_VRS_RATE_SIZE_XY (47723) */
	'C', 'B', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_FDCC_CONTROL (47746) */
	'P', 'A', '_', 'R', 'A', 'T', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_RATE_CNTL (47762) */
	'S', 'P', 'I', '_', 'G', 'F', 'X', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* SPI_GFX_SCRATCH_BASE_LO (47775) */
	'S', 'P', 'I', '_', 'G', 'F', 'X', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* SPI_GFX_SCRATCH_BASE_HI (47799) */
	'P', 'A', '_', 'S', 'C', '_', 'B', 'I', 'N', 'N', 'E', 'R', '_', 'C', 'N', 'T', 'L', '_', '2', '\0', /* PA_SC_BINNER_CNTL_2 (47823) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR0_FDCC_CONTROL (47843) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR1_FDCC_CONTROL (47866) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR2_FDCC_CONTROL (47889) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR3_FDCC_CONTROL (47912) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR4_FDCC_CONTROL (47935) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR5_FDCC_CONTROL (47958) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR6_FDCC_CONTROL (47981) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR7_FDCC_CONTROL (48004) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'A', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_ASINVOC_COUNT_LO (48027) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'A', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_ASINVOC_COUNT_HI (48051) */
	'C', 'P', '_', 'P', 'A', '_', 'M', 'S', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_PA_MSPRIM_COUNT_LO (48075) */
	'C', 'P', '_', 'P', 'A', '_', 'M', 'S', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_PA_MSPRIM_COUNT_HI (48097) */
	'C', 'P', '_', 'G', 'E', '_', 'M', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_GE_MSINVOC_COUNT_LO (48119) */
	'C', 'P', '_', 'G', 'E', '_', 'M', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_GE_MSINVOC_COUNT_HI (48142) */
	'G', 'E', '_', 'G', 'S', '_', 'F', 'A', 'S', 'T', '_', 'L', 'A', 'U', 'N', 'C', 'H', '_', 'W', 'G', '_', 'D', 'I', 'M', '\0', /* GE_GS_FAST_LAUNCH_WG_DIM (48165) */
	'G', 'E', '_', 'G', 'S', '_', 'F', 'A', 'S', 'T', '_', 'L', 'A', 'U', 'N', 'C', 'H', '_', 'W', 'G', '_', 'D', 'I', 'M', '_', '1', '\0', /* GE_GS_FAST_LAUNCH_WG_DIM_1 (48190) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'D', 'W', 'O', 'R', 'D', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '0', '\0', /* GDS_STRMOUT_DWORDS_WRITTEN_0 (48217) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'D', 'W', 'O', 'R', 'D', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '1', '\0', /* GDS_STRMOUT_DWORDS_WRITTEN_1 (48246) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'D', 'W', 'O', 'R', 'D', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '2', '\0', /* GDS_STRMOUT_DWORDS_WRITTEN_2 (48275) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'D', 'W', 'O', 'R', 'D', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '3', '\0', /* GDS_STRMOUT_DWORDS_WRITTEN_3 (48304) */
	'G', 'D', 'S', '_', 'G', 'S', '_', '0', '\0', /* GDS_GS_0 (48333) */
	'G', 'D', 'S', '_', 'G', 'S', '_', '1', '\0', /* GDS_GS_1 (48342) */
	'G', 'D', 'S', '_', 'G', 'S', '_', '2', '\0', /* GDS_GS_2 (48351) */
	'G', 'D', 'S', '_', 'G', 'S', '_', '3', '\0', /* GDS_GS_3 (48360) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', '0', '_', 'L', 'O', '\0', /* GDS_STRMOUT_PRIMS_NEEDED_0_LO (48369) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', '0', '_', 'H', 'I', '\0', /* GDS_STRMOUT_PRIMS_NEEDED_0_HI (48399) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '0', '_', 'L', 'O', '\0', /* GDS_STRMOUT_PRIMS_WRITTEN_0_LO (48429) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '0', '_', 'H', 'I', '\0', /* GDS_STRMOUT_PRIMS_WRITTEN_0_HI (48460) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', '1', '_', 'L', 'O', '\0', /* GDS_STRMOUT_PRIMS_NEEDED_1_LO (48491) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', '1', '_', 'H', 'I', '\0', /* GDS_STRMOUT_PRIMS_NEEDED_1_HI (48521) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '1', '_', 'L', 'O', '\0', /* GDS_STRMOUT_PRIMS_WRITTEN_1_LO (48551) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '1', '_', 'H', 'I', '\0', /* GDS_STRMOUT_PRIMS_WRITTEN_1_HI (48582) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', '2', '_', 'L', 'O', '\0', /* GDS_STRMOUT_PRIMS_NEEDED_2_LO (48613) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', '2', '_', 'H', 'I', '\0', /* GDS_STRMOUT_PRIMS_NEEDED_2_HI (48643) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '2', '_', 'L', 'O', '\0', /* GDS_STRMOUT_PRIMS_WRITTEN_2_LO (48673) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '2', '_', 'H', 'I', '\0', /* GDS_STRMOUT_PRIMS_WRITTEN_2_HI (48704) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', '3', '_', 'L', 'O', '\0', /* GDS_STRMOUT_PRIMS_NEEDED_3_LO (48735) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', '3', '_', 'H', 'I', '\0', /* GDS_STRMOUT_PRIMS_NEEDED_3_HI (48765) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '3', '_', 'L', 'O', '\0', /* GDS_STRMOUT_PRIMS_WRITTEN_3_LO (48795) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '3', '_', 'H', 'I', '\0', /* GDS_STRMOUT_PRIMS_WRITTEN_3_HI (48826) */
	'S', 'P', 'I', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'C', 'N', 'T', 'L', '_', '1', '\0', /* SPI_CONFIG_CNTL_1 (48857) */
	'S', 'P', 'I', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'C', 'N', 'T', 'L', '_', '2', '\0', /* SPI_CONFIG_CNTL_2 (48875) */
	'S', 'P', 'I', '_', 'W', 'A', 'V', 'E', '_', 'L', 'I', 'M', 'I', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* SPI_WAVE_LIMIT_CNTL (48893) */
	'S', 'P', 'I', '_', 'G', 'S', '_', 'T', 'H', 'R', 'O', 'T', 'T', 'L', 'E', '_', 'C', 'N', 'T', 'L', '1', '\0', /* SPI_GS_THROTTLE_CNTL1 (48913) */
	'S', 'P', 'I', '_', 'G', 'S', '_', 'T', 'H', 'R', 'O', 'T', 'T', 'L', 'E', '_', 'C', 'N', 'T', 'L', '2', '\0', /* SPI_GS_THROTTLE_CNTL2 (48935) */
	'S', 'P', 'I', '_', 'A', 'T', 'T', 'R', 'I', 'B', 'U', 'T', 'E', '_', 'R', 'I', 'N', 'G', '_', 'B', 'A', 'S', 'E', '\0', /* SPI_ATTRIBUTE_RING_BASE (48957) */
	'S', 'P', 'I', '_', 'A', 'T', 'T', 'R', 'I', 'B', 'U', 'T', 'E', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* SPI_ATTRIBUTE_RING_SIZE (48981) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '4', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GRBM_SE4_PERFCOUNTER_LO (49005) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '4', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GRBM_SE4_PERFCOUNTER_HI (49029) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '5', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GRBM_SE5_PERFCOUNTER_LO (49053) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '5', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GRBM_SE5_PERFCOUNTER_HI (49077) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '6', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GRBM_SE6_PERFCOUNTER_LO (49101) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '6', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GRBM_SE6_PERFCOUNTER_HI (49125) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* PC_PERFCOUNTER2_HI (49149) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* PC_PERFCOUNTER2_LO (49168) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* PC_PERFCOUNTER3_HI (49187) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* PC_PERFCOUNTER3_LO (49206) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SQG_PERFCOUNTER0_LO (49225) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SQG_PERFCOUNTER0_HI (49245) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SQG_PERFCOUNTER1_LO (49265) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SQG_PERFCOUNTER1_HI (49285) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* SQG_PERFCOUNTER2_LO (49305) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* SQG_PERFCOUNTER2_HI (49325) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* SQG_PERFCOUNTER3_LO (49345) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* SQG_PERFCOUNTER3_HI (49365) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'L', 'O', '\0', /* SQG_PERFCOUNTER4_LO (49385) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'H', 'I', '\0', /* SQG_PERFCOUNTER4_HI (49405) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'L', 'O', '\0', /* SQG_PERFCOUNTER5_LO (49425) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'H', 'I', '\0', /* SQG_PERFCOUNTER5_HI (49445) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'L', 'O', '\0', /* SQG_PERFCOUNTER6_LO (49465) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'H', 'I', '\0', /* SQG_PERFCOUNTER6_HI (49485) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'L', 'O', '\0', /* SQG_PERFCOUNTER7_LO (49505) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'H', 'I', '\0', /* SQG_PERFCOUNTER7_HI (49525) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'F', 'I', 'L', 'T', 'E', 'R', '\0', /* TCP_PERFCOUNTER_FILTER (49545) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'F', 'I', 'L', 'T', 'E', 'R', '2', '\0', /* TCP_PERFCOUNTER_FILTER2 (49568) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'F', 'I', 'L', 'T', 'E', 'R', '_', 'E', 'N', '\0', /* TCP_PERFCOUNTER_FILTER_EN (49592) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* UTCL1_PERFCOUNTER2_LO (49618) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* UTCL1_PERFCOUNTER2_HI (49640) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* UTCL1_PERFCOUNTER3_LO (49662) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* UTCL1_PERFCOUNTER3_HI (49684) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GL1H_PERFCOUNTER0_LO (49706) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GL1H_PERFCOUNTER0_HI (49727) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GL1H_PERFCOUNTER1_LO (49748) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GL1H_PERFCOUNTER1_HI (49769) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GL1H_PERFCOUNTER2_LO (49790) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GL1H_PERFCOUNTER2_HI (49811) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GL1H_PERFCOUNTER3_LO (49832) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GL1H_PERFCOUNTER3_HI (49853) */
	'C', 'P', 'C', '_', 'T', 'C', '_', 'P', 'E', 'R', 'F', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPC_TC_PERF_COUNTER_WINDOW_SELECT (49874) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '4', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_SE4_PERFCOUNTER_SELECT (49908) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '5', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_SE5_PERFCOUNTER_SELECT (49936) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '6', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_SE6_PERFCOUNTER_SELECT (49964) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PC_PERFCOUNTER2_SELECT (49992) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PC_PERFCOUNTER3_SELECT (50015) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PC_PERFCOUNTER1_SELECT1 (50038) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PC_PERFCOUNTER2_SELECT1 (50062) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PC_PERFCOUNTER3_SELECT1 (50086) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQG_PERFCOUNTER0_SELECT (50110) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQG_PERFCOUNTER1_SELECT (50134) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQG_PERFCOUNTER2_SELECT (50158) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQG_PERFCOUNTER3_SELECT (50182) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQG_PERFCOUNTER4_SELECT (50206) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQG_PERFCOUNTER5_SELECT (50230) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQG_PERFCOUNTER6_SELECT (50254) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQG_PERFCOUNTER7_SELECT (50278) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'C', 'T', 'R', 'L', '\0', /* SQG_PERFCOUNTER_CTRL (50302) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'C', 'T', 'R', 'L', '2', '\0', /* SQG_PERFCOUNTER_CTRL2 (50323) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'F', 'I', 'N', 'I', 'S', 'H', '\0', /* SQG_PERF_SAMPLE_FINISH (50345) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'A', 'U', 'S', 'E', '\0', /* RLC_SPM_PAUSE (50368, 50376) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* RLC_SPM_STATUS (50382) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'M', 'O', 'D', 'E', '\0', /* RLC_SPM_MODE (50397, 50401) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'Q', '_', 'D', 'A', 'T', 'A', '_', 'L', 'O', '\0', /* RLC_SPM_RSPM_REQ_DATA_LO (50410) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'Q', '_', 'D', 'A', 'T', 'A', '_', 'H', 'I', '\0', /* RLC_SPM_RSPM_REQ_DATA_HI (50435) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'Q', '_', 'O', 'P', '\0', /* RLC_SPM_RSPM_REQ_OP (50460) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'T', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_RSPM_RET_DATA (50480) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'T', '_', 'O', 'P', '\0', /* RLC_SPM_RSPM_RET_OP (50502) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'Q', '_', 'D', 'A', 'T', 'A', '_', 'L', 'O', '\0', /* RLC_SPM_SE_RSPM_REQ_DATA_LO (50522) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'Q', '_', 'D', 'A', 'T', 'A', '_', 'H', 'I', '\0', /* RLC_SPM_SE_RSPM_REQ_DATA_HI (50550) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'Q', '_', 'O', 'P', '\0', /* RLC_SPM_SE_RSPM_REQ_OP (50578) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'T', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_SE_RSPM_RET_DATA (50601) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'T', '_', 'O', 'P', '\0', /* RLC_SPM_SE_RSPM_RET_OP (50626) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'S', 'P', 'M', '_', 'C', 'M', 'D', '\0', /* RLC_SPM_RSPM_CMD (50649, 50662) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'S', 'P', 'M', '_', 'C', 'M', 'D', '_', 'A', 'C', 'K', '\0', /* RLC_SPM_RSPM_CMD_ACK (50666) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'P', 'A', 'R', 'E', '\0', /* RLC_SPM_SPARE (50687) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* UTCL1_PERFCOUNTER2_SELECT (50701) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* UTCL1_PERFCOUNTER3_SELECT (50727) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1H_PERFCOUNTER0_SELECT (50753) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL1H_PERFCOUNTER0_SELECT1 (50778) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1H_PERFCOUNTER1_SELECT (50804) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1H_PERFCOUNTER2_SELECT (50829) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1H_PERFCOUNTER3_SELECT (50854) */
	'A', 'C', 'Q', 'U', 'I', 'R', 'E', '_', 'M', 'E', 'M', '_', 'P', 'W', 'S', '_', '2', '\0', /* ACQUIRE_MEM_PWS_2 (50879) */
	'A', 'C', 'Q', 'U', 'I', 'R', 'E', '_', 'M', 'E', 'M', '_', 'P', 'W', 'S', '_', '7', '\0', /* ACQUIRE_MEM_PWS_7 (50897) */
	'D', 'B', '_', 'S', 'P', 'I', '_', 'V', 'R', 'S', '_', 'C', 'E', 'N', 'T', 'E', 'R', '_', 'L', 'O', 'C', 'A', 'T', 'I', 'O', 'N', '\0', /* DB_SPI_VRS_CENTER_LOCATION (50915) */
	'S', 'P', 'I', '_', 'B', 'A', 'R', 'Y', 'C', '_', 'S', 'S', 'A', 'A', '_', 'C', 'N', 'T', 'L', '\0', /* SPI_BARYC_SSAA_CNTL (50942) */
	'P', 'A', '_', 'S', 'C', '_', 'B', 'I', 'N', 'N', 'E', 'R', '_', 'O', 'U', 'T', 'P', 'U', 'T', '_', 'T', 'I', 'M', 'E', 'O', 'U', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_BINNER_OUTPUT_TIMEOUT_CNTL (50962) */
	'G', 'C', 'L', '2', 'T', 'L', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GCL2TLB_PERFCOUNTER_LO (50995) */
	'G', 'C', 'L', '2', 'T', 'L', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GCL2TLB_PERFCOUNTER_HI (51018) */
	'G', 'C', 'L', '2', 'T', 'L', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* GCL2TLB_PERFCOUNTER0_CFG (51041) */
	'G', 'C', 'L', '2', 'T', 'L', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* GCL2TLB_PERFCOUNTER1_CFG (51066) */
	'G', 'C', 'L', '2', 'T', 'L', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'C', 'F', 'G', '\0', /* GCL2TLB_PERFCOUNTER2_CFG (51091) */
	'G', 'C', 'L', '2', 'T', 'L', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'C', 'F', 'G', '\0', /* GCL2TLB_PERFCOUNTER3_CFG (51116) */
	'G', 'C', 'L', '2', 'T', 'L', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GCL2TLB_PERFCOUNTER_RSLT_CNTL (51141) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'H', 'W', '_', 'I', 'D', '\0', /* SQ_WAVE_HW_ID (51171) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'I', 'N', 'S', 'T', '_', 'D', 'W', '1', '\0', /* SQ_WAVE_INST_DW1 (51185) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'I', 'B', '_', 'D', 'B', 'G', '0', '\0', /* SQ_WAVE_IB_DBG0 (51202) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'B', 'A', '_', 'L', 'O', '\0', /* SQ_WAVE_TBA_LO (51218) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'B', 'A', '_', 'H', 'I', '\0', /* SQ_WAVE_TBA_HI (51233) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'M', 'A', '_', 'L', 'O', '\0', /* SQ_WAVE_TMA_LO (51248) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'M', 'A', '_', 'H', 'I', '\0', /* SQ_WAVE_TMA_HI (51263) */
	'S', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '2', '\0', /* SRBM_STATUS2 (51278) */
	'S', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* SRBM_STATUS (51291) */
	'S', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '3', '\0', /* SRBM_STATUS3 (51303) */
	'G', 'R', 'B', 'M', '_', 'C', 'N', 'T', 'L', '\0', /* GRBM_CNTL (51316) */
	'G', 'R', 'B', 'M', '_', 'S', 'K', 'E', 'W', '_', 'C', 'N', 'T', 'L', '\0', /* GRBM_SKEW_CNTL (51326) */
	'G', 'R', 'B', 'M', '_', 'P', 'W', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* GRBM_PWR_CNTL (51341) */
	'G', 'R', 'B', 'M', '_', 'S', 'O', 'F', 'T', '_', 'R', 'E', 'S', 'E', 'T', '\0', /* GRBM_SOFT_RESET (51355) */
	'G', 'R', 'B', 'M', '_', 'D', 'E', 'B', 'U', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* GRBM_DEBUG_CNTL (51371) */
	'G', 'R', 'B', 'M', '_', 'D', 'E', 'B', 'U', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* GRBM_DEBUG_DATA (51387) */
	'G', 'R', 'B', 'M', '_', 'G', 'F', 'X', '_', 'C', 'L', 'K', 'E', 'N', '_', 'C', 'N', 'T', 'L', '\0', /* GRBM_GFX_CLKEN_CNTL (51403) */
	'G', 'R', 'B', 'M', '_', 'W', 'A', 'I', 'T', '_', 'I', 'D', 'L', 'E', '_', 'C', 'L', 'O', 'C', 'K', 'S', '\0', /* GRBM_WAIT_IDLE_CLOCKS (51423, 51428) */
	'G', 'R', 'B', 'M', '_', 'D', 'E', 'B', 'U', 'G', '\0', /* GRBM_DEBUG (51445) */
	'G', 'R', 'B', 'M', '_', 'D', 'E', 'B', 'U', 'G', '_', 'S', 'N', 'A', 'P', 'S', 'H', 'O', 'T', '\0', /* GRBM_DEBUG_SNAPSHOT (51456) */
	'G', 'R', 'B', 'M', '_', 'R', 'E', 'A', 'D', '_', 'E', 'R', 'R', 'O', 'R', '\0', /* GRBM_READ_ERROR (51476, 51481) */
	'G', 'R', 'B', 'M', '_', 'I', 'N', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GRBM_INT_CNTL (51492) */
	'D', 'E', 'B', 'U', 'G', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* DEBUG_INDEX (51506) */
	'G', 'R', 'B', 'M', '_', 'N', 'O', 'W', 'H', 'E', 'R', 'E', '\0', /* GRBM_NOWHERE (51518) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '0', '\0', /* GRBM_SCRATCH_REG0 (51531) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '1', '\0', /* GRBM_SCRATCH_REG1 (51549) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '2', '\0', /* GRBM_SCRATCH_REG2 (51567) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '3', '\0', /* GRBM_SCRATCH_REG3 (51585) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '4', '\0', /* GRBM_SCRATCH_REG4 (51603) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '5', '\0', /* GRBM_SCRATCH_REG5 (51621) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '6', '\0', /* GRBM_SCRATCH_REG6 (51639) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '7', '\0', /* GRBM_SCRATCH_REG7 (51657) */
	'S', 'Q', '_', 'I', 'N', 'T', 'E', 'R', 'R', 'U', 'P', 'T', '_', 'W', 'O', 'R', 'D', '_', 'A', 'U', 'T', 'O', '\0', /* SQ_INTERRUPT_WORD_AUTO (51675) */
	'C', 'P', '_', 'S', 'T', 'A', 'L', 'L', 'E', 'D', '_', 'S', 'T', 'A', 'T', '3', '\0', /* CP_STALLED_STAT3 (51698) */
	'C', 'P', '_', 'S', 'T', 'A', 'L', 'L', 'E', 'D', '_', 'S', 'T', 'A', 'T', '1', '\0', /* CP_STALLED_STAT1 (51715) */
	'C', 'P', '_', 'S', 'T', 'A', 'L', 'L', 'E', 'D', '_', 'S', 'T', 'A', 'T', '2', '\0', /* CP_STALLED_STAT2 (51732) */
	'C', 'P', '_', 'B', 'U', 'S', 'Y', '_', 'S', 'T', 'A', 'T', '\0', /* CP_BUSY_STAT (51749) */
	'C', 'P', '_', 'S', 'T', 'A', 'T', '\0', /* CP_STAT (51762) */
	'C', 'P', '_', 'M', 'E', '_', 'H', 'E', 'A', 'D', 'E', 'R', '_', 'D', 'U', 'M', 'P', '\0', /* CP_ME_HEADER_DUMP (51770) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'H', 'E', 'A', 'D', 'E', 'R', '_', 'D', 'U', 'M', 'P', '\0', /* CP_PFP_HEADER_DUMP (51788) */
	'C', 'P', '_', 'G', 'R', 'B', 'M', '_', 'F', 'R', 'E', 'E', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* CP_GRBM_FREE_COUNT (51807) */
	'C', 'P', '_', 'C', 'E', '_', 'H', 'E', 'A', 'D', 'E', 'R', '_', 'D', 'U', 'M', 'P', '\0', /* CP_CE_HEADER_DUMP (51826) */
	'C', 'P', '_', 'M', 'C', '_', 'P', 'A', 'C', 'K', '_', 'D', 'E', 'L', 'A', 'Y', '_', 'C', 'N', 'T', '\0', /* CP_MC_PACK_DELAY_CNT (51844, 51850) */
	'C', 'P', '_', 'C', 'S', 'F', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CSF_STAT (51865) */
	'C', 'P', '_', 'C', 'S', 'F', '_', 'C', 'N', 'T', 'L', '\0', /* CP_CSF_CNTL (51877) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* CP_ME_CNTL (51889) */
	'C', 'P', '_', 'C', 'N', 'T', 'X', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CNTX_STAT (51900) */
	'C', 'P', '_', 'M', 'E', '_', 'P', 'R', 'E', 'E', 'M', 'P', 'T', 'I', 'O', 'N', '\0', /* CP_ME_PREEMPTION (51913) */
	'C', 'P', '_', 'R', 'B', '2', '_', 'R', 'P', 'T', 'R', '\0', /* CP_RB2_RPTR (51930) */
	'C', 'P', '_', 'R', 'B', '1', '_', 'R', 'P', 'T', 'R', '\0', /* CP_RB1_RPTR (51942) */
	'C', 'P', '_', 'R', 'B', '0', '_', 'R', 'P', 'T', 'R', '\0', /* CP_RB0_RPTR (51954) */
	'C', 'P', '_', 'R', 'B', '_', 'W', 'P', 'T', 'R', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* CP_RB_WPTR_DELAY (51966) */
	'C', 'P', '_', 'R', 'B', '_', 'W', 'P', 'T', 'R', '_', 'P', 'O', 'L', 'L', '_', 'C', 'N', 'T', 'L', '\0', /* CP_RB_WPTR_POLL_CNTL (51983) */
	'C', 'P', '_', 'R', 'O', 'Q', '1', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', 'S', '\0', /* CP_ROQ1_THRESHOLDS (52004) */
	'C', 'P', '_', 'R', 'O', 'Q', '2', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', 'S', '\0', /* CP_ROQ2_THRESHOLDS (52023) */
	'C', 'P', '_', 'S', 'T', 'Q', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', 'S', '\0', /* CP_STQ_THRESHOLDS (52042) */
	'C', 'P', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', 'S', '\0', /* CP_QUEUE_THRESHOLDS (52060) */
	'C', 'P', '_', 'M', 'E', 'Q', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', 'S', '\0', /* CP_MEQ_THRESHOLDS (52080) */
	'C', 'P', '_', 'R', 'O', 'Q', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* CP_ROQ_AVAIL (52098) */
	'C', 'P', '_', 'S', 'T', 'Q', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* CP_STQ_AVAIL (52111) */
	'C', 'P', '_', 'R', 'O', 'Q', '2', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* CP_ROQ2_AVAIL (52124) */
	'C', 'P', '_', 'M', 'E', 'Q', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* CP_MEQ_AVAIL (52138) */
	'C', 'P', '_', 'C', 'M', 'D', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* CP_CMD_INDEX (52151, 52154) */
	'C', 'P', '_', 'C', 'M', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* CP_CMD_DATA (52164) */
	'C', 'P', '_', 'R', 'O', 'Q', '_', 'R', 'B', '_', 'S', 'T', 'A', 'T', '\0', /* CP_ROQ_RB_STAT (52176) */
	'C', 'P', '_', 'R', 'O', 'Q', '_', 'I', 'B', '1', '_', 'S', 'T', 'A', 'T', '\0', /* CP_ROQ_IB1_STAT (52191) */
	'C', 'P', '_', 'R', 'O', 'Q', '_', 'I', 'B', '2', '_', 'S', 'T', 'A', 'T', '\0', /* CP_ROQ_IB2_STAT (52207) */
	'C', 'P', '_', 'S', 'T', 'Q', '_', 'S', 'T', 'A', 'T', '\0', /* CP_STQ_STAT (52223) */
	'C', 'P', '_', 'M', 'E', 'Q', '_', 'S', 'T', 'A', 'T', '\0', /* CP_MEQ_STAT (52235) */
	'C', 'P', '_', 'C', 'E', 'Q', '1', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* CP_CEQ1_AVAIL (52247) */
	'C', 'P', '_', 'C', 'E', 'Q', '2', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* CP_CEQ2_AVAIL (52261) */
	'C', 'P', '_', 'C', 'E', '_', 'R', 'O', 'Q', '_', 'R', 'B', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CE_ROQ_RB_STAT (52275) */
	'C', 'P', '_', 'C', 'E', '_', 'R', 'O', 'Q', '_', 'I', 'B', '1', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CE_ROQ_IB1_STAT (52293) */
	'C', 'P', '_', 'C', 'E', '_', 'R', 'O', 'Q', '_', 'I', 'B', '2', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CE_ROQ_IB2_STAT (52312) */
	'C', 'P', '_', 'I', 'N', 'T', '_', 'S', 'T', 'A', 'T', '_', 'D', 'E', 'B', 'U', 'G', '\0', /* CP_INT_STAT_DEBUG (52331) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* IA_PERFCOUNTER0_SELECT (52349) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* IA_PERFCOUNTER1_SELECT (52372) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* IA_PERFCOUNTER2_SELECT (52395) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* IA_PERFCOUNTER3_SELECT (52418) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* IA_PERFCOUNTER0_LO (52441) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* IA_PERFCOUNTER0_HI (52460) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* IA_PERFCOUNTER1_LO (52479) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* IA_PERFCOUNTER1_HI (52498) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* IA_PERFCOUNTER2_LO (52517) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* IA_PERFCOUNTER2_HI (52536) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* IA_PERFCOUNTER3_LO (52555) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* IA_PERFCOUNTER3_HI (52574) */
	'V', 'G', 'T', '_', 'V', 'T', 'X', '_', 'V', 'E', 'C', 'T', '_', 'E', 'J', 'E', 'C', 'T', '_', 'R', 'E', 'G', '\0', /* VGT_VTX_VECT_EJECT_REG (52593) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'D', 'A', 'T', 'A', '_', 'F', 'I', 'F', 'O', '_', 'D', 'E', 'P', 'T', 'H', '\0', /* VGT_DMA_DATA_FIFO_DEPTH (52616, 52620) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'R', 'E', 'Q', '_', 'F', 'I', 'F', 'O', '_', 'D', 'E', 'P', 'T', 'H', '\0', /* VGT_DMA_REQ_FIFO_DEPTH (52640, 52644) */
	'V', 'G', 'T', '_', 'D', 'R', 'A', 'W', '_', 'I', 'N', 'I', 'T', '_', 'F', 'I', 'F', 'O', '_', 'D', 'E', 'P', 'T', 'H', '\0', /* VGT_DRAW_INIT_FIFO_DEPTH (52663, 52667) */
	'V', 'G', 'T', '_', 'L', 'A', 'S', 'T', '_', 'C', 'O', 'P', 'Y', '_', 'S', 'T', 'A', 'T', 'E', '\0', /* VGT_LAST_COPY_STATE (52688) */
	'V', 'G', 'T', '_', 'C', 'A', 'C', 'H', 'E', '_', 'I', 'N', 'V', 'A', 'L', 'I', 'D', 'A', 'T', 'I', 'O', 'N', '\0', /* VGT_CACHE_INVALIDATION (52708, 52712) */
	'V', 'G', 'T', '_', 'F', 'I', 'F', 'O', '_', 'D', 'E', 'P', 'T', 'H', 'S', '\0', /* VGT_FIFO_DEPTHS (52731) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'V', 'E', 'R', 'T', 'E', 'X', '_', 'R', 'E', 'U', 'S', 'E', '\0', /* VGT_GS_VERTEX_REUSE (52747) */
	'V', 'G', 'T', '_', 'M', 'C', '_', 'L', 'A', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_MC_LAT_CNTL (52767) */
	'I', 'A', '_', 'C', 'N', 'T', 'L', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* IA_CNTL_STATUS (52783) */
	'V', 'G', 'T', '_', 'D', 'E', 'B', 'U', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_DEBUG_CNTL (52798) */
	'V', 'G', 'T', '_', 'D', 'E', 'B', 'U', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* VGT_DEBUG_DATA (52813) */
	'I', 'A', '_', 'D', 'E', 'B', 'U', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* IA_DEBUG_CNTL (52828) */
	'I', 'A', '_', 'D', 'E', 'B', 'U', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* IA_DEBUG_DATA (52842) */
	'V', 'G', 'T', '_', 'C', 'N', 'T', 'L', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* VGT_CNTL_STATUS (52856) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'I', 'D', '_', 'M', 'A', 'S', 'K', '\0', /* VGT_PERFCOUNTER_SEID_MASK (52872) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* VGT_PERFCOUNTER0_SELECT (52898) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* VGT_PERFCOUNTER1_SELECT (52922) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* VGT_PERFCOUNTER2_SELECT (52946) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* VGT_PERFCOUNTER3_SELECT (52970) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* VGT_PERFCOUNTER0_LO (52994) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* VGT_PERFCOUNTER0_HI (53014) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* VGT_PERFCOUNTER1_LO (53034) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* VGT_PERFCOUNTER1_HI (53054) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* VGT_PERFCOUNTER2_LO (53074) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* VGT_PERFCOUNTER2_HI (53094) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* VGT_PERFCOUNTER3_LO (53114) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* VGT_PERFCOUNTER3_HI (53134) */
	'C', 'G', 'T', 'T', '_', 'V', 'G', 'T', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* CGTT_VGT_CLK_CTRL (53154) */
	'I', 'A', '_', 'V', 'M', 'I', 'D', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* IA_VMID_OVERRIDE (53172) */
	'C', 'G', 'T', 'T', '_', 'I', 'A', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* CGTT_IA_CLK_CTRL (53189) */
	'V', 'G', 'T', '_', 'S', 'Y', 'S', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* VGT_SYS_CONFIG (53206) */
	'C', 'C', '_', 'G', 'C', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'A', 'R', 'R', 'A', 'Y', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* CC_GC_SHADER_ARRAY_CONFIG (53221) */
	'G', 'C', '_', 'U', 'S', 'E', 'R', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'A', 'R', 'R', 'A', 'Y', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* GC_USER_SHADER_ARRAY_CONFIG (53247) */
	'P', 'A', '_', 'S', 'U', '_', 'D', 'E', 'B', 'U', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_DEBUG_CNTL (53275) */
	'P', 'A', '_', 'S', 'U', '_', 'D', 'E', 'B', 'U', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* PA_SU_DEBUG_DATA (53292) */
	'P', 'A', '_', 'C', 'L', '_', 'C', 'N', 'T', 'L', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* PA_CL_CNTL_STATUS (53309) */
	'P', 'A', '_', 'C', 'L', '_', 'E', 'N', 'H', 'A', 'N', 'C', 'E', '\0', /* PA_CL_ENHANCE (53327) */
	'C', 'G', 'T', 'T', '_', 'P', 'A', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* CGTT_PA_CLK_CTRL (53341) */
	'P', 'A', '_', 'S', 'U', '_', 'C', 'N', 'T', 'L', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* PA_SU_CNTL_STATUS (53358) */
	'P', 'A', '_', 'S', 'C', '_', 'F', 'I', 'F', 'O', '_', 'D', 'E', 'P', 'T', 'H', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_FIFO_DEPTH_CNTL (53376) */
	'P', 'A', '_', 'S', 'C', '_', 'F', 'O', 'R', 'C', 'E', '_', 'E', 'O', 'V', '_', 'M', 'A', 'X', '_', 'C', 'N', 'T', 'S', '\0', /* PA_SC_FORCE_EOV_MAX_CNTS (53398) */
	'C', 'G', 'T', 'T', '_', 'S', 'C', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* CGTT_SC_CLK_CTRL (53423) */
	'P', 'A', '_', 'S', 'C', '_', 'F', 'I', 'F', 'O', '_', 'S', 'I', 'Z', 'E', '\0', /* PA_SC_FIFO_SIZE (53440) */
	'P', 'A', '_', 'S', 'C', '_', 'I', 'F', '_', 'F', 'I', 'F', 'O', '_', 'S', 'I', 'Z', 'E', '\0', /* PA_SC_IF_FIFO_SIZE (53456) */
	'P', 'A', '_', 'S', 'C', '_', 'D', 'E', 'B', 'U', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_DEBUG_CNTL (53475) */
	'P', 'A', '_', 'S', 'C', '_', 'D', 'E', 'B', 'U', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* PA_SC_DEBUG_DATA (53492) */
	'P', 'A', '_', 'S', 'C', '_', 'E', 'N', 'H', 'A', 'N', 'C', 'E', '\0', /* PA_SC_ENHANCE (53509) */
	'S', 'Q', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* SQ_CONFIG (53523) */
	'S', 'Q', 'C', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* SQC_CONFIG (53533) */
	'S', 'Q', '_', 'R', 'A', 'N', 'D', 'O', 'M', '_', 'W', 'A', 'V', 'E', '_', 'P', 'R', 'I', '\0', /* SQ_RANDOM_WAVE_PRI (53544) */
	'S', 'Q', '_', 'R', 'E', 'G', '_', 'C', 'R', 'E', 'D', 'I', 'T', 'S', '\0', /* SQ_REG_CREDITS (53563) */
	'S', 'Q', '_', 'F', 'I', 'F', 'O', '_', 'S', 'I', 'Z', 'E', 'S', '\0', /* SQ_FIFO_SIZES (53578) */
	'C', 'C', '_', 'S', 'Q', 'C', '_', 'B', 'A', 'N', 'K', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* CC_SQC_BANK_DISABLE (53592) */
	'U', 'S', 'E', 'R', '_', 'S', 'Q', 'C', '_', 'B', 'A', 'N', 'K', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* USER_SQC_BANK_DISABLE (53612) */
	'S', 'Q', '_', 'D', 'E', 'B', 'U', 'G', '_', 'S', 'T', 'S', '_', 'G', 'L', 'O', 'B', 'A', 'L', '\0', /* SQ_DEBUG_STS_GLOBAL (53634) */
	'S', 'Q', '_', 'A', 'L', 'U', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* SQ_ALU_CLK_CTRL (53654) */
	'S', 'Q', '_', 'T', 'E', 'X', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* SQ_TEX_CLK_CTRL (53670) */
	'C', 'G', 'T', 'T', '_', 'S', 'Q', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* CGTT_SQ_CLK_CTRL (53686) */
	'C', 'G', 'T', 'T', '_', 'S', 'Q', 'G', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* CGTT_SQG_CLK_CTRL (53703) */
	'S', 'Q', '_', 'I', 'N', 'D', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* SQ_IND_INDEX (53721) */
	'S', 'Q', '_', 'I', 'N', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* SQ_IND_DATA (53734) */
	'S', 'Q', '_', 'T', 'I', 'M', 'E', '_', 'H', 'I', '\0', /* SQ_TIME_HI (53746) */
	'S', 'Q', '_', 'T', 'I', 'M', 'E', '_', 'L', 'O', '\0', /* SQ_TIME_LO (53757) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'A', 'S', 'E', '\0', /* SQ_THREAD_TRACE_BASE (53768) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'S', 'I', 'Z', 'E', '\0', /* SQ_THREAD_TRACE_SIZE (53789) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'P', 'E', 'R', 'F', '_', 'M', 'A', 'S', 'K', '\0', /* SQ_THREAD_TRACE_PERF_MASK (53810) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'M', 'O', 'D', 'E', '\0', /* SQ_THREAD_TRACE_MODE (53836) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'C', 'N', 'T', 'R', '\0', /* SQ_THREAD_TRACE_CNTR (53857) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'H', 'I', 'W', 'A', 'T', 'E', 'R', '\0', /* SQ_THREAD_TRACE_HIWATER (53878, 53894) */
	'S', 'Q', '_', 'P', 'O', 'W', 'E', 'R', '_', 'T', 'H', 'R', 'O', 'T', 'T', 'L', 'E', '\0', /* SQ_POWER_THROTTLE (53902) */
	'S', 'Q', '_', 'P', 'O', 'W', 'E', 'R', '_', 'T', 'H', 'R', 'O', 'T', 'T', 'L', 'E', '2', '\0', /* SQ_POWER_THROTTLE2 (53920) */
	'S', 'Q', '_', 'L', 'B', '_', 'C', 'T', 'R', '_', 'C', 'T', 'R', 'L', '\0', /* SQ_LB_CTR_CTRL (53939) */
	'S', 'Q', '_', 'L', 'B', '_', 'D', 'A', 'T', 'A', '_', 'A', 'L', 'U', '_', 'C', 'Y', 'C', 'L', 'E', 'S', '\0', /* SQ_LB_DATA_ALU_CYCLES (53954) */
	'S', 'Q', '_', 'L', 'B', '_', 'D', 'A', 'T', 'A', '_', 'T', 'E', 'X', '_', 'C', 'Y', 'C', 'L', 'E', 'S', '\0', /* SQ_LB_DATA_TEX_CYCLES (53976) */
	'S', 'Q', '_', 'L', 'B', '_', 'D', 'A', 'T', 'A', '_', 'A', 'L', 'U', '_', 'S', 'T', 'A', 'L', 'L', 'S', '\0', /* SQ_LB_DATA_ALU_STALLS (53998) */
	'S', 'Q', '_', 'L', 'B', '_', 'D', 'A', 'T', 'A', '_', 'T', 'E', 'X', '_', 'S', 'T', 'A', 'L', 'L', 'S', '\0', /* SQ_LB_DATA_TEX_STALLS (54020) */
	'S', 'Q', 'C', '_', 'S', 'E', 'C', 'D', 'E', 'D', '_', 'C', 'N', 'T', '\0', /* SQC_SECDED_CNT (54042) */
	'S', 'Q', '_', 'S', 'E', 'C', '_', 'C', 'N', 'T', '\0', /* SQ_SEC_CNT (54057) */
	'S', 'Q', '_', 'D', 'E', 'D', '_', 'C', 'N', 'T', '\0', /* SQ_DED_CNT (54068) */
	'S', 'Q', '_', 'D', 'E', 'D', '_', 'I', 'N', 'F', 'O', '\0', /* SQ_DED_INFO (54079) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'L', 'O', '_', 'P', 'S', '\0', /* SPI_SHADER_TBA_LO_PS (54091) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'H', 'I', '_', 'P', 'S', '\0', /* SPI_SHADER_TBA_HI_PS (54112) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'L', 'O', '_', 'P', 'S', '\0', /* SPI_SHADER_TMA_LO_PS (54133) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'H', 'I', '_', 'P', 'S', '\0', /* SPI_SHADER_TMA_HI_PS (54154) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'L', 'O', '_', 'V', 'S', '\0', /* SPI_SHADER_TBA_LO_VS (54175) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'H', 'I', '_', 'V', 'S', '\0', /* SPI_SHADER_TBA_HI_VS (54196) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'L', 'O', '_', 'V', 'S', '\0', /* SPI_SHADER_TMA_LO_VS (54217) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'H', 'I', '_', 'V', 'S', '\0', /* SPI_SHADER_TMA_HI_VS (54238) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'L', 'O', '_', 'G', 'S', '\0', /* SPI_SHADER_TBA_LO_GS (54259) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'H', 'I', '_', 'G', 'S', '\0', /* SPI_SHADER_TBA_HI_GS (54280) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'L', 'O', '_', 'G', 'S', '\0', /* SPI_SHADER_TMA_LO_GS (54301) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'H', 'I', '_', 'G', 'S', '\0', /* SPI_SHADER_TMA_HI_GS (54322) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'L', 'O', '_', 'E', 'S', '\0', /* SPI_SHADER_TBA_LO_ES (54343) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'H', 'I', '_', 'E', 'S', '\0', /* SPI_SHADER_TBA_HI_ES (54364) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'L', 'O', '_', 'E', 'S', '\0', /* SPI_SHADER_TMA_LO_ES (54385) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'H', 'I', '_', 'E', 'S', '\0', /* SPI_SHADER_TMA_HI_ES (54406) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'L', 'O', '_', 'H', 'S', '\0', /* SPI_SHADER_TBA_LO_HS (54427) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'H', 'I', '_', 'H', 'S', '\0', /* SPI_SHADER_TBA_HI_HS (54448) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'L', 'O', '_', 'H', 'S', '\0', /* SPI_SHADER_TMA_LO_HS (54469) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'H', 'I', '_', 'H', 'S', '\0', /* SPI_SHADER_TMA_HI_HS (54490) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'L', 'O', '_', 'L', 'S', '\0', /* SPI_SHADER_TBA_LO_LS (54511) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'H', 'I', '_', 'L', 'S', '\0', /* SPI_SHADER_TBA_HI_LS (54532) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'L', 'O', '_', 'L', 'S', '\0', /* SPI_SHADER_TMA_LO_LS (54553) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'H', 'I', '_', 'L', 'S', '\0', /* SPI_SHADER_TMA_HI_LS (54574) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'M', 'A', 'X', '_', 'W', 'A', 'V', 'E', '_', 'I', 'D', '\0', /* COMPUTE_MAX_WAVE_ID (54595, 54603, 54607) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'B', 'A', '_', 'L', 'O', '\0', /* COMPUTE_TBA_LO (54615) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'B', 'A', '_', 'H', 'I', '\0', /* COMPUTE_TBA_HI (54630) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'M', 'A', '_', 'L', 'O', '\0', /* COMPUTE_TMA_LO (54645) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'M', 'A', '_', 'H', 'I', '\0', /* COMPUTE_TMA_HI (54660) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '0', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE0 (54675) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '1', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE1 (54706) */
	'S', 'D', 'M', 'A', '0', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'R', 'E', 'G', '\0', /* SDMA0_STATUS_REG (54737) */
	'S', 'D', 'M', 'A', '1', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'R', 'E', 'G', '\0', /* SDMA1_STATUS_REG (54754) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'I', 'N', 'F', 'O', '\0', /* DB_DEPTH_INFO (54771) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'S', 'I', 'Z', 'E', '\0', /* DB_DEPTH_SIZE (54785) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* DB_DEPTH_SLICE (54799) */
	'C', 'P', '_', 'R', 'I', 'N', 'G', 'I', 'D', '\0', /* CP_RINGID (54814, 54817) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'M', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* CP_CPC_MC_CNTL (54824) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'A', 'S', 'E', '2', '\0', /* SQ_THREAD_TRACE_BASE2 (54839) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'T', 'O', 'K', 'E', 'N', '_', 'M', 'A', 'S', 'K', '2', '\0', /* SQ_THREAD_TRACE_TOKEN_MASK2 (54861) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '2', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE2 (54889) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '3', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE3 (54920) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* WD_PERFCOUNTER0_LO (54951) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* WD_PERFCOUNTER0_HI (54970) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* WD_PERFCOUNTER1_LO (54989) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* WD_PERFCOUNTER1_HI (55008) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* WD_PERFCOUNTER2_LO (55027) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* WD_PERFCOUNTER2_HI (55046) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* WD_PERFCOUNTER3_LO (55065) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* WD_PERFCOUNTER3_HI (55084) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* TCC_PERFCOUNTER0_LO (55103) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* TCC_PERFCOUNTER0_HI (55123) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* TCC_PERFCOUNTER1_LO (55143) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* TCC_PERFCOUNTER1_HI (55163) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* TCC_PERFCOUNTER2_LO (55183) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* TCC_PERFCOUNTER2_HI (55203) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* TCC_PERFCOUNTER3_LO (55223) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* TCC_PERFCOUNTER3_HI (55243) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* TCA_PERFCOUNTER0_LO (55263) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* TCA_PERFCOUNTER0_HI (55283) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* TCA_PERFCOUNTER1_LO (55303) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* TCA_PERFCOUNTER1_HI (55323) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* TCA_PERFCOUNTER2_LO (55343) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* TCA_PERFCOUNTER2_HI (55363) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* TCA_PERFCOUNTER3_LO (55383) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* TCA_PERFCOUNTER3_HI (55403) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* TCS_PERFCOUNTER0_LO (55423) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* TCS_PERFCOUNTER0_HI (55443) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* TCS_PERFCOUNTER1_LO (55463) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* TCS_PERFCOUNTER1_HI (55483) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* TCS_PERFCOUNTER2_LO (55503) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* TCS_PERFCOUNTER2_HI (55523) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* TCS_PERFCOUNTER3_LO (55543) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* TCS_PERFCOUNTER3_HI (55563) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* WD_PERFCOUNTER0_SELECT (55583) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* WD_PERFCOUNTER1_SELECT (55606) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* WD_PERFCOUNTER2_SELECT (55629) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* WD_PERFCOUNTER3_SELECT (55652) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* IA_PERFCOUNTER0_SELECT1 (55675) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* VGT_PERFCOUNTER0_SELECT1 (55699) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* VGT_PERFCOUNTER1_SELECT1 (55724) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'M', 'A', 'S', 'K', '\0', /* SQ_PERFCOUNTER_MASK (55749) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCC_PERFCOUNTER0_SELECT (55769) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCC_PERFCOUNTER0_SELECT1 (55793) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCC_PERFCOUNTER1_SELECT (55818) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCC_PERFCOUNTER1_SELECT1 (55842) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCC_PERFCOUNTER2_SELECT (55867) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCC_PERFCOUNTER3_SELECT (55891) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCA_PERFCOUNTER0_SELECT (55915) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCA_PERFCOUNTER0_SELECT1 (55939) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCA_PERFCOUNTER1_SELECT (55964) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCA_PERFCOUNTER1_SELECT1 (55988) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCA_PERFCOUNTER2_SELECT (56013) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCA_PERFCOUNTER3_SELECT (56037) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCS_PERFCOUNTER0_SELECT (56061) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCS_PERFCOUNTER0_SELECT1 (56085) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCS_PERFCOUNTER1_SELECT (56110) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCS_PERFCOUNTER2_SELECT (56134) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCS_PERFCOUNTER3_SELECT (56158) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_CPG_PERFMON_SAMPLE_DELAY (56182, 56194) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_CPC_PERFMON_SAMPLE_DELAY (56215) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_CPF_PERFMON_SAMPLE_DELAY (56248) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'C', 'B', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_CB_PERFMON_SAMPLE_DELAY (56281) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'D', 'B', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_DB_PERFMON_SAMPLE_DELAY (56313) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'A', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_PA_PERFMON_SAMPLE_DELAY (56345) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_GDS_PERFMON_SAMPLE_DELAY (56377) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'I', 'A', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_IA_PERFMON_SAMPLE_DELAY (56410) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_SC_PERFMON_SAMPLE_DELAY (56442) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_TCC_PERFMON_SAMPLE_DELAY (56474) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_TCA_PERFMON_SAMPLE_DELAY (56507) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_TCP_PERFMON_SAMPLE_DELAY (56540) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'T', 'A', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_TA_PERFMON_SAMPLE_DELAY (56573) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'T', 'D', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_TD_PERFMON_SAMPLE_DELAY (56605) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_VGT_PERFMON_SAMPLE_DELAY (56637) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_SPI_PERFMON_SAMPLE_DELAY (56670) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_SQG_PERFMON_SAMPLE_DELAY (56703) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_TCS_PERFMON_SAMPLE_DELAY (56736) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'X', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_SX_PERFMON_SAMPLE_DELAY (56769) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'D', 'B', 'R', '0', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_DBR0_PERFMON_SAMPLE_DELAY (56801) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'D', 'B', 'R', '1', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_DBR1_PERFMON_SAMPLE_DELAY (56835) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'C', 'B', 'R', '0', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_CBR0_PERFMON_SAMPLE_DELAY (56869) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'C', 'B', 'R', '1', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_CBR1_PERFMON_SAMPLE_DELAY (56903) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'W', 'A', 'V', 'E', '_', 'R', 'E', 'S', 'T', 'O', 'R', 'E', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* COMPUTE_WAVE_RESTORE_CONTROL (56937) */
	'C', 'P', '_', 'C', 'E', '_', 'R', 'B', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* CP_CE_RB_OFFSET (56966) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_ES_16 (56982) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_ES_17 (57009) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_ES_18 (57036) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_ES_19 (57063) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_ES_20 (57090) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_ES_21 (57117) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_ES_22 (57144) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_ES_23 (57171) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_ES_24 (57198) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_ES_25 (57225) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_ES_26 (57252) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_ES_27 (57279) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_ES_28 (57306) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_ES_29 (57333) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_ES_30 (57360) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_ES_31 (57387) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_LS_16 (57414) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_LS_17 (57441) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_LS_18 (57468) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_LS_19 (57495) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_LS_20 (57522) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_LS_21 (57549) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_LS_22 (57576) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_LS_23 (57603) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_LS_24 (57630) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_LS_25 (57657) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_LS_26 (57684) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_LS_27 (57711) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_LS_28 (57738) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_LS_29 (57765) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_LS_30 (57792) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_LS_31 (57819) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '0', '\0', /* SPI_SHADER_USER_DATA_COMMON_0 (57846) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '\0', /* SPI_SHADER_USER_DATA_COMMON_1 (57876) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '\0', /* SPI_SHADER_USER_DATA_COMMON_2 (57906) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '3', '\0', /* SPI_SHADER_USER_DATA_COMMON_3 (57936) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '4', '\0', /* SPI_SHADER_USER_DATA_COMMON_4 (57966) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '5', '\0', /* SPI_SHADER_USER_DATA_COMMON_5 (57996) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '6', '\0', /* SPI_SHADER_USER_DATA_COMMON_6 (58026) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '7', '\0', /* SPI_SHADER_USER_DATA_COMMON_7 (58056) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '8', '\0', /* SPI_SHADER_USER_DATA_COMMON_8 (58086) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '9', '\0', /* SPI_SHADER_USER_DATA_COMMON_9 (58116) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_COMMON_10 (58146) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_COMMON_11 (58177) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_COMMON_12 (58208) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_COMMON_13 (58239) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_COMMON_14 (58270) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_COMMON_15 (58301) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_COMMON_16 (58332) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_COMMON_17 (58363) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_COMMON_18 (58394) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_COMMON_19 (58425) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_COMMON_20 (58456) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_COMMON_21 (58487) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_COMMON_22 (58518) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_COMMON_23 (58549) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_COMMON_24 (58580) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_COMMON_25 (58611) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_COMMON_26 (58642) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_COMMON_27 (58673) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_COMMON_28 (58704) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_COMMON_29 (58735) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_COMMON_30 (58766) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_COMMON_31 (58797) */
	'D', 'B', '_', 'Z', '_', 'I', 'N', 'F', 'O', '2', '\0', /* DB_Z_INFO2 (58828) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'I', 'N', 'F', 'O', '2', '\0', /* DB_STENCIL_INFO2 (58839) */
	'C', 'B', '_', 'M', 'R', 'T', '0', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT0_EPITCH (58856, 58864) */
	'C', 'B', '_', 'M', 'R', 'T', '1', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT1_EPITCH (58871) */
	'C', 'B', '_', 'M', 'R', 'T', '2', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT2_EPITCH (58886) */
	'C', 'B', '_', 'M', 'R', 'T', '3', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT3_EPITCH (58901) */
	'C', 'B', '_', 'M', 'R', 'T', '4', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT4_EPITCH (58916) */
	'C', 'B', '_', 'M', 'R', 'T', '5', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT5_EPITCH (58931) */
	'C', 'B', '_', 'M', 'R', 'T', '6', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT6_EPITCH (58946) */
	'C', 'B', '_', 'M', 'R', 'T', '7', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT7_EPITCH (58961) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'M', 'A', 'X', '_', 'P', 'R', 'I', 'M', 'S', '_', 'P', 'E', 'R', '_', 'S', 'U', 'B', 'G', 'R', 'O', 'U', 'P', '\0', /* VGT_GS_MAX_PRIMS_PER_SUBGROUP (58976, 58983) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'D', 'A', 'T', 'A', '_', 'L', 'O', '\0', /* CP_APPEND_DATA_LO (59006) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'L', 'A', 'S', 'T', '_', 'C', 'S', '_', 'F', 'E', 'N', 'C', 'E', '_', 'L', 'O', '\0', /* CP_APPEND_LAST_CS_FENCE_LO (59024) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'L', 'A', 'S', 'T', '_', 'P', 'S', '_', 'F', 'E', 'N', 'C', 'E', '_', 'L', 'O', '\0', /* CP_APPEND_LAST_PS_FENCE_LO (59051) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_RMI_PERFMON_SAMPLE_DELAY (59078) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '_', 'M', 'A', 'X', '\0', /* RLC_SPM_PERFMON_SAMPLE_DELAY_MAX (59111, 59138) */
	'C', 'P', '_', 'C', 'P', 'F', '_', 'D', 'E', 'B', 'U', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* CP_CPF_DEBUG_CNTL (59144) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'G', '_', 'C', 'H', 'U', 'N', 'K', '_', 'S', 'I', 'Z', 'E', '\0', /* COMPUTE_TG_CHUNK_SIZE (59162, 59170) */
	'F', 'P', '_', 'R', 'O', 'U', 'N', 'D', '\0', /* FP_ROUND (59184) */
	'F', 'P', '_', 'D', 'E', 'N', 'O', 'R', 'M', '\0', /* FP_DENORM (59193) */
	'D', 'X', '1', '0', '_', 'C', 'L', 'A', 'M', 'P', '\0', /* DX10_CLAMP (59203) */
	'I', 'E', 'E', 'E', '\0', /* IEEE (59214) */
	'L', 'O', 'D', '_', 'C', 'L', 'A', 'M', 'P', 'E', 'D', '\0', /* LOD_CLAMPED (59219) */
	'I', 'N', 'V', 'A', 'L', 'I', 'D', '\0', /* INVALID (59231, 59233) */
	'I', 'N', 'P', 'U', 'T', '_', 'D', 'E', 'N', 'O', 'R', 'M', 'A', 'L', '\0', /* INPUT_DENORMAL (59239) */
	'D', 'I', 'V', 'I', 'D', 'E', '_', 'B', 'Y', '_', 'Z', 'E', 'R', 'O', '\0', /* DIVIDE_BY_ZERO (59254) */
	'O', 'V', 'E', 'R', 'F', 'L', 'O', 'W', '\0', /* OVERFLOW (59269) */
	'U', 'N', 'D', 'E', 'R', 'F', 'L', 'O', 'W', '\0', /* UNDERFLOW (59278) */
	'I', 'N', 'E', 'X', 'A', 'C', 'T', '\0', /* INEXACT (59288, 59290) */
	'I', 'N', 'T', '_', 'D', 'I', 'V', 'I', 'D', 'E', '_', 'B', 'Y', '_', 'Z', 'E', 'R', 'O', '\0', /* INT_DIVIDE_BY_ZERO (59296) */
	'A', 'D', 'D', 'R', 'E', 'S', 'S', '_', 'W', 'A', 'T', 'C', 'H', '\0', /* ADDRESS_WATCH (59315) */
	'M', 'E', 'M', 'O', 'R', 'Y', '_', 'V', 'I', 'O', 'L', 'A', 'T', 'I', 'O', 'N', '\0', /* MEMORY_VIOLATION (59329) */
	'E', 'X', 'C', 'P', '_', 'E', 'N', '\0', /* EXCP_EN (59346) */
	'F', 'P', '1', '6', '_', 'O', 'V', 'F', 'L', '\0', /* FP16_OVFL (59354) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'P', 'E', 'R', 'F', '\0', /* DISABLE_PERF (59364) */
	'V', 'S', 'K', 'I', 'P', '\0', /* VSKIP (59377) */
	'C', 'S', 'P', '\0', /* CSP (59383) */
	'S', 'C', 'C', '\0', /* SCC (59387) */
	'S', 'P', 'I', '_', 'P', 'R', 'I', 'O', '\0', /* SPI_PRIO (59391) */
	'U', 'S', 'E', 'R', '_', 'P', 'R', 'I', 'O', '\0', /* USER_PRIO (59400) */
	'P', 'R', 'I', 'V', '\0', /* PRIV (59410) */
	'T', 'R', 'A', 'P', '_', 'E', 'N', '\0', /* TRAP_EN (59415) */
	'T', 'T', 'R', 'A', 'C', 'E', '_', 'E', 'N', '\0', /* TTRACE_EN (59423) */
	'E', 'X', 'P', 'O', 'R', 'T', '_', 'R', 'D', 'Y', '\0', /* EXPORT_RDY (59433) */
	'E', 'X', 'E', 'C', 'Z', '\0', /* EXECZ (59444) */
	'V', 'C', 'C', 'Z', '\0', /* VCCZ (59450) */
	'I', 'N', '_', 'T', 'G', '\0', /* IN_TG (59455) */
	'I', 'N', '_', 'B', 'A', 'R', 'R', 'I', 'E', 'R', '\0', /* IN_BARRIER (59461) */
	'H', 'A', 'L', 'T', '\0', /* HALT (59472) */
	'T', 'R', 'A', 'P', '\0', /* TRAP (59477) */
	'T', 'T', 'R', 'A', 'C', 'E', '_', 'S', 'I', 'M', 'D', '_', 'E', 'N', '\0', /* TTRACE_SIMD_EN (59482, 59489) */
	'E', 'C', 'C', '_', 'E', 'R', 'R', '\0', /* ECC_ERR (59497) */
	'S', 'K', 'I', 'P', '_', 'E', 'X', 'P', 'O', 'R', 'T', '\0', /* SKIP_EXPORT (59505) */
	'P', 'E', 'R', 'F', '_', 'E', 'N', '\0', /* PERF_EN (59517) */
	'F', 'A', 'T', 'A', 'L', '_', 'H', 'A', 'L', 'T', '\0', /* FATAL_HALT (59525) */
	'M', 'U', 'S', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '\0', /* MUST_EXPORT (59536) */
	'E', 'X', 'C', 'P', '\0', /* EXCP (59548) */
	'S', 'A', 'V', 'E', 'C', 'T', 'X', '\0', /* SAVECTX (59553) */
	'I', 'L', 'L', 'E', 'G', 'A', 'L', '_', 'I', 'N', 'S', 'T', '\0', /* ILLEGAL_INST (59561) */
	'E', 'X', 'C', 'P', '_', 'H', 'I', '\0', /* EXCP_HI (59574) */
	'B', 'U', 'F', 'F', 'E', 'R', '_', 'O', 'O', 'B', '\0', /* BUFFER_OOB (59582) */
	'E', 'X', 'C', 'P', '_', 'C', 'Y', 'C', 'L', 'E', '\0', /* EXCP_CYCLE (59593) */
	'E', 'X', 'C', 'P', '_', 'G', 'R', 'O', 'U', 'P', '_', 'M', 'A', 'S', 'K', '\0', /* EXCP_GROUP_MASK (59604) */
	'E', 'X', 'C', 'P', '_', 'W', 'A', 'V', 'E', '6', '4', 'H', 'I', '\0', /* EXCP_WAVE64HI (59620, 59625) */
	'X', 'N', 'A', 'C', 'K', '_', 'E', 'R', 'R', 'O', 'R', '\0', /* XNACK_ERROR (59634) */
	'D', 'P', '_', 'R', 'A', 'T', 'E', '\0', /* DP_RATE (59646) */
	'S', 'I', 'M', 'D', '_', 'I', 'D', '\0', /* SIMD_ID (59654) */
	'P', 'I', 'P', 'E', '_', 'I', 'D', '\0', /* PIPE_ID (59662) */
	'C', 'U', '_', 'I', 'D', '\0', /* CU_ID (59670) */
	'S', 'H', '_', 'I', 'D', '\0', /* SH_ID (59676) */
	'W', 'A', 'V', 'E', '_', 'I', 'D', '_', 'M', 'S', 'B', '\0', /* WAVE_ID_MSB (59682) */
	'T', 'G', '_', 'I', 'D', '\0', /* TG_ID (59694) */
	'V', 'M', '_', 'I', 'D', '\0', /* VM_ID (59700) */
	'Q', 'U', 'E', 'U', 'E', '_', 'I', 'D', '\0', /* QUEUE_ID (59706) */
	'S', 'T', 'A', 'T', 'E', '_', 'I', 'D', '\0', /* STATE_ID (59715) */
	'M', 'E', '_', 'I', 'D', '\0', /* ME_ID (59724) */
	'V', 'G', 'P', 'R', '_', 'B', 'A', 'S', 'E', '\0', /* VGPR_BASE (59730) */
	'V', 'G', 'P', 'R', '_', 'S', 'I', 'Z', 'E', '\0', /* VGPR_SIZE (59740) */
	'S', 'G', 'P', 'R', '_', 'B', 'A', 'S', 'E', '\0', /* SGPR_BASE (59750) */
	'S', 'G', 'P', 'R', '_', 'S', 'I', 'Z', 'E', '\0', /* SGPR_SIZE (59760) */
	'L', 'D', 'S', '_', 'B', 'A', 'S', 'E', '\0', /* LDS_BASE (59770) */
	'L', 'D', 'S', '_', 'S', 'I', 'Z', 'E', '\0', /* LDS_SIZE (59779) */
	'V', 'G', 'P', 'R', '_', 'S', 'H', 'A', 'R', 'E', 'D', '_', 'S', 'I', 'Z', 'E', '\0', /* VGPR_SHARED_SIZE (59788) */
	'V', 'M', '_', 'C', 'N', 'T', '\0', /* VM_CNT (59805) */
	'E', 'X', 'P', '_', 'C', 'N', 'T', '\0', /* EXP_CNT (59812) */
	'L', 'G', 'K', 'M', '_', 'C', 'N', 'T', '_', 'B', 'I', 'T', '4', '\0', /* LGKM_CNT_BIT4 (59820) */
	'L', 'G', 'K', 'M', '_', 'C', 'N', 'T', '\0', /* LGKM_CNT (59834) */
	'V', 'A', 'L', 'U', '_', 'C', 'N', 'T', '\0', /* VALU_CNT (59843) */
	'F', 'I', 'R', 'S', 'T', '_', 'R', 'E', 'P', 'L', 'A', 'Y', '\0', /* FIRST_REPLAY (59852) */
	'R', 'C', 'N', 'T', '\0', /* RCNT (59865) */
	'V', 'M', '_', 'C', 'N', 'T', '_', 'H', 'I', '\0', /* VM_CNT_HI (59870) */
	'L', 'G', 'K', 'M', '_', 'C', 'N', 'T', '_', 'B', 'I', 'T', '5', '\0', /* LGKM_CNT_BIT5 (59880) */
	'R', 'E', 'P', 'L', 'A', 'Y', '_', 'W', '6', '4', 'H', '\0', /* REPLAY_W64H (59894) */
	'V', 'S', '_', 'C', 'N', 'T', '\0', /* VS_CNT (59906) */
	'X', 'N', 'A', 'C', 'K', '\0', /* XNACK (59913) */
	'T', 'A', '_', 'N', 'E', 'E', 'D', '_', 'R', 'E', 'S', 'E', 'T', '\0', /* TA_NEED_RESET (59919) */
	'X', 'N', 'A', 'C', 'K', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* XNACK_OVERRIDE (59933) */
	'X', 'C', 'N', 'T', '\0', /* XCNT (59948) */
	'Q', 'C', 'N', 'T', '\0', /* QCNT (59953) */
	'W', 'A', 'V', 'E', '_', 'I', 'D', 'L', 'E', '\0', /* WAVE_IDLE (59958) */
	'M', 'I', 'S', 'C', '_', 'C', 'N', 'T', '\0', /* MISC_CNT (59968) */
	'W', 'G', 'P', '_', 'I', 'D', '\0', /* WGP_ID (59977) */
	'S', 'A', '_', 'I', 'D', '\0', /* SA_ID (59984) */
	'W', 'G', '_', 'I', 'D', '\0', /* WG_ID (59990) */
	'C', 'O', 'M', 'P', 'A', 'T', '_', 'L', 'E', 'V', 'E', 'L', '\0', /* COMPAT_LEVEL (59996) */
	'P', 'O', 'P', 'S', '_', 'E', 'N', '\0', /* POPS_EN (60009, 60011) */
	'P', 'O', 'P', 'S', '_', 'P', 'A', 'C', 'K', 'E', 'R', '_', 'I', 'D', '\0', /* POPS_PACKER_ID (60017) */
	'D', 'E', 'P', '_', 'M', 'O', 'D', 'E', '\0', /* DEP_MODE (60032) */
	'I', 'N', 'S', 'T', '_', 'P', 'R', 'E', 'F', 'E', 'T', 'C', 'H', '\0', /* INST_PREFETCH (60041) */
	'R', 'E', 'S', 'O', 'U', 'R', 'C', 'E', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* RESOURCE_OVERRIDE (60055) */
	'M', 'E', 'M', '_', 'O', 'R', 'D', 'E', 'R', '\0', /* MEM_ORDER (60073) */
	'F', 'W', 'D', '_', 'P', 'R', 'O', 'G', 'R', 'E', 'S', 'S', '\0', /* FWD_PROGRESS (60083) */
	'W', 'A', 'V', 'E', '6', '4', '\0', /* WAVE64 (60096) */
	'S', 'U', 'B', 'V', '_', 'L', 'O', 'O', 'P', '\0', /* SUBV_LOOP (60103) */
	'M', 'E', '0', 'P', 'I', 'P', 'E', '1', '_', 'C', 'M', 'D', 'F', 'I', 'F', 'O', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* ME0PIPE1_CMDFIFO_AVAIL (60113) */
	'M', 'E', '0', 'P', 'I', 'P', 'E', '1', '_', 'C', 'F', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME0PIPE1_CF_RQ_PENDING (60136) */
	'M', 'E', '0', 'P', 'I', 'P', 'E', '1', '_', 'P', 'F', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME0PIPE1_PF_RQ_PENDING (60159) */
	'M', 'E', '1', 'P', 'I', 'P', 'E', '0', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME1PIPE0_RQ_PENDING (60182) */
	'M', 'E', '1', 'P', 'I', 'P', 'E', '1', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME1PIPE1_RQ_PENDING (60202) */
	'M', 'E', '1', 'P', 'I', 'P', 'E', '2', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME1PIPE2_RQ_PENDING (60222) */
	'M', 'E', '1', 'P', 'I', 'P', 'E', '3', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME1PIPE3_RQ_PENDING (60242) */
	'M', 'E', '2', 'P', 'I', 'P', 'E', '0', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME2PIPE0_RQ_PENDING (60262) */
	'M', 'E', '2', 'P', 'I', 'P', 'E', '1', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME2PIPE1_RQ_PENDING (60282) */
	'M', 'E', '2', 'P', 'I', 'P', 'E', '2', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME2PIPE2_RQ_PENDING (60302) */
	'M', 'E', '2', 'P', 'I', 'P', 'E', '3', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME2PIPE3_RQ_PENDING (60322) */
	'R', 'L', 'C', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* RLC_RQ_PENDING (60342) */
	'U', 'T', 'C', 'L', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* UTCL2_BUSY (60357, 60363) */
	'E', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* EA_BUSY (60368) */
	'R', 'M', 'I', '_', 'B', 'U', 'S', 'Y', '\0', /* RMI_BUSY (60376) */
	'U', 'T', 'C', 'L', '2', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* UTCL2_RQ_PENDING (60385) */
	'C', 'P', 'F', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* CPF_RQ_PENDING (60402) */
	'E', 'A', '_', 'L', 'I', 'N', 'K', '_', 'B', 'U', 'S', 'Y', '\0', /* EA_LINK_BUSY (60417) */
	'S', 'D', 'M', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* SDMA_BUSY (60430, 60431) */
	'S', 'D', 'M', 'A', '0', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* SDMA0_RQ_PENDING (60440) */
	'S', 'D', 'M', 'A', '1', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* SDMA1_RQ_PENDING (60457) */
	'R', 'L', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* RLC_BUSY (60474) */
	'T', 'C', 'P', '_', 'B', 'U', 'S', 'Y', '\0', /* TCP_BUSY (60483, 60484) */
	'C', 'P', 'F', '_', 'B', 'U', 'S', 'Y', '\0', /* CPF_BUSY (60492) */
	'C', 'P', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* CPC_BUSY (60501, 60502) */
	'C', 'P', 'G', '_', 'B', 'U', 'S', 'Y', '\0', /* CPG_BUSY (60510) */
	'C', 'P', 'A', 'X', 'I', '_', 'B', 'U', 'S', 'Y', '\0', /* CPAXI_BUSY (60519) */
	'M', 'E', '0', 'P', 'I', 'P', 'E', '0', '_', 'C', 'M', 'D', 'F', 'I', 'F', 'O', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* ME0PIPE0_CMDFIFO_AVAIL (60530) */
	'R', 'S', 'M', 'U', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* RSMU_RQ_PENDING (60553, 60554) */
	'M', 'E', '0', 'P', 'I', 'P', 'E', '0', '_', 'C', 'F', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME0PIPE0_CF_RQ_PENDING (60569) */
	'M', 'E', '0', 'P', 'I', 'P', 'E', '0', '_', 'P', 'F', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME0PIPE0_PF_RQ_PENDING (60592) */
	'G', 'D', 'S', '_', 'D', 'M', 'A', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* GDS_DMA_RQ_PENDING (60615) */
	'D', 'B', '_', 'C', 'L', 'E', 'A', 'N', '\0', /* DB_CLEAN (60634) */
	'C', 'B', '_', 'C', 'L', 'E', 'A', 'N', '\0', /* CB_CLEAN (60643) */
	'T', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* TA_BUSY (60652) */
	'G', 'D', 'S', '_', 'B', 'U', 'S', 'Y', '\0', /* GDS_BUSY (60660) */
	'G', 'E', '_', 'B', 'U', 'S', 'Y', '_', 'N', 'O', '_', 'D', 'M', 'A', '\0', /* GE_BUSY_NO_DMA (60669) */
	'S', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* SX_BUSY (60684) */
	'G', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* GE_BUSY (60692) */
	'S', 'P', 'I', '_', 'B', 'U', 'S', 'Y', '\0', /* SPI_BUSY (60700) */
	'B', 'C', 'I', '_', 'B', 'U', 'S', 'Y', '\0', /* BCI_BUSY (60709) */
	'S', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* SC_BUSY (60718) */
	'P', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* PA_BUSY (60726) */
	'D', 'B', '_', 'B', 'U', 'S', 'Y', '\0', /* DB_BUSY (60734) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', 'E', 'N', 'C', 'Y', '_', 'B', 'U', 'S', 'Y', '\0', /* CP_COHERENCY_BUSY (60742) */
	'C', 'B', '_', 'B', 'U', 'S', 'Y', '\0', /* CB_BUSY (60760) */
	'G', 'U', 'I', '_', 'A', 'C', 'T', 'I', 'V', 'E', '\0', /* GUI_ACTIVE (60768) */
	'U', 'T', 'C', 'L', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* UTCL1_BUSY (60779) */
	'G', 'L', '1', 'C', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* GL1CC_BUSY (60790) */
	'G', 'R', 'B', 'M', '_', 'R', 'L', 'C', '_', 'I', 'N', 'T', 'R', '_', 'C', 'R', 'E', 'D', 'I', 'T', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* GRBM_RLC_INTR_CREDIT_PENDING (60801) */
	'G', 'R', 'B', 'M', '_', 'U', 'T', 'C', 'L', '2', '_', 'I', 'N', 'T', 'R', '_', 'C', 'R', 'E', 'D', 'I', 'T', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* GRBM_UTCL2_INTR_CREDIT_PENDING (60830) */
	'G', 'R', 'B', 'M', '_', 'C', 'P', 'F', '_', 'I', 'N', 'T', 'R', '_', 'C', 'R', 'E', 'D', 'I', 'T', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* GRBM_CPF_INTR_CREDIT_PENDING (60861) */
	'M', 'E', 'S', 'P', 'I', 'P', 'E', '0', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* MESPIPE0_RQ_PENDING (60890) */
	'M', 'E', 'S', 'P', 'I', 'P', 'E', '1', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* MESPIPE1_RQ_PENDING (60910) */
	'M', 'E', 'S', 'P', 'I', 'P', 'E', '2', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* MESPIPE2_RQ_PENDING (60930) */
	'M', 'E', 'S', 'P', 'I', 'P', 'E', '3', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* MESPIPE3_RQ_PENDING (60950) */
	'P', 'H', '_', 'B', 'U', 'S', 'Y', '\0', /* PH_BUSY (60970) */
	'C', 'H', '_', 'B', 'U', 'S', 'Y', '\0', /* CH_BUSY (60978) */
	'G', 'L', '2', 'C', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* GL2CC_BUSY (60986) */
	'G', 'U', 'S', '_', 'L', 'I', 'N', 'K', '_', 'B', 'U', 'S', 'Y', '\0', /* GUS_LINK_BUSY (60997) */
	'G', 'U', 'S', '_', 'B', 'U', 'S', 'Y', '\0', /* GUS_BUSY (61011) */
	'P', 'M', 'M', '_', 'B', 'U', 'S', 'Y', '\0', /* PMM_BUSY (61020) */
	'M', 'E', 'C', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_BUSY (61029) */
	'M', 'E', 'C', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_BUSY (61039) */
	'D', 'C', '0', '_', 'B', 'U', 'S', 'Y', '\0', /* DC0_BUSY (61049) */
	'D', 'C', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* DC1_BUSY (61058) */
	'R', 'C', 'I', 'U', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* RCIU1_BUSY (61067) */
	'R', 'C', 'I', 'U', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* RCIU2_BUSY (61078) */
	'R', 'O', 'Q', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ1_BUSY (61089) */
	'R', 'O', 'Q', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ2_BUSY (61099) */
	'T', 'C', 'I', 'U', '_', 'B', 'U', 'S', 'Y', '\0', /* TCIU_BUSY (61109) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'A', 'M', '_', 'B', 'U', 'S', 'Y', '\0', /* SCRATCH_RAM_BUSY (61119) */
	'Q', 'U', '_', 'B', 'U', 'S', 'Y', '\0', /* QU_BUSY (61136) */
	'U', 'T', 'C', 'L', '2', 'I', 'U', '_', 'B', 'U', 'S', 'Y', '\0', /* UTCL2IU_BUSY (61144) */
	'S', 'A', 'V', 'E', '_', 'R', 'E', 'S', 'T', 'O', 'R', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* SAVE_RESTORE_BUSY (61157) */
	'G', 'C', 'R', 'I', 'U', '_', 'B', 'U', 'S', 'Y', '\0', /* GCRIU_BUSY (61175) */
	'M', 'E', 'S', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_BUSY (61186) */
	'M', 'E', 'S', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'A', 'M', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_SCRATCH_RAM_BUSY (61195) */
	'R', 'C', 'I', 'U', '3', '_', 'B', 'U', 'S', 'Y', '\0', /* RCIU3_BUSY (61216) */
	'M', 'E', 'S', '_', 'I', 'N', 'S', 'T', 'R', 'U', 'C', 'T', 'I', 'O', 'N', '_', 'C', 'A', 'C', 'H', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_INSTRUCTION_CACHE_BUSY (61227) */
	'C', 'P', 'G', '_', 'C', 'P', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* CPG_CPC_BUSY (61254) */
	'C', 'P', 'F', '_', 'C', 'P', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* CPF_CPC_BUSY (61267) */
	'M', 'E', 'C', '1', '_', 'L', 'O', 'A', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_LOAD_BUSY (61280) */
	'M', 'E', 'C', '1', '_', 'S', 'E', 'M', 'A', 'P', 'O', 'H', 'R', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_SEMAPOHRE_BUSY (61295) */
	'M', 'E', 'C', '1', '_', 'M', 'U', 'T', 'E', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_MUTEX_BUSY (61315) */
	'M', 'E', 'C', '1', '_', 'M', 'E', 'S', 'S', 'A', 'G', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_MESSAGE_BUSY (61331) */
	'M', 'E', 'C', '1', '_', 'E', 'O', 'P', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_EOP_QUEUE_BUSY (61349) */
	'M', 'E', 'C', '1', '_', 'I', 'Q', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_IQ_QUEUE_BUSY (61369) */
	'M', 'E', 'C', '1', '_', 'I', 'B', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_IB_QUEUE_BUSY (61388) */
	'M', 'E', 'C', '1', '_', 'T', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_TC_BUSY (61407, 61412) */
	'M', 'E', 'C', '1', '_', 'D', 'M', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_DMA_BUSY (61420) */
	'M', 'E', 'C', '1', '_', 'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'F', 'L', 'U', 'S', 'H', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_PARTIAL_FLUSH_BUSY (61434) */
	'M', 'E', 'C', '1', '_', 'P', 'I', 'P', 'E', '0', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_PIPE0_BUSY (61458) */
	'M', 'E', 'C', '1', '_', 'P', 'I', 'P', 'E', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_PIPE1_BUSY (61474) */
	'M', 'E', 'C', '1', '_', 'P', 'I', 'P', 'E', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_PIPE2_BUSY (61490) */
	'M', 'E', 'C', '1', '_', 'P', 'I', 'P', 'E', '3', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_PIPE3_BUSY (61506) */
	'M', 'E', 'C', '2', '_', 'L', 'O', 'A', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_LOAD_BUSY (61522) */
	'M', 'E', 'C', '2', '_', 'S', 'E', 'M', 'A', 'P', 'O', 'H', 'R', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_SEMAPOHRE_BUSY (61537) */
	'M', 'E', 'C', '2', '_', 'M', 'U', 'T', 'E', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_MUTEX_BUSY (61557) */
	'M', 'E', 'C', '2', '_', 'M', 'E', 'S', 'S', 'A', 'G', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_MESSAGE_BUSY (61573) */
	'M', 'E', 'C', '2', '_', 'E', 'O', 'P', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_EOP_QUEUE_BUSY (61591) */
	'M', 'E', 'C', '2', '_', 'I', 'Q', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_IQ_QUEUE_BUSY (61611) */
	'M', 'E', 'C', '2', '_', 'I', 'B', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_IB_QUEUE_BUSY (61630) */
	'M', 'E', 'C', '2', '_', 'T', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_TC_BUSY (61649) */
	'M', 'E', 'C', '2', '_', 'D', 'M', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_DMA_BUSY (61662) */
	'M', 'E', 'C', '2', '_', 'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'F', 'L', 'U', 'S', 'H', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_PARTIAL_FLUSH_BUSY (61676) */
	'M', 'E', 'C', '2', '_', 'P', 'I', 'P', 'E', '0', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_PIPE0_BUSY (61700) */
	'M', 'E', 'C', '2', '_', 'P', 'I', 'P', 'E', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_PIPE1_BUSY (61716) */
	'M', 'E', 'C', '2', '_', 'P', 'I', 'P', 'E', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_PIPE2_BUSY (61732) */
	'M', 'E', 'C', '2', '_', 'P', 'I', 'P', 'E', '3', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_PIPE3_BUSY (61748) */
	'R', 'C', 'I', 'U', '_', 'T', 'X', '_', 'F', 'R', 'E', 'E', '_', 'S', 'T', 'A', 'L', 'L', '\0', /* RCIU_TX_FREE_STALL (61764) */
	'R', 'C', 'I', 'U', '_', 'P', 'R', 'I', 'V', '_', 'V', 'I', 'O', 'L', 'A', 'T', 'I', 'O', 'N', '\0', /* RCIU_PRIV_VIOLATION (61783) */
	'T', 'C', 'I', 'U', '_', 'T', 'X', '_', 'F', 'R', 'E', 'E', '_', 'S', 'T', 'A', 'L', 'L', '\0', /* TCIU_TX_FREE_STALL (61803) */
	'M', 'E', 'C', '1', '_', 'D', 'E', 'C', 'O', 'D', 'I', 'N', 'G', '_', 'P', 'A', 'C', 'K', 'E', 'T', '\0', /* MEC1_DECODING_PACKET (61822) */
	'M', 'E', 'C', '1', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'R', 'C', 'I', 'U', '\0', /* MEC1_WAIT_ON_RCIU (61843) */
	'M', 'E', 'C', '1', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'R', 'C', 'I', 'U', '_', 'R', 'E', 'A', 'D', '\0', /* MEC1_WAIT_ON_RCIU_READ (61861) */
	'M', 'E', 'C', '1', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'R', 'O', 'Q', '_', 'D', 'A', 'T', 'A', '\0', /* MEC1_WAIT_ON_ROQ_DATA (61884) */
	'M', 'E', 'C', '2', '_', 'D', 'E', 'C', 'O', 'D', 'I', 'N', 'G', '_', 'P', 'A', 'C', 'K', 'E', 'T', '\0', /* MEC2_DECODING_PACKET (61906) */
	'M', 'E', 'C', '2', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'R', 'C', 'I', 'U', '\0', /* MEC2_WAIT_ON_RCIU (61927) */
	'M', 'E', 'C', '2', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'R', 'C', 'I', 'U', '_', 'R', 'E', 'A', 'D', '\0', /* MEC2_WAIT_ON_RCIU_READ (61945) */
	'M', 'E', 'C', '2', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'R', 'O', 'Q', '_', 'D', 'A', 'T', 'A', '\0', /* MEC2_WAIT_ON_ROQ_DATA (61968) */
	'U', 'T', 'C', 'L', '2', 'I', 'U', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'F', 'R', 'E', 'E', '\0', /* UTCL2IU_WAITING_ON_FREE (61990) */
	'U', 'T', 'C', 'L', '2', 'I', 'U', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'T', 'A', 'G', 'S', '\0', /* UTCL2IU_WAITING_ON_TAGS (62014) */
	'U', 'T', 'C', 'L', '1', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'T', 'R', 'A', 'N', 'S', '\0', /* UTCL1_WAITING_ON_TRANS (62038) */
	'G', 'C', 'R', 'I', 'U', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'F', 'R', 'E', 'E', '\0', /* GCRIU_WAITING_ON_FREE (62061) */
	'P', 'O', 'S', 'T', '_', 'W', 'P', 'T', 'R', '_', 'G', 'F', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* POST_WPTR_GFX_BUSY (62083) */
	'C', 'S', 'F', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_BUSY (62102) */
	'R', 'O', 'Q', '_', 'A', 'L', 'I', 'G', 'N', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_ALIGN_BUSY (62111) */
	'R', 'O', 'Q', '_', 'R', 'I', 'N', 'G', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_RING_BUSY (62126) */
	'R', 'O', 'Q', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_INDIRECT1_BUSY (62140) */
	'R', 'O', 'Q', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_INDIRECT2_BUSY (62159) */
	'R', 'O', 'Q', '_', 'S', 'T', 'A', 'T', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_STATE_BUSY (62178) */
	'R', 'O', 'Q', '_', 'C', 'E', '_', 'R', 'I', 'N', 'G', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_CE_RING_BUSY (62193) */
	'R', 'O', 'Q', '_', 'C', 'E', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_CE_INDIRECT1_BUSY (62210) */
	'R', 'O', 'Q', '_', 'C', 'E', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_CE_INDIRECT2_BUSY (62232) */
	'S', 'E', 'M', 'A', 'P', 'H', 'O', 'R', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* SEMAPHORE_BUSY (62254) */
	'I', 'N', 'T', 'E', 'R', 'R', 'U', 'P', 'T', '_', 'B', 'U', 'S', 'Y', '\0', /* INTERRUPT_BUSY (62269) */
	'H', 'Q', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_BUSY (62284) */
	'P', 'R', 'T', '_', 'B', 'U', 'S', 'Y', '\0', /* PRT_BUSY (62293) */
	'R', 'C', 'I', 'U', '_', 'B', 'U', 'S', 'Y', '\0', /* RCIU_BUSY (62302) */
	'R', 'C', 'I', 'U', '_', 'G', 'F', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* RCIU_GFX_BUSY (62312) */
	'R', 'C', 'I', 'U', '_', 'C', 'M', 'P', '_', 'B', 'U', 'S', 'Y', '\0', /* RCIU_CMP_BUSY (62326) */
	'R', 'O', 'Q', '_', 'D', 'A', 'T', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_DATA_BUSY (62340) */
	'R', 'O', 'Q', '_', 'C', 'E', '_', 'D', 'A', 'T', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_CE_DATA_BUSY (62354) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_BUSY (62371) */
	'C', 'P', 'F', '_', 'G', 'F', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* CPF_GFX_BUSY (62384) */
	'C', 'P', 'F', '_', 'C', 'M', 'P', '_', 'B', 'U', 'S', 'Y', '\0', /* CPF_CMP_BUSY (62397) */
	'G', 'R', 'B', 'M', '_', 'C', 'P', 'F', '_', 'S', 'T', 'A', 'T', '_', 'B', 'U', 'S', 'Y', '\0', /* GRBM_CPF_STAT_BUSY (62410) */
	'C', 'P', 'C', '_', 'C', 'P', 'F', '_', 'B', 'U', 'S', 'Y', '\0', /* CPC_CPF_BUSY (62429) */
	'R', 'E', 'G', '_', 'B', 'U', 'S', '_', 'F', 'I', 'F', 'O', '_', 'B', 'U', 'S', 'Y', '\0', /* REG_BUS_FIFO_BUSY (62442) */
	'C', 'S', 'F', '_', 'R', 'I', 'N', 'G', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_RING_BUSY (62460) */
	'C', 'S', 'F', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_INDIRECT1_BUSY (62474) */
	'C', 'S', 'F', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_INDIRECT2_BUSY (62493) */
	'C', 'S', 'F', '_', 'S', 'T', 'A', 'T', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_STATE_BUSY (62512) */
	'C', 'S', 'F', '_', 'C', 'E', '_', 'I', 'N', 'D', 'R', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_CE_INDR1_BUSY (62527) */
	'C', 'S', 'F', '_', 'C', 'E', '_', 'I', 'N', 'D', 'R', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_CE_INDR2_BUSY (62545) */
	'C', 'S', 'F', '_', 'A', 'R', 'B', 'I', 'T', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_ARBITER_BUSY (62563) */
	'C', 'S', 'F', '_', 'I', 'N', 'P', 'U', 'T', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_INPUT_BUSY (62580) */
	'C', 'S', 'F', '_', 'D', 'A', 'T', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_DATA_BUSY (62595) */
	'C', 'S', 'F', '_', 'C', 'E', '_', 'D', 'A', 'T', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_CE_DATA_BUSY (62609) */
	'H', 'P', 'D', '_', 'P', 'R', 'O', 'C', 'E', 'S', 'S', 'I', 'N', 'G', '_', 'E', 'O', 'P', '_', 'B', 'U', 'S', 'Y', '\0', /* HPD_PROCESSING_EOP_BUSY (62626) */
	'H', 'Q', 'D', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_DISPATCH_BUSY (62650) */
	'H', 'Q', 'D', '_', 'I', 'Q', '_', 'T', 'I', 'M', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_IQ_TIMER_BUSY (62668) */
	'H', 'Q', 'D', '_', 'D', 'M', 'A', '_', 'O', 'F', 'F', 'L', 'O', 'A', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_DMA_OFFLOAD_BUSY (62686) */
	'H', 'Q', 'D', '_', 'W', 'A', 'I', 'T', '_', 'S', 'E', 'M', 'A', 'P', 'H', 'O', 'R', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_WAIT_SEMAPHORE_BUSY (62707) */
	'H', 'Q', 'D', '_', 'S', 'I', 'G', 'N', 'A', 'L', '_', 'S', 'E', 'M', 'A', 'P', 'H', 'O', 'R', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_SIGNAL_SEMAPHORE_BUSY (62731) */
	'H', 'Q', 'D', '_', 'M', 'E', 'S', 'S', 'A', 'G', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_MESSAGE_BUSY (62757) */
	'H', 'Q', 'D', '_', 'P', 'Q', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_PQ_FETCHER_BUSY (62774) */
	'H', 'Q', 'D', '_', 'I', 'B', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_IB_FETCHER_BUSY (62794) */
	'H', 'Q', 'D', '_', 'I', 'Q', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_IQ_FETCHER_BUSY (62814) */
	'H', 'Q', 'D', '_', 'E', 'O', 'P', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_EOP_FETCHER_BUSY (62834) */
	'H', 'Q', 'D', '_', 'C', 'O', 'N', 'S', 'U', 'M', 'E', 'D', '_', 'R', 'P', 'T', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_CONSUMED_RPTR_BUSY (62855) */
	'H', 'Q', 'D', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'A', 'R', 'B', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_FETCHER_ARB_BUSY (62878) */
	'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'A', 'L', 'I', 'G', 'N', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_ROQ_ALIGN_BUSY (62899) */
	'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'E', 'O', 'P', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_ROQ_EOP_BUSY (62918) */
	'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'I', 'Q', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_ROQ_IQ_BUSY (62935) */
	'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'P', 'Q', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_ROQ_PQ_BUSY (62951) */
	'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'I', 'B', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_ROQ_IB_BUSY (62967) */
	'H', 'Q', 'D', '_', 'W', 'P', 'T', 'R', '_', 'P', 'O', 'L', 'L', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_WPTR_POLL_BUSY (62983) */
	'H', 'Q', 'D', '_', 'P', 'Q', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_PQ_BUSY (63002) */
	'H', 'Q', 'D', '_', 'I', 'B', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_IB_BUSY (63014) */
	'R', 'I', 'N', 'G', '_', 'F', 'E', 'T', 'C', 'H', 'I', 'N', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* RING_FETCHING_DATA (63026) */
	'I', 'N', 'D', 'R', '1', '_', 'F', 'E', 'T', 'C', 'H', 'I', 'N', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* INDR1_FETCHING_DATA (63045) */
	'I', 'N', 'D', 'R', '2', '_', 'F', 'E', 'T', 'C', 'H', 'I', 'N', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* INDR2_FETCHING_DATA (63065) */
	'S', 'T', 'A', 'T', 'E', '_', 'F', 'E', 'T', 'C', 'H', 'I', 'N', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* STATE_FETCHING_DATA (63085) */
	'T', 'C', 'I', 'U', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'F', 'R', 'E', 'E', '\0', /* TCIU_WAITING_ON_FREE (63105) */
	'T', 'C', 'I', 'U', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'T', 'A', 'G', 'S', '\0', /* TCIU_WAITING_ON_TAGS (63126) */
	'G', 'F', 'X', '_', 'U', 'T', 'C', 'L', '1', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'T', 'R', 'A', 'N', 'S', '\0', /* GFX_UTCL1_WAITING_ON_TRANS (63147) */
	'C', 'M', 'P', '_', 'U', 'T', 'C', 'L', '1', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'T', 'R', 'A', 'N', 'S', '\0', /* CMP_UTCL1_WAITING_ON_TRANS (63174) */
	'R', 'C', 'I', 'U', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'F', 'R', 'E', 'E', '\0', /* RCIU_WAITING_ON_FREE (63201) */
	'D', 'A', 'T', 'A', '_', 'F', 'E', 'T', 'C', 'H', 'I', 'N', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* DATA_FETCHING_DATA (63222) */
	'G', 'C', 'R', 'I', 'U', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'F', 'R', 'E', 'E', '\0', /* GCRIU_WAIT_ON_FREE (63241) */
	'M', 'E', 'S', '_', 'L', 'O', 'A', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_LOAD_BUSY (63260) */
	'M', 'E', 'S', '_', 'M', 'U', 'T', 'E', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_MUTEX_BUSY (63274) */
	'M', 'E', 'S', '_', 'M', 'E', 'S', 'S', 'A', 'G', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_MESSAGE_BUSY (63289) */
	'M', 'E', 'S', '_', 'T', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_TC_BUSY (63306) */
	'M', 'E', 'S', '_', 'D', 'M', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_DMA_BUSY (63318) */
	'M', 'E', 'S', '_', 'P', 'I', 'P', 'E', '0', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_PIPE0_BUSY (63331) */
	'M', 'E', 'S', '_', 'P', 'I', 'P', 'E', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_PIPE1_BUSY (63346) */
	'M', 'E', 'S', '_', 'P', 'I', 'P', 'E', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_PIPE2_BUSY (63361) */
	'M', 'E', 'S', '_', 'P', 'I', 'P', 'E', '3', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_PIPE3_BUSY (63376) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'D', 'E', 'X', '_', '6', '4', 'B', 'I', 'T', '_', 'M', 'O', 'D', 'E', '\0', /* SCRATCH_INDEX_64BIT_MODE (63391) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_DISPATCH_BUSY (63416) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'D', 'M', 'A', '_', 'O', 'F', 'F', 'L', 'O', 'A', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_DMA_OFFLOAD_BUSY (63438) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'M', 'E', 'S', 'S', 'A', 'G', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_MESSAGE_BUSY (63463) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'P', 'Q', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_PQ_FETCHER_BUSY (63484) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'C', 'O', 'N', 'S', 'U', 'M', 'E', 'D', '_', 'R', 'P', 'T', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_CONSUMED_RPTR_BUSY (63508) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'A', 'R', 'B', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_FETCHER_ARB_BUSY (63535) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'A', 'L', 'I', 'G', 'N', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_ROQ_ALIGN_BUSY (63560) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'P', 'Q', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_ROQ_PQ_BUSY (63583) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'P', 'Q', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_PQ_BUSY (63603) */
	'B', 'U', 'F', 'F', 'E', 'R', '_', 'I', 'D', '\0', /* BUFFER_ID (63619) */
	'S', 'I', 'M', 'D', '_', 'S', 'E', 'L', '\0', /* SIMD_SEL (63629) */
	'W', 'G', 'P', '_', 'S', 'E', 'L', '\0', /* WGP_SEL (63638) */
	'S', 'A', '_', 'S', 'E', 'L', '\0', /* SA_SEL (63646) */
	'W', 'T', 'Y', 'P', 'E', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '\0', /* WTYPE_INCLUDE (63653) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'V', 'M', 'E', 'M', 'E', 'X', 'E', 'C', '\0', /* TOKEN_EXCLUDE_VMEMEXEC (63667) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'A', 'L', 'U', 'E', 'X', 'E', 'C', '\0', /* TOKEN_EXCLUDE_ALUEXEC (63690) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'V', 'A', 'L', 'U', 'I', 'N', 'S', 'T', '\0', /* TOKEN_EXCLUDE_VALUINST (63712) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'W', 'A', 'V', 'E', 'R', 'D', 'Y', '\0', /* TOKEN_EXCLUDE_WAVERDY (63735) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'I', 'M', 'M', 'E', 'D', '1', '\0', /* TOKEN_EXCLUDE_IMMED1 (63757) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'I', 'M', 'M', 'E', 'D', 'I', 'A', 'T', 'E', '\0', /* TOKEN_EXCLUDE_IMMEDIATE (63778, 63792) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'R', 'E', 'G', '\0', /* TOKEN_EXCLUDE_REG (63802) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'E', 'V', 'E', 'N', 'T', '\0', /* TOKEN_EXCLUDE_EVENT (63820) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'I', 'N', 'S', 'T', '\0', /* TOKEN_EXCLUDE_INST (63840) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'U', 'T', 'I', 'L', 'C', 'T', 'R', '\0', /* TOKEN_EXCLUDE_UTILCTR (63859) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'W', 'A', 'V', 'E', 'A', 'L', 'L', 'O', 'C', '\0', /* TOKEN_EXCLUDE_WAVEALLOC (63881) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'P', 'E', 'R', 'F', '\0', /* TOKEN_EXCLUDE_PERF (63905) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '\0', /* TOKEN_EXCLUDE (63924) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'S', 'Q', 'D', 'E', 'C', '\0', /* REG_INCLUDE_SQDEC (63938) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'S', 'H', 'D', 'E', 'C', '\0', /* REG_INCLUDE_SHDEC (63956) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'G', 'F', 'X', 'U', 'D', 'E', 'C', '\0', /* REG_INCLUDE_GFXUDEC (63974) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'C', 'O', 'M', 'P', '\0', /* REG_INCLUDE_COMP (63994) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'C', 'O', 'N', 'T', 'E', 'X', 'T', '\0', /* REG_INCLUDE_CONTEXT (64011) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* REG_INCLUDE_CONFIG (64031) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'O', 'T', 'H', 'E', 'R', '\0', /* REG_INCLUDE_OTHER (64050) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'R', 'E', 'A', 'D', 'S', '\0', /* REG_INCLUDE_READS (64068) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '\0', /* REG_INCLUDE (64086) */
	'I', 'N', 'S', 'T', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '\0', /* INST_EXCLUDE (64098) */
	'R', 'E', 'G', '_', 'D', 'E', 'T', 'A', 'I', 'L', '_', 'A', 'L', 'L', '\0', /* REG_DETAIL_ALL (64111) */
	'A', 'L', 'L', '_', 'V', 'M', 'I', 'D', '\0', /* ALL_VMID (64126) */
	'C', 'H', '_', 'P', 'E', 'R', 'F', '_', 'E', 'N', '\0', /* CH_PERF_EN (64135) */
	'I', 'N', 'T', 'E', 'R', 'R', 'U', 'P', 'T', '_', 'E', 'N', '\0', /* INTERRUPT_EN (64146) */
	'D', 'O', 'U', 'B', 'L', 'E', '_', 'B', 'U', 'F', 'F', 'E', 'R', '\0', /* DOUBLE_BUFFER (64159) */
	'R', 'E', 'G', '_', 'S', 'T', 'A', 'L', 'L', '_', 'E', 'N', '\0', /* REG_STALL_EN (64173) */
	'S', 'P', 'I', '_', 'S', 'T', 'A', 'L', 'L', '_', 'E', 'N', '\0', /* SPI_STALL_EN (64186) */
	'S', 'Q', '_', 'S', 'T', 'A', 'L', 'L', '_', 'E', 'N', '\0', /* SQ_STALL_EN (64199) */
	'R', 'E', 'G', '_', 'D', 'R', 'O', 'P', '_', 'O', 'N', '_', 'S', 'T', 'A', 'L', 'L', '\0', /* REG_DROP_ON_STALL (64211) */
	'U', 'T', 'I', 'L', '_', 'T', 'I', 'M', 'E', 'R', '\0', /* UTIL_TIMER (64229) */
	'W', 'A', 'V', 'E', 'S', 'T', 'A', 'R', 'T', '_', 'M', 'O', 'D', 'E', '\0', /* WAVESTART_MODE (64240) */
	'R', 'T', '_', 'F', 'R', 'E', 'Q', '\0', /* RT_FREQ (64255) */
	'S', 'Y', 'N', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'M', 'A', 'R', 'K', 'E', 'R', 'S', '\0', /* SYNC_COUNT_MARKERS (64263) */
	'S', 'Y', 'N', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'D', 'R', 'A', 'W', 'S', '\0', /* SYNC_COUNT_DRAWS (64282) */
	'C', 'A', 'P', 'T', 'U', 'R', 'E', '_', 'A', 'L', 'L', '\0', /* CAPTURE_ALL (64299) */
	'D', 'R', 'A', 'W', '_', 'E', 'V', 'E', 'N', 'T', '_', 'E', 'N', '\0', /* DRAW_EVENT_EN (64311) */
	'F', 'I', 'N', 'I', 'S', 'H', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* FINISH_PENDING (64325) */
	'F', 'I', 'N', 'I', 'S', 'H', '_', 'D', 'O', 'N', 'E', '\0', /* FINISH_DONE (64340, 64347) */
	'U', 'T', 'C', '_', 'E', 'R', 'R', '\0', /* UTC_ERR (64352) */
	'E', 'V', 'E', 'N', 'T', '_', 'C', 'N', 'T', 'R', '_', 'O', 'V', 'E', 'R', 'F', 'L', 'O', 'W', '\0', /* EVENT_CNTR_OVERFLOW (64360) */
	'E', 'V', 'E', 'N', 'T', '_', 'C', 'N', 'T', 'R', '_', 'S', 'T', 'A', 'L', 'L', '\0', /* EVENT_CNTR_STALL (64380) */
	'S', 'Q', '_', 'E', 'X', 'P', '_', 'M', 'R', 'T', '\0', /* SQ_EXP_MRT (64397) */
	'S', 'Q', '_', 'E', 'X', 'P', '_', 'M', 'R', 'T', 'Z', '\0', /* SQ_EXP_MRTZ (64408) */
	'S', 'Q', '_', 'E', 'X', 'P', '_', 'N', 'U', 'L', 'L', '\0', /* SQ_EXP_NULL (64420) */
	'S', 'Q', '_', 'E', 'X', 'P', '_', 'P', 'O', 'S', '\0', /* SQ_EXP_POS (64432) */
	'S', 'Q', '_', 'E', 'X', 'P', '_', 'P', 'R', 'I', 'M', '\0', /* SQ_EXP_PRIM (64443) */
	'S', 'Q', '_', 'E', 'X', 'P', '_', 'P', 'A', 'R', 'A', 'M', '\0', /* SQ_EXP_PARAM (64455) */
	'T', 'G', 'T', '\0', /* TGT (64468) */
	'C', 'O', 'M', 'P', 'R', '\0', /* COMPR (64472) */
	'V', 'M', '\0', /* VM (64478) */
	'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', 'E', 'S', 'S', '_', 'H', 'I', '\0', /* BASE_ADDRESS_HI (64481, 64486) */
	'C', 'A', 'C', 'H', 'E', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '\0', /* CACHE_SWIZZLE (64497) */
	'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* SWIZZLE_ENABLE (64511) */
	'D', 'S', 'T', '_', 'S', 'E', 'L', '_', 'X', '\0', /* DST_SEL_X (64526) */
	'D', 'S', 'T', '_', 'S', 'E', 'L', '_', 'Y', '\0', /* DST_SEL_Y (64536) */
	'D', 'S', 'T', '_', 'S', 'E', 'L', '_', 'Z', '\0', /* DST_SEL_Z (64546) */
	'D', 'S', 'T', '_', 'S', 'E', 'L', '_', 'W', '\0', /* DST_SEL_W (64556) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'I', 'N', 'V', 'A', 'L', 'I', 'D', '\0', /* GFX10_FORMAT_INVALID (64566) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_8_UNORM (64587) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_8_SNORM (64608) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_8_USCALED (64629) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_8_SSCALED (64652) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_8_UINT (64675) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_8_SINT (64695) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_16_UNORM (64715) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_16_SNORM (64737) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_16_USCALED (64759) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_16_SSCALED (64783) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_16_UINT (64807) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_16_SINT (64828) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_16_FLOAT (64849) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_8_8_UNORM (64871) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_8_8_SNORM (64894) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_8_8_USCALED (64917) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_8_8_SSCALED (64942) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_8_8_UINT (64967) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_8_8_SINT (64989) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_UINT (65011) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_SINT (65032) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_32_FLOAT (65053) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_16_16_UNORM (65075) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_16_16_SNORM (65100) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_16_16_USCALED (65125) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_16_16_SSCALED (65152) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_16_16_UINT (65179) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_16_16_SINT (65203) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_16_16_FLOAT (65227) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_10_11_11_UNORM (65252) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_10_11_11_SNORM (65280) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_10_11_11_USCALED (65308) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_10_11_11_SSCALED (65338) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_10_11_11_UINT (65368) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_10_11_11_SINT (65395) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_10_11_11_FLOAT (65422) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '1', '_', '1', '1', '_', '1', '0', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_11_11_10_UNORM (65450) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '1', '_', '1', '1', '_', '1', '0', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_11_11_10_SNORM (65478) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '1', '_', '1', '1', '_', '1', '0', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_11_11_10_USCALED (65506) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '1', '_', '1', '1', '_', '1', '0', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_11_11_10_SSCALED (65536) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '1', '_', '1', '1', '_', '1', '0', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_11_11_10_UINT (65566) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '1', '_', '1', '1', '_', '1', '0', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_11_11_10_SINT (65593) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '1', '_', '1', '1', '_', '1', '0', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_11_11_10_FLOAT (65620) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', '2', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_10_10_10_2_UNORM (65648) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', '2', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_10_10_10_2_SNORM (65678) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', '2', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_10_10_10_2_USCALED (65708) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', '2', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_10_10_10_2_SSCALED (65740) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', '2', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_10_10_10_2_UINT (65772) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', '2', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_10_10_10_2_SINT (65801) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_2_10_10_10_UNORM (65830) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_2_10_10_10_SNORM (65860) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_2_10_10_10_USCALED (65890) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_2_10_10_10_SSCALED (65922) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_2_10_10_10_UINT (65954) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_2_10_10_10_SINT (65983) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_8_8_8_8_UNORM (66012) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_8_8_8_8_SNORM (66039) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_8_8_8_8_USCALED (66066) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_8_8_8_8_SSCALED (66095) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_8_8_8_8_UINT (66124) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_8_8_8_8_SINT (66150) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_32_UINT (66176) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_32_SINT (66200) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_32_32_FLOAT (66224) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_16_16_16_16_UNORM (66249) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_16_16_16_16_SNORM (66280) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_16_16_16_16_USCALED (66311) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_16_16_16_16_SSCALED (66344) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_16_16_16_16_UINT (66377) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_16_16_16_16_SINT (66407) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_16_16_16_16_FLOAT (66437) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_32_32_UINT (66468) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_32_32_SINT (66495) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_32_32_32_FLOAT (66522) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_32_32_32_UINT (66550) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_32_32_32_SINT (66580) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_32_32_32_32_FLOAT (66610) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_8_SRGB (66641) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_8_8_SRGB (66661) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_8_8_8_8_SRGB (66683) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '6', 'E', '4', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_6E4_FLOAT (66709) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '5', '_', '9', '_', '9', '_', '9', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_5_9_9_9_FLOAT (66732) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '5', '_', '6', '_', '5', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_5_6_5_UNORM (66759) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '_', '5', '_', '5', '_', '5', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_1_5_5_5_UNORM (66784) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '5', '_', '5', '_', '5', '_', '1', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_5_5_5_1_UNORM (66811) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '4', '_', '4', '_', '4', '_', '4', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_4_4_4_4_UNORM (66838) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '4', '_', '4', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_4_4_UNORM (66865) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_1_UNORM (66888) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '_', 'R', 'E', 'V', 'E', 'R', 'S', 'E', 'D', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_1_REVERSED_UNORM (66909) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', 'F', 'L', 'O', 'A', 'T', '_', 'C', 'L', 'A', 'M', 'P', '\0', /* GFX10_FORMAT_32_FLOAT_CLAMP (66939) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '2', '4', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_8_24_UNORM (66967) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '2', '4', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_8_24_UINT (66991) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '4', '_', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_24_8_UNORM (67014) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '4', '_', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_24_8_UINT (67038) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'X', '2', '4', '_', '8', '_', '3', '2', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_X24_8_32_UINT (67061) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'X', '2', '4', '_', '8', '_', '3', '2', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_X24_8_32_FLOAT (67088) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'G', 'B', '_', 'G', 'R', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_GB_GR_UNORM (67116) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'G', 'B', '_', 'G', 'R', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_GB_GR_SNORM (67141) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'G', 'B', '_', 'G', 'R', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_GB_GR_UINT (67166) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'G', 'B', '_', 'G', 'R', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_GB_GR_SRGB (67190) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'G', '_', 'R', 'G', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BG_RG_UNORM (67214) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'G', '_', 'R', 'G', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BG_RG_SNORM (67239) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'G', '_', 'R', 'G', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_BG_RG_UINT (67264) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'G', '_', 'R', 'G', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_BG_RG_SRGB (67288) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '8', '_', 'S', '2', '_', 'F', '1', '\0', /* GFX10_FORMAT_FMASK8_S2_F1 (67312) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '8', '_', 'S', '4', '_', 'F', '1', '\0', /* GFX10_FORMAT_FMASK8_S4_F1 (67338) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '8', '_', 'S', '8', '_', 'F', '1', '\0', /* GFX10_FORMAT_FMASK8_S8_F1 (67364) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '8', '_', 'S', '2', '_', 'F', '2', '\0', /* GFX10_FORMAT_FMASK8_S2_F2 (67390) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '8', '_', 'S', '4', '_', 'F', '2', '\0', /* GFX10_FORMAT_FMASK8_S4_F2 (67416) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '8', '_', 'S', '4', '_', 'F', '4', '\0', /* GFX10_FORMAT_FMASK8_S4_F4 (67442) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '1', '6', '_', 'S', '1', '6', '_', 'F', '1', '\0', /* GFX10_FORMAT_FMASK16_S16_F1 (67468) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '1', '6', '_', 'S', '8', '_', 'F', '2', '\0', /* GFX10_FORMAT_FMASK16_S8_F2 (67496) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '3', '2', '_', 'S', '1', '6', '_', 'F', '2', '\0', /* GFX10_FORMAT_FMASK32_S16_F2 (67523) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '3', '2', '_', 'S', '8', '_', 'F', '4', '\0', /* GFX10_FORMAT_FMASK32_S8_F4 (67551) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '3', '2', '_', 'S', '8', '_', 'F', '8', '\0', /* GFX10_FORMAT_FMASK32_S8_F8 (67578) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '6', '4', '_', 'S', '1', '6', '_', 'F', '4', '\0', /* GFX10_FORMAT_FMASK64_S16_F4 (67605) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '6', '4', '_', 'S', '1', '6', '_', 'F', '8', '\0', /* GFX10_FORMAT_FMASK64_S16_F8 (67633) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '1', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC1_UNORM (67661) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '1', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_BC1_SRGB (67684) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '2', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC2_UNORM (67706) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '2', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_BC2_SRGB (67729) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '3', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC3_UNORM (67751) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '3', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_BC3_SRGB (67774) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '4', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC4_UNORM (67796) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '4', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC4_SNORM (67819) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '5', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC5_UNORM (67842) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '5', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC5_SNORM (67865) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '6', '_', 'U', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_BC6_UFLOAT (67888) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '6', '_', 'S', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_BC6_SFLOAT (67912) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '7', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC7_UNORM (67936) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '7', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_BC7_SRGB (67959) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_8_UNORM (67981) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_8_UINT (68005) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '8', '_', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_8_8_UNORM (68028) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '8', '_', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_8_8_UINT (68054) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_8_8_8_8_UNORM (68079) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_8_8_8_8_UINT (68109) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', 'V', 'Y', 'U', 'Y', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_VYUY8_UNORM (68138) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', 'V', 'Y', 'U', 'Y', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_VYUY8_UINT (68166) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_10_11_11_UNORM (68193) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_10_11_11_UINT (68224) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_2_10_10_10_UNORM (68254) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_2_10_10_10_UINT (68287) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_16_16_16_16_UNORM (68319) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_16_16_16_16_UINT (68353) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', 'I', 'N', '_', '1', '6', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_10_IN_16_UNORM (68386) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', 'I', 'N', '_', '1', '6', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_10_IN_16_UINT (68417) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', 'I', 'N', '_', '1', '6', '_', '1', '6', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_10_IN_16_16_UNORM (68447) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', 'I', 'N', '_', '1', '6', '_', '1', '6', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_10_IN_16_16_UINT (68481) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', 'I', 'N', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'U', 'N', 'O', 'R', 'M', ' ', '\0', /* GFX10_FORMAT_MM_10_IN_16_16_16_16_UNORM  (68514) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', 'I', 'N', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_10_IN_16_16_16_16_UINT (68555) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '7', 'E', '3', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_7E3_FLOAT (68594) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'Y', 'C', 'B', 'C', 'R', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_YCBCR_UNORM (68617) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'Y', 'C', 'B', 'C', 'R', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_YCBCR_SNORM (68642) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'Y', 'C', 'B', 'C', 'R', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_YCBCR_USCALED (68667) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'Y', 'C', 'B', 'C', 'R', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_YCBCR_SSCALED (68694) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'Y', 'C', 'B', 'C', 'R', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_YCBCR_UINT (68721) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'Y', 'C', 'B', 'C', 'R', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_YCBCR_SINT (68745) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'Y', 'C', 'B', 'C', 'R', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_YCBCR_SRGB (68769) */
	'I', 'N', 'D', 'E', 'X', '_', 'S', 'T', 'R', 'I', 'D', 'E', '\0', /* INDEX_STRIDE (68793) */
	'A', 'D', 'D', '_', 'T', 'I', 'D', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* ADD_TID_ENABLE (68806) */
	'R', 'E', 'S', 'O', 'U', 'R', 'C', 'E', '_', 'L', 'E', 'V', 'E', 'L', '\0', /* RESOURCE_LEVEL (68821) */
	'O', 'O', 'B', '_', 'S', 'E', 'L', 'E', 'C', 'T', '_', 'S', 'T', 'R', 'U', 'C', 'T', 'U', 'R', 'E', 'D', '_', 'W', 'I', 'T', 'H', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* OOB_SELECT_STRUCTURED_WITH_OFFSET (68836) */
	'O', 'O', 'B', '_', 'S', 'E', 'L', 'E', 'C', 'T', '_', 'S', 'T', 'R', 'U', 'C', 'T', 'U', 'R', 'E', 'D', '\0', /* OOB_SELECT_STRUCTURED (68870) */
	'O', 'O', 'B', '_', 'S', 'E', 'L', 'E', 'C', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', 'D', '\0', /* OOB_SELECT_DISABLED (68892) */
	'O', 'O', 'B', '_', 'S', 'E', 'L', 'E', 'C', 'T', '_', 'R', 'A', 'W', '\0', /* OOB_SELECT_RAW (68912, 68923) */
	'O', 'O', 'B', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* OOB_SELECT (68927) */
	'C', 'L', 'A', 'M', 'P', '_', 'X', '\0', /* CLAMP_X (68938) */
	'C', 'L', 'A', 'M', 'P', '_', 'Y', '\0', /* CLAMP_Y (68946) */
	'C', 'L', 'A', 'M', 'P', '_', 'Z', '\0', /* CLAMP_Z (68954) */
	'M', 'A', 'X', '_', 'A', 'N', 'I', 'S', 'O', '_', 'R', 'A', 'T', 'I', 'O', '\0', /* MAX_ANISO_RATIO (68962) */
	'D', 'E', 'P', 'T', 'H', '_', 'C', 'O', 'M', 'P', 'A', 'R', 'E', '_', 'F', 'U', 'N', 'C', '\0', /* DEPTH_COMPARE_FUNC (68978) */
	'F', 'O', 'R', 'C', 'E', '_', 'U', 'N', 'N', 'O', 'R', 'M', 'A', 'L', 'I', 'Z', 'E', 'D', '\0', /* FORCE_UNNORMALIZED (68997) */
	'A', 'N', 'I', 'S', 'O', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', '\0', /* ANISO_THRESHOLD (69016) */
	'M', 'C', '_', 'C', 'O', 'O', 'R', 'D', '_', 'T', 'R', 'U', 'N', 'C', '\0', /* MC_COORD_TRUNC (69032) */
	'F', 'O', 'R', 'C', 'E', '_', 'D', 'E', 'G', 'A', 'M', 'M', 'A', '\0', /* FORCE_DEGAMMA (69047) */
	'A', 'N', 'I', 'S', 'O', '_', 'B', 'I', 'A', 'S', '\0', /* ANISO_BIAS (69061) */
	'T', 'R', 'U', 'N', 'C', '_', 'C', 'O', 'O', 'R', 'D', '\0', /* TRUNC_COORD (69072) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'C', 'U', 'B', 'E', '_', 'W', 'R', 'A', 'P', '\0', /* DISABLE_CUBE_WRAP (69084, 69097) */
	'F', 'I', 'L', 'T', 'E', 'R', '_', 'M', 'O', 'D', 'E', '\0', /* FILTER_MODE (69102) */
	'S', 'K', 'I', 'P', '_', 'D', 'E', 'G', 'A', 'M', 'M', 'A', '\0', /* SKIP_DEGAMMA (69114) */
	'M', 'I', 'N', '_', 'L', 'O', 'D', '\0', /* MIN_LOD (69127) */
	'M', 'A', 'X', '_', 'L', 'O', 'D', '\0', /* MAX_LOD (69135) */
	'P', 'E', 'R', 'F', '_', 'M', 'I', 'P', '\0', /* PERF_MIP (69143) */
	'P', 'E', 'R', 'F', '_', 'Z', '\0', /* PERF_Z (69152) */
	'L', 'O', 'D', '_', 'B', 'I', 'A', 'S', '\0', /* LOD_BIAS (69159) */
	'L', 'O', 'D', '_', 'B', 'I', 'A', 'S', '_', 'S', 'E', 'C', '\0', /* LOD_BIAS_SEC (69168) */
	'X', 'Y', '_', 'M', 'A', 'G', '_', 'F', 'I', 'L', 'T', 'E', 'R', '\0', /* XY_MAG_FILTER (69181) */
	'X', 'Y', '_', 'M', 'I', 'N', '_', 'F', 'I', 'L', 'T', 'E', 'R', '\0', /* XY_MIN_FILTER (69195) */
	'Z', '_', 'F', 'I', 'L', 'T', 'E', 'R', '\0', /* Z_FILTER (69209) */
	'M', 'I', 'P', '_', 'F', 'I', 'L', 'T', 'E', 'R', '\0', /* MIP_FILTER (69218) */
	'M', 'I', 'P', '_', 'P', 'O', 'I', 'N', 'T', '_', 'P', 'R', 'E', 'C', 'L', 'A', 'M', 'P', '\0', /* MIP_POINT_PRECLAMP (69229) */
	'A', 'N', 'I', 'S', 'O', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* ANISO_OVERRIDE (69248) */
	'B', 'L', 'E', 'N', 'D', '_', 'Z', 'E', 'R', 'O', '_', 'P', 'R', 'T', '\0', /* BLEND_ZERO_PRT (69263, 69274) */
	'B', 'O', 'R', 'D', 'E', 'R', '_', 'C', 'O', 'L', 'O', 'R', '_', 'P', 'T', 'R', '\0', /* BORDER_COLOR_PTR (69278) */
	'B', 'O', 'R', 'D', 'E', 'R', '_', 'C', 'O', 'L', 'O', 'R', '_', 'T', 'Y', 'P', 'E', '\0', /* BORDER_COLOR_TYPE (69295) */
	'G', 'P', 'R', '_', 'W', 'R', 'I', 'T', 'E', '_', 'P', 'R', 'I', 'O', 'R', 'I', 'T', 'Y', '\0', /* GPR_WRITE_PRIORITY (69313, 69323) */
	'E', 'X', 'P', '_', 'P', 'R', 'I', 'O', 'R', 'I', 'T', 'Y', '_', 'O', 'R', 'D', 'E', 'R', '\0', /* EXP_PRIORITY_ORDER (69332) */
	'E', 'N', 'A', 'B', 'L', 'E', '_', 'S', 'Q', 'G', '_', 'T', 'O', 'P', '_', 'E', 'V', 'E', 'N', 'T', 'S', '\0', /* ENABLE_SQG_TOP_EVENTS (69351) */
	'E', 'N', 'A', 'B', 'L', 'E', '_', 'S', 'Q', 'G', '_', 'B', 'O', 'P', '_', 'E', 'V', 'E', 'N', 'T', 'S', '\0', /* ENABLE_SQG_BOP_EVENTS (69373) */
	'R', 'S', 'R', 'C', '_', 'M', 'G', 'M', 'T', '_', 'R', 'E', 'S', 'E', 'T', '\0', /* RSRC_MGMT_RESET (69395) */
	'T', 'T', 'R', 'A', 'C', 'E', '_', 'S', 'T', 'A', 'L', 'L', '_', 'A', 'L', 'L', '\0', /* TTRACE_STALL_ALL (69411) */
	'A', 'L', 'L', 'O', 'C', '_', 'A', 'R', 'B', '_', 'L', 'R', 'U', '_', 'E', 'N', 'A', '\0', /* ALLOC_ARB_LRU_ENA (69428) */
	'E', 'X', 'P', '_', 'A', 'R', 'B', '_', 'L', 'R', 'U', '_', 'E', 'N', 'A', '\0', /* EXP_ARB_LRU_ENA (69446) */
	'P', 'S', '_', 'P', 'K', 'R', '_', 'P', 'R', 'I', 'O', 'R', 'I', 'T', 'Y', '_', 'C', 'N', 'T', 'L', '\0', /* PS_PKR_PRIORITY_CNTL (69462) */
	'N', 'U', 'M', '_', 'P', 'I', 'P', 'E', 'S', '\0', /* NUM_PIPES (69483) */
	'P', 'I', 'P', 'E', '_', 'I', 'N', 'T', 'E', 'R', 'L', 'E', 'A', 'V', 'E', '_', 'S', 'I', 'Z', 'E', '\0', /* PIPE_INTERLEAVE_SIZE (69493) */
	'M', 'A', 'X', '_', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', 'E', 'D', '_', 'F', 'R', 'A', 'G', 'S', '\0', /* MAX_COMPRESSED_FRAGS (69514) */
	'N', 'U', 'M', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'E', 'N', 'G', 'I', 'N', 'E', 'S', '\0', /* NUM_SHADER_ENGINES (69535) */
	'N', 'U', 'M', '_', 'R', 'B', '_', 'P', 'E', 'R', '_', 'S', 'E', '\0', /* NUM_RB_PER_SE (69554) */
	'A', 'R', 'R', 'A', 'Y', '_', 'L', 'I', 'N', 'E', 'A', 'R', '_', 'G', 'E', 'N', 'E', 'R', 'A', 'L', '\0', /* ARRAY_LINEAR_GENERAL (69568, 69574) */
	'A', 'R', 'R', 'A', 'Y', '_', 'L', 'I', 'N', 'E', 'A', 'R', '_', 'A', 'L', 'I', 'G', 'N', 'E', 'D', '\0', /* ARRAY_LINEAR_ALIGNED (69589) */
	'A', 'R', 'R', 'A', 'Y', '_', '1', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'N', '1', '\0', /* ARRAY_1D_TILED_THIN1 (69610) */
	'A', 'R', 'R', 'A', 'Y', '_', '1', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_1D_TILED_THICK (69631) */
	'A', 'R', 'R', 'A', 'Y', '_', '2', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'N', '1', '\0', /* ARRAY_2D_TILED_THIN1 (69652) */
	'A', 'R', 'R', 'A', 'Y', '_', 'P', 'R', 'T', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'N', '1', '\0', /* ARRAY_PRT_TILED_THIN1 (69673) */
	'A', 'R', 'R', 'A', 'Y', '_', 'P', 'R', 'T', '_', '2', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'N', '1', '\0', /* ARRAY_PRT_2D_TILED_THIN1 (69695) */
	'A', 'R', 'R', 'A', 'Y', '_', '2', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_2D_TILED_THICK (69720) */
	'A', 'R', 'R', 'A', 'Y', '_', '2', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'X', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_2D_TILED_XTHICK (69741) */
	'A', 'R', 'R', 'A', 'Y', '_', 'P', 'R', 'T', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_PRT_TILED_THICK (69763) */
	'A', 'R', 'R', 'A', 'Y', '_', 'P', 'R', 'T', '_', '2', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_PRT_2D_TILED_THICK (69785) */
	'A', 'R', 'R', 'A', 'Y', '_', 'P', 'R', 'T', '_', '3', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'N', '1', '\0', /* ARRAY_PRT_3D_TILED_THIN1 (69810) */
	'A', 'R', 'R', 'A', 'Y', '_', '3', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'N', '1', '\0', /* ARRAY_3D_TILED_THIN1 (69835) */
	'A', 'R', 'R', 'A', 'Y', '_', '3', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_3D_TILED_THICK (69856) */
	'A', 'R', 'R', 'A', 'Y', '_', '3', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'X', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_3D_TILED_XTHICK (69877) */
	'A', 'R', 'R', 'A', 'Y', '_', 'P', 'R', 'T', '_', '3', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_PRT_3D_TILED_THICK (69899) */
	'A', 'R', 'R', 'A', 'Y', '_', 'M', 'O', 'D', 'E', '\0', /* ARRAY_MODE (69924) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '2', '\0', /* ADDR_SURF_P2 (69935) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '2', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '0', '\0', /* ADDR_SURF_P2_RESERVED0 (69948) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '2', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '1', '\0', /* ADDR_SURF_P2_RESERVED1 (69971, 69984) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '2', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '2', '\0', /* ADDR_SURF_P2_RESERVED2 (69994, 70007) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '4', '_', '8', 'x', '1', '6', '\0', /* ADDR_SURF_P4_8x16 (70017) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '4', '_', '1', '6', 'x', '1', '6', '\0', /* ADDR_SURF_P4_16x16 (70035) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '4', '_', '1', '6', 'x', '3', '2', '\0', /* ADDR_SURF_P4_16x32 (70054) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '4', '_', '3', '2', 'x', '3', '2', '\0', /* ADDR_SURF_P4_32x32 (70073) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', '1', '6', 'x', '1', '6', '_', '8', 'x', '1', '6', '\0', /* ADDR_SURF_P8_16x16_8x16 (70092) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', '1', '6', 'x', '3', '2', '_', '8', 'x', '1', '6', '\0', /* ADDR_SURF_P8_16x32_8x16 (70116) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', '3', '2', 'x', '3', '2', '_', '8', 'x', '1', '6', '\0', /* ADDR_SURF_P8_32x32_8x16 (70140) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', '1', '6', 'x', '3', '2', '_', '1', '6', 'x', '1', '6', '\0', /* ADDR_SURF_P8_16x32_16x16 (70164) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', '3', '2', 'x', '3', '2', '_', '1', '6', 'x', '1', '6', '\0', /* ADDR_SURF_P8_32x32_16x16 (70189) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', '3', '2', 'x', '3', '2', '_', '1', '6', 'x', '3', '2', '\0', /* ADDR_SURF_P8_32x32_16x32 (70214) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', '3', '2', 'x', '6', '4', '_', '3', '2', 'x', '3', '2', '\0', /* ADDR_SURF_P8_32x64_32x32 (70239) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '0', '\0', /* ADDR_SURF_P8_RESERVED0 (70264) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '1', '6', '_', '3', '2', 'x', '3', '2', '_', '8', 'x', '1', '6', '\0', /* ADDR_SURF_P16_32x32_8x16 (70287) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '1', '6', '_', '3', '2', 'x', '3', '2', '_', '1', '6', 'x', '1', '6', '\0', /* ADDR_SURF_P16_32x32_16x16 (70312) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '1', '6', '\0', /* ADDR_SURF_P16 (70338) */
	'P', 'I', 'P', 'E', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* PIPE_CONFIG (70352) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '_', '6', '4', 'B', '\0', /* ADDR_SURF_TILE_SPLIT_64B (70364) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '_', '1', '2', '8', 'B', '\0', /* ADDR_SURF_TILE_SPLIT_128B (70389) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '_', '2', '5', '6', 'B', '\0', /* ADDR_SURF_TILE_SPLIT_256B (70415) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '_', '5', '1', '2', 'B', '\0', /* ADDR_SURF_TILE_SPLIT_512B (70441) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '_', '1', 'K', 'B', '\0', /* ADDR_SURF_TILE_SPLIT_1KB (70467) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '_', '2', 'K', 'B', '\0', /* ADDR_SURF_TILE_SPLIT_2KB (70492) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '_', '4', 'K', 'B', '\0', /* ADDR_SURF_TILE_SPLIT_4KB (70517) */
	'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '\0', /* TILE_SPLIT (70542) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'D', 'I', 'S', 'P', 'L', 'A', 'Y', '_', 'M', 'I', 'C', 'R', 'O', '_', 'T', 'I', 'L', 'I', 'N', 'G', '\0', /* ADDR_SURF_DISPLAY_MICRO_TILING (70553) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'H', 'I', 'N', '_', 'M', 'I', 'C', 'R', 'O', '_', 'T', 'I', 'L', 'I', 'N', 'G', '\0', /* ADDR_SURF_THIN_MICRO_TILING (70584) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'D', 'E', 'P', 'T', 'H', '_', 'M', 'I', 'C', 'R', 'O', '_', 'T', 'I', 'L', 'I', 'N', 'G', '\0', /* ADDR_SURF_DEPTH_MICRO_TILING (70612) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'R', 'O', 'T', 'A', 'T', 'E', 'D', '_', 'M', 'I', 'C', 'R', 'O', '_', 'T', 'I', 'L', 'I', 'N', 'G', '\0', /* ADDR_SURF_ROTATED_MICRO_TILING (70641) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'H', 'I', 'C', 'K', '_', 'M', 'I', 'C', 'R', 'O', '_', 'T', 'I', 'L', 'I', 'N', 'G', '\0', /* ADDR_SURF_THICK_MICRO_TILING (70672) */
	'M', 'I', 'C', 'R', 'O', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '_', 'N', 'E', 'W', '\0', /* MICRO_TILE_MODE_NEW (70701) */
	'S', 'A', 'M', 'P', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '\0', /* SAMPLE_SPLIT (70721) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'W', 'I', 'D', 'T', 'H', '_', '1', '\0', /* ADDR_SURF_BANK_WIDTH_1 (70734) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'W', 'I', 'D', 'T', 'H', '_', '2', '\0', /* ADDR_SURF_BANK_WIDTH_2 (70757) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'W', 'I', 'D', 'T', 'H', '_', '4', '\0', /* ADDR_SURF_BANK_WIDTH_4 (70780) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'W', 'I', 'D', 'T', 'H', '_', '8', '\0', /* ADDR_SURF_BANK_WIDTH_8 (70803) */
	'B', 'A', 'N', 'K', '_', 'W', 'I', 'D', 'T', 'H', '\0', /* BANK_WIDTH (70826, 70831) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'H', 'E', 'I', 'G', 'H', 'T', '_', '1', '\0', /* ADDR_SURF_BANK_HEIGHT_1 (70837) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'H', 'E', 'I', 'G', 'H', 'T', '_', '2', '\0', /* ADDR_SURF_BANK_HEIGHT_2 (70861) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'H', 'E', 'I', 'G', 'H', 'T', '_', '4', '\0', /* ADDR_SURF_BANK_HEIGHT_4 (70885) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'H', 'E', 'I', 'G', 'H', 'T', '_', '8', '\0', /* ADDR_SURF_BANK_HEIGHT_8 (70909) */
	'B', 'A', 'N', 'K', '_', 'H', 'E', 'I', 'G', 'H', 'T', '\0', /* BANK_HEIGHT (70933, 70938) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'M', 'A', 'C', 'R', 'O', '_', 'A', 'S', 'P', 'E', 'C', 'T', '_', '1', '\0', /* ADDR_SURF_MACRO_ASPECT_1 (70945) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'M', 'A', 'C', 'R', 'O', '_', 'A', 'S', 'P', 'E', 'C', 'T', '_', '2', '\0', /* ADDR_SURF_MACRO_ASPECT_2 (70970) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'M', 'A', 'C', 'R', 'O', '_', 'A', 'S', 'P', 'E', 'C', 'T', '_', '4', '\0', /* ADDR_SURF_MACRO_ASPECT_4 (70995) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'M', 'A', 'C', 'R', 'O', '_', 'A', 'S', 'P', 'E', 'C', 'T', '_', '8', '\0', /* ADDR_SURF_MACRO_ASPECT_8 (71020) */
	'M', 'A', 'C', 'R', 'O', '_', 'T', 'I', 'L', 'E', '_', 'A', 'S', 'P', 'E', 'C', 'T', '\0', /* MACRO_TILE_ASPECT (71045) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', '2', '_', 'B', 'A', 'N', 'K', '\0', /* ADDR_SURF_2_BANK (71063) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', '4', '_', 'B', 'A', 'N', 'K', '\0', /* ADDR_SURF_4_BANK (71080) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', '8', '_', 'B', 'A', 'N', 'K', '\0', /* ADDR_SURF_8_BANK (71097) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', '1', '6', '_', 'B', 'A', 'N', 'K', '\0', /* ADDR_SURF_16_BANK (71114) */
	'N', 'U', 'M', '_', 'B', 'A', 'N', 'K', 'S', '\0', /* NUM_BANKS (71132) */
	'W', 'I', 'D', 'T', 'H', '_', 'L', 'O', '\0', /* WIDTH_LO (71142) */
	'W', 'I', 'D', 'T', 'H', '_', 'H', 'I', '\0', /* WIDTH_HI (71151) */
	'B', 'A', 'S', 'E', '_', 'L', 'E', 'V', 'E', 'L', '\0', /* BASE_LEVEL (71160) */
	'L', 'A', 'S', 'T', '_', 'L', 'E', 'V', 'E', 'L', '\0', /* LAST_LEVEL (71171) */
	'S', 'W', '_', 'M', 'O', 'D', 'E', '\0', /* SW_MODE (71182) */
	'B', 'C', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '_', 'X', 'Y', 'Z', 'W', '\0', /* BC_SWIZZLE_XYZW (71190) */
	'B', 'C', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '_', 'X', 'W', 'Y', 'Z', '\0', /* BC_SWIZZLE_XWYZ (71206) */
	'B', 'C', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '_', 'W', 'Z', 'Y', 'X', '\0', /* BC_SWIZZLE_WZYX (71222) */
	'B', 'C', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '_', 'W', 'X', 'Y', 'Z', '\0', /* BC_SWIZZLE_WXYZ (71238) */
	'B', 'C', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '_', 'Z', 'Y', 'X', 'W', '\0', /* BC_SWIZZLE_ZYXW (71254) */
	'B', 'C', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '_', 'Y', 'X', 'W', 'Z', '\0', /* BC_SWIZZLE_YXWZ (71270) */
	'B', 'C', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '\0', /* BC_SWIZZLE (71286) */
	'B', 'A', 'S', 'E', '_', 'A', 'R', 'R', 'A', 'Y', '\0', /* BASE_ARRAY (71297) */
	'A', 'R', 'R', 'A', 'Y', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* ARRAY_PITCH (71308) */
	'M', 'A', 'X', '_', 'M', 'I', 'P', '\0', /* MAX_MIP (71320) */
	'M', 'I', 'N', '_', 'L', 'O', 'D', '_', 'W', 'A', 'R', 'N', '\0', /* MIN_LOD_WARN (71328) */
	'P', 'E', 'R', 'F', '_', 'M', 'O', 'D', '\0', /* PERF_MOD (71341) */
	'C', 'O', 'R', 'N', 'E', 'R', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '\0', /* CORNER_SAMPLES (71350) */
	'L', 'O', 'D', '_', 'H', 'D', 'W', '_', 'C', 'N', 'T', '_', 'E', 'N', '\0', /* LOD_HDW_CNT_EN (71365) */
	'P', 'R', 'T', '_', 'D', 'E', 'F', 'A', 'U', 'L', 'T', '\0', /* PRT_DEFAULT (71380) */
	'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'B', 'A', 'N', 'K', '_', 'I', 'D', '\0', /* COUNTER_BANK_ID (71392) */
	'I', 'T', 'E', 'R', 'A', 'T', 'E', '_', '2', '5', '6', '\0', /* ITERATE_256 (71408) */
	'M', 'A', 'X', '_', 'U', 'N', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', 'E', 'D', '_', 'B', 'L', 'O', 'C', 'K', '_', 'S', 'I', 'Z', 'E', '\0', /* MAX_UNCOMPRESSED_BLOCK_SIZE (71420) */
	'M', 'A', 'X', '_', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', 'E', 'D', '_', 'B', 'L', 'O', 'C', 'K', '_', 'S', 'I', 'Z', 'E', '\0', /* MAX_COMPRESSED_BLOCK_SIZE (71448) */
	'M', 'E', 'T', 'A', '_', 'P', 'I', 'P', 'E', '_', 'A', 'L', 'I', 'G', 'N', 'E', 'D', '\0', /* META_PIPE_ALIGNED (71474, 71479) */
	'W', 'R', 'I', 'T', 'E', '_', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* WRITE_COMPRESS_ENABLE (71492) */
	'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', 'I', 'O', 'N', '_', 'E', 'N', '\0', /* COMPRESSION_EN (71514) */
	'A', 'L', 'P', 'H', 'A', '_', 'I', 'S', '_', 'O', 'N', '_', 'M', 'S', 'B', '\0', /* ALPHA_IS_ON_MSB (71529) */
	'C', 'O', 'L', 'O', 'R', '_', 'T', 'R', 'A', 'N', 'S', 'F', 'O', 'R', 'M', '\0', /* COLOR_TRANSFORM (71545) */
	'M', 'E', 'T', 'A', '_', 'D', 'A', 'T', 'A', '_', 'A', 'D', 'D', 'R', 'E', 'S', 'S', '_', 'L', 'O', '\0', /* META_DATA_ADDRESS_LO (71561) */
	'M', 'O', 'R', 'E', '_', 'F', 'A', 'U', 'L', 'T', 'S', '\0', /* MORE_FAULTS (71582) */
	'W', 'A', 'L', 'K', 'E', 'R', '_', 'E', 'R', 'R', 'O', 'R', '\0', /* WALKER_ERROR (71594) */
	'P', 'E', 'R', 'M', 'I', 'S', 'S', 'I', 'O', 'N', '_', 'F', 'A', 'U', 'L', 'T', 'S', '\0', /* PERMISSION_FAULTS (71607) */
	'M', 'A', 'P', 'P', 'I', 'N', 'G', '_', 'E', 'R', 'R', 'O', 'R', '\0', /* MAPPING_ERROR (71625) */
	'C', 'I', 'D', '\0', /* CID (71639) */
	'R', 'W', '\0', /* RW (71643) */
	'V', 'F', '\0', /* VF (71646) */
	'V', 'F', 'I', 'D', '\0', /* VFID (71649) */
	'C', 'U', '_', 'E', 'N', '\0', /* CU_EN (71654) */
	'W', 'A', 'V', 'E', '_', 'L', 'I', 'M', 'I', 'T', '\0', /* WAVE_LIMIT (71660, 71665) */
	'L', 'O', 'C', 'K', '_', 'L', 'O', 'W', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', '\0', /* LOCK_LOW_THRESHOLD (71671) */
	'M', 'E', 'M', '_', 'B', 'A', 'S', 'E', '\0', /* MEM_BASE (71690) */
	'V', 'G', 'P', 'R', 'S', '\0', /* VGPRS (71699) */
	'S', 'G', 'P', 'R', 'S', '\0', /* SGPRS (71705) */
	'F', 'P', '_', '3', '2', '_', 'R', 'O', 'U', 'N', 'D', '_', 'T', 'O', 'W', 'A', 'R', 'D', 'S', '_', 'Z', 'E', 'R', 'O', '\0', /* FP_32_ROUND_TOWARDS_ZERO (71711) */
	'F', 'P', '_', '1', '6', '_', '6', '4', '_', 'R', 'O', 'U', 'N', 'D', '_', 'T', 'O', 'W', 'A', 'R', 'D', 'S', '_', 'Z', 'E', 'R', 'O', '\0', /* FP_16_64_ROUND_TOWARDS_ZERO (71736) */
	'F', 'P', '_', '3', '2', '_', 'D', 'E', 'N', 'O', 'R', 'M', 'S', '\0', /* FP_32_DENORMS (71764) */
	'F', 'P', '_', '1', '6', '_', '6', '4', '_', 'D', 'E', 'N', 'O', 'R', 'M', 'S', '\0', /* FP_16_64_DENORMS (71778) */
	'F', 'L', 'O', 'A', 'T', '_', 'M', 'O', 'D', 'E', '\0', /* FLOAT_MODE (71795) */
	'I', 'E', 'E', 'E', '_', 'M', 'O', 'D', 'E', '\0', /* IEEE_MODE (71806) */
	'C', 'U', '_', 'G', 'R', 'O', 'U', 'P', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* CU_GROUP_DISABLE (71816) */
	'M', 'E', 'M', '_', 'O', 'R', 'D', 'E', 'R', 'E', 'D', '\0', /* MEM_ORDERED (71833) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'E', 'N', '\0', /* SCRATCH_EN (71845) */
	'U', 'S', 'E', 'R', '_', 'S', 'G', 'P', 'R', '\0', /* USER_SGPR (71856) */
	'T', 'R', 'A', 'P', '_', 'P', 'R', 'E', 'S', 'E', 'N', 'T', '\0', /* TRAP_PRESENT (71866) */
	'W', 'A', 'V', 'E', '_', 'C', 'N', 'T', '_', 'E', 'N', '\0', /* WAVE_CNT_EN (71879) */
	'E', 'X', 'T', 'R', 'A', '_', 'L', 'D', 'S', '_', 'S', 'I', 'Z', 'E', '\0', /* EXTRA_LDS_SIZE (71891) */
	'L', 'O', 'A', 'D', '_', 'C', 'O', 'L', 'L', 'I', 'S', 'I', 'O', 'N', '_', 'W', 'A', 'V', 'E', 'I', 'D', '\0', /* LOAD_COLLISION_WAVEID (71906) */
	'L', 'O', 'A', 'D', '_', 'I', 'N', 'T', 'R', 'A', 'W', 'A', 'V', 'E', '_', 'C', 'O', 'L', 'L', 'I', 'S', 'I', 'O', 'N', '\0', /* LOAD_INTRAWAVE_COLLISION (71928) */
	'U', 'S', 'E', 'R', '_', 'S', 'G', 'P', 'R', '_', 'M', 'S', 'B', '\0', /* USER_SGPR_MSB (71953) */
	'S', 'H', 'A', 'R', 'E', 'D', '_', 'V', 'G', 'P', 'R', '_', 'C', 'N', 'T', '\0', /* SHARED_VGPR_CNT (71967) */
	'S', 'O', 'F', 'T', '_', 'G', 'R', 'O', 'U', 'P', 'I', 'N', 'G', '_', 'E', 'N', '\0', /* SOFT_GROUPING_EN (71983) */
	'N', 'U', 'M', 'B', 'E', 'R', '_', 'O', 'F', '_', 'R', 'E', 'Q', 'U', 'E', 'S', 'T', 'S', '_', 'P', 'E', 'R', '_', 'C', 'U', '\0', /* NUMBER_OF_REQUESTS_PER_CU (72000) */
	'S', 'O', 'F', 'T', '_', 'G', 'R', 'O', 'U', 'P', 'I', 'N', 'G', '_', 'A', 'L', 'L', 'O', 'C', 'A', 'T', 'I', 'O', 'N', '_', 'T', 'I', 'M', 'E', 'O', 'U', 'T', '\0', /* SOFT_GROUPING_ALLOCATION_TIMEOUT (72026) */
	'H', 'A', 'R', 'D', '_', 'L', 'O', 'C', 'K', '_', 'H', 'Y', 'S', 'T', 'E', 'R', 'E', 'S', 'I', 'S', '\0', /* HARD_LOCK_HYSTERESIS (72059) */
	'H', 'A', 'R', 'D', '_', 'L', 'O', 'C', 'K', '_', 'L', 'O', 'W', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', '\0', /* HARD_LOCK_LOW_THRESHOLD (72080) */
	'P', 'R', 'O', 'D', 'U', 'C', 'E', 'R', '_', 'R', 'E', 'Q', 'U', 'E', 'S', 'T', '_', 'L', 'O', 'C', 'K', 'O', 'U', 'T', '\0', /* PRODUCER_REQUEST_LOCKOUT (72104) */
	'G', 'L', 'O', 'B', 'A', 'L', '_', 'S', 'C', 'A', 'N', 'N', 'I', 'N', 'G', '_', 'E', 'N', '\0', /* GLOBAL_SCANNING_EN (72129) */
	'A', 'L', 'L', 'O', 'C', 'A', 'T', 'I', 'O', 'N', '_', 'R', 'A', 'T', 'E', '_', 'T', 'H', 'R', 'O', 'T', 'T', 'L', 'I', 'N', 'G', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', '\0', /* ALLOCATION_RATE_THROTTLING_THRESHOLD (72148) */
	'T', 'O', 'T', 'A', 'L', '_', 'W', 'A', 'V', 'E', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TOTAL_WAVE_COUNT_HIER_SELECT (72185) */
	'P', 'E', 'R', '_', 'T', 'Y', 'P', 'E', '_', 'W', 'A', 'V', 'E', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PER_TYPE_WAVE_COUNT_HIER_SELECT (72214) */
	'G', 'R', 'O', 'U', 'P', '_', 'U', 'P', 'D', 'A', 'T', 'E', '_', 'E', 'N', '\0', /* GROUP_UPDATE_EN (72246) */
	'T', 'O', 'T', 'A', 'L', '_', 'W', 'A', 'V', 'E', '_', 'C', 'O', 'U', 'N', 'T', '_', 'C', 'O', 'E', 'F', 'F', 'I', 'C', 'I', 'E', 'N', 'T', '\0', /* TOTAL_WAVE_COUNT_COEFFICIENT (72262) */
	'P', 'E', 'R', '_', 'T', 'Y', 'P', 'E', '_', 'W', 'A', 'V', 'E', '_', 'C', 'O', 'U', 'N', 'T', '_', 'C', 'O', 'E', 'F', 'F', 'I', 'C', 'I', 'E', 'N', 'T', '\0', /* PER_TYPE_WAVE_COUNT_COEFFICIENT (72291) */
	'C', 'O', 'N', 'T', 'R', 'I', 'B', 'U', 'T', 'I', 'O', 'N', '\0', /* CONTRIBUTION (72323) */
	'V', 'G', 'P', 'R', '_', 'C', 'O', 'M', 'P', '_', 'C', 'N', 'T', '\0', /* VGPR_COMP_CNT (72336) */
	'C', 'U', '_', 'G', 'R', 'O', 'U', 'P', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* CU_GROUP_ENABLE (72350) */
	'O', 'C', '_', 'L', 'D', 'S', '_', 'E', 'N', '\0', /* OC_LDS_EN (72366) */
	'S', 'O', '_', 'B', 'A', 'S', 'E', '0', '_', 'E', 'N', '\0', /* SO_BASE0_EN (72376) */
	'S', 'O', '_', 'B', 'A', 'S', 'E', '1', '_', 'E', 'N', '\0', /* SO_BASE1_EN (72388) */
	'S', 'O', '_', 'B', 'A', 'S', 'E', '2', '_', 'E', 'N', '\0', /* SO_BASE2_EN (72400) */
	'S', 'O', '_', 'B', 'A', 'S', 'E', '3', '_', 'E', 'N', '\0', /* SO_BASE3_EN (72412) */
	'S', 'O', '_', 'E', 'N', '\0', /* SO_EN (72424) */
	'P', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'N', '\0', /* PC_BASE_EN (72430) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'D', 'R', 'A', 'W', '_', 'E', 'N', '\0', /* DISPATCH_DRAW_EN (72441) */
	'S', 'K', 'I', 'P', '_', 'U', 'S', 'G', 'P', 'R', '0', '\0', /* SKIP_USGPR0 (72458) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'L', 'A', 'T', 'E', '_', 'A', 'L', 'L', 'O', 'C', '_', 'G', 'S', '\0', /* SPI_SHADER_LATE_ALLOC_GS (72470) */
	'G', 'R', 'O', 'U', 'P', '_', 'F', 'I', 'F', 'O', '_', 'D', 'E', 'P', 'T', 'H', '\0', /* GROUP_FIFO_DEPTH (72495) */
	'W', 'G', 'P', '_', 'M', 'O', 'D', 'E', '\0', /* WGP_MODE (72512) */
	'G', 'S', '_', 'V', 'G', 'P', 'R', '_', 'C', 'O', 'M', 'P', '_', 'C', 'N', 'T', '\0', /* GS_VGPR_COMP_CNT (72521) */
	'E', 'S', '_', 'V', 'G', 'P', 'R', '_', 'C', 'O', 'M', 'P', '_', 'C', 'N', 'T', '\0', /* ES_VGPR_COMP_CNT (72538) */
	'L', 'S', '_', 'V', 'G', 'P', 'R', '_', 'C', 'O', 'M', 'P', '_', 'C', 'N', 'T', '\0', /* LS_VGPR_COMP_CNT (72555) */
	'T', 'G', '_', 'S', 'I', 'Z', 'E', '_', 'E', 'N', '\0', /* TG_SIZE_EN (72572) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'E', 'N', '\0', /* COMPUTE_SHADER_EN (72583) */
	'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'T', 'G', '_', 'E', 'N', '\0', /* PARTIAL_TG_EN (72601) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'T', 'A', 'R', 'T', '_', 'A', 'T', '_', '0', '0', '0', '\0', /* FORCE_START_AT_000 (72615) */
	'O', 'R', 'D', 'E', 'R', 'E', 'D', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'E', 'N', 'B', 'L', '\0', /* ORDERED_APPEND_ENBL (72634) */
	'O', 'R', 'D', 'E', 'R', 'E', 'D', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'M', 'O', 'D', 'E', '\0', /* ORDERED_APPEND_MODE (72654) */
	'U', 'S', 'E', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'D', 'I', 'M', 'E', 'N', 'S', 'I', 'O', 'N', 'S', '\0', /* USE_THREAD_DIMENSIONS (72674) */
	'O', 'R', 'D', 'E', 'R', '_', 'M', 'O', 'D', 'E', '\0', /* ORDER_MODE (72696) */
	'S', 'C', 'A', 'L', 'A', 'R', '_', 'L', '1', '_', 'I', 'N', 'V', '_', 'V', 'O', 'L', '\0', /* SCALAR_L1_INV_VOL (72707, 72721) */
	'V', 'E', 'C', 'T', 'O', 'R', '_', 'L', '1', '_', 'I', 'N', 'V', '_', 'V', 'O', 'L', '\0', /* VECTOR_L1_INV_VOL (72725) */
	'T', 'U', 'N', 'N', 'E', 'L', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TUNNEL_ENABLE (72743) */
	'R', 'E', 'S', 'T', 'O', 'R', 'E', '\0', /* RESTORE (72757) */
	'C', 'S', '_', 'W', '3', '2', '_', 'E', 'N', '\0', /* CS_W32_EN (72765) */
	'N', 'U', 'M', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'F', 'U', 'L', 'L', '\0', /* NUM_THREAD_FULL (72775, 72786) */
	'N', 'U', 'M', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'P', 'A', 'R', 'T', 'I', 'A', 'L', '\0', /* NUM_THREAD_PARTIAL (72791) */
	'B', 'U', 'L', 'K', 'Y', '\0', /* BULKY (72810) */
	'T', 'G', 'I', 'D', '_', 'X', '_', 'E', 'N', '\0', /* TGID_X_EN (72816) */
	'T', 'G', 'I', 'D', '_', 'Y', '_', 'E', 'N', '\0', /* TGID_Y_EN (72826) */
	'T', 'G', 'I', 'D', '_', 'Z', '_', 'E', 'N', '\0', /* TGID_Z_EN (72836) */
	'T', 'I', 'D', 'I', 'G', '_', 'C', 'O', 'M', 'P', '_', 'C', 'N', 'T', '\0', /* TIDIG_COMP_CNT (72846) */
	'E', 'X', 'C', 'P', '_', 'E', 'N', '_', 'M', 'S', 'B', '\0', /* EXCP_EN_MSB (72861) */
	'W', 'A', 'V', 'E', 'S', '_', 'P', 'E', 'R', '_', 'S', 'H', '\0', /* WAVES_PER_SH (72873) */
	'T', 'G', '_', 'P', 'E', 'R', '_', 'C', 'U', '\0', /* TG_PER_CU (72886) */
	'L', 'O', 'C', 'K', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', '\0', /* LOCK_THRESHOLD (72896) */
	'S', 'I', 'M', 'D', '_', 'D', 'E', 'S', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* SIMD_DEST_CNTL (72911) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'I', 'M', 'D', '_', 'D', 'I', 'S', 'T', '\0', /* FORCE_SIMD_DIST (72926) */
	'C', 'U', '_', 'G', 'R', 'O', 'U', 'P', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* CU_GROUP_COUNT (72942) */
	'W', 'A', 'V', 'E', 'S', '\0', /* WAVES (72957) */
	'W', 'A', 'V', 'E', 'S', 'I', 'Z', 'E', '\0', /* WAVESIZE (72963) */
	'S', 'E', 'N', 'D', '_', 'S', 'E', 'I', 'D', '\0', /* SEND_SEID (72972) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '3', '\0', /* RESERVED3 (72982) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '4', '\0', /* RESERVED4 (72992) */
	'W', 'A', 'V', 'E', '_', 'I', 'D', '_', 'B', 'A', 'S', 'E', '\0', /* WAVE_ID_BASE (73002) */
	'D', 'E', 'D', 'I', 'C', 'A', 'T', 'E', 'D', '_', 'P', 'R', 'E', 'A', 'L', 'L', 'O', 'C', 'A', 'T', 'I', 'O', 'N', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'L', 'I', 'M', 'I', 'T', '\0', /* DEDICATED_PREALLOCATION_BUFFER_LIMIT (73015) */
	'P', 'A', 'Y', 'L', 'O', 'A', 'D', '\0', /* PAYLOAD (73052, 73055) */
	'I', 'S', '_', 'E', 'V', 'E', 'N', 'T', '\0', /* IS_EVENT (73060) */
	'I', 'S', '_', 'S', 'T', 'A', 'T', 'E', '\0', /* IS_STATE (73069) */
	'O', 'F', 'F', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* OFF_DELAY (73078) */
	'D', 'E', 'P', 'T', 'H', '_', 'C', 'L', 'E', 'A', 'R', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* DEPTH_CLEAR_ENABLE (73088) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'C', 'L', 'E', 'A', 'R', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* STENCIL_CLEAR_ENABLE (73107) */
	'D', 'E', 'P', 'T', 'H', '_', 'C', 'O', 'P', 'Y', '\0', /* DEPTH_COPY (73128) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'C', 'O', 'P', 'Y', '\0', /* STENCIL_COPY (73139) */
	'R', 'E', 'S', 'U', 'M', 'M', 'A', 'R', 'I', 'Z', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* RESUMMARIZE_ENABLE (73152) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* STENCIL_COMPRESS_DISABLE (73171) */
	'D', 'E', 'P', 'T', 'H', '_', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* DEPTH_COMPRESS_DISABLE (73196) */
	'C', 'O', 'P', 'Y', '_', 'C', 'E', 'N', 'T', 'R', 'O', 'I', 'D', '\0', /* COPY_CENTROID (73219) */
	'C', 'O', 'P', 'Y', '_', 'S', 'A', 'M', 'P', 'L', 'E', '\0', /* COPY_SAMPLE (73233) */
	'D', 'E', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* DECOMPRESS_ENABLE (73245) */
	'Z', 'P', 'A', 'S', 'S', '_', 'I', 'N', 'C', 'R', 'E', 'M', 'E', 'N', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* ZPASS_INCREMENT_DISABLE (73263) */
	'P', 'E', 'R', 'F', 'E', 'C', 'T', '_', 'Z', 'P', 'A', 'S', 'S', '_', 'C', 'O', 'U', 'N', 'T', 'S', '\0', /* PERFECT_ZPASS_COUNTS (73287) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'C', 'O', 'N', 'S', 'E', 'R', 'V', 'A', 'T', 'I', 'V', 'E', '_', 'Z', 'P', 'A', 'S', 'S', '_', 'C', 'O', 'U', 'N', 'T', 'S', '\0', /* DISABLE_CONSERVATIVE_ZPASS_COUNTS (73308) */
	'E', 'N', 'H', 'A', 'N', 'C', 'E', 'D', '_', 'C', 'O', 'N', 'S', 'E', 'R', 'V', 'A', 'T', 'I', 'V', 'E', '_', 'Z', 'P', 'A', 'S', 'S', '_', 'C', 'O', 'U', 'N', 'T', 'S', '\0', /* ENHANCED_CONSERVATIVE_ZPASS_COUNTS (73342) */
	'S', 'A', 'M', 'P', 'L', 'E', '_', 'R', 'A', 'T', 'E', '\0', /* SAMPLE_RATE (73377) */
	'Z', 'P', 'A', 'S', 'S', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* ZPASS_ENABLE (73389) */
	'Z', 'F', 'A', 'I', 'L', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* ZFAIL_ENABLE (73402) */
	'S', 'F', 'A', 'I', 'L', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* SFAIL_ENABLE (73415) */
	'D', 'B', 'F', 'A', 'I', 'L', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* DBFAIL_ENABLE (73428) */
	'S', 'L', 'I', 'C', 'E', '_', 'E', 'V', 'E', 'N', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* SLICE_EVEN_ENABLE (73442) */
	'S', 'L', 'I', 'C', 'E', '_', 'O', 'D', 'D', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* SLICE_ODD_ENABLE (73460) */
	'S', 'L', 'I', 'C', 'E', '_', 'S', 'T', 'A', 'R', 'T', '\0', /* SLICE_START (73477, 73483) */
	'S', 'L', 'I', 'C', 'E', '_', 'S', 'T', 'A', 'R', 'T', '_', 'H', 'I', '\0', /* SLICE_START_HI (73489) */
	'S', 'L', 'I', 'C', 'E', '_', 'M', 'A', 'X', '\0', /* SLICE_MAX (73504) */
	'Z', '_', 'R', 'E', 'A', 'D', '_', 'O', 'N', 'L', 'Y', '\0', /* Z_READ_ONLY (73514) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'R', 'E', 'A', 'D', '_', 'O', 'N', 'L', 'Y', '\0', /* STENCIL_READ_ONLY (73526) */
	'M', 'I', 'P', 'I', 'D', '\0', /* MIPID (73544) */
	'S', 'L', 'I', 'C', 'E', '_', 'M', 'A', 'X', '_', 'H', 'I', '\0', /* SLICE_MAX_HI (73550) */
	'F', 'O', 'R', 'C', 'E', '_', 'O', 'F', 'F', '\0', /* FORCE_OFF (73563) */
	'F', 'O', 'R', 'C', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* FORCE_ENABLE (73573) */
	'F', 'O', 'R', 'C', 'E', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* FORCE_DISABLE (73586) */
	'F', 'O', 'R', 'C', 'E', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '\0', /* FORCE_RESERVED (73600) */
	'F', 'O', 'R', 'C', 'E', '_', 'H', 'I', 'Z', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* FORCE_HIZ_ENABLE (73615, 73623) */
	'F', 'O', 'R', 'C', 'E', '_', 'H', 'I', 'S', '_', 'E', 'N', 'A', 'B', 'L', 'E', '0', '\0', /* FORCE_HIS_ENABLE0 (73632, 73642) */
	'F', 'O', 'R', 'C', 'E', '_', 'H', 'I', 'S', '_', 'E', 'N', 'A', 'B', 'L', 'E', '1', '\0', /* FORCE_HIS_ENABLE1 (73650, 73660) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'Z', '_', 'O', 'R', 'D', 'E', 'R', '\0', /* FORCE_SHADER_Z_ORDER (73668, 73681) */
	'F', 'A', 'S', 'T', '_', 'Z', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* FAST_Z_DISABLE (73689) */
	'F', 'A', 'S', 'T', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* FAST_STENCIL_DISABLE (73704) */
	'N', 'O', 'O', 'P', '_', 'C', 'U', 'L', 'L', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* NOOP_CULL_DISABLE (73725) */
	'F', 'O', 'R', 'C', 'E', '_', 'C', 'O', 'L', 'O', 'R', '_', 'K', 'I', 'L', 'L', '\0', /* FORCE_COLOR_KILL (73743, 73755) */
	'F', 'O', 'R', 'C', 'E', '_', 'Z', '_', 'R', 'E', 'A', 'D', '\0', /* FORCE_Z_READ (73760) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'R', 'E', 'A', 'D', '\0', /* FORCE_STENCIL_READ (73773) */
	'F', 'O', 'R', 'C', 'E', '_', 'F', 'U', 'L', 'L', '_', 'Z', '_', 'R', 'A', 'N', 'G', 'E', '\0', /* FORCE_FULL_Z_RANGE (73792) */
	'F', 'O', 'R', 'C', 'E', '_', 'Q', 'C', '_', 'S', 'M', 'A', 'S', 'K', '_', 'C', 'O', 'N', 'F', 'L', 'I', 'C', 'T', '\0', /* FORCE_QC_SMASK_CONFLICT (73811) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'V', 'I', 'E', 'W', 'P', 'O', 'R', 'T', '_', 'C', 'L', 'A', 'M', 'P', '\0', /* DISABLE_VIEWPORT_CLAMP (73835) */
	'I', 'G', 'N', 'O', 'R', 'E', '_', 'S', 'C', '_', 'Z', 'R', 'A', 'N', 'G', 'E', '\0', /* IGNORE_SC_ZRANGE (73858) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'F', 'U', 'L', 'L', 'Y', '_', 'C', 'O', 'V', 'E', 'R', 'E', 'D', '\0', /* DISABLE_FULLY_COVERED (73875) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'U', 'M', 'M', '_', 'O', 'F', 'F', '\0', /* FORCE_SUMM_OFF (73897) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'U', 'M', 'M', '_', 'M', 'I', 'N', 'Z', '\0', /* FORCE_SUMM_MINZ (73912) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'U', 'M', 'M', '_', 'M', 'A', 'X', 'Z', '\0', /* FORCE_SUMM_MAXZ (73928) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'U', 'M', 'M', '_', 'B', 'O', 'T', 'H', '\0', /* FORCE_SUMM_BOTH (73944) */
	'F', 'O', 'R', 'C', 'E', '_', 'Z', '_', 'L', 'I', 'M', 'I', 'T', '_', 'S', 'U', 'M', 'M', '\0', /* FORCE_Z_LIMIT_SUMM (73960) */
	'M', 'A', 'X', '_', 'T', 'I', 'L', 'E', 'S', '_', 'I', 'N', '_', 'D', 'T', 'T', '\0', /* MAX_TILES_IN_DTT (73979) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'T', 'I', 'L', 'E', '_', 'R', 'A', 'T', 'E', '_', 'T', 'I', 'L', 'E', 'S', '\0', /* DISABLE_TILE_RATE_TILES (73996) */
	'F', 'O', 'R', 'C', 'E', '_', 'Z', '_', 'D', 'I', 'R', 'T', 'Y', '\0', /* FORCE_Z_DIRTY (74020, 74028) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'D', 'I', 'R', 'T', 'Y', '\0', /* FORCE_STENCIL_DIRTY (74034) */
	'F', 'O', 'R', 'C', 'E', '_', 'Z', '_', 'V', 'A', 'L', 'I', 'D', '\0', /* FORCE_Z_VALID (74054) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'V', 'A', 'L', 'I', 'D', '\0', /* FORCE_STENCIL_VALID (74068) */
	'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', 'I', 'O', 'N', '\0', /* PRESERVE_COMPRESSION (74088, 74097) */
	'P', 'S', 'L', 'C', '_', 'A', 'U', 'T', 'O', '\0', /* PSLC_AUTO (74109) */
	'P', 'S', 'L', 'C', '_', 'O', 'N', '_', 'H', 'A', 'N', 'G', '_', 'O', 'N', 'L', 'Y', '\0', /* PSLC_ON_HANG_ONLY (74119) */
	'P', 'S', 'L', 'C', '_', 'A', 'S', 'A', 'P', '\0', /* PSLC_ASAP (74137) */
	'P', 'S', 'L', 'C', '_', 'C', 'O', 'U', 'N', 'T', 'D', 'O', 'W', 'N', '\0', /* PSLC_COUNTDOWN (74147) */
	'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'S', 'Q', 'U', 'A', 'D', '_', 'L', 'A', 'U', 'N', 'C', 'H', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* PARTIAL_SQUAD_LAUNCH_CONTROL (74162) */
	'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'S', 'Q', 'U', 'A', 'D', '_', 'L', 'A', 'U', 'N', 'C', 'H', '_', 'C', 'O', 'U', 'N', 'T', 'D', 'O', 'W', 'N', '\0', /* PARTIAL_SQUAD_LAUNCH_COUNTDOWN (74191) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'Z', 'M', 'A', 'S', 'K', '_', 'E', 'X', 'P', 'C', 'L', 'E', 'A', 'R', '_', 'O', 'P', 'T', 'I', 'M', 'I', 'Z', 'A', 'T', 'I', 'O', 'N', '\0', /* DISABLE_ZMASK_EXPCLEAR_OPTIMIZATION (74222) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'S', 'M', 'E', 'M', '_', 'E', 'X', 'P', 'C', 'L', 'E', 'A', 'R', '_', 'O', 'P', 'T', 'I', 'M', 'I', 'Z', 'A', 'T', 'I', 'O', 'N', '\0', /* DISABLE_SMEM_EXPCLEAR_OPTIMIZATION (74258) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'C', 'O', 'L', 'O', 'R', '_', 'O', 'N', '_', 'V', 'A', 'L', 'I', 'D', 'A', 'T', 'I', 'O', 'N', '\0', /* DISABLE_COLOR_ON_VALIDATION (74293) */
	'D', 'E', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '_', 'Z', '_', 'O', 'N', '_', 'F', 'L', 'U', 'S', 'H', '\0', /* DECOMPRESS_Z_ON_FLUSH (74321) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'R', 'E', 'G', '_', 'S', 'N', 'O', 'O', 'P', '\0', /* DISABLE_REG_SNOOP (74343) */
	'D', 'E', 'P', 'T', 'H', '_', 'B', 'O', 'U', 'N', 'D', 'S', '_', 'H', 'I', 'E', 'R', '_', 'D', 'E', 'P', 'T', 'H', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* DEPTH_BOUNDS_HIER_DEPTH_DISABLE (74361) */
	'S', 'E', 'P', 'A', 'R', 'A', 'T', 'E', '_', 'H', 'I', 'Z', 'S', '_', 'F', 'U', 'N', 'C', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* SEPARATE_HIZS_FUNC_ENABLE (74393) */
	'F', 'R', 'A', 'G', '_', 'N', 'E', 'V', 'E', 'R', '\0', /* FRAG_NEVER (74419) */
	'F', 'R', 'A', 'G', '_', 'L', 'E', 'S', 'S', '\0', /* FRAG_LESS (74430) */
	'F', 'R', 'A', 'G', '_', 'E', 'Q', 'U', 'A', 'L', '\0', /* FRAG_EQUAL (74440) */
	'F', 'R', 'A', 'G', '_', 'L', 'E', 'Q', 'U', 'A', 'L', '\0', /* FRAG_LEQUAL (74451) */
	'F', 'R', 'A', 'G', '_', 'G', 'R', 'E', 'A', 'T', 'E', 'R', '\0', /* FRAG_GREATER (74463) */
	'F', 'R', 'A', 'G', '_', 'N', 'O', 'T', 'E', 'Q', 'U', 'A', 'L', '\0', /* FRAG_NOTEQUAL (74476) */
	'F', 'R', 'A', 'G', '_', 'G', 'E', 'Q', 'U', 'A', 'L', '\0', /* FRAG_GEQUAL (74490) */
	'F', 'R', 'A', 'G', '_', 'A', 'L', 'W', 'A', 'Y', 'S', '\0', /* FRAG_ALWAYS (74502, 74507) */
	'H', 'I', 'Z', '_', 'Z', 'F', 'U', 'N', 'C', '\0', /* HIZ_ZFUNC (74514, 74518) */
	'H', 'I', 'S', '_', 'S', 'F', 'U', 'N', 'C', '_', 'F', 'F', '\0', /* HIS_SFUNC_FF (74524) */
	'H', 'I', 'S', '_', 'S', 'F', 'U', 'N', 'C', '_', 'B', 'F', '\0', /* HIS_SFUNC_BF (74537) */
	'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'Z', 'R', 'A', 'N', 'G', 'E', '\0', /* PRESERVE_ZRANGE (74550) */
	'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'S', 'R', 'E', 'S', 'U', 'L', 'T', 'S', '\0', /* PRESERVE_SRESULTS (74566) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'F', 'A', 'S', 'T', '_', 'P', 'A', 'S', 'S', '\0', /* DISABLE_FAST_PASS (74584) */
	'A', 'L', 'L', 'O', 'W', '_', 'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'R', 'E', 'S', '_', 'H', 'I', 'E', 'R', '_', 'K', 'I', 'L', 'L', '\0', /* ALLOW_PARTIAL_RES_HIER_KILL (74602) */
	'X', '_', 'M', 'A', 'X', '\0', /* X_MAX (74630) */
	'T', 'L', '_', 'X', '\0', /* TL_X (74636) */
	'T', 'L', '_', 'Y', '\0', /* TL_Y (74641) */
	'B', 'R', '_', 'X', '\0', /* BR_X (74646) */
	'B', 'R', '_', 'Y', '\0', /* BR_Y (74651) */
	'F', 'O', 'R', 'C', 'E', '_', 'O', 'N', '\0', /* FORCE_ON (74656) */
	'P', 'U', 'N', 'C', 'H', 'O', 'U', 'T', '_', 'M', 'O', 'D', 'E', '\0', /* PUNCHOUT_MODE (74665) */
	'P', 'O', 'P', 'S', '_', 'D', 'R', 'A', 'I', 'N', '_', 'P', 'S', '_', 'O', 'N', '_', 'O', 'V', 'E', 'R', 'L', 'A', 'P', '\0', /* POPS_DRAIN_PS_ON_OVERLAP (74679) */
	'D', 'I', 'S', 'A', 'L', 'L', 'O', 'W', '_', 'O', 'V', 'E', 'R', 'F', 'L', 'O', 'W', '\0', /* DISALLOW_OVERFLOW (74704) */
	'F', 'I', 'E', 'L', 'D', '_', '1', '\0', /* FIELD_1 (74722) */
	'F', 'I', 'E', 'L', 'D', '_', '2', '\0', /* FIELD_2 (74730) */
	'F', 'I', 'E', 'L', 'D', '_', '3', '\0', /* FIELD_3 (74738) */
	'F', 'I', 'E', 'L', 'D', '_', '4', '\0', /* FIELD_4 (74746) */
	'F', 'I', 'E', 'L', 'D', '_', '5', '\0', /* FIELD_5 (74754) */
	'F', 'I', 'E', 'L', 'D', '_', '6', '\0', /* FIELD_6 (74762) */
	'F', 'I', 'E', 'L', 'D', '_', '7', '\0', /* FIELD_7 (74770) */
	'Z', '_', 'I', 'N', 'V', 'A', 'L', 'I', 'D', '\0', /* Z_INVALID (74778) */
	'Z', '_', '1', '6', '\0', /* Z_16 (74788) */
	'Z', '_', '2', '4', '\0', /* Z_24 (74793) */
	'Z', '_', '3', '2', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* Z_32_FLOAT (74798) */
	'N', 'U', 'M', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '\0', /* NUM_SAMPLES (74809) */
	'F', 'A', 'U', 'L', 'T', '_', 'Z', 'E', 'R', 'O', '\0', /* FAULT_ZERO (74821) */
	'F', 'A', 'U', 'L', 'T', '_', 'O', 'N', 'E', '\0', /* FAULT_ONE (74832) */
	'F', 'A', 'U', 'L', 'T', '_', 'F', 'A', 'I', 'L', '\0', /* FAULT_FAIL (74842) */
	'F', 'A', 'U', 'L', 'T', '_', 'P', 'A', 'S', 'S', '\0', /* FAULT_PASS (74853) */
	'F', 'A', 'U', 'L', 'T', '_', 'B', 'E', 'H', 'A', 'V', 'I', 'O', 'R', '\0', /* FAULT_BEHAVIOR (74864) */
	'I', 'T', 'E', 'R', 'A', 'T', 'E', '_', 'F', 'L', 'U', 'S', 'H', '\0', /* ITERATE_FLUSH (74879) */
	'P', 'A', 'R', 'T', 'I', 'A', 'L', 'L', 'Y', '_', 'R', 'E', 'S', 'I', 'D', 'E', 'N', 'T', '\0', /* PARTIALLY_RESIDENT (74893) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'F', 'I', 'E', 'L', 'D', '_', '1', '\0', /* RESERVED_FIELD_1 (74912) */
	'M', 'A', 'X', 'M', 'I', 'P', '\0', /* MAXMIP (74929) */
	'D', 'E', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '_', 'O', 'N', '_', 'N', '_', 'Z', 'P', 'L', 'A', 'N', 'E', 'S', '\0', /* DECOMPRESS_ON_N_ZPLANES (74936) */
	'A', 'L', 'L', 'O', 'W', '_', 'E', 'X', 'P', 'C', 'L', 'E', 'A', 'R', '\0', /* ALLOW_EXPCLEAR (74960) */
	'R', 'E', 'A', 'D', '_', 'S', 'I', 'Z', 'E', '\0', /* READ_SIZE (74975) */
	'T', 'I', 'L', 'E', '_', 'S', 'U', 'R', 'F', 'A', 'C', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TILE_SURFACE_ENABLE (74985) */
	'Z', 'R', 'A', 'N', 'G', 'E', '_', 'P', 'R', 'E', 'C', 'I', 'S', 'I', 'O', 'N', '\0', /* ZRANGE_PRECISION (75005) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'I', 'N', 'V', 'A', 'L', 'I', 'D', '\0', /* STENCIL_INVALID (75022) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', '8', '\0', /* STENCIL_8 (75038) */
	'T', 'I', 'L', 'E', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* TILE_STENCIL_DISABLE (75048) */
	'C', 'A', 'C', 'H', 'E', '_', 'L', 'R', 'U', '_', 'W', 'R', '\0', /* CACHE_LRU_WR (75069) */
	'C', 'A', 'C', 'H', 'E', '_', 'S', 'T', 'R', 'E', 'A', 'M', '\0', /* CACHE_STREAM (75082) */
	'C', 'A', 'C', 'H', 'E', '_', 'B', 'Y', 'P', 'A', 'S', 'S', '\0', /* CACHE_BYPASS (75095) */
	'U', 'N', 'C', 'A', 'C', 'H', 'E', 'D', '_', 'W', 'R', '\0', /* UNCACHED_WR (75108) */
	'Z', '_', 'W', 'R', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* Z_WR_POLICY (75120) */
	'S', '_', 'W', 'R', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* S_WR_POLICY (75132) */
	'H', 'T', 'I', 'L', 'E', '_', 'W', 'R', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* HTILE_WR_POLICY (75144) */
	'Z', 'P', 'C', 'P', 'S', 'D', '_', 'W', 'R', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* ZPCPSD_WR_POLICY (75160) */
	'C', 'A', 'C', 'H', 'E', '_', 'L', 'R', 'U', '_', 'R', 'D', '\0', /* CACHE_LRU_RD (75177) */
	'C', 'A', 'C', 'H', 'E', '_', 'N', 'O', 'A', '\0', /* CACHE_NOA (75190) */
	'U', 'N', 'C', 'A', 'C', 'H', 'E', 'D', '_', 'R', 'D', '\0', /* UNCACHED_RD (75200) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'D', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* RESERVED_RDPOLICY (75212) */
	'Z', '_', 'R', 'D', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* Z_RD_POLICY (75230) */
	'S', '_', 'R', 'D', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* S_RD_POLICY (75242) */
	'H', 'T', 'I', 'L', 'E', '_', 'R', 'D', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* HTILE_RD_POLICY (75254) */
	'Z', '_', 'B', 'I', 'G', '_', 'P', 'A', 'G', 'E', '\0', /* Z_BIG_PAGE (75270, 75272) */
	'S', '_', 'B', 'I', 'G', '_', 'P', 'A', 'G', 'E', '\0', /* S_BIG_PAGE (75281) */
	'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '_', '2', '5', '6', 'B', '\0', /* DEST_BASE_HI_256B (75292) */
	'W', 'I', 'N', 'D', 'O', 'W', '_', 'X', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* WINDOW_X_OFFSET (75310) */
	'W', 'I', 'N', 'D', 'O', 'W', '_', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* WINDOW_Y_OFFSET (75326, 75333) */
	'W', 'I', 'N', 'D', 'O', 'W', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* WINDOW_OFFSET_DISABLE (75342) */
	'I', 'N', '_', '2', '0', '\0', /* IN_20 (75364) */
	'I', 'N', '_', '2', '1', '\0', /* IN_21 (75370) */
	'I', 'N', '_', '2', '1', '0', '\0', /* IN_210 (75376) */
	'I', 'N', '_', '3', '0', '\0', /* IN_30 (75383) */
	'I', 'N', '_', '3', '1', '\0', /* IN_31 (75389) */
	'I', 'N', '_', '3', '1', '0', '\0', /* IN_310 (75395) */
	'I', 'N', '_', '3', '2', '\0', /* IN_32 (75402) */
	'I', 'N', '_', '3', '2', '0', '\0', /* IN_320 (75408) */
	'I', 'N', '_', '3', '2', '1', '\0', /* IN_321 (75415) */
	'I', 'N', '_', '3', '2', '1', '0', '\0', /* IN_3210 (75422) */
	'C', 'L', 'I', 'P', '_', 'R', 'U', 'L', 'E', '\0', /* CLIP_RULE (75430) */
	'E', 'R', '_', 'T', 'R', 'I', '\0', /* ER_TRI (75440) */
	'E', 'R', '_', 'P', 'O', 'I', 'N', 'T', '\0', /* ER_POINT (75447) */
	'E', 'R', '_', 'R', 'E', 'C', 'T', '\0', /* ER_RECT (75456) */
	'E', 'R', '_', 'L', 'I', 'N', 'E', '_', 'L', 'R', '\0', /* ER_LINE_LR (75464) */
	'E', 'R', '_', 'L', 'I', 'N', 'E', '_', 'R', 'L', '\0', /* ER_LINE_RL (75475) */
	'E', 'R', '_', 'L', 'I', 'N', 'E', '_', 'T', 'B', '\0', /* ER_LINE_TB (75486) */
	'E', 'R', '_', 'L', 'I', 'N', 'E', '_', 'B', 'T', '\0', /* ER_LINE_BT (75497) */
	'H', 'W', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'X', '\0', /* HW_SCREEN_OFFSET_X (75508) */
	'H', 'W', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'Y', '\0', /* HW_SCREEN_OFFSET_Y (75527) */
	'T', 'A', 'R', 'G', 'E', 'T', '0', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET0_ENABLE (75546) */
	'T', 'A', 'R', 'G', 'E', 'T', '1', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET1_ENABLE (75561) */
	'T', 'A', 'R', 'G', 'E', 'T', '2', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET2_ENABLE (75576) */
	'T', 'A', 'R', 'G', 'E', 'T', '3', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET3_ENABLE (75591) */
	'T', 'A', 'R', 'G', 'E', 'T', '4', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET4_ENABLE (75606) */
	'T', 'A', 'R', 'G', 'E', 'T', '5', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET5_ENABLE (75621) */
	'T', 'A', 'R', 'G', 'E', 'T', '6', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET6_ENABLE (75636) */
	'T', 'A', 'R', 'G', 'E', 'T', '7', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET7_ENABLE (75651) */
	'O', 'U', 'T', 'P', 'U', 'T', '0', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT0_ENABLE (75666) */
	'O', 'U', 'T', 'P', 'U', 'T', '1', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT1_ENABLE (75681) */
	'O', 'U', 'T', 'P', 'U', 'T', '2', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT2_ENABLE (75696) */
	'O', 'U', 'T', 'P', 'U', 'T', '3', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT3_ENABLE (75711) */
	'O', 'U', 'T', 'P', 'U', 'T', '4', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT4_ENABLE (75726) */
	'O', 'U', 'T', 'P', 'U', 'T', '5', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT5_ENABLE (75741) */
	'O', 'U', 'T', 'P', 'U', 'T', '6', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT6_ENABLE (75756) */
	'O', 'U', 'T', 'P', 'U', 'T', '7', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT7_ENABLE (75771) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'M', 'A', 'P', '_', '0', '\0', /* RASTER_CONFIG_RB_MAP_0 (75786) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'M', 'A', 'P', '_', '1', '\0', /* RASTER_CONFIG_RB_MAP_1 (75809) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'M', 'A', 'P', '_', '2', '\0', /* RASTER_CONFIG_RB_MAP_2 (75832) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'M', 'A', 'P', '_', '3', '\0', /* RASTER_CONFIG_RB_MAP_3 (75855) */
	'R', 'B', '_', 'M', 'A', 'P', '_', 'P', 'K', 'R', '0', '\0', /* RB_MAP_PKR0 (75878) */
	'R', 'B', '_', 'M', 'A', 'P', '_', 'P', 'K', 'R', '1', '\0', /* RB_MAP_PKR1 (75890) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'X', 'S', 'E', 'L', '2', '_', '0', '\0', /* RASTER_CONFIG_RB_XSEL2_0 (75902) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'X', 'S', 'E', 'L', '2', '_', '1', '\0', /* RASTER_CONFIG_RB_XSEL2_1 (75927) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'X', 'S', 'E', 'L', '2', '_', '2', '\0', /* RASTER_CONFIG_RB_XSEL2_2 (75952) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'X', 'S', 'E', 'L', '2', '_', '3', '\0', /* RASTER_CONFIG_RB_XSEL2_3 (75977) */
	'R', 'B', '_', 'X', 'S', 'E', 'L', '2', '\0', /* RB_XSEL2 (76002) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'X', 'S', 'E', 'L', '_', '0', '\0', /* RASTER_CONFIG_RB_XSEL_0 (76011) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'X', 'S', 'E', 'L', '_', '1', '\0', /* RASTER_CONFIG_RB_XSEL_1 (76035) */
	'R', 'B', '_', 'X', 'S', 'E', 'L', '\0', /* RB_XSEL (76059) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'Y', 'S', 'E', 'L', '_', '0', '\0', /* RASTER_CONFIG_RB_YSEL_0 (76067) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'Y', 'S', 'E', 'L', '_', '1', '\0', /* RASTER_CONFIG_RB_YSEL_1 (76091) */
	'R', 'B', '_', 'Y', 'S', 'E', 'L', '\0', /* RB_YSEL (76115) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'M', 'A', 'P', '_', '0', '\0', /* RASTER_CONFIG_PKR_MAP_0 (76123) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'M', 'A', 'P', '_', '1', '\0', /* RASTER_CONFIG_PKR_MAP_1 (76147) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'M', 'A', 'P', '_', '2', '\0', /* RASTER_CONFIG_PKR_MAP_2 (76171) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'M', 'A', 'P', '_', '3', '\0', /* RASTER_CONFIG_PKR_MAP_3 (76195) */
	'P', 'K', 'R', '_', 'M', 'A', 'P', '\0', /* PKR_MAP (76219) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '_', '0', '\0', /* RASTER_CONFIG_PKR_XSEL_0 (76227) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '_', '1', '\0', /* RASTER_CONFIG_PKR_XSEL_1 (76252) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '_', '2', '\0', /* RASTER_CONFIG_PKR_XSEL_2 (76277) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '_', '3', '\0', /* RASTER_CONFIG_PKR_XSEL_3 (76302) */
	'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '\0', /* PKR_XSEL (76327) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'Y', 'S', 'E', 'L', '_', '0', '\0', /* RASTER_CONFIG_PKR_YSEL_0 (76336) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'Y', 'S', 'E', 'L', '_', '1', '\0', /* RASTER_CONFIG_PKR_YSEL_1 (76361) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'Y', 'S', 'E', 'L', '_', '2', '\0', /* RASTER_CONFIG_PKR_YSEL_2 (76386) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'Y', 'S', 'E', 'L', '_', '3', '\0', /* RASTER_CONFIG_PKR_YSEL_3 (76411) */
	'P', 'K', 'R', '_', 'Y', 'S', 'E', 'L', '\0', /* PKR_YSEL (76436) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '2', '_', '0', '\0', /* RASTER_CONFIG_PKR_XSEL2_0 (76445) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '2', '_', '1', '\0', /* RASTER_CONFIG_PKR_XSEL2_1 (76471) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '2', '_', '2', '\0', /* RASTER_CONFIG_PKR_XSEL2_2 (76497) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '2', '_', '3', '\0', /* RASTER_CONFIG_PKR_XSEL2_3 (76523) */
	'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '2', '\0', /* PKR_XSEL2 (76549) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'M', 'A', 'P', '_', '0', '\0', /* RASTER_CONFIG_SC_MAP_0 (76559) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'M', 'A', 'P', '_', '1', '\0', /* RASTER_CONFIG_SC_MAP_1 (76582) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'M', 'A', 'P', '_', '2', '\0', /* RASTER_CONFIG_SC_MAP_2 (76605) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'M', 'A', 'P', '_', '3', '\0', /* RASTER_CONFIG_SC_MAP_3 (76628) */
	'S', 'C', '_', 'M', 'A', 'P', '\0', /* SC_MAP (76651) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'X', 'S', 'E', 'L', '_', '8', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_XSEL_8_WIDE_TILE (76658) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'X', 'S', 'E', 'L', '_', '1', '6', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_XSEL_16_WIDE_TILE (76692) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'X', 'S', 'E', 'L', '_', '3', '2', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_XSEL_32_WIDE_TILE (76727) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'X', 'S', 'E', 'L', '_', '6', '4', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_XSEL_64_WIDE_TILE (76762) */
	'S', 'C', '_', 'X', 'S', 'E', 'L', '\0', /* SC_XSEL (76797) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'Y', 'S', 'E', 'L', '_', '8', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_YSEL_8_WIDE_TILE (76805) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'Y', 'S', 'E', 'L', '_', '1', '6', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_YSEL_16_WIDE_TILE (76839) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'Y', 'S', 'E', 'L', '_', '3', '2', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_YSEL_32_WIDE_TILE (76874) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'Y', 'S', 'E', 'L', '_', '6', '4', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_YSEL_64_WIDE_TILE (76909) */
	'S', 'C', '_', 'Y', 'S', 'E', 'L', '\0', /* SC_YSEL (76944) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'M', 'A', 'P', '_', '0', '\0', /* RASTER_CONFIG_SE_MAP_0 (76952) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'M', 'A', 'P', '_', '1', '\0', /* RASTER_CONFIG_SE_MAP_1 (76975) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'M', 'A', 'P', '_', '2', '\0', /* RASTER_CONFIG_SE_MAP_2 (76998) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'M', 'A', 'P', '_', '3', '\0', /* RASTER_CONFIG_SE_MAP_3 (77021) */
	'S', 'E', '_', 'M', 'A', 'P', '\0', /* SE_MAP (77044) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'X', 'S', 'E', 'L', '_', '8', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_XSEL_8_WIDE_TILE (77051) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'X', 'S', 'E', 'L', '_', '1', '6', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_XSEL_16_WIDE_TILE (77085) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'X', 'S', 'E', 'L', '_', '3', '2', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_XSEL_32_WIDE_TILE (77120) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'X', 'S', 'E', 'L', '_', '6', '4', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_XSEL_64_WIDE_TILE (77155) */
	'S', 'E', '_', 'X', 'S', 'E', 'L', '\0', /* SE_XSEL (77190) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'Y', 'S', 'E', 'L', '_', '8', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_YSEL_8_WIDE_TILE (77198) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'Y', 'S', 'E', 'L', '_', '1', '6', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_YSEL_16_WIDE_TILE (77232) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'Y', 'S', 'E', 'L', '_', '3', '2', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_YSEL_32_WIDE_TILE (77267) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'Y', 'S', 'E', 'L', '_', '6', '4', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_YSEL_64_WIDE_TILE (77302) */
	'S', 'E', '_', 'Y', 'S', 'E', 'L', '\0', /* SE_YSEL (77337) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'M', 'A', 'P', '_', '0', '\0', /* RASTER_CONFIG_SE_PAIR_MAP_0 (77345) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F',