/*
 * Decompiled with CFR 0.152.
 */
package org.scalasbt.ipcsocket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicInteger;
import org.scalasbt.ipcsocket.NativeErrorException;
import org.scalasbt.ipcsocket.ReferenceCountedFileDescriptor;
import org.scalasbt.ipcsocket.UnixDomainSocketLibraryProvider;

public class UnixDomainSocket
extends Socket {
    private final UnixDomainSocketLibraryProvider provider;
    private final ReferenceCountedFileDescriptor fd;
    private final InputStream is;
    private final OutputStream os;
    private final String path;
    private static final int SHUT_RD = 0;
    private static final int SHUT_WR = 1;

    public UnixDomainSocket(String string, boolean bl) throws IOException {
        try {
            this.path = string;
            this.provider = UnixDomainSocketLibraryProvider.get(bl);
            AtomicInteger atomicInteger = new AtomicInteger(this.provider.socket(1, 1, 0));
            int n = atomicInteger.get();
            this.provider.connect(n, string.getBytes(), string.length());
            this.fd = new ReferenceCountedFileDescriptor(n, this.provider);
            this.is = new UnixDomainSocketInputStream();
            this.os = new UnixDomainSocketOutputStream();
        }
        catch (NativeErrorException nativeErrorException) {
            throw new IOException(nativeErrorException);
        }
    }

    public UnixDomainSocket(String string) throws IOException {
        this(string, false);
    }

    public UnixDomainSocket(int n, boolean bl) {
        this.provider = UnixDomainSocketLibraryProvider.get(bl);
        this.path = null;
        this.fd = new ReferenceCountedFileDescriptor(n, this.provider);
        this.is = new UnixDomainSocketInputStream();
        this.os = new UnixDomainSocketOutputStream();
    }

    public UnixDomainSocket(int n) {
        this(n, false);
    }

    @Override
    public InputStream getInputStream() {
        return this.is;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.os;
    }

    @Override
    public void shutdownInput() throws IOException {
        this.doShutdown(0);
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.doShutdown(1);
    }

    private void doShutdown(int n) throws IOException {
        try {
            int n2 = this.fd.acquire();
            if (n2 != -1) {
                this.provider.shutdown(n2, n);
            }
        }
        catch (NativeErrorException nativeErrorException) {
            throw new IOException(nativeErrorException);
        }
        finally {
            this.fd.release();
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.fd.close();
    }

    private class UnixDomainSocketOutputStream
    extends OutputStream {
        private UnixDomainSocketOutputStream() {
        }

        @Override
        public void write(int n) throws IOException {
            this.doWrite(new byte[]{(byte)(0xFF & n)}, 0, 1);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (n2 == 0) {
                return;
            }
            this.doWrite(byArray, n, n2);
        }

        private void doWrite(byte[] byArray, int n, int n2) throws IOException {
            try {
                int n3 = UnixDomainSocket.this.fd.acquire();
                if (n3 == -1) {
                    return;
                }
                int n4 = UnixDomainSocket.this.provider.write(n3, byArray, n, n2);
                if (n4 != n2) {
                    throw new IOException("Could not write " + n2 + " bytes as requested (wrote " + n4 + " bytes instead)");
                }
            }
            catch (NativeErrorException nativeErrorException) {
                throw new IOException(nativeErrorException);
            }
            finally {
                UnixDomainSocket.this.fd.release();
            }
        }
    }

    private class UnixDomainSocketInputStream
    extends InputStream {
        private UnixDomainSocketInputStream() {
        }

        @Override
        public int read() throws IOException {
            byte[] byArray = new byte[1];
            int n = this.doRead(byArray, 0, 1) == 0 ? -1 : 0xFF & byArray[0];
            return n;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (n2 == 0) {
                return 0;
            }
            int n3 = this.doRead(byArray, n, n2);
            if (n3 == 0) {
                try {
                    UnixDomainSocket.this.provider.close(UnixDomainSocket.this.fd.acquire());
                }
                catch (NativeErrorException nativeErrorException) {
                    throw new IOException("Error closing " + UnixDomainSocket.this.fd.acquire() + (UnixDomainSocket.this.path == null ? "" : " for " + UnixDomainSocket.this.path));
                }
                n3 = -1;
            }
            return n3;
        }

        private int doRead(byte[] byArray, int n, int n2) throws IOException {
            try {
                int n3 = UnixDomainSocket.this.fd.acquire();
                if (n3 == -1) {
                    int n4 = -1;
                    return n4;
                }
                int n5 = UnixDomainSocket.this.provider.read(n3, byArray, n, n2);
                return n5;
            }
            catch (NativeErrorException nativeErrorException) {
                throw new IOException(nativeErrorException);
            }
            finally {
                UnixDomainSocket.this.fd.release();
            }
        }
    }
}

