/*
 * Decompiled with CFR 0.152.
 */
package org.scalasbt.ipcsocket;

import com.sun.jna.Native;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import org.scalasbt.ipcsocket.Win32SecurityLevel;

public class Win32SecurityLibrary {
    private static final long SE_GROUP_LOGON_ID = 0xC0000000L;

    public static WinBase.SECURITY_ATTRIBUTES createSecurityWithLogonDacl(int n) {
        return Win32SecurityLibrary.createSecurityWithDacl(n, Win32SecurityLevel.LOGON_DACL);
    }

    public static WinBase.SECURITY_ATTRIBUTES createSecurityWithDacl(int n, int n2) {
        if (n2 == Win32SecurityLevel.NO_SECURITY) {
            return null;
        }
        WinNT.SECURITY_DESCRIPTOR sECURITY_DESCRIPTOR = new WinNT.SECURITY_DESCRIPTOR(65536);
        Advapi32.INSTANCE.InitializeSecurityDescriptor(sECURITY_DESCRIPTOR, 1);
        Native.getLastError();
        int n3 = 0;
        WinNT.PSIDByReference pSIDByReference = new WinNT.PSIDByReference();
        if (n2 == Win32SecurityLevel.LOGON_DACL) {
            Win32SecurityLibrary.getLogonSID(pSIDByReference);
        } else {
            Win32SecurityLibrary.getOwnerSID(pSIDByReference);
        }
        int n4 = Advapi32.INSTANCE.GetLengthSid(pSIDByReference.getValue());
        n3 = Native.getNativeSize(WinNT.ACL.class, null);
        n3 += Native.getNativeSize(WinNT.ACCESS_ALLOWED_ACE.class, null);
        n3 += n4 - 4;
        n3 = Advapi32Util.alignOnDWORD((int)n3);
        WinNT.ACL aCL = new WinNT.ACL(n3);
        Advapi32.INSTANCE.InitializeAcl(aCL, n3, 2);
        Native.getLastError();
        Advapi32.INSTANCE.AddAccessAllowedAce(aCL, 2, n, pSIDByReference.getValue());
        Native.getLastError();
        Advapi32.INSTANCE.SetSecurityDescriptorDacl(sECURITY_DESCRIPTOR, true, aCL, false);
        Native.getLastError();
        WinBase.SECURITY_ATTRIBUTES sECURITY_ATTRIBUTES = new WinBase.SECURITY_ATTRIBUTES();
        sECURITY_ATTRIBUTES.dwLength = new WinDef.DWORD((long)sECURITY_DESCRIPTOR.size());
        sECURITY_ATTRIBUTES.lpSecurityDescriptor = sECURITY_DESCRIPTOR.getPointer();
        sECURITY_ATTRIBUTES.bInheritHandle = false;
        return sECURITY_ATTRIBUTES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getOwnerSID(WinNT.PSIDByReference pSIDByReference) {
        WinNT.HANDLEByReference hANDLEByReference = new WinNT.HANDLEByReference();
        try {
            Advapi32.INSTANCE.OpenProcessToken(Kernel32.INSTANCE.GetCurrentProcess(), 8, hANDLEByReference);
            Native.getLastError();
            IntByReference intByReference = new IntByReference();
            Advapi32.INSTANCE.GetTokenInformation(hANDLEByReference.getValue(), 4, null, 0, intByReference);
            WinNT.TOKEN_OWNER tOKEN_OWNER = new WinNT.TOKEN_OWNER(intByReference.getValue());
            Advapi32.INSTANCE.GetTokenInformation(hANDLEByReference.getValue(), 4, (Structure)tOKEN_OWNER, intByReference.getValue(), intByReference);
            Native.getLastError();
            pSIDByReference.setValue((WinNT.PSID)tOKEN_OWNER.Owner);
        }
        finally {
            Kernel32Util.closeHandleRef((WinNT.HANDLEByReference)hANDLEByReference);
        }
    }

    public static void getLogonSID(WinNT.PSIDByReference pSIDByReference) {
        WinNT.HANDLEByReference hANDLEByReference = new WinNT.HANDLEByReference();
        try {
            Advapi32.INSTANCE.OpenProcessToken(Kernel32.INSTANCE.GetCurrentProcess(), 8, hANDLEByReference);
            Native.getLastError();
            IntByReference intByReference = new IntByReference();
            Advapi32.INSTANCE.GetTokenInformation(hANDLEByReference.getValue(), 2, null, 0, intByReference);
            WinNT.TOKEN_GROUPS tOKEN_GROUPS = new WinNT.TOKEN_GROUPS(intByReference.getValue());
            Advapi32.INSTANCE.GetTokenInformation(hANDLEByReference.getValue(), 2, (Structure)tOKEN_GROUPS, intByReference.getValue(), intByReference);
            Native.getLastError();
            for (WinNT.SID_AND_ATTRIBUTES sID_AND_ATTRIBUTES : tOKEN_GROUPS.getGroups()) {
                if (((long)sID_AND_ATTRIBUTES.Attributes & 0xC0000000L) != 0xC0000000L) continue;
                pSIDByReference.setValue((WinNT.PSID)sID_AND_ATTRIBUTES.Sid);
                return;
            }
            throw new RuntimeException("LogonSID was not found.");
        }
        finally {
            Kernel32Util.closeHandleRef((WinNT.HANDLEByReference)hANDLEByReference);
        }
    }
}

