/*
 * Decompiled with CFR 0.152.
 */
package bloop.bloopgun.util;

import bloop.bloopgun.core.AvailableAtPath;
import bloop.bloopgun.core.LocatedServer;
import bloop.bloopgun.util.GlobalSettings;
import bloop.bloopgun.util.GlobalSettings$;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Properties$;
import scala.util.control.NonFatal$;
import snailgun.logging.Logger;

public final class Environment$ {
    public static final Environment$ MODULE$;
    private static final boolean isWindows;
    private static final boolean isCygwin;
    private static final List<String> PerformanceSensitiveOptsForBloop;

    static {
        boolean bl;
        MODULE$ = new Environment$();
        isWindows = Properties$.MODULE$.isWin();
        Option option = Option$.MODULE$.apply((Object)System.getenv("OSTYPE"));
        if (option instanceof Some) {
            Some some = (Some)option;
            String x = (String)some.value();
            bl = x.toLowerCase(Locale.ENGLISH).contains("cygwin");
        } else {
            bl = false;
        }
        isCygwin = bl;
        PerformanceSensitiveOptsForBloop = new .colon.colon((Object)"-Xss4m", (List)new .colon.colon((Object)"-XX:MaxInlineLevel=20", (List)new .colon.colon((Object)"-XX:+UseParallelGC", (List)Nil$.MODULE$)));
    }

    public final boolean isWindows() {
        return isWindows;
    }

    public final boolean isCygwin() {
        return isCygwin;
    }

    public Path cwd() {
        return Paths.get(System.getProperty("user.dir"), new String[0]);
    }

    public Path homeDirectory() {
        return Paths.get(System.getProperty("user.home"), new String[0]);
    }

    public Path defaultBloopDirectory() {
        return this.homeDirectory().resolve(".bloop");
    }

    public Path bloopGlobalSettingsPath() {
        return this.defaultBloopDirectory().resolve("bloop.json");
    }

    public Either<String, GlobalSettings> bloopGlobalSettings(Logger logger) {
        if (Files.isReadable(this.bloopGlobalSettingsPath())) {
            return GlobalSettings$.MODULE$.readFromFile(this.bloopGlobalSettingsPath(), logger);
        }
        return package$.MODULE$.Right().apply((Object)GlobalSettings$.MODULE$.default());
    }

    public Option<Path> executablePath() {
        Some some;
        try {
            some = new Some((Object)Paths.get(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI()));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    public List<String> detectJvmOptionsForServer(LocatedServer server, List<String> serverArgs, Logger logger) {
        List jvmServerArgs;
        block0: {
            jvmServerArgs = serverArgs.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith("-J")));
            Environment$.detectJvmOptsFile$1(this.defaultBloopDirectory().resolve(".jvmopts"), logger);
            LocatedServer locatedServer = server;
            if (!(locatedServer instanceof AvailableAtPath)) break block0;
            AvailableAtPath availableAtPath = (AvailableAtPath)locatedServer;
            Path binary = availableAtPath.binary();
            Environment$.detectJvmOptsFile$1(binary.getParent().resolve(".jvmopts"), logger);
        }
        return jvmServerArgs.map((Function1 & Serializable)x$2 -> StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(x$2), "-J"));
    }

    public List<String> PerformanceSensitiveOptsForBloop() {
        return PerformanceSensitiveOptsForBloop;
    }

    private static final void detectJvmOptsFile$1(Path jvmOptsFile, Logger logger$1) {
        if (Files.exists(jvmOptsFile, new LinkOption[0])) {
            logger$1.warn(new StringBuilder(30).append("Since Bloop 1.5.0 ").append(jvmOptsFile.toAbsolutePath()).append(" is ignored.").toString());
            return;
        }
    }

    private Environment$() {
    }
}

