/*
 * Decompiled with CFR 0.152.
 */
package upickle.core;

import upickle.core.Abort;
import upickle.core.ByteBuilder;
import upickle.core.RenderUtils$;

public final class ByteUtils$ {
    public static final ByteUtils$ MODULE$ = new ByteUtils$();

    public boolean appendEscapedByte(ByteBuilder byteBuilder, char c, int i) {
        switch (c) {
            case '\"': {
                this.escapeSingleByte(byteBuilder, i, '\"');
                return true;
            }
            case '\\': {
                this.escapeSingleByte(byteBuilder, i, '\\');
                return true;
            }
            case '\b': {
                this.escapeSingleByte(byteBuilder, i, 'b');
                return true;
            }
            case '\f': {
                this.escapeSingleByte(byteBuilder, i, 'f');
                return true;
            }
            case '\n': {
                this.escapeSingleByte(byteBuilder, i, 'n');
                return true;
            }
            case '\r': {
                this.escapeSingleByte(byteBuilder, i, 'r');
                return true;
            }
            case '\t': {
                this.escapeSingleByte(byteBuilder, i, 't');
                return true;
            }
        }
        return false;
    }

    public void escapeSingleByte(ByteBuilder byteBuilder, int i, char c) {
        byteBuilder.ensureLength(2);
        int length = byteBuilder.length();
        byte[] arr = byteBuilder.arr();
        arr[length] = (byte)92;
        arr[length + 1] = (byte)c;
        byteBuilder.length_$eq(byteBuilder.length() + 2);
    }

    public void escapeSingleByteUnicodeEscape(ByteBuilder byteBuilder, int i, char c) {
        byteBuilder.ensureLength(6);
        byte[] arr = byteBuilder.arr();
        int length = byteBuilder.length();
        arr[length] = (byte)92;
        arr[length + 1] = (byte)117;
        arr[length + 2] = (byte)RenderUtils$.MODULE$.toHex(c >> 12 & 0xF);
        arr[length + 3] = (byte)RenderUtils$.MODULE$.toHex(c >> 8 & 0xF);
        arr[length + 4] = (byte)RenderUtils$.MODULE$.toHex(c >> 4 & 0xF);
        arr[length + 5] = (byte)RenderUtils$.MODULE$.toHex(c & 0xF);
        byteBuilder.length_$eq(byteBuilder.length() + 6);
    }

    public int appendSimpleStringSection(ByteBuilder byteBuilder, int i0, int len, CharSequence s) {
        byteBuilder.ensureLength(len - i0);
        int i = this.appendSimpleStringSection0(byteBuilder.arr(), byteBuilder.length(), i0, len, s);
        byteBuilder.length_$eq(byteBuilder.length() + (i - i0) + 1);
        return i;
    }

    public int appendSimpleStringSectionNoUnicode(ByteBuilder byteBuilder, int i0, int len, CharSequence s) {
        byteBuilder.ensureLength(len - i0);
        int i = this.appendSimpleStringSectionNoUnicode0(byteBuilder.arr(), byteBuilder.length(), i0, len, s);
        byteBuilder.length_$eq(byteBuilder.length() + (i - i0) + 1);
        return i;
    }

    private int appendSimpleStringSection0(byte[] arr, int arrOffset, int i0, int len, CharSequence s) {
        char c2;
        int i;
        for (i = i0; i < len && !((c2 = s.charAt(i)) < ' ' | c2 == '\"' | c2 == '\\'); ++i) {
            arr[arrOffset + i - i0] = (byte)c2;
        }
        return i - 1;
    }

    private int appendSimpleStringSectionNoUnicode0(byte[] arr, int arrOffset, int i0, int len, CharSequence s) {
        char c2;
        int i;
        for (i = i0; i < len && (c2 = s.charAt(i)) >= ' ' && c2 <= '\u007f' && c2 != '\"' && c2 != '\\'; ++i) {
            arr[arrOffset + i - i0] = (byte)c2;
        }
        return i - 1;
    }

    public long parseIntegralNum(byte[] arr, int arrOffset, int arrLength, int decIndex, int expIndex) {
        long l;
        int expMul;
        int n;
        if (expIndex == -1) {
            n = 1;
        } else {
            int mult = 1;
            long e = this.parseLong(arr, arrOffset + expIndex + 1, arrOffset + arrLength);
            int i = 0;
            while ((long)i < e) {
                if ((long)mult >= 0xCCCCCCCCCCCCCCCL) {
                    throw new Abort("expected integer");
                }
                mult *= 10;
                ++i;
            }
            n = expMul = mult;
        }
        int end = decIndex != -1 ? decIndex : (expIndex != -1 ? expIndex : arrLength);
        long intPortion = this.parseLong(arr, arrOffset, arrOffset + end) * (long)expMul;
        if (decIndex == -1) {
            l = 0L;
        } else {
            int end2 = expIndex != -1 ? expIndex : arrLength;
            long value = this.parseLong(arr, arrOffset + decIndex + 1, arrOffset + end2) * (long)expMul;
            for (int i = end2 - (decIndex + 1); i > 0; --i) {
                value /= 10L;
            }
            l = arr[arrOffset] == 45 ? -value : value;
        }
        long decPortion = l;
        return intPortion + decPortion;
    }

    public long parseLong(byte[] cs0, int start0, int end0) {
        int size;
        if ((start0 | end0 | end0 - start0 | cs0.length - end0) < 0) {
            throw new IndexOutOfBoundsException();
        }
        byte[] cs = new byte[end0 - start0];
        System.arraycopy(cs0, start0, cs, 0, end0 - start0);
        long inverseSum = 0L;
        long inverseSign = -1L;
        int i = 0;
        int end = end0 - start0;
        if (cs[0] == 45) {
            inverseSign = 1L;
            ++i;
        }
        if ((size = end - i) <= 0 || size > 19) {
            throw new NumberFormatException(new String(cs));
        }
        while (i < end) {
            int digit = cs[i] - 48;
            if (digit < 0 || 9 < digit) {
                throw new NumberFormatException(new String(cs));
            }
            inverseSum = inverseSum * 10L - (long)digit;
            ++i;
        }
        if (size == 19 && (inverseSum >= 0L || inverseSum == Long.MIN_VALUE && inverseSign < 0L)) {
            throw new NumberFormatException(new String(cs));
        }
        return inverseSum * inverseSign;
    }

    private ByteUtils$() {
    }
}

