/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.util;

public final class SimpleIdentityHashSet {
    private static final int MINIMUM_CAPACITY = 4;
    private static final int MAXIMUM_CAPACITY = 0x20000000;
    private Object[] table = new Object[SimpleIdentityHashSet.capacity(4)];
    private int size;

    private static int capacity(int expectedMaxSize) {
        return expectedMaxSize > 0xAAAAAAA ? 0x20000000 : (expectedMaxSize <= 2 ? 4 : Integer.highestOneBit(expectedMaxSize + (expectedMaxSize << 1)));
    }

    private static int hash(Object x, int length) {
        return System.identityHashCode(x) & length - 1;
    }

    private static int nextIndex(int i, int len) {
        return i + 1 < len ? i + 1 : 0;
    }

    public boolean add(Object o) {
        int len;
        int s;
        do {
            Object item;
            Object[] tab = this.table;
            len = tab.length;
            int i = SimpleIdentityHashSet.hash(o, len);
            while ((item = tab[i]) != null) {
                if (item == o) {
                    return false;
                }
                i = SimpleIdentityHashSet.nextIndex(i, len);
            }
        } while ((s = this.size + 1) * 3 > len && this.resize(len));
        tab[i] = o;
        this.size = s;
        return true;
    }

    private boolean resize(int newCapacity) {
        int newLength = newCapacity * 2;
        Object[] oldTable = this.table;
        int oldLength = oldTable.length;
        if (oldLength == 0x40000000) {
            if (this.size == 0x1FFFFFFF) {
                throw new IllegalStateException("Capacity exhausted.");
            }
            return false;
        }
        if (oldLength >= newLength) {
            return false;
        }
        Object[] newTable = new Object[newLength];
        for (Object o : oldTable) {
            if (o == null) continue;
            int i = SimpleIdentityHashSet.hash(o, newLength);
            while (newTable[i] != null) {
                i = SimpleIdentityHashSet.nextIndex(i, newLength);
            }
            newTable[i] = o;
        }
        this.table = newTable;
        return true;
    }
}

