/*
 * Decompiled with CFR 0.152.
 */
package org.scalasbt.ipcsocket;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import org.scalasbt.ipcsocket.Handle;
import org.scalasbt.ipcsocket.JNAWin32NamedPipeLibraryProvider;
import org.scalasbt.ipcsocket.JNIWin32NamedPipeLibraryProvider;
import org.scalasbt.ipcsocket.Overlapped;
import org.scalasbt.ipcsocket.Win32NamedPipeLibraryProvider;
import org.scalasbt.ipcsocket.Win32NamedPipeSocket;
import org.scalasbt.ipcsocket.Win32SecurityLevel;

public class Win32NamedPipeServerSocket
extends ServerSocket {
    private static final String WIN32_PIPE_PREFIX = "\\\\.\\pipe\\";
    private static final int BUFFER_SIZE = 65535;
    private final LinkedBlockingQueue<Handle> openHandles;
    private final LinkedBlockingQueue<Handle> connectedHandles;
    private final Win32NamedPipeSocket.CloseCallback closeCallback;
    private final String path;
    private final int maxInstances;
    private final Handle lockHandle;
    private final boolean requireStrictLength;
    private final Win32NamedPipeLibraryProvider provider;
    private final boolean useJNI;
    private final int securityLevel;

    public Win32NamedPipeServerSocket(String string) throws IOException {
        this(255, string);
    }

    public Win32NamedPipeServerSocket(String string, boolean bl, int n) throws IOException {
        this(255, string, false, bl, n);
    }

    @Deprecated
    public Win32NamedPipeServerSocket(String string, boolean bl) throws IOException {
        this(255, string, bl);
    }

    public Win32NamedPipeServerSocket(int n, String string) throws IOException {
        this(n, string, false);
    }

    public Win32NamedPipeServerSocket(int n, String string, boolean bl) throws IOException {
        this(n, string, bl, false, Win32SecurityLevel.LOGON_DACL);
    }

    public Win32NamedPipeServerSocket(int n, String string, boolean bl, boolean bl2, int n2) throws IOException {
        this.securityLevel = n2;
        this.useJNI = bl2;
        this.provider = bl2 ? JNIWin32NamedPipeLibraryProvider.instance() : JNAWin32NamedPipeLibraryProvider.instance();
        this.openHandles = new LinkedBlockingQueue();
        this.connectedHandles = new LinkedBlockingQueue();
        this.closeCallback = handle -> {
            if (this.connectedHandles.remove(handle)) {
                this.closeConnectedPipe(handle);
            }
            if (this.openHandles.remove(handle)) {
                this.closeOpenPipe(handle);
            }
        };
        this.maxInstances = n;
        this.requireStrictLength = bl;
        this.path = !string.startsWith(WIN32_PIPE_PREFIX) ? WIN32_PIPE_PREFIX + string : string;
        String string2 = this.path + "_lock";
        try {
            this.lockHandle = this.provider.CreateNamedPipe(string2, this.provider.FILE_FLAG_FIRST_PIPE_INSTANCE() | this.provider.PIPE_ACCESS_DUPLEX(), 0, 1, 65535, 65535, 0, this.provider.FILE_GENERIC_READ(), n2);
        }
        catch (IOException iOException) {
            throw new IOException(String.format("Could not create lock for %s, error %d", string2, this.provider.GetLastError()));
        }
        if (!this.provider.DisconnectNamedPipe(this.lockHandle)) {
            throw new IOException(String.format("Could not disconnect lock %d", this.provider.GetLastError()));
        }
    }

    @Override
    public void bind(SocketAddress socketAddress) throws IOException {
        throw new IOException("Win32 named pipes do not support bind(), pass path to constructor");
    }

    @Override
    public Socket accept() throws IOException {
        Handle handle;
        try {
            handle = this.provider.CreateNamedPipe(this.path, this.provider.PIPE_ACCESS_DUPLEX() | this.provider.FILE_FLAG_OVERLAPPED(), 0, this.maxInstances, 65535, 65535, 0, this.provider.FILE_ALL_ACCESS(), this.securityLevel);
        }
        catch (IOException iOException) {
            throw new IOException(String.format("Could not create named pipe, error %d", this.provider.GetLastError()));
        }
        this.openHandles.add(handle);
        Handle handle2 = this.provider.CreateEvent(true, false, null);
        Overlapped overlapped = this.provider.NewOverlapped(handle2);
        try {
            int n = this.provider.ConnectNamedPipe(handle, overlapped);
            if (n == -1) {
                this.openHandles.remove(handle);
                this.connectedHandles.add(handle);
                Win32NamedPipeSocket win32NamedPipeSocket = new Win32NamedPipeSocket(handle, this.closeCallback, this.requireStrictLength, this.useJNI);
                return win32NamedPipeSocket;
            }
            if (n == this.provider.ERROR_PIPE_CONNECTED()) {
                this.openHandles.remove(handle);
                this.connectedHandles.add(handle);
                Win32NamedPipeSocket win32NamedPipeSocket = new Win32NamedPipeSocket(handle, this.closeCallback, this.requireStrictLength, this.useJNI);
                return win32NamedPipeSocket;
            }
            if (n == this.provider.ERROR_NO_DATA()) {
                Win32NamedPipeSocket win32NamedPipeSocket = new Win32NamedPipeSocket(handle, this.closeCallback, this.requireStrictLength, this.useJNI);
                return win32NamedPipeSocket;
            }
            if (n == this.provider.ERROR_IO_PENDING()) {
                if (!this.provider.GetOverlappedResult(handle, overlapped)) {
                    this.openHandles.remove(handle);
                    this.closeOpenPipe(handle);
                    throw new IOException("GetOverlappedResult() failed for connect operation: " + this.provider.GetLastError());
                }
                this.openHandles.remove(handle);
                this.connectedHandles.add(handle);
                Win32NamedPipeSocket win32NamedPipeSocket = new Win32NamedPipeSocket(handle, this.closeCallback, this.requireStrictLength, this.useJNI);
                return win32NamedPipeSocket;
            }
            throw new IOException("ConnectNamedPipe() failed with: " + n);
        }
        finally {
            this.provider.DeleteOverlapped(overlapped);
            this.provider.CloseHandle(handle2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            Object object2;
            ArrayList arrayList = new ArrayList();
            this.openHandles.drainTo(arrayList);
            for (Object object2 : arrayList) {
                this.closeOpenPipe((Handle)object2);
            }
            ArrayList arrayList2 = new ArrayList();
            this.connectedHandles.drainTo(arrayList2);
            object2 = arrayList2.iterator();
            while (object2.hasNext()) {
                Handle handle = (Handle)object2.next();
                this.closeConnectedPipe(handle);
            }
        }
        finally {
            this.provider.CloseHandle(this.lockHandle);
        }
    }

    private void closeOpenPipe(Handle handle) throws IOException {
        this.provider.CancelIoEx(handle);
        this.provider.CloseHandle(handle);
    }

    private void closeConnectedPipe(Handle handle) throws IOException {
        this.provider.FlushFileBuffers(handle);
        this.provider.DisconnectNamedPipe(handle);
        this.provider.CloseHandle(handle);
    }
}

