/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.core.patch;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.compare.internal.core.ComparePlugin;
import org.eclipse.compare.internal.core.Messages;
import org.eclipse.compare.internal.core.patch.FilePatch2;
import org.eclipse.compare.internal.core.patch.Hunk;
import org.eclipse.compare.internal.core.patch.HunkResult;
import org.eclipse.compare.internal.core.patch.LineReader;
import org.eclipse.compare.internal.core.patch.Utilities;
import org.eclipse.compare.patch.IFilePatchResult;
import org.eclipse.compare.patch.IHunk;
import org.eclipse.compare.patch.PatchConfiguration;
import org.eclipse.compare.patch.ReaderCreator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class FileDiffResult
implements IFilePatchResult {
    private FilePatch2 fDiff;
    private boolean fMatches = false;
    private boolean fDiffProblem;
    private String fErrorMessage;
    private Map<Hunk, HunkResult> fHunkResults = new HashMap<Hunk, HunkResult>();
    private List<String> fBeforeLines;
    private List<String> fAfterLines;
    private final PatchConfiguration configuration;
    private String charset;

    public FileDiffResult(FilePatch2 diff, PatchConfiguration configuration) {
        this.fDiff = diff;
        this.configuration = configuration;
    }

    public PatchConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean canApplyHunk(Hunk hunk) {
        HunkResult result = this.getHunkResult(hunk);
        return result.isOK() && !this.fDiffProblem;
    }

    public void refresh(ReaderCreator content, IProgressMonitor monitor) {
        HunkResult result;
        Hunk hunk;
        IHunk h;
        int n;
        int n2;
        IHunk[] iHunkArray;
        IHunk[] hunks;
        this.fMatches = false;
        this.fDiffProblem = false;
        boolean create = false;
        this.charset = Utilities.getCharset(content);
        boolean exists = this.targetExists(content);
        if (this.fDiff.getDiffType(this.getConfiguration().isReversed()) == 1) {
            if ((!exists || this.isEmpty(content)) && this.canCreateTarget(content)) {
                this.fMatches = true;
            } else {
                this.fDiffProblem = true;
                this.fErrorMessage = Messages.FileDiffResult_0;
            }
            create = true;
        } else if (exists) {
            this.fMatches = true;
        } else {
            this.fDiffProblem = true;
            this.fErrorMessage = Messages.FileDiffResult_1;
        }
        if (this.fDiffProblem) {
            this.fBeforeLines = new ArrayList<String>(this.getLines(content, false));
            this.fAfterLines = this.fMatches ? new ArrayList() : this.fBeforeLines;
            iHunkArray = hunks = this.fDiff.getHunks();
            n2 = hunks.length;
            n = 0;
            while (n < n2) {
                h = iHunkArray[n];
                hunk = (Hunk)h;
                hunk.setCharset(this.getCharset());
                result = this.getHunkResult(hunk);
                result.setMatches(false);
                ++n;
            }
        } else {
            this.patch(this.getLines(content, create), monitor);
        }
        if (this.containsProblems() && this.fMatches) {
            this.fMatches = false;
            iHunkArray = hunks = this.fDiff.getHunks();
            n2 = hunks.length;
            n = 0;
            while (n < n2) {
                h = iHunkArray[n];
                hunk = (Hunk)h;
                result = this.getHunkResult(hunk);
                if (result.isOK()) {
                    this.fMatches = true;
                    break;
                }
                ++n;
            }
        }
    }

    protected boolean canCreateTarget(ReaderCreator content) {
        return true;
    }

    protected boolean targetExists(ReaderCreator content) {
        return content != null && content.canCreateReader();
    }

    protected List<String> getLines(ReaderCreator content, boolean create) {
        List<String> lines = LineReader.load(content, create);
        return lines;
    }

    protected boolean isEmpty(ReaderCreator content) {
        if (content == null) {
            return true;
        }
        return LineReader.load(content, false).isEmpty();
    }

    public void patch(List<String> lines, IProgressMonitor monitor) {
        IHunk[] hunks;
        this.fBeforeLines = new ArrayList<String>();
        this.fBeforeLines.addAll(lines);
        if (this.getConfiguration().getFuzz() != 0) {
            this.calculateFuzz(this.fBeforeLines, monitor);
        }
        int shift = 0;
        IHunk[] iHunkArray = hunks = this.fDiff.getHunks();
        int n = hunks.length;
        int n2 = 0;
        while (n2 < n) {
            IHunk h = iHunkArray[n2];
            Hunk hunk = (Hunk)h;
            hunk.setCharset(this.getCharset());
            HunkResult result = this.getHunkResult(hunk);
            result.setShift(shift);
            if (result.patch(lines)) {
                shift = result.getShift();
            }
            ++n2;
        }
        this.fAfterLines = lines;
    }

    public boolean getDiffProblem() {
        return this.fDiffProblem;
    }

    public boolean containsProblems() {
        if (this.fDiffProblem) {
            return true;
        }
        for (HunkResult result : this.fHunkResults.values()) {
            if (result.isOK()) continue;
            return true;
        }
        return false;
    }

    public String getLabel() {
        String label = this.getTargetPath().toString();
        if (this.fDiffProblem) {
            return NLS.bind((String)Messages.FileDiffResult_2, (Object[])new String[]{label, this.fErrorMessage});
        }
        return label;
    }

    @Override
    public boolean hasMatches() {
        return this.fMatches;
    }

    public List<String> getLines() {
        return this.fAfterLines;
    }

    public int calculateFuzz(List<String> lines, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.fBeforeLines = new ArrayList<String>(lines);
        if (this.fDiff.getDiffType(this.getConfiguration().isReversed()) == 1) {
            return -1;
        }
        int shift = 0;
        int highestFuzz = -1;
        String name = this.getTargetPath() != null ? this.getTargetPath().lastSegment() : "";
        IHunk[] hunks = this.fDiff.getHunks();
        int j = 0;
        while (j < hunks.length) {
            Hunk h = (Hunk)hunks[j];
            monitor.subTask(NLS.bind((String)Messages.FileDiffResult_3, (Object[])new String[]{name, Integer.toString(j + 1)}));
            HunkResult result = this.getHunkResult(h);
            result.setShift(shift);
            int fuzz = result.calculateFuzz(lines, monitor);
            shift = result.getShift();
            if (fuzz > highestFuzz) {
                highestFuzz = fuzz;
            }
            monitor.worked(1);
            ++j;
        }
        this.fAfterLines = lines;
        return highestFuzz;
    }

    public IPath getTargetPath() {
        return this.fDiff.getStrippedPath(this.getConfiguration().getPrefixSegmentStripCount(), this.getConfiguration().isReversed());
    }

    private HunkResult getHunkResult(Hunk hunk) {
        HunkResult result = this.fHunkResults.get(hunk);
        if (result == null) {
            result = new HunkResult(this, hunk);
            this.fHunkResults.put(hunk, result);
        }
        return result;
    }

    public List<Hunk> getFailedHunks() {
        IHunk[] hunks;
        ArrayList<Hunk> failedHunks = new ArrayList<Hunk>();
        IHunk[] iHunkArray = hunks = this.fDiff.getHunks();
        int n = hunks.length;
        int n2 = 0;
        while (n2 < n) {
            IHunk hunk = iHunkArray[n2];
            HunkResult result = this.fHunkResults.get(hunk);
            if (result != null && !result.isOK()) {
                failedHunks.add(result.getHunk());
            }
            ++n2;
        }
        return failedHunks;
    }

    public FilePatch2 getDiff() {
        return this.fDiff;
    }

    public List<String> getBeforeLines() {
        return this.fBeforeLines;
    }

    public List<String> getAfterLines() {
        return this.fAfterLines;
    }

    public HunkResult[] getHunkResults() {
        IHunk[] hunks;
        ArrayList<HunkResult> results = new ArrayList<HunkResult>();
        IHunk[] iHunkArray = hunks = this.fDiff.getHunks();
        int n = hunks.length;
        int n2 = 0;
        while (n2 < n) {
            IHunk hunk = iHunkArray[n2];
            HunkResult result = this.fHunkResults.get(hunk);
            if (result != null) {
                results.add(result);
            }
            ++n2;
        }
        return results.toArray(new HunkResult[results.size()]);
    }

    @Override
    public InputStream getOriginalContents() {
        String contents = LineReader.createString(this.isPreserveLineDelimeters(), this.getBeforeLines());
        return FileDiffResult.asInputStream(contents, this.getCharset());
    }

    @Override
    public InputStream getPatchedContents() {
        String contents = LineReader.createString(this.isPreserveLineDelimeters(), this.getLines());
        return FileDiffResult.asInputStream(contents, this.getCharset());
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    public boolean isPreserveLineDelimeters() {
        return false;
    }

    @Override
    public IHunk[] getRejects() {
        List<Hunk> failedHunks = this.getFailedHunks();
        return failedHunks.toArray(new IHunk[failedHunks.size()]);
    }

    @Override
    public boolean hasRejects() {
        return this.getFailedHunks().size() > 0;
    }

    public static InputStream asInputStream(String contents, String charSet) {
        byte[] bytes = null;
        if (charSet != null) {
            try {
                bytes = contents.getBytes(charSet);
            }
            catch (UnsupportedEncodingException e) {
                ComparePlugin.log(e);
            }
        }
        if (bytes == null) {
            bytes = contents.getBytes();
        }
        return new ByteArrayInputStream(bytes);
    }
}

