/*
 * Decompiled with CFR 0.152.
 */
package coursier.launcher;

import coursier.launcher.AssemblyGenerator$;
import coursier.launcher.Generator;
import coursier.launcher.Parameters;
import coursier.launcher.Parameters$Assembly$;
import coursier.launcher.Preamble;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Left;
import scala.util.Right;

public final class NativeImageGenerator$
extends Generator<Parameters.NativeImage> {
    public static final NativeImageGenerator$ MODULE$ = new NativeImageGenerator$();

    private Option<File> executable(File dir, String name, Option<Seq<String>> pathExtensionsOpt) {
        Some some;
        Option<Seq<String>> option = pathExtensionsOpt;
        if (None$.MODULE$.equals(option)) {
            some = new Some((Object)new File(dir, name));
        } else if (option instanceof Some) {
            Some some2 = (Some)option;
            Seq pathExts = (Seq)some2.value();
            Iterator it = pathExts.iterator().map((Function1 & Serializable)ext -> new File(dir, new StringBuilder(0).append(name).append((String)ext).toString())).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.exists()));
            some = it.hasNext() ? new Some(it.next()) : None$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        return some;
    }

    @Override
    public void generate(Parameters.NativeImage parameters, Path output) {
        block15: {
            Left left;
            block14: {
                Left res;
                Left left2;
                Path currentDir;
                Path relativizedOutput = output.isAbsolute() ? (output.startsWith(currentDir = Paths.get(System.getProperty("user.dir"), new String[0])) ? currentDir.relativize(output) : output) : output;
                String version = (String)parameters.graalvmVersion().getOrElse((Function0 & Serializable)() -> "latest.release");
                boolean isInterval = version.startsWith("latest") || version.endsWith("+") || version.contains("[") || version.contains("(");
                String version0 = isInterval ? version : new StringBuilder(1).append(version).append("+").toString();
                Seq<String> javaOpts = parameters.graalvmJvmOptions();
                Seq cp = (Seq)parameters.fetch().apply((Object)new .colon.colon((Object)new StringBuilder(35).append("org.graalvm.nativeimage:svm-driver:").append(version0).toString(), (List)Nil$.MODULE$));
                String javaPath = (String)parameters.javaHome().map((Function1 & Serializable)x$2 -> new File((File)x$2, "bin")).flatMap((Function1 & Serializable)x$3 -> MODULE$.executable((File)x$3, "java", parameters.windowsPathExtensions())).fold((Function0 & Serializable)() -> "java", (Function1 & Serializable)x$4 -> x$4.getAbsolutePath());
                Seq startCmd = (Seq)((IterableOps)new .colon.colon((Object)javaPath, (List)Nil$.MODULE$).$plus$plus(javaOpts)).$plus$plus((IterableOnce)new .colon.colon((Object)"-cp", (List)new .colon.colon((Object)((IterableOnceOps)cp.map((Function1 & Serializable)x$5 -> x$5.getAbsolutePath())).mkString(File.pathSeparator), (List)new .colon.colon((Object)"com.oracle.svm.driver.NativeImage", (List)Nil$.MODULE$))));
                Path tmpFile = null;
                try {
                    ProcessBuilder b;
                    Process p2;
                    int retCode;
                    String string;
                    if (parameters.intermediateAssembly()) {
                        Parameters.Assembly p3 = Parameters$Assembly$.MODULE$.apply().withFiles(parameters.jars()).withMainClass(parameters.mainClass()).withPreambleOpt((Option<Preamble>)None$.MODULE$);
                        tmpFile = Files.createTempFile("native-image-assembly-", ".jar", new FileAttribute[0]);
                        AssemblyGenerator$.MODULE$.generate(p3, tmpFile);
                        string = ((Object)tmpFile).toString();
                    } else {
                        string = ((IterableOnceOps)parameters.jars().map((Function1 & Serializable)x$6 -> x$6.getAbsolutePath().toString())).mkString(File.pathSeparator);
                    }
                    String cp2 = string;
                    Seq cmd = (Seq)((IterableOps)((IterableOps)startCmd.$plus$plus(parameters.graalvmOptions())).$plus$plus((IterableOnce)parameters.nameOpt().map((Function1 & Serializable)name -> new StringBuilder(8).append("-H:Name=").append((String)name).toString()))).$plus$plus((IterableOnce)new .colon.colon((Object)"-cp", (List)new .colon.colon((Object)cp2, (List)new .colon.colon((Object)parameters.mainClass(), (List)new .colon.colon((Object)((Object)relativizedOutput).toString(), (List)Nil$.MODULE$)))));
                    if (parameters.verbosity() >= 1) {
                        System.err.println(new StringBuilder(8).append("Running ").append(cmd).toString());
                    }
                    if ((retCode = (p2 = (b = new ProcessBuilder((String[])cmd.toArray(ClassTag$.MODULE$.apply(String.class))).inheritIO()).start()).waitFor()) == 0) {
                        if (parameters.isWindows()) {
                            String exe = new StringBuilder(4).append(((Object)output.getFileName()).toString()).append(".exe").toString();
                            Stream<Path> s = Files.list(output.getParent());
                            String prefix = new StringBuilder(1).append(((Object)output.getFileName()).toString()).append(".").toString();
                            CollectionConverters$.MODULE$.IteratorHasAsScala(s.iterator()).asScala().toVector().foreach((Function1 & Serializable)p -> {
                                String name;
                                String string = name = ((Object)p.getFileName()).toString();
                                String string2 = exe;
                                return (string == null ? string2 != null : !string.equals(string2)) && name.startsWith(prefix) ? BoxesRunTime.boxToBoolean((boolean)Files.deleteIfExists(p)) : BoxedUnit.UNIT;
                            });
                            s.close();
                        }
                        left2 = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                    } else {
                        left2 = package$.MODULE$.Left().apply((Object)BoxesRunTime.boxToInteger((int)retCode));
                    }
                }
                catch (Throwable throwable) {
                    if (tmpFile != null) {
                        Files.deleteIfExists(tmpFile);
                    }
                    throw throwable;
                }
                if (tmpFile != null) {
                    Files.deleteIfExists(tmpFile);
                }
                if ((left = (res = left2)) instanceof Left) {
                    Left left3 = left;
                    int retCode = BoxesRunTime.unboxToInt((Object)left3.value());
                    throw scala.sys.package$.MODULE$.error(new StringBuilder(40).append("Error running native-image (exit code: ").append(retCode).append(")").toString());
                }
                if (!(left instanceof Right)) break block14;
                Right right = (Right)left;
                BoxedUnit boxedUnit = (BoxedUnit)right.value();
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                BoxedUnit boxedUnit3 = boxedUnit;
                if (!(boxedUnit2 != null ? !boxedUnit2.equals(boxedUnit3) : boxedUnit3 != null)) break block15;
            }
            throw new MatchError((Object)left);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private <T> T withTempFile(byte[] content, Function1<Path, T> t) {
        Object object;
        Path path = Files.createTempFile("temp", ".tmp", new FileAttribute[0]);
        try {
            Files.write(path, content, new OpenOption[0]);
            object = t.apply((Object)path);
        }
        finally {
            Files.deleteIfExists(path);
        }
        return (T)object;
    }

    private NativeImageGenerator$() {
    }
}

