/*
 * Decompiled with CFR 0.152.
 */
package metaconfig;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Path;
import metaconfig.Conf;
import metaconfig.ConfError;
import metaconfig.ConfError$;
import metaconfig.Configured;
import metaconfig.Position;
import metaconfig.Position$None$;
import metaconfig.annotation.DeprecatedName;
import metaconfig.error.CompositeException;
import metaconfig.internal.Levenshtein$;
import scala.DummyImplicit;
import scala.DummyImplicit$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;

public final class ConfError$
implements Serializable {
    public static final ConfError$ MODULE$ = new ConfError$();
    private static ConfError empty;
    private static volatile boolean bitmap$0;

    private ConfError empty$lzycompute() {
        ConfError$ confError$ = this;
        synchronized (confError$) {
            if (!bitmap$0) {
                empty = new ConfError(){};
                bitmap$0 = true;
            }
        }
        return empty;
    }

    public ConfError empty() {
        if (!bitmap$0) {
            return this.empty$lzycompute();
        }
        return empty;
    }

    public ConfError deprecated(String name, String message, String sinceVersion2) {
        return this.deprecated(new DeprecatedName(name, message, sinceVersion2));
    }

    public ConfError deprecated(DeprecatedName deprecation) {
        return new ConfError(deprecation){

            public boolean isDeprecation() {
                return true;
            }
        };
    }

    public ConfError message(String message) {
        return new ConfError(message){};
    }

    public ConfError exception(Throwable e, int stackSize) {
        e.setStackTrace((StackTraceElement[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.refArrayOps((Object[])e.getStackTrace()), stackSize));
        return new ConfError(e){
            private final Throwable e$1;

            public Option<Throwable> cause() {
                return new Some((Object)this.e$1);
            }
            {
                this.e$1 = e$1;
                super(e$1.getMessage());
            }
        };
    }

    public int exception$default$2() {
        return 10;
    }

    public ConfError fileDoesNotExist(Path path) {
        return this.fileDoesNotExist(((Object)path.toAbsolutePath()).toString());
    }

    public ConfError fileDoesNotExist(File file) {
        return this.fileDoesNotExist(file.getAbsolutePath());
    }

    public ConfError fileDoesNotExist(String path) {
        return this.message(new StringBuilder(21).append("File ").append(path).append(" does not exist.").toString());
    }

    public ConfError parseError(Position position, String message) {
        return new ConfError(position, message){

            public boolean isParseError() {
                return true;
            }
        };
    }

    public ConfError typeMismatch(String expected, Conf obtained) {
        return this.typeMismatch(expected, obtained, "");
    }

    public ConfError typeMismatch(String expected, Conf obtained, String path) {
        return this.typeMismatch(expected, new StringBuilder(10).append(obtained.kind()).append(" (value: ").append(obtained).append(")").toString(), path).atPos(obtained.pos());
    }

    public ConfError typeMismatch(String expected, String obtained, String path) {
        String pathSuffix = path.isEmpty() ? "" : new StringBuilder(6).append(" at '").append(path).append("'").toString();
        return new ConfError(pathSuffix, obtained, expected){

            public boolean isTypeMismatch() {
                return true;
            }
        };
    }

    public ConfError missingField(Conf.Obj obj, String field) {
        String string;
        if (obj.values().lengthCompare(1) <= 0) {
            string = "";
        } else {
            String closestField = obj.values().isEmpty() ? "" : (String)((IterableOnceOps)obj.keys().sorted((Ordering)Ordering.String$.MODULE$)).minBy((Function1 & Serializable)s2 -> BoxesRunTime.boxToInteger((int)Levenshtein$.MODULE$.distance(field, s2)), (Ordering)Ordering.Int$.MODULE$);
            string = new StringBuilder(25).append(" Did you mean '").append(closestField).append("' instead?").toString();
        }
        String hint = string;
        return new ConfError(obj, field, hint){

            public boolean isMissingField() {
                return true;
            }
        };
    }

    public ConfError invalidFields(Iterable<String> invalid, Iterable<String> valid) {
        return (ConfError)this.invalidFieldsOpt(invalid, valid).getOrElse((Function0 & Serializable)() -> MODULE$.empty());
    }

    public Option<ConfError> invalidFieldsOpt(Iterable<String> invalid, Iterable<String> valid) {
        return this.invalidFieldsOpt((Iterable<Tuple2<String, Position>>)((Iterable)invalid.map((Function1 & Serializable)i -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(i), (Object)Position$None$.MODULE$))), valid, DummyImplicit$.MODULE$.dummyImplicit());
    }

    public ConfError invalidFields(Iterable<Tuple2<String, Position>> invalid, Iterable<String> valid, DummyImplicit dummy) {
        return (ConfError)this.invalidFieldsOpt(invalid, valid, dummy).getOrElse((Function0 & Serializable)() -> MODULE$.empty());
    }

    public Option<ConfError> invalidFieldsOpt(Iterable<Tuple2<String, Position>> invalid, Iterable<String> valid, DummyImplicit dummy) {
        Seq candidates = valid.toSeq();
        List errors = invalid.toList().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String string;
                String field = (String)tuple2._1();
                Position pos = (Position)tuple2._2();
                Option<String> closestCandidate = Levenshtein$.MODULE$.closestCandidate(field, (Seq<String>)candidates);
                Option<String> option = closestCandidate;
                if (None$.MODULE$.equals(option)) {
                    string = "";
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    String candidate = (String)some.value();
                    string = new StringBuilder(18).append("\n\tDid you mean '").append(candidate).append("'?").toString();
                } else {
                    throw new MatchError(option);
                }
                String didYouMean = string;
                return MODULE$.message(new StringBuilder(70).append("found option '").append(field).append("' which wasn't expected, or isn't valid in this context.").append(didYouMean).toString()).atPos(pos);
            }
            throw new MatchError((Object)tuple2);
        });
        return this.apply((Seq<ConfError>)errors);
    }

    public Option<ConfError> fromResults(Seq<Configured<?>> results) {
        return this.apply((Seq<ConfError>)((Seq)results.collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Configured<?>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof Configured.NotOk) {
                    Configured.NotOk notOk = (Configured.NotOk)A1;
                    ConfError x = notOk.error();
                    return (B1)x;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Configured<?> x1) {
                Configured<?> configured = x1;
                return configured instanceof Configured.NotOk;
            }
        })));
    }

    public Option<ConfError> apply(Seq<ConfError> errors) {
        return ConfError$.metaconfig$ConfError$$seqToOpt$1(errors, (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                ConfError head = (ConfError)tuple2._1();
                Seq tail = (Seq)tuple2._2();
                return new ConfError(head, tail, errors){
                    private final ConfError head$1;
                    private final Seq tail$1;
                    private final Seq errors$1;

                    public List<String> extra() {
                        return (List)this.head$1.extra().$plus$plus((IterableOnce)this.tail$1.flatMap((Function1 & Serializable)x -> {
                            String string = x.stackTrace();
                            return x.extra().$colon$colon((Object)string);
                        }));
                    }

                    public Option<ConfError.TypeMismatch> typeMismatch() {
                        return ((IterableOps)this.errors$1.view().flatMap((Function1 & Serializable)x$1 -> x$1.typeMismatch())).headOption();
                    }

                    public boolean isParseError() {
                        return this.errors$1.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)anon.11.$anonfun$isParseError$1(x$2)));
                    }

                    public boolean isMissingField() {
                        return this.errors$1.exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)anon.11.$anonfun$isMissingField$1(x$3)));
                    }

                    public Option<Throwable> cause() {
                        return ConfError$.metaconfig$ConfError$$seqToOpt$1((Seq)this.errors$1.flatMap((Function1 & Serializable)x$4 -> {
                            Some some;
                            Throwable c;
                            Option<Throwable> option = x$4.cause();
                            if (option instanceof Some && (c = (Throwable)(some = (Some)option).value()) instanceof CompositeException) {
                                CompositeException compositeException = (CompositeException)c;
                                return compositeException.all();
                            }
                            return option;
                        }), (Function2 & Serializable)(x0$1, x1$1) -> {
                            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                            if (tuple2 != null) {
                                Throwable head = (Throwable)tuple2._1();
                                Seq tail = (Seq)tuple2._2();
                                return new CompositeException(head, (List<Throwable>)tail.toList());
                            }
                            throw new MatchError((Object)tuple2);
                        });
                    }

                    public static final /* synthetic */ boolean $anonfun$isParseError$1(ConfError x$2) {
                        return x$2.isParseError();
                    }

                    public static final /* synthetic */ boolean $anonfun$isMissingField$1(ConfError x$3) {
                        return x$3.isMissingField();
                    }
                    {
                        this.head$1 = head$1;
                        this.tail$1 = tail$1;
                        this.errors$1 = errors$1;
                        super(head$1.stackTrace());
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$cause$1(metaconfig.ConfError ), $anonfun$cause$2(java.lang.Throwable scala.collection.immutable.Seq ), $anonfun$extra$1(metaconfig.ConfError ), $anonfun$isMissingField$1$adapted(metaconfig.ConfError ), $anonfun$isParseError$1$adapted(metaconfig.ConfError ), $anonfun$typeMismatch$2(metaconfig.ConfError )}, serializedLambda);
                    }
                };
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ConfError$.class);
    }

    public static final Option metaconfig$ConfError$$seqToOpt$1(Seq values, Function2 f) {
        return values.headOption().map((Function1 & Serializable)head -> {
            Seq tail = (Seq)values.tail();
            if (tail.isEmpty()) {
                return head;
            }
            return f.apply(head, (Object)tail);
        });
    }

    private ConfError$() {
    }
}

