/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter;

import com.microsoft.java.debug.core.adapter.IdCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RecyclableObjectPool<O, V> {
    private final IdCollection<V> objectCollection = new IdCollection();
    private final Map<V, Set<O>> referenceMap = new HashMap<V, Set<O>>();
    private final Map<V, Integer> objectIdMap = new HashMap<V, Integer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addObject(O o, V v) {
        if (o == null) {
            throw new IllegalArgumentException("Owner cannot be null.");
        }
        if (v == null) {
            throw new IllegalArgumentException("Null object cannot be added.");
        }
        RecyclableObjectPool recyclableObjectPool = this;
        synchronized (recyclableObjectPool) {
            if (!this.referenceMap.containsKey(v)) {
                HashSet<O> hashSet = new HashSet<O>(1);
                hashSet.add(o);
                this.referenceMap.put(v, (Set<O>)hashSet);
                int n = this.objectCollection.create(v);
                this.objectIdMap.put((Integer)v, n);
                return n;
            }
            this.referenceMap.get(v).add(o);
            return this.objectIdMap.get(v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getObjectById(int n) {
        RecyclableObjectPool recyclableObjectPool = this;
        synchronized (recyclableObjectPool) {
            return this.objectCollection.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeObjectById(int n) {
        RecyclableObjectPool recyclableObjectPool = this;
        synchronized (recyclableObjectPool) {
            V v = this.objectCollection.remove(n);
            if (v == null) {
                return false;
            }
            this.referenceMap.remove(v);
            this.objectIdMap.remove(v);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeObjectsByOwner(O o) {
        if (o == null) {
            throw new IllegalArgumentException("owner cannot be null.");
        }
        RecyclableObjectPool recyclableObjectPool = this;
        synchronized (recyclableObjectPool) {
            ArrayList arrayList = new ArrayList();
            this.referenceMap.forEach((object2, set) -> {
                if (set.remove(o) && set.isEmpty()) {
                    arrayList.add(object2);
                }
            });
            for (Object e : arrayList) {
                this.objectCollection.remove(this.objectIdMap.remove(e));
                this.referenceMap.remove(e);
            }
            return !arrayList.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllObjects() {
        RecyclableObjectPool recyclableObjectPool = this;
        synchronized (recyclableObjectPool) {
            this.objectCollection.reset();
            this.referenceMap.clear();
            this.objectIdMap.clear();
        }
    }
}

