/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.cache;

import coursierapi.shaded.coursier.cache.CacheDefaults$;
import coursierapi.shaded.coursier.cache.CacheLogger$;
import coursierapi.shaded.coursier.cache.FileCache;
import coursierapi.shaded.coursier.cache.internal.FileUtil;
import coursierapi.shaded.coursier.cache.internal.FileUtil$;
import coursierapi.shaded.coursier.cache.internal.Retry;
import coursierapi.shaded.coursier.paths.CachePath;
import coursierapi.shaded.coursier.util.Sync;
import coursierapi.shaded.coursier.util.Task;
import coursierapi.shaded.coursier.util.Task$;
import coursierapi.shaded.scala.$less$colon$less$;
import coursierapi.shaded.scala.Function0;
import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.None$;
import coursierapi.shaded.scala.Option;
import coursierapi.shaded.scala.PartialFunction;
import coursierapi.shaded.scala.Predef$;
import coursierapi.shaded.scala.collection.ArrayOps$;
import coursierapi.shaded.scala.collection.StringOps$;
import coursierapi.shaded.scala.collection.immutable.Nil$;
import coursierapi.shaded.scala.runtime.BoxedUnit;
import coursierapi.shaded.scala.runtime.BoxesRunTime;
import coursierapi.shaded.scala.runtime.ObjectRef;
import coursierapi.shaded.scala.util.Properties$;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.time.Clock;
import java.util.Locale;

public final class FileCache$
implements Serializable {
    public static final FileCache$ MODULE$ = new FileCache$();

    public File localFile0(String url, File cache, Option<String> user, boolean localArtifactsShouldBeCached) {
        return CachePath.localFile(url, cache, (String)user.orNull($less$colon$less$.MODULE$.refl()), localArtifactsShouldBeCached);
    }

    private String auxiliaryFilePrefix(File file) {
        return new StringBuilder(3).append(".").append(file.getName()).append("__").toString();
    }

    public void clearAuxiliaryFiles(File file) {
        String prefix = this.auxiliaryFilePrefix(file);
        FilenameFilter filter = new FilenameFilter(prefix){
            private final String prefix$1;

            public boolean accept(File dir, String name) {
                return name.startsWith(this.prefix$1);
            }
            {
                this.prefix$1 = prefix$1;
            }
        };
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(file.getParentFile().listFiles(filter)), (Function1<File, Object> & Serializable)f -> BoxesRunTime.boxToBoolean(f.delete()));
    }

    public File auxiliaryFile(File file, String key) {
        String key0 = StringOps$.MODULE$.filter$extension(Predef$.MODULE$.augmentString(key.toLowerCase(Locale.ROOT)), (Function1<Object, Object> & Serializable)x$21 -> BoxesRunTime.boxToBoolean(FileCache$.$anonfun$auxiliaryFile$1(BoxesRunTime.unboxToChar(x$21))));
        return new File(file.getParentFile(), new StringBuilder(0).append(this.auxiliaryFilePrefix(file)).append(key0).toString());
    }

    public <F> FileCache<F> apply(Sync<F> S) {
        return this.apply(CacheDefaults$.MODULE$.location(), S);
    }

    public BigInteger coursier$cache$FileCache$$persistedDigest(File location, String sumType, File localFile, Retry retry) {
        byte[] byArray;
        String location0 = new StringBuilder(0).append(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(location.getCanonicalPath()), File.separator)).append(File.separator).toString();
        boolean isInCache = localFile.getCanonicalPath().startsWith(location0);
        if (!isInCache) {
            byArray = this.computeDigest(sumType, localFile, retry);
        } else {
            File cacheFile = this.auxiliaryFile(localFile, new StringBuilder(9).append(sumType).append(".computed").toString());
            Path cacheFilePath = cacheFile.toPath();
            try {
                byArray = (byte[])retry.retry((Function0<byte[]> & Serializable)() -> Files.readAllBytes(cacheFilePath), (PartialFunction<Throwable, BoxedUnit>)((Object)new Serializable(){

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        if (A1 instanceof AccessDeniedException && Properties$.MODULE$.isWin()) {
                            return (B1)BoxedUnit.UNIT;
                        }
                        return function1.apply(x1);
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        return throwable instanceof AccessDeniedException && Properties$.MODULE$.isWin();
                    }
                }));
            }
            catch (NoSuchFileException noSuchFileException) {
                byte[] bytes = this.computeDigest(sumType, localFile, retry);
                Path tmpFile = File.createTempFile(cacheFile.getName(), ".tmp", cacheFile.getParentFile()).toPath();
                try {
                    Files.write(tmpFile, bytes, new OpenOption[0]);
                    retry.retry((Function0<Object> & Serializable)() -> {
                        Object object;
                        try {
                            object = Files.move(tmpFile, cacheFilePath, StandardCopyOption.ATOMIC_MOVE);
                        }
                        catch (FileAlreadyExistsException fileAlreadyExistsException) {
                            object = BoxedUnit.UNIT;
                        }
                        return object;
                    }, (PartialFunction<Throwable, BoxedUnit>)((Object)new Serializable(){

                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                            A1 A1 = x2;
                            if (A1 instanceof AccessDeniedException && Properties$.MODULE$.isWin()) {
                                return (B1)BoxedUnit.UNIT;
                            }
                            return function1.apply(x2);
                        }

                        public final boolean isDefinedAt(Throwable x2) {
                            Throwable throwable = x2;
                            return throwable instanceof AccessDeniedException && Properties$.MODULE$.isWin();
                        }
                    }));
                }
                finally {
                    Files.deleteIfExists(tmpFile);
                }
                byArray = bytes;
            }
        }
        byte[] digested = byArray;
        return new BigInteger(1, digested);
    }

    private byte[] computeDigest(String sumType, File localFile, Retry retry) {
        MessageDigest md = MessageDigest.getInstance(sumType);
        ObjectRef<Object> is = ObjectRef.create(null);
        try {
            retry.retry(() -> {
                is$1.elem = new FileInputStream(localFile);
            }, (PartialFunction<Throwable, BoxedUnit>)((Object)new Serializable(){

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof FileNotFoundException && Properties$.MODULE$.isWin()) {
                        return (B1)BoxedUnit.UNIT;
                    }
                    return function1.apply(x1);
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    return throwable instanceof FileNotFoundException && Properties$.MODULE$.isWin();
                }
            }));
            FileUtil$.MODULE$.withContent((FileInputStream)is.elem, new FileUtil.UpdateDigest(md), FileUtil$.MODULE$.withContent$default$3());
        }
        finally {
            if ((FileInputStream)is.elem != null) {
                ((FileInputStream)is.elem).close();
            }
        }
        return md.digest();
    }

    public <F> FileCache<F> apply(File location, Sync<F> sync) {
        return new FileCache<F>(location, CacheDefaults$.MODULE$.cachePolicies(), CacheDefaults$.MODULE$.checksums(), CacheDefaults$.MODULE$.credentials(), CacheLogger$.MODULE$.nop(), CacheDefaults$.MODULE$.pool(), CacheDefaults$.MODULE$.ttl(), false, true, false, CacheDefaults$.MODULE$.maxRedirections(), CacheDefaults$.MODULE$.retryCount(), None$.MODULE$, None$.MODULE$, CacheDefaults$.MODULE$.retryCount(), CacheDefaults$.MODULE$.bufferSize(), Nil$.MODULE$, Clock.systemDefaultZone(), CacheDefaults$.MODULE$.retryBackoffInitialDelay(), CacheDefaults$.MODULE$.retryBackoffMultiplier(), sync);
    }

    public <F> Sync<Task> apply$default$1() {
        return Task$.MODULE$.sync();
    }

    public static final /* synthetic */ boolean $anonfun$auxiliaryFile$1(char x$21) {
        return x$21 != '-';
    }

    private FileCache$() {
    }
}

