/*******************************************************************************
 * Copyright (C) 2017 Advanced Micro Devices, Inc. All rights reserved.
 *******************************************************************************/
#include <algorithm>
#include <cmath>
#include <sstream>
#include <vector>

#include <miopengemm/geometries.hpp>
#include <miopengemm/geometry.hpp>

namespace MIOpenGEMM
{

std::vector<Geometry> take_fives(size_t wSpaceSize)
{
  std::vector<Geometry> geometries;

  std::vector<size_t> fives{3, 10001};

  for (size_t m : fives)
  {
    for (size_t n : fives)
    {
      for (size_t k : fives)
      {
        for (bool tA : {true, false})
        {
          for (bool tB : {true, false})
          {
            geometries.push_back({m, n, k, tA, tB, wSpaceSize, 'f'});
          }
        }
      }
    }
  }
  return geometries;
}

std::vector<Geometry> get_deepbench(size_t wSpaceSize)
{

  return {{512, 8, 500000, true, false, wSpaceSize, 'f'},
          {512, 8, 500000, false, false, wSpaceSize, 'f'},
          {512, 16, 512, false, true, wSpaceSize, 'f'},
          {512, 16, 512, false, false, wSpaceSize, 'f'},
          {512, 16, 500000, true, false, wSpaceSize, 'f'},
          {1024, 8, 500000, true, false, wSpaceSize, 'f'},
          {512, 16, 500000, false, false, wSpaceSize, 'f'},
          {1024, 8, 500000, false, false, wSpaceSize, 'f'},
          {512, 32, 512, false, true, wSpaceSize, 'f'},
          {512, 32, 512, false, false, wSpaceSize, 'f'},
          {1024, 16, 512, false, true, wSpaceSize, 'f'},
          {1024, 16, 512, false, false, wSpaceSize, 'f'},
          {1024, 16, 500000, true, false, wSpaceSize, 'f'},
          {1024, 16, 500000, false, false, wSpaceSize, 'f'},
          {1760, 16, 1760, true, false, wSpaceSize, 'f'},
          {1760, 16, 1760, false, false, wSpaceSize, 'f'},
          {1024, 32, 512, false, true, wSpaceSize, 'f'},
          {1024, 32, 512, false, false, wSpaceSize, 'f'},
          {2048, 16, 2048, true, false, wSpaceSize, 'f'},
          {2048, 16, 2048, false, false, wSpaceSize, 'f'},
          {2560, 16, 2560, true, false, wSpaceSize, 'f'},
          {2560, 16, 2560, false, false, wSpaceSize, 'f'},
          {3072, 16, 1024, true, false, wSpaceSize, 'f'},
          {3072, 16, 1024, false, false, wSpaceSize, 'f'},
          {1760, 32, 1760, true, false, wSpaceSize, 'f'},
          {1760, 32, 1760, false, false, wSpaceSize, 'f'},
          {4096, 16, 4096, true, false, wSpaceSize, 'f'},
          {2048, 32, 2048, true, false, wSpaceSize, 'f'},
          {4096, 16, 4096, false, false, wSpaceSize, 'f'},
          {2048, 32, 2048, false, false, wSpaceSize, 'f'},
          {4608, 16, 1536, true, false, wSpaceSize, 'f'},
          {4608, 16, 1536, false, false, wSpaceSize, 'f'},
          {2560, 32, 2560, true, false, wSpaceSize, 'f'},
          {2560, 32, 2560, false, false, wSpaceSize, 'f'},
          {6144, 16, 2048, true, false, wSpaceSize, 'f'},
          {6144, 16, 2048, false, false, wSpaceSize, 'f'},
          {3072, 32, 1024, true, false, wSpaceSize, 'f'},
          {3072, 32, 1024, false, false, wSpaceSize, 'f'},
          {1760, 64, 1760, true, false, wSpaceSize, 'f'},
          {1760, 64, 1760, false, false, wSpaceSize, 'f'},
          {7680, 16, 2560, true, false, wSpaceSize, 'f'},
          {7680, 16, 2560, false, false, wSpaceSize, 'f'},
          {4096, 32, 4096, true, false, wSpaceSize, 'f'},
          {2048, 64, 2048, true, false, wSpaceSize, 'f'},
          {4096, 32, 4096, false, false, wSpaceSize, 'f'},
          {2048, 64, 2048, false, false, wSpaceSize, 'f'},
          {8448, 16, 2816, true, false, wSpaceSize, 'f'},
          {8448, 16, 2816, false, false, wSpaceSize, 'f'},
          {4608, 32, 1536, true, false, wSpaceSize, 'f'},
          {4608, 32, 1536, false, false, wSpaceSize, 'f'},
          {2560, 64, 2560, true, false, wSpaceSize, 'f'},
          {2560, 64, 2560, false, false, wSpaceSize, 'f'},
          {6144, 32, 2048, true, false, wSpaceSize, 'f'},
          {6144, 32, 2048, false, false, wSpaceSize, 'f'},
          {3072, 64, 1024, true, false, wSpaceSize, 'f'},
          {3072, 64, 1024, false, false, wSpaceSize, 'f'},
          {1760, 128, 1760, true, false, wSpaceSize, 'f'},
          {1760, 128, 1760, false, false, wSpaceSize, 'f'},
          {7680, 32, 2560, true, false, wSpaceSize, 'f'},
          {7680, 32, 2560, false, false, wSpaceSize, 'f'},
          {4096, 64, 4096, true, false, wSpaceSize, 'f'},
          {2048, 128, 2048, true, false, wSpaceSize, 'f'},
          {4096, 64, 4096, false, false, wSpaceSize, 'f'},
          {2048, 128, 2048, false, false, wSpaceSize, 'f'},
          {8448, 32, 2816, true, false, wSpaceSize, 'f'},
          {8448, 32, 2816, false, false, wSpaceSize, 'f'},
          {35, 8457, 4096, true, false, wSpaceSize, 'f'},
          {35, 8457, 2560, true, false, wSpaceSize, 'f'},
          {35, 8457, 2048, true, false, wSpaceSize, 'f'},
          {35, 8457, 1760, true, false, wSpaceSize, 'f'},
          {35, 8457, 4096, false, false, wSpaceSize, 'f'},
          {35, 8457, 2560, false, false, wSpaceSize, 'f'},
          {35, 8457, 2048, false, false, wSpaceSize, 'f'},
          {35, 8457, 1760, false, false, wSpaceSize, 'f'},
          {2560, 128, 2560, true, false, wSpaceSize, 'f'},
          {2560, 128, 2560, false, false, wSpaceSize, 'f'},
          {3072, 128, 1024, true, false, wSpaceSize, 'f'},
          {3072, 128, 1024, false, false, wSpaceSize, 'f'},
          {7680, 64, 2560, true, false, wSpaceSize, 'f'},
          {7680, 64, 2560, false, false, wSpaceSize, 'f'},
          {4096, 128, 4096, true, false, wSpaceSize, 'f'},
          {4096, 128, 4096, false, false, wSpaceSize, 'f'},
          {1024, 700, 512, true, false, wSpaceSize, 'f'},
          {1024, 700, 512, false, false, wSpaceSize, 'f'},
          {7680, 128, 2560, true, false, wSpaceSize, 'f'},
          {7680, 128, 2560, false, false, wSpaceSize, 'f'},
          {512, 24000, 1530, true, false, wSpaceSize, 'f'},
          {512, 24000, 2560, true, false, wSpaceSize, 'f'},
          {512, 24000, 2048, true, false, wSpaceSize, 'f'},
          {512, 24000, 2816, true, false, wSpaceSize, 'f'},
          {512, 24000, 1530, false, false, wSpaceSize, 'f'},
          {512, 24000, 2560, false, false, wSpaceSize, 'f'},
          {512, 24000, 2048, false, false, wSpaceSize, 'f'},
          {512, 24000, 2816, false, false, wSpaceSize, 'f'},
          {1760, 7000, 1760, true, false, wSpaceSize, 'f'},
          {1760, 7000, 1760, false, false, wSpaceSize, 'f'},
          {1760, 7133, 1760, false, true, wSpaceSize, 'f'},
          {2048, 7000, 2048, true, false, wSpaceSize, 'f'},
          {2048, 7000, 2048, false, false, wSpaceSize, 'f'},
          {2048, 7133, 2048, false, true, wSpaceSize, 'f'},
          {2560, 7000, 2560, true, false, wSpaceSize, 'f'},
          {2560, 7000, 2560, false, false, wSpaceSize, 'f'},
          {2560, 7133, 2560, false, true, wSpaceSize, 'f'},
          {3072, 7435, 1024, false, true, wSpaceSize, 'f'},
          {512, 48000, 1530, true, false, wSpaceSize, 'f'},
          {512, 48000, 2560, true, false, wSpaceSize, 'f'},
          {512, 48000, 2048, true, false, wSpaceSize, 'f'},
          {512, 48000, 2816, true, false, wSpaceSize, 'f'},
          {512, 48000, 1530, false, false, wSpaceSize, 'f'},
          {512, 48000, 2560, false, false, wSpaceSize, 'f'},
          {512, 48000, 2048, false, false, wSpaceSize, 'f'},
          {512, 48000, 2816, false, false, wSpaceSize, 'f'},
          {1024, 24000, 1530, true, false, wSpaceSize, 'f'},
          {1024, 24000, 2560, true, false, wSpaceSize, 'f'},
          {1024, 24000, 2048, true, false, wSpaceSize, 'f'},
          {1024, 24000, 2816, true, false, wSpaceSize, 'f'},
          {1024, 24000, 1530, false, false, wSpaceSize, 'f'},
          {1024, 24000, 2560, false, false, wSpaceSize, 'f'},
          {1024, 24000, 2048, false, false, wSpaceSize, 'f'},
          {1024, 24000, 2816, false, false, wSpaceSize, 'f'},
          {4096, 7000, 4096, true, false, wSpaceSize, 'f'},
          {4096, 7000, 4096, false, false, wSpaceSize, 'f'},
          {4096, 7133, 4096, false, true, wSpaceSize, 'f'},
          {7680, 5481, 2560, false, true, wSpaceSize, 'f'},
          {5124, 9124, 4096, true, false, wSpaceSize, 'f'},
          {5124, 9124, 2560, true, false, wSpaceSize, 'f'},
          {5124, 9124, 2048, true, false, wSpaceSize, 'f'},
          {5124, 9124, 1760, true, false, wSpaceSize, 'f'},
          {5124, 9124, 4096, false, false, wSpaceSize, 'f'},
          {5124, 9124, 2560, false, false, wSpaceSize, 'f'},
          {5124, 9124, 2048, false, false, wSpaceSize, 'f'},
          {5124, 9124, 1760, false, false, wSpaceSize, 'f'},
          {1024, 48000, 1530, true, false, wSpaceSize, 'f'},
          {1024, 48000, 2560, true, false, wSpaceSize, 'f'},
          {1024, 48000, 2048, true, false, wSpaceSize, 'f'},
          {1024, 48000, 2816, true, false, wSpaceSize, 'f'},
          {1024, 48000, 1530, false, false, wSpaceSize, 'f'},
          {1024, 48000, 2560, false, false, wSpaceSize, 'f'},
          {1024, 48000, 2048, false, false, wSpaceSize, 'f'},
          {1024, 48000, 2816, false, false, wSpaceSize, 'f'},
          {3072, 24000, 1024, true, false, wSpaceSize, 'f'},
          {3072, 24000, 1024, false, false, wSpaceSize, 'f'},
          {4608, 24000, 1536, true, false, wSpaceSize, 'f'},
          {4608, 24000, 1536, false, false, wSpaceSize, 'f'},
          {3072, 48000, 1024, true, false, wSpaceSize, 'f'},
          {6144, 24000, 2048, true, false, wSpaceSize, 'f'},
          {3072, 48000, 1024, false, false, wSpaceSize, 'f'},
          {6144, 24000, 2048, false, false, wSpaceSize, 'f'},
          {7680, 24000, 2560, true, false, wSpaceSize, 'f'},
          {7680, 24000, 2560, false, false, wSpaceSize, 'f'},
          {8448, 24000, 2816, true, false, wSpaceSize, 'f'},
          {8448, 24000, 2816, false, false, wSpaceSize, 'f'},
          {4608, 48000, 1536, true, false, wSpaceSize, 'f'},
          {4608, 48000, 1536, false, false, wSpaceSize, 'f'},
          {6144, 48000, 2048, true, false, wSpaceSize, 'f'},
          {6144, 48000, 2048, false, false, wSpaceSize, 'f'},
          {7680, 48000, 2560, true, false, wSpaceSize, 'f'},
          {7680, 48000, 2560, false, false, wSpaceSize, 'f'},
          {8448, 48000, 2816, true, false, wSpaceSize, 'f'},
          {8448, 48000, 2816, false, false, wSpaceSize, 'f'}};
}

std::vector<Geometry> get_squares(size_t wSpaceSize)
{

  std::vector<Geometry> geometries;
  std::vector<size_t>   dimensions;
  for (size_t k = 5; k < 14; ++k)
  {
    dimensions.push_back(std::pow(2, k));
    for (size_t off = 1; off < 5; ++off)
    {
      dimensions.push_back(std::pow(2, k) + off);
      dimensions.push_back(std::pow(2, k) - off);
    }
  }

  for (size_t k = 317; k < 7000; k += 300)
  {
    dimensions.push_back(k);
  }

  for (auto d : dimensions)
  {
    geometries.push_back({1, 0, 0, 0, d, d, d, d, d, d, wSpaceSize, 'f'});
    geometries.push_back({1, 0, 1, 0, d, d, d, d, d, d, wSpaceSize, 'f'});
    geometries.push_back({1, 1, 0, 0, d, d, d, d, d, d, wSpaceSize, 'f'});
    geometries.push_back({1, 1, 1, 0, d, d, d, d, d, d, wSpaceSize, 'f'});
  }
  return geometries;
}

// the geometries run by test_conv --all in MIOpen (25 September 2017)
const std::vector<Geometry>& get_conv_geometries()
{

  const static std::vector<Geometry> conv_geometries{
    {"tC0_tA0_tB0_colMaj1_m900_n1_k27_lda900_ldb27_ldc900_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m27_n900_k1_lda27_ldb900_ldc900_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m27_n1_k900_lda900_ldb900_ldc27_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m1024_n1_k27_lda1024_ldb27_ldc1024_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m27_n1024_k1_lda27_ldb1024_ldc1024_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m27_n1_k1024_lda1024_ldb1024_ldc27_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m256_n1_k27_lda256_ldb27_ldc256_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m27_n256_k1_lda27_ldb256_ldc256_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m27_n1_k256_lda256_ldb256_ldc27_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m784_n1_k75_lda784_ldb75_ldc784_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m75_n784_k1_lda75_ldb784_ldc784_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m75_n1_k784_lda784_ldb784_ldc75_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m900_n1_k75_lda900_ldb75_ldc900_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m75_n900_k1_lda75_ldb900_ldc900_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m75_n1_k900_lda900_ldb900_ldc75_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m225_n1_k75_lda225_ldb75_ldc225_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m75_n225_k1_lda75_ldb225_ldc225_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m75_n1_k225_lda225_ldb225_ldc75_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m1024_n1_k75_lda1024_ldb75_ldc1024_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m75_n1024_k1_lda75_ldb1024_ldc1024_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m75_n1_k1024_lda1024_ldb1024_ldc75_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m676_n1_k147_lda676_ldb147_ldc676_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m147_n676_k1_lda147_ldb676_ldc676_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m147_n1_k676_lda676_ldb676_ldc147_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m784_n1_k147_lda784_ldb147_ldc784_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m147_n784_k1_lda147_ldb784_ldc784_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m147_n1_k784_lda784_ldb784_ldc147_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m196_n1_k147_lda196_ldb147_ldc196_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m147_n196_k1_lda147_ldb196_ldc196_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m147_n1_k196_lda196_ldb196_ldc147_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m900_n1_k147_lda900_ldb147_ldc900_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m147_n900_k1_lda147_ldb900_ldc900_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m147_n1_k900_lda900_ldb900_ldc147_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m256_n1_k147_lda256_ldb147_ldc256_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m147_n256_k1_lda147_ldb256_ldc256_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m147_n1_k256_lda256_ldb256_ldc147_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m484_n1_k363_lda484_ldb363_ldc484_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m363_n484_k1_lda363_ldb484_ldc484_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m363_n1_k484_lda484_ldb484_ldc363_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m576_n1_k363_lda576_ldb363_ldc576_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m363_n576_k1_lda363_ldb576_ldc576_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m363_n1_k576_lda576_ldb576_ldc363_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m144_n1_k363_lda144_ldb363_ldc144_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m363_n144_k1_lda363_ldb144_ldc144_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m363_n1_k144_lda144_ldb144_ldc363_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m676_n1_k363_lda676_ldb363_ldc676_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m363_n676_k1_lda363_ldb676_ldc676_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m363_n1_k676_lda676_ldb676_ldc363_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m196_n1_k363_lda196_ldb363_ldc196_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m363_n196_k1_lda363_ldb196_ldc196_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m363_n1_k196_lda196_ldb196_ldc363_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m49284_n1_k27_lda49284_ldb27_ldc49284_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m27_n49284_k1_lda27_ldb49284_ldc49284_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m27_n1_k49284_lda49284_ldb49284_ldc27_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m50176_n1_k27_lda50176_ldb27_ldc50176_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m27_n50176_k1_lda27_ldb50176_ldc50176_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m27_n1_k50176_lda50176_ldb50176_ldc27_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m12544_n1_k27_lda12544_ldb27_ldc12544_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m27_n12544_k1_lda27_ldb12544_ldc12544_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m27_n1_k12544_lda12544_ldb12544_ldc27_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m48400_n1_k75_lda48400_ldb75_ldc48400_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m75_n48400_k1_lda75_ldb48400_ldc48400_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m75_n1_k48400_lda48400_ldb48400_ldc75_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m49284_n1_k75_lda49284_ldb75_ldc49284_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m75_n49284_k1_lda75_ldb49284_ldc49284_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m75_n1_k49284_lda49284_ldb49284_ldc75_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m12321_n1_k75_lda12321_ldb75_ldc12321_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m75_n12321_k1_lda75_ldb12321_ldc12321_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m75_n1_k12321_lda12321_ldb12321_ldc75_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m50176_n1_k75_lda50176_ldb75_ldc50176_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m75_n50176_k1_lda75_ldb50176_ldc50176_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m75_n1_k50176_lda50176_ldb50176_ldc75_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m47524_n1_k147_lda47524_ldb147_ldc47524_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m147_n47524_k1_lda147_ldb47524_ldc47524_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m147_n1_k47524_lda47524_ldb47524_ldc147_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m48400_n1_k147_lda48400_ldb147_ldc48400_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m147_n48400_k1_lda147_ldb48400_ldc48400_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m147_n1_k48400_lda48400_ldb48400_ldc147_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m12100_n1_k147_lda12100_ldb147_ldc12100_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m147_n12100_k1_lda147_ldb12100_ldc12100_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m147_n1_k12100_lda12100_ldb12100_ldc147_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m49284_n1_k147_lda49284_ldb147_ldc49284_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m147_n49284_k1_lda147_ldb49284_ldc49284_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m147_n1_k49284_lda49284_ldb49284_ldc147_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m12544_n1_k147_lda12544_ldb147_ldc12544_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m147_n12544_k1_lda147_ldb12544_ldc12544_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m147_n1_k12544_lda12544_ldb12544_ldc147_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m45796_n1_k363_lda45796_ldb363_ldc45796_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m363_n45796_k1_lda363_ldb45796_ldc45796_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m363_n1_k45796_lda45796_ldb45796_ldc363_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m46656_n1_k363_lda46656_ldb363_ldc46656_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m363_n46656_k1_lda363_ldb46656_ldc46656_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m363_n1_k46656_lda46656_ldb46656_ldc363_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m11664_n1_k363_lda11664_ldb363_ldc11664_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m363_n11664_k1_lda363_ldb11664_ldc11664_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m363_n1_k11664_lda11664_ldb11664_ldc363_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m47524_n1_k363_lda47524_ldb363_ldc47524_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m363_n47524_k1_lda363_ldb47524_ldc47524_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m363_n1_k47524_lda47524_ldb47524_ldc363_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m12100_n1_k363_lda12100_ldb363_ldc12100_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m363_n12100_k1_lda363_ldb12100_ldc12100_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m363_n1_k12100_lda12100_ldb12100_ldc363_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m50625_n1_k27_lda50625_ldb27_ldc50625_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m27_n50625_k1_lda27_ldb50625_ldc50625_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m27_n1_k50625_lda50625_ldb50625_ldc27_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m51529_n1_k27_lda51529_ldb27_ldc51529_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m27_n51529_k1_lda27_ldb51529_ldc51529_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m27_n1_k51529_lda51529_ldb51529_ldc27_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m12996_n1_k27_lda12996_ldb27_ldc12996_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m27_n12996_k1_lda27_ldb12996_ldc12996_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m27_n1_k12996_lda12996_ldb12996_ldc27_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m49729_n1_k75_lda49729_ldb75_ldc49729_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m75_n49729_k1_lda75_ldb49729_ldc49729_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m75_n1_k49729_lda49729_ldb49729_ldc75_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m50625_n1_k75_lda50625_ldb75_ldc50625_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m75_n50625_k1_lda75_ldb50625_ldc50625_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m75_n1_k50625_lda50625_ldb50625_ldc75_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m12769_n1_k75_lda12769_ldb75_ldc12769_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m75_n12769_k1_lda75_ldb12769_ldc12769_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m75_n1_k12769_lda12769_ldb12769_ldc75_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m51529_n1_k75_lda51529_ldb75_ldc51529_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m75_n51529_k1_lda75_ldb51529_ldc51529_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m75_n1_k51529_lda51529_ldb51529_ldc75_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m48841_n1_k147_lda48841_ldb147_ldc48841_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m147_n48841_k1_lda147_ldb48841_ldc48841_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m147_n1_k48841_lda48841_ldb48841_ldc147_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m49729_n1_k147_lda49729_ldb147_ldc49729_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m147_n49729_k1_lda147_ldb49729_ldc49729_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m147_n1_k49729_lda49729_ldb49729_ldc147_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m50625_n1_k147_lda50625_ldb147_ldc50625_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m147_n50625_k1_lda147_ldb50625_ldc50625_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m147_n1_k50625_lda50625_ldb50625_ldc147_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m12996_n1_k147_lda12996_ldb147_ldc12996_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m147_n12996_k1_lda147_ldb12996_ldc12996_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m147_n1_k12996_lda12996_ldb12996_ldc147_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m47089_n1_k363_lda47089_ldb363_ldc47089_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m363_n47089_k1_lda363_ldb47089_ldc47089_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m363_n1_k47089_lda47089_ldb47089_ldc363_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m47961_n1_k363_lda47961_ldb363_ldc47961_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m363_n47961_k1_lda363_ldb47961_ldc47961_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m363_n1_k47961_lda47961_ldb47961_ldc363_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m48841_n1_k363_lda48841_ldb363_ldc48841_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m363_n48841_k1_lda363_ldb48841_ldc48841_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m363_n1_k48841_lda48841_ldb48841_ldc363_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m12544_n1_k363_lda12544_ldb363_ldc12544_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m363_n12544_k1_lda363_ldb12544_ldc12544_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m363_n1_k12544_lda12544_ldb12544_ldc363_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m52441_n1_k27_lda52441_ldb27_ldc52441_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m27_n52441_k1_lda27_ldb52441_ldc52441_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m27_n1_k52441_lda52441_ldb52441_ldc27_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m53361_n1_k27_lda53361_ldb27_ldc53361_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m27_n53361_k1_lda27_ldb53361_ldc53361_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m27_n1_k53361_lda53361_ldb53361_ldc27_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m13456_n1_k27_lda13456_ldb27_ldc13456_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m27_n13456_k1_lda27_ldb13456_ldc13456_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m27_n1_k13456_lda13456_ldb13456_ldc27_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m52441_n1_k75_lda52441_ldb75_ldc52441_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m75_n52441_k1_lda75_ldb52441_ldc52441_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m75_n1_k52441_lda52441_ldb52441_ldc75_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m13225_n1_k75_lda13225_ldb75_ldc13225_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m75_n13225_k1_lda75_ldb13225_ldc13225_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m75_n1_k13225_lda13225_ldb13225_ldc75_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m53361_n1_k75_lda53361_ldb75_ldc53361_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m75_n53361_k1_lda75_ldb53361_ldc53361_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m75_n1_k53361_lda53361_ldb53361_ldc75_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m51529_n1_k147_lda51529_ldb147_ldc51529_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m147_n51529_k1_lda147_ldb51529_ldc51529_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m147_n1_k51529_lda51529_ldb51529_ldc147_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m52441_n1_k147_lda52441_ldb147_ldc52441_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m147_n52441_k1_lda147_ldb52441_ldc52441_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m147_n1_k52441_lda52441_ldb52441_ldc147_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m13456_n1_k147_lda13456_ldb147_ldc13456_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m147_n13456_k1_lda147_ldb13456_ldc13456_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m147_n1_k13456_lda13456_ldb13456_ldc147_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m49729_n1_k363_lda49729_ldb363_ldc49729_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m363_n49729_k1_lda363_ldb49729_ldc49729_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m363_n1_k49729_lda49729_ldb49729_ldc363_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m50625_n1_k363_lda50625_ldb363_ldc50625_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m363_n50625_k1_lda363_ldb50625_ldc50625_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m363_n1_k50625_lda50625_ldb50625_ldc363_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m12996_n1_k363_lda12996_ldb363_ldc12996_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m363_n12996_k1_lda363_ldb12996_ldc12996_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m363_n1_k12996_lda12996_ldb12996_ldc363_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m100_n1_k400_lda100_ldb400_ldc100_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m400_n100_k1_lda400_ldb100_ldc100_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m400_n1_k100_lda100_ldb100_ldc400_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m144_n1_k400_lda144_ldb400_ldc144_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m400_n144_k1_lda400_ldb144_ldc144_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m400_n1_k144_lda144_ldb144_ldc400_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m36_n1_k400_lda36_ldb400_ldc36_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m400_n36_k1_lda400_ldb36_ldc36_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m400_n1_k36_lda36_ldb36_ldc400_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m196_n1_k400_lda196_ldb400_ldc196_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m400_n196_k1_lda400_ldb196_ldc196_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m400_n1_k196_lda196_ldb196_ldc400_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m576_n1_k400_lda576_ldb400_ldc576_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m400_n576_k1_lda400_ldb576_ldc576_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m400_n1_k576_lda576_ldb576_ldc400_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m676_n1_k400_lda676_ldb400_ldc676_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m400_n676_k1_lda400_ldb676_ldc676_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m400_n1_k676_lda676_ldb676_ldc400_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m169_n1_k400_lda169_ldb400_ldc169_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m400_n169_k1_lda400_ldb169_ldc169_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m400_n1_k169_lda169_ldb169_ldc400_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m784_n1_k400_lda784_ldb400_ldc784_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m400_n784_k1_lda400_ldb784_ldc784_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m400_n1_k784_lda784_ldb784_ldc400_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m100_n1_k600_lda100_ldb600_ldc100_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m600_n100_k1_lda600_ldb100_ldc100_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m600_n1_k100_lda100_ldb100_ldc600_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m144_n1_k600_lda144_ldb600_ldc144_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m600_n144_k1_lda600_ldb144_ldc144_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m600_n1_k144_lda144_ldb144_ldc600_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m36_n1_k600_lda36_ldb600_ldc36_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m600_n36_k1_lda600_ldb36_ldc36_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m600_n1_k36_lda36_ldb36_ldc600_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m196_n1_k600_lda196_ldb600_ldc196_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m600_n196_k1_lda600_ldb196_ldc196_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m600_n1_k196_lda196_ldb196_ldc600_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m9_n1_k800_lda9_ldb800_ldc9_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m800_n9_k1_lda800_ldb9_ldc9_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m800_n1_k9_lda9_ldb9_ldc800_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m25_n1_k800_lda25_ldb800_ldc25_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m800_n25_k1_lda800_ldb25_ldc25_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m800_n1_k25_lda25_ldb25_ldc800_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m49_n1_k800_lda49_ldb800_ldc49_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m800_n49_k1_lda800_ldb49_ldc49_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m800_n1_k49_lda49_ldb49_ldc800_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m16_n1_k800_lda16_ldb800_ldc16_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m800_n16_k1_lda800_ldb16_ldc16_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m800_n1_k16_lda16_ldb16_ldc800_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m36_n1_k800_lda36_ldb800_ldc36_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m800_n36_k1_lda800_ldb36_ldc36_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m800_n1_k36_lda36_ldb36_ldc800_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m64_n1_k800_lda64_ldb800_ldc64_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m800_n64_k1_lda800_ldb64_ldc64_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m800_n1_k64_lda64_ldb64_ldc800_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m100_n1_k800_lda100_ldb800_ldc100_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m800_n100_k1_lda800_ldb100_ldc100_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m800_n1_k100_lda100_ldb100_ldc800_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m144_n1_k800_lda144_ldb800_ldc144_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m800_n144_k1_lda800_ldb144_ldc144_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m800_n1_k144_lda144_ldb144_ldc800_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m196_n1_k800_lda196_ldb800_ldc196_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m800_n196_k1_lda800_ldb196_ldc196_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m800_n1_k196_lda196_ldb196_ldc800_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m256_n1_k800_lda256_ldb800_ldc256_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m800_n256_k1_lda800_ldb256_ldc256_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m800_n1_k256_lda256_ldb256_ldc800_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m576_n1_k800_lda576_ldb800_ldc576_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m800_n576_k1_lda800_ldb576_ldc576_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m800_n1_k576_lda576_ldb576_ldc800_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m676_n1_k800_lda676_ldb800_ldc676_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m800_n676_k1_lda800_ldb676_ldc676_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m800_n1_k676_lda676_ldb676_ldc800_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m169_n1_k800_lda169_ldb800_ldc169_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m800_n169_k1_lda800_ldb169_ldc169_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m800_n1_k169_lda169_ldb169_ldc800_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m784_n1_k800_lda784_ldb800_ldc784_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m800_n784_k1_lda800_ldb784_ldc784_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m800_n1_k784_lda784_ldb784_ldc800_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m9_n1_k1200_lda9_ldb1200_ldc9_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1200_n9_k1_lda1200_ldb9_ldc9_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1200_n1_k9_lda9_ldb9_ldc1200_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m25_n1_k1200_lda25_ldb1200_ldc25_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1200_n25_k1_lda1200_ldb25_ldc25_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1200_n1_k25_lda25_ldb25_ldc1200_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m49_n1_k1200_lda49_ldb1200_ldc49_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1200_n49_k1_lda1200_ldb49_ldc49_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1200_n1_k49_lda49_ldb49_ldc1200_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m196_n1_k64_lda196_ldb64_ldc196_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m64_n196_k1_lda64_ldb196_ldc196_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m64_n1_k196_lda196_ldb196_ldc64_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m144_n1_k576_lda144_ldb576_ldc144_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m576_n144_k1_lda576_ldb144_ldc144_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m576_n1_k144_lda144_ldb144_ldc576_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m576_n196_k1_lda576_ldb196_ldc196_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m576_n1_k196_lda196_ldb196_ldc576_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m49_n1_k576_lda49_ldb576_ldc49_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m576_n49_k1_lda576_ldb49_ldc49_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m576_n1_k49_lda49_ldb49_ldc576_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m100_n1_k1600_lda100_ldb1600_ldc100_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1600_n100_k1_lda1600_ldb100_ldc100_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1600_n1_k100_lda100_ldb100_ldc1600_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m144_n1_k1600_lda144_ldb1600_ldc144_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1600_n144_k1_lda1600_ldb144_ldc144_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1600_n1_k144_lda144_ldb144_ldc1600_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m36_n1_k1600_lda36_ldb1600_ldc36_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1600_n36_k1_lda1600_ldb36_ldc36_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1600_n1_k36_lda36_ldb36_ldc1600_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m196_n1_k1600_lda196_ldb1600_ldc196_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1600_n196_k1_lda1600_ldb196_ldc196_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1600_n1_k196_lda196_ldb196_ldc1600_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m729_n1_k64_lda729_ldb64_ldc729_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m64_n729_k1_lda64_ldb729_ldc729_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m64_n1_k729_lda729_ldb729_ldc64_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m625_n1_k576_lda625_ldb576_ldc625_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m576_n625_k1_lda576_ldb625_ldc625_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m576_n1_k625_lda625_ldb625_ldc576_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m576_n729_k1_lda576_ldb729_ldc729_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m576_n1_k729_lda729_ldb729_ldc576_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m196_n1_k576_lda196_ldb576_ldc196_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m529_n1_k1600_lda529_ldb1600_ldc529_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1600_n529_k1_lda1600_ldb529_ldc529_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1600_n1_k529_lda529_ldb529_ldc1600_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m625_n1_k1600_lda625_ldb1600_ldc625_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1600_n625_k1_lda1600_ldb625_ldc625_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1600_n1_k625_lda625_ldb625_ldc1600_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m169_n1_k1600_lda169_ldb1600_ldc169_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1600_n169_k1_lda1600_ldb169_ldc169_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1600_n1_k169_lda169_ldb169_ldc1600_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m729_n1_k1600_lda729_ldb1600_ldc729_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1600_n729_k1_lda1600_ldb729_ldc729_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1600_n1_k729_lda729_ldb729_ldc1600_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m784_n1_k64_lda784_ldb64_ldc784_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m64_n784_k1_lda64_ldb784_ldc784_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m64_n1_k784_lda784_ldb784_ldc64_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m676_n1_k576_lda676_ldb576_ldc676_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m576_n676_k1_lda576_ldb676_ldc676_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m576_n1_k676_lda676_ldb676_ldc576_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m576_n784_k1_lda576_ldb784_ldc784_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m576_n1_k784_lda784_ldb784_ldc576_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m576_n1_k1600_lda576_ldb1600_ldc576_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1600_n576_k1_lda1600_ldb576_ldc576_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1600_n1_k576_lda576_ldb576_ldc1600_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m676_n1_k1600_lda676_ldb1600_ldc676_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1600_n676_k1_lda1600_ldb676_ldc676_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1600_n1_k676_lda676_ldb676_ldc1600_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m784_n1_k1600_lda784_ldb1600_ldc784_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1600_n784_k1_lda1600_ldb784_ldc784_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1600_n1_k784_lda784_ldb784_ldc1600_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m3136_n1_k64_lda3136_ldb64_ldc3136_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m64_n3136_k1_lda64_ldb3136_ldc3136_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m64_n1_k3136_lda3136_ldb3136_ldc64_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m2916_n1_k576_lda2916_ldb576_ldc2916_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m576_n2916_k1_lda576_ldb2916_ldc2916_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m576_n1_k2916_lda2916_ldb2916_ldc576_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m576_n3136_k1_lda576_ldb3136_ldc3136_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m576_n1_k3136_lda3136_ldb3136_ldc576_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m784_n1_k576_lda784_ldb576_ldc784_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m2704_n1_k1600_lda2704_ldb1600_ldc2704_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1600_n2704_k1_lda1600_ldb2704_ldc2704_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1600_n1_k2704_lda2704_ldb2704_ldc1600_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m2916_n1_k1600_lda2916_ldb1600_ldc2916_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1600_n2916_k1_lda1600_ldb2916_ldc2916_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1600_n1_k2916_lda2916_ldb2916_ldc1600_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m3136_n1_k1600_lda3136_ldb1600_ldc3136_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1600_n3136_k1_lda1600_ldb3136_ldc3136_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1600_n1_k3136_lda3136_ldb3136_ldc1600_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m12544_n1_k64_lda12544_ldb64_ldc12544_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m64_n12544_k1_lda64_ldb12544_ldc12544_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m64_n1_k12544_lda12544_ldb12544_ldc64_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m12100_n1_k576_lda12100_ldb576_ldc12100_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m576_n12100_k1_lda576_ldb12100_ldc12100_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m576_n1_k12100_lda12100_ldb12100_ldc576_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m576_n12544_k1_lda576_ldb12544_ldc12544_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m576_n1_k12544_lda12544_ldb12544_ldc576_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m3136_n1_k576_lda3136_ldb576_ldc3136_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m11664_n1_k1600_lda11664_ldb1600_ldc11664_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1600_n11664_k1_lda1600_ldb11664_ldc11664_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1600_n1_k11664_lda11664_ldb11664_ldc1600_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m12100_n1_k1600_lda12100_ldb1600_ldc12100_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1600_n12100_k1_lda1600_ldb12100_ldc12100_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1600_n1_k12100_lda12100_ldb12100_ldc1600_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m3025_n1_k1600_lda3025_ldb1600_ldc3025_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1600_n3025_k1_lda1600_ldb3025_ldc3025_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1600_n1_k3025_lda3025_ldb3025_ldc1600_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m12544_n1_k1600_lda12544_ldb1600_ldc12544_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1600_n12544_k1_lda1600_ldb12544_ldc12544_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1600_n1_k12544_lda12544_ldb12544_ldc1600_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m524288_n1_k64_lda524288_ldb64_ldc524288_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m64_n524288_k1_lda64_ldb524288_ldc524288_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m64_n1_k524288_lda524288_ldb524288_ldc64_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m131072_n1_k576_lda131072_ldb576_ldc131072_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m576_n131072_k1_lda576_ldb131072_ldc131072_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m576_n1_k131072_lda131072_ldb131072_ldc576_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m130305_n1_k1600_lda130305_ldb1600_ldc130305_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1600_n130305_k1_lda1600_ldb130305_ldc130305_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1600_n1_k130305_lda130305_ldb130305_ldc1600_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m144_n1_k864_lda144_ldb864_ldc144_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m864_n144_k1_lda864_ldb144_ldc144_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m864_n1_k144_lda144_ldb144_ldc864_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m864_n196_k1_lda864_ldb196_ldc196_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m864_n1_k196_lda196_ldb196_ldc864_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m49_n1_k864_lda49_ldb864_ldc49_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m864_n49_k1_lda864_ldb49_ldc49_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m864_n1_k49_lda49_ldb49_ldc864_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m100_n1_k2400_lda100_ldb2400_ldc100_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m2400_n100_k1_lda2400_ldb100_ldc100_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m2400_n1_k100_lda100_ldb100_ldc2400_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m144_n1_k2400_lda144_ldb2400_ldc144_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m2400_n144_k1_lda2400_ldb144_ldc144_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m2400_n1_k144_lda144_ldb144_ldc2400_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m36_n1_k2400_lda36_ldb2400_ldc36_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m2400_n36_k1_lda2400_ldb36_ldc36_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m2400_n1_k36_lda36_ldb36_ldc2400_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m196_n1_k2400_lda196_ldb2400_ldc196_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m2400_n196_k1_lda2400_ldb196_ldc196_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m2400_n1_k196_lda196_ldb196_ldc2400_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m625_n1_k864_lda625_ldb864_ldc625_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m864_n625_k1_lda864_ldb625_ldc625_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m864_n1_k625_lda625_ldb625_ldc864_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m864_n729_k1_lda864_ldb729_ldc729_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m864_n1_k729_lda729_ldb729_ldc864_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m196_n1_k864_lda196_ldb864_ldc196_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m529_n1_k2400_lda529_ldb2400_ldc529_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m2400_n529_k1_lda2400_ldb529_ldc529_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m2400_n1_k529_lda529_ldb529_ldc2400_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m625_n1_k2400_lda625_ldb2400_ldc625_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m2400_n625_k1_lda2400_ldb625_ldc625_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m2400_n1_k625_lda625_ldb625_ldc2400_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m169_n1_k2400_lda169_ldb2400_ldc169_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m2400_n169_k1_lda2400_ldb169_ldc169_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m2400_n1_k169_lda169_ldb169_ldc2400_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m729_n1_k2400_lda729_ldb2400_ldc729_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m2400_n729_k1_lda2400_ldb729_ldc729_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m2400_n1_k729_lda729_ldb729_ldc2400_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m676_n1_k864_lda676_ldb864_ldc676_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m864_n676_k1_lda864_ldb676_ldc676_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m864_n1_k676_lda676_ldb676_ldc864_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m864_n784_k1_lda864_ldb784_ldc784_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m864_n1_k784_lda784_ldb784_ldc864_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m576_n1_k2400_lda576_ldb2400_ldc576_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m2400_n576_k1_lda2400_ldb576_ldc576_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m2400_n1_k576_lda576_ldb576_ldc2400_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m676_n1_k2400_lda676_ldb2400_ldc676_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m2400_n676_k1_lda2400_ldb676_ldc676_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m2400_n1_k676_lda676_ldb676_ldc2400_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m784_n1_k2400_lda784_ldb2400_ldc784_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m2400_n784_k1_lda2400_ldb784_ldc784_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m2400_n1_k784_lda784_ldb784_ldc2400_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m144_n1_k1008_lda144_ldb1008_ldc144_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1008_n144_k1_lda1008_ldb144_ldc144_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1008_n1_k144_lda144_ldb144_ldc1008_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1008_n196_k1_lda1008_ldb196_ldc196_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1008_n1_k196_lda196_ldb196_ldc1008_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m49_n1_k1008_lda49_ldb1008_ldc49_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1008_n49_k1_lda1008_ldb49_ldc49_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1008_n1_k49_lda49_ldb49_ldc1008_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m196_n1_k128_lda196_ldb128_ldc196_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m128_n196_k1_lda128_ldb196_ldc196_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m128_n1_k196_lda196_ldb196_ldc128_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m144_n1_k1152_lda144_ldb1152_ldc144_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1152_n144_k1_lda1152_ldb144_ldc144_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1152_n1_k144_lda144_ldb144_ldc1152_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1152_n196_k1_lda1152_ldb196_ldc196_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1152_n1_k196_lda196_ldb196_ldc1152_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m49_n1_k1152_lda49_ldb1152_ldc49_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1152_n49_k1_lda1152_ldb49_ldc49_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1152_n1_k49_lda49_ldb49_ldc1152_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m784_n1_k128_lda784_ldb128_ldc784_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m128_n784_k1_lda128_ldb784_ldc784_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m128_n1_k784_lda784_ldb784_ldc128_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m676_n1_k1152_lda676_ldb1152_ldc676_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1152_n676_k1_lda1152_ldb676_ldc676_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1152_n1_k676_lda676_ldb676_ldc1152_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1152_n784_k1_lda1152_ldb784_ldc784_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1152_n1_k784_lda784_ldb784_ldc1152_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m196_n1_k1152_lda196_ldb1152_ldc196_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m3136_n1_k128_lda3136_ldb128_ldc3136_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m128_n3136_k1_lda128_ldb3136_ldc3136_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m128_n1_k3136_lda3136_ldb3136_ldc128_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m2916_n1_k1152_lda2916_ldb1152_ldc2916_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1152_n2916_k1_lda1152_ldb2916_ldc2916_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1152_n1_k2916_lda2916_ldb2916_ldc1152_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1152_n3136_k1_lda1152_ldb3136_ldc3136_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1152_n1_k3136_lda3136_ldb3136_ldc1152_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m784_n1_k1152_lda784_ldb1152_ldc784_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m144_n1_k1296_lda144_ldb1296_ldc144_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1296_n144_k1_lda1296_ldb144_ldc144_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1296_n1_k144_lda144_ldb144_ldc1296_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1296_n196_k1_lda1296_ldb196_ldc196_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1296_n1_k196_lda196_ldb196_ldc1296_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m49_n1_k1296_lda49_ldb1296_ldc49_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1296_n49_k1_lda1296_ldb49_ldc49_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1296_n1_k49_lda49_ldb49_ldc1296_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m25_n1_k1440_lda25_ldb1440_ldc25_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1440_n25_k1_lda1440_ldb25_ldc25_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1440_n1_k25_lda25_ldb25_ldc1440_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1440_n49_k1_lda1440_ldb49_ldc49_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1440_n1_k49_lda49_ldb49_ldc1440_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m16_n1_k1440_lda16_ldb1440_ldc16_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1440_n16_k1_lda1440_ldb16_ldc16_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1440_n1_k16_lda16_ldb16_ldc1440_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m144_n1_k1440_lda144_ldb1440_ldc144_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1440_n144_k1_lda1440_ldb144_ldc144_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1440_n1_k144_lda144_ldb144_ldc1440_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1440_n196_k1_lda1440_ldb196_ldc196_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1440_n1_k196_lda196_ldb196_ldc1440_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m49_n1_k1440_lda49_ldb1440_ldc49_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m49_n1_k192_lda49_ldb192_ldc49_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m192_n49_k1_lda192_ldb49_ldc49_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m192_n1_k49_lda49_ldb49_ldc192_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m25_n1_k1728_lda25_ldb1728_ldc25_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1728_n25_k1_lda1728_ldb25_ldc25_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1728_n1_k25_lda25_ldb25_ldc1728_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1728_n49_k1_lda1728_ldb49_ldc49_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1728_n1_k49_lda49_ldb49_ldc1728_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m16_n1_k1728_lda16_ldb1728_ldc16_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1728_n16_k1_lda1728_ldb16_ldc16_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1728_n1_k16_lda16_ldb16_ldc1728_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m196_n1_k192_lda196_ldb192_ldc196_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m192_n196_k1_lda192_ldb196_ldc196_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m192_n1_k196_lda196_ldb196_ldc192_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m144_n1_k1728_lda144_ldb1728_ldc144_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1728_n144_k1_lda1728_ldb144_ldc144_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1728_n1_k144_lda144_ldb144_ldc1728_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1728_n196_k1_lda1728_ldb196_ldc196_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1728_n1_k196_lda196_ldb196_ldc1728_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m49_n1_k1728_lda49_ldb1728_ldc49_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m784_n1_k192_lda784_ldb192_ldc784_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m192_n784_k1_lda192_ldb784_ldc784_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m192_n1_k784_lda784_ldb784_ldc192_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m676_n1_k1728_lda676_ldb1728_ldc676_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1728_n676_k1_lda1728_ldb676_ldc676_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1728_n1_k676_lda676_ldb676_ldc1728_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1728_n784_k1_lda1728_ldb784_ldc784_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1728_n1_k784_lda784_ldb784_ldc1728_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m196_n1_k1728_lda196_ldb1728_ldc196_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m32768_n1_k192_lda32768_ldb192_ldc32768_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m192_n32768_k1_lda192_ldb32768_ldc32768_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m192_n1_k32768_lda32768_ldb32768_ldc192_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m32004_n1_k1728_lda32004_ldb1728_ldc32004_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1728_n32004_k1_lda1728_ldb32004_ldc32004_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1728_n1_k32004_lda32004_ldb32004_ldc1728_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1728_n32768_k1_lda1728_ldb32768_ldc32768_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1728_n1_k32768_lda32768_ldb32768_ldc1728_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m8192_n1_k1728_lda8192_ldb1728_ldc8192_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1728_n8192_k1_lda1728_ldb8192_ldc8192_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1728_n1_k8192_lda8192_ldb8192_ldc1728_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m25_n1_k2016_lda25_ldb2016_ldc25_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m2016_n25_k1_lda2016_ldb25_ldc25_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m2016_n1_k25_lda25_ldb25_ldc2016_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m2016_n49_k1_lda2016_ldb49_ldc49_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m2016_n1_k49_lda49_ldb49_ldc2016_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m16_n1_k2016_lda16_ldb2016_ldc16_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m2016_n16_k1_lda2016_ldb16_ldc16_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m2016_n1_k16_lda16_ldb16_ldc2016_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m144_n1_k256_lda144_ldb256_ldc144_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m256_n144_k1_lda256_ldb144_ldc144_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m256_n1_k144_lda144_ldb144_ldc256_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m100_n1_k2304_lda100_ldb2304_ldc100_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m2304_n100_k1_lda2304_ldb100_ldc100_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m2304_n1_k100_lda100_ldb100_ldc2304_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m2304_n144_k1_lda2304_ldb144_ldc144_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m2304_n1_k144_lda144_ldb144_ldc2304_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m36_n1_k2304_lda36_ldb2304_ldc36_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m2304_n36_k1_lda2304_ldb36_ldc36_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m2304_n1_k36_lda36_ldb36_ldc2304_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m169_n1_k256_lda169_ldb256_ldc169_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m256_n169_k1_lda256_ldb169_ldc169_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m256_n1_k169_lda169_ldb169_ldc256_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m121_n1_k2304_lda121_ldb2304_ldc121_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m2304_n121_k1_lda2304_ldb121_ldc121_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m2304_n1_k121_lda121_ldb121_ldc2304_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m2304_n169_k1_lda2304_ldb169_ldc169_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m2304_n1_k169_lda169_ldb169_ldc2304_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m49_n1_k2304_lda49_ldb2304_ldc49_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m2304_n49_k1_lda2304_ldb49_ldc49_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m2304_n1_k49_lda49_ldb49_ldc2304_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m196_n1_k256_lda196_ldb256_ldc196_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m256_n196_k1_lda256_ldb196_ldc196_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m256_n1_k196_lda196_ldb196_ldc256_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m144_n1_k2304_lda144_ldb2304_ldc144_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m2304_n196_k1_lda2304_ldb196_ldc196_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m2304_n1_k196_lda196_ldb196_ldc2304_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m784_n1_k256_lda784_ldb256_ldc784_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m256_n784_k1_lda256_ldb784_ldc784_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m256_n1_k784_lda784_ldb784_ldc256_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m676_n1_k2304_lda676_ldb2304_ldc676_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m2304_n676_k1_lda2304_ldb676_ldc676_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m2304_n1_k676_lda676_ldb676_ldc2304_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m2304_n784_k1_lda2304_ldb784_ldc784_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m2304_n1_k784_lda784_ldb784_ldc2304_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m196_n1_k2304_lda196_ldb2304_ldc196_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m3136_n1_k256_lda3136_ldb256_ldc3136_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m256_n3136_k1_lda256_ldb3136_ldc3136_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m256_n1_k3136_lda3136_ldb3136_ldc256_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m2916_n1_k2304_lda2916_ldb2304_ldc2916_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m2304_n2916_k1_lda2304_ldb2916_ldc2916_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m2304_n1_k2916_lda2916_ldb2916_ldc2304_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m2304_n3136_k1_lda2304_ldb3136_ldc3136_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m2304_n1_k3136_lda3136_ldb3136_ldc2304_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m784_n1_k2304_lda784_ldb2304_ldc784_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m784_n1_k320_lda784_ldb320_ldc784_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m320_n784_k1_lda320_ldb784_ldc784_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m320_n1_k784_lda784_ldb784_ldc320_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m121_n1_k3456_lda121_ldb3456_ldc121_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m3456_n121_k1_lda3456_ldb121_ldc121_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m3456_n1_k121_lda121_ldb121_ldc3456_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m3456_n169_k1_lda3456_ldb169_ldc169_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m3456_n1_k169_lda169_ldb169_ldc3456_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m49_n1_k3456_lda49_ldb3456_ldc49_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m3456_n49_k1_lda3456_ldb49_ldc49_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m3456_n1_k49_lda49_ldb49_ldc3456_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m196_n1_k480_lda196_ldb480_ldc196_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m480_n196_k1_lda480_ldb196_ldc196_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m480_n1_k196_lda196_ldb196_ldc480_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m8192_n1_k480_lda8192_ldb480_ldc8192_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m480_n8192_k1_lda480_ldb8192_ldc8192_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m480_n1_k8192_lda8192_ldb8192_ldc480_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m32768_n1_k480_lda32768_ldb480_ldc32768_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m480_n32768_k1_lda480_ldb32768_ldc32768_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m480_n1_k32768_lda32768_ldb32768_ldc480_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m16_n1_k512_lda16_ldb512_ldc16_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m512_n16_k1_lda512_ldb16_ldc16_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m512_n1_k16_lda16_ldb16_ldc512_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m4_n1_k4608_lda4_ldb4608_ldc4_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m4608_n4_k1_lda4608_ldb4_ldc4_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m4608_n1_k4_lda4_ldb4_ldc4608_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m4608_n16_k1_lda4608_ldb16_ldc16_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m4608_n1_k16_lda16_ldb16_ldc4608_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m49_n1_k512_lda49_ldb512_ldc49_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m512_n49_k1_lda512_ldb49_ldc49_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m512_n1_k49_lda49_ldb49_ldc512_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m25_n1_k4608_lda25_ldb4608_ldc25_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m4608_n25_k1_lda4608_ldb25_ldc25_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m4608_n1_k25_lda25_ldb25_ldc4608_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m4608_n49_k1_lda4608_ldb49_ldc49_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m4608_n1_k49_lda49_ldb49_ldc4608_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m16_n1_k4608_lda16_ldb4608_ldc16_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m144_n1_k512_lda144_ldb512_ldc144_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m512_n144_k1_lda512_ldb144_ldc144_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m512_n1_k144_lda144_ldb144_ldc512_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m100_n1_k4608_lda100_ldb4608_ldc100_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m4608_n100_k1_lda4608_ldb100_ldc100_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m4608_n1_k100_lda100_ldb100_ldc4608_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m4608_n144_k1_lda4608_ldb144_ldc144_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m4608_n1_k144_lda144_ldb144_ldc4608_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m36_n1_k4608_lda36_ldb4608_ldc36_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m4608_n36_k1_lda4608_ldb36_ldc36_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m4608_n1_k36_lda36_ldb36_ldc4608_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m196_n1_k512_lda196_ldb512_ldc196_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m512_n196_k1_lda512_ldb196_ldc196_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m512_n1_k196_lda196_ldb196_ldc512_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m144_n1_k4608_lda144_ldb4608_ldc144_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m4608_n196_k1_lda4608_ldb196_ldc196_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m4608_n1_k196_lda196_ldb196_ldc4608_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m49_n1_k4608_lda49_ldb4608_ldc49_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m784_n1_k512_lda784_ldb512_ldc784_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m512_n784_k1_lda512_ldb784_ldc784_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m512_n1_k784_lda784_ldb784_ldc512_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m676_n1_k4608_lda676_ldb4608_ldc676_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m4608_n676_k1_lda4608_ldb676_ldc676_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m4608_n1_k676_lda676_ldb676_ldc4608_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m4608_n784_k1_lda4608_ldb784_ldc784_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m4608_n1_k784_lda784_ldb784_ldc4608_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m196_n1_k4608_lda196_ldb4608_ldc196_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m8192_n1_k512_lda8192_ldb512_ldc8192_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m512_n8192_k1_lda512_ldb8192_ldc8192_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m512_n1_k8192_lda8192_ldb8192_ldc512_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m7812_n1_k4608_lda7812_ldb4608_ldc7812_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m4608_n7812_k1_lda4608_ldb7812_ldc7812_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m4608_n1_k7812_lda7812_ldb7812_ldc4608_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m4608_n8192_k1_lda4608_ldb8192_ldc8192_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m4608_n1_k8192_lda8192_ldb8192_ldc4608_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m2048_n1_k4608_lda2048_ldb4608_ldc2048_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m4608_n2048_k1_lda4608_ldb2048_ldc2048_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m4608_n1_k2048_lda2048_ldb2048_ldc4608_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m16_n1_k528_lda16_ldb528_ldc16_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m528_n16_k1_lda528_ldb16_ldc16_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m528_n1_k16_lda16_ldb16_ldc528_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m196_n1_k528_lda196_ldb528_ldc196_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m528_n196_k1_lda528_ldb196_ldc196_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m528_n1_k196_lda196_ldb196_ldc528_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m8192_n1_k528_lda8192_ldb528_ldc8192_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m528_n8192_k1_lda528_ldb8192_ldc8192_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m528_n1_k8192_lda8192_ldb8192_ldc528_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m16_n1_k576_lda16_ldb576_ldc16_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m576_n16_k1_lda576_ldb16_ldc16_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m576_n1_k16_lda16_ldb16_ldc576_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m16_n1_k608_lda16_ldb608_ldc16_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m608_n16_k1_lda608_ldb16_ldc16_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m608_n1_k16_lda16_ldb16_ldc608_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m196_n1_k608_lda196_ldb608_ldc196_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m608_n196_k1_lda608_ldb196_ldc196_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m608_n1_k196_lda196_ldb196_ldc608_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m49_n1_k832_lda49_ldb832_ldc49_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m832_n49_k1_lda832_ldb49_ldc49_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m832_n1_k49_lda49_ldb49_ldc832_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m8192_n1_k832_lda8192_ldb832_ldc8192_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m832_n8192_k1_lda832_ldb8192_ldc8192_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m832_n1_k8192_lda8192_ldb8192_ldc832_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m49_n1_k1024_lda49_ldb1024_ldc49_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1024_n49_k1_lda1024_ldb49_ldc49_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1024_n1_k49_lda49_ldb49_ldc1024_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m25_n1_k9216_lda25_ldb9216_ldc25_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m9216_n25_k1_lda9216_ldb25_ldc25_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m9216_n1_k25_lda25_ldb25_ldc9216_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m9216_n49_k1_lda9216_ldb49_ldc49_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m9216_n1_k49_lda49_ldb49_ldc9216_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m16_n1_k9216_lda16_ldb9216_ldc16_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m9216_n16_k1_lda9216_ldb16_ldc16_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m9216_n1_k16_lda16_ldb16_ldc9216_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m144_n1_k1024_lda144_ldb1024_ldc144_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1024_n144_k1_lda1024_ldb144_ldc144_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1024_n1_k144_lda144_ldb144_ldc1024_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m100_n1_k9216_lda100_ldb9216_ldc100_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m9216_n100_k1_lda9216_ldb100_ldc100_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m9216_n1_k100_lda100_ldb100_ldc9216_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m9216_n144_k1_lda9216_ldb144_ldc144_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m9216_n1_k144_lda144_ldb144_ldc9216_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m36_n1_k9216_lda36_ldb9216_ldc36_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m9216_n36_k1_lda9216_ldb36_ldc36_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m9216_n1_k36_lda36_ldb36_ldc9216_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m49_n1_k1056_lda49_ldb1056_ldc49_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m1056_n49_k1_lda1056_ldb49_ldc49_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m1056_n1_k49_lda49_ldb49_ldc1056_ws0_f32"},
    {"tC0_tA0_tB0_colMaj1_m121_n1_k2048_lda121_ldb2048_ldc121_ws0_f32"},
    {"tC0_tA1_tB0_colMaj0_m2048_n121_k1_lda2048_ldb121_ldc121_ws0_f32"},
    {"tC0_tA1_tB0_colMaj1_m2048_n1_k121_lda121_ldb121_ldc2048_ws0_f32"}};

  return conv_geometries;
}
}
