# Copyright (c) 2016-2023 Martin Donath <martin.donath@squidfunk.com>

# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to
# deal in the Software without restriction, including without limitation the
# rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
# sell copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:

# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.

# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
# IN THE SOFTWARE.

from mkdocs.config.config_options import (
    Choice,
    Deprecated,
    Optional,
    ListOfItems,
    Type
)
from mkdocs.config.base import Config
from mkdocs.contrib.search import LangOption

# -----------------------------------------------------------------------------
# Options
# -----------------------------------------------------------------------------

# Options for search pipeline
pipeline = ("stemmer", "stopWordFilter", "trimmer")

# -----------------------------------------------------------------------------
# Classes
# -----------------------------------------------------------------------------

# Search plugin configuration
class SearchConfig(Config):
    lang = Optional(LangOption())
    separator = Optional(Type(str))
    pipeline = ListOfItems(Choice(pipeline), default = [])

    # Settings for text segmentation (Chinese)
    jieba_dict = Optional(Type(str))
    jieba_dict_user = Optional(Type(str))

    # Unsupported settings, originally implemented in MkDocs
    indexing = Deprecated(message = "Unsupported option")
    prebuild_index = Deprecated(message = "Unsupported option")
    min_search_length = Deprecated(message = "Unsupported option")
