/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.ShortBuffer;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.libjpegturbo.turbojpeg.TJ;
import org.libjpegturbo.turbojpeg.TJCompressor;
import org.libjpegturbo.turbojpeg.TJCustomFilter;
import org.libjpegturbo.turbojpeg.TJDecompressor;
import org.libjpegturbo.turbojpeg.TJException;
import org.libjpegturbo.turbojpeg.TJScalingFactor;
import org.libjpegturbo.turbojpeg.TJTransform;
import org.libjpegturbo.turbojpeg.TJTransformer;

class TJExample
implements TJCustomFilter {
    static final String CLASS_NAME = new TJExample().getClass().getName();
    static final int DEFAULT_SUBSAMP = 0;
    static final int DEFAULT_QUALITY = 95;
    static final String[] SUBSAMP_NAME = new String[]{"4:4:4", "4:2:2", "4:2:0", "Grayscale", "4:4:0", "4:1:1", "4:4:1"};
    static final String[] COLORSPACE_NAME = new String[]{"RGB", "YCbCr", "GRAY", "CMYK", "YCCK"};
    static final TJScalingFactor[] SCALING_FACTORS = TJ.getScalingFactors();

    TJExample() {
    }

    @Override
    public void customFilter(ShortBuffer shortBuffer, Rectangle rectangle, Rectangle rectangle2, int n, int n2, TJTransform tJTransform) throws TJException {
        for (int i = 0; i < rectangle.width * rectangle.height; ++i) {
            shortBuffer.put(i, -shortBuffer.get(i));
        }
    }

    static void usage() throws Exception {
        System.out.println("\nUSAGE: java [Java options] " + CLASS_NAME + " <Input image> <Output image> [options]\n");
        System.out.println("Input and output images can be in any image format that the Java Image I/O");
        System.out.println("extensions understand.  If either filename ends in a .jpg extension, then");
        System.out.println("the TurboJPEG API will be used to compress or decompress the image.\n");
        System.out.println("Compression Options (used if the output image is a JPEG image)");
        System.out.println("--------------------------------------------------------------\n");
        System.out.println("-subsamp <444|422|420|gray> = Apply this level of chrominance subsampling when");
        System.out.println("     compressing the output image.  The default is to use the same level of");
        System.out.println("     subsampling as in the input image, if the input image is also a JPEG");
        System.out.println("     image, or to use grayscale if the input image is a grayscale non-JPEG");
        System.out.println("     image, or to use " + SUBSAMP_NAME[0] + " subsampling otherwise.\n");
        System.out.println("-q <1-100> = Compress the output image with this JPEG quality level");
        System.out.println("     (default = 95).\n");
        System.out.println("Decompression Options (used if the input image is a JPEG image)");
        System.out.println("---------------------------------------------------------------\n");
        System.out.println("-scale M/N = Scale the input image by a factor of M/N when decompressing it.");
        System.out.print("(M/N = ");
        for (int i = 0; i < SCALING_FACTORS.length; ++i) {
            System.out.print(SCALING_FACTORS[i].getNum() + "/" + SCALING_FACTORS[i].getDenom());
            if (SCALING_FACTORS.length == 2 && i != SCALING_FACTORS.length - 1) {
                System.out.print(" or ");
                continue;
            }
            if (SCALING_FACTORS.length <= 2) continue;
            if (i != SCALING_FACTORS.length - 1) {
                System.out.print(", ");
            }
            if (i != SCALING_FACTORS.length - 2) continue;
            System.out.print("or ");
        }
        System.out.println(")\n");
        System.out.println("-hflip, -vflip, -transpose, -transverse, -rot90, -rot180, -rot270 =");
        System.out.println("     Perform one of these lossless transform operations on the input image");
        System.out.println("     prior to decompressing it (these options are mutually exclusive.)\n");
        System.out.println("-grayscale = Perform lossless grayscale conversion on the input image prior");
        System.out.println("     to decompressing it (can be combined with the other transform operations");
        System.out.println("     above.)\n");
        System.out.println("-crop WxH+X+Y = Perform lossless cropping on the input image prior to");
        System.out.println("     decompressing it.  X and Y specify the upper left corner of the cropping");
        System.out.println("     region, and W and H specify the width and height of the cropping region.");
        System.out.println("     X and Y must be evenly divible by the iMCU size (8x8 if the input image");
        System.out.println("     was compressed using no subsampling or grayscale, 16x8 if it was");
        System.out.println("     compressed using 4:2:2 subsampling, or 16x16 if it was compressed using");
        System.out.println("     4:2:0 subsampling.)\n");
        System.out.println("General Options");
        System.out.println("---------------\n");
        System.out.println("-display = Display output image (Output filename need not be specified in this");
        System.out.println("     case.)\n");
        System.out.println("-fastupsample = Use the fastest chrominance upsampling algorithm available\n");
        System.out.println("-fastdct = Use the fastest DCT/IDCT algorithm available\n");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        try {
            int n;
            int n2;
            Object object;
            Object object2;
            TJScalingFactor tJScalingFactor = TJ.UNSCALED;
            int n3 = -1;
            int n4 = -1;
            TJTransform tJTransform = new TJTransform();
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            String string = "jpg";
            String string2 = "jpg";
            BufferedImage bufferedImage = null;
            byte[] byArray = null;
            if (stringArray.length < 2) {
                TJExample.usage();
            }
            if (stringArray[1].substring(0, 2).equalsIgnoreCase("-d")) {
                bl = true;
            }
            for (int i = 2; i < stringArray.length; ++i) {
                if (stringArray[i].length() < 2) continue;
                if (stringArray[i].length() > 2 && stringArray[i].substring(0, 3).equalsIgnoreCase("-sc") && i < stringArray.length - 1) {
                    String[] stringArray2;
                    boolean bl4 = false;
                    if ((stringArray2 = stringArray[++i].split("/")).length == 2) {
                        object2 = new TJScalingFactor(Integer.parseInt(stringArray2[0]), Integer.parseInt(stringArray2[1]));
                        for (int j = 0; j < SCALING_FACTORS.length; ++j) {
                            if (!((TJScalingFactor)object2).equals(SCALING_FACTORS[j])) continue;
                            tJScalingFactor = SCALING_FACTORS[j];
                            bl4 = true;
                            break;
                        }
                    }
                    if (bl4) continue;
                    TJExample.usage();
                    continue;
                }
                if (stringArray[i].length() > 2 && stringArray[i].substring(0, 3).equalsIgnoreCase("-su") && i < stringArray.length - 1) {
                    if (stringArray[++i].substring(0, 1).equalsIgnoreCase("g")) {
                        n3 = 3;
                        continue;
                    }
                    if (stringArray[i].equals("444")) {
                        n3 = 0;
                        continue;
                    }
                    if (stringArray[i].equals("422")) {
                        n3 = 1;
                        continue;
                    }
                    if (stringArray[i].equals("420")) {
                        n3 = 2;
                        continue;
                    }
                    TJExample.usage();
                    continue;
                }
                if (stringArray[i].substring(0, 2).equalsIgnoreCase("-q") && i < stringArray.length - 1) {
                    if ((n4 = Integer.parseInt(stringArray[++i])) >= 1 && n4 <= 100) continue;
                    TJExample.usage();
                    continue;
                }
                if (stringArray[i].substring(0, 2).equalsIgnoreCase("-g")) {
                    tJTransform.options |= 8;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-hflip")) {
                    tJTransform.op = 1;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-vflip")) {
                    tJTransform.op = 2;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-transpose")) {
                    tJTransform.op = 3;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-transverse")) {
                    tJTransform.op = 4;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-rot90")) {
                    tJTransform.op = 5;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-rot180")) {
                    tJTransform.op = 6;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-rot270")) {
                    tJTransform.op = 7;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-custom")) {
                    tJTransform.cf = new TJExample();
                    continue;
                }
                if (stringArray[i].length() > 2 && stringArray[i].substring(0, 2).equalsIgnoreCase("-c") && i < stringArray.length - 1) {
                    String[] stringArray3;
                    if ((stringArray3 = stringArray[++i].split("[x\\+]")).length != 4) {
                        TJExample.usage();
                    }
                    tJTransform.width = Integer.parseInt(stringArray3[0]);
                    tJTransform.height = Integer.parseInt(stringArray3[1]);
                    tJTransform.x = Integer.parseInt(stringArray3[2]);
                    tJTransform.y = Integer.parseInt(stringArray3[3]);
                    if (tJTransform.x < 0 || tJTransform.y < 0 || tJTransform.width < 1 || tJTransform.height < 1) {
                        TJExample.usage();
                    }
                    tJTransform.options |= 4;
                    continue;
                }
                if (stringArray[i].substring(0, 2).equalsIgnoreCase("-d")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-fastupsample")) {
                    System.out.println("Using fast upsampling code");
                    bl2 = true;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-fastdct")) {
                    System.out.println("Using fastest DCT/IDCT algorithm");
                    bl3 = true;
                    continue;
                }
                TJExample.usage();
            }
            String[] stringArray4 = stringArray[0].split("\\.");
            if (stringArray4.length > 1) {
                string = stringArray4[stringArray4.length - 1];
            }
            if (bl) {
                string2 = "bmp";
            } else {
                String[] stringArray5 = stringArray[1].split("\\.");
                if (stringArray5.length > 1) {
                    string2 = stringArray5[stringArray5.length - 1];
                }
            }
            if (string.equalsIgnoreCase("jpg")) {
                TJDecompressor tJDecompressor;
                Object object3;
                boolean bl5 = tJTransform.op != 0 || tJTransform.options != 0 || tJTransform.cf != null;
                object2 = new File(stringArray[0]);
                FileInputStream fileInputStream = new FileInputStream((File)object2);
                int n5 = fileInputStream.available();
                if (n5 < 1) {
                    System.out.println("Input file contains no data");
                    System.exit(1);
                }
                object = new byte[n5];
                fileInputStream.read((byte[])object);
                fileInputStream.close();
                if (bl5) {
                    TJTransformer tJTransformer = new TJTransformer((byte[])object);
                    TJTransform[] tJTransformArray = new TJTransform[]{tJTransform};
                    tJTransformArray[0].options |= 2;
                    object3 = tJTransformer.transform(tJTransformArray);
                    tJDecompressor = object3[0];
                    tJTransformer.close();
                } else {
                    tJDecompressor = new TJDecompressor((byte[])object);
                }
                tJDecompressor.set(9, bl2 ? 1 : 0);
                tJDecompressor.set(10, bl3 ? 1 : 0);
                n2 = tJDecompressor.getWidth();
                n = tJDecompressor.getHeight();
                int n6 = tJDecompressor.get(4);
                int n7 = tJDecompressor.get(8);
                if (tJDecompressor.get(15) == 1) {
                    tJScalingFactor = TJ.UNSCALED;
                }
                System.out.println((bl5 ? "Transformed" : "Input") + " Image (jpg):  " + n2 + " x " + n + " pixels, " + SUBSAMP_NAME[n6] + " subsampling, " + COLORSPACE_NAME[n7]);
                if (string2.equalsIgnoreCase("jpg") && bl5 && tJScalingFactor.isOne() && n3 < 0 && n4 < 0) {
                    object3 = new File(stringArray[1]);
                    FileOutputStream fileOutputStream = new FileOutputStream((File)object3);
                    fileOutputStream.write(tJDecompressor.getJPEGBuf(), 0, tJDecompressor.getJPEGSize());
                    fileOutputStream.close();
                    System.exit(0);
                }
                tJDecompressor.setScalingFactor(tJScalingFactor);
                n2 = tJScalingFactor.getScaled(n2);
                n = tJScalingFactor.getScaled(n);
                if (n3 < 0) {
                    n3 = n6;
                }
                if (!string2.equalsIgnoreCase("jpg")) {
                    bufferedImage = tJDecompressor.decompress8(1);
                } else {
                    byArray = tJDecompressor.decompress8(0, 3);
                }
                tJDecompressor.close();
            } else {
                bufferedImage = ImageIO.read(new File(stringArray[0]));
                if (bufferedImage == null) {
                    throw new Exception("Input image type not supported.");
                }
                n2 = bufferedImage.getWidth();
                n = bufferedImage.getHeight();
                if (n3 < 0) {
                    n3 = bufferedImage.getType() == 10 ? 3 : 0;
                }
                System.out.println("Input Image:  " + n2 + " x " + n + " pixels");
            }
            System.gc();
            if (!bl) {
                System.out.print("Output Image (" + string2 + "):  " + n2 + " x " + n + " pixels");
            }
            if (bl) {
                ImageIcon imageIcon = new ImageIcon(bufferedImage);
                object2 = new JLabel(imageIcon, 0);
                JOptionPane.showMessageDialog(null, object2, "Output Image", -1);
            } else if (string2.equalsIgnoreCase("jpg")) {
                if (n4 < 0) {
                    n4 = 95;
                }
                System.out.println(", " + SUBSAMP_NAME[n3] + " subsampling, quality = " + n4);
                TJCompressor tJCompressor = new TJCompressor();
                tJCompressor.set(4, n3);
                tJCompressor.set(3, n4);
                tJCompressor.set(10, bl3 ? 1 : 0);
                if (bufferedImage != null) {
                    tJCompressor.setSourceImage(bufferedImage, 0, 0, 0, 0);
                } else {
                    tJCompressor.setSourceImage(byArray, 0, 0, n2, 0, n, 3);
                }
                object2 = tJCompressor.compress();
                int n8 = tJCompressor.getCompressedSize();
                tJCompressor.close();
                File file = new File(stringArray[1]);
                object = new FileOutputStream(file);
                ((FileOutputStream)object).write((byte[])object2, 0, n8);
                ((FileOutputStream)object).close();
            } else {
                System.out.print("\n");
                File file = new File(stringArray[1]);
                ImageIO.write((RenderedImage)bufferedImage, string2, file);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
    }
}

