#!/usr/bin/env bash

BASEDIR=$(dirname ${BASH_SOURCE[0]})
command -v realpath &> /dev/null && BASEDIR=$(realpath ${BASEDIR}/../..) || BASEDIR=$(cd ${BASEDIR}/../.. && pwd)

if [ ! -d "${BASEDIR}" ]; then
    echo "${BASEDIR} does not exist"
    return 1
fi

rocprofiler_register_ROOT=${BASEDIR}
PATH=${BASEDIR}/bin:${PATH}
LD_LIBRARY_PATH=${BASEDIR}/lib:${LD_LIBRARY_PATH}
PYTHONPATH=${BASEDIR}/:${PYTHONPATH}
CMAKE_PREFIX_PATH=${BASEDIR}:${CMAKE_PREFIX_PATH}
rocprofiler_register_DIR=${BASEDIR}/share/cmake/rocprofiler_register

export rocprofiler_register_ROOT
export PATH
export LD_LIBRARY_PATH
export PYTHONPATH
export CMAKE_PREFIX_PATH
export rocprofiler_register_DIR
