/*
 * Decompiled with CFR 0.152.
 */
package org.prismlauncher.launcher.impl.legacy;

import java.io.File;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import org.prismlauncher.launcher.impl.AbstractLauncher;
import org.prismlauncher.launcher.impl.legacy.LegacyFrame;
import org.prismlauncher.utils.Parameters;
import org.prismlauncher.utils.ReflectionUtils;
import org.prismlauncher.utils.logging.Log;

public final class LegacyLauncher
extends AbstractLauncher {
    private final String user;
    private final String session;
    private final String title;
    private final String appletClass;
    private final boolean useApplet;
    private final String gameDir;

    public LegacyLauncher(Parameters parameters) {
        super(parameters);
        this.user = parameters.getString("userName");
        this.session = parameters.getString("sessionId");
        this.title = parameters.getString("windowTitle", "Minecraft");
        this.appletClass = parameters.getString("appletClass", "net.minecraft.client.MinecraftApplet");
        List<String> list = parameters.getList("traits", Collections.emptyList());
        this.useApplet = !list.contains("noapplet");
        this.gameDir = System.getProperty("user.dir");
    }

    @Override
    public void launch() throws Throwable {
        Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(this.mainClassName);
        Field field = ReflectionUtils.findMinecraftGameDirField(clazz);
        if (field == null) {
            Log.warning("Could not find Minecraft folder field");
        } else {
            field.setAccessible(true);
            field.set(null, new File(this.gameDir));
        }
        if (this.useApplet) {
            System.setProperty("minecraft.applet.TargetDirectory", this.gameDir);
            try {
                LegacyFrame legacyFrame = new LegacyFrame(this.title, ReflectionUtils.createAppletClass(this.appletClass));
                legacyFrame.start(this.user, this.session, this.width, this.height, this.maximize, this.serverAddress, this.serverPort, this.gameArgs.contains("--demo"));
                return;
            }
            catch (Throwable throwable) {
                Log.error("Running applet wrapper failed with exception; falling back to main class", throwable);
            }
        }
        MethodHandle methodHandle = ReflectionUtils.findMainMethod(clazz);
        methodHandle.invokeExact(this.gameArgs.toArray(new String[0]));
    }
}

