/*
 * Decompiled with CFR 0.152.
 */
package org.prismlauncher.launcher.impl.legacy;

import java.applet.Applet;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import net.minecraft.Launcher;
import org.prismlauncher.utils.logging.Log;

public final class LegacyFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private final Launcher launcher;

    public LegacyFrame(String string, Applet applet) {
        super(string);
        this.launcher = new Launcher(applet);
        applet.setStub(this.launcher);
        try {
            this.setIconImage(ImageIO.read(new File("icon.png")));
        }
        catch (IOException iOException) {
            Log.error("Failed to read window icon", iOException);
        }
        this.addWindowListener(new ForceExitHandler());
    }

    public void start(String string, String string2, int n, int n2, boolean bl, String string3, String string4, boolean bl2) {
        Path path = Paths.get("..", new String[0]);
        Path path2 = path.resolve("mpticket");
        Path path3 = path.resolve("mpticket.corrupt");
        if (Files.exists(path2, new LinkOption[0])) {
            try {
                List<String> list = Files.readAllLines(path2, StandardCharsets.UTF_8);
                if (list.size() < 3) {
                    Files.move(path2, path3, StandardCopyOption.REPLACE_EXISTING);
                    Log.warning("mpticket file is corrupted");
                } else {
                    this.launcher.setParameter("server", list.get(0));
                    this.launcher.setParameter("port", list.get(1));
                    this.launcher.setParameter("mppass", list.get(2));
                }
            }
            catch (IOException iOException) {
                Log.error("Failed to read mpticket file", iOException);
            }
        }
        if (string3 != null) {
            this.launcher.setParameter("server", string3);
            this.launcher.setParameter("port", string4);
        }
        this.launcher.setParameter("username", string);
        this.launcher.setParameter("sessionid", string2);
        this.launcher.setParameter("stand-alone", true);
        this.launcher.setParameter("haspaid", true);
        this.launcher.setParameter("demo", bl2);
        this.launcher.setParameter("fullscreen", false);
        this.add(this.launcher);
        this.launcher.setPreferredSize(new Dimension(n, n2));
        this.pack();
        this.setLocationRelativeTo(null);
        this.setResizable(true);
        if (bl) {
            this.setExtendedState(6);
        }
        this.validate();
        this.launcher.init();
        this.launcher.start();
        this.setVisible(true);
    }

    private final class ForceExitHandler
    extends WindowAdapter {
        private ForceExitHandler() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException interruptedException) {
                        Log.error("Thread interrupted", interruptedException);
                    }
                    Log.warning("Forcing exit");
                    System.exit(0);
                }
            }).start();
            if (LegacyFrame.this.launcher != null) {
                LegacyFrame.this.launcher.stop();
                LegacyFrame.this.launcher.destroy();
            }
            System.exit(0);
        }
    }
}

