/*
 * Decompiled with CFR 0.152.
 */
package org.prismlauncher.utils;

import java.applet.Applet;
import java.io.File;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.prismlauncher.utils.logging.Log;

public final class ReflectionUtils {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final ClassLoader LOADER = ClassLoader.getSystemClassLoader();

    public static Applet createAppletClass(String string) throws Throwable {
        Class<?> clazz = LOADER.loadClass(string);
        MethodHandle methodHandle = LOOKUP.findConstructor(clazz, MethodType.methodType(Void.TYPE));
        return methodHandle.invoke();
    }

    public static Field findMinecraftGameDirField(Class<?> clazz) {
        Log.debug("Resolving minecraft game directory field");
        for (Field field : clazz.getDeclaredFields()) {
            if (field.getType() != File.class) continue;
            int n = field.getModifiers();
            if (!Modifier.isStatic(n)) {
                Log.debug("Rejecting field " + field.getName() + " because it is not static");
                continue;
            }
            if (!Modifier.isPrivate(n)) {
                Log.debug("Rejecting field " + field.getName() + " because it is not private");
                continue;
            }
            if (Modifier.isFinal(n)) {
                Log.debug("Rejecting field " + field.getName() + " because it is final");
                continue;
            }
            Log.debug("Identified field " + field.getName() + " to match conditions for game directory field");
            return field;
        }
        return null;
    }

    public static MethodHandle findMainMethod(Class<?> clazz) throws NoSuchMethodException, IllegalAccessException {
        return LOOKUP.findStatic(clazz, "main", MethodType.methodType(Void.TYPE, String[].class));
    }

    public static MethodHandle findMainMethod(String string) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException {
        return ReflectionUtils.findMainMethod(LOADER.loadClass(string));
    }
}

