/*
 * Decompiled with CFR 0.152.
 */
package org.prismlauncher;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.prismlauncher.exception.ParseException;
import org.prismlauncher.launcher.impl.StandardLauncher;
import org.prismlauncher.legacy.LegacyProxy;
import org.prismlauncher.utils.Parameters;
import org.prismlauncher.utils.logging.Log;

public final class EntryPoint {
    public static void main(String[] stringArray) {
        ExitCode exitCode = EntryPoint.listen();
        if (exitCode != ExitCode.NORMAL) {
            Log.fatal("Exiting with " + (Object)((Object)exitCode));
            System.exit(exitCode.numeric);
        }
    }

    private static ExitCode listen() {
        Object object;
        Object object2;
        Parameters parameters = new Parameters();
        PreLaunchAction preLaunchAction = PreLaunchAction.PROCEED;
        try {
            object2 = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
            try {
                while (preLaunchAction == PreLaunchAction.PROCEED) {
                    object = ((BufferedReader)object2).readLine();
                    if (object != null) {
                        preLaunchAction = EntryPoint.parseLine((String)object, parameters);
                        continue;
                    }
                    preLaunchAction = PreLaunchAction.ABORT;
                }
            }
            finally {
                ((BufferedReader)object2).close();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.fatal("Aborting due to wrong argument", illegalArgumentException);
            return ExitCode.ILLEGAL_ARGUMENT;
        }
        catch (Throwable throwable) {
            Log.fatal("Aborting due to exception", throwable);
            return ExitCode.ABORT;
        }
        if (preLaunchAction == PreLaunchAction.ABORT) {
            Log.fatal("Launch aborted by the launcher");
            return ExitCode.ABORT;
        }
        EntryPoint.setProperties(parameters);
        object2 = parameters.getString("launcher");
        try {
            LegacyProxy.applyOnlineFixes(parameters);
            switch (object2) {
                case "standard": {
                    object = new StandardLauncher(parameters);
                    break;
                }
                case "legacy": {
                    object = LegacyProxy.createLauncher(parameters);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid launcher type: " + (String)object2);
                }
            }
            object.launch();
            return ExitCode.NORMAL;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.fatal("Illegal argument", illegalArgumentException);
            return ExitCode.ILLEGAL_ARGUMENT;
        }
        catch (Throwable throwable) {
            Log.fatal("Exception caught from launcher", throwable);
            return ExitCode.ERROR;
        }
    }

    private static void setProperties(Parameters parameters) {
        String string = parameters.getString("launcherBrand", null);
        String string2 = parameters.getString("launcherVersion", null);
        String string3 = parameters.getString("instanceName", null);
        String string4 = parameters.getString("instanceIconKey", null);
        String string5 = parameters.getString("instanceIconPath", null);
        String string6 = parameters.getString("windowTitle", null);
        String string7 = parameters.getString("windowParams", null);
        if (string != null) {
            System.setProperty("minecraft.launcher.brand", string);
        }
        if (string2 != null) {
            System.setProperty("minecraft.launcher.version", string2);
        }
        if (string3 != null) {
            System.setProperty("org.prismlauncher.instance.name", string3);
        }
        if (string4 != null) {
            System.setProperty("org.prismlauncher.instance.icon.id", string4);
        }
        if (string5 != null) {
            System.setProperty("org.prismlauncher.instance.icon.path", string5);
        }
        if (string6 != null) {
            System.setProperty("org.prismlauncher.window.title", string6);
        }
        if (string7 != null) {
            System.setProperty("org.prismlauncher.window.dimensions", string7);
        }
        if (string3 != null) {
            System.setProperty("multimc.instance.title", string3);
        }
        if (string4 != null) {
            System.setProperty("multimc.instance.icon", string4);
        }
    }

    private static PreLaunchAction parseLine(String string, Parameters parameters) throws ParseException {
        switch (string) {
            case "": {
                break;
            }
            case "launch": {
                return PreLaunchAction.LAUNCH;
            }
            case "abort": {
                return PreLaunchAction.ABORT;
            }
            default: {
                String[] stringArray = string.split(" ", 2);
                if (stringArray.length != 2) {
                    throw new ParseException(string, "[key] [value]");
                }
                parameters.add(stringArray[0], stringArray[1]);
            }
        }
        return PreLaunchAction.PROCEED;
    }

    private static enum ExitCode {
        NORMAL(0),
        ABORT(1),
        ERROR(2),
        ILLEGAL_ARGUMENT(65);

        private final int numeric;

        private ExitCode(int n2) {
            this.numeric = n2;
        }
    }

    private static enum PreLaunchAction {
        PROCEED,
        LAUNCH,
        ABORT;

    }
}

