/*
 * Decompiled with CFR 0.152.
 */
package proguard.io.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import proguard.io.ClassPath;
import proguard.io.ClassPathEntry;
import proguard.util.FileNameParser;
import proguard.util.ListParser;
import proguard.util.StringMatcher;

public final class ClassPathUtil {
    private ClassPathUtil() {
    }

    public static boolean hasAabInput(ClassPath classPath) {
        return classPath != null && classPath.getClassPathEntries().stream().filter(entry -> !entry.isOutput()).anyMatch(ClassPathEntry::isAab);
    }

    public static boolean isAndroid(ClassPath classPath) {
        return classPath != null && classPath.getClassPathEntries().stream().anyMatch(entry -> entry.isDex() || entry.isApk() || entry.isAab() || entry.isAar());
    }

    public static boolean isDalvik(ClassPath classPath) {
        return classPath != null && classPath.getClassPathEntries().stream().anyMatch(entry -> entry.isDex() || entry.isApk());
    }

    public static StringMatcher determineCompressionMethod(ClassPath classPath) {
        ArrayList<String> dontCompress = new ArrayList<String>();
        for (int index = 0; index < classPath.size(); ++index) {
            ClassPathEntry entry = classPath.get(index);
            if (entry.isOutput()) continue;
            dontCompress.addAll(ClassPathUtil.determineCompressionMethod(entry));
        }
        return dontCompress.isEmpty() ? null : new ListParser(new FileNameParser()).parse(dontCompress);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String> determineCompressionMethod(ClassPathEntry entry) {
        File file = entry.getFile();
        if (file == null) return new ArrayList<String>();
        if (file.isDirectory()) {
            return new ArrayList<String>();
        }
        String regexDexClasses = "classes*.dex";
        try (ZipFile zip2 = new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zip2.entries();
            TreeSet<String> storedEntries = new TreeSet<String>();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                if (zipEntry.getMethod() == 8) continue;
                String name = zipEntry.getName();
                if (name.matches("classes\\d*.dex")) {
                    storedEntries.add(regexDexClasses);
                    continue;
                }
                storedEntries.add(name);
            }
            ArrayList<String> arrayList = new ArrayList<String>(storedEntries);
            return arrayList;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not determine compression method for " + entry.getName(), e);
        }
    }
}

