/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;

public class ConstantProcessingFlagFilter
implements ConstantVisitor {
    private final int requiredSetProcessingFlags;
    private final int requiredUnsetProcessingFlags;
    private final ConstantVisitor constantVisitor;

    public ConstantProcessingFlagFilter(int requiredSetProcessingFlags, int requiredUnsetProcessingFlags, ConstantVisitor constantVisitor) {
        this.requiredSetProcessingFlags = requiredSetProcessingFlags;
        this.requiredUnsetProcessingFlags = requiredUnsetProcessingFlags;
        this.constantVisitor = constantVisitor;
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
        if (this.accepted(constant.getProcessingFlags())) {
            constant.accept(clazz, this.constantVisitor);
        }
    }

    private boolean accepted(int processingFlags) {
        return (this.requiredSetProcessingFlags & ~processingFlags) == 0 && (this.requiredUnsetProcessingFlags & processingFlags) == 0;
    }
}

