/*
 * Decompiled with CFR 0.152.
 */
package proguard.fixer.kotlin;

import proguard.classfile.Clazz;
import proguard.classfile.kotlin.KotlinClassKindMetadata;
import proguard.classfile.kotlin.KotlinConstructorMetadata;
import proguard.classfile.kotlin.KotlinDeclarationContainerMetadata;
import proguard.classfile.kotlin.KotlinFileFacadeKindMetadata;
import proguard.classfile.kotlin.KotlinFunctionMetadata;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.KotlinMultiFileFacadeKindMetadata;
import proguard.classfile.kotlin.KotlinMultiFilePartKindMetadata;
import proguard.classfile.kotlin.KotlinPropertyMetadata;
import proguard.classfile.kotlin.KotlinSyntheticClassKindMetadata;
import proguard.classfile.kotlin.KotlinTypeAliasMetadata;
import proguard.classfile.kotlin.KotlinTypeMetadata;
import proguard.classfile.kotlin.KotlinTypeParameterMetadata;
import proguard.classfile.kotlin.KotlinValueParameterMetadata;
import proguard.classfile.kotlin.KotlinVersionRequirementMetadata;
import proguard.classfile.kotlin.visitor.KotlinConstructorVisitor;
import proguard.classfile.kotlin.visitor.KotlinFunctionVisitor;
import proguard.classfile.kotlin.visitor.KotlinMetadataVisitor;
import proguard.classfile.kotlin.visitor.KotlinPropertyVisitor;
import proguard.classfile.kotlin.visitor.KotlinTypeAliasVisitor;
import proguard.classfile.kotlin.visitor.KotlinTypeParameterVisitor;
import proguard.classfile.kotlin.visitor.KotlinTypeVisitor;
import proguard.classfile.kotlin.visitor.KotlinValueParameterVisitor;
import proguard.classfile.kotlin.visitor.KotlinVersionRequirementVisitor;
import proguard.fixer.kotlin.KotlinAnnotationCounter;

public class KotlinAnnotationFlagFixer
implements KotlinMetadataVisitor,
KotlinPropertyVisitor,
KotlinFunctionVisitor,
KotlinTypeAliasVisitor,
KotlinTypeVisitor,
KotlinConstructorVisitor,
KotlinTypeParameterVisitor,
KotlinValueParameterVisitor,
KotlinVersionRequirementVisitor {
    private final KotlinAnnotationCounter annotationCounter = new KotlinAnnotationCounter();

    @Override
    public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
    }

    @Override
    public void visitKotlinDeclarationContainerMetadata(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata) {
        kotlinDeclarationContainerMetadata.propertiesAccept(clazz, this);
        kotlinDeclarationContainerMetadata.functionsAccept(clazz, this);
        kotlinDeclarationContainerMetadata.typeAliasesAccept(clazz, this);
        kotlinDeclarationContainerMetadata.delegatedPropertiesAccept(clazz, this);
    }

    @Override
    public void visitKotlinClassMetadata(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata) {
        this.visitKotlinDeclarationContainerMetadata(clazz, kotlinClassKindMetadata);
        kotlinClassKindMetadata.contextReceiverTypesAccept(clazz, this);
        kotlinClassKindMetadata.superTypesAccept(clazz, this);
        kotlinClassKindMetadata.typeParametersAccept(clazz, this);
        kotlinClassKindMetadata.versionRequirementAccept(clazz, this);
        kotlinClassKindMetadata.constructorsAccept(clazz, this);
        kotlinClassKindMetadata.inlineClassUnderlyingPropertyTypeAccept(clazz, this);
        kotlinClassKindMetadata.referencedClass.attributesAccept(this.annotationCounter.reset());
        kotlinClassKindMetadata.flags.common.hasAnnotations = this.annotationCounter.getCount() > 0;
    }

    @Override
    public void visitKotlinFileFacadeMetadata(Clazz clazz, KotlinFileFacadeKindMetadata kotlinFileFacadeKindMetadata) {
        this.visitKotlinDeclarationContainerMetadata(clazz, kotlinFileFacadeKindMetadata);
    }

    @Override
    public void visitKotlinSyntheticClassMetadata(Clazz clazz, KotlinSyntheticClassKindMetadata kotlinSyntheticClassKindMetadata) {
        kotlinSyntheticClassKindMetadata.functionsAccept(clazz, this);
    }

    @Override
    public void visitKotlinMultiFileFacadeMetadata(Clazz clazz, KotlinMultiFileFacadeKindMetadata kotlinMultiFileFacadeKindMetadata) {
    }

    @Override
    public void visitKotlinMultiFilePartMetadata(Clazz clazz, KotlinMultiFilePartKindMetadata kotlinMultiFilePartKindMetadata) {
        this.visitKotlinDeclarationContainerMetadata(clazz, kotlinMultiFilePartKindMetadata);
    }

    @Override
    public void visitAnyProperty(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata) {
        kotlinPropertyMetadata.versionRequirementAccept(clazz, kotlinDeclarationContainerMetadata, this);
        kotlinPropertyMetadata.typeAccept(clazz, kotlinDeclarationContainerMetadata, this);
        kotlinPropertyMetadata.setterParametersAccept(clazz, kotlinDeclarationContainerMetadata, this);
        kotlinPropertyMetadata.contextReceiverTypesAccept(clazz, kotlinDeclarationContainerMetadata, this);
        kotlinPropertyMetadata.receiverTypeAccept(clazz, kotlinDeclarationContainerMetadata, this);
        kotlinPropertyMetadata.typeParametersAccept(clazz, kotlinDeclarationContainerMetadata, this);
        if (kotlinPropertyMetadata.syntheticMethodForAnnotations != null) {
            kotlinPropertyMetadata.referencedSyntheticMethodForAnnotations.accept(kotlinPropertyMetadata.referencedSyntheticMethodClass, this.annotationCounter.reset());
            kotlinPropertyMetadata.flags.common.hasAnnotations = this.annotationCounter.getCount() > 0;
        } else if (kotlinPropertyMetadata.referencedBackingField != null) {
            kotlinPropertyMetadata.referencedBackingField.accept(kotlinPropertyMetadata.referencedBackingFieldClass, this.annotationCounter);
            kotlinPropertyMetadata.flags.common.hasAnnotations = this.annotationCounter.getCount() > 0;
        } else {
            kotlinPropertyMetadata.flags.common.hasAnnotations = false;
        }
        if (kotlinPropertyMetadata.flags.hasGetter && kotlinPropertyMetadata.referencedGetterMethod != null) {
            kotlinPropertyMetadata.referencedGetterMethod.accept(clazz, this.annotationCounter.reset());
            boolean bl = kotlinPropertyMetadata.getterFlags.common.hasAnnotations = this.annotationCounter.getCount() > 0;
        }
        if (kotlinPropertyMetadata.flags.hasSetter && kotlinPropertyMetadata.referencedSetterMethod != null) {
            kotlinPropertyMetadata.referencedSetterMethod.accept(clazz, this.annotationCounter.reset());
            kotlinPropertyMetadata.setterFlags.common.hasAnnotations = this.annotationCounter.getCount() > 0;
        }
    }

    @Override
    public void visitAnyFunction(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
        kotlinFunctionMetadata.contextReceiverTypesAccept(clazz, kotlinMetadata, this);
        kotlinFunctionMetadata.receiverTypeAccept(clazz, kotlinMetadata, this);
        kotlinFunctionMetadata.typeParametersAccept(clazz, kotlinMetadata, this);
        kotlinFunctionMetadata.valueParametersAccept(clazz, kotlinMetadata, this);
        kotlinFunctionMetadata.returnTypeAccept(clazz, kotlinMetadata, this);
        kotlinFunctionMetadata.referencedMethodAccept(this.annotationCounter.reset());
        kotlinFunctionMetadata.flags.common.hasAnnotations = this.annotationCounter.getCount() != 0;
    }

    @Override
    public void visitConstructor(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata, KotlinConstructorMetadata kotlinConstructorMetadata) {
        kotlinConstructorMetadata.valueParametersAccept(clazz, kotlinClassKindMetadata, this);
        kotlinConstructorMetadata.versionRequirementAccept(clazz, kotlinClassKindMetadata, this);
        if (kotlinClassKindMetadata.flags.isAnnotationClass) {
            kotlinConstructorMetadata.flags.common.hasAnnotations = false;
        } else {
            kotlinConstructorMetadata.referencedMethodAccept(clazz, this.annotationCounter.reset());
            kotlinConstructorMetadata.flags.common.hasAnnotations = this.annotationCounter.getCount() != 0;
        }
    }

    @Override
    public void visitTypeAlias(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinTypeAliasMetadata kotlinTypeAliasMetadata) {
        kotlinTypeAliasMetadata.typeParametersAccept(clazz, kotlinDeclarationContainerMetadata, this);
        kotlinTypeAliasMetadata.underlyingTypeAccept(clazz, kotlinDeclarationContainerMetadata, this);
        kotlinTypeAliasMetadata.expandedTypeAccept(clazz, kotlinDeclarationContainerMetadata, this);
        kotlinTypeAliasMetadata.versionRequirementAccept(clazz, kotlinDeclarationContainerMetadata, this);
        kotlinTypeAliasMetadata.flags.common.hasAnnotations = !kotlinTypeAliasMetadata.annotations.isEmpty();
    }

    @Override
    public void visitAnyType(Clazz clazz, KotlinTypeMetadata kotlinTypeMetadata) {
        kotlinTypeMetadata.typeArgumentsAccept(clazz, this);
        kotlinTypeMetadata.upperBoundsAccept(clazz, this);
        kotlinTypeMetadata.abbreviationAccept(clazz, this);
    }

    @Override
    public void visitFunctionReceiverType(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
        kotlinFunctionMetadata.referencedMethodAccept(this.annotationCounter.reset());
    }

    @Override
    public void visitAnyValueParameter(Clazz clazz, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
    }

    @Override
    public void visitAnyTypeParameter(Clazz clazz, KotlinTypeParameterMetadata kotlinTypeParameterMetadata) {
        kotlinTypeParameterMetadata.upperBoundsAccept(clazz, this);
    }

    @Override
    public void visitFunctionValParameter(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
        kotlinValueParameterMetadata.typeAccept(clazz, kotlinMetadata, kotlinFunctionMetadata, (KotlinTypeVisitor)this);
        if (kotlinValueParameterMetadata.flags.common.hasAnnotations) {
            kotlinFunctionMetadata.referencedMethodAccept(this.annotationCounter.reset());
            kotlinValueParameterMetadata.flags.common.hasAnnotations = this.annotationCounter.getParameterAnnotationCount(kotlinValueParameterMetadata.index) > 0;
        }
    }

    @Override
    public void visitConstructorValParameter(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata, KotlinConstructorMetadata kotlinConstructorMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
        kotlinValueParameterMetadata.typeAccept(clazz, kotlinClassKindMetadata, kotlinConstructorMetadata, (KotlinTypeVisitor)this);
        if (kotlinValueParameterMetadata.flags.common.hasAnnotations && !kotlinClassKindMetadata.flags.isAnnotationClass) {
            kotlinConstructorMetadata.referencedMethodAccept(clazz, this.annotationCounter.reset());
            kotlinValueParameterMetadata.flags.common.hasAnnotations = this.annotationCounter.getParameterAnnotationCount(kotlinValueParameterMetadata.index) > 0;
        }
    }

    @Override
    public void visitPropertyValParameter(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
        kotlinValueParameterMetadata.typeAccept(clazz, kotlinDeclarationContainerMetadata, kotlinPropertyMetadata, (KotlinTypeVisitor)this);
        if (kotlinValueParameterMetadata.flags.common.hasAnnotations) {
            kotlinPropertyMetadata.referencedSetterMethod.accept(clazz, this.annotationCounter.reset());
            kotlinValueParameterMetadata.flags.common.hasAnnotations = this.annotationCounter.getParameterAnnotationCount(kotlinValueParameterMetadata.index) > 0;
        }
    }

    @Override
    public void visitAnyVersionRequirement(Clazz clazz, KotlinVersionRequirementMetadata kotlinVersionRequirementMetadata) {
    }
}

