/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Field;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.util.ArrayUtil;

public class ClassEditor {
    private static final boolean DEBUG = false;
    private ProgramClass targetClass;

    public ClassEditor(ProgramClass targetClass) {
        this.targetClass = targetClass;
    }

    public void addInterface(int interfaceConstantIndex) {
        this.targetClass.u2interfaces = ArrayUtil.add(this.targetClass.u2interfaces, this.targetClass.u2interfacesCount++, interfaceConstantIndex);
    }

    public void removeInterface(int interfaceConstantIndex) {
        ArrayUtil.remove(this.targetClass.u2interfaces, this.targetClass.u2interfacesCount--, this.findInterfaceIndex(interfaceConstantIndex));
    }

    private int findInterfaceIndex(int interfaceConstantIndex) {
        int interfacesCount = this.targetClass.u2interfacesCount;
        int[] interfaces = this.targetClass.u2interfaces;
        for (int index = 0; index < interfacesCount; ++index) {
            if (interfaces[index] != interfaceConstantIndex) continue;
            return index;
        }
        return interfacesCount;
    }

    public void addField(Field field) {
        this.targetClass.fields = (ProgramField[])ArrayUtil.add(this.targetClass.fields, this.targetClass.u2fieldsCount++, field);
    }

    public void removeField(Field field) {
        ArrayUtil.remove(this.targetClass.fields, this.targetClass.u2fieldsCount--, this.findFieldIndex(field));
    }

    private int findFieldIndex(Field field) {
        int fieldsCount = this.targetClass.u2fieldsCount;
        ProgramField[] fields = this.targetClass.fields;
        for (int index = 0; index < fieldsCount; ++index) {
            if (!fields[index].equals(field)) continue;
            return index;
        }
        return fieldsCount;
    }

    public void addMethod(Method method) {
        this.targetClass.methods = (ProgramMethod[])ArrayUtil.add(this.targetClass.methods, this.targetClass.u2methodsCount++, method);
    }

    public void removeMethod(Method method) {
        ArrayUtil.remove(this.targetClass.methods, this.targetClass.u2methodsCount--, this.findMethodIndex(method));
    }

    private int findMethodIndex(Method method) {
        int methodsCount = this.targetClass.u2methodsCount;
        ProgramMethod[] methods = this.targetClass.methods;
        for (int index = 0; index < methodsCount; ++index) {
            if (!methods[index].equals(method)) continue;
            return index;
        }
        return methodsCount;
    }
}

