/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.optimize.peephole.ReachableCodeMarker;

public class UnreachableCodeRemover
implements AttributeVisitor,
InstructionVisitor {
    private static final Logger logger = LogManager.getLogger(UnreachableCodeRemover.class);
    private final InstructionVisitor extraInstructionVisitor;
    private final ReachableCodeMarker reachableCodeMarker = new ReachableCodeMarker();
    private final CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor();

    public UnreachableCodeRemover() {
        this(null);
    }

    public UnreachableCodeRemover(InstructionVisitor extraInstructionVisitor) {
        this.extraInstructionVisitor = extraInstructionVisitor;
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        try {
            this.visitCodeAttribute0(clazz, method, codeAttribute);
        }
        catch (RuntimeException ex) {
            logger.error("Unexpected error while removing unreachable code:");
            logger.error("  Class       = [{}]", (Object)clazz.getName());
            logger.error("  Method      = [{}{}]", (Object)method.getName(clazz), (Object)method.getDescriptor(clazz));
            logger.error("  Exception   = [{}] ({})", (Object)ex.getClass().getName(), (Object)ex.getMessage());
            throw ex;
        }
    }

    public void visitCodeAttribute0(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        logger.debug("UnreachableCodeRemover: {}.{}{}", (Object)clazz.getName(), (Object)method.getName(clazz), (Object)method.getDescriptor(clazz));
        this.reachableCodeMarker.visitCodeAttribute(clazz, method, codeAttribute);
        this.codeAttributeEditor.reset(codeAttribute.u4codeLength);
        codeAttribute.instructionsAccept(clazz, method, this);
        this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        logger.debug("  {} {}", (Object)(this.reachableCodeMarker.isReachable(offset) ? "+" : "-"), (Object)instruction.toString(offset));
        if (!this.reachableCodeMarker.isReachable(offset)) {
            this.codeAttributeEditor.deleteInstruction(offset);
            if (this.extraInstructionVisitor != null) {
                instruction.accept(clazz, method, codeAttribute, offset, this.extraInstructionVisitor);
            }
        }
    }
}

