/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util.kotlin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlinx.metadata.Flag;
import kotlinx.metadata.InconsistentKotlinMetadataException;
import kotlinx.metadata.KmClass;
import kotlinx.metadata.KmClassifier;
import kotlinx.metadata.KmConstructor;
import kotlinx.metadata.KmContract;
import kotlinx.metadata.KmEffect;
import kotlinx.metadata.KmEffectExpression;
import kotlinx.metadata.KmEffectInvocationKind;
import kotlinx.metadata.KmEffectType;
import kotlinx.metadata.KmFlexibleTypeUpperBound;
import kotlinx.metadata.KmFunction;
import kotlinx.metadata.KmPackage;
import kotlinx.metadata.KmProperty;
import kotlinx.metadata.KmType;
import kotlinx.metadata.KmTypeAlias;
import kotlinx.metadata.KmTypeParameter;
import kotlinx.metadata.KmTypeProjection;
import kotlinx.metadata.KmValueParameter;
import kotlinx.metadata.KmVariance;
import kotlinx.metadata.KmVersionRequirement;
import kotlinx.metadata.KmVersionRequirementLevel;
import kotlinx.metadata.KmVersionRequirementVersionKind;
import kotlinx.metadata.internal.metadata.jvm.deserialization.JvmMetadataVersion;
import kotlinx.metadata.jvm.JvmExtensionsKt;
import kotlinx.metadata.jvm.JvmFieldSignature;
import kotlinx.metadata.jvm.JvmFlag;
import kotlinx.metadata.jvm.JvmMetadataUtil;
import kotlinx.metadata.jvm.JvmMethodSignature;
import kotlinx.metadata.jvm.KotlinClassMetadata;
import proguard.classfile.Clazz;
import proguard.classfile.FieldSignature;
import proguard.classfile.LibraryClass;
import proguard.classfile.MethodSignature;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.visitor.AllAnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.AnnotationTypeFilter;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeNameFilter;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.kotlin.KotlinClassKindMetadata;
import proguard.classfile.kotlin.KotlinConstructorMetadata;
import proguard.classfile.kotlin.KotlinContractMetadata;
import proguard.classfile.kotlin.KotlinDeclarationContainerMetadata;
import proguard.classfile.kotlin.KotlinEffectExpressionMetadata;
import proguard.classfile.kotlin.KotlinEffectInvocationKind;
import proguard.classfile.kotlin.KotlinEffectMetadata;
import proguard.classfile.kotlin.KotlinEffectType;
import proguard.classfile.kotlin.KotlinFileFacadeKindMetadata;
import proguard.classfile.kotlin.KotlinFunctionMetadata;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.KotlinMetadataVersion;
import proguard.classfile.kotlin.KotlinMultiFileFacadeKindMetadata;
import proguard.classfile.kotlin.KotlinMultiFilePartKindMetadata;
import proguard.classfile.kotlin.KotlinPropertyMetadata;
import proguard.classfile.kotlin.KotlinSyntheticClassKindMetadata;
import proguard.classfile.kotlin.KotlinTypeAliasMetadata;
import proguard.classfile.kotlin.KotlinTypeMetadata;
import proguard.classfile.kotlin.KotlinTypeParameterMetadata;
import proguard.classfile.kotlin.KotlinTypeVariance;
import proguard.classfile.kotlin.KotlinValueParameterMetadata;
import proguard.classfile.kotlin.KotlinVersionRequirementLevel;
import proguard.classfile.kotlin.KotlinVersionRequirementMetadata;
import proguard.classfile.kotlin.KotlinVersionRequirementVersionKind;
import proguard.classfile.kotlin.UnsupportedKotlinMetadata;
import proguard.classfile.kotlin.flags.KotlinClassFlags;
import proguard.classfile.kotlin.flags.KotlinCommonFlags;
import proguard.classfile.kotlin.flags.KotlinConstructorFlags;
import proguard.classfile.kotlin.flags.KotlinEffectExpressionFlags;
import proguard.classfile.kotlin.flags.KotlinFunctionFlags;
import proguard.classfile.kotlin.flags.KotlinModalityFlags;
import proguard.classfile.kotlin.flags.KotlinPropertyAccessorFlags;
import proguard.classfile.kotlin.flags.KotlinPropertyFlags;
import proguard.classfile.kotlin.flags.KotlinTypeAliasFlags;
import proguard.classfile.kotlin.flags.KotlinTypeFlags;
import proguard.classfile.kotlin.flags.KotlinTypeParameterFlags;
import proguard.classfile.kotlin.flags.KotlinValueParameterFlags;
import proguard.classfile.kotlin.flags.KotlinVisibilityFlags;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.util.kotlin.KotlinAnnotationUtilKt;
import proguard.classfile.visitor.ClassVisitor;

public class KotlinMetadataInitializer
implements ClassVisitor,
AnnotationVisitor,
ElementValueVisitor,
ConstantVisitor {
    private int k;
    private int[] mv;
    private String[] d1;
    private String[] d2;
    private int xi;
    private String xs;
    private String pn;
    public static final KotlinMetadataVersion MAX_SUPPORTED_VERSION;
    private MetadataType currentType;
    private final BiConsumer<Clazz, String> errorHandler;

    public KotlinMetadataInitializer(WarningPrinter warningPrinter) {
        this((Clazz clazz, String message) -> warningPrinter.print(clazz.getName(), (String)message));
    }

    public KotlinMetadataInitializer(BiConsumer<Clazz, String> errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
    }

    @Override
    public void visitProgramClass(ProgramClass clazz) {
        clazz.accept(new AllAttributeVisitor(new AttributeNameFilter("RuntimeVisibleAnnotations", (AttributeVisitor)new AllAnnotationVisitor(new AnnotationTypeFilter("Lkotlin/Metadata;", (AnnotationVisitor)this)))));
    }

    @Override
    public void visitAnnotation(Clazz clazz, Annotation annotation) {
        this.k = -1;
        this.mv = null;
        this.d1 = null;
        this.d2 = null;
        this.xi = 0;
        this.xs = null;
        this.pn = null;
        try {
            annotation.elementValuesAccept(clazz, this);
        }
        catch (Exception e) {
            this.errorHandler.accept(clazz, "Encountered corrupt Kotlin metadata in class " + clazz.getName() + ". The metadata for this class will not be processed (" + e.getMessage() + ")");
            clazz.accept(new SimpleKotlinMetadataSetter(new UnsupportedKotlinMetadata(this.k, this.mv, this.xi, this.xs, this.pn)));
            return;
        }
        this.initialize(clazz, this.k, this.mv, this.d1, this.d2, this.xi, this.xs, this.pn);
    }

    public void initialize(Clazz clazz, int k, int[] mv, String[] d1, String[] d2, int xi, String xs, String pn) {
        Metadata metadata = JvmMetadataUtil.Metadata(k, mv, d1, d2, xs, pn, xi);
        KotlinClassMetadata md = KotlinClassMetadata.read(metadata);
        if (md == null) {
            String version = mv == null ? "unknown" : Arrays.stream(mv).mapToObj(Integer::toString).collect(Collectors.joining("."));
            this.errorHandler.accept(clazz, "Encountered corrupt @kotlin/Metadata for class " + clazz.getName() + " (version " + version + ").");
            clazz.accept(new SimpleKotlinMetadataSetter(new UnsupportedKotlinMetadata(k, mv, xi, xs, pn)));
            return;
        }
        try {
            switch (k) {
                case 1: {
                    KotlinClassKindMetadata kotlinClassKindMetadata = this.toKotlinClassKindMetadata(md);
                    kotlinClassKindMetadata.ownerClassName = clazz.getName();
                    clazz.accept(new SimpleKotlinMetadataSetter(kotlinClassKindMetadata));
                    break;
                }
                case 2: {
                    KotlinFileFacadeKindMetadata kotlinFileFacadeKindMetadata = KotlinMetadataInitializer.toKotlinFileFacadeKindMetadata(md);
                    kotlinFileFacadeKindMetadata.ownerClassName = clazz.getName();
                    clazz.accept(new SimpleKotlinMetadataSetter(kotlinFileFacadeKindMetadata));
                    break;
                }
                case 3: {
                    KotlinClassMetadata.SyntheticClass smd = (KotlinClassMetadata.SyntheticClass)md;
                    KotlinSyntheticClassKindMetadata.Flavor flavor = smd.isLambda() ? KotlinSyntheticClassKindMetadata.Flavor.LAMBDA : (clazz.getName().endsWith("$DefaultImpls") ? KotlinSyntheticClassKindMetadata.Flavor.DEFAULT_IMPLS : (clazz.getName().endsWith("$WhenMappings") ? KotlinSyntheticClassKindMetadata.Flavor.WHEN_MAPPINGS : KotlinSyntheticClassKindMetadata.Flavor.REGULAR));
                    KotlinSyntheticClassKindMetadata kotlinSyntheticClassKindMetadata = new KotlinSyntheticClassKindMetadata(mv, xi, xs, pn, flavor);
                    if (smd.isLambda()) {
                        kotlinSyntheticClassKindMetadata.functions = new ArrayList<KotlinFunctionMetadata>(1);
                        kotlinSyntheticClassKindMetadata.functions.add(KotlinMetadataInitializer.toKotlinFunctionMetadata(Objects.requireNonNull(smd.toKmLambda()).getFunction()));
                    } else {
                        kotlinSyntheticClassKindMetadata.functions = Collections.emptyList();
                    }
                    clazz.accept(new SimpleKotlinMetadataSetter(kotlinSyntheticClassKindMetadata));
                    break;
                }
                case 4: {
                    clazz.accept(new SimpleKotlinMetadataSetter(new KotlinMultiFileFacadeKindMetadata(mv, d1, xi, xs, pn)));
                    break;
                }
                case 5: {
                    KotlinMultiFilePartKindMetadata kotlinMultiFilePartKindMetadata = KotlinMetadataInitializer.toKotlinMultiFilePartKindMetadata(md);
                    kotlinMultiFilePartKindMetadata.ownerClassName = clazz.getName();
                    clazz.accept(new SimpleKotlinMetadataSetter(kotlinMultiFilePartKindMetadata));
                    break;
                }
                default: {
                    this.errorHandler.accept(clazz, "Unknown Kotlin class kind in class " + clazz.getName() + ". The metadata for this class will not be processed.");
                    clazz.accept(new SimpleKotlinMetadataSetter(new UnsupportedKotlinMetadata(k, mv, xi, xs, pn)));
                    break;
                }
            }
        }
        catch (InconsistentKotlinMetadataException e) {
            this.errorHandler.accept(clazz, "Encountered corrupt Kotlin metadata in class " + clazz.getName() + ". The metadata for this class will not be processed (" + e.getMessage() + ")");
            clazz.accept(new SimpleKotlinMetadataSetter(new UnsupportedKotlinMetadata(k, mv, xi, xs, pn)));
        }
    }

    @Override
    public void visitConstantElementValue(Clazz clazz, Annotation annotation, ConstantElementValue constantElementValue) {
        this.currentType = KotlinMetadataInitializer.metadataTypeOf(constantElementValue.getMethodName(clazz));
        clazz.constantPoolEntryAccept(constantElementValue.u2constantValueIndex, this);
    }

    @Override
    public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
        MetadataType arrayElementType = KotlinMetadataInitializer.metadataTypeOf(arrayElementValue.getMethodName(clazz));
        switch (arrayElementType) {
            case mv: {
                this.mv = new int[arrayElementValue.u2elementValuesCount];
                break;
            }
            case d1: {
                this.d1 = new String[arrayElementValue.u2elementValuesCount];
                break;
            }
            case d2: {
                this.d2 = new String[arrayElementValue.u2elementValuesCount];
            }
        }
        arrayElementValue.elementValuesAccept(clazz, annotation, new ArrayElementValueCollector(arrayElementType));
    }

    @Override
    public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
        if (this.currentType == MetadataType.xs) {
            this.xs = utf8Constant.getString();
        } else if (this.currentType == MetadataType.pn) {
            this.pn = utf8Constant.getString();
        } else {
            throw new UnsupportedOperationException("Cannot store Utf8Constant in int");
        }
    }

    @Override
    public void visitIntegerConstant(Clazz clazz, IntegerConstant integerConstant) {
        if (this.currentType == MetadataType.k) {
            this.k = integerConstant.getValue();
        } else if (this.currentType == MetadataType.xi) {
            this.xi = integerConstant.getValue();
        } else {
            throw new UnsupportedOperationException("Cannot store Utf8Constant in int");
        }
    }

    private KotlinClassKindMetadata toKotlinClassKindMetadata(KotlinClassMetadata md) {
        KotlinClassKindMetadata kotlinClassKindMetadata = new KotlinClassKindMetadata(md.getAnnotationData().mv(), md.getAnnotationData().xi(), md.getAnnotationData().xs(), md.getAnnotationData().pn());
        KotlinClassMetadata.Class classMetadata = (KotlinClassMetadata.Class)md;
        KmClass kmClass = classMetadata.toKmClass();
        String className = kmClass.getName();
        if (className.startsWith(".")) {
            className = className.substring(1);
        }
        kotlinClassKindMetadata.className = className = className.replace('.', '$');
        kotlinClassKindMetadata.flags = KotlinMetadataInitializer.convertClassFlags(kmClass.getFlags());
        kotlinClassKindMetadata.companionObjectName = kmClass.getCompanionObject();
        kotlinClassKindMetadata.underlyingPropertyName = kmClass.getInlineClassUnderlyingPropertyName();
        kotlinClassKindMetadata.underlyingPropertyType = KotlinMetadataInitializer.toKotlinTypeMetadata(kmClass.getInlineClassUnderlyingType());
        kotlinClassKindMetadata.enumEntryNames = kmClass.getEnumEntries();
        kotlinClassKindMetadata.nestedClassNames = kmClass.getNestedClasses();
        kotlinClassKindMetadata.sealedSubclassNames = kmClass.getSealedSubclasses().stream().map(it -> it.replace(".", "$")).collect(Collectors.toList());
        kotlinClassKindMetadata.versionRequirement = KotlinMetadataInitializer.toKotlinVersionRequirementMetadataFromList(kmClass.getVersionRequirements());
        kotlinClassKindMetadata.typeParameters = kmClass.getTypeParameters().stream().map(KotlinMetadataInitializer::toKotlinTypeParameterMetadata).collect(Collectors.toList());
        kotlinClassKindMetadata.contextReceivers = kmClass.getContextReceiverTypes().stream().map(KotlinMetadataInitializer::toKotlinTypeMetadata).collect(Collectors.toList());
        kotlinClassKindMetadata.superTypes = kmClass.getSupertypes().stream().map(KotlinMetadataInitializer::toKotlinTypeMetadata).collect(Collectors.toList());
        kotlinClassKindMetadata.constructors = kmClass.getConstructors().stream().map(it -> KotlinMetadataInitializer.toKotlinConstructorMetadata(md.getAnnotationData().mv(), kotlinClassKindMetadata.flags.isAnnotationClass, it)).collect(Collectors.toList());
        kotlinClassKindMetadata.functions = kmClass.getFunctions().stream().map(KotlinMetadataInitializer::toKotlinFunctionMetadata).collect(Collectors.toList());
        kotlinClassKindMetadata.properties = kmClass.getProperties().stream().map(KotlinMetadataInitializer::toKotlinPropertyMetadata).collect(Collectors.toList());
        kotlinClassKindMetadata.typeAliases = kmClass.getTypeAliases().stream().map(KotlinMetadataInitializer::toKotlinTypeAliasMetadata).collect(Collectors.toList());
        KotlinMetadataInitializer.setClassJvmFlags(kotlinClassKindMetadata.flags, JvmExtensionsKt.getJvmFlags(kmClass));
        kotlinClassKindMetadata.anonymousObjectOriginName = JvmExtensionsKt.getAnonymousObjectOriginName(kmClass);
        kotlinClassKindMetadata.localDelegatedProperties = JvmExtensionsKt.getLocalDelegatedProperties(kmClass).stream().map(KotlinMetadataInitializer::toKotlinPropertyMetadata).collect(Collectors.toList());
        return kotlinClassKindMetadata;
    }

    private static KotlinFileFacadeKindMetadata toKotlinFileFacadeKindMetadata(KotlinClassMetadata md) {
        KotlinFileFacadeKindMetadata kotlinFileFacadeKindMetadata = new KotlinFileFacadeKindMetadata(md.getAnnotationData().mv(), md.getAnnotationData().xi(), md.getAnnotationData().xs(), md.getAnnotationData().pn());
        KotlinClassMetadata.FileFacade fileFacade = (KotlinClassMetadata.FileFacade)md;
        KmPackage kmPackage = fileFacade.toKmPackage();
        KotlinMetadataInitializer.populateFromKmPackage(kotlinFileFacadeKindMetadata, kmPackage);
        return kotlinFileFacadeKindMetadata;
    }

    private static KotlinMultiFilePartKindMetadata toKotlinMultiFilePartKindMetadata(KotlinClassMetadata md) {
        KotlinMultiFilePartKindMetadata kotlinMultiFilePartKindMetadata = new KotlinMultiFilePartKindMetadata(md.getAnnotationData().mv(), md.getAnnotationData().xi(), md.getAnnotationData().xs(), md.getAnnotationData().pn());
        KotlinClassMetadata.MultiFileClassPart fileFacade = (KotlinClassMetadata.MultiFileClassPart)md;
        KmPackage kmPackage = fileFacade.toKmPackage();
        KotlinMetadataInitializer.populateFromKmPackage(kotlinMultiFilePartKindMetadata, kmPackage);
        return kotlinMultiFilePartKindMetadata;
    }

    private static void populateFromKmPackage(KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KmPackage kmPackage) {
        kotlinDeclarationContainerMetadata.functions = kmPackage.getFunctions().stream().map(KotlinMetadataInitializer::toKotlinFunctionMetadata).collect(Collectors.toList());
        kotlinDeclarationContainerMetadata.typeAliases = kmPackage.getTypeAliases().stream().map(KotlinMetadataInitializer::toKotlinTypeAliasMetadata).collect(Collectors.toList());
        kotlinDeclarationContainerMetadata.properties = kmPackage.getProperties().stream().map(KotlinMetadataInitializer::toKotlinPropertyMetadata).collect(Collectors.toList());
        kotlinDeclarationContainerMetadata.localDelegatedProperties = JvmExtensionsKt.getLocalDelegatedProperties(kmPackage).stream().map(KotlinMetadataInitializer::toKotlinPropertyMetadata).collect(Collectors.toList());
    }

    private static KotlinFunctionMetadata toKotlinFunctionMetadata(KmFunction kmFunction) {
        KotlinFunctionMetadata kotlinFunctionMetadata = new KotlinFunctionMetadata(KotlinMetadataInitializer.convertFunctionFlags(kmFunction.getFlags()), kmFunction.getName());
        kotlinFunctionMetadata.contracts = kmFunction.getContract() != null ? new ArrayList<KotlinContractMetadata>(Collections.singleton(KotlinMetadataInitializer.toKotlinContractMetadata(kmFunction.getContract()))) : new ArrayList();
        kotlinFunctionMetadata.receiverType = KotlinMetadataInitializer.toKotlinTypeMetadata(kmFunction.getReceiverParameterType());
        kotlinFunctionMetadata.contextReceivers = kmFunction.getContextReceiverTypes().stream().map(KotlinMetadataInitializer::toKotlinTypeMetadata).collect(Collectors.toList());
        kotlinFunctionMetadata.returnType = KotlinMetadataInitializer.toKotlinTypeMetadata(kmFunction.returnType);
        kotlinFunctionMetadata.typeParameters = kmFunction.getTypeParameters().stream().map(KotlinMetadataInitializer::toKotlinTypeParameterMetadata).collect(Collectors.toList());
        List<KmValueParameter> valueParameters = kmFunction.getValueParameters();
        kotlinFunctionMetadata.valueParameters = new ArrayList<KotlinValueParameterMetadata>(valueParameters.size());
        for (int i = 0; i < valueParameters.size(); ++i) {
            kotlinFunctionMetadata.valueParameters.add(KotlinMetadataInitializer.toKotlinValueParameterMetadata(i, valueParameters.get(i)));
        }
        kotlinFunctionMetadata.versionRequirement = KotlinMetadataInitializer.toKotlinVersionRequirementMetadataFromList(kmFunction.getVersionRequirements());
        kotlinFunctionMetadata.jvmSignature = KotlinMetadataInitializer.fromKotlinJvmMethodSignature(JvmExtensionsKt.getSignature(kmFunction));
        kotlinFunctionMetadata.lambdaClassOriginName = JvmExtensionsKt.getLambdaClassOriginName(kmFunction);
        return kotlinFunctionMetadata;
    }

    private static KotlinContractMetadata toKotlinContractMetadata(KmContract kmContract) {
        KotlinContractMetadata kotlinContractMetadata = new KotlinContractMetadata();
        kotlinContractMetadata.effects = kmContract.getEffects().stream().map(KotlinMetadataInitializer::toKotlinEffectMetadata).collect(Collectors.toList());
        return kotlinContractMetadata;
    }

    private static KotlinEffectMetadata toKotlinEffectMetadata(KmEffect kmEffect) {
        KotlinEffectMetadata effect = new KotlinEffectMetadata(KotlinMetadataInitializer.fromKmEffectType(kmEffect.getType()), KotlinMetadataInitializer.fromKmEffectInvocationKind(kmEffect.getInvocationKind()));
        effect.conclusionOfConditionalEffect = KotlinMetadataInitializer.toKotlinEffectExpressionMetadata(kmEffect.getConclusion());
        effect.constructorArguments = kmEffect.getConstructorArguments().stream().map(KotlinMetadataInitializer::toKotlinEffectExpressionMetadata).collect(Collectors.toList());
        return effect;
    }

    private static KotlinEffectExpressionMetadata toKotlinEffectExpressionMetadata(KmEffectExpression kmEffectExpression) {
        if (kmEffectExpression == null) {
            return null;
        }
        KotlinEffectExpressionMetadata expressionMetadata = new KotlinEffectExpressionMetadata();
        expressionMetadata.flags = KotlinMetadataInitializer.convertEffectExpressionFlags(kmEffectExpression.getFlags());
        if (kmEffectExpression.getParameterIndex() != null) {
            expressionMetadata.parameterIndex = kmEffectExpression.getParameterIndex();
        }
        if (kmEffectExpression.getConstantValue() != null) {
            expressionMetadata.hasConstantValue = true;
            expressionMetadata.constantValue = kmEffectExpression.getConstantValue().getValue();
        }
        if (kmEffectExpression.isInstanceType() != null) {
            expressionMetadata.typeOfIs = KotlinMetadataInitializer.toKotlinTypeMetadata(kmEffectExpression.isInstanceType());
        }
        expressionMetadata.andRightHandSides = kmEffectExpression.getAndArguments().stream().map(KotlinMetadataInitializer::toKotlinEffectExpressionMetadata).collect(Collectors.toList());
        expressionMetadata.orRightHandSides = kmEffectExpression.getOrArguments().stream().map(KotlinMetadataInitializer::toKotlinEffectExpressionMetadata).collect(Collectors.toList());
        return expressionMetadata;
    }

    private static KotlinTypeAliasMetadata toKotlinTypeAliasMetadata(KmTypeAlias kmTypeAlias) {
        KotlinTypeAliasMetadata typeAlias = new KotlinTypeAliasMetadata(KotlinMetadataInitializer.convertTypeAliasFlags(kmTypeAlias.getFlags()), kmTypeAlias.getName());
        typeAlias.underlyingType = KotlinMetadataInitializer.toKotlinTypeMetadata(kmTypeAlias.getUnderlyingType());
        typeAlias.expandedType = KotlinMetadataInitializer.toKotlinTypeMetadata(kmTypeAlias.getExpandedType());
        typeAlias.versionRequirement = KotlinMetadataInitializer.toKotlinVersionRequirementMetadataFromList(kmTypeAlias.getVersionRequirements());
        typeAlias.annotations = kmTypeAlias.getAnnotations().stream().map(KotlinAnnotationUtilKt::convertAnnotation).collect(Collectors.toList());
        typeAlias.typeParameters = kmTypeAlias.getTypeParameters().stream().map(KotlinMetadataInitializer::toKotlinTypeParameterMetadata).collect(Collectors.toList());
        return typeAlias;
    }

    private static KotlinPropertyMetadata toKotlinPropertyMetadata(KmProperty kmProperty) {
        KotlinPropertyMetadata property = new KotlinPropertyMetadata(KotlinMetadataInitializer.convertPropertyFlags(kmProperty.getFlags()), kmProperty.getName(), KotlinMetadataInitializer.convertPropertyAccessorFlags(kmProperty.getGetterFlags()), KotlinMetadataInitializer.convertPropertyAccessorFlags(kmProperty.getSetterFlags()));
        property.receiverType = KotlinMetadataInitializer.toKotlinTypeMetadata(kmProperty.getReceiverParameterType());
        property.contextReceivers = kmProperty.getContextReceiverTypes().stream().map(KotlinMetadataInitializer::toKotlinTypeMetadata).collect(Collectors.toList());
        property.type = KotlinMetadataInitializer.toKotlinTypeMetadata(kmProperty.returnType);
        property.versionRequirement = KotlinMetadataInitializer.toKotlinVersionRequirementMetadataFromList(kmProperty.getVersionRequirements());
        KmValueParameter setterParameter = kmProperty.getSetterParameter();
        property.setterParameters = setterParameter != null ? new ArrayList<KotlinValueParameterMetadata>(Collections.singletonList(KotlinMetadataInitializer.toKotlinValueParameterMetadata(0, setterParameter))) : new ArrayList();
        property.typeParameters = kmProperty.getTypeParameters().stream().map(KotlinMetadataInitializer::toKotlinTypeParameterMetadata).collect(Collectors.toList());
        property.backingFieldSignature = KotlinMetadataInitializer.fromKotlinJvmFieldSignature(JvmExtensionsKt.getFieldSignature(kmProperty));
        property.getterSignature = KotlinMetadataInitializer.fromKotlinJvmMethodSignature(JvmExtensionsKt.getGetterSignature(kmProperty));
        property.setterSignature = KotlinMetadataInitializer.fromKotlinJvmMethodSignature(JvmExtensionsKt.getSetterSignature(kmProperty));
        KotlinMetadataInitializer.setPropertyJvmFlags(property.flags, JvmExtensionsKt.getJvmFlags(kmProperty));
        property.syntheticMethodForAnnotations = KotlinMetadataInitializer.fromKotlinJvmMethodSignature(JvmExtensionsKt.getSyntheticMethodForAnnotations(kmProperty));
        property.syntheticMethodForDelegate = KotlinMetadataInitializer.fromKotlinJvmMethodSignature(JvmExtensionsKt.getSyntheticMethodForDelegate(kmProperty));
        return property;
    }

    private static KotlinTypeMetadata toKotlinTypeMetadata(KmType kmType) {
        return KotlinMetadataInitializer.toKotlinTypeMetadata(kmType, null);
    }

    private static KotlinTypeMetadata toKotlinTypeMetadata(KmType kmType, KmVariance kmVariance) {
        KmClassifier classifier;
        if (kmType == null) {
            return null;
        }
        KotlinTypeMetadata type = new KotlinTypeMetadata(KotlinMetadataInitializer.convertTypeFlags(kmType.getFlags()), KotlinMetadataInitializer.fromKmVariance(kmVariance));
        type.abbreviation = KotlinMetadataInitializer.toKotlinTypeMetadata(kmType.getAbbreviatedType(), null);
        if (kmType.getClassifier() instanceof KmClassifier.Class) {
            classifier = (KmClassifier.Class)kmType.getClassifier();
            String className = ((KmClassifier.Class)classifier).getName();
            if (ClassUtil.isInternalClassType(className)) {
                className = ClassUtil.internalClassNameFromClassType(className);
            }
            if (className.startsWith(".")) {
                className = className.substring(1);
            }
            type.className = className = className.replace('.', '$');
        } else if (kmType.getClassifier() instanceof KmClassifier.TypeParameter) {
            classifier = (KmClassifier.TypeParameter)kmType.getClassifier();
            type.typeParamID = ((KmClassifier.TypeParameter)classifier).getId();
        } else if (kmType.getClassifier() instanceof KmClassifier.TypeAlias) {
            KmClassifier.TypeAlias classifer = (KmClassifier.TypeAlias)kmType.getClassifier();
            type.aliasName = classifer.getName();
        }
        type.outerClassType = KotlinMetadataInitializer.toKotlinTypeMetadata(kmType.getOuterType());
        type.typeArguments = kmType.getArguments().stream().map(KotlinMetadataInitializer::toKotlinTypeMetadataFromKotlinTypeProjection).collect(Collectors.toList());
        KmFlexibleTypeUpperBound flexibleTypeUpperBound = kmType.getFlexibleTypeUpperBound();
        if (flexibleTypeUpperBound != null) {
            type.flexibilityID = flexibleTypeUpperBound.getTypeFlexibilityId();
            type.upperBounds = new ArrayList<KotlinTypeMetadata>(Collections.singletonList(KotlinMetadataInitializer.toKotlinTypeMetadata(flexibleTypeUpperBound.getType())));
        } else {
            type.upperBounds = new ArrayList<KotlinTypeMetadata>();
        }
        type.isRaw = JvmExtensionsKt.isRaw(kmType);
        type.annotations = JvmExtensionsKt.getAnnotations(kmType).stream().map(KotlinAnnotationUtilKt::convertAnnotation).collect(Collectors.toList());
        return type;
    }

    private static KotlinTypeMetadata toKotlinTypeMetadataFromKotlinTypeProjection(KmTypeProjection kmTypeProjection) {
        if (kmTypeProjection == KmTypeProjection.STAR) {
            return KotlinTypeMetadata.starProjection();
        }
        return KotlinMetadataInitializer.toKotlinTypeMetadata(kmTypeProjection.getType(), kmTypeProjection.getVariance());
    }

    private static KotlinTypeParameterMetadata toKotlinTypeParameterMetadata(KmTypeParameter kmTypeParameter) {
        KotlinTypeParameterMetadata kotlinTypeParameterMetadata = new KotlinTypeParameterMetadata(KotlinMetadataInitializer.convertTypeParameterFlags(kmTypeParameter.getFlags()), kmTypeParameter.getName(), kmTypeParameter.getId(), KotlinMetadataInitializer.fromKmVariance(kmTypeParameter.getVariance()));
        kotlinTypeParameterMetadata.upperBounds = kmTypeParameter.getUpperBounds().stream().map(KotlinMetadataInitializer::toKotlinTypeMetadata).collect(Collectors.toList());
        kotlinTypeParameterMetadata.annotations = JvmExtensionsKt.getAnnotations(kmTypeParameter).stream().map(KotlinAnnotationUtilKt::convertAnnotation).collect(Collectors.toList());
        return kotlinTypeParameterMetadata;
    }

    private static KotlinConstructorMetadata toKotlinConstructorMetadata(int[] mv, boolean isAnnotationClass, KmConstructor kmConstructor) {
        KotlinConstructorMetadata constructor = new KotlinConstructorMetadata(KotlinMetadataInitializer.convertConstructorFlags(mv, kmConstructor.getFlags()));
        List<KmValueParameter> valueParameters = kmConstructor.getValueParameters();
        constructor.valueParameters = new ArrayList<KotlinValueParameterMetadata>(valueParameters.size());
        for (int i = 0; i < valueParameters.size(); ++i) {
            constructor.valueParameters.add(KotlinMetadataInitializer.toKotlinValueParameterMetadata(i, valueParameters.get(i)));
        }
        constructor.versionRequirement = KotlinMetadataInitializer.toKotlinVersionRequirementMetadataFromList(kmConstructor.getVersionRequirements());
        if (!isAnnotationClass) {
            constructor.jvmSignature = KotlinMetadataInitializer.fromKotlinJvmMethodSignature(JvmExtensionsKt.getSignature(kmConstructor));
        }
        return constructor;
    }

    private static KotlinValueParameterMetadata toKotlinValueParameterMetadata(int index, KmValueParameter kmValueParameter) {
        KotlinValueParameterMetadata valueParameterMetadata = new KotlinValueParameterMetadata(KotlinMetadataInitializer.convertValueParameterFlags(kmValueParameter.getFlags()), index, kmValueParameter.getName());
        valueParameterMetadata.type = KotlinMetadataInitializer.toKotlinTypeMetadata(kmValueParameter.getType());
        valueParameterMetadata.varArgElementType = KotlinMetadataInitializer.toKotlinTypeMetadata(kmValueParameter.getVarargElementType());
        return valueParameterMetadata;
    }

    private static KotlinVersionRequirementMetadata toKotlinVersionRequirementMetadataFromList(List<KmVersionRequirement> kmVersionRequirement) {
        List versionRequirementMetadata = kmVersionRequirement.stream().map(KotlinMetadataInitializer::toKotlinVersionRequirementMetadata).collect(Collectors.toList());
        if (versionRequirementMetadata.size() > 1) {
            return (KotlinVersionRequirementMetadata)versionRequirementMetadata.get(versionRequirementMetadata.size() - 1);
        }
        if (versionRequirementMetadata.size() == 1) {
            return (KotlinVersionRequirementMetadata)versionRequirementMetadata.get(0);
        }
        return null;
    }

    private static KotlinVersionRequirementMetadata toKotlinVersionRequirementMetadata(KmVersionRequirement kmVersionRequirement) {
        KotlinVersionRequirementMetadata versionReq = new KotlinVersionRequirementMetadata();
        versionReq.kind = KotlinMetadataInitializer.fromKmVersionRequirementVersionKind(kmVersionRequirement.kind);
        versionReq.level = KotlinMetadataInitializer.fromKmVersionRequirementLevel(kmVersionRequirement.level);
        versionReq.errorCode = kmVersionRequirement.getErrorCode();
        versionReq.message = kmVersionRequirement.getMessage();
        versionReq.major = kmVersionRequirement.version.getMajor();
        versionReq.minor = kmVersionRequirement.version.getMinor();
        versionReq.patch = kmVersionRequirement.version.getPatch();
        return versionReq;
    }

    private static MethodSignature fromKotlinJvmMethodSignature(JvmMethodSignature jvmMethodSignature) {
        if (jvmMethodSignature == null) {
            return null;
        }
        try {
            return new MethodSignature(null, jvmMethodSignature.getName(), jvmMethodSignature.getDesc());
        }
        catch (Exception e) {
            return null;
        }
    }

    private static FieldSignature fromKotlinJvmFieldSignature(JvmFieldSignature jvmFieldSignature) {
        if (jvmFieldSignature == null) {
            return null;
        }
        return new FieldSignature(null, jvmFieldSignature.getName(), jvmFieldSignature.getDesc());
    }

    private static KotlinTypeVariance fromKmVariance(KmVariance variance) {
        if (variance == null) {
            return null;
        }
        switch (variance) {
            case IN: {
                return KotlinTypeVariance.IN;
            }
            case INVARIANT: {
                return KotlinTypeVariance.INVARIANT;
            }
            case OUT: {
                return KotlinTypeVariance.OUT;
            }
        }
        throw new UnsupportedOperationException("Encountered unknown enum value for KmVariance.");
    }

    private static KotlinVersionRequirementVersionKind fromKmVersionRequirementVersionKind(KmVersionRequirementVersionKind kotlinVersionRequirementVersionKind) {
        switch (kotlinVersionRequirementVersionKind) {
            case API_VERSION: {
                return KotlinVersionRequirementVersionKind.API_VERSION;
            }
            case COMPILER_VERSION: {
                return KotlinVersionRequirementVersionKind.COMPILER_VERSION;
            }
            case LANGUAGE_VERSION: {
                return KotlinVersionRequirementVersionKind.LANGUAGE_VERSION;
            }
        }
        throw new UnsupportedOperationException("Encountered unknown enum value for KmVersionRequirementVersionKind.");
    }

    private static KotlinVersionRequirementLevel fromKmVersionRequirementLevel(KmVersionRequirementLevel kmVersionRequirementLevel) {
        switch (kmVersionRequirementLevel) {
            case ERROR: {
                return KotlinVersionRequirementLevel.ERROR;
            }
            case HIDDEN: {
                return KotlinVersionRequirementLevel.HIDDEN;
            }
            case WARNING: {
                return KotlinVersionRequirementLevel.WARNING;
            }
        }
        throw new UnsupportedOperationException("Encountered unknown enum value for KmVersionRequirementLevel.");
    }

    private static KotlinEffectType fromKmEffectType(KmEffectType effectType) {
        switch (effectType) {
            case CALLS: {
                return KotlinEffectType.CALLS;
            }
            case RETURNS_CONSTANT: {
                return KotlinEffectType.RETURNS_CONSTANT;
            }
            case RETURNS_NOT_NULL: {
                return KotlinEffectType.RETURNS_NOT_NULL;
            }
        }
        throw new UnsupportedOperationException("Encountered unknown enum value for KmEffectType.");
    }

    private static KotlinEffectInvocationKind fromKmEffectInvocationKind(KmEffectInvocationKind invocationKind) {
        if (invocationKind == null) {
            return null;
        }
        switch (invocationKind) {
            case AT_MOST_ONCE: {
                return KotlinEffectInvocationKind.AT_MOST_ONCE;
            }
            case EXACTLY_ONCE: {
                return KotlinEffectInvocationKind.EXACTLY_ONCE;
            }
            case AT_LEAST_ONCE: {
                return KotlinEffectInvocationKind.AT_LEAST_ONCE;
            }
        }
        throw new UnsupportedOperationException("Encountered unknown enum value for KmEffectInvocationKind.");
    }

    private static KotlinCommonFlags convertCommonFlags(int kotlinFlags) {
        KotlinCommonFlags flags = new KotlinCommonFlags();
        flags.hasAnnotations = Flag.HAS_ANNOTATIONS.invoke(kotlinFlags);
        return flags;
    }

    private static KotlinVisibilityFlags convertVisibilityFlags(int kotlinFlags) {
        KotlinVisibilityFlags flags = new KotlinVisibilityFlags();
        flags.isInternal = Flag.IS_INTERNAL.invoke(kotlinFlags);
        flags.isLocal = Flag.IS_LOCAL.invoke(kotlinFlags);
        flags.isPrivate = Flag.IS_PRIVATE.invoke(kotlinFlags);
        flags.isProtected = Flag.IS_PROTECTED.invoke(kotlinFlags);
        flags.isPublic = Flag.IS_PUBLIC.invoke(kotlinFlags);
        flags.isPrivateToThis = Flag.IS_PRIVATE_TO_THIS.invoke(kotlinFlags);
        return flags;
    }

    private static KotlinModalityFlags convertModalityFlags(int kotlinFlags) {
        KotlinModalityFlags flags = new KotlinModalityFlags();
        flags.isAbstract = Flag.IS_ABSTRACT.invoke(kotlinFlags);
        flags.isFinal = Flag.IS_FINAL.invoke(kotlinFlags);
        flags.isOpen = Flag.IS_OPEN.invoke(kotlinFlags);
        flags.isSealed = Flag.IS_SEALED.invoke(kotlinFlags);
        return flags;
    }

    private static KotlinClassFlags convertClassFlags(int kotlinFlags) {
        KotlinClassFlags flags = new KotlinClassFlags(KotlinMetadataInitializer.convertCommonFlags(kotlinFlags), KotlinMetadataInitializer.convertVisibilityFlags(kotlinFlags), KotlinMetadataInitializer.convertModalityFlags(kotlinFlags));
        flags.isUsualClass = Flag.Class.IS_CLASS.invoke(kotlinFlags);
        flags.isInterface = Flag.Class.IS_INTERFACE.invoke(kotlinFlags);
        flags.isEnumClass = Flag.Class.IS_ENUM_CLASS.invoke(kotlinFlags);
        flags.isEnumEntry = Flag.Class.IS_ENUM_ENTRY.invoke(kotlinFlags);
        flags.isAnnotationClass = Flag.Class.IS_ANNOTATION_CLASS.invoke(kotlinFlags);
        flags.isObject = Flag.Class.IS_OBJECT.invoke(kotlinFlags);
        flags.isCompanionObject = Flag.Class.IS_COMPANION_OBJECT.invoke(kotlinFlags);
        flags.isInner = Flag.Class.IS_INNER.invoke(kotlinFlags);
        flags.isData = Flag.Class.IS_DATA.invoke(kotlinFlags);
        flags.isExternal = Flag.Class.IS_EXTERNAL.invoke(kotlinFlags);
        flags.isExpect = Flag.Class.IS_EXPECT.invoke(kotlinFlags);
        flags.isInline = Flag.Class.IS_INLINE.invoke(kotlinFlags);
        flags.isValue = Flag.Class.IS_VALUE.invoke(kotlinFlags);
        flags.isFun = Flag.Class.IS_FUN.invoke(kotlinFlags);
        return flags;
    }

    private static KotlinConstructorFlags convertConstructorFlags(int[] mv, int kotlinFlags) {
        KotlinConstructorFlags flags = new KotlinConstructorFlags(KotlinMetadataInitializer.convertCommonFlags(kotlinFlags), KotlinMetadataInitializer.convertVisibilityFlags(kotlinFlags));
        flags.isPrimary = Flag.Constructor.IS_PRIMARY.invoke(kotlinFlags);
        flags.isSecondary = mv[0] == 1 && mv[1] == 1 ? !flags.isPrimary : Flag.Constructor.IS_SECONDARY.invoke(kotlinFlags);
        flags.hasNonStableParameterNames = Flag.Constructor.HAS_NON_STABLE_PARAMETER_NAMES.invoke(kotlinFlags);
        return flags;
    }

    private static KotlinFunctionFlags convertFunctionFlags(int kotlinFlags) {
        KotlinFunctionFlags flags = new KotlinFunctionFlags(KotlinMetadataInitializer.convertCommonFlags(kotlinFlags), KotlinMetadataInitializer.convertVisibilityFlags(kotlinFlags), KotlinMetadataInitializer.convertModalityFlags(kotlinFlags));
        flags.isDeclaration = Flag.Function.IS_DECLARATION.invoke(kotlinFlags);
        flags.isFakeOverride = Flag.Function.IS_FAKE_OVERRIDE.invoke(kotlinFlags);
        flags.isDelegation = Flag.Function.IS_DELEGATION.invoke(kotlinFlags);
        flags.isSynthesized = Flag.Function.IS_SYNTHESIZED.invoke(kotlinFlags);
        flags.isOperator = Flag.Function.IS_OPERATOR.invoke(kotlinFlags);
        flags.isInfix = Flag.Function.IS_INFIX.invoke(kotlinFlags);
        flags.isInline = Flag.Function.IS_INLINE.invoke(kotlinFlags);
        flags.isTailrec = Flag.Function.IS_TAILREC.invoke(kotlinFlags);
        flags.isExternal = Flag.Function.IS_EXTERNAL.invoke(kotlinFlags);
        flags.isSuspend = Flag.Function.IS_SUSPEND.invoke(kotlinFlags);
        flags.isExpect = Flag.Function.IS_EXPECT.invoke(kotlinFlags);
        return flags;
    }

    private static KotlinTypeFlags convertTypeFlags(int kotlinFlags) {
        KotlinTypeFlags flags = new KotlinTypeFlags();
        flags.isNullable = Flag.Type.IS_NULLABLE.invoke(kotlinFlags);
        flags.isSuspend = Flag.Type.IS_SUSPEND.invoke(kotlinFlags);
        flags.isDefinitelyNonNull = Flag.Type.IS_DEFINITELY_NON_NULL.invoke(kotlinFlags);
        return flags;
    }

    private static KotlinTypeParameterFlags convertTypeParameterFlags(int kotlinFlags) {
        KotlinTypeParameterFlags flags = new KotlinTypeParameterFlags();
        flags.isReified = Flag.TypeParameter.IS_REIFIED.invoke(kotlinFlags);
        return flags;
    }

    private static KotlinTypeAliasFlags convertTypeAliasFlags(int kotlinFlags) {
        return new KotlinTypeAliasFlags(KotlinMetadataInitializer.convertCommonFlags(kotlinFlags), KotlinMetadataInitializer.convertVisibilityFlags(kotlinFlags));
    }

    private static KotlinPropertyFlags convertPropertyFlags(int kotlinFlags) {
        KotlinPropertyFlags flags = new KotlinPropertyFlags(KotlinMetadataInitializer.convertCommonFlags(kotlinFlags), KotlinMetadataInitializer.convertVisibilityFlags(kotlinFlags), KotlinMetadataInitializer.convertModalityFlags(kotlinFlags));
        flags.isDeclared = Flag.Property.IS_DECLARATION.invoke(kotlinFlags);
        flags.isFakeOverride = Flag.Property.IS_FAKE_OVERRIDE.invoke(kotlinFlags);
        flags.isDelegation = Flag.Property.IS_DELEGATION.invoke(kotlinFlags);
        flags.isSynthesized = Flag.Property.IS_SYNTHESIZED.invoke(kotlinFlags);
        flags.isVar = Flag.Property.IS_VAR.invoke(kotlinFlags);
        flags.hasGetter = Flag.Property.HAS_GETTER.invoke(kotlinFlags);
        flags.hasSetter = Flag.Property.HAS_SETTER.invoke(kotlinFlags);
        flags.isConst = Flag.Property.IS_CONST.invoke(kotlinFlags);
        flags.isLateinit = Flag.Property.IS_LATEINIT.invoke(kotlinFlags);
        flags.hasConstant = Flag.Property.HAS_CONSTANT.invoke(kotlinFlags);
        flags.isExternal = Flag.Property.IS_EXTERNAL.invoke(kotlinFlags);
        flags.isDelegated = Flag.Property.IS_DELEGATED.invoke(kotlinFlags);
        flags.isExpect = Flag.Property.IS_EXPECT.invoke(kotlinFlags);
        return flags;
    }

    private static void setPropertyJvmFlags(KotlinPropertyFlags flags, int jvmFlags) {
        flags.isMovedFromInterfaceCompanion = JvmFlag.Property.IS_MOVED_FROM_INTERFACE_COMPANION.invoke(jvmFlags);
    }

    private static void setClassJvmFlags(KotlinClassFlags flags, int jvmFlags) {
        flags.hasMethodBodiesInInterface = JvmFlag.Class.HAS_METHOD_BODIES_IN_INTERFACE.invoke(jvmFlags);
        flags.isCompiledInCompatibilityMode = JvmFlag.Class.IS_COMPILED_IN_COMPATIBILITY_MODE.invoke(jvmFlags);
    }

    private static KotlinPropertyAccessorFlags convertPropertyAccessorFlags(int kotlinFlags) {
        KotlinPropertyAccessorFlags flags = new KotlinPropertyAccessorFlags(KotlinMetadataInitializer.convertCommonFlags(kotlinFlags), KotlinMetadataInitializer.convertVisibilityFlags(kotlinFlags), KotlinMetadataInitializer.convertModalityFlags(kotlinFlags));
        flags.isDefault = !Flag.PropertyAccessor.IS_NOT_DEFAULT.invoke(kotlinFlags);
        flags.isExternal = Flag.PropertyAccessor.IS_EXTERNAL.invoke(kotlinFlags);
        flags.isInline = Flag.PropertyAccessor.IS_INLINE.invoke(kotlinFlags);
        return flags;
    }

    private static KotlinValueParameterFlags convertValueParameterFlags(int kotlinFlags) {
        KotlinValueParameterFlags flags = new KotlinValueParameterFlags(KotlinMetadataInitializer.convertCommonFlags(kotlinFlags));
        flags.hasDefaultValue = Flag.ValueParameter.DECLARES_DEFAULT_VALUE.invoke(kotlinFlags);
        flags.isCrossInline = Flag.ValueParameter.IS_CROSSINLINE.invoke(kotlinFlags);
        flags.isNoInline = Flag.ValueParameter.IS_NOINLINE.invoke(kotlinFlags);
        return flags;
    }

    private static KotlinEffectExpressionFlags convertEffectExpressionFlags(int kotlinFlags) {
        KotlinEffectExpressionFlags flags = new KotlinEffectExpressionFlags();
        flags.isNullCheckPredicate = Flag.EffectExpression.IS_NULL_CHECK_PREDICATE.invoke(kotlinFlags);
        flags.isNegated = Flag.EffectExpression.IS_NEGATED.invoke(kotlinFlags);
        return flags;
    }

    public static boolean isSupportedMetadataVersion(KotlinMetadataVersion mv) {
        return new JvmMetadataVersion(mv.major, mv.minor, mv.patch).isCompatible();
    }

    public static boolean isValidKotlinMetadataAnnotationField(String name) {
        switch (name) {
            case "k": 
            case "bv": 
            case "mv": 
            case "d1": 
            case "d2": 
            case "xi": 
            case "xs": 
            case "pn": {
                return true;
            }
        }
        return false;
    }

    public static MetadataType metadataTypeOf(String name) {
        switch (name) {
            case "k": {
                return MetadataType.k;
            }
            case "bv": {
                return MetadataType.bv;
            }
            case "mv": {
                return MetadataType.mv;
            }
            case "d1": {
                return MetadataType.d1;
            }
            case "d2": {
                return MetadataType.d2;
            }
            case "xi": {
                return MetadataType.xi;
            }
            case "xs": {
                return MetadataType.xs;
            }
            case "pn": {
                return MetadataType.pn;
            }
        }
        throw new IllegalArgumentException("Unknown Kotlin metadata field '" + name + "'");
    }

    static {
        int[] version = JvmMetadataVersion.INSTANCE.toArray();
        MAX_SUPPORTED_VERSION = new KotlinMetadataVersion(version[0], version[1] + 1);
    }

    private static class SimpleKotlinMetadataSetter
    implements ClassVisitor {
        private final KotlinMetadata kmd;

        SimpleKotlinMetadataSetter(KotlinMetadata kmd) {
            this.kmd = kmd;
        }

        @Override
        public void visitAnyClass(Clazz clazz) {
            throw new UnsupportedOperationException(this.getClass().getName() + " does not support " + clazz.getClass().getName());
        }

        @Override
        public void visitProgramClass(ProgramClass programClass) {
            programClass.kotlinMetadata = this.kmd;
        }

        @Override
        public void visitLibraryClass(LibraryClass libraryClass) {
            libraryClass.kotlinMetadata = this.kmd;
        }
    }

    public static enum MetadataType {
        k,
        mv,
        d1,
        d2,
        xi,
        xs,
        pn,
        bv;

    }

    private class ArrayElementValueCollector
    implements ElementValueVisitor,
    ConstantVisitor {
        private final MetadataType arrayType;
        private int index;

        ArrayElementValueCollector(MetadataType array) {
            this.arrayType = array;
            this.index = 0;
        }

        @Override
        public void visitConstantElementValue(Clazz clazz, Annotation annotation, ConstantElementValue constantElementValue) {
            clazz.constantPoolEntryAccept(constantElementValue.u2constantValueIndex, this);
        }

        @Override
        public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
            if (this.arrayType == MetadataType.d1) {
                ((KotlinMetadataInitializer)KotlinMetadataInitializer.this).d1[this.index++] = utf8Constant.getString();
            } else if (this.arrayType == MetadataType.d2) {
                ((KotlinMetadataInitializer)KotlinMetadataInitializer.this).d2[this.index++] = utf8Constant.getString();
            } else {
                throw new UnsupportedOperationException("Cannot store UTF8Constant in int[]");
            }
        }

        @Override
        public void visitIntegerConstant(Clazz clazz, IntegerConstant integerConstant) {
            if (this.arrayType == MetadataType.mv) {
                ((KotlinMetadataInitializer)KotlinMetadataInitializer.this).mv[this.index++] = integerConstant.getValue();
            } else if (this.arrayType != MetadataType.bv) {
                throw new UnsupportedOperationException("Cannot store IntegerConstant in String[]");
            }
        }
    }
}

