/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.visitor.ClassVisitor;

public class ClassProcessingFlagFilter
implements ClassVisitor {
    private final int requiredSetProcessingFlags;
    private final int requiredUnsetProcessingFlags;
    private final ClassVisitor classVisitor;

    public ClassProcessingFlagFilter(int requiredSetProcessingFlags, int requiredUnsetProcessingFlags, ClassVisitor classVisitor) {
        this.requiredSetProcessingFlags = requiredSetProcessingFlags;
        this.requiredUnsetProcessingFlags = requiredUnsetProcessingFlags;
        this.classVisitor = classVisitor;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
        if (this.accepted(clazz.getProcessingFlags())) {
            clazz.accept(this.classVisitor);
        }
    }

    private boolean accepted(int processingFlags) {
        return (this.requiredSetProcessingFlags & ~processingFlags) == 0 && (this.requiredUnsetProcessingFlags & processingFlags) == 0;
    }
}

