/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.gson;

import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.InnerClassesInfo;
import proguard.classfile.attribute.visitor.AllInnerClassesInfoVisitor;
import proguard.classfile.attribute.visitor.InnerClassesInfoVisitor;
import proguard.classfile.visitor.ClassVisitor;

class LocalOrAnonymousClassChecker
implements ClassVisitor,
InnerClassesInfoVisitor {
    private boolean localOrAnonymous;

    LocalOrAnonymousClassChecker() {
    }

    public boolean isLocalOrAnonymous() {
        return this.localOrAnonymous;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        this.localOrAnonymous = false;
        programClass.attributesAccept(new AllInnerClassesInfoVisitor(this));
    }

    @Override
    public void visitInnerClassesInfo(Clazz clazz, InnerClassesInfo innerClassesInfo) {
        if (innerClassesInfo.u2innerClassIndex == ((ProgramClass)clazz).u2thisClass) {
            this.localOrAnonymous = innerClassesInfo.u2outerClassIndex == 0 || innerClassesInfo.u2innerNameIndex == 0;
        }
    }
}

