/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include <sbkpython.h>
#include <shiboken.h>
#include <algorithm>
#include <signature.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
#include "pyside2_qt3danimation_python.h"



// Extra includes

// Current module's type array.
PyTypeObject **SbkPySide2_Qt3DAnimationTypes = nullptr;
// Current module's PyObject pointer.
PyObject *SbkPySide2_Qt3DAnimationModuleObject = nullptr;
// Current module's converter array.
SbkConverter **SbkPySide2_Qt3DAnimationTypeConverters = nullptr;
void cleanTypesAttributes(void) {
    if (PY_VERSION_HEX >= 0x03000000 && PY_VERSION_HEX < 0x03060000)
        return; // PYSIDE-953: testbinding crashes in Python 3.5 when hasattr touches types!
    for (int i = 0, imax = SBK_Qt3DAnimation_IDX_COUNT; i < imax; i++) {
        PyObject *pyType = reinterpret_cast<PyObject *>(SbkPySide2_Qt3DAnimationTypes[i]);
        Shiboken::AutoDecRef attrName(Py_BuildValue("s", "staticMetaObject"));
        if (pyType && PyObject_HasAttr(pyType, attrName))
            PyObject_SetAttr(pyType, attrName, Py_None);
    }
}
// Global functions ------------------------------------------------------------

static PyMethodDef Qt3DAnimation_methods[] = {
    {0} // Sentinel
};

// Classes initialization functions ------------------------------------------------------------
void init_Qt3DAnimationQt3DAnimation(PyObject *module);
void init_Qt3DAnimation_QMorphTarget(PyObject *enclosingClass);
void init_Qt3DAnimation_QKeyFrame(PyObject *enclosingClass);
void init_Qt3DAnimation_QClock(PyObject *enclosingClass);
void init_Qt3DAnimation_QAnimationGroup(PyObject *enclosingClass);
void init_Qt3DAnimation_QAnimationController(PyObject *enclosingClass);
void init_Qt3DAnimation_QAnimationCallback(PyObject *enclosingClass);
void init_Qt3DAnimation_QAnimationAspect(PyObject *enclosingClass);
void init_Qt3DAnimation_QAbstractClipBlendNode(PyObject *enclosingClass);
void init_Qt3DAnimation_QAdditiveClipBlend(PyObject *enclosingClass);
void init_Qt3DAnimation_QLerpClipBlend(PyObject *enclosingClass);
void init_Qt3DAnimation_QAbstractClipAnimator(PyObject *enclosingClass);
void init_Qt3DAnimation_QClipAnimator(PyObject *enclosingClass);
void init_Qt3DAnimation_QBlendedClipAnimator(PyObject *enclosingClass);
void init_Qt3DAnimation_QAbstractChannelMapping(PyObject *enclosingClass);
void init_Qt3DAnimation_QSkeletonMapping(PyObject *enclosingClass);
void init_Qt3DAnimation_QAbstractAnimationClip(PyObject *enclosingClass);
void init_Qt3DAnimation_QAnimationClipLoader(PyObject *enclosingClass);
void init_Qt3DAnimation_QAnimationClip(PyObject *enclosingClass);
void init_Qt3DAnimation_QAbstractAnimation(PyObject *enclosingClass);
void init_Qt3DAnimation_QVertexBlendAnimation(PyObject *enclosingClass);
void init_Qt3DAnimation_QMorphingAnimation(PyObject *enclosingClass);
void init_Qt3DAnimation_QKeyframeAnimation(PyObject *enclosingClass);

// Required modules' type and converter arrays.
PyTypeObject **SbkPySide2_Qt3DRenderTypes;
SbkConverter **SbkPySide2_Qt3DRenderTypeConverters;
PyTypeObject **SbkPySide2_Qt3DCoreTypes;
SbkConverter **SbkPySide2_Qt3DCoreTypeConverters;
PyTypeObject **SbkPySide2_QtGuiTypes;
SbkConverter **SbkPySide2_QtGuiTypeConverters;
PyTypeObject **SbkPySide2_QtCoreTypes;
SbkConverter **SbkPySide2_QtCoreTypeConverters;

// Module initialization ------------------------------------------------------------
// Container Type converters.

// C++ to Python conversion for type 'QVector<Qt3DRender::QAttribute* >'.
static PyObject *_QVector_Qt3DRender_QAttributePTR__CppToPython__QVector_Qt3DRender_QAttributePTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<Qt3DRender::QAttribute* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<Qt3DRender::QAttribute* >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<Qt3DRender::QAttribute* >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::Qt3DRender::QAttribute* cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_Qt3DRender_QAttributePTR__PythonToCpp__QVector_Qt3DRender_QAttributePTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<Qt3DRender::QAttribute* > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::Qt3DRender::QAttribute* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_Qt3DRender_QAttributePTR__PythonToCpp__QVector_Qt3DRender_QAttributePTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QATTRIBUTE_IDX], pyIn))
        return _QVector_Qt3DRender_QAttributePTR__PythonToCpp__QVector_Qt3DRender_QAttributePTR_;
    return {};
}

// C++ to Python conversion for type 'const QList<QObject* > &'.
static PyObject *_constQList_QObjectPTR_REF_CppToPython__constQList_QObjectPTR_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QObject* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QObject* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QObject* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QObject* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QObject* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX], pyIn))
        return _constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QByteArray >'.
static PyObject *_QList_QByteArray__CppToPython__QList_QByteArray_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QByteArray > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QByteArray >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QByteArray cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QByteArray__PythonToCpp__QList_QByteArray_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QByteArray > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QByteArray cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QByteArray__PythonToCpp__QList_QByteArray__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pyIn))
        return _QList_QByteArray__PythonToCpp__QList_QByteArray_;
    return {};
}

// C++ to Python conversion for type 'QVector<Qt3DCore::QNode* >'.
static PyObject *_QVector_Qt3DCore_QNodePTR__CppToPython__QVector_Qt3DCore_QNodePTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<Qt3DCore::QNode* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<Qt3DCore::QNode* >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<Qt3DCore::QNode* >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::Qt3DCore::QNode* cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_Qt3DCore_QNodePTR__PythonToCpp__QVector_Qt3DCore_QNodePTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<Qt3DCore::QNode* > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::Qt3DCore::QNode* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_Qt3DCore_QNodePTR__PythonToCpp__QVector_Qt3DCore_QNodePTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX], pyIn))
        return _QVector_Qt3DCore_QNodePTR__PythonToCpp__QVector_Qt3DCore_QNodePTR_;
    return {};
}

// C++ to Python conversion for type 'QVector<Qt3DAnimation::QAnimationGroup* >'.
static PyObject *_QVector_Qt3DAnimation_QAnimationGroupPTR__CppToPython__QVector_Qt3DAnimation_QAnimationGroupPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<Qt3DAnimation::QAnimationGroup* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<Qt3DAnimation::QAnimationGroup* >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<Qt3DAnimation::QAnimationGroup* >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::Qt3DAnimation::QAnimationGroup* cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QANIMATIONGROUP_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_Qt3DAnimation_QAnimationGroupPTR__PythonToCpp__QVector_Qt3DAnimation_QAnimationGroupPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<Qt3DAnimation::QAnimationGroup* > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::Qt3DAnimation::QAnimationGroup* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QANIMATIONGROUP_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_Qt3DAnimation_QAnimationGroupPTR__PythonToCpp__QVector_Qt3DAnimation_QAnimationGroupPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QANIMATIONGROUP_IDX], pyIn))
        return _QVector_Qt3DAnimation_QAnimationGroupPTR__PythonToCpp__QVector_Qt3DAnimation_QAnimationGroupPTR_;
    return {};
}

// C++ to Python conversion for type 'QVector<Qt3DAnimation::QAbstractAnimation* >'.
static PyObject *_QVector_Qt3DAnimation_QAbstractAnimationPTR__CppToPython__QVector_Qt3DAnimation_QAbstractAnimationPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<Qt3DAnimation::QAbstractAnimation* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<Qt3DAnimation::QAbstractAnimation* >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<Qt3DAnimation::QAbstractAnimation* >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::Qt3DAnimation::QAbstractAnimation* cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QABSTRACTANIMATION_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_Qt3DAnimation_QAbstractAnimationPTR__PythonToCpp__QVector_Qt3DAnimation_QAbstractAnimationPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<Qt3DAnimation::QAbstractAnimation* > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::Qt3DAnimation::QAbstractAnimation* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QABSTRACTANIMATION_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_Qt3DAnimation_QAbstractAnimationPTR__PythonToCpp__QVector_Qt3DAnimation_QAbstractAnimationPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QABSTRACTANIMATION_IDX], pyIn))
        return _QVector_Qt3DAnimation_QAbstractAnimationPTR__PythonToCpp__QVector_Qt3DAnimation_QAbstractAnimationPTR_;
    return {};
}

// C++ to Python conversion for type 'QVector<Qt3DCore::QEntity* >'.
static PyObject *_QVector_Qt3DCore_QEntityPTR__CppToPython__QVector_Qt3DCore_QEntityPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<Qt3DCore::QEntity* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<Qt3DCore::QEntity* >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<Qt3DCore::QEntity* >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::Qt3DCore::QEntity* cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QENTITY_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_Qt3DCore_QEntityPTR__PythonToCpp__QVector_Qt3DCore_QEntityPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<Qt3DCore::QEntity* > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::Qt3DCore::QEntity* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QENTITY_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_Qt3DCore_QEntityPTR__PythonToCpp__QVector_Qt3DCore_QEntityPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QENTITY_IDX], pyIn))
        return _QVector_Qt3DCore_QEntityPTR__PythonToCpp__QVector_Qt3DCore_QEntityPTR_;
    return {};
}

// C++ to Python conversion for type 'QVector<float >'.
static PyObject *_QVector_float__CppToPython__QVector_float_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<float > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<float >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<float >::size_type idx = 0; idx < vectorSize; ++idx) {
        float cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_float__PythonToCpp__QVector_float_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<float > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        float cppItem;
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<float>(), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_float__PythonToCpp__QVector_float__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Conversions::PrimitiveTypeConverter<float>(), pyIn))
        return _QVector_float__PythonToCpp__QVector_float_;
    return {};
}

// C++ to Python conversion for type 'QVector<Qt3DCore::QTransform* >'.
static PyObject *_QVector_Qt3DCore_QTransformPTR__CppToPython__QVector_Qt3DCore_QTransformPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<Qt3DCore::QTransform* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<Qt3DCore::QTransform* >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<Qt3DCore::QTransform* >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::Qt3DCore::QTransform* cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QTRANSFORM_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_Qt3DCore_QTransformPTR__PythonToCpp__QVector_Qt3DCore_QTransformPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<Qt3DCore::QTransform* > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::Qt3DCore::QTransform* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QTRANSFORM_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_Qt3DCore_QTransformPTR__PythonToCpp__QVector_Qt3DCore_QTransformPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QTRANSFORM_IDX], pyIn))
        return _QVector_Qt3DCore_QTransformPTR__PythonToCpp__QVector_Qt3DCore_QTransformPTR_;
    return {};
}

// C++ to Python conversion for type 'QVector<Qt3DAnimation::QMorphTarget* >'.
static PyObject *_QVector_Qt3DAnimation_QMorphTargetPTR__CppToPython__QVector_Qt3DAnimation_QMorphTargetPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<Qt3DAnimation::QMorphTarget* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<Qt3DAnimation::QMorphTarget* >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<Qt3DAnimation::QMorphTarget* >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::Qt3DAnimation::QMorphTarget* cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QMORPHTARGET_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_Qt3DAnimation_QMorphTargetPTR__PythonToCpp__QVector_Qt3DAnimation_QMorphTargetPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<Qt3DAnimation::QMorphTarget* > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::Qt3DAnimation::QMorphTarget* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QMORPHTARGET_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_Qt3DAnimation_QMorphTargetPTR__PythonToCpp__QVector_Qt3DAnimation_QMorphTargetPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QMORPHTARGET_IDX], pyIn))
        return _QVector_Qt3DAnimation_QMorphTargetPTR__PythonToCpp__QVector_Qt3DAnimation_QMorphTargetPTR_;
    return {};
}

// C++ to Python conversion for type 'QList<QVariant >'.
static PyObject *_QList_QVariant__CppToPython__QList_QVariant_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QVariant > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QVariant >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QVariant cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QVariant__PythonToCpp__QList_QVariant_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QVariant > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QVariant cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QVariant__PythonToCpp__QList_QVariant__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyIn))
        return _QList_QVariant__PythonToCpp__QList_QVariant_;
    return {};
}

// C++ to Python conversion for type 'QList<QString >'.
static PyObject *_QList_QString__CppToPython__QList_QString_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QString > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QString >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QString cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QString__PythonToCpp__QList_QString_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QString > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QString cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QString__PythonToCpp__QList_QString__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyIn))
        return _QList_QString__PythonToCpp__QList_QString_;
    return {};
}

// C++ to Python conversion for type 'QMap<QString,QVariant >'.
static PyObject *_QMap_QString_QVariant__CppToPython__QMap_QString_QVariant_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QMap<QString,QVariant > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppmap_to_pymap_conversion - START
    PyObject *pyOut = PyDict_New();
    for (::QMap<QString,QVariant >::const_iterator it = cppInRef.begin(), end = cppInRef.end(); it != end; ++it) {
        ::QString key = it.key();
        ::QVariant value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - cppmap_to_pymap_conversion - END

}
static void _QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QMap<QString,QVariant > *>(cppOut);
    // TEMPLATE - pydict_to_cppmap_conversion - START
    PyObject *key;
    PyObject *value;
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QString cppKey;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], key, &(cppKey));
        ::QVariant cppValue;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - pydict_to_cppmap_conversion - END

}
static PythonToCppFunc is__QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleDictTypes(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], false, SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], false, pyIn))
        return _QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant_;
    return {};
}


#ifdef IS_PY3K
static struct PyModuleDef moduledef = {
    /* m_base     */ PyModuleDef_HEAD_INIT,
    /* m_name     */ "Qt3DAnimation",
    /* m_doc      */ nullptr,
    /* m_size     */ -1,
    /* m_methods  */ Qt3DAnimation_methods,
    /* m_reload   */ nullptr,
    /* m_traverse */ nullptr,
    /* m_clear    */ nullptr,
    /* m_free     */ nullptr
};

#endif

// The signatures string for the global functions.
// Multiple signatures have their index "n:" in front.
static const char *Qt3DAnimation_SignatureStrings[] = {
    nullptr}; // Sentinel

SBK_MODULE_INIT_FUNCTION_BEGIN(Qt3DAnimation)
    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide2.Qt3DRender"));
        if (requiredModule.isNull())
            return SBK_MODULE_INIT_ERROR;
        SbkPySide2_Qt3DRenderTypes = Shiboken::Module::getTypes(requiredModule);
        SbkPySide2_Qt3DRenderTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide2.Qt3DCore"));
        if (requiredModule.isNull())
            return SBK_MODULE_INIT_ERROR;
        SbkPySide2_Qt3DCoreTypes = Shiboken::Module::getTypes(requiredModule);
        SbkPySide2_Qt3DCoreTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide2.QtGui"));
        if (requiredModule.isNull())
            return SBK_MODULE_INIT_ERROR;
        SbkPySide2_QtGuiTypes = Shiboken::Module::getTypes(requiredModule);
        SbkPySide2_QtGuiTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide2.QtCore"));
        if (requiredModule.isNull())
            return SBK_MODULE_INIT_ERROR;
        SbkPySide2_QtCoreTypes = Shiboken::Module::getTypes(requiredModule);
        SbkPySide2_QtCoreTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    // Create an array of wrapper types for the current module.
    static PyTypeObject *cppApi[SBK_Qt3DAnimation_IDX_COUNT];
    SbkPySide2_Qt3DAnimationTypes = cppApi;

    // Create an array of primitive type converters for the current module.
    static SbkConverter *sbkConverters[SBK_Qt3DAnimation_CONVERTERS_IDX_COUNT];
    SbkPySide2_Qt3DAnimationTypeConverters = sbkConverters;

#ifdef IS_PY3K
    PyObject *module = Shiboken::Module::create("Qt3DAnimation", &moduledef);
#else
    PyObject *module = Shiboken::Module::create("Qt3DAnimation", Qt3DAnimation_methods);
#endif

    // Make module available from global scope
    SbkPySide2_Qt3DAnimationModuleObject = module;

    // Initialize classes in the type system
    init_Qt3DAnimationQt3DAnimation(module);
    init_Qt3DAnimation_QMorphTarget(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DAnimationTypes[SBK_Qt3DAnimationQT3DANIMATION_IDX])->tp_dict);
    init_Qt3DAnimation_QKeyFrame(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DAnimationTypes[SBK_Qt3DAnimationQT3DANIMATION_IDX])->tp_dict);
    init_Qt3DAnimation_QClock(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DAnimationTypes[SBK_Qt3DAnimationQT3DANIMATION_IDX])->tp_dict);
    init_Qt3DAnimation_QAnimationGroup(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DAnimationTypes[SBK_Qt3DAnimationQT3DANIMATION_IDX])->tp_dict);
    init_Qt3DAnimation_QAnimationController(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DAnimationTypes[SBK_Qt3DAnimationQT3DANIMATION_IDX])->tp_dict);
    init_Qt3DAnimation_QAnimationCallback(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DAnimationTypes[SBK_Qt3DAnimationQT3DANIMATION_IDX])->tp_dict);
    init_Qt3DAnimation_QAnimationAspect(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DAnimationTypes[SBK_Qt3DAnimationQT3DANIMATION_IDX])->tp_dict);
    init_Qt3DAnimation_QAbstractClipBlendNode(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DAnimationTypes[SBK_Qt3DAnimationQT3DANIMATION_IDX])->tp_dict);
    init_Qt3DAnimation_QAdditiveClipBlend(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DAnimationTypes[SBK_Qt3DAnimationQT3DANIMATION_IDX])->tp_dict);
    init_Qt3DAnimation_QLerpClipBlend(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DAnimationTypes[SBK_Qt3DAnimationQT3DANIMATION_IDX])->tp_dict);
    init_Qt3DAnimation_QAbstractClipAnimator(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DAnimationTypes[SBK_Qt3DAnimationQT3DANIMATION_IDX])->tp_dict);
    init_Qt3DAnimation_QClipAnimator(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DAnimationTypes[SBK_Qt3DAnimationQT3DANIMATION_IDX])->tp_dict);
    init_Qt3DAnimation_QBlendedClipAnimator(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DAnimationTypes[SBK_Qt3DAnimationQT3DANIMATION_IDX])->tp_dict);
    init_Qt3DAnimation_QAbstractChannelMapping(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DAnimationTypes[SBK_Qt3DAnimationQT3DANIMATION_IDX])->tp_dict);
    init_Qt3DAnimation_QSkeletonMapping(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DAnimationTypes[SBK_Qt3DAnimationQT3DANIMATION_IDX])->tp_dict);
    init_Qt3DAnimation_QAbstractAnimationClip(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DAnimationTypes[SBK_Qt3DAnimationQT3DANIMATION_IDX])->tp_dict);
    init_Qt3DAnimation_QAnimationClipLoader(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DAnimationTypes[SBK_Qt3DAnimationQT3DANIMATION_IDX])->tp_dict);
    init_Qt3DAnimation_QAnimationClip(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DAnimationTypes[SBK_Qt3DAnimationQT3DANIMATION_IDX])->tp_dict);
    init_Qt3DAnimation_QAbstractAnimation(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DAnimationTypes[SBK_Qt3DAnimationQT3DANIMATION_IDX])->tp_dict);
    init_Qt3DAnimation_QVertexBlendAnimation(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DAnimationTypes[SBK_Qt3DAnimationQT3DANIMATION_IDX])->tp_dict);
    init_Qt3DAnimation_QMorphingAnimation(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DAnimationTypes[SBK_Qt3DAnimationQT3DANIMATION_IDX])->tp_dict);
    init_Qt3DAnimation_QKeyframeAnimation(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DAnimationTypes[SBK_Qt3DAnimationQT3DANIMATION_IDX])->tp_dict);

    // Register converter for type 'QVector<Qt3DRender::QAttribute*>'.
    SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QVECTOR_QT3DRENDER_QATTRIBUTEPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_Qt3DRender_QAttributePTR__CppToPython__QVector_Qt3DRender_QAttributePTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QVECTOR_QT3DRENDER_QATTRIBUTEPTR_IDX], "QVector<Qt3DRender::QAttribute*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QVECTOR_QT3DRENDER_QATTRIBUTEPTR_IDX],
        _QVector_Qt3DRender_QAttributePTR__PythonToCpp__QVector_Qt3DRender_QAttributePTR_,
        is__QVector_Qt3DRender_QAttributePTR__PythonToCpp__QVector_Qt3DRender_QAttributePTR__Convertible);

    // Register converter for type 'const QList<QObject*>&'.
    SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QLIST_QOBJECTPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QObjectPTR_REF_CppToPython__constQList_QObjectPTR_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QLIST_QOBJECTPTR_IDX], "const QList<QObject*>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QLIST_QOBJECTPTR_IDX], "QList<QObject*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QLIST_QOBJECTPTR_IDX],
        _constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF,
        is__constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF_Convertible);

    // Register converter for type 'QList<QByteArray>'.
    SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QLIST_QBYTEARRAY_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QByteArray__CppToPython__QList_QByteArray_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QLIST_QBYTEARRAY_IDX], "QList<QByteArray>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QLIST_QBYTEARRAY_IDX],
        _QList_QByteArray__PythonToCpp__QList_QByteArray_,
        is__QList_QByteArray__PythonToCpp__QList_QByteArray__Convertible);

    // Register converter for type 'QVector<Qt3DCore::QNode*>'.
    SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QVECTOR_QT3DCORE_QNODEPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_Qt3DCore_QNodePTR__CppToPython__QVector_Qt3DCore_QNodePTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QVECTOR_QT3DCORE_QNODEPTR_IDX], "QVector<Qt3DCore::QNode*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QVECTOR_QT3DCORE_QNODEPTR_IDX],
        _QVector_Qt3DCore_QNodePTR__PythonToCpp__QVector_Qt3DCore_QNodePTR_,
        is__QVector_Qt3DCore_QNodePTR__PythonToCpp__QVector_Qt3DCore_QNodePTR__Convertible);

    // Register converter for type 'QVector<Qt3DAnimation::QAnimationGroup*>'.
    SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QVECTOR_QT3DANIMATION_QANIMATIONGROUPPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_Qt3DAnimation_QAnimationGroupPTR__CppToPython__QVector_Qt3DAnimation_QAnimationGroupPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QVECTOR_QT3DANIMATION_QANIMATIONGROUPPTR_IDX], "QVector<Qt3DAnimation::QAnimationGroup*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QVECTOR_QT3DANIMATION_QANIMATIONGROUPPTR_IDX],
        _QVector_Qt3DAnimation_QAnimationGroupPTR__PythonToCpp__QVector_Qt3DAnimation_QAnimationGroupPTR_,
        is__QVector_Qt3DAnimation_QAnimationGroupPTR__PythonToCpp__QVector_Qt3DAnimation_QAnimationGroupPTR__Convertible);

    // Register converter for type 'QVector<Qt3DAnimation::QAbstractAnimation*>'.
    SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QVECTOR_QT3DANIMATION_QABSTRACTANIMATIONPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_Qt3DAnimation_QAbstractAnimationPTR__CppToPython__QVector_Qt3DAnimation_QAbstractAnimationPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QVECTOR_QT3DANIMATION_QABSTRACTANIMATIONPTR_IDX], "QVector<Qt3DAnimation::QAbstractAnimation*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QVECTOR_QT3DANIMATION_QABSTRACTANIMATIONPTR_IDX],
        _QVector_Qt3DAnimation_QAbstractAnimationPTR__PythonToCpp__QVector_Qt3DAnimation_QAbstractAnimationPTR_,
        is__QVector_Qt3DAnimation_QAbstractAnimationPTR__PythonToCpp__QVector_Qt3DAnimation_QAbstractAnimationPTR__Convertible);

    // Register converter for type 'QVector<Qt3DCore::QEntity*>'.
    SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QVECTOR_QT3DCORE_QENTITYPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_Qt3DCore_QEntityPTR__CppToPython__QVector_Qt3DCore_QEntityPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QVECTOR_QT3DCORE_QENTITYPTR_IDX], "QVector<Qt3DCore::QEntity*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QVECTOR_QT3DCORE_QENTITYPTR_IDX],
        _QVector_Qt3DCore_QEntityPTR__PythonToCpp__QVector_Qt3DCore_QEntityPTR_,
        is__QVector_Qt3DCore_QEntityPTR__PythonToCpp__QVector_Qt3DCore_QEntityPTR__Convertible);

    // Register converter for type 'QVector<float>'.
    SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QVECTOR_FLOAT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_float__CppToPython__QVector_float_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QVECTOR_FLOAT_IDX], "QVector<float>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QVECTOR_FLOAT_IDX],
        _QVector_float__PythonToCpp__QVector_float_,
        is__QVector_float__PythonToCpp__QVector_float__Convertible);

    // Register converter for type 'QVector<Qt3DCore::QTransform*>'.
    SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QVECTOR_QT3DCORE_QTRANSFORMPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_Qt3DCore_QTransformPTR__CppToPython__QVector_Qt3DCore_QTransformPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QVECTOR_QT3DCORE_QTRANSFORMPTR_IDX], "QVector<Qt3DCore::QTransform*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QVECTOR_QT3DCORE_QTRANSFORMPTR_IDX],
        _QVector_Qt3DCore_QTransformPTR__PythonToCpp__QVector_Qt3DCore_QTransformPTR_,
        is__QVector_Qt3DCore_QTransformPTR__PythonToCpp__QVector_Qt3DCore_QTransformPTR__Convertible);

    // Register converter for type 'QVector<Qt3DAnimation::QMorphTarget*>'.
    SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QVECTOR_QT3DANIMATION_QMORPHTARGETPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_Qt3DAnimation_QMorphTargetPTR__CppToPython__QVector_Qt3DAnimation_QMorphTargetPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QVECTOR_QT3DANIMATION_QMORPHTARGETPTR_IDX], "QVector<Qt3DAnimation::QMorphTarget*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QVECTOR_QT3DANIMATION_QMORPHTARGETPTR_IDX],
        _QVector_Qt3DAnimation_QMorphTargetPTR__PythonToCpp__QVector_Qt3DAnimation_QMorphTargetPTR_,
        is__QVector_Qt3DAnimation_QMorphTargetPTR__PythonToCpp__QVector_Qt3DAnimation_QMorphTargetPTR__Convertible);

    // Register converter for type 'QList<QVariant>'.
    SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QLIST_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QVariant__CppToPython__QList_QVariant_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QLIST_QVARIANT_IDX], "QList<QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QLIST_QVARIANT_IDX],
        _QList_QVariant__PythonToCpp__QList_QVariant_,
        is__QList_QVariant__PythonToCpp__QList_QVariant__Convertible);

    // Register converter for type 'QList<QString>'.
    SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QLIST_QSTRING_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QString__CppToPython__QList_QString_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QLIST_QSTRING_IDX], "QList<QString>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QLIST_QSTRING_IDX],
        _QList_QString__PythonToCpp__QList_QString_,
        is__QList_QString__PythonToCpp__QList_QString__Convertible);

    // Register converter for type 'QMap<QString,QVariant>'.
    SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QMAP_QSTRING_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QMap_QString_QVariant__CppToPython__QMap_QString_QVariant_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QMAP_QSTRING_QVARIANT_IDX], "QMap<QString,QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QMAP_QSTRING_QVARIANT_IDX],
        _QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant_,
        is__QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant__Convertible);

    // Register primitive types converters.

    Shiboken::Module::registerTypes(module, SbkPySide2_Qt3DAnimationTypes);
    Shiboken::Module::registerTypeConverters(module, SbkPySide2_Qt3DAnimationTypeConverters);

    if (PyErr_Occurred()) {
        PyErr_Print();
        Py_FatalError("can't initialize module Qt3DAnimation");
    }
    PySide::registerCleanupFunction(cleanTypesAttributes);

    FinishSignatureInitialization(module, Qt3DAnimation_SignatureStrings);

SBK_MODULE_INIT_FUNCTION_END
