/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include <sbkpython.h>
#include <shiboken.h>
#include <algorithm>
#include <signature.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
#include "pyside2_qt3dcore_python.h"



// Extra includes

// Current module's type array.
PyTypeObject **SbkPySide2_Qt3DCoreTypes = nullptr;
// Current module's PyObject pointer.
PyObject *SbkPySide2_Qt3DCoreModuleObject = nullptr;
// Current module's converter array.
SbkConverter **SbkPySide2_Qt3DCoreTypeConverters = nullptr;
void cleanTypesAttributes(void) {
    if (PY_VERSION_HEX >= 0x03000000 && PY_VERSION_HEX < 0x03060000)
        return; // PYSIDE-953: testbinding crashes in Python 3.5 when hasattr touches types!
    for (int i = 0, imax = SBK_Qt3DCore_IDX_COUNT; i < imax; i++) {
        PyObject *pyType = reinterpret_cast<PyObject *>(SbkPySide2_Qt3DCoreTypes[i]);
        Shiboken::AutoDecRef attrName(Py_BuildValue("s", "staticMetaObject"));
        if (pyType && PyObject_HasAttr(pyType, attrName))
            PyObject_SetAttr(pyType, attrName, Py_None);
    }
}
// Global functions ------------------------------------------------------------

static PyMethodDef Qt3DCore_methods[] = {
    {0} // Sentinel
};

// Classes initialization functions ------------------------------------------------------------
void init_Qt3DCoreQt3DCore(PyObject *module);
void init_Qt3DCore_QSceneChange(PyObject *enclosingClass);
void init_Qt3DCore_QPropertyValueRemovedChangeBase(PyObject *enclosingClass);
void init_Qt3DCore_QStaticPropertyValueRemovedChangeBase(PyObject *enclosingClass);
void init_Qt3DCore_QPropertyValueRemovedChange(PyObject *enclosingClass);
void init_Qt3DCore_QPropertyValueAddedChangeBase(PyObject *enclosingClass);
void init_Qt3DCore_QStaticPropertyValueAddedChangeBase(PyObject *enclosingClass);
void init_Qt3DCore_QPropertyValueAddedChange(PyObject *enclosingClass);
void init_Qt3DCore_QPropertyUpdatedChangeBase(PyObject *enclosingClass);
void init_Qt3DCore_QStaticPropertyUpdatedChangeBase(PyObject *enclosingClass);
void init_Qt3DCore_QPropertyUpdatedChange(PyObject *enclosingClass);
void init_Qt3DCore_QPropertyNodeRemovedChange(PyObject *enclosingClass);
void init_Qt3DCore_QPropertyNodeAddedChange(PyObject *enclosingClass);
void init_Qt3DCore_QNodeId(PyObject *enclosingClass);
void init_Qt3DCore_QNodeIdTypePair(PyObject *enclosingClass);
void init_Qt3DCore_QNodeDestroyedChange(PyObject *enclosingClass);
void init_Qt3DCore_QNodeCreatedChangeBase(PyObject *enclosingClass);
void init_Qt3DCore_QNodeCommand(PyObject *enclosingClass);
void init_Qt3DCore_QNode(PyObject *enclosingClass);
void init_Qt3DCore_QJoint(PyObject *enclosingClass);
void init_Qt3DCore_QEntity(PyObject *enclosingClass);
void init_Qt3DCore_QDynamicPropertyUpdatedChange(PyObject *enclosingClass);
void init_Qt3DCore_QComponentRemovedChange(PyObject *enclosingClass);
void init_Qt3DCore_QComponentAddedChange(PyObject *enclosingClass);
void init_Qt3DCore_QComponent(PyObject *enclosingClass);
void init_Qt3DCore_QTransform(PyObject *enclosingClass);
void init_Qt3DCore_QBackendNode(PyObject *enclosingClass);
void init_Qt3DCore_QAspectJob(PyObject *enclosingClass);
void init_Qt3DCore_QAspectEngine(PyObject *enclosingClass);
void init_Qt3DCore_QArmature(PyObject *enclosingClass);
void init_Qt3DCore_QAbstractSkeleton(PyObject *enclosingClass);
void init_Qt3DCore_QSkeletonLoader(PyObject *enclosingClass);
void init_Qt3DCore_QSkeleton(PyObject *enclosingClass);
void init_Qt3DCore_QAbstractAspect(PyObject *enclosingClass);

// Required modules' type and converter arrays.
PyTypeObject **SbkPySide2_QtGuiTypes;
SbkConverter **SbkPySide2_QtGuiTypeConverters;
PyTypeObject **SbkPySide2_QtCoreTypes;
SbkConverter **SbkPySide2_QtCoreTypeConverters;

// Module initialization ------------------------------------------------------------
// Container Type converters.

// C++ to Python conversion for type 'QVector<Qt3DCore::QAbstractAspect* >'.
static PyObject *_QVector_Qt3DCore_QAbstractAspectPTR__CppToPython__QVector_Qt3DCore_QAbstractAspectPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<Qt3DCore::QAbstractAspect* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<Qt3DCore::QAbstractAspect* >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<Qt3DCore::QAbstractAspect* >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::Qt3DCore::QAbstractAspect* cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QABSTRACTASPECT_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_Qt3DCore_QAbstractAspectPTR__PythonToCpp__QVector_Qt3DCore_QAbstractAspectPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<Qt3DCore::QAbstractAspect* > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::Qt3DCore::QAbstractAspect* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QABSTRACTASPECT_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_Qt3DCore_QAbstractAspectPTR__PythonToCpp__QVector_Qt3DCore_QAbstractAspectPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QABSTRACTASPECT_IDX], pyIn))
        return _QVector_Qt3DCore_QAbstractAspectPTR__PythonToCpp__QVector_Qt3DCore_QAbstractAspectPTR_;
    return {};
}

// C++ to Python conversion for type 'const QList<QObject* > &'.
static PyObject *_constQList_QObjectPTR_REF_CppToPython__constQList_QObjectPTR_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QObject* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QObject* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QObject* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QObject* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QObject* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX], pyIn))
        return _constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QByteArray >'.
static PyObject *_QList_QByteArray__CppToPython__QList_QByteArray_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QByteArray > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QByteArray >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QByteArray cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QByteArray__PythonToCpp__QList_QByteArray_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QByteArray > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QByteArray cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QByteArray__PythonToCpp__QList_QByteArray__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pyIn))
        return _QList_QByteArray__PythonToCpp__QList_QByteArray_;
    return {};
}

// C++ to Python conversion for type 'QVector<Qt3DCore::QNode* >'.
static PyObject *_QVector_Qt3DCore_QNodePTR__CppToPython__QVector_Qt3DCore_QNodePTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<Qt3DCore::QNode* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<Qt3DCore::QNode* >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<Qt3DCore::QNode* >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::Qt3DCore::QNode* cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_Qt3DCore_QNodePTR__PythonToCpp__QVector_Qt3DCore_QNodePTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<Qt3DCore::QNode* > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::Qt3DCore::QNode* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_Qt3DCore_QNodePTR__PythonToCpp__QVector_Qt3DCore_QNodePTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX], pyIn))
        return _QVector_Qt3DCore_QNodePTR__PythonToCpp__QVector_Qt3DCore_QNodePTR_;
    return {};
}

// C++ to Python conversion for type 'QVector<Qt3DCore::QEntity* >'.
static PyObject *_QVector_Qt3DCore_QEntityPTR__CppToPython__QVector_Qt3DCore_QEntityPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<Qt3DCore::QEntity* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<Qt3DCore::QEntity* >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<Qt3DCore::QEntity* >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::Qt3DCore::QEntity* cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QENTITY_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_Qt3DCore_QEntityPTR__PythonToCpp__QVector_Qt3DCore_QEntityPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<Qt3DCore::QEntity* > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::Qt3DCore::QEntity* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QENTITY_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_Qt3DCore_QEntityPTR__PythonToCpp__QVector_Qt3DCore_QEntityPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QENTITY_IDX], pyIn))
        return _QVector_Qt3DCore_QEntityPTR__PythonToCpp__QVector_Qt3DCore_QEntityPTR_;
    return {};
}

// C++ to Python conversion for type 'QVector<Qt3DCore::QJoint* >'.
static PyObject *_QVector_Qt3DCore_QJointPTR__CppToPython__QVector_Qt3DCore_QJointPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<Qt3DCore::QJoint* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<Qt3DCore::QJoint* >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<Qt3DCore::QJoint* >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::Qt3DCore::QJoint* cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QJOINT_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_Qt3DCore_QJointPTR__PythonToCpp__QVector_Qt3DCore_QJointPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<Qt3DCore::QJoint* > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::Qt3DCore::QJoint* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QJOINT_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_Qt3DCore_QJointPTR__PythonToCpp__QVector_Qt3DCore_QJointPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QJOINT_IDX], pyIn))
        return _QVector_Qt3DCore_QJointPTR__PythonToCpp__QVector_Qt3DCore_QJointPTR_;
    return {};
}

// C++ to Python conversion for type 'QVector<Qt3DCore::QComponent* >'.
static PyObject *_QVector_Qt3DCore_QComponentPTR__CppToPython__QVector_Qt3DCore_QComponentPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<Qt3DCore::QComponent* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<Qt3DCore::QComponent* >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<Qt3DCore::QComponent* >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::Qt3DCore::QComponent* cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QCOMPONENT_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_Qt3DCore_QComponentPTR__PythonToCpp__QVector_Qt3DCore_QComponentPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<Qt3DCore::QComponent* > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::Qt3DCore::QComponent* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QCOMPONENT_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_Qt3DCore_QComponentPTR__PythonToCpp__QVector_Qt3DCore_QComponentPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QCOMPONENT_IDX], pyIn))
        return _QVector_Qt3DCore_QComponentPTR__PythonToCpp__QVector_Qt3DCore_QComponentPTR_;
    return {};
}

// C++ to Python conversion for type 'const QVector<Qt3DCore::QNodeIdTypePair > &'.
static PyObject *_constQVector_Qt3DCore_QNodeIdTypePair_REF_CppToPython__constQVector_Qt3DCore_QNodeIdTypePair_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<Qt3DCore::QNodeIdTypePair > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<Qt3DCore::QNodeIdTypePair >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<Qt3DCore::QNodeIdTypePair >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::Qt3DCore::QNodeIdTypePair cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODEIDTYPEPAIR_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _constQVector_Qt3DCore_QNodeIdTypePair_REF_PythonToCpp__constQVector_Qt3DCore_QNodeIdTypePair_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<Qt3DCore::QNodeIdTypePair > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::Qt3DCore::QNodeIdTypePair cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODEIDTYPEPAIR_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__constQVector_Qt3DCore_QNodeIdTypePair_REF_PythonToCpp__constQVector_Qt3DCore_QNodeIdTypePair_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODEIDTYPEPAIR_IDX]), pyIn))
        return _constQVector_Qt3DCore_QNodeIdTypePair_REF_PythonToCpp__constQVector_Qt3DCore_QNodeIdTypePair_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QVariant >'.
static PyObject *_QList_QVariant__CppToPython__QList_QVariant_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QVariant > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QVariant >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QVariant cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QVariant__PythonToCpp__QList_QVariant_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QVariant > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QVariant cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QVariant__PythonToCpp__QList_QVariant__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyIn))
        return _QList_QVariant__PythonToCpp__QList_QVariant_;
    return {};
}

// C++ to Python conversion for type 'QList<QString >'.
static PyObject *_QList_QString__CppToPython__QList_QString_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QString > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QString >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QString cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QString__PythonToCpp__QList_QString_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QString > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QString cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QString__PythonToCpp__QList_QString__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyIn))
        return _QList_QString__PythonToCpp__QList_QString_;
    return {};
}

// C++ to Python conversion for type 'QMap<QString,QVariant >'.
static PyObject *_QMap_QString_QVariant__CppToPython__QMap_QString_QVariant_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QMap<QString,QVariant > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppmap_to_pymap_conversion - START
    PyObject *pyOut = PyDict_New();
    for (::QMap<QString,QVariant >::const_iterator it = cppInRef.begin(), end = cppInRef.end(); it != end; ++it) {
        ::QString key = it.key();
        ::QVariant value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - cppmap_to_pymap_conversion - END

}
static void _QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QMap<QString,QVariant > *>(cppOut);
    // TEMPLATE - pydict_to_cppmap_conversion - START
    PyObject *key;
    PyObject *value;
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QString cppKey;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], key, &(cppKey));
        ::QVariant cppValue;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - pydict_to_cppmap_conversion - END

}
static PythonToCppFunc is__QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleDictTypes(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], false, SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], false, pyIn))
        return _QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant_;
    return {};
}


#ifdef IS_PY3K
static struct PyModuleDef moduledef = {
    /* m_base     */ PyModuleDef_HEAD_INIT,
    /* m_name     */ "Qt3DCore",
    /* m_doc      */ nullptr,
    /* m_size     */ -1,
    /* m_methods  */ Qt3DCore_methods,
    /* m_reload   */ nullptr,
    /* m_traverse */ nullptr,
    /* m_clear    */ nullptr,
    /* m_free     */ nullptr
};

#endif

// The signatures string for the global functions.
// Multiple signatures have their index "n:" in front.
static const char *Qt3DCore_SignatureStrings[] = {
    nullptr}; // Sentinel

SBK_MODULE_INIT_FUNCTION_BEGIN(Qt3DCore)
    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide2.QtGui"));
        if (requiredModule.isNull())
            return SBK_MODULE_INIT_ERROR;
        SbkPySide2_QtGuiTypes = Shiboken::Module::getTypes(requiredModule);
        SbkPySide2_QtGuiTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide2.QtCore"));
        if (requiredModule.isNull())
            return SBK_MODULE_INIT_ERROR;
        SbkPySide2_QtCoreTypes = Shiboken::Module::getTypes(requiredModule);
        SbkPySide2_QtCoreTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    // Create an array of wrapper types for the current module.
    static PyTypeObject *cppApi[SBK_Qt3DCore_IDX_COUNT];
    SbkPySide2_Qt3DCoreTypes = cppApi;

    // Create an array of primitive type converters for the current module.
    static SbkConverter *sbkConverters[SBK_Qt3DCore_CONVERTERS_IDX_COUNT];
    SbkPySide2_Qt3DCoreTypeConverters = sbkConverters;

#ifdef IS_PY3K
    PyObject *module = Shiboken::Module::create("Qt3DCore", &moduledef);
#else
    PyObject *module = Shiboken::Module::create("Qt3DCore", Qt3DCore_methods);
#endif

    // Make module available from global scope
    SbkPySide2_Qt3DCoreModuleObject = module;

    // Initialize classes in the type system
    init_Qt3DCoreQt3DCore(module);
    init_Qt3DCore_QSceneChange(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DCoreTypes[SBK_Qt3DCoreQT3DCORE_IDX])->tp_dict);
    init_Qt3DCore_QPropertyValueRemovedChangeBase(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DCoreTypes[SBK_Qt3DCoreQT3DCORE_IDX])->tp_dict);
    init_Qt3DCore_QStaticPropertyValueRemovedChangeBase(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DCoreTypes[SBK_Qt3DCoreQT3DCORE_IDX])->tp_dict);
    init_Qt3DCore_QPropertyValueRemovedChange(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DCoreTypes[SBK_Qt3DCoreQT3DCORE_IDX])->tp_dict);
    init_Qt3DCore_QPropertyValueAddedChangeBase(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DCoreTypes[SBK_Qt3DCoreQT3DCORE_IDX])->tp_dict);
    init_Qt3DCore_QStaticPropertyValueAddedChangeBase(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DCoreTypes[SBK_Qt3DCoreQT3DCORE_IDX])->tp_dict);
    init_Qt3DCore_QPropertyValueAddedChange(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DCoreTypes[SBK_Qt3DCoreQT3DCORE_IDX])->tp_dict);
    init_Qt3DCore_QPropertyUpdatedChangeBase(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DCoreTypes[SBK_Qt3DCoreQT3DCORE_IDX])->tp_dict);
    init_Qt3DCore_QStaticPropertyUpdatedChangeBase(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DCoreTypes[SBK_Qt3DCoreQT3DCORE_IDX])->tp_dict);
    init_Qt3DCore_QPropertyUpdatedChange(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DCoreTypes[SBK_Qt3DCoreQT3DCORE_IDX])->tp_dict);
    init_Qt3DCore_QPropertyNodeRemovedChange(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DCoreTypes[SBK_Qt3DCoreQT3DCORE_IDX])->tp_dict);
    init_Qt3DCore_QPropertyNodeAddedChange(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DCoreTypes[SBK_Qt3DCoreQT3DCORE_IDX])->tp_dict);
    init_Qt3DCore_QNodeId(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DCoreTypes[SBK_Qt3DCoreQT3DCORE_IDX])->tp_dict);
    init_Qt3DCore_QNodeIdTypePair(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DCoreTypes[SBK_Qt3DCoreQT3DCORE_IDX])->tp_dict);
    init_Qt3DCore_QNodeDestroyedChange(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DCoreTypes[SBK_Qt3DCoreQT3DCORE_IDX])->tp_dict);
    init_Qt3DCore_QNodeCreatedChangeBase(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DCoreTypes[SBK_Qt3DCoreQT3DCORE_IDX])->tp_dict);
    init_Qt3DCore_QNodeCommand(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DCoreTypes[SBK_Qt3DCoreQT3DCORE_IDX])->tp_dict);
    init_Qt3DCore_QNode(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DCoreTypes[SBK_Qt3DCoreQT3DCORE_IDX])->tp_dict);
    init_Qt3DCore_QJoint(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DCoreTypes[SBK_Qt3DCoreQT3DCORE_IDX])->tp_dict);
    init_Qt3DCore_QEntity(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DCoreTypes[SBK_Qt3DCoreQT3DCORE_IDX])->tp_dict);
    init_Qt3DCore_QDynamicPropertyUpdatedChange(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DCoreTypes[SBK_Qt3DCoreQT3DCORE_IDX])->tp_dict);
    init_Qt3DCore_QComponentRemovedChange(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DCoreTypes[SBK_Qt3DCoreQT3DCORE_IDX])->tp_dict);
    init_Qt3DCore_QComponentAddedChange(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DCoreTypes[SBK_Qt3DCoreQT3DCORE_IDX])->tp_dict);
    init_Qt3DCore_QComponent(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DCoreTypes[SBK_Qt3DCoreQT3DCORE_IDX])->tp_dict);
    init_Qt3DCore_QTransform(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DCoreTypes[SBK_Qt3DCoreQT3DCORE_IDX])->tp_dict);
    init_Qt3DCore_QBackendNode(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DCoreTypes[SBK_Qt3DCoreQT3DCORE_IDX])->tp_dict);
    init_Qt3DCore_QAspectJob(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DCoreTypes[SBK_Qt3DCoreQT3DCORE_IDX])->tp_dict);
    init_Qt3DCore_QAspectEngine(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DCoreTypes[SBK_Qt3DCoreQT3DCORE_IDX])->tp_dict);
    init_Qt3DCore_QArmature(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DCoreTypes[SBK_Qt3DCoreQT3DCORE_IDX])->tp_dict);
    init_Qt3DCore_QAbstractSkeleton(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DCoreTypes[SBK_Qt3DCoreQT3DCORE_IDX])->tp_dict);
    init_Qt3DCore_QSkeletonLoader(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DCoreTypes[SBK_Qt3DCoreQT3DCORE_IDX])->tp_dict);
    init_Qt3DCore_QSkeleton(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DCoreTypes[SBK_Qt3DCoreQT3DCORE_IDX])->tp_dict);
    init_Qt3DCore_QAbstractAspect(reinterpret_cast<PyTypeObject *>(SbkPySide2_Qt3DCoreTypes[SBK_Qt3DCoreQT3DCORE_IDX])->tp_dict);

    // Register converter for type 'QVector<Qt3DCore::QAbstractAspect*>'.
    SbkPySide2_Qt3DCoreTypeConverters[SBK_QT3DCORE_QVECTOR_QT3DCORE_QABSTRACTASPECTPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_Qt3DCore_QAbstractAspectPTR__CppToPython__QVector_Qt3DCore_QAbstractAspectPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DCoreTypeConverters[SBK_QT3DCORE_QVECTOR_QT3DCORE_QABSTRACTASPECTPTR_IDX], "QVector<Qt3DCore::QAbstractAspect*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DCoreTypeConverters[SBK_QT3DCORE_QVECTOR_QT3DCORE_QABSTRACTASPECTPTR_IDX],
        _QVector_Qt3DCore_QAbstractAspectPTR__PythonToCpp__QVector_Qt3DCore_QAbstractAspectPTR_,
        is__QVector_Qt3DCore_QAbstractAspectPTR__PythonToCpp__QVector_Qt3DCore_QAbstractAspectPTR__Convertible);

    // Register converter for type 'const QList<QObject*>&'.
    SbkPySide2_Qt3DCoreTypeConverters[SBK_QT3DCORE_QLIST_QOBJECTPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QObjectPTR_REF_CppToPython__constQList_QObjectPTR_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DCoreTypeConverters[SBK_QT3DCORE_QLIST_QOBJECTPTR_IDX], "const QList<QObject*>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DCoreTypeConverters[SBK_QT3DCORE_QLIST_QOBJECTPTR_IDX], "QList<QObject*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DCoreTypeConverters[SBK_QT3DCORE_QLIST_QOBJECTPTR_IDX],
        _constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF,
        is__constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF_Convertible);

    // Register converter for type 'QList<QByteArray>'.
    SbkPySide2_Qt3DCoreTypeConverters[SBK_QT3DCORE_QLIST_QBYTEARRAY_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QByteArray__CppToPython__QList_QByteArray_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DCoreTypeConverters[SBK_QT3DCORE_QLIST_QBYTEARRAY_IDX], "QList<QByteArray>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DCoreTypeConverters[SBK_QT3DCORE_QLIST_QBYTEARRAY_IDX],
        _QList_QByteArray__PythonToCpp__QList_QByteArray_,
        is__QList_QByteArray__PythonToCpp__QList_QByteArray__Convertible);

    // Register converter for type 'QVector<Qt3DCore::QNode*>'.
    SbkPySide2_Qt3DCoreTypeConverters[SBK_QT3DCORE_QVECTOR_QT3DCORE_QNODEPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_Qt3DCore_QNodePTR__CppToPython__QVector_Qt3DCore_QNodePTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DCoreTypeConverters[SBK_QT3DCORE_QVECTOR_QT3DCORE_QNODEPTR_IDX], "QVector<Qt3DCore::QNode*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DCoreTypeConverters[SBK_QT3DCORE_QVECTOR_QT3DCORE_QNODEPTR_IDX],
        _QVector_Qt3DCore_QNodePTR__PythonToCpp__QVector_Qt3DCore_QNodePTR_,
        is__QVector_Qt3DCore_QNodePTR__PythonToCpp__QVector_Qt3DCore_QNodePTR__Convertible);

    // Register converter for type 'QVector<Qt3DCore::QEntity*>'.
    SbkPySide2_Qt3DCoreTypeConverters[SBK_QT3DCORE_QVECTOR_QT3DCORE_QENTITYPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_Qt3DCore_QEntityPTR__CppToPython__QVector_Qt3DCore_QEntityPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DCoreTypeConverters[SBK_QT3DCORE_QVECTOR_QT3DCORE_QENTITYPTR_IDX], "QVector<Qt3DCore::QEntity*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DCoreTypeConverters[SBK_QT3DCORE_QVECTOR_QT3DCORE_QENTITYPTR_IDX],
        _QVector_Qt3DCore_QEntityPTR__PythonToCpp__QVector_Qt3DCore_QEntityPTR_,
        is__QVector_Qt3DCore_QEntityPTR__PythonToCpp__QVector_Qt3DCore_QEntityPTR__Convertible);

    // Register converter for type 'QVector<Qt3DCore::QJoint*>'.
    SbkPySide2_Qt3DCoreTypeConverters[SBK_QT3DCORE_QVECTOR_QT3DCORE_QJOINTPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_Qt3DCore_QJointPTR__CppToPython__QVector_Qt3DCore_QJointPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DCoreTypeConverters[SBK_QT3DCORE_QVECTOR_QT3DCORE_QJOINTPTR_IDX], "QVector<Qt3DCore::QJoint*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DCoreTypeConverters[SBK_QT3DCORE_QVECTOR_QT3DCORE_QJOINTPTR_IDX],
        _QVector_Qt3DCore_QJointPTR__PythonToCpp__QVector_Qt3DCore_QJointPTR_,
        is__QVector_Qt3DCore_QJointPTR__PythonToCpp__QVector_Qt3DCore_QJointPTR__Convertible);

    // Register converter for type 'QVector<Qt3DCore::QComponent*>'.
    SbkPySide2_Qt3DCoreTypeConverters[SBK_QT3DCORE_QVECTOR_QT3DCORE_QCOMPONENTPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_Qt3DCore_QComponentPTR__CppToPython__QVector_Qt3DCore_QComponentPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DCoreTypeConverters[SBK_QT3DCORE_QVECTOR_QT3DCORE_QCOMPONENTPTR_IDX], "QVector<Qt3DCore::QComponent*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DCoreTypeConverters[SBK_QT3DCORE_QVECTOR_QT3DCORE_QCOMPONENTPTR_IDX],
        _QVector_Qt3DCore_QComponentPTR__PythonToCpp__QVector_Qt3DCore_QComponentPTR_,
        is__QVector_Qt3DCore_QComponentPTR__PythonToCpp__QVector_Qt3DCore_QComponentPTR__Convertible);

    // Register converter for type 'const QVector<Qt3DCore::QNodeIdTypePair>&'.
    SbkPySide2_Qt3DCoreTypeConverters[SBK_QT3DCORE_QVECTOR_QT3DCORE_QNODEIDTYPEPAIR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQVector_Qt3DCore_QNodeIdTypePair_REF_CppToPython__constQVector_Qt3DCore_QNodeIdTypePair_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DCoreTypeConverters[SBK_QT3DCORE_QVECTOR_QT3DCORE_QNODEIDTYPEPAIR_IDX], "const QVector<Qt3DCore::QNodeIdTypePair>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DCoreTypeConverters[SBK_QT3DCORE_QVECTOR_QT3DCORE_QNODEIDTYPEPAIR_IDX], "QVector<Qt3DCore::QNodeIdTypePair>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DCoreTypeConverters[SBK_QT3DCORE_QVECTOR_QT3DCORE_QNODEIDTYPEPAIR_IDX],
        _constQVector_Qt3DCore_QNodeIdTypePair_REF_PythonToCpp__constQVector_Qt3DCore_QNodeIdTypePair_REF,
        is__constQVector_Qt3DCore_QNodeIdTypePair_REF_PythonToCpp__constQVector_Qt3DCore_QNodeIdTypePair_REF_Convertible);

    // Register converter for type 'QList<QVariant>'.
    SbkPySide2_Qt3DCoreTypeConverters[SBK_QT3DCORE_QLIST_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QVariant__CppToPython__QList_QVariant_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DCoreTypeConverters[SBK_QT3DCORE_QLIST_QVARIANT_IDX], "QList<QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DCoreTypeConverters[SBK_QT3DCORE_QLIST_QVARIANT_IDX],
        _QList_QVariant__PythonToCpp__QList_QVariant_,
        is__QList_QVariant__PythonToCpp__QList_QVariant__Convertible);

    // Register converter for type 'QList<QString>'.
    SbkPySide2_Qt3DCoreTypeConverters[SBK_QT3DCORE_QLIST_QSTRING_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QString__CppToPython__QList_QString_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DCoreTypeConverters[SBK_QT3DCORE_QLIST_QSTRING_IDX], "QList<QString>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DCoreTypeConverters[SBK_QT3DCORE_QLIST_QSTRING_IDX],
        _QList_QString__PythonToCpp__QList_QString_,
        is__QList_QString__PythonToCpp__QList_QString__Convertible);

    // Register converter for type 'QMap<QString,QVariant>'.
    SbkPySide2_Qt3DCoreTypeConverters[SBK_QT3DCORE_QMAP_QSTRING_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QMap_QString_QVariant__CppToPython__QMap_QString_QVariant_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_Qt3DCoreTypeConverters[SBK_QT3DCORE_QMAP_QSTRING_QVARIANT_IDX], "QMap<QString,QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_Qt3DCoreTypeConverters[SBK_QT3DCORE_QMAP_QSTRING_QVARIANT_IDX],
        _QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant_,
        is__QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant__Convertible);

    // Register primitive types converters.

    Shiboken::Module::registerTypes(module, SbkPySide2_Qt3DCoreTypes);
    Shiboken::Module::registerTypeConverters(module, SbkPySide2_Qt3DCoreTypeConverters);

    if (PyErr_Occurred()) {
        PyErr_Print();
        Py_FatalError("can't initialize module Qt3DCore");
    }
    PySide::registerCleanupFunction(cleanTypesAttributes);

    FinishSignatureInitialization(module, Qt3DCore_SignatureStrings);

SBK_MODULE_INIT_FUNCTION_END
