/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qt3dcore_python.h"

// main header
#include "qt3dcore_qbackendnode_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QBackendNodeWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QBackendNodeWrapper::QBackendNodeWrapper(::Qt3DCore::QBackendNode::Mode mode) : Qt3DCore::QBackendNode(mode)
{
    resetPyMethodCache();
    // ... middle
}

QBackendNodeWrapper::~QBackendNodeWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_Qt3DCore_QBackendNode_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::Qt3DCore::QBackendNode >()))
        return -1;

    ::QBackendNodeWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.QBackendNode.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_Qt3DCore_QBackendNode_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:QBackendNode", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QBackendNode::QBackendNode(Qt3DCore::QBackendNode::Mode)
    if (numArgs == 0) {
        overloadId = 0; // QBackendNode(Qt3DCore::QBackendNode::Mode)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QBACKENDNODE_MODE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // QBackendNode(Qt3DCore::QBackendNode::Mode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DCore_QBackendNode_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
            if (PyDict_Contains(kwds, key_mode)) {
                value = PyDict_GetItem(kwds, key_mode);
                if (value && pyArgs[0]) {
                    errInfo = key_mode;
                    Py_INCREF(errInfo);
                    goto Sbk_Qt3DCore_QBackendNode_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QBACKENDNODE_MODE_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_Qt3DCore_QBackendNode_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_mode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_Qt3DCore_QBackendNode_Init_TypeError;
            }
        }
        ::Qt3DCore::QBackendNode::Mode cppArg0 = Qt3DCore::QBackendNode::Mode::ReadOnly;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QBackendNode(Qt3DCore::QBackendNode::Mode)
            cptr = new ::QBackendNodeWrapper(cppArg0);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::Qt3DCore::QBackendNode >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_Qt3DCore_QBackendNode_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_Qt3DCore_QBackendNode_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_Qt3DCore_QBackendNodeFunc_isEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DCore::QBackendNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QBACKENDNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.QBackendNode.isEnabled";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isEnabled()const
            bool cppResult = const_cast<const ::Qt3DCore::QBackendNode *>(cppSelf)->isEnabled();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DCore_QBackendNodeFunc_mode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DCore::QBackendNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QBACKENDNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.QBackendNode.mode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mode()const
            Qt3DCore::QBackendNode::Mode cppResult = const_cast<const ::Qt3DCore::QBackendNode *>(cppSelf)->mode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QBACKENDNODE_MODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DCore_QBackendNodeFunc_peerId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DCore::QBackendNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QBACKENDNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.QBackendNode.peerId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // peerId()const
            Qt3DCore::QNodeId cppResult = const_cast<const ::Qt3DCore::QBackendNode *>(cppSelf)->peerId();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODEID_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DCore_QBackendNodeFunc_sendCommand(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DCore::QBackendNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QBACKENDNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.QBackendNode.sendCommand";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_Qt3DCore_QBackendNodeFunc_sendCommand_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_Qt3DCore_QBackendNodeFunc_sendCommand_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:sendCommand", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QBackendNode::sendCommand(QString,QVariant,unsigned long long)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // sendCommand(QString,QVariant,unsigned long long)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[2])))) {
            overloadId = 0; // sendCommand(QString,QVariant,unsigned long long)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DCore_QBackendNodeFunc_sendCommand_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_replyTo = Shiboken::String::createStaticString("replyTo");
            if (PyDict_Contains(kwds, key_replyTo)) {
                value = PyDict_GetItem(kwds, key_replyTo);
                if (value && pyArgs[2]) {
                    errInfo = key_replyTo;
                    Py_INCREF(errInfo);
                    goto Sbk_Qt3DCore_QBackendNodeFunc_sendCommand_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[2]))))
                        goto Sbk_Qt3DCore_QBackendNodeFunc_sendCommand_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_replyTo);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_Qt3DCore_QBackendNodeFunc_sendCommand_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QVariant cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned long long cppArg2 = 0;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // sendCommand(QString,QVariant,unsigned long long)
            unsigned long long cppResult = cppSelf->sendCommand(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_Qt3DCore_QBackendNodeFunc_sendCommand_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DCore_QBackendNodeFunc_setEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DCore::QBackendNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QBACKENDNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.QBackendNode.setEnabled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QBackendNode::setEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DCore_QBackendNodeFunc_setEnabled_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setEnabled(bool)
            cppSelf->setEnabled(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DCore_QBackendNodeFunc_setEnabled_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_Qt3DCore_QBackendNode_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_Qt3DCore_QBackendNode_methods[] = {
    {"isEnabled", reinterpret_cast<PyCFunction>(Sbk_Qt3DCore_QBackendNodeFunc_isEnabled), METH_NOARGS},
    {"mode", reinterpret_cast<PyCFunction>(Sbk_Qt3DCore_QBackendNodeFunc_mode), METH_NOARGS},
    {"peerId", reinterpret_cast<PyCFunction>(Sbk_Qt3DCore_QBackendNodeFunc_peerId), METH_NOARGS},
    {"sendCommand", reinterpret_cast<PyCFunction>(Sbk_Qt3DCore_QBackendNodeFunc_sendCommand), METH_VARARGS|METH_KEYWORDS},
    {"setEnabled", reinterpret_cast<PyCFunction>(Sbk_Qt3DCore_QBackendNodeFunc_setEnabled), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_Qt3DCore_QBackendNode_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::Qt3DCore::QBackendNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QBACKENDNODE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QBackendNodeWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_Qt3DCore_QBackendNode_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_Qt3DCore_QBackendNode_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_Qt3DCore_QBackendNode_Type = nullptr;
static SbkObjectType *Sbk_Qt3DCore_QBackendNode_TypeF(void)
{
    return _Sbk_Qt3DCore_QBackendNode_Type;
}

static PyType_Slot Sbk_Qt3DCore_QBackendNode_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_Qt3DCore_QBackendNode_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Qt3DCore_QBackendNode_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Qt3DCore_QBackendNode_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Qt3DCore_QBackendNode_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_Qt3DCore_QBackendNode_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_Qt3DCore_QBackendNode_spec = {
    "2:PySide2.Qt3DCore.Qt3DCore.QBackendNode",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_Qt3DCore_QBackendNode_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void Qt3DCore_QBackendNode_Mode_PythonToCpp_Qt3DCore_QBackendNode_Mode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DCore::QBackendNode::Mode *>(cppOut) =
        static_cast<::Qt3DCore::QBackendNode::Mode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DCore_QBackendNode_Mode_PythonToCpp_Qt3DCore_QBackendNode_Mode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QBACKENDNODE_MODE_IDX]))
        return Qt3DCore_QBackendNode_Mode_PythonToCpp_Qt3DCore_QBackendNode_Mode;
    return {};
}
static PyObject *Qt3DCore_QBackendNode_Mode_CppToPython_Qt3DCore_QBackendNode_Mode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DCore::QBackendNode::Mode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QBACKENDNODE_MODE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QBackendNode_PythonToCpp_QBackendNode_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_Qt3DCore_QBackendNode_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QBackendNode_PythonToCpp_QBackendNode_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_Qt3DCore_QBackendNode_TypeF())))
        return QBackendNode_PythonToCpp_QBackendNode_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QBackendNode_PTR_CppToPython_QBackendNode(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::Qt3DCore::QBackendNode *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_Qt3DCore_QBackendNode_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *Qt3DCore_QBackendNode_SignatureStrings[] = {
    "PySide2.Qt3DCore.Qt3DCore.QBackendNode(self,mode:PySide2.Qt3DCore.Qt3DCore.QBackendNode.Mode=ReadOnly)",
    "PySide2.Qt3DCore.Qt3DCore.QBackendNode.isEnabled(self)->bool",
    "PySide2.Qt3DCore.Qt3DCore.QBackendNode.mode(self)->PySide2.Qt3DCore.Qt3DCore.QBackendNode.Mode",
    "PySide2.Qt3DCore.Qt3DCore.QBackendNode.peerId(self)->PySide2.Qt3DCore.Qt3DCore.QNodeId",
    "PySide2.Qt3DCore.Qt3DCore.QBackendNode.sendCommand(self,name:QString,data:QVariant,replyTo:unsigned long long=0)->unsigned long long",
    "PySide2.Qt3DCore.Qt3DCore.QBackendNode.setEnabled(self,enabled:bool)",
    nullptr}; // Sentinel

void init_Qt3DCore_QBackendNode(PyObject *enclosingClass)
{
    _Sbk_Qt3DCore_QBackendNode_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QBackendNode",
        "Qt3DCore::QBackendNode*",
        &Sbk_Qt3DCore_QBackendNode_spec,
        &Shiboken::callCppDestructor< ::Qt3DCore::QBackendNode >,
        0,
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DCore_QBackendNode_Type);
    InitSignatureStrings(pyType, Qt3DCore_QBackendNode_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DCore_QBackendNode_Type), Sbk_Qt3DCore_QBackendNode_PropertyStrings);
    SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QBACKENDNODE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_Qt3DCore_QBackendNode_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_Qt3DCore_QBackendNode_TypeF(),
        QBackendNode_PythonToCpp_QBackendNode_PTR,
        is_QBackendNode_PythonToCpp_QBackendNode_PTR_Convertible,
        QBackendNode_PTR_CppToPython_QBackendNode);

    Shiboken::Conversions::registerConverterName(converter, "Qt3DCore::QBackendNode");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DCore::QBackendNode*");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DCore::QBackendNode&");
    Shiboken::Conversions::registerConverterName(converter, "QBackendNode");
    Shiboken::Conversions::registerConverterName(converter, "QBackendNode*");
    Shiboken::Conversions::registerConverterName(converter, "QBackendNode&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::Qt3DCore::QBackendNode).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QBackendNodeWrapper).name());


    // Initialization of enums.

    // Initialization of enum 'Mode'.
    SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QBACKENDNODE_MODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DCore_QBackendNode_TypeF(),
        "Mode",
        "2:PySide2.Qt3DCore.Qt3DCore.QBackendNode.Mode",
        "Qt3DCore::QBackendNode::Mode");
    if (!SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QBACKENDNODE_MODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QBACKENDNODE_MODE_IDX],
        Sbk_Qt3DCore_QBackendNode_TypeF(), "ReadOnly", (long) Qt3DCore::QBackendNode::Mode::ReadOnly))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QBACKENDNODE_MODE_IDX],
        Sbk_Qt3DCore_QBackendNode_TypeF(), "ReadWrite", (long) Qt3DCore::QBackendNode::Mode::ReadWrite))
        return;
    // Register converter for enum 'Qt3DCore::QBackendNode::Mode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QBACKENDNODE_MODE_IDX],
            Qt3DCore_QBackendNode_Mode_CppToPython_Qt3DCore_QBackendNode_Mode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DCore_QBackendNode_Mode_PythonToCpp_Qt3DCore_QBackendNode_Mode,
            is_Qt3DCore_QBackendNode_Mode_PythonToCpp_Qt3DCore_QBackendNode_Mode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QBACKENDNODE_MODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DCore::QBackendNode::Mode");
        Shiboken::Conversions::registerConverterName(converter, "QBackendNode::Mode");
        Shiboken::Conversions::registerConverterName(converter, "Mode");
    }
    // End of 'Mode' enum.

    qRegisterMetaType< ::Qt3DCore::QBackendNode::Mode >("QBackendNode::Mode");
    qRegisterMetaType< ::Qt3DCore::QBackendNode::Mode >("Qt3DCore::QBackendNode::Mode");
}
