/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qt3dcore_python.h"

// main header
#include "qt3dcore_qdynamicpropertyupdatedchange_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QDynamicPropertyUpdatedChangeWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QDynamicPropertyUpdatedChangeWrapper::QDynamicPropertyUpdatedChangeWrapper(::Qt3DCore::QNodeId subjectId) : Qt3DCore::QDynamicPropertyUpdatedChange(subjectId)
{
    resetPyMethodCache();
    // ... middle
}

QDynamicPropertyUpdatedChangeWrapper::~QDynamicPropertyUpdatedChangeWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_Qt3DCore_QDynamicPropertyUpdatedChange_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::Qt3DCore::QDynamicPropertyUpdatedChange >()))
        return -1;

    ::QDynamicPropertyUpdatedChangeWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.QDynamicPropertyUpdatedChange.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QDynamicPropertyUpdatedChange", 1, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QDynamicPropertyUpdatedChange::QDynamicPropertyUpdatedChange(Qt3DCore::QNodeId)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODEID_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QDynamicPropertyUpdatedChange(Qt3DCore::QNodeId)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DCore_QDynamicPropertyUpdatedChange_Init_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::Qt3DCore::QNodeId cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QDynamicPropertyUpdatedChange(Qt3DCore::QNodeId)
            cptr = new ::QDynamicPropertyUpdatedChangeWrapper(cppArg0);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::Qt3DCore::QDynamicPropertyUpdatedChange >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_Qt3DCore_QDynamicPropertyUpdatedChange_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_Qt3DCore_QDynamicPropertyUpdatedChange_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_Qt3DCore_QDynamicPropertyUpdatedChangeFunc_propertyName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DCore::QDynamicPropertyUpdatedChange *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QDYNAMICPROPERTYUPDATEDCHANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.QDynamicPropertyUpdatedChange.propertyName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // propertyName()const
            QByteArray cppResult = const_cast<const ::Qt3DCore::QDynamicPropertyUpdatedChange *>(cppSelf)->propertyName();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DCore_QDynamicPropertyUpdatedChangeFunc_setPropertyName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DCore::QDynamicPropertyUpdatedChange *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QDYNAMICPROPERTYUPDATEDCHANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.QDynamicPropertyUpdatedChange.setPropertyName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDynamicPropertyUpdatedChange::setPropertyName(QByteArray)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // setPropertyName(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DCore_QDynamicPropertyUpdatedChangeFunc_setPropertyName_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setPropertyName(QByteArray)
            cppSelf->setPropertyName(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DCore_QDynamicPropertyUpdatedChangeFunc_setPropertyName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DCore_QDynamicPropertyUpdatedChangeFunc_setValue(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DCore::QDynamicPropertyUpdatedChange *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QDYNAMICPROPERTYUPDATEDCHANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.QDynamicPropertyUpdatedChange.setValue";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDynamicPropertyUpdatedChange::setValue(QVariant)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArg)))) {
        overloadId = 0; // setValue(QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DCore_QDynamicPropertyUpdatedChangeFunc_setValue_TypeError;

    // Call function/method
    {
        ::QVariant cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setValue(QVariant)
            cppSelf->setValue(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DCore_QDynamicPropertyUpdatedChangeFunc_setValue_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DCore_QDynamicPropertyUpdatedChangeFunc_value(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DCore::QDynamicPropertyUpdatedChange *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QDYNAMICPROPERTYUPDATEDCHANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.QDynamicPropertyUpdatedChange.value";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // value()const
            QVariant cppResult = const_cast<const ::Qt3DCore::QDynamicPropertyUpdatedChange *>(cppSelf)->value();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_Qt3DCore_QDynamicPropertyUpdatedChange_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_Qt3DCore_QDynamicPropertyUpdatedChange_methods[] = {
    {"propertyName", reinterpret_cast<PyCFunction>(Sbk_Qt3DCore_QDynamicPropertyUpdatedChangeFunc_propertyName), METH_NOARGS},
    {"setPropertyName", reinterpret_cast<PyCFunction>(Sbk_Qt3DCore_QDynamicPropertyUpdatedChangeFunc_setPropertyName), METH_O},
    {"setValue", reinterpret_cast<PyCFunction>(Sbk_Qt3DCore_QDynamicPropertyUpdatedChangeFunc_setValue), METH_O},
    {"value", reinterpret_cast<PyCFunction>(Sbk_Qt3DCore_QDynamicPropertyUpdatedChangeFunc_value), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_Qt3DCore_QDynamicPropertyUpdatedChange_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::Qt3DCore::QDynamicPropertyUpdatedChange *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QDYNAMICPROPERTYUPDATEDCHANGE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QDynamicPropertyUpdatedChangeWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_Qt3DCore_QDynamicPropertyUpdatedChange_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_Qt3DCore_QDynamicPropertyUpdatedChange_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_Qt3DCore_QDynamicPropertyUpdatedChange_Type = nullptr;
static SbkObjectType *Sbk_Qt3DCore_QDynamicPropertyUpdatedChange_TypeF(void)
{
    return _Sbk_Qt3DCore_QDynamicPropertyUpdatedChange_Type;
}

static PyType_Slot Sbk_Qt3DCore_QDynamicPropertyUpdatedChange_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_Qt3DCore_QDynamicPropertyUpdatedChange_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Qt3DCore_QDynamicPropertyUpdatedChange_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Qt3DCore_QDynamicPropertyUpdatedChange_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Qt3DCore_QDynamicPropertyUpdatedChange_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_Qt3DCore_QDynamicPropertyUpdatedChange_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_Qt3DCore_QDynamicPropertyUpdatedChange_spec = {
    "2:PySide2.Qt3DCore.Qt3DCore.QDynamicPropertyUpdatedChange",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_Qt3DCore_QDynamicPropertyUpdatedChange_slots
};

} //extern "C"

static void *Sbk_Qt3DCore_QDynamicPropertyUpdatedChange_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::Qt3DCore::QSceneChange >()))
        return dynamic_cast< ::Qt3DCore::QDynamicPropertyUpdatedChange *>(reinterpret_cast< ::Qt3DCore::QSceneChange *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QDynamicPropertyUpdatedChange_PythonToCpp_QDynamicPropertyUpdatedChange_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_Qt3DCore_QDynamicPropertyUpdatedChange_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QDynamicPropertyUpdatedChange_PythonToCpp_QDynamicPropertyUpdatedChange_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_Qt3DCore_QDynamicPropertyUpdatedChange_TypeF())))
        return QDynamicPropertyUpdatedChange_PythonToCpp_QDynamicPropertyUpdatedChange_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QDynamicPropertyUpdatedChange_PTR_CppToPython_QDynamicPropertyUpdatedChange(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::Qt3DCore::QDynamicPropertyUpdatedChange *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_Qt3DCore_QDynamicPropertyUpdatedChange_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *Qt3DCore_QDynamicPropertyUpdatedChange_SignatureStrings[] = {
    "PySide2.Qt3DCore.Qt3DCore.QDynamicPropertyUpdatedChange(self,subjectId:PySide2.Qt3DCore.Qt3DCore.QNodeId)",
    "PySide2.Qt3DCore.Qt3DCore.QDynamicPropertyUpdatedChange.propertyName(self)->PySide2.QtCore.QByteArray",
    "PySide2.Qt3DCore.Qt3DCore.QDynamicPropertyUpdatedChange.setPropertyName(self,name:PySide2.QtCore.QByteArray)",
    "PySide2.Qt3DCore.Qt3DCore.QDynamicPropertyUpdatedChange.setValue(self,value:QVariant)",
    "PySide2.Qt3DCore.Qt3DCore.QDynamicPropertyUpdatedChange.value(self)->QVariant",
    nullptr}; // Sentinel

void init_Qt3DCore_QDynamicPropertyUpdatedChange(PyObject *enclosingClass)
{
    _Sbk_Qt3DCore_QDynamicPropertyUpdatedChange_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QDynamicPropertyUpdatedChange",
        "Qt3DCore::QDynamicPropertyUpdatedChange*",
        &Sbk_Qt3DCore_QDynamicPropertyUpdatedChange_spec,
        &Shiboken::callCppDestructor< ::Qt3DCore::QDynamicPropertyUpdatedChange >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QPROPERTYUPDATEDCHANGEBASE_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DCore_QDynamicPropertyUpdatedChange_Type);
    InitSignatureStrings(pyType, Qt3DCore_QDynamicPropertyUpdatedChange_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DCore_QDynamicPropertyUpdatedChange_Type), Sbk_Qt3DCore_QDynamicPropertyUpdatedChange_PropertyStrings);
    SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QDYNAMICPROPERTYUPDATEDCHANGE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_Qt3DCore_QDynamicPropertyUpdatedChange_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_Qt3DCore_QDynamicPropertyUpdatedChange_TypeF(),
        QDynamicPropertyUpdatedChange_PythonToCpp_QDynamicPropertyUpdatedChange_PTR,
        is_QDynamicPropertyUpdatedChange_PythonToCpp_QDynamicPropertyUpdatedChange_PTR_Convertible,
        QDynamicPropertyUpdatedChange_PTR_CppToPython_QDynamicPropertyUpdatedChange);

    Shiboken::Conversions::registerConverterName(converter, "Qt3DCore::QDynamicPropertyUpdatedChange");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DCore::QDynamicPropertyUpdatedChange*");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DCore::QDynamicPropertyUpdatedChange&");
    Shiboken::Conversions::registerConverterName(converter, "QDynamicPropertyUpdatedChange");
    Shiboken::Conversions::registerConverterName(converter, "QDynamicPropertyUpdatedChange*");
    Shiboken::Conversions::registerConverterName(converter, "QDynamicPropertyUpdatedChange&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::Qt3DCore::QDynamicPropertyUpdatedChange).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QDynamicPropertyUpdatedChangeWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_Qt3DCore_QDynamicPropertyUpdatedChange_TypeF(), &Sbk_Qt3DCore_QDynamicPropertyUpdatedChange_typeDiscovery);

}
