/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qt3dcore_python.h"

// main header
#include "qt3dcore_qnodeid_wrapper.h"

// inner classes

// Extra includes
#include <Qt3DCore/qnodeid.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_Qt3DCore_QNodeId_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::Qt3DCore::QNodeId >()))
        return -1;

    ::Qt3DCore::QNodeId *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.QNodeId.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QNodeId", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QNodeId::QNodeId()
    // 1: QNodeId::QNodeId(Qt3DCore::QNodeId)
    if (numArgs == 0) {
        overloadId = 0; // QNodeId()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODEID_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QNodeId(Qt3DCore::QNodeId)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DCore_QNodeId_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QNodeId()
        {

            if (!PyErr_Occurred()) {
                // QNodeId()
                cptr = new ::Qt3DCore::QNodeId();
            }
            break;
        }
        case 1: // QNodeId(const Qt3DCore::QNodeId & QNodeId)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::Qt3DCore::QNodeId cppArg0_local;
            ::Qt3DCore::QNodeId *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODEID_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QNodeId(Qt3DCore::QNodeId)
                cptr = new ::Qt3DCore::QNodeId(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::Qt3DCore::QNodeId >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_Qt3DCore_QNodeId_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_Qt3DCore_QNodeId_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_Qt3DCore_QNodeIdFunc_createId(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.QNodeId.createId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // createId()
            Qt3DCore::QNodeId cppResult = ::Qt3DCore::QNodeId::createId();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODEID_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DCore_QNodeIdFunc_id(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DCore::QNodeId *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODEID_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.QNodeId.id";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // id()const
            quint64 cppResult = const_cast<const ::Qt3DCore::QNodeId *>(cppSelf)->id();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DCore_QNodeIdFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DCore::QNodeId *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODEID_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DCore.Qt3DCore.QNodeId.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::Qt3DCore::QNodeId *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DCore_QNodeId___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::Qt3DCore::QNodeId *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODEID_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODEID_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_Qt3DCore_QNodeId_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_Qt3DCore_QNodeId_methods[] = {
    {"createId", reinterpret_cast<PyCFunction>(Sbk_Qt3DCore_QNodeIdFunc_createId), METH_NOARGS|METH_STATIC},
    {"id", reinterpret_cast<PyCFunction>(Sbk_Qt3DCore_QNodeIdFunc_id), METH_NOARGS},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_Qt3DCore_QNodeIdFunc_isNull), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_Qt3DCore_QNodeId___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_Qt3DCore_QNodeId___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::Qt3DCore::QNodeId *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODEID_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

// Rich comparison
static PyObject * Sbk_Qt3DCore_QNodeId_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::Qt3DCore::QNodeId *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODEID_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODEID_IDX]), (pyArg)))) {
                // operator!=(Qt3DCore::QNodeId other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::Qt3DCore::QNodeId cppArg0;
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf !=(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_LT:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODEID_IDX]), (pyArg)))) {
                // operator<(Qt3DCore::QNodeId other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::Qt3DCore::QNodeId cppArg0;
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf <(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                goto Sbk_Qt3DCore_QNodeId_RichComparison_TypeError;
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODEID_IDX]), (pyArg)))) {
                // operator==(Qt3DCore::QNodeId other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::Qt3DCore::QNodeId cppArg0;
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf ==(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        case Py_GT:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODEID_IDX]), (pyArg)))) {
                // operator>(Qt3DCore::QNodeId other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::Qt3DCore::QNodeId cppArg0;
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf >(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                goto Sbk_Qt3DCore_QNodeId_RichComparison_TypeError;
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_Qt3DCore_QNodeId_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_Qt3DCore_QNodeId_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_Qt3DCore_QNodeId_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_Qt3DCore_QNodeId_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_Qt3DCore_QNodeId__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DCore::QNodeId *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODEID_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_Qt3DCore_QNodeId_Type = nullptr;
static SbkObjectType *Sbk_Qt3DCore_QNodeId_TypeF(void)
{
    return _Sbk_Qt3DCore_QNodeId_Type;
}

static PyType_Slot Sbk_Qt3DCore_QNodeId_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_Qt3DCore_QNodeId__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Qt3DCore_QNodeId_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Qt3DCore_QNodeId_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_Qt3DCore_QNodeId_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Qt3DCore_QNodeId_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_Qt3DCore_QNodeId_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_Qt3DCore_QNodeId___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_Qt3DCore_QNodeId___nb_bool},
#endif
    {0, nullptr}
};
static PyType_Spec Sbk_Qt3DCore_QNodeId_spec = {
    "2:PySide2.Qt3DCore.Qt3DCore.QNodeId",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_Qt3DCore_QNodeId_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QNodeId_PythonToCpp_QNodeId_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_Qt3DCore_QNodeId_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QNodeId_PythonToCpp_QNodeId_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_Qt3DCore_QNodeId_TypeF())))
        return QNodeId_PythonToCpp_QNodeId_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QNodeId_PTR_CppToPython_QNodeId(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::Qt3DCore::QNodeId *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_Qt3DCore_QNodeId_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QNodeId_COPY_CppToPython_QNodeId(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_Qt3DCore_QNodeId_TypeF(), new ::Qt3DCore::QNodeId(*reinterpret_cast<const ::Qt3DCore::QNodeId *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QNodeId_PythonToCpp_QNodeId_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DCore::QNodeId *>(cppOut) = *reinterpret_cast< ::Qt3DCore::QNodeId *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODEID_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QNodeId_PythonToCpp_QNodeId_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_Qt3DCore_QNodeId_TypeF())))
        return QNodeId_PythonToCpp_QNodeId_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *Qt3DCore_QNodeId_SignatureStrings[] = {
    "1:PySide2.Qt3DCore.Qt3DCore.QNodeId(self)",
    "0:PySide2.Qt3DCore.Qt3DCore.QNodeId(self,QNodeId:PySide2.Qt3DCore.Qt3DCore.QNodeId)",
    "PySide2.Qt3DCore.Qt3DCore.QNodeId.createId()->PySide2.Qt3DCore.Qt3DCore.QNodeId",
    "PySide2.Qt3DCore.Qt3DCore.QNodeId.id(self)->quint64",
    "PySide2.Qt3DCore.Qt3DCore.QNodeId.isNull(self)->bool",
    "PySide2.Qt3DCore.Qt3DCore.QNodeId.__copy__()",
    nullptr}; // Sentinel

void init_Qt3DCore_QNodeId(PyObject *enclosingClass)
{
    _Sbk_Qt3DCore_QNodeId_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QNodeId",
        "Qt3DCore::QNodeId",
        &Sbk_Qt3DCore_QNodeId_spec,
        &Shiboken::callCppDestructor< ::Qt3DCore::QNodeId >,
        0,
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DCore_QNodeId_Type);
    InitSignatureStrings(pyType, Qt3DCore_QNodeId_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DCore_QNodeId_Type), Sbk_Qt3DCore_QNodeId_PropertyStrings);
    SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODEID_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_Qt3DCore_QNodeId_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_Qt3DCore_QNodeId_TypeF(),
        QNodeId_PythonToCpp_QNodeId_PTR,
        is_QNodeId_PythonToCpp_QNodeId_PTR_Convertible,
        QNodeId_PTR_CppToPython_QNodeId,
        QNodeId_COPY_CppToPython_QNodeId);

    Shiboken::Conversions::registerConverterName(converter, "Qt3DCore::QNodeId");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DCore::QNodeId*");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DCore::QNodeId&");
    Shiboken::Conversions::registerConverterName(converter, "QNodeId");
    Shiboken::Conversions::registerConverterName(converter, "QNodeId*");
    Shiboken::Conversions::registerConverterName(converter, "QNodeId&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::Qt3DCore::QNodeId).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QNodeId_PythonToCpp_QNodeId_COPY,
        is_QNodeId_PythonToCpp_QNodeId_COPY_Convertible);

    qRegisterMetaType< ::Qt3DCore::QNodeId >("QNodeId");
    qRegisterMetaType< ::Qt3DCore::QNodeId >("Qt3DCore::QNodeId");
}
