/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qt3dextras_python.h"

// main header
#include "qt3dextras_qabstractcameracontroller_inputstate_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>

using namespace Qt3DExtras;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_Qt3DExtras_QAbstractCameraController_InputState_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::Qt3DExtras::QAbstractCameraController::InputState >()))
        return -1;

    ::Qt3DExtras::QAbstractCameraController::InputState *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DExtras.Qt3DExtras.QAbstractCameraController.InputState.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "InputState", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: InputState::InputState()
    // 1: InputState::InputState(Qt3DExtras::QAbstractCameraController::InputState)
    if (numArgs == 0) {
        overloadId = 0; // InputState()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QABSTRACTCAMERACONTROLLER_INPUTSTATE_IDX]), (pyArgs[0])))) {
        overloadId = 1; // InputState(Qt3DExtras::QAbstractCameraController::InputState)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DExtras_QAbstractCameraController_InputState_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // InputState()
        {

            if (!PyErr_Occurred()) {
                // InputState()
                cptr = new ::Qt3DExtras::QAbstractCameraController::InputState();
            }
            break;
        }
        case 1: // InputState(const Qt3DExtras::QAbstractCameraController::InputState & InputState)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::Qt3DExtras::QAbstractCameraController::InputState cppArg0_local;
            ::Qt3DExtras::QAbstractCameraController::InputState *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QABSTRACTCAMERACONTROLLER_INPUTSTATE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // InputState(Qt3DExtras::QAbstractCameraController::InputState)
                cptr = new ::Qt3DExtras::QAbstractCameraController::InputState(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::Qt3DExtras::QAbstractCameraController::InputState >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_Qt3DExtras_QAbstractCameraController_InputState_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_Qt3DExtras_QAbstractCameraController_InputState_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_Qt3DExtras_QAbstractCameraController_InputState___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::Qt3DExtras::QAbstractCameraController::InputState *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QABSTRACTCAMERACONTROLLER_INPUTSTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QABSTRACTCAMERACONTROLLER_INPUTSTATE_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_Qt3DExtras_QAbstractCameraController_InputState_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_Qt3DExtras_QAbstractCameraController_InputState_methods[] = {

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_Qt3DExtras_QAbstractCameraController_InputState___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_Qt3DExtras_QAbstractCameraController_InputState_get_rxAxisValue(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QAbstractCameraController::InputState *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QABSTRACTCAMERACONTROLLER_INPUTSTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppSelf->rxAxisValue);
    return pyOut;
}
static int Sbk_Qt3DExtras_QAbstractCameraController_InputState_set_rxAxisValue(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QAbstractCameraController::InputState *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QABSTRACTCAMERACONTROLLER_INPUTSTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'rxAxisValue' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'rxAxisValue', 'float' or convertible type expected");
        return -1;
    }

    float& cppOut_ptr = cppSelf->rxAxisValue;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_Qt3DExtras_QAbstractCameraController_InputState_get_ryAxisValue(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QAbstractCameraController::InputState *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QABSTRACTCAMERACONTROLLER_INPUTSTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppSelf->ryAxisValue);
    return pyOut;
}
static int Sbk_Qt3DExtras_QAbstractCameraController_InputState_set_ryAxisValue(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QAbstractCameraController::InputState *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QABSTRACTCAMERACONTROLLER_INPUTSTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'ryAxisValue' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'ryAxisValue', 'float' or convertible type expected");
        return -1;
    }

    float& cppOut_ptr = cppSelf->ryAxisValue;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_Qt3DExtras_QAbstractCameraController_InputState_get_txAxisValue(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QAbstractCameraController::InputState *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QABSTRACTCAMERACONTROLLER_INPUTSTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppSelf->txAxisValue);
    return pyOut;
}
static int Sbk_Qt3DExtras_QAbstractCameraController_InputState_set_txAxisValue(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QAbstractCameraController::InputState *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QABSTRACTCAMERACONTROLLER_INPUTSTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'txAxisValue' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'txAxisValue', 'float' or convertible type expected");
        return -1;
    }

    float& cppOut_ptr = cppSelf->txAxisValue;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_Qt3DExtras_QAbstractCameraController_InputState_get_tyAxisValue(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QAbstractCameraController::InputState *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QABSTRACTCAMERACONTROLLER_INPUTSTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppSelf->tyAxisValue);
    return pyOut;
}
static int Sbk_Qt3DExtras_QAbstractCameraController_InputState_set_tyAxisValue(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QAbstractCameraController::InputState *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QABSTRACTCAMERACONTROLLER_INPUTSTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'tyAxisValue' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'tyAxisValue', 'float' or convertible type expected");
        return -1;
    }

    float& cppOut_ptr = cppSelf->tyAxisValue;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_Qt3DExtras_QAbstractCameraController_InputState_get_tzAxisValue(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QAbstractCameraController::InputState *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QABSTRACTCAMERACONTROLLER_INPUTSTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppSelf->tzAxisValue);
    return pyOut;
}
static int Sbk_Qt3DExtras_QAbstractCameraController_InputState_set_tzAxisValue(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QAbstractCameraController::InputState *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QABSTRACTCAMERACONTROLLER_INPUTSTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'tzAxisValue' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'tzAxisValue', 'float' or convertible type expected");
        return -1;
    }

    float& cppOut_ptr = cppSelf->tzAxisValue;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_Qt3DExtras_QAbstractCameraController_InputState_get_leftMouseButtonActive(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QAbstractCameraController::InputState *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QABSTRACTCAMERACONTROLLER_INPUTSTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->leftMouseButtonActive;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
    return pyOut;
}
static int Sbk_Qt3DExtras_QAbstractCameraController_InputState_set_leftMouseButtonActive(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QAbstractCameraController::InputState *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QABSTRACTCAMERACONTROLLER_INPUTSTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'leftMouseButtonActive' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'leftMouseButtonActive', 'bool' or convertible type expected");
        return -1;
    }

    bool cppOut_local = cppSelf->leftMouseButtonActive;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->leftMouseButtonActive = cppOut_local;

    return 0;
}

static PyObject *Sbk_Qt3DExtras_QAbstractCameraController_InputState_get_middleMouseButtonActive(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QAbstractCameraController::InputState *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QABSTRACTCAMERACONTROLLER_INPUTSTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->middleMouseButtonActive;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
    return pyOut;
}
static int Sbk_Qt3DExtras_QAbstractCameraController_InputState_set_middleMouseButtonActive(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QAbstractCameraController::InputState *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QABSTRACTCAMERACONTROLLER_INPUTSTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'middleMouseButtonActive' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'middleMouseButtonActive', 'bool' or convertible type expected");
        return -1;
    }

    bool cppOut_local = cppSelf->middleMouseButtonActive;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->middleMouseButtonActive = cppOut_local;

    return 0;
}

static PyObject *Sbk_Qt3DExtras_QAbstractCameraController_InputState_get_rightMouseButtonActive(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QAbstractCameraController::InputState *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QABSTRACTCAMERACONTROLLER_INPUTSTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->rightMouseButtonActive;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
    return pyOut;
}
static int Sbk_Qt3DExtras_QAbstractCameraController_InputState_set_rightMouseButtonActive(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QAbstractCameraController::InputState *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QABSTRACTCAMERACONTROLLER_INPUTSTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'rightMouseButtonActive' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'rightMouseButtonActive', 'bool' or convertible type expected");
        return -1;
    }

    bool cppOut_local = cppSelf->rightMouseButtonActive;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->rightMouseButtonActive = cppOut_local;

    return 0;
}

static PyObject *Sbk_Qt3DExtras_QAbstractCameraController_InputState_get_altKeyActive(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QAbstractCameraController::InputState *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QABSTRACTCAMERACONTROLLER_INPUTSTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->altKeyActive;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
    return pyOut;
}
static int Sbk_Qt3DExtras_QAbstractCameraController_InputState_set_altKeyActive(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QAbstractCameraController::InputState *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QABSTRACTCAMERACONTROLLER_INPUTSTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'altKeyActive' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'altKeyActive', 'bool' or convertible type expected");
        return -1;
    }

    bool cppOut_local = cppSelf->altKeyActive;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->altKeyActive = cppOut_local;

    return 0;
}

static PyObject *Sbk_Qt3DExtras_QAbstractCameraController_InputState_get_shiftKeyActive(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QAbstractCameraController::InputState *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QABSTRACTCAMERACONTROLLER_INPUTSTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->shiftKeyActive;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
    return pyOut;
}
static int Sbk_Qt3DExtras_QAbstractCameraController_InputState_set_shiftKeyActive(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::Qt3DExtras::QAbstractCameraController::InputState *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QABSTRACTCAMERACONTROLLER_INPUTSTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'shiftKeyActive' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'shiftKeyActive', 'bool' or convertible type expected");
        return -1;
    }

    bool cppOut_local = cppSelf->shiftKeyActive;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->shiftKeyActive = cppOut_local;

    return 0;
}

// Getters and Setters for InputState
static PyGetSetDef Sbk_Qt3DExtras_QAbstractCameraController_InputState_getsetlist[] = {
    {const_cast<char *>("rxAxisValue"), Sbk_Qt3DExtras_QAbstractCameraController_InputState_get_rxAxisValue, Sbk_Qt3DExtras_QAbstractCameraController_InputState_set_rxAxisValue},
    {const_cast<char *>("ryAxisValue"), Sbk_Qt3DExtras_QAbstractCameraController_InputState_get_ryAxisValue, Sbk_Qt3DExtras_QAbstractCameraController_InputState_set_ryAxisValue},
    {const_cast<char *>("txAxisValue"), Sbk_Qt3DExtras_QAbstractCameraController_InputState_get_txAxisValue, Sbk_Qt3DExtras_QAbstractCameraController_InputState_set_txAxisValue},
    {const_cast<char *>("tyAxisValue"), Sbk_Qt3DExtras_QAbstractCameraController_InputState_get_tyAxisValue, Sbk_Qt3DExtras_QAbstractCameraController_InputState_set_tyAxisValue},
    {const_cast<char *>("tzAxisValue"), Sbk_Qt3DExtras_QAbstractCameraController_InputState_get_tzAxisValue, Sbk_Qt3DExtras_QAbstractCameraController_InputState_set_tzAxisValue},
    {const_cast<char *>("leftMouseButtonActive"), Sbk_Qt3DExtras_QAbstractCameraController_InputState_get_leftMouseButtonActive, Sbk_Qt3DExtras_QAbstractCameraController_InputState_set_leftMouseButtonActive},
    {const_cast<char *>("middleMouseButtonActive"), Sbk_Qt3DExtras_QAbstractCameraController_InputState_get_middleMouseButtonActive, Sbk_Qt3DExtras_QAbstractCameraController_InputState_set_middleMouseButtonActive},
    {const_cast<char *>("rightMouseButtonActive"), Sbk_Qt3DExtras_QAbstractCameraController_InputState_get_rightMouseButtonActive, Sbk_Qt3DExtras_QAbstractCameraController_InputState_set_rightMouseButtonActive},
    {const_cast<char *>("altKeyActive"), Sbk_Qt3DExtras_QAbstractCameraController_InputState_get_altKeyActive, Sbk_Qt3DExtras_QAbstractCameraController_InputState_set_altKeyActive},
    {const_cast<char *>("shiftKeyActive"), Sbk_Qt3DExtras_QAbstractCameraController_InputState_get_shiftKeyActive, Sbk_Qt3DExtras_QAbstractCameraController_InputState_set_shiftKeyActive},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_Qt3DExtras_QAbstractCameraController_InputState_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_Qt3DExtras_QAbstractCameraController_InputState_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_Qt3DExtras_QAbstractCameraController_InputState_Type = nullptr;
static SbkObjectType *Sbk_Qt3DExtras_QAbstractCameraController_InputState_TypeF(void)
{
    return _Sbk_Qt3DExtras_QAbstractCameraController_InputState_Type;
}

static PyType_Slot Sbk_Qt3DExtras_QAbstractCameraController_InputState_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Qt3DExtras_QAbstractCameraController_InputState_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Qt3DExtras_QAbstractCameraController_InputState_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Qt3DExtras_QAbstractCameraController_InputState_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_Qt3DExtras_QAbstractCameraController_InputState_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_Qt3DExtras_QAbstractCameraController_InputState_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_Qt3DExtras_QAbstractCameraController_InputState_spec = {
    "2:PySide2.Qt3DExtras.Qt3DExtras.QAbstractCameraController.InputState",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_Qt3DExtras_QAbstractCameraController_InputState_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void InputState_PythonToCpp_InputState_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_Qt3DExtras_QAbstractCameraController_InputState_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_InputState_PythonToCpp_InputState_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_Qt3DExtras_QAbstractCameraController_InputState_TypeF())))
        return InputState_PythonToCpp_InputState_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *InputState_PTR_CppToPython_InputState(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::Qt3DExtras::QAbstractCameraController::InputState *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_Qt3DExtras_QAbstractCameraController_InputState_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *InputState_COPY_CppToPython_InputState(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_Qt3DExtras_QAbstractCameraController_InputState_TypeF(), new ::Qt3DExtras::QAbstractCameraController::InputState(*reinterpret_cast<const ::Qt3DExtras::QAbstractCameraController::InputState *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void InputState_PythonToCpp_InputState_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DExtras::QAbstractCameraController::InputState *>(cppOut) = *reinterpret_cast< ::Qt3DExtras::QAbstractCameraController::InputState *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QABSTRACTCAMERACONTROLLER_INPUTSTATE_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_InputState_PythonToCpp_InputState_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_Qt3DExtras_QAbstractCameraController_InputState_TypeF())))
        return InputState_PythonToCpp_InputState_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *Qt3DExtras_QAbstractCameraController_InputState_SignatureStrings[] = {
    "1:PySide2.Qt3DExtras.Qt3DExtras.QAbstractCameraController.InputState(self)",
    "0:PySide2.Qt3DExtras.Qt3DExtras.QAbstractCameraController.InputState(self,InputState:PySide2.Qt3DExtras.Qt3DExtras.QAbstractCameraController.InputState)",
    "PySide2.Qt3DExtras.Qt3DExtras.QAbstractCameraController.InputState.__copy__()",
    nullptr}; // Sentinel

void init_Qt3DExtras_QAbstractCameraController_InputState(PyObject *enclosingClass)
{
    _Sbk_Qt3DExtras_QAbstractCameraController_InputState_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "InputState",
        "Qt3DExtras::QAbstractCameraController::InputState",
        &Sbk_Qt3DExtras_QAbstractCameraController_InputState_spec,
        &Shiboken::callCppDestructor< ::Qt3DExtras::QAbstractCameraController::InputState >,
        0,
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DExtras_QAbstractCameraController_InputState_Type);
    InitSignatureStrings(pyType, Qt3DExtras_QAbstractCameraController_InputState_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DExtras_QAbstractCameraController_InputState_Type), Sbk_Qt3DExtras_QAbstractCameraController_InputState_PropertyStrings);
    SbkPySide2_Qt3DExtrasTypes[SBK_QT3DEXTRAS_QABSTRACTCAMERACONTROLLER_INPUTSTATE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_Qt3DExtras_QAbstractCameraController_InputState_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_Qt3DExtras_QAbstractCameraController_InputState_TypeF(),
        InputState_PythonToCpp_InputState_PTR,
        is_InputState_PythonToCpp_InputState_PTR_Convertible,
        InputState_PTR_CppToPython_InputState,
        InputState_COPY_CppToPython_InputState);

    Shiboken::Conversions::registerConverterName(converter, "Qt3DExtras::QAbstractCameraController::InputState");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DExtras::QAbstractCameraController::InputState*");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DExtras::QAbstractCameraController::InputState&");
    Shiboken::Conversions::registerConverterName(converter, "QAbstractCameraController::InputState");
    Shiboken::Conversions::registerConverterName(converter, "QAbstractCameraController::InputState*");
    Shiboken::Conversions::registerConverterName(converter, "QAbstractCameraController::InputState&");
    Shiboken::Conversions::registerConverterName(converter, "InputState");
    Shiboken::Conversions::registerConverterName(converter, "InputState*");
    Shiboken::Conversions::registerConverterName(converter, "InputState&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::Qt3DExtras::QAbstractCameraController::InputState).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        InputState_PythonToCpp_InputState_COPY,
        is_InputState_PythonToCpp_InputState_COPY_Convertible);

    qRegisterMetaType< ::Qt3DExtras::QAbstractCameraController::InputState >("InputState");
    qRegisterMetaType< ::Qt3DExtras::QAbstractCameraController::InputState >("QAbstractCameraController::InputState");
    qRegisterMetaType< ::Qt3DExtras::QAbstractCameraController::InputState >("Qt3DExtras::QAbstractCameraController::InputState");
}
