/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qt3dinput_python.h"

// main header
#include "qt3dinput_qkeyevent_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>

using namespace Qt3DInput;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QKeyEventWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QKeyEventWrapper::QKeyEventWrapper(::QEvent::Type type, int key, ::QFlags<Qt::KeyboardModifier> modifiers, const ::QString & text, bool autorep, ushort count) : Qt3DInput::QKeyEvent(type, key, modifiers, text, autorep, count)
{
    resetPyMethodCache();
    // ... middle
}

QKeyEventWrapper::QKeyEventWrapper(const ::QKeyEvent & ke) : Qt3DInput::QKeyEvent(ke)
{
    resetPyMethodCache();
    // ... middle
}

void QKeyEventWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QKeyEventWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QKeyEventWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QKeyEventWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QKeyEventWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QKeyEvent.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QKeyEventWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QKeyEvent.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QKeyEventWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QKeyEventWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return Qt3DInput::QKeyEvent::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QKeyEventWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = Qt3DInput::QKeyEvent::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QKeyEventWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QKeyEventWrapper *>(this));
        return Qt3DInput::QKeyEvent::qt_metacast(_clname);
}

QKeyEventWrapper::~QKeyEventWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_Qt3DInput_QKeyEvent_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::Qt3DInput::QKeyEvent >()))
        return -1;

    ::QKeyEventWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DInput.Qt3DInput.QKeyEvent.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_Qt3DInput_QKeyEvent_Init_TypeError;
    } else if (numArgs == 2)
        goto Sbk_Qt3DInput_QKeyEvent_Init_TypeError;

    if (!PyArg_ParseTuple(args, "|OOOOOO:QKeyEvent", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return -1;


    // Overloaded function decisor
    // 0: QKeyEvent::QKeyEvent(QEvent::Type,int,QFlags<Qt::KeyboardModifier>,QString,bool,ushort)
    // 1: QKeyEvent::QKeyEvent(QKeyEvent)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QKeyEvent(QKeyEvent)
    } else if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // QKeyEvent(QEvent::Type,int,QFlags<Qt::KeyboardModifier>,QString,bool,ushort)
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3])))) {
            if (numArgs == 4) {
                overloadId = 0; // QKeyEvent(QEvent::Type,int,QFlags<Qt::KeyboardModifier>,QString,bool,ushort)
            } else if (numArgs >= 5
                && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[4])))) {
                if (numArgs == 5) {
                    overloadId = 0; // QKeyEvent(QEvent::Type,int,QFlags<Qt::KeyboardModifier>,QString,bool,ushort)
                } else if (numArgs >= 6
                    && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<ushort>(), (pyArgs[5])))) {
                    overloadId = 0; // QKeyEvent(QEvent::Type,int,QFlags<Qt::KeyboardModifier>,QString,bool,ushort)
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DInput_QKeyEvent_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QKeyEvent(QEvent::Type type, int key, QFlags<Qt::KeyboardModifier> modifiers, const QString & text, bool autorep, ushort count)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_text = Shiboken::String::createStaticString("text");
                if (PyDict_Contains(kwds, key_text)) {
                    value = PyDict_GetItem(kwds, key_text);
                    if (value && pyArgs[3]) {
                        errInfo = key_text;
                        Py_INCREF(errInfo);
                        goto Sbk_Qt3DInput_QKeyEvent_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3]))))
                            goto Sbk_Qt3DInput_QKeyEvent_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_text);
                }
                static PyObject *const key_autorep = Shiboken::String::createStaticString("autorep");
                if (PyDict_Contains(kwds, key_autorep)) {
                    value = PyDict_GetItem(kwds, key_autorep);
                    if (value && pyArgs[4]) {
                        errInfo = key_autorep;
                        Py_INCREF(errInfo);
                        goto Sbk_Qt3DInput_QKeyEvent_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[4]))))
                            goto Sbk_Qt3DInput_QKeyEvent_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_autorep);
                }
                static PyObject *const key_count = Shiboken::String::createStaticString("count");
                if (PyDict_Contains(kwds, key_count)) {
                    value = PyDict_GetItem(kwds, key_count);
                    if (value && pyArgs[5]) {
                        errInfo = key_count;
                        Py_INCREF(errInfo);
                        goto Sbk_Qt3DInput_QKeyEvent_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[5] = value;
                        if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<ushort>(), (pyArgs[5]))))
                            goto Sbk_Qt3DInput_QKeyEvent_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_count);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            ::QEvent::Type cppArg0{QEvent::None};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<Qt::KeyboardModifier> cppArg2 = QFlags<Qt::KeyboardModifier>(0);
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3 = QString();
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
            bool cppArg4 = false;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);
            ushort cppArg5 = 1;
            if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);

            if (!PyErr_Occurred()) {
                // QKeyEvent(QEvent::Type,int,QFlags<Qt::KeyboardModifier>,QString,bool,ushort)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QKeyEventWrapper(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QKeyEventWrapper(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
                }

            }
            break;
        }
        case 1: // QKeyEvent(const QKeyEvent & ke)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_Qt3DInput_QKeyEvent_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QKeyEvent *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QKeyEvent(QKeyEvent)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QKeyEventWrapper(*cppArg0);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QKeyEventWrapper(*cppArg0);
                }

            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::Qt3DInput::QKeyEvent >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_Qt3DInput_QKeyEvent_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_Qt3DInput_QKeyEvent_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_Qt3DInput_QKeyEvent_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_Qt3DInput_QKeyEventFunc_count(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DInput::QKeyEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QKEYEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DInput.Qt3DInput.QKeyEvent.count";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // count()const
            int cppResult = const_cast<const ::Qt3DInput::QKeyEvent *>(cppSelf)->count();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DInput_QKeyEventFunc_isAccepted(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DInput::QKeyEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QKEYEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DInput.Qt3DInput.QKeyEvent.isAccepted";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isAccepted()const
            bool cppResult = const_cast<const ::Qt3DInput::QKeyEvent *>(cppSelf)->isAccepted();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DInput_QKeyEventFunc_isAutoRepeat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DInput::QKeyEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QKEYEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DInput.Qt3DInput.QKeyEvent.isAutoRepeat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isAutoRepeat()const
            bool cppResult = const_cast<const ::Qt3DInput::QKeyEvent *>(cppSelf)->isAutoRepeat();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DInput_QKeyEventFunc_key(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DInput::QKeyEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QKEYEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DInput.Qt3DInput.QKeyEvent.key";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // key()const
            int cppResult = const_cast<const ::Qt3DInput::QKeyEvent *>(cppSelf)->key();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DInput_QKeyEventFunc_matches(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DInput::QKeyEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QKEYEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DInput.Qt3DInput.QKeyEvent.matches";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QKeyEvent::matches(QKeySequence::StandardKey)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX])->converter, (pyArg)))) {
        overloadId = 0; // matches(QKeySequence::StandardKey)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DInput_QKeyEventFunc_matches_TypeError;

    // Call function/method
    {
        ::QKeySequence::StandardKey cppArg0{QKeySequence::UnknownKey};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // matches(QKeySequence::StandardKey)const
            bool cppResult = const_cast<const ::Qt3DInput::QKeyEvent *>(cppSelf)->matches(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_Qt3DInput_QKeyEventFunc_matches_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DInput_QKeyEventFunc_modifiers(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DInput::QKeyEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QKEYEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DInput.Qt3DInput.QKeyEvent.modifiers";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // modifiers()const
            int cppResult = const_cast<const ::Qt3DInput::QKeyEvent *>(cppSelf)->modifiers();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DInput_QKeyEventFunc_nativeScanCode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DInput::QKeyEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QKEYEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DInput.Qt3DInput.QKeyEvent.nativeScanCode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // nativeScanCode()const
            quint32 cppResult = const_cast<const ::Qt3DInput::QKeyEvent *>(cppSelf)->nativeScanCode();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DInput_QKeyEventFunc_setAccepted(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DInput::QKeyEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QKEYEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DInput.Qt3DInput.QKeyEvent.setAccepted";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QKeyEvent::setAccepted(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAccepted(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DInput_QKeyEventFunc_setAccepted_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAccepted(bool)
            cppSelf->setAccepted(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DInput_QKeyEventFunc_setAccepted_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DInput_QKeyEventFunc_text(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DInput::QKeyEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QKEYEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DInput.Qt3DInput.QKeyEvent.text";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // text()const
            QString cppResult = const_cast<const ::Qt3DInput::QKeyEvent *>(cppSelf)->text();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DInput_QKeyEventFunc_type(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DInput::QKeyEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QKEYEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DInput.Qt3DInput.QKeyEvent.type";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // type()const
            QEvent::Type cppResult = const_cast<const ::Qt3DInput::QKeyEvent *>(cppSelf)->type();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_Qt3DInput_QKeyEvent_PropertyStrings[] = {
    "accepted:isAccepted:",
    "count:",
    "isAutoRepeat:",
    "key:",
    "modifiers:",
    "nativeScanCode:",
    "text:",
    nullptr // Sentinel
};

static PyMethodDef Sbk_Qt3DInput_QKeyEvent_methods[] = {
    {"count", reinterpret_cast<PyCFunction>(Sbk_Qt3DInput_QKeyEventFunc_count), METH_NOARGS},
    {"isAccepted", reinterpret_cast<PyCFunction>(Sbk_Qt3DInput_QKeyEventFunc_isAccepted), METH_NOARGS},
    {"isAutoRepeat", reinterpret_cast<PyCFunction>(Sbk_Qt3DInput_QKeyEventFunc_isAutoRepeat), METH_NOARGS},
    {"key", reinterpret_cast<PyCFunction>(Sbk_Qt3DInput_QKeyEventFunc_key), METH_NOARGS},
    {"matches", reinterpret_cast<PyCFunction>(Sbk_Qt3DInput_QKeyEventFunc_matches), METH_O},
    {"modifiers", reinterpret_cast<PyCFunction>(Sbk_Qt3DInput_QKeyEventFunc_modifiers), METH_NOARGS},
    {"nativeScanCode", reinterpret_cast<PyCFunction>(Sbk_Qt3DInput_QKeyEventFunc_nativeScanCode), METH_NOARGS},
    {"setAccepted", reinterpret_cast<PyCFunction>(Sbk_Qt3DInput_QKeyEventFunc_setAccepted), METH_O},
    {"text", reinterpret_cast<PyCFunction>(Sbk_Qt3DInput_QKeyEventFunc_text), METH_NOARGS},
    {"type", reinterpret_cast<PyCFunction>(Sbk_Qt3DInput_QKeyEventFunc_type), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_Qt3DInput_QKeyEvent_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::Qt3DInput::QKeyEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QKEYEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QKeyEventWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_Qt3DInput_QKeyEvent_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_Qt3DInput_QKeyEvent_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_Qt3DInput_QKeyEvent_Type = nullptr;
static SbkObjectType *Sbk_Qt3DInput_QKeyEvent_TypeF(void)
{
    return _Sbk_Qt3DInput_QKeyEvent_Type;
}

static PyType_Slot Sbk_Qt3DInput_QKeyEvent_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_Qt3DInput_QKeyEvent_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Qt3DInput_QKeyEvent_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Qt3DInput_QKeyEvent_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Qt3DInput_QKeyEvent_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_Qt3DInput_QKeyEvent_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_Qt3DInput_QKeyEvent_spec = {
    "2:PySide2.Qt3DInput.Qt3DInput.QKeyEvent",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_Qt3DInput_QKeyEvent_slots
};

} //extern "C"

static void *Sbk_Qt3DInput_QKeyEvent_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::Qt3DInput::QKeyEvent *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QKeyEvent_PythonToCpp_QKeyEvent_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_Qt3DInput_QKeyEvent_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QKeyEvent_PythonToCpp_QKeyEvent_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_Qt3DInput_QKeyEvent_TypeF())))
        return QKeyEvent_PythonToCpp_QKeyEvent_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QKeyEvent_PTR_CppToPython_QKeyEvent(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::Qt3DInput::QKeyEvent *>(const_cast<void *>(cppIn)), Sbk_Qt3DInput_QKeyEvent_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *Qt3DInput_QKeyEvent_SignatureStrings[] = {
    "1:PySide2.Qt3DInput.Qt3DInput.QKeyEvent(self,type:PySide2.QtCore.QEvent.Type,key:int,modifiers:PySide2.QtCore.Qt.KeyboardModifiers,text:QString=QString(),autorep:bool=false,count:ushort=1)",
    "0:PySide2.Qt3DInput.Qt3DInput.QKeyEvent(self,ke:PySide2.QtGui.QKeyEvent)",
    "PySide2.Qt3DInput.Qt3DInput.QKeyEvent.count(self)->int",
    "PySide2.Qt3DInput.Qt3DInput.QKeyEvent.isAccepted(self)->bool",
    "PySide2.Qt3DInput.Qt3DInput.QKeyEvent.isAutoRepeat(self)->bool",
    "PySide2.Qt3DInput.Qt3DInput.QKeyEvent.key(self)->int",
    "PySide2.Qt3DInput.Qt3DInput.QKeyEvent.matches(self,key_:PySide2.QtGui.QKeySequence.StandardKey)->bool",
    "PySide2.Qt3DInput.Qt3DInput.QKeyEvent.modifiers(self)->int",
    "PySide2.Qt3DInput.Qt3DInput.QKeyEvent.nativeScanCode(self)->quint32",
    "PySide2.Qt3DInput.Qt3DInput.QKeyEvent.setAccepted(self,accepted:bool)",
    "PySide2.Qt3DInput.Qt3DInput.QKeyEvent.text(self)->QString",
    "PySide2.Qt3DInput.Qt3DInput.QKeyEvent.type(self)->PySide2.QtCore.QEvent.Type",
    nullptr}; // Sentinel

void init_Qt3DInput_QKeyEvent(PyObject *enclosingClass)
{
    _Sbk_Qt3DInput_QKeyEvent_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QKeyEvent",
        "Qt3DInput::QKeyEvent*",
        &Sbk_Qt3DInput_QKeyEvent_spec,
        &Shiboken::callCppDestructor< ::Qt3DInput::QKeyEvent >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DInput_QKeyEvent_Type);
    InitSignatureStrings(pyType, Qt3DInput_QKeyEvent_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DInput_QKeyEvent_Type), Sbk_Qt3DInput_QKeyEvent_PropertyStrings);
    SbkPySide2_Qt3DInputTypes[SBK_QT3DINPUT_QKEYEVENT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_Qt3DInput_QKeyEvent_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_Qt3DInput_QKeyEvent_TypeF(),
        QKeyEvent_PythonToCpp_QKeyEvent_PTR,
        is_QKeyEvent_PythonToCpp_QKeyEvent_PTR_Convertible,
        QKeyEvent_PTR_CppToPython_QKeyEvent);

    Shiboken::Conversions::registerConverterName(converter, "Qt3DInput::QKeyEvent");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DInput::QKeyEvent*");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DInput::QKeyEvent&");
    Shiboken::Conversions::registerConverterName(converter, "QKeyEvent");
    Shiboken::Conversions::registerConverterName(converter, "QKeyEvent*");
    Shiboken::Conversions::registerConverterName(converter, "QKeyEvent&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::Qt3DInput::QKeyEvent).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QKeyEventWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_Qt3DInput_QKeyEvent_TypeF(), &Sbk_Qt3DInput_QKeyEvent_typeDiscovery);

    PySide::Signal::registerSignals(Sbk_Qt3DInput_QKeyEvent_TypeF(), &::Qt3DInput::QKeyEvent::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_Qt3DInput_QKeyEvent_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_Qt3DInput_QKeyEvent_TypeF(), &::Qt3DInput::QKeyEvent::staticMetaObject, sizeof(QKeyEventWrapper));
}
