/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qt3drender_python.h"

// main header
#include "qt3drender_qabstracttexture_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>

using namespace Qt3DRender;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QAbstractTextureWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QAbstractTextureWrapper::QAbstractTextureWrapper(::Qt3DCore::QNode * parent) : Qt3DRender::QAbstractTexture(parent)
{
    resetPyMethodCache();
    // ... middle
}

QAbstractTextureWrapper::QAbstractTextureWrapper(::Qt3DRender::QAbstractTexture::Target target, ::Qt3DCore::QNode * parent) : Qt3DRender::QAbstractTexture(target, parent)
{
    resetPyMethodCache();
    // ... middle
}

void QAbstractTextureWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractTextureWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractTextureWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractTextureWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QAbstractTextureWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractTexture.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QAbstractTextureWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractTexture.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QAbstractTextureWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QAbstractTextureWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return Qt3DRender::QAbstractTexture::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QAbstractTextureWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = Qt3DRender::QAbstractTexture::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QAbstractTextureWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QAbstractTextureWrapper *>(this));
        return Qt3DRender::QAbstractTexture::qt_metacast(_clname);
}

QAbstractTextureWrapper::~QAbstractTextureWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_Qt3DRender_QAbstractTexture_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::Qt3DRender::QAbstractTexture >()))
        return -1;

    ::QAbstractTextureWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|OO:QAbstractTexture", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QAbstractTexture::QAbstractTexture(Qt3DCore::QNode*)
    // 1: QAbstractTexture::QAbstractTexture(Qt3DRender::QAbstractTexture::Target,Qt3DCore::QNode*)
    if (numArgs == 0) {
        overloadId = 0; // QAbstractTexture(Qt3DCore::QNode*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TARGET_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // QAbstractTexture(Qt3DRender::QAbstractTexture::Target,Qt3DCore::QNode*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), (pyArgs[1])))) {
            overloadId = 1; // QAbstractTexture(Qt3DRender::QAbstractTexture::Target,Qt3DCore::QNode*)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QAbstractTexture(Qt3DCore::QNode*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QAbstractTexture_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QAbstractTexture(Qt3DCore::QNode * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[0]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_Qt3DRender_QAbstractTexture_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), (pyArgs[0]))))
                            goto Sbk_Qt3DRender_QAbstractTexture_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::Qt3DCore::QNode *cppArg0 = nullptr;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QAbstractTexture(Qt3DCore::QNode*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QAbstractTextureWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QAbstractTextureWrapper(cppArg0);
                }

                Shiboken::Object::setParent(pyArgs[0], self);
            }
            break;
        }
        case 1: // QAbstractTexture(Qt3DRender::QAbstractTexture::Target target, Qt3DCore::QNode * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[1]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_Qt3DRender_QAbstractTexture_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), (pyArgs[1]))))
                            goto Sbk_Qt3DRender_QAbstractTexture_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            ::Qt3DRender::QAbstractTexture::Target cppArg0{Qt3DRender::QAbstractTexture::TargetAutomatic};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::Qt3DCore::QNode *cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QAbstractTexture(Qt3DRender::QAbstractTexture::Target,Qt3DCore::QNode*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QAbstractTextureWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QAbstractTextureWrapper(cppArg0, cppArg1);
                }

                Shiboken::Object::setParent(pyArgs[1], self);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::Qt3DRender::QAbstractTexture >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_Qt3DRender_QAbstractTexture_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_Qt3DRender_QAbstractTexture_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_Qt3DRender_QAbstractTexture_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_Qt3DRender_QAbstractTextureFunc_addTextureImage(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.addTextureImage";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractTexture::addTextureImage(Qt3DRender::QAbstractTextureImage*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTUREIMAGE_IDX]), (pyArg)))) {
        overloadId = 0; // addTextureImage(Qt3DRender::QAbstractTextureImage*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QAbstractTextureFunc_addTextureImage_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::Qt3DRender::QAbstractTextureImage *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // addTextureImage(Qt3DRender::QAbstractTextureImage*)
            cppSelf->addTextureImage(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QAbstractTextureFunc_addTextureImage_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QAbstractTextureFunc_comparisonFunction(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.comparisonFunction";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // comparisonFunction()const
            Qt3DRender::QAbstractTexture::ComparisonFunction cppResult = const_cast<const ::Qt3DRender::QAbstractTexture *>(cppSelf)->comparisonFunction();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_COMPARISONFUNCTION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QAbstractTextureFunc_comparisonMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.comparisonMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // comparisonMode()const
            Qt3DRender::QAbstractTexture::ComparisonMode cppResult = const_cast<const ::Qt3DRender::QAbstractTexture *>(cppSelf)->comparisonMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_COMPARISONMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QAbstractTextureFunc_depth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.depth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // depth()const
            int cppResult = const_cast<const ::Qt3DRender::QAbstractTexture *>(cppSelf)->depth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QAbstractTextureFunc_format(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.format";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // format()const
            Qt3DRender::QAbstractTexture::TextureFormat cppResult = const_cast<const ::Qt3DRender::QAbstractTexture *>(cppSelf)->format();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QAbstractTextureFunc_generateMipMaps(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.generateMipMaps";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // generateMipMaps()const
            bool cppResult = const_cast<const ::Qt3DRender::QAbstractTexture *>(cppSelf)->generateMipMaps();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QAbstractTextureFunc_handle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.handle";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // handle()const
            QVariant cppResult = const_cast<const ::Qt3DRender::QAbstractTexture *>(cppSelf)->handle();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QAbstractTextureFunc_handleType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.handleType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // handleType()const
            Qt3DRender::QAbstractTexture::HandleType cppResult = const_cast<const ::Qt3DRender::QAbstractTexture *>(cppSelf)->handleType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_HANDLETYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QAbstractTextureFunc_height(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.height";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // height()const
            int cppResult = const_cast<const ::Qt3DRender::QAbstractTexture *>(cppSelf)->height();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QAbstractTextureFunc_layers(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.layers";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // layers()const
            int cppResult = const_cast<const ::Qt3DRender::QAbstractTexture *>(cppSelf)->layers();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QAbstractTextureFunc_magnificationFilter(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.magnificationFilter";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // magnificationFilter()const
            Qt3DRender::QAbstractTexture::Filter cppResult = const_cast<const ::Qt3DRender::QAbstractTexture *>(cppSelf)->magnificationFilter();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_FILTER_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QAbstractTextureFunc_maximumAnisotropy(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.maximumAnisotropy";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maximumAnisotropy()const
            float cppResult = const_cast<const ::Qt3DRender::QAbstractTexture *>(cppSelf)->maximumAnisotropy();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QAbstractTextureFunc_minificationFilter(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.minificationFilter";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // minificationFilter()const
            Qt3DRender::QAbstractTexture::Filter cppResult = const_cast<const ::Qt3DRender::QAbstractTexture *>(cppSelf)->minificationFilter();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_FILTER_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QAbstractTextureFunc_removeTextureImage(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.removeTextureImage";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractTexture::removeTextureImage(Qt3DRender::QAbstractTextureImage*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTUREIMAGE_IDX]), (pyArg)))) {
        overloadId = 0; // removeTextureImage(Qt3DRender::QAbstractTextureImage*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QAbstractTextureFunc_removeTextureImage_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::Qt3DRender::QAbstractTextureImage *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // removeTextureImage(Qt3DRender::QAbstractTextureImage*)
            cppSelf->removeTextureImage(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QAbstractTextureFunc_removeTextureImage_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QAbstractTextureFunc_samples(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.samples";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // samples()const
            int cppResult = const_cast<const ::Qt3DRender::QAbstractTexture *>(cppSelf)->samples();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QAbstractTextureFunc_setComparisonFunction(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.setComparisonFunction";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractTexture::setComparisonFunction(Qt3DRender::QAbstractTexture::ComparisonFunction)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_COMPARISONFUNCTION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setComparisonFunction(Qt3DRender::QAbstractTexture::ComparisonFunction)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QAbstractTextureFunc_setComparisonFunction_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QAbstractTexture::ComparisonFunction cppArg0 = static_cast< ::Qt3DRender::QAbstractTexture::ComparisonFunction>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setComparisonFunction(Qt3DRender::QAbstractTexture::ComparisonFunction)
            cppSelf->setComparisonFunction(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QAbstractTextureFunc_setComparisonFunction_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QAbstractTextureFunc_setComparisonMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.setComparisonMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractTexture::setComparisonMode(Qt3DRender::QAbstractTexture::ComparisonMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_COMPARISONMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setComparisonMode(Qt3DRender::QAbstractTexture::ComparisonMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QAbstractTextureFunc_setComparisonMode_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QAbstractTexture::ComparisonMode cppArg0{Qt3DRender::QAbstractTexture::CompareNone};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setComparisonMode(Qt3DRender::QAbstractTexture::ComparisonMode)
            cppSelf->setComparisonMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QAbstractTextureFunc_setComparisonMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QAbstractTextureFunc_setDepth(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.setDepth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractTexture::setDepth(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setDepth(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QAbstractTextureFunc_setDepth_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDepth(int)
            cppSelf->setDepth(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QAbstractTextureFunc_setDepth_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QAbstractTextureFunc_setFormat(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.setFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractTexture::setFormat(Qt3DRender::QAbstractTexture::TextureFormat)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setFormat(Qt3DRender::QAbstractTexture::TextureFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QAbstractTextureFunc_setFormat_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QAbstractTexture::TextureFormat cppArg0{Qt3DRender::QAbstractTexture::NoFormat};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFormat(Qt3DRender::QAbstractTexture::TextureFormat)
            cppSelf->setFormat(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QAbstractTextureFunc_setFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QAbstractTextureFunc_setGenerateMipMaps(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.setGenerateMipMaps";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractTexture::setGenerateMipMaps(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setGenerateMipMaps(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QAbstractTextureFunc_setGenerateMipMaps_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setGenerateMipMaps(bool)
            cppSelf->setGenerateMipMaps(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QAbstractTextureFunc_setGenerateMipMaps_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QAbstractTextureFunc_setHandle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.setHandle";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractTexture::setHandle(QVariant)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArg)))) {
        overloadId = 0; // setHandle(QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QAbstractTextureFunc_setHandle_TypeError;

    // Call function/method
    {
        ::QVariant cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setHandle(QVariant)
            cppSelf->setHandle(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QAbstractTextureFunc_setHandle_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QAbstractTextureFunc_setHandleType(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.setHandleType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractTexture::setHandleType(Qt3DRender::QAbstractTexture::HandleType)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_HANDLETYPE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setHandleType(Qt3DRender::QAbstractTexture::HandleType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QAbstractTextureFunc_setHandleType_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QAbstractTexture::HandleType cppArg0{Qt3DRender::QAbstractTexture::NoHandle};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setHandleType(Qt3DRender::QAbstractTexture::HandleType)
            cppSelf->setHandleType(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QAbstractTextureFunc_setHandleType_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QAbstractTextureFunc_setHeight(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.setHeight";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractTexture::setHeight(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setHeight(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QAbstractTextureFunc_setHeight_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setHeight(int)
            cppSelf->setHeight(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QAbstractTextureFunc_setHeight_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QAbstractTextureFunc_setLayers(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.setLayers";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractTexture::setLayers(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setLayers(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QAbstractTextureFunc_setLayers_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLayers(int)
            cppSelf->setLayers(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QAbstractTextureFunc_setLayers_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QAbstractTextureFunc_setMagnificationFilter(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.setMagnificationFilter";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractTexture::setMagnificationFilter(Qt3DRender::QAbstractTexture::Filter)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_FILTER_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setMagnificationFilter(Qt3DRender::QAbstractTexture::Filter)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QAbstractTextureFunc_setMagnificationFilter_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QAbstractTexture::Filter cppArg0 = static_cast< ::Qt3DRender::QAbstractTexture::Filter>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMagnificationFilter(Qt3DRender::QAbstractTexture::Filter)
            cppSelf->setMagnificationFilter(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QAbstractTextureFunc_setMagnificationFilter_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QAbstractTextureFunc_setMaximumAnisotropy(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.setMaximumAnisotropy";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractTexture::setMaximumAnisotropy(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // setMaximumAnisotropy(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QAbstractTextureFunc_setMaximumAnisotropy_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMaximumAnisotropy(float)
            cppSelf->setMaximumAnisotropy(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QAbstractTextureFunc_setMaximumAnisotropy_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QAbstractTextureFunc_setMinificationFilter(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.setMinificationFilter";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractTexture::setMinificationFilter(Qt3DRender::QAbstractTexture::Filter)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_FILTER_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setMinificationFilter(Qt3DRender::QAbstractTexture::Filter)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QAbstractTextureFunc_setMinificationFilter_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QAbstractTexture::Filter cppArg0 = static_cast< ::Qt3DRender::QAbstractTexture::Filter>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMinificationFilter(Qt3DRender::QAbstractTexture::Filter)
            cppSelf->setMinificationFilter(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QAbstractTextureFunc_setMinificationFilter_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QAbstractTextureFunc_setSamples(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.setSamples";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractTexture::setSamples(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setSamples(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QAbstractTextureFunc_setSamples_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSamples(int)
            cppSelf->setSamples(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QAbstractTextureFunc_setSamples_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QAbstractTextureFunc_setSize(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.setSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_Qt3DRender_QAbstractTextureFunc_setSize_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_Qt3DRender_QAbstractTextureFunc_setSize_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:setSize", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractTexture::setSize(int,int,int)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setSize(int,int,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // setSize(int,int,int)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
                overloadId = 0; // setSize(int,int,int)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QAbstractTextureFunc_setSize_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_height = Shiboken::String::createStaticString("height");
            if (PyDict_Contains(kwds, key_height)) {
                value = PyDict_GetItem(kwds, key_height);
                if (value && pyArgs[1]) {
                    errInfo = key_height;
                    Py_INCREF(errInfo);
                    goto Sbk_Qt3DRender_QAbstractTextureFunc_setSize_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                        goto Sbk_Qt3DRender_QAbstractTextureFunc_setSize_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_height);
            }
            static PyObject *const key_depth = Shiboken::String::createStaticString("depth");
            if (PyDict_Contains(kwds, key_depth)) {
                value = PyDict_GetItem(kwds, key_depth);
                if (value && pyArgs[2]) {
                    errInfo = key_depth;
                    Py_INCREF(errInfo);
                    goto Sbk_Qt3DRender_QAbstractTextureFunc_setSize_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                        goto Sbk_Qt3DRender_QAbstractTextureFunc_setSize_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_depth);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_Qt3DRender_QAbstractTextureFunc_setSize_TypeError;
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = 1;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2 = 1;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // setSize(int,int,int)
            cppSelf->setSize(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QAbstractTextureFunc_setSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QAbstractTextureFunc_setStatus(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.setStatus";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractTexture::setStatus(Qt3DRender::QAbstractTexture::Status)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_STATUS_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setStatus(Qt3DRender::QAbstractTexture::Status)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QAbstractTextureFunc_setStatus_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QAbstractTexture::Status cppArg0{Qt3DRender::QAbstractTexture::None};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setStatus(Qt3DRender::QAbstractTexture::Status)
            cppSelf->setStatus(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QAbstractTextureFunc_setStatus_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QAbstractTextureFunc_setWidth(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.setWidth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractTexture::setWidth(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setWidth(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QAbstractTextureFunc_setWidth_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setWidth(int)
            cppSelf->setWidth(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QAbstractTextureFunc_setWidth_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QAbstractTextureFunc_setWrapMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.setWrapMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractTexture::setWrapMode(Qt3DRender::QTextureWrapMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREWRAPMODE_IDX]), (pyArg)))) {
        overloadId = 0; // setWrapMode(Qt3DRender::QTextureWrapMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QAbstractTextureFunc_setWrapMode_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::Qt3DRender::QTextureWrapMode *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setWrapMode(Qt3DRender::QTextureWrapMode)
            cppSelf->setWrapMode(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QAbstractTextureFunc_setWrapMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QAbstractTextureFunc_status(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.status";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // status()const
            Qt3DRender::QAbstractTexture::Status cppResult = const_cast<const ::Qt3DRender::QAbstractTexture *>(cppSelf)->status();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_STATUS_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QAbstractTextureFunc_target(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.target";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // target()const
            Qt3DRender::QAbstractTexture::Target cppResult = const_cast<const ::Qt3DRender::QAbstractTexture *>(cppSelf)->target();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TARGET_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QAbstractTextureFunc_textureImages(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.textureImages";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // textureImages()const
            QVector<Qt3DRender::QAbstractTextureImage* > cppResult = const_cast<const ::Qt3DRender::QAbstractTexture *>(cppSelf)->textureImages();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_Qt3DRenderTypeConverters[SBK_QT3DRENDER_QVECTOR_QT3DRENDER_QABSTRACTTEXTUREIMAGEPTR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QAbstractTextureFunc_width(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.width";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // width()const
            int cppResult = const_cast<const ::Qt3DRender::QAbstractTexture *>(cppSelf)->width();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QAbstractTextureFunc_wrapMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QAbstractTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.wrapMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // wrapMode()
            Qt3DRender::QTextureWrapMode * cppResult = cppSelf->wrapMode();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREWRAPMODE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_Qt3DRender_QAbstractTexture_PropertyStrings[] = {
    "comparisonFunction::",
    "comparisonMode::",
    "depth::",
    "format::",
    "generateMipMaps::",
    "handle:",
    "handleType:",
    "height::",
    "layers::",
    "magnificationFilter::",
    "maximumAnisotropy::",
    "minificationFilter::",
    "samples::",
    "status:",
    "target:",
    "width::",
    "wrapMode:",
    nullptr // Sentinel
};

static PyMethodDef Sbk_Qt3DRender_QAbstractTexture_methods[] = {
    {"addTextureImage", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractTextureFunc_addTextureImage), METH_O},
    {"comparisonFunction", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractTextureFunc_comparisonFunction), METH_NOARGS},
    {"comparisonMode", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractTextureFunc_comparisonMode), METH_NOARGS},
    {"depth", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractTextureFunc_depth), METH_NOARGS},
    {"format", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractTextureFunc_format), METH_NOARGS},
    {"generateMipMaps", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractTextureFunc_generateMipMaps), METH_NOARGS},
    {"handle", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractTextureFunc_handle), METH_NOARGS},
    {"handleType", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractTextureFunc_handleType), METH_NOARGS},
    {"height", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractTextureFunc_height), METH_NOARGS},
    {"layers", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractTextureFunc_layers), METH_NOARGS},
    {"magnificationFilter", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractTextureFunc_magnificationFilter), METH_NOARGS},
    {"maximumAnisotropy", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractTextureFunc_maximumAnisotropy), METH_NOARGS},
    {"minificationFilter", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractTextureFunc_minificationFilter), METH_NOARGS},
    {"removeTextureImage", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractTextureFunc_removeTextureImage), METH_O},
    {"samples", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractTextureFunc_samples), METH_NOARGS},
    {"setComparisonFunction", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractTextureFunc_setComparisonFunction), METH_O},
    {"setComparisonMode", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractTextureFunc_setComparisonMode), METH_O},
    {"setDepth", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractTextureFunc_setDepth), METH_O},
    {"setFormat", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractTextureFunc_setFormat), METH_O},
    {"setGenerateMipMaps", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractTextureFunc_setGenerateMipMaps), METH_O},
    {"setHandle", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractTextureFunc_setHandle), METH_O},
    {"setHandleType", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractTextureFunc_setHandleType), METH_O},
    {"setHeight", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractTextureFunc_setHeight), METH_O},
    {"setLayers", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractTextureFunc_setLayers), METH_O},
    {"setMagnificationFilter", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractTextureFunc_setMagnificationFilter), METH_O},
    {"setMaximumAnisotropy", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractTextureFunc_setMaximumAnisotropy), METH_O},
    {"setMinificationFilter", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractTextureFunc_setMinificationFilter), METH_O},
    {"setSamples", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractTextureFunc_setSamples), METH_O},
    {"setSize", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractTextureFunc_setSize), METH_VARARGS|METH_KEYWORDS},
    {"setStatus", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractTextureFunc_setStatus), METH_O},
    {"setWidth", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractTextureFunc_setWidth), METH_O},
    {"setWrapMode", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractTextureFunc_setWrapMode), METH_O},
    {"status", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractTextureFunc_status), METH_NOARGS},
    {"target", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractTextureFunc_target), METH_NOARGS},
    {"textureImages", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractTextureFunc_textureImages), METH_NOARGS},
    {"width", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractTextureFunc_width), METH_NOARGS},
    {"wrapMode", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QAbstractTextureFunc_wrapMode), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_Qt3DRender_QAbstractTexture_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::Qt3DRender::QAbstractTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QAbstractTextureWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_Qt3DRender_QAbstractTexture_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_Qt3DRender_QAbstractTexture_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_Qt3DRender_QAbstractTexture_Type = nullptr;
static SbkObjectType *Sbk_Qt3DRender_QAbstractTexture_TypeF(void)
{
    return _Sbk_Qt3DRender_QAbstractTexture_Type;
}

static PyType_Slot Sbk_Qt3DRender_QAbstractTexture_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_Qt3DRender_QAbstractTexture_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Qt3DRender_QAbstractTexture_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Qt3DRender_QAbstractTexture_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Qt3DRender_QAbstractTexture_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_Qt3DRender_QAbstractTexture_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_Qt3DRender_QAbstractTexture_spec = {
    "2:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_Qt3DRender_QAbstractTexture_slots
};

} //extern "C"

static void *Sbk_Qt3DRender_QAbstractTexture_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::Qt3DRender::QAbstractTexture *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Qt3DRender_QAbstractTexture_Status_PythonToCpp_Qt3DRender_QAbstractTexture_Status(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DRender::QAbstractTexture::Status *>(cppOut) =
        static_cast<::Qt3DRender::QAbstractTexture::Status>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DRender_QAbstractTexture_Status_PythonToCpp_Qt3DRender_QAbstractTexture_Status_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_STATUS_IDX]))
        return Qt3DRender_QAbstractTexture_Status_PythonToCpp_Qt3DRender_QAbstractTexture_Status;
    return {};
}
static PyObject *Qt3DRender_QAbstractTexture_Status_CppToPython_Qt3DRender_QAbstractTexture_Status(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DRender::QAbstractTexture::Status *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_STATUS_IDX], castCppIn);

}

static void Qt3DRender_QAbstractTexture_Target_PythonToCpp_Qt3DRender_QAbstractTexture_Target(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DRender::QAbstractTexture::Target *>(cppOut) =
        static_cast<::Qt3DRender::QAbstractTexture::Target>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DRender_QAbstractTexture_Target_PythonToCpp_Qt3DRender_QAbstractTexture_Target_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TARGET_IDX]))
        return Qt3DRender_QAbstractTexture_Target_PythonToCpp_Qt3DRender_QAbstractTexture_Target;
    return {};
}
static PyObject *Qt3DRender_QAbstractTexture_Target_CppToPython_Qt3DRender_QAbstractTexture_Target(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DRender::QAbstractTexture::Target *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TARGET_IDX], castCppIn);

}

static void Qt3DRender_QAbstractTexture_TextureFormat_PythonToCpp_Qt3DRender_QAbstractTexture_TextureFormat(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DRender::QAbstractTexture::TextureFormat *>(cppOut) =
        static_cast<::Qt3DRender::QAbstractTexture::TextureFormat>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DRender_QAbstractTexture_TextureFormat_PythonToCpp_Qt3DRender_QAbstractTexture_TextureFormat_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX]))
        return Qt3DRender_QAbstractTexture_TextureFormat_PythonToCpp_Qt3DRender_QAbstractTexture_TextureFormat;
    return {};
}
static PyObject *Qt3DRender_QAbstractTexture_TextureFormat_CppToPython_Qt3DRender_QAbstractTexture_TextureFormat(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DRender::QAbstractTexture::TextureFormat *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX], castCppIn);

}

static void Qt3DRender_QAbstractTexture_Filter_PythonToCpp_Qt3DRender_QAbstractTexture_Filter(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DRender::QAbstractTexture::Filter *>(cppOut) =
        static_cast<::Qt3DRender::QAbstractTexture::Filter>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DRender_QAbstractTexture_Filter_PythonToCpp_Qt3DRender_QAbstractTexture_Filter_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_FILTER_IDX]))
        return Qt3DRender_QAbstractTexture_Filter_PythonToCpp_Qt3DRender_QAbstractTexture_Filter;
    return {};
}
static PyObject *Qt3DRender_QAbstractTexture_Filter_CppToPython_Qt3DRender_QAbstractTexture_Filter(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DRender::QAbstractTexture::Filter *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_FILTER_IDX], castCppIn);

}

static void Qt3DRender_QAbstractTexture_CubeMapFace_PythonToCpp_Qt3DRender_QAbstractTexture_CubeMapFace(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DRender::QAbstractTexture::CubeMapFace *>(cppOut) =
        static_cast<::Qt3DRender::QAbstractTexture::CubeMapFace>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DRender_QAbstractTexture_CubeMapFace_PythonToCpp_Qt3DRender_QAbstractTexture_CubeMapFace_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_CUBEMAPFACE_IDX]))
        return Qt3DRender_QAbstractTexture_CubeMapFace_PythonToCpp_Qt3DRender_QAbstractTexture_CubeMapFace;
    return {};
}
static PyObject *Qt3DRender_QAbstractTexture_CubeMapFace_CppToPython_Qt3DRender_QAbstractTexture_CubeMapFace(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DRender::QAbstractTexture::CubeMapFace *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_CUBEMAPFACE_IDX], castCppIn);

}

static void Qt3DRender_QAbstractTexture_ComparisonFunction_PythonToCpp_Qt3DRender_QAbstractTexture_ComparisonFunction(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DRender::QAbstractTexture::ComparisonFunction *>(cppOut) =
        static_cast<::Qt3DRender::QAbstractTexture::ComparisonFunction>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DRender_QAbstractTexture_ComparisonFunction_PythonToCpp_Qt3DRender_QAbstractTexture_ComparisonFunction_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_COMPARISONFUNCTION_IDX]))
        return Qt3DRender_QAbstractTexture_ComparisonFunction_PythonToCpp_Qt3DRender_QAbstractTexture_ComparisonFunction;
    return {};
}
static PyObject *Qt3DRender_QAbstractTexture_ComparisonFunction_CppToPython_Qt3DRender_QAbstractTexture_ComparisonFunction(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DRender::QAbstractTexture::ComparisonFunction *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_COMPARISONFUNCTION_IDX], castCppIn);

}

static void Qt3DRender_QAbstractTexture_ComparisonMode_PythonToCpp_Qt3DRender_QAbstractTexture_ComparisonMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DRender::QAbstractTexture::ComparisonMode *>(cppOut) =
        static_cast<::Qt3DRender::QAbstractTexture::ComparisonMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DRender_QAbstractTexture_ComparisonMode_PythonToCpp_Qt3DRender_QAbstractTexture_ComparisonMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_COMPARISONMODE_IDX]))
        return Qt3DRender_QAbstractTexture_ComparisonMode_PythonToCpp_Qt3DRender_QAbstractTexture_ComparisonMode;
    return {};
}
static PyObject *Qt3DRender_QAbstractTexture_ComparisonMode_CppToPython_Qt3DRender_QAbstractTexture_ComparisonMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DRender::QAbstractTexture::ComparisonMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_COMPARISONMODE_IDX], castCppIn);

}

static void Qt3DRender_QAbstractTexture_HandleType_PythonToCpp_Qt3DRender_QAbstractTexture_HandleType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DRender::QAbstractTexture::HandleType *>(cppOut) =
        static_cast<::Qt3DRender::QAbstractTexture::HandleType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DRender_QAbstractTexture_HandleType_PythonToCpp_Qt3DRender_QAbstractTexture_HandleType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_HANDLETYPE_IDX]))
        return Qt3DRender_QAbstractTexture_HandleType_PythonToCpp_Qt3DRender_QAbstractTexture_HandleType;
    return {};
}
static PyObject *Qt3DRender_QAbstractTexture_HandleType_CppToPython_Qt3DRender_QAbstractTexture_HandleType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DRender::QAbstractTexture::HandleType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_HANDLETYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QAbstractTexture_PythonToCpp_QAbstractTexture_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_Qt3DRender_QAbstractTexture_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QAbstractTexture_PythonToCpp_QAbstractTexture_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_Qt3DRender_QAbstractTexture_TypeF())))
        return QAbstractTexture_PythonToCpp_QAbstractTexture_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QAbstractTexture_PTR_CppToPython_QAbstractTexture(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::Qt3DRender::QAbstractTexture *>(const_cast<void *>(cppIn)), Sbk_Qt3DRender_QAbstractTexture_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *Qt3DRender_QAbstractTexture_SignatureStrings[] = {
    "1:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture(self,parent:PySide2.Qt3DCore.Qt3DCore.QNode=nullptr)",
    "0:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture(self,target:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Target,parent:PySide2.Qt3DCore.Qt3DCore.QNode=nullptr)",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.addTextureImage(self,textureImage:PySide2.Qt3DRender.Qt3DRender.QAbstractTextureImage)",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.comparisonFunction(self)->PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.ComparisonFunction",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.comparisonMode(self)->PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.ComparisonMode",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.depth(self)->int",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.format(self)->PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.TextureFormat",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.generateMipMaps(self)->bool",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.handle(self)->QVariant",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.handleType(self)->PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.HandleType",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.height(self)->int",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.layers(self)->int",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.magnificationFilter(self)->PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Filter",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.maximumAnisotropy(self)->float",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.minificationFilter(self)->PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Filter",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.removeTextureImage(self,textureImage:PySide2.Qt3DRender.Qt3DRender.QAbstractTextureImage)",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.samples(self)->int",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.setComparisonFunction(self,function:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.ComparisonFunction)",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.setComparisonMode(self,mode:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.ComparisonMode)",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.setDepth(self,depth:int)",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.setFormat(self,format:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.TextureFormat)",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.setGenerateMipMaps(self,gen:bool)",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.setHandle(self,handle:QVariant)",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.setHandleType(self,type:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.HandleType)",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.setHeight(self,height:int)",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.setLayers(self,layers:int)",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.setMagnificationFilter(self,f:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Filter)",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.setMaximumAnisotropy(self,anisotropy:float)",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.setMinificationFilter(self,f:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Filter)",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.setSamples(self,samples:int)",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.setSize(self,width:int,height:int=1,depth:int=1)",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.setStatus(self,status:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Status)",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.setWidth(self,width:int)",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.setWrapMode(self,wrapMode:PySide2.Qt3DRender.Qt3DRender.QTextureWrapMode)",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.status(self)->PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Status",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.target(self)->PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Target",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.textureImages(self)->QVector[PySide2.Qt3DRender.Qt3DRender.QAbstractTextureImage]",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.width(self)->int",
    "PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.wrapMode(self)->PySide2.Qt3DRender.Qt3DRender.QTextureWrapMode",
    nullptr}; // Sentinel

void init_Qt3DRender_QAbstractTexture(PyObject *enclosingClass)
{
    _Sbk_Qt3DRender_QAbstractTexture_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QAbstractTexture",
        "Qt3DRender::QAbstractTexture*",
        &Sbk_Qt3DRender_QAbstractTexture_spec,
        &Shiboken::callCppDestructor< ::Qt3DRender::QAbstractTexture >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DRender_QAbstractTexture_Type);
    InitSignatureStrings(pyType, Qt3DRender_QAbstractTexture_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DRender_QAbstractTexture_Type), Sbk_Qt3DRender_QAbstractTexture_PropertyStrings);
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_Qt3DRender_QAbstractTexture_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_Qt3DRender_QAbstractTexture_TypeF(),
        QAbstractTexture_PythonToCpp_QAbstractTexture_PTR,
        is_QAbstractTexture_PythonToCpp_QAbstractTexture_PTR_Convertible,
        QAbstractTexture_PTR_CppToPython_QAbstractTexture);

    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QAbstractTexture");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QAbstractTexture*");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QAbstractTexture&");
    Shiboken::Conversions::registerConverterName(converter, "QAbstractTexture");
    Shiboken::Conversions::registerConverterName(converter, "QAbstractTexture*");
    Shiboken::Conversions::registerConverterName(converter, "QAbstractTexture&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::Qt3DRender::QAbstractTexture).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAbstractTextureWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_Qt3DRender_QAbstractTexture_TypeF(), &Sbk_Qt3DRender_QAbstractTexture_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'Status'.
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_STATUS_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DRender_QAbstractTexture_TypeF(),
        "Status",
        "2:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Status",
        "Qt3DRender::QAbstractTexture::Status");
    if (!SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_STATUS_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_STATUS_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "None_", (long) Qt3DRender::QAbstractTexture::Status::None))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_STATUS_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "Loading", (long) Qt3DRender::QAbstractTexture::Status::Loading))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_STATUS_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "Ready", (long) Qt3DRender::QAbstractTexture::Status::Ready))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_STATUS_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "Error", (long) Qt3DRender::QAbstractTexture::Status::Error))
        return;
    // Register converter for enum 'Qt3DRender::QAbstractTexture::Status'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_STATUS_IDX],
            Qt3DRender_QAbstractTexture_Status_CppToPython_Qt3DRender_QAbstractTexture_Status);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DRender_QAbstractTexture_Status_PythonToCpp_Qt3DRender_QAbstractTexture_Status,
            is_Qt3DRender_QAbstractTexture_Status_PythonToCpp_Qt3DRender_QAbstractTexture_Status_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_STATUS_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QAbstractTexture::Status");
        Shiboken::Conversions::registerConverterName(converter, "QAbstractTexture::Status");
        Shiboken::Conversions::registerConverterName(converter, "Status");
    }
    // End of 'Status' enum.

    // Initialization of enum 'Target'.
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TARGET_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DRender_QAbstractTexture_TypeF(),
        "Target",
        "2:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Target",
        "Qt3DRender::QAbstractTexture::Target");
    if (!SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TARGET_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TARGET_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "TargetAutomatic", (long) Qt3DRender::QAbstractTexture::Target::TargetAutomatic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TARGET_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "Target1D", (long) Qt3DRender::QAbstractTexture::Target::Target1D))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TARGET_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "Target1DArray", (long) Qt3DRender::QAbstractTexture::Target::Target1DArray))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TARGET_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "Target2D", (long) Qt3DRender::QAbstractTexture::Target::Target2D))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TARGET_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "Target2DArray", (long) Qt3DRender::QAbstractTexture::Target::Target2DArray))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TARGET_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "Target3D", (long) Qt3DRender::QAbstractTexture::Target::Target3D))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TARGET_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "TargetCubeMap", (long) Qt3DRender::QAbstractTexture::Target::TargetCubeMap))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TARGET_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "TargetCubeMapArray", (long) Qt3DRender::QAbstractTexture::Target::TargetCubeMapArray))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TARGET_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "Target2DMultisample", (long) Qt3DRender::QAbstractTexture::Target::Target2DMultisample))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TARGET_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "Target2DMultisampleArray", (long) Qt3DRender::QAbstractTexture::Target::Target2DMultisampleArray))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TARGET_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "TargetRectangle", (long) Qt3DRender::QAbstractTexture::Target::TargetRectangle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TARGET_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "TargetBuffer", (long) Qt3DRender::QAbstractTexture::Target::TargetBuffer))
        return;
    // Register converter for enum 'Qt3DRender::QAbstractTexture::Target'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TARGET_IDX],
            Qt3DRender_QAbstractTexture_Target_CppToPython_Qt3DRender_QAbstractTexture_Target);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DRender_QAbstractTexture_Target_PythonToCpp_Qt3DRender_QAbstractTexture_Target,
            is_Qt3DRender_QAbstractTexture_Target_PythonToCpp_Qt3DRender_QAbstractTexture_Target_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TARGET_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QAbstractTexture::Target");
        Shiboken::Conversions::registerConverterName(converter, "QAbstractTexture::Target");
        Shiboken::Conversions::registerConverterName(converter, "Target");
    }
    // End of 'Target' enum.

    // Initialization of enum 'TextureFormat'.
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DRender_QAbstractTexture_TypeF(),
        "TextureFormat",
        "2:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.TextureFormat",
        "Qt3DRender::QAbstractTexture::TextureFormat");
    if (!SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "NoFormat", (long) Qt3DRender::QAbstractTexture::TextureFormat::NoFormat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "Automatic", (long) Qt3DRender::QAbstractTexture::TextureFormat::Automatic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "R8_UNorm", (long) Qt3DRender::QAbstractTexture::TextureFormat::R8_UNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RG8_UNorm", (long) Qt3DRender::QAbstractTexture::TextureFormat::RG8_UNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RGB8_UNorm", (long) Qt3DRender::QAbstractTexture::TextureFormat::RGB8_UNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RGBA8_UNorm", (long) Qt3DRender::QAbstractTexture::TextureFormat::RGBA8_UNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "R16_UNorm", (long) Qt3DRender::QAbstractTexture::TextureFormat::R16_UNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RG16_UNorm", (long) Qt3DRender::QAbstractTexture::TextureFormat::RG16_UNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RGB16_UNorm", (long) Qt3DRender::QAbstractTexture::TextureFormat::RGB16_UNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RGBA16_UNorm", (long) Qt3DRender::QAbstractTexture::TextureFormat::RGBA16_UNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "R8_SNorm", (long) Qt3DRender::QAbstractTexture::TextureFormat::R8_SNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RG8_SNorm", (long) Qt3DRender::QAbstractTexture::TextureFormat::RG8_SNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RGB8_SNorm", (long) Qt3DRender::QAbstractTexture::TextureFormat::RGB8_SNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RGBA8_SNorm", (long) Qt3DRender::QAbstractTexture::TextureFormat::RGBA8_SNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "R16_SNorm", (long) Qt3DRender::QAbstractTexture::TextureFormat::R16_SNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RG16_SNorm", (long) Qt3DRender::QAbstractTexture::TextureFormat::RG16_SNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RGB16_SNorm", (long) Qt3DRender::QAbstractTexture::TextureFormat::RGB16_SNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RGBA16_SNorm", (long) Qt3DRender::QAbstractTexture::TextureFormat::RGBA16_SNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "R8U", (long) Qt3DRender::QAbstractTexture::TextureFormat::R8U))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RG8U", (long) Qt3DRender::QAbstractTexture::TextureFormat::RG8U))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RGB8U", (long) Qt3DRender::QAbstractTexture::TextureFormat::RGB8U))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RGBA8U", (long) Qt3DRender::QAbstractTexture::TextureFormat::RGBA8U))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "R16U", (long) Qt3DRender::QAbstractTexture::TextureFormat::R16U))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RG16U", (long) Qt3DRender::QAbstractTexture::TextureFormat::RG16U))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RGB16U", (long) Qt3DRender::QAbstractTexture::TextureFormat::RGB16U))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RGBA16U", (long) Qt3DRender::QAbstractTexture::TextureFormat::RGBA16U))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "R32U", (long) Qt3DRender::QAbstractTexture::TextureFormat::R32U))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RG32U", (long) Qt3DRender::QAbstractTexture::TextureFormat::RG32U))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RGB32U", (long) Qt3DRender::QAbstractTexture::TextureFormat::RGB32U))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RGBA32U", (long) Qt3DRender::QAbstractTexture::TextureFormat::RGBA32U))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "R8I", (long) Qt3DRender::QAbstractTexture::TextureFormat::R8I))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RG8I", (long) Qt3DRender::QAbstractTexture::TextureFormat::RG8I))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RGB8I", (long) Qt3DRender::QAbstractTexture::TextureFormat::RGB8I))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RGBA8I", (long) Qt3DRender::QAbstractTexture::TextureFormat::RGBA8I))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "R16I", (long) Qt3DRender::QAbstractTexture::TextureFormat::R16I))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RG16I", (long) Qt3DRender::QAbstractTexture::TextureFormat::RG16I))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RGB16I", (long) Qt3DRender::QAbstractTexture::TextureFormat::RGB16I))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RGBA16I", (long) Qt3DRender::QAbstractTexture::TextureFormat::RGBA16I))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "R32I", (long) Qt3DRender::QAbstractTexture::TextureFormat::R32I))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RG32I", (long) Qt3DRender::QAbstractTexture::TextureFormat::RG32I))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RGB32I", (long) Qt3DRender::QAbstractTexture::TextureFormat::RGB32I))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RGBA32I", (long) Qt3DRender::QAbstractTexture::TextureFormat::RGBA32I))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "R16F", (long) Qt3DRender::QAbstractTexture::TextureFormat::R16F))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RG16F", (long) Qt3DRender::QAbstractTexture::TextureFormat::RG16F))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RGB16F", (long) Qt3DRender::QAbstractTexture::TextureFormat::RGB16F))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RGBA16F", (long) Qt3DRender::QAbstractTexture::TextureFormat::RGBA16F))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "R32F", (long) Qt3DRender::QAbstractTexture::TextureFormat::R32F))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RG32F", (long) Qt3DRender::QAbstractTexture::TextureFormat::RG32F))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RGB32F", (long) Qt3DRender::QAbstractTexture::TextureFormat::RGB32F))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RGBA32F", (long) Qt3DRender::QAbstractTexture::TextureFormat::RGBA32F))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RGB9E5", (long) Qt3DRender::QAbstractTexture::TextureFormat::RGB9E5))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RG11B10F", (long) Qt3DRender::QAbstractTexture::TextureFormat::RG11B10F))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RG3B2", (long) Qt3DRender::QAbstractTexture::TextureFormat::RG3B2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "R5G6B5", (long) Qt3DRender::QAbstractTexture::TextureFormat::R5G6B5))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RGB5A1", (long) Qt3DRender::QAbstractTexture::TextureFormat::RGB5A1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RGBA4", (long) Qt3DRender::QAbstractTexture::TextureFormat::RGBA4))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RGB10A2", (long) Qt3DRender::QAbstractTexture::TextureFormat::RGB10A2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RGB10A2U", (long) Qt3DRender::QAbstractTexture::TextureFormat::RGB10A2U))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "D16", (long) Qt3DRender::QAbstractTexture::TextureFormat::D16))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "D24", (long) Qt3DRender::QAbstractTexture::TextureFormat::D24))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "D24S8", (long) Qt3DRender::QAbstractTexture::TextureFormat::D24S8))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "D32", (long) Qt3DRender::QAbstractTexture::TextureFormat::D32))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "D32F", (long) Qt3DRender::QAbstractTexture::TextureFormat::D32F))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "D32FS8X24", (long) Qt3DRender::QAbstractTexture::TextureFormat::D32FS8X24))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RGB_DXT1", (long) Qt3DRender::QAbstractTexture::TextureFormat::RGB_DXT1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RGBA_DXT1", (long) Qt3DRender::QAbstractTexture::TextureFormat::RGBA_DXT1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RGBA_DXT3", (long) Qt3DRender::QAbstractTexture::TextureFormat::RGBA_DXT3))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RGBA_DXT5", (long) Qt3DRender::QAbstractTexture::TextureFormat::RGBA_DXT5))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "R_ATI1N_UNorm", (long) Qt3DRender::QAbstractTexture::TextureFormat::R_ATI1N_UNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "R_ATI1N_SNorm", (long) Qt3DRender::QAbstractTexture::TextureFormat::R_ATI1N_SNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RG_ATI2N_UNorm", (long) Qt3DRender::QAbstractTexture::TextureFormat::RG_ATI2N_UNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RG_ATI2N_SNorm", (long) Qt3DRender::QAbstractTexture::TextureFormat::RG_ATI2N_SNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RGB_BP_UNSIGNED_FLOAT", (long) Qt3DRender::QAbstractTexture::TextureFormat::RGB_BP_UNSIGNED_FLOAT))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RGB_BP_SIGNED_FLOAT", (long) Qt3DRender::QAbstractTexture::TextureFormat::RGB_BP_SIGNED_FLOAT))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RGB_BP_UNorm", (long) Qt3DRender::QAbstractTexture::TextureFormat::RGB_BP_UNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "R11_EAC_UNorm", (long) Qt3DRender::QAbstractTexture::TextureFormat::R11_EAC_UNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "R11_EAC_SNorm", (long) Qt3DRender::QAbstractTexture::TextureFormat::R11_EAC_SNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RG11_EAC_UNorm", (long) Qt3DRender::QAbstractTexture::TextureFormat::RG11_EAC_UNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RG11_EAC_SNorm", (long) Qt3DRender::QAbstractTexture::TextureFormat::RG11_EAC_SNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RGB8_ETC2", (long) Qt3DRender::QAbstractTexture::TextureFormat::RGB8_ETC2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "SRGB8_ETC2", (long) Qt3DRender::QAbstractTexture::TextureFormat::SRGB8_ETC2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RGB8_PunchThrough_Alpha1_ETC2", (long) Qt3DRender::QAbstractTexture::TextureFormat::RGB8_PunchThrough_Alpha1_ETC2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "SRGB8_PunchThrough_Alpha1_ETC2", (long) Qt3DRender::QAbstractTexture::TextureFormat::SRGB8_PunchThrough_Alpha1_ETC2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RGBA8_ETC2_EAC", (long) Qt3DRender::QAbstractTexture::TextureFormat::RGBA8_ETC2_EAC))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "SRGB8_Alpha8_ETC2_EAC", (long) Qt3DRender::QAbstractTexture::TextureFormat::SRGB8_Alpha8_ETC2_EAC))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RGB8_ETC1", (long) Qt3DRender::QAbstractTexture::TextureFormat::RGB8_ETC1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "SRGB8", (long) Qt3DRender::QAbstractTexture::TextureFormat::SRGB8))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "SRGB8_Alpha8", (long) Qt3DRender::QAbstractTexture::TextureFormat::SRGB8_Alpha8))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "SRGB_DXT1", (long) Qt3DRender::QAbstractTexture::TextureFormat::SRGB_DXT1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "SRGB_Alpha_DXT1", (long) Qt3DRender::QAbstractTexture::TextureFormat::SRGB_Alpha_DXT1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "SRGB_Alpha_DXT3", (long) Qt3DRender::QAbstractTexture::TextureFormat::SRGB_Alpha_DXT3))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "SRGB_Alpha_DXT5", (long) Qt3DRender::QAbstractTexture::TextureFormat::SRGB_Alpha_DXT5))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "SRGB_BP_UNorm", (long) Qt3DRender::QAbstractTexture::TextureFormat::SRGB_BP_UNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "DepthFormat", (long) Qt3DRender::QAbstractTexture::TextureFormat::DepthFormat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "AlphaFormat", (long) Qt3DRender::QAbstractTexture::TextureFormat::AlphaFormat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RGBFormat", (long) Qt3DRender::QAbstractTexture::TextureFormat::RGBFormat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "RGBAFormat", (long) Qt3DRender::QAbstractTexture::TextureFormat::RGBAFormat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "LuminanceFormat", (long) Qt3DRender::QAbstractTexture::TextureFormat::LuminanceFormat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "LuminanceAlphaFormat", (long) Qt3DRender::QAbstractTexture::TextureFormat::LuminanceAlphaFormat))
        return;
    // Register converter for enum 'Qt3DRender::QAbstractTexture::TextureFormat'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX],
            Qt3DRender_QAbstractTexture_TextureFormat_CppToPython_Qt3DRender_QAbstractTexture_TextureFormat);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DRender_QAbstractTexture_TextureFormat_PythonToCpp_Qt3DRender_QAbstractTexture_TextureFormat,
            is_Qt3DRender_QAbstractTexture_TextureFormat_PythonToCpp_Qt3DRender_QAbstractTexture_TextureFormat_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_TEXTUREFORMAT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QAbstractTexture::TextureFormat");
        Shiboken::Conversions::registerConverterName(converter, "QAbstractTexture::TextureFormat");
        Shiboken::Conversions::registerConverterName(converter, "TextureFormat");
    }
    // End of 'TextureFormat' enum.

    // Initialization of enum 'Filter'.
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_FILTER_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DRender_QAbstractTexture_TypeF(),
        "Filter",
        "2:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Filter",
        "Qt3DRender::QAbstractTexture::Filter");
    if (!SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_FILTER_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_FILTER_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "Nearest", (long) Qt3DRender::QAbstractTexture::Filter::Nearest))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_FILTER_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "Linear", (long) Qt3DRender::QAbstractTexture::Filter::Linear))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_FILTER_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "NearestMipMapNearest", (long) Qt3DRender::QAbstractTexture::Filter::NearestMipMapNearest))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_FILTER_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "NearestMipMapLinear", (long) Qt3DRender::QAbstractTexture::Filter::NearestMipMapLinear))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_FILTER_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "LinearMipMapNearest", (long) Qt3DRender::QAbstractTexture::Filter::LinearMipMapNearest))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_FILTER_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "LinearMipMapLinear", (long) Qt3DRender::QAbstractTexture::Filter::LinearMipMapLinear))
        return;
    // Register converter for enum 'Qt3DRender::QAbstractTexture::Filter'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_FILTER_IDX],
            Qt3DRender_QAbstractTexture_Filter_CppToPython_Qt3DRender_QAbstractTexture_Filter);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DRender_QAbstractTexture_Filter_PythonToCpp_Qt3DRender_QAbstractTexture_Filter,
            is_Qt3DRender_QAbstractTexture_Filter_PythonToCpp_Qt3DRender_QAbstractTexture_Filter_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_FILTER_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QAbstractTexture::Filter");
        Shiboken::Conversions::registerConverterName(converter, "QAbstractTexture::Filter");
        Shiboken::Conversions::registerConverterName(converter, "Filter");
    }
    // End of 'Filter' enum.

    // Initialization of enum 'CubeMapFace'.
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_CUBEMAPFACE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DRender_QAbstractTexture_TypeF(),
        "CubeMapFace",
        "2:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.CubeMapFace",
        "Qt3DRender::QAbstractTexture::CubeMapFace");
    if (!SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_CUBEMAPFACE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_CUBEMAPFACE_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "CubeMapPositiveX", (long) Qt3DRender::QAbstractTexture::CubeMapFace::CubeMapPositiveX))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_CUBEMAPFACE_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "CubeMapNegativeX", (long) Qt3DRender::QAbstractTexture::CubeMapFace::CubeMapNegativeX))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_CUBEMAPFACE_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "CubeMapPositiveY", (long) Qt3DRender::QAbstractTexture::CubeMapFace::CubeMapPositiveY))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_CUBEMAPFACE_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "CubeMapNegativeY", (long) Qt3DRender::QAbstractTexture::CubeMapFace::CubeMapNegativeY))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_CUBEMAPFACE_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "CubeMapPositiveZ", (long) Qt3DRender::QAbstractTexture::CubeMapFace::CubeMapPositiveZ))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_CUBEMAPFACE_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "CubeMapNegativeZ", (long) Qt3DRender::QAbstractTexture::CubeMapFace::CubeMapNegativeZ))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_CUBEMAPFACE_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "AllFaces", (long) Qt3DRender::QAbstractTexture::CubeMapFace::AllFaces))
        return;
    // Register converter for enum 'Qt3DRender::QAbstractTexture::CubeMapFace'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_CUBEMAPFACE_IDX],
            Qt3DRender_QAbstractTexture_CubeMapFace_CppToPython_Qt3DRender_QAbstractTexture_CubeMapFace);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DRender_QAbstractTexture_CubeMapFace_PythonToCpp_Qt3DRender_QAbstractTexture_CubeMapFace,
            is_Qt3DRender_QAbstractTexture_CubeMapFace_PythonToCpp_Qt3DRender_QAbstractTexture_CubeMapFace_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_CUBEMAPFACE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QAbstractTexture::CubeMapFace");
        Shiboken::Conversions::registerConverterName(converter, "QAbstractTexture::CubeMapFace");
        Shiboken::Conversions::registerConverterName(converter, "CubeMapFace");
    }
    // End of 'CubeMapFace' enum.

    // Initialization of enum 'ComparisonFunction'.
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_COMPARISONFUNCTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DRender_QAbstractTexture_TypeF(),
        "ComparisonFunction",
        "2:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.ComparisonFunction",
        "Qt3DRender::QAbstractTexture::ComparisonFunction");
    if (!SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_COMPARISONFUNCTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_COMPARISONFUNCTION_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "CompareLessEqual", (long) Qt3DRender::QAbstractTexture::ComparisonFunction::CompareLessEqual))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_COMPARISONFUNCTION_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "CompareGreaterEqual", (long) Qt3DRender::QAbstractTexture::ComparisonFunction::CompareGreaterEqual))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_COMPARISONFUNCTION_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "CompareLess", (long) Qt3DRender::QAbstractTexture::ComparisonFunction::CompareLess))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_COMPARISONFUNCTION_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "CompareGreater", (long) Qt3DRender::QAbstractTexture::ComparisonFunction::CompareGreater))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_COMPARISONFUNCTION_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "CompareEqual", (long) Qt3DRender::QAbstractTexture::ComparisonFunction::CompareEqual))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_COMPARISONFUNCTION_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "CommpareNotEqual", (long) Qt3DRender::QAbstractTexture::ComparisonFunction::CommpareNotEqual))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_COMPARISONFUNCTION_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "CompareAlways", (long) Qt3DRender::QAbstractTexture::ComparisonFunction::CompareAlways))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_COMPARISONFUNCTION_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "CompareNever", (long) Qt3DRender::QAbstractTexture::ComparisonFunction::CompareNever))
        return;
    // Register converter for enum 'Qt3DRender::QAbstractTexture::ComparisonFunction'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_COMPARISONFUNCTION_IDX],
            Qt3DRender_QAbstractTexture_ComparisonFunction_CppToPython_Qt3DRender_QAbstractTexture_ComparisonFunction);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DRender_QAbstractTexture_ComparisonFunction_PythonToCpp_Qt3DRender_QAbstractTexture_ComparisonFunction,
            is_Qt3DRender_QAbstractTexture_ComparisonFunction_PythonToCpp_Qt3DRender_QAbstractTexture_ComparisonFunction_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_COMPARISONFUNCTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QAbstractTexture::ComparisonFunction");
        Shiboken::Conversions::registerConverterName(converter, "QAbstractTexture::ComparisonFunction");
        Shiboken::Conversions::registerConverterName(converter, "ComparisonFunction");
    }
    // End of 'ComparisonFunction' enum.

    // Initialization of enum 'ComparisonMode'.
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_COMPARISONMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DRender_QAbstractTexture_TypeF(),
        "ComparisonMode",
        "2:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.ComparisonMode",
        "Qt3DRender::QAbstractTexture::ComparisonMode");
    if (!SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_COMPARISONMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_COMPARISONMODE_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "CompareRefToTexture", (long) Qt3DRender::QAbstractTexture::ComparisonMode::CompareRefToTexture))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_COMPARISONMODE_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "CompareNone", (long) Qt3DRender::QAbstractTexture::ComparisonMode::CompareNone))
        return;
    // Register converter for enum 'Qt3DRender::QAbstractTexture::ComparisonMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_COMPARISONMODE_IDX],
            Qt3DRender_QAbstractTexture_ComparisonMode_CppToPython_Qt3DRender_QAbstractTexture_ComparisonMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DRender_QAbstractTexture_ComparisonMode_PythonToCpp_Qt3DRender_QAbstractTexture_ComparisonMode,
            is_Qt3DRender_QAbstractTexture_ComparisonMode_PythonToCpp_Qt3DRender_QAbstractTexture_ComparisonMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_COMPARISONMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QAbstractTexture::ComparisonMode");
        Shiboken::Conversions::registerConverterName(converter, "QAbstractTexture::ComparisonMode");
        Shiboken::Conversions::registerConverterName(converter, "ComparisonMode");
    }
    // End of 'ComparisonMode' enum.

    // Initialization of enum 'HandleType'.
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_HANDLETYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DRender_QAbstractTexture_TypeF(),
        "HandleType",
        "2:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.HandleType",
        "Qt3DRender::QAbstractTexture::HandleType");
    if (!SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_HANDLETYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_HANDLETYPE_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "NoHandle", (long) Qt3DRender::QAbstractTexture::HandleType::NoHandle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_HANDLETYPE_IDX],
        Sbk_Qt3DRender_QAbstractTexture_TypeF(), "OpenGLTextureId", (long) Qt3DRender::QAbstractTexture::HandleType::OpenGLTextureId))
        return;
    // Register converter for enum 'Qt3DRender::QAbstractTexture::HandleType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_HANDLETYPE_IDX],
            Qt3DRender_QAbstractTexture_HandleType_CppToPython_Qt3DRender_QAbstractTexture_HandleType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DRender_QAbstractTexture_HandleType_PythonToCpp_Qt3DRender_QAbstractTexture_HandleType,
            is_Qt3DRender_QAbstractTexture_HandleType_PythonToCpp_Qt3DRender_QAbstractTexture_HandleType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_HANDLETYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QAbstractTexture::HandleType");
        Shiboken::Conversions::registerConverterName(converter, "QAbstractTexture::HandleType");
        Shiboken::Conversions::registerConverterName(converter, "HandleType");
    }
    // End of 'HandleType' enum.

    PySide::Signal::registerSignals(Sbk_Qt3DRender_QAbstractTexture_TypeF(), &::Qt3DRender::QAbstractTexture::staticMetaObject);
    qRegisterMetaType< ::Qt3DRender::QAbstractTexture::Status >("QAbstractTexture::Status");
    qRegisterMetaType< ::Qt3DRender::QAbstractTexture::Status >("Qt3DRender::QAbstractTexture::Status");
    qRegisterMetaType< ::Qt3DRender::QAbstractTexture::Target >("QAbstractTexture::Target");
    qRegisterMetaType< ::Qt3DRender::QAbstractTexture::Target >("Qt3DRender::QAbstractTexture::Target");
    qRegisterMetaType< ::Qt3DRender::QAbstractTexture::TextureFormat >("QAbstractTexture::TextureFormat");
    qRegisterMetaType< ::Qt3DRender::QAbstractTexture::TextureFormat >("Qt3DRender::QAbstractTexture::TextureFormat");
    qRegisterMetaType< ::Qt3DRender::QAbstractTexture::Filter >("QAbstractTexture::Filter");
    qRegisterMetaType< ::Qt3DRender::QAbstractTexture::Filter >("Qt3DRender::QAbstractTexture::Filter");
    qRegisterMetaType< ::Qt3DRender::QAbstractTexture::CubeMapFace >("QAbstractTexture::CubeMapFace");
    qRegisterMetaType< ::Qt3DRender::QAbstractTexture::CubeMapFace >("Qt3DRender::QAbstractTexture::CubeMapFace");
    qRegisterMetaType< ::Qt3DRender::QAbstractTexture::ComparisonFunction >("QAbstractTexture::ComparisonFunction");
    qRegisterMetaType< ::Qt3DRender::QAbstractTexture::ComparisonFunction >("Qt3DRender::QAbstractTexture::ComparisonFunction");
    qRegisterMetaType< ::Qt3DRender::QAbstractTexture::ComparisonMode >("QAbstractTexture::ComparisonMode");
    qRegisterMetaType< ::Qt3DRender::QAbstractTexture::ComparisonMode >("Qt3DRender::QAbstractTexture::ComparisonMode");
    qRegisterMetaType< ::Qt3DRender::QAbstractTexture::HandleType >("QAbstractTexture::HandleType");
    qRegisterMetaType< ::Qt3DRender::QAbstractTexture::HandleType >("Qt3DRender::QAbstractTexture::HandleType");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_Qt3DRender_QAbstractTexture_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_Qt3DRender_QAbstractTexture_TypeF(), &::Qt3DRender::QAbstractTexture::staticMetaObject, sizeof(QAbstractTextureWrapper));
}
