/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qt3drender_python.h"

// main header
#include "qt3drender_qraycasterhit_wrapper.h"

// inner classes

// Extra includes
#include <Qt3DCore/qentity.h>
#include <Qt3DCore/qnodeid.h>
#include <Qt3DRender/qraycasterhit.h>
#include <QtGui/qvector3d.h>
#include <qobject.h>


#include <cctype>
#include <cstring>

using namespace Qt3DRender;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_Qt3DRender_QRayCasterHit_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::Qt3DRender::QRayCasterHit >()))
        return -1;

    ::Qt3DRender::QRayCasterHit *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QRayCasterHit.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3 || numArgs == 4 || numArgs == 5 || numArgs == 6 || numArgs == 7 || numArgs == 8)
        goto Sbk_Qt3DRender_QRayCasterHit_Init_TypeError;

    if (!PyArg_UnpackTuple(args, "QRayCasterHit", 0, 9, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8])))
        return -1;


    // Overloaded function decisor
    // 0: QRayCasterHit::QRayCasterHit()
    // 1: QRayCasterHit::QRayCasterHit(Qt3DRender::QRayCasterHit::HitType,Qt3DCore::QNodeId,float,QVector3D,QVector3D,uint,uint,uint,uint)
    // 2: QRayCasterHit::QRayCasterHit(Qt3DRender::QRayCasterHit)
    if (numArgs == 0) {
        overloadId = 0; // QRayCasterHit()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRAYCASTERHIT_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QRayCasterHit(Qt3DRender::QRayCasterHit)
    } else if (numArgs == 9
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRAYCASTERHIT_HITTYPE_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODEID_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[7])))
        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[8])))) {
        overloadId = 1; // QRayCasterHit(Qt3DRender::QRayCasterHit::HitType,Qt3DCore::QNodeId,float,QVector3D,QVector3D,uint,uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QRayCasterHit_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QRayCasterHit()
        {

            if (!PyErr_Occurred()) {
                // QRayCasterHit()
                cptr = new ::Qt3DRender::QRayCasterHit();
            }
            break;
        }
        case 1: // QRayCasterHit(Qt3DRender::QRayCasterHit::HitType type, Qt3DCore::QNodeId id, float distance, const QVector3D & localIntersect, const QVector3D & worldIntersect, uint primitiveIndex, uint v1, uint v2, uint v3)
        {
            ::Qt3DRender::QRayCasterHit::HitType cppArg0{Qt3DRender::QRayCasterHit::TriangleHit};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::Qt3DCore::QNodeId cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            float cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return -1;
            ::QVector3D cppArg3_local;
            ::QVector3D *cppArg3 = &cppArg3_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), pythonToCpp[3]))
                pythonToCpp[3](pyArgs[3], &cppArg3_local);
            else
                pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!Shiboken::Object::isValid(pyArgs[4]))
                return -1;
            ::QVector3D cppArg4_local;
            ::QVector3D *cppArg4 = &cppArg4_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), pythonToCpp[4]))
                pythonToCpp[4](pyArgs[4], &cppArg4_local);
            else
                pythonToCpp[4](pyArgs[4], &cppArg4);

            uint cppArg5;
            pythonToCpp[5](pyArgs[5], &cppArg5);
            uint cppArg6;
            pythonToCpp[6](pyArgs[6], &cppArg6);
            uint cppArg7;
            pythonToCpp[7](pyArgs[7], &cppArg7);
            uint cppArg8;
            pythonToCpp[8](pyArgs[8], &cppArg8);

            if (!PyErr_Occurred()) {
                // QRayCasterHit(Qt3DRender::QRayCasterHit::HitType,Qt3DCore::QNodeId,float,QVector3D,QVector3D,uint,uint,uint,uint)
                cptr = new ::Qt3DRender::QRayCasterHit(cppArg0, cppArg1, cppArg2, *cppArg3, *cppArg4, cppArg5, cppArg6, cppArg7, cppArg8);
            }
            break;
        }
        case 2: // QRayCasterHit(const Qt3DRender::QRayCasterHit & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::Qt3DRender::QRayCasterHit cppArg0_local;
            ::Qt3DRender::QRayCasterHit *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRAYCASTERHIT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QRayCasterHit(Qt3DRender::QRayCasterHit)
                cptr = new ::Qt3DRender::QRayCasterHit(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::Qt3DRender::QRayCasterHit >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_Qt3DRender_QRayCasterHit_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_Qt3DRender_QRayCasterHit_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_Qt3DRender_QRayCasterHitFunc_distance(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QRayCasterHit *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRAYCASTERHIT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QRayCasterHit.distance";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // distance()const
            float cppResult = const_cast<const ::Qt3DRender::QRayCasterHit *>(cppSelf)->distance();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QRayCasterHitFunc_entity(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QRayCasterHit *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRAYCASTERHIT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QRayCasterHit.entity";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // entity()const
            Qt3DCore::QEntity * cppResult = const_cast<const ::Qt3DRender::QRayCasterHit *>(cppSelf)->entity();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QENTITY_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QRayCasterHitFunc_entityId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QRayCasterHit *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRAYCASTERHIT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QRayCasterHit.entityId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // entityId()const
            Qt3DCore::QNodeId cppResult = const_cast<const ::Qt3DRender::QRayCasterHit *>(cppSelf)->entityId();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODEID_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QRayCasterHitFunc_localIntersection(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QRayCasterHit *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRAYCASTERHIT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QRayCasterHit.localIntersection";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // localIntersection()const
            QVector3D cppResult = const_cast<const ::Qt3DRender::QRayCasterHit *>(cppSelf)->localIntersection();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QRayCasterHitFunc_primitiveIndex(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QRayCasterHit *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRAYCASTERHIT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QRayCasterHit.primitiveIndex";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // primitiveIndex()const
            uint cppResult = const_cast<const ::Qt3DRender::QRayCasterHit *>(cppSelf)->primitiveIndex();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QRayCasterHitFunc_type(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QRayCasterHit *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRAYCASTERHIT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QRayCasterHit.type";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // type()const
            Qt3DRender::QRayCasterHit::HitType cppResult = const_cast<const ::Qt3DRender::QRayCasterHit *>(cppSelf)->type();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRAYCASTERHIT_HITTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QRayCasterHitFunc_vertex1Index(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QRayCasterHit *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRAYCASTERHIT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QRayCasterHit.vertex1Index";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // vertex1Index()const
            uint cppResult = const_cast<const ::Qt3DRender::QRayCasterHit *>(cppSelf)->vertex1Index();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QRayCasterHitFunc_vertex2Index(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QRayCasterHit *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRAYCASTERHIT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QRayCasterHit.vertex2Index";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // vertex2Index()const
            uint cppResult = const_cast<const ::Qt3DRender::QRayCasterHit *>(cppSelf)->vertex2Index();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QRayCasterHitFunc_vertex3Index(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QRayCasterHit *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRAYCASTERHIT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QRayCasterHit.vertex3Index";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // vertex3Index()const
            uint cppResult = const_cast<const ::Qt3DRender::QRayCasterHit *>(cppSelf)->vertex3Index();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QRayCasterHitFunc_worldIntersection(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QRayCasterHit *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRAYCASTERHIT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QRayCasterHit.worldIntersection";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // worldIntersection()const
            QVector3D cppResult = const_cast<const ::Qt3DRender::QRayCasterHit *>(cppSelf)->worldIntersection();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QRayCasterHit___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::Qt3DRender::QRayCasterHit *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRAYCASTERHIT_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRAYCASTERHIT_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_Qt3DRender_QRayCasterHit_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_Qt3DRender_QRayCasterHit_methods[] = {
    {"distance", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QRayCasterHitFunc_distance), METH_NOARGS},
    {"entity", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QRayCasterHitFunc_entity), METH_NOARGS},
    {"entityId", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QRayCasterHitFunc_entityId), METH_NOARGS},
    {"localIntersection", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QRayCasterHitFunc_localIntersection), METH_NOARGS},
    {"primitiveIndex", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QRayCasterHitFunc_primitiveIndex), METH_NOARGS},
    {"type", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QRayCasterHitFunc_type), METH_NOARGS},
    {"vertex1Index", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QRayCasterHitFunc_vertex1Index), METH_NOARGS},
    {"vertex2Index", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QRayCasterHitFunc_vertex2Index), METH_NOARGS},
    {"vertex3Index", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QRayCasterHitFunc_vertex3Index), METH_NOARGS},
    {"worldIntersection", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QRayCasterHitFunc_worldIntersection), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QRayCasterHit___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_Qt3DRender_QRayCasterHit_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_Qt3DRender_QRayCasterHit_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_Qt3DRender_QRayCasterHit_Type = nullptr;
static SbkObjectType *Sbk_Qt3DRender_QRayCasterHit_TypeF(void)
{
    return _Sbk_Qt3DRender_QRayCasterHit_Type;
}

static PyType_Slot Sbk_Qt3DRender_QRayCasterHit_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Qt3DRender_QRayCasterHit_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Qt3DRender_QRayCasterHit_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Qt3DRender_QRayCasterHit_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_Qt3DRender_QRayCasterHit_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_Qt3DRender_QRayCasterHit_spec = {
    "2:PySide2.Qt3DRender.Qt3DRender.QRayCasterHit",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_Qt3DRender_QRayCasterHit_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void Qt3DRender_QRayCasterHit_HitType_PythonToCpp_Qt3DRender_QRayCasterHit_HitType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DRender::QRayCasterHit::HitType *>(cppOut) =
        static_cast<::Qt3DRender::QRayCasterHit::HitType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DRender_QRayCasterHit_HitType_PythonToCpp_Qt3DRender_QRayCasterHit_HitType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRAYCASTERHIT_HITTYPE_IDX]))
        return Qt3DRender_QRayCasterHit_HitType_PythonToCpp_Qt3DRender_QRayCasterHit_HitType;
    return {};
}
static PyObject *Qt3DRender_QRayCasterHit_HitType_CppToPython_Qt3DRender_QRayCasterHit_HitType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DRender::QRayCasterHit::HitType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRAYCASTERHIT_HITTYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QRayCasterHit_PythonToCpp_QRayCasterHit_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_Qt3DRender_QRayCasterHit_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QRayCasterHit_PythonToCpp_QRayCasterHit_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_Qt3DRender_QRayCasterHit_TypeF())))
        return QRayCasterHit_PythonToCpp_QRayCasterHit_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QRayCasterHit_PTR_CppToPython_QRayCasterHit(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::Qt3DRender::QRayCasterHit *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_Qt3DRender_QRayCasterHit_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QRayCasterHit_COPY_CppToPython_QRayCasterHit(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_Qt3DRender_QRayCasterHit_TypeF(), new ::Qt3DRender::QRayCasterHit(*reinterpret_cast<const ::Qt3DRender::QRayCasterHit *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QRayCasterHit_PythonToCpp_QRayCasterHit_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DRender::QRayCasterHit *>(cppOut) = *reinterpret_cast< ::Qt3DRender::QRayCasterHit *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRAYCASTERHIT_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QRayCasterHit_PythonToCpp_QRayCasterHit_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_Qt3DRender_QRayCasterHit_TypeF())))
        return QRayCasterHit_PythonToCpp_QRayCasterHit_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *Qt3DRender_QRayCasterHit_SignatureStrings[] = {
    "2:PySide2.Qt3DRender.Qt3DRender.QRayCasterHit(self)",
    "1:PySide2.Qt3DRender.Qt3DRender.QRayCasterHit(self,type:PySide2.Qt3DRender.Qt3DRender.QRayCasterHit.HitType,id:PySide2.Qt3DCore.Qt3DCore.QNodeId,distance:float,localIntersect:PySide2.QtGui.QVector3D,worldIntersect:PySide2.QtGui.QVector3D,primitiveIndex:uint,v1:uint,v2:uint,v3:uint)",
    "0:PySide2.Qt3DRender.Qt3DRender.QRayCasterHit(self,other:PySide2.Qt3DRender.Qt3DRender.QRayCasterHit)",
    "PySide2.Qt3DRender.Qt3DRender.QRayCasterHit.distance(self)->float",
    "PySide2.Qt3DRender.Qt3DRender.QRayCasterHit.entity(self)->PySide2.Qt3DCore.Qt3DCore.QEntity",
    "PySide2.Qt3DRender.Qt3DRender.QRayCasterHit.entityId(self)->PySide2.Qt3DCore.Qt3DCore.QNodeId",
    "PySide2.Qt3DRender.Qt3DRender.QRayCasterHit.localIntersection(self)->PySide2.QtGui.QVector3D",
    "PySide2.Qt3DRender.Qt3DRender.QRayCasterHit.primitiveIndex(self)->uint",
    "PySide2.Qt3DRender.Qt3DRender.QRayCasterHit.type(self)->PySide2.Qt3DRender.Qt3DRender.QRayCasterHit.HitType",
    "PySide2.Qt3DRender.Qt3DRender.QRayCasterHit.vertex1Index(self)->uint",
    "PySide2.Qt3DRender.Qt3DRender.QRayCasterHit.vertex2Index(self)->uint",
    "PySide2.Qt3DRender.Qt3DRender.QRayCasterHit.vertex3Index(self)->uint",
    "PySide2.Qt3DRender.Qt3DRender.QRayCasterHit.worldIntersection(self)->PySide2.QtGui.QVector3D",
    "PySide2.Qt3DRender.Qt3DRender.QRayCasterHit.__copy__()",
    nullptr}; // Sentinel

void init_Qt3DRender_QRayCasterHit(PyObject *enclosingClass)
{
    _Sbk_Qt3DRender_QRayCasterHit_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QRayCasterHit",
        "Qt3DRender::QRayCasterHit",
        &Sbk_Qt3DRender_QRayCasterHit_spec,
        &Shiboken::callCppDestructor< ::Qt3DRender::QRayCasterHit >,
        0,
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DRender_QRayCasterHit_Type);
    InitSignatureStrings(pyType, Qt3DRender_QRayCasterHit_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DRender_QRayCasterHit_Type), Sbk_Qt3DRender_QRayCasterHit_PropertyStrings);
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRAYCASTERHIT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_Qt3DRender_QRayCasterHit_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_Qt3DRender_QRayCasterHit_TypeF(),
        QRayCasterHit_PythonToCpp_QRayCasterHit_PTR,
        is_QRayCasterHit_PythonToCpp_QRayCasterHit_PTR_Convertible,
        QRayCasterHit_PTR_CppToPython_QRayCasterHit,
        QRayCasterHit_COPY_CppToPython_QRayCasterHit);

    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QRayCasterHit");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QRayCasterHit*");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QRayCasterHit&");
    Shiboken::Conversions::registerConverterName(converter, "QRayCasterHit");
    Shiboken::Conversions::registerConverterName(converter, "QRayCasterHit*");
    Shiboken::Conversions::registerConverterName(converter, "QRayCasterHit&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::Qt3DRender::QRayCasterHit).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QRayCasterHit_PythonToCpp_QRayCasterHit_COPY,
        is_QRayCasterHit_PythonToCpp_QRayCasterHit_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'HitType'.
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRAYCASTERHIT_HITTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DRender_QRayCasterHit_TypeF(),
        "HitType",
        "2:PySide2.Qt3DRender.Qt3DRender.QRayCasterHit.HitType",
        "Qt3DRender::QRayCasterHit::HitType");
    if (!SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRAYCASTERHIT_HITTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRAYCASTERHIT_HITTYPE_IDX],
        Sbk_Qt3DRender_QRayCasterHit_TypeF(), "TriangleHit", (long) Qt3DRender::QRayCasterHit::HitType::TriangleHit))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRAYCASTERHIT_HITTYPE_IDX],
        Sbk_Qt3DRender_QRayCasterHit_TypeF(), "LineHit", (long) Qt3DRender::QRayCasterHit::HitType::LineHit))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRAYCASTERHIT_HITTYPE_IDX],
        Sbk_Qt3DRender_QRayCasterHit_TypeF(), "PointHit", (long) Qt3DRender::QRayCasterHit::HitType::PointHit))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRAYCASTERHIT_HITTYPE_IDX],
        Sbk_Qt3DRender_QRayCasterHit_TypeF(), "EntityHit", (long) Qt3DRender::QRayCasterHit::HitType::EntityHit))
        return;
    // Register converter for enum 'Qt3DRender::QRayCasterHit::HitType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRAYCASTERHIT_HITTYPE_IDX],
            Qt3DRender_QRayCasterHit_HitType_CppToPython_Qt3DRender_QRayCasterHit_HitType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DRender_QRayCasterHit_HitType_PythonToCpp_Qt3DRender_QRayCasterHit_HitType,
            is_Qt3DRender_QRayCasterHit_HitType_PythonToCpp_Qt3DRender_QRayCasterHit_HitType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QRAYCASTERHIT_HITTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QRayCasterHit::HitType");
        Shiboken::Conversions::registerConverterName(converter, "QRayCasterHit::HitType");
        Shiboken::Conversions::registerConverterName(converter, "HitType");
    }
    // End of 'HitType' enum.

    qRegisterMetaType< ::Qt3DRender::QRayCasterHit >("QRayCasterHit");
    qRegisterMetaType< ::Qt3DRender::QRayCasterHit >("Qt3DRender::QRayCasterHit");
    qRegisterMetaType< ::Qt3DRender::QRayCasterHit::HitType >("QRayCasterHit::HitType");
    qRegisterMetaType< ::Qt3DRender::QRayCasterHit::HitType >("Qt3DRender::QRayCasterHit::HitType");
}
