/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qt3drender_python.h"

// main header
#include "qt3drender_qshaderimage_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>

using namespace Qt3DRender;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QShaderImageWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QShaderImageWrapper::QShaderImageWrapper(::Qt3DCore::QNode * parent) : Qt3DRender::QShaderImage(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QShaderImageWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QShaderImageWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QShaderImageWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QShaderImageWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QShaderImageWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QShaderImage.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QShaderImageWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QShaderImage.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QShaderImageWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QShaderImageWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return Qt3DRender::QShaderImage::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QShaderImageWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = Qt3DRender::QShaderImage::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QShaderImageWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QShaderImageWrapper *>(this));
        return Qt3DRender::QShaderImage::qt_metacast(_clname);
}

QShaderImageWrapper::~QShaderImageWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_Qt3DRender_QShaderImage_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::Qt3DRender::QShaderImage >()))
        return -1;

    ::QShaderImageWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QShaderImage.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QShaderImage", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QShaderImage::QShaderImage(Qt3DCore::QNode*)
    if (numArgs == 0) {
        overloadId = 0; // QShaderImage(Qt3DCore::QNode*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QShaderImage(Qt3DCore::QNode*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QShaderImage_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_Qt3DRender_QShaderImage_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), (pyArgs[0]))))
                        goto Sbk_Qt3DRender_QShaderImage_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::Qt3DCore::QNode *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QShaderImage(Qt3DCore::QNode*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QShaderImageWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QShaderImageWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::Qt3DRender::QShaderImage >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_Qt3DRender_QShaderImage_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_Qt3DRender_QShaderImage_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_Qt3DRender_QShaderImage_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_Qt3DRender_QShaderImageFunc_access(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QShaderImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QShaderImage.access";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // access()const
            Qt3DRender::QShaderImage::Access cppResult = const_cast<const ::Qt3DRender::QShaderImage *>(cppSelf)->access();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_ACCESS_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QShaderImageFunc_format(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QShaderImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QShaderImage.format";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // format()const
            Qt3DRender::QShaderImage::ImageFormat cppResult = const_cast<const ::Qt3DRender::QShaderImage *>(cppSelf)->format();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QShaderImageFunc_layer(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QShaderImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QShaderImage.layer";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // layer()const
            int cppResult = const_cast<const ::Qt3DRender::QShaderImage *>(cppSelf)->layer();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QShaderImageFunc_layered(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QShaderImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QShaderImage.layered";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // layered()const
            bool cppResult = const_cast<const ::Qt3DRender::QShaderImage *>(cppSelf)->layered();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QShaderImageFunc_mipLevel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QShaderImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QShaderImage.mipLevel";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mipLevel()const
            int cppResult = const_cast<const ::Qt3DRender::QShaderImage *>(cppSelf)->mipLevel();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QShaderImageFunc_setAccess(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QShaderImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QShaderImage.setAccess";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QShaderImage::setAccess(Qt3DRender::QShaderImage::Access)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_ACCESS_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setAccess(Qt3DRender::QShaderImage::Access)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QShaderImageFunc_setAccess_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QShaderImage::Access cppArg0{Qt3DRender::QShaderImage::ReadOnly};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAccess(Qt3DRender::QShaderImage::Access)
            cppSelf->setAccess(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QShaderImageFunc_setAccess_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QShaderImageFunc_setFormat(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QShaderImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QShaderImage.setFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QShaderImage::setFormat(Qt3DRender::QShaderImage::ImageFormat)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setFormat(Qt3DRender::QShaderImage::ImageFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QShaderImageFunc_setFormat_TypeError;

    // Call function/method
    {
        ::Qt3DRender::QShaderImage::ImageFormat cppArg0{Qt3DRender::QShaderImage::NoFormat};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFormat(Qt3DRender::QShaderImage::ImageFormat)
            cppSelf->setFormat(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QShaderImageFunc_setFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QShaderImageFunc_setLayer(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QShaderImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QShaderImage.setLayer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QShaderImage::setLayer(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setLayer(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QShaderImageFunc_setLayer_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLayer(int)
            cppSelf->setLayer(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QShaderImageFunc_setLayer_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QShaderImageFunc_setLayered(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QShaderImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QShaderImage.setLayered";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QShaderImage::setLayered(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setLayered(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QShaderImageFunc_setLayered_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLayered(bool)
            cppSelf->setLayered(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QShaderImageFunc_setLayered_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QShaderImageFunc_setMipLevel(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QShaderImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QShaderImage.setMipLevel";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QShaderImage::setMipLevel(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setMipLevel(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QShaderImageFunc_setMipLevel_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMipLevel(int)
            cppSelf->setMipLevel(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QShaderImageFunc_setMipLevel_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QShaderImageFunc_setTexture(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QShaderImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QShaderImage.setTexture";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QShaderImage::setTexture(Qt3DRender::QAbstractTexture*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_IDX]), (pyArg)))) {
        overloadId = 0; // setTexture(Qt3DRender::QAbstractTexture*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QShaderImageFunc_setTexture_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::Qt3DRender::QAbstractTexture *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTexture(Qt3DRender::QAbstractTexture*)
            cppSelf->setTexture(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QShaderImageFunc_setTexture_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QShaderImageFunc_texture(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QShaderImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QShaderImage.texture";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // texture()const
            Qt3DRender::QAbstractTexture * cppResult = const_cast<const ::Qt3DRender::QShaderImage *>(cppSelf)->texture();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QABSTRACTTEXTURE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_Qt3DRender_QShaderImage_PropertyStrings[] = {
    "access::",
    "format::",
    "layer::",
    "layered::",
    "mipLevel::",
    "texture::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_Qt3DRender_QShaderImage_methods[] = {
    {"access", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QShaderImageFunc_access), METH_NOARGS},
    {"format", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QShaderImageFunc_format), METH_NOARGS},
    {"layer", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QShaderImageFunc_layer), METH_NOARGS},
    {"layered", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QShaderImageFunc_layered), METH_NOARGS},
    {"mipLevel", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QShaderImageFunc_mipLevel), METH_NOARGS},
    {"setAccess", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QShaderImageFunc_setAccess), METH_O},
    {"setFormat", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QShaderImageFunc_setFormat), METH_O},
    {"setLayer", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QShaderImageFunc_setLayer), METH_O},
    {"setLayered", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QShaderImageFunc_setLayered), METH_O},
    {"setMipLevel", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QShaderImageFunc_setMipLevel), METH_O},
    {"setTexture", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QShaderImageFunc_setTexture), METH_O},
    {"texture", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QShaderImageFunc_texture), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_Qt3DRender_QShaderImage_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::Qt3DRender::QShaderImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QShaderImageWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_Qt3DRender_QShaderImage_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_Qt3DRender_QShaderImage_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_Qt3DRender_QShaderImage_Type = nullptr;
static SbkObjectType *Sbk_Qt3DRender_QShaderImage_TypeF(void)
{
    return _Sbk_Qt3DRender_QShaderImage_Type;
}

static PyType_Slot Sbk_Qt3DRender_QShaderImage_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_Qt3DRender_QShaderImage_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Qt3DRender_QShaderImage_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Qt3DRender_QShaderImage_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Qt3DRender_QShaderImage_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_Qt3DRender_QShaderImage_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_Qt3DRender_QShaderImage_spec = {
    "2:PySide2.Qt3DRender.Qt3DRender.QShaderImage",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_Qt3DRender_QShaderImage_slots
};

} //extern "C"

static void *Sbk_Qt3DRender_QShaderImage_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::Qt3DRender::QShaderImage *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Qt3DRender_QShaderImage_Access_PythonToCpp_Qt3DRender_QShaderImage_Access(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DRender::QShaderImage::Access *>(cppOut) =
        static_cast<::Qt3DRender::QShaderImage::Access>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DRender_QShaderImage_Access_PythonToCpp_Qt3DRender_QShaderImage_Access_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_ACCESS_IDX]))
        return Qt3DRender_QShaderImage_Access_PythonToCpp_Qt3DRender_QShaderImage_Access;
    return {};
}
static PyObject *Qt3DRender_QShaderImage_Access_CppToPython_Qt3DRender_QShaderImage_Access(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DRender::QShaderImage::Access *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_ACCESS_IDX], castCppIn);

}

static void Qt3DRender_QShaderImage_ImageFormat_PythonToCpp_Qt3DRender_QShaderImage_ImageFormat(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DRender::QShaderImage::ImageFormat *>(cppOut) =
        static_cast<::Qt3DRender::QShaderImage::ImageFormat>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DRender_QShaderImage_ImageFormat_PythonToCpp_Qt3DRender_QShaderImage_ImageFormat_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX]))
        return Qt3DRender_QShaderImage_ImageFormat_PythonToCpp_Qt3DRender_QShaderImage_ImageFormat;
    return {};
}
static PyObject *Qt3DRender_QShaderImage_ImageFormat_CppToPython_Qt3DRender_QShaderImage_ImageFormat(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DRender::QShaderImage::ImageFormat *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QShaderImage_PythonToCpp_QShaderImage_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_Qt3DRender_QShaderImage_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QShaderImage_PythonToCpp_QShaderImage_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_Qt3DRender_QShaderImage_TypeF())))
        return QShaderImage_PythonToCpp_QShaderImage_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QShaderImage_PTR_CppToPython_QShaderImage(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::Qt3DRender::QShaderImage *>(const_cast<void *>(cppIn)), Sbk_Qt3DRender_QShaderImage_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *Qt3DRender_QShaderImage_SignatureStrings[] = {
    "PySide2.Qt3DRender.Qt3DRender.QShaderImage(self,parent:PySide2.Qt3DCore.Qt3DCore.QNode=nullptr)",
    "PySide2.Qt3DRender.Qt3DRender.QShaderImage.access(self)->PySide2.Qt3DRender.Qt3DRender.QShaderImage.Access",
    "PySide2.Qt3DRender.Qt3DRender.QShaderImage.format(self)->PySide2.Qt3DRender.Qt3DRender.QShaderImage.ImageFormat",
    "PySide2.Qt3DRender.Qt3DRender.QShaderImage.layer(self)->int",
    "PySide2.Qt3DRender.Qt3DRender.QShaderImage.layered(self)->bool",
    "PySide2.Qt3DRender.Qt3DRender.QShaderImage.mipLevel(self)->int",
    "PySide2.Qt3DRender.Qt3DRender.QShaderImage.setAccess(self,access:PySide2.Qt3DRender.Qt3DRender.QShaderImage.Access)",
    "PySide2.Qt3DRender.Qt3DRender.QShaderImage.setFormat(self,format:PySide2.Qt3DRender.Qt3DRender.QShaderImage.ImageFormat)",
    "PySide2.Qt3DRender.Qt3DRender.QShaderImage.setLayer(self,layer:int)",
    "PySide2.Qt3DRender.Qt3DRender.QShaderImage.setLayered(self,layered:bool)",
    "PySide2.Qt3DRender.Qt3DRender.QShaderImage.setMipLevel(self,mipLevel:int)",
    "PySide2.Qt3DRender.Qt3DRender.QShaderImage.setTexture(self,texture:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture)",
    "PySide2.Qt3DRender.Qt3DRender.QShaderImage.texture(self)->PySide2.Qt3DRender.Qt3DRender.QAbstractTexture",
    nullptr}; // Sentinel

void init_Qt3DRender_QShaderImage(PyObject *enclosingClass)
{
    _Sbk_Qt3DRender_QShaderImage_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QShaderImage",
        "Qt3DRender::QShaderImage*",
        &Sbk_Qt3DRender_QShaderImage_spec,
        &Shiboken::callCppDestructor< ::Qt3DRender::QShaderImage >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DRender_QShaderImage_Type);
    InitSignatureStrings(pyType, Qt3DRender_QShaderImage_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DRender_QShaderImage_Type), Sbk_Qt3DRender_QShaderImage_PropertyStrings);
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_Qt3DRender_QShaderImage_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_Qt3DRender_QShaderImage_TypeF(),
        QShaderImage_PythonToCpp_QShaderImage_PTR,
        is_QShaderImage_PythonToCpp_QShaderImage_PTR_Convertible,
        QShaderImage_PTR_CppToPython_QShaderImage);

    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QShaderImage");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QShaderImage*");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QShaderImage&");
    Shiboken::Conversions::registerConverterName(converter, "QShaderImage");
    Shiboken::Conversions::registerConverterName(converter, "QShaderImage*");
    Shiboken::Conversions::registerConverterName(converter, "QShaderImage&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::Qt3DRender::QShaderImage).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QShaderImageWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_Qt3DRender_QShaderImage_TypeF(), &Sbk_Qt3DRender_QShaderImage_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'Access'.
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_ACCESS_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DRender_QShaderImage_TypeF(),
        "Access",
        "2:PySide2.Qt3DRender.Qt3DRender.QShaderImage.Access",
        "Qt3DRender::QShaderImage::Access");
    if (!SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_ACCESS_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_ACCESS_IDX],
        Sbk_Qt3DRender_QShaderImage_TypeF(), "ReadOnly", (long) Qt3DRender::QShaderImage::Access::ReadOnly))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_ACCESS_IDX],
        Sbk_Qt3DRender_QShaderImage_TypeF(), "WriteOnly", (long) Qt3DRender::QShaderImage::Access::WriteOnly))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_ACCESS_IDX],
        Sbk_Qt3DRender_QShaderImage_TypeF(), "ReadWrite", (long) Qt3DRender::QShaderImage::Access::ReadWrite))
        return;
    // Register converter for enum 'Qt3DRender::QShaderImage::Access'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_ACCESS_IDX],
            Qt3DRender_QShaderImage_Access_CppToPython_Qt3DRender_QShaderImage_Access);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DRender_QShaderImage_Access_PythonToCpp_Qt3DRender_QShaderImage_Access,
            is_Qt3DRender_QShaderImage_Access_PythonToCpp_Qt3DRender_QShaderImage_Access_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_ACCESS_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QShaderImage::Access");
        Shiboken::Conversions::registerConverterName(converter, "QShaderImage::Access");
        Shiboken::Conversions::registerConverterName(converter, "Access");
    }
    // End of 'Access' enum.

    // Initialization of enum 'ImageFormat'.
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DRender_QShaderImage_TypeF(),
        "ImageFormat",
        "2:PySide2.Qt3DRender.Qt3DRender.QShaderImage.ImageFormat",
        "Qt3DRender::QShaderImage::ImageFormat");
    if (!SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX],
        Sbk_Qt3DRender_QShaderImage_TypeF(), "NoFormat", (long) Qt3DRender::QShaderImage::ImageFormat::NoFormat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX],
        Sbk_Qt3DRender_QShaderImage_TypeF(), "Automatic", (long) Qt3DRender::QShaderImage::ImageFormat::Automatic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX],
        Sbk_Qt3DRender_QShaderImage_TypeF(), "R8_UNorm", (long) Qt3DRender::QShaderImage::ImageFormat::R8_UNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX],
        Sbk_Qt3DRender_QShaderImage_TypeF(), "RG8_UNorm", (long) Qt3DRender::QShaderImage::ImageFormat::RG8_UNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX],
        Sbk_Qt3DRender_QShaderImage_TypeF(), "RGBA8_UNorm", (long) Qt3DRender::QShaderImage::ImageFormat::RGBA8_UNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX],
        Sbk_Qt3DRender_QShaderImage_TypeF(), "R16_UNorm", (long) Qt3DRender::QShaderImage::ImageFormat::R16_UNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX],
        Sbk_Qt3DRender_QShaderImage_TypeF(), "RG16_UNorm", (long) Qt3DRender::QShaderImage::ImageFormat::RG16_UNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX],
        Sbk_Qt3DRender_QShaderImage_TypeF(), "RGBA16_UNorm", (long) Qt3DRender::QShaderImage::ImageFormat::RGBA16_UNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX],
        Sbk_Qt3DRender_QShaderImage_TypeF(), "R8_SNorm", (long) Qt3DRender::QShaderImage::ImageFormat::R8_SNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX],
        Sbk_Qt3DRender_QShaderImage_TypeF(), "RG8_SNorm", (long) Qt3DRender::QShaderImage::ImageFormat::RG8_SNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX],
        Sbk_Qt3DRender_QShaderImage_TypeF(), "RGBA8_SNorm", (long) Qt3DRender::QShaderImage::ImageFormat::RGBA8_SNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX],
        Sbk_Qt3DRender_QShaderImage_TypeF(), "R16_SNorm", (long) Qt3DRender::QShaderImage::ImageFormat::R16_SNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX],
        Sbk_Qt3DRender_QShaderImage_TypeF(), "RG16_SNorm", (long) Qt3DRender::QShaderImage::ImageFormat::RG16_SNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX],
        Sbk_Qt3DRender_QShaderImage_TypeF(), "RGBA16_SNorm", (long) Qt3DRender::QShaderImage::ImageFormat::RGBA16_SNorm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX],
        Sbk_Qt3DRender_QShaderImage_TypeF(), "R8U", (long) Qt3DRender::QShaderImage::ImageFormat::R8U))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX],
        Sbk_Qt3DRender_QShaderImage_TypeF(), "RG8U", (long) Qt3DRender::QShaderImage::ImageFormat::RG8U))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX],
        Sbk_Qt3DRender_QShaderImage_TypeF(), "RGBA8U", (long) Qt3DRender::QShaderImage::ImageFormat::RGBA8U))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX],
        Sbk_Qt3DRender_QShaderImage_TypeF(), "R16U", (long) Qt3DRender::QShaderImage::ImageFormat::R16U))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX],
        Sbk_Qt3DRender_QShaderImage_TypeF(), "RG16U", (long) Qt3DRender::QShaderImage::ImageFormat::RG16U))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX],
        Sbk_Qt3DRender_QShaderImage_TypeF(), "RGBA16U", (long) Qt3DRender::QShaderImage::ImageFormat::RGBA16U))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX],
        Sbk_Qt3DRender_QShaderImage_TypeF(), "R32U", (long) Qt3DRender::QShaderImage::ImageFormat::R32U))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX],
        Sbk_Qt3DRender_QShaderImage_TypeF(), "RG32U", (long) Qt3DRender::QShaderImage::ImageFormat::RG32U))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX],
        Sbk_Qt3DRender_QShaderImage_TypeF(), "RGBA32U", (long) Qt3DRender::QShaderImage::ImageFormat::RGBA32U))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX],
        Sbk_Qt3DRender_QShaderImage_TypeF(), "R8I", (long) Qt3DRender::QShaderImage::ImageFormat::R8I))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX],
        Sbk_Qt3DRender_QShaderImage_TypeF(), "RG8I", (long) Qt3DRender::QShaderImage::ImageFormat::RG8I))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX],
        Sbk_Qt3DRender_QShaderImage_TypeF(), "RGBA8I", (long) Qt3DRender::QShaderImage::ImageFormat::RGBA8I))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX],
        Sbk_Qt3DRender_QShaderImage_TypeF(), "R16I", (long) Qt3DRender::QShaderImage::ImageFormat::R16I))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX],
        Sbk_Qt3DRender_QShaderImage_TypeF(), "RG16I", (long) Qt3DRender::QShaderImage::ImageFormat::RG16I))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX],
        Sbk_Qt3DRender_QShaderImage_TypeF(), "RGBA16I", (long) Qt3DRender::QShaderImage::ImageFormat::RGBA16I))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX],
        Sbk_Qt3DRender_QShaderImage_TypeF(), "R32I", (long) Qt3DRender::QShaderImage::ImageFormat::R32I))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX],
        Sbk_Qt3DRender_QShaderImage_TypeF(), "RG32I", (long) Qt3DRender::QShaderImage::ImageFormat::RG32I))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX],
        Sbk_Qt3DRender_QShaderImage_TypeF(), "RGBA32I", (long) Qt3DRender::QShaderImage::ImageFormat::RGBA32I))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX],
        Sbk_Qt3DRender_QShaderImage_TypeF(), "R16F", (long) Qt3DRender::QShaderImage::ImageFormat::R16F))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX],
        Sbk_Qt3DRender_QShaderImage_TypeF(), "RG16F", (long) Qt3DRender::QShaderImage::ImageFormat::RG16F))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX],
        Sbk_Qt3DRender_QShaderImage_TypeF(), "RGBA16F", (long) Qt3DRender::QShaderImage::ImageFormat::RGBA16F))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX],
        Sbk_Qt3DRender_QShaderImage_TypeF(), "R32F", (long) Qt3DRender::QShaderImage::ImageFormat::R32F))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX],
        Sbk_Qt3DRender_QShaderImage_TypeF(), "RG32F", (long) Qt3DRender::QShaderImage::ImageFormat::RG32F))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX],
        Sbk_Qt3DRender_QShaderImage_TypeF(), "RGBA32F", (long) Qt3DRender::QShaderImage::ImageFormat::RGBA32F))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX],
        Sbk_Qt3DRender_QShaderImage_TypeF(), "RG11B10F", (long) Qt3DRender::QShaderImage::ImageFormat::RG11B10F))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX],
        Sbk_Qt3DRender_QShaderImage_TypeF(), "RGB10A2", (long) Qt3DRender::QShaderImage::ImageFormat::RGB10A2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX],
        Sbk_Qt3DRender_QShaderImage_TypeF(), "RGB10A2U", (long) Qt3DRender::QShaderImage::ImageFormat::RGB10A2U))
        return;
    // Register converter for enum 'Qt3DRender::QShaderImage::ImageFormat'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX],
            Qt3DRender_QShaderImage_ImageFormat_CppToPython_Qt3DRender_QShaderImage_ImageFormat);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DRender_QShaderImage_ImageFormat_PythonToCpp_Qt3DRender_QShaderImage_ImageFormat,
            is_Qt3DRender_QShaderImage_ImageFormat_PythonToCpp_Qt3DRender_QShaderImage_ImageFormat_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QSHADERIMAGE_IMAGEFORMAT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QShaderImage::ImageFormat");
        Shiboken::Conversions::registerConverterName(converter, "QShaderImage::ImageFormat");
        Shiboken::Conversions::registerConverterName(converter, "ImageFormat");
    }
    // End of 'ImageFormat' enum.

    PySide::Signal::registerSignals(Sbk_Qt3DRender_QShaderImage_TypeF(), &::Qt3DRender::QShaderImage::staticMetaObject);
    qRegisterMetaType< ::Qt3DRender::QShaderImage::Access >("QShaderImage::Access");
    qRegisterMetaType< ::Qt3DRender::QShaderImage::Access >("Qt3DRender::QShaderImage::Access");
    qRegisterMetaType< ::Qt3DRender::QShaderImage::ImageFormat >("QShaderImage::ImageFormat");
    qRegisterMetaType< ::Qt3DRender::QShaderImage::ImageFormat >("Qt3DRender::QShaderImage::ImageFormat");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_Qt3DRender_QShaderImage_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_Qt3DRender_QShaderImage_TypeF(), &::Qt3DRender::QShaderImage::staticMetaObject, sizeof(QShaderImageWrapper));
}
