/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qt3drender_python.h"

// main header
#include "qt3drender_qtextureimagedata_wrapper.h"

// inner classes

// Extra includes
#include <Qt3DRender/qtextureimagedata.h>
#include <QtGui/qimage.h>
#include <qbytearray.h>


#include <cctype>
#include <cstring>

using namespace Qt3DRender;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_Qt3DRender_QTextureImageData_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::Qt3DRender::QTextureImageData >()))
        return -1;

    ::Qt3DRender::QTextureImageData *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QTextureImageData()
            cptr = new ::Qt3DRender::QTextureImageData();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::Qt3DRender::QTextureImageData >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_Qt3DRender_QTextureImageDataFunc_cleanup(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureImageData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREIMAGEDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.cleanup";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // cleanup()
            cppSelf->cleanup();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_Qt3DRender_QTextureImageDataFunc_data(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureImageData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREIMAGEDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.data";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_Qt3DRender_QTextureImageDataFunc_data_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:data", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QTextureImageData::data(int,int,int)const
    if (numArgs == 0) {
        overloadId = 0; // data(int,int,int)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // data(int,int,int)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // data(int,int,int)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
                overloadId = 0; // data(int,int,int)const
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QTextureImageDataFunc_data_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_layer = Shiboken::String::createStaticString("layer");
            if (PyDict_Contains(kwds, key_layer)) {
                value = PyDict_GetItem(kwds, key_layer);
                if (value && pyArgs[0]) {
                    errInfo = key_layer;
                    Py_INCREF(errInfo);
                    goto Sbk_Qt3DRender_QTextureImageDataFunc_data_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_Qt3DRender_QTextureImageDataFunc_data_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_layer);
            }
            static PyObject *const key_face = Shiboken::String::createStaticString("face");
            if (PyDict_Contains(kwds, key_face)) {
                value = PyDict_GetItem(kwds, key_face);
                if (value && pyArgs[1]) {
                    errInfo = key_face;
                    Py_INCREF(errInfo);
                    goto Sbk_Qt3DRender_QTextureImageDataFunc_data_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                        goto Sbk_Qt3DRender_QTextureImageDataFunc_data_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_face);
            }
            static PyObject *const key_mipmapLevel = Shiboken::String::createStaticString("mipmapLevel");
            if (PyDict_Contains(kwds, key_mipmapLevel)) {
                value = PyDict_GetItem(kwds, key_mipmapLevel);
                if (value && pyArgs[2]) {
                    errInfo = key_mipmapLevel;
                    Py_INCREF(errInfo);
                    goto Sbk_Qt3DRender_QTextureImageDataFunc_data_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                        goto Sbk_Qt3DRender_QTextureImageDataFunc_data_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_mipmapLevel);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_Qt3DRender_QTextureImageDataFunc_data_TypeError;
            }
        }
        int cppArg0 = 0;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = 0;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2 = 0;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // data(int,int,int)const
            QByteArray cppResult = const_cast<const ::Qt3DRender::QTextureImageData *>(cppSelf)->data(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_Qt3DRender_QTextureImageDataFunc_data_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QTextureImageDataFunc_depth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureImageData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREIMAGEDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.depth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // depth()const
            int cppResult = const_cast<const ::Qt3DRender::QTextureImageData *>(cppSelf)->depth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QTextureImageDataFunc_faces(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureImageData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREIMAGEDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.faces";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // faces()const
            int cppResult = const_cast<const ::Qt3DRender::QTextureImageData *>(cppSelf)->faces();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QTextureImageDataFunc_format(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureImageData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREIMAGEDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.format";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // format()const
            QOpenGLTexture::TextureFormat cppResult = const_cast<const ::Qt3DRender::QTextureImageData *>(cppSelf)->format();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QTextureImageDataFunc_height(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureImageData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREIMAGEDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.height";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // height()const
            int cppResult = const_cast<const ::Qt3DRender::QTextureImageData *>(cppSelf)->height();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QTextureImageDataFunc_isCompressed(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureImageData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREIMAGEDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.isCompressed";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isCompressed()const
            bool cppResult = const_cast<const ::Qt3DRender::QTextureImageData *>(cppSelf)->isCompressed();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QTextureImageDataFunc_layers(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureImageData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREIMAGEDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.layers";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // layers()const
            int cppResult = const_cast<const ::Qt3DRender::QTextureImageData *>(cppSelf)->layers();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QTextureImageDataFunc_mipLevels(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureImageData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREIMAGEDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.mipLevels";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mipLevels()const
            int cppResult = const_cast<const ::Qt3DRender::QTextureImageData *>(cppSelf)->mipLevels();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QTextureImageDataFunc_pixelFormat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureImageData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREIMAGEDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.pixelFormat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pixelFormat()const
            QOpenGLTexture::PixelFormat cppResult = const_cast<const ::Qt3DRender::QTextureImageData *>(cppSelf)->pixelFormat();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELFORMAT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QTextureImageDataFunc_pixelType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureImageData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREIMAGEDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.pixelType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pixelType()const
            QOpenGLTexture::PixelType cppResult = const_cast<const ::Qt3DRender::QTextureImageData *>(cppSelf)->pixelType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QTextureImageDataFunc_setData(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureImageData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREIMAGEDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.setData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_Qt3DRender_QTextureImageDataFunc_setData_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_Qt3DRender_QTextureImageDataFunc_setData_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:setData", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QTextureImageData::setData(QByteArray,int,bool)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // setData(QByteArray,int,bool)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[2])))) {
            overloadId = 0; // setData(QByteArray,int,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QTextureImageDataFunc_setData_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_isCompressed = Shiboken::String::createStaticString("isCompressed");
            if (PyDict_Contains(kwds, key_isCompressed)) {
                value = PyDict_GetItem(kwds, key_isCompressed);
                if (value && pyArgs[2]) {
                    errInfo = key_isCompressed;
                    Py_INCREF(errInfo);
                    goto Sbk_Qt3DRender_QTextureImageDataFunc_setData_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[2]))))
                        goto Sbk_Qt3DRender_QTextureImageDataFunc_setData_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_isCompressed);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_Qt3DRender_QTextureImageDataFunc_setData_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        bool cppArg2 = false;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // setData(QByteArray,int,bool)
            cppSelf->setData(*cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QTextureImageDataFunc_setData_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QTextureImageDataFunc_setDepth(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureImageData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREIMAGEDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.setDepth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextureImageData::setDepth(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setDepth(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QTextureImageDataFunc_setDepth_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDepth(int)
            cppSelf->setDepth(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QTextureImageDataFunc_setDepth_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QTextureImageDataFunc_setFaces(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureImageData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREIMAGEDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.setFaces";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextureImageData::setFaces(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setFaces(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QTextureImageDataFunc_setFaces_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFaces(int)
            cppSelf->setFaces(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QTextureImageDataFunc_setFaces_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QTextureImageDataFunc_setFormat(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureImageData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREIMAGEDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.setFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextureImageData::setFormat(QOpenGLTexture::TextureFormat)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TEXTUREFORMAT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setFormat(QOpenGLTexture::TextureFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QTextureImageDataFunc_setFormat_TypeError;

    // Call function/method
    {
        ::QOpenGLTexture::TextureFormat cppArg0{QOpenGLTexture::NoFormat};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFormat(QOpenGLTexture::TextureFormat)
            cppSelf->setFormat(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QTextureImageDataFunc_setFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QTextureImageDataFunc_setHeight(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureImageData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREIMAGEDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.setHeight";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextureImageData::setHeight(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setHeight(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QTextureImageDataFunc_setHeight_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setHeight(int)
            cppSelf->setHeight(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QTextureImageDataFunc_setHeight_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QTextureImageDataFunc_setImage(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureImageData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREIMAGEDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.setImage";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextureImageData::setImage(QImage)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), (pyArg)))) {
        overloadId = 0; // setImage(QImage)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QTextureImageDataFunc_setImage_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QImage cppArg0_local;
        ::QImage *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setImage(QImage)
            cppSelf->setImage(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QTextureImageDataFunc_setImage_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QTextureImageDataFunc_setLayers(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureImageData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREIMAGEDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.setLayers";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextureImageData::setLayers(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setLayers(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QTextureImageDataFunc_setLayers_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLayers(int)
            cppSelf->setLayers(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QTextureImageDataFunc_setLayers_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QTextureImageDataFunc_setMipLevels(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureImageData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREIMAGEDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.setMipLevels";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextureImageData::setMipLevels(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setMipLevels(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QTextureImageDataFunc_setMipLevels_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMipLevels(int)
            cppSelf->setMipLevels(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QTextureImageDataFunc_setMipLevels_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QTextureImageDataFunc_setPixelFormat(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureImageData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREIMAGEDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.setPixelFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextureImageData::setPixelFormat(QOpenGLTexture::PixelFormat)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELFORMAT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setPixelFormat(QOpenGLTexture::PixelFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QTextureImageDataFunc_setPixelFormat_TypeError;

    // Call function/method
    {
        ::QOpenGLTexture::PixelFormat cppArg0{QOpenGLTexture::NoSourceFormat};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPixelFormat(QOpenGLTexture::PixelFormat)
            cppSelf->setPixelFormat(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QTextureImageDataFunc_setPixelFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QTextureImageDataFunc_setPixelType(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureImageData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREIMAGEDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.setPixelType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextureImageData::setPixelType(QOpenGLTexture::PixelType)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_PIXELTYPE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setPixelType(QOpenGLTexture::PixelType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QTextureImageDataFunc_setPixelType_TypeError;

    // Call function/method
    {
        ::QOpenGLTexture::PixelType cppArg0{QOpenGLTexture::NoPixelType};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPixelType(QOpenGLTexture::PixelType)
            cppSelf->setPixelType(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QTextureImageDataFunc_setPixelType_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QTextureImageDataFunc_setTarget(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureImageData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREIMAGEDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.setTarget";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextureImageData::setTarget(QOpenGLTexture::Target)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TARGET_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setTarget(QOpenGLTexture::Target)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QTextureImageDataFunc_setTarget_TypeError;

    // Call function/method
    {
        ::QOpenGLTexture::Target cppArg0 = static_cast< ::QOpenGLTexture::Target>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTarget(QOpenGLTexture::Target)
            cppSelf->setTarget(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QTextureImageDataFunc_setTarget_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QTextureImageDataFunc_setWidth(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureImageData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREIMAGEDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.setWidth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextureImageData::setWidth(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setWidth(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DRender_QTextureImageDataFunc_setWidth_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setWidth(int)
            cppSelf->setWidth(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DRender_QTextureImageDataFunc_setWidth_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DRender_QTextureImageDataFunc_target(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureImageData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREIMAGEDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.target";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // target()const
            QOpenGLTexture::Target cppResult = const_cast<const ::Qt3DRender::QTextureImageData *>(cppSelf)->target();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_TARGET_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DRender_QTextureImageDataFunc_width(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DRender::QTextureImageData *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREIMAGEDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.width";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // width()const
            int cppResult = const_cast<const ::Qt3DRender::QTextureImageData *>(cppSelf)->width();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_Qt3DRender_QTextureImageData_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_Qt3DRender_QTextureImageData_methods[] = {
    {"cleanup", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureImageDataFunc_cleanup), METH_NOARGS},
    {"data", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureImageDataFunc_data), METH_VARARGS|METH_KEYWORDS},
    {"depth", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureImageDataFunc_depth), METH_NOARGS},
    {"faces", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureImageDataFunc_faces), METH_NOARGS},
    {"format", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureImageDataFunc_format), METH_NOARGS},
    {"height", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureImageDataFunc_height), METH_NOARGS},
    {"isCompressed", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureImageDataFunc_isCompressed), METH_NOARGS},
    {"layers", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureImageDataFunc_layers), METH_NOARGS},
    {"mipLevels", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureImageDataFunc_mipLevels), METH_NOARGS},
    {"pixelFormat", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureImageDataFunc_pixelFormat), METH_NOARGS},
    {"pixelType", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureImageDataFunc_pixelType), METH_NOARGS},
    {"setData", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureImageDataFunc_setData), METH_VARARGS|METH_KEYWORDS},
    {"setDepth", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureImageDataFunc_setDepth), METH_O},
    {"setFaces", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureImageDataFunc_setFaces), METH_O},
    {"setFormat", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureImageDataFunc_setFormat), METH_O},
    {"setHeight", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureImageDataFunc_setHeight), METH_O},
    {"setImage", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureImageDataFunc_setImage), METH_O},
    {"setLayers", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureImageDataFunc_setLayers), METH_O},
    {"setMipLevels", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureImageDataFunc_setMipLevels), METH_O},
    {"setPixelFormat", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureImageDataFunc_setPixelFormat), METH_O},
    {"setPixelType", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureImageDataFunc_setPixelType), METH_O},
    {"setTarget", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureImageDataFunc_setTarget), METH_O},
    {"setWidth", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureImageDataFunc_setWidth), METH_O},
    {"target", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureImageDataFunc_target), METH_NOARGS},
    {"width", reinterpret_cast<PyCFunction>(Sbk_Qt3DRender_QTextureImageDataFunc_width), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_Qt3DRender_QTextureImageData_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_Qt3DRender_QTextureImageData_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_Qt3DRender_QTextureImageData_Type = nullptr;
static SbkObjectType *Sbk_Qt3DRender_QTextureImageData_TypeF(void)
{
    return _Sbk_Qt3DRender_QTextureImageData_Type;
}

static PyType_Slot Sbk_Qt3DRender_QTextureImageData_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Qt3DRender_QTextureImageData_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Qt3DRender_QTextureImageData_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Qt3DRender_QTextureImageData_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_Qt3DRender_QTextureImageData_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_Qt3DRender_QTextureImageData_spec = {
    "2:PySide2.Qt3DRender.Qt3DRender.QTextureImageData",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_Qt3DRender_QTextureImageData_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QTextureImageData_PythonToCpp_QTextureImageData_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_Qt3DRender_QTextureImageData_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QTextureImageData_PythonToCpp_QTextureImageData_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_Qt3DRender_QTextureImageData_TypeF())))
        return QTextureImageData_PythonToCpp_QTextureImageData_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QTextureImageData_PTR_CppToPython_QTextureImageData(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::Qt3DRender::QTextureImageData *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_Qt3DRender_QTextureImageData_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *Qt3DRender_QTextureImageData_SignatureStrings[] = {
    "PySide2.Qt3DRender.Qt3DRender.QTextureImageData(self)",
    "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.cleanup(self)",
    "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.data(self,layer:int=0,face:int=0,mipmapLevel:int=0)->PySide2.QtCore.QByteArray",
    "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.depth(self)->int",
    "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.faces(self)->int",
    "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.format(self)->PySide2.QtGui.QOpenGLTexture.TextureFormat",
    "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.height(self)->int",
    "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.isCompressed(self)->bool",
    "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.layers(self)->int",
    "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.mipLevels(self)->int",
    "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.pixelFormat(self)->PySide2.QtGui.QOpenGLTexture.PixelFormat",
    "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.pixelType(self)->PySide2.QtGui.QOpenGLTexture.PixelType",
    "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.setData(self,data:PySide2.QtCore.QByteArray,blockSize:int,isCompressed:bool=false)",
    "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.setDepth(self,depth:int)",
    "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.setFaces(self,faces:int)",
    "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.setFormat(self,format:PySide2.QtGui.QOpenGLTexture.TextureFormat)",
    "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.setHeight(self,height:int)",
    "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.setImage(self,arg__1:PySide2.QtGui.QImage)",
    "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.setLayers(self,layers:int)",
    "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.setMipLevels(self,mipLevels:int)",
    "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.setPixelFormat(self,pixelFormat:PySide2.QtGui.QOpenGLTexture.PixelFormat)",
    "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.setPixelType(self,pixelType:PySide2.QtGui.QOpenGLTexture.PixelType)",
    "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.setTarget(self,target:PySide2.QtGui.QOpenGLTexture.Target)",
    "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.setWidth(self,width:int)",
    "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.target(self)->PySide2.QtGui.QOpenGLTexture.Target",
    "PySide2.Qt3DRender.Qt3DRender.QTextureImageData.width(self)->int",
    nullptr}; // Sentinel

void init_Qt3DRender_QTextureImageData(PyObject *enclosingClass)
{
    _Sbk_Qt3DRender_QTextureImageData_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QTextureImageData",
        "Qt3DRender::QTextureImageData*",
        &Sbk_Qt3DRender_QTextureImageData_spec,
        &Shiboken::callCppDestructor< ::Qt3DRender::QTextureImageData >,
        0,
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DRender_QTextureImageData_Type);
    InitSignatureStrings(pyType, Qt3DRender_QTextureImageData_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DRender_QTextureImageData_Type), Sbk_Qt3DRender_QTextureImageData_PropertyStrings);
    SbkPySide2_Qt3DRenderTypes[SBK_QT3DRENDER_QTEXTUREIMAGEDATA_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_Qt3DRender_QTextureImageData_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_Qt3DRender_QTextureImageData_TypeF(),
        QTextureImageData_PythonToCpp_QTextureImageData_PTR,
        is_QTextureImageData_PythonToCpp_QTextureImageData_PTR_Convertible,
        QTextureImageData_PTR_CppToPython_QTextureImageData);

    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QTextureImageData");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QTextureImageData*");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DRender::QTextureImageData&");
    Shiboken::Conversions::registerConverterName(converter, "QTextureImageData");
    Shiboken::Conversions::registerConverterName(converter, "QTextureImageData*");
    Shiboken::Conversions::registerConverterName(converter, "QTextureImageData&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::Qt3DRender::QTextureImageData).name());


}
