/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtcharts_python.h"

// main header
#include "qtcharts_qpieslice_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>

using namespace QtCharts;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QPieSliceWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QPieSliceWrapper::QPieSliceWrapper(::QObject * parent) : QtCharts::QPieSlice(parent)
{
    resetPyMethodCache();
    // ... middle
}

QPieSliceWrapper::QPieSliceWrapper(::QString label, qreal value, ::QObject * parent) : QtCharts::QPieSlice(label, value, parent)
{
    resetPyMethodCache();
    // ... middle
}

void QPieSliceWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QPieSliceWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QPieSliceWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QPieSliceWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QPieSliceWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPieSlice.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QPieSliceWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPieSlice.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QPieSliceWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QPieSliceWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QtCharts::QPieSlice::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QPieSliceWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QtCharts::QPieSlice::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QPieSliceWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QPieSliceWrapper *>(this));
        return QtCharts::QPieSlice::qt_metacast(_clname);
}

QPieSliceWrapper::~QPieSliceWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QtCharts_QPieSlice_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QtCharts::QPieSlice >()))
        return -1;

    ::QPieSliceWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QPieSlice.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|OOO:QPieSlice", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return -1;


    // Overloaded function decisor
    // 0: QPieSlice::QPieSlice(QObject*)
    // 1: QPieSlice::QPieSlice(QString,qreal,QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QPieSlice(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QPieSlice(QObject*)
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 1; // QPieSlice(QString,qreal,QObject*)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[2])))) {
            overloadId = 1; // QPieSlice(QString,qreal,QObject*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QPieSlice_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QPieSlice(QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[0]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QtCharts_QPieSlice_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                            goto Sbk_QtCharts_QPieSlice_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0 = nullptr;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QPieSlice(QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QPieSliceWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QPieSliceWrapper(cppArg0);
                }

                Shiboken::Object::setParent(pyArgs[0], self);
            }
            break;
        }
        case 1: // QPieSlice(QString label, qreal value, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[2]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QtCharts_QPieSlice_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[2]))))
                            goto Sbk_QtCharts_QPieSlice_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QObject *cppArg2 = nullptr;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // QPieSlice(QString,qreal,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QPieSliceWrapper(cppArg0, cppArg1, cppArg2);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QPieSliceWrapper(cppArg0, cppArg1, cppArg2);
                }

                Shiboken::Object::setParent(pyArgs[2], self);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QtCharts::QPieSlice >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QtCharts_QPieSlice_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QtCharts_QPieSlice_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QtCharts_QPieSlice_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QtCharts_QPieSliceFunc_angleSpan(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QPieSlice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QPieSlice.angleSpan";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // angleSpan()const
            qreal cppResult = const_cast<const ::QtCharts::QPieSlice *>(cppSelf)->angleSpan();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QPieSliceFunc_borderColor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QPieSlice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QPieSlice.borderColor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // borderColor()
            QColor cppResult = cppSelf->borderColor();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QPieSliceFunc_borderWidth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QPieSlice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QPieSlice.borderWidth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // borderWidth()
            int cppResult = cppSelf->borderWidth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QPieSliceFunc_brush(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QPieSlice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QPieSlice.brush";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // brush()const
            QBrush cppResult = const_cast<const ::QtCharts::QPieSlice *>(cppSelf)->brush();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QPieSliceFunc_color(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QPieSlice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QPieSlice.color";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // color()
            QColor cppResult = cppSelf->color();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QPieSliceFunc_explodeDistanceFactor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QPieSlice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QPieSlice.explodeDistanceFactor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // explodeDistanceFactor()const
            qreal cppResult = const_cast<const ::QtCharts::QPieSlice *>(cppSelf)->explodeDistanceFactor();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QPieSliceFunc_isExploded(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QPieSlice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QPieSlice.isExploded";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isExploded()const
            bool cppResult = const_cast<const ::QtCharts::QPieSlice *>(cppSelf)->isExploded();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QPieSliceFunc_isLabelVisible(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QPieSlice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QPieSlice.isLabelVisible";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isLabelVisible()const
            bool cppResult = const_cast<const ::QtCharts::QPieSlice *>(cppSelf)->isLabelVisible();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QPieSliceFunc_label(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QPieSlice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QPieSlice.label";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // label()const
            QString cppResult = const_cast<const ::QtCharts::QPieSlice *>(cppSelf)->label();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QPieSliceFunc_labelArmLengthFactor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QPieSlice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QPieSlice.labelArmLengthFactor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // labelArmLengthFactor()const
            qreal cppResult = const_cast<const ::QtCharts::QPieSlice *>(cppSelf)->labelArmLengthFactor();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QPieSliceFunc_labelBrush(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QPieSlice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QPieSlice.labelBrush";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // labelBrush()const
            QBrush cppResult = const_cast<const ::QtCharts::QPieSlice *>(cppSelf)->labelBrush();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QPieSliceFunc_labelColor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QPieSlice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QPieSlice.labelColor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // labelColor()
            QColor cppResult = cppSelf->labelColor();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QPieSliceFunc_labelFont(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QPieSlice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QPieSlice.labelFont";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // labelFont()const
            QFont cppResult = const_cast<const ::QtCharts::QPieSlice *>(cppSelf)->labelFont();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QPieSliceFunc_labelPosition(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QPieSlice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QPieSlice.labelPosition";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // labelPosition()
            QtCharts::QPieSlice::LabelPosition cppResult = cppSelf->labelPosition();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_LABELPOSITION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QPieSliceFunc_pen(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QPieSlice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QPieSlice.pen";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pen()const
            QPen cppResult = const_cast<const ::QtCharts::QPieSlice *>(cppSelf)->pen();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QPieSliceFunc_percentage(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QPieSlice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QPieSlice.percentage";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // percentage()const
            qreal cppResult = const_cast<const ::QtCharts::QPieSlice *>(cppSelf)->percentage();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QPieSliceFunc_series(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QPieSlice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QPieSlice.series";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // series()const
            QtCharts::QPieSeries * cppResult = const_cast<const ::QtCharts::QPieSlice *>(cppSelf)->series();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESERIES_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QPieSliceFunc_setBorderColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QPieSlice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QPieSlice.setBorderColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPieSlice::setBorderColor(QColor)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArg)))) {
        overloadId = 0; // setBorderColor(QColor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QPieSliceFunc_setBorderColor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setBorderColor(QColor)
            cppSelf->setBorderColor(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QPieSliceFunc_setBorderColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QPieSliceFunc_setBorderWidth(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QPieSlice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QPieSlice.setBorderWidth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPieSlice::setBorderWidth(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setBorderWidth(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QPieSliceFunc_setBorderWidth_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setBorderWidth(int)
            cppSelf->setBorderWidth(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QPieSliceFunc_setBorderWidth_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QPieSliceFunc_setBrush(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QPieSlice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QPieSlice.setBrush";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPieSlice::setBrush(QBrush)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArg)))) {
        overloadId = 0; // setBrush(QBrush)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QPieSliceFunc_setBrush_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QBrush cppArg0_local;
        ::QBrush *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setBrush(QBrush)
            cppSelf->setBrush(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QPieSliceFunc_setBrush_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QPieSliceFunc_setColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QPieSlice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QPieSlice.setColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPieSlice::setColor(QColor)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArg)))) {
        overloadId = 0; // setColor(QColor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QPieSliceFunc_setColor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setColor(QColor)
            cppSelf->setColor(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QPieSliceFunc_setColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QPieSliceFunc_setExplodeDistanceFactor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QPieSlice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QPieSlice.setExplodeDistanceFactor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPieSlice::setExplodeDistanceFactor(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setExplodeDistanceFactor(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QPieSliceFunc_setExplodeDistanceFactor_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setExplodeDistanceFactor(qreal)
            cppSelf->setExplodeDistanceFactor(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QPieSliceFunc_setExplodeDistanceFactor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QPieSliceFunc_setExploded(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QPieSlice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QPieSlice.setExploded";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QtCharts_QPieSliceFunc_setExploded_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:setExploded", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QPieSlice::setExploded(bool)
    if (numArgs == 0) {
        overloadId = 0; // setExploded(bool)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 0; // setExploded(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QPieSliceFunc_setExploded_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_exploded = Shiboken::String::createStaticString("exploded");
            if (PyDict_Contains(kwds, key_exploded)) {
                value = PyDict_GetItem(kwds, key_exploded);
                if (value && pyArgs[0]) {
                    errInfo = key_exploded;
                    Py_INCREF(errInfo);
                    goto Sbk_QtCharts_QPieSliceFunc_setExploded_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))
                        goto Sbk_QtCharts_QPieSliceFunc_setExploded_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_exploded);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QtCharts_QPieSliceFunc_setExploded_TypeError;
            }
        }
        bool cppArg0 = true;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // setExploded(bool)
            cppSelf->setExploded(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QPieSliceFunc_setExploded_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QPieSliceFunc_setLabel(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QPieSlice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QPieSlice.setLabel";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPieSlice::setLabel(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setLabel(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QPieSliceFunc_setLabel_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLabel(QString)
            cppSelf->setLabel(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QPieSliceFunc_setLabel_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QPieSliceFunc_setLabelArmLengthFactor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QPieSlice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QPieSlice.setLabelArmLengthFactor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPieSlice::setLabelArmLengthFactor(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setLabelArmLengthFactor(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QPieSliceFunc_setLabelArmLengthFactor_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLabelArmLengthFactor(qreal)
            cppSelf->setLabelArmLengthFactor(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QPieSliceFunc_setLabelArmLengthFactor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QPieSliceFunc_setLabelBrush(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QPieSlice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QPieSlice.setLabelBrush";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPieSlice::setLabelBrush(QBrush)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArg)))) {
        overloadId = 0; // setLabelBrush(QBrush)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QPieSliceFunc_setLabelBrush_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QBrush cppArg0_local;
        ::QBrush *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setLabelBrush(QBrush)
            cppSelf->setLabelBrush(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QPieSliceFunc_setLabelBrush_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QPieSliceFunc_setLabelColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QPieSlice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QPieSlice.setLabelColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPieSlice::setLabelColor(QColor)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArg)))) {
        overloadId = 0; // setLabelColor(QColor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QPieSliceFunc_setLabelColor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLabelColor(QColor)
            cppSelf->setLabelColor(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QPieSliceFunc_setLabelColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QPieSliceFunc_setLabelFont(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QPieSlice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QPieSlice.setLabelFont";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPieSlice::setLabelFont(QFont)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), (pyArg)))) {
        overloadId = 0; // setLabelFont(QFont)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QPieSliceFunc_setLabelFont_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QFont cppArg0_local;
        ::QFont *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setLabelFont(QFont)
            cppSelf->setLabelFont(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QPieSliceFunc_setLabelFont_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QPieSliceFunc_setLabelPosition(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QPieSlice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QPieSlice.setLabelPosition";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPieSlice::setLabelPosition(QtCharts::QPieSlice::LabelPosition)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_LABELPOSITION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setLabelPosition(QtCharts::QPieSlice::LabelPosition)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QPieSliceFunc_setLabelPosition_TypeError;

    // Call function/method
    {
        ::QtCharts::QPieSlice::LabelPosition cppArg0{QtCharts::QPieSlice::LabelOutside};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLabelPosition(QtCharts::QPieSlice::LabelPosition)
            cppSelf->setLabelPosition(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QPieSliceFunc_setLabelPosition_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QPieSliceFunc_setLabelVisible(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QPieSlice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QPieSlice.setLabelVisible";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QtCharts_QPieSliceFunc_setLabelVisible_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:setLabelVisible", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QPieSlice::setLabelVisible(bool)
    if (numArgs == 0) {
        overloadId = 0; // setLabelVisible(bool)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 0; // setLabelVisible(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QPieSliceFunc_setLabelVisible_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_visible = Shiboken::String::createStaticString("visible");
            if (PyDict_Contains(kwds, key_visible)) {
                value = PyDict_GetItem(kwds, key_visible);
                if (value && pyArgs[0]) {
                    errInfo = key_visible;
                    Py_INCREF(errInfo);
                    goto Sbk_QtCharts_QPieSliceFunc_setLabelVisible_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))
                        goto Sbk_QtCharts_QPieSliceFunc_setLabelVisible_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_visible);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QtCharts_QPieSliceFunc_setLabelVisible_TypeError;
            }
        }
        bool cppArg0 = true;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // setLabelVisible(bool)
            cppSelf->setLabelVisible(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QPieSliceFunc_setLabelVisible_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QPieSliceFunc_setPen(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QPieSlice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QPieSlice.setPen";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPieSlice::setPen(QPen)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), (pyArg)))) {
        overloadId = 0; // setPen(QPen)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QPieSliceFunc_setPen_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPen cppArg0_local;
        ::QPen *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setPen(QPen)
            cppSelf->setPen(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QPieSliceFunc_setPen_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QPieSliceFunc_setValue(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QPieSlice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QPieSlice.setValue";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPieSlice::setValue(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setValue(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QtCharts_QPieSliceFunc_setValue_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setValue(qreal)
            cppSelf->setValue(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QtCharts_QPieSliceFunc_setValue_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QtCharts_QPieSliceFunc_startAngle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QPieSlice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QPieSlice.startAngle";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // startAngle()const
            qreal cppResult = const_cast<const ::QtCharts::QPieSlice *>(cppSelf)->startAngle();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QtCharts_QPieSliceFunc_value(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QtCharts::QPieSlice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCharts.QtCharts.QPieSlice.value";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // value()const
            qreal cppResult = const_cast<const ::QtCharts::QPieSlice *>(cppSelf)->value();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QtCharts_QPieSlice_PropertyStrings[] = {
    "angleSpan:",
    "borderColor::",
    "borderWidth::",
    "brush::",
    "color::",
    "explodeDistanceFactor::",
    "exploded:isExploded:",
    "label::",
    "labelArmLengthFactor::",
    "labelBrush::",
    "labelColor::",
    "labelFont::",
    "labelPosition::",
    "labelVisible:isLabelVisible:",
    "pen::",
    "percentage:",
    "startAngle:",
    "value::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QtCharts_QPieSlice_methods[] = {
    {"angleSpan", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QPieSliceFunc_angleSpan), METH_NOARGS},
    {"borderColor", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QPieSliceFunc_borderColor), METH_NOARGS},
    {"borderWidth", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QPieSliceFunc_borderWidth), METH_NOARGS},
    {"brush", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QPieSliceFunc_brush), METH_NOARGS},
    {"color", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QPieSliceFunc_color), METH_NOARGS},
    {"explodeDistanceFactor", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QPieSliceFunc_explodeDistanceFactor), METH_NOARGS},
    {"isExploded", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QPieSliceFunc_isExploded), METH_NOARGS},
    {"isLabelVisible", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QPieSliceFunc_isLabelVisible), METH_NOARGS},
    {"label", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QPieSliceFunc_label), METH_NOARGS},
    {"labelArmLengthFactor", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QPieSliceFunc_labelArmLengthFactor), METH_NOARGS},
    {"labelBrush", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QPieSliceFunc_labelBrush), METH_NOARGS},
    {"labelColor", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QPieSliceFunc_labelColor), METH_NOARGS},
    {"labelFont", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QPieSliceFunc_labelFont), METH_NOARGS},
    {"labelPosition", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QPieSliceFunc_labelPosition), METH_NOARGS},
    {"pen", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QPieSliceFunc_pen), METH_NOARGS},
    {"percentage", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QPieSliceFunc_percentage), METH_NOARGS},
    {"series", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QPieSliceFunc_series), METH_NOARGS},
    {"setBorderColor", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QPieSliceFunc_setBorderColor), METH_O},
    {"setBorderWidth", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QPieSliceFunc_setBorderWidth), METH_O},
    {"setBrush", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QPieSliceFunc_setBrush), METH_O},
    {"setColor", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QPieSliceFunc_setColor), METH_O},
    {"setExplodeDistanceFactor", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QPieSliceFunc_setExplodeDistanceFactor), METH_O},
    {"setExploded", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QPieSliceFunc_setExploded), METH_VARARGS|METH_KEYWORDS},
    {"setLabel", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QPieSliceFunc_setLabel), METH_O},
    {"setLabelArmLengthFactor", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QPieSliceFunc_setLabelArmLengthFactor), METH_O},
    {"setLabelBrush", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QPieSliceFunc_setLabelBrush), METH_O},
    {"setLabelColor", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QPieSliceFunc_setLabelColor), METH_O},
    {"setLabelFont", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QPieSliceFunc_setLabelFont), METH_O},
    {"setLabelPosition", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QPieSliceFunc_setLabelPosition), METH_O},
    {"setLabelVisible", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QPieSliceFunc_setLabelVisible), METH_VARARGS|METH_KEYWORDS},
    {"setPen", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QPieSliceFunc_setPen), METH_O},
    {"setValue", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QPieSliceFunc_setValue), METH_O},
    {"startAngle", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QPieSliceFunc_startAngle), METH_NOARGS},
    {"value", reinterpret_cast<PyCFunction>(Sbk_QtCharts_QPieSliceFunc_value), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QtCharts_QPieSlice_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QtCharts::QPieSlice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QPieSliceWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QtCharts_QPieSlice_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QtCharts_QPieSlice_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QtCharts_QPieSlice_Type = nullptr;
static SbkObjectType *Sbk_QtCharts_QPieSlice_TypeF(void)
{
    return _Sbk_QtCharts_QPieSlice_Type;
}

static PyType_Slot Sbk_QtCharts_QPieSlice_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QtCharts_QPieSlice_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QtCharts_QPieSlice_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QtCharts_QPieSlice_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QtCharts_QPieSlice_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QtCharts_QPieSlice_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QtCharts_QPieSlice_spec = {
    "2:PySide2.QtCharts.QtCharts.QPieSlice",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QtCharts_QPieSlice_slots
};

} //extern "C"

static void *Sbk_QtCharts_QPieSlice_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QtCharts::QPieSlice *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QtCharts_QPieSlice_LabelPosition_PythonToCpp_QtCharts_QPieSlice_LabelPosition(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QtCharts::QPieSlice::LabelPosition *>(cppOut) =
        static_cast<::QtCharts::QPieSlice::LabelPosition>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QtCharts_QPieSlice_LabelPosition_PythonToCpp_QtCharts_QPieSlice_LabelPosition_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_LABELPOSITION_IDX]))
        return QtCharts_QPieSlice_LabelPosition_PythonToCpp_QtCharts_QPieSlice_LabelPosition;
    return {};
}
static PyObject *QtCharts_QPieSlice_LabelPosition_CppToPython_QtCharts_QPieSlice_LabelPosition(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QtCharts::QPieSlice::LabelPosition *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_LABELPOSITION_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QPieSlice_PythonToCpp_QPieSlice_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QtCharts_QPieSlice_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QPieSlice_PythonToCpp_QPieSlice_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QtCharts_QPieSlice_TypeF())))
        return QPieSlice_PythonToCpp_QPieSlice_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QPieSlice_PTR_CppToPython_QPieSlice(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QtCharts::QPieSlice *>(const_cast<void *>(cppIn)), Sbk_QtCharts_QPieSlice_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QtCharts_QPieSlice_SignatureStrings[] = {
    "1:PySide2.QtCharts.QtCharts.QPieSlice(self,parent:PySide2.QtCore.QObject=nullptr)",
    "0:PySide2.QtCharts.QtCharts.QPieSlice(self,label:QString,value:qreal,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtCharts.QtCharts.QPieSlice.angleSpan(self)->qreal",
    "PySide2.QtCharts.QtCharts.QPieSlice.borderColor(self)->PySide2.QtGui.QColor",
    "PySide2.QtCharts.QtCharts.QPieSlice.borderWidth(self)->int",
    "PySide2.QtCharts.QtCharts.QPieSlice.brush(self)->PySide2.QtGui.QBrush",
    "PySide2.QtCharts.QtCharts.QPieSlice.color(self)->PySide2.QtGui.QColor",
    "PySide2.QtCharts.QtCharts.QPieSlice.explodeDistanceFactor(self)->qreal",
    "PySide2.QtCharts.QtCharts.QPieSlice.isExploded(self)->bool",
    "PySide2.QtCharts.QtCharts.QPieSlice.isLabelVisible(self)->bool",
    "PySide2.QtCharts.QtCharts.QPieSlice.label(self)->QString",
    "PySide2.QtCharts.QtCharts.QPieSlice.labelArmLengthFactor(self)->qreal",
    "PySide2.QtCharts.QtCharts.QPieSlice.labelBrush(self)->PySide2.QtGui.QBrush",
    "PySide2.QtCharts.QtCharts.QPieSlice.labelColor(self)->PySide2.QtGui.QColor",
    "PySide2.QtCharts.QtCharts.QPieSlice.labelFont(self)->PySide2.QtGui.QFont",
    "PySide2.QtCharts.QtCharts.QPieSlice.labelPosition(self)->PySide2.QtCharts.QtCharts.QPieSlice.LabelPosition",
    "PySide2.QtCharts.QtCharts.QPieSlice.pen(self)->PySide2.QtGui.QPen",
    "PySide2.QtCharts.QtCharts.QPieSlice.percentage(self)->qreal",
    "PySide2.QtCharts.QtCharts.QPieSlice.series(self)->PySide2.QtCharts.QtCharts.QPieSeries",
    "PySide2.QtCharts.QtCharts.QPieSlice.setBorderColor(self,color:PySide2.QtGui.QColor)",
    "PySide2.QtCharts.QtCharts.QPieSlice.setBorderWidth(self,width:int)",
    "PySide2.QtCharts.QtCharts.QPieSlice.setBrush(self,brush:PySide2.QtGui.QBrush)",
    "PySide2.QtCharts.QtCharts.QPieSlice.setColor(self,color:PySide2.QtGui.QColor)",
    "PySide2.QtCharts.QtCharts.QPieSlice.setExplodeDistanceFactor(self,factor:qreal)",
    "PySide2.QtCharts.QtCharts.QPieSlice.setExploded(self,exploded:bool=true)",
    "PySide2.QtCharts.QtCharts.QPieSlice.setLabel(self,label:QString)",
    "PySide2.QtCharts.QtCharts.QPieSlice.setLabelArmLengthFactor(self,factor:qreal)",
    "PySide2.QtCharts.QtCharts.QPieSlice.setLabelBrush(self,brush:PySide2.QtGui.QBrush)",
    "PySide2.QtCharts.QtCharts.QPieSlice.setLabelColor(self,color:PySide2.QtGui.QColor)",
    "PySide2.QtCharts.QtCharts.QPieSlice.setLabelFont(self,font:PySide2.QtGui.QFont)",
    "PySide2.QtCharts.QtCharts.QPieSlice.setLabelPosition(self,position:PySide2.QtCharts.QtCharts.QPieSlice.LabelPosition)",
    "PySide2.QtCharts.QtCharts.QPieSlice.setLabelVisible(self,visible:bool=true)",
    "PySide2.QtCharts.QtCharts.QPieSlice.setPen(self,pen:PySide2.QtGui.QPen)",
    "PySide2.QtCharts.QtCharts.QPieSlice.setValue(self,value:qreal)",
    "PySide2.QtCharts.QtCharts.QPieSlice.startAngle(self)->qreal",
    "PySide2.QtCharts.QtCharts.QPieSlice.value(self)->qreal",
    nullptr}; // Sentinel

void init_QtCharts_QPieSlice(PyObject *enclosingClass)
{
    _Sbk_QtCharts_QPieSlice_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QPieSlice",
        "QtCharts::QPieSlice*",
        &Sbk_QtCharts_QPieSlice_spec,
        &Shiboken::callCppDestructor< ::QtCharts::QPieSlice >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QtCharts_QPieSlice_Type);
    InitSignatureStrings(pyType, QtCharts_QPieSlice_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QtCharts_QPieSlice_Type), Sbk_QtCharts_QPieSlice_PropertyStrings);
    SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QtCharts_QPieSlice_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QtCharts_QPieSlice_TypeF(),
        QPieSlice_PythonToCpp_QPieSlice_PTR,
        is_QPieSlice_PythonToCpp_QPieSlice_PTR_Convertible,
        QPieSlice_PTR_CppToPython_QPieSlice);

    Shiboken::Conversions::registerConverterName(converter, "QtCharts::QPieSlice");
    Shiboken::Conversions::registerConverterName(converter, "QtCharts::QPieSlice*");
    Shiboken::Conversions::registerConverterName(converter, "QtCharts::QPieSlice&");
    Shiboken::Conversions::registerConverterName(converter, "QPieSlice");
    Shiboken::Conversions::registerConverterName(converter, "QPieSlice*");
    Shiboken::Conversions::registerConverterName(converter, "QPieSlice&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QtCharts::QPieSlice).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QPieSliceWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QtCharts_QPieSlice_TypeF(), &Sbk_QtCharts_QPieSlice_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'LabelPosition'.
    SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_LABELPOSITION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QtCharts_QPieSlice_TypeF(),
        "LabelPosition",
        "2:PySide2.QtCharts.QtCharts.QPieSlice.LabelPosition",
        "QtCharts::QPieSlice::LabelPosition");
    if (!SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_LABELPOSITION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_LABELPOSITION_IDX],
        Sbk_QtCharts_QPieSlice_TypeF(), "LabelOutside", (long) QtCharts::QPieSlice::LabelPosition::LabelOutside))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_LABELPOSITION_IDX],
        Sbk_QtCharts_QPieSlice_TypeF(), "LabelInsideHorizontal", (long) QtCharts::QPieSlice::LabelPosition::LabelInsideHorizontal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_LABELPOSITION_IDX],
        Sbk_QtCharts_QPieSlice_TypeF(), "LabelInsideTangential", (long) QtCharts::QPieSlice::LabelPosition::LabelInsideTangential))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_LABELPOSITION_IDX],
        Sbk_QtCharts_QPieSlice_TypeF(), "LabelInsideNormal", (long) QtCharts::QPieSlice::LabelPosition::LabelInsideNormal))
        return;
    // Register converter for enum 'QtCharts::QPieSlice::LabelPosition'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_LABELPOSITION_IDX],
            QtCharts_QPieSlice_LabelPosition_CppToPython_QtCharts_QPieSlice_LabelPosition);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QtCharts_QPieSlice_LabelPosition_PythonToCpp_QtCharts_QPieSlice_LabelPosition,
            is_QtCharts_QPieSlice_LabelPosition_PythonToCpp_QtCharts_QPieSlice_LabelPosition_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtChartsTypes[SBK_QTCHARTS_QPIESLICE_LABELPOSITION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QtCharts::QPieSlice::LabelPosition");
        Shiboken::Conversions::registerConverterName(converter, "QPieSlice::LabelPosition");
        Shiboken::Conversions::registerConverterName(converter, "LabelPosition");
    }
    // End of 'LabelPosition' enum.

    PySide::Signal::registerSignals(Sbk_QtCharts_QPieSlice_TypeF(), &::QtCharts::QPieSlice::staticMetaObject);
    qRegisterMetaType< ::QtCharts::QPieSlice::LabelPosition >("QPieSlice::LabelPosition");
    qRegisterMetaType< ::QtCharts::QPieSlice::LabelPosition >("QtCharts::QPieSlice::LabelPosition");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QtCharts_QPieSlice_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QtCharts_QPieSlice_TypeF(), &::QtCharts::QPieSlice::staticMetaObject, sizeof(QPieSliceWrapper));
}
