/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtconcurrent_python.h"

// main header
#include "qfuturevoid_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QFutureVoid_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QFutureVoid >()))
        return -1;

    ::QFutureVoid *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtConcurrent.QFutureVoid.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QFutureVoid", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QFutureVoid::QFutureVoid()
    // 1: QFutureVoid::QFutureVoid(QFutureVoid)
    if (numArgs == 0) {
        overloadId = 0; // QFutureVoid()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREVOID_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QFutureVoid(QFutureVoid)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFutureVoid_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QFutureVoid()
        {

            if (!PyErr_Occurred()) {
                // QFutureVoid()
                cptr = new ::QFutureVoid();
            }
            break;
        }
        case 1: // QFutureVoid(const QFutureVoid & QFutureVoid)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QFutureVoid cppArg0_local;
            ::QFutureVoid *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREVOID_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QFutureVoid(QFutureVoid)
                cptr = new ::QFutureVoid(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QFutureVoid >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QFutureVoid_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QFutureVoid_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QFutureVoidFunc_cancel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureVoid *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREVOID_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtConcurrent.QFutureVoid.cancel";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // cancel()
            cppSelf->cancel();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QFutureVoidFunc_isCanceled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureVoid *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREVOID_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtConcurrent.QFutureVoid.isCanceled";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isCanceled()const
            bool cppResult = const_cast<const ::QFutureVoid *>(cppSelf)->isCanceled();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFutureVoidFunc_isFinished(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureVoid *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREVOID_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtConcurrent.QFutureVoid.isFinished";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isFinished()const
            bool cppResult = const_cast<const ::QFutureVoid *>(cppSelf)->isFinished();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFutureVoidFunc_isPaused(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureVoid *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREVOID_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtConcurrent.QFutureVoid.isPaused";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isPaused()const
            bool cppResult = const_cast<const ::QFutureVoid *>(cppSelf)->isPaused();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFutureVoidFunc_isRunning(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureVoid *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREVOID_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtConcurrent.QFutureVoid.isRunning";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isRunning()const
            bool cppResult = const_cast<const ::QFutureVoid *>(cppSelf)->isRunning();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFutureVoidFunc_isStarted(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureVoid *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREVOID_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtConcurrent.QFutureVoid.isStarted";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isStarted()const
            bool cppResult = const_cast<const ::QFutureVoid *>(cppSelf)->isStarted();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFutureVoidFunc_pause(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureVoid *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREVOID_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtConcurrent.QFutureVoid.pause";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pause()
            cppSelf->pause();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QFutureVoidFunc_progressMaximum(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureVoid *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREVOID_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtConcurrent.QFutureVoid.progressMaximum";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // progressMaximum()const
            int cppResult = const_cast<const ::QFutureVoid *>(cppSelf)->progressMaximum();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFutureVoidFunc_progressMinimum(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureVoid *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREVOID_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtConcurrent.QFutureVoid.progressMinimum";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // progressMinimum()const
            int cppResult = const_cast<const ::QFutureVoid *>(cppSelf)->progressMinimum();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFutureVoidFunc_progressText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureVoid *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREVOID_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtConcurrent.QFutureVoid.progressText";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // progressText()const
            QString cppResult = const_cast<const ::QFutureVoid *>(cppSelf)->progressText();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFutureVoidFunc_progressValue(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureVoid *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREVOID_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtConcurrent.QFutureVoid.progressValue";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // progressValue()const
            int cppResult = const_cast<const ::QFutureVoid *>(cppSelf)->progressValue();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFutureVoidFunc_resultCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureVoid *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREVOID_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtConcurrent.QFutureVoid.resultCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // resultCount()const
            int cppResult = const_cast<const ::QFutureVoid *>(cppSelf)->resultCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFutureVoidFunc_resume(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureVoid *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREVOID_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtConcurrent.QFutureVoid.resume";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // resume()
            cppSelf->resume();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QFutureVoidFunc_setPaused(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureVoid *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREVOID_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtConcurrent.QFutureVoid.setPaused";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFutureVoid::setPaused(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setPaused(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFutureVoidFunc_setPaused_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPaused(bool)
            cppSelf->setPaused(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFutureVoidFunc_setPaused_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFutureVoidFunc_togglePaused(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureVoid *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREVOID_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtConcurrent.QFutureVoid.togglePaused";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // togglePaused()
            cppSelf->togglePaused();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QFutureVoidFunc_waitForFinished(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFutureVoid *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREVOID_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtConcurrent.QFutureVoid.waitForFinished";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // waitForFinished()
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            cppSelf->waitForFinished();
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QFutureVoid___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QFutureVoid *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREVOID_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREVOID_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QFutureVoid_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QFutureVoid_methods[] = {
    {"cancel", reinterpret_cast<PyCFunction>(Sbk_QFutureVoidFunc_cancel), METH_NOARGS},
    {"isCanceled", reinterpret_cast<PyCFunction>(Sbk_QFutureVoidFunc_isCanceled), METH_NOARGS},
    {"isFinished", reinterpret_cast<PyCFunction>(Sbk_QFutureVoidFunc_isFinished), METH_NOARGS},
    {"isPaused", reinterpret_cast<PyCFunction>(Sbk_QFutureVoidFunc_isPaused), METH_NOARGS},
    {"isRunning", reinterpret_cast<PyCFunction>(Sbk_QFutureVoidFunc_isRunning), METH_NOARGS},
    {"isStarted", reinterpret_cast<PyCFunction>(Sbk_QFutureVoidFunc_isStarted), METH_NOARGS},
    {"pause", reinterpret_cast<PyCFunction>(Sbk_QFutureVoidFunc_pause), METH_NOARGS},
    {"progressMaximum", reinterpret_cast<PyCFunction>(Sbk_QFutureVoidFunc_progressMaximum), METH_NOARGS},
    {"progressMinimum", reinterpret_cast<PyCFunction>(Sbk_QFutureVoidFunc_progressMinimum), METH_NOARGS},
    {"progressText", reinterpret_cast<PyCFunction>(Sbk_QFutureVoidFunc_progressText), METH_NOARGS},
    {"progressValue", reinterpret_cast<PyCFunction>(Sbk_QFutureVoidFunc_progressValue), METH_NOARGS},
    {"resultCount", reinterpret_cast<PyCFunction>(Sbk_QFutureVoidFunc_resultCount), METH_NOARGS},
    {"resume", reinterpret_cast<PyCFunction>(Sbk_QFutureVoidFunc_resume), METH_NOARGS},
    {"setPaused", reinterpret_cast<PyCFunction>(Sbk_QFutureVoidFunc_setPaused), METH_O},
    {"togglePaused", reinterpret_cast<PyCFunction>(Sbk_QFutureVoidFunc_togglePaused), METH_NOARGS},
    {"waitForFinished", reinterpret_cast<PyCFunction>(Sbk_QFutureVoidFunc_waitForFinished), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QFutureVoid___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QFutureVoid_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QFutureVoid_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QFutureVoid_Type = nullptr;
static SbkObjectType *Sbk_QFutureVoid_TypeF(void)
{
    return _Sbk_QFutureVoid_Type;
}

static PyType_Slot Sbk_QFutureVoid_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QFutureVoid_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QFutureVoid_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QFutureVoid_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QFutureVoid_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QFutureVoid_spec = {
    "2:PySide2.QtConcurrent.QFutureVoid",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QFutureVoid_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QFutureVoid_PythonToCpp_QFutureVoid_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QFutureVoid_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QFutureVoid_PythonToCpp_QFutureVoid_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QFutureVoid_TypeF())))
        return QFutureVoid_PythonToCpp_QFutureVoid_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QFutureVoid_PTR_CppToPython_QFutureVoid(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QFutureVoid *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QFutureVoid_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QFutureVoid_COPY_CppToPython_QFutureVoid(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QFutureVoid_TypeF(), new ::QFutureVoid(*reinterpret_cast<const ::QFutureVoid *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QFutureVoid_PythonToCpp_QFutureVoid_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFutureVoid *>(cppOut) = *reinterpret_cast< ::QFutureVoid *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtConcurrentTypes[SBK_QFUTUREVOID_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QFutureVoid_PythonToCpp_QFutureVoid_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QFutureVoid_TypeF())))
        return QFutureVoid_PythonToCpp_QFutureVoid_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QFutureVoid_SignatureStrings[] = {
    "1:PySide2.QtConcurrent.QFutureVoid(self)",
    "0:PySide2.QtConcurrent.QFutureVoid(self,QFutureVoid:PySide2.QtConcurrent.QFutureVoid)",
    "PySide2.QtConcurrent.QFutureVoid.cancel(self)",
    "PySide2.QtConcurrent.QFutureVoid.isCanceled(self)->bool",
    "PySide2.QtConcurrent.QFutureVoid.isFinished(self)->bool",
    "PySide2.QtConcurrent.QFutureVoid.isPaused(self)->bool",
    "PySide2.QtConcurrent.QFutureVoid.isRunning(self)->bool",
    "PySide2.QtConcurrent.QFutureVoid.isStarted(self)->bool",
    "PySide2.QtConcurrent.QFutureVoid.pause(self)",
    "PySide2.QtConcurrent.QFutureVoid.progressMaximum(self)->int",
    "PySide2.QtConcurrent.QFutureVoid.progressMinimum(self)->int",
    "PySide2.QtConcurrent.QFutureVoid.progressText(self)->QString",
    "PySide2.QtConcurrent.QFutureVoid.progressValue(self)->int",
    "PySide2.QtConcurrent.QFutureVoid.resultCount(self)->int",
    "PySide2.QtConcurrent.QFutureVoid.resume(self)",
    "PySide2.QtConcurrent.QFutureVoid.setPaused(self,paused:bool)",
    "PySide2.QtConcurrent.QFutureVoid.togglePaused(self)",
    "PySide2.QtConcurrent.QFutureVoid.waitForFinished(self)",
    "PySide2.QtConcurrent.QFutureVoid.__copy__()",
    nullptr}; // Sentinel

void init_QFutureVoid(PyObject *module)
{
    _Sbk_QFutureVoid_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QFutureVoid",
        "QFutureVoid",
        &Sbk_QFutureVoid_spec,
        &Shiboken::callCppDestructor< ::QFutureVoid >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QFutureVoid_Type);
    InitSignatureStrings(pyType, QFutureVoid_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QFutureVoid_Type), Sbk_QFutureVoid_PropertyStrings);
    SbkPySide2_QtConcurrentTypes[SBK_QFUTUREVOID_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QFutureVoid_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QFutureVoid_TypeF(),
        QFutureVoid_PythonToCpp_QFutureVoid_PTR,
        is_QFutureVoid_PythonToCpp_QFutureVoid_PTR_Convertible,
        QFutureVoid_PTR_CppToPython_QFutureVoid,
        QFutureVoid_COPY_CppToPython_QFutureVoid);

    Shiboken::Conversions::registerConverterName(converter, "QFutureVoid");
    Shiboken::Conversions::registerConverterName(converter, "QFutureVoid*");
    Shiboken::Conversions::registerConverterName(converter, "QFutureVoid&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QFutureVoid).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QFutureVoid_PythonToCpp_QFutureVoid_COPY,
        is_QFutureVoid_PythonToCpp_QFutureVoid_COPY_Convertible);

    qRegisterMetaType< ::QFutureVoid >("QFutureVoid");
}
