/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qabstractproxymodel_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QAbstractProxyModelWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QAbstractProxyModelWrapper::QAbstractProxyModelWrapper(::QObject * parent) : QAbstractProxyModel(parent)
{
    resetPyMethodCache();
    // ... middle
}

::QModelIndex QAbstractProxyModelWrapper::buddy(const ::QModelIndex & index) const
{
    if (m_PyMethodCache[0])
        return this->::QAbstractProxyModel::buddy(index);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "buddy";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QAbstractProxyModel::buddy(index);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &index)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractProxyModel.buddy", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QModelIndex >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QModelIndex cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QAbstractProxyModelWrapper::canDropMimeData(const ::QMimeData * data, ::Qt::DropAction action, int row, int column, const ::QModelIndex & parent) const
{
    if (m_PyMethodCache[1])
        return this->::QAbstractProxyModel::canDropMimeData(data, action, row, column, parent);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "canDropMimeData";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QAbstractProxyModel::canDropMimeData(data, action, row, column, parent);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNiiN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMIMEDATA_IDX]), data),
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_DROPACTION_IDX])->converter, &action),
    row,
    column,
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &parent)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractProxyModel.canDropMimeData", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QAbstractProxyModelWrapper::canFetchMore(const ::QModelIndex & parent) const
{
    if (m_PyMethodCache[2])
        return this->::QAbstractProxyModel::canFetchMore(parent);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "canFetchMore";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QAbstractProxyModel::canFetchMore(parent);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &parent)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractProxyModel.canFetchMore", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractProxyModelWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

int QAbstractProxyModelWrapper::columnCount(const ::QModelIndex & parent) const
{
    if (m_PyMethodCache[4]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractProxyModel.columnCount()' not implemented.");
        return 0;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "columnCount";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractProxyModel.columnCount()' not implemented.");
        return 0;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &parent)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractProxyModel.columnCount", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractProxyModelWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[5]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractProxyModelWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[6]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

::QVariant QAbstractProxyModelWrapper::data(const ::QModelIndex & proxyIndex, int role) const
{
    if (m_PyMethodCache[7])
        return this->::QAbstractProxyModel::data(proxyIndex, role);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QVariant();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "data";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QAbstractProxyModel::data(proxyIndex, role);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(Ni)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &proxyIndex),
    role
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QVariant();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractProxyModel.data", "QVariant", Py_TYPE(pyResult)->tp_name);
        return ::QVariant();
    }
    ::QVariant cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (Shiboken::Object::checkType(pyResult))
        Shiboken::Object::releaseOwnership(pyResult);
    return cppResult;
}

void QAbstractProxyModelWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[8]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QAbstractProxyModelWrapper::dropMimeData(const ::QMimeData * data, ::Qt::DropAction action, int row, int column, const ::QModelIndex & parent)
{
    if (m_PyMethodCache[9])
        return this->::QAbstractProxyModel::dropMimeData(data, action, row, column, parent);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "dropMimeData";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QAbstractProxyModel::dropMimeData(data, action, row, column, parent);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNiiN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMIMEDATA_IDX]), data),
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_DROPACTION_IDX])->converter, &action),
    row,
    column,
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &parent)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractProxyModel.dropMimeData", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QAbstractProxyModelWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[10])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractProxyModel.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QAbstractProxyModelWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[11])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[11] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractProxyModel.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QAbstractProxyModelWrapper::fetchMore(const ::QModelIndex & parent)
{
    if (m_PyMethodCache[12]) {
        return this->::QAbstractProxyModel::fetchMore(parent);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "fetchMore";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[12] = true;
        return this->::QAbstractProxyModel::fetchMore(parent);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &parent)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QFlags<Qt::ItemFlag> QAbstractProxyModelWrapper::flags(const ::QModelIndex & index) const
{
    if (m_PyMethodCache[13])
        return this->::QAbstractProxyModel::flags(index);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QFlags<Qt::ItemFlag>(0);
    static PyObject *nameCache[2] = {};
    static const char *funcName = "flags";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[13] = true;
        return this->::QAbstractProxyModel::flags(index);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &index)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QFlags<Qt::ItemFlag>(0);
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ITEMFLAG_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractProxyModel.flags", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QFlags<Qt::ItemFlag> >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QFlags<Qt::ItemFlag>(0);
    }
    ::QFlags<Qt::ItemFlag> cppResult = QFlags<Qt::ItemFlag>(0);
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QAbstractProxyModelWrapper::hasChildren(const ::QModelIndex & parent) const
{
    if (m_PyMethodCache[14])
        return this->::QAbstractProxyModel::hasChildren(parent);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "hasChildren";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[14] = true;
        return this->::QAbstractProxyModel::hasChildren(parent);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &parent)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractProxyModel.hasChildren", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QVariant QAbstractProxyModelWrapper::headerData(int section, ::Qt::Orientation orientation, int role) const
{
    if (m_PyMethodCache[15])
        return this->::QAbstractProxyModel::headerData(section, orientation, role);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QVariant();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "headerData";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[15] = true;
        return this->::QAbstractProxyModel::headerData(section, orientation, role);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(iNi)",
    section,
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ORIENTATION_IDX])->converter, &orientation),
    role
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QVariant();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractProxyModel.headerData", "QVariant", Py_TYPE(pyResult)->tp_name);
        return ::QVariant();
    }
    ::QVariant cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QModelIndex QAbstractProxyModelWrapper::index(int row, int column, const ::QModelIndex & parent) const
{
    if (m_PyMethodCache[16]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractProxyModel.index()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "index";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[16] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractProxyModel.index()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(iiN)",
    row,
    column,
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &parent)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractProxyModel.index", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QModelIndex >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QModelIndex cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QAbstractProxyModelWrapper::insertColumns(int column, int count, const ::QModelIndex & parent)
{
    if (m_PyMethodCache[17])
        return this->::QAbstractItemModel::insertColumns(column, count, parent);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "insertColumns";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[17] = true;
        return this->::QAbstractItemModel::insertColumns(column, count, parent);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(iiN)",
    column,
    count,
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &parent)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractProxyModel.insertColumns", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QAbstractProxyModelWrapper::insertRows(int row, int count, const ::QModelIndex & parent)
{
    if (m_PyMethodCache[18])
        return this->::QAbstractItemModel::insertRows(row, count, parent);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "insertRows";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[18] = true;
        return this->::QAbstractItemModel::insertRows(row, count, parent);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(iiN)",
    row,
    count,
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &parent)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractProxyModel.insertRows", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QMap<int,QVariant > QAbstractProxyModelWrapper::itemData(const ::QModelIndex & index) const
{
    if (m_PyMethodCache[19])
        return this->::QAbstractProxyModel::itemData(index);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "itemData";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[19] = true;
        return this->::QAbstractProxyModel::itemData(index);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &index)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QMAP_INT_QVARIANT_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractProxyModel.itemData", "map", Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QMap<int,QVariant > cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QModelIndex QAbstractProxyModelWrapper::mapFromSource(const ::QModelIndex & sourceIndex) const
{
    if (m_PyMethodCache[20]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractProxyModel.mapFromSource()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mapFromSource";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[20] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractProxyModel.mapFromSource()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &sourceIndex)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractProxyModel.mapFromSource", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QModelIndex >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QModelIndex cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QItemSelection QAbstractProxyModelWrapper::mapSelectionFromSource(const ::QItemSelection & selection) const
{
    if (m_PyMethodCache[21])
        return this->::QAbstractProxyModel::mapSelectionFromSource(selection);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mapSelectionFromSource";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[21] = true;
        return this->::QAbstractProxyModel::mapSelectionFromSource(selection);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX]), &selection)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractProxyModel.mapSelectionFromSource", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QItemSelection >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QItemSelection cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QItemSelection QAbstractProxyModelWrapper::mapSelectionToSource(const ::QItemSelection & selection) const
{
    if (m_PyMethodCache[22])
        return this->::QAbstractProxyModel::mapSelectionToSource(selection);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mapSelectionToSource";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[22] = true;
        return this->::QAbstractProxyModel::mapSelectionToSource(selection);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX]), &selection)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractProxyModel.mapSelectionToSource", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QItemSelection >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QItemSelection cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QModelIndex QAbstractProxyModelWrapper::mapToSource(const ::QModelIndex & proxyIndex) const
{
    if (m_PyMethodCache[23]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractProxyModel.mapToSource()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mapToSource";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[23] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractProxyModel.mapToSource()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &proxyIndex)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractProxyModel.mapToSource", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QModelIndex >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QModelIndex cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QModelIndexList QAbstractProxyModelWrapper::match(const ::QModelIndex & start, int role, const ::QVariant & value, int hits, ::QFlags<Qt::MatchFlag> flags) const
{
    if (m_PyMethodCache[24])
        return this->::QAbstractItemModel::match(start, role, value, hits, flags);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QModelIndexList();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "match";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[24] = true;
        return this->::QAbstractItemModel::match(start, role, value, hits, flags);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NiNiN)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &start),
    role,
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &value),
    hits,
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MATCHFLAG_IDX])->converter, &flags)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QModelIndexList();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QMODELINDEXLIST_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractProxyModel.match", "QModelIndexList", Py_TYPE(pyResult)->tp_name);
        return ::QModelIndexList();
    }
    ::QModelIndexList cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QMimeData * QAbstractProxyModelWrapper::mimeData(const ::QModelIndexList & indexes) const
{
    if (m_PyMethodCache[26])
        return this->::QAbstractProxyModel::mimeData(indexes);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mimeData";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[26] = true;
        return this->::QAbstractProxyModel::mimeData(indexes);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QMODELINDEXLIST_IDX], &indexes)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMIMEDATA_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractProxyModel.mimeData", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QMimeData >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QMimeData *cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (Shiboken::Object::checkType(pyResult))
        Shiboken::Object::releaseOwnership(pyResult);
    return cppResult;
}

::QStringList QAbstractProxyModelWrapper::mimeTypes() const
{
    if (m_PyMethodCache[27])
        return this->::QAbstractProxyModel::mimeTypes();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QStringList();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mimeTypes";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[27] = true;
        return this->::QAbstractProxyModel::mimeTypes();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QStringList();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractProxyModel.mimeTypes", "QStringList", Py_TYPE(pyResult)->tp_name);
        return ::QStringList();
    }
    ::QStringList cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QAbstractProxyModelWrapper::moveColumns(const ::QModelIndex & sourceParent, int sourceColumn, int count, const ::QModelIndex & destinationParent, int destinationChild)
{
    if (m_PyMethodCache[28])
        return this->::QAbstractItemModel::moveColumns(sourceParent, sourceColumn, count, destinationParent, destinationChild);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "moveColumns";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[28] = true;
        return this->::QAbstractItemModel::moveColumns(sourceParent, sourceColumn, count, destinationParent, destinationChild);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NiiNi)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &sourceParent),
    sourceColumn,
    count,
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &destinationParent),
    destinationChild
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractProxyModel.moveColumns", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QAbstractProxyModelWrapper::moveRows(const ::QModelIndex & sourceParent, int sourceRow, int count, const ::QModelIndex & destinationParent, int destinationChild)
{
    if (m_PyMethodCache[29])
        return this->::QAbstractItemModel::moveRows(sourceParent, sourceRow, count, destinationParent, destinationChild);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "moveRows";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[29] = true;
        return this->::QAbstractItemModel::moveRows(sourceParent, sourceRow, count, destinationParent, destinationChild);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NiiNi)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &sourceParent),
    sourceRow,
    count,
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &destinationParent),
    destinationChild
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractProxyModel.moveRows", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QModelIndex QAbstractProxyModelWrapper::parent(const ::QModelIndex & child) const
{
    if (m_PyMethodCache[30]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractProxyModel.parent()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "parent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[30] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractProxyModel.parent()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &child)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractProxyModel.parent", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QModelIndex >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QModelIndex cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QAbstractProxyModelWrapper::removeColumns(int column, int count, const ::QModelIndex & parent)
{
    if (m_PyMethodCache[31])
        return this->::QAbstractItemModel::removeColumns(column, count, parent);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "removeColumns";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[31] = true;
        return this->::QAbstractItemModel::removeColumns(column, count, parent);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(iiN)",
    column,
    count,
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &parent)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractProxyModel.removeColumns", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QAbstractProxyModelWrapper::removeRows(int row, int count, const ::QModelIndex & parent)
{
    if (m_PyMethodCache[32])
        return this->::QAbstractItemModel::removeRows(row, count, parent);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "removeRows";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[32] = true;
        return this->::QAbstractItemModel::removeRows(row, count, parent);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(iiN)",
    row,
    count,
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &parent)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractProxyModel.removeRows", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractProxyModelWrapper::revert()
{
    if (m_PyMethodCache[33]) {
        return this->::QAbstractProxyModel::revert();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "revert";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[33] = true;
        return this->::QAbstractProxyModel::revert();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QHash<int,QByteArray > QAbstractProxyModelWrapper::roleNames() const
{
    if (m_PyMethodCache[34])
        return this->::QAbstractItemModel::roleNames();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "roleNames";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[34] = true;
        return this->::QAbstractItemModel::roleNames();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QHASH_INT_QBYTEARRAY_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractProxyModel.roleNames", "hash", Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QHash<int,QByteArray > cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

int QAbstractProxyModelWrapper::rowCount(const ::QModelIndex & parent) const
{
    if (m_PyMethodCache[35]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractProxyModel.rowCount()' not implemented.");
        return 0;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "rowCount";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[35] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractProxyModel.rowCount()' not implemented.");
        return 0;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &parent)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractProxyModel.rowCount", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QAbstractProxyModelWrapper::setData(const ::QModelIndex & index, const ::QVariant & value, int role)
{
    if (m_PyMethodCache[36])
        return this->::QAbstractProxyModel::setData(index, value, role);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setData";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[36] = true;
        return this->::QAbstractProxyModel::setData(index, value, role);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNi)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &index),
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &value),
    role
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractProxyModel.setData", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QAbstractProxyModelWrapper::setHeaderData(int section, ::Qt::Orientation orientation, const ::QVariant & value, int role)
{
    if (m_PyMethodCache[37])
        return this->::QAbstractProxyModel::setHeaderData(section, orientation, value, role);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setHeaderData";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[37] = true;
        return this->::QAbstractProxyModel::setHeaderData(section, orientation, value, role);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(iNNi)",
    section,
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ORIENTATION_IDX])->converter, &orientation),
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &value),
    role
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractProxyModel.setHeaderData", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QAbstractProxyModelWrapper::setItemData(const ::QModelIndex & index, const ::QMap<int,QVariant > & roles)
{
    if (m_PyMethodCache[38])
        return this->::QAbstractProxyModel::setItemData(index, roles);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setItemData";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[38] = true;
        return this->::QAbstractProxyModel::setItemData(index, roles);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &index),
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QMAP_INT_QVARIANT_IDX], &roles)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractProxyModel.setItemData", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractProxyModelWrapper::setSourceModel(::QAbstractItemModel * sourceModel)
{
    if (m_PyMethodCache[39]) {
        return this->::QAbstractProxyModel::setSourceModel(sourceModel);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    // This method belongs to a property.
    static const char *funcName = "2:setSourceModel";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[39] = true;
        return this->::QAbstractProxyModel::setSourceModel(sourceModel);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTITEMMODEL_IDX]), sourceModel)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QModelIndex QAbstractProxyModelWrapper::sibling(int row, int column, const ::QModelIndex & idx) const
{
    if (m_PyMethodCache[40])
        return this->::QAbstractProxyModel::sibling(row, column, idx);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "sibling";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[40] = true;
        return this->::QAbstractProxyModel::sibling(row, column, idx);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(iiN)",
    row,
    column,
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &idx)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractProxyModel.sibling", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QModelIndex >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QModelIndex cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractProxyModelWrapper::sort(int column, ::Qt::SortOrder order)
{
    if (m_PyMethodCache[41]) {
        return this->::QAbstractProxyModel::sort(column, order);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "sort";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[41] = true;
        return this->::QAbstractProxyModel::sort(column, order);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(iN)",
    column,
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SORTORDER_IDX])->converter, &order)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QSize QAbstractProxyModelWrapper::span(const ::QModelIndex & index) const
{
    if (m_PyMethodCache[42])
        return this->::QAbstractProxyModel::span(index);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "span";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[42] = true;
        return this->::QAbstractProxyModel::span(index);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &index)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractProxyModel.span", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSize >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QSize cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QAbstractProxyModelWrapper::submit()
{
    if (m_PyMethodCache[43])
        return this->::QAbstractProxyModel::submit();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "submit";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[43] = true;
        return this->::QAbstractProxyModel::submit();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractProxyModel.submit", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QFlags<Qt::DropAction> QAbstractProxyModelWrapper::supportedDragActions() const
{
    if (m_PyMethodCache[44])
        return this->::QAbstractProxyModel::supportedDragActions();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QFlags<Qt::DropAction>(0);
    static PyObject *nameCache[2] = {};
    static const char *funcName = "supportedDragActions";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[44] = true;
        return this->::QAbstractProxyModel::supportedDragActions();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QFlags<Qt::DropAction>(0);
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_DROPACTION_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractProxyModel.supportedDragActions", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QFlags<Qt::DropAction> >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QFlags<Qt::DropAction>(0);
    }
    ::QFlags<Qt::DropAction> cppResult = QFlags<Qt::DropAction>(0);
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QFlags<Qt::DropAction> QAbstractProxyModelWrapper::supportedDropActions() const
{
    if (m_PyMethodCache[45])
        return this->::QAbstractProxyModel::supportedDropActions();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QFlags<Qt::DropAction>(0);
    static PyObject *nameCache[2] = {};
    static const char *funcName = "supportedDropActions";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[45] = true;
        return this->::QAbstractProxyModel::supportedDropActions();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QFlags<Qt::DropAction>(0);
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_DROPACTION_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractProxyModel.supportedDropActions", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QFlags<Qt::DropAction> >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QFlags<Qt::DropAction>(0);
    }
    ::QFlags<Qt::DropAction> cppResult = QFlags<Qt::DropAction>(0);
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractProxyModelWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[46]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[46] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QAbstractProxyModelWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QAbstractProxyModel::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QAbstractProxyModelWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QAbstractProxyModel::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QAbstractProxyModelWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QAbstractProxyModelWrapper *>(this));
        return QAbstractProxyModel::qt_metacast(_clname);
}

QAbstractProxyModelWrapper::~QAbstractProxyModelWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QAbstractProxyModel_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTPROXYMODEL_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QAbstractProxyModel' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QAbstractProxyModel >()))
        return -1;

    ::QAbstractProxyModelWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractProxyModel.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QAbstractProxyModel", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QAbstractProxyModel::QAbstractProxyModel(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QAbstractProxyModel(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QAbstractProxyModel(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractProxyModel_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QAbstractProxyModel_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_QAbstractProxyModel_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QAbstractProxyModel(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QAbstractProxyModelWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QAbstractProxyModelWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QAbstractProxyModel >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QAbstractProxyModel_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QAbstractProxyModel_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QAbstractProxyModel_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QAbstractProxyModelFunc_buddy(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractProxyModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTPROXYMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractProxyModel.buddy";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemModel::buddy(QModelIndex)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArg)))) {
        overloadId = 0; // buddy(QModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractProxyModelFunc_buddy_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // buddy(QModelIndex)const
            QModelIndex cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QAbstractProxyModel *>(cppSelf)->::QAbstractProxyModel::buddy(*cppArg0)
                : const_cast<const ::QAbstractProxyModel *>(cppSelf)->buddy(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractProxyModelFunc_buddy_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractProxyModelFunc_canDropMimeData(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractProxyModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTPROXYMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractProxyModel.canDropMimeData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "canDropMimeData", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemModel::canDropMimeData(const QMimeData*,Qt::DropAction,int,int,QModelIndex)const
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMIMEDATA_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_DROPACTION_IDX])->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArgs[4])))) {
        overloadId = 0; // canDropMimeData(const QMimeData*,Qt::DropAction,int,int,QModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractProxyModelFunc_canDropMimeData_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QMimeData *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::Qt::DropAction cppArg1{Qt::IgnoreAction};
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        if (!Shiboken::Object::isValid(pyArgs[4]))
            return {};
        ::QModelIndex cppArg4_local;
        ::QModelIndex *cppArg4 = &cppArg4_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp[4]))
            pythonToCpp[4](pyArgs[4], &cppArg4_local);
        else
            pythonToCpp[4](pyArgs[4], &cppArg4);


        if (!PyErr_Occurred()) {
            // canDropMimeData(const QMimeData*,Qt::DropAction,int,int,QModelIndex)const
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QAbstractProxyModel *>(cppSelf)->::QAbstractProxyModel::canDropMimeData(cppArg0, cppArg1, cppArg2, cppArg3, *cppArg4)
                : const_cast<const ::QAbstractProxyModel *>(cppSelf)->canDropMimeData(cppArg0, cppArg1, cppArg2, cppArg3, *cppArg4);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractProxyModelFunc_canDropMimeData_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractProxyModelFunc_canFetchMore(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractProxyModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTPROXYMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractProxyModel.canFetchMore";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemModel::canFetchMore(QModelIndex)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArg)))) {
        overloadId = 0; // canFetchMore(QModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractProxyModelFunc_canFetchMore_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // canFetchMore(QModelIndex)const
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QAbstractProxyModel *>(cppSelf)->::QAbstractProxyModel::canFetchMore(*cppArg0)
                : const_cast<const ::QAbstractProxyModel *>(cppSelf)->canFetchMore(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractProxyModelFunc_canFetchMore_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractProxyModelFunc_data(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractProxyModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTPROXYMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractProxyModel.data";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QAbstractProxyModelFunc_data_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QAbstractProxyModelFunc_data_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:data", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemModel::data(QModelIndex,int)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // data(QModelIndex,int)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // data(QModelIndex,int)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractProxyModelFunc_data_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_role = Shiboken::String::createStaticString("role");
            if (PyDict_Contains(kwds, key_role)) {
                value = PyDict_GetItem(kwds, key_role);
                if (value && pyArgs[1]) {
                    errInfo = key_role;
                    Py_INCREF(errInfo);
                    goto Sbk_QAbstractProxyModelFunc_data_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                        goto Sbk_QAbstractProxyModelFunc_data_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_role);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QAbstractProxyModelFunc_data_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        int cppArg1 = Qt::DisplayRole;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // data(QModelIndex,int)const
            QVariant cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QAbstractProxyModel *>(cppSelf)->::QAbstractProxyModel::data(*cppArg0, cppArg1)
                : const_cast<const ::QAbstractProxyModel *>(cppSelf)->data(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractProxyModelFunc_data_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractProxyModelFunc_dropMimeData(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractProxyModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTPROXYMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractProxyModel.dropMimeData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "dropMimeData", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemModel::dropMimeData(const QMimeData*,Qt::DropAction,int,int,QModelIndex)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMIMEDATA_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_DROPACTION_IDX])->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArgs[4])))) {
        overloadId = 0; // dropMimeData(const QMimeData*,Qt::DropAction,int,int,QModelIndex)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractProxyModelFunc_dropMimeData_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QMimeData *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::Qt::DropAction cppArg1{Qt::IgnoreAction};
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        if (!Shiboken::Object::isValid(pyArgs[4]))
            return {};
        ::QModelIndex cppArg4_local;
        ::QModelIndex *cppArg4 = &cppArg4_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp[4]))
            pythonToCpp[4](pyArgs[4], &cppArg4_local);
        else
            pythonToCpp[4](pyArgs[4], &cppArg4);


        if (!PyErr_Occurred()) {
            // dropMimeData(const QMimeData*,Qt::DropAction,int,int,QModelIndex)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractProxyModel::dropMimeData(cppArg0, cppArg1, cppArg2, cppArg3, *cppArg4)
                : cppSelf->dropMimeData(cppArg0, cppArg1, cppArg2, cppArg3, *cppArg4);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractProxyModelFunc_dropMimeData_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractProxyModelFunc_fetchMore(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractProxyModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTPROXYMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractProxyModel.fetchMore";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemModel::fetchMore(QModelIndex)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArg)))) {
        overloadId = 0; // fetchMore(QModelIndex)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractProxyModelFunc_fetchMore_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // fetchMore(QModelIndex)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractProxyModel::fetchMore(*cppArg0)
                : cppSelf->fetchMore(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractProxyModelFunc_fetchMore_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractProxyModelFunc_flags(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractProxyModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTPROXYMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractProxyModel.flags";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemModel::flags(QModelIndex)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArg)))) {
        overloadId = 0; // flags(QModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractProxyModelFunc_flags_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // flags(QModelIndex)const
            QFlags<Qt::ItemFlag> cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QAbstractProxyModel *>(cppSelf)->::QAbstractProxyModel::flags(*cppArg0)
                : const_cast<const ::QAbstractProxyModel *>(cppSelf)->flags(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ITEMFLAG_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractProxyModelFunc_flags_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractProxyModelFunc_hasChildren(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractProxyModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTPROXYMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractProxyModel.hasChildren";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QAbstractProxyModelFunc_hasChildren_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:hasChildren", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemModel::hasChildren(QModelIndex)const
    if (numArgs == 0) {
        overloadId = 0; // hasChildren(QModelIndex)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArgs[0])))) {
        overloadId = 0; // hasChildren(QModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractProxyModelFunc_hasChildren_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QAbstractProxyModelFunc_hasChildren_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArgs[0]))))
                        goto Sbk_QAbstractProxyModelFunc_hasChildren_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QAbstractProxyModelFunc_hasChildren_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QModelIndex cppArg0_local = QModelIndex();
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);
        }

        if (!PyErr_Occurred()) {
            // hasChildren(QModelIndex)const
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QAbstractProxyModel *>(cppSelf)->::QAbstractProxyModel::hasChildren(*cppArg0)
                : const_cast<const ::QAbstractProxyModel *>(cppSelf)->hasChildren(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractProxyModelFunc_hasChildren_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractProxyModelFunc_headerData(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractProxyModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTPROXYMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractProxyModel.headerData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QAbstractProxyModelFunc_headerData_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QAbstractProxyModelFunc_headerData_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:headerData", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemModel::headerData(int,Qt::Orientation,int)const
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ORIENTATION_IDX])->converter, (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // headerData(int,Qt::Orientation,int)const
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
            overloadId = 0; // headerData(int,Qt::Orientation,int)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractProxyModelFunc_headerData_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_role = Shiboken::String::createStaticString("role");
            if (PyDict_Contains(kwds, key_role)) {
                value = PyDict_GetItem(kwds, key_role);
                if (value && pyArgs[2]) {
                    errInfo = key_role;
                    Py_INCREF(errInfo);
                    goto Sbk_QAbstractProxyModelFunc_headerData_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                        goto Sbk_QAbstractProxyModelFunc_headerData_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_role);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QAbstractProxyModelFunc_headerData_TypeError;
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::Qt::Orientation cppArg1 = static_cast< ::Qt::Orientation>(0);
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2 = Qt::DisplayRole;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // headerData(int,Qt::Orientation,int)const
            QVariant cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QAbstractProxyModel *>(cppSelf)->::QAbstractProxyModel::headerData(cppArg0, cppArg1, cppArg2)
                : const_cast<const ::QAbstractProxyModel *>(cppSelf)->headerData(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractProxyModelFunc_headerData_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractProxyModelFunc_itemData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractProxyModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTPROXYMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractProxyModel.itemData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemModel::itemData(QModelIndex)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArg)))) {
        overloadId = 0; // itemData(QModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractProxyModelFunc_itemData_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // itemData(QModelIndex)const
            QMap<int,QVariant > cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QAbstractProxyModel *>(cppSelf)->::QAbstractProxyModel::itemData(*cppArg0)
                : const_cast<const ::QAbstractProxyModel *>(cppSelf)->itemData(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QMAP_INT_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractProxyModelFunc_itemData_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractProxyModelFunc_mapFromSource(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractProxyModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTPROXYMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractProxyModel.mapFromSource";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractProxyModel::mapFromSource(QModelIndex)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArg)))) {
        overloadId = 0; // mapFromSource(QModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractProxyModelFunc_mapFromSource_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // mapFromSource(QModelIndex)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractProxyModel.mapFromSource()' not implemented.");
                return {};
            }
            QModelIndex cppResult = const_cast<const ::QAbstractProxyModel *>(cppSelf)->mapFromSource(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractProxyModelFunc_mapFromSource_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractProxyModelFunc_mapSelectionFromSource(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractProxyModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTPROXYMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractProxyModel.mapSelectionFromSource";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractProxyModel::mapSelectionFromSource(QItemSelection)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX]), (pyArg)))) {
        overloadId = 0; // mapSelectionFromSource(QItemSelection)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractProxyModelFunc_mapSelectionFromSource_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QItemSelection cppArg0_local;
        ::QItemSelection *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // mapSelectionFromSource(QItemSelection)const
            QItemSelection cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QAbstractProxyModel *>(cppSelf)->::QAbstractProxyModel::mapSelectionFromSource(*cppArg0)
                : const_cast<const ::QAbstractProxyModel *>(cppSelf)->mapSelectionFromSource(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractProxyModelFunc_mapSelectionFromSource_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractProxyModelFunc_mapSelectionToSource(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractProxyModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTPROXYMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractProxyModel.mapSelectionToSource";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractProxyModel::mapSelectionToSource(QItemSelection)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX]), (pyArg)))) {
        overloadId = 0; // mapSelectionToSource(QItemSelection)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractProxyModelFunc_mapSelectionToSource_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QItemSelection cppArg0_local;
        ::QItemSelection *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // mapSelectionToSource(QItemSelection)const
            QItemSelection cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QAbstractProxyModel *>(cppSelf)->::QAbstractProxyModel::mapSelectionToSource(*cppArg0)
                : const_cast<const ::QAbstractProxyModel *>(cppSelf)->mapSelectionToSource(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTION_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractProxyModelFunc_mapSelectionToSource_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractProxyModelFunc_mapToSource(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractProxyModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTPROXYMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractProxyModel.mapToSource";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractProxyModel::mapToSource(QModelIndex)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArg)))) {
        overloadId = 0; // mapToSource(QModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractProxyModelFunc_mapToSource_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // mapToSource(QModelIndex)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractProxyModel.mapToSource()' not implemented.");
                return {};
            }
            QModelIndex cppResult = const_cast<const ::QAbstractProxyModel *>(cppSelf)->mapToSource(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractProxyModelFunc_mapToSource_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractProxyModelFunc_mimeData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractProxyModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTPROXYMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractProxyModel.mimeData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemModel::mimeData(QModelIndexList)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QMODELINDEXLIST_IDX], (pyArg)))) {
        overloadId = 0; // mimeData(QModelIndexList)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractProxyModelFunc_mimeData_TypeError;

    // Call function/method
    {
        ::QModelIndexList cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // mimeData(QModelIndexList)const
            QMimeData * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QAbstractProxyModel *>(cppSelf)->::QAbstractProxyModel::mimeData(cppArg0)
                : const_cast<const ::QAbstractProxyModel *>(cppSelf)->mimeData(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMIMEDATA_IDX]), cppResult);

            // Ownership transferences.
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractProxyModelFunc_mimeData_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractProxyModelFunc_mimeTypes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractProxyModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTPROXYMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractProxyModel.mimeTypes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mimeTypes()const
            QStringList cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QAbstractProxyModel *>(cppSelf)->::QAbstractProxyModel::mimeTypes()
                : const_cast<const ::QAbstractProxyModel *>(cppSelf)->mimeTypes();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractProxyModelFunc_resetInternalData(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractProxyModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTPROXYMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractProxyModel.resetInternalData";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // resetInternalData()
            cppSelf->resetInternalData();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QAbstractProxyModelFunc_revert(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractProxyModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTPROXYMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractProxyModel.revert";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // revert()
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractProxyModel::revert()
                : cppSelf->revert();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QAbstractProxyModelFunc_setData(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractProxyModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTPROXYMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractProxyModel.setData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QAbstractProxyModelFunc_setData_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QAbstractProxyModelFunc_setData_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:setData", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemModel::setData(QModelIndex,QVariant,int)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // setData(QModelIndex,QVariant,int)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
            overloadId = 0; // setData(QModelIndex,QVariant,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractProxyModelFunc_setData_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_role = Shiboken::String::createStaticString("role");
            if (PyDict_Contains(kwds, key_role)) {
                value = PyDict_GetItem(kwds, key_role);
                if (value && pyArgs[2]) {
                    errInfo = key_role;
                    Py_INCREF(errInfo);
                    goto Sbk_QAbstractProxyModelFunc_setData_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                        goto Sbk_QAbstractProxyModelFunc_setData_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_role);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QAbstractProxyModelFunc_setData_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QVariant cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2 = Qt::EditRole;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // setData(QModelIndex,QVariant,int)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractProxyModel::setData(*cppArg0, cppArg1, cppArg2)
                : cppSelf->setData(*cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractProxyModelFunc_setData_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractProxyModelFunc_setHeaderData(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractProxyModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTPROXYMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractProxyModel.setHeaderData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QAbstractProxyModelFunc_setHeaderData_TypeError;
    } else if (numArgs < 3) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QAbstractProxyModelFunc_setHeaderData_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:setHeaderData", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemModel::setHeaderData(int,Qt::Orientation,QVariant,int)
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ORIENTATION_IDX])->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // setHeaderData(int,Qt::Orientation,QVariant,int)
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
            overloadId = 0; // setHeaderData(int,Qt::Orientation,QVariant,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractProxyModelFunc_setHeaderData_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_role = Shiboken::String::createStaticString("role");
            if (PyDict_Contains(kwds, key_role)) {
                value = PyDict_GetItem(kwds, key_role);
                if (value && pyArgs[3]) {
                    errInfo = key_role;
                    Py_INCREF(errInfo);
                    goto Sbk_QAbstractProxyModelFunc_setHeaderData_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))
                        goto Sbk_QAbstractProxyModelFunc_setHeaderData_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_role);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QAbstractProxyModelFunc_setHeaderData_TypeError;
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::Qt::Orientation cppArg1 = static_cast< ::Qt::Orientation>(0);
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QVariant cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3 = Qt::EditRole;
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // setHeaderData(int,Qt::Orientation,QVariant,int)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractProxyModel::setHeaderData(cppArg0, cppArg1, cppArg2, cppArg3)
                : cppSelf->setHeaderData(cppArg0, cppArg1, cppArg2, cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractProxyModelFunc_setHeaderData_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractProxyModelFunc_setItemData(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractProxyModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTPROXYMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractProxyModel.setItemData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setItemData", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemModel::setItemData(QModelIndex,QMap<int,QVariant>)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QTCORE_QMAP_INT_QVARIANT_IDX], (pyArgs[1])))) {
        overloadId = 0; // setItemData(QModelIndex,QMap<int,QVariant>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractProxyModelFunc_setItemData_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QMap<int,QVariant > cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setItemData(QModelIndex,QMap<int,QVariant>)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractProxyModel::setItemData(*cppArg0, cppArg1)
                : cppSelf->setItemData(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractProxyModelFunc_setItemData_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractProxyModelFunc_setSourceModel(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractProxyModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTPROXYMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractProxyModel.setSourceModel";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractProxyModel::setSourceModel(QAbstractItemModel*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTITEMMODEL_IDX]), (pyArg)))) {
        overloadId = 0; // setSourceModel(QAbstractItemModel*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractProxyModelFunc_setSourceModel_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAbstractItemModel *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSourceModel(QAbstractItemModel*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractProxyModel::setSourceModel(cppArg0)
                : cppSelf->setSourceModel(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractProxyModelFunc_setSourceModel_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractProxyModelFunc_sibling(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractProxyModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTPROXYMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractProxyModel.sibling";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "sibling", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemModel::sibling(int,int,QModelIndex)const
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArgs[2])))) {
        overloadId = 0; // sibling(int,int,QModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractProxyModelFunc_sibling_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QModelIndex cppArg2_local;
        ::QModelIndex *cppArg2 = &cppArg2_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp[2]))
            pythonToCpp[2](pyArgs[2], &cppArg2_local);
        else
            pythonToCpp[2](pyArgs[2], &cppArg2);


        if (!PyErr_Occurred()) {
            // sibling(int,int,QModelIndex)const
            QModelIndex cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QAbstractProxyModel *>(cppSelf)->::QAbstractProxyModel::sibling(cppArg0, cppArg1, *cppArg2)
                : const_cast<const ::QAbstractProxyModel *>(cppSelf)->sibling(cppArg0, cppArg1, *cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractProxyModelFunc_sibling_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractProxyModelFunc_sort(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractProxyModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTPROXYMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractProxyModel.sort";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QAbstractProxyModelFunc_sort_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QAbstractProxyModelFunc_sort_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:sort", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemModel::sort(int,Qt::SortOrder)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // sort(int,Qt::SortOrder)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SORTORDER_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // sort(int,Qt::SortOrder)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractProxyModelFunc_sort_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_order = Shiboken::String::createStaticString("order");
            if (PyDict_Contains(kwds, key_order)) {
                value = PyDict_GetItem(kwds, key_order);
                if (value && pyArgs[1]) {
                    errInfo = key_order;
                    Py_INCREF(errInfo);
                    goto Sbk_QAbstractProxyModelFunc_sort_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SORTORDER_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QAbstractProxyModelFunc_sort_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_order);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QAbstractProxyModelFunc_sort_TypeError;
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::Qt::SortOrder cppArg1 = Qt::AscendingOrder;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // sort(int,Qt::SortOrder)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractProxyModel::sort(cppArg0, cppArg1)
                : cppSelf->sort(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractProxyModelFunc_sort_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractProxyModelFunc_sourceModel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractProxyModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTPROXYMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractProxyModel.sourceModel";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sourceModel()const
            QAbstractItemModel * cppResult = const_cast<const ::QAbstractProxyModel *>(cppSelf)->sourceModel();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTITEMMODEL_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractProxyModelFunc_span(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractProxyModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTPROXYMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractProxyModel.span";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemModel::span(QModelIndex)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyArg)))) {
        overloadId = 0; // span(QModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractProxyModelFunc_span_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // span(QModelIndex)const
            QSize cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QAbstractProxyModel *>(cppSelf)->::QAbstractProxyModel::span(*cppArg0)
                : const_cast<const ::QAbstractProxyModel *>(cppSelf)->span(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractProxyModelFunc_span_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractProxyModelFunc_submit(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractProxyModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTPROXYMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractProxyModel.submit";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // submit()
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractProxyModel::submit()
                : cppSelf->submit();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractProxyModelFunc_supportedDragActions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractProxyModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTPROXYMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractProxyModel.supportedDragActions";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedDragActions()const
            QFlags<Qt::DropAction> cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QAbstractProxyModel *>(cppSelf)->::QAbstractProxyModel::supportedDragActions()
                : const_cast<const ::QAbstractProxyModel *>(cppSelf)->supportedDragActions();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_DROPACTION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractProxyModelFunc_supportedDropActions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractProxyModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTPROXYMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QAbstractProxyModel.supportedDropActions";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedDropActions()const
            QFlags<Qt::DropAction> cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QAbstractProxyModel *>(cppSelf)->::QAbstractProxyModel::supportedDropActions()
                : const_cast<const ::QAbstractProxyModel *>(cppSelf)->supportedDropActions();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_DROPACTION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QAbstractProxyModel_PropertyStrings[] = {
    "sourceModel::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QAbstractProxyModel_methods[] = {
    {"buddy", reinterpret_cast<PyCFunction>(Sbk_QAbstractProxyModelFunc_buddy), METH_O},
    {"canDropMimeData", reinterpret_cast<PyCFunction>(Sbk_QAbstractProxyModelFunc_canDropMimeData), METH_VARARGS},
    {"canFetchMore", reinterpret_cast<PyCFunction>(Sbk_QAbstractProxyModelFunc_canFetchMore), METH_O},
    {"data", reinterpret_cast<PyCFunction>(Sbk_QAbstractProxyModelFunc_data), METH_VARARGS|METH_KEYWORDS},
    {"dropMimeData", reinterpret_cast<PyCFunction>(Sbk_QAbstractProxyModelFunc_dropMimeData), METH_VARARGS},
    {"fetchMore", reinterpret_cast<PyCFunction>(Sbk_QAbstractProxyModelFunc_fetchMore), METH_O},
    {"flags", reinterpret_cast<PyCFunction>(Sbk_QAbstractProxyModelFunc_flags), METH_O},
    {"hasChildren", reinterpret_cast<PyCFunction>(Sbk_QAbstractProxyModelFunc_hasChildren), METH_VARARGS|METH_KEYWORDS},
    {"headerData", reinterpret_cast<PyCFunction>(Sbk_QAbstractProxyModelFunc_headerData), METH_VARARGS|METH_KEYWORDS},
    {"itemData", reinterpret_cast<PyCFunction>(Sbk_QAbstractProxyModelFunc_itemData), METH_O},
    {"mapFromSource", reinterpret_cast<PyCFunction>(Sbk_QAbstractProxyModelFunc_mapFromSource), METH_O},
    {"mapSelectionFromSource", reinterpret_cast<PyCFunction>(Sbk_QAbstractProxyModelFunc_mapSelectionFromSource), METH_O},
    {"mapSelectionToSource", reinterpret_cast<PyCFunction>(Sbk_QAbstractProxyModelFunc_mapSelectionToSource), METH_O},
    {"mapToSource", reinterpret_cast<PyCFunction>(Sbk_QAbstractProxyModelFunc_mapToSource), METH_O},
    {"mimeData", reinterpret_cast<PyCFunction>(Sbk_QAbstractProxyModelFunc_mimeData), METH_O},
    {"mimeTypes", reinterpret_cast<PyCFunction>(Sbk_QAbstractProxyModelFunc_mimeTypes), METH_NOARGS},
    {"resetInternalData", reinterpret_cast<PyCFunction>(Sbk_QAbstractProxyModelFunc_resetInternalData), METH_NOARGS},
    {"revert", reinterpret_cast<PyCFunction>(Sbk_QAbstractProxyModelFunc_revert), METH_NOARGS},
    {"setData", reinterpret_cast<PyCFunction>(Sbk_QAbstractProxyModelFunc_setData), METH_VARARGS|METH_KEYWORDS},
    {"setHeaderData", reinterpret_cast<PyCFunction>(Sbk_QAbstractProxyModelFunc_setHeaderData), METH_VARARGS|METH_KEYWORDS},
    {"setItemData", reinterpret_cast<PyCFunction>(Sbk_QAbstractProxyModelFunc_setItemData), METH_VARARGS},
    {"setSourceModel", reinterpret_cast<PyCFunction>(Sbk_QAbstractProxyModelFunc_setSourceModel), METH_O},
    {"sibling", reinterpret_cast<PyCFunction>(Sbk_QAbstractProxyModelFunc_sibling), METH_VARARGS},
    {"sort", reinterpret_cast<PyCFunction>(Sbk_QAbstractProxyModelFunc_sort), METH_VARARGS|METH_KEYWORDS},
    {"sourceModel", reinterpret_cast<PyCFunction>(Sbk_QAbstractProxyModelFunc_sourceModel), METH_NOARGS},
    {"span", reinterpret_cast<PyCFunction>(Sbk_QAbstractProxyModelFunc_span), METH_O},
    {"submit", reinterpret_cast<PyCFunction>(Sbk_QAbstractProxyModelFunc_submit), METH_NOARGS},
    {"supportedDragActions", reinterpret_cast<PyCFunction>(Sbk_QAbstractProxyModelFunc_supportedDragActions), METH_NOARGS},
    {"supportedDropActions", reinterpret_cast<PyCFunction>(Sbk_QAbstractProxyModelFunc_supportedDropActions), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QAbstractProxyModel_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QAbstractProxyModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QABSTRACTPROXYMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QAbstractProxyModelWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QAbstractProxyModel_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QAbstractProxyModel_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QAbstractProxyModel_Type = nullptr;
static SbkObjectType *Sbk_QAbstractProxyModel_TypeF(void)
{
    return _Sbk_QAbstractProxyModel_Type;
}

static PyType_Slot Sbk_QAbstractProxyModel_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QAbstractProxyModel_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QAbstractProxyModel_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QAbstractProxyModel_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QAbstractProxyModel_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QAbstractProxyModel_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QAbstractProxyModel_spec = {
    "2:PySide2.QtCore.QAbstractProxyModel",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QAbstractProxyModel_slots
};

} //extern "C"

static void *Sbk_QAbstractProxyModel_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
     if (qobject_cast<QAbstractProxyModel*>( reinterpret_cast< ::QAbstractProxyModel *>(cptr)))
        return cptr;
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QAbstractProxyModel_PythonToCpp_QAbstractProxyModel_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QAbstractProxyModel_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QAbstractProxyModel_PythonToCpp_QAbstractProxyModel_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QAbstractProxyModel_TypeF())))
        return QAbstractProxyModel_PythonToCpp_QAbstractProxyModel_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QAbstractProxyModel_PTR_CppToPython_QAbstractProxyModel(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QAbstractProxyModel *>(const_cast<void *>(cppIn)), Sbk_QAbstractProxyModel_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QAbstractProxyModel_SignatureStrings[] = {
    "PySide2.QtCore.QAbstractProxyModel(self,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtCore.QAbstractProxyModel.buddy(self,index:PySide2.QtCore.QModelIndex)->PySide2.QtCore.QModelIndex",
    "PySide2.QtCore.QAbstractProxyModel.canDropMimeData(self,data:PySide2.QtCore.QMimeData,action:PySide2.QtCore.Qt.DropAction,row:int,column:int,parent:PySide2.QtCore.QModelIndex)->bool",
    "PySide2.QtCore.QAbstractProxyModel.canFetchMore(self,parent:PySide2.QtCore.QModelIndex)->bool",
    "PySide2.QtCore.QAbstractProxyModel.data(self,proxyIndex:PySide2.QtCore.QModelIndex,role:int=Qt.DisplayRole)->QVariant",
    "PySide2.QtCore.QAbstractProxyModel.dropMimeData(self,data:PySide2.QtCore.QMimeData,action:PySide2.QtCore.Qt.DropAction,row:int,column:int,parent:PySide2.QtCore.QModelIndex)->bool",
    "PySide2.QtCore.QAbstractProxyModel.fetchMore(self,parent:PySide2.QtCore.QModelIndex)",
    "PySide2.QtCore.QAbstractProxyModel.flags(self,index:PySide2.QtCore.QModelIndex)->PySide2.QtCore.Qt.ItemFlags",
    "PySide2.QtCore.QAbstractProxyModel.hasChildren(self,parent:PySide2.QtCore.QModelIndex=QModelIndex())->bool",
    "PySide2.QtCore.QAbstractProxyModel.headerData(self,section:int,orientation:PySide2.QtCore.Qt.Orientation,role:int=Qt.DisplayRole)->QVariant",
    "PySide2.QtCore.QAbstractProxyModel.itemData(self,index:PySide2.QtCore.QModelIndex)->QMap[int, QVariant]",
    "PySide2.QtCore.QAbstractProxyModel.mapFromSource(self,sourceIndex:PySide2.QtCore.QModelIndex)->PySide2.QtCore.QModelIndex",
    "PySide2.QtCore.QAbstractProxyModel.mapSelectionFromSource(self,selection:PySide2.QtCore.QItemSelection)->PySide2.QtCore.QItemSelection",
    "PySide2.QtCore.QAbstractProxyModel.mapSelectionToSource(self,selection:PySide2.QtCore.QItemSelection)->PySide2.QtCore.QItemSelection",
    "PySide2.QtCore.QAbstractProxyModel.mapToSource(self,proxyIndex:PySide2.QtCore.QModelIndex)->PySide2.QtCore.QModelIndex",
    "PySide2.QtCore.QAbstractProxyModel.mimeData(self,indexes:QModelIndexList)->PySide2.QtCore.QMimeData",
    "PySide2.QtCore.QAbstractProxyModel.mimeTypes(self)->QStringList",
    "PySide2.QtCore.QAbstractProxyModel.resetInternalData(self)",
    "PySide2.QtCore.QAbstractProxyModel.revert(self)",
    "PySide2.QtCore.QAbstractProxyModel.setData(self,index:PySide2.QtCore.QModelIndex,value:QVariant,role:int=Qt.EditRole)->bool",
    "PySide2.QtCore.QAbstractProxyModel.setHeaderData(self,section:int,orientation:PySide2.QtCore.Qt.Orientation,value:QVariant,role:int=Qt.EditRole)->bool",
    "PySide2.QtCore.QAbstractProxyModel.setItemData(self,index:PySide2.QtCore.QModelIndex,roles:QMap[int, QVariant])->bool",
    "PySide2.QtCore.QAbstractProxyModel.setSourceModel(self,sourceModel:PySide2.QtCore.QAbstractItemModel)",
    "PySide2.QtCore.QAbstractProxyModel.sibling(self,row:int,column:int,idx:PySide2.QtCore.QModelIndex)->PySide2.QtCore.QModelIndex",
    "PySide2.QtCore.QAbstractProxyModel.sort(self,column:int,order:PySide2.QtCore.Qt.SortOrder=Qt.AscendingOrder)",
    "PySide2.QtCore.QAbstractProxyModel.sourceModel(self)->PySide2.QtCore.QAbstractItemModel",
    "PySide2.QtCore.QAbstractProxyModel.span(self,index:PySide2.QtCore.QModelIndex)->PySide2.QtCore.QSize",
    "PySide2.QtCore.QAbstractProxyModel.submit(self)->bool",
    "PySide2.QtCore.QAbstractProxyModel.supportedDragActions(self)->PySide2.QtCore.Qt.DropActions",
    "PySide2.QtCore.QAbstractProxyModel.supportedDropActions(self)->PySide2.QtCore.Qt.DropActions",
    nullptr}; // Sentinel

void init_QAbstractProxyModel(PyObject *module)
{
    _Sbk_QAbstractProxyModel_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QAbstractProxyModel",
        "QAbstractProxyModel*",
        &Sbk_QAbstractProxyModel_spec,
        &Shiboken::callCppDestructor< ::QAbstractProxyModel >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTITEMMODEL_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QAbstractProxyModel_Type);
    InitSignatureStrings(pyType, QAbstractProxyModel_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QAbstractProxyModel_Type), Sbk_QAbstractProxyModel_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QABSTRACTPROXYMODEL_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QAbstractProxyModel_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QAbstractProxyModel_TypeF(),
        QAbstractProxyModel_PythonToCpp_QAbstractProxyModel_PTR,
        is_QAbstractProxyModel_PythonToCpp_QAbstractProxyModel_PTR_Convertible,
        QAbstractProxyModel_PTR_CppToPython_QAbstractProxyModel);

    Shiboken::Conversions::registerConverterName(converter, "QAbstractProxyModel");
    Shiboken::Conversions::registerConverterName(converter, "QAbstractProxyModel*");
    Shiboken::Conversions::registerConverterName(converter, "QAbstractProxyModel&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAbstractProxyModel).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAbstractProxyModelWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QAbstractProxyModel_TypeF(), &Sbk_QAbstractProxyModel_typeDiscovery);

    PySide::Signal::registerSignals(Sbk_QAbstractProxyModel_TypeF(), &::QAbstractProxyModel::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QAbstractProxyModel_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QAbstractProxyModel_TypeF(), &::QAbstractProxyModel::staticMetaObject, sizeof(QAbstractProxyModelWrapper));
}
