/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qcborerror_wrapper.h"

// inner classes

// Extra includes
#include <qobject.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QCborError_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QCborError >()))
        return -1;

    ::QCborError *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborError.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QCborError", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QCborError::QCborError()
    // 1: QCborError::QCborError(QCborError)
    if (numArgs == 0) {
        overloadId = 0; // QCborError()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORERROR_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QCborError(QCborError)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCborError_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QCborError()
        {

            if (!PyErr_Occurred()) {
                // QCborError()
                cptr = new ::QCborError();
            }
            break;
        }
        case 1: // QCborError(const QCborError & QCborError)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QCborError cppArg0_local;
            ::QCborError *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORERROR_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QCborError(QCborError)
                cptr = new ::QCborError(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QCborError >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QCborError_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QCborError_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QCborErrorFunc_toString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborError.toString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toString()const
            QString cppResult = const_cast<const ::QCborError *>(cppSelf)->toString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborError___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QCborError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORERROR_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QCborError_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QCborError_methods[] = {
    {"toString", reinterpret_cast<PyCFunction>(Sbk_QCborErrorFunc_toString), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QCborError___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QCborError_get_c(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QCborError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ::QCborError::Code cppOut_local = cppSelf->c;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QCBORERROR_CODE_IDX])->converter, &cppOut_local);
    return pyOut;
}
static int Sbk_QCborError_set_c(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QCborError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'c' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QCBORERROR_CODE_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'c', 'Code' or convertible type expected");
        return -1;
    }

    ::QCborError::Code cppOut_local = cppSelf->c;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->c = cppOut_local;

    return 0;
}

// Getters and Setters for QCborError
static PyGetSetDef Sbk_QCborError_getsetlist[] = {
    {const_cast<char *>("c"), Sbk_QCborError_get_c, Sbk_QCborError_set_c},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QCborError_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QCborError_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QCborError_Type = nullptr;
static SbkObjectType *Sbk_QCborError_TypeF(void)
{
    return _Sbk_QCborError_Type;
}

static PyType_Slot Sbk_QCborError_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QCborError_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QCborError_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QCborError_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QCborError_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QCborError_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QCborError_spec = {
    "2:PySide2.QtCore.QCborError",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QCborError_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QCborError_Code_PythonToCpp_QCborError_Code(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCborError::Code *>(cppOut) =
        static_cast<::QCborError::Code>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QCborError_Code_PythonToCpp_QCborError_Code_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QCBORERROR_CODE_IDX]))
        return QCborError_Code_PythonToCpp_QCborError_Code;
    return {};
}
static PyObject *QCborError_Code_CppToPython_QCborError_Code(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QCborError::Code *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QCBORERROR_CODE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QCborError_PythonToCpp_QCborError_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QCborError_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QCborError_PythonToCpp_QCborError_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QCborError_TypeF())))
        return QCborError_PythonToCpp_QCborError_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QCborError_PTR_CppToPython_QCborError(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QCborError *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QCborError_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QCborError_COPY_CppToPython_QCborError(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QCborError_TypeF(), new ::QCborError(*reinterpret_cast<const ::QCborError *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QCborError_PythonToCpp_QCborError_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCborError *>(cppOut) = *reinterpret_cast< ::QCborError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORERROR_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QCborError_PythonToCpp_QCborError_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QCborError_TypeF())))
        return QCborError_PythonToCpp_QCborError_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QCborError_SignatureStrings[] = {
    "1:PySide2.QtCore.QCborError(self)",
    "0:PySide2.QtCore.QCborError(self,QCborError:PySide2.QtCore.QCborError)",
    "PySide2.QtCore.QCborError.toString(self)->QString",
    "PySide2.QtCore.QCborError.__copy__()",
    nullptr}; // Sentinel

void init_QCborError(PyObject *module)
{
    _Sbk_QCborError_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QCborError",
        "QCborError",
        &Sbk_QCborError_spec,
        &Shiboken::callCppDestructor< ::QCborError >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QCborError_Type);
    InitSignatureStrings(pyType, QCborError_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QCborError_Type), Sbk_QCborError_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QCBORERROR_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QCborError_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QCborError_TypeF(),
        QCborError_PythonToCpp_QCborError_PTR,
        is_QCborError_PythonToCpp_QCborError_PTR_Convertible,
        QCborError_PTR_CppToPython_QCborError,
        QCborError_COPY_CppToPython_QCborError);

    Shiboken::Conversions::registerConverterName(converter, "QCborError");
    Shiboken::Conversions::registerConverterName(converter, "QCborError*");
    Shiboken::Conversions::registerConverterName(converter, "QCborError&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QCborError).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QCborError_PythonToCpp_QCborError_COPY,
        is_QCborError_PythonToCpp_QCborError_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'Code'.
    SbkPySide2_QtCoreTypes[SBK_QCBORERROR_CODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QCborError_TypeF(),
        "Code",
        "2:PySide2.QtCore.QCborError.Code",
        "QCborError::Code");
    if (!SbkPySide2_QtCoreTypes[SBK_QCBORERROR_CODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORERROR_CODE_IDX],
        Sbk_QCborError_TypeF(), "UnknownError", (long) QCborError::Code::UnknownError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORERROR_CODE_IDX],
        Sbk_QCborError_TypeF(), "AdvancePastEnd", (long) QCborError::Code::AdvancePastEnd))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORERROR_CODE_IDX],
        Sbk_QCborError_TypeF(), "InputOutputError", (long) QCborError::Code::InputOutputError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORERROR_CODE_IDX],
        Sbk_QCborError_TypeF(), "GarbageAtEnd", (long) QCborError::Code::GarbageAtEnd))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORERROR_CODE_IDX],
        Sbk_QCborError_TypeF(), "EndOfFile", (long) QCborError::Code::EndOfFile))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORERROR_CODE_IDX],
        Sbk_QCborError_TypeF(), "UnexpectedBreak", (long) QCborError::Code::UnexpectedBreak))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORERROR_CODE_IDX],
        Sbk_QCborError_TypeF(), "UnknownType", (long) QCborError::Code::UnknownType))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORERROR_CODE_IDX],
        Sbk_QCborError_TypeF(), "IllegalType", (long) QCborError::Code::IllegalType))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORERROR_CODE_IDX],
        Sbk_QCborError_TypeF(), "IllegalNumber", (long) QCborError::Code::IllegalNumber))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORERROR_CODE_IDX],
        Sbk_QCborError_TypeF(), "IllegalSimpleType", (long) QCborError::Code::IllegalSimpleType))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORERROR_CODE_IDX],
        Sbk_QCborError_TypeF(), "InvalidUtf8String", (long) QCborError::Code::InvalidUtf8String))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORERROR_CODE_IDX],
        Sbk_QCborError_TypeF(), "DataTooLarge", (long) QCborError::Code::DataTooLarge))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORERROR_CODE_IDX],
        Sbk_QCborError_TypeF(), "NestingTooDeep", (long) QCborError::Code::NestingTooDeep))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORERROR_CODE_IDX],
        Sbk_QCborError_TypeF(), "UnsupportedType", (long) QCborError::Code::UnsupportedType))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORERROR_CODE_IDX],
        Sbk_QCborError_TypeF(), "NoError", (long) QCborError::Code::NoError))
        return;
    // Register converter for enum 'QCborError::Code'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QCBORERROR_CODE_IDX],
            QCborError_Code_CppToPython_QCborError_Code);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QCborError_Code_PythonToCpp_QCborError_Code,
            is_QCborError_Code_PythonToCpp_QCborError_Code_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QCBORERROR_CODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QCborError::Code");
        Shiboken::Conversions::registerConverterName(converter, "Code");
    }
    // End of 'Code' enum.

    qRegisterMetaType< ::QCborError >("QCborError");
    qRegisterMetaType< ::QCborError::Code >("QCborError::Code");
}
