/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qcborstreamreader_wrapper.h"

// inner classes

// Extra includes
#include <qbytearray.h>
#include <qcborcommon.h>
#include <qiodevice.h>
#include <qobject.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QCborStreamReader_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QCborStreamReader >()))
        return -1;

    ::QCborStreamReader *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QCborStreamReader", 0, 2, &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QCborStreamReader::QCborStreamReader()
    // 1: QCborStreamReader::QCborStreamReader(QIODevice*)
    // 2: QCborStreamReader::QCborStreamReader(QByteArray)
    // 3: QCborStreamReader::QCborStreamReader(const char*,long long)
    // 4: QCborStreamReader::QCborStreamReader(const quint8*,long long)
    if (numArgs == 0) {
        overloadId = 0; // QCborStreamReader()
    } else if (numArgs == 2
        && SbkChar_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint8>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<long long>(), (pyArgs[1])))) {
        overloadId = 4; // QCborStreamReader(const quint8*,long long)
    } else if (numArgs == 2
        && Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<long long>(), (pyArgs[1])))) {
        overloadId = 3; // QCborStreamReader(const char*,long long)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QCborStreamReader(QByteArray)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QCborStreamReader(QIODevice*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCborStreamReader_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QCborStreamReader()
        {

            if (!PyErr_Occurred()) {
                // QCborStreamReader()
                cptr = new ::QCborStreamReader();
            }
            break;
        }
        case 1: // QCborStreamReader(QIODevice * device)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QIODevice *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QCborStreamReader(QIODevice*)
                cptr = new ::QCborStreamReader(cppArg0);
            }
            break;
        }
        case 2: // QCborStreamReader(const QByteArray & data)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QCborStreamReader(QByteArray)
                cptr = new ::QCborStreamReader(*cppArg0);
            }
            break;
        }
        case 3: // QCborStreamReader(const char * data, long long len)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            long long cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QCborStreamReader(const char*,long long)
                cptr = new ::QCborStreamReader(cppArg0, cppArg1);
            }
            break;
        }
        case 4: // QCborStreamReader(const quint8 * data, long long len)
        {
            quint8 *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            long long cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QCborStreamReader(const quint8*,long long)
                cptr = new ::QCborStreamReader(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QCborStreamReader >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QCborStreamReader_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QCborStreamReader_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QCborStreamReaderFunc_addData(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.addData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "addData", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QCborStreamReader::addData(QByteArray)
    // 1: QCborStreamReader::addData(const char*,long long)
    // 2: QCborStreamReader::addData(const quint8*,long long)
    if (numArgs == 2
        && SbkChar_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint8>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<long long>(), (pyArgs[1])))) {
        overloadId = 2; // addData(const quint8*,long long)
    } else if (numArgs == 2
        && Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<long long>(), (pyArgs[1])))) {
        overloadId = 1; // addData(const char*,long long)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        overloadId = 0; // addData(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCborStreamReaderFunc_addData_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // addData(const QByteArray & data)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // addData(QByteArray)
                cppSelf->addData(*cppArg0);
            }
            break;
        }
        case 1: // addData(const char * data, long long len)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            long long cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // addData(const char*,long long)
                cppSelf->addData(cppArg0, cppArg1);
            }
            break;
        }
        case 2: // addData(const quint8 * data, long long len)
        {
            quint8 *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            long long cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // addData(const quint8*,long long)
                cppSelf->addData(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCborStreamReaderFunc_addData_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCborStreamReaderFunc_clear(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.clear";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clear()
            cppSelf->clear();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QCborStreamReaderFunc_containerDepth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.containerDepth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // containerDepth()const
            int cppResult = const_cast<const ::QCborStreamReader *>(cppSelf)->containerDepth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborStreamReaderFunc_currentOffset(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.currentOffset";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentOffset()const
            qint64 cppResult = const_cast<const ::QCborStreamReader *>(cppSelf)->currentOffset();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborStreamReaderFunc_currentStringChunkSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.currentStringChunkSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentStringChunkSize()const
            long long cppResult = const_cast<const ::QCborStreamReader *>(cppSelf)->currentStringChunkSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<long long>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborStreamReaderFunc_device(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.device";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // device()const
            QIODevice * cppResult = const_cast<const ::QCborStreamReader *>(cppSelf)->device();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborStreamReaderFunc_enterContainer(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.enterContainer";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // enterContainer()
            bool cppResult = cppSelf->enterContainer();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborStreamReaderFunc_hasNext(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.hasNext";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasNext()const
            bool cppResult = const_cast<const ::QCborStreamReader *>(cppSelf)->hasNext();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborStreamReaderFunc_isArray(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.isArray";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isArray()const
            bool cppResult = const_cast<const ::QCborStreamReader *>(cppSelf)->isArray();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborStreamReaderFunc_isBool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.isBool";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isBool()const
            bool cppResult = const_cast<const ::QCborStreamReader *>(cppSelf)->isBool();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborStreamReaderFunc_isByteArray(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.isByteArray";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isByteArray()const
            bool cppResult = const_cast<const ::QCborStreamReader *>(cppSelf)->isByteArray();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborStreamReaderFunc_isContainer(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.isContainer";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isContainer()const
            bool cppResult = const_cast<const ::QCborStreamReader *>(cppSelf)->isContainer();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborStreamReaderFunc_isDouble(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.isDouble";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isDouble()const
            bool cppResult = const_cast<const ::QCborStreamReader *>(cppSelf)->isDouble();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborStreamReaderFunc_isFalse(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.isFalse";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isFalse()const
            bool cppResult = const_cast<const ::QCborStreamReader *>(cppSelf)->isFalse();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborStreamReaderFunc_isFloat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.isFloat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isFloat()const
            bool cppResult = const_cast<const ::QCborStreamReader *>(cppSelf)->isFloat();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborStreamReaderFunc_isFloat16(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.isFloat16";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isFloat16()const
            bool cppResult = const_cast<const ::QCborStreamReader *>(cppSelf)->isFloat16();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborStreamReaderFunc_isInteger(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.isInteger";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isInteger()const
            bool cppResult = const_cast<const ::QCborStreamReader *>(cppSelf)->isInteger();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborStreamReaderFunc_isInvalid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.isInvalid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isInvalid()const
            bool cppResult = const_cast<const ::QCborStreamReader *>(cppSelf)->isInvalid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborStreamReaderFunc_isLengthKnown(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.isLengthKnown";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isLengthKnown()const
            bool cppResult = const_cast<const ::QCborStreamReader *>(cppSelf)->isLengthKnown();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborStreamReaderFunc_isMap(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.isMap";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isMap()const
            bool cppResult = const_cast<const ::QCborStreamReader *>(cppSelf)->isMap();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborStreamReaderFunc_isNegativeInteger(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.isNegativeInteger";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNegativeInteger()const
            bool cppResult = const_cast<const ::QCborStreamReader *>(cppSelf)->isNegativeInteger();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborStreamReaderFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::QCborStreamReader *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborStreamReaderFunc_isSimpleType(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.isSimpleType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "isSimpleType", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QCborStreamReader::isSimpleType()const
    // 1: QCborStreamReader::isSimpleType(QCborSimpleType)const
    if (numArgs == 0) {
        overloadId = 0; // isSimpleType()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QCBORSIMPLETYPE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // isSimpleType(QCborSimpleType)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCborStreamReaderFunc_isSimpleType_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // isSimpleType() const
        {

            if (!PyErr_Occurred()) {
                // isSimpleType()const
                bool cppResult = const_cast<const ::QCborStreamReader *>(cppSelf)->isSimpleType();
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // isSimpleType(QCborSimpleType st) const
        {
            ::QCborSimpleType cppArg0 = static_cast< ::QCborSimpleType>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // isSimpleType(QCborSimpleType)const
                bool cppResult = const_cast<const ::QCborStreamReader *>(cppSelf)->isSimpleType(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCborStreamReaderFunc_isSimpleType_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCborStreamReaderFunc_isString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.isString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isString()const
            bool cppResult = const_cast<const ::QCborStreamReader *>(cppSelf)->isString();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborStreamReaderFunc_isTag(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.isTag";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isTag()const
            bool cppResult = const_cast<const ::QCborStreamReader *>(cppSelf)->isTag();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborStreamReaderFunc_isTrue(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.isTrue";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isTrue()const
            bool cppResult = const_cast<const ::QCborStreamReader *>(cppSelf)->isTrue();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborStreamReaderFunc_isUndefined(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.isUndefined";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isUndefined()const
            bool cppResult = const_cast<const ::QCborStreamReader *>(cppSelf)->isUndefined();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborStreamReaderFunc_isUnsignedInteger(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.isUnsignedInteger";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isUnsignedInteger()const
            bool cppResult = const_cast<const ::QCborStreamReader *>(cppSelf)->isUnsignedInteger();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborStreamReaderFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QCborStreamReader *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborStreamReaderFunc_lastError(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.lastError";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lastError()
            QCborError cppResult = cppSelf->lastError();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORERROR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborStreamReaderFunc_leaveContainer(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.leaveContainer";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // leaveContainer()
            bool cppResult = cppSelf->leaveContainer();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborStreamReaderFunc_length(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.length";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // length()const
            quint64 cppResult = const_cast<const ::QCborStreamReader *>(cppSelf)->length();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborStreamReaderFunc_next(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.next";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QCborStreamReaderFunc_next_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:next", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QCborStreamReader::next(int)
    if (numArgs == 0) {
        overloadId = 0; // next(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // next(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCborStreamReaderFunc_next_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_maxRecursion = Shiboken::String::createStaticString("maxRecursion");
            if (PyDict_Contains(kwds, key_maxRecursion)) {
                value = PyDict_GetItem(kwds, key_maxRecursion);
                if (value && pyArgs[0]) {
                    errInfo = key_maxRecursion;
                    Py_INCREF(errInfo);
                    goto Sbk_QCborStreamReaderFunc_next_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QCborStreamReaderFunc_next_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_maxRecursion);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QCborStreamReaderFunc_next_TypeError;
            }
        }
        int cppArg0 = 10000;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // next(int)
            bool cppResult = cppSelf->next(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCborStreamReaderFunc_next_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCborStreamReaderFunc_parentContainerType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.parentContainerType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // parentContainerType()const
            QCborStreamReader::Type cppResult = const_cast<const ::QCborStreamReader *>(cppSelf)->parentContainerType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_TYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborStreamReaderFunc_readByteArray(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.readByteArray";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // readByteArray()
            QCborStringResultByteArray cppResult = cppSelf->readByteArray();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORSTRINGRESULTBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborStreamReaderFunc_readString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.readString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // readString()
            QCborStringResultString cppResult = cppSelf->readString();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORSTRINGRESULTSTRING_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborStreamReaderFunc_reparse(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.reparse";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // reparse()
            cppSelf->reparse();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QCborStreamReaderFunc_reset(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.reset";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // reset()
            cppSelf->reset();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QCborStreamReaderFunc_setDevice(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.setDevice";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCborStreamReader::setDevice(QIODevice*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArg)))) {
        overloadId = 0; // setDevice(QIODevice*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCborStreamReaderFunc_setDevice_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QIODevice *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDevice(QIODevice*)
            cppSelf->setDevice(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCborStreamReaderFunc_setDevice_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCborStreamReaderFunc_toBool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.toBool";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toBool()const
            bool cppResult = const_cast<const ::QCborStreamReader *>(cppSelf)->toBool();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborStreamReaderFunc_toDouble(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.toDouble";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toDouble()const
            double cppResult = const_cast<const ::QCborStreamReader *>(cppSelf)->toDouble();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<double>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborStreamReaderFunc_toFloat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.toFloat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toFloat()const
            float cppResult = const_cast<const ::QCborStreamReader *>(cppSelf)->toFloat();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborStreamReaderFunc_toInteger(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.toInteger";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toInteger()const
            qint64 cppResult = const_cast<const ::QCborStreamReader *>(cppSelf)->toInteger();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborStreamReaderFunc_toSimpleType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.toSimpleType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toSimpleType()const
            QCborSimpleType cppResult = const_cast<const ::QCborStreamReader *>(cppSelf)->toSimpleType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QCBORSIMPLETYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborStreamReaderFunc_toUnsignedInteger(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.toUnsignedInteger";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toUnsignedInteger()const
            quint64 cppResult = const_cast<const ::QCborStreamReader *>(cppSelf)->toUnsignedInteger();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborStreamReaderFunc_type(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborStreamReader.type";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // type()const
            QCborStreamReader::Type cppResult = const_cast<const ::QCborStreamReader *>(cppSelf)->type();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_TYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QCborStreamReader_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QCborStreamReader_methods[] = {
    {"addData", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_addData), METH_VARARGS},
    {"clear", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_clear), METH_NOARGS},
    {"containerDepth", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_containerDepth), METH_NOARGS},
    {"currentOffset", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_currentOffset), METH_NOARGS},
    {"currentStringChunkSize", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_currentStringChunkSize), METH_NOARGS},
    {"device", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_device), METH_NOARGS},
    {"enterContainer", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_enterContainer), METH_NOARGS},
    {"hasNext", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_hasNext), METH_NOARGS},
    {"isArray", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_isArray), METH_NOARGS},
    {"isBool", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_isBool), METH_NOARGS},
    {"isByteArray", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_isByteArray), METH_NOARGS},
    {"isContainer", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_isContainer), METH_NOARGS},
    {"isDouble", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_isDouble), METH_NOARGS},
    {"isFalse", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_isFalse), METH_NOARGS},
    {"isFloat", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_isFloat), METH_NOARGS},
    {"isFloat16", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_isFloat16), METH_NOARGS},
    {"isInteger", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_isInteger), METH_NOARGS},
    {"isInvalid", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_isInvalid), METH_NOARGS},
    {"isLengthKnown", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_isLengthKnown), METH_NOARGS},
    {"isMap", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_isMap), METH_NOARGS},
    {"isNegativeInteger", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_isNegativeInteger), METH_NOARGS},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_isNull), METH_NOARGS},
    {"isSimpleType", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_isSimpleType), METH_VARARGS},
    {"isString", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_isString), METH_NOARGS},
    {"isTag", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_isTag), METH_NOARGS},
    {"isTrue", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_isTrue), METH_NOARGS},
    {"isUndefined", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_isUndefined), METH_NOARGS},
    {"isUnsignedInteger", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_isUnsignedInteger), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_isValid), METH_NOARGS},
    {"lastError", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_lastError), METH_NOARGS},
    {"leaveContainer", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_leaveContainer), METH_NOARGS},
    {"length", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_length), METH_NOARGS},
    {"next", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_next), METH_VARARGS|METH_KEYWORDS},
    {"parentContainerType", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_parentContainerType), METH_NOARGS},
    {"readByteArray", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_readByteArray), METH_NOARGS},
    {"readString", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_readString), METH_NOARGS},
    {"reparse", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_reparse), METH_NOARGS},
    {"reset", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_reset), METH_NOARGS},
    {"setDevice", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_setDevice), METH_O},
    {"toBool", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_toBool), METH_NOARGS},
    {"toDouble", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_toDouble), METH_NOARGS},
    {"toFloat", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_toFloat), METH_NOARGS},
    {"toInteger", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_toInteger), METH_NOARGS},
    {"toSimpleType", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_toSimpleType), METH_NOARGS},
    {"toUnsignedInteger", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_toUnsignedInteger), METH_NOARGS},
    {"type", reinterpret_cast<PyCFunction>(Sbk_QCborStreamReaderFunc_type), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QCborStreamReader___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QCborStreamReader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

} // extern "C"

static int Sbk_QCborStreamReader_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QCborStreamReader_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QCborStreamReader_Type = nullptr;
static SbkObjectType *Sbk_QCborStreamReader_TypeF(void)
{
    return _Sbk_QCborStreamReader_Type;
}

static PyType_Slot Sbk_QCborStreamReader_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QCborStreamReader_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QCborStreamReader_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QCborStreamReader_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QCborStreamReader_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QCborStreamReader___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QCborStreamReader___nb_bool},
#endif
    {0, nullptr}
};
static PyType_Spec Sbk_QCborStreamReader_spec = {
    "2:PySide2.QtCore.QCborStreamReader",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QCborStreamReader_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QCborStreamReader_Type_PythonToCpp_QCborStreamReader_Type(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCborStreamReader::Type *>(cppOut) =
        static_cast<::QCborStreamReader::Type>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QCborStreamReader_Type_PythonToCpp_QCborStreamReader_Type_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_TYPE_IDX]))
        return QCborStreamReader_Type_PythonToCpp_QCborStreamReader_Type;
    return {};
}
static PyObject *QCborStreamReader_Type_CppToPython_QCborStreamReader_Type(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QCborStreamReader::Type *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_TYPE_IDX], castCppIn);

}

static void QCborStreamReader_StringResultCode_PythonToCpp_QCborStreamReader_StringResultCode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCborStreamReader::StringResultCode *>(cppOut) =
        static_cast<::QCborStreamReader::StringResultCode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QCborStreamReader_StringResultCode_PythonToCpp_QCborStreamReader_StringResultCode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_STRINGRESULTCODE_IDX]))
        return QCborStreamReader_StringResultCode_PythonToCpp_QCborStreamReader_StringResultCode;
    return {};
}
static PyObject *QCborStreamReader_StringResultCode_CppToPython_QCborStreamReader_StringResultCode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QCborStreamReader::StringResultCode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_STRINGRESULTCODE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QCborStreamReader_PythonToCpp_QCborStreamReader_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QCborStreamReader_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QCborStreamReader_PythonToCpp_QCborStreamReader_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QCborStreamReader_TypeF())))
        return QCborStreamReader_PythonToCpp_QCborStreamReader_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QCborStreamReader_PTR_CppToPython_QCborStreamReader(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QCborStreamReader *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QCborStreamReader_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QCborStreamReader_SignatureStrings[] = {
    "4:PySide2.QtCore.QCborStreamReader(self)",
    "3:PySide2.QtCore.QCborStreamReader(self,device:PySide2.QtCore.QIODevice)",
    "2:PySide2.QtCore.QCborStreamReader(self,data:PySide2.QtCore.QByteArray)",
    "1:PySide2.QtCore.QCborStreamReader(self,data:char*,len:long long)",
    "0:PySide2.QtCore.QCborStreamReader(self,data:quint8*,len:long long)",
    "2:PySide2.QtCore.QCborStreamReader.addData(self,data:PySide2.QtCore.QByteArray)",
    "1:PySide2.QtCore.QCborStreamReader.addData(self,data:char*,len:long long)",
    "0:PySide2.QtCore.QCborStreamReader.addData(self,data:quint8*,len:long long)",
    "PySide2.QtCore.QCborStreamReader.clear(self)",
    "PySide2.QtCore.QCborStreamReader.containerDepth(self)->int",
    "PySide2.QtCore.QCborStreamReader.currentOffset(self)->qint64",
    "PySide2.QtCore.QCborStreamReader.currentStringChunkSize(self)->long long",
    "PySide2.QtCore.QCborStreamReader.device(self)->PySide2.QtCore.QIODevice",
    "PySide2.QtCore.QCborStreamReader.enterContainer(self)->bool",
    "PySide2.QtCore.QCborStreamReader.hasNext(self)->bool",
    "PySide2.QtCore.QCborStreamReader.isArray(self)->bool",
    "PySide2.QtCore.QCborStreamReader.isBool(self)->bool",
    "PySide2.QtCore.QCborStreamReader.isByteArray(self)->bool",
    "PySide2.QtCore.QCborStreamReader.isContainer(self)->bool",
    "PySide2.QtCore.QCborStreamReader.isDouble(self)->bool",
    "PySide2.QtCore.QCborStreamReader.isFalse(self)->bool",
    "PySide2.QtCore.QCborStreamReader.isFloat(self)->bool",
    "PySide2.QtCore.QCborStreamReader.isFloat16(self)->bool",
    "PySide2.QtCore.QCborStreamReader.isInteger(self)->bool",
    "PySide2.QtCore.QCborStreamReader.isInvalid(self)->bool",
    "PySide2.QtCore.QCborStreamReader.isLengthKnown(self)->bool",
    "PySide2.QtCore.QCborStreamReader.isMap(self)->bool",
    "PySide2.QtCore.QCborStreamReader.isNegativeInteger(self)->bool",
    "PySide2.QtCore.QCborStreamReader.isNull(self)->bool",
    "1:PySide2.QtCore.QCborStreamReader.isSimpleType(self)->bool",
    "0:PySide2.QtCore.QCborStreamReader.isSimpleType(self,st:PySide2.QtCore.QCborSimpleType)->bool",
    "PySide2.QtCore.QCborStreamReader.isString(self)->bool",
    "PySide2.QtCore.QCborStreamReader.isTag(self)->bool",
    "PySide2.QtCore.QCborStreamReader.isTrue(self)->bool",
    "PySide2.QtCore.QCborStreamReader.isUndefined(self)->bool",
    "PySide2.QtCore.QCborStreamReader.isUnsignedInteger(self)->bool",
    "PySide2.QtCore.QCborStreamReader.isValid(self)->bool",
    "PySide2.QtCore.QCborStreamReader.lastError(self)->PySide2.QtCore.QCborError",
    "PySide2.QtCore.QCborStreamReader.leaveContainer(self)->bool",
    "PySide2.QtCore.QCborStreamReader.length(self)->quint64",
    "PySide2.QtCore.QCborStreamReader.next(self,maxRecursion:int=10000)->bool",
    "PySide2.QtCore.QCborStreamReader.parentContainerType(self)->PySide2.QtCore.QCborStreamReader.Type",
    "PySide2.QtCore.QCborStreamReader.readByteArray(self)->PySide2.QtCore.QCborStringResultByteArray",
    "PySide2.QtCore.QCborStreamReader.readString(self)->PySide2.QtCore.QCborStringResultString",
    "PySide2.QtCore.QCborStreamReader.reparse(self)",
    "PySide2.QtCore.QCborStreamReader.reset(self)",
    "PySide2.QtCore.QCborStreamReader.setDevice(self,device:PySide2.QtCore.QIODevice)",
    "PySide2.QtCore.QCborStreamReader.toBool(self)->bool",
    "PySide2.QtCore.QCborStreamReader.toDouble(self)->double",
    "PySide2.QtCore.QCborStreamReader.toFloat(self)->float",
    "PySide2.QtCore.QCborStreamReader.toInteger(self)->qint64",
    "PySide2.QtCore.QCborStreamReader.toSimpleType(self)->PySide2.QtCore.QCborSimpleType",
    "PySide2.QtCore.QCborStreamReader.toUnsignedInteger(self)->quint64",
    "PySide2.QtCore.QCborStreamReader.type(self)->PySide2.QtCore.QCborStreamReader.Type",
    nullptr}; // Sentinel

void init_QCborStreamReader(PyObject *module)
{
    _Sbk_QCborStreamReader_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QCborStreamReader",
        "QCborStreamReader*",
        &Sbk_QCborStreamReader_spec,
        &Shiboken::callCppDestructor< ::QCborStreamReader >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QCborStreamReader_Type);
    InitSignatureStrings(pyType, QCborStreamReader_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QCborStreamReader_Type), Sbk_QCborStreamReader_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QCborStreamReader_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QCborStreamReader_TypeF(),
        QCborStreamReader_PythonToCpp_QCborStreamReader_PTR,
        is_QCborStreamReader_PythonToCpp_QCborStreamReader_PTR_Convertible,
        QCborStreamReader_PTR_CppToPython_QCborStreamReader);

    Shiboken::Conversions::registerConverterName(converter, "QCborStreamReader");
    Shiboken::Conversions::registerConverterName(converter, "QCborStreamReader*");
    Shiboken::Conversions::registerConverterName(converter, "QCborStreamReader&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QCborStreamReader).name());


    // Initialization of enums.

    // Initialization of enum 'Type'.
    SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_TYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QCborStreamReader_TypeF(),
        "Type",
        "2:PySide2.QtCore.QCborStreamReader.Type",
        "QCborStreamReader::Type");
    if (!SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_TYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_TYPE_IDX],
        Sbk_QCborStreamReader_TypeF(), "UnsignedInteger", (long) QCborStreamReader::Type::UnsignedInteger))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_TYPE_IDX],
        Sbk_QCborStreamReader_TypeF(), "NegativeInteger", (long) QCborStreamReader::Type::NegativeInteger))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_TYPE_IDX],
        Sbk_QCborStreamReader_TypeF(), "ByteString", (long) QCborStreamReader::Type::ByteString))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_TYPE_IDX],
        Sbk_QCborStreamReader_TypeF(), "ByteArray", (long) QCborStreamReader::Type::ByteArray))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_TYPE_IDX],
        Sbk_QCborStreamReader_TypeF(), "TextString", (long) QCborStreamReader::Type::TextString))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_TYPE_IDX],
        Sbk_QCborStreamReader_TypeF(), "String", (long) QCborStreamReader::Type::String))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_TYPE_IDX],
        Sbk_QCborStreamReader_TypeF(), "Array", (long) QCborStreamReader::Type::Array))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_TYPE_IDX],
        Sbk_QCborStreamReader_TypeF(), "Map", (long) QCborStreamReader::Type::Map))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_TYPE_IDX],
        Sbk_QCborStreamReader_TypeF(), "Tag", (long) QCborStreamReader::Type::Tag))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_TYPE_IDX],
        Sbk_QCborStreamReader_TypeF(), "SimpleType", (long) QCborStreamReader::Type::SimpleType))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_TYPE_IDX],
        Sbk_QCborStreamReader_TypeF(), "HalfFloat", (long) QCborStreamReader::Type::HalfFloat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_TYPE_IDX],
        Sbk_QCborStreamReader_TypeF(), "Float16", (long) QCborStreamReader::Type::Float16))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_TYPE_IDX],
        Sbk_QCborStreamReader_TypeF(), "Float", (long) QCborStreamReader::Type::Float))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_TYPE_IDX],
        Sbk_QCborStreamReader_TypeF(), "Double", (long) QCborStreamReader::Type::Double))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_TYPE_IDX],
        Sbk_QCborStreamReader_TypeF(), "Invalid", (long) QCborStreamReader::Type::Invalid))
        return;
    // Register converter for enum 'QCborStreamReader::Type'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_TYPE_IDX],
            QCborStreamReader_Type_CppToPython_QCborStreamReader_Type);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QCborStreamReader_Type_PythonToCpp_QCborStreamReader_Type,
            is_QCborStreamReader_Type_PythonToCpp_QCborStreamReader_Type_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_TYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QCborStreamReader::Type");
        Shiboken::Conversions::registerConverterName(converter, "Type");
    }
    // End of 'Type' enum.

    // Initialization of enum 'StringResultCode'.
    SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_STRINGRESULTCODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QCborStreamReader_TypeF(),
        "StringResultCode",
        "2:PySide2.QtCore.QCborStreamReader.StringResultCode",
        "QCborStreamReader::StringResultCode");
    if (!SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_STRINGRESULTCODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_STRINGRESULTCODE_IDX],
        Sbk_QCborStreamReader_TypeF(), "EndOfString", (long) QCborStreamReader::StringResultCode::EndOfString))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_STRINGRESULTCODE_IDX],
        Sbk_QCborStreamReader_TypeF(), "Ok", (long) QCborStreamReader::StringResultCode::Ok))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_STRINGRESULTCODE_IDX],
        Sbk_QCborStreamReader_TypeF(), "Error", (long) QCborStreamReader::StringResultCode::Error))
        return;
    // Register converter for enum 'QCborStreamReader::StringResultCode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_STRINGRESULTCODE_IDX],
            QCborStreamReader_StringResultCode_CppToPython_QCborStreamReader_StringResultCode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QCborStreamReader_StringResultCode_PythonToCpp_QCborStreamReader_StringResultCode,
            is_QCborStreamReader_StringResultCode_PythonToCpp_QCborStreamReader_StringResultCode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_STRINGRESULTCODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QCborStreamReader::StringResultCode");
        Shiboken::Conversions::registerConverterName(converter, "StringResultCode");
    }
    // End of 'StringResultCode' enum.

    qRegisterMetaType< ::QCborStreamReader::Type >("QCborStreamReader::Type");
    qRegisterMetaType< ::QCborStreamReader::StringResultCode >("QCborStreamReader::StringResultCode");
}
