/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qcborvalue_wrapper.h"

// inner classes

// Extra includes
#include <qbytearray.h>
#include <qcborarray.h>
#include <qcbormap.h>
#include <qcborstream.h>
#include <qcborvalue.h>
#include <qdatetime.h>
#include <qjsonvalue.h>
#include <qobject.h>
#include <qregularexpression.h>
#include <qurl.h>
#include <quuid.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QCborValue_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QCborValue >()))
        return -1;

    ::QCborValue *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborValue.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QCborValue_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:QCborValue", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QCborValue::QCborValue()
    // 1: QCborValue::QCborValue(QCborKnownTags,QCborValue)
    // 2: QCborValue::QCborValue(QCborSimpleType)
    // 3: QCborValue::QCborValue(QCborValue::Type)
    // 4: QCborValue::QCborValue(bool)
    // 5: QCborValue::QCborValue(QByteArray)
    // 6: QCborValue::QCborValue(QCborArray)
    // 7: QCborValue::QCborValue(QCborMap)
    // 8: QCborValue::QCborValue(QCborValue)
    // 9: QCborValue::QCborValue(QDateTime)
    // 10: QCborValue::QCborValue(QRegularExpression)
    // 11: QCborValue::QCborValue(QString)
    // 12: QCborValue::QCborValue(QUrl)
    // 13: QCborValue::QCborValue(QUuid)
    // 14: QCborValue::QCborValue(const char*)
    // 15: QCborValue::QCborValue(double)
    // 16: QCborValue::QCborValue(int)
    // 17: QCborValue::QCborValue(qint64)
    // 18: QCborValue::QCborValue(uint)
    if (numArgs == 0) {
        overloadId = 0; // QCborValue()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), (pyArgs[0])))) {
        overloadId = 9; // QCborValue(QDateTime)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORMAP_IDX]), (pyArgs[0])))) {
        overloadId = 7; // QCborValue(QCborMap)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORARRAY_IDX]), (pyArgs[0])))) {
        overloadId = 6; // QCborValue(QCborArray)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_TYPE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 3; // QCborValue(QCborValue::Type)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QCBORSIMPLETYPE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 2; // QCborValue(QCborSimpleType)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // QCborValue(QCborKnownTags,QCborValue)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX]), (pyArgs[1])))) {
            overloadId = 1; // QCborValue(QCborKnownTags,QCborValue)
        }
    } else if (numArgs == 1
        && PyFloat_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[0])))) {
        overloadId = 15; // QCborValue(double)
    } else if (numArgs == 1
        && Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))) {
        overloadId = 14; // QCborValue(const char*)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 11; // QCborValue(QString)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[0])))) {
        overloadId = 12; // QCborValue(QUrl)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_IDX]), (pyArgs[0])))) {
        overloadId = 10; // QCborValue(QRegularExpression)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        overloadId = 5; // QCborValue(QByteArray)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX]), (pyArgs[0])))) {
        overloadId = 13; // QCborValue(QUuid)
    } else if (numArgs == 1
        && PyBool_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 4; // QCborValue(bool)
    } else if (numArgs == 1
        && PyLong_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[0])))) {
        overloadId = 17; // QCborValue(qint64)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 16; // QCborValue(int)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))) {
        overloadId = 18; // QCborValue(uint)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX]), (pyArgs[0])))) {
        overloadId = 8; // QCborValue(QCborValue)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCborValue_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QCborValue()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QCborValue_Init_TypeError;
            }

            if (!PyErr_Occurred()) {
                // QCborValue()
                cptr = new ::QCborValue();
            }
            break;
        }
        case 1: // QCborValue(QCborKnownTags t_, const QCborValue & tv)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_tv = Shiboken::String::createStaticString("tv");
                if (PyDict_Contains(kwds, key_tv)) {
                    value = PyDict_GetItem(kwds, key_tv);
                    if (value && pyArgs[1]) {
                        errInfo = key_tv;
                        Py_INCREF(errInfo);
                        goto Sbk_QCborValue_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX]), (pyArgs[1]))))
                            goto Sbk_QCborValue_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_tv);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QCborValue_Init_TypeError;
                }
            }
            ::QCborKnownTags cppArg0{QCborKnownTags::DateTimeString};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QCborValue cppArg1_local = QCborValue();
            ::QCborValue *cppArg1 = &cppArg1_local;
            if (pythonToCpp[1]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);
            }

            if (!PyErr_Occurred()) {
                // QCborValue(QCborKnownTags,QCborValue)
                cptr = new ::QCborValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 2: // QCborValue(QCborSimpleType st)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QCborValue_Init_TypeError;
            }
            ::QCborSimpleType cppArg0 = static_cast< ::QCborSimpleType>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QCborValue(QCborSimpleType)
                cptr = new ::QCborValue(cppArg0);
            }
            break;
        }
        case 3: // QCborValue(QCborValue::Type t_)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QCborValue_Init_TypeError;
            }
            ::QCborValue::Type cppArg0{QCborValue::Integer};
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QCborValue(QCborValue::Type)
                cptr = new ::QCborValue(cppArg0);
            }
            break;
        }
        case 4: // QCborValue(bool b_)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QCborValue_Init_TypeError;
            }
            bool cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QCborValue(bool)
                cptr = new ::QCborValue(cppArg0);
            }
            break;
        }
        case 5: // QCborValue(const QByteArray & ba)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QCborValue_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QCborValue(QByteArray)
                cptr = new ::QCborValue(*cppArg0);
            }
            break;
        }
        case 6: // QCborValue(const QCborArray & a)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QCborValue_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QCborArray cppArg0_local;
            ::QCborArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QCborValue(QCborArray)
                cptr = new ::QCborValue(*cppArg0);
            }
            break;
        }
        case 7: // QCborValue(const QCborMap & m)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QCborValue_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QCborMap cppArg0_local;
            ::QCborMap *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORMAP_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QCborValue(QCborMap)
                cptr = new ::QCborValue(*cppArg0);
            }
            break;
        }
        case 8: // QCborValue(const QCborValue & other)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QCborValue_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QCborValue cppArg0_local;
            ::QCborValue *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QCborValue(QCborValue)
                cptr = new ::QCborValue(*cppArg0);
            }
            break;
        }
        case 9: // QCborValue(const QDateTime & dt)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QCborValue_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QDateTime cppArg0_local;
            ::QDateTime *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QCborValue(QDateTime)
                cptr = new ::QCborValue(*cppArg0);
            }
            break;
        }
        case 10: // QCborValue(const QRegularExpression & rx)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QCborValue_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QRegularExpression cppArg0_local;
            ::QRegularExpression *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QCborValue(QRegularExpression)
                cptr = new ::QCborValue(*cppArg0);
            }
            break;
        }
        case 11: // QCborValue(const QString & s)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QCborValue_Init_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QCborValue(QString)
                cptr = new ::QCborValue(cppArg0);
            }
            break;
        }
        case 12: // QCborValue(const QUrl & url)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QCborValue_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QUrl cppArg0_local;
            ::QUrl *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QCborValue(QUrl)
                cptr = new ::QCborValue(*cppArg0);
            }
            break;
        }
        case 13: // QCborValue(const QUuid & uuid)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QCborValue_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QUuid cppArg0_local;
            ::QUuid *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QCborValue(QUuid)
                cptr = new ::QCborValue(*cppArg0);
            }
            break;
        }
        case 14: // QCborValue(const char * s)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QCborValue_Init_TypeError;
            }
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QCborValue(const char*)
                cptr = new ::QCborValue(cppArg0);
            }
            break;
        }
        case 15: // QCborValue(double v)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QCborValue_Init_TypeError;
            }
            double cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QCborValue(double)
                cptr = new ::QCborValue(cppArg0);
            }
            break;
        }
        case 16: // QCborValue(int i)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QCborValue_Init_TypeError;
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QCborValue(int)
                cptr = new ::QCborValue(cppArg0);
            }
            break;
        }
        case 17: // QCborValue(qint64 i)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QCborValue_Init_TypeError;
            }
            qint64 cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QCborValue(qint64)
                cptr = new ::QCborValue(cppArg0);
            }
            break;
        }
        case 18: // QCborValue(unsigned int u)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QCborValue_Init_TypeError;
            }
            unsigned int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QCborValue(uint)
                cptr = new ::QCborValue(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QCborValue >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QCborValue_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QCborValue_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QCborValueFunc_compare(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborValue.compare";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCborValue::compare(QCborValue)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX]), (pyArg)))) {
        overloadId = 0; // compare(QCborValue)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCborValueFunc_compare_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QCborValue cppArg0_local;
        ::QCborValue *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // compare(QCborValue)const
            int cppResult = const_cast<const ::QCborValue *>(cppSelf)->compare(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCborValueFunc_compare_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCborValueFunc_fromCbor(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborValue.fromCbor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QCborValueFunc_fromCbor_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QCborValueFunc_fromCbor_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:fromCbor", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: static QCborValue::fromCbor(QCborStreamReader&)
    // 1: static QCborValue::fromCbor(QByteArray,QCborParserError*)
    // 2: static QCborValue::fromCbor(const char*,long long,QCborParserError*)
    // 3: static QCborValue::fromCbor(const quint8*,long long,QCborParserError*)
    if (numArgs >= 2
        && SbkChar_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint8>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<long long>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 3; // fromCbor(const quint8*,long long,QCborParserError*)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORPARSERERROR_IDX]), (pyArgs[2])))) {
            overloadId = 3; // fromCbor(const quint8*,long long,QCborParserError*)
        }
    } else if (numArgs >= 2
        && Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<long long>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 2; // fromCbor(const char*,long long,QCborParserError*)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORPARSERERROR_IDX]), (pyArgs[2])))) {
            overloadId = 2; // fromCbor(const char*,long long,QCborParserError*)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // fromCbor(QByteArray,QCborParserError*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORPARSERERROR_IDX]), (pyArgs[1])))) {
            overloadId = 1; // fromCbor(QByteArray,QCborParserError*)
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMREADER_IDX]), (pyArgs[0])))) {
        overloadId = 0; // fromCbor(QCborStreamReader&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCborValueFunc_fromCbor_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // fromCbor(QCborStreamReader & reader)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QCborValueFunc_fromCbor_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QCborStreamReader *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // fromCbor(QCborStreamReader&)
                QCborValue cppResult = ::QCborValue::fromCbor(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX]), &cppResult);
            }
            break;
        }
        case 1: // fromCbor(const QByteArray & ba, QCborParserError * error)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_error = Shiboken::String::createStaticString("error");
                if (PyDict_Contains(kwds, key_error)) {
                    value = PyDict_GetItem(kwds, key_error);
                    if (value && pyArgs[1]) {
                        errInfo = key_error;
                        Py_INCREF(errInfo);
                        goto Sbk_QCborValueFunc_fromCbor_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORPARSERERROR_IDX]), (pyArgs[1]))))
                            goto Sbk_QCborValueFunc_fromCbor_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_error);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QCborValueFunc_fromCbor_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QCborParserError *cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // fromCbor(QByteArray,QCborParserError*)
                QCborValue cppResult = ::QCborValue::fromCbor(*cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX]), &cppResult);
            }
            break;
        }
        case 2: // fromCbor(const char * data, long long len, QCborParserError * error)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_error = Shiboken::String::createStaticString("error");
                if (PyDict_Contains(kwds, key_error)) {
                    value = PyDict_GetItem(kwds, key_error);
                    if (value && pyArgs[2]) {
                        errInfo = key_error;
                        Py_INCREF(errInfo);
                        goto Sbk_QCborValueFunc_fromCbor_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORPARSERERROR_IDX]), (pyArgs[2]))))
                            goto Sbk_QCborValueFunc_fromCbor_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_error);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QCborValueFunc_fromCbor_TypeError;
                }
            }
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            long long cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QCborParserError *cppArg2 = nullptr;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // fromCbor(const char*,long long,QCborParserError*)
                QCborValue cppResult = ::QCborValue::fromCbor(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX]), &cppResult);
            }
            break;
        }
        case 3: // fromCbor(const quint8 * data, long long len, QCborParserError * error)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_error = Shiboken::String::createStaticString("error");
                if (PyDict_Contains(kwds, key_error)) {
                    value = PyDict_GetItem(kwds, key_error);
                    if (value && pyArgs[2]) {
                        errInfo = key_error;
                        Py_INCREF(errInfo);
                        goto Sbk_QCborValueFunc_fromCbor_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORPARSERERROR_IDX]), (pyArgs[2]))))
                            goto Sbk_QCborValueFunc_fromCbor_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_error);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QCborValueFunc_fromCbor_TypeError;
                }
            }
            quint8 *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            long long cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QCborParserError *cppArg2 = nullptr;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // fromCbor(const quint8*,long long,QCborParserError*)
                QCborValue cppResult = ::QCborValue::fromCbor(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCborValueFunc_fromCbor_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCborValueFunc_fromJsonValue(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborValue.fromJsonValue";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QCborValue::fromJsonValue(QJsonValue)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_IDX]), (pyArg)))) {
        overloadId = 0; // fromJsonValue(QJsonValue)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCborValueFunc_fromJsonValue_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QJsonValue cppArg0_local;
        ::QJsonValue *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // fromJsonValue(QJsonValue)
            QCborValue cppResult = ::QCborValue::fromJsonValue(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCborValueFunc_fromJsonValue_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCborValueFunc_fromVariant(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborValue.fromVariant";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QCborValue::fromVariant(QVariant)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArg)))) {
        overloadId = 0; // fromVariant(QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCborValueFunc_fromVariant_TypeError;

    // Call function/method
    {
        ::QVariant cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // fromVariant(QVariant)
            QCborValue cppResult = ::QCborValue::fromVariant(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCborValueFunc_fromVariant_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCborValueFunc_isArray(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborValue.isArray";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isArray()const
            bool cppResult = const_cast<const ::QCborValue *>(cppSelf)->isArray();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborValueFunc_isBool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborValue.isBool";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isBool()const
            bool cppResult = const_cast<const ::QCborValue *>(cppSelf)->isBool();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborValueFunc_isByteArray(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborValue.isByteArray";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isByteArray()const
            bool cppResult = const_cast<const ::QCborValue *>(cppSelf)->isByteArray();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborValueFunc_isContainer(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborValue.isContainer";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isContainer()const
            bool cppResult = const_cast<const ::QCborValue *>(cppSelf)->isContainer();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborValueFunc_isDateTime(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborValue.isDateTime";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isDateTime()const
            bool cppResult = const_cast<const ::QCborValue *>(cppSelf)->isDateTime();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborValueFunc_isDouble(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborValue.isDouble";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isDouble()const
            bool cppResult = const_cast<const ::QCborValue *>(cppSelf)->isDouble();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborValueFunc_isFalse(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborValue.isFalse";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isFalse()const
            bool cppResult = const_cast<const ::QCborValue *>(cppSelf)->isFalse();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborValueFunc_isInteger(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborValue.isInteger";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isInteger()const
            bool cppResult = const_cast<const ::QCborValue *>(cppSelf)->isInteger();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborValueFunc_isInvalid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborValue.isInvalid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isInvalid()const
            bool cppResult = const_cast<const ::QCborValue *>(cppSelf)->isInvalid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborValueFunc_isMap(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborValue.isMap";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isMap()const
            bool cppResult = const_cast<const ::QCborValue *>(cppSelf)->isMap();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborValueFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborValue.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::QCborValue *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborValueFunc_isRegularExpression(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborValue.isRegularExpression";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isRegularExpression()const
            bool cppResult = const_cast<const ::QCborValue *>(cppSelf)->isRegularExpression();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborValueFunc_isSimpleType(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborValue.isSimpleType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "isSimpleType", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QCborValue::isSimpleType()const
    // 1: QCborValue::isSimpleType(QCborSimpleType)const
    if (numArgs == 0) {
        overloadId = 0; // isSimpleType()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QCBORSIMPLETYPE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // isSimpleType(QCborSimpleType)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCborValueFunc_isSimpleType_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // isSimpleType() const
        {

            if (!PyErr_Occurred()) {
                // isSimpleType()const
                bool cppResult = const_cast<const ::QCborValue *>(cppSelf)->isSimpleType();
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // isSimpleType(QCborSimpleType st) const
        {
            ::QCborSimpleType cppArg0 = static_cast< ::QCborSimpleType>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // isSimpleType(QCborSimpleType)const
                bool cppResult = const_cast<const ::QCborValue *>(cppSelf)->isSimpleType(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCborValueFunc_isSimpleType_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCborValueFunc_isString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborValue.isString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isString()const
            bool cppResult = const_cast<const ::QCborValue *>(cppSelf)->isString();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborValueFunc_isTag(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborValue.isTag";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isTag()const
            bool cppResult = const_cast<const ::QCborValue *>(cppSelf)->isTag();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborValueFunc_isTrue(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborValue.isTrue";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isTrue()const
            bool cppResult = const_cast<const ::QCborValue *>(cppSelf)->isTrue();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborValueFunc_isUndefined(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborValue.isUndefined";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isUndefined()const
            bool cppResult = const_cast<const ::QCborValue *>(cppSelf)->isUndefined();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborValueFunc_isUrl(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborValue.isUrl";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isUrl()const
            bool cppResult = const_cast<const ::QCborValue *>(cppSelf)->isUrl();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborValueFunc_isUuid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborValue.isUuid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isUuid()const
            bool cppResult = const_cast<const ::QCborValue *>(cppSelf)->isUuid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborValueFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborValue.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCborValue::swap(QCborValue&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QCborValue&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCborValueFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QCborValue cppArg0_local;
        ::QCborValue *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QCborValue&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCborValueFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCborValueFunc_taggedValue(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborValue.taggedValue";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QCborValueFunc_taggedValue_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:taggedValue", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QCborValue::taggedValue(QCborValue)const
    if (numArgs == 0) {
        overloadId = 0; // taggedValue(QCborValue)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX]), (pyArgs[0])))) {
        overloadId = 0; // taggedValue(QCborValue)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCborValueFunc_taggedValue_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_defaultValue = Shiboken::String::createStaticString("defaultValue");
            if (PyDict_Contains(kwds, key_defaultValue)) {
                value = PyDict_GetItem(kwds, key_defaultValue);
                if (value && pyArgs[0]) {
                    errInfo = key_defaultValue;
                    Py_INCREF(errInfo);
                    goto Sbk_QCborValueFunc_taggedValue_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX]), (pyArgs[0]))))
                        goto Sbk_QCborValueFunc_taggedValue_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_defaultValue);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QCborValueFunc_taggedValue_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QCborValue cppArg0_local = QCborValue();
        ::QCborValue *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);
        }

        if (!PyErr_Occurred()) {
            // taggedValue(QCborValue)const
            QCborValue cppResult = const_cast<const ::QCborValue *>(cppSelf)->taggedValue(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCborValueFunc_taggedValue_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCborValueFunc_toArray(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborValue.toArray";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "toArray", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QCborValue::toArray()const
    // 1: QCborValue::toArray(QCborArray)const
    if (numArgs == 0) {
        overloadId = 0; // toArray()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORARRAY_IDX]), (pyArgs[0])))) {
        overloadId = 1; // toArray(QCborArray)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCborValueFunc_toArray_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // toArray() const
        {

            if (!PyErr_Occurred()) {
                // toArray()const
                QCborArray cppResult = const_cast<const ::QCborValue *>(cppSelf)->toArray();
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORARRAY_IDX]), &cppResult);
            }
            break;
        }
        case 1: // toArray(const QCborArray & defaultValue) const
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QCborArray cppArg0_local;
            ::QCborArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // toArray(QCborArray)const
                QCborArray cppResult = const_cast<const ::QCborValue *>(cppSelf)->toArray(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORARRAY_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCborValueFunc_toArray_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCborValueFunc_toBool(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborValue.toBool";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QCborValueFunc_toBool_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:toBool", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QCborValue::toBool(bool)const
    if (numArgs == 0) {
        overloadId = 0; // toBool(bool)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 0; // toBool(bool)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCborValueFunc_toBool_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_defaultValue = Shiboken::String::createStaticString("defaultValue");
            if (PyDict_Contains(kwds, key_defaultValue)) {
                value = PyDict_GetItem(kwds, key_defaultValue);
                if (value && pyArgs[0]) {
                    errInfo = key_defaultValue;
                    Py_INCREF(errInfo);
                    goto Sbk_QCborValueFunc_toBool_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))
                        goto Sbk_QCborValueFunc_toBool_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_defaultValue);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QCborValueFunc_toBool_TypeError;
            }
        }
        bool cppArg0 = false;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // toBool(bool)const
            bool cppResult = const_cast<const ::QCborValue *>(cppSelf)->toBool(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCborValueFunc_toBool_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCborValueFunc_toByteArray(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborValue.toByteArray";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QCborValueFunc_toByteArray_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:toByteArray", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QCborValue::toByteArray(QByteArray)const
    if (numArgs == 0) {
        overloadId = 0; // toByteArray(QByteArray)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        overloadId = 0; // toByteArray(QByteArray)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCborValueFunc_toByteArray_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_defaultValue = Shiboken::String::createStaticString("defaultValue");
            if (PyDict_Contains(kwds, key_defaultValue)) {
                value = PyDict_GetItem(kwds, key_defaultValue);
                if (value && pyArgs[0]) {
                    errInfo = key_defaultValue;
                    Py_INCREF(errInfo);
                    goto Sbk_QCborValueFunc_toByteArray_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0]))))
                        goto Sbk_QCborValueFunc_toByteArray_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_defaultValue);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QCborValueFunc_toByteArray_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QByteArray cppArg0_local = {};
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);
        }

        if (!PyErr_Occurred()) {
            // toByteArray(QByteArray)const
            QByteArray cppResult = const_cast<const ::QCborValue *>(cppSelf)->toByteArray(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCborValueFunc_toByteArray_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCborValueFunc_toCbor(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborValue.toCbor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QCborValueFunc_toCbor_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:toCbor", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QCborValue::toCbor(QCborStreamWriter&,QFlags<QCborValue::EncodingOption>)
    // 1: QCborValue::toCbor(QFlags<QCborValue::EncodingOption>)
    if (numArgs == 0) {
        overloadId = 1; // toCbor(QFlags<QCborValue::EncodingOption>)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCBORVALUE_ENCODINGOPTION_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // toCbor(QFlags<QCborValue::EncodingOption>)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORSTREAMWRITER_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // toCbor(QCborStreamWriter&,QFlags<QCborValue::EncodingOption>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCBORVALUE_ENCODINGOPTION_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // toCbor(QCborStreamWriter&,QFlags<QCborValue::EncodingOption>)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCborValueFunc_toCbor_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // toCbor(QCborStreamWriter & writer, QFlags<QCborValue::EncodingOption> opt)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_opt = Shiboken::String::createStaticString("opt");
                if (PyDict_Contains(kwds, key_opt)) {
                    value = PyDict_GetItem(kwds, key_opt);
                    if (value && pyArgs[1]) {
                        errInfo = key_opt;
                        Py_INCREF(errInfo);
                        goto Sbk_QCborValueFunc_toCbor_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCBORVALUE_ENCODINGOPTION_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QCborValueFunc_toCbor_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_opt);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QCborValueFunc_toCbor_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QCborStreamWriter *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QFlags<QCborValue::EncodingOption> cppArg1 = QCborValue::NoTransformation;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // toCbor(QCborStreamWriter&,QFlags<QCborValue::EncodingOption>)
                cppSelf->toCbor(*cppArg0, cppArg1);
                pyResult = Py_None;
                Py_INCREF(Py_None);
            }
            break;
        }
        case 1: // toCbor(QFlags<QCborValue::EncodingOption> opt)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_opt = Shiboken::String::createStaticString("opt");
                if (PyDict_Contains(kwds, key_opt)) {
                    value = PyDict_GetItem(kwds, key_opt);
                    if (value && pyArgs[0]) {
                        errInfo = key_opt;
                        Py_INCREF(errInfo);
                        goto Sbk_QCborValueFunc_toCbor_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCBORVALUE_ENCODINGOPTION_IDX])->converter, (pyArgs[0]))))
                            goto Sbk_QCborValueFunc_toCbor_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_opt);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QCborValueFunc_toCbor_TypeError;
                }
            }
            ::QFlags<QCborValue::EncodingOption> cppArg0 = QCborValue::NoTransformation;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // toCbor(QFlags<QCborValue::EncodingOption>)
                QByteArray cppResult = cppSelf->toCbor(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCborValueFunc_toCbor_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCborValueFunc_toDateTime(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborValue.toDateTime";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QCborValueFunc_toDateTime_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:toDateTime", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QCborValue::toDateTime(QDateTime)const
    if (numArgs == 0) {
        overloadId = 0; // toDateTime(QDateTime)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), (pyArgs[0])))) {
        overloadId = 0; // toDateTime(QDateTime)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCborValueFunc_toDateTime_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_defaultValue = Shiboken::String::createStaticString("defaultValue");
            if (PyDict_Contains(kwds, key_defaultValue)) {
                value = PyDict_GetItem(kwds, key_defaultValue);
                if (value && pyArgs[0]) {
                    errInfo = key_defaultValue;
                    Py_INCREF(errInfo);
                    goto Sbk_QCborValueFunc_toDateTime_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), (pyArgs[0]))))
                        goto Sbk_QCborValueFunc_toDateTime_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_defaultValue);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QCborValueFunc_toDateTime_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QDateTime cppArg0_local = {};
        ::QDateTime *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);
        }

        if (!PyErr_Occurred()) {
            // toDateTime(QDateTime)const
            QDateTime cppResult = const_cast<const ::QCborValue *>(cppSelf)->toDateTime(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCborValueFunc_toDateTime_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCborValueFunc_toDiagnosticNotation(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborValue.toDiagnosticNotation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QCborValueFunc_toDiagnosticNotation_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:toDiagnosticNotation", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QCborValue::toDiagnosticNotation(QFlags<QCborValue::DiagnosticNotationOption>)const
    if (numArgs == 0) {
        overloadId = 0; // toDiagnosticNotation(QFlags<QCborValue::DiagnosticNotationOption>)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCBORVALUE_DIAGNOSTICNOTATIONOPTION_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // toDiagnosticNotation(QFlags<QCborValue::DiagnosticNotationOption>)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCborValueFunc_toDiagnosticNotation_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_opts = Shiboken::String::createStaticString("opts");
            if (PyDict_Contains(kwds, key_opts)) {
                value = PyDict_GetItem(kwds, key_opts);
                if (value && pyArgs[0]) {
                    errInfo = key_opts;
                    Py_INCREF(errInfo);
                    goto Sbk_QCborValueFunc_toDiagnosticNotation_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCBORVALUE_DIAGNOSTICNOTATIONOPTION_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QCborValueFunc_toDiagnosticNotation_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_opts);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QCborValueFunc_toDiagnosticNotation_TypeError;
            }
        }
        ::QFlags<QCborValue::DiagnosticNotationOption> cppArg0 = QCborValue::Compact;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // toDiagnosticNotation(QFlags<QCborValue::DiagnosticNotationOption>)const
            QString cppResult = const_cast<const ::QCborValue *>(cppSelf)->toDiagnosticNotation(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCborValueFunc_toDiagnosticNotation_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCborValueFunc_toDouble(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborValue.toDouble";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QCborValueFunc_toDouble_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:toDouble", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QCborValue::toDouble(double)const
    if (numArgs == 0) {
        overloadId = 0; // toDouble(double)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[0])))) {
        overloadId = 0; // toDouble(double)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCborValueFunc_toDouble_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_defaultValue = Shiboken::String::createStaticString("defaultValue");
            if (PyDict_Contains(kwds, key_defaultValue)) {
                value = PyDict_GetItem(kwds, key_defaultValue);
                if (value && pyArgs[0]) {
                    errInfo = key_defaultValue;
                    Py_INCREF(errInfo);
                    goto Sbk_QCborValueFunc_toDouble_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[0]))))
                        goto Sbk_QCborValueFunc_toDouble_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_defaultValue);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QCborValueFunc_toDouble_TypeError;
            }
        }
        double cppArg0 = 0;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // toDouble(double)const
            double cppResult = const_cast<const ::QCborValue *>(cppSelf)->toDouble(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<double>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCborValueFunc_toDouble_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCborValueFunc_toInteger(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborValue.toInteger";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QCborValueFunc_toInteger_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:toInteger", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QCborValue::toInteger(qint64)const
    if (numArgs == 0) {
        overloadId = 0; // toInteger(qint64)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[0])))) {
        overloadId = 0; // toInteger(qint64)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCborValueFunc_toInteger_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_defaultValue = Shiboken::String::createStaticString("defaultValue");
            if (PyDict_Contains(kwds, key_defaultValue)) {
                value = PyDict_GetItem(kwds, key_defaultValue);
                if (value && pyArgs[0]) {
                    errInfo = key_defaultValue;
                    Py_INCREF(errInfo);
                    goto Sbk_QCborValueFunc_toInteger_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[0]))))
                        goto Sbk_QCborValueFunc_toInteger_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_defaultValue);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QCborValueFunc_toInteger_TypeError;
            }
        }
        qint64 cppArg0 = 0;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // toInteger(qint64)const
            qint64 cppResult = const_cast<const ::QCborValue *>(cppSelf)->toInteger(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCborValueFunc_toInteger_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCborValueFunc_toJsonValue(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborValue.toJsonValue";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toJsonValue()const
            QJsonValue cppResult = const_cast<const ::QCborValue *>(cppSelf)->toJsonValue();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QJSONVALUE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborValueFunc_toMap(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborValue.toMap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "toMap", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QCborValue::toMap()const
    // 1: QCborValue::toMap(QCborMap)const
    if (numArgs == 0) {
        overloadId = 0; // toMap()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORMAP_IDX]), (pyArgs[0])))) {
        overloadId = 1; // toMap(QCborMap)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCborValueFunc_toMap_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // toMap() const
        {

            if (!PyErr_Occurred()) {
                // toMap()const
                QCborMap cppResult = const_cast<const ::QCborValue *>(cppSelf)->toMap();
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORMAP_IDX]), &cppResult);
            }
            break;
        }
        case 1: // toMap(const QCborMap & defaultValue) const
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QCborMap cppArg0_local;
            ::QCborMap *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORMAP_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // toMap(QCborMap)const
                QCborMap cppResult = const_cast<const ::QCborValue *>(cppSelf)->toMap(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORMAP_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCborValueFunc_toMap_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCborValueFunc_toRegularExpression(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborValue.toRegularExpression";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QCborValueFunc_toRegularExpression_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:toRegularExpression", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QCborValue::toRegularExpression(QRegularExpression)const
    if (numArgs == 0) {
        overloadId = 0; // toRegularExpression(QRegularExpression)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_IDX]), (pyArgs[0])))) {
        overloadId = 0; // toRegularExpression(QRegularExpression)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCborValueFunc_toRegularExpression_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_defaultValue = Shiboken::String::createStaticString("defaultValue");
            if (PyDict_Contains(kwds, key_defaultValue)) {
                value = PyDict_GetItem(kwds, key_defaultValue);
                if (value && pyArgs[0]) {
                    errInfo = key_defaultValue;
                    Py_INCREF(errInfo);
                    goto Sbk_QCborValueFunc_toRegularExpression_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_IDX]), (pyArgs[0]))))
                        goto Sbk_QCborValueFunc_toRegularExpression_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_defaultValue);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QCborValueFunc_toRegularExpression_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QRegularExpression cppArg0_local = {};
        ::QRegularExpression *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);
        }

        if (!PyErr_Occurred()) {
            // toRegularExpression(QRegularExpression)const
            QRegularExpression cppResult = const_cast<const ::QCborValue *>(cppSelf)->toRegularExpression(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCborValueFunc_toRegularExpression_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCborValueFunc_toSimpleType(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborValue.toSimpleType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QCborValueFunc_toSimpleType_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:toSimpleType", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QCborValue::toSimpleType(QCborSimpleType)const
    if (numArgs == 0) {
        overloadId = 0; // toSimpleType(QCborSimpleType)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QCBORSIMPLETYPE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // toSimpleType(QCborSimpleType)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCborValueFunc_toSimpleType_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_defaultValue = Shiboken::String::createStaticString("defaultValue");
            if (PyDict_Contains(kwds, key_defaultValue)) {
                value = PyDict_GetItem(kwds, key_defaultValue);
                if (value && pyArgs[0]) {
                    errInfo = key_defaultValue;
                    Py_INCREF(errInfo);
                    goto Sbk_QCborValueFunc_toSimpleType_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QCBORSIMPLETYPE_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QCborValueFunc_toSimpleType_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_defaultValue);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QCborValueFunc_toSimpleType_TypeError;
            }
        }
        ::QCborSimpleType cppArg0 = QCborSimpleType::Undefined;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // toSimpleType(QCborSimpleType)const
            QCborSimpleType cppResult = const_cast<const ::QCborValue *>(cppSelf)->toSimpleType(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QCBORSIMPLETYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCborValueFunc_toSimpleType_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCborValueFunc_toString(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborValue.toString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QCborValueFunc_toString_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:toString", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QCborValue::toString(QString)const
    if (numArgs == 0) {
        overloadId = 0; // toString(QString)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 0; // toString(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCborValueFunc_toString_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_defaultValue = Shiboken::String::createStaticString("defaultValue");
            if (PyDict_Contains(kwds, key_defaultValue)) {
                value = PyDict_GetItem(kwds, key_defaultValue);
                if (value && pyArgs[0]) {
                    errInfo = key_defaultValue;
                    Py_INCREF(errInfo);
                    goto Sbk_QCborValueFunc_toString_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0]))))
                        goto Sbk_QCborValueFunc_toString_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_defaultValue);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QCborValueFunc_toString_TypeError;
            }
        }
        ::QString cppArg0 = {};
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // toString(QString)const
            QString cppResult = const_cast<const ::QCborValue *>(cppSelf)->toString(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCborValueFunc_toString_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCborValueFunc_toUrl(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborValue.toUrl";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QCborValueFunc_toUrl_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:toUrl", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QCborValue::toUrl(QUrl)const
    if (numArgs == 0) {
        overloadId = 0; // toUrl(QUrl)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[0])))) {
        overloadId = 0; // toUrl(QUrl)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCborValueFunc_toUrl_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_defaultValue = Shiboken::String::createStaticString("defaultValue");
            if (PyDict_Contains(kwds, key_defaultValue)) {
                value = PyDict_GetItem(kwds, key_defaultValue);
                if (value && pyArgs[0]) {
                    errInfo = key_defaultValue;
                    Py_INCREF(errInfo);
                    goto Sbk_QCborValueFunc_toUrl_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[0]))))
                        goto Sbk_QCborValueFunc_toUrl_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_defaultValue);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QCborValueFunc_toUrl_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QUrl cppArg0_local = {};
        ::QUrl *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);
        }

        if (!PyErr_Occurred()) {
            // toUrl(QUrl)const
            QUrl cppResult = const_cast<const ::QCborValue *>(cppSelf)->toUrl(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCborValueFunc_toUrl_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCborValueFunc_toUuid(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborValue.toUuid";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QCborValueFunc_toUuid_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:toUuid", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QCborValue::toUuid(QUuid)const
    if (numArgs == 0) {
        overloadId = 0; // toUuid(QUuid)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX]), (pyArgs[0])))) {
        overloadId = 0; // toUuid(QUuid)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCborValueFunc_toUuid_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_defaultValue = Shiboken::String::createStaticString("defaultValue");
            if (PyDict_Contains(kwds, key_defaultValue)) {
                value = PyDict_GetItem(kwds, key_defaultValue);
                if (value && pyArgs[0]) {
                    errInfo = key_defaultValue;
                    Py_INCREF(errInfo);
                    goto Sbk_QCborValueFunc_toUuid_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX]), (pyArgs[0]))))
                        goto Sbk_QCborValueFunc_toUuid_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_defaultValue);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QCborValueFunc_toUuid_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QUuid cppArg0_local = {};
        ::QUuid *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);
        }

        if (!PyErr_Occurred()) {
            // toUuid(QUuid)const
            QUuid cppResult = const_cast<const ::QCborValue *>(cppSelf)->toUuid(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QUUID_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCborValueFunc_toUuid_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCborValueFunc_toVariant(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborValue.toVariant";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toVariant()const
            QVariant cppResult = const_cast<const ::QCborValue *>(cppSelf)->toVariant();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborValueFunc_type(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCborValue.type";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // type()const
            QCborValue::Type cppResult = const_cast<const ::QCborValue *>(cppSelf)->type();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_TYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCborValue___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QCborValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QCborValue_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QCborValue_methods[] = {
    {"compare", reinterpret_cast<PyCFunction>(Sbk_QCborValueFunc_compare), METH_O},
    {"fromCbor", reinterpret_cast<PyCFunction>(Sbk_QCborValueFunc_fromCbor), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"fromJsonValue", reinterpret_cast<PyCFunction>(Sbk_QCborValueFunc_fromJsonValue), METH_O|METH_STATIC},
    {"fromVariant", reinterpret_cast<PyCFunction>(Sbk_QCborValueFunc_fromVariant), METH_O|METH_STATIC},
    {"isArray", reinterpret_cast<PyCFunction>(Sbk_QCborValueFunc_isArray), METH_NOARGS},
    {"isBool", reinterpret_cast<PyCFunction>(Sbk_QCborValueFunc_isBool), METH_NOARGS},
    {"isByteArray", reinterpret_cast<PyCFunction>(Sbk_QCborValueFunc_isByteArray), METH_NOARGS},
    {"isContainer", reinterpret_cast<PyCFunction>(Sbk_QCborValueFunc_isContainer), METH_NOARGS},
    {"isDateTime", reinterpret_cast<PyCFunction>(Sbk_QCborValueFunc_isDateTime), METH_NOARGS},
    {"isDouble", reinterpret_cast<PyCFunction>(Sbk_QCborValueFunc_isDouble), METH_NOARGS},
    {"isFalse", reinterpret_cast<PyCFunction>(Sbk_QCborValueFunc_isFalse), METH_NOARGS},
    {"isInteger", reinterpret_cast<PyCFunction>(Sbk_QCborValueFunc_isInteger), METH_NOARGS},
    {"isInvalid", reinterpret_cast<PyCFunction>(Sbk_QCborValueFunc_isInvalid), METH_NOARGS},
    {"isMap", reinterpret_cast<PyCFunction>(Sbk_QCborValueFunc_isMap), METH_NOARGS},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QCborValueFunc_isNull), METH_NOARGS},
    {"isRegularExpression", reinterpret_cast<PyCFunction>(Sbk_QCborValueFunc_isRegularExpression), METH_NOARGS},
    {"isSimpleType", reinterpret_cast<PyCFunction>(Sbk_QCborValueFunc_isSimpleType), METH_VARARGS},
    {"isString", reinterpret_cast<PyCFunction>(Sbk_QCborValueFunc_isString), METH_NOARGS},
    {"isTag", reinterpret_cast<PyCFunction>(Sbk_QCborValueFunc_isTag), METH_NOARGS},
    {"isTrue", reinterpret_cast<PyCFunction>(Sbk_QCborValueFunc_isTrue), METH_NOARGS},
    {"isUndefined", reinterpret_cast<PyCFunction>(Sbk_QCborValueFunc_isUndefined), METH_NOARGS},
    {"isUrl", reinterpret_cast<PyCFunction>(Sbk_QCborValueFunc_isUrl), METH_NOARGS},
    {"isUuid", reinterpret_cast<PyCFunction>(Sbk_QCborValueFunc_isUuid), METH_NOARGS},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QCborValueFunc_swap), METH_O},
    {"taggedValue", reinterpret_cast<PyCFunction>(Sbk_QCborValueFunc_taggedValue), METH_VARARGS|METH_KEYWORDS},
    {"toArray", reinterpret_cast<PyCFunction>(Sbk_QCborValueFunc_toArray), METH_VARARGS},
    {"toBool", reinterpret_cast<PyCFunction>(Sbk_QCborValueFunc_toBool), METH_VARARGS|METH_KEYWORDS},
    {"toByteArray", reinterpret_cast<PyCFunction>(Sbk_QCborValueFunc_toByteArray), METH_VARARGS|METH_KEYWORDS},
    {"toCbor", reinterpret_cast<PyCFunction>(Sbk_QCborValueFunc_toCbor), METH_VARARGS|METH_KEYWORDS},
    {"toDateTime", reinterpret_cast<PyCFunction>(Sbk_QCborValueFunc_toDateTime), METH_VARARGS|METH_KEYWORDS},
    {"toDiagnosticNotation", reinterpret_cast<PyCFunction>(Sbk_QCborValueFunc_toDiagnosticNotation), METH_VARARGS|METH_KEYWORDS},
    {"toDouble", reinterpret_cast<PyCFunction>(Sbk_QCborValueFunc_toDouble), METH_VARARGS|METH_KEYWORDS},
    {"toInteger", reinterpret_cast<PyCFunction>(Sbk_QCborValueFunc_toInteger), METH_VARARGS|METH_KEYWORDS},
    {"toJsonValue", reinterpret_cast<PyCFunction>(Sbk_QCborValueFunc_toJsonValue), METH_NOARGS},
    {"toMap", reinterpret_cast<PyCFunction>(Sbk_QCborValueFunc_toMap), METH_VARARGS},
    {"toRegularExpression", reinterpret_cast<PyCFunction>(Sbk_QCborValueFunc_toRegularExpression), METH_VARARGS|METH_KEYWORDS},
    {"toSimpleType", reinterpret_cast<PyCFunction>(Sbk_QCborValueFunc_toSimpleType), METH_VARARGS|METH_KEYWORDS},
    {"toString", reinterpret_cast<PyCFunction>(Sbk_QCborValueFunc_toString), METH_VARARGS|METH_KEYWORDS},
    {"toUrl", reinterpret_cast<PyCFunction>(Sbk_QCborValueFunc_toUrl), METH_VARARGS|METH_KEYWORDS},
    {"toUuid", reinterpret_cast<PyCFunction>(Sbk_QCborValueFunc_toUuid), METH_VARARGS|METH_KEYWORDS},
    {"toVariant", reinterpret_cast<PyCFunction>(Sbk_QCborValueFunc_toVariant), METH_NOARGS},
    {"type", reinterpret_cast<PyCFunction>(Sbk_QCborValueFunc_type), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QCborValue___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QCborValue___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QCborValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

// Rich comparison
static PyObject * Sbk_QCborValue_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QCborValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX]), (pyArg)))) {
                // operator!=(const QCborValue & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QCborValue cppArg0_local;
                ::QCborValue *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_LT:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX]), (pyArg)))) {
                // operator<(const QCborValue & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QCborValue cppArg0_local;
                ::QCborValue *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf <(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                goto Sbk_QCborValue_RichComparison_TypeError;
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX]), (pyArg)))) {
                // operator==(const QCborValue & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QCborValue cppArg0_local;
                ::QCborValue *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QCborValue_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QCborValue_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QCborValue_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QCborValue_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QCborValue__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCborValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QCborValue_Type = nullptr;
static SbkObjectType *Sbk_QCborValue_TypeF(void)
{
    return _Sbk_QCborValue_Type;
}

static PyType_Slot Sbk_QCborValue_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QCborValue__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QCborValue_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QCborValue_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QCborValue_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QCborValue_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QCborValue_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QCborValue___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QCborValue___nb_bool},
#endif
    {0, nullptr}
};
static PyType_Spec Sbk_QCborValue_spec = {
    "2:PySide2.QtCore.QCborValue",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QCborValue_slots
};

} //extern "C"

PyObject *SbkPySide2_QtCore_QCborValue_EncodingOption___and__(PyObject *self, PyObject *pyArg)
{
    ::QCborValue::EncodingOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QCborValue::EncodingOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QCborValue::EncodingOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QCborValue::EncodingOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QCborValue::EncodingOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCBORVALUE_ENCODINGOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QCborValue_EncodingOption___or__(PyObject *self, PyObject *pyArg)
{
    ::QCborValue::EncodingOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QCborValue::EncodingOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QCborValue::EncodingOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QCborValue::EncodingOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QCborValue::EncodingOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCBORVALUE_ENCODINGOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QCborValue_EncodingOption___xor__(PyObject *self, PyObject *pyArg)
{
    ::QCborValue::EncodingOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QCborValue::EncodingOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QCborValue::EncodingOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QCborValue::EncodingOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QCborValue::EncodingOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCBORVALUE_ENCODINGOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QCborValue_EncodingOption___invert__(PyObject *self, PyObject *pyArg)
{
    ::QCborValue::EncodingOptions cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCBORVALUE_ENCODINGOPTION_IDX])->converter, self, &cppSelf);
    ::QCborValue::EncodingOptions cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCBORVALUE_ENCODINGOPTION_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCore_QCborValue_EncodingOption_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCBORVALUE_ENCODINGOPTION_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCore_QCborValue_EncodingOption__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCBORVALUE_ENCODINGOPTION_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCore_QCborValue_EncodingOption_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCore_QCborValue_EncodingOption__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCore_QCborValue_EncodingOption__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_QCborValue_EncodingOption_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCore_QCborValue_EncodingOption___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCore_QCborValue_EncodingOption___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCore_QCborValue_EncodingOption___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCore_QCborValue_EncodingOption___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCore_QCborValue_EncodingOption_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCore_QCborValue_EncodingOption_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_QCborValue_EncodingOption_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtCore_QCborValue_DiagnosticNotationOption___and__(PyObject *self, PyObject *pyArg)
{
    ::QCborValue::DiagnosticNotationOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QCborValue::DiagnosticNotationOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QCborValue::DiagnosticNotationOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QCborValue::DiagnosticNotationOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QCborValue::DiagnosticNotationOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCBORVALUE_DIAGNOSTICNOTATIONOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QCborValue_DiagnosticNotationOption___or__(PyObject *self, PyObject *pyArg)
{
    ::QCborValue::DiagnosticNotationOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QCborValue::DiagnosticNotationOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QCborValue::DiagnosticNotationOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QCborValue::DiagnosticNotationOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QCborValue::DiagnosticNotationOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCBORVALUE_DIAGNOSTICNOTATIONOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QCborValue_DiagnosticNotationOption___xor__(PyObject *self, PyObject *pyArg)
{
    ::QCborValue::DiagnosticNotationOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QCborValue::DiagnosticNotationOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QCborValue::DiagnosticNotationOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QCborValue::DiagnosticNotationOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QCborValue::DiagnosticNotationOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCBORVALUE_DIAGNOSTICNOTATIONOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QCborValue_DiagnosticNotationOption___invert__(PyObject *self, PyObject *pyArg)
{
    ::QCborValue::DiagnosticNotationOptions cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCBORVALUE_DIAGNOSTICNOTATIONOPTION_IDX])->converter, self, &cppSelf);
    ::QCborValue::DiagnosticNotationOptions cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCBORVALUE_DIAGNOSTICNOTATIONOPTION_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCore_QCborValue_DiagnosticNotationOption_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCBORVALUE_DIAGNOSTICNOTATIONOPTION_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCore_QCborValue_DiagnosticNotationOption__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCBORVALUE_DIAGNOSTICNOTATIONOPTION_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCore_QCborValue_DiagnosticNotationOption_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCore_QCborValue_DiagnosticNotationOption__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCore_QCborValue_DiagnosticNotationOption__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_QCborValue_DiagnosticNotationOption_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCore_QCborValue_DiagnosticNotationOption___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCore_QCborValue_DiagnosticNotationOption___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCore_QCborValue_DiagnosticNotationOption___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCore_QCborValue_DiagnosticNotationOption___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCore_QCborValue_DiagnosticNotationOption_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCore_QCborValue_DiagnosticNotationOption_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_QCborValue_DiagnosticNotationOption_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QCborValue_EncodingOption_PythonToCpp_QCborValue_EncodingOption(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCborValue::EncodingOption *>(cppOut) =
        static_cast<::QCborValue::EncodingOption>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QCborValue_EncodingOption_PythonToCpp_QCborValue_EncodingOption_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_ENCODINGOPTION_IDX]))
        return QCborValue_EncodingOption_PythonToCpp_QCborValue_EncodingOption;
    return {};
}
static PyObject *QCborValue_EncodingOption_CppToPython_QCborValue_EncodingOption(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QCborValue::EncodingOption *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_ENCODINGOPTION_IDX], castCppIn);

}

static void QFlags_QCborValue_EncodingOption__PythonToCpp_QFlags_QCborValue_EncodingOption_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QCborValue::EncodingOption> *>(cppOut) =
        ::QFlags<QCborValue::EncodingOption>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QCborValue_EncodingOption__PythonToCpp_QFlags_QCborValue_EncodingOption__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCBORVALUE_ENCODINGOPTION_IDX]))
        return QFlags_QCborValue_EncodingOption__PythonToCpp_QFlags_QCborValue_EncodingOption_;
    return {};
}
static PyObject *QFlags_QCborValue_EncodingOption__CppToPython_QFlags_QCborValue_EncodingOption_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QCborValue::EncodingOption> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCBORVALUE_ENCODINGOPTION_IDX]));

}

static void QCborValue_EncodingOption_PythonToCpp_QFlags_QCborValue_EncodingOption_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QCborValue::EncodingOption> *>(cppOut) =
        ::QFlags<QCborValue::EncodingOption>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QCborValue_EncodingOption_PythonToCpp_QFlags_QCborValue_EncodingOption__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_ENCODINGOPTION_IDX]))
        return QCborValue_EncodingOption_PythonToCpp_QFlags_QCborValue_EncodingOption_;
    return {};
}
static void number_PythonToCpp_QFlags_QCborValue_EncodingOption_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QCborValue::EncodingOption> *>(cppOut) =
        ::QFlags<QCborValue::EncodingOption>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QCborValue_EncodingOption__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_ENCODINGOPTION_IDX]))
        return number_PythonToCpp_QFlags_QCborValue_EncodingOption_;
    return {};
}
static void QCborValue_DiagnosticNotationOption_PythonToCpp_QCborValue_DiagnosticNotationOption(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCborValue::DiagnosticNotationOption *>(cppOut) =
        static_cast<::QCborValue::DiagnosticNotationOption>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QCborValue_DiagnosticNotationOption_PythonToCpp_QCborValue_DiagnosticNotationOption_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_DIAGNOSTICNOTATIONOPTION_IDX]))
        return QCborValue_DiagnosticNotationOption_PythonToCpp_QCborValue_DiagnosticNotationOption;
    return {};
}
static PyObject *QCborValue_DiagnosticNotationOption_CppToPython_QCborValue_DiagnosticNotationOption(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QCborValue::DiagnosticNotationOption *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_DIAGNOSTICNOTATIONOPTION_IDX], castCppIn);

}

static void QFlags_QCborValue_DiagnosticNotationOption__PythonToCpp_QFlags_QCborValue_DiagnosticNotationOption_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QCborValue::DiagnosticNotationOption> *>(cppOut) =
        ::QFlags<QCborValue::DiagnosticNotationOption>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QCborValue_DiagnosticNotationOption__PythonToCpp_QFlags_QCborValue_DiagnosticNotationOption__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCBORVALUE_DIAGNOSTICNOTATIONOPTION_IDX]))
        return QFlags_QCborValue_DiagnosticNotationOption__PythonToCpp_QFlags_QCborValue_DiagnosticNotationOption_;
    return {};
}
static PyObject *QFlags_QCborValue_DiagnosticNotationOption__CppToPython_QFlags_QCborValue_DiagnosticNotationOption_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QCborValue::DiagnosticNotationOption> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCBORVALUE_DIAGNOSTICNOTATIONOPTION_IDX]));

}

static void QCborValue_DiagnosticNotationOption_PythonToCpp_QFlags_QCborValue_DiagnosticNotationOption_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QCborValue::DiagnosticNotationOption> *>(cppOut) =
        ::QFlags<QCborValue::DiagnosticNotationOption>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QCborValue_DiagnosticNotationOption_PythonToCpp_QFlags_QCborValue_DiagnosticNotationOption__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_DIAGNOSTICNOTATIONOPTION_IDX]))
        return QCborValue_DiagnosticNotationOption_PythonToCpp_QFlags_QCborValue_DiagnosticNotationOption_;
    return {};
}
static void number_PythonToCpp_QFlags_QCborValue_DiagnosticNotationOption_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QCborValue::DiagnosticNotationOption> *>(cppOut) =
        ::QFlags<QCborValue::DiagnosticNotationOption>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QCborValue_DiagnosticNotationOption__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_DIAGNOSTICNOTATIONOPTION_IDX]))
        return number_PythonToCpp_QFlags_QCborValue_DiagnosticNotationOption_;
    return {};
}
static void QCborValue_Type_PythonToCpp_QCborValue_Type(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCborValue::Type *>(cppOut) =
        static_cast<::QCborValue::Type>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QCborValue_Type_PythonToCpp_QCborValue_Type_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_TYPE_IDX]))
        return QCborValue_Type_PythonToCpp_QCborValue_Type;
    return {};
}
static PyObject *QCborValue_Type_CppToPython_QCborValue_Type(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QCborValue::Type *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_TYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QCborValue_PythonToCpp_QCborValue_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QCborValue_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QCborValue_PythonToCpp_QCborValue_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QCborValue_TypeF())))
        return QCborValue_PythonToCpp_QCborValue_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QCborValue_PTR_CppToPython_QCborValue(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QCborValue *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QCborValue_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QCborValue_COPY_CppToPython_QCborValue(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QCborValue_TypeF(), new ::QCborValue(*reinterpret_cast<const ::QCborValue *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QCborValue_PythonToCpp_QCborValue_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCborValue *>(cppOut) = *reinterpret_cast< ::QCborValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QCborValue_PythonToCpp_QCborValue_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QCborValue_TypeF())))
        return QCborValue_PythonToCpp_QCborValue_COPY;
    return {};
}

// Implicit conversions.
static void QCborKnownTags_PythonToCpp_QCborValue(PyObject *pyIn, void *cppOut) {
    ::QCborKnownTags cppIn{QCborKnownTags::DateTimeString};
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX])->converter, pyIn, &cppIn);
    *reinterpret_cast<::QCborValue *>(cppOut) = ::QCborValue(cppIn);
}
static PythonToCppFunc is_QCborKnownTags_PythonToCpp_QCborValue_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QCBORKNOWNTAGS_IDX], pyIn))
        return QCborKnownTags_PythonToCpp_QCborValue;
    return {};
}

static void QCborSimpleType_PythonToCpp_QCborValue(PyObject *pyIn, void *cppOut) {
    ::QCborSimpleType cppIn = static_cast< ::QCborSimpleType>(0);
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QCBORSIMPLETYPE_IDX])->converter, pyIn, &cppIn);
    *reinterpret_cast<::QCborValue *>(cppOut) = ::QCborValue(cppIn);
}
static PythonToCppFunc is_QCborSimpleType_PythonToCpp_QCborValue_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QCBORSIMPLETYPE_IDX], pyIn))
        return QCborSimpleType_PythonToCpp_QCborValue;
    return {};
}

static void QCborValue_Type_PythonToCpp_QCborValue(PyObject *pyIn, void *cppOut) {
    ::QCborValue::Type cppIn{QCborValue::Integer};
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_TYPE_IDX])->converter, pyIn, &cppIn);
    *reinterpret_cast<::QCborValue *>(cppOut) = ::QCborValue(cppIn);
}
static PythonToCppFunc is_QCborValue_Type_PythonToCpp_QCborValue_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_TYPE_IDX], pyIn))
        return QCborValue_Type_PythonToCpp_QCborValue;
    return {};
}

static void bool_PythonToCpp_QCborValue(PyObject *pyIn, void *cppOut) {
    bool cppIn;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyIn, &cppIn);
    *reinterpret_cast<::QCborValue *>(cppOut) = ::QCborValue(cppIn);
}
static PythonToCppFunc is_bool_PythonToCpp_QCborValue_Convertible(PyObject *pyIn) {
    if (PyBool_Check(pyIn))
        return bool_PythonToCpp_QCborValue;
    return {};
}

static void constQByteArrayREF_PythonToCpp_QCborValue(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCborValue *>(cppOut) = ::QCborValue( *reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_constQByteArrayREF_PythonToCpp_QCborValue_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], pyIn))
        return constQByteArrayREF_PythonToCpp_QCborValue;
    return {};
}

static void constQCborArrayREF_PythonToCpp_QCborValue(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCborValue *>(cppOut) = ::QCborValue( *reinterpret_cast< ::QCborArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORARRAY_IDX], reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_constQCborArrayREF_PythonToCpp_QCborValue_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QCBORARRAY_IDX], pyIn))
        return constQCborArrayREF_PythonToCpp_QCborValue;
    return {};
}

static void constQCborMapREF_PythonToCpp_QCborValue(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCborValue *>(cppOut) = ::QCborValue( *reinterpret_cast< ::QCborMap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCBORMAP_IDX], reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_constQCborMapREF_PythonToCpp_QCborValue_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QCBORMAP_IDX], pyIn))
        return constQCborMapREF_PythonToCpp_QCborValue;
    return {};
}

static void constQStringREF_PythonToCpp_QCborValue(PyObject *pyIn, void *cppOut) {
    ::QString cppIn;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyIn, &cppIn);
    *reinterpret_cast<::QCborValue *>(cppOut) = ::QCborValue(cppIn);
}
static PythonToCppFunc is_constQStringREF_PythonToCpp_QCborValue_Convertible(PyObject *pyIn) {
    if (Shiboken::String::check(pyIn))
        return constQStringREF_PythonToCpp_QCborValue;
    return {};
}

static void constcharPTR_PythonToCpp_QCborValue(PyObject *pyIn, void *cppOut) {
    const char* cppIn;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), pyIn, &cppIn);
    *reinterpret_cast<::QCborValue *>(cppOut) = ::QCborValue(cppIn);
}
static PythonToCppFunc is_constcharPTR_PythonToCpp_QCborValue_Convertible(PyObject *pyIn) {
    if (Shiboken::String::check(pyIn))
        return constcharPTR_PythonToCpp_QCborValue;
    return {};
}

static void double_PythonToCpp_QCborValue(PyObject *pyIn, void *cppOut) {
    double cppIn;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<double>(), pyIn, &cppIn);
    *reinterpret_cast<::QCborValue *>(cppOut) = ::QCborValue(cppIn);
}
static PythonToCppFunc is_double_PythonToCpp_QCborValue_Convertible(PyObject *pyIn) {
    if (PyFloat_Check(pyIn))
        return double_PythonToCpp_QCborValue;
    return {};
}

static void int_PythonToCpp_QCborValue(PyObject *pyIn, void *cppOut) {
    int cppIn;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyIn, &cppIn);
    *reinterpret_cast<::QCborValue *>(cppOut) = ::QCborValue(cppIn);
}
static PythonToCppFunc is_int_PythonToCpp_QCborValue_Convertible(PyObject *pyIn) {
    if (PyInt_Check(pyIn))
        return int_PythonToCpp_QCborValue;
    return {};
}

static void qint64_PythonToCpp_QCborValue(PyObject *pyIn, void *cppOut) {
    qint64 cppIn;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), pyIn, &cppIn);
    *reinterpret_cast<::QCborValue *>(cppOut) = ::QCborValue(cppIn);
}
static PythonToCppFunc is_qint64_PythonToCpp_QCborValue_Convertible(PyObject *pyIn) {
    if (PyLong_Check(pyIn))
        return qint64_PythonToCpp_QCborValue;
    return {};
}

static void unsignedint_PythonToCpp_QCborValue(PyObject *pyIn, void *cppOut) {
    unsigned int cppIn;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), pyIn, &cppIn);
    *reinterpret_cast<::QCborValue *>(cppOut) = ::QCborValue(cppIn);
}
static PythonToCppFunc is_unsignedint_PythonToCpp_QCborValue_Convertible(PyObject *pyIn) {
    if (PyInt_Check(pyIn))
        return unsignedint_PythonToCpp_QCborValue;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QCborValue_SignatureStrings[] = {
    "18:PySide2.QtCore.QCborValue(self)",
    "17:PySide2.QtCore.QCborValue(self,t_:PySide2.QtCore.QCborKnownTags,tv:PySide2.QtCore.QCborValue=QCborValue())",
    "16:PySide2.QtCore.QCborValue(self,st:PySide2.QtCore.QCborSimpleType)",
    "15:PySide2.QtCore.QCborValue(self,t_:PySide2.QtCore.QCborValue.Type)",
    "14:PySide2.QtCore.QCborValue(self,b_:bool)",
    "13:PySide2.QtCore.QCborValue(self,ba:PySide2.QtCore.QByteArray)",
    "12:PySide2.QtCore.QCborValue(self,a:PySide2.QtCore.QCborArray)",
    "11:PySide2.QtCore.QCborValue(self,m:PySide2.QtCore.QCborMap)",
    "10:PySide2.QtCore.QCborValue(self,other:PySide2.QtCore.QCborValue)",
    "9:PySide2.QtCore.QCborValue(self,dt:PySide2.QtCore.QDateTime)",
    "8:PySide2.QtCore.QCborValue(self,rx:PySide2.QtCore.QRegularExpression)",
    "7:PySide2.QtCore.QCborValue(self,s:QString)",
    "6:PySide2.QtCore.QCborValue(self,url:PySide2.QtCore.QUrl)",
    "5:PySide2.QtCore.QCborValue(self,uuid:PySide2.QtCore.QUuid)",
    "4:PySide2.QtCore.QCborValue(self,s:char*)",
    "3:PySide2.QtCore.QCborValue(self,v:double)",
    "2:PySide2.QtCore.QCborValue(self,i:int)",
    "1:PySide2.QtCore.QCborValue(self,i:qint64)",
    "0:PySide2.QtCore.QCborValue(self,u:unsigned int)",
    "PySide2.QtCore.QCborValue.compare(self,other:PySide2.QtCore.QCborValue)->int",
    "3:PySide2.QtCore.QCborValue.fromCbor(reader:PySide2.QtCore.QCborStreamReader)->PySide2.QtCore.QCborValue",
    "2:PySide2.QtCore.QCborValue.fromCbor(ba:PySide2.QtCore.QByteArray,error:PySide2.QtCore.QCborParserError=nullptr)->PySide2.QtCore.QCborValue",
    "1:PySide2.QtCore.QCborValue.fromCbor(data:char*,len:long long,error:PySide2.QtCore.QCborParserError=nullptr)->PySide2.QtCore.QCborValue",
    "0:PySide2.QtCore.QCborValue.fromCbor(data:quint8*,len:long long,error:PySide2.QtCore.QCborParserError=nullptr)->PySide2.QtCore.QCborValue",
    "PySide2.QtCore.QCborValue.fromJsonValue(v:PySide2.QtCore.QJsonValue)->PySide2.QtCore.QCborValue",
    "PySide2.QtCore.QCborValue.fromVariant(variant:QVariant)->PySide2.QtCore.QCborValue",
    "PySide2.QtCore.QCborValue.isArray(self)->bool",
    "PySide2.QtCore.QCborValue.isBool(self)->bool",
    "PySide2.QtCore.QCborValue.isByteArray(self)->bool",
    "PySide2.QtCore.QCborValue.isContainer(self)->bool",
    "PySide2.QtCore.QCborValue.isDateTime(self)->bool",
    "PySide2.QtCore.QCborValue.isDouble(self)->bool",
    "PySide2.QtCore.QCborValue.isFalse(self)->bool",
    "PySide2.QtCore.QCborValue.isInteger(self)->bool",
    "PySide2.QtCore.QCborValue.isInvalid(self)->bool",
    "PySide2.QtCore.QCborValue.isMap(self)->bool",
    "PySide2.QtCore.QCborValue.isNull(self)->bool",
    "PySide2.QtCore.QCborValue.isRegularExpression(self)->bool",
    "1:PySide2.QtCore.QCborValue.isSimpleType(self)->bool",
    "0:PySide2.QtCore.QCborValue.isSimpleType(self,st:PySide2.QtCore.QCborSimpleType)->bool",
    "PySide2.QtCore.QCborValue.isString(self)->bool",
    "PySide2.QtCore.QCborValue.isTag(self)->bool",
    "PySide2.QtCore.QCborValue.isTrue(self)->bool",
    "PySide2.QtCore.QCborValue.isUndefined(self)->bool",
    "PySide2.QtCore.QCborValue.isUrl(self)->bool",
    "PySide2.QtCore.QCborValue.isUuid(self)->bool",
    "PySide2.QtCore.QCborValue.swap(self,other:PySide2.QtCore.QCborValue)",
    "PySide2.QtCore.QCborValue.taggedValue(self,defaultValue:PySide2.QtCore.QCborValue=QCborValue())->PySide2.QtCore.QCborValue",
    "1:PySide2.QtCore.QCborValue.toArray(self)->PySide2.QtCore.QCborArray",
    "0:PySide2.QtCore.QCborValue.toArray(self,defaultValue:PySide2.QtCore.QCborArray)->PySide2.QtCore.QCborArray",
    "PySide2.QtCore.QCborValue.toBool(self,defaultValue:bool=false)->bool",
    "PySide2.QtCore.QCborValue.toByteArray(self,defaultValue:PySide2.QtCore.QByteArray={})->PySide2.QtCore.QByteArray",
    "1:PySide2.QtCore.QCborValue.toCbor(self,writer:PySide2.QtCore.QCborStreamWriter,opt:PySide2.QtCore.QCborValue.EncodingOptions=QCborValue.NoTransformation)",
    "0:PySide2.QtCore.QCborValue.toCbor(self,opt:PySide2.QtCore.QCborValue.EncodingOptions=QCborValue.NoTransformation)->PySide2.QtCore.QByteArray",
    "PySide2.QtCore.QCborValue.toDateTime(self,defaultValue:PySide2.QtCore.QDateTime={})->PySide2.QtCore.QDateTime",
    "PySide2.QtCore.QCborValue.toDiagnosticNotation(self,opts:PySide2.QtCore.QCborValue.DiagnosticNotationOptions=QCborValue.Compact)->QString",
    "PySide2.QtCore.QCborValue.toDouble(self,defaultValue:double=0)->double",
    "PySide2.QtCore.QCborValue.toInteger(self,defaultValue:qint64=0)->qint64",
    "PySide2.QtCore.QCborValue.toJsonValue(self)->PySide2.QtCore.QJsonValue",
    "1:PySide2.QtCore.QCborValue.toMap(self)->PySide2.QtCore.QCborMap",
    "0:PySide2.QtCore.QCborValue.toMap(self,defaultValue:PySide2.QtCore.QCborMap)->PySide2.QtCore.QCborMap",
    "PySide2.QtCore.QCborValue.toRegularExpression(self,defaultValue:PySide2.QtCore.QRegularExpression={})->PySide2.QtCore.QRegularExpression",
    "PySide2.QtCore.QCborValue.toSimpleType(self,defaultValue:PySide2.QtCore.QCborSimpleType=QCborSimpleType.Undefined)->PySide2.QtCore.QCborSimpleType",
    "PySide2.QtCore.QCborValue.toString(self,defaultValue:QString={})->QString",
    "PySide2.QtCore.QCborValue.toUrl(self,defaultValue:PySide2.QtCore.QUrl={})->PySide2.QtCore.QUrl",
    "PySide2.QtCore.QCborValue.toUuid(self,defaultValue:PySide2.QtCore.QUuid={})->PySide2.QtCore.QUuid",
    "PySide2.QtCore.QCborValue.toVariant(self)->QVariant",
    "PySide2.QtCore.QCborValue.type(self)->PySide2.QtCore.QCborValue.Type",
    "PySide2.QtCore.QCborValue.__copy__()",
    nullptr}; // Sentinel

void init_QCborValue(PyObject *module)
{
    _Sbk_QCborValue_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QCborValue",
        "QCborValue",
        &Sbk_QCborValue_spec,
        &Shiboken::callCppDestructor< ::QCborValue >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QCborValue_Type);
    InitSignatureStrings(pyType, QCborValue_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QCborValue_Type), Sbk_QCborValue_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QCborValue_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QCborValue_TypeF(),
        QCborValue_PythonToCpp_QCborValue_PTR,
        is_QCborValue_PythonToCpp_QCborValue_PTR_Convertible,
        QCborValue_PTR_CppToPython_QCborValue,
        QCborValue_COPY_CppToPython_QCborValue);

    Shiboken::Conversions::registerConverterName(converter, "QCborValue");
    Shiboken::Conversions::registerConverterName(converter, "QCborValue*");
    Shiboken::Conversions::registerConverterName(converter, "QCborValue&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QCborValue).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QCborValue_PythonToCpp_QCborValue_COPY,
        is_QCborValue_PythonToCpp_QCborValue_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QCborKnownTags_PythonToCpp_QCborValue,
        is_QCborKnownTags_PythonToCpp_QCborValue_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QCborSimpleType_PythonToCpp_QCborValue,
        is_QCborSimpleType_PythonToCpp_QCborValue_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QCborValue_Type_PythonToCpp_QCborValue,
        is_QCborValue_Type_PythonToCpp_QCborValue_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        bool_PythonToCpp_QCborValue,
        is_bool_PythonToCpp_QCborValue_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        constQByteArrayREF_PythonToCpp_QCborValue,
        is_constQByteArrayREF_PythonToCpp_QCborValue_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        constQCborArrayREF_PythonToCpp_QCborValue,
        is_constQCborArrayREF_PythonToCpp_QCborValue_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        constQCborMapREF_PythonToCpp_QCborValue,
        is_constQCborMapREF_PythonToCpp_QCborValue_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        constQStringREF_PythonToCpp_QCborValue,
        is_constQStringREF_PythonToCpp_QCborValue_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        constcharPTR_PythonToCpp_QCborValue,
        is_constcharPTR_PythonToCpp_QCborValue_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        double_PythonToCpp_QCborValue,
        is_double_PythonToCpp_QCborValue_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        int_PythonToCpp_QCborValue,
        is_int_PythonToCpp_QCborValue_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        qint64_PythonToCpp_QCborValue,
        is_qint64_PythonToCpp_QCborValue_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        unsignedint_PythonToCpp_QCborValue,
        is_unsignedint_PythonToCpp_QCborValue_Convertible);

    // Initialization of enums.

    // Initialization of enum 'EncodingOption'.
    SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCBORVALUE_ENCODINGOPTION_IDX] = PySide::QFlags::create("2:PySide2.QtCore.QCborValue.EncodingOptions", SbkPySide2_QtCore_QCborValue_EncodingOption_number_slots);
    SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_ENCODINGOPTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QCborValue_TypeF(),
        "EncodingOption",
        "2:PySide2.QtCore.QCborValue.EncodingOption",
        "QCborValue::EncodingOption",
        SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCBORVALUE_ENCODINGOPTION_IDX]);
    if (!SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_ENCODINGOPTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_ENCODINGOPTION_IDX],
        Sbk_QCborValue_TypeF(), "SortKeysInMaps", (long) QCborValue::EncodingOption::SortKeysInMaps))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_ENCODINGOPTION_IDX],
        Sbk_QCborValue_TypeF(), "UseFloat", (long) QCborValue::EncodingOption::UseFloat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_ENCODINGOPTION_IDX],
        Sbk_QCborValue_TypeF(), "UseFloat16", (long) QCborValue::EncodingOption::UseFloat16))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_ENCODINGOPTION_IDX],
        Sbk_QCborValue_TypeF(), "UseIntegers", (long) QCborValue::EncodingOption::UseIntegers))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_ENCODINGOPTION_IDX],
        Sbk_QCborValue_TypeF(), "NoTransformation", (long) QCborValue::EncodingOption::NoTransformation))
        return;
    // Register converter for enum 'QCborValue::EncodingOption'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_ENCODINGOPTION_IDX],
            QCborValue_EncodingOption_CppToPython_QCborValue_EncodingOption);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QCborValue_EncodingOption_PythonToCpp_QCborValue_EncodingOption,
            is_QCborValue_EncodingOption_PythonToCpp_QCborValue_EncodingOption_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_ENCODINGOPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QCborValue::EncodingOption");
        Shiboken::Conversions::registerConverterName(converter, "EncodingOption");
    }
    // Register converter for flag 'QFlags<QCborValue::EncodingOption>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCBORVALUE_ENCODINGOPTION_IDX],
            QFlags_QCborValue_EncodingOption__CppToPython_QFlags_QCborValue_EncodingOption_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QCborValue_EncodingOption_PythonToCpp_QFlags_QCborValue_EncodingOption_,
            is_QCborValue_EncodingOption_PythonToCpp_QFlags_QCborValue_EncodingOption__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QCborValue_EncodingOption__PythonToCpp_QFlags_QCborValue_EncodingOption_,
            is_QFlags_QCborValue_EncodingOption__PythonToCpp_QFlags_QCborValue_EncodingOption__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QCborValue_EncodingOption_,
            is_number_PythonToCpp_QFlags_QCborValue_EncodingOption__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCBORVALUE_ENCODINGOPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QCborValue::EncodingOptions");
        Shiboken::Conversions::registerConverterName(converter, "EncodingOptions");
    }
    // End of 'EncodingOption' enum/flags.

    // Initialization of enum 'DiagnosticNotationOption'.
    SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCBORVALUE_DIAGNOSTICNOTATIONOPTION_IDX] = PySide::QFlags::create("2:PySide2.QtCore.QCborValue.DiagnosticNotationOptions", SbkPySide2_QtCore_QCborValue_DiagnosticNotationOption_number_slots);
    SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_DIAGNOSTICNOTATIONOPTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QCborValue_TypeF(),
        "DiagnosticNotationOption",
        "2:PySide2.QtCore.QCborValue.DiagnosticNotationOption",
        "QCborValue::DiagnosticNotationOption",
        SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCBORVALUE_DIAGNOSTICNOTATIONOPTION_IDX]);
    if (!SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_DIAGNOSTICNOTATIONOPTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_DIAGNOSTICNOTATIONOPTION_IDX],
        Sbk_QCborValue_TypeF(), "Compact", (long) QCborValue::DiagnosticNotationOption::Compact))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_DIAGNOSTICNOTATIONOPTION_IDX],
        Sbk_QCborValue_TypeF(), "LineWrapped", (long) QCborValue::DiagnosticNotationOption::LineWrapped))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_DIAGNOSTICNOTATIONOPTION_IDX],
        Sbk_QCborValue_TypeF(), "ExtendedFormat", (long) QCborValue::DiagnosticNotationOption::ExtendedFormat))
        return;
    // Register converter for enum 'QCborValue::DiagnosticNotationOption'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_DIAGNOSTICNOTATIONOPTION_IDX],
            QCborValue_DiagnosticNotationOption_CppToPython_QCborValue_DiagnosticNotationOption);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QCborValue_DiagnosticNotationOption_PythonToCpp_QCborValue_DiagnosticNotationOption,
            is_QCborValue_DiagnosticNotationOption_PythonToCpp_QCborValue_DiagnosticNotationOption_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_DIAGNOSTICNOTATIONOPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QCborValue::DiagnosticNotationOption");
        Shiboken::Conversions::registerConverterName(converter, "DiagnosticNotationOption");
    }
    // Register converter for flag 'QFlags<QCborValue::DiagnosticNotationOption>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCBORVALUE_DIAGNOSTICNOTATIONOPTION_IDX],
            QFlags_QCborValue_DiagnosticNotationOption__CppToPython_QFlags_QCborValue_DiagnosticNotationOption_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QCborValue_DiagnosticNotationOption_PythonToCpp_QFlags_QCborValue_DiagnosticNotationOption_,
            is_QCborValue_DiagnosticNotationOption_PythonToCpp_QFlags_QCborValue_DiagnosticNotationOption__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QCborValue_DiagnosticNotationOption__PythonToCpp_QFlags_QCborValue_DiagnosticNotationOption_,
            is_QFlags_QCborValue_DiagnosticNotationOption__PythonToCpp_QFlags_QCborValue_DiagnosticNotationOption__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QCborValue_DiagnosticNotationOption_,
            is_number_PythonToCpp_QFlags_QCborValue_DiagnosticNotationOption__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCBORVALUE_DIAGNOSTICNOTATIONOPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QCborValue::DiagnosticNotationOptions");
        Shiboken::Conversions::registerConverterName(converter, "DiagnosticNotationOptions");
    }
    // End of 'DiagnosticNotationOption' enum/flags.

    // Initialization of enum 'Type'.
    SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_TYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QCborValue_TypeF(),
        "Type",
        "2:PySide2.QtCore.QCborValue.Type",
        "QCborValue::Type");
    if (!SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_TYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_TYPE_IDX],
        Sbk_QCborValue_TypeF(), "Integer", (long) QCborValue::Type::Integer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_TYPE_IDX],
        Sbk_QCborValue_TypeF(), "ByteArray", (long) QCborValue::Type::ByteArray))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_TYPE_IDX],
        Sbk_QCborValue_TypeF(), "String", (long) QCborValue::Type::String))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_TYPE_IDX],
        Sbk_QCborValue_TypeF(), "Array", (long) QCborValue::Type::Array))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_TYPE_IDX],
        Sbk_QCborValue_TypeF(), "Map", (long) QCborValue::Type::Map))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_TYPE_IDX],
        Sbk_QCborValue_TypeF(), "Tag", (long) QCborValue::Type::Tag))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_TYPE_IDX],
        Sbk_QCborValue_TypeF(), "SimpleType", (long) QCborValue::Type::SimpleType))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_TYPE_IDX],
        Sbk_QCborValue_TypeF(), "False_", (long) QCborValue::Type::False))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_TYPE_IDX],
        Sbk_QCborValue_TypeF(), "True_", (long) QCborValue::Type::True))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_TYPE_IDX],
        Sbk_QCborValue_TypeF(), "Null", (long) QCborValue::Type::Null))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_TYPE_IDX],
        Sbk_QCborValue_TypeF(), "Undefined", (long) QCborValue::Type::Undefined))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_TYPE_IDX],
        Sbk_QCborValue_TypeF(), "Double", (long) QCborValue::Type::Double))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_TYPE_IDX],
        Sbk_QCborValue_TypeF(), "DateTime", (long) QCborValue::Type::DateTime))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_TYPE_IDX],
        Sbk_QCborValue_TypeF(), "Url", (long) QCborValue::Type::Url))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_TYPE_IDX],
        Sbk_QCborValue_TypeF(), "RegularExpression", (long) QCborValue::Type::RegularExpression))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_TYPE_IDX],
        Sbk_QCborValue_TypeF(), "Uuid", (long) QCborValue::Type::Uuid))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_TYPE_IDX],
        Sbk_QCborValue_TypeF(), "Invalid", (long) QCborValue::Type::Invalid))
        return;
    // Register converter for enum 'QCborValue::Type'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_TYPE_IDX],
            QCborValue_Type_CppToPython_QCborValue_Type);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QCborValue_Type_PythonToCpp_QCborValue_Type,
            is_QCborValue_Type_PythonToCpp_QCborValue_Type_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QCBORVALUE_TYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QCborValue::Type");
        Shiboken::Conversions::registerConverterName(converter, "Type");
    }
    // End of 'Type' enum.

    qRegisterMetaType< ::QCborValue >("QCborValue");
    qRegisterMetaType< ::QCborValue::EncodingOption >("QCborValue::EncodingOption");
    qRegisterMetaType< ::QCborValue::EncodingOptions >("QCborValue::EncodingOptions");
    qRegisterMetaType< ::QCborValue::DiagnosticNotationOption >("QCborValue::DiagnosticNotationOption");
    qRegisterMetaType< ::QCborValue::DiagnosticNotationOptions >("QCborValue::DiagnosticNotationOptions");
    qRegisterMetaType< ::QCborValue::Type >("QCborValue::Type");
}
