/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qcommandlineoption_wrapper.h"

// inner classes

// Extra includes
#include <qcommandlineoption.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QCommandLineOption_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QCommandLineOption >()))
        return -1;

    ::QCommandLineOption *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCommandLineOption.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QCommandLineOption_Init_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QCommandLineOption_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:QCommandLineOption", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return -1;


    // Overloaded function decisor
    // 0: QCommandLineOption::QCommandLineOption(QCommandLineOption)
    // 1: QCommandLineOption::QCommandLineOption(QString)
    // 2: QCommandLineOption::QCommandLineOption(QString,QString,QString,QString)
    // 3: QCommandLineOption::QCommandLineOption(QStringList)
    // 4: QCommandLineOption::QCommandLineOption(QStringList,QString,QString,QString)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 3; // QCommandLineOption(QStringList)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 4; // QCommandLineOption(QStringList,QString,QString,QString)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 4; // QCommandLineOption(QStringList,QString,QString,QString)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3])))) {
                    overloadId = 4; // QCommandLineOption(QStringList,QString,QString,QString)
                }
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // QCommandLineOption(QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 2; // QCommandLineOption(QString,QString,QString,QString)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 2; // QCommandLineOption(QString,QString,QString,QString)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3])))) {
                    overloadId = 2; // QCommandLineOption(QString,QString,QString,QString)
                }
            }
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEOPTION_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QCommandLineOption(QCommandLineOption)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCommandLineOption_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QCommandLineOption(const QCommandLineOption & other)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QCommandLineOption_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QCommandLineOption *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QCommandLineOption(QCommandLineOption)
                cptr = new ::QCommandLineOption(*cppArg0);
            }
            break;
        }
        case 1: // QCommandLineOption(const QString & name)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QCommandLineOption_Init_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QCommandLineOption(QString)
                cptr = new ::QCommandLineOption(cppArg0);
            }
            break;
        }
        case 2: // QCommandLineOption(const QString & name, const QString & description, const QString & valueName, const QString & defaultValue)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_valueName = Shiboken::String::createStaticString("valueName");
                if (PyDict_Contains(kwds, key_valueName)) {
                    value = PyDict_GetItem(kwds, key_valueName);
                    if (value && pyArgs[2]) {
                        errInfo = key_valueName;
                        Py_INCREF(errInfo);
                        goto Sbk_QCommandLineOption_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2]))))
                            goto Sbk_QCommandLineOption_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_valueName);
                }
                static PyObject *const key_defaultValue = Shiboken::String::createStaticString("defaultValue");
                if (PyDict_Contains(kwds, key_defaultValue)) {
                    value = PyDict_GetItem(kwds, key_defaultValue);
                    if (value && pyArgs[3]) {
                        errInfo = key_defaultValue;
                        Py_INCREF(errInfo);
                        goto Sbk_QCommandLineOption_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3]))))
                            goto Sbk_QCommandLineOption_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_defaultValue);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QCommandLineOption_Init_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2 = QString();
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3 = QString();
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // QCommandLineOption(QString,QString,QString,QString)
                cptr = new ::QCommandLineOption(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 3: // QCommandLineOption(const QStringList & names)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QCommandLineOption_Init_TypeError;
            }
            ::QStringList cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QCommandLineOption(QStringList)
                cptr = new ::QCommandLineOption(cppArg0);
            }
            break;
        }
        case 4: // QCommandLineOption(const QStringList & names, const QString & description, const QString & valueName, const QString & defaultValue)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_valueName = Shiboken::String::createStaticString("valueName");
                if (PyDict_Contains(kwds, key_valueName)) {
                    value = PyDict_GetItem(kwds, key_valueName);
                    if (value && pyArgs[2]) {
                        errInfo = key_valueName;
                        Py_INCREF(errInfo);
                        goto Sbk_QCommandLineOption_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2]))))
                            goto Sbk_QCommandLineOption_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_valueName);
                }
                static PyObject *const key_defaultValue = Shiboken::String::createStaticString("defaultValue");
                if (PyDict_Contains(kwds, key_defaultValue)) {
                    value = PyDict_GetItem(kwds, key_defaultValue);
                    if (value && pyArgs[3]) {
                        errInfo = key_defaultValue;
                        Py_INCREF(errInfo);
                        goto Sbk_QCommandLineOption_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3]))))
                            goto Sbk_QCommandLineOption_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_defaultValue);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QCommandLineOption_Init_TypeError;
                }
            }
            ::QStringList cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2 = QString();
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3 = QString();
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // QCommandLineOption(QStringList,QString,QString,QString)
                cptr = new ::QCommandLineOption(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QCommandLineOption >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QCommandLineOption_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QCommandLineOption_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QCommandLineOptionFunc_defaultValues(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCommandLineOption *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEOPTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCommandLineOption.defaultValues";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultValues()const
            QStringList cppResult = const_cast<const ::QCommandLineOption *>(cppSelf)->defaultValues();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCommandLineOptionFunc_description(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCommandLineOption *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEOPTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCommandLineOption.description";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // description()const
            QString cppResult = const_cast<const ::QCommandLineOption *>(cppSelf)->description();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCommandLineOptionFunc_flags(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCommandLineOption *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEOPTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCommandLineOption.flags";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // flags()const
            QFlags<QCommandLineOption::Flag> cppResult = const_cast<const ::QCommandLineOption *>(cppSelf)->flags();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCOMMANDLINEOPTION_FLAG_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCommandLineOptionFunc_isHidden(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCommandLineOption *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEOPTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCommandLineOption.isHidden";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isHidden()const
            bool cppResult = const_cast<const ::QCommandLineOption *>(cppSelf)->isHidden();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCommandLineOptionFunc_names(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCommandLineOption *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEOPTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCommandLineOption.names";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // names()const
            QStringList cppResult = const_cast<const ::QCommandLineOption *>(cppSelf)->names();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCommandLineOptionFunc_setDefaultValue(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCommandLineOption *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEOPTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCommandLineOption.setDefaultValue";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCommandLineOption::setDefaultValue(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setDefaultValue(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCommandLineOptionFunc_setDefaultValue_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDefaultValue(QString)
            cppSelf->setDefaultValue(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCommandLineOptionFunc_setDefaultValue_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCommandLineOptionFunc_setDefaultValues(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCommandLineOption *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEOPTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCommandLineOption.setDefaultValues";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCommandLineOption::setDefaultValues(QStringList)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArg)))) {
        overloadId = 0; // setDefaultValues(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCommandLineOptionFunc_setDefaultValues_TypeError;

    // Call function/method
    {
        ::QStringList cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDefaultValues(QStringList)
            cppSelf->setDefaultValues(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCommandLineOptionFunc_setDefaultValues_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCommandLineOptionFunc_setDescription(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCommandLineOption *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEOPTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCommandLineOption.setDescription";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCommandLineOption::setDescription(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setDescription(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCommandLineOptionFunc_setDescription_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDescription(QString)
            cppSelf->setDescription(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCommandLineOptionFunc_setDescription_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCommandLineOptionFunc_setFlags(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCommandLineOption *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEOPTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCommandLineOption.setFlags";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCommandLineOption::setFlags(QFlags<QCommandLineOption::Flag>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCOMMANDLINEOPTION_FLAG_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setFlags(QFlags<QCommandLineOption::Flag>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCommandLineOptionFunc_setFlags_TypeError;

    // Call function/method
    {
        ::QFlags<QCommandLineOption::Flag> cppArg0 = QFlags<QCommandLineOption::Flag>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFlags(QFlags<QCommandLineOption::Flag>)
            cppSelf->setFlags(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCommandLineOptionFunc_setFlags_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCommandLineOptionFunc_setHidden(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCommandLineOption *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEOPTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCommandLineOption.setHidden";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCommandLineOption::setHidden(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setHidden(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCommandLineOptionFunc_setHidden_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setHidden(bool)
            cppSelf->setHidden(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCommandLineOptionFunc_setHidden_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCommandLineOptionFunc_setValueName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCommandLineOption *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEOPTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCommandLineOption.setValueName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCommandLineOption::setValueName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setValueName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCommandLineOptionFunc_setValueName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setValueName(QString)
            cppSelf->setValueName(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCommandLineOptionFunc_setValueName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCommandLineOptionFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCommandLineOption *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEOPTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCommandLineOption.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCommandLineOption::swap(QCommandLineOption&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEOPTION_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QCommandLineOption&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCommandLineOptionFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QCommandLineOption *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // swap(QCommandLineOption&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCommandLineOptionFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCommandLineOptionFunc_valueName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCommandLineOption *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEOPTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QCommandLineOption.valueName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // valueName()const
            QString cppResult = const_cast<const ::QCommandLineOption *>(cppSelf)->valueName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QCommandLineOption_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QCommandLineOption_methods[] = {
    {"defaultValues", reinterpret_cast<PyCFunction>(Sbk_QCommandLineOptionFunc_defaultValues), METH_NOARGS},
    {"description", reinterpret_cast<PyCFunction>(Sbk_QCommandLineOptionFunc_description), METH_NOARGS},
    {"flags", reinterpret_cast<PyCFunction>(Sbk_QCommandLineOptionFunc_flags), METH_NOARGS},
    {"isHidden", reinterpret_cast<PyCFunction>(Sbk_QCommandLineOptionFunc_isHidden), METH_NOARGS},
    {"names", reinterpret_cast<PyCFunction>(Sbk_QCommandLineOptionFunc_names), METH_NOARGS},
    {"setDefaultValue", reinterpret_cast<PyCFunction>(Sbk_QCommandLineOptionFunc_setDefaultValue), METH_O},
    {"setDefaultValues", reinterpret_cast<PyCFunction>(Sbk_QCommandLineOptionFunc_setDefaultValues), METH_O},
    {"setDescription", reinterpret_cast<PyCFunction>(Sbk_QCommandLineOptionFunc_setDescription), METH_O},
    {"setFlags", reinterpret_cast<PyCFunction>(Sbk_QCommandLineOptionFunc_setFlags), METH_O},
    {"setHidden", reinterpret_cast<PyCFunction>(Sbk_QCommandLineOptionFunc_setHidden), METH_O},
    {"setValueName", reinterpret_cast<PyCFunction>(Sbk_QCommandLineOptionFunc_setValueName), METH_O},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QCommandLineOptionFunc_swap), METH_O},
    {"valueName", reinterpret_cast<PyCFunction>(Sbk_QCommandLineOptionFunc_valueName), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QCommandLineOption_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QCommandLineOption_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QCommandLineOption_Type = nullptr;
static SbkObjectType *Sbk_QCommandLineOption_TypeF(void)
{
    return _Sbk_QCommandLineOption_Type;
}

static PyType_Slot Sbk_QCommandLineOption_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QCommandLineOption_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QCommandLineOption_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QCommandLineOption_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QCommandLineOption_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QCommandLineOption_spec = {
    "2:PySide2.QtCore.QCommandLineOption",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QCommandLineOption_slots
};

} //extern "C"

PyObject *SbkPySide2_QtCore_QCommandLineOption_Flag___and__(PyObject *self, PyObject *pyArg)
{
    ::QCommandLineOption::Flags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QCommandLineOption::Flags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QCommandLineOption::Flags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QCommandLineOption::Flags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QCommandLineOption::Flags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCOMMANDLINEOPTION_FLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QCommandLineOption_Flag___or__(PyObject *self, PyObject *pyArg)
{
    ::QCommandLineOption::Flags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QCommandLineOption::Flags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QCommandLineOption::Flags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QCommandLineOption::Flags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QCommandLineOption::Flags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCOMMANDLINEOPTION_FLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QCommandLineOption_Flag___xor__(PyObject *self, PyObject *pyArg)
{
    ::QCommandLineOption::Flags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QCommandLineOption::Flags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QCommandLineOption::Flags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QCommandLineOption::Flags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QCommandLineOption::Flags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCOMMANDLINEOPTION_FLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtCore_QCommandLineOption_Flag___invert__(PyObject *self, PyObject *pyArg)
{
    ::QCommandLineOption::Flags cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCOMMANDLINEOPTION_FLAG_IDX])->converter, self, &cppSelf);
    ::QCommandLineOption::Flags cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCOMMANDLINEOPTION_FLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtCore_QCommandLineOption_Flag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCOMMANDLINEOPTION_FLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtCore_QCommandLineOption_Flag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCOMMANDLINEOPTION_FLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtCore_QCommandLineOption_Flag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtCore_QCommandLineOption_Flag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtCore_QCommandLineOption_Flag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_QCommandLineOption_Flag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtCore_QCommandLineOption_Flag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtCore_QCommandLineOption_Flag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtCore_QCommandLineOption_Flag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtCore_QCommandLineOption_Flag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtCore_QCommandLineOption_Flag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtCore_QCommandLineOption_Flag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtCore_QCommandLineOption_Flag_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QCommandLineOption_Flag_PythonToCpp_QCommandLineOption_Flag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCommandLineOption::Flag *>(cppOut) =
        static_cast<::QCommandLineOption::Flag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QCommandLineOption_Flag_PythonToCpp_QCommandLineOption_Flag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEOPTION_FLAG_IDX]))
        return QCommandLineOption_Flag_PythonToCpp_QCommandLineOption_Flag;
    return {};
}
static PyObject *QCommandLineOption_Flag_CppToPython_QCommandLineOption_Flag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QCommandLineOption::Flag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEOPTION_FLAG_IDX], castCppIn);

}

static void QFlags_QCommandLineOption_Flag__PythonToCpp_QFlags_QCommandLineOption_Flag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QCommandLineOption::Flag> *>(cppOut) =
        ::QFlags<QCommandLineOption::Flag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QCommandLineOption_Flag__PythonToCpp_QFlags_QCommandLineOption_Flag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCOMMANDLINEOPTION_FLAG_IDX]))
        return QFlags_QCommandLineOption_Flag__PythonToCpp_QFlags_QCommandLineOption_Flag_;
    return {};
}
static PyObject *QFlags_QCommandLineOption_Flag__CppToPython_QFlags_QCommandLineOption_Flag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QCommandLineOption::Flag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCOMMANDLINEOPTION_FLAG_IDX]));

}

static void QCommandLineOption_Flag_PythonToCpp_QFlags_QCommandLineOption_Flag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QCommandLineOption::Flag> *>(cppOut) =
        ::QFlags<QCommandLineOption::Flag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QCommandLineOption_Flag_PythonToCpp_QFlags_QCommandLineOption_Flag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEOPTION_FLAG_IDX]))
        return QCommandLineOption_Flag_PythonToCpp_QFlags_QCommandLineOption_Flag_;
    return {};
}
static void number_PythonToCpp_QFlags_QCommandLineOption_Flag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QCommandLineOption::Flag> *>(cppOut) =
        ::QFlags<QCommandLineOption::Flag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QCommandLineOption_Flag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEOPTION_FLAG_IDX]))
        return number_PythonToCpp_QFlags_QCommandLineOption_Flag_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QCommandLineOption_PythonToCpp_QCommandLineOption_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QCommandLineOption_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QCommandLineOption_PythonToCpp_QCommandLineOption_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QCommandLineOption_TypeF())))
        return QCommandLineOption_PythonToCpp_QCommandLineOption_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QCommandLineOption_PTR_CppToPython_QCommandLineOption(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QCommandLineOption *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QCommandLineOption_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QCommandLineOption_SignatureStrings[] = {
    "4:PySide2.QtCore.QCommandLineOption(self,other:PySide2.QtCore.QCommandLineOption)",
    "3:PySide2.QtCore.QCommandLineOption(self,name:QString)",
    "2:PySide2.QtCore.QCommandLineOption(self,name:QString,description:QString,valueName:QString=QString(),defaultValue:QString=QString())",
    "1:PySide2.QtCore.QCommandLineOption(self,names:QStringList)",
    "0:PySide2.QtCore.QCommandLineOption(self,names:QStringList,description:QString,valueName:QString=QString(),defaultValue:QString=QString())",
    "PySide2.QtCore.QCommandLineOption.defaultValues(self)->QStringList",
    "PySide2.QtCore.QCommandLineOption.description(self)->QString",
    "PySide2.QtCore.QCommandLineOption.flags(self)->PySide2.QtCore.QCommandLineOption.Flags",
    "PySide2.QtCore.QCommandLineOption.isHidden(self)->bool",
    "PySide2.QtCore.QCommandLineOption.names(self)->QStringList",
    "PySide2.QtCore.QCommandLineOption.setDefaultValue(self,defaultValue:QString)",
    "PySide2.QtCore.QCommandLineOption.setDefaultValues(self,defaultValues:QStringList)",
    "PySide2.QtCore.QCommandLineOption.setDescription(self,description:QString)",
    "PySide2.QtCore.QCommandLineOption.setFlags(self,aflags:PySide2.QtCore.QCommandLineOption.Flags)",
    "PySide2.QtCore.QCommandLineOption.setHidden(self,hidden:bool)",
    "PySide2.QtCore.QCommandLineOption.setValueName(self,name:QString)",
    "PySide2.QtCore.QCommandLineOption.swap(self,other:PySide2.QtCore.QCommandLineOption)",
    "PySide2.QtCore.QCommandLineOption.valueName(self)->QString",
    nullptr}; // Sentinel

void init_QCommandLineOption(PyObject *module)
{
    _Sbk_QCommandLineOption_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QCommandLineOption",
        "QCommandLineOption*",
        &Sbk_QCommandLineOption_spec,
        &Shiboken::callCppDestructor< ::QCommandLineOption >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QCommandLineOption_Type);
    InitSignatureStrings(pyType, QCommandLineOption_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QCommandLineOption_Type), Sbk_QCommandLineOption_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEOPTION_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QCommandLineOption_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QCommandLineOption_TypeF(),
        QCommandLineOption_PythonToCpp_QCommandLineOption_PTR,
        is_QCommandLineOption_PythonToCpp_QCommandLineOption_PTR_Convertible,
        QCommandLineOption_PTR_CppToPython_QCommandLineOption);

    Shiboken::Conversions::registerConverterName(converter, "QCommandLineOption");
    Shiboken::Conversions::registerConverterName(converter, "QCommandLineOption*");
    Shiboken::Conversions::registerConverterName(converter, "QCommandLineOption&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QCommandLineOption).name());


    // Initialization of enums.

    // Initialization of enum 'Flag'.
    SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCOMMANDLINEOPTION_FLAG_IDX] = PySide::QFlags::create("2:PySide2.QtCore.QCommandLineOption.Flags", SbkPySide2_QtCore_QCommandLineOption_Flag_number_slots);
    SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEOPTION_FLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QCommandLineOption_TypeF(),
        "Flag",
        "2:PySide2.QtCore.QCommandLineOption.Flag",
        "QCommandLineOption::Flag",
        SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCOMMANDLINEOPTION_FLAG_IDX]);
    if (!SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEOPTION_FLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEOPTION_FLAG_IDX],
        Sbk_QCommandLineOption_TypeF(), "HiddenFromHelp", (long) QCommandLineOption::Flag::HiddenFromHelp))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEOPTION_FLAG_IDX],
        Sbk_QCommandLineOption_TypeF(), "ShortOptionStyle", (long) QCommandLineOption::Flag::ShortOptionStyle))
        return;
    // Register converter for enum 'QCommandLineOption::Flag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEOPTION_FLAG_IDX],
            QCommandLineOption_Flag_CppToPython_QCommandLineOption_Flag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QCommandLineOption_Flag_PythonToCpp_QCommandLineOption_Flag,
            is_QCommandLineOption_Flag_PythonToCpp_QCommandLineOption_Flag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QCOMMANDLINEOPTION_FLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QCommandLineOption::Flag");
        Shiboken::Conversions::registerConverterName(converter, "Flag");
    }
    // Register converter for flag 'QFlags<QCommandLineOption::Flag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCOMMANDLINEOPTION_FLAG_IDX],
            QFlags_QCommandLineOption_Flag__CppToPython_QFlags_QCommandLineOption_Flag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QCommandLineOption_Flag_PythonToCpp_QFlags_QCommandLineOption_Flag_,
            is_QCommandLineOption_Flag_PythonToCpp_QFlags_QCommandLineOption_Flag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QCommandLineOption_Flag__PythonToCpp_QFlags_QCommandLineOption_Flag_,
            is_QFlags_QCommandLineOption_Flag__PythonToCpp_QFlags_QCommandLineOption_Flag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QCommandLineOption_Flag_,
            is_number_PythonToCpp_QFlags_QCommandLineOption_Flag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QCOMMANDLINEOPTION_FLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QCommandLineOption::Flags");
        Shiboken::Conversions::registerConverterName(converter, "Flags");
    }
    // End of 'Flag' enum/flags.

    qRegisterMetaType< ::QCommandLineOption::Flag >("QCommandLineOption::Flag");
    qRegisterMetaType< ::QCommandLineOption::Flags >("QCommandLineOption::Flags");
}
