/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qdatetime_wrapper.h"

// inner classes

// Extra includes
#include <datetime.h>
#include <qcalendar.h>
#include <qdatetime.h>
#include <qtimezone.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Begin code injection
// TEMPLATE - pydatetime_importandcheck_function - START
#ifdef IS_PY3K
#define PySideDateTime_IMPORT PyDateTime_IMPORT
#else
#define PySideDateTime_IMPORT \
            (PyDateTimeAPI = (PyDateTime_CAPI*) PyCObject_Import((char*)"datetime", \
                                                             (char*)"datetime_CAPI"))
#endif
static bool PyDateTime_ImportAndCheck(PyObject *pyIn) {
    if (!PyDateTimeAPI) PySideDateTime_IMPORT;
    return PyDateTime_Check(pyIn);
}
// TEMPLATE - pydatetime_importandcheck_function - END

// End of code injection



// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QDateTime_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QDateTime >()))
        return -1;

    ::QDateTime *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 8) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QDateTime_Init_TypeError;
    } else if (numArgs == 5)
        goto Sbk_QDateTime_Init_TypeError;

    if (!PyArg_ParseTuple(args, "|OOOOOOOO:QDateTime", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7])))
        return -1;


    // Overloaded function decisor
    // 0: QDateTime::QDateTime()
    // 1: QDateTime::QDateTime(QDate)
    // 2: QDateTime::QDateTime(QDate,QTime,Qt::TimeSpec)
    // 3: QDateTime::QDateTime(QDate,QTime,Qt::TimeSpec,int)
    // 4: QDateTime::QDateTime(QDate,QTime,QTimeZone)
    // 5: QDateTime::QDateTime(QDateTime)
    // 6: QDateTime::QDateTime(int,int,int,int,int,int)
    // 7: QDateTime::QDateTime(int,int,int,int,int,int,int,int)
    if (numArgs == 0) {
        overloadId = 0; // QDateTime()
    } else if (numArgs >= 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))) {
        if (numArgs == 6) {
            overloadId = 6; // QDateTime(int,int,int,int,int,int)
        } else if (numArgs >= 7
            && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))) {
            if (numArgs == 7) {
                overloadId = 7; // QDateTime(int,int,int,int,int,int,int,int)
            } else if (numArgs >= 8
                && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[7])))) {
                overloadId = 7; // QDateTime(int,int,int,int,int,int,int,int)
            }
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), (pyArgs[0])))) {
        overloadId = 5; // QDateTime(QDateTime)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // QDateTime(QDate)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 2; // QDateTime(QDate,QTime,Qt::TimeSpec)
            } else if (numArgs == 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX]), (pyArgs[2])))) {
                overloadId = 4; // QDateTime(QDate,QTime,QTimeZone)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TIMESPEC_IDX])->converter, (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 2; // QDateTime(QDate,QTime,Qt::TimeSpec)
                } else if (numArgs == 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
                    overloadId = 3; // QDateTime(QDate,QTime,Qt::TimeSpec,int)
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateTime_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QDateTime()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QDateTime_Init_TypeError;
            }

            if (!PyErr_Occurred()) {
                // QDateTime()
                cptr = new ::QDateTime();
            }
            break;
        }
        case 1: // QDateTime(const QDate & arg__1)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QDateTime_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QDate cppArg0_local;
            ::QDate *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QDateTime(QDate)
                cptr = new ::QDateTime(*cppArg0);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QDateTime.QDateTime(const QDate & arg__1) is deprecated", 1);
            break;
        }
        case 2: // QDateTime(const QDate & arg__1, const QTime & arg__2, Qt::TimeSpec spec)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_spec = Shiboken::String::createStaticString("spec");
                if (PyDict_Contains(kwds, key_spec)) {
                    value = PyDict_GetItem(kwds, key_spec);
                    if (value && pyArgs[2]) {
                        errInfo = key_spec;
                        Py_INCREF(errInfo);
                        goto Sbk_QDateTime_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TIMESPEC_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QDateTime_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_spec);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QDateTime_Init_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QDate cppArg0_local;
            ::QDate *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QTime cppArg1_local;
            ::QTime *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            ::Qt::TimeSpec cppArg2 = Qt::LocalTime;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // QDateTime(QDate,QTime,Qt::TimeSpec)
                cptr = new ::QDateTime(*cppArg0, *cppArg1, cppArg2);
            }
            break;
        }
        case 3: // QDateTime(const QDate & date, const QTime & time, Qt::TimeSpec spec, int offsetSeconds)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QDateTime_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QDate cppArg0_local;
            ::QDate *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QTime cppArg1_local;
            ::QTime *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            ::Qt::TimeSpec cppArg2{Qt::LocalTime};
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // QDateTime(QDate,QTime,Qt::TimeSpec,int)
                cptr = new ::QDateTime(*cppArg0, *cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 4: // QDateTime(const QDate & date, const QTime & time, const QTimeZone & timeZone)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QDateTime_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QDate cppArg0_local;
            ::QDate *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QTime cppArg1_local;
            ::QTime *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QTimeZone cppArg2_local;
            ::QTimeZone *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);


            if (!PyErr_Occurred()) {
                // QDateTime(QDate,QTime,QTimeZone)
                cptr = new ::QDateTime(*cppArg0, *cppArg1, *cppArg2);
            }
            break;
        }
        case 5: // QDateTime(const QDateTime & other)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QDateTime_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QDateTime cppArg0_local;
            ::QDateTime *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QDateTime(QDateTime)
                cptr = new ::QDateTime(*cppArg0);
            }
            break;
        }
        case 6: // QDateTime(int arg__1, int arg__2, int arg__3, int arg__4, int arg__5, int arg__6)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QDateTime_Init_TypeError;
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            SBK_UNUSED(cppArg0)
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            SBK_UNUSED(cppArg1)
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            SBK_UNUSED(cppArg2)
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            SBK_UNUSED(cppArg3)
            int cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            SBK_UNUSED(cppArg4)
            int cppArg5;
            pythonToCpp[5](pyArgs[5], &cppArg5);
            SBK_UNUSED(cppArg5)

            if (!PyErr_Occurred()) {
                // QDateTime(int,int,int,int,int,int)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtcore.cpp (qdatetime-2)]
                QDate date(cppArg0, cppArg1, cppArg2);
                QTime time(cppArg3, cppArg4, cppArg5);
                cptr = new QDateTime(date, time);
                // END of custom code block [file: ../glue/qtcore.cpp (qdatetime-2)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
        case 7: // QDateTime(int arg__1, int arg__2, int arg__3, int arg__4, int arg__5, int arg__6, int arg__7, int arg__8)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_arg__8 = Shiboken::String::createStaticString("arg__8");
                if (PyDict_Contains(kwds, key_arg__8)) {
                    value = PyDict_GetItem(kwds, key_arg__8);
                    if (value && pyArgs[7]) {
                        errInfo = key_arg__8;
                        Py_INCREF(errInfo);
                        goto Sbk_QDateTime_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[7] = value;
                        if (!(pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[7]))))
                            goto Sbk_QDateTime_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_arg__8);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QDateTime_Init_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            SBK_UNUSED(cppArg0)
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            SBK_UNUSED(cppArg1)
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            SBK_UNUSED(cppArg2)
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            SBK_UNUSED(cppArg3)
            int cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            SBK_UNUSED(cppArg4)
            int cppArg5;
            pythonToCpp[5](pyArgs[5], &cppArg5);
            SBK_UNUSED(cppArg5)
            int cppArg6;
            pythonToCpp[6](pyArgs[6], &cppArg6);
            SBK_UNUSED(cppArg6)
            int cppArg7 = Qt::LocalTime;
            if (pythonToCpp[7]) pythonToCpp[7](pyArgs[7], &cppArg7);
            SBK_UNUSED(cppArg7)

            if (!PyErr_Occurred()) {
                // QDateTime(int,int,int,int,int,int,int,int)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtcore.cpp (qdatetime-1)]
                QDate date(cppArg0, cppArg1, cppArg2);
                QTime time(cppArg3, cppArg4, cppArg5, cppArg6);
                cptr = new QDateTime(date, time, Qt::TimeSpec(cppArg7));
                // END of custom code block [file: ../glue/qtcore.cpp (qdatetime-1)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QDateTime >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QDateTime_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QDateTime_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QDateTimeFunc___reduce__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.__reduce__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // __reduce__()
            // Begin code injection
            // TEMPLATE - reduce_code - START
            pyResult = Py_BuildValue("(N(iiiiiiii))", PyObject_Type(self), cppSelf->date().year(), cppSelf->date().month(), cppSelf->date().day(), cppSelf->time().hour(), cppSelf->time().minute(), cppSelf->time().second(), cppSelf->time().msec(), (int)cppSelf->timeSpec());
            // TEMPLATE - reduce_code - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDateTimeFunc___repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.__repr__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // __repr__()
            // Begin code injection
            // TEMPLATE - repr_code - START
            QString format = QString::asprintf("%s(%i, %i, %i, %i, %i, %i, %i, %i)",
                Py_TYPE(self)->tp_name, cppSelf->date().year(), cppSelf->date().month(), cppSelf->date().day(), cppSelf->time().hour(), cppSelf->time().minute(), cppSelf->time().second(), cppSelf->time().msec(), (int)cppSelf->timeSpec());
            pyResult = Shiboken::String::fromCString(qPrintable(format));
            // TEMPLATE - repr_code - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDateTimeFunc_addDays(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.addDays";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDateTime::addDays(qint64)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // addDays(qint64)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateTimeFunc_addDays_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // addDays(qint64)const
            QDateTime cppResult = const_cast<const ::QDateTime *>(cppSelf)->addDays(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDateTimeFunc_addDays_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateTimeFunc_addMSecs(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.addMSecs";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDateTime::addMSecs(qint64)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // addMSecs(qint64)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateTimeFunc_addMSecs_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // addMSecs(qint64)const
            QDateTime cppResult = const_cast<const ::QDateTime *>(cppSelf)->addMSecs(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDateTimeFunc_addMSecs_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateTimeFunc_addMonths(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.addMonths";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDateTime::addMonths(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // addMonths(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateTimeFunc_addMonths_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // addMonths(int)const
            QDateTime cppResult = const_cast<const ::QDateTime *>(cppSelf)->addMonths(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDateTimeFunc_addMonths_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateTimeFunc_addSecs(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.addSecs";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDateTime::addSecs(qint64)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // addSecs(qint64)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateTimeFunc_addSecs_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // addSecs(qint64)const
            QDateTime cppResult = const_cast<const ::QDateTime *>(cppSelf)->addSecs(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDateTimeFunc_addSecs_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateTimeFunc_addYears(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.addYears";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDateTime::addYears(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // addYears(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateTimeFunc_addYears_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // addYears(int)const
            QDateTime cppResult = const_cast<const ::QDateTime *>(cppSelf)->addYears(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDateTimeFunc_addYears_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateTimeFunc_currentDateTime(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.currentDateTime";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentDateTime()
            QDateTime cppResult = ::QDateTime::currentDateTime();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDateTimeFunc_currentDateTimeUtc(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.currentDateTimeUtc";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentDateTimeUtc()
            QDateTime cppResult = ::QDateTime::currentDateTimeUtc();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDateTimeFunc_currentMSecsSinceEpoch(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.currentMSecsSinceEpoch";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentMSecsSinceEpoch()
            qint64 cppResult = ::QDateTime::currentMSecsSinceEpoch();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDateTimeFunc_currentSecsSinceEpoch(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.currentSecsSinceEpoch";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentSecsSinceEpoch()
            qint64 cppResult = ::QDateTime::currentSecsSinceEpoch();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDateTimeFunc_date(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.date";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // date()const
            QDate cppResult = const_cast<const ::QDateTime *>(cppSelf)->date();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDateTimeFunc_daysTo(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.daysTo";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDateTime::daysTo(QDateTime)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), (pyArg)))) {
        overloadId = 0; // daysTo(QDateTime)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateTimeFunc_daysTo_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QDateTime cppArg0_local;
        ::QDateTime *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // daysTo(QDateTime)const
            qint64 cppResult = const_cast<const ::QDateTime *>(cppSelf)->daysTo(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDateTimeFunc_daysTo_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateTimeFunc_fromMSecsSinceEpoch(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.fromMSecsSinceEpoch";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QDateTimeFunc_fromMSecsSinceEpoch_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QDateTimeFunc_fromMSecsSinceEpoch_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:fromMSecsSinceEpoch", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: static QDateTime::fromMSecsSinceEpoch(qint64)
    // 1: static QDateTime::fromMSecsSinceEpoch(qint64,Qt::TimeSpec,int)
    // 2: static QDateTime::fromMSecsSinceEpoch(qint64,QTimeZone)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // fromMSecsSinceEpoch(qint64)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX]), (pyArgs[1])))) {
            overloadId = 2; // fromMSecsSinceEpoch(qint64,QTimeZone)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TIMESPEC_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // fromMSecsSinceEpoch(qint64,Qt::TimeSpec,int)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
                overloadId = 1; // fromMSecsSinceEpoch(qint64,Qt::TimeSpec,int)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateTimeFunc_fromMSecsSinceEpoch_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // fromMSecsSinceEpoch(qint64 msecs)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QDateTimeFunc_fromMSecsSinceEpoch_TypeError;
            }
            qint64 cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // fromMSecsSinceEpoch(qint64)
                QDateTime cppResult = ::QDateTime::fromMSecsSinceEpoch(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
            }
            break;
        }
        case 1: // fromMSecsSinceEpoch(qint64 msecs, Qt::TimeSpec spec, int offsetFromUtc)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_offsetFromUtc = Shiboken::String::createStaticString("offsetFromUtc");
                if (PyDict_Contains(kwds, key_offsetFromUtc)) {
                    value = PyDict_GetItem(kwds, key_offsetFromUtc);
                    if (value && pyArgs[2]) {
                        errInfo = key_offsetFromUtc;
                        Py_INCREF(errInfo);
                        goto Sbk_QDateTimeFunc_fromMSecsSinceEpoch_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                            goto Sbk_QDateTimeFunc_fromMSecsSinceEpoch_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_offsetFromUtc);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QDateTimeFunc_fromMSecsSinceEpoch_TypeError;
                }
            }
            qint64 cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::Qt::TimeSpec cppArg1{Qt::LocalTime};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2 = 0;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // fromMSecsSinceEpoch(qint64,Qt::TimeSpec,int)
                QDateTime cppResult = ::QDateTime::fromMSecsSinceEpoch(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
            }
            break;
        }
        case 2: // fromMSecsSinceEpoch(qint64 msecs, const QTimeZone & timeZone)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QDateTimeFunc_fromMSecsSinceEpoch_TypeError;
            }
            qint64 cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QTimeZone cppArg1_local;
            ::QTimeZone *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // fromMSecsSinceEpoch(qint64,QTimeZone)
                QDateTime cppResult = ::QDateTime::fromMSecsSinceEpoch(cppArg0, *cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDateTimeFunc_fromMSecsSinceEpoch_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateTimeFunc_fromSecsSinceEpoch(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.fromSecsSinceEpoch";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QDateTimeFunc_fromSecsSinceEpoch_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QDateTimeFunc_fromSecsSinceEpoch_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:fromSecsSinceEpoch", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: static QDateTime::fromSecsSinceEpoch(qint64,Qt::TimeSpec,int)
    // 1: static QDateTime::fromSecsSinceEpoch(qint64,QTimeZone)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // fromSecsSinceEpoch(qint64,Qt::TimeSpec,int)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX]), (pyArgs[1])))) {
            overloadId = 1; // fromSecsSinceEpoch(qint64,QTimeZone)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TIMESPEC_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // fromSecsSinceEpoch(qint64,Qt::TimeSpec,int)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
                overloadId = 0; // fromSecsSinceEpoch(qint64,Qt::TimeSpec,int)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateTimeFunc_fromSecsSinceEpoch_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // fromSecsSinceEpoch(qint64 secs, Qt::TimeSpec spe, int offsetFromUtc)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_spe = Shiboken::String::createStaticString("spe");
                if (PyDict_Contains(kwds, key_spe)) {
                    value = PyDict_GetItem(kwds, key_spe);
                    if (value && pyArgs[1]) {
                        errInfo = key_spe;
                        Py_INCREF(errInfo);
                        goto Sbk_QDateTimeFunc_fromSecsSinceEpoch_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TIMESPEC_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QDateTimeFunc_fromSecsSinceEpoch_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_spe);
                }
                static PyObject *const key_offsetFromUtc = Shiboken::String::createStaticString("offsetFromUtc");
                if (PyDict_Contains(kwds, key_offsetFromUtc)) {
                    value = PyDict_GetItem(kwds, key_offsetFromUtc);
                    if (value && pyArgs[2]) {
                        errInfo = key_offsetFromUtc;
                        Py_INCREF(errInfo);
                        goto Sbk_QDateTimeFunc_fromSecsSinceEpoch_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                            goto Sbk_QDateTimeFunc_fromSecsSinceEpoch_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_offsetFromUtc);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QDateTimeFunc_fromSecsSinceEpoch_TypeError;
                }
            }
            qint64 cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::Qt::TimeSpec cppArg1 = Qt::LocalTime;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2 = 0;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // fromSecsSinceEpoch(qint64,Qt::TimeSpec,int)
                QDateTime cppResult = ::QDateTime::fromSecsSinceEpoch(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
            }
            break;
        }
        case 1: // fromSecsSinceEpoch(qint64 secs, const QTimeZone & timeZone)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QDateTimeFunc_fromSecsSinceEpoch_TypeError;
            }
            qint64 cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QTimeZone cppArg1_local;
            ::QTimeZone *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // fromSecsSinceEpoch(qint64,QTimeZone)
                QDateTime cppResult = ::QDateTime::fromSecsSinceEpoch(cppArg0, *cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDateTimeFunc_fromSecsSinceEpoch_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateTimeFunc_fromString(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.fromString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QDateTimeFunc_fromString_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QDateTimeFunc_fromString_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:fromString", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: static QDateTime::fromString(QString,Qt::DateFormat)
    // 1: static QDateTime::fromString(QString,QString)
    // 2: static QDateTime::fromString(QString,QString,QCalendar)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // fromString(QString,Qt::DateFormat)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // fromString(QString,QString)
            } else if (numArgs == 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX]), (pyArgs[2])))) {
                overloadId = 2; // fromString(QString,QString,QCalendar)
            }
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_DATEFORMAT_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // fromString(QString,Qt::DateFormat)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateTimeFunc_fromString_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // fromString(const QString & s, Qt::DateFormat f)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_f = Shiboken::String::createStaticString("f");
                if (PyDict_Contains(kwds, key_f)) {
                    value = PyDict_GetItem(kwds, key_f);
                    if (value && pyArgs[1]) {
                        errInfo = key_f;
                        Py_INCREF(errInfo);
                        goto Sbk_QDateTimeFunc_fromString_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_DATEFORMAT_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QDateTimeFunc_fromString_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_f);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QDateTimeFunc_fromString_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::Qt::DateFormat cppArg1 = Qt::TextDate;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // fromString(QString,Qt::DateFormat)
                QDateTime cppResult = ::QDateTime::fromString(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
            }
            break;
        }
        case 1: // fromString(const QString & s, const QString & format)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QDateTimeFunc_fromString_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // fromString(QString,QString)
                QDateTime cppResult = ::QDateTime::fromString(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
            }
            break;
        }
        case 2: // fromString(const QString & s, const QString & format, QCalendar cal)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QDateTimeFunc_fromString_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QCalendar cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // fromString(QString,QString,QCalendar)
                QDateTime cppResult = ::QDateTime::fromString(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDateTimeFunc_fromString_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateTimeFunc_fromTime_t(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.fromTime_t";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QDateTimeFunc_fromTime_t_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QDateTimeFunc_fromTime_t_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:fromTime_t", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: static QDateTime::fromTime_t(uint)
    // 1: static QDateTime::fromTime_t(uint,Qt::TimeSpec,int)
    // 2: static QDateTime::fromTime_t(uint,QTimeZone)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // fromTime_t(uint)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX]), (pyArgs[1])))) {
            overloadId = 2; // fromTime_t(uint,QTimeZone)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TIMESPEC_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // fromTime_t(uint,Qt::TimeSpec,int)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
                overloadId = 1; // fromTime_t(uint,Qt::TimeSpec,int)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateTimeFunc_fromTime_t_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // fromTime_t(uint secsSince1Jan1970UTC)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QDateTimeFunc_fromTime_t_TypeError;
            }
            uint cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // fromTime_t(uint)
                QDateTime cppResult = ::QDateTime::fromTime_t(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
            }
            break;
        }
        case 1: // fromTime_t(uint secsSince1Jan1970UTC, Qt::TimeSpec spec, int offsetFromUtc)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_offsetFromUtc = Shiboken::String::createStaticString("offsetFromUtc");
                if (PyDict_Contains(kwds, key_offsetFromUtc)) {
                    value = PyDict_GetItem(kwds, key_offsetFromUtc);
                    if (value && pyArgs[2]) {
                        errInfo = key_offsetFromUtc;
                        Py_INCREF(errInfo);
                        goto Sbk_QDateTimeFunc_fromTime_t_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                            goto Sbk_QDateTimeFunc_fromTime_t_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_offsetFromUtc);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QDateTimeFunc_fromTime_t_TypeError;
                }
            }
            uint cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::Qt::TimeSpec cppArg1{Qt::LocalTime};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2 = 0;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // fromTime_t(uint,Qt::TimeSpec,int)
                QDateTime cppResult = ::QDateTime::fromTime_t(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
            }
            break;
        }
        case 2: // fromTime_t(uint secsSince1Jan1970UTC, const QTimeZone & timeZone)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QDateTimeFunc_fromTime_t_TypeError;
            }
            uint cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QTimeZone cppArg1_local;
            ::QTimeZone *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // fromTime_t(uint,QTimeZone)
                QDateTime cppResult = ::QDateTime::fromTime_t(cppArg0, *cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDateTimeFunc_fromTime_t_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateTimeFunc_isDaylightTime(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.isDaylightTime";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isDaylightTime()const
            bool cppResult = const_cast<const ::QDateTime *>(cppSelf)->isDaylightTime();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDateTimeFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::QDateTime *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDateTimeFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QDateTime *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDateTimeFunc_msecsTo(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.msecsTo";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDateTime::msecsTo(QDateTime)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), (pyArg)))) {
        overloadId = 0; // msecsTo(QDateTime)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateTimeFunc_msecsTo_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QDateTime cppArg0_local;
        ::QDateTime *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // msecsTo(QDateTime)const
            qint64 cppResult = const_cast<const ::QDateTime *>(cppSelf)->msecsTo(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDateTimeFunc_msecsTo_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateTimeFunc_offsetFromUtc(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.offsetFromUtc";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // offsetFromUtc()const
            int cppResult = const_cast<const ::QDateTime *>(cppSelf)->offsetFromUtc();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDateTimeFunc_secsTo(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.secsTo";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDateTime::secsTo(QDateTime)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), (pyArg)))) {
        overloadId = 0; // secsTo(QDateTime)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateTimeFunc_secsTo_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QDateTime cppArg0_local;
        ::QDateTime *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // secsTo(QDateTime)const
            qint64 cppResult = const_cast<const ::QDateTime *>(cppSelf)->secsTo(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDateTimeFunc_secsTo_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateTimeFunc_setDate(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.setDate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDateTime::setDate(QDate)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), (pyArg)))) {
        overloadId = 0; // setDate(QDate)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateTimeFunc_setDate_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QDate cppArg0_local;
        ::QDate *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setDate(QDate)
            cppSelf->setDate(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDateTimeFunc_setDate_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateTimeFunc_setMSecsSinceEpoch(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.setMSecsSinceEpoch";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDateTime::setMSecsSinceEpoch(qint64)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // setMSecsSinceEpoch(qint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateTimeFunc_setMSecsSinceEpoch_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMSecsSinceEpoch(qint64)
            cppSelf->setMSecsSinceEpoch(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDateTimeFunc_setMSecsSinceEpoch_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateTimeFunc_setOffsetFromUtc(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.setOffsetFromUtc";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDateTime::setOffsetFromUtc(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setOffsetFromUtc(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateTimeFunc_setOffsetFromUtc_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setOffsetFromUtc(int)
            cppSelf->setOffsetFromUtc(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDateTimeFunc_setOffsetFromUtc_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateTimeFunc_setSecsSinceEpoch(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.setSecsSinceEpoch";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDateTime::setSecsSinceEpoch(qint64)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // setSecsSinceEpoch(qint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateTimeFunc_setSecsSinceEpoch_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSecsSinceEpoch(qint64)
            cppSelf->setSecsSinceEpoch(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDateTimeFunc_setSecsSinceEpoch_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateTimeFunc_setTime(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.setTime";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDateTime::setTime(QTime)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX]), (pyArg)))) {
        overloadId = 0; // setTime(QTime)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateTimeFunc_setTime_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTime cppArg0_local;
        ::QTime *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setTime(QTime)
            cppSelf->setTime(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDateTimeFunc_setTime_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateTimeFunc_setTimeSpec(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.setTimeSpec";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDateTime::setTimeSpec(Qt::TimeSpec)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TIMESPEC_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setTimeSpec(Qt::TimeSpec)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateTimeFunc_setTimeSpec_TypeError;

    // Call function/method
    {
        ::Qt::TimeSpec cppArg0{Qt::LocalTime};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTimeSpec(Qt::TimeSpec)
            cppSelf->setTimeSpec(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDateTimeFunc_setTimeSpec_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateTimeFunc_setTimeZone(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.setTimeZone";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDateTime::setTimeZone(QTimeZone)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX]), (pyArg)))) {
        overloadId = 0; // setTimeZone(QTimeZone)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateTimeFunc_setTimeZone_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTimeZone cppArg0_local;
        ::QTimeZone *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setTimeZone(QTimeZone)
            cppSelf->setTimeZone(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDateTimeFunc_setTimeZone_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateTimeFunc_setTime_t(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.setTime_t";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDateTime::setTime_t(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArg)))) {
        overloadId = 0; // setTime_t(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateTimeFunc_setTime_t_TypeError;

    // Call function/method
    {
        uint cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTime_t(uint)
            cppSelf->setTime_t(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDateTimeFunc_setTime_t_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateTimeFunc_setUtcOffset(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.setUtcOffset";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDateTime::setUtcOffset(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setUtcOffset(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateTimeFunc_setUtcOffset_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setUtcOffset(int)
            cppSelf->setUtcOffset(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDateTimeFunc_setUtcOffset_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateTimeFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDateTime::swap(QDateTime&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QDateTime&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateTimeFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QDateTime cppArg0_local;
        ::QDateTime *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QDateTime&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDateTimeFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateTimeFunc_time(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.time";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // time()const
            QTime cppResult = const_cast<const ::QDateTime *>(cppSelf)->time();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIME_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDateTimeFunc_timeSpec(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.timeSpec";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // timeSpec()const
            Qt::TimeSpec cppResult = const_cast<const ::QDateTime *>(cppSelf)->timeSpec();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TIMESPEC_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDateTimeFunc_timeZone(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.timeZone";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // timeZone()const
            QTimeZone cppResult = const_cast<const ::QDateTime *>(cppSelf)->timeZone();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDateTimeFunc_timeZoneAbbreviation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.timeZoneAbbreviation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // timeZoneAbbreviation()const
            QString cppResult = const_cast<const ::QDateTime *>(cppSelf)->timeZoneAbbreviation();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDateTimeFunc_toLocalTime(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.toLocalTime";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toLocalTime()const
            QDateTime cppResult = const_cast<const ::QDateTime *>(cppSelf)->toLocalTime();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDateTimeFunc_toMSecsSinceEpoch(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.toMSecsSinceEpoch";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toMSecsSinceEpoch()const
            qint64 cppResult = const_cast<const ::QDateTime *>(cppSelf)->toMSecsSinceEpoch();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDateTimeFunc_toOffsetFromUtc(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.toOffsetFromUtc";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDateTime::toOffsetFromUtc(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // toOffsetFromUtc(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateTimeFunc_toOffsetFromUtc_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // toOffsetFromUtc(int)const
            QDateTime cppResult = const_cast<const ::QDateTime *>(cppSelf)->toOffsetFromUtc(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDateTimeFunc_toOffsetFromUtc_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateTimeFunc_toPython(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.toPython";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toPython()
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qdatetime-topython)]
            QDate date = cppSelf->date();
            QTime time = cppSelf->time();
            if (!PyDateTimeAPI) PySideDateTime_IMPORT;
            pyResult = PyDateTime_FromDateAndTime(date.year(), date.month(), date.day(), time.hour(), time.minute(), time.second(), time.msec()*1000);
            // END of custom code block [file: ../glue/qtcore.cpp (qdatetime-topython)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDateTimeFunc_toSecsSinceEpoch(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.toSecsSinceEpoch";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toSecsSinceEpoch()const
            qint64 cppResult = const_cast<const ::QDateTime *>(cppSelf)->toSecsSinceEpoch();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDateTimeFunc_toString(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.toString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QDateTimeFunc_toString_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:toString", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QDateTime::toString(Qt::DateFormat)const
    // 1: QDateTime::toString(QString)const
    // 2: QDateTime::toString(QString,QCalendar)const
    if (numArgs == 0) {
        overloadId = 0; // toString(Qt::DateFormat)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // toString(QString)const
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCALENDAR_IDX]), (pyArgs[1])))) {
            overloadId = 2; // toString(QString,QCalendar)const
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_DATEFORMAT_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // toString(Qt::DateFormat)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateTimeFunc_toString_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // toString(Qt::DateFormat format) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_format = Shiboken::String::createStaticString("format");
                if (PyDict_Contains(kwds, key_format)) {
                    value = PyDict_GetItem(kwds, key_format);
                    if (value && pyArgs[0]) {
                        errInfo = key_format;
                        Py_INCREF(errInfo);
                        goto Sbk_QDateTimeFunc_toString_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_DATEFORMAT_IDX])->converter, (pyArgs[0]))))
                            goto Sbk_QDateTimeFunc_toString_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_format);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QDateTimeFunc_toString_TypeError;
                }
            }
            ::Qt::DateFormat cppArg0 = Qt::TextDate;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // toString(Qt::DateFormat)const
                QString cppResult = const_cast<const ::QDateTime *>(cppSelf)->toString(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 1: // toString(const QString & format) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QDateTimeFunc_toString_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // toString(QString)const
                QString cppResult = const_cast<const ::QDateTime *>(cppSelf)->toString(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 2: // toString(const QString & format, QCalendar cal) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QDateTimeFunc_toString_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QCalendar cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // toString(QString,QCalendar)const
                QString cppResult = const_cast<const ::QDateTime *>(cppSelf)->toString(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDateTimeFunc_toString_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateTimeFunc_toTimeSpec(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.toTimeSpec";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDateTime::toTimeSpec(Qt::TimeSpec)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TIMESPEC_IDX])->converter, (pyArg)))) {
        overloadId = 0; // toTimeSpec(Qt::TimeSpec)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateTimeFunc_toTimeSpec_TypeError;

    // Call function/method
    {
        ::Qt::TimeSpec cppArg0{Qt::LocalTime};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // toTimeSpec(Qt::TimeSpec)const
            QDateTime cppResult = const_cast<const ::QDateTime *>(cppSelf)->toTimeSpec(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDateTimeFunc_toTimeSpec_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateTimeFunc_toTimeZone(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.toTimeZone";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDateTime::toTimeZone(QTimeZone)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX]), (pyArg)))) {
        overloadId = 0; // toTimeZone(QTimeZone)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDateTimeFunc_toTimeZone_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTimeZone cppArg0_local;
        ::QTimeZone *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEZONE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // toTimeZone(QTimeZone)const
            QDateTime cppResult = const_cast<const ::QDateTime *>(cppSelf)->toTimeZone(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDateTimeFunc_toTimeZone_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDateTimeFunc_toTime_t(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.toTime_t";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toTime_t()const
            uint cppResult = const_cast<const ::QDateTime *>(cppSelf)->toTime_t();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDateTimeFunc_toUTC(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.toUTC";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toUTC()const
            QDateTime cppResult = const_cast<const ::QDateTime *>(cppSelf)->toUTC();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDateTimeFunc_utcOffset(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QDateTime.utcOffset";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // utcOffset()const
            int cppResult = const_cast<const ::QDateTime *>(cppSelf)->utcOffset();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDateTime___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QDateTime_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QDateTime_methods[] = {
    {"__reduce__", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc___reduce__), METH_NOARGS},
    {"addDays", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_addDays), METH_O},
    {"addMSecs", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_addMSecs), METH_O},
    {"addMonths", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_addMonths), METH_O},
    {"addSecs", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_addSecs), METH_O},
    {"addYears", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_addYears), METH_O},
    {"currentDateTime", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_currentDateTime), METH_NOARGS|METH_STATIC},
    {"currentDateTimeUtc", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_currentDateTimeUtc), METH_NOARGS|METH_STATIC},
    {"currentMSecsSinceEpoch", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_currentMSecsSinceEpoch), METH_NOARGS|METH_STATIC},
    {"currentSecsSinceEpoch", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_currentSecsSinceEpoch), METH_NOARGS|METH_STATIC},
    {"date", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_date), METH_NOARGS},
    {"daysTo", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_daysTo), METH_O},
    {"fromMSecsSinceEpoch", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_fromMSecsSinceEpoch), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"fromSecsSinceEpoch", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_fromSecsSinceEpoch), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"fromString", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_fromString), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"fromTime_t", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_fromTime_t), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"isDaylightTime", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_isDaylightTime), METH_NOARGS},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_isNull), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_isValid), METH_NOARGS},
    {"msecsTo", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_msecsTo), METH_O},
    {"offsetFromUtc", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_offsetFromUtc), METH_NOARGS},
    {"secsTo", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_secsTo), METH_O},
    {"setDate", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_setDate), METH_O},
    {"setMSecsSinceEpoch", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_setMSecsSinceEpoch), METH_O},
    {"setOffsetFromUtc", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_setOffsetFromUtc), METH_O},
    {"setSecsSinceEpoch", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_setSecsSinceEpoch), METH_O},
    {"setTime", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_setTime), METH_O},
    {"setTimeSpec", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_setTimeSpec), METH_O},
    {"setTimeZone", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_setTimeZone), METH_O},
    {"setTime_t", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_setTime_t), METH_O},
    {"setUtcOffset", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_setUtcOffset), METH_O},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_swap), METH_O},
    {"time", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_time), METH_NOARGS},
    {"timeSpec", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_timeSpec), METH_NOARGS},
    {"timeZone", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_timeZone), METH_NOARGS},
    {"timeZoneAbbreviation", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_timeZoneAbbreviation), METH_NOARGS},
    {"toLocalTime", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_toLocalTime), METH_NOARGS},
    {"toMSecsSinceEpoch", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_toMSecsSinceEpoch), METH_NOARGS},
    {"toOffsetFromUtc", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_toOffsetFromUtc), METH_O},
    {"toPython", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_toPython), METH_NOARGS},
    {"toSecsSinceEpoch", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_toSecsSinceEpoch), METH_NOARGS},
    {"toString", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_toString), METH_VARARGS|METH_KEYWORDS},
    {"toTimeSpec", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_toTimeSpec), METH_O},
    {"toTimeZone", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_toTimeZone), METH_O},
    {"toTime_t", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_toTime_t), METH_NOARGS},
    {"toUTC", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_toUTC), METH_NOARGS},
    {"utcOffset", reinterpret_cast<PyCFunction>(Sbk_QDateTimeFunc_utcOffset), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QDateTime___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QDateTime___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

// Rich comparison
static PyObject * Sbk_QDateTime_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), (pyArg)))) {
                // operator!=(const QDateTime & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QDateTime cppArg0_local;
                ::QDateTime *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_LT:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), (pyArg)))) {
                // operator<(const QDateTime & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QDateTime cppArg0_local;
                ::QDateTime *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf <(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                goto Sbk_QDateTime_RichComparison_TypeError;
            }

            break;
        case Py_LE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), (pyArg)))) {
                // operator<=(const QDateTime & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QDateTime cppArg0_local;
                ::QDateTime *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf <=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                goto Sbk_QDateTime_RichComparison_TypeError;
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), (pyArg)))) {
                // operator==(const QDateTime & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QDateTime cppArg0_local;
                ::QDateTime *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        case Py_GT:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), (pyArg)))) {
                // operator>(const QDateTime & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QDateTime cppArg0_local;
                ::QDateTime *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf >(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                goto Sbk_QDateTime_RichComparison_TypeError;
            }

            break;
        case Py_GE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), (pyArg)))) {
                // operator>=(const QDateTime & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QDateTime cppArg0_local;
                ::QDateTime *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf >=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                goto Sbk_QDateTime_RichComparison_TypeError;
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QDateTime_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QDateTime_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static Py_hash_t Sbk_QDateTime_HashFunc(PyObject *self) {
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Py_hash_t(PySide::hash(*cppSelf));
}

static int Sbk_QDateTime_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QDateTime_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QDateTime_Type = nullptr;
static SbkObjectType *Sbk_QDateTime_TypeF(void)
{
    return _Sbk_QDateTime_Type;
}

static PyType_Slot Sbk_QDateTime_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QDateTimeFunc___repr__)},
    {Py_tp_hash,        reinterpret_cast<void *>(&Sbk_QDateTime_HashFunc)},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QDateTime_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QDateTime_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QDateTime_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QDateTime_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QDateTime_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QDateTime___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QDateTime___nb_bool},
#endif
    {0, nullptr}
};
static PyType_Spec Sbk_QDateTime_spec = {
    "2:PySide2.QtCore.QDateTime",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QDateTime_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QDateTime_YearRange_PythonToCpp_QDateTime_YearRange(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QDateTime::YearRange *>(cppOut) =
        static_cast<::QDateTime::YearRange>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QDateTime_YearRange_PythonToCpp_QDateTime_YearRange_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QDATETIME_YEARRANGE_IDX]))
        return QDateTime_YearRange_PythonToCpp_QDateTime_YearRange;
    return {};
}
static PyObject *QDateTime_YearRange_CppToPython_QDateTime_YearRange(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QDateTime::YearRange *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QDATETIME_YEARRANGE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QDateTime_PythonToCpp_QDateTime_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QDateTime_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QDateTime_PythonToCpp_QDateTime_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QDateTime_TypeF())))
        return QDateTime_PythonToCpp_QDateTime_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QDateTime_PTR_CppToPython_QDateTime(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QDateTime *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QDateTime_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QDateTime_COPY_CppToPython_QDateTime(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QDateTime_TypeF(), new ::QDateTime(*reinterpret_cast<const ::QDateTime *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QDateTime_PythonToCpp_QDateTime_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QDateTime *>(cppOut) = *reinterpret_cast< ::QDateTime *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QDateTime_PythonToCpp_QDateTime_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QDateTime_TypeF())))
        return QDateTime_PythonToCpp_QDateTime_COPY;
    return {};
}

// Python to C++ conversions for type 'QDateTime'.
static void Py_None_PythonToCpp_QDateTime(PyObject *pyIn, void *cppOut) {
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-pynone)]
    *reinterpret_cast<::QDateTime *>(cppOut) = QDateTime();
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-pynone)]
    // ========================================================================

}
static PythonToCppFunc is_Py_None_PythonToCpp_QDateTime_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Py_None_PythonToCpp_QDateTime;
    return {};
}
static void PyDateTime_PythonToCpp_QDateTime(PyObject *pyIn, void *cppOut) {
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-qdatetime-pydatetime)]
    int day = PyDateTime_GET_DAY(pyIn);
    int month = PyDateTime_GET_MONTH(pyIn);
    int year = PyDateTime_GET_YEAR(pyIn);
    int hour = PyDateTime_DATE_GET_HOUR(pyIn);
    int min = PyDateTime_DATE_GET_MINUTE(pyIn);
    int sec = PyDateTime_DATE_GET_SECOND(pyIn);
    int usec = PyDateTime_DATE_GET_MICROSECOND(pyIn);
    *reinterpret_cast<::QDateTime *>(cppOut) = QDateTime(QDate(year, month, day), QTime(hour, min, sec, usec/1000));
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-qdatetime-pydatetime)]
    // ========================================================================

}
static PythonToCppFunc is_PyDateTime_PythonToCpp_QDateTime_Convertible(PyObject *pyIn) {
    if (PyDateTime_ImportAndCheck(pyIn))
        return PyDateTime_PythonToCpp_QDateTime;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QDateTime_SignatureStrings[] = {
    "7:PySide2.QtCore.QDateTime(self)",
    "6:PySide2.QtCore.QDateTime(self,arg__1:PySide2.QtCore.QDate)",
    "5:PySide2.QtCore.QDateTime(self,arg__1:PySide2.QtCore.QDate,arg__2:PySide2.QtCore.QTime,spec:PySide2.QtCore.Qt.TimeSpec=Qt.LocalTime)",
    "4:PySide2.QtCore.QDateTime(self,date:PySide2.QtCore.QDate,time:PySide2.QtCore.QTime,spec:PySide2.QtCore.Qt.TimeSpec,offsetSeconds:int)",
    "3:PySide2.QtCore.QDateTime(self,date:PySide2.QtCore.QDate,time:PySide2.QtCore.QTime,timeZone:PySide2.QtCore.QTimeZone)",
    "2:PySide2.QtCore.QDateTime(self,other:PySide2.QtCore.QDateTime)",
    "1:PySide2.QtCore.QDateTime(self,arg__1:int,arg__2:int,arg__3:int,arg__4:int,arg__5:int,arg__6:int)",
    "0:PySide2.QtCore.QDateTime(self,arg__1:int,arg__2:int,arg__3:int,arg__4:int,arg__5:int,arg__6:int,arg__7:int,arg__8:int=Qt.LocalTime)",
    "PySide2.QtCore.QDateTime.__reduce__(self)->PyObject",
    "PySide2.QtCore.QDateTime.__repr__(self)->PyObject",
    "PySide2.QtCore.QDateTime.addDays(self,days:qint64)->PySide2.QtCore.QDateTime",
    "PySide2.QtCore.QDateTime.addMSecs(self,msecs:qint64)->PySide2.QtCore.QDateTime",
    "PySide2.QtCore.QDateTime.addMonths(self,months:int)->PySide2.QtCore.QDateTime",
    "PySide2.QtCore.QDateTime.addSecs(self,secs:qint64)->PySide2.QtCore.QDateTime",
    "PySide2.QtCore.QDateTime.addYears(self,years:int)->PySide2.QtCore.QDateTime",
    "PySide2.QtCore.QDateTime.currentDateTime()->PySide2.QtCore.QDateTime",
    "PySide2.QtCore.QDateTime.currentDateTimeUtc()->PySide2.QtCore.QDateTime",
    "PySide2.QtCore.QDateTime.currentMSecsSinceEpoch()->qint64",
    "PySide2.QtCore.QDateTime.currentSecsSinceEpoch()->qint64",
    "PySide2.QtCore.QDateTime.date(self)->PySide2.QtCore.QDate",
    "PySide2.QtCore.QDateTime.daysTo(self,arg__1:PySide2.QtCore.QDateTime)->qint64",
    "2:PySide2.QtCore.QDateTime.fromMSecsSinceEpoch(msecs:qint64)->PySide2.QtCore.QDateTime",
    "1:PySide2.QtCore.QDateTime.fromMSecsSinceEpoch(msecs:qint64,spec:PySide2.QtCore.Qt.TimeSpec,offsetFromUtc:int=0)->PySide2.QtCore.QDateTime",
    "0:PySide2.QtCore.QDateTime.fromMSecsSinceEpoch(msecs:qint64,timeZone:PySide2.QtCore.QTimeZone)->PySide2.QtCore.QDateTime",
    "1:PySide2.QtCore.QDateTime.fromSecsSinceEpoch(secs:qint64,spe:PySide2.QtCore.Qt.TimeSpec=Qt.LocalTime,offsetFromUtc:int=0)->PySide2.QtCore.QDateTime",
    "0:PySide2.QtCore.QDateTime.fromSecsSinceEpoch(secs:qint64,timeZone:PySide2.QtCore.QTimeZone)->PySide2.QtCore.QDateTime",
    "2:PySide2.QtCore.QDateTime.fromString(s:QString,f:PySide2.QtCore.Qt.DateFormat=Qt.TextDate)->PySide2.QtCore.QDateTime",
    "1:PySide2.QtCore.QDateTime.fromString(s:QString,format:QString)->PySide2.QtCore.QDateTime",
    "0:PySide2.QtCore.QDateTime.fromString(s:QString,format:QString,cal:PySide2.QtCore.QCalendar)->PySide2.QtCore.QDateTime",
    "2:PySide2.QtCore.QDateTime.fromTime_t(secsSince1Jan1970UTC:uint)->PySide2.QtCore.QDateTime",
    "1:PySide2.QtCore.QDateTime.fromTime_t(secsSince1Jan1970UTC:uint,spec:PySide2.QtCore.Qt.TimeSpec,offsetFromUtc:int=0)->PySide2.QtCore.QDateTime",
    "0:PySide2.QtCore.QDateTime.fromTime_t(secsSince1Jan1970UTC:uint,timeZone:PySide2.QtCore.QTimeZone)->PySide2.QtCore.QDateTime",
    "PySide2.QtCore.QDateTime.isDaylightTime(self)->bool",
    "PySide2.QtCore.QDateTime.isNull(self)->bool",
    "PySide2.QtCore.QDateTime.isValid(self)->bool",
    "PySide2.QtCore.QDateTime.msecsTo(self,arg__1:PySide2.QtCore.QDateTime)->qint64",
    "PySide2.QtCore.QDateTime.offsetFromUtc(self)->int",
    "PySide2.QtCore.QDateTime.secsTo(self,arg__1:PySide2.QtCore.QDateTime)->qint64",
    "PySide2.QtCore.QDateTime.setDate(self,date:PySide2.QtCore.QDate)",
    "PySide2.QtCore.QDateTime.setMSecsSinceEpoch(self,msecs:qint64)",
    "PySide2.QtCore.QDateTime.setOffsetFromUtc(self,offsetSeconds:int)",
    "PySide2.QtCore.QDateTime.setSecsSinceEpoch(self,secs:qint64)",
    "PySide2.QtCore.QDateTime.setTime(self,time:PySide2.QtCore.QTime)",
    "PySide2.QtCore.QDateTime.setTimeSpec(self,spec:PySide2.QtCore.Qt.TimeSpec)",
    "PySide2.QtCore.QDateTime.setTimeZone(self,toZone:PySide2.QtCore.QTimeZone)",
    "PySide2.QtCore.QDateTime.setTime_t(self,secsSince1Jan1970UTC:uint)",
    "PySide2.QtCore.QDateTime.setUtcOffset(self,seconds:int)",
    "PySide2.QtCore.QDateTime.swap(self,other:PySide2.QtCore.QDateTime)",
    "PySide2.QtCore.QDateTime.time(self)->PySide2.QtCore.QTime",
    "PySide2.QtCore.QDateTime.timeSpec(self)->PySide2.QtCore.Qt.TimeSpec",
    "PySide2.QtCore.QDateTime.timeZone(self)->PySide2.QtCore.QTimeZone",
    "PySide2.QtCore.QDateTime.timeZoneAbbreviation(self)->QString",
    "PySide2.QtCore.QDateTime.toLocalTime(self)->PySide2.QtCore.QDateTime",
    "PySide2.QtCore.QDateTime.toMSecsSinceEpoch(self)->qint64",
    "PySide2.QtCore.QDateTime.toOffsetFromUtc(self,offsetSeconds:int)->PySide2.QtCore.QDateTime",
    "PySide2.QtCore.QDateTime.toPython(self)->PyObject",
    "PySide2.QtCore.QDateTime.toSecsSinceEpoch(self)->qint64",
    "2:PySide2.QtCore.QDateTime.toString(self,format:PySide2.QtCore.Qt.DateFormat=Qt.TextDate)->QString",
    "1:PySide2.QtCore.QDateTime.toString(self,format:QString)->QString",
    "0:PySide2.QtCore.QDateTime.toString(self,format:QString,cal:PySide2.QtCore.QCalendar)->QString",
    "PySide2.QtCore.QDateTime.toTimeSpec(self,spec:PySide2.QtCore.Qt.TimeSpec)->PySide2.QtCore.QDateTime",
    "PySide2.QtCore.QDateTime.toTimeZone(self,toZone:PySide2.QtCore.QTimeZone)->PySide2.QtCore.QDateTime",
    "PySide2.QtCore.QDateTime.toTime_t(self)->uint",
    "PySide2.QtCore.QDateTime.toUTC(self)->PySide2.QtCore.QDateTime",
    "PySide2.QtCore.QDateTime.utcOffset(self)->int",
    "PySide2.QtCore.QDateTime.__copy__()",
    nullptr}; // Sentinel

void init_QDateTime(PyObject *module)
{
    _Sbk_QDateTime_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QDateTime",
        "QDateTime",
        &Sbk_QDateTime_spec,
        &Shiboken::callCppDestructor< ::QDateTime >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QDateTime_Type);
    InitSignatureStrings(pyType, QDateTime_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QDateTime_Type), Sbk_QDateTime_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QDateTime_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QDateTime_TypeF(),
        QDateTime_PythonToCpp_QDateTime_PTR,
        is_QDateTime_PythonToCpp_QDateTime_PTR_Convertible,
        QDateTime_PTR_CppToPython_QDateTime,
        QDateTime_COPY_CppToPython_QDateTime);

    Shiboken::Conversions::registerConverterName(converter, "QDateTime");
    Shiboken::Conversions::registerConverterName(converter, "QDateTime*");
    Shiboken::Conversions::registerConverterName(converter, "QDateTime&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QDateTime).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QDateTime_PythonToCpp_QDateTime_COPY,
        is_QDateTime_PythonToCpp_QDateTime_COPY_Convertible);
    // Add user defined implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        Py_None_PythonToCpp_QDateTime,
        is_Py_None_PythonToCpp_QDateTime_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PyDateTime_PythonToCpp_QDateTime,
        is_PyDateTime_PythonToCpp_QDateTime_Convertible);


    // Initialization of enums.

    // Initialization of enum 'YearRange'.
    SbkPySide2_QtCoreTypes[SBK_QDATETIME_YEARRANGE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QDateTime_TypeF(),
        "YearRange",
        "2:PySide2.QtCore.QDateTime.YearRange",
        "QDateTime::YearRange");
    if (!SbkPySide2_QtCoreTypes[SBK_QDATETIME_YEARRANGE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATETIME_YEARRANGE_IDX],
        SbkPySide2_QtCoreTypes[SBK_QDATETIME_YEARRANGE_IDX], "First", (long) QDateTime::YearRange::First))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QDATETIME_YEARRANGE_IDX],
        SbkPySide2_QtCoreTypes[SBK_QDATETIME_YEARRANGE_IDX], "Last", (long) QDateTime::YearRange::Last))
        return;
    // Register converter for enum 'QDateTime::YearRange'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QDATETIME_YEARRANGE_IDX],
            QDateTime_YearRange_CppToPython_QDateTime_YearRange);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QDateTime_YearRange_PythonToCpp_QDateTime_YearRange,
            is_QDateTime_YearRange_PythonToCpp_QDateTime_YearRange_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QDATETIME_YEARRANGE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QDateTime::YearRange");
        Shiboken::Conversions::registerConverterName(converter, "YearRange");
    }
    // End of 'YearRange' enum.


    qRegisterMetaType< ::QDateTime >("QDateTime");
    qRegisterMetaType< ::QDateTime::YearRange >("QDateTime::YearRange");
}

