/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtcore_python.h"

// main header
#include "qelapsedtimer_wrapper.h"

// inner classes

// Extra includes
#include <qelapsedtimer.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QElapsedTimer_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QElapsedTimer >()))
        return -1;

    ::QElapsedTimer *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QElapsedTimer.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QElapsedTimer", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QElapsedTimer::QElapsedTimer()
    // 1: QElapsedTimer::QElapsedTimer(QElapsedTimer)
    if (numArgs == 0) {
        overloadId = 0; // QElapsedTimer()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QELAPSEDTIMER_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QElapsedTimer(QElapsedTimer)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QElapsedTimer_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QElapsedTimer()
        {

            if (!PyErr_Occurred()) {
                // QElapsedTimer()
                cptr = new ::QElapsedTimer();
            }
            break;
        }
        case 1: // QElapsedTimer(const QElapsedTimer & QElapsedTimer)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QElapsedTimer cppArg0_local;
            ::QElapsedTimer *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QELAPSEDTIMER_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QElapsedTimer(QElapsedTimer)
                cptr = new ::QElapsedTimer(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QElapsedTimer >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QElapsedTimer_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QElapsedTimer_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QElapsedTimerFunc_clockType(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QElapsedTimer.clockType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clockType()
            QElapsedTimer::ClockType cppResult = ::QElapsedTimer::clockType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QELAPSEDTIMER_CLOCKTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QElapsedTimerFunc_elapsed(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QElapsedTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QELAPSEDTIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QElapsedTimer.elapsed";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // elapsed()const
            qint64 cppResult = const_cast<const ::QElapsedTimer *>(cppSelf)->elapsed();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QElapsedTimerFunc_hasExpired(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QElapsedTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QELAPSEDTIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QElapsedTimer.hasExpired";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QElapsedTimer::hasExpired(qint64)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // hasExpired(qint64)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QElapsedTimerFunc_hasExpired_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // hasExpired(qint64)const
            bool cppResult = const_cast<const ::QElapsedTimer *>(cppSelf)->hasExpired(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QElapsedTimerFunc_hasExpired_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QElapsedTimerFunc_invalidate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QElapsedTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QELAPSEDTIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QElapsedTimer.invalidate";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // invalidate()
            cppSelf->invalidate();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QElapsedTimerFunc_isMonotonic(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QElapsedTimer.isMonotonic";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isMonotonic()
            bool cppResult = ::QElapsedTimer::isMonotonic();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QElapsedTimerFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QElapsedTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QELAPSEDTIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QElapsedTimer.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QElapsedTimer *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QElapsedTimerFunc_msecsSinceReference(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QElapsedTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QELAPSEDTIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QElapsedTimer.msecsSinceReference";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // msecsSinceReference()const
            qint64 cppResult = const_cast<const ::QElapsedTimer *>(cppSelf)->msecsSinceReference();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QElapsedTimerFunc_msecsTo(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QElapsedTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QELAPSEDTIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QElapsedTimer.msecsTo";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QElapsedTimer::msecsTo(QElapsedTimer)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QELAPSEDTIMER_IDX]), (pyArg)))) {
        overloadId = 0; // msecsTo(QElapsedTimer)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QElapsedTimerFunc_msecsTo_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QElapsedTimer cppArg0_local;
        ::QElapsedTimer *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QELAPSEDTIMER_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // msecsTo(QElapsedTimer)const
            qint64 cppResult = const_cast<const ::QElapsedTimer *>(cppSelf)->msecsTo(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QElapsedTimerFunc_msecsTo_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QElapsedTimerFunc_nsecsElapsed(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QElapsedTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QELAPSEDTIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QElapsedTimer.nsecsElapsed";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // nsecsElapsed()const
            qint64 cppResult = const_cast<const ::QElapsedTimer *>(cppSelf)->nsecsElapsed();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QElapsedTimerFunc_restart(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QElapsedTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QELAPSEDTIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QElapsedTimer.restart";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // restart()
            qint64 cppResult = cppSelf->restart();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QElapsedTimerFunc_secsTo(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QElapsedTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QELAPSEDTIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QElapsedTimer.secsTo";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QElapsedTimer::secsTo(QElapsedTimer)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QELAPSEDTIMER_IDX]), (pyArg)))) {
        overloadId = 0; // secsTo(QElapsedTimer)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QElapsedTimerFunc_secsTo_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QElapsedTimer cppArg0_local;
        ::QElapsedTimer *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QELAPSEDTIMER_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // secsTo(QElapsedTimer)const
            qint64 cppResult = const_cast<const ::QElapsedTimer *>(cppSelf)->secsTo(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QElapsedTimerFunc_secsTo_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QElapsedTimerFunc_start(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QElapsedTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QELAPSEDTIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtCore.QElapsedTimer.start";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // start()
            cppSelf->start();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QElapsedTimer___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QElapsedTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QELAPSEDTIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QELAPSEDTIMER_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QElapsedTimer_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QElapsedTimer_methods[] = {
    {"clockType", reinterpret_cast<PyCFunction>(Sbk_QElapsedTimerFunc_clockType), METH_NOARGS|METH_STATIC},
    {"elapsed", reinterpret_cast<PyCFunction>(Sbk_QElapsedTimerFunc_elapsed), METH_NOARGS},
    {"hasExpired", reinterpret_cast<PyCFunction>(Sbk_QElapsedTimerFunc_hasExpired), METH_O},
    {"invalidate", reinterpret_cast<PyCFunction>(Sbk_QElapsedTimerFunc_invalidate), METH_NOARGS},
    {"isMonotonic", reinterpret_cast<PyCFunction>(Sbk_QElapsedTimerFunc_isMonotonic), METH_NOARGS|METH_STATIC},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QElapsedTimerFunc_isValid), METH_NOARGS},
    {"msecsSinceReference", reinterpret_cast<PyCFunction>(Sbk_QElapsedTimerFunc_msecsSinceReference), METH_NOARGS},
    {"msecsTo", reinterpret_cast<PyCFunction>(Sbk_QElapsedTimerFunc_msecsTo), METH_O},
    {"nsecsElapsed", reinterpret_cast<PyCFunction>(Sbk_QElapsedTimerFunc_nsecsElapsed), METH_NOARGS},
    {"restart", reinterpret_cast<PyCFunction>(Sbk_QElapsedTimerFunc_restart), METH_NOARGS},
    {"secsTo", reinterpret_cast<PyCFunction>(Sbk_QElapsedTimerFunc_secsTo), METH_O},
    {"start", reinterpret_cast<PyCFunction>(Sbk_QElapsedTimerFunc_start), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QElapsedTimer___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QElapsedTimer_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QElapsedTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QELAPSEDTIMER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QELAPSEDTIMER_IDX]), (pyArg)))) {
                // operator!=(const QElapsedTimer & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QElapsedTimer cppArg0_local;
                ::QElapsedTimer *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QELAPSEDTIMER_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QELAPSEDTIMER_IDX]), (pyArg)))) {
                // operator==(const QElapsedTimer & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QElapsedTimer cppArg0_local;
                ::QElapsedTimer *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QELAPSEDTIMER_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QElapsedTimer_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QElapsedTimer_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QElapsedTimer_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QElapsedTimer_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QElapsedTimer_Type = nullptr;
static SbkObjectType *Sbk_QElapsedTimer_TypeF(void)
{
    return _Sbk_QElapsedTimer_Type;
}

static PyType_Slot Sbk_QElapsedTimer_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QElapsedTimer_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QElapsedTimer_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QElapsedTimer_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QElapsedTimer_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QElapsedTimer_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QElapsedTimer_spec = {
    "2:PySide2.QtCore.QElapsedTimer",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QElapsedTimer_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QElapsedTimer_ClockType_PythonToCpp_QElapsedTimer_ClockType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QElapsedTimer::ClockType *>(cppOut) =
        static_cast<::QElapsedTimer::ClockType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QElapsedTimer_ClockType_PythonToCpp_QElapsedTimer_ClockType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtCoreTypes[SBK_QELAPSEDTIMER_CLOCKTYPE_IDX]))
        return QElapsedTimer_ClockType_PythonToCpp_QElapsedTimer_ClockType;
    return {};
}
static PyObject *QElapsedTimer_ClockType_CppToPython_QElapsedTimer_ClockType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QElapsedTimer::ClockType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtCoreTypes[SBK_QELAPSEDTIMER_CLOCKTYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QElapsedTimer_PythonToCpp_QElapsedTimer_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QElapsedTimer_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QElapsedTimer_PythonToCpp_QElapsedTimer_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QElapsedTimer_TypeF())))
        return QElapsedTimer_PythonToCpp_QElapsedTimer_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QElapsedTimer_PTR_CppToPython_QElapsedTimer(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QElapsedTimer *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QElapsedTimer_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QElapsedTimer_COPY_CppToPython_QElapsedTimer(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QElapsedTimer_TypeF(), new ::QElapsedTimer(*reinterpret_cast<const ::QElapsedTimer *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QElapsedTimer_PythonToCpp_QElapsedTimer_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QElapsedTimer *>(cppOut) = *reinterpret_cast< ::QElapsedTimer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QELAPSEDTIMER_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QElapsedTimer_PythonToCpp_QElapsedTimer_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QElapsedTimer_TypeF())))
        return QElapsedTimer_PythonToCpp_QElapsedTimer_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QElapsedTimer_SignatureStrings[] = {
    "1:PySide2.QtCore.QElapsedTimer(self)",
    "0:PySide2.QtCore.QElapsedTimer(self,QElapsedTimer:PySide2.QtCore.QElapsedTimer)",
    "PySide2.QtCore.QElapsedTimer.clockType()->PySide2.QtCore.QElapsedTimer.ClockType",
    "PySide2.QtCore.QElapsedTimer.elapsed(self)->qint64",
    "PySide2.QtCore.QElapsedTimer.hasExpired(self,timeout:qint64)->bool",
    "PySide2.QtCore.QElapsedTimer.invalidate(self)",
    "PySide2.QtCore.QElapsedTimer.isMonotonic()->bool",
    "PySide2.QtCore.QElapsedTimer.isValid(self)->bool",
    "PySide2.QtCore.QElapsedTimer.msecsSinceReference(self)->qint64",
    "PySide2.QtCore.QElapsedTimer.msecsTo(self,other:PySide2.QtCore.QElapsedTimer)->qint64",
    "PySide2.QtCore.QElapsedTimer.nsecsElapsed(self)->qint64",
    "PySide2.QtCore.QElapsedTimer.restart(self)->qint64",
    "PySide2.QtCore.QElapsedTimer.secsTo(self,other:PySide2.QtCore.QElapsedTimer)->qint64",
    "PySide2.QtCore.QElapsedTimer.start(self)",
    "PySide2.QtCore.QElapsedTimer.__copy__()",
    nullptr}; // Sentinel

void init_QElapsedTimer(PyObject *module)
{
    _Sbk_QElapsedTimer_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QElapsedTimer",
        "QElapsedTimer",
        &Sbk_QElapsedTimer_spec,
        &Shiboken::callCppDestructor< ::QElapsedTimer >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QElapsedTimer_Type);
    InitSignatureStrings(pyType, QElapsedTimer_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QElapsedTimer_Type), Sbk_QElapsedTimer_PropertyStrings);
    SbkPySide2_QtCoreTypes[SBK_QELAPSEDTIMER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QElapsedTimer_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QElapsedTimer_TypeF(),
        QElapsedTimer_PythonToCpp_QElapsedTimer_PTR,
        is_QElapsedTimer_PythonToCpp_QElapsedTimer_PTR_Convertible,
        QElapsedTimer_PTR_CppToPython_QElapsedTimer,
        QElapsedTimer_COPY_CppToPython_QElapsedTimer);

    Shiboken::Conversions::registerConverterName(converter, "QElapsedTimer");
    Shiboken::Conversions::registerConverterName(converter, "QElapsedTimer*");
    Shiboken::Conversions::registerConverterName(converter, "QElapsedTimer&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QElapsedTimer).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QElapsedTimer_PythonToCpp_QElapsedTimer_COPY,
        is_QElapsedTimer_PythonToCpp_QElapsedTimer_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'ClockType'.
    SbkPySide2_QtCoreTypes[SBK_QELAPSEDTIMER_CLOCKTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QElapsedTimer_TypeF(),
        "ClockType",
        "2:PySide2.QtCore.QElapsedTimer.ClockType",
        "QElapsedTimer::ClockType");
    if (!SbkPySide2_QtCoreTypes[SBK_QELAPSEDTIMER_CLOCKTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QELAPSEDTIMER_CLOCKTYPE_IDX],
        Sbk_QElapsedTimer_TypeF(), "SystemTime", (long) QElapsedTimer::ClockType::SystemTime))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QELAPSEDTIMER_CLOCKTYPE_IDX],
        Sbk_QElapsedTimer_TypeF(), "MonotonicClock", (long) QElapsedTimer::ClockType::MonotonicClock))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QELAPSEDTIMER_CLOCKTYPE_IDX],
        Sbk_QElapsedTimer_TypeF(), "TickCounter", (long) QElapsedTimer::ClockType::TickCounter))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QELAPSEDTIMER_CLOCKTYPE_IDX],
        Sbk_QElapsedTimer_TypeF(), "MachAbsoluteTime", (long) QElapsedTimer::ClockType::MachAbsoluteTime))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtCoreTypes[SBK_QELAPSEDTIMER_CLOCKTYPE_IDX],
        Sbk_QElapsedTimer_TypeF(), "PerformanceCounter", (long) QElapsedTimer::ClockType::PerformanceCounter))
        return;
    // Register converter for enum 'QElapsedTimer::ClockType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtCoreTypes[SBK_QELAPSEDTIMER_CLOCKTYPE_IDX],
            QElapsedTimer_ClockType_CppToPython_QElapsedTimer_ClockType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QElapsedTimer_ClockType_PythonToCpp_QElapsedTimer_ClockType,
            is_QElapsedTimer_ClockType_PythonToCpp_QElapsedTimer_ClockType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtCoreTypes[SBK_QELAPSEDTIMER_CLOCKTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QElapsedTimer::ClockType");
        Shiboken::Conversions::registerConverterName(converter, "ClockType");
    }
    // End of 'ClockType' enum.

    qRegisterMetaType< ::QElapsedTimer >("QElapsedTimer");
    qRegisterMetaType< ::QElapsedTimer::ClockType >("QElapsedTimer::ClockType");
}
